/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import com.google.android.gcm.server.Message;
import com.google.android.gcm.server.MulticastResult;
import com.google.android.gcm.server.Sender;
import ibase.ejb.CommonDBAccessEJB;
import ibase.ejb.CommonDBAccessRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.Payload;
import javapns.notification.PushNotificationManager;
import javapns.notification.PushNotificationPayload;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class E12PushNotificationServlet
extends HttpServlet {
    private static final String SERVER_ID = "AIzaSyAYfiHifWwAMGOck_XHC2jakJpkciMxLN4";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BaseLogger.log("2", null, null, "=================E12PushNotification=====Start1==========================");
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        String successAndErrorMsg = "Publish push notification successfully";
        try {
            BaseLogger.log("3", null, null, "=================E12PushNotification=====Start2==========================");
            UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            if (userInfo == null) {
                return;
            }
            String userMessage = request.getParameter("message");
            BaseLogger.log("3", null, null, "userMessage [" + userMessage + "]");
            this.publishAndroidNotification(userMessage);
            this.publishiOSNotification(userMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            successAndErrorMsg = "Exception :" + e.getMessage();
        }
        resp.sendRedirect("/ibase/jsp/E12PushNotification.jsp?ACTION=SUCCESS&MSG=" + successAndErrorMsg);
        BaseLogger.log("2", null, null, "=================E12PushNotification=====End==========================");
    }

    public void publishAndroidNotification(String userMessage) throws IOException, BaseException {
        String collapseKey = "GCM_Message";
        Object resultchk = null;
        ArrayList<String> registeredIdList = this.getCommonDBAccess().getRegisteredIdList("Android");
        Sender sender = new Sender(SERVER_ID);
        BaseLogger.log("2", null, null, "========111111===============");
        Message message = new Message.Builder().collapseKey(collapseKey).timeToLive(30).delayWhileIdle(true).addData("message", userMessage).build();
        BaseLogger.log("2", null, null, "========222222===============");
        MulticastResult result = null;
        result = sender.send(message, registeredIdList, 1);
        if (result.getResults() != null) {
            int n = result.getCanonicalIds();
        } else {
            int error = result.getFailure();
            BaseLogger.log("3", null, null, "Broadcast failure: " + error);
        }
        BaseLogger.log("2", null, null, "========33333333===============");
    }

    private void publishiOSNotification(String userMessage) throws ServletException, IOException {
        try {
            String userId;
            BaseLogger.log("3", null, null, "========111111===============");
            String certificatePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "device" + File.separator + "base.p12";
            String certificatePassword = "base123";
            Map<String, String> getRegisteredIdList = this.getCommonDBAccess().getRegisteredIdListForiOS("iOS");
            BaseLogger.log("3", null, null, "========222222===============");
            PushNotificationManager pushManager = new PushNotificationManager();
            for (Map.Entry<String, String> m : getRegisteredIdList.entrySet()) {
                userId = m.getKey();
                String deviceId = m.getValue();
                BaseLogger.log("3", null, null, "UserId[" + userId + "]---DeviceId[" + deviceId + "]");
                pushManager.addDevice(userId, deviceId);
            }
            BaseLogger.log("3", null, null, "========3333333===============");
            for (Map.Entry<String, String> pushNotify : getRegisteredIdList.entrySet()) {
                userId = pushNotify.getKey();
                PushNotificationPayload simplePayLoad = new PushNotificationPayload();
                simplePayLoad.addAlert(userMessage);
                simplePayLoad.addCategory("ACTIONABLE");
                simplePayLoad.addBadge(1);
                simplePayLoad.addSound("default");
                pushManager.getDevice(userId);
                pushManager.initializeConnection((AppleNotificationServer)new AppleNotificationServerBasicImpl((Object)certificatePath, certificatePassword, false));
                pushManager.sendNotification(pushManager.getDevice(userId), (Payload)simplePayLoad);
                BaseLogger.log("3", null, null, "Notification sent successfully......." + simplePayLoad.toString());
            }
            BaseLogger.log("3", null, null, "========444444===============");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CommonDBAccessRemote getCommonDBAccess() throws BaseException {
        CommonDBAccessEJB ejbObj = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            BaseLogger.log("3", null, null, "Looking Up for CommonDBAccess EJB with Properties==>\n" + p);
            ejbObj = new CommonDBAccessEJB();
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "Exception: getCommonDBAccess:==>\n" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: getCommonDBAccess:==>\n" + e);
            throw new BaseException(e);
        }
        return ejbObj;
    }
}

