package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Set;
import java.util.ArrayList;
import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;

public class StrgMeetDCRWizConfEmail extends ActionHandlerEJB
{
    private E12GenericUtility e12GenericUtility = new E12GenericUtility();
	
    public String confirm(String xmlData, String tranID, String editFlg, String xtraParam, Connection conn) throws RemoteException, ITMException
    {
        PreparedStatement pstmt = null;
        ResultSet rs = null ;
        UserInfoBean userInfo = null;
		boolean isLocalConn = false;

		System.out.println("StrgMeetDCRWizConfEmail.confirm()");
		System.out.println("StrgMeetDCRWizConfEmail.confirm() xmlData ["+xmlData+"]");
		System.out.println("StrgMeetDCRWizConfEmail.confirm() tranID ["+tranID+"]");
		System.out.println("StrgMeetDCRWizConfEmail.confirm() editFlag ["+editFlg+"]");
        System.out.println("StrgMeetDCRWizConfEmail.confirm() xtraParam ["+xtraParam+"]");
        try
        {
            String userId = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginCode");
			if ( getUserInfo() == null )
			{
				CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
				setUserInfo( commonDBAccessEJB.createUserInfo( userId ) );
			}
			if ( conn == null )
			{
				String transDB = getUserInfo().getTransDB();
				
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
				connDriver = null;
				
				isLocalConn = true;
				System.out.println("Connection created...");
            }
            userInfo = getUserInfo();
            System.out.println("(userInfo:::"+userInfo);
			String loginEmpCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"loginEmpCode");
            String objName = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam,"objName");
            System.out.println("(objName:::"+objName);
            System.out.println("(userId:::"+userId);
            System.out.println("(loginEmpCode:::"+loginEmpCode);

            SimpleDateFormat sdf = new SimpleDateFormat(e12GenericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
            currDate = e12GenericUtility.getValidDateTimeString( currDate, e12GenericUtility.getApplDateFormat(),e12GenericUtility.getDBDateFormat() );
            System.out.println("(currDate:::"+currDate);
            StrgMeetDCRWizard strgMeetDCRWizard = new StrgMeetDCRWizard();
            String isEmailRequired = strgMeetDCRWizard.getSfaParmValue(userId, "SENDER_ID_EMAIL", conn);
            System.out.println("(isEmailRequired:::"+isEmailRequired);
            if( "Y".equalsIgnoreCase(isEmailRequired) )
            {
                String enterprise = "";
                String EntSql = "SELECT ENTERPRISE FROM USERS WHERE CODE=?";
                pstmt = conn.prepareStatement(EntSql);
                pstmt.setString(1, userId);
                rs = pstmt.executeQuery();
                while(rs.next())
                {
                    enterprise = E12GenericUtility.checkNull(rs.getString("ENTERPRISE"));
                    System.out.println("(enterprise:::"+enterprise);
                }
                if(pstmt != null)
                {
                    pstmt.close();
                    pstmt = null;
                }
                if(rs != null)
                {
                    rs.close();
                    rs = null;
                }

                String emailFrom = "";
                String sql = "SELECT EMAIL_ID FROM ENTERPRISE WHERE ENTERPRISE=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, enterprise);
                rs = pstmt.executeQuery();
                while(rs.next())
                {
                    emailFrom = E12GenericUtility.checkNull(rs.getString("EMAIL_ID"));
                    System.out.println("(emailFrom:::"+emailFrom);
                }
                if(pstmt != null)
                {
                    pstmt.close();
                    pstmt = null;
                }
                if(rs != null)
                {
                    rs.close();
                    rs = null;
                }

                String spName = "";
                String contactno = "";
                String compName = "";
                String url = "";
                String mobileNoSp = "";
                String spEmail = "";
                String empReportTomail = "";
                String emailTextFormated = "";
                String mailSignsql ="select  e.emp_Fname||' '|| e.emp_lname as empName , s.tele1 as  contactno  ,f.descr  as compname, f.web_site as url  ,e.mobile_no as "+           "  mobileNo ,e.email_id_off as spemail , em.email_id_off as empReportTomail "+
                        " from employee e , employee em, site s ,  finent f "+
                        " where  e.emp_site =s.site_code and "+
                        " s.fin_entity = f.fin_entity  and "+  
                        " e.report_to 	= em.emp_code  and  "+ 
                        " e.emp_code= ?" ;
                pstmt = conn.prepareStatement(mailSignsql);
                pstmt.setString(1, userId);
                
                rs = pstmt.executeQuery();
                if(rs.next())
                {
                    spName      = rs.getString("empName") == null ?"" :rs.getString("empName");
                    contactno   = rs.getString("contactno") == null ?"" :rs.getString("contactno");
                    compName    = rs.getString("compname") == null ?"" :rs.getString("compname");
                    url         = rs.getString("url") == null ?"" :rs.getString("url");
                    mobileNoSp  = rs.getString("mobileNo") == null ?"" :rs.getString("mobileNo");
                    spEmail     = rs.getString("spemail") == null ?"" :rs.getString("spemail");
                    empReportTomail =	rs.getString("empReportTomail") == null ?"" :rs.getString("empReportTomail");	
                    System.out.println("(spName:::"+spName);
                    System.out.println("(contactno:::"+contactno);
                    System.out.println("(compName:::"+compName);
                    System.out.println("(url:::"+url);
                    System.out.println("(mobileNoSp:::"+mobileNoSp);
                    System.out.println("(spEmail:::"+spEmail);
                    System.out.println("(empReportTomail:::"+empReportTomail);
                }
                if(pstmt != null)
                {
                    pstmt.close();
                    pstmt = null;
                }
                if(rs != null)
                {
                    rs.close();
                    rs = null;
                }

                String emailSubject = "",emailSubjectUnlist="";
                String emailBodyText = "",emailBodyTextUnlist="";
                String mailformatsql = "SELECT SUBJECT,BODY_TEXT FROM MAIL_FORMAT WHERE FORMAT_CODE = 'LISTED_DAR_MAIL'";
                
                pstmt = conn.prepareStatement(mailformatsql);
                rs = pstmt.executeQuery();
                
                if(rs.next())
                {
                    emailSubject = (rs.getString("SUBJECT") == null) ?"":rs.getString("SUBJECT").trim();
                    emailBodyText = (rs.getString("BODY_TEXT") == null) ?"":rs.getString("BODY_TEXT").trim();
                    System.out.println("(emailSubject:::"+emailSubject);
                    System.out.println("(emailBodyText:::"+emailBodyText);
                }
                if(pstmt != null)
                {
                    pstmt.close();
                    pstmt = null;
                }
                if(rs != null)
                {
                    rs.close();
                    rs = null;
                }

                String mailformatsqlUnlist = "SELECT SUBJECT,BODY_TEXT FROM MAIL_FORMAT WHERE FORMAT_CODE = 'UNLISTED_DAR_MAIL'";
                
                pstmt = conn.prepareStatement(mailformatsqlUnlist);
                rs = pstmt.executeQuery();
                
                if(rs.next())
                {
                    emailSubjectUnlist = (rs.getString("SUBJECT") == null) ?"":rs.getString("SUBJECT").trim();
                    emailBodyTextUnlist = (rs.getString("BODY_TEXT") == null) ?"":rs.getString("BODY_TEXT").trim();
                    System.out.println("(emailBodyTextUnlist:::"+emailBodyTextUnlist);
                    System.out.println("(emailBodyTextUnlist:::"+emailBodyTextUnlist);
                }
                if(pstmt != null)
                {
                    pstmt.close();
                    pstmt = null;
                }
                if(rs != null)
                {
                    rs.close();
                    rs = null;
                }

                String eventDate = "";
                HashMap<String, String> customerDetMap = new HashMap<String, String>();
                
                /*
                String custMailSql = "SELECT SM.STRG_CODE AS STRG_CODE, SM.STRG_NAME AS STRG_NAME, (CASE WHEN SC.EMAIL_ADDR IS NOT NULL THEN SC.EMAIL_ADDR "+
                                     " ELSE SM.EMAIL_ADDR END) AS EMAIL_ADDR, SM.EVENT_DATE AS EVENT_DATE FROM STRG_MEET SM, STRG_CUSTOMER SC WHERE "+ 
                                     " SM.STRG_CODE=SC.SC_CODE AND DCR_ID=?";
                */
                
                //change by prachi [W22FFOR008]
                String custMailSql = "SELECT SM.STRG_CODE AS STRG_CODE, SM.STRG_NAME AS STRG_NAME, (CASE WHEN SC.EMAIL_ADDR IS NOT NULL THEN SC.EMAIL_ADDR "+
                        " ELSE SM.EMAIL_ADDR END) AS EMAIL_ADDR, SM.EVENT_DATE AS EVENT_DATE FROM STRG_MEET SM, STRG_CUSTOMER SC,FIELDACTIVITY FA,SALES_PERS SP WHERE "+ 
                        " SM.STRG_CODE=SC.SC_CODE  AND FA.ACTIVITY_CODE=SM.EVENT_TYPE AND FA.EMAIL_NOTIFY='Y' AND SC.EMAIL_NOTIFY='Y' AND DCR_ID=?"+
                        " AND SM.SALES_PERS=SP.SALES_PERS AND (CASE WHEN SP.SC_NOTIFY IS NULL THEN 'Y' ELSE SP.SC_NOTIFY END) = 'Y'";
                
                pstmt = conn.prepareStatement(custMailSql);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while(rs.next())
                {
                    if(eventDate.length() <= 0)
                    {
                        eventDate = E12GenericUtility.checkNull(rs.getString("EVENT_DATE"));
                        System.out.println("(eventDate:::"+eventDate);
                    }
                    customerDetMap.put(E12GenericUtility.checkNull( rs.getString("STRG_CODE") ), E12GenericUtility.checkNull( rs.getString("EMAIL_ADDR") ));
                    System.out.println("(customerDetMap:::"+customerDetMap);
                }
                if(pstmt != null)
                {
                    pstmt.close();
                    pstmt = null;
                }
                if(rs != null)
                {
                    rs.close();
                    rs = null;
                }

                HashMap<String, String> unListCustomerDetMap = new HashMap<String, String>();
                //commented by prachi [W22FFOR008]start
                /*
                String unListCustMailSql = "SELECT STRG_CODE, EMAIL_ADDR, EVENT_DATE FROM STRG_MEET "+
                                            " WHERE DCR_ID=? AND STRG_CODE NOT IN(SELECT SC_CODE FROM STRG_CUSTOMER)";
                pstmt = conn.prepareStatement(unListCustMailSql);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                while(rs.next())
                {
                    if(eventDate.length() <= 0)
                    {
                        eventDate = E12GenericUtility.checkNull(rs.getString("EVENT_DATE"));
                        System.out.println("(eventDate:::"+eventDate);
                    }
                    unListCustomerDetMap.put(E12GenericUtility.checkNull( rs.getString("STRG_CODE") ), E12GenericUtility.checkNull( rs.getString("EMAIL_ADDR") ));
                    System.out.println("(unListCustomerDetMap:::"+unListCustomerDetMap);
                }
                if(pstmt != null)
                {
                    pstmt.close();
                    pstmt = null;
                }
                if(rs != null)
                {
                    rs.close();
                    rs = null;
                }
               *///end
               
               if(eventDate!=null && eventDate.trim().length()>0)
               {
                String eventApplDate = e12GenericUtility.getValidDateString(eventDate, e12GenericUtility.getDBDateFormat(), e12GenericUtility.getApplDateFormat());
                if(customerDetMap.size() > 0)
                {
                    Set<String> customerKeySet = customerDetMap.keySet();
                    for (String scCode : customerKeySet)
                    {
                        //String[] scDetailsArr = scDetails.split(":");
                        String emailId = customerDetMap.get(scCode);
                        System.out.println("Customer scCode::"+scCode+"::emailId::"+emailId+"]");
                        System.out.println("eventApplDate ::["+eventApplDate+"]");
                        
                        //emailTextFormated = "DATE :"+eventApplDate+"\n\n"+"Dear Sir/Madam, \n\n" +emailBodyText +"\n\nWarm Regards,\n"+spName +"\nMobile No:"+mobileNoSp+"\nBranch Contact No:"+contactno+"\n"+compName+"\n"+url;
                       
                        // System.out.println("emailTextFormated::"+emailTextFormated);
                        if(emailId != null && emailId.trim().length() > 0)
                        {
                            //sendDARMail(eventApplDate, objName, userId, emailId, emailTextFormated, emailSubject ,emailFrom, userInfo,spEmail);
                        	sendDARMail(eventApplDate, objName, userId, emailId, emailSubject ,emailFrom, userInfo,spEmail,spName,mobileNoSp,compName,url,"LISTED_DAR_MAIL");
                        }
                        emailId="";
                        emailTextFormated="";
                    }
                }
                if(unListCustomerDetMap.size() > 0)
                {
                    Set<String> customerKeySet = unListCustomerDetMap.keySet();
                    for (String scCode : customerKeySet)
                    {
                        //String[] scDetailsArr = scDetails.split(":");
                        String emailId = unListCustomerDetMap.get(scCode);
                        System.out.println("Unlisted Customer scCode::"+scCode+"::emailId::"+emailId+"]");
                        System.out.println("unlkisted eventApplDate ::["+eventApplDate+"]");
                        //changes done by prachi on 14-Oct-22
                        //emailTextFormated = "Dear Sir/Madam, \n\n" +emailBodyTextUnlist +"\n\nWarm Regards,\n"+spName +"\nMobile No:"+mobileNoSp+"\n"+compName+"\n"+url;
                        
                        //System.out.println("unlisted emailTextFormated::"+emailTextFormated);
                        if(emailId != null && emailId.trim().length() > 0)
                        {
                           // sendDARMail(eventApplDate, objName, userId, emailId, emailTextFormated, emailSubjectUnlist ,emailFrom, userInfo,spEmail);
                        	sendDARMail(eventApplDate, objName, userId, emailId, emailSubjectUnlist ,emailFrom, userInfo,spEmail,spName,mobileNoSp,compName,url,"UNLISTED_DAR_MAIL");
                        }
                        emailId="";
                        emailTextFormated="";
                    }
                }
               } 
                
            }
            else
            {
                System.out.println("Email not required on confirmation");
            }
            System.out.println("::Exiting confirm method::");

        }
        catch(Exception e)
        {
            System.out.println("Exception in [StrgMeetDCRWizConfEmail]:[confirm]:::["+e.getMessage()+"]");
        }
        finally 
		{
			try 
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && isLocalConn )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
        }
        return "";
    }

    //method signature  change by prachi [W22FFOR008] added spEmail
    private void sendDARMail( String workDateApp,String objName,String salesPers,String emailID,String emailSubject,String mailFrom, UserInfoBean userInfo,String spEmail,String spName,String mobileNo,String companyname,String url,String formatCode)
    {
        System.out.println("Sending mail to id =["+emailID+"]");
        try
        {
        EMail email = new EMail();
        
        StringBuffer xmlString = new StringBuffer("<?xml version=\"1.0\" encoding='"+CommonConstants.ENCODING+"' ?>");
        xmlString.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>");
        xmlString.append("<Header0>");
        xmlString.append("<description>Header0 members</description>");
        xmlString.append("<Detail1 dbID='"+workDateApp+":"+salesPers+"' domID=\"1\" objName=\""+objName+"\" objContext=\"1\">");
        xmlString.append("<attribute pkNames=\"work_date:sales_pers:\" status=\"N\" updateFlag=\"V\" selected=\"N\" />");
        xmlString.append("<sales_pers><![CDATA["+salesPers+"]]></sales_pers>");
        //xmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(salesPersonName).append( "]]></sales_pers_sp_name>\r\n" );
        xmlString.append("<work_date><![CDATA["+workDateApp+"]]></work_date>");
        xmlString.append("<sales_pers_name><![CDATA["+spName+"]]></sales_pers_name>");
        xmlString.append("<mobile_no><![CDATA["+mobileNo+"]]></mobile_no>");
        xmlString.append("<company_name><![CDATA["+companyname+"]]></company_name>");
        xmlString.append("<url><![CDATA["+url+"]]></url>");
        xmlString.append("</Detail1>");	
        xmlString.append("</Header0></group0></DocumentRoot>");

        String mailDomStr = "<ROOT><TRANS_INFO><OBJ_NAME>"+objName+"</OBJ_NAME>"+
                                "<REF_SER></REF_SER><REF_ID>"+workDateApp+":"+salesPers+"</REF_ID>"+
                                "<LINE_NO>1</LINE_NO></TRANS_INFO>"+
                                "<EMAIL_TYPE></EMAIL_TYPE><ENTITY_CODE></ENTITY_CODE>"+
                                "<XML_DATA>"+xmlString.toString()+"</XML_DATA>"+
                                "<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>"+
                                "<LINK_ADDR></LINK_ADDR>"+
                                "<TO_ADD>"+emailID+" </TO_ADD>" +
                                "<CC_ADD>"+spEmail+"</CC_ADD>" +//spEmail added by prachi
                                "<BCC_ADD>"+mailFrom+"</BCC_ADD>" +
                                "<BODY_TEXT></BODY_TEXT>"+
                               // "<BODY_TEXT>"+emailBodyText+"</BODY_TEXT>"+
                                "<SUBJECT>"+emailSubject+"</SUBJECT>"+
                                "<MAIL_FROM>"+mailFrom+"</MAIL_FROM>"+
                            "</ROOT>";
        System.out.println("mailDomStr....::"+mailDomStr);
        email.setMailFrom(mailFrom);
        System.out.println("getMailFrom1....::"+email.getMailFrom());
        String emailStatus = email.sendMail(mailDomStr, "ITM", userInfo);
        System.out.println("emailStatus....::"+emailStatus);
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
        
    }
}