/********************************************************
	Title : CustomerFileUploadPos
	Date  : 07/DEC/21
	Developer:Bhagyashri Tikone
 ********************************************************/
package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.webitm.ejb.*;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import org.w3c.dom.*;
import ibase.webitm.ejb.wsfa.transactions.StrgCustUploadSchedule;
import ibase.utility.UserInfoBean;

public class CustomerFileUploadPos extends ValidatorEJB
{
	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		//System.out.println("Inside post save customerfileuploadpos");
		String retString = "";
		String sql="";

		String salesPers="";
		String errCode="";
		String scCode="";
		String effDate="";
		String custTypeDom="";
		String noVisit="";
		String stateCode="";
		String gender="";
		String shortId="";
		String localityCode="";
		String classCode="";
		String speciality="";
		String specialStrg="";
		String qualification="";
		String custType="";
		String custTypeDes="";
		String qualStrg;
		String pinCode = "";
		String stanCodeDescr = "";
		String localityDescr = "";
		String stanCode = "";

		long cnt = 0;

		boolean isNumber = true;
		UserInfoBean userInfo = null;
		PreparedStatement pstmt = null ;
		PreparedStatement pstmtStrgUpd = null ;
		ResultSet rs = null;
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			//System.out.println("xmlStringAll in customerFileUploadPos::"+xmlStringAll);
			//getting userInfo in PostSave[START]
			if(userInfo == null)
			{
				userInfo = getUserInfo();
			}
			//getting userInfo in PostSave[END]
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			BaseLogger.log("3",null,null,"postSave => xmlStringAll : "+xmlStringAll);
			Document dom = genericUtility.parseString(xmlStringAll);
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = null;
			String messageType = "";
			ArrayList<String> errCodeList = new ArrayList<String>();
			ArrayList messageDescrList = new ArrayList();
			StringBuffer msgDescr = new StringBuffer();

			int childNodeListLength = 0;
			//System.out.println("Inside post save customerfileuploadpos");
			NodeList parentNodeList = dom.getElementsByTagName("Detail1");
			//System.out.println("Inside customerfileuploadpos::"+parentNodeList);
			int parentNodeListLength = parentNodeList.getLength();
			for (int p = 0; p < parentNodeListLength; p++)
			{
				parentNode = parentNodeList.item(p);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				//System.out.println("Inside customerfileuploadpos:::::"+childNodeListLength);
				for(int c = 0; c < childNodeListLength; c ++)
				{
					childNode = childNodeList.item(c);
					childNodeName = childNode.getNodeName();
					//System.out.println("currentColumn customerfileuploadpos =["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULSLSPER ";
							errCodeList.add( errCode );
						}
						else
						{
							salesPers = genericUtility.getColumnValue("sales_pers", dom);
							sql = "select count(1) from sales_pers where sales_pers = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,salesPers);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "SLPNOTEXT";
								errCodeList.add(errCode);
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("cust_type"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "VCUSTTYPE";
							errCodeList.add(errCode);
						}
						else
						{
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							//System.out.println("file custypedom filepos====>["+custTypeDom+"]");
							int seriesCount = 0;
							String countSerSql = "select COUNT(1) as COUNT from gencodes where fld_name='CUST_TYPE' and mod_name='W_WSFA_STRG_CUSTOMER' and fld_value= ?";
							PreparedStatement pstmtSeriesCnt = conn.prepareStatement(countSerSql);
							pstmtSeriesCnt.setString(1, custTypeDom);
							ResultSet rsCnt = pstmtSeriesCnt.executeQuery();
							//System.out.println("countSerSql custUploadfile"+countSerSql);
							if(rsCnt.next())
							{
								seriesCount = rsCnt.getInt("COUNT");
							}
							if(seriesCount == 0 )
							{
								errCode = "INVCUSTYPE";
								errCodeList.add(errCode);
							}
							rsCnt.close();
							rsCnt = null;
							pstmtSeriesCnt.close();
							pstmtSeriesCnt = null;
						}
					}//cust_type val
					else if(childNodeName.equalsIgnoreCase("short_id"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						//System.out.println("currentColumn custTypeMain =["+custTypeMain+"]");
						if( childNode.getFirstChild() == null  && custTypeMain.equalsIgnoreCase("D"))
						{
							//errCode = "NULLSHRID";
							//errCodeList.add( errCode );
						}

					}//short_id val
					else if(childNodeName.equalsIgnoreCase("sc_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSCODE";
							errCodeList.add( errCode );
						}
						else
						{
							scCode = checkNull(genericUtility.getColumnValue("sc_code", dom));
							shortId = checkNull(genericUtility.getColumnValue("short_id", dom));
							System.out.println("currentColumn scCode =["+scCode+"]");
							System.out.println("currentColumn shortId =["+shortId+"]");
							sql = "select count(1) from strg_customer where sc_code = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,scCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt >= 1)
							{
								errCode = "VSTRGCODE1";
								errCodeList.add( errCode );
							}
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							//System.out.println("currentColumn scCode custTypedom =["+custTypeDom+"]");
							if("D".equalsIgnoreCase(custTypeDom))
							{
								sql = "select count(1) from strg_series where sales_pers = ? and short_id=? and status='Y'";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,salesPers);
								pstmt.setString(2,shortId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if(cnt >= 1)
								{
									errCode = "VSTRGCODE2";
									errCodeList.add( errCode );
								}
							}		
						}	
					}//sc_code val
					else if(childNodeName.equalsIgnoreCase("first_name"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLFNAME";
							errCodeList.add( errCode );
						}
						/*
						//Commented by Rahul P. on [16-Feb-24] as unable to check duplicate entry because locality_code is null in dom
						else
						{
							if( editFlag.equalsIgnoreCase("A") )
							{
								BaseLogger.log("3",null,null,"Inside postSave => childNodeName : first_name => else block");
								String locCode =genericUtility.getColumnValue("locality_code",dom);
								
								String errorCode = checkNullAndTrim(checkCustomerExist(dom,conn,locCode));
								BaseLogger.log("3",null,null," else block => errCode : ["+errorCode+"]");
								
								if(errorCode.equalsIgnoreCase("DUPRECFOND")) {
									errCodeList.add( errorCode );
									errCode = errorCode;
								}
								String locCode =genericUtility.getColumnValue("locality_code",dom);
								String firstName =genericUtility.getColumnValue("first_name",dom);
								String middleName =genericUtility.getColumnValue("middle_name",dom);
								String lastName =genericUtility.getColumnValue("last_name",dom);
								String mobileNo =genericUtility.getColumnValue("mobile_no",dom);
								String regNo =genericUtility.getColumnValue("reg_no",dom);
								String sccCode =genericUtility.getColumnValue("sc_code",dom);
								String custmrType =genericUtility.getColumnValue("cust_type",dom);
								System.out.println("custmrType["+custmrType+"]locCode["+locCode+"]regNo["+regNo+"]");

								sql = "SELECT FN_CHK_DUP_STRGCUST(?,?,?,?,?,?,?,?) AS DUP_RECORD FROM DUAL";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString(1, locCode );
								pstmt.setString(2, firstName );
								pstmt.setString(3, middleName );
								pstmt.setString(4, lastName );
								pstmt.setString(5, mobileNo );
								pstmt.setString(6, regNo );
								pstmt.setString(7, sccCode );
								pstmt.setString(8, custmrType );

								rs = pstmt.executeQuery();
								if(rs.next())
								{
									if(rs.getInt("DUP_RECORD") > 0)
									{
										errCode = "DUPRECFOND";
										errCodeList.add( errCode );
									}
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

						}*/
					}//first_name
					else if(childNodeName.equalsIgnoreCase("address_as"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLADDAS";
							errCodeList.add( errCode );
						}
					}//address_as
					else if (childNodeName.equalsIgnoreCase("eff_from"))
					{
						effDate = genericUtility.getColumnValue("eff_from",dom);
						Timestamp timestamp = new Timestamp(System.currentTimeMillis());
						if ( effDate == null || effDate.trim().length() == 0 )
						{
							errCode = "NULLEFFDT";
							errCodeList.add( errCode );
						}
					}//eff_from
					else if(childNodeName.equalsIgnoreCase("qualification"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						if(custTypeMain.equalsIgnoreCase("D"))
						{
							if( childNode.getFirstChild() == null)
							{
								errCode = "NULLQUAL";
								errCodeList.add( errCode );
							}
							else
							{
								qualification = genericUtility.getColumnValue("qualification",dom);
								//System.out.println("currentColumn qualification =["+qualification+"]");
								String qualMulti[] = qualification.split(",");
		
								for(int i = 0; i < qualMulti.length; i++)
								{
									qualStrg = qualMulti[i].trim().toLowerCase();
									sql = "select count(1) from qualification where lower(trim(qlf_code))=?";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,qualStrg);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt =  rs.getInt(1);
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;
									if(cnt == 0)
									{
										errCode = "INVQUALCD";
										errCodeList.add( errCode );
									}
								}
								
							}
						}

					}//qualification val
					else if(childNodeName.equalsIgnoreCase("speciality_descr"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						if(custTypeMain.equalsIgnoreCase("D"))
						{
							if( childNode.getFirstChild() == null)
							{
								errCode = "VSPLDESC";
								errCodeList.add( errCode );
							}
							else
							{
								speciality = checkNull(genericUtility.getColumnValue("speciality_descr",dom));
								//System.out.println("currentColumn speciality =["+speciality+"]");
								String splMulti[]= speciality.split(",");
	
								for(int i =0; i < splMulti.length ; i++)
								{
									specialStrg= splMulti[i].trim().toLowerCase();
									//System.out.println("currentColumn speciality specialStrg =["+specialStrg+"]");
									sql = "select count(1) from speciality where lower(trim(descr))=?";
									pstmt =  conn.prepareStatement(sql);
									pstmt.setString(1,specialStrg);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt =  rs.getInt(1);
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;
									if(cnt == 0)
									{
										errCode = "INVSPEDES";
										errCodeList.add( errCode );
									}
								}
							}
						}
					}//speciality_descr
					else if(childNodeName.equalsIgnoreCase("class_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULCLSCODE";
							errCodeList.add( errCode );
						}
						else
						{
							classCode = checkNull(genericUtility.getColumnValue("class_code", dom));
							custTypeDom = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
							//System.out.println("currentColumn classcode=["+classCode+"]");
							//System.out.println("currentColumn classCode custTypeDom =["+custTypeDom+"]");
							sql = "select count(1) from strg_cust_class where class_code = ? and cust_type=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,classCode);
							pstmt.setString(2,custTypeDom);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVCLASSCD";
								errCodeList.add( errCode );
							}
						}
						
					}//class_code val
					else if(childNodeName.equalsIgnoreCase("no_visit"))
					{
						String custTypeMain = checkNullAndTrim(genericUtility.getColumnValue("cust_type", dom));
						//System.out.println("currentColumn no_visit custTypeDom =["+custTypeMain+"]");
						if(custTypeMain.equalsIgnoreCase("D"))
						{
							if( childNode.getFirstChild() == null)
							{
								errCode = "NULLVISIT";
								errCodeList.add( errCode );
							}
							else
							{
								noVisit = checkNull(genericUtility.getColumnValue("no_visit", dom));
								isNumber = checkNumeric( noVisit );
								//System.out.println("isNumber =["+isNumber+"]");
								if ( !isNumber )
								{
									errCode = "INVAVISIT";
									errCodeList.add( errCode );
								}
							}
						}
					}//no_visit
					else if(childNodeName.equalsIgnoreCase("sex"))
					{
						gender = checkNull(genericUtility.getColumnValue("sex", dom));
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULSEXSEL";
							errCodeList.add( errCode );
						}
						else if( gender.trim().length() > 0 && !("M".equalsIgnoreCase(gender) || "F".equalsIgnoreCase(gender) || "O".equalsIgnoreCase(gender)) )//Added Others in the condition
						{
							errCode = "INVGENDER";
							errCodeList.add( errCode );
						}
					}//gender val
					/*else if(childNodeName.equalsIgnoreCase("locality_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLOCCODE";
							errCodeList.add( errCode );
						}
						else
						{
							localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom));
							sql = "select count(1) from locality where locality_code = ?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,localityCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "LOCNOTEXTS";
								errCodeList.add( errCode );
							}
						}
					}//locality_code*/
					else if(childNodeName.equalsIgnoreCase("locality_descr"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLOCCODE";
							errCodeList.add( errCode );
						}
						/*else
						{
							localityDescr = checkNull(genericUtility.getColumnValue("locality_descr", dom));
							sql = "select count(1) from locality where UPPER(descr) = UPPER(trim(?))";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,localityDescr);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "LOCNOTEXTS";
								errCodeList.add( errCode );
							}
						}*/
					}//locality_descr
					else if(childNodeName.equalsIgnoreCase("stan_type"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSTNTYP";
							errCodeList.add( errCode );
						}
						else
						{
							String stanType = checkNull(genericUtility.getColumnValue("stan_type", dom));
							stanType = stanType.trim().toLowerCase();
							sql = "select count(1) from stantype where lower(trim(stan_type)) = lower(trim(?))";//Added lower and to trim the station type
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,stanType);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVSTANTYP";
								errCodeList.add( errCode );
							}
						}
					}//stan_type val
					else if(childNodeName.equalsIgnoreCase("reg_no"))
					{
						String regNo = checkNull(genericUtility.getColumnValue("reg_no", dom));
						String transactioId = checkNull(genericUtility.getColumnValue("tran_id", dom));
						//System.out.println("regNofilepost save::["+regNo+"]transactioId["+transactioId+"]");
						if( childNode.getFirstChild() != null )
						{
							sql = "select count(1) from strg_customer where reg_no = ? ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,regNo);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
								System.out.println("cntstrgcust["+cnt+"]");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close(); 
								pstmt = null;
							}
							if (cnt == 0)
							{
								sql = "select count(1) from strgcust_upload where reg_no = ? and tran_id <> ?";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,regNo);
								pstmt.setString(2,transactioId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									System.out.println("cnt>>>>["+cnt+"]");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
							}
							if(cnt > 0)
							{
								errCode = "DUPPREGNO";
								errCodeList.add( errCode );
							}
							else if(cnt==0 && regNo.length() > 5) 							
							{
								//System.out.println("inside the condtion");
								String councilNo= regNo.substring(0, 5);
								int count =0;
								sql="SELECT COUNT(*) AS COUNT FROM GENCODES WHERE FLD_NAME='REG_NO' AND MOD_NAME='W_WSFA_STRG_CUSTOMER' AND FLD_VALUE =? ";
								
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,councilNo);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count =  rs.getInt("COUNT");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close(); 
									pstmt = null;
								}
								if(count == 0)
								{
									errCode = "INVREGNO";
									errCodeList.add( errCode );
									
								}
							}
						}//if childnode not null
					}//reg_no val
					else if(childNodeName.equalsIgnoreCase("cust_type_descr"))
					{
						if( childNode.getFirstChild() == null)
						{
							errCode = "VCUSTDESC";
							errCodeList.add( errCode );
						}
						else
						{
							custTypeDes = checkNull(genericUtility.getColumnValue("cust_type_descr",dom));
							custTypeDes = custTypeDes.trim().toLowerCase();
							//System.out.println("currentColumn custTypeDes =["+custTypeDes+"]");
							sql = "select count(1) from strg_cust_type where lower(trim(sh_descr))=?";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,custTypeDes);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "INVCUSTDES";
								errCodeList.add( errCode );
							}
						}
					}//cust_type_descr
					else if(childNodeName.equalsIgnoreCase("age"))
					{
						String age = checkNull(genericUtility.getColumnValue("age", dom));
						System.out.println("Age is::["+age+"]");
						//System.out.println("childNode.getFirstChild()::["+childNode.getFirstChild()+"]");
						if( childNode.getFirstChild() != null && age.trim().length()>3)
						{
							System.out.println("Inside age is not null");
							errCode = "INVSCAGE";
							errCodeList.add( errCode );
						}//if childnode not null
					}//age val
					//Added stateCode Null validation
					else if(childNodeName.equalsIgnoreCase("state_code"))
					{
						if( childNode.getFirstChild() == null)
						{
							errCode = "VMSTATCD";
							errCodeList.add( errCode );
						}
					}//state val
					//Added stateCode Null validation
					//Added stationDescr Null validation
					else if(childNodeName.equalsIgnoreCase("stan_code_descr"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "VMSTNCDNLL";
							errCodeList.add( errCode );
						}
						/*else
						{
							stanCodeDescr = checkNull(genericUtility.getColumnValue("stan_code_descr", dom));
							sql = "select count(1) from station where UPPER(descr) = UPPER(trim(?))";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1,stanCodeDescr);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt =  rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if(cnt == 0)
							{
								errCode = "VTSTNCDINV";
								errCodeList.add( errCode );
							}
						}*/
					}
					//Added stationDescr Null validation
				}//end of inner for loop
			}//end outer for loop
			String userId = "";
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			System.out.println("userId::::::::::"+userId);
			int errListSize = errCodeList.size();
			cnt = 0;
			String errFldName = null;
			BaseLogger.log("3",null,null," errListSize :: ["+errListSize+"]");
			/*if(errCodeList != null && errListSize > 0)
			{
				BaseLogger.log("3",null,null," errCodeList :: ["+errCodeList+"]");
				for (int i = 0; i < errCodeList.size(); i++)
				{
					String errorCode = errCodeList.get(i);
					retString = getErrorString("",errorCode, userId);
					BaseLogger.log("3",null,null," retString :: ["+retString+"]");
					BaseLogger.log("3",null,null," errCode :: ["+errCode+"]");
					messageDescrList = getMessageDescr(errCode,conn);
					BaseLogger.log("3",null,null," messageDescrList :: ["+messageDescrList+"]");
					messageType = (String)messageDescrList.get(0);
					if(retString.length() > 0)
					{
						String bifurErrString = retString.substring(retString.indexOf("<Errors>") + 8, retString.indexOf("<trace>"));
						bifurErrString = bifurErrString + retString.substring(retString.indexOf("</trace>") + 8, retString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						retString = "";
						System.out.println("errStringXml>>>>611::["+errStringXml+"]");
					}
					if ("W".equalsIgnoreCase(messageType) )
					{
						msgDescr.append((String)messageDescrList.get(1)).append("~");
					}
					else if ("E".equalsIgnoreCase(messageType) )
					{
						msgDescr.append((String)messageDescrList.get(1)).append("~");
						break;
					}
				}
				errCodeList.clear();
				errCodeList = null;
				messageDescrList.clear();
				messageDescrList = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				pinCode = checkNullAndTrim(genericUtility.getColumnValue("pin", dom));
				stateCode = checkNullAndTrim(genericUtility.getColumnValue("state_code", dom));
				stanCodeDescr = checkNullAndTrim(genericUtility.getColumnValue("stan_code_descr", dom));
				localityDescr = checkNullAndTrim(genericUtility.getColumnValue("locality_descr", dom));
				
				String stationBuffer = "",pin = "";
				
				stationBuffer = checkNull(getStationCode(stanCodeDescr,pinCode,stateCode,conn));
				
				if(stationBuffer.indexOf(',') > -1)
				{
					String[] stationList = stationBuffer.split(",");
					if(stationList.length >= 1)
					{
						stanCode = checkNullAndTrim(stationList[0]);
					}
					if(stationList.length >= 2)
					{
						pin = checkNullAndTrim(stationList[1]);
					}
				}
				else
				{
					stanCode = stationBuffer;
				}
				
				localityCode = checkNull(getLocalityCode(localityDescr,stanCode,pinCode,stateCode,conn));
				
				//if both does not exist
				if((stanCode == null || stanCode.trim().length() == 0) && (localityCode == null || localityCode.trim().length() == 0))
				{
					if ( stanCodeDescr.length() > 0 )
					{
						stanCodeDescr = stanCodeDescr.toUpperCase();
					}
					stanCode = generateCode(conn);
					localityCode = stanCode;
					createStation(stanCode,stanCodeDescr,salesPers,dom,conn);
					createLocality(localityCode,localityDescr,stanCode,salesPers,dom,conn);
					updateStrgCustUpload(dom, tranID,stanCode,localityCode,conn);
				}
				//if only station does not exist then create new station and new locality aganist it
				else if((stanCode == null || stanCode.trim().length() == 0) && (localityCode != null && localityCode.trim().length() > 0))
				{
					if ( stanCodeDescr.length() > 0 )
					{
						stanCodeDescr = stanCodeDescr.toUpperCase();
					}
					stanCode = generateCode(conn);
					localityCode = stanCode;
					createStation(stanCode,stanCodeDescr,salesPers,dom,conn);
					createLocality(localityCode,localityDescr,stanCode,salesPers,dom,conn);
					updateStrgCustUpload(dom, tranID,stanCode,localityCode,conn);
				}
				//if only locality does not exist and station exists localityCode is same as stanCode 
				else if((stanCode != null && stanCode.trim().length() > 0) && (localityCode == null || localityCode.trim().length() == 0))
				{
					//If stationCode same as localityCode does not exist in locality then keep it same. 
					if(!getExistingLocalityCode(stanCode,conn))
					{
						localityCode = stanCode;
					}
					//If stationCode same as localityCode exist in locality then create new localityCode.
					else
					{
						if(pinCode == null || pinCode.trim().length() == 0)
						{
							pinCode = pin;
						}
						localityCode = generateLocalityCode(pinCode,conn);
					}
					createLocality(localityCode,localityDescr,stanCode,salesPers,dom,conn);
					updateStrgCustUpload(dom, tranID,stanCode,localityCode,conn);
				}
				//if both exists
				else if((stanCode != null && stanCode.trim().length() > 0) && (localityCode != null && localityCode.trim().length() > 0))
				{
					updateStrgCustUpload(dom, tranID,stanCode,localityCode,conn);
				}
				
				errCode = checkNullAndTrim(checkCustomerExist(dom,conn,localityCode));
				BaseLogger.log("3",null,null," else block => errCode : ["+errCode+"]");
				
				if(errCode.equalsIgnoreCase("DUPRECFOND")) {
					errCodeList.add( errCode );
				}
				
				//Changes added by ManishK to call insertNewCustomersDetail method [START]
				StrgCustUploadSchedule strgCustUpload = new StrgCustUploadSchedule();
				//Added ScCode in method while uploading Customer[04-DEC-23]
				//Added userInfo in method while customer Upload
				retString = strgCustUpload.insertNewCustomersDetail(salesPers, scCode, userInfo, conn);
				//Changes added by ManishK to call insertNewCustomersDetail method [END]
				errStringXml = new StringBuffer(retString);
			}*/
			
			if(errListSize == 0)
			{
				pinCode = checkNullAndTrim(genericUtility.getColumnValue("pin", dom));
				stateCode = checkNullAndTrim(genericUtility.getColumnValue("state_code", dom));
				stanCodeDescr = checkNullAndTrim(genericUtility.getColumnValue("stan_code_descr", dom));
				localityDescr = checkNullAndTrim(genericUtility.getColumnValue("locality_descr", dom));
				
				String stationBuffer = "",pin = "";
				
				stationBuffer = checkNull(getStationCode(stanCodeDescr,pinCode,stateCode,conn));
				
				if(stationBuffer.indexOf(',') > -1)
				{
					String[] stationList = stationBuffer.split(",");
					if(stationList.length >= 1)
					{
						stanCode = checkNullAndTrim(stationList[0]);
					}
					if(stationList.length >= 2)
					{
						pin = checkNullAndTrim(stationList[1]);
					}
				}
				else
				{
					stanCode = stationBuffer;
				}
				
				localityCode = checkNull(getLocalityCode(localityDescr,stanCode,pinCode,stateCode,conn));
				
				//if both does not exist
				if((stanCode == null || stanCode.trim().length() == 0) && (localityCode == null || localityCode.trim().length() == 0))
				{
					if ( stanCodeDescr.length() > 0 )
					{
						stanCodeDescr = stanCodeDescr.toUpperCase();
					}
					stanCode = generateCode(conn);
					localityCode = stanCode;
					createStation(stanCode,stanCodeDescr,salesPers,dom,conn);
					createLocality(localityCode,localityDescr,stanCode,salesPers,dom,conn);
					updateStrgCustUpload(tranID,stanCode,localityCode,conn);
				}
				//if only station does not exist then create new station and new locality aganist it
				else if((stanCode == null || stanCode.trim().length() == 0) && (localityCode != null && localityCode.trim().length() > 0))
				{
					if ( stanCodeDescr.length() > 0 )
					{
						stanCodeDescr = stanCodeDescr.toUpperCase();
					}
					stanCode = generateCode(conn);
					localityCode = stanCode;
					createStation(stanCode,stanCodeDescr,salesPers,dom,conn);
					createLocality(localityCode,localityDescr,stanCode,salesPers,dom,conn);
					updateStrgCustUpload(tranID,stanCode,localityCode,conn);
				}
				//if only locality does not exist and station exists localityCode is same as stanCode 
				else if((stanCode != null && stanCode.trim().length() > 0) && (localityCode == null || localityCode.trim().length() == 0))
				{
					//If stationCode same as localityCode does not exist in locality then keep it same. 
					if(!getExistingLocalityCode(stanCode,conn))
					{
						localityCode = stanCode;
					}
					//If stationCode same as localityCode exist in locality then create new localityCode.
					else
					{
						if(pinCode == null || pinCode.trim().length() == 0)
						{
							pinCode = pin;
						}
						localityCode = generateLocalityCode(pinCode,conn);
					}
					createLocality(localityCode,localityDescr,stanCode,salesPers,dom,conn);
					updateStrgCustUpload(tranID,stanCode,localityCode,conn);
				}
				//if both exists
				else if((stanCode != null && stanCode.trim().length() > 0) && (localityCode != null && localityCode.trim().length() > 0))
				{
					updateStrgCustUpload(tranID,stanCode,localityCode,conn);
				}

				// Added by Rahul P. on 16-Feb-24 to prevent duplicate customer entry [START]
				errCode = checkNullAndTrim(checkCustomerExist(dom, conn, localityCode));
				BaseLogger.log("3", null, null, " errListSize == 0 :: if block => errCode : [" + errCode + "]");

				if (!errCode.isEmpty() && errCodeList != null) 
				{
					errCodeList.add(errCode);
					errListSize = errCodeList.size();
					BaseLogger.log("3", null, null, "Error found => updated errListSize :: [" + errListSize + "]");
				}
				// Added by Rahul P. on 16-Feb-24 to prevent duplicate customer entry [END]

			}

			if(errCodeList != null && errListSize > 0)
			{
				BaseLogger.log("3",null,null,"Inside if block => errListSize > 0 : errCodeList ["+errCodeList+"]");
				for (int i = 0; i < errCodeList.size(); i++)
				{
					String errorCode = errCodeList.get(i);
					retString = getErrorString("",errorCode, userId);
					messageDescrList = getMessageDescr(errCode,conn);
					BaseLogger.log("3",null,null," messageDescrList :: ["+messageDescrList+"]");
					messageType = (String)messageDescrList.get(0);
					if(retString.length() > 0)
					{
						String bifurErrString = retString.substring(retString.indexOf("<Errors>") + 8, retString.indexOf("<trace>"));
						bifurErrString = bifurErrString + retString.substring(retString.indexOf("</trace>") + 8, retString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						retString = "";
						System.out.println("errStringXml>>>>611::["+errStringXml+"]");
					}
					if ("W".equalsIgnoreCase(messageType) )
					{
						msgDescr.append((String)messageDescrList.get(1)).append("~");
					}
					else if ("E".equalsIgnoreCase(messageType) )
					{
						msgDescr.append((String)messageDescrList.get(1)).append("~");
						break;
					}
				}
				errCodeList.clear();
				errCodeList = null;
				messageDescrList.clear();
				messageDescrList = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else {
				BaseLogger.log("3",null,null," Inside else block => error not occurred..");
				//Changes added by ManishK to call insertNewCustomersDetail method [START]
				StrgCustUploadSchedule strgCustUpload = new StrgCustUploadSchedule();
				//Added ScCode in method while uploading Customer[04-DEC-23]
				//Added userInfo in method while customer Upload
				retString = strgCustUpload.insertNewCustomersDetail(salesPers, scCode, userInfo, conn);
				//Changes added by ManishK to call insertNewCustomersDetail method [END]
				errStringXml = new StringBuffer(retString);
			}
			
			String errorMsgStr = msgDescr.toString();
			System.out.println("errorMsgStr["+errorMsgStr+"]");
			if ( errorMsgStr != null && errorMsgStr.trim().length() > 0 )
			{
				if (errorMsgStr.lastIndexOf("~") != -1)
				{
					errorMsgStr = errorMsgStr.substring(0,errorMsgStr.length()-1);
					System.out.println("errorMsgStr");
				}
				String strgUpdSql = "UPDATE STRGCUST_UPLOAD SET ERROR_STATUS='Y', ERROR_DESCR = ? WHERE TRAN_ID = ?";
				pstmtStrgUpd = conn.prepareStatement( strgUpdSql );
				pstmtStrgUpd.setString( 1, errorMsgStr);
				pstmtStrgUpd.setString( 2, tranID);
				int updCount = pstmtStrgUpd.executeUpdate();
				System.out.println("updCount =["+updCount+"]");
				System.out.println("retString["+retString+"]errorMsgStr["+errorMsgStr+"]");
			}	
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtStrgUpd != null)
				{
					pstmtStrgUpd.close();
					pstmtStrgUpd = null;
				}
			}
			catch(Exception e)
			{

				throw new ITMException(e);
			}
		}
		retString = errStringXml.toString();

		return retString;
	}//end post_save
	private ArrayList<String> getMessageDescr(String messageNo, Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList<String> messageDescrList = new ArrayList<>();
		try
		{
			String messageSql = "select msg_type, msg_descr from messages where msg_no=?";
			pstmt = conn.prepareStatement(messageSql);
			pstmt.setString(1,messageNo);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				messageDescrList.add(checkNullAndTrim(rs.getString("msg_type")));
				messageDescrList.add(checkNullAndTrim(rs.getString("msg_descr")));
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		return messageDescrList;
	}//end messagedescr
	private String checkNullAndTrim(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value.trim();
	}//end checknulltrim
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}//checknull
	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++)
		{
			if( !Character.isDigit(cArray[i]) )
			{
				isNumber = false;
			}
		}
		return isNumber;
	}//checknumeric
	
	//Added method to create station on postSave[START]
	private void createStation(String stanCode,String stanDescr,String salesPers,Document dom,Connection conn) throws Exception
	{
		String shDescrStation = "",stateCode = "",pinCode = "",stateCodeBuffer = "";
		int updtStationCnt = 0;
		PreparedStatement pstmtInsertStation = null;
		try
		{	
			stateCode = checkNullAndTrim(genericUtility.getColumnValue("state_code", dom));
			pinCode = checkNullAndTrim(genericUtility.getColumnValue("pin", dom));
			stateCodeBuffer = checkNullAndTrim(getStateCode(salesPers,conn));
			if(stateCodeBuffer.indexOf(',') > -1)
			{
				String[] stateCodeList = stateCodeBuffer.split(",");
				
				if(stateCode == null || stateCode.trim().length() == 0)
				{
					if(stateCodeList.length >= 1)
					{
						stateCode = checkNullAndTrim(stateCodeList[0]);
					}
				}
				
				if(pinCode == null || pinCode.trim().length() == 0)
				{
					if(stateCodeList.length >= 3)
					{
						pinCode = checkNullAndTrim(stateCodeList[2]);
					}
					else
					{
						pinCode = "";
					}
				}
			}
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String stationDescr = checkNullAndTrim(stanDescr);
			String stationInsertSql = "INSERT INTO STATION(STAN_CODE,DESCR,STATE_CODE,CITY,DISTRICT,CHG_DATE,CHG_USER,CHG_TERM,SH_DESCR,PIN,RD_PERMIT_REQD,STAN_TYPE,ACTIVE) "
					+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsertStation = conn.prepareStatement(stationInsertSql);
			pstmtInsertStation.setString(1, checkNullAndTrim(stanCode));
			pstmtInsertStation.setString(2, checkNullAndTrim(stanDescr));
			pstmtInsertStation.setString(3, checkNullAndTrim(stateCode));
			if (stationDescr.trim().length() > 20 )
			{
				shDescrStation = stationDescr.substring(0,20);
			}
			else
			{
				shDescrStation = stationDescr;
			}
			pstmtInsertStation.setString(4, checkNullAndTrim(stanDescr));
			pstmtInsertStation.setString(5, checkNullAndTrim(stanDescr));
			pstmtInsertStation.setTimestamp(6, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertStation.setString(7, checkNullAndTrim(salesPers));
			pstmtInsertStation.setString(8, "SYSTEM");
			pstmtInsertStation.setString(9, checkNullAndTrim(shDescrStation));
			pstmtInsertStation.setString(10, checkNullAndTrim(pinCode));
			pstmtInsertStation.setString(11, "Y");
			pstmtInsertStation.setString(12, "M");
			pstmtInsertStation.setString(13, "Y");
			
			updtStationCnt = pstmtInsertStation.executeUpdate();
			if(updtStationCnt > 0)
			{
				System.out.println("Inserted Successfully into STATION =["+updtStationCnt+"]");
			}
			
			conn.commit();
			
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmtInsertStation != null )
				{
					pstmtInsertStation.close();
					pstmtInsertStation = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
	}
	//Added method to create station on postSave[END]
	
	//Added method to create locality on postSave[START]
	private void createLocality(String localityCode,String localityDescr,String stanCode,String salesPers,Document dom,Connection conn) throws Exception
	{
		int updtLocalityCnt = 0;
		String stateCode = "",pinCode = "",countCode = "",shDescrLocality = "",stateCodeBuffer = "";
		PreparedStatement pstmtInsertLocality = null;
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
						
			stateCode = checkNullAndTrim(genericUtility.getColumnValue("state_code", dom));
			pinCode = checkNullAndTrim(genericUtility.getColumnValue("pin", dom));
			
			stateCodeBuffer = checkNullAndTrim(getStateCode(salesPers,conn));
			if(stateCodeBuffer.indexOf(',') > -1)
			{
				String[] stateCodeList = stateCodeBuffer.split(",");
				
				if(stateCode == null || stateCode.trim().length() == 0)
				{
					if(stateCodeList.length >= 1)
					{
						stateCode = checkNullAndTrim(stateCodeList[0]);
					}
				}

				if(stateCodeList.length >= 2)
				{
					countCode = checkNullAndTrim(stateCodeList[1]);
				}

				if(pinCode == null || pinCode.trim().length() == 0)
				{
					if(stateCodeList.length >= 3)
					{
						pinCode = checkNullAndTrim(stateCodeList[2]);
					}
					else
					{
						pinCode = "";
					}
				}
			}
			
			if (localityDescr.trim().length() > 20 )
			{
				shDescrLocality = localityDescr.substring(0,20);
			}
			else
			{
				shDescrLocality = localityDescr;
			}
			
			String localityInsertSql = "INSERT INTO LOCALITY(LOCALITY_CODE,DESCR,CITY,DISTRICT,STAN_CODE,STATE_CODE,PIN,COUNT_CODE,CHG_DATE,CHG_USER,CHG_TERM,LOCALITY_TYPE,LOCALITY_SUBTYPE,STATUS) "
					+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsertLocality = conn.prepareStatement(localityInsertSql);
			pstmtInsertLocality.setString(1, checkNullAndTrim(localityCode));
			pstmtInsertLocality.setString(2, checkNullAndTrim(localityDescr));
			pstmtInsertLocality.setString(3, checkNullAndTrim(shDescrLocality));
			pstmtInsertLocality.setString(4, checkNullAndTrim(shDescrLocality));
			pstmtInsertLocality.setString(5, checkNullAndTrim(stanCode));
			pstmtInsertLocality.setString(6, checkNullAndTrim(stateCode));
			pstmtInsertLocality.setString(7, checkNullAndTrim(pinCode));
			pstmtInsertLocality.setString(8, checkNullAndTrim(countCode));
			pstmtInsertLocality.setTimestamp(9, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertLocality.setString(10, checkNullAndTrim(salesPers));
			pstmtInsertLocality.setString(11, "SYSTEM");
			pstmtInsertLocality.setString(12, "N");
			pstmtInsertLocality.setString(13, "O");
			pstmtInsertLocality.setString(14, "A");

			updtLocalityCnt = pstmtInsertLocality.executeUpdate();
			if(updtLocalityCnt > 0)
			{
				System.out.println("Inserted Successfully into LOCALITY =["+updtLocalityCnt+"]");
			}
			
			conn.commit();
		}
		catch(Exception e)
		{	
			throw new ITMException(e);		
		}
		finally
		{
			try
			{
				if( pstmtInsertLocality != null )
				{
					pstmtInsertLocality.close();
					pstmtInsertLocality = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
	}
	//Added method to create locality on itemchange[END]
	
	//Added method to create new locality/station code when not exists from sequence[START]
	public String generateCode(Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String stanCode = "",sql = "";
		try
		{
			sql = "SELECT substr( '0000' || stan_code_seq.nextval , -5 ) AS STAN_CODE from dual";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stanCode = checkNullAndTrim(rs.getString("STAN_CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		return stanCode;
	}
	//Added method to create new locality/station code when not exists from sequence[END]
	
	//Added method for getting pin,state,country from loginPerson[START]
	public String getStateCode(String salesPers,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",stateCode = "",countCode = "", pin = "";
		StringBuffer stateCountPinbuff = null;
		try
		{
			stateCountPinbuff = new StringBuffer();
			sql = "SELECT STATE_CODE,COUNT_CODE,PIN FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stateCode = checkNull(rs.getString("STATE_CODE"));
				countCode = checkNull(rs.getString("COUNT_CODE"));
				pin = checkNull(rs.getString("PIN"));
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(pin == null || pin.trim().length() == 0)
			{
				sql = "SELECT CUR_PIN FROM EMPLOYEE WHERE EMP_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					pin = checkNull(rs.getString("CUR_PIN"));
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			
			if (stateCode != null && stateCode.trim().length() > 0) 
			{
	            stateCountPinbuff.append(stateCode);
	            if (countCode != null && countCode.trim().length() > 0) 
	            {
	                stateCountPinbuff.append(",");
	            }
	        }
	        if (countCode != null && countCode.trim().length() > 0) 
	        {
	            stateCountPinbuff.append(countCode);
	            if (pin != null && pin.trim().length() > 0) 
	            {
	                stateCountPinbuff.append(",");
	            }
	        }
	        if (pin != null && pin.trim().length() > 0) 
	        {
	            stateCountPinbuff.append(pin);
	        }
			
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		
		return stateCountPinbuff.toString();
	}
	//Added method for getting pin,state,country from loginPerson[END]
	
	//Added method to get stationCode from station master[START]
	public String getStationCode(String stanCodeDescr,String pin,String stateCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",stanCode = "",pinCode = "";
		StringBuffer stationBuff = null;
		try
		{
			stationBuff = new StringBuffer();
			if((pin != null && pin.trim().length() > 0) && (stateCode != null && stateCode.trim().length() > 0))
			{
				sql = "SELECT STAN_CODE FROM STATION WHERE UPPER(TRIM(DESCR)) = UPPER(?) AND PIN = ? AND STATE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,stanCodeDescr);
				pstmt.setString(2,pin);
				pstmt.setString(3,stateCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					stanCode = rs.getString("STAN_CODE");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				if(stanCode == null || stanCode.trim().length() == 0)
				{
					sql = "SELECT STAN_CODE FROM STATION WHERE UPPER(TRIM(DESCR)) = UPPER(?) AND STATE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,stanCodeDescr);
					pstmt.setString(2,stateCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stanCode = rs.getString("STAN_CODE");
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			else if((pin == null || pin.trim().length() == 0) && (stateCode != null && stateCode.trim().length() > 0))
			{
				sql = "SELECT STAN_CODE,PIN FROM STATION WHERE UPPER(TRIM(DESCR)) = UPPER(?) AND STATE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,stanCodeDescr);
				pstmt.setString(2,stateCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					stanCode = rs.getString("STAN_CODE");
					pinCode = rs.getString("PIN");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
						
			if (stanCode != null && stanCode.trim().length() > 0) 
			{
				stationBuff.append(stanCode);
	            if (pinCode != null && pinCode.trim().length() > 0) 
	            {
	            	stationBuff.append(",");
	            }
	        }
			if (pinCode != null && pinCode.trim().length() > 0) 
	        {
				stationBuff.append(pinCode);
	        }
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return stationBuff.toString();
	}
	//Added method to get stationCode from station master[END]
	
	//Added method to get localityCode from locality master[START]
	public String getLocalityCode(String localityDescr,String stanCode,String pin,String stateCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",localityCode = "";
		try
		{
			if((pin != null && pin.trim().length() > 0) && (stateCode != null && stateCode.trim().length() > 0) && (stanCode != null && stanCode.trim().length() > 0))
			{
				sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE STAN_CODE = ? AND UPPER(TRIM(DESCR)) = UPPER(?) AND PIN = ? AND STATE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stanCode);
				pstmt.setString(2,localityDescr);
				pstmt.setString(3,pin);
				pstmt.setString(4,stateCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCode = rs.getString("LOCALITY_CODE");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				if(localityCode == null || localityCode.trim().length() == 0)
				{
					sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE STAN_CODE = ? AND UPPER(TRIM(DESCR)) = UPPER(?) AND STATE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, stanCode);
					pstmt.setString(2,localityDescr);
					pstmt.setString(3,stateCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						localityCode = rs.getString("LOCALITY_CODE");
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				
			}
			else if((pin == null || pin.trim().length() == 0) && (stateCode != null && stateCode.trim().length() > 0) && (stanCode != null && stanCode.trim().length() > 0))
			{
				sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE STAN_CODE = ? AND UPPER(TRIM(DESCR)) = UPPER(?) AND STATE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stanCode);
				pstmt.setString(2,localityDescr);
				pstmt.setString(3,stateCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCode = rs.getString("LOCALITY_CODE");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			/*else if((pin != null && pin.trim().length() > 0) && (stateCode != null && stateCode.trim().length() > 0) && (stanCode == null || stanCode.trim().length() == 0))
			{
				sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE UPPER(DESCR) = UPPER(?) AND PIN = ? AND STATE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,stanCodeDescr);
				pstmt.setString(2,pin);
				pstmt.setString(3,stateCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCode = rs.getString("LOCALITY_CODE");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}*/
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return localityCode;
	}
	//Added method to get localityCode from locality master[START]
	
	//Added method to update strgCustUpload in PostSave[START]
	public void updateStrgCustUpload(String tranID,String stationCode,String localityCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt=null;
		try
		{
			String updateSql = "UPDATE STRGCUST_UPLOAD SET STAN_CODE = ?, LOCALITY_CODE = ? WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(updateSql);
			pstmt.setString(1, stationCode);
			pstmt.setString(2, localityCode);
			pstmt.setString(3, tranID);
			int cnt= pstmt.executeUpdate();
			if(cnt > 0)
			{
				System.out.println("updates successfully strgcustupload"+cnt);
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		
	}
	//Added method to update strgCustUpload in PostSave[END]
	
	//Added method to check if stationCode is same as LocalityCode
	public boolean getExistingLocalityCode(String stanCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",localityCode = "";
		boolean isLocalityExists = false;
		try
		{
			sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE LOCALITY_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,stanCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityCode = rs.getString("LOCALITY_CODE");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(localityCode != null && localityCode.trim().length() > 0)
			{
				isLocalityExists = true;
			}
			else
			{
				isLocalityExists = false;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return isLocalityExists;
	}
	//Added method to check if stationCode is same as LocalityCode
	
	//Added method to generate LocalityCode
	public String generateLocalityCode(String pinCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",localityCode = "";
		try
		{
			sql = "SELECT CASE WHEN MAX(LOCALITY_CODE) + 1 IS NULL THEN (91" + pinCode + " || substr('000',-2)) + 1 ELSE MAX(LOCALITY_CODE) + 1 END AS LOCALITY_CODE FROM LOCALITY WHERE LOCALITY_CODE LIKE '%91" + pinCode + "%'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityCode = rs.getString("LOCALITY_CODE");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		
		return localityCode;
	}
	//Added method to generate LocalityCode
	
	//Added By Rahul P. on 16-Feb-24 to check for duplicate customer [START]
	private String checkCustomerExist(Document dom, Connection conn, String localityCode) throws ITMException 
	{

		E12GenericUtility genericUtility = new E12GenericUtility();
		String errCode = "";
		String locCode = genericUtility.getColumnValue("locality_code", dom);
		BaseLogger.log("3",null,null,"Inside checkCustomerExist => locCode : ["+locCode+"] & localityCode : ["+localityCode+"]");
		
		String firstName = genericUtility.getColumnValue("first_name", dom);
		String middleName = genericUtility.getColumnValue("middle_name", dom);
		String lastName = genericUtility.getColumnValue("last_name", dom);
		String mobileNo = genericUtility.getColumnValue("mobile_no", dom);
		String regNo = genericUtility.getColumnValue("reg_no", dom);
		String sccCode = genericUtility.getColumnValue("sc_code", dom);
		String custmrType = genericUtility.getColumnValue("cust_type", dom);
		System.out.println("custmrType[" + custmrType + "]locCode[" + locCode + "]regNo[" + regNo + "]");

		String sql = "SELECT FN_CHK_DUP_STRGCUST(?,?,?,?,?,?,?,?) AS DUP_RECORD FROM DUAL";
		try (PreparedStatement pstmt = conn.prepareStatement(sql)) 
		{
			pstmt.setString(1, localityCode);
			pstmt.setString(2, firstName);
			pstmt.setString(3, middleName);
			pstmt.setString(4, lastName);
			pstmt.setString(5, mobileNo);
			pstmt.setString(6, regNo);
			pstmt.setString(7, sccCode);
			pstmt.setString(8, custmrType);

			try (ResultSet rs = pstmt.executeQuery()) 
			{

				if (rs.next()) 
				{
					if (rs.getInt("DUP_RECORD") > 0) 
					{
						errCode = "DUPRECFOND";

					}
				}
			}

		} catch (Exception e) 
		{
			BaseLogger.log("3",null,null,"Error occurred in checkCustomerExist : "+e);
		}

		return errCode;

	}
	//Added by Rahul P. on 16-Feb-24 to check for duplicate customer [END]
	
}