var bbHostURL = '';
var isMobile = window.location.pathname.indexOf('E12BROWSER') == -1;

setBBHostURL();
addCssLink("material-theme.css");
addScript("assets/js/pluginWrapper.js");

if(isMobile)
{
	addScript("runtime.js");
	addScript("polyfills.js");
	addScript("main.js");
}
addCssLink("foundation.min.css");
addCssLink("styles.css");
addCssLink("visionicon.css");
addCssLink("dragula.css");

addScript2("./visplugin/assets/flexmonster/","flexmonster.js");

if( !HTMLElement.prototype.createShadowRoot ){
	HTMLElement.prototype.createShadowRoot = function(){
		return this;
	}
}

function addScript(fileName)
{
    addScript2("./visplugin/", fileName);
}

function addScript2(path, fileName)
{
    var script=document.createElement('script');
    script.type='text/javascript';
    script.src= path + fileName;
    document.head.appendChild(script);
}

function addCssLink( fileName)
{
    try {
    var cssLink=document.createElement('link');
    cssLink.rel='stylesheet';
    cssLink.href= "./visplugin/assets/css/" + fileName;
    document.head.appendChild(cssLink);
    } 
	catch(e){
    console.log('Errorrr--');
  }
}

function addCssLink2( path,fileName)
{
    try {
    var cssLink=document.createElement('link');
    cssLink.rel='stylesheet';
    cssLink.href= path + fileName;
    document.head.appendChild(cssLink);
    } 
	catch(e){
    console.log('Errorrr--');
  }
}

function addElement(elName){
   var el = document.createElement(elName);
   document.body.appendChild(el);
}

function loaddashboardComponent(targetId, componentData, callback)
{
	var compRef;
    setBBHostURL();
    if( window.VisPlugin )
    {
	    var pluginEmitter = window.VisPlugin.pluginEvtEmitter;
	    var pluginConfig = window.VisPlugin.pluginConfig;
	    var evtEmit = new pluginEmitter();
	    evtEmit.subscribe( function(pluginEvent) {
	        (typeof callback === 'function') && callback(pluginEvent);
	    });

	    var compData = {};
	    var componentName = "";
	    try {
			compData = JSON.parse(componentData);
			componentName = compData.componentName;
		}
		catch(e) {
			componentName = componentData;
		}
	    console.log( 'Print componentData >>', componentData, ' componentName >>', componentName );
        if(typeof(compData.cacheComp) == "string"){
            if(compData.cacheComp && compData.cacheComp.trim() == "true"){
                compData.cacheComp = true;
            }else {
                compData.cacheComp = false;
            }
        }
	    var data = {
	    	"target-id" : compData.targetId,
	    	"compData" : compData,
	    	"cacheComp" : compData.cacheComp ? true : false
	    };
	    var angPlugin = window.VisPlugin.loadPlugin(componentName, data, window.VisPlugin.pluginMI, evtEmit);
	    compRef = angPlugin.instance;
    }

	return compRef;
}

function destroyComponent(componentName)
{
	if( window.VisPlugin )
	{
		window.VisPlugin.destroyPlugin(componentName);
	}
}

function detachComponent(componentName)
{
	if( window.VisPlugin )
	{
		window.VisPlugin.detachPlugin(componentName);
	}
}

function detachPlugin(componentName)
{
	if( window.VisPlugin )
	{
		window.VisPlugin.detachPlugin(componentName);
	}
}

function setBBHostURL()
{
	if(window._getHostURL)
	{
     	bbHostURL = window._getHostURL();
 	}
 	else
 	{
		bbHostURL = localStorage.getItem('hostUrl');
		if(bbHostURL == null){
			bbHostURL = '';
		}
	}

	localStorage.setItem('HOST_URL', bbHostURL);
}

function getBBHostURL()
{
	return bbHostURL;
}

