/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.ejb;

import ibase.scheduler.ejb.ScheduleInfoLocal;
import ibase.scheduler.ejb.ScheduleInfoRemote;
import ibase.scheduler.ejb.SchedulerEJB;
import ibase.scheduler.utility.ScheduleModel;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TimerHandle;
import javax.naming.InitialContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ScheduleInfoEJB
implements ScheduleInfoLocal,
ScheduleInfoRemote {
    static HashMap scheduleinfoMap = new HashMap();
    static HashMap calDayMap = new HashMap();
    private String filePath;
    static String regSchId = "";
    SessionContext sessionContext = null;
    private Connection remoteCon = null;

    public ScheduleInfoEJB() {
        try {
            BaseLogger.log("3", null, null, "ejbCreate is called.......1");
            calDayMap.put("SUNDAY", 1);
            calDayMap.put("MONDAY", 2);
            calDayMap.put("TUESDAY", 3);
            calDayMap.put("WEDNESDAY", 4);
            calDayMap.put("THURSDAY", 5);
            calDayMap.put("FRIDAY", 6);
            calDayMap.put("SATURDAY", 7);
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            this.setSchedulerPropPath(null);
        }
        catch (BaseException be) {
            be.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void ejbCreate() {
        try {
            BaseLogger.log("3", null, null, "ejbCreate is called.......2");
            calDayMap.put("SUNDAY", 1);
            calDayMap.put("MONDAY", 2);
            calDayMap.put("TUESDAY", 3);
            calDayMap.put("WEDNESDAY", 4);
            calDayMap.put("THURSDAY", 5);
            calDayMap.put("FRIDAY", 6);
            calDayMap.put("SATURDAY", 7);
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            this.setSchedulerPropPath(null);
        }
        catch (BaseException be) {
            be.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Remove
    public void stopSession() {
        BaseLogger.log("3", null, null, "From stopSession method with @Remove annotation");
    }

    private void setSchedulerPropPath(String filePath) throws BaseException {
        try {
            BaseLogger.log("3", null, null, " CommonConstants.APPLICATION_CONTEXT [" + CommonConstants.APPLICATION_CONTEXT + "]");
            this.filePath = CommonConstants.APPLICATION_CONTEXT != null ? (filePath == null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "setting" + File.separator + "ScheduleProperties.xml" : filePath) : (filePath == null ? String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "setting" + File.separator + "ScheduleProperties.xml" : filePath);
            File schPropFile = new File(this.filePath);
            if (schPropFile.createNewFile()) {
                FileWriter fWriter = new FileWriter(schPropFile);
                fWriter.write("<ROOT><SCHEDULES></SCHEDULES></ROOT>");
                fWriter.flush();
                fWriter.close();
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @PreDestroy
    public void ejbRemove() {
        StringBuffer strBuff = new StringBuffer("<ROOT><SCHEDULES>");
        try {
            BaseLogger.log("3", null, null, "\n\n$$$$$$$$$$****************** EJB REMOVE ********************************\n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getScheduleModelStr(String scheduleId) throws RemoteException, BaseException {
        String retSchModel = "";
        ScheduleModel schModel = null;
        try {
            schModel = this.getScheduleModel(scheduleId);
            retSchModel = schModel != null ? schModel.toString() : "";
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return retSchModel;
    }

    @Override
    public String getScheduleModelDetail(String scheduleId) throws RemoteException, BaseException {
        String retSchModel = "";
        ScheduleModel schModel = null;
        try {
            schModel = this.parseForSchedule(scheduleId);
            String lastFiredOn = this.getLastFiredOn(scheduleId);
            String nextDueDate = this.getNextDueDate(scheduleId);
            if (lastFiredOn != null && schModel != null) {
                if (lastFiredOn.equalsIgnoreCase("0")) {
                    lastFiredOn = "Not Fired";
                }
                schModel.setLastSchFireOn(lastFiredOn);
            }
            if (schModel != null) {
                schModel.setNextDueDate(nextDueDate);
                retSchModel = schModel.toString();
            } else {
                retSchModel = "";
            }
        }
        catch (BaseException be) {
            be.printStackTrace();
            BaseLogger.log("0", null, null, "BaseException-Exception-while setting nextDue date--[" + be.getMessage() + "]");
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception-while setting nextDue date-[" + e.getMessage() + "]");
            throw new BaseException(e);
        }
        return retSchModel;
    }

    @Override
    public ScheduleModel getScheduleModel(String scheduleId) throws RemoteException, BaseException {
        ScheduleModel schModel = null;
        BaseLogger.log("2", null, null, "ScheduleInfoEJB >> getScheduleModel is called......[" + scheduleId + "]");
        try {
            if (scheduleinfoMap.get(scheduleId) != null) {
                schModel = (ScheduleModel)scheduleinfoMap.get(scheduleId);
            } else {
                BaseLogger.log("3", null, null, "Getting new model....");
                schModel = this.parseForSchedule(scheduleId);
                scheduleinfoMap.put(scheduleId, schModel);
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schModel;
    }

    @Override
    public ArrayList getAllScheduleNameList(String schInfoFileName) throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "ScheduleInfoEJB >> getAllScheduleNameList is called......[" + schInfoFileName + "]");
        return this.getAllScheduleNameList(schInfoFileName, null);
    }

    public ArrayList getAllScheduleNameList(String schInfoFileName, UserInfoBean userInfo) throws RemoteException, BaseException {
        this.setSchedulerPropPath(schInfoFileName);
        ArrayList allSchNameList = this.getAllScheduleNameList(userInfo);
        return allSchNameList;
    }

    @Override
    public ArrayList getAllScheduleNameList() throws RemoteException, BaseException {
        UserInfoBean userInfo = null;
        return this.getAllScheduleNameList(userInfo);
    }

    public ArrayList getAllScheduleNameList(UserInfoBean userInfo) throws RemoteException, BaseException {
        ArrayList<String> allSchNameList = new ArrayList<String>();
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                String appServerIP = this.getAppServerIPAddr();
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                String sql = "SELECT SCHEDULE_ID,SCHEDULE_NAME FROM SCHEDULES_INFO WHERE APP_SERVER_IP = ? ORDER BY SCHEDULE_NAME DESC";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, appServerIP);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    String scheduleId = rs.getString("SCHEDULE_ID");
                    String scheduleName = rs.getString("SCHEDULE_NAME");
                    allSchNameList.add(String.valueOf(scheduleId) + "~" + scheduleName);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allSchNameList;
    }

    @Override
    public ArrayList getUserDefScheduleNameList(String owner) throws RemoteException, BaseException {
        return this.getUserDefScheduleNameList(owner, null);
    }

    public ArrayList getUserDefScheduleNameList(String owner, UserInfoBean userInfo) throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "<ScheduleInfoEJB><getAllScheduleNameList(String owner)>Start");
        ArrayList<String> allSchNameList = new ArrayList<String>();
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                String sql = "SELECT SCHEDULE_ID,SCHEDULE_NAME,SCHEDULE_TYPE FROM SCHEDULES_INFO WHERE OWNER='" + owner + "' order by schedule_name desc";
                pstmt = conn.prepareStatement(sql);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    String scheduleId = rs.getString("SCHEDULE_ID");
                    String scheduleName = rs.getString("SCHEDULE_NAME");
                    String scheduleType = rs.getString("SCHEDULE_TYPE");
                    allSchNameList.add(String.valueOf(scheduleId) + "~" + scheduleType + "." + scheduleName);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (BaseException be) {
                BaseLogger.log("0", null, null, "BaseException:<ScheduleInfoEJB><getAllScheduleNameList(String owner)>" + be.getMessage());
                throw be;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception:<ScheduleInfoEJB><getAllScheduleNameList(String owner)>" + e.getMessage());
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "<ScheduleInfoEJB><getAllScheduleNameList(String owner)>End");
        return allSchNameList;
    }

    @Override
    public String getAllSchedule() throws RemoteException, BaseException {
        String allSchXmlStr = "";
        try {
            allSchXmlStr = new E12GenericUtility().readFile(this.filePath);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return allSchXmlStr;
    }

    @Override
    public void updateScheduleStatus(String scheduleId, String status, Connection remoteCon) throws RemoteException, BaseException {
        this.remoteCon = remoteCon;
        this.updateScheduleStatus(scheduleId, status, remoteCon, null);
    }

    @Override
    public void updateScheduleStatus(String scheduleId, String status, Connection remoteCon, UserInfoBean userInfo) throws RemoteException, BaseException {
        this.remoteCon = remoteCon;
        this.updateScheduleStatus(scheduleId, status, userInfo);
    }

    @Override
    public void updateLastFiredOn(String scheduleId) throws RemoteException, BaseException {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            BaseLogger.log("3", null, null, "Updating Last fired on Scehdule Id :[" + scheduleId + "]");
            ScheduleModel schModel = this.getScheduleModel(scheduleId);
            BaseLogger.log("3", null, null, "Updating Last fired on Scehdule :[" + schModel + "]");
            String lastFiredOn = "0";
            if (schModel != null) {
                lastFiredOn = schModel.getLastSchFireOn();
            }
            Long lastFired = Long.valueOf(schModel.getPropValue("LAST_SCH_FIRE_ON"));
            String interval = schModel.getPropValue("INTERVAL");
            String startDate = schModel.getPropValue("START_DATE");
            String startTime = schModel.getPropValue("START_TIME");
            String startDateTime = String.valueOf(startDate) + " " + startTime + ":00";
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mi:ss");
            java.util.Date startOfDate = df.parse(startDateTime);
            df.format(startOfDate);
            Long startDateInt = startOfDate.getTime();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(startOfDate);
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            SchedulerEJB sEJB = new SchedulerEJB();
            cal.setTime(sEJB.getNextMonth(cal.getTime(), interval));
            String startDateStr = String.valueOf(cal.get(5)) + "-" + (cal.get(2) + 1) + "-" + cal.get(1);
            String startTimeStr = String.valueOf(cal.get(11)) + ":" + cal.get(12);
            String startDateTimeStr = String.valueOf(startDateStr) + " " + startTimeStr;
            BaseLogger.log("3", null, null, "startDateTimeStr[" + startDateTimeStr + "]");
            java.util.Date startDateObj = new SimpleDateFormat("dd-MM-yyyy HH:mi").parse(startDateTimeStr);
            Long startDateNext = startDateObj.getTime();
            Long schInterval = this.getInterval(schModel.getInterval(), lastFired, startDateNext);
            if (lastFiredOn.trim().equalsIgnoreCase("0")) {
                this.updateLastFiredOnToDB(scheduleId, schInterval);
                schModel.setLastSchFireOn("" + new Timestamp(System.currentTimeMillis()).getTime());
            } else {
                this.updateLastFiredOnToDB(scheduleId, schInterval);
                long last = Long.parseLong(lastFiredOn) + schInterval;
                BaseLogger.log("3", null, null, "updateLastFiredOn : -[Setting the next timer for scheduler [ " + scheduleId + " ] on   [ " + new java.util.Date(last) + " ]]");
                schModel.setLastSchFireOn(new Long(last).toString());
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    @Override
    public String registerSchedule(String schXmlStr) throws RemoteException, BaseException {
        UserInfoBean userInfo = null;
        return this.registerSchedule(schXmlStr, userInfo);
    }

    @Override
    public String registerSchedule(String schXmlStr, UserInfoBean userInfo) throws RemoteException, BaseException {
        String registeredXmlStr = null;
        try {
            BaseLogger.log("3", null, null, "\n\n$$$$$$$$****************REGISTER SCHDULER (SINGLE PARAMETER)**********************************\n");
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document newScheduleDom = genericUtility.parseString(schXmlStr);
            Node newScheduleNode = newScheduleDom.getElementsByTagName("SCHEDULE").item(0);
            String genId = newScheduleNode.getAttributes().getNamedItem("id").getNodeValue();
            if (genId == null || "null".equalsIgnoreCase(genId) || genId.length() == 0) {
                genId = this.generateScheduleId();
                newScheduleNode.getAttributes().getNamedItem("id").setNodeValue(genId);
            }
            regSchId = genId;
            newScheduleNode.getAttributes().getNamedItem("id").setNodeValue(genId);
            ScheduleModel schModel = new ScheduleModel(newScheduleDom);
            scheduleinfoMap.put(genId, schModel);
            this.insertNewSchedule(newScheduleDom, userInfo);
            String action = "register";
            String XMLStr = schModel.toString();
            this.modifyInfo(XMLStr, action, userInfo);
            registeredXmlStr = this.getSchedulesNameAfterReg(userInfo);
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException:<ScheduleInfoEJB><registerSchedule(String schXmlStr)>" + be.getMessage());
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return registeredXmlStr;
    }

    @Override
    public String registerSchedule(String schXmlStr, String owner) throws RemoteException, BaseException {
        return this.registerSchedule(schXmlStr, owner, null);
    }

    @Override
    public String registerSchedule(String schXmlStr, String owner, UserInfoBean userInfo) throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "<ScheduleInfoEJB><registerSchedule( String schXmlStr ,String owner)>Start");
        String registeredXmlStr = null;
        String returnSchStr = "";
        try {
            BaseLogger.log("3", null, null, "\n\n$$$$$$$$****************REGISTER SCHDULER (TWO PARAMETER)**********************************\n");
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document newScheduleDom = genericUtility.parseString(schXmlStr);
            Node newScheduleNode = newScheduleDom.getElementsByTagName("SCHEDULE").item(0);
            String genId = newScheduleNode.getAttributes().getNamedItem("id").getNodeValue();
            if (genId == null || "null".equalsIgnoreCase(genId) || genId.length() <= 0) {
                genId = this.generateScheduleId();
                newScheduleNode.getAttributes().getNamedItem("id").setNodeValue(genId);
            }
            regSchId = genId;
            ScheduleModel schModel = new ScheduleModel(newScheduleDom);
            scheduleinfoMap.put(genId, schModel);
            registeredXmlStr = schModel.toString();
            this.insertNewSchedule(newScheduleDom, userInfo);
            String action = "register";
            this.modifyInfo(registeredXmlStr, action, userInfo);
            returnSchStr = this.getSchedulesNameAfterReg(owner, userInfo);
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException:<ScheduleInfoEJB><getAllSchedule( String schXmlStr ,String owner)>" + be.getMessage());
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:<ScheduleInfoEJB><registerSchedule( String schXmlStr ,String owner)>" + e.getMessage());
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "<ScheduleInfoEJB><registerSchedule( String schXmlStr ,String owner)>End" + returnSchStr);
        return returnSchStr;
    }

    @Override
    public String updateSchedule(String scheduleId, String schXmlStr) throws RemoteException, Exception {
        return this.updateSchedule(scheduleId, schXmlStr, null);
    }

    @Override
    public String updateSchedule(String scheduleId, String schXmlStr, UserInfoBean userInfo) throws RemoteException, Exception {
        BaseLogger.log("3", null, null, "Inside updateSchedule..START");
        String updatedSchMdlStr = null;
        try {
            BaseLogger.log("3", null, null, "\n\n***************UPDATE SCHEDULER***********************************\n\n");
            E12GenericUtility genericUtility = new E12GenericUtility();
            ScheduleModel schModel = new ScheduleModel(schXmlStr);
            schModel.setLastSchFireOn(this.getLastFiredOn(scheduleId, userInfo));
            scheduleinfoMap.put(scheduleId, schModel);
            updatedSchMdlStr = schModel.toString();
            String action = "update";
            ScheduleModel schModelDB = (ScheduleModel)scheduleinfoMap.get(scheduleId);
            String changedXmlStr = schModelDB.toString();
            this.modifyInfo(changedXmlStr, action, userInfo);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return updatedSchMdlStr;
    }

    @Override
    public String deleteSchedule(String scheduleId) throws RemoteException, BaseException {
        UserInfoBean userInfo = null;
        return this.deleteSchedule(scheduleId, userInfo);
    }

    @Override
    public String deleteSchedule(String scheduleId, UserInfoBean userInfo) throws RemoteException, BaseException {
        String schAfterDelete = null;
        try {
            BaseLogger.log("3", null, null, "\n\n******************DELETE SCHEDULE (ONE PARAMETER)********************************\n\n");
            scheduleinfoMap.remove(scheduleId);
            this.deleteScheduleFromDB(scheduleId, userInfo);
            schAfterDelete = this.getSchedulesNameAfterReg(userInfo);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schAfterDelete;
    }

    @Override
    public String deleteSchedule(String scheduleId, String owner) throws RemoteException, BaseException {
        return this.deleteSchedule(scheduleId, owner, null);
    }

    @Override
    public String deleteSchedule(String scheduleId, String owner, UserInfoBean userInfo) throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "<ScheduleInfoEJB><deleteSchedule(String scheduleId, String owner )>Start");
        String schAfterDelete = null;
        try {
            BaseLogger.log("3", null, null, "\n\n$$$$$$$$$$**************DELETE SCHEDULE(TWO PARAMETER)************************************");
            scheduleinfoMap.remove(scheduleId);
            this.deleteScheduleFromDB(scheduleId, userInfo);
            schAfterDelete = this.getSchedulesNameAfterReg(owner, userInfo);
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException:<ScheduleInfoEJB><deleteSchedule(String scheduleId, String owner )>" + be.getMessage());
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:<ScheduleInfoEJB><deleteSchedule(String scheduleId, String owner )>" + e.getMessage());
            throw new BaseException(e);
        }
        BaseLogger.log("2", null, null, "<ScheduleInfoEJB><deleteSchedule(String scheduleId, String owner )>End");
        return schAfterDelete;
    }

    private String getSchedulesNameAfterReg() throws Exception {
        UserInfoBean userInfo = null;
        return this.getSchedulesNameAfterReg(userInfo);
    }

    private String getSchedulesNameAfterReg(UserInfoBean userInfo) throws Exception {
        ArrayList schNameLstAfterRegis = new ArrayList();
        String allSchNameAterReg = "";
        boolean checkschName = false;
        String schIdfrmHash2 = "";
        String schType = "";
        try {
            schNameLstAfterRegis = this.getAllScheduleNameList(userInfo);
            int schNameCtr = 0;
            while (schNameCtr < schNameLstAfterRegis.size()) {
                allSchNameAterReg = String.valueOf(allSchNameAterReg) + schNameLstAfterRegis.get(schNameCtr);
                allSchNameAterReg = String.valueOf(allSchNameAterReg) + ",";
                ++schNameCtr;
            }
            String scheduleId = "";
            Set allSchKey = scheduleinfoMap.keySet();
            for (String schIdfrmHash2 : allSchKey) {
                int schNameLstAfterRegisCtr = 0;
                while (schNameLstAfterRegisCtr < schNameLstAfterRegis.size()) {
                    int indexOfSep;
                    String scheduleIdStr = (String)schNameLstAfterRegis.get(schNameLstAfterRegisCtr);
                    scheduleId = scheduleIdStr.substring(0, indexOfSep = scheduleIdStr.indexOf("~"));
                    if (scheduleId.equals(schIdfrmHash2)) {
                        checkschName = true;
                    }
                    ++schNameLstAfterRegisCtr;
                }
                if (!checkschName) {
                    checkschName = false;
                    String schMdlStr = "";
                    allSchNameAterReg = String.valueOf(allSchNameAterReg) + schIdfrmHash2;
                    allSchNameAterReg = String.valueOf(allSchNameAterReg) + "~";
                    ScheduleModel schMdl = (ScheduleModel)scheduleinfoMap.get(schIdfrmHash2);
                    System.out.println("schMdl ::: " + schMdl);
                    Document scheduleDom = null;
                    if (schMdl != null) {
                        schMdlStr = schMdl.toString();
                    }
                    System.out.println("schMdlStr ::: " + schMdlStr);
                    if (schMdlStr != null) {
                        scheduleDom = new E12GenericUtility().parseString(schMdlStr);
                    }
                    System.out.println("scheduleDom ::: " + scheduleDom);
                    if (scheduleDom != null) {
                        schType = scheduleDom.getElementsByTagName("SCHEDULE").item(0).getAttributes().getNamedItem("schtype").getNodeValue();
                    }
                    if (scheduleDom.getElementsByTagName("NAME").item(0) != null) {
                        allSchNameAterReg = String.valueOf(allSchNameAterReg) + schType + "." + scheduleDom.getElementsByTagName("NAME").item(0).getFirstChild().getNodeValue();
                        allSchNameAterReg = String.valueOf(allSchNameAterReg) + ",";
                    }
                }
                checkschName = false;
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return allSchNameAterReg;
    }

    @Override
    public String getSchedulesNameAfterReg(String owner) throws RemoteException, BaseException {
        return this.getSchedulesNameAfterReg(owner, null);
    }

    @Override
    public String getSchedulesNameAfterReg(String owner, UserInfoBean userInfo) throws RemoteException, BaseException {
        ArrayList schNameLstAfterRegis = new ArrayList();
        String allSchNameAterReg = "";
        try {
            String filePath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "ScheduleProperties.xml";
            int userLevel = this.getUserLevel(owner, userInfo);
            if (userLevel == 0) {
                schNameLstAfterRegis = this.getAllScheduleNameList(filePath, userInfo);
                int schNameCtr = 0;
                while (schNameCtr < schNameLstAfterRegis.size()) {
                    String schString = (String)schNameLstAfterRegis.get(schNameCtr);
                    String schUserName = null;
                    if (schString.indexOf("@") != -1) {
                        schUserName = schString.substring(0, schString.indexOf("@"));
                    }
                    if (schUserName != null && schUserName.equals(owner)) {
                        schString = schString.replaceAll("OTHER.", "");
                    }
                    allSchNameAterReg = String.valueOf(allSchNameAterReg) + schString;
                    allSchNameAterReg = String.valueOf(allSchNameAterReg) + ",";
                    ++schNameCtr;
                }
            } else {
                schNameLstAfterRegis = this.getUserDefScheduleNameList(owner, userInfo);
                int schNameCtr = 0;
                while (schNameCtr < schNameLstAfterRegis.size()) {
                    allSchNameAterReg = String.valueOf(allSchNameAterReg) + schNameLstAfterRegis.get(schNameCtr);
                    allSchNameAterReg = String.valueOf(allSchNameAterReg) + ",";
                    ++schNameCtr;
                }
            }
            BaseLogger.log("3", null, null, "ScheduleInfoEJB::getSchedulesNameAfterReg:: schNameLstAfterRegis:: " + schNameLstAfterRegis);
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return allSchNameAterReg;
    }

    private String generateScheduleId() throws BaseException {
        String genId = "";
        try {
            int randInt = new Random().nextInt();
            genId = "sch" + randInt;
            if (scheduleinfoMap.containsKey(genId)) {
                randInt = new Random().nextInt();
                genId = "sch" + randInt;
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return genId;
    }

    @Override
    public ScheduleModel parseForSchedule(String scheduleId) throws RemoteException, BaseException {
        ScheduleModel schModel = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String schXMLString = this.getScheduledFromDB(scheduleId);
            BaseLogger.log("3", null, null, "schXMLString inparse for schedule[" + schXMLString + "]");
            Document scheduleDom = genericUtility.parseString(schXMLString);
            NodeList scheduleList = scheduleDom.getElementsByTagName("SCHEDULE");
            int noOfSchedules = scheduleList.getLength();
            int scheduleCtr = 0;
            while (scheduleCtr <= noOfSchedules) {
                String currScheduleId;
                Node currSchedule = scheduleList.item(scheduleCtr);
                if (currSchedule != null && currSchedule.getAttributes().getNamedItem("id") != null && scheduleId.equals(currScheduleId = currSchedule.getAttributes().getNamedItem("id").getNodeValue())) {
                    schModel = new ScheduleModel(genericUtility.serializeDom(currSchedule));
                    break;
                }
                ++scheduleCtr;
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schModel;
    }

    private Node searchNode(Document dom, String scheduleId) {
        Node schNode = null;
        try {
            NodeList schNodeList = dom.getElementsByTagName("SCHEDULE");
            int ctr = 0;
            while (ctr < schNodeList.getLength()) {
                Node currSchNode = schNodeList.item(ctr);
                if (currSchNode.getAttributes().getNamedItem("id").getNodeValue().equals(scheduleId)) {
                    schNode = currSchNode;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :searchNode(dom, scheduleId) :==>\n" + e.getMessage());
        }
        return schNode;
    }

    @Override
    public String getAllSchSummary() throws RemoteException, BaseException {
        StringBuffer allSchSummaryBuff = new StringBuffer("<SCHEDULES>");
        HashMap allschfrmMap = (HashMap)scheduleinfoMap.clone();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String schXMLString = this.getAllScheduledFromDB();
            Document allScheduleDom = genericUtility.parseString(schXMLString);
            NodeList scheduleList = allScheduleDom.getElementsByTagName("SCHEDULE");
            int noOfSchdl = scheduleList.getLength();
            int schdlCtr = 0;
            while (schdlCtr < noOfSchdl) {
                Node scheduleNode = scheduleList.item(schdlCtr);
                String schId = scheduleNode.getAttributes().getNamedItem("id").getNodeValue();
                allSchSummaryBuff.append(this.parseSchedule(scheduleNode));
                if (allschfrmMap.containsKey(schId)) {
                    allschfrmMap.remove(schId);
                }
                ++schdlCtr;
            }
            Set allSchKey = allschfrmMap.keySet();
            Iterator keySetItr = allSchKey.iterator();
            while (keySetItr.hasNext()) {
                BaseLogger.log("3", null, null, "---------keySetItr.next()---" + keySetItr.next());
                ScheduleModel schModel = (ScheduleModel)allschfrmMap.get(keySetItr.next());
                Document scheduleDom = new E12GenericUtility().parseString(schModel.toString());
                Node SchNode = scheduleDom.getElementsByTagName("SCHEDULE").item(0);
                allSchSummaryBuff.append(this.parseSchedule(SchNode));
            }
            allSchSummaryBuff.append("</SCHEDULES>");
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return allSchSummaryBuff.toString();
    }

    @Override
    public String getAllSchSummary(String owner) throws RemoteException, BaseException {
        StringBuffer allSchSummaryBuff = new StringBuffer("<SCHEDULES>");
        HashMap allschfrmMap = (HashMap)scheduleinfoMap.clone();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String schXMLString = this.getAllScheduledFromDB();
            Document allScheduleDom = genericUtility.parseString(schXMLString);
            NodeList scheduleList = allScheduleDom.getElementsByTagName("SCHEDULE");
            int noOfSchdl = scheduleList.getLength();
            int schdlCtr = 0;
            while (schdlCtr < noOfSchdl) {
                Node scheduleNode = scheduleList.item(schdlCtr);
                String schId = scheduleNode.getAttributes().getNamedItem("id").getNodeValue();
                String ownerId = "";
                NodeList schldNodePropList = scheduleNode.getChildNodes();
                int schedulePropLen = schldNodePropList.getLength();
                int schedulePropCtr = 0;
                while (schedulePropCtr < schedulePropLen) {
                    Node schldPropNode = schldNodePropList.item(schedulePropCtr);
                    if (schldPropNode != null && schldPropNode.getNodeType() == 1 && "OWNER".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                        ownerId = schldPropNode.getFirstChild().getNodeValue();
                    }
                    ++schedulePropCtr;
                }
                if (ownerId.equals(owner)) {
                    allSchSummaryBuff.append(this.parseSchedule(scheduleNode));
                }
                if (allschfrmMap.containsKey(schId)) {
                    allschfrmMap.remove(schId);
                }
                ++schdlCtr;
            }
            Set allSchKey = allschfrmMap.keySet();
            Iterator keySetItr = allSchKey.iterator();
            while (keySetItr.hasNext()) {
                BaseLogger.log("3", null, null, "---------keySetItr.next()---" + keySetItr.next());
                ScheduleModel schModel = (ScheduleModel)allschfrmMap.get(keySetItr.next());
                Document scheduleDom = new E12GenericUtility().parseString(schModel.toString());
                Node SchNode = scheduleDom.getElementsByTagName("SCHEDULE").item(0);
                allSchSummaryBuff.append(this.parseSchedule(SchNode));
            }
            allSchSummaryBuff.append("</SCHEDULES>");
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return allSchSummaryBuff.toString();
    }

    private String getDate(long miliseconds) throws Exception {
        java.util.Date currDate = new java.util.Date(miliseconds);
        String currDateStr = "";
        currDateStr = "" + currDate.getDate();
        currDateStr = String.valueOf(currDateStr) + "-";
        currDateStr = String.valueOf(currDateStr) + (currDate.getMonth() + 1);
        currDateStr = String.valueOf(currDateStr) + "-";
        currDateStr = String.valueOf(currDateStr) + (1900 + currDate.getYear());
        return currDateStr;
    }

    private String parseSchedule(Node scheduleNode) throws Exception {
        StringBuffer allSchSummaryBuff = new StringBuffer();
        allSchSummaryBuff.append("<SCHEDULE id='");
        String schId = scheduleNode.getAttributes().getNamedItem("id").getNodeValue();
        if (schId != null || !"null".equalsIgnoreCase(schId) || schId.length() != 0) {
            allSchSummaryBuff.append(schId);
        }
        allSchSummaryBuff.append("'>");
        NodeList schldNodePropList = scheduleNode.getChildNodes();
        int schedulePropLen = schldNodePropList.getLength();
        int schedulePropCtr = 0;
        while (schedulePropCtr < schedulePropLen) {
            Node schldPropNode = schldNodePropList.item(schedulePropCtr);
            if (schldPropNode != null && schldPropNode.getNodeType() == 1) {
                if ("NAME".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                    allSchSummaryBuff.append("<NAME>");
                    allSchSummaryBuff.append(schldPropNode.getFirstChild().getNodeValue());
                    allSchSummaryBuff.append("</NAME>");
                }
                if ("STATUS".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                    allSchSummaryBuff.append("<STATUS>");
                    allSchSummaryBuff.append(schldPropNode.getFirstChild().getNodeValue());
                    allSchSummaryBuff.append("</STATUS>");
                }
                if ("START_DATE".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                    allSchSummaryBuff.append("<START_DATE>");
                    allSchSummaryBuff.append(schldPropNode.getFirstChild().getNodeValue());
                    allSchSummaryBuff.append("</START_DATE>");
                }
                if ("INTERVAL".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                    allSchSummaryBuff.append("<INTERVAL>");
                    allSchSummaryBuff.append(schldPropNode.getFirstChild().getNodeValue());
                    allSchSummaryBuff.append("</INTERVAL>");
                }
                if ("LAST_SCH_FIRE_ON".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                    allSchSummaryBuff.append("<LAST_SCH_FIRE_ON>");
                    String lastSchDate = schldPropNode.getFirstChild().getNodeValue();
                    if (!"null".equals(lastSchDate.trim()) && !"0".equals(lastSchDate) && lastSchDate != null) {
                        allSchSummaryBuff.append(lastSchDate);
                    } else {
                        allSchSummaryBuff.append("0");
                    }
                    allSchSummaryBuff.append("</LAST_SCH_FIRE_ON>");
                }
                if ("NEXT_DUE_DATE".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                    allSchSummaryBuff.append("<NEXT_DUE_DATE>");
                    String nextDueate = schldPropNode.getFirstChild().getNodeValue();
                    if (!"null".equals(nextDueate.trim()) && !"0".equals(nextDueate) && nextDueate != null) {
                        allSchSummaryBuff.append(nextDueate);
                    } else {
                        allSchSummaryBuff.append("0");
                    }
                    allSchSummaryBuff.append("</NEXT_DUE_DATE>");
                }
                if ("OWNER".equals(schldPropNode.getNodeName()) && schldPropNode.getFirstChild() != null) {
                    allSchSummaryBuff.append("<OWNER>");
                    allSchSummaryBuff.append(schldPropNode.getFirstChild().getNodeValue());
                    allSchSummaryBuff.append("</OWNER>");
                }
            }
            ++schedulePropCtr;
        }
        allSchSummaryBuff.append("</SCHEDULE>");
        return allSchSummaryBuff.toString();
    }

    @Override
    public String getRegSchId() throws RemoteException, BaseException {
        return regSchId;
    }

    private void insertNewSchedule(Document newScheduleDom) throws Exception {
        this.insertNewSchedule(newScheduleDom, null);
    }

    private void insertNewSchedule(Document newScheduleDom, UserInfoBean userInfo) throws Exception {
        Connection conn = null;
        Statement pstmt = null;
        String sqlQuery = "";
        try {
            try {
                String schName = null;
                String schStartDate = null;
                String schStartTime = null;
                String schLastSchFireOn = null;
                String schInterval = null;
                String schStatus = null;
                String appServerIP = this.getAppServerIPAddr();
                BaseLogger.log("3", null, null, "appServerIP =[ " + appServerIP + "]");
                Node newScheduleNode = newScheduleDom.getElementsByTagName("SCHEDULE").item(0);
                String schId = newScheduleNode.getAttributes().getNamedItem("id").getNodeValue();
                NodeList schldNodePropList = newScheduleNode.getChildNodes();
                int noOfSchldProp = schldNodePropList.getLength();
                int schldCtr = 0;
                while (schldCtr < noOfSchldProp) {
                    Node schldPropNode = schldNodePropList.item(schldCtr);
                    if (schldPropNode != null && schldPropNode.getFirstChild() != null) {
                        String schldPropName = schldPropNode.getNodeName();
                        if ("NAME".equals(schldPropName)) {
                            schName = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("START_DATE".equals(schldPropName)) {
                            schStartDate = schldPropNode.getFirstChild().getNodeValue();
                            BaseLogger.log("3", null, null, "Schedule start Date:" + schStartDate);
                        } else if ("START_TIME".equals(schldPropName)) {
                            schStartTime = schldPropNode.getFirstChild().getNodeValue();
                            BaseLogger.log("3", null, null, "Schedule StartTime:" + schStartTime);
                        } else if ("LAST_SCH_FIRE_ON".equals(schldPropName)) {
                            schLastSchFireOn = this.checkNull(schldPropNode.getFirstChild().getNodeValue());
                            BaseLogger.log("3", null, null, "schLastSchFireOn::" + schLastSchFireOn);
                        } else if ("NEXT_DUE_DATE".equals(schldPropName)) {
                            schLastSchFireOn = "0";
                        } else if ("INTERVAL".equals(schldPropName)) {
                            schInterval = schldPropNode.getFirstChild().getNodeValue();
                            BaseLogger.log("3", null, null, "schInterval ::" + schInterval);
                        } else if ("STATUS".equals(schldPropName)) {
                            schStatus = schldPropNode.getFirstChild().getNodeValue();
                            BaseLogger.log("3", null, null, "schStatus::" + schStatus);
                        }
                    }
                    ++schldCtr;
                }
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                String strDateformat = this.getDate(schStartDate);
                BaseLogger.log("3", null, null, "STARTDATEFORMAT:::" + strDateformat);
                BaseLogger.log("3", null, null, "schLastSchFireOn::" + schLastSchFireOn);
                long lastFiredOn = Long.valueOf(schLastSchFireOn);
                BaseLogger.log("3", null, null, "lastFiredOn::" + lastFiredOn);
                Timestamp st = new Timestamp(lastFiredOn);
                BaseLogger.log("3", null, null, "Last Fired Date & time" + st);
                BaseLogger.log("3", null, null, "TIMESTAMP:[" + strDateformat + " " + String.valueOf(String.valueOf(schStartTime) + ":00") + "]");
                sqlQuery = "INSERT INTO SCHEDULES (SCHEDULE_ID,DESCR,SCHEDULE_TYPE,LAST_FIRED_ON,REP_FREQ,START_DATE,END_DATE,LAST_FIRED_DATE,NEXT_DUE_DATE,APP_SERVER_IP) VALUES(?,?,?,?,?,?,?,?,?,?)";
                pstmt = conn.prepareStatement(sqlQuery);
                pstmt.setString(1, schId);
                pstmt.setString(2, schName);
                pstmt.setString(3, schStatus);
                pstmt.setString(4, schLastSchFireOn);
                pstmt.setString(5, schInterval);
                pstmt.setTimestamp(6, Timestamp.valueOf(String.valueOf(strDateformat) + " " + String.valueOf(String.valueOf(schStartTime) + ":00")));
                pstmt.setTimestamp(7, Timestamp.valueOf(String.valueOf(strDateformat) + " " + String.valueOf(String.valueOf(schStartTime) + ":00")));
                pstmt.setTimestamp(8, st);
                pstmt.setTimestamp(9, null);
                pstmt.setString(10, appServerIP);
                int result = pstmt.executeUpdate();
                if (result < 1) {
                    BaseLogger.log("3", null, null, "Scheduler Table NOT Updated :" + result);
                }
                BaseLogger.log("3", null, null, "Scheduler  Info Inserted Successfully :" + result);
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "SQL insert==>\n" + sqlQuery);
                BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :insertNewSchedule :==>\n" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void updateScheduleToDB(String scheduleId, String schXmlStr) {
        this.updateScheduleToDB(scheduleId, schXmlStr, null);
    }

    @Override
    public void updateScheduleToDB(String scheduleId, String schXmlStr, UserInfoBean userInfo) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                String schName = null;
                String schStartDate = null;
                String schStartTime = null;
                String schLastSchFireOn = null;
                String schNextDueDate = null;
                String schInterval = null;
                String schStatus = null;
                ScheduleModel schModel = new ScheduleModel(schXmlStr);
                Document scheduledDom = new E12GenericUtility().parseString(schModel.toString());
                Node scheduledNode = scheduledDom.getElementsByTagName("SCHEDULE").item(0);
                String schId = scheduledNode.getAttributes().getNamedItem("id").getNodeValue();
                NodeList schldNodePropList = scheduledNode.getChildNodes();
                int noOfSchldProp = schldNodePropList.getLength();
                int schldCtr = 0;
                while (schldCtr < noOfSchldProp) {
                    Node schldPropNode = schldNodePropList.item(schldCtr);
                    if (schldPropNode != null && schldPropNode.getFirstChild() != null) {
                        String schldPropName = schldPropNode.getNodeName();
                        if ("NAME".equals(schldPropName)) {
                            schName = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("START_DATE".equals(schldPropName)) {
                            schStartDate = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("START_TIME".equals(schldPropName)) {
                            schStartTime = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("LAST_SCH_FIRE_ON".equals(schldPropName)) {
                            schLastSchFireOn = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("NEXT_DUE_DATE".equals(schldPropName)) {
                            schNextDueDate = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("INTERVAL".equals(schldPropName)) {
                            schInterval = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("STATUS".equals(schldPropName)) {
                            schStatus = schldPropNode.getFirstChild().getNodeValue();
                        }
                    }
                    ++schldCtr;
                }
                String strDateformat = this.getDate(schStartDate);
                BaseLogger.log("3", null, null, "NAME:[" + schName + "],ID[" + schId + "],sysDate[" + schStartDate + "],StartTime[" + schStartTime + "],LAST_SCH_FIRE_ON[" + schLastSchFireOn + "],INTERVAL[" + schInterval + "],STATUS[" + schStatus + "]");
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement("UPDATE SCHEDULES SET SCHEDULE_TYPE=?,REP_FREQ=?,START_DATE=?,LAST_FIRED_ON=? WHERE SCHEDULE_ID=?");
                pstmt.setString(1, schStatus);
                pstmt.setString(2, schInterval);
                pstmt.setTimestamp(3, Timestamp.valueOf(String.valueOf(strDateformat) + " " + String.valueOf(String.valueOf(schStartTime) + ":00")));
                pstmt.setString(4, "0");
                pstmt.setString(5, schId);
                int result = pstmt.executeUpdate();
                if (result >= 1) {
                    BaseLogger.log("3", null, null, "Schedule Table Updated Successfully");
                } else {
                    BaseLogger.log("3", null, null, "Schedule Table NOT Updated ");
                    this.insertNewSchedule(scheduledDom);
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :updateScheduleToDB :==>\n" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean updateStatusToDB(String scheduleId, String status, Connection conn) {
        return this.updateStatusToDB(scheduleId, status, conn, null);
    }

    private boolean updateStatusToDB(String scheduleId, String status, Connection conn, UserInfoBean userInfo) {
        BaseLogger.log("2", null, null, "--Sachin In updateStatusToDB--[" + scheduleId + "]--status[" + status + "]");
        Statement pstmt = null;
        boolean isUpdated = false;
        boolean isRemoteConn = true;
        boolean isError = false;
        try {
            try {
                int result;
                if (conn == null) {
                    ConnDriver mConnDriver = new ConnDriver();
                    String transDB = "Driver";
                    conn = mConnDriver.getConnectDB(transDB);
                    isRemoteConn = false;
                }
                String sql = "UPDATE SCHEDULES SET SCHEDULE_TYPE='" + status + "' WHERE SCHEDULE_ID='" + scheduleId + "'";
                if ("C".equalsIgnoreCase(status)) {
                    sql = "UPDATE SCHEDULES SET SCHEDULE_TYPE='" + status + "', NEXT_DUE_DATE = NULL WHERE SCHEDULE_ID='" + scheduleId + "'";
                }
                if ((result = (pstmt = conn.prepareStatement(sql)).executeUpdate()) == 1) {
                    isUpdated = true;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                isError = true;
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :updateStatusToDB :==>\n" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null && !isRemoteConn) {
                        if (isError) {
                            conn.rollback();
                        } else {
                            conn.commit();
                        }
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && !isRemoteConn) {
                    if (isError) {
                        conn.rollback();
                    } else {
                        conn.commit();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isUpdated;
    }

    private void updateLastFiredOnToDB(String scheduleId, Long schInterval) {
        block23: {
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            long lastFiredOn = 0L;
            boolean isPresent = false;
            try {
                try {
                    String sqlQuery = "";
                    ConnDriver mConnDriver = new ConnDriver();
                    conn = mConnDriver.getConnectDB("Driver");
                    pstmt = conn.prepareStatement("SELECT LAST_FIRED_ON FROM SCHEDULES WHERE SCHEDULE_ID='" + scheduleId + "'");
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        lastFiredOn = Long.parseLong(rs.getString("LAST_FIRED_ON"));
                        isPresent = true;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (isPresent) {
                        boolean isFirstTime;
                        boolean bl = isFirstTime = String.valueOf(lastFiredOn).equalsIgnoreCase("0");
                        if (isFirstTime) {
                            String currDate = "" + new Timestamp(System.currentTimeMillis()).getTime();
                            long lastFiredOnSch = Long.valueOf(currDate);
                            Timestamp st = new Timestamp(lastFiredOnSch);
                            sqlQuery = "UPDATE SCHEDULES SET LAST_FIRED_ON = ? , LAST_FIRED_DATE=? WHERE SCHEDULE_ID = ?";
                            pstmt = conn.prepareStatement(sqlQuery);
                            pstmt.setString(1, currDate);
                            pstmt.setTimestamp(2, st);
                            pstmt.setString(3, scheduleId);
                            BaseLogger.log("3", null, null, "updateLastFiredOnToDB : - [Setting the last fired time with Current Date for scheduler [ " + scheduleId + " ] on   [ " + new java.util.Date(Long.parseLong(currDate)) + " ]]");
                        } else {
                            Long lastFiredOnL = lastFiredOn + schInterval;
                            String lastFiredOnStr = lastFiredOnL.toString();
                            Timestamp st = new Timestamp(lastFiredOnL);
                            sqlQuery = "UPDATE SCHEDULES SET LAST_FIRED_ON = ? , LAST_FIRED_DATE=? WHERE SCHEDULE_ID = ?";
                            pstmt = conn.prepareStatement(sqlQuery);
                            pstmt.setString(1, lastFiredOnStr);
                            pstmt.setTimestamp(2, st);
                            pstmt.setString(3, scheduleId);
                        }
                        BaseLogger.log("3", null, null, "LAST FIRED ON QUERY =[" + sqlQuery + "]");
                        int result = pstmt.executeUpdate();
                        if (result >= 1) {
                            BaseLogger.log("3", null, null, "Schedule Last Fired On Updated Successfully");
                        } else {
                            BaseLogger.log("3", null, null, "Schedule last Fired On NOT Updated ");
                        }
                        pstmt.close();
                        pstmt = null;
                        conn.commit();
                        break block23;
                    }
                    BaseLogger.log("3", null, null, "schedule ID of " + scheduleId + " entry not present in schedules table");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :updateLastFiredOnToDB :==>\n" + e);
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void deleteScheduleFromDB(String scheduleId) {
        this.deleteScheduleFromDB(scheduleId, null);
    }

    private void deleteScheduleFromDB(String scheduleId, UserInfoBean userInfo) {
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement("DELETE FROM SCHEDULES WHERE SCHEDULE_ID='" + scheduleId + "'");
                int result = pstmt.executeUpdate();
                if (result >= 1) {
                    BaseLogger.log("3", null, null, "Schedule DELETED Updated Successfully");
                } else {
                    BaseLogger.log("3", null, null, "Schedule NOT DELETED ");
                }
                pstmt.close();
                pstmt = null;
                pstmt = conn.prepareStatement("DELETE FROM SCHEDULES_INFO WHERE SCHEDULE_ID='" + scheduleId + "'");
                int resultSchInfo = pstmt.executeUpdate();
                if (resultSchInfo >= 1) {
                    BaseLogger.log("3", null, null, "Schedules_info DELETED Successfully");
                } else {
                    BaseLogger.log("3", null, null, "Schedules_info NOT DELETED");
                }
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :deleteScheduleToDB :==>\n" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getDate(String strDate) throws BaseException, Exception {
        String strDateformat = "";
        try {
            String strMonth;
            StringTokenizer tokens = new StringTokenizer(strDate, "-");
            String strDay = tokens.nextToken();
            if (strDay.trim().length() == 1) {
                strDay = "0" + strDay;
            }
            if ((strMonth = tokens.nextToken()).trim().length() == 1) {
                strDay = "0" + strDay;
            }
            String strYear = tokens.nextToken();
            int day = Integer.parseInt(strDay.trim());
            int month = Integer.parseInt(strMonth.trim());
            int year = Integer.parseInt(strYear.trim());
            strDateformat = month < 10 && day < 10 ? String.valueOf(year) + "-0" + month + "-0" + day : (month < 10 && day >= 10 ? String.valueOf(year) + "-0" + month + "-" + day : (month >= 10 && day < 10 ? String.valueOf(year) + "-" + month + "-0" + day : String.valueOf(year) + "-" + month + "-" + day));
            BaseLogger.log("3", null, null, "DATE FORMATE[" + strDateformat + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDateformat;
    }

    public int getUserLevel(String userID) throws Exception {
        return this.getUserLevel(userID, null);
    }

    public int getUserLevel(String userID, UserInfoBean userInfo) throws Exception {
        int userLevel = -1;
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                ConnDriver conDriver = new ConnDriver();
                String transDB = "Driver";
                conn = conDriver.getConnectDB(transDB);
                String selectUsrLevQuery = "SELECT USR_LEV FROM USERS WHERE CODE='" + userID + "'";
                pstmt = conn.prepareStatement(selectUsrLevQuery);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    userLevel = rs.getInt("USR_LEV");
                }
                rs.close();
                rs = null;
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "BaseException: CommonDBAccess: getUserLevel: ==>: User level Not Returned(Generic Exception)\n");
                throw e;
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
        BaseLogger.log("3", null, null, "getUserLevel>>>>>>>>>>>>>>>>>>>>>>>" + userLevel);
        return userLevel;
    }

    private Long getInterval(String strInterval, Long lastFiredOn, Long startDate) throws Exception {
        double interval = 0.0;
        if (Character.isDigit(strInterval.charAt(0)) || '.' == strInterval.charAt(0)) {
            BaseLogger.log("3", null, null, "-------SchedulerInfoEJB : - getInterval---" + strInterval);
            interval = Double.parseDouble(strInterval) * 1000.0 * 3600.0;
            return new Long((long)interval);
        }
        char ch = strInterval.charAt(0);
        switch (ch) {
            case 'H': {
                interval = 3600000.0;
                break;
            }
            case 'D': {
                interval = 8.64E7;
                break;
            }
            case 'W': {
                interval = 6.048E8;
                break;
            }
            case 'F': {
                interval = 1.296E9;
                break;
            }
            case 'M': {
                if (lastFiredOn == 0L) {
                    lastFiredOn = startDate;
                }
                Timestamp st = new Timestamp(lastFiredOn);
                Date dateM = new Date(st.getTime());
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                String startDateStr = sdf.format(dateM);
                int dateOfMonth = Integer.parseInt(startDateStr.substring(0, 2));
                int month = Integer.parseInt(startDateStr.substring(3, 5));
                int year = Integer.parseInt(startDateStr.substring(6, 10));
                AppConnectParm appConnect = new AppConnectParm();
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                SchedulerEJB sEJB = new SchedulerEJB();
                int nextMonthDays = sEJB.getNextMonthlyInterval(month, year);
                int monthDays = 0;
                monthDays = lastFiredOn == 0L ? sEJB.getPreviousMonthlyDays(month, year) : sEJB.getMonthlyDays(month, year);
                monthDays = sEJB.getMonthlyDays(month, year);
                if (dateOfMonth > nextMonthDays) {
                    monthDays = nextMonthDays;
                }
                interval = 86400000L * (long)monthDays;
                break;
            }
            case 'L': {
                Timestamp ts = new Timestamp(lastFiredOn);
                Date dateL = new Date(ts.getTime());
                SimpleDateFormat sdfL = new SimpleDateFormat("dd-MM-yyyy");
                String startDateStrL = sdfL.format(dateL);
                int curr_DateL = Integer.parseInt(startDateStrL.substring(0, 2));
                int monthL = Integer.parseInt(startDateStrL.substring(3, 5));
                int yearL = Integer.parseInt(startDateStrL.substring(6, 10));
                AppConnectParm appConnectL = new AppConnectParm();
                Properties pL = appConnectL.getProperty();
                InitialContext ctxL = new InitialContext(pL);
                SchedulerEJB sEJBL = new SchedulerEJB();
                int nextMonthDaysL = sEJBL.getNextMonthlyInterval(monthL, yearL);
                interval = 86400000L * (long)nextMonthDaysL;
                break;
            }
            case 'S': {
                if (lastFiredOn == 0L) {
                    lastFiredOn = startDate;
                }
                Timestamp timestamp = new Timestamp(lastFiredOn);
                Date dateF = new Date(timestamp.getTime());
                SimpleDateFormat sdfF = new SimpleDateFormat("dd-MM-yyyy");
                String startDateStrF = sdfF.format(dateF);
                int curr_DateF = Integer.parseInt(startDateStrF.substring(0, 2));
                int monthF = Integer.parseInt(startDateStrF.substring(3, 5));
                int yearF = Integer.parseInt(startDateStrF.substring(6, 10));
                AppConnectParm appConnectF = new AppConnectParm();
                Properties pF = appConnectF.getProperty();
                InitialContext ctxF = new InitialContext(pF);
                SchedulerEJB sEJBF = new SchedulerEJB();
                int nextMonthDaysF = sEJBF.getMonthlyDays(monthF, yearF);
                int data = nextMonthDaysF - curr_DateF + 1;
                interval = 86400000L * (long)(nextMonthDaysF - curr_DateF + 1);
                break;
            }
            case 'O': {
                int days = Integer.parseInt(strInterval.substring(1).trim());
                int monthDaysO = 0;
                if (lastFiredOn == 0L) {
                    lastFiredOn = startDate;
                }
                Timestamp timestamp1 = new Timestamp(lastFiredOn);
                Date dateO = new Date(timestamp1.getTime());
                SimpleDateFormat sdfO = new SimpleDateFormat("dd-MM-yyyy");
                String startDateStrO = sdfO.format(dateO);
                int curr_DateO = Integer.parseInt(startDateStrO.substring(0, 2));
                int monthO = Integer.parseInt(startDateStrO.substring(3, 5));
                int yearO = Integer.parseInt(startDateStrO.substring(6, 10));
                AppConnectParm appConnectO = new AppConnectParm();
                Properties pO = appConnectO.getProperty();
                InitialContext ctxO = new InitialContext(pO);
                SchedulerEJB sEJBO = new SchedulerEJB();
                int nextMonthDaysO = sEJBO.getMonthlyDays(monthO, yearO);
                monthDaysO = nextMonthDaysO - curr_DateO + days;
                interval = 86400000L * (long)monthDaysO;
            }
        }
        BaseLogger.log("2", null, null, "<SchedulerEJB><getInterval()>End");
        return new Long((long)interval);
    }

    private String getLastFiredOn(String schedulerId) {
        return this.getLastFiredOn(schedulerId, null);
    }

    private String getLastFiredOn(String schedulerId, UserInfoBean userInfo) {
        String lastFiredOn;
        block28: {
            Statement pstmt = null;
            Connection conn = null;
            lastFiredOn = "0";
            String query = "";
            try {
                try {
                    ConnDriver conDriver = new ConnDriver();
                    String transDB = "Driver";
                    conn = conDriver.getConnectDB(transDB);
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ("DB2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        String lastFiredDate = "";
                        String lastFiredHour = "";
                        String lastFiredMin = "";
                        query = "SELECT DATE(LAST_FIRED_DATE) LAST_FIRED_DATE, HOUR(LAST_FIRED_DATE) LAST_FIRED_HOUR, MINUTE(LAST_FIRED_DATE) LAST_FIRED_MINUTE FROM SCHEDULES WHERE SCHEDULE_ID='" + schedulerId.trim() + "'";
                        pstmt = conn.prepareStatement(query);
                        ResultSet rs = pstmt.executeQuery();
                        if (rs.next()) {
                            lastFiredDate = this.checkNull(rs.getString("LAST_FIRED_DATE"));
                            lastFiredHour = this.checkNull(rs.getString("LAST_FIRED_HOUR"));
                            lastFiredMin = this.checkNull(rs.getString("LAST_FIRED_MINUTE"));
                            lastFiredDate = genericUtility.getValidDateString(lastFiredDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                            lastFiredOn = String.valueOf(lastFiredDate) + " " + lastFiredHour + ":" + lastFiredMin;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    } else if ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        query = "SELECT DATE_FORMAT(LAST_FIRED_DATE,'%d/%m/%y %H:%i') AS LAST_FIRED_DATE FROM SCHEDULES WHERE SCHEDULE_ID='" + schedulerId.trim() + "'";
                        pstmt = conn.prepareStatement(query);
                        ResultSet rs = pstmt.executeQuery();
                        while (rs.next()) {
                            lastFiredOn = rs.getString("LAST_FIRED_DATE");
                            BaseLogger.log("3", null, null, "getLastFiredOn   [" + lastFiredOn + "]");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    } else {
                        query = "SELECT TO_CHAR(LAST_FIRED_DATE,'DD/MM/YY hh24:mi') AS LAST_FIRED_DATE FROM SCHEDULES WHERE SCHEDULE_ID='" + schedulerId.trim() + "'";
                        pstmt = conn.prepareStatement(query);
                        ResultSet rs = pstmt.executeQuery();
                        while (rs.next()) {
                            lastFiredOn = rs.getString("LAST_FIRED_DATE");
                            BaseLogger.log("3", null, null, "getLastFiredOn   [" + lastFiredOn + "]");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception trye) {
                    BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Try getLastFiredOn: ==>: n" + trye.getMessage());
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block28;
                    }
                    catch (Exception finallye) {
                        BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Finally getLastFiredOn: ==>: n" + finallye.getMessage());
                        finallye.printStackTrace();
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception finallye) {
                    BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Finally getLastFiredOn: ==>: n" + finallye.getMessage());
                    finallye.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception finallye) {
                BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Finally getLastFiredOn: ==>: n" + finallye.getMessage());
                finallye.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "lastFiredOn =[" + lastFiredOn + "]");
        return lastFiredOn;
    }

    private String getNextDueDate(String schedulerId) {
        return this.getNextDueDate(schedulerId, null);
    }

    private String getNextDueDate(String schedulerId, UserInfoBean userInfo) {
        String nextDueDate;
        block30: {
            Statement pstmt = null;
            Connection conn = null;
            nextDueDate = "Not Scheduled";
            String query = "";
            try {
                try {
                    ConnDriver conDriver = new ConnDriver();
                    String transDB = "Driver";
                    conn = conDriver.getConnectDB(transDB);
                    E12GenericUtility genericUtility = new E12GenericUtility();
                    if ("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        query = "SELECT TO_CHAR(NEXT_DUE_DATE,'DD/MM/YY hh24:mi') AS NEXT_DUE_DATE FROM SCHEDULES WHERE SCHEDULE_ID='" + schedulerId.trim() + "'";
                        pstmt = conn.prepareStatement(query);
                        ResultSet rs = pstmt.executeQuery();
                        if (rs.next()) {
                            nextDueDate = rs.getString("NEXT_DUE_DATE");
                            BaseLogger.log("3", null, null, "getNextDueDate  [" + nextDueDate + "]");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    } else if ("DB2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        String dueDate = "";
                        String dueHour = "";
                        String dueMin = "";
                        query = "SELECT DATE(NEXT_DUE_DATE) NEXT_DUE_DATE, HOUR(NEXT_DUE_DATE) NEXT_DUE_HOUR, MINUTE(NEXT_DUE_DATE) NEXT_DUE_MINUTE FROM SCHEDULES WHERE SCHEDULE_ID='" + schedulerId.trim() + "'";
                        pstmt = conn.prepareStatement(query);
                        ResultSet rs = pstmt.executeQuery();
                        if (rs.next()) {
                            dueDate = this.checkNull(rs.getString("NEXT_DUE_DATE"));
                            dueHour = this.checkNull(rs.getString("NEXT_DUE_HOUR"));
                            dueMin = this.checkNull(rs.getString("NEXT_DUE_MINUTE"));
                            dueDate = genericUtility.getValidDateString(dueDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                            nextDueDate = String.valueOf(dueDate) + " " + dueHour + ":" + dueMin;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    } else if ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                        query = "SELECT DATE_FORMAT(NEXT_DUE_DATE,'%d/%m/%y %H:%i') AS NEXT_DUE_DATE FROM SCHEDULES WHERE SCHEDULE_ID='" + schedulerId.trim() + "'";
                        pstmt = conn.prepareStatement(query);
                        ResultSet rs = pstmt.executeQuery();
                        if (rs.next()) {
                            nextDueDate = rs.getString("NEXT_DUE_DATE");
                            BaseLogger.log("3", null, null, "getNextDueDate  [" + nextDueDate + "]");
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                    }
                    if (nextDueDate == null) {
                        nextDueDate = "Not Scheduled";
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception trye) {
                    BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Try getLastFiredOn: ==>: n" + trye.getMessage());
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block30;
                    }
                    catch (Exception finallye) {
                        BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Finally getLastFiredOn: ==>: n" + finallye.getMessage());
                        finallye.printStackTrace();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception finallye) {
                    BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Finally getLastFiredOn: ==>: n" + finallye.getMessage());
                    finallye.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception finallye) {
                BaseLogger.log("0", null, null, "BaseException: ScheduleInfoEJB: Finally getLastFiredOn: ==>: n" + finallye.getMessage());
                finallye.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "nextDueDate =[" + nextDueDate + "]");
        return nextDueDate;
    }

    @Override
    public String automateSchedule(String schXmlStr, String owner) throws RemoteException, BaseException {
        String registeredXmlStr = null;
        try {
            BaseLogger.log("3", null, null, "\n\n$$$$$$$$****************AUTOMATING SCHDULER (SINGLE PARAMETER)**********************************\n");
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document regSchDom = genericUtility.parseString(schXmlStr);
            Node regSheduleNode = regSchDom.getElementsByTagName("SCHEDULE").item(0);
            String genId = regSheduleNode.getAttributes().getNamedItem("id").getNodeValue();
            if (genId == null || "null".equalsIgnoreCase(genId) || genId.length() == 0) {
                genId = this.generateScheduleId();
                regSheduleNode.getAttributes().getNamedItem("id").setNodeValue(genId);
            }
            regSchId = genId;
            regSheduleNode.getAttributes().getNamedItem("id").setNodeValue(genId);
            ScheduleModel schModel = new ScheduleModel(regSchDom);
            scheduleinfoMap.put(genId, schModel);
            if (this.checkScheduleExist(genId)) {
                BaseLogger.log("3", null, null, "Inside automateSchedule:saveScheduleToDB");
                this.saveScheduleToDB("update", regSchDom);
            } else {
                BaseLogger.log("3", null, null, "Inside automateSchedule:saveScheduleToDB");
                this.saveScheduleToDB("insert", regSchDom);
            }
            registeredXmlStr = owner != null && owner.trim().length() > 0 ? this.getSchedulesNameAfterReg(owner) : this.getSchedulesNameAfterReg();
            if (registeredXmlStr == null) {
                registeredXmlStr = "getSchedulesNameAfterReg not returned Value";
            }
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException:<ScheduleInfoEJB><registerSchedule(String schXmlStr)>" + be.getMessage());
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return registeredXmlStr;
    }

    private boolean checkScheduleExist(String schId) throws Exception {
        boolean isSchExist;
        block23: {
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            isSchExist = false;
            try {
                try {
                    ConnDriver mConnDriver = new ConnDriver();
                    conn = mConnDriver.getConnectDB("Driver");
                    String sqlQuery = "SELECT SCHEDULE_ID FROM SCHEDULES WHERE SCHEDULE_ID = '" + schId + "'";
                    stmt = conn.prepareStatement(sqlQuery);
                    rs = stmt.executeQuery(sqlQuery);
                    if (rs.next()) {
                        isSchExist = true;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :checkScheduleExist :==>\n" + e);
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block23;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "isSchExist [" + isSchExist + "]");
        return isSchExist;
    }

    private void saveScheduleToDB(String action, Document regSchDom) throws Exception {
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                String schName = null;
                String schStartDate = null;
                String schStartTime = null;
                String schLastSchFireOn = null;
                String schNextDueDate = null;
                String schInterval = null;
                String schStatus = null;
                String appServerIP = this.getAppServerIPAddr();
                Node regSchNode = regSchDom.getElementsByTagName("SCHEDULE").item(0);
                String schId = regSchNode.getAttributes().getNamedItem("id").getNodeValue();
                NodeList schldNodePropList = regSchNode.getChildNodes();
                int noOfSchldProp = schldNodePropList.getLength();
                int schldCtr = 0;
                while (schldCtr < noOfSchldProp) {
                    Node schldPropNode = schldNodePropList.item(schldCtr);
                    if (schldPropNode != null && schldPropNode.getFirstChild() != null) {
                        String schldPropName = schldPropNode.getNodeName();
                        if ("NAME".equals(schldPropName)) {
                            schName = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("START_DATE".equals(schldPropName)) {
                            schStartDate = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("START_TIME".equals(schldPropName)) {
                            schStartTime = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("LAST_SCH_FIRE_ON".equals(schldPropName)) {
                            schLastSchFireOn = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("NEXT_DUE_DATE".equals(schldPropName)) {
                            schNextDueDate = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("INTERVAL".equals(schldPropName)) {
                            schInterval = schldPropNode.getFirstChild().getNodeValue();
                        } else if ("STATUS".equals(schldPropName)) {
                            schStatus = schldPropNode.getFirstChild().getNodeValue();
                        }
                    }
                    ++schldCtr;
                }
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB("Driver");
                String strDateformat = this.getDate(schStartDate);
                BaseLogger.log("3", null, null, "TIMESTAMP:[" + strDateformat + " " + String.valueOf(String.valueOf(schStartTime) + ":00") + "]");
                String sqlQuery = null;
                if (action.equals("insert")) {
                    long lastFiredOn = Long.valueOf(schLastSchFireOn);
                    Timestamp st = new Timestamp(lastFiredOn);
                    BaseLogger.log("3", null, null, "Last Fired Date & time" + st);
                    sqlQuery = "INSERT INTO SCHEDULES (SCHEDULE_ID,DESCR,SCHEDULE_TYPE,LAST_FIRED_ON,REP_FREQ,START_DATE,END_DATE,LAST_FIRED_DATE,NEXT_DUE_DATE,APP_SERVER_IP) VALUES(?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(sqlQuery);
                    pstmt.setString(1, schId);
                    pstmt.setString(2, schName);
                    pstmt.setString(3, schStatus);
                    pstmt.setString(4, schLastSchFireOn);
                    pstmt.setString(5, schInterval);
                    pstmt.setTimestamp(6, Timestamp.valueOf(String.valueOf(strDateformat) + " " + String.valueOf(String.valueOf(schStartTime) + ":00")));
                    pstmt.setTimestamp(7, Timestamp.valueOf(String.valueOf(strDateformat) + " " + String.valueOf(String.valueOf(schStartTime) + ":00")));
                    pstmt.setTimestamp(8, st);
                    pstmt.setTimestamp(9, null);
                    pstmt.setString(10, appServerIP);
                    int result = pstmt.executeUpdate();
                    if (result < 1) {
                        BaseLogger.log("3", null, null, "Scheduler Table NOT Updated :" + result);
                    }
                } else if (action.equals("update")) {
                    long lastFiredOn = Long.valueOf(schLastSchFireOn);
                    Timestamp st = new Timestamp(lastFiredOn);
                    sqlQuery = "UPDATE SCHEDULES SET LAST_FIRED_ON = ? , LAST_FIRED_DATE=? WHERE SCHEDULE_ID = ? AND APP_SERVER_IP = ?";
                    pstmt = conn.prepareStatement(sqlQuery);
                    pstmt.setString(1, schLastSchFireOn);
                    pstmt.setTimestamp(2, st);
                    pstmt.setString(3, schId);
                    pstmt.setString(4, appServerIP);
                    int result = pstmt.executeUpdate();
                    if (result < 1) {
                        BaseLogger.log("3", null, null, "Scheduler Table NOT Updated :" + result);
                    }
                }
                pstmt.close();
                pstmt = null;
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception :ScheduleInfoEJB :saveScheduleToDB :==>\n" + e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getAllScheduledFromDB() throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "Sachin getAllScheduledFromDB()--");
        String allScheduleStr = null;
        Connection conn = null;
        Statement pstmtSch = null;
        try {
            try {
                StringBuffer schBuffer = new StringBuffer("<ROOT><SCHEDULES>");
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB("Driver");
                String sqlQuery = "SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.OWNER, SI.OWNER_TYPE, SI.START_DATE, SI.START_TIME, SI.INTERVAL, SI.RUNMODE, SI.SCHEDULE_OBJ_ID, SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.USERINFO_XML, SI.ACTUALPARAMETERS, SC.DESCR, SC.SCHEDULE_TYPE, SC.LAST_FIRED_ON, SC.REP_FREQ, SC.END_DATE, SC.LAST_FIRED_DATE, SC.NEXT_DUE_DATE, SI.EXCLUDE_START_DAY, SI.EXCLUDE_START_TIME, SI.EXCLUDE_END_DAY, SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID AND SC.APP_SERVER_IP = ?";
                String appServerIP = this.getAppServerIPAddr();
                pstmtSch = conn.prepareStatement(sqlQuery);
                pstmtSch.setString(1, appServerIP);
                ResultSet rsSch = pstmtSch.executeQuery();
                while (rsSch.next()) {
                    schBuffer.append("<SCHEDULE id=\"" + this.checkNull(rsSch.getString("SCHEDULE_ID")) + "\" schtype=\"" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "\">");
                    schBuffer.append("<NAME><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_NAME")) + "]]></NAME>");
                    schBuffer.append("<SCHEDULEINFO/>");
                    schBuffer.append("<OWNER TYPE=\"" + this.checkNull(rsSch.getString("OWNER_TYPE")) + "\"><![CDATA[" + this.checkNull(rsSch.getString("OWNER")) + "]]></OWNER>");
                    schBuffer.append("<START_DATE><![CDATA[" + this.checkNull(rsSch.getString("START_DATE")) + "]]></START_DATE>");
                    schBuffer.append("<START_TIME><![CDATA[" + this.checkNull(rsSch.getString("START_TIME")) + "]]></START_TIME>");
                    schBuffer.append("<LAST_SCH_FIRE_ON><![CDATA[" + this.checkNull(rsSch.getString("LAST_FIRED_DATE")) + "]]></LAST_SCH_FIRE_ON>");
                    schBuffer.append("<NEXT_DUE_DATE><![CDATA[" + this.checkNull(rsSch.getString("NEXT_DUE_DATE")) + "]]></NEXT_DUE_DATE>");
                    schBuffer.append("<INTERVAL><![CDATA[" + this.checkNull(rsSch.getString("INTERVAL")) + "]]></INTERVAL>");
                    schBuffer.append("<SCHEDULE_SEQ><![CDATA[null]]></SCHEDULE_SEQ><EXCEPTION_TYPE><![CDATA[null]]></EXCEPTION_TYPE><CRITERIA><![CDATA[null]]></CRITERIA><DEBUG_MODE><![CDATA[null]]></DEBUG_MODE>");
                    schBuffer.append("<STATUS><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "]]></STATUS>");
                    schBuffer.append("<EXCLUDE_START_DAY><![CDATA[" + this.checkNull(rsSch.getString("EXCLUDE_START_DAY")) + "]]></EXCLUDE_START_DAY>");
                    schBuffer.append("<EXCLUDE_START_TIME><![CDATA[" + this.checkNull(rsSch.getString("EXCLUDE_START_TIME")) + "]]></EXCLUDE_START_TIME>");
                    schBuffer.append("<EXCLUDE_END_DAY><![CDATA[" + this.checkNull(rsSch.getString("EXCLUDE_END_DAY")) + "]]></EXCLUDE_END_DAY>");
                    schBuffer.append("<EXCLUDE_END_TIME><![CDATA[" + this.checkNull(rsSch.getString("EXCLUDE_END_TIME")) + "]]></EXCLUDE_END_TIME>");
                    schBuffer.append("<BUSI_EVENT><![CDATA[" + this.checkNull(rsSch.getString("BUSI_EVENT")) + "]]></BUSI_EVENT>");
                    schBuffer.append(this.checkNull(rsSch.getString("USERINFO_XML")));
                    schBuffer.append("<RUNMODE><![CDATA[" + this.checkNull(rsSch.getString("RUNMODE")) + "]]></RUNMODE>");
                    schBuffer.append("<SCHEDULE_OBJ id=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_ID")) + "\" name=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_NAME")) + "\" type=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_TYPE")) + "\">");
                    schBuffer.append(this.checkNull(rsSch.getString("ACTUALPARAMETERS")));
                    schBuffer.append("</SCHEDULE_OBJ></SCHEDULE>");
                }
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (rsSch != null) {
                    rsSch.close();
                    rsSch = null;
                }
                schBuffer.append("</SCHEDULES></ROOT>");
                allScheduleStr = schBuffer.toString();
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return allScheduleStr;
    }

    @Override
    public String getSchedulersToBeFired() throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "Sachin getSchedulersToBeFired()--");
        String allScheduleStr = null;
        Connection conn = null;
        Statement pstmtSch = null;
        String DB_NAME = "";
        String sqlQuery = "";
        try {
            try {
                BaseLogger.log("3", null, null, "calDayMap ::" + calDayMap);
                StringBuffer schBuffer = new StringBuffer("<ROOT><SCHEDULES>");
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB("Driver");
                DB_NAME = CommonConstants.DB_NAME;
                BaseLogger.log("3", null, null, "DB_NAME:" + DB_NAME);
                E12GenericUtility genericUtility = new E12GenericUtility();
                SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
                SimpleDateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
                SimpleDateFormat applDateTimeFmt = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
                Calendar calCurr = Calendar.getInstance();
                String curDateOnly = applFormat.format(calCurr.getTime());
                if ("db2".equalsIgnoreCase(DB_NAME)) {
                    sqlQuery = "SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.OWNER, SI.OWNER_TYPE, SI.START_DATE, SI.START_TIME, SI.INTERVAL, SC.APP_SERVER_IP, SI.RUNMODE, SI.SCHEDULE_OBJ_ID, SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.USERINFO_XML, SI.ACTUALPARAMETERS, SC.DESCR, SC.SCHEDULE_TYPE, SC.LAST_FIRED_ON, SC.REP_FREQ, SC.END_DATE, SC.LAST_FIRED_DATE, SC.NEXT_DUE_DATE, EXCLUDE_START_DAY, SI.EXCLUDE_START_TIME, SI.EXCLUDE_END_DAY, SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID and SC.SCHEDULE_TYPE != 'C' and NEXT_DUE_DATE <= CURRENT TIMESTAMP AND SC.APP_SERVER_IP = ?";
                    BaseLogger.log("3", null, null, "DB_NAme" + DB_NAME + "ScheduleInfoEJB:SQLQUERY:-" + sqlQuery);
                } else if ("MSSQL".equalsIgnoreCase(DB_NAME)) {
                    sqlQuery = "SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.OWNER, SI.OWNER_TYPE, SI.START_DATE, SI.START_TIME, SI.INTERVAL, SC.APP_SERVER_IP, SI.RUNMODE, SI.SCHEDULE_OBJ_ID, SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.USERINFO_XML, SI.ACTUALPARAMETERS, SC.DESCR, SC.SCHEDULE_TYPE, SC.LAST_FIRED_ON, SC.REP_FREQ, SC.END_DATE, SC.LAST_FIRED_DATE, SC.NEXT_DUE_DATE, EXCLUDE_START_DAY, SI.EXCLUDE_START_TIME, SI.EXCLUDE_END_DAY, SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID and SC.SCHEDULE_TYPE != 'C' and NEXT_DUE_DATE <= CURRENT_TIMESTAMP AND SC.APP_SERVER_IP = ?";
                    BaseLogger.log("3", null, null, "DB_NAme" + DB_NAME + "ScheduleInfoEJB:SQLQUERY:-" + sqlQuery);
                } else if (DB_NAME.equalsIgnoreCase("oracle")) {
                    sqlQuery = "SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.OWNER, SI.OWNER_TYPE, SI.START_DATE, SI.START_TIME, SI.INTERVAL, SC.APP_SERVER_IP, SI.RUNMODE, SI.SCHEDULE_OBJ_ID, SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.USERINFO_XML, SI.ACTUALPARAMETERS, SC.DESCR, SC.SCHEDULE_TYPE, SC.LAST_FIRED_ON, SC.REP_FREQ, SC.END_DATE, SC.LAST_FIRED_DATE, SC.NEXT_DUE_DATE, EXCLUDE_START_DAY, SI.EXCLUDE_START_TIME, EXCLUDE_END_DAY, SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID AND SC.SCHEDULE_TYPE != 'C'  AND SC.APP_SERVER_IP = ? AND NEXT_DUE_DATE <= ? ";
                    BaseLogger.log("3", null, null, "DB_NAme" + DB_NAME + "ScheduleInfoEJB:SQLQUERY:-" + sqlQuery);
                } else if ("mysql".equalsIgnoreCase(DB_NAME)) {
                    sqlQuery = "SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.OWNER, SI.OWNER_TYPE, SI.START_DATE, SI.START_TIME, SI.INTERVAL, SC.APP_SERVER_IP, SI.RUNMODE, SI.SCHEDULE_OBJ_ID, SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.USERINFO_XML, SI.ACTUALPARAMETERS, SC.DESCR, SC.SCHEDULE_TYPE, SC.LAST_FIRED_ON, SC.REP_FREQ, SC.END_DATE, SC.LAST_FIRED_DATE, SC.NEXT_DUE_DATE, EXCLUDE_START_DAY, SI.EXCLUDE_START_TIME, EXCLUDE_END_DAY, SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID AND SC.SCHEDULE_TYPE != 'C' and NEXT_DUE_DATE <= SYSDATE() AND SC.APP_SERVER_IP = ?";
                    BaseLogger.log("3", null, null, "DB_NAme" + DB_NAME + "ScheduleInfoEJB:SQLQUERY:-" + sqlQuery);
                }
                String appServerIP = this.getAppServerIPAddr();
                pstmtSch = conn.prepareStatement(sqlQuery);
                pstmtSch.setString(1, appServerIP);
                if (DB_NAME.equalsIgnoreCase("oracle")) {
                    String appServerDateTime = applDateTimeFmt.format(new java.util.Date());
                    String appServerDateTimeStr = genericUtility.getValidDateTimeString(appServerDateTime, genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateTimeFormat());
                    System.out.println("NEXT_SCHEDULE_DATE appServerDateTime : " + appServerDateTimeStr);
                    pstmtSch.setTimestamp(2, Timestamp.valueOf(appServerDateTimeStr));
                }
                ResultSet rsSch = pstmtSch.executeQuery();
                BaseLogger.log("3", null, null, "ScheduleInfoEJB:ResultSet::" + rsSch.toString());
                while (rsSch.next()) {
                    String excStartDay = this.checkNull(rsSch.getString("EXCLUDE_START_DAY"));
                    String excStartTime = this.checkNull(rsSch.getString("EXCLUDE_START_TIME"));
                    String excEndDay = this.checkNull(rsSch.getString("EXCLUDE_END_DAY"));
                    String excEndTime = this.checkNull(rsSch.getString("EXCLUDE_END_TIME"));
                    String scheduleID = this.checkNull(rsSch.getString("SCHEDULE_ID"));
                    String schInterval = this.checkNull(rsSch.getString("INTERVAL"));
                    BaseLogger.log("3", null, null, "\nexcStartDay =[" + excStartDay + "] \nexcStartTime =[" + excStartTime + "] \nexcEndDay=[" + excEndDay + "] \nexcEndTime =[" + excEndTime + "]");
                    int hour = 0;
                    int minute = 0;
                    int startDay = 0;
                    boolean toBeInclude = true;
                    boolean toBeExclude = false;
                    boolean isTimePart = false;
                    Calendar calStart = Calendar.getInstance();
                    calStart.setTime(applFormat.parse(curDateOnly));
                    Calendar calEnd = Calendar.getInstance();
                    calEnd.setTime(applFormat.parse(curDateOnly));
                    if (excStartDay.length() > 0 && calDayMap.containsKey(excStartDay.toUpperCase())) {
                        toBeExclude = true;
                        startDay = (Integer)calDayMap.get(excStartDay.toUpperCase());
                        calStart.set(7, startDay);
                    }
                    if (excStartTime != null && excStartTime.trim().length() > 0) {
                        isTimePart = true;
                        toBeExclude = true;
                        if (excStartTime.indexOf(":") != -1) {
                            hour = Integer.parseInt(excStartTime.substring(0, excStartTime.indexOf(":")));
                            minute = Integer.parseInt(excStartTime.substring(excStartTime.indexOf(":") + 1));
                        } else {
                            hour = Integer.parseInt(excStartTime);
                            minute = 0;
                        }
                        calStart.set(11, hour);
                        calStart.set(12, minute);
                    }
                    hour = 0;
                    minute = 0;
                    int endDay = 0;
                    if (excEndDay.length() > 0 && calDayMap.containsKey(excEndDay.toUpperCase())) {
                        endDay = (Integer)calDayMap.get(excEndDay.toUpperCase());
                        if (startDay > endDay) {
                            calEnd.setTime(calStart.getTime());
                            endDay = 7 - startDay + endDay;
                            calEnd.add(5, endDay);
                        } else {
                            calEnd.set(7, endDay);
                        }
                        BaseLogger.log("3", null, null, "endDay1 =[" + endDay + "]");
                    }
                    if (excEndTime != null && excEndTime.trim().length() > 0) {
                        isTimePart = true;
                        toBeExclude = true;
                        if (excEndTime.indexOf(":") != -1) {
                            hour = Integer.parseInt(excEndTime.substring(0, excEndTime.indexOf(":")));
                            minute = Integer.parseInt(excEndTime.substring(excEndTime.indexOf(":") + 1));
                        } else {
                            hour = Integer.parseInt(excEndTime);
                            minute = 0;
                        }
                        calEnd.set(11, hour);
                        calEnd.set(12, minute);
                    }
                    String newStartDate = applDateTimeFmt.format(calStart.getTime());
                    String newEndDate = applDateTimeFmt.format(calEnd.getTime());
                    String currDate = applDateTimeFmt.format(calCurr.getTime());
                    BaseLogger.log("3", null, null, "\nnewStartDate =[" + newStartDate + "] \nnewEndDate =[" + newEndDate + "] \ncurrDate=[" + currDate + "]");
                    BaseLogger.log("3", null, null, "toBeExclude =[" + toBeExclude + "]");
                    BaseLogger.log("3", null, null, "calCurr.compareTo(calStart) =[" + calCurr.compareTo(calStart) + "]");
                    BaseLogger.log("3", null, null, "calCurr.compareTo(calEnd) =[" + calCurr.compareTo(calEnd) + "]");
                    if (toBeExclude) {
                        if (!isTimePart && calCurr.get(7) == startDay && calCurr.get(7) == endDay) {
                            toBeInclude = false;
                        } else if (calCurr.compareTo(calStart) >= 0 && calCurr.compareTo(calEnd) <= 0) {
                            toBeInclude = false;
                        }
                    } else {
                        toBeExclude = false;
                        toBeInclude = true;
                    }
                    BaseLogger.log("3", null, null, "\ntoBeInclude =[" + toBeInclude + "] \ntoBeExclude =[" + toBeExclude + "]");
                    if (toBeInclude) {
                        schBuffer.append("<SCHEDULE id=\"" + this.checkNull(rsSch.getString("SCHEDULE_ID")) + "\" schtype=\"" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "\">");
                        schBuffer.append("<NAME><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_NAME")) + "]]></NAME>");
                        schBuffer.append("<SCHEDULEINFO/>");
                        schBuffer.append("<OWNER TYPE=\"" + this.checkNull(rsSch.getString("OWNER_TYPE")) + "\"><![CDATA[" + this.checkNull(rsSch.getString("OWNER")) + "]]></OWNER>");
                        schBuffer.append("<START_DATE><![CDATA[" + this.checkNull(rsSch.getString("START_DATE")) + "]]></START_DATE>");
                        schBuffer.append("<START_TIME><![CDATA[" + this.checkNull(rsSch.getString("START_TIME")) + "]]></START_TIME>");
                        schBuffer.append("<LAST_SCH_FIRE_ON><![CDATA[" + this.checkNull(rsSch.getString("LAST_FIRED_ON")) + "]]></LAST_SCH_FIRE_ON>");
                        schBuffer.append("<NEXT_DUE_DATE><![CDATA[" + this.checkNull(rsSch.getString("NEXT_DUE_DATE")) + "]]></NEXT_DUE_DATE>");
                        schBuffer.append("<INTERVAL><![CDATA[" + this.checkNull(rsSch.getString("INTERVAL")) + "]]></INTERVAL>");
                        schBuffer.append("<SCHEDULE_SEQ><![CDATA[null]]></SCHEDULE_SEQ><EXCEPTION_TYPE><![CDATA[null]]></EXCEPTION_TYPE><CRITERIA><![CDATA[null]]></CRITERIA><DEBUG_MODE><![CDATA[null]]></DEBUG_MODE>");
                        schBuffer.append("<STATUS><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "]]></STATUS>");
                        schBuffer.append("<EXCLUDE_START_DAY><![CDATA[" + excStartDay + "]]></EXCLUDE_START_DAY>");
                        schBuffer.append("<EXCLUDE_START_TIME><![CDATA[" + excStartTime + "]]></EXCLUDE_START_TIME>");
                        schBuffer.append("<EXCLUDE_END_DAY><![CDATA[" + excEndDay + "]]></EXCLUDE_END_DAY>");
                        schBuffer.append("<EXCLUDE_END_TIME><![CDATA[" + excStartTime + "]]></EXCLUDE_END_TIME>");
                        schBuffer.append("<BUSI_EVENT><![CDATA[" + this.checkNull(rsSch.getString("BUSI_EVENT")) + "]]></BUSI_EVENT>");
                        schBuffer.append(this.checkNull(rsSch.getString("USERINFO_XML")));
                        schBuffer.append("<RUNMODE><![CDATA[" + this.checkNull(rsSch.getString("RUNMODE")) + "]]></RUNMODE>");
                        schBuffer.append("<SCHEDULE_OBJ id=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_ID")) + "\" name=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_NAME")) + "\" type=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_TYPE")) + "\">");
                        schBuffer.append(this.checkNull(rsSch.getString("ACTUALPARAMETERS")));
                        schBuffer.append("</SCHEDULE_OBJ></SCHEDULE>");
                        continue;
                    }
                    if ("W".equalsIgnoreCase(schInterval) || "F".equalsIgnoreCase(schInterval) || "M".equalsIgnoreCase(schInterval) || "L".equalsIgnoreCase(schInterval) || "S".equalsIgnoreCase(schInterval) || "O".equalsIgnoreCase(schInterval)) continue;
                    calEnd.add(12, 1);
                    String nextDueDate = applDateTimeFmt.format(calEnd.getTime());
                    String updSql = "UPDATE SCHEDULES SET NEXT_DUE_DATE = ? WHERE SCHEDULE_ID = ?";
                    PreparedStatement pstmtSchUpd = conn.prepareStatement(updSql);
                    pstmtSchUpd.setTimestamp(1, Timestamp.valueOf(genericUtility.getValidDateTimeString(nextDueDate, genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateTimeFormat())));
                    pstmtSchUpd.setString(2, scheduleID);
                    int updCnt = pstmtSchUpd.executeUpdate();
                    if (updCnt <= 0) continue;
                    BaseLogger.log("3", null, null, "updCnt = [" + updCnt + "]");
                    conn.commit();
                }
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (rsSch != null) {
                    rsSch.close();
                    rsSch = null;
                }
                schBuffer.append("</SCHEDULES></ROOT>");
                allScheduleStr = schBuffer.toString();
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "Exception Due to ExecuteQuery()-");
                e.printStackTrace();
            }
        }
        return allScheduleStr;
    }

    @Override
    public String getScheduledFromDB(String schID) throws RemoteException, BaseException {
        Connection conn = null;
        Statement pstmtSch = null;
        String scheduleStr = null;
        try {
            try {
                BaseLogger.log("3", null, null, "ScheduleInfoEJB >> getScheduledFromDB is called.........");
                StringBuffer schBuffer = new StringBuffer("<ROOT><SCHEDULES>");
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB("Driver");
                E12GenericUtility genericUtility = new E12GenericUtility();
                SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
                SimpleDateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
                SimpleDateFormat applDateTimeFmt = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
                Calendar calCurr = Calendar.getInstance();
                String curDateOnly = applFormat.format(calCurr.getTime());
                String appServerIP = this.getAppServerIPAddr();
                BaseLogger.log("3", null, null, "appServerIP getScheduledFromDB 1  =[ " + appServerIP + "]");
                String sqlQuery = "SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.OWNER, SI.OWNER_TYPE, SI.START_DATE, SI.START_TIME, SI.INTERVAL, SI.RUNMODE, SI.SCHEDULE_OBJ_ID, SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.USERINFO_XML, SI.ACTUALPARAMETERS, SC.DESCR, SC.SCHEDULE_TYPE, SC.LAST_FIRED_ON, SC.REP_FREQ, SC.END_DATE, SC.LAST_FIRED_DATE, SC.NEXT_DUE_DATE, SI.EXCLUDE_START_DAY, SI.EXCLUDE_START_TIME, SI.EXCLUDE_END_DAY, SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID AND SC.SCHEDULE_ID = '" + schID + "' ";
                pstmtSch = conn.prepareStatement(sqlQuery);
                ResultSet rsSch = pstmtSch.executeQuery();
                if (rsSch.next()) {
                    String excStartDay = this.checkNull(rsSch.getString("EXCLUDE_START_DAY"));
                    String excStartTime = this.checkNull(rsSch.getString("EXCLUDE_START_TIME"));
                    String excEndDay = this.checkNull(rsSch.getString("EXCLUDE_END_DAY"));
                    String excEndTime = this.checkNull(rsSch.getString("EXCLUDE_END_TIME"));
                    BaseLogger.log("3", null, null, "\nexcStartDay =[" + excStartDay + "] \nexcStartTime =[" + excStartTime + "] \nexcEndDay=[" + excEndDay + "] \nexcEndTime =[" + excEndTime + "]");
                    int hour = 0;
                    int minute = 0;
                    int startDay = 0;
                    boolean toBeInclude = true;
                    boolean toBeExclude = false;
                    boolean isTimePart = false;
                    Calendar calStart = Calendar.getInstance();
                    calStart.setTime(applFormat.parse(curDateOnly));
                    Calendar calEnd = Calendar.getInstance();
                    calEnd.setTime(applFormat.parse(curDateOnly));
                    if (excStartDay.length() > 0 && calDayMap.containsKey(excStartDay.toUpperCase())) {
                        toBeExclude = true;
                        startDay = (Integer)calDayMap.get(excStartDay.toUpperCase());
                        calStart.set(7, startDay);
                    }
                    if (excStartTime != null && excStartTime.trim().length() > 0) {
                        isTimePart = true;
                        toBeExclude = true;
                        if (excStartTime.indexOf(":") != -1) {
                            hour = Integer.parseInt(excStartTime.substring(0, excStartTime.indexOf(":")));
                            minute = Integer.parseInt(excStartTime.substring(excStartTime.indexOf(":") + 1));
                        } else {
                            hour = Integer.parseInt(excStartTime);
                            minute = 0;
                        }
                        calStart.set(11, hour);
                        calStart.set(12, minute);
                    }
                    hour = 0;
                    minute = 0;
                    int endDay = 0;
                    if (excEndDay.length() > 0 && calDayMap.containsKey(excEndDay.toUpperCase())) {
                        endDay = (Integer)calDayMap.get(excEndDay.toUpperCase());
                        if (startDay > endDay) {
                            calEnd.setTime(calStart.getTime());
                            endDay = 7 - startDay + endDay;
                            calEnd.add(5, endDay);
                        } else {
                            calEnd.set(7, endDay);
                        }
                        BaseLogger.log("3", null, null, "endDay1 =[" + endDay + "]");
                    }
                    if (excEndTime != null && excEndTime.trim().length() > 0) {
                        isTimePart = true;
                        toBeExclude = true;
                        if (excEndTime.indexOf(":") != -1) {
                            hour = Integer.parseInt(excEndTime.substring(0, excEndTime.indexOf(":")));
                            minute = Integer.parseInt(excEndTime.substring(excEndTime.indexOf(":") + 1));
                        } else {
                            hour = Integer.parseInt(excEndTime);
                            minute = 0;
                        }
                        calEnd.set(11, hour);
                        calEnd.set(12, minute);
                    }
                    String newStartDate = applDateTimeFmt.format(calStart.getTime());
                    String newEndDate = applDateTimeFmt.format(calEnd.getTime());
                    String currDate = applDateTimeFmt.format(calCurr.getTime());
                    BaseLogger.log("3", null, null, "\nnewStartDate =[" + newStartDate + "] \nnewEndDate =[" + newEndDate + "] \ncurrDate=[" + currDate + "]");
                    BaseLogger.log("3", null, null, "toBeExclude =[" + toBeExclude + "]");
                    BaseLogger.log("3", null, null, "calCurr.compareTo(calStart) =[" + calCurr.compareTo(calStart) + "]");
                    BaseLogger.log("3", null, null, "calCurr.compareTo(calEnd) =[" + calCurr.compareTo(calEnd) + "]");
                    if (toBeExclude) {
                        if (!isTimePart && calCurr.get(7) == startDay && calCurr.get(7) == endDay) {
                            toBeInclude = false;
                        } else if (calCurr.compareTo(calStart) >= 0 && calCurr.compareTo(calEnd) <= 0) {
                            toBeInclude = false;
                        }
                    } else {
                        toBeExclude = false;
                        toBeInclude = true;
                    }
                    BaseLogger.log("3", null, null, "\ntoBeInclude =[" + toBeInclude + "] \ntoBeExclude =[" + toBeExclude + "]");
                    if (toBeInclude) {
                        schBuffer.append("<SCHEDULE id=\"" + this.checkNull(rsSch.getString("SCHEDULE_ID")) + "\" schtype=\"" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "\">");
                        schBuffer.append("<NAME><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_NAME")) + "]]></NAME>");
                        schBuffer.append("<SCHEDULEINFO/>");
                        schBuffer.append("<OWNER TYPE=\"" + this.checkNull(rsSch.getString("OWNER_TYPE")) + "\"><![CDATA[" + this.checkNull(rsSch.getString("OWNER")) + "]]></OWNER>");
                        schBuffer.append("<START_DATE><![CDATA[" + this.checkNull(rsSch.getString("START_DATE")) + "]]></START_DATE>");
                        schBuffer.append("<START_TIME><![CDATA[" + this.checkNull(rsSch.getString("START_TIME")) + "]]></START_TIME>");
                        schBuffer.append("<LAST_SCH_FIRE_ON><![CDATA[" + this.checkNull(rsSch.getString("LAST_FIRED_ON")) + "]]></LAST_SCH_FIRE_ON>");
                        schBuffer.append("<NEXT_DUE_DATE><![CDATA[" + this.checkNull(rsSch.getString("NEXT_DUE_DATE")) + "]]></NEXT_DUE_DATE>");
                        schBuffer.append("<INTERVAL><![CDATA[" + this.checkNull(rsSch.getString("INTERVAL")) + "]]></INTERVAL>");
                        schBuffer.append("<SCHEDULE_SEQ><![CDATA[null]]></SCHEDULE_SEQ><EXCEPTION_TYPE><![CDATA[null]]></EXCEPTION_TYPE><CRITERIA><![CDATA[null]]></CRITERIA><DEBUG_MODE><![CDATA[null]]></DEBUG_MODE>");
                        schBuffer.append("<STATUS><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "]]></STATUS>");
                        schBuffer.append("<EXCLUDE_START_DAY><![CDATA[" + excStartDay + "]]></EXCLUDE_START_DAY>");
                        schBuffer.append("<EXCLUDE_START_TIME><![CDATA[" + excStartTime + "]]></EXCLUDE_START_TIME>");
                        schBuffer.append("<EXCLUDE_END_DAY><![CDATA[" + excEndDay + "]]></EXCLUDE_END_DAY>");
                        schBuffer.append("<EXCLUDE_END_TIME><![CDATA[" + excStartTime + "]]></EXCLUDE_END_TIME>");
                        schBuffer.append("<BUSI_EVENT><![CDATA[" + this.checkNull(rsSch.getString("BUSI_EVENT")) + "]]></BUSI_EVENT>");
                        schBuffer.append(this.checkNull(rsSch.getString("USERINFO_XML")));
                        schBuffer.append("<RUNMODE><![CDATA[" + this.checkNull(rsSch.getString("RUNMODE")) + "]]></RUNMODE>");
                        schBuffer.append("<SCHEDULE_OBJ id=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_ID")) + "\" name=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_NAME")) + "\" type=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_TYPE")) + "\">");
                        schBuffer.append(this.checkNull(rsSch.getString("ACTUALPARAMETERS")));
                        schBuffer.append("</SCHEDULE_OBJ></SCHEDULE>");
                    }
                }
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (rsSch != null) {
                    rsSch.close();
                    rsSch = null;
                }
                schBuffer.append("</SCHEDULES></ROOT>");
                scheduleStr = schBuffer.toString();
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scheduleStr;
    }

    public void modifyInfo(String schXMLString, String action) throws RemoteException, BaseException {
        this.modifyInfo(schXMLString, action, null);
    }

    public void modifyInfo(String schXMLString, String action, UserInfoBean userInfo) throws RemoteException, BaseException {
        Connection conn = null;
        Statement pstmt = null;
        try {
            try {
                int schCount = 0;
                int totalChldSch = 0;
                Node schNode = null;
                Node schChildNode = null;
                NodeList schChildList = null;
                StringBuffer schBuffer = new StringBuffer("<ROOT><SCHEDULES>");
                String schString = null;
                String updateSQL = null;
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                String appServerIP = this.getAppServerIPAddr();
                schBuffer.append(schXMLString);
                schBuffer.append("</SCHEDULES></ROOT>");
                schString = schBuffer.toString();
                E12GenericUtility genericUtility = new E12GenericUtility();
                Document schDoc = genericUtility.parseString(schString);
                NodeList schNodeList = schDoc.getElementsByTagName("SCHEDULES").item(0).getChildNodes();
                schCount = schNodeList.getLength();
                int cntr = 0;
                while (cntr < schCount) {
                    int userInfoStart = 0;
                    int userInfoEnd = 0;
                    int actParmStart = 0;
                    int actParmEnd = 0;
                    String schName = null;
                    String ownerType = null;
                    String owner = null;
                    String startDateStr = null;
                    String startTimeStr = null;
                    String interval = null;
                    String runMode = null;
                    String schObjID = null;
                    String schObjName = null;
                    String schObjType = null;
                    String userInfoXML = null;
                    String actParmXML = null;
                    String excludeStartDay = null;
                    String excludeEndDay = null;
                    String excludeStartTime = null;
                    String excludeEndTime = null;
                    String businessEvent = null;
                    String enterprise = userInfo.getEnterprise();
                    schNode = schNodeList.item(cntr);
                    String schID = schNode.getAttributes().getNamedItem("id").getNodeValue();
                    String schType = schNode.getAttributes().getNamedItem("schtype").getNodeValue();
                    StringWriter sw = new StringWriter();
                    StreamResult result = new StreamResult(sw);
                    DOMSource source = new DOMSource(schNode);
                    Transformer t = TransformerFactory.newInstance().newTransformer();
                    t.transform(source, result);
                    String schNodeStr = sw.toString();
                    if (schNodeStr.indexOf("<USERINFOXML>") != -1) {
                        userInfoStart = schNodeStr.indexOf("<USERINFOXML>");
                        userInfoEnd = schNodeStr.lastIndexOf("</USERINFOXML>");
                        userInfoXML = schNodeStr.substring(userInfoStart, userInfoEnd + "</USERINFOXML>".length());
                    } else {
                        userInfoXML = "<USERINFOXML/>";
                    }
                    if (schNodeStr.indexOf("<ACTUALPARAMETERS>") != -1) {
                        actParmStart = schNodeStr.indexOf("<ACTUALPARAMETERS>");
                        actParmEnd = schNodeStr.lastIndexOf("</ACTUALPARAMETERS>");
                        actParmXML = schNodeStr.substring(actParmStart, actParmEnd + "</ACTUALPARAMETERS>".length());
                    } else {
                        actParmXML = "<ACTUALPARAMETERS/>";
                    }
                    schChildList = schNode.getChildNodes();
                    totalChldSch = schChildList.getLength();
                    int childCntr = 0;
                    while (childCntr < totalChldSch) {
                        schChildNode = schChildList.item(childCntr);
                        if (schChildNode.getNodeName().equalsIgnoreCase("NAME")) {
                            schName = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("OWNER")) {
                            ownerType = schChildNode.getAttributes().getNamedItem("TYPE").getNodeValue();
                            owner = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("START_DATE")) {
                            startDateStr = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("START_TIME")) {
                            startTimeStr = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("INTERVAL")) {
                            interval = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("EXCLUDE_START_DAY") && schChildNode.getFirstChild() != null) {
                            excludeStartDay = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("EXCLUDE_END_DAY") && schChildNode.getFirstChild() != null) {
                            excludeEndDay = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("EXCLUDE_START_TIME") && schChildNode.getFirstChild() != null) {
                            excludeStartTime = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("EXCLUDE_END_TIME") && schChildNode.getFirstChild() != null) {
                            excludeEndTime = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("RUNMODE") && schChildNode.getFirstChild() != null) {
                            runMode = schChildNode.getFirstChild().getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("SCHEDULE_OBJ")) {
                            schObjID = schChildNode.getAttributes().getNamedItem("id").getNodeValue();
                            schObjName = schChildNode.getAttributes().getNamedItem("name").getNodeValue();
                            schObjType = schChildNode.getAttributes().getNamedItem("type").getNodeValue();
                        }
                        if (schChildNode.getNodeName().equalsIgnoreCase("BUSI_EVENT") && schChildNode.getFirstChild() != null) {
                            businessEvent = schChildNode.getFirstChild().getNodeValue();
                            System.out.println("ScheduleInfoEJB.modifyInfo() BUSI_EVENT :[" + businessEvent + "]");
                        }
                        ++childCntr;
                    }
                    BaseLogger.log("3", null, null, "excludeStartDay :: [" + excludeStartDay + "] excludeEndDay :: [" + excludeEndDay + "] excludeStartTime :: [" + excludeStartTime + "] excludeEndTime :: [" + excludeEndTime + "]");
                    if (action.equalsIgnoreCase("update")) {
                        updateSQL = "mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "UPDATE SCHEDULES_INFO SET SCHEDULE_NAME = ?,SCHEDULE_TYPE = ?,OWNER = ?,OWNER_TYPE = ?,START_DATE = ?,START_TIME = ?,`INTERVAL` = ?,RUNMODE = ?,SCHEDULE_OBJ_ID = ?,SCHEDULE_OBJ_NAME = ?,SCHEDULE_OBJ_TYPE = ?,USERINFO_XML = ?,ACTUALPARAMETERS = ? , EXCLUDE_START_DAY = ? , EXCLUDE_END_DAY = ? , EXCLUDE_START_TIME = ? , EXCLUDE_END_TIME = ?, BUSI_EVENT = ? WHERE SCHEDULE_ID = ? AND APP_SERVER_IP = ? " : "UPDATE SCHEDULES_INFO SET SCHEDULE_NAME = ?,SCHEDULE_TYPE = ?,OWNER = ?,OWNER_TYPE = ?,START_DATE = ?,START_TIME = ?,INTERVAL = ?,RUNMODE = ?,SCHEDULE_OBJ_ID = ?,SCHEDULE_OBJ_NAME = ?,SCHEDULE_OBJ_TYPE = ?,USERINFO_XML = ?,ACTUALPARAMETERS = ? , EXCLUDE_START_DAY = ? , EXCLUDE_END_DAY = ? , EXCLUDE_START_TIME = ? , EXCLUDE_END_TIME = ?, BUSI_EVENT = ? WHERE SCHEDULE_ID = ? AND APP_SERVER_IP = ? ";
                        pstmt = conn.prepareStatement(updateSQL);
                        pstmt.setString(1, schName);
                        pstmt.setString(2, schType);
                        pstmt.setString(3, owner);
                        pstmt.setString(4, ownerType);
                        pstmt.setString(5, startDateStr);
                        pstmt.setString(6, startTimeStr);
                        pstmt.setString(7, interval);
                        pstmt.setString(8, runMode);
                        pstmt.setString(9, schObjID);
                        pstmt.setString(10, schObjName);
                        pstmt.setString(11, schObjType);
                        pstmt.setString(12, userInfoXML);
                        pstmt.setString(13, actParmXML);
                        pstmt.setString(14, excludeStartDay);
                        pstmt.setString(15, excludeEndDay);
                        pstmt.setString(16, excludeStartTime);
                        pstmt.setString(17, excludeEndTime);
                        pstmt.setString(18, businessEvent);
                        pstmt.setString(19, schID);
                        pstmt.setString(20, appServerIP);
                        pstmt.executeUpdate();
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        conn.commit();
                    } else if (action.equalsIgnoreCase("register")) {
                        BaseLogger.log("3", null, null, "insert query............");
                        updateSQL = "mysql".equalsIgnoreCase(CommonConstants.DB_NAME) ? "INSERT INTO SCHEDULES_INFO (SCHEDULE_ID,SCHEDULE_NAME,SCHEDULE_TYPE,OWNER,OWNER_TYPE,START_DATE,START_TIME,`INTERVAL`,RUNMODE,SCHEDULE_OBJ_ID,SCHEDULE_OBJ_NAME,SCHEDULE_OBJ_TYPE,USERINFO_XML,ACTUALPARAMETERS,APP_SERVER_IP,EXCLUDE_START_DAY,EXCLUDE_END_DAY,EXCLUDE_START_TIME,EXCLUDE_END_TIME,BUSI_EVENT,ENTERPRISE)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)" : "INSERT INTO SCHEDULES_INFO (SCHEDULE_ID,SCHEDULE_NAME,SCHEDULE_TYPE,OWNER,OWNER_TYPE,START_DATE,START_TIME,INTERVAL,RUNMODE,SCHEDULE_OBJ_ID,SCHEDULE_OBJ_NAME,SCHEDULE_OBJ_TYPE,USERINFO_XML,ACTUALPARAMETERS,APP_SERVER_IP,EXCLUDE_START_DAY,EXCLUDE_END_DAY,EXCLUDE_START_TIME,EXCLUDE_END_TIME,BUSI_EVENT,ENTERPRISE)VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                        pstmt = conn.prepareStatement(updateSQL);
                        pstmt.setString(1, schID);
                        pstmt.setString(2, schName);
                        pstmt.setString(3, schType);
                        pstmt.setString(4, owner);
                        pstmt.setString(5, ownerType);
                        pstmt.setString(6, startDateStr);
                        pstmt.setString(7, startTimeStr);
                        pstmt.setString(8, interval);
                        pstmt.setString(9, runMode);
                        pstmt.setString(10, schObjID);
                        pstmt.setString(11, schObjName);
                        pstmt.setString(12, schObjType);
                        pstmt.setString(13, userInfoXML);
                        pstmt.setString(14, actParmXML);
                        pstmt.setString(15, appServerIP);
                        pstmt.setString(16, excludeStartDay);
                        pstmt.setString(17, excludeEndDay);
                        pstmt.setString(18, excludeStartTime);
                        pstmt.setString(19, excludeEndTime);
                        pstmt.setString(20, businessEvent);
                        pstmt.setString(21, enterprise);
                        pstmt.executeUpdate();
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        conn.commit();
                    }
                    ++cntr;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String[][] getScheduleInfo(String[] schArrary) throws RemoteException, BaseException {
        Statement pStmt = null;
        Connection con = null;
        ResultSet rs = null;
        String[][] resultArray = new String[schArrary.length][8];
        TimerHandle valTimer = null;
        ObjectInputStream ois = null;
        try {
            try {
                BaseLogger.log("3", null, null, "ScheduleInfoEJB >> getScheduleInfo() is called ......");
                String path = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "bin" + File.separator + "schhandles";
                String nextDueDate = null;
                String sqlStatus = null;
                String sqlSch = null;
                String sqlSchInfo = null;
                String status = null;
                String sql = "";
                String result = "";
                String[] startSchArray = new String[schArrary.length];
                String[] stopSchArray = new String[schArrary.length];
                ConnDriver driverObj = new ConnDriver();
                con = driverObj.getConnectDB("Driver");
                E12GenericUtility genericUtility = new E12GenericUtility();
                int startSchIndex = 0;
                int stopSchIndex = 0;
                int stopSchCntr = 0;
                int stopSchFileCntr = 0;
                int statusCntr = 0;
                while (statusCntr < schArrary.length) {
                    sqlStatus = "SELECT SCHEDULE_TYPE FROM SCHEDULES WHERE SCHEDULE_ID = ?";
                    pStmt = con.prepareStatement(sqlStatus);
                    pStmt.setString(1, schArrary[statusCntr]);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        status = rs.getString("SCHEDULE_TYPE");
                        if (status.equals("S")) {
                            startSchArray[startSchIndex] = schArrary[statusCntr];
                            ++startSchIndex;
                        } else if (status.equals("C")) {
                            stopSchArray[stopSchIndex] = schArrary[statusCntr];
                            ++stopSchIndex;
                        }
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    ++statusCntr;
                }
                int cntr = 0;
                while (cntr < schArrary.length) {
                    sqlSch = "SELECT SCHEDULE_NAME,OWNER,START_DATE,INTERVAL FROM SCHEDULES_INFO WHERE SCHEDULE_ID=?";
                    pStmt = con.prepareStatement(sqlSch);
                    if (cntr < schArrary.length) {
                        pStmt.setString(1, startSchArray[cntr]);
                    } else {
                        pStmt.setString(1, stopSchArray[stopSchCntr]);
                        ++stopSchCntr;
                    }
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        resultArray[cntr][0] = rs.getString("SCHEDULE_NAME");
                        resultArray[cntr][1] = rs.getString("OWNER");
                        resultArray[cntr][2] = rs.getString("START_DATE");
                        resultArray[cntr][3] = rs.getString("INTERVAL");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    ++cntr;
                }
                cntr = 0;
                while (cntr < schArrary.length) {
                    sqlSchInfo = "SELECT SCHEDULE_TYPE,LAST_FIRED_DATE,NEXT_DUE_DATE FROM SCHEDULES WHERE SCHEDULE_ID=?";
                    pStmt = con.prepareStatement(sqlSchInfo);
                    if (cntr < schArrary.length) {
                        pStmt.setString(1, startSchArray[cntr]);
                    } else {
                        pStmt.setString(1, stopSchArray[stopSchCntr]);
                        ++stopSchCntr;
                    }
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        resultArray[cntr][4] = rs.getString("SCHEDULE_TYPE");
                        resultArray[cntr][5] = rs.getString("LAST_FIRED_DATE");
                        resultArray[cntr][6] = rs.getString("NEXT_DUE_DATE");
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    ++cntr;
                }
                cntr = 0;
                while (cntr < schArrary.length) {
                    String schedule_id = null;
                    File schFile = null;
                    if (cntr < schArrary.length) {
                        schFile = new File(String.valueOf(path) + File.separator + startSchArray[cntr] + ".ser");
                        schedule_id = startSchArray[cntr];
                    } else {
                        schFile = new File(String.valueOf(path) + File.separator + stopSchArray[stopSchFileCntr] + ".ser");
                        ++stopSchFileCntr;
                    }
                    ois = new ObjectInputStream(new FileInputStream(schFile));
                    valTimer = (TimerHandle)ois.readObject();
                    resultArray[cntr][6] = nextDueDate = valTimer.toString().substring(valTimer.toString().indexOf("first") + "first=".length(), valTimer.toString().indexOf(",periode"));
                    SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss.SSS");
                    java.util.Date startOfDate = df.parse(nextDueDate);
                    df.format(startOfDate);
                    Long startDateInt = startOfDate.getTime();
                    Timestamp st = new Timestamp(startDateInt);
                    sql = "UPDATE SCHEDULES SET NEXT_DUE_DATE = ? WHERE SCHEDULE_ID=?";
                    pStmt = con.prepareStatement(sql);
                    pStmt.setTimestamp(1, st);
                    pStmt.setString(2, schedule_id);
                    int rowCnt = pStmt.executeUpdate();
                    BaseLogger.log("3", null, null, "[ScheduleInfoEJB] getScheduleInfo >> rowCnt[" + rowCnt + "]");
                    result = rowCnt > 0 ? "updated" : "not upadated";
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    ++cntr;
                }
                if (ois != null) {
                    ois.close();
                    ois = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (ois != null) {
                        ois.close();
                        ois = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                    ois = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultArray;
    }

    private String checkNull(String value) {
        value = value == null || value != null && "null".equalsIgnoreCase(value) ? "" : value.trim();
        return value;
    }

    @Override
    public void updateScheduleStatus(String scheduleId, String status) throws RemoteException, BaseException {
        UserInfoBean userInfo = null;
        this.updateScheduleStatus(scheduleId, status, userInfo);
    }

    public void updateScheduleStatus(String scheduleId, String status, UserInfoBean userInfo) throws RemoteException, BaseException {
        try {
            if (this.remoteCon == null) {
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                this.remoteCon = mConnDriver.getConnectDB(transDB);
            }
            BaseLogger.log("3", null, null, "\n\n$$$$$$$$****************UPDATE SCHEDULER STATUS**********************************\n");
            E12GenericUtility genericUtility = new E12GenericUtility();
            ScheduleModel schModel = this.getScheduleModel(scheduleId);
            if (schModel != null) {
                schModel.setStatus(status);
                Document newScheduleDom = null;
                if (status.equalsIgnoreCase("C")) {
                    ScheduleModel schModel1 = new ScheduleModel(schModel.toString("stop"));
                    schModel1.setStatus(status);
                    scheduleinfoMap.put(scheduleId, schModel1);
                    newScheduleDom = genericUtility.parseString(schModel.toString("stop"));
                } else {
                    newScheduleDom = genericUtility.parseString(schModel.toString());
                }
                boolean isUpdated = this.updateStatusToDB(scheduleId, status, this.remoteCon);
                BaseLogger.log("3", null, null, "After updateStatusToDB( scheduleId, status ) isUpdated [" + isUpdated + "]");
                String action = "update";
                ScheduleModel schModelDB = (ScheduleModel)scheduleinfoMap.get(scheduleId);
                String changedXmlStr = schModelDB.toString();
                this.modifyInfo(changedXmlStr, action);
            }
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
    }

    public String getAppServerIPAddr() throws Exception {
        String ipAddr = "";
        try {
            Enumeration<NetworkInterface> b = NetworkInterface.getNetworkInterfaces();
            while (b.hasMoreElements()) {
                for (InterfaceAddress f : b.nextElement().getInterfaceAddresses()) {
                    if (!f.getAddress().isSiteLocalAddress()) continue;
                    ipAddr = f.getAddress().toString();
                }
            }
            BaseLogger.log("3", null, null, "ipAddr =[" + ipAddr + "]");
            if (ipAddr.startsWith("\"") || ipAddr.startsWith("/")) {
                ipAddr = ipAddr.substring(1, ipAddr.length());
            }
            BaseLogger.log("3", null, null, "ipAddr1 =[" + ipAddr + "]");
            if (ipAddr == null || ipAddr.trim().length() == 0) {
                InetAddress inetAddress = InetAddress.getLocalHost();
                String hostName = inetAddress.getHostName();
                ipAddr = inetAddress.getHostAddress();
                BaseLogger.log("3", null, null, "hostName =[" + hostName + "]");
            }
            BaseLogger.log("3", null, null, "ipAddr2 =[" + ipAddr + "]");
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipAddr;
    }

    @Override
    public String getSelectedScheduleModel(String scheduleId) throws RemoteException, BaseException {
        UserInfoBean userInfo = null;
        return this.getSelectedScheduleModel(scheduleId, userInfo);
    }

    @Override
    public String getSelectedScheduleModel(String scheduleId, UserInfoBean userInfo) throws RemoteException, BaseException {
        String retSchModel = "";
        ScheduleModel schModel = null;
        try {
            schModel = this.parseSelecedSchedule(scheduleId, userInfo);
            String lastFiredOn = this.getLastFiredOn(scheduleId, userInfo);
            String nextDueDate = this.getNextDueDate(scheduleId, userInfo);
            if (lastFiredOn != null && schModel != null) {
                if (lastFiredOn.equalsIgnoreCase("0")) {
                    lastFiredOn = "Not Fired";
                }
                schModel.setLastSchFireOn(lastFiredOn);
            }
            if (schModel != null) {
                schModel.setNextDueDate(nextDueDate);
                retSchModel = schModel.toString();
            } else {
                retSchModel = "";
            }
        }
        catch (BaseException be) {
            be.printStackTrace();
            BaseLogger.log("0", null, null, "BaseException-Exception-while setting nextDue date--[" + be.getMessage() + "]");
            throw be;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", null, null, "Exception-while setting nextDue date-[" + e.getMessage() + "]");
            throw new BaseException(e);
        }
        return retSchModel;
    }

    @Override
    public ScheduleModel parseSelecedSchedule(String scheduleId) throws RemoteException, BaseException {
        return this.parseSelecedSchedule(scheduleId, null);
    }

    public ScheduleModel parseSelecedSchedule(String scheduleId, UserInfoBean userInfo) throws RemoteException, BaseException {
        ScheduleModel schModel = null;
        BaseLogger.log("3", null, null, "parseSelecedSchedule called for schedule");
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String schXMLString = this.getSelScheduledFromDB(scheduleId, userInfo);
            BaseLogger.log("3", null, null, "schXMLString inparse for schedule[" + schXMLString + "]");
            Document scheduleDom = genericUtility.parseString(schXMLString);
            NodeList scheduleList = scheduleDom.getElementsByTagName("SCHEDULE");
            int noOfSchedules = scheduleList.getLength();
            int scheduleCtr = 0;
            while (scheduleCtr <= noOfSchedules) {
                String currScheduleId;
                Node currSchedule = scheduleList.item(scheduleCtr);
                if (currSchedule != null && currSchedule.getAttributes().getNamedItem("id") != null && scheduleId.equals(currScheduleId = currSchedule.getAttributes().getNamedItem("id").getNodeValue())) {
                    schModel = new ScheduleModel(genericUtility.serializeDom(currSchedule));
                    break;
                }
                ++scheduleCtr;
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schModel;
    }

    @Override
    public String getSelScheduledFromDB(String schID) throws RemoteException, BaseException {
        return this.getSelScheduledFromDB(schID, null);
    }

    public String getSelScheduledFromDB(String schID, UserInfoBean userInfo) throws RemoteException, BaseException {
        Connection conn = null;
        Statement pstmtSch = null;
        String scheduleStr = null;
        try {
            try {
                StringBuffer schBuffer = new StringBuffer("<ROOT><SCHEDULES>");
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                String appServerIP = this.getAppServerIPAddr();
                BaseLogger.log("3", null, null, "appServerIP getSelScheduledFromDB userInfo =[ " + appServerIP + "]");
                E12GenericUtility genericUtility = new E12GenericUtility();
                String sqlQuery = "SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.OWNER, SI.OWNER_TYPE, SI.START_DATE, SI.START_TIME, SI.INTERVAL, SI.RUNMODE, SI.SCHEDULE_OBJ_ID, SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.USERINFO_XML, SI.ACTUALPARAMETERS, SC.DESCR, SC.SCHEDULE_TYPE, SC.LAST_FIRED_ON, SC.REP_FREQ, SC.END_DATE, SC.LAST_FIRED_DATE, SC.NEXT_DUE_DATE, SI.EXCLUDE_START_DAY, SI.EXCLUDE_START_TIME, SI.EXCLUDE_END_DAY, SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID AND SC.SCHEDULE_ID = '" + schID + "' ";
                pstmtSch = conn.prepareStatement(sqlQuery);
                ResultSet rsSch = pstmtSch.executeQuery();
                if (rsSch.next()) {
                    String excStartDay = this.checkNull(rsSch.getString("EXCLUDE_START_DAY"));
                    String excStartTime = this.checkNull(rsSch.getString("EXCLUDE_START_TIME"));
                    String excEndDay = this.checkNull(rsSch.getString("EXCLUDE_END_DAY"));
                    String excEndTime = this.checkNull(rsSch.getString("EXCLUDE_END_TIME"));
                    schBuffer.append("<SCHEDULE id=\"" + this.checkNull(rsSch.getString("SCHEDULE_ID")) + "\" schtype=\"" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "\">");
                    schBuffer.append("<NAME><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_NAME")) + "]]></NAME>");
                    schBuffer.append("<SCHEDULEINFO/>");
                    schBuffer.append("<OWNER TYPE=\"" + this.checkNull(rsSch.getString("OWNER_TYPE")) + "\"><![CDATA[" + this.checkNull(rsSch.getString("OWNER")) + "]]></OWNER>");
                    schBuffer.append("<START_DATE><![CDATA[" + this.checkNull(rsSch.getString("START_DATE")) + "]]></START_DATE>");
                    schBuffer.append("<START_TIME><![CDATA[" + this.checkNull(rsSch.getString("START_TIME")) + "]]></START_TIME>");
                    schBuffer.append("<LAST_SCH_FIRE_ON><![CDATA[" + this.checkNull(rsSch.getString("LAST_FIRED_ON")) + "]]></LAST_SCH_FIRE_ON>");
                    schBuffer.append("<NEXT_DUE_DATE><![CDATA[" + this.checkNull(rsSch.getString("NEXT_DUE_DATE")) + "]]></NEXT_DUE_DATE>");
                    schBuffer.append("<INTERVAL><![CDATA[" + this.checkNull(rsSch.getString("INTERVAL")) + "]]></INTERVAL>");
                    schBuffer.append("<SCHEDULE_SEQ><![CDATA[null]]></SCHEDULE_SEQ><EXCEPTION_TYPE><![CDATA[null]]></EXCEPTION_TYPE><CRITERIA><![CDATA[null]]></CRITERIA><DEBUG_MODE><![CDATA[null]]></DEBUG_MODE>");
                    schBuffer.append("<STATUS><![CDATA[" + this.checkNull(rsSch.getString("SCHEDULE_TYPE")) + "]]></STATUS>");
                    schBuffer.append("<EXCLUDE_START_DAY><![CDATA[" + excStartDay + "]]></EXCLUDE_START_DAY>");
                    schBuffer.append("<EXCLUDE_START_TIME><![CDATA[" + excStartTime + "]]></EXCLUDE_START_TIME>");
                    schBuffer.append("<EXCLUDE_END_DAY><![CDATA[" + excEndDay + "]]></EXCLUDE_END_DAY>");
                    schBuffer.append("<EXCLUDE_END_TIME><![CDATA[" + excStartTime + "]]></EXCLUDE_END_TIME>");
                    schBuffer.append("<BUSI_EVENT><![CDATA[" + this.checkNull(rsSch.getString("BUSI_EVENT")) + "]]></BUSI_EVENT>");
                    schBuffer.append(this.checkNull(rsSch.getString("USERINFO_XML")));
                    schBuffer.append("<RUNMODE><![CDATA[" + this.checkNull(rsSch.getString("RUNMODE")) + "]]></RUNMODE>");
                    schBuffer.append("<SCHEDULE_OBJ id=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_ID")) + "\" name=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_NAME")) + "\" type=\"" + this.checkNull(rsSch.getString("SCHEDULE_OBJ_TYPE")) + "\">");
                    schBuffer.append(this.checkNull(rsSch.getString("ACTUALPARAMETERS")));
                    schBuffer.append("</SCHEDULE_OBJ></SCHEDULE>");
                }
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (rsSch != null) {
                    rsSch.close();
                    rsSch = null;
                }
                schBuffer.append("</SCHEDULES></ROOT>");
                scheduleStr = schBuffer.toString();
            }
            catch (BaseException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scheduleStr;
    }

    @Override
    public void updateSelectedScheduleStatus(String scheduleId, String status) throws RemoteException, BaseException {
        this.updateSelectedScheduleStatus(scheduleId, status, null);
    }

    @Override
    public void updateSelectedScheduleStatus(String scheduleId, String status, UserInfoBean userInfo) throws RemoteException, BaseException {
        Connection conn = null;
        try {
            try {
                BaseLogger.log("3", null, null, "sScheduleInfoEJB >> updateSelectedScheduleStatus is called >> scheduleId :: [" + scheduleId + "] status :: [" + status + "]");
                E12GenericUtility genericUtility = new E12GenericUtility();
                ScheduleModel schModel = this.getSelectedScheduleModel(scheduleId, status, userInfo);
                if (schModel != null) {
                    schModel.setStatus(status);
                    Document newScheduleDom = null;
                    if (status.equalsIgnoreCase("C")) {
                        ScheduleModel schModel1 = new ScheduleModel(schModel.toString("stop"));
                        schModel1.setStatus(status);
                        scheduleinfoMap.put(scheduleId, schModel1);
                        newScheduleDom = genericUtility.parseString(schModel.toString("stop"));
                    } else {
                        newScheduleDom = genericUtility.parseString(schModel.toString());
                    }
                    boolean isUpdated = this.updateStatusToDB(scheduleId, status, conn, userInfo);
                    BaseLogger.log("3", null, null, "ScheduleInfoEJB >> updateSelectedScheduleStatus isUpdateddd [" + isUpdated + "]");
                    String action = "update";
                    ScheduleModel schModelDB = (ScheduleModel)scheduleinfoMap.get(scheduleId);
                    String changedXmlStr = schModelDB.toString();
                    this.modifyInfo(changedXmlStr, action, userInfo);
                }
            }
            catch (Exception e) {
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ScheduleModel getSelectedScheduleModel(String scheduleId, String status) throws RemoteException, BaseException {
        return this.getSelectedScheduleModel(scheduleId, status, null);
    }

    public ScheduleModel getSelectedScheduleModel(String scheduleId, String status, UserInfoBean userInfo) throws RemoteException, BaseException {
        ScheduleModel schModel = null;
        BaseLogger.log("2", null, null, "ScheduleInfoEJB >> getSelectedScheduleModel is called......[" + scheduleId + "]::status::[" + status + "]::scheduleinfoMap::[" + scheduleinfoMap + "]");
        try {
            if (scheduleinfoMap.get(scheduleId) != null) {
                schModel = (ScheduleModel)scheduleinfoMap.get(scheduleId);
            } else {
                BaseLogger.log("3", null, null, "Getting new model....");
                schModel = this.parseSelecedSchedule(scheduleId, userInfo);
                scheduleinfoMap.put(scheduleId, schModel);
            }
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BaseException(e);
        }
        return schModel;
    }

    @Override
    public LinkedHashMap getSchedulesInfoList() throws ITMException {
        return this.getSchedulesInfoList(null);
    }

    public LinkedHashMap getSchedulesInfoList(UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", null, null, "inside getSchedulesInfoList.........");
        Connection conn = null;
        Statement pstmt = null;
        LinkedHashMap schedulesMap = new LinkedHashMap();
        try {
            try {
                String appServerIP = this.getAppServerIPAddr();
                ConnDriver mConnDriver = new ConnDriver();
                String enterpriseOfUser = userInfo.getEnterprise();
                String enterpriseOfSchedulesInfo = null;
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                int num = 0;
                String userId = userInfo.getLoginCode();
                String sql = " SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, S.SCHEDULE_TYPE, SI.START_DATE, SI.START_TIME, SI.SCHEDULE_OBJ_ID, SI.OWNER, SI.OWNER_TYPE,   SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.APP_SERVER_IP, SI.INTERVAL, SI.EXCLUDE_START_TIME,  SI.EXCLUDE_END_TIME, SI.EXCLUDE_START_DAY, SI.EXCLUDE_END_DAY, SI.ACTUALPARAMETERS, SI.BUSI_EVENT  FROM SCHEDULES_INFO SI , SCHEDULES S  WHERE SI.SCHEDULE_ID = S.SCHEDULE_ID  AND ( (SI.OWNER_TYPE = 'U') OR (SI.OWNER = ? AND SI.OWNER_TYPE = 'P') )  ORDER BY SI.START_DATE DESC, SI.SCHEDULE_NAME ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, userId);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    String status;
                    ++num;
                    ArrayList<String> scheduleList = new ArrayList<String>();
                    String scheduleId = this.checkNull(rs.getString("SCHEDULE_ID"));
                    String scheduleName = this.checkNull(rs.getString("SCHEDULE_NAME"));
                    String scheduleType = this.checkNull(rs.getString("SCHEDULE_TYPE"));
                    String startDate = this.checkNull(rs.getString("START_DATE"));
                    String startTime = this.checkNull(rs.getString("START_TIME"));
                    String scheduleObjId = this.checkNull(rs.getString("SCHEDULE_OBJ_ID"));
                    String owner = this.checkNull(rs.getString("OWNER"));
                    String ownerType = this.checkNull(rs.getString("OWNER_TYPE"));
                    String scheduleObjName = this.checkNull(rs.getString("SCHEDULE_OBJ_NAME"));
                    String scheduleObjType = this.checkNull(rs.getString("SCHEDULE_OBJ_TYPE"));
                    String serverIP = this.checkNull(rs.getString("APP_SERVER_IP"));
                    String interval = this.checkNull(rs.getString("INTERVAL"));
                    String excludeStartTime = this.checkNull(rs.getString("EXCLUDE_START_TIME"));
                    String excludeEndTime = this.checkNull(rs.getString("EXCLUDE_END_TIME"));
                    String excludeStartDay = this.checkNull(rs.getString("EXCLUDE_START_DAY"));
                    String excludeEndDay = this.checkNull(rs.getString("EXCLUDE_END_DAY"));
                    String actParameter = this.checkNull(rs.getString("ACTUALPARAMETERS"));
                    String busiEvent = this.checkNull(rs.getString("BUSI_EVENT"));
                    String string = status = "S".equalsIgnoreCase(scheduleType) ? "Running" : "Stopped";
                    if (userInfo != null) {
                        DBAccessEJB dbAccessEJB = new DBAccessEJB();
                        try {
                            enterpriseOfSchedulesInfo = dbAccessEJB.getDBColumnValue("SCHEDULES_INFO", "ENTERPRISE", "SCHEDULE_ID  = '" + scheduleId + "'", userInfo.getTransDB());
                            BaseLogger.log("3", null, null, "enterpriseOfSchedulesInfo::: [" + enterpriseOfSchedulesInfo + "]");
                        }
                        catch (ITMException | RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!enterpriseOfUser.equalsIgnoreCase(enterpriseOfSchedulesInfo) && !enterpriseOfSchedulesInfo.equalsIgnoreCase(null) && !enterpriseOfSchedulesInfo.equalsIgnoreCase("")) continue;
                    scheduleList.add(scheduleId);
                    scheduleList.add(scheduleName);
                    scheduleList.add(scheduleType);
                    scheduleList.add(startDate);
                    scheduleList.add(startTime);
                    scheduleList.add(scheduleObjId);
                    scheduleList.add(scheduleObjName);
                    scheduleList.add(scheduleObjType);
                    scheduleList.add(serverIP);
                    scheduleList.add(interval);
                    scheduleList.add(excludeStartTime);
                    scheduleList.add(excludeEndTime);
                    scheduleList.add(excludeStartDay);
                    scheduleList.add(excludeEndDay);
                    scheduleList.add(status);
                    scheduleList.add(actParameter);
                    scheduleList.add(busiEvent);
                    scheduleList.add(owner);
                    scheduleList.add(ownerType);
                    schedulesMap.put("" + num, scheduleList);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception : [ ScheduleInfoEJB ][ getSchulesInfoList ] : ==>\n" + e.getMessage());
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return schedulesMap;
    }

    @Override
    public HashMap getAllScheduleDetails(String scheduleId) throws ITMException {
        return this.getAllScheduleDetails(scheduleId, null);
    }

    public HashMap getAllScheduleDetails(String scheduleId, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", null, null, "ScheduleInfoEJB :::: getAllScheduleDetails ");
        Connection conn = null;
        ConnDriver connDriver = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, String> scheduleMap = new HashMap<String, String>();
        try {
            try {
                connDriver = new ConnDriver();
                String transDB = "Driver";
                conn = connDriver.getConnectDB(transDB);
                String sql = " SELECT SI.SCHEDULE_ID, SI.SCHEDULE_NAME, SI.SCHEDULE_TYPE, SI.START_DATE, SI.START_TIME, SI.SCHEDULE_OBJ_ID,  SI.SCHEDULE_OBJ_NAME, SI.SCHEDULE_OBJ_TYPE, SI.APP_SERVER_IP, SI.INTERVAL, SI.EXCLUDE_START_TIME,   SI.EXCLUDE_END_TIME, SI.EXCLUDE_START_DAY, SI.EXCLUDE_END_DAY, S.SCHEDULE_TYPE AS STATUS,  SI.ACTUALPARAMETERS, SI.BUSI_EVENT FROM SCHEDULES_INFO SI, SCHEDULES S  WHERE SI.SCHEDULE_ID = S.SCHEDULE_ID AND SI.SCHEDULE_ID = ? ORDER BY SI.SCHEDULE_NAME DESC ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, scheduleId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String scheduleName = this.checkNull(rs.getString("SCHEDULE_NAME"));
                    String scheduleType = this.checkNull(rs.getString("SCHEDULE_TYPE"));
                    String startDate = this.checkNull(rs.getString("START_DATE"));
                    String startTime = this.checkNull(rs.getString("START_TIME"));
                    String scheduleObjId = this.checkNull(rs.getString("SCHEDULE_OBJ_ID"));
                    String scheduleObjName = this.checkNull(rs.getString("SCHEDULE_OBJ_NAME"));
                    String scheduleObjType = this.checkNull(rs.getString("SCHEDULE_OBJ_TYPE"));
                    String serverIP = this.checkNull(rs.getString("APP_SERVER_IP"));
                    String interval = this.checkNull(rs.getString("INTERVAL"));
                    String excludeStartTime = this.checkNull(rs.getString("EXCLUDE_START_TIME"));
                    String excludeEndTime = this.checkNull(rs.getString("EXCLUDE_END_TIME"));
                    String excludeStartDay = this.checkNull(rs.getString("EXCLUDE_START_DAY"));
                    String excludeEndDay = this.checkNull(rs.getString("EXCLUDE_END_DAY"));
                    String status = this.checkNull(rs.getString("STATUS"));
                    String actualParameters = this.checkNull(rs.getString("ACTUALPARAMETERS"));
                    String busiEvent = this.checkNull(rs.getString("BUSI_EVENT"));
                    status = "S".equalsIgnoreCase(status) ? "Running" : "Stopped";
                    scheduleMap.put("SCHEDULE_ID", scheduleId);
                    scheduleMap.put("SCHEDULE_NAME", scheduleName);
                    scheduleMap.put("SCHEDULE_TYPE", scheduleType);
                    scheduleMap.put("START_DATE", startDate);
                    scheduleMap.put("START_TIME", startTime);
                    scheduleMap.put("SCHEDULE_OBJ_ID", scheduleObjId);
                    scheduleMap.put("schdlActivities", scheduleObjName);
                    scheduleMap.put("SCHEDULE_OBJ_TYPE", scheduleObjType);
                    scheduleMap.put("APP_SERVER_IP", serverIP);
                    scheduleMap.put("intervalID", interval);
                    scheduleMap.put("EXCLUDE_START_TIME", excludeStartTime);
                    scheduleMap.put("EXCLUDE_END_TIME", excludeEndTime);
                    scheduleMap.put("EXCLUDE_START_DAY", excludeStartDay);
                    scheduleMap.put("EXCLUDE_END_DAY", excludeEndDay);
                    scheduleMap.put("STATUS", status);
                    scheduleMap.put("actArg", actualParameters);
                    scheduleMap.put("BUSI_EVENT", busiEvent);
                }
            }
            catch (Exception exception) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scheduleMap;
    }

    public String getUserDefScheduleInfo(String owner, UserInfoBean userInfo) throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "getUserDefScheduleInfo...1");
        Connection conn = null;
        Statement pstmt = null;
        JSONArray schedulesInfo = new JSONArray();
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                BaseLogger.log("2", null, null, "getUserDefScheduleInfo...1" + transDB);
                String sql = "SELECT S.SCHEDULE_ID,S.LAST_FIRED_DATE,S.NEXT_DUE_DATE,S.SCHEDULE_TYPE,SI.SCHEDULE_NAME,SI.START_DATE,SI.START_TIME,SI.INTERVAL,SI.ACTUALPARAMETERS FROM SCHEDULES S,SCHEDULES_INFO SI WHERE SI.OWNER='" + owner + "' AND S.SCHEDULE_ID = SI.SCHEDULE_ID";
                pstmt = conn.prepareStatement(sql);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    BaseLogger.log("2", null, null, "inside while loop::");
                    JSONObject scheduleObject = new JSONObject();
                    String scheduleId = rs.getString("SCHEDULE_ID");
                    String scheduleType = rs.getString("SCHEDULE_TYPE");
                    String lastFiredDate = rs.getString("LAST_FIRED_DATE");
                    String nextDueDate = rs.getString("NEXT_DUE_DATE");
                    String scheduleName = rs.getString("SCHEDULE_NAME");
                    String startDate = rs.getString("START_DATE");
                    String startTime = rs.getString("START_TIME");
                    String interval = rs.getString("INTERVAL");
                    String actualParam = rs.getString("ACTUALPARAMETERS");
                    scheduleObject.put("SCHEDULE_ID", (Object)scheduleId);
                    scheduleObject.put("SCHEDULE_NAME", (Object)scheduleName);
                    scheduleObject.put("SCHEDULE_TYPE", (Object)scheduleType);
                    scheduleObject.put("LAST_FIRED_DATE", (Object)lastFiredDate);
                    scheduleObject.put("NEXT_DUE_DATE", (Object)nextDueDate);
                    scheduleObject.put("START_DATE", (Object)startDate);
                    scheduleObject.put("START_TIME", (Object)startTime);
                    scheduleObject.put("INTERVAL", (Object)interval);
                    scheduleObject.put("ACTUALPARAMETERS", (Object)actualParam);
                    schedulesInfo.put((Object)scheduleObject);
                    BaseLogger.log("3", null, null, "Schedule Object::" + scheduleObject);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (BaseException be) {
                BaseLogger.log("0", null, null, "BaseException:getUserDefScheduleInfo" + be.getMessage());
                throw be;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception:getUserDefScheduleInfo" + e.getMessage());
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "getUserDefScheduleInfo...2");
        BaseLogger.log("3", null, null, "ShedulesInfo::" + schedulesInfo);
        return schedulesInfo.toString();
    }

    public String getSelScheduledFromDB1(String schID, UserInfoBean userInfo) throws RemoteException, BaseException {
        BaseLogger.log("2", null, null, "getSelScheduledFromDB1...1");
        Connection conn = null;
        Statement pstmtSch = null;
        JSONArray selecScheduleInfo = new JSONArray();
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                String transDB = "Driver";
                conn = mConnDriver.getConnectDB(transDB);
                BaseLogger.log("2", null, null, "getSelScheduledFromDB1........" + transDB);
                String appServerIP = this.getAppServerIPAddr();
                BaseLogger.log("3", null, null, "appServerIP getSelScheduledFromDB1  =[ " + appServerIP + "]");
                E12GenericUtility genericUtility = new E12GenericUtility();
                String sqlQuery = "SELECT SI.SCHEDULE_ID,SI.SCHEDULE_NAME,SI.OWNER,SI.OWNER_TYPE,SI.START_DATE,SI.START_TIME,SI.INTERVAL,SI.RUNMODE,SI.SCHEDULE_OBJ_ID,SI.SCHEDULE_OBJ_NAME,SI.SCHEDULE_OBJ_TYPE,SI.USERINFO_XML,SI.ACTUALPARAMETERS,SC.SCHEDULE_TYPE,SC.LAST_FIRED_ON, SC.LAST_FIRED_DATE,SC.NEXT_DUE_DATE,SI.EXCLUDE_START_DAY,SI.EXCLUDE_START_TIME,SI.EXCLUDE_END_DAY,SI.EXCLUDE_END_TIME, SI.BUSI_EVENT FROM SCHEDULES_INFO SI,SCHEDULES SC where SI.SCHEDULE_ID = SC.SCHEDULE_ID AND SC.SCHEDULE_ID = '" + schID + "' ";
                BaseLogger.log("3", null, null, "Inside getSelScheduledFromDB1(SQL)::" + sqlQuery);
                pstmtSch = conn.prepareStatement(sqlQuery);
                ResultSet rs = pstmtSch.executeQuery();
                BaseLogger.log("3", null, null, "Inside getSelScheduledFromDB1(SQL) rs::" + rs);
                while (rs.next()) {
                    BaseLogger.log("3", null, null, "Inside rs::");
                    JSONObject selScheduleObject = new JSONObject();
                    String scheduleId = rs.getString("SCHEDULE_ID");
                    String scheduleName = rs.getString("SCHEDULE_NAME");
                    String owner = rs.getString("OWNER");
                    String ownerType = rs.getString("OWNER_TYPE");
                    String startDate = rs.getString("START_DATE");
                    String startTime = rs.getString("START_TIME");
                    String interval = rs.getString("INTERVAL");
                    String runMode = rs.getString("RUNMODE");
                    String schObjId = rs.getString("SCHEDULE_OBJ_ID");
                    String schObjName = rs.getString("SCHEDULE_OBJ_NAME");
                    String schObjType = rs.getString("SCHEDULE_OBJ_TYPE");
                    String userInfoXml = rs.getString("USERINFO_XML");
                    String actualParam = rs.getString("ACTUALPARAMETERS");
                    String schType = rs.getString("SCHEDULE_TYPE");
                    String excStartDay = rs.getString("EXCLUDE_START_DAY");
                    String excStartTime = rs.getString("EXCLUDE_START_TIME");
                    String excEndDay = rs.getString("EXCLUDE_END_DAY");
                    String excEndTime = rs.getString("EXCLUDE_END_TIME");
                    String lastSchFireOn = rs.getString("LAST_FIRED_ON");
                    String lastFireDate = rs.getString("LAST_FIRED_DATE");
                    String nextDueDate = rs.getString("NEXT_DUE_DATE");
                    String busievent = rs.getString("BUSI_EVENT");
                    JSONObject xmlJSONObj = XML.toJSONObject((String)actualParam);
                    BaseLogger.log("3", null, null, "XML to JSON object::" + xmlJSONObj);
                    selScheduleObject.put("EXCLUDE_START_DAY", (Object)excStartDay);
                    selScheduleObject.put("EXCLUDE_START_TIME", (Object)excStartTime);
                    selScheduleObject.put("EXCLUDE_END_DAY", (Object)excEndDay);
                    selScheduleObject.put("EXCLUDE_END_TIME", (Object)excEndTime);
                    selScheduleObject.put("SCHEDULE_ID", (Object)scheduleId);
                    selScheduleObject.put("SCHEDULE_NAME", (Object)scheduleName);
                    selScheduleObject.put("OWNER", (Object)owner);
                    selScheduleObject.put("OWNER_TYPE", (Object)ownerType);
                    selScheduleObject.put("START_DATE", (Object)startDate);
                    selScheduleObject.put("START_TIME", (Object)startTime);
                    selScheduleObject.put("LAST_FIRED_ON", (Object)lastSchFireOn);
                    selScheduleObject.put("LAST_FIRED_DATE", (Object)lastFireDate);
                    selScheduleObject.put("NEXT_DUE_DATE", (Object)nextDueDate);
                    selScheduleObject.put("INTERVAL", (Object)interval);
                    selScheduleObject.put("RUNMODE", (Object)runMode);
                    selScheduleObject.put("SCHEDULE_OBJ_ID", (Object)schObjId);
                    selScheduleObject.put("SCHEDULE_OBJ_NAME", (Object)schObjName);
                    selScheduleObject.put("SCHEDULE_OBJ_TYPE", (Object)schObjType);
                    selScheduleObject.put("USERINFO_XML", (Object)userInfoXml);
                    selScheduleObject.put("ACTUALPARAMETERS", (Object)xmlJSONObj);
                    selScheduleObject.put("SCHEDULE_TYPE", (Object)schType);
                    selScheduleObject.put("BUSI_EVENT", (Object)busievent);
                    selecScheduleInfo.put((Object)selScheduleObject);
                    BaseLogger.log("3", null, null, "Inside selScheduleObject::" + selScheduleObject);
                    BaseLogger.log("3", null, null, " Selected Schedule selecScheduleInfo::" + selecScheduleInfo);
                }
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (BaseException be) {
                be.printStackTrace();
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException(e);
            }
        }
        finally {
            try {
                if (pstmtSch != null) {
                    pstmtSch.close();
                    pstmtSch = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "getUserDefScheduleInfo...2");
        BaseLogger.log("3", null, null, "SCHEDULEINFO:::" + selecScheduleInfo);
        return selecScheduleInfo.toString();
    }

    public ArrayList<String> getBusinessEventList(UserInfoBean userInfo) throws ITMException {
        System.out.println("ScheduleInfoEJB.getBusinessEventList()");
        ArrayList<String> busiEventList = new ArrayList<String>();
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB("Driver");
                String sql = "SELECT BUSI_EVENT FROM BUSINESS_EVENTS ORDER BY BUSI_EVENT";
                preparedStatement = connection.prepareStatement(sql);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    busiEventList.add(resultSet.getString("BUSI_EVENT"));
                }
            }
            catch (Exception e) {
                System.out.println("ScheduleInfoEJB.getBusinessEventList() Exception :[" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        System.out.println("ScheduleInfoEJB.getBusinessEventList() busiEventList:[" + busiEventList + "]");
        return busiEventList;
    }

    public String getSelectedReportSchedule(String owner, UserInfoBean userInfo, String biReportName) throws RemoteException, BaseException {
        JSONArray schedulesInfo;
        block21: {
            BaseLogger.log("3", null, null, "Inside ScheduleInfoEJB.getSelectedReportSchedule()");
            BaseLogger.log("3", null, null, "Owner::=" + owner + " " + "BiReportName:=" + biReportName);
            Connection conn = null;
            Statement pstmt = null;
            schedulesInfo = new JSONArray();
            try {
                try {
                    ConnDriver connDriver = new ConnDriver();
                    String transDB = "Driver";
                    conn = connDriver.getConnectDB(transDB);
                    String fileName = new String();
                    fileName = biReportName;
                    String sql = "SELECT S.SCHEDULE_ID,S.LAST_FIRED_DATE,S.NEXT_DUE_DATE,S.SCHEDULE_TYPE,SI.SCHEDULE_NAME,SI.START_DATE,SI.START_TIME,SI.INTERVAL,SI.ACTUALPARAMETERS FROM SCHEDULES S,SCHEDULES_INFO SI WHERE SI.OWNER='" + owner + "' AND SI.SCHEDULE_ID LIKE '%" + fileName + "%' AND S.SCHEDULE_ID = SI.SCHEDULE_ID";
                    pstmt = conn.prepareStatement(sql);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BaseLogger.log("2", null, null, "inside while loop::");
                        JSONObject scheduleObject = new JSONObject();
                        String scheduleId = rs.getString("SCHEDULE_ID");
                        String scheduleType = rs.getString("SCHEDULE_TYPE");
                        String lastFiredDate = rs.getString("LAST_FIRED_DATE");
                        String nextDueDate = rs.getString("NEXT_DUE_DATE");
                        String scheduleName = rs.getString("SCHEDULE_NAME");
                        String startDate = rs.getString("START_DATE");
                        String startTime = rs.getString("START_TIME");
                        String interval = rs.getString("INTERVAL");
                        String actualParam = rs.getString("ACTUALPARAMETERS");
                        scheduleObject.put("SCHEDULE_ID", (Object)scheduleId);
                        scheduleObject.put("SCHEDULE_NAME", (Object)scheduleName);
                        scheduleObject.put("SCHEDULE_TYPE", (Object)scheduleType);
                        scheduleObject.put("LAST_FIRED_DATE", (Object)lastFiredDate);
                        scheduleObject.put("NEXT_DUE_DATE", (Object)nextDueDate);
                        scheduleObject.put("START_DATE", (Object)startDate);
                        scheduleObject.put("START_TIME", (Object)startTime);
                        scheduleObject.put("INTERVAL", (Object)interval);
                        scheduleObject.put("ACTUALPARAMETERS", (Object)actualParam);
                        schedulesInfo.put((Object)scheduleObject);
                        BaseLogger.log("3", null, null, "Schedule Object::" + scheduleObject);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (BaseException be) {
                    be.printStackTrace();
                    throw be;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseLogger.log("2", null, null, "getUserDefScheduleInfo...2");
        BaseLogger.log("3", null, null, "ShedulesInfo::" + schedulesInfo);
        return schedulesInfo.toString();
    }
}

