/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ArgumentBean;
import ibase.webitm.bean.Messages;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMFilterEJB;
import ibase.webitm.utility.ITMException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ITMFilterModel
implements Serializable {
    static String FILTER_NAMES_SEP = ":";
    static String FILTER_TYPES_SEP = ":";
    static String FILTER_VALUES_SEP = ":";
    private UserInfoBean userInfo = null;
    private String objName = "";
    private ITMFilterEJB itmFilterComp = null;
    private String formalFilterInfoStr = "";
    private ArrayList formalFilterNamesList = null;
    private ArrayList formalFilterTypesList = null;
    private ArrayList formalFilterValuesList = null;
    private String formalFilterValuesStr = null;
    private ArrayList formalFilterDefaultValuesList = null;
    private ArrayList formalFilterDisplayNamesList = null;
    private ArrayList userFilterNamesList = null;
    private ArrayList userFilterExprList = null;
    private ArrayList userFilterValuesList = null;
    ArrayList defaultOptList = new ArrayList();
    private ArrayList applnFilterNamesList = null;
    private ArrayList applnFilterTypesList = null;
    private ArrayList applnFilterValuesList = null;
    public String dispDateFormat = "";

    public ITMFilterModel() throws ITMException {
        this("", null);
    }

    public ITMFilterModel(String objName) throws ITMException {
        this(objName, null);
    }

    public ITMFilterModel(String objName, UserInfoBean userInfo) throws ITMException {
        try {
            this.objName = objName;
            this.userInfo = userInfo;
            this.formalFilterNamesList = new ArrayList();
            this.formalFilterTypesList = new ArrayList();
            this.formalFilterValuesList = new ArrayList();
            this.formalFilterDefaultValuesList = new ArrayList();
            this.formalFilterDisplayNamesList = new ArrayList();
            this.userFilterNamesList = new ArrayList();
            this.userFilterExprList = new ArrayList();
            this.userFilterValuesList = new ArrayList();
            this.applnFilterNamesList = new ArrayList();
            this.applnFilterTypesList = new ArrayList();
            this.applnFilterValuesList = new ArrayList();
            this.setITMFilterComp();
            String transDB = "";
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
            }
            this.setFormalFilterInfoStr(userInfo);
            this.setUserFilterInfoStr(userInfo);
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    public String getObjName() {
        return this.objName;
    }

    public ArrayList getFormalFilterNamesList() {
        return this.formalFilterNamesList;
    }

    public String getFormalFilterNamesString() {
        String formalFilterNamesStr = "";
        StringBuffer formalFilterNamesStrBuff = new StringBuffer("");
        int ctr = 0;
        while (ctr < this.formalFilterNamesList.size()) {
            formalFilterNamesStrBuff.append((String)this.formalFilterNamesList.get(ctr)).append(FILTER_NAMES_SEP);
            ++ctr;
        }
        formalFilterNamesStr = formalFilterNamesStrBuff.toString();
        if (formalFilterNamesStr.endsWith(FILTER_NAMES_SEP)) {
            formalFilterNamesStr.substring(0, formalFilterNamesStr.length() - 1);
        }
        return formalFilterNamesStr;
    }

    public ArrayList getFormalFilterTypesList() {
        return this.formalFilterTypesList;
    }

    public String getFormalFilterTypesString() {
        String formalFilterTypesStr = "";
        StringBuffer formalFilterTypesStrBuff = new StringBuffer("");
        int ctr = 0;
        while (ctr < this.formalFilterTypesList.size()) {
            formalFilterTypesStrBuff.append((String)this.formalFilterTypesList.get(ctr)).append(FILTER_TYPES_SEP);
            ++ctr;
        }
        formalFilterTypesStr = formalFilterTypesStrBuff.toString();
        if (formalFilterTypesStr.endsWith(FILTER_TYPES_SEP)) {
            formalFilterTypesStr.substring(0, formalFilterTypesStr.length() - 1);
        }
        return formalFilterTypesStr;
    }

    public ArrayList getFormalFilterValuesList() {
        return this.formalFilterValuesList;
    }

    public void setFormalFilterValuesString(String filterValuesStr) {
        this.formalFilterValuesStr = filterValuesStr;
    }

    public String getFormalFilterValuesString() {
        return this.formalFilterValuesStr;
    }

    public ArrayList getFormalFilterDefaultValuesList() {
        return this.formalFilterDefaultValuesList;
    }

    public ArrayList getFormalFilterDisplayNamesList() {
        return this.formalFilterDisplayNamesList;
    }

    public ArrayList getUserFilterNamesList() {
        return this.userFilterNamesList;
    }

    public ArrayList getUserFilterExprList() {
        return this.userFilterExprList;
    }

    public ArrayList getUserFilterValuesList() {
        return this.userFilterValuesList;
    }

    public String getUserFilterValuesString() {
        String userFilterValuesStr = "";
        StringBuffer userFilterValuesStrBuff = new StringBuffer("");
        int ctr = 0;
        while (ctr < this.userFilterValuesList.size()) {
            userFilterValuesStrBuff.append((String)this.userFilterValuesList.get(ctr)).append(FILTER_VALUES_SEP);
            ++ctr;
        }
        userFilterValuesStr = userFilterValuesStrBuff.toString();
        if (userFilterValuesStr.endsWith(FILTER_VALUES_SEP)) {
            userFilterValuesStr.substring(0, userFilterValuesStr.length() - 1);
        }
        return userFilterValuesStr;
    }

    public ArrayList getDefaultOptList() {
        return this.defaultOptList;
    }

    private void setITMFilterComp() throws ITMException {
        try {
            InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
            if (this.itmFilterComp == null) {
                this.itmFilterComp = new ITMFilterEJB();
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :ITMFilterBean :setITMFilterComp :==>\n" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMFilterBean :setITMFilterComp :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public ArrayList getPeriodInfoList() throws ITMException {
        ArrayList periodInfoList = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            periodInfoList = new ArrayList();
            ArrayList<String> periodCodeList = new ArrayList<String>();
            ArrayList<String> fromDateList = new ArrayList<String>();
            ArrayList<String> toDateList = new ArrayList<String>();
            Document doc = genericUtility.parseString(this.formalFilterInfoStr);
            NodeList periodNodeList = doc.getElementsByTagName("PERIOD");
            int periodNodeListLength = periodNodeList.getLength();
            int ctr = 0;
            while (ctr < periodNodeListLength) {
                Node periodNode = periodNodeList.item(ctr);
                NodeList periodList = periodNode.getChildNodes();
                int dCtr = 0;
                while (dCtr < periodList.getLength()) {
                    Node currChild = periodList.item(dCtr);
                    if (currChild.getNodeName().equalsIgnoreCase("CODE")) {
                        periodCodeList.add(currChild.getFirstChild().getNodeValue());
                    } else if (currChild.getNodeName().equalsIgnoreCase("FR_DATE")) {
                        String currFromDateString = genericUtility.getValidDateString(currChild.getFirstChild().getNodeValue(), genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                        fromDateList.add(currFromDateString);
                    } else if (currChild.getNodeName().equalsIgnoreCase("TO_DATE")) {
                        String currToDateString = genericUtility.getValidDateString(currChild.getFirstChild().getNodeValue(), genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                        toDateList.add(currToDateString);
                    }
                    ++dCtr;
                }
                ++ctr;
            }
            periodInfoList.add(periodCodeList);
            periodInfoList.add(fromDateList);
            periodInfoList.add(toDateList);
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return periodInfoList;
    }

    public String getPrdCode() throws ITMException {
        String prdCode = "";
        String name = "";
        String type = "";
        try {
            Document doc = new E12GenericUtility().parseString(this.formalFilterInfoStr);
            NodeList nlFormAlarg = doc.getElementsByTagName("DEFAULT_CODE");
            if (nlFormAlarg.item(0) != null) {
                prdCode = nlFormAlarg.item(0).getFirstChild().getNodeValue();
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return prdCode;
    }

    public String getFormalFilterDisplayNames() throws ITMException {
        StringBuffer formalFilterNameBuff = new StringBuffer("");
        String formalFilterNameStr = null;
        try {
            int ctr = 0;
            while (ctr < this.formalFilterDisplayNamesList.size()) {
                formalFilterNameBuff.append((String)this.formalFilterDisplayNamesList.get(ctr)).append(FILTER_NAMES_SEP);
                ++ctr;
            }
            formalFilterNameStr = formalFilterNameBuff.toString();
            if (formalFilterNameStr.endsWith(FILTER_NAMES_SEP)) {
                formalFilterNameStr = formalFilterNameStr.substring(0, formalFilterNameStr.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return formalFilterNameStr;
    }

    public void createXmlVals() throws ITMException {
        String fieldName = null;
        String name = null;
        String type = null;
        ArrayList<String> lFieldNameList = new ArrayList<String>();
        ArrayList<String> lNameList = new ArrayList<String>();
        ArrayList<String> lTypeList = new ArrayList<String>();
        ArrayList<String> lValueList = new ArrayList<String>();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document doc = genericUtility.parseString(this.formalFilterInfoStr);
            NodeList nlFormAlarg = doc.getElementsByTagName("FORMALARG");
            int size = nlFormAlarg.getLength();
            int iTot = 0;
            while (iTot < size) {
                Node ndFormAlarg = nlFormAlarg.item(iTot);
                fieldName = ndFormAlarg.getAttributes().getNamedItem("field_name").getNodeValue();
                name = ndFormAlarg.getAttributes().getNamedItem("name").getNodeValue();
                type = ndFormAlarg.getAttributes().getNamedItem("javatype").getNodeValue();
                BaseLogger.log("3", this.userInfo, null, String.valueOf(fieldName) + " *****" + name + "*******" + type);
                String formattedData = "";
                Node valueNode = ndFormAlarg.getFirstChild();
                if (valueNode != null && valueNode.getFirstChild() != null) {
                    formattedData = valueNode.getFirstChild().getNodeValue();
                    if (type.equalsIgnoreCase("date")) {
                        formattedData = genericUtility.getValidDateString(formattedData, genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat());
                    } else if (type.equalsIgnoreCase("datetime")) {
                        formattedData = genericUtility.getValidDateString(formattedData, genericUtility.getApplDateTimeFormat(), genericUtility.getDispDateFormat());
                    }
                } else {
                    formattedData = "";
                }
                lFieldNameList.add(fieldName);
                lNameList.add(name);
                lTypeList.add(type);
                lValueList.add(formattedData);
                ++iTot;
            }
            this.formalFilterNamesList = lFieldNameList;
            this.formalFilterDisplayNamesList = lNameList;
            this.formalFilterTypesList = lTypeList;
            this.formalFilterDefaultValuesList = lValueList;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void setUserFilterData(String filterStrXml) throws Exception {
        try {
            Document doc = new E12GenericUtility().parseString(filterStrXml);
            NodeList filterNodeList = doc.getElementsByTagName("filter");
            int iTot = 0;
            while (iTot < filterNodeList.getLength()) {
                String defaultOptString = filterNodeList.item(iTot).getAttributes().getNamedItem("default_opt").getNodeValue();
                this.defaultOptList.add(iTot, defaultOptString);
                NodeList valueList = filterNodeList.item(iTot).getChildNodes();
                int x = 0;
                while (x < valueList.getLength()) {
                    if (valueList.item(x).getFirstChild() != null) {
                        if (valueList.item(x).getNodeName().equals("name")) {
                            this.userFilterNamesList.add(iTot, valueList.item(x).getFirstChild().getNodeValue());
                        }
                        if (valueList.item(x).getNodeName().equals("expr")) {
                            this.userFilterExprList.add(iTot, valueList.item(x).getFirstChild().getNodeValue());
                        }
                    }
                    ++x;
                }
                ++iTot;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String replaceQestMark(String nameStr, int cntr, String expString) throws Exception {
        String str1 = nameStr;
        String str12 = "";
        int num = 0;
        while (str1.indexOf(63) != -1) {
            StringBuffer filterBuffer = new StringBuffer(str1);
            StringBuffer filterExp = new StringBuffer(expString);
            int indexExp = filterExp.toString().indexOf(63);
            int index = filterBuffer.toString().indexOf(63);
            filterBuffer.replace(index, index + 1, "<input type='text' id='textSpan" + cntr + num + "' size = '30' style='border:solid 1;border-color:lightgrey;font-family:Tahoma;font-size: 12' onFocus='selectedCheckBox(this)' typedata='" + this.assignType(filterExp.toString()) + "'/>");
            filterExp.replace(indexExp, indexExp + 1, "A");
            expString = filterExp.toString();
            filterExp = null;
            str1 = filterBuffer.toString();
            filterBuffer = null;
            ++num;
        }
        return str1;
    }

    private String assignType(String expString) throws Exception {
        String type = "";
        ArgumentBean argumentBean = new ArgumentBean();
        argumentBean.setObjName(this.objName);
        argumentBean.setColumnsInfo();
        ArrayList physicalName = argumentBean.getPhysicalNameList();
        ArrayList dataType = argumentBean.getUserFilterTypeList();
        String[] filterToken = expString.split(" ");
        int i = 0;
        while (i < filterToken.length) {
            BaseLogger.log("3", this.userInfo, null, "----filterToken[i]--" + filterToken[i]);
            ++i;
        }
        i = 0;
        while (i < filterToken.length) {
            int indx = this.getIndex(filterToken[i], physicalName);
            if (filterToken[i + 4].equals("'?'")) {
                type = (String)dataType.get(indx);
                break;
            }
            i += 6;
        }
        return type;
    }

    private int getIndex(String str, ArrayList physicalName) throws Exception {
        int retIdx = -1;
        if (str.trim().startsWith("(")) {
            str = str.substring(str.indexOf("(") + 1, str.length());
        }
        int i = 0;
        while (i < physicalName.size()) {
            if (str.equals((String)physicalName.get(i))) {
                retIdx = i;
                break;
            }
            ++i;
        }
        return retIdx;
    }

    private void setFormalFilterInfoStr(UserInfoBean userInfo) throws ITMException {
        try {
            this.formalFilterInfoStr = this.itmFilterComp.getFilterInfoString(this.objName, userInfo);
            this.createXmlVals();
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void setUserFilterInfoStr(UserInfoBean userInfo) throws ITMException {
        String retUserRights = "";
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            if (userInfo != null) {
                DBAccessEJB dbAccess = new DBAccessEJB();
                retUserRights = dbAccess.getUserInfoString(this.objName, this.userInfo.getLoginCode(), this.userInfo.getProfileId(), this.userInfo.getUserLevel(), userInfo);
                this.setUserFilterData(retUserRights);
                dbAccess = null;
            } else {
                retUserRights = Messages.getString("ITMFilterModel_userInfoNotInSession");
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }
}

