package ibase.communication;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import org.json.JSONArray;
import org.json.JSONObject;

import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;

public class WhatsAppComm {

	private DBAccessEJB dbAccess = null;

	public String sendWhatsApp(String actionInfo, String WhatsappXMLString, UserInfoBean userInfo) {
		BaseLogger.log("3", null, null, " sendWhatsApp Testing 06-May-25==> ");
		BaseLogger.log("3", null, null, "WhatsappXMLString ==> " + WhatsappXMLString);
		BaseLogger.log("3", null, null, " ActionInfo==> " +actionInfo);

		try {

			//DBAccessEJB dbAccess = new DBAccessEJB();

			String	jsonObject = getDBAccess().getDBColumnValue("AUTH_APPS_API", "SERVICE_SETTING",
					(" APP_ID = '" + actionInfo + "' "), userInfo.getTransDB());
			BaseLogger.log("3", null, null, "jsonObject::: [" + jsonObject + "]");
			
			JSONObject jsonObj = new JSONObject(jsonObject);

			String phoneNumber = jsonObj.getString("whatsappNumber");
			String template_name = jsonObj.getString("template_name");
			String broadcast_name = jsonObj.getString("broadcast_name");
			JSONArray parameters = jsonObj.getJSONArray("parameters");
			
			JSONObject jsonBodyObj = new JSONObject();
			jsonBodyObj.put("template_name", template_name);
			jsonBodyObj.put("broadcast_name", broadcast_name);
			jsonBodyObj.put("parameters", parameters);
			
			String jsonBody = jsonBodyObj.toString();

			
			String channelId = "+919673134809"; 
			String accessToken = getDBAccess().getDBColumnValue("USER_ACC_CHANNEL", "TOKEN_ID",
					(" CHANNEL_UUID = '" + channelId + "' "), userInfo.getTransDB());
			BaseLogger.log("3", null, null, "accessToken::: [" + accessToken + "]");
			

			String apiUrl = getDBAccess().getDBColumnValue("AUTH_APPS_API", "ENDPOINT",
					(" APP_ID = '" + actionInfo + "' "), userInfo.getTransDB());
			apiUrl = apiUrl + phoneNumber;
			BaseLogger.log("3", null, null, "ENDPOINT::: [" + apiUrl + "]");


			URL url = new URL(apiUrl);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();

			// Set headers
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Authorization", "Bearer " + accessToken);

			// Replace with your token
			conn.setRequestProperty("Content-Type", "application/json-patch+json");
			conn.setDoOutput(true);
			
			/*
			 String jsonBody = "{"
		        	    + "\"template_name\": \"thank_you_for_shop\","
		        	    + "\"broadcast_name\": \"T1\","
		        	    + "\"parameters\": []"
		        	    + "}";
			 */
			
			// Write body
			try (OutputStream os = conn.getOutputStream()) {
				byte[] input = jsonBody.getBytes("utf-8");
				os.write(input, 0, input.length);
			}

			// Get response
			int responseCode = conn.getResponseCode();
			BaseLogger.log("3", null, null, "WhatsApp API Response Code: " + responseCode);

			if (responseCode == 200 || responseCode == 201) {
				BaseLogger.log("3", null, null, "Message sent successfully via WhatsApp.");
			} else {
				BaseLogger.log("3", null, null, "Failed to send WhatsApp message. HTTP code: " + responseCode);
			}

			conn.disconnect();

		} catch (Exception e) {
			BaseLogger.log("3", null, null, "Error sending WhatsApp message: " + e.getMessage());
			e.printStackTrace();
		}

		return WhatsappXMLString;
	}

	private DBAccessEJB getDBAccess() {
		try {
			if (dbAccess == null) {

				dbAccess = new DBAccessEJB();
			}
		}

		catch (Exception e) {
			e.printStackTrace();
		}

		return dbAccess;
	}
}
