package ibase.webitm.utility.wsfa;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.ITMException;

public class CommonMethods {
	UserInfoBean userInfoGlobal = new UserInfoBean();
	public CommonMethods(String userCode) {
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		try {
			UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
			userInfoGlobal = userInfo;
		} catch (BaseException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public CommonMethods() {
		//TODO Auto-generated constructor stub
	}

	private String getDetailXMLDomString( String objName, String objContext, String editFlag, String pkValues, String argFieldValues )throws RemoteException,ibase.webitm.utility.ITMException, ITMException
	{
		String resultString = "";
		//Added By Nilesh Start ::12-05-2017
		MasterStatefulLocal masterStateful=null;
		//Added By Nilesh End ::12-05-2017
		try
		{
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			int randInt = new Random().nextInt();
			masterStateful.setEditorId( ""+randInt );
			masterStateful.setUserInfo( userInfoGlobal );
			resultString = masterStateful.getDetailXMLDomString( objName, objContext, editFlag, pkValues, argFieldValues );
		}
		catch (NamingException e)
		{
//			//BaseLogger.log("0",null,null,"NamingException :: getDetailXMLDomString() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		//Added By Nilesh Start ::12-05-2017
		finally
		{
			if(masterStateful!=null)
			{
				masterStateful.remove();
				masterStateful=null;
			}
		}
		//Added By Nilesh End ::12-05-2017
		return resultString;
	}
	
	private InitialContext getInitialContext() throws ITMException	
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
//			//BaseLogger.log("0",null,null, "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			//BaseLogger.log("0",null,null, "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
	
	public String getSortedJson(String xmlStr,String objName) {
		StringBuilder json = new StringBuilder("{\"Root\":{");
		Document document = convertStringToDocument(xmlStr);
		try {
			UploadFileEJB uploadFileEJB = new UploadFileEJB();
			Map<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, userInfoGlobal);
			Map<String,List<String>> detailDataMap = new TreeMap<>();
			for(int mapIndex =1;mapIndex<=formDetailInfo.size();mapIndex++)
			{
				NodeList detailNodeList = document.getElementsByTagName("Detail"+mapIndex);
				for(int detailIndex=0;detailIndex<detailNodeList.getLength();detailIndex++) {
					Node detailNode = detailNodeList.item(detailIndex);
					//BaseLogger.log("3", null, null,"DetailNode="+detailNode.getNodeName());
					NodeList detailList = detailNode.getChildNodes();
					String data = "";
					for(int index=0;index<detailList.getLength();index++) 
					{
					  Node child = detailList.item(index);
					  
					  if(child.getTextContent().contains("{") && child.getTextContent().contains("}") ) {
						  //BaseLogger.log("3", null, null,"Found Json obj"+child.getTextContent());
						  String jsonData ="\""+ child.getTextContent().replace("\"", "\\\"")+"\"";
						  //BaseLogger.log("3", null, null,"Found Json obj"+jsonData);
						  data+="\""+child.getNodeName()+"\":"+jsonData+",";
					  }
					  else if(child.getTextContent().equals("\"\"")) {
						  data+="\""+child.getNodeName()+"\":"+child.getTextContent()+",";
					  }
					  else {
						  data+="\""+child.getNodeName()+"\":\""+child.getTextContent()+"\",";
					  }
					  /*if(child.getTextContent().equals("\"\"")) {
						  data+="\""+child.getNodeName()+"\":"+child.getTextContent()+",";
					  }
					  else {
					  data+="\""+child.getNodeName()+"\":\""+child.getTextContent()+"\",";
					  }*/
					  
					}
					  
					  if(!data.equals("")) {
						  data="{"+data.substring(0,data.length()-1)+ "}";  
					  }
					 // //BaseLogger.log("3", null, null,"Data Json=="+data);
					//
					
					////BaseLogger.log("3", null, null,"data string="+detailNode.getNodeName()+"["+data+"}");
					if(!detailDataMap.containsKey(detailNode.getNodeName())) {
						////BaseLogger.log("3", null, null,"Key Not Found==");
						List<String>list = new ArrayList<>();
						list.add(data);
						detailDataMap.put(detailNode.getNodeName(), list);
					}
					else
					{
						////BaseLogger.log("3", null, null,"Key Found==");
						List<String>list = detailDataMap.get(detailNode.getNodeName());
						list.add(data);
						
						detailDataMap.put(detailNode.getNodeName(),list);
					}
				}
			}
			
			detailDataMap.forEach((key,value)->{
				////BaseLogger.log("3", null, null,"Key json="+key);
				json.append("\""+key+"\":");
				////BaseLogger.log("3", null, null,"value json="+value);
				json.append(value+",");
			});
			json.append("}}");
			////BaseLogger.log("3", null, null,"Detail Data with quot treeMap"+detailDataMap.toString());
			
			////BaseLogger.log("3", null, null,"Formatted with old  JSON String==["+json);
			
		}catch(Exception e) {
			//BaseLogger.log("3", null, null,"Error in getSortedJson()"+e.getMessage());
		}
		
		return json.toString().replace("],}", "]}");
	}
	
	private  Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
        DocumentBuilder builder;  
        try  
        {  
            builder = factory.newDocumentBuilder();  
            Document doc = builder.parse( new InputSource( new StringReader( xmlStr ) ) ); 
            return doc;
        } catch (Exception e) {  
            e.printStackTrace();  
        } 
        return null;
    }
	
	public String getFormattedXML(String result,String objName) {//with multiple rows
		StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root>");
		try {
		UploadFileEJB uploadFileEJB = new UploadFileEJB();
		
		DocumentBuilder builder =  DocumentBuilderFactory.newInstance().newDocumentBuilder();
		Document document = builder.parse(new ByteArrayInputStream(result.getBytes()));
		Map<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, userInfoGlobal);
		//BaseLogger.log("3", null, null,"formDetailInfoMAP=["+formDetailInfo+"]");
		for(int mapIndex =1;mapIndex<=formDetailInfo.size();mapIndex++)
		{
			NodeList detailNodeList = document.getElementsByTagName("Detail"+mapIndex);
			//BaseLogger.log("3", null, null,"Detail node count="+detailNodeList.getLength());
			for(int detailIndex=0;detailIndex<detailNodeList.getLength();detailIndex++)
			{
				if(!detailNodeList.item(detailIndex).getNodeName().contains("#")) 
				{
					Node detailNode = detailNodeList.item(detailIndex);
					xml.append("<"+detailNode.getNodeName()+">");
				
					NodeList detailChildList = detailNode.getChildNodes();
					for(int childIndex=0;childIndex<detailChildList.getLength();childIndex++) {
					  Node childNode = detailChildList.item(childIndex);
					  if(!childNode.getNodeName().contains("#") && !childNode.getNodeName().equalsIgnoreCase("attribute")) {
						  String data="\"\"";
						  if(childNode.hasChildNodes()) {
								data = childNode.getFirstChild().getTextContent();
							}
						  xml.append("<"+childNode.getNodeName()+"><![CDATA["+data+"]]>");
						  xml.append("</"+childNode.getNodeName()+">");
					  }//end check child empty
				}
					xml.append("</"+detailNode.getNodeName()+">");
			}
			}//end check empty node
		}
		xml.append("</Root>");
		}catch(Exception e) {
			e.printStackTrace();
		}
		//BaseLogger.log("3", null, null,"xml String output="+xml.toString());
		return xml.toString();
	} 
	public int jsonDetailCount(String jsonData) {

		int detailCount = 0;

		try {

			JSONObject jsonObject = new JSONObject(jsonData);

			JSONObject rootObject = jsonObject.getJSONObject("Root");



			for (int i = 1; i <= rootObject.length(); i++) {

				if (rootObject.has("Detail" + i)) {

					detailCount++;

				}

			}



			System.out.println("Number of Detail objects: " + detailCount);

		} catch (Exception e) {



		}

		return detailCount;

	}

	// Added by Gagan B. method returns how many detail object present in JSON 22-JUN-23 -- [END]

	

	// Added by Gagan B. method formats the order of JSON -- [22-JUN-23/START]

	public String jsonFormatter(String jsonData, int detailCount) {

		String finalJson = "";

		try {

			JSONObject originalObject = new JSONObject(jsonData);



			StringBuilder jsonBuilder = new StringBuilder();

			jsonBuilder.append("{ \"Root\": {");



			boolean isFirstDetail = true;

			for (int i = 1; i <= detailCount; i++) {

				String detailArrayName = "Detail" + i;

				if (originalObject.getJSONObject("Root").has(detailArrayName)) {

					JSONArray jsonArray = originalObject.getJSONObject("Root").getJSONArray(detailArrayName);



					if (!isFirstDetail) {

						jsonBuilder.append(",");

					}



					jsonBuilder.append("\"").append(detailArrayName).append("\": ").append(jsonArray.toString());

					isFirstDetail = false;

				}

			}



			jsonBuilder.append("}}");

			finalJson = jsonBuilder.toString();



			System.out.println("Formatted JSON: " + finalJson);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return finalJson;

	}
}
