package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException; 
import java.text.SimpleDateFormat;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import java.util.Date;
import javax.ejb.Stateless;
import javax.ejb.CreateException;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;

//Modified by Ramchandra on [07/08/2012] [To add elements in to Vector class for validation]
import java.util.Vector;

//@Stateless
public class StrgSeriesPsrCopy extends ValidatorEJB implements StrgSeriesPsrCopyLocal,StrgSeriesPsrCopyRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility(); 

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String  errString = null;
		System.out.println("Validation Start..........");
		try
		{
			System.out.println("xmlString:::"+xmlString);
			/*dom = parseString(xmlString);
			dom1 = parseString(xmlString1); 
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}*/
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
				System.out.println("xmlString -- wfValData> " + xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
				System.out.println("xmlString1 --wfValData > " + xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
				System.out.println("xmlString2 -- wfValData> " + xmlString2);
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : StrgSeriesPsrCopyEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		//ConnDriver connDriver = new ConnDriver();	//Commented by vinayak on [11/07/2016]
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String sql = "";
		String errString = "";
		String errCode = "";
		String childNodeName = null; 
		String userId = "";
		String userType = ""; // Modified by Rupesh on 04/09/2012 [To fetch user type of login employee code]
		int ctr,currentFormNo=0;
		int childNodeListLength;
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]
		String fldStaffSiteString = "";
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			stmt = conn.createStatement();
			//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level 
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");

			//Modified by Ramchandra on [07/08/2012] [To retrive Employee Hierarcy of loginEmpCode][Start]
			PreparedStatement pstmt2 = null;
			ResultSet rs2 = null;
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			// Modified by Rupesh on 04/09/2012 [Fetch user type for login employee code like HO,Manager etc]
			userType = getUserType(loginEmpCode,conn);

			System.out.println("[StrgSeriesPsrCopy][wfValData()][loginEmpCode]" +loginEmpCode);
			Vector vec = new Vector();

			//Modified by Ramchandra on [13/10/2012][To Validate for sales persons if other than Hierarcy ][Start]
			//sql = "SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  AND RELIEVE_DATE IS NULL START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 AND E.RELIEVE_DATE IS NULL ";

			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]
			
			//sql = "SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 ";

			fldStaffSiteString = getFldStaffSiteList(conn);
			System.out.println("Inside [StrgSeriesPrsCopy][wfValData]fldStaffSiteString::["+fldStaffSiteString+"]");
			
			sql = "SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ("+getFormattedStringBuff(fldStaffSiteString)+")  START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 ";

			//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

			pstmt2 = conn.prepareStatement(sql);
			pstmt2.setString(1, loginEmpCode);
			System.out.println("[StrgSeriesPsrCopy][wfValData()][SQL ::]"+sql);
			rs2 = pstmt2.executeQuery();
			while(rs2.next())
			{
				String empCodeHierarchy = rs2.getString( 1 );
				vec.addElement(empCodeHierarchy.trim());
			}
			if (rs2 != null)
			{
				rs2.close();
				rs2 = null;
			}
			if (pstmt2 != null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			System.out.println("[StrgSeriesPsrCopy][wfValData()][Employee in Hierarcy] "+vec);
			//Modified by Ramchandra on [07/08/2012] [To retrive Employee Hierarcy of loginEmpCode][End]

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						int cnt;
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equals("sales_pers__from"))
						{
							if ( childNode.getFirstChild() == null ) //Condition Added By Gulzar - 25/08/08 Req ID: SY89SUN001
							{
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers__from",errCode,userId);
								break;
							}
							else
							{
								String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom);
								int spCntr = 0;
								sql = "SELECT COUNT(*) AS SPCNTR FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersFrom +"' ";
								System.out.println("SQL from sales_pers :: "+sql);
								rs = stmt.executeQuery(sql);	
								if(rs.next())
								{
									spCntr = rs.getInt("SPCNTR");
								}
								rs.close();
								if (spCntr == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers__from",errCode,userId);
									break;
								}

								//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode] [Start]
								else
								{
									//Modified by Rupesh on [03/09/2012] [To Validate Hierarcy in case of Manager only]
									//if (!vec.contains(salesPersFrom.trim()))
									
									if (userType.trim().length() > 0 && userType.equalsIgnoreCase("M") && !vec.contains(salesPersFrom.trim()))
									{											
										errString = getErrorString("sales_pers__from","INVHIEEMP",userId);
										break;
									}									
								}
								//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode] [End]

							}
						}
						else if (childNodeName.equals("sales_pers__to"))
						{
							if ( childNode.getFirstChild() == null ) //Condition Added By Gulzar - 25/08/08 Req ID: SY89SUN001
							{
								errCode = "VMSALESPER";
								errString = getErrorString("sales_pers__to",errCode,userId);
								break;
							}
							else
							{
								String salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom);	

								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][Start]							
								String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom);
								salesPersFrom = salesPersFrom.trim();
								salesPersTo =salesPersTo.trim();
								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][End]
								
								int spCntr = 0;
								
								sql = "SELECT COUNT(*) AS SPCNTR FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
								System.out.println("SQL from sales_pers :: "+sql);
								rs = stmt.executeQuery(sql);	
								if(rs.next())
								{
									spCntr = rs.getInt("SPCNTR");
								}
								rs.close();
								if (spCntr == 0)
								{
									errCode = "VSALPER";
									errString = getErrorString("sales_pers__to",errCode,userId);
									break;
								}

								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][Start]							
								else if (salesPersFrom.equalsIgnoreCase(salesPersTo))
								{
									errString = getErrorString("sales_pers__to","INVDUPEMP",userId);
									break;
								}
								//Modified by Rupesh on [08/08/2012] [To Validate duplicate emp][End]							

								//Modified by Ramchandra on [07/08/2012] [To validate for employee relieved or not] [Start]
								else 
								{
									String empRelieveDate = "";
									PreparedStatement pstmt1 = null;
									ResultSet rs1 = null;
									if(salesPersTo != null)
									{	
										sql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE =? ";
										pstmt1 = conn.prepareStatement(sql);
										pstmt1.setString(1, salesPersTo);
										rs1 = pstmt1.executeQuery();
										if(rs1.next())
										{
											empRelieveDate = rs1.getString("RELIEVE_DATE");
										}
										if (rs1 != null)
										{
											rs1.close();
											rs1 = null;
										}
										if (pstmt1 != null)
										{
											pstmt1.close();
											pstmt1 = null;
										}
										if (empRelieveDate != null && empRelieveDate.trim().length() > 0 )
										{
											errString = getErrorString("sales_pers__to","INVRELEMP",userId);
											break;
										}

										//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode][Start]
										else
										{
											//Modified by Rupesh on [03/09/2012] [To Validate Hierarcy in case of Manager only]
											//if (!vec.contains(salesPersTo))
											
											if (userType.trim().length() > 0 && userType.equalsIgnoreCase("M") && !vec.contains(salesPersTo))
											{
												errString = getErrorString("sales_pers__to","INVHIEEMP",userId);
												break;
											}											
										}
										//Modified by Ramchandra on [07/08/2012] [To Validate Employee not in Hierarcy of loginEmpCode][End]

									}						 
								}
								//Modified by Ramchandra on [07/08/2012] [To validate for employee relieved or not] [End]

							}
						}
						else if (childNodeName.equals("division_opt"))
						{
							if (childNode.getFirstChild() == null)
							{
								errCode = "VDIVOPT";
								errString = getErrorString("division_opt",errCode,userId);
								break;
							}
						}
						else if (childNodeName.equals("copy_opt"))
						{
							if (childNode.getFirstChild() == null)
							{
								errCode = "VCOPYOPT";
								errString = getErrorString("copy_opt",errCode,userId);
								break;
							}
						}
					}//END FOR
					break;
			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch ( Exception e){}
		}
		System.out.println("ErrString ::"+ errString);
		return errString;
	}//END OF VALIDATION 

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = null;
		try
		{
			dom = parseString(xmlString); 
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1); 
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgSeriesPsrCopyEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
        return valueXmlString; 
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
		Statement stmt = null;
		ResultSet rs = null;
		NodeList parentNodeList = null;
		Node parentNode = null; 
		Node childNode = null;
		NodeList childNodeList = null;
		String childNodeName = "";
		StringBuffer valueXmlString = new StringBuffer();
		String columnValue = "";
		String sql = "";
		String userId = "";
		String entityCode = "";//Added By Gulzar - 25/08/08 Req ID : SY89SUN001
		
		int count = 0;
		int ctr = 0;
		int currentFormNo = 0;
		Exception exc = new Exception("Editing is not allowed......");
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			//stmt = conn.createStatement();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"); //Added By Gulzar - 25/08/08 Req ID : SY89SUN001
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[StrgSeriesPsrCopyIcEJB] [itemChanged] :currentFormNo ....." +currentFormNo);
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
			//valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?><Root><header><editFlag>");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			valueXmlString.append(editFlag).append("</editFlag></header>");
			valueXmlString.append("<Detail>");	
			System.out.println("Current Form No ["+currentFormNo+"]");	
			switch (currentFormNo)
			{
				case 1:					
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0;
					int childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild() != null)
							{
								columnValue=childNode.getFirstChild().getNodeValue().trim();
							}
						}
						ctr++;
					}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));					
					if (currentColumn.trim().equals("itm_default"))
					{
						String salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom);
						System.out.println("Sales Pers to ===========================>1 item default :: "+salesPersTo);
						String spName = "";

						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][Start]						
						
						String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
							
						String userType = "";
						userType = getUserType(loginEmpCode,conn);
						System.out.println("[StrgSeriesPsrCopy] [itemChanged()][userType] "+userType);
						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][End]
						
						//Added By Gulzar - 25/08/08 Req ID : SY89SUN001

						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][Start]
						/*if ( salesPersTo == null || salesPersTo.trim().length() == 0 )
						{
							salesPersTo = entityCode;
						}*/
						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][End]

						if (salesPersTo != null && salesPersTo.trim().length() > 0 )
						{
							sql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = '"+salesPersTo+"'";
							stmt = conn.createStatement();
							rs = stmt.executeQuery(sql);
							if ( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							rs.close();
							if ( count > 0 )
							{
								sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
								System.out.println("SQL for sp_name from sales_pers :: "+sql);
								rs = stmt.executeQuery(sql);	
								if(rs.next())
								{
									spName = rs.getString("SP_NAME");	
								}
								rs.close();
								
								//Modified By Rupesh [08/08/2012] [To protect sales_pers__to]
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect = '1'>").append(salesPersTo).append("</sales_pers__to>\r\n");	
								valueXmlString.append("<sales_pers__to protect = '1'><![CDATA[").append(salesPersTo).append("]]></sales_pers__to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
							}
							else
							{
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect = '0'>").append(salesPersTo).append("</sales_pers__to>\r\n");	
								valueXmlString.append("<sales_pers__to protect = '0'><![CDATA[").append(salesPersTo).append("]]></sales_pers__to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]	
							}
							stmt.close();
						}
						//End Changes Gulzar - 25/08/08 Req ID : SY89SUN001

						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][Start]
						/*valueXmlString.append("<sales_pers__to>").append(salesPersTo == null ? "" :salesPersTo).append("</sales_pers__to>\r\n");//Gulzar - 28/12/09 */
						else
						{
							salesPersTo = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
							System.out.println("[StrgSeriesPsrCopy][itemChanged()] [salesPersTo :: ]"+salesPersTo);
							Statement cstmt = null;
							ResultSet crs = null;
							String spnamesql = "";
							spnamesql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
							System.out.println("[StrgSeriesPsrCopy][itemChanged()] [spnameSQL] :: "+spnamesql);
							cstmt = conn.createStatement();
							crs = cstmt.executeQuery(spnamesql);	
							if(crs.next())
							{
								spName = crs.getString("SP_NAME");	
							}
							if (crs != null)
							{
								crs.close();
								crs = null;
							}
							if ( cstmt != null )
							{
								cstmt.close();
								cstmt = null;
							}
							if ( userType != null && (userType.equalsIgnoreCase("M")|| userType.equalsIgnoreCase("H")))
							{													
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [Start]
								//valueXmlString.append("<sales_pers__to protect= '0'>").append(salesPersTo).append("</sales_pers__to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect= '0'>").append("").append("</sales_pers__to>\r\n");
								//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
								valueXmlString.append("<sales_pers__to protect= '0'><![CDATA[").append("").append("]]></sales_pers__to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [End]
							}
							else
							{	
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect= '1'>").append(salesPersTo).append("</sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect= '1'><![CDATA[").append(salesPersTo).append("]]></sales_pers__to>\r\n");
								//Modified By Rupesh [11/01/2013] [To set name of emp_to] [Start]
								//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append(spName == null ? "" :spName).append("]]></name_to>\r\n");
								//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
								//Modified By Rupesh [11/01/2013] [To set name of emp_to] [End]
							}
						}
						// Modified by Ramchandra [07/08/2012][To enable if login employee is manager or ho][End]
				
						//Modified By Rupesh [11/01/2013] [To set blank emp_to] [Start]
						//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
						//Modified By Rupesh [11/01/2013] [To set blank emp_to] End]
						//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
						//valueXmlString.append("<division_opt>").append("N").append("</division_opt>\r\n");
						//valueXmlString.append("<copy_opt>").append("1").append("</copy_opt>\r\n");
						valueXmlString.append("<division_opt><![CDATA[").append("N").append("]]></division_opt>\r\n");
						valueXmlString.append("<copy_opt><![CDATA[").append("1").append("]]></copy_opt>\r\n");
						//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
					}
					else if (currentColumn.trim().equals("sales_pers__from"))
					{
						String salesPersFrom = genericUtility.getColumnValue("sales_pers__from",dom); 
						String spName = "";
						sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersFrom +"' ";
						System.out.println("SQL for sp_name from sales_pers :: "+sql);
						stmt = conn.createStatement();
						rs = stmt.executeQuery(sql);	
						if(rs.next())
						{
							spName = rs.getString("SP_NAME");	
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<name_from>").append(spName == null ? "" :spName).append("</name_from>\r\n");
							valueXmlString.append("<name_from><![CDATA[").append(spName == null ? "" :spName).append("]]></name_from>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<name_from>").append(" ").append("</name_from>\r\n");	
							valueXmlString.append("<name_from><![CDATA[").append(" ").append("]]></name_from>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}
						rs.close();
						stmt.close();
					}
					else if (currentColumn.trim().equals("sales_pers__to"))
					{
						String salesPersTo = genericUtility.getColumnValue("sales_pers__to",dom); 
						System.out.println("Sales Pers to ===========================> "+salesPersTo);
						String spName = "";
						if (salesPersTo != null && salesPersTo.trim().length() > 0)
						{
							sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
							System.out.println("SQL for sp_name from sales_pers :: "+sql);
							stmt = conn.createStatement();
							rs = stmt.executeQuery(sql);	
							if(rs.next())
							{
								spName = rs.getString("SP_NAME");	
							}
							rs.close();
							stmt.close();

							//Modified by Rupesh [08/08/2012] [To enable sales_pers__to]
							//valueXmlString.append("<sales_pers__to protect = '1' >").append(salesPersTo == null ? "" :salesPersTo).append("</sales_pers__to>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<sales_pers__to>").append(salesPersTo == null ? "" :salesPersTo).append("</sales_pers__to>\r\n");	

							//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
							valueXmlString.append("<sales_pers__to><![CDATA[").append(salesPersTo == null ? "" :salesPersTo).append("]]></sales_pers__to>\r\n");	

							valueXmlString.append("<name_to><![CDATA[").append(spName == null ? "" :spName).append("]]></name_to>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<name_to>").append(spName == null ? "" :spName).append("</name_to>\r\n");
							valueXmlString.append("<name_to><![CDATA[").append(spName == null ? "" :spName).append("]]></name_to>\r\n");
							//Modified By Ganesh [13/05/2013][To set the value in cdata of xml][End]
						}

					}
					valueXmlString.append("</Detail>");
					break;		
			}//END OF SWITCH
			valueXmlString.append("</Root>");				
							
		}//END OF TRY		
		catch(Exception e)
		{
			System.out.println("Exception ::"+ e.getMessage());
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}//END OF ITEMCHANGE	

	// Modified by Ramchandra [07/08/2012][To identify login employee is manager or Ho][start]
	private String getUserType(String empCode,Connection conn) throws ITMException
	{
		System.out.println("In getUserType() method");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String empCodeHO = "";
		String userType1 = "";
		String selectSql = "";
		boolean isEmpMgr = false;
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.GRADE = B.GRADE_CODE " + 
				  "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			System.out.println("[StrgSeriesPsrCopy][getUserType()][selectSQL >>]"+selectSql);
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));	
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (empCodeMGR != null && empCodeMGR.trim().length() > 0)
			{
				userType1 = "M";
				isEmpMgr = true;
			}
			if (isEmpMgr == false)
			{
				selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.PROFILE_ID = B.PROFILE_ID " +
				  "AND B.APPLICATION = 'MRO' " +
				  "AND B.MENU_ROW = 1 " +       
				  "AND B.MENU_COL = 1 " +       
				  "AND B.MENU_SUBCOL = 1 " +
				  "AND B.LEVEL_4 = 1 " +        
				  "AND B.LEVEL_5 = 1 " +        
				  "AND B.MENU_NAME = 'MR Online Application' ";

				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString( 1, empCode );
				System.out.println("[StrgSeriesPsrCopy][getUserType()][selectSQL for HO >>] "+selectSql);
				rs = pstmt.executeQuery();	
				if(rs.next())
				{
					empCodeHO = checkNull(rs.getString("EMP_CODE"));	
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (empCodeHO != null && empCodeHO.trim().length() > 0)
				{
					userType1 = "H";				
				}
			}	
			System.out.println("[StrgSeriesPsrCopy][getUserType()][userType1 >>]"+userType1);
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return userType1;		
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	// Modified by Ramchandra [07/08/2012][To identify login employee is manager or Ho][End]

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

	public String getFldStaffSiteList(Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			 pstmt = conn.prepareStatement(sql);
			 rs = pstmt.executeQuery();
			System.out.println("Inside [StrgSeriesPrsCopy][getFldStaffSiteList]sql::>"+sql);

			 if (rs.next())
			 {
				fldStaffSiteString = rs.getString("PROP_VALUE");
				fldStaffSiteString = (fldStaffSiteString == null)? "" : fldStaffSiteString.trim();
				System.out.println("Inside [StrgSeriesPrsCopy][getFldStaffSiteList]fldStaffSiteString::["+fldStaffSiteString+"]");
			 }
			 if (rs!=null)
			 {
				 rs.close();
				 rs = null;
			 }
			 if (pstmt!=null)
			 {
				 pstmt.close();
				 pstmt = null;
			 }
			
		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [StrgSeriesPrsCopy][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
				 rs.close();
				 rs = null;
				}
				if (pstmt!=null)
				{
				 pstmt.close();
				 pstmt = null;
				}				
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [StrgSeriesPrsCopy][getFldStaffSiteList]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		System.out.println("Returning from [StrgSeriesPrsCopy][getFldStaffSiteList]["+fldStaffSiteString+"]");
		return fldStaffSiteString;
	}

	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;
			
			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{ 
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}										
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return dataString.toString();
	}

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

}
