package ibase.webitm.ejb.wsfa.masters;


import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import javax.ejb.Stateless;

/**
 * Session Bean implementation class RetailBrandEJB
 */
@Stateless
public class RetailBrandEJB  extends ValidatorEJB implements RetailBrandEJBRemote, RetailBrandEJBLocal
{

	

    /**
     * Default constructor. 
     */
    public RetailBrandEJB() 
    {
        // TODO Auto-generated constructor stub
    }

	
	/**
	 * databse name
	 */
	protected static String database = CommonConstants.DB_NAME;

	/**
	 * this method handle validation on form
	 */
	
	
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * This method handles validation on form.
	 * 
	 * @param xmlString contains form data
	 * @param xmlString1 contains form data
	 * @param xmlString2 contains form data
	 * @param objContext contains form no.
	 * @param editFlag contains  editFlag eg. "A" or "E"
	 * @param xtraParams contains user info.  
	 */
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: RetailerBrand: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from Retailer Brand wfValData");
		return (errString); 
	}
	

	/**
	 * This method handles validation on form.
	 * 
	 * @param dom contains form data
	 * @param dom1 contains form data
	 * @param dom2 contains form data
	 * @param objContext contains form no.
	 * @param editFlag contains  editFlag eg. "A" or "E"
	 * @param xtraParams contains user info.  
	 */
	
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String columnName = "";
		String columnValue = "";
		String brandCode="";	
		String userId = "";
		String errString = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String errorType = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String scCode = "";
		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		
		String errCode = "";
		
		String effDate="";
		String validUptoDate="";
		
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			System.out.println("wfValData validation");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());//added by arpit on 08-june-2015
			//Commented by Saiprasad G on [09/04/2019] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by Saiprasad G on [09/04/2019] [END]
			connectionObject = getConnection();
			
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				System.out.println("childNodeName:["+childNodeName+"]");
				switch(currentFormNo)
				{
					case 1:
						 if (childNodeName.equalsIgnoreCase("retailer_code"))
						{
							if(childNode.getFirstChild() == null )	
							{
								errCode = "NULLRETCOD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								String sql = "SELECT COUNT(1) FROM RETAILER WHERE RETAILER_CODE = ?";
								pstmt = connectionObject.prepareStatement( sql );
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next())
								{	
									int count = rs.getInt(1);
									if( count == 0 )
									{
										errCode = "VTRETNOMAS";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt=null;
								}
							}
						}
						
						else if (childNodeName.equalsIgnoreCase("brand_code"))
						{
							
							if(childNode.getFirstChild() == null)
							{
								errCode = "DDNULLBRCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}							
							else
							{
								int count=0;
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								brandCode= childNode.getFirstChild().getNodeValue().trim();
								System.out.println("selected brand code["+columnValue+"]");
								String sql="select COUNT(*) from brand where brand_code=? and active_yn='Y'";
								pstmt = connectionObject.prepareStatement( sql );
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next())
								{	
									count = rs.getInt(1);									
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt=null;
								}
								if( count == 0 )
								{
									errCode = "DDINVDBRCD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							
							
							if( editFlag.equals("A") )
							{
								Node sCustCodeNode = dom.getElementsByTagName("retailer_code").item(0);
								if( sCustCodeNode.hasChildNodes() )
								{
																
									String retailerCode = checkNull(sCustCodeNode.getFirstChild().getNodeValue());
									String eff_from = checkNull(genericUtility.getColumnValue("eff_from",dom));
									String valid_upto = checkNull(genericUtility.getColumnValue("valid_upto",dom));
									String brand_code = checkNull(genericUtility.getColumnValue("brand_code",dom));
									String item_ser = checkNull(genericUtility.getColumnValue("item_ser",dom));
									rs=null;
							
									String sql = " SELECT COUNT(*) FROM RETAIL_BRAND WHERE RETAILER_CODE = ? AND BRAND_CODE = ? "+
												 " AND  ITEM_SER = ? AND  EFF_FROM = ? AND  VALID_UPTO   =  ? ";
									
									pstmt = connectionObject.prepareStatement( sql );
									pstmt.setString(1, retailerCode);
									pstmt.setString(2, brand_code);
									pstmt.setString(3, item_ser);
									pstmt.setString(4, eff_from);
									pstmt.setString(5, valid_upto);
									rs = pstmt.executeQuery();
									if( rs.next())
									{	
										int count = rs.getInt(1);
										if( count > 0 )
										{
											errCode = "VMDUPLBRCD";
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());
										}
									}
									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt=null;
									}
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("item_ser"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errCode = "DDNULITMSR";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								/*errString = getErrorString("item_ser","DDNULITMSR",userId );
								break;*/
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								String sql = "SELECT COUNT(1) FROM ITEMSER WHERE ITEM_SER = ?";
								pstmt = connectionObject.prepareStatement( sql );
								pstmt.setString(1, columnValue);
								rs = pstmt.executeQuery();
								if( rs.next())
								{	
									int count = rs.getInt(1);
									if( count == 0 )
									{
										errCode = "DDINVDITSR";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt=null;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("eff_from")) 
						{
							if(childNode.getFirstChild() == null )
							{
								errCode = "VMNULEFFRM";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								effDate=childNode.getFirstChild().getNodeValue().trim();
							}
												
						}
						else if(childNodeName.equalsIgnoreCase("valid_upto")) 
						{
							if(childNode.getFirstChild() == null )
							{
								errCode = "VMNULVALUP";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else 
							{
								validUptoDate=childNode.getFirstChild().getNodeValue().trim();
							}
							
							if( editFlag.equals("A") )
							{

								String retailerCode = checkNull(genericUtility.getColumnValue("retailer_code",dom));
								String eff_from = checkNull(genericUtility.getColumnValue("eff_from",dom));
								String brand_code = checkNull(genericUtility.getColumnValue("brand_code",dom));
								String valid_upto = checkNull(genericUtility.getColumnValue("valid_upto",dom));
							    rs=null;
							    int count = 0;
							    int count1 = 0;
								String sql = "select count(*) from retail_brand where retailer_code=? and brand_code=? and eff_from= ? and valid_upto=?";
								
								pstmt = connectionObject.prepareStatement( sql );
								pstmt.setString(1, retailerCode);
								pstmt.setString(2, brand_code);
								pstmt.setString(3, eff_from);
								pstmt.setString(4, valid_upto);
								rs = pstmt.executeQuery();
								while(rs.next())
								{	
									count = rs.getInt(1);									
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt=null;
								}
								if( count > 0 )
								{
									errCode = "VMRTBDEXTS";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								
								if(count==0)
								{
									sql = " SELECT COUNT(*) FROM RETAIL_BRAND WHERE RETAILER_CODE=? AND BRAND_CODE=? "+
												 "	AND ( "+
												 "	( ( EFF_FROM  BETWEEN ? AND ?  "+
												 "	OR VALID_UPTO BETWEEN ? AND ? ) "+
												 "	AND  ( EFF_FROM > ?  OR VALID_UPTO <  ?)) "+
												 "	OR  (  ? BETWEEN EFF_FROM AND VALID_UPTO  "+
												 "	or    ? BETWEEN EFF_FROM AND VALID_UPTO )) ";
									
									pstmt = connectionObject.prepareStatement( sql );
									pstmt.setString(1, retailerCode);
									pstmt.setString(2, brand_code);
									pstmt.setString(3, eff_from);
									pstmt.setString(4, valid_upto);
									pstmt.setString(5, eff_from);
									pstmt.setString(6, valid_upto);
									pstmt.setString(7, eff_from);
									pstmt.setString(8, valid_upto);
									pstmt.setString(9, eff_from);
									pstmt.setString(10, valid_upto);
									rs = pstmt.executeQuery();
									while(rs.next())
									{	
										count1 = rs.getInt(1);									
									}
									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt=null;
									}
									
									if( count1 > 0 )
									{
										System.out.println("count1 ---------"+count1);
										errCode = "VMINVDRECD";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}									
								}
								
							}						
							
						}
						 break;
					}
			}	
			
			if(effDate.length()>0 & validUptoDate.length()>0)
			{
				Date date1 = sdf.parse(effDate);
				Date date2 = sdf.parse(validUptoDate);
				
				if(date1.compareTo(date2)>0){
					errCode = "INDDTRNG";
					errList.add(errCode);
					errFields.add(childNodeName.toLowerCase());
				}
				
			}	
			int errListSize = errList.size();
			int cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(connectionObject , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}			
		}
		catch(SQLException se)
		{
			System.out.println("Exception: StrgCustomer: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{		
			System.out.println("Exception: StrgCustomer: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}			
		}
		errString = errStringXml.toString();
		return errString;
	}
			
	
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * this method handles itemchange on the form
	 * 
	 * @param xmlString contains form data
	 * @param xmlString1 contains form data
	 * @param xmlString2 contains form data
	 * @param objContext contains form no.
	 * @param currentColumn contains currentColumn to be item changed
	 * @param editFlag contains  editFlag eg. "A" or "E"
	 * @param xtraParams contains user info.
	 */
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :StrgCustomer :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from StrgCustomer itemChanged");
		return errString;
	}

	/**
	 * this method handles itemchange on the form
	 * 
	 * @param dom contains form data
	 * @param dom1 contains form data
	 * @param dom2 contains form data
	 * @param objContext contains form no.
	 * @param currentColumn contains currentColumn to be item changed
	 * @param editFlag contains  editFlag eg. "A" or "E"
	 * @param xtraParams contains user info.
	 */
	
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("RETAILER BRAND EJB ITEMCHANGE");
		String columnValue = "";
		String returnString = "";	
		String localityDescr ="";
		String stanCode = "";				
		String stateCode = "";				
		String city = "";				
		String countCode = "";				
		String pin = "";				
		String district = "";
		String selectSql = ""; 
		String firstName = "";
		String middleName = "";
		String lastName = "";
		String chqName = "";

		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//Commented by Saiprasad G on [09/04/2019] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by Saiprasad G on [09/04/2019] [END]
			connectionObject = getConnection();
			
			String chgDate = "";
			String chgUser = "";
			String chgTerm = "";
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			//SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String effDate="";
			String validUptoDate="";
			
			chgDate = sdf.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
            valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentFormNo ["+currentFormNo+"] currentColumn ["+currentColumn+"]");
			
			
			String scCode = genericUtility.getColumnValue("retailer_code",dom1);
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail>\r\n");
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{	
						System.out.println("itm_default =[itm_default]");
						String localityCode = genericUtility.getColumnValue("locality_code",dom);
						String retailer_code = genericUtility.getColumnValue("retailer_code",dom);
						System.out.println("retailer_code =["+retailer_code+"]");						
						java.util.Calendar dateCreated = java.util.Calendar.getInstance();
						java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
						String sysDate = df.format(dateCreated.getTime());						
						valueXmlString.append("<added_date>").append(sysDate).append("</added_date>\r\n");
			
						
						valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
						
						/*
						String sql = "SELECT RETAILER_NAME FROM RETAILER WHERE RETAILER_CODE = ?";
						pstmt = connectionObject.prepareStatement( sql );
						pstmt.setString(1, columnValue);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							valueXmlString.append("<retailer_name>").append( checkNull( rs.getString("RETAILER_NAME") ) ).append("</retailer_name>\r\n");
						}	
						else
						{
							
							valueXmlString.append("<retailer_name><![CDATA[]]></retailer_name>\r\n");
							}
						if(pstmt != null)
						{
							pstmt.close();
						}				
			              */
					}
										
					else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit")) 
					{
						String itm_div = checkNull(genericUtility.getColumnValue("item_ser",dom));
						String validUpto = checkNull(genericUtility.getColumnValue("valid_upto",dom));
						valueXmlString.append("<item_ser protect='1'>").append(itm_div).append("</item_ser>\r\n");
						valueXmlString.append("<valid_upto protect='1'>").append(validUpto).append("</valid_upto>\r\n");
					}
					
					
					else if ( currentColumn.trim().equalsIgnoreCase("retailer_code") )
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);	
						
						//if(columnValue.trim().length()>=3)
						//{
							StringBuffer fullName = new StringBuffer();
							System.out.println("selected retailer code ["+columnValue+"]");
							String sql = "SELECT RETAILER_NAME FROM RETAILER WHERE RETAILER_CODE = ?";
							pstmt = connectionObject.prepareStatement( sql );
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								valueXmlString.append("<retailer_name>").append( checkNull( rs.getString("RETAILER_NAME") ) ).append("</retailer_name>\r\n");
							}	
							else
							{
								valueXmlString.append("<retailer_name><![CDATA[]]></retailer_name>\r\n");
						    }
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}						
						//}
					}
					
					else if ( currentColumn.equalsIgnoreCase("item_ser") )
					{
						String itemSer = "";
						columnValue = checkNull(genericUtility.getColumnValue(currentColumn,dom));	
						System.out.println("selected item series ["+columnValue+"]");
						String sql = "SELECT DESCR FROM ITEMSER WHERE ITEM_SER = ?";
						pstmt = connectionObject.prepareStatement( sql );
						pstmt.setString(1, columnValue.trim());
						rs = pstmt.executeQuery();
						if( rs.next())
						{	
							itemSer = checkNull(rs.getString(1));
							valueXmlString.append("<descr>").append(itemSer).append("</descr>\r\n");	
						}	
						else
						{
							valueXmlString.append("<descr>").append("").append("</descr>\r\n");								
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt =null;
						}
					}
					else if(currentColumn.equalsIgnoreCase("brand_code"))
					{
						String brand = genericUtility.getColumnValue("brand_code",dom);
						System.out.println("selected brand ["+brand+"]");
						if( brand != null && brand != "")
						{
							String sql = "SELECT Description,y.item_ser,y.descr FROM BRAND x"
									+" join itemser y on x.item_ser=y.item_ser where x.brand_code=? and x.active_yn='Y'"; 
							pstmt = connectionObject.prepareStatement( sql );
							pstmt.setString( 1, brand.trim() );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								String brandDescr = rs.getString(1);
								String itemSer=rs.getString(2);
								String itemSerDescr=rs.getString(3);
								valueXmlString.append("<description>").append( "<![CDATA["+brandDescr.trim()+"]]>" ).append("</description>\r\n");
								valueXmlString.append("<item_ser>").append( "<![CDATA["+itemSer.trim()+"]]>" ).append("</item_ser>\r\n");
								valueXmlString.append("<descr>").append( "<![CDATA["+itemSerDescr.trim()+"]]>" ).append("</descr>\r\n");
							}
						}
						else
						{
							valueXmlString.append("<description>").append( "" ).append("</description>\r\n");
							valueXmlString.append("<item_ser>").append( "" ).append("</item_ser>\r\n");
							valueXmlString.append("<descr>").append( "" ).append("</descr>\r\n");
						}
					}
					valueXmlString.append("</Detail>\r\n");
					break;
				
			}		
					
			
		}
		catch(SQLException se)
		{
			System.out.println("Exception: Retailer Brand: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :Retailer Brand :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");	
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}
	
	
	
	
			
	
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	
	private String errorType(Connection conn , String errorCode) throws ITMException // throws added by kailash on 11-04-18.
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex); 
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	
}
