/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration.scheduledSFTP;

import ibase.bankIntegration.CommonMethods;
import ibase.bankIntegration.unsHsbc.UNSHSBC;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.json.JsonObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledSFTPUploader
implements Schedule {
    E12GenericUtility e12GenericUtility = new E12GenericUtility();
    boolean bankCodeBool = false;
    String bankCode = "";
    UserInfoBean userInfoGlobal = new UserInfoBean();
    NodeList argNodeList = null;

    public String schedule(HashMap arg0) throws Exception {
        return null;
    }

    public String schedule(String name) throws Exception {
        UserInfoBean userInfo;
        BaseLogger.log((String)"2", null, null, (Object)"ScheduledSFTPUploader gsb calling 123------------------");
        BaseLogger.log((String)"3", null, null, (Object)("name::[ " + name + " ]"));
        String scheduleId = "";
        Document schdulerInfoDocument = this.e12GenericUtility.parseString(name);
        NodeList scheduleList = schdulerInfoDocument.getElementsByTagName("SCHEDULE");
        if (scheduleList.getLength() > 0) {
            String idValue;
            Element scheduleElement = (Element)scheduleList.item(0);
            scheduleId = idValue = scheduleElement.getAttribute("id");
            System.out.println("scheduleId value:: " + idValue);
        }
        this.userInfoGlobal = userInfo = new UserInfoBean(this.e12GenericUtility.serializeDom(schdulerInfoDocument.getElementsByTagName("USERINFOXML").item(0).getChildNodes().item(0)));
        this.argNodeList = schdulerInfoDocument.getElementsByTagName("ACTUALPARAMETER");
        int i = 0;
        while (i < this.argNodeList.getLength()) {
            Node childNode = this.argNodeList.item(i);
            if (childNode.getNodeType() == 1 && childNode != null) {
                System.out.println("childNode gsb=[" + childNode + "]");
                this.bankCodeBool = this.isParameterPresent(childNode, "BANK_CODE");
                if (this.bankCodeBool && childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("BANK_CODE")) {
                    this.bankCode = E12GenericUtility.checkNull((String)childNode.getFirstChild().getNodeValue());
                    System.out.println("BankCode = [" + this.bankCode + "]");
                }
            }
            ++i;
        }
        String uploadFileToSFTPResult = this.uploadFileToSFTP(this.bankCode, userInfo, scheduleId);
        System.out.println("uploadFileToSFTPResult gsb=[" + uploadFileToSFTPResult + "]");
        return null;
    }

    public String schedulePriority(String arg0) throws Exception {
        return null;
    }

    private boolean isParameterPresent(Node childNode, String attribName) throws ITMException {
        boolean attribFound = false;
        try {
            System.out.println("attribFound test= [" + childNode.getAttributes() + "]");
            if (childNode != null && childNode.getAttributes() != null) {
                System.out.println("attribFound name= [" + childNode.getAttributes().getNamedItem("name").getNodeValue() + "]");
                if (childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(attribName)) {
                    attribFound = true;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        System.out.println("attribFound = [" + attribFound + "]");
        return attribFound;
    }

    public String uploadFileToSFTP(String bankCode, UserInfoBean userInfo, String scheduleId) {
        BaseLogger.log((String)"3", null, null, (Object)("Inside ScheduledSFTPUploader.uploadFileToSFTP() gsb[ " + bankCode + "]"));
        String uploadFileToSFTPResult = "";
        CommonMethods commonMethods = new CommonMethods();
        DBAccessEJB dbAccessEJB = new DBAccessEJB();
        try {
            File[] files;
            String payIntArgs = dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + bankCode + "'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs gsb[ " + payIntArgs + "]"));
            JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
            String localFolderPath = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
            localFolderPath = String.valueOf(localFolderPath) + File.separator + "XML_files";
            BaseLogger.log((String)"3", null, null, (Object)("Inside localFolderPath[ " + localFolderPath + "]"));
            int fileCount = 0;
            File localFolder = new File(localFolderPath);
            if (localFolder.exists() && localFolder.isDirectory() && (files = localFolder.listFiles((directory, fileName) -> fileName.endsWith(".xml"))) != null) {
                fileCount = files.length - 1;
            }
            BaseLogger.log((String)"3", null, null, (Object)("Number of XML files in the local folder: " + fileCount));
            LocalDateTime currentTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedTime = currentTime.format(formatter);
            BaseLogger.log((String)"3", null, null, (Object)("File uploaded at Time : " + formattedTime));
            Timestamp startingTimestamp = this.getStartingTimestamp(scheduleId, userInfo);
            BaseLogger.log((String)"3", null, null, (Object)("startingTimestampTime : " + startingTimestamp));
            int count = this.getConfirmedTransactionCount(scheduleId, userInfo, formattedTime, bankCode);
            BaseLogger.log((String)"3", null, null, (Object)("Trancasction confirm in misc_payment table Count: " + count));
            Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
            if (fileCount == count || fileCount > count) {
                uploadFileToSFTPResult = commonMethods.uploadFileToSFTP(bankCode, userInfo);
            } else if (fileCount < count) {
                BaseLogger.log((String)"3", null, null, (Object)("Calling processMissingFiles at: " + currentTimestamp));
                boolean processMissingFilesResult = this.processMissingFiles(localFolderPath, startingTimestamp, currentTimestamp, userInfo, bankCode);
                if (processMissingFilesResult) {
                    uploadFileToSFTPResult = commonMethods.uploadFileToSFTP(bankCode, userInfo);
                } else {
                    BaseLogger.log((String)"3", null, null, (Object)"Process failed....");
                }
            }
            System.out.println("uploadFileToSFTPResult gsb=[" + uploadFileToSFTPResult + "]");
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", null, null, (Object)("Exception in ScheduledSFTUploader.uploadFileToSFTP: [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
        }
        return uploadFileToSFTPResult;
    }

    public Timestamp getStartingTimestamp(String scheduleId, UserInfoBean userInfo) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method getStartingTimestamp 12May::");
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Timestamp startingTimestamp = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                connection = connDriver.getConnectDB(transDB);
                String query = "SELECT ADD_DATE FROM BANK_EPAY_STATUS WHERE REMARKS = 'File Uploaded to Bank''s SFTP Server' ORDER BY ADD_DATE DESC FETCH FIRST 1 ROW ONLY";
                preparedStatement = connection.prepareStatement(query);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    startingTimestamp = resultSet.getTimestamp("ADD_DATE");
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Error in getStartingTimestamp @@: [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new Exception("Error fetching the starting timestamp: " + e.getMessage(), e);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("startingTimestamp ===> [" + startingTimestamp + "]"));
        return startingTimestamp;
    }

    public int getConfirmedTransactionCount(String scheduleId, UserInfoBean userInfo, String formattedTime, String bankCode) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method getConfirmedTransactionCount--> \t");
        String query = "SELECT COUNT(*) AS total_confirmed_transactions FROM misc_payment WHERE CONFIRMED = 'Y' AND net_amt > 0 AND BANK_TRANSFER_ID IS NULL AND SUNDRY_TYPE IN ('E','S') AND BANK_CODE = ? AND conf_date BETWEEN ? AND ?";
        int totalCount = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                Timestamp startingTimestamp = this.getStartingTimestamp(scheduleId, userInfo);
                preparedStatement = connection.prepareStatement(query);
                preparedStatement.setString(1, bankCode);
                preparedStatement.setTimestamp(2, startingTimestamp);
                preparedStatement.setTimestamp(3, Timestamp.valueOf(formattedTime));
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    totalCount = resultSet.getInt("total_confirmed_transactions");
                }
            }
            catch (Exception e) {
                throw new Exception("Error fetching confirmed transaction count: " + e.getMessage(), e);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("totalCount of transactions:: ===> [" + totalCount + "]"));
        return totalCount;
    }

    public List<String> findMissingGeneratedFiles(String localFolderPath, Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo, String bankCode) throws Exception {
        File[] files;
        BaseLogger.log((String)"3", null, null, (Object)"Inside findMissingGeneratedFiles...");
        ArrayList<String> missingFiles = new ArrayList<String>();
        List<String> confirmedTranIds = this.getConfirmedTransactionIds(startingTimestamp, currentTimestamp, userInfo, bankCode);
        BaseLogger.log((String)"3", null, null, (Object)("Confirmed Transactions: " + confirmedTranIds));
        File localFolder = new File(localFolderPath);
        HashSet<String> localFileNames = new HashSet<String>();
        if (localFolder.exists() && localFolder.isDirectory() && (files = localFolder.listFiles((dir, name) -> name.endsWith(".xml"))) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                localFileNames.add(file.getName().trim());
                ++n2;
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("Files in Local Folder: " + localFileNames));
        for (String tranId : confirmedTranIds) {
            boolean isFileFound = false;
            for (String fileName : localFileNames) {
                if (!fileName.startsWith(tranId)) continue;
                isFileFound = true;
                break;
            }
            if (isFileFound) continue;
            System.out.println("Missing file for transaction: " + tranId);
            missingFiles.add(tranId);
        }
        BaseLogger.log((String)"3", null, null, (Object)("Final Missing Files: " + missingFiles));
        return missingFiles;
    }

    private List<String> getConfirmedTransactionIds(Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo, String bankCode) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method getConfirmedTransactionIds::::: \t");
        String query = "SELECT tran_id FROM misc_payment WHERE CONFIRMED = 'Y' AND BANK_TRANSFER_ID IS NULL AND BANK_CODE = ? AND SUNDRY_TYPE IN ('E','S') AND conf_date BETWEEN ? AND ?";
        ArrayList<String> confirmedTranIds = new ArrayList<String>();
        Connection connection = null;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                preparedStatement = connection.prepareStatement(query);
                preparedStatement.setString(1, bankCode);
                preparedStatement.setTimestamp(2, startingTimestamp);
                preparedStatement.setTimestamp(3, currentTimestamp);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    confirmedTranIds.add(resultSet.getString("tran_id").trim());
                }
            }
            catch (Exception e) {
                throw new Exception("Error fetching confirmed transaction IDs: " + e.getMessage(), e);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        BaseLogger.log((String)"3", null, null, (Object)("confirmedTranIds in getConfirmedTransactionIds :::-->  \t" + confirmedTranIds));
        return confirmedTranIds;
    }

    public boolean processMissingFiles(String localFolderPath, Timestamp startingTimestamp, Timestamp currentTimestamp, UserInfoBean userInfo, String bankCode) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"Inside the method processMissingFiles....\t");
        BaseLogger.log((String)"3", null, null, (Object)("startingTimestamp:::\t" + startingTimestamp));
        BaseLogger.log((String)"3", null, null, (Object)("currentTimestamp\t" + currentTimestamp));
        UNSHSBC unshsbc = new UNSHSBC();
        List<String> missingFiles = this.findMissingGeneratedFiles(localFolderPath, startingTimestamp, currentTimestamp, userInfo, bankCode);
        for (String tranID : missingFiles) {
            BaseLogger.log((String)"3", null, null, (Object)("TranId....\t" + tranID));
            try {
                String result = unshsbc.generateBankSpecificXML(userInfo, tranID);
                BaseLogger.log((String)"3", null, null, (Object)("XML generated for Tran ID: " + tranID + " - Result: " + result));
            }
            catch (ITMException e) {
                BaseLogger.log((String)"3", null, null, (Object)("Error generating XML for Tran ID: " + tranID + " - " + e.getMessage()));
                return false;
            }
        }
        return true;
    }
}

