/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    ServletConfig servletConfig = null;
    private static String dirName = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletConfig = config;
        if (CommonConstants.J2EE_VERSION.equals("1")) {
            CommonConstants.setAPPLICATION_CONTEXT(this.servletConfig.getServletContext().getRealPath("/"));
            dirName = new File(CommonConstants.APPLICATION_CONTEXT) + File.separator + "jsp";
        } else if (CommonConstants.J2EE_VERSION.equals("2")) {
            dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "dump";
        }
        BaseLogger.log("2", null, null, "dirName in UploadServlet:: " + dirName);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                String fname = null;
                String fsize = null;
                String ftype = null;
                List multiparts = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(request);
                for (FileItem item : multiparts) {
                    if (item.isFormField()) continue;
                    fname = new File(item.getName()).getName();
                    BaseLogger.log("3", null, null, "File Uploaded at path : " + dirName + File.separator + fname);
                    fsize = new Long(item.getSize()).toString();
                    ftype = item.getContentType();
                    item.write(new File(String.valueOf(dirName) + File.separator + fname));
                }
                request.setAttribute("message", (Object)"File Uploaded Successfully");
                request.setAttribute("name", fname);
                request.setAttribute("size", fsize);
                request.setAttribute("type", ftype);
            }
            catch (Exception ex) {
                request.setAttribute("message", (Object)("File Upload Failed due to " + ex));
            }
        } else {
            request.setAttribute("message", (Object)"Sorry this Servlet only handles file upload request");
        }
        request.getRequestDispatcher("/jsp/result.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

