/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class AssetDataUtility
extends RestAPIServiceUtility {
    ValidatorEJB validatorEJB = new ValidatorEJB();

    public String getAssetData(String assetCode, String transDB, UserInfoBean userInfo) throws BaseException {
        StringBuilder htmlResponse;
        block10: {
            htmlResponse = new StringBuilder();
            BaseLogger.log("2", null, null, "AssetDataUtility :getAssetData :==> assetCode[" + assetCode + "]");
            LinkedHashMap<String, String> attribMap = new LinkedHashMap<String, String>();
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            PreparedStatement itemPstmt = null;
            ResultSet itemRs = null;
            PreparedStatement itemDataPstmt = null;
            ResultSet itemDataRs = null;
            PreparedStatement AMCDataPstmt = null;
            ResultSet AMCDataRs = null;
            PreparedStatement assetPstmt = null;
            ResultSet assetRs = null;
            String dbName = "oracle";
            String itemCode = "";
            String assetType = "";
            String assetDescription = "";
            String assetCodeResult = "";
            String brand = "";
            String CPU = "";
            String RAM = "";
            String storage = "";
            String contractNo = "";
            String effDate = "";
            String validUpto = "";
            String suppName = "";
            String renewDate = "";
            String status = "";
            String display = "";
            String itemDescr = "";
            try {
                try {
                    ValidatorEJB validatorEJB = new ValidatorEJB();
                    conn = validatorEJB.getConnection(transDB, userInfo);
                    String sql = "SELECT ASSET_CODE, descr, asset_type, item_code FROM asset_register WHERE asset_code = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, assetCode);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        assetCodeResult = this.checkNull(rs.getString("ASSET_CODE").trim());
                        assetDescription = this.checkNull(rs.getString("descr"));
                        assetType = this.checkNull(rs.getString("asset_type"));
                        itemCode = this.checkNull(rs.getString("item_code"));
                    }
                    BaseLogger.log("3", null, null, "AssetDataUtility :getAssetData :==> assetDescription[" + assetDescription + "], assetType" + assetType + " ,itemCode" + itemCode);
                    String sql4 = "select descr from item where item_code = ?";
                    itemPstmt = conn.prepareStatement(sql4);
                    itemPstmt.setString(1, itemCode);
                    itemRs = itemPstmt.executeQuery();
                    if (itemRs.next()) {
                        itemDescr = this.checkNull(itemRs.getString("descr"));
                    }
                    BaseLogger.log("3", null, null, "AssetDataUtility :getAssetData :==> itemDescr[" + itemDescr + "]");
                    String sql3 = "SELECT    rc.contract_id as contract_no,    rc.status as status,    rc.eff_date as eff_date,    rc.valid_upto as valid_upto,     rc.DATE__LAST_PROC as renew_date,    s.supp_name as supp_name FROM retainer_contract rc JOIN retainer_contract_asset rca     ON rc.contract_id = rca.contract_id LEFT JOIN supplier s     ON rc.sundry_code = s.supp_code WHERE rca.asset_code = ?";
                    AMCDataPstmt = conn.prepareStatement(sql3);
                    AMCDataPstmt.setString(1, assetCode);
                    AMCDataRs = AMCDataPstmt.executeQuery();
                    if (AMCDataRs.next()) {
                        contractNo = this.checkNull(AMCDataRs.getString("contract_no"));
                        status = this.checkNull(AMCDataRs.getString("status"));
                        String effDateStr = this.checkNull(AMCDataRs.getString("eff_date")).substring(0, 10);
                        effDate = effDateStr.length() >= 10 ? effDateStr.substring(0, 10) : effDateStr;
                        String validUptoStr = this.checkNull(AMCDataRs.getString("valid_upto")).substring(0, 10);
                        validUpto = validUptoStr.length() >= 10 ? validUptoStr.substring(0, 10) : validUptoStr;
                        suppName = this.checkNull(AMCDataRs.getString("supp_name"));
                        String renewDateStr = this.checkNull(AMCDataRs.getString("renew_date"));
                        String string = renewDate = renewDateStr.length() >= 10 ? renewDateStr.substring(0, 10) : renewDateStr;
                    }
                    status = status.equals("A") ? "Under AMC" : (status.equals("X") ? "Not Under AMC" : status);
                    BaseLogger.log("3", null, null, "AssetDataUtility :getAssetData :==> contractNo[" + contractNo + "], status:" + status + " ,effDate:" + effDate + " validUpto:" + validUpto + " suppName:" + suppName + " renewDate:" + renewDate);
                    int fieldCount = 0;
                    String assetSql = "SELECT ATTRIB_HEADING, ATTRIB_VALUE FROM TRANS_ITEM_ATTRIBUTES WHERE ref_id = ?";
                    assetPstmt = conn.prepareStatement(assetSql);
                    assetPstmt.setString(1, String.valueOf(assetCode) + ":");
                    assetRs = assetPstmt.executeQuery();
                    while (assetRs.next()) {
                        attribMap.put(assetRs.getString("ATTRIB_HEADING"), assetRs.getString("ATTRIB_VALUE"));
                    }
                    htmlResponse.append("<div class='asset-details'>").append("<div class='row'><div class='field'>Asset No: <span class='value'>").append(assetCodeResult).append("</span></div>").append("<div class='field'>Asset Description: <span class='value'>").append(assetDescription).append("</span></div>").append("<div class='field'>Asset Type: <span class='value'>").append(assetType).append("</span></div></div>").append("<div class='row'><div class='field'>Item Code: <span class='value'>").append(itemDescr).append("</span></div>");
                    for (Map.Entry entry : attribMap.entrySet()) {
                        htmlResponse.append("<div class='field'>").append((String)entry.getKey()).append(": <span class='value'>").append((String)entry.getValue()).append("</span></div>");
                        if (++fieldCount % 3 != 0) continue;
                        htmlResponse.append("</div><div class='row'>");
                    }
                    htmlResponse.append("</div>");
                    htmlResponse.append("<div style='font-weight: bold; padding: 11px; border-top: #f9f9f9 3px solid;'>AMC Details </div>").append("<div style='display: flex; gap: 0px; flex-wrap: wrap;'>").append("<div class='row'><div class='field'>Contract No: <span class='value'>").append(contractNo).append("</span></div>").append("<div class='field'>Status: <span class='value'>").append(status).append("</span></div>").append("<div class='field'>Supplier: <span class='value'>").append(suppName).append("</span></div></div>").append("<div class='row'><div class='field'>Effective From: <span class='value'>").append(effDate).append("</span></div>").append("<div class='field'>Valid Upto: <span class='value'>").append(validUpto).append("</span></div>").append("<div class='field'>Renewal Date: <span class='value'>").append(renewDate).append("</span></div></div>").append("</div></div>");
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :AssetDataUtility :getAssetData::" + e);
                    htmlResponse.append("<div class='error'>Error retrieving asset data</div>");
                    this.closeResources(rs, pstmt, conn);
                    this.closeResources(itemDataRs, itemDataPstmt, conn);
                    this.closeResources(AMCDataRs, AMCDataPstmt, conn);
                    this.closeResources(itemRs, itemPstmt, conn);
                    this.closeResources(assetRs, assetPstmt, conn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.closeResources(rs, pstmt, conn);
                this.closeResources(itemDataRs, itemDataPstmt, conn);
                this.closeResources(AMCDataRs, AMCDataPstmt, conn);
                this.closeResources(itemRs, itemPstmt, conn);
                this.closeResources(assetRs, assetPstmt, conn);
                throw throwable;
            }
            this.closeResources(rs, pstmt, conn);
            this.closeResources(itemDataRs, itemDataPstmt, conn);
            this.closeResources(AMCDataRs, AMCDataPstmt, conn);
            this.closeResources(itemRs, itemPstmt, conn);
            this.closeResources(assetRs, assetPstmt, conn);
        }
        return htmlResponse.toString();
    }

    public Connection getConnection(String transDB, UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        String database = "";
        try {
            BaseLogger.log("3", userInfo, null, "IN getConnection METHOD");
            ConnDriver connDriver = null;
            connDriver = new ConnDriver();
            conn = connDriver.getConnectDB(transDB);
            conn.setAutoCommit(false);
            database = connDriver.getDBName();
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : [DocumentHandlerEJB][getConnection] :==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    private void closeResources(ResultSet rs, PreparedStatement pstmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String checkNull(String value) {
        value = value == null || value.trim().length() == 0 ? "" : value.trim();
        return value;
    }
}

