/*
 * Decompiled with CFR 0.152.
 */
package ibase.bis.ejb;

import ibase.bis.ejb.BISIntentNEntityRecognitionProcess;
import ibase.bis.ejb.BusinessIntentEJB;
import ibase.bis.utility.BISUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class WitAiAPI
extends BISIntentNEntityRecognitionProcess {
    private BISUtility bisUtility = new BISUtility();
    private BusinessIntentEJB businessIntentEJB = new BusinessIntentEJB();
    private final String NLP_AGENT = "WIT";
    private Map<String, String> urlMap = CommonConstants.PYTHON_SERVICES.get("WIT");
    private final String ENTITY_URL = String.format("%s://%s/%s", this.urlMap.get("PROTOCOL"), this.urlMap.get("HOST"), this.urlMap.get("uploadEntity"));
    private final String INTENT_URL = String.format("%s://%s/%s", this.urlMap.get("PROTOCOL"), this.urlMap.get("HOST"), this.urlMap.get("train"));
    private final String PROCESS_URL = String.format("%s://%s/%s", this.urlMap.get("PROTOCOL"), this.urlMap.get("HOST"), this.urlMap.get("process"));
    private final String APP_URL = String.format("%s://%s/%s", this.urlMap.get("PROTOCOL"), this.urlMap.get("HOST"), this.urlMap.get("apps"));
    private String ACCESS_TOKEN = this.urlMap.get("ACCESS_TOKEN");
    JSONObject nlpDetailJson = null;
    private HashMap<String, String> dataTypeValueMap = new HashMap();

    @Override
    public String processIntent(String inputString) throws ITMException {
        BaseLogger.log("3", this.getUserInfo(), null, "In processIntent :: inputString : [" + inputString + "]");
        String responseStr = "";
        try {
            inputString = URLEncoder.encode(inputString, CommonConstants.ENCODING);
            JSONObject response = new JSONObject();
            String witResponse = this.buildRequest("processIntent", inputString);
            BaseLogger.log("3", this.getUserInfo(), null, "witResponse : [" + witResponse + "]");
            JSONArray intentArr = new JSONArray();
            JSONArray entitiesArr = new JSONArray();
            witResponse = E12GenericUtility.checkNull(witResponse);
            if (witResponse.length() > 0) {
                JSONObject processResponseJson = new JSONObject(witResponse);
                BaseLogger.log("3", this.getUserInfo(), null, "processResponseJson : [" + processResponseJson + "]");
                entitiesArr = new JSONArray();
                intentArr = (JSONArray)processResponseJson.get("intents");
                JSONObject jsonObjectEntity = (JSONObject)processResponseJson.get("entities");
                Iterator keys = jsonObjectEntity.keys();
                while (keys.hasNext()) {
                    JSONArray entityArr;
                    String key = (String)keys.next();
                    if (!(jsonObjectEntity.get(key) instanceof JSONArray) || (entityArr = (JSONArray)jsonObjectEntity.get(key)).length() <= 0) continue;
                    JSONObject entity = (JSONObject)entityArr.get(0);
                    entity.put("entity", entity.remove("name"));
                    entitiesArr.put((Object)entity);
                }
            }
            if (intentArr.length() > 0) {
                response.put("intent", intentArr.get(0));
            } else {
                response.put("intent", (Object)"");
            }
            response.put("entities", (Object)entitiesArr);
            response.put("intent_ranking", (Object)intentArr);
            response.put("nlp_details", (Object)this.nlpDetailJson);
            responseStr = response.toString();
            BaseLogger.log("3", this.getUserInfo(), null, "responseStr : [" + responseStr + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", this.getUserInfo(), null, "Exception in processIntent [" + e.getMessage() + "]");
            throw new ITMException(e);
        }
        return responseStr;
    }

    public void trainIntent(String trainOption) throws ITMException {
        Connection mConnection = null;
        Statement mStatement = null;
        ResultSet mResultSet = null;
        JSONArray finalIntentJsonArr = new JSONArray();
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(this.getUserInfo().getTransDB());
                mConnDriver = null;
                Boolean isEnterpriseExist = CommonConstants.ENTERPRISE_NLP_TOKENS.containsKey(this.getUserInfo().getEnterprise());
                if (!isEnterpriseExist.booleanValue()) {
                    JSONObject createApp = new JSONObject();
                    createApp.put("name", (Object)this.getUserInfo().getEnterprise());
                    createApp.put("lang", (Object)"en");
                    createApp.put("private", (Object)"false");
                    JSONObject createAppResponse = new JSONObject(this.buildRequest("createApp", createApp.toString()));
                    CommonConstants.ENTERPRISE_NLP_TOKENS.put(this.getUserInfo().getEnterprise(), createAppResponse.getString("access_token"));
                    this.updateEnterpriseNLPToken();
                }
                HashMap<String, String> entityValueMap = this.uploadEntities(trainOption, mConnection);
                mStatement = mConnection.createStatement();
                StringBuilder argNameSql = new StringBuilder();
                argNameSql.append(" SELECT BIS_INVOC.BIS_INTENT_ID, BIS_INVOC.INVOC_STRING, BIS_INVOC.INVOC_ORDER, BIS_INVOC.DESCR ");
                argNameSql.append(" FROM BIS_INTENT_INVOC BIS_INVOC ");
                argNameSql.append(" LEFT OUTER JOIN BIS_INTENT BIS_INTENT on BIS_INTENT.BIS_INTENT_ID= BIS_INVOC.BIS_INTENT_ID ");
                if ("All Data".equalsIgnoreCase(trainOption)) {
                    argNameSql.append(" WHERE BIS_INTENT.INT_STAT IN ( 'A', 'D' ) ");
                } else {
                    argNameSql.append(" WHERE BIS_INTENT.INT_STAT <> 'D' ");
                }
                mResultSet = mStatement.executeQuery(argNameSql.toString());
                while (mResultSet.next()) {
                    JSONObject sampleJson = new JSONObject();
                    JSONArray intentJsonArr = new JSONArray();
                    String entityName = "";
                    String entityNameVal = "";
                    String invocString = mResultSet.getString("INVOC_STRING");
                    String bisIntentId = mResultSet.getString("BIS_INTENT_ID");
                    String invocDescr = mResultSet.getString("DESCR");
                    BaseLogger.log("3", this.getUserInfo(), null, "invocString[" + invocString + "]bisIntentId[" + bisIntentId + "]invocDescr [" + invocDescr + "]");
                    invocString = invocString == null ? invocDescr : String.valueOf(invocString) + " ";
                    JSONArray entityArray = new JSONArray();
                    if (invocString.indexOf(":") > 0) {
                        String invocStr = invocString;
                        int occurance = this.bisUtility.charaterOccurance(invocString);
                        int i = 0;
                        while (i < occurance) {
                            ArrayList<Integer> startEndPointsArray;
                            JSONObject entity;
                            entityName = (invocStr = invocStr.substring(invocStr.indexOf(":"))).substring(0, invocStr.indexOf(" "));
                            entityNameVal = entityName.contains(".") ? entityName.substring(entityName.indexOf(".") + 1).toUpperCase() : entityName.substring(1).toUpperCase();
                            if (entityNameVal.indexOf(",") > 0) {
                                entityNameVal = entityNameVal.substring(0, entityNameVal.indexOf(","));
                            }
                            BaseLogger.log("3", this.getUserInfo(), null, "entityNameVal [" + entityNameVal + "]");
                            invocStr = invocStr.substring(invocStr.indexOf(" "));
                            if (entityValueMap.containsKey(entityNameVal)) {
                                invocString = invocString.replace(entityName, entityValueMap.get(entityNameVal));
                                entity = new JSONObject();
                                entity.put("entity", (Object)entityNameVal);
                                entity.put("value", (Object)entityValueMap.get(entityNameVal));
                                startEndPointsArray = this.bisUtility.getStartEndPosition(invocString, entityValueMap.get(entityNameVal));
                                entity.put("start", (Object)startEndPointsArray.get(0));
                                entity.put("end", (Object)startEndPointsArray.get(1));
                                entityArray.put((Object)entity);
                            } else if (this.dataTypeValueMap.containsKey(entityNameVal)) {
                                if (this.dataTypeValueMap.get(entityNameVal).equalsIgnoreCase("date")) {
                                    invocString = invocString.replace(entityName, entityValueMap.get("datetime"));
                                    entity = new JSONObject();
                                    entity.put("entity", (Object)"datetime");
                                    entity.put("value", (Object)entityValueMap.get("datetime"));
                                    startEndPointsArray = this.bisUtility.getStartEndPosition(invocString, entityValueMap.get("datetime"));
                                    entity.put("start", (Object)startEndPointsArray.get(0));
                                    entity.put("end", (Object)startEndPointsArray.get(1));
                                    entityArray.put((Object)entity);
                                } else if (this.dataTypeValueMap.get(entityNameVal).equalsIgnoreCase("number")) {
                                    invocString = invocString.replace(entityName, entityValueMap.get("number"));
                                    entity = new JSONObject();
                                    entity.put("entity", (Object)"number");
                                    entity.put("value", (Object)entityValueMap.get("number"));
                                    startEndPointsArray = this.bisUtility.getStartEndPosition(invocString, entityValueMap.get("number"));
                                    entity.put("start", (Object)startEndPointsArray.get(0));
                                    entity.put("end", (Object)startEndPointsArray.get(1));
                                    entityArray.put((Object)entity);
                                }
                            }
                            ++i;
                        }
                    }
                    sampleJson.put("text", (Object)invocString);
                    JSONObject intent = new JSONObject();
                    intent.put("entity", (Object)"intent");
                    intent.put("value", (Object)bisIntentId);
                    entityArray.put((Object)intent);
                    sampleJson.put("entities", (Object)entityArray);
                    intentJsonArr.put((Object)sampleJson);
                    finalIntentJsonArr.put((Object)intentJsonArr);
                }
                mStatement.close();
                mStatement = null;
                mResultSet.close();
                mResultSet = null;
                this.buildRequest("trainIntent", finalIntentJsonArr.toString());
                argNameSql = new StringBuilder();
                argNameSql.append(" UPDATE BIS_INTENT SET INT_STAT = 'D' WHERE INT_STAT = 'A' ");
                mStatement = mConnection.createStatement();
                int countUpdated = mStatement.executeUpdate(argNameSql.toString());
                BaseLogger.log("3", this.getUserInfo(), null, "[" + countUpdated + "] records affected.");
                mStatement.close();
                mStatement = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("3", this.getUserInfo(), null, "Exception in trainIntent [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mStatement != null) {
                    mStatement.close();
                    mStatement = null;
                }
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String buildRequest(String action, String inputString) throws Exception {
        BaseLogger.log("3", this.getUserInfo(), null, "buildRequest :: action : [" + action + "]");
        String data = "";
        try {
            if ("uploadEntities".equalsIgnoreCase(action)) {
                JSONArray jsonArray = new JSONArray(inputString);
                int i = 0;
                int size = jsonArray.length();
                while (i < size) {
                    this.nlpDetailJson = new JSONObject();
                    this.nlpDetailJson.put("NLP_AGENT", (Object)"WIT");
                    this.nlpDetailJson.put("NLP_TYPE", (Object)action);
                    this.nlpDetailJson.put("NLP_REQ", (Object)this.ENTITY_URL);
                    data = this.makeRequest(this.ENTITY_URL, jsonArray.getJSONObject(i).toString());
                    this.businessIntentEJB.createNlpTraningLog(this.getUserInfo(), this.nlpDetailJson);
                    ++i;
                }
            } else if ("trainIntent".equalsIgnoreCase(action)) {
                JSONArray jsonArray = new JSONArray(inputString);
                int i = 0;
                int size = jsonArray.length();
                while (i < size) {
                    this.nlpDetailJson = new JSONObject();
                    this.nlpDetailJson.put("NLP_AGENT", (Object)"WIT");
                    this.nlpDetailJson.put("NLP_TYPE", (Object)action);
                    this.nlpDetailJson.put("NLP_REQ", (Object)this.INTENT_URL);
                    data = this.makeRequest(this.INTENT_URL, jsonArray.getJSONArray(i).toString());
                    this.businessIntentEJB.createNlpTraningLog(this.getUserInfo(), this.nlpDetailJson);
                    ++i;
                }
            } else if ("processIntent".equalsIgnoreCase(action)) {
                String query = String.format("q=%s&n=%s", inputString, 3);
                String urlString = String.valueOf(this.PROCESS_URL) + "&" + query;
                this.nlpDetailJson = new JSONObject();
                this.nlpDetailJson.put("NLP_AGENT", (Object)"WIT");
                this.nlpDetailJson.put("NLP_TYPE", (Object)action);
                this.nlpDetailJson.put("NLP_REQ", (Object)urlString);
                data = this.makeRequest(urlString, null);
            } else if ("createApp".equalsIgnoreCase(action)) {
                String urlString = this.APP_URL;
                this.nlpDetailJson = new JSONObject();
                this.nlpDetailJson.put("NLP_AGENT", (Object)"WIT");
                this.nlpDetailJson.put("NLP_TYPE", (Object)action);
                this.nlpDetailJson.put("NLP_REQ", (Object)urlString);
                data = this.makeRequest(urlString, inputString);
                this.businessIntentEJB.createNlpTraningLog(this.getUserInfo(), this.nlpDetailJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", this.getUserInfo(), null, "Exception in buildRequest [" + e.getMessage() + "]");
        }
        return data;
    }

    private HashMap<String, String> uploadEntities(String trainOption, Connection mConnection) throws ITMException {
        Statement mStatement = null;
        ResultSet mResultSet = null;
        JSONArray finalEntityJson = new JSONArray();
        Pattern regex = Pattern.compile("[$&+,:;=\\\\?@#|/'<>.^*%!-]");
        HashMap<String, String> entityValueMap = new HashMap<String, String>();
        try {
            try {
                mStatement = mConnection.createStatement();
                StringBuilder argNameSql = new StringBuilder();
                argNameSql.append(" SELECT DISTINCT UPPER(SUBSTR(INTENT_ARGS.ARG_NAME,INSTR(INTENT_ARGS.ARG_NAME, '.')+1)) ARG_NAME,  ");
                argNameSql.append(" INTENT_ARGS.DATA_TYPE, INTENT_ARGS.TRANING_DATA, ENTITY.DATA_MODEL ");
                argNameSql.append(" FROM BIS_INTENT_ARGS INTENT_ARGS ");
                argNameSql.append(" LEFT OUTER JOIN BIS_INTENT INTENT ON INTENT_ARGS.BIS_INTENT_ID = INTENT .BIS_INTENT_ID ");
                argNameSql.append(" LEFT OUTER JOIN BIS_ENTITY ENTITY ON INTENT_ARGS.BIS_ENTITY_ID = ENTITY.BIS_ENTITY_ID ");
                argNameSql.append(" LEFT OUTER JOIN DATA_MODEL DATA_MODEL ON ENTITY.DATA_MODEL = DATA_MODEL.DATA_MODEL ");
                argNameSql.append(" WHERE INTENT_ARGS.ARG_SOURCE <> 'U' ");
                if (!"All Data".equalsIgnoreCase(trainOption)) {
                    argNameSql.append(" AND INTENT.INT_STAT <> 'D' ");
                }
                mResultSet = mStatement.executeQuery(argNameSql.toString());
                while (mResultSet.next()) {
                    String dataModel = mResultSet.getString("DATA_MODEL");
                    String argName = mResultSet.getString("ARG_NAME");
                    String dataType = E12GenericUtility.checkNull(mResultSet.getString("DATA_TYPE"));
                    ArrayList<String> arrayList = null;
                    if (!dataType.equalsIgnoreCase("number") && !dataType.equalsIgnoreCase("date")) {
                        BaseLogger.log("3", this.getUserInfo(), null, "DATAMODEL [" + dataModel + "] argName [" + argName + "]");
                        BaseLogger.log("3", this.getUserInfo(), null, "dataType [" + dataType + "]");
                        arrayList = this.bisUtility.getDataModelDataList(String.valueOf(dataModel) + ".json", this.getUserInfo().getLoginCode());
                        if (dataModel == null && mResultSet.getString("TRANING_DATA") != null) {
                            arrayList = new ArrayList();
                            arrayList.addAll(new ArrayList<String>(Arrays.asList(mResultSet.getString("TRANING_DATA").split(","))));
                        }
                        JSONObject json = new JSONObject();
                        json.put("name", (Object)argName);
                        json.put("roles", (Object)new JSONArray().put((Object)argName));
                        json.put("lookups", (Object)new JSONArray().put((Object)"free-text").put((Object)"keywords"));
                        String dataModelVal = "";
                        String firstVal = "";
                        JSONArray keyWordFinalArray = new JSONArray();
                        if (arrayList != null && arrayList.size() > 0) {
                            int datModelVal = 0;
                            while (datModelVal < arrayList.size()) {
                                if (regex.matcher(arrayList.get(datModelVal)).find()) {
                                    BaseLogger.log("3", this.getUserInfo(), null, "SPECIAL FOUND>>>>>>>>>>>>>>");
                                } else {
                                    BaseLogger.log("3", this.getUserInfo(), null, "arrayList VAL [" + arrayList.get(datModelVal) + "]");
                                    dataModelVal = arrayList.get(datModelVal).indexOf("(") > 0 ? arrayList.get(datModelVal).substring(0, arrayList.get(datModelVal).indexOf("(")).trim() : arrayList.get(datModelVal).trim();
                                    firstVal = arrayList.get(0).indexOf("(") > 0 ? arrayList.get(0).substring(0, arrayList.get(0).indexOf("(")).trim() : arrayList.get(0).trim();
                                    entityValueMap.put(mResultSet.getString("ARG_NAME"), firstVal);
                                    BaseLogger.log("3", this.getUserInfo(), null, "dataModelVal[" + dataModelVal + "]");
                                    JSONObject entityValues = new JSONObject();
                                    entityValues.put("keyword", (Object)dataModelVal);
                                    entityValues.put("synonyms", (Object)new JSONArray().put((Object)dataModelVal));
                                    keyWordFinalArray.put((Object)entityValues);
                                }
                                ++datModelVal;
                            }
                        }
                        json.put("keywords", (Object)keyWordFinalArray);
                        finalEntityJson.put((Object)json);
                        continue;
                    }
                    this.dataTypeValueMap.put(argName, dataType);
                }
                JSONObject dateTimeJson = new JSONObject();
                dateTimeJson.put("name", (Object)"datetime");
                dateTimeJson.put("roles", (Object)new JSONArray().put((Object)"datetime"));
                dateTimeJson.put("lookups", (Object)new JSONArray().put((Object)"free-text").put((Object)"keywords"));
                ArrayList<String> traningDateData = this.bisUtility.getDefaultValueList();
                JSONArray keyWordFinalArray = new JSONArray();
                if (traningDateData != null && traningDateData.size() > 0) {
                    int datModelVal = 0;
                    while (datModelVal < traningDateData.size()) {
                        entityValueMap.put("datetime", traningDateData.get(0).trim());
                        if (regex.matcher(traningDateData.get(datModelVal)).find()) {
                            BaseLogger.log("3", this.getUserInfo(), null, "SPECIAL FOUND>>>>>>>>>>>>>>");
                        } else {
                            JSONObject entityValues = new JSONObject();
                            entityValues.put("keyword", (Object)traningDateData.get(datModelVal).trim());
                            entityValues.put("synonyms", (Object)new JSONArray().put((Object)traningDateData.get(datModelVal).trim()));
                            keyWordFinalArray.put((Object)entityValues);
                        }
                        ++datModelVal;
                    }
                }
                dateTimeJson.put("keywords", (Object)keyWordFinalArray);
                finalEntityJson.put((Object)dateTimeJson);
                JSONObject numberJson = new JSONObject();
                numberJson.put("name", (Object)"number");
                numberJson.put("roles", (Object)new JSONArray().put((Object)"number"));
                numberJson.put("lookups", (Object)new JSONArray().put((Object)"free-text").put((Object)"keywords"));
                ArrayList<String> numbers = new ArrayList<String>(Arrays.asList("1", "22", "322", "44", "54", "60", "778", "841", "41"));
                JSONArray keyWordFinalArrayNumber = new JSONArray();
                if (numbers != null && numbers.size() > 0) {
                    int datModelVal = 0;
                    while (datModelVal < numbers.size()) {
                        entityValueMap.put("number", numbers.get(0));
                        if (regex.matcher(numbers.get(datModelVal)).find()) {
                            BaseLogger.log("3", this.getUserInfo(), null, "SPECIAL FOUND>>>>>>>>>>>>>>");
                        } else {
                            JSONObject entityValues = new JSONObject();
                            entityValues.put("keyword", (Object)numbers.get(datModelVal).trim());
                            entityValues.put("synonyms", (Object)new JSONArray().put((Object)numbers.get(datModelVal).trim()));
                            keyWordFinalArrayNumber.put((Object)entityValues);
                        }
                        ++datModelVal;
                    }
                }
                numberJson.put("keywords", (Object)keyWordFinalArrayNumber);
                finalEntityJson.put((Object)numberJson);
                BaseLogger.log("3", this.getUserInfo(), null, "Final Array to write [" + finalEntityJson.toString() + "]");
                this.buildRequest("uploadEntities", finalEntityJson.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("3", this.getUserInfo(), null, "Exception in updateEntities [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mStatement != null) {
                    mStatement.close();
                    mStatement = null;
                }
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return entityValueMap;
    }

    private String makeRequest(String urlStr, String uploadData) throws Exception {
        StringBuilder sb = new StringBuilder();
        try {
            if (CommonConstants.ENTERPRISE_NLP_TOKENS != null && CommonConstants.ENTERPRISE_NLP_TOKENS.containsKey(this.getUserInfo().getEnterprise())) {
                this.ACCESS_TOKEN = CommonConstants.ENTERPRISE_NLP_TOKENS.get(this.getUserInfo().getEnterprise());
            }
            BaseLogger.log("3", this.getUserInfo(), null, "uploadData : [" + uploadData + "] urlStr[" + urlStr + "] ACCESS_TOKEN [" + this.ACCESS_TOKEN + "]");
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + this.ACCESS_TOKEN);
            if (uploadData != null) {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                os.write(uploadData.getBytes());
                os.flush();
                os.close();
            }
            long startTime = System.currentTimeMillis();
            BaseLogger.log("2", null, null, "startTime [" + startTime + "]");
            this.nlpDetailJson.put("NLP_REQ_TIME", startTime);
            String output = "";
            BufferedReader br = null;
            if (conn.getResponseCode() != 200) {
                this.nlpDetailJson.put("NLP_RESP_TIME", System.currentTimeMillis());
                br = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            } else {
                this.nlpDetailJson.put("NLP_RESP_TIME", System.currentTimeMillis());
                br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            }
            BaseLogger.log("2", null, null, "Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                sb.append(String.valueOf(output) + "\n");
            }
            conn.disconnect();
            this.nlpDetailJson.put("NLP_RESPONSE", (Object)sb.toString());
        }
        catch (Exception e) {
            BaseLogger.log("3", this.getUserInfo(), null, "Exception makeRequest[" + e.getMessage() + "]");
            e.getMessage();
        }
        return sb.toString();
    }

    private void updateEnterpriseNLPToken() throws ITMException {
        BaseLogger.log("2", null, null, "In updateBisAccessTable");
        Connection conn = null;
        Statement pStmt = null;
        try {
            try {
                BaseLogger.log("2", null, null, "ENTERPRISE_NLP_TOKENS : [" + CommonConstants.ENTERPRISE_NLP_TOKENS.get(this.getUserInfo().getEnterprise()) + "]");
                ConnDriver mConnDriver = new ConnDriver();
                conn = mConnDriver.getConnectDB("DriverITM");
                mConnDriver = null;
                conn.setAutoCommit(false);
                String updateNlpTokenSql = "UPDATE ENTERPRISE SET NLP_APP = ?, NLP_APP_TOKEN = ? WHERE ENTERPRISE = ?";
                pStmt = conn.prepareStatement(updateNlpTokenSql);
                pStmt.setString(1, "WIT");
                pStmt.setString(2, CommonConstants.ENTERPRISE_NLP_TOKENS.get(this.getUserInfo().getEnterprise()));
                pStmt.setString(3, this.getUserInfo().getEnterprise());
                int updateCount = pStmt.executeUpdate();
                BaseLogger.log("2", null, null, "updateCount [" + updateCount + "]");
                if (updateCount > 0) {
                    conn.commit();
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("2", null, null, "Exception :: updateEnterpriseNLPToken : [" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

