/* Created by Jatin M
 * Brand Campaign: Defining Campaign and Brands [09-jan-2021] W20ISUN020
 * */
package ibase.webitm.ejb.wsfa.transactions;

import java.sql.*;
import java.text.*;
import java.util.ArrayList;
import java.util.Date;


import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
public class StrgBrandCampaign extends ValidatorEJB
{
	public String wfValData() throws ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		try
		{
			System.out.println("wfValData:xmlString ::: ["+xmlString+"]");
			System.out.println("wfValData:xmlString1 ::: ["+xmlString1+"]");
			System.out.println("wfValData:xmlString2 ::: ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println(e);
			throw new ITMException(e);
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws ITMException
	{
		System.out.println("Inside StrgBrandCampaign:wfValData");
		Connection conn = null;
		String userId="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String errString = "";
		String updateFlag = "";
		int parentListLen = 0;
		
		String effFrom = "";
		String validUpto = "";
		String itemSer = "";
        String campaignDescr = "";
        String campgnId = "";
		
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		
		
		try
		{
            campgnId = checkNull(genericUtility.getColumnValue("campgn_id", dom));
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Date effFromDate = new Date();
			Date validUptoDate =new Date();
			conn = getConnection();
			System.out.println("editFlag::::::["+editFlag+"]");
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("userId::::::["+userId+"]");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
					System.out.println("------------------Inside case 1------------------");
					parentList = dom.getElementsByTagName("Detail" + currentFormNo);
					parentNode = parentList.item(0);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for(ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						childNodeName = childNode.getNodeName();
						
						if(childNodeName.equalsIgnoreCase("descr"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString("descr","DSCRNUL",userId);
								break;
							}
							else
							{
								campaignDescr = checkNull(genericUtility.getColumnValue("descr", dom));
								effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom));
								validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom));
								itemSer = checkNull(genericUtility.getColumnValue("item_ser", dom));
								if(effFrom.length() > 0 && validUpto.length() > 0  && itemSer.length() > 0 )
								{
									String checkOverLap = 	validateOverllapEntry(campaignDescr, effFrom, validUpto, itemSer, campgnId, conn);
									if(checkOverLap.equals("true"))
									{
										System.out.println("Called from description");
										errString = getErrorString("item_ser","INVITMSERB",userId);
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("eff_from"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString("eff_from","EFFFRMNUL",userId);
								break;
							}
							effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom));
							validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom)); 
							effFromDate = sdf.parse(effFrom);
							validUptoDate =sdf.parse(validUpto);
							if(effFromDate.compareTo(validUptoDate)>0)
							{
								System.out.println("Value of compareTo ["+effFrom.compareTo(validUpto)+"]");
								errString = getErrorString("eff_from","INVEFFVLD",userId);
								break;
							}
							else
							{
								campaignDescr = checkNull(genericUtility.getColumnValue("descr", dom));
								effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom));
								validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom));
								itemSer = checkNull(genericUtility.getColumnValue("item_ser", dom));
								if(campaignDescr.length() > 0 && validUpto.length() > 0  && itemSer.length() > 0 )
								{
									String checkOverLap = validateOverllapEntry(campaignDescr, effFrom, validUpto, itemSer, campgnId, conn);
									if(checkOverLap.equals("true"))
									{
										System.out.println("Called from effective from");
										errString = getErrorString("item_ser","INVITMSERB",userId);
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("valid_upto"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString("valid_upto","VLDUPTONUL",userId);
								break;
							}
							
							effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom));
							validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom)); 
							effFromDate = sdf.parse(effFrom);
							validUptoDate =sdf.parse(validUpto);
							System.out.println("eff_from ["+effFromDate+"] and valid_upto 0 ["+validUptoDate+"]");
							if(effFromDate.compareTo(validUptoDate)>0)
							{
								System.out.println("Value of compareTo ["+effFrom.compareTo(validUpto)+"]");
								errString = getErrorString("valid_upto","INVEFFVLD",userId);
								break;
							}
							else
							{
								campaignDescr = checkNull(genericUtility.getColumnValue("descr", dom));
								effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom));
								itemSer = checkNull(genericUtility.getColumnValue("item_ser", dom));
								if(campaignDescr.length() > 0 && effFrom.length() > 0  && itemSer.length() > 0 )
								{
									String checkOverLap = validateOverllapEntry(campaignDescr, effFrom, validUpto, itemSer, campgnId, conn);
									if(checkOverLap.equals("true"))
									{
										System.out.println("Called from validupto");
										errString = getErrorString("valid_upto","INVITMSERB",userId);
										break;
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("item_ser"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = getErrorString("item_ser","ITMSERNUL",userId);
								break;
							}
							else 
							{
								int itemCnt = 0;
								itemSer = checkNull(genericUtility.getColumnValue("item_ser", dom));
								System.out.println("itemSer ["+itemSer+"]");
								if(itemSer.trim().length()>0)
								{
									sql = "SELECT COUNT(*) AS CNT FROM ITEMSER WHERE ITEM_SER=?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, itemSer);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										itemCnt = rs.getInt("CNT");
									}
									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(itemCnt==0)
									{
										System.out.println("itemCnt ["+itemCnt+"]");
										errString = getErrorString("item_ser","INVITMSER",userId);
										break;
									}
									else
									{
										campaignDescr = checkNull(genericUtility.getColumnValue("descr", dom));
										effFrom = checkNull(genericUtility.getColumnValue("eff_from", dom));
										validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom));
										if(campaignDescr.length() > 0 && effFrom.length() > 0  && validUpto.length() > 0 )
										{
											String checkOverLap = validateOverllapEntry(campaignDescr, effFrom, validUpto, itemSer, campgnId, conn);
											if(checkOverLap.equals("true"))
											{
												System.out.println("Called from Division");
												errString = getErrorString("item_ser","INVITMSERB",userId);
												break;
											}
										}
								 	}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("campaign_type"))
						{
							int cmpTypeCnt = 0;
							String campaignType = checkNull(genericUtility.getColumnValue("campaign_type",dom));
							if(campaignType.length() > 0)
							{
								
								sql = "SELECT COUNT(*) AS CNT FROM CAMPAIGN_TYPE WHERE CAMPAIGN_TYPE=?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, campaignType);
								rs  = pstmt.executeQuery();
								if(rs.next())
								{
									cmpTypeCnt = rs.getInt("CNT");
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(cmpTypeCnt==0)
								{
									System.out.println("cmpTypeCnt ["+cmpTypeCnt+"]");
									errString = getErrorString("campaign_type","INVCMPTYPE",userId);
									break;
								}
								
							}
						}
						else if(childNodeName.equalsIgnoreCase("grace_days"))
						{
							String grceDays = checkNull(genericUtility.getColumnValue("grace_days", dom));
							
							if(grceDays.length() > 0)
							{
								int graceDays = Integer.parseInt(grceDays);
								if(graceDays < 0 )
								{
									System.out.println("graceDays ["+graceDays+"]");
									errString = getErrorString("grace_days","NEGGRCDAY",userId);
									break;
								}
							}
						}
					}//end for
				
				case 2:
					System.out.println("------------------Inside case 2------------------");
					
					ArrayList<String> brandCodeList = new ArrayList<String>();
					parentList = dom2.getElementsByTagName("Detail" + currentFormNo);
					
                    parentListLen = parentList.getLength();
                    System.out.println("parent length"+parentListLen);
                    for(int pCtr = 0; pCtr < parentListLen; pCtr++)
				    {
                        updateFlag = "";
                        String brandCode = "";
			    		parentNode = parentList.item(pCtr);
			    		childList = parentNode.getChildNodes();
			    		noOfChilds = childList.getLength();
			    		
						for(ctr = 0; ctr < noOfChilds; ctr++)
						{	
							childNode = childList.item(ctr);

							if (childNode.getNodeType() != Node.ELEMENT_NODE) 
			    			{
                                continue;                 
                            }
							childNodeName = childNode.getNodeName();
							if ("attribute".equalsIgnoreCase(childNodeName)) 
			    			{
				    			if (childNode.getAttributes().getNamedItem("updateFlag") != null) 
					    		{
						    		updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							    }
                            }
							else if(childNodeName.equalsIgnoreCase("brand_code"))
							{
								if(childNode.getFirstChild() == null)			
								{
									errString = getErrorString("brand_code","BRNDNUL",userId);
									break;
								}
								else
								{
									int brandCnt = 0;
									updateFlag = getAttributeVal(parentNode, "updateFlag");
									brandCode = checkNull(childNode.getFirstChild().getNodeValue());
									
									String itemSerr = checkNull(genericUtility.getColumnValue("item_ser", dom1, "1"));
									
									System.out.println("updateFlag value is"+updateFlag);
								
									System.out.println("Division for brand code :::"+itemSerr);

									sql = "SELECT COUNT(*) AS CNT FROM BRAND WHERE BRAND_CODE=? and ITEM_SER=?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, brandCode);
									pstmt.setString(2, itemSerr);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										brandCnt = rs.getInt("CNT");
									}
									if(rs!=null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(brandCnt>0)
									{
										if(!"D".equalsIgnoreCase(updateFlag))
										{
											if(brandCodeList.size() > 0 && brandCodeList.contains(brandCode))
											{
												System.out.println("brand Code ["+brandCode+"]");
												errString = getErrorString("brand_code","DUPBRDCODE",userId);
												break;
											}
											brandCodeList.add(brandCode);
										}
									}
									else
									{
										System.out.println("brandCnt ["+brandCnt+"]");
										errString = getErrorString("brand_code","INVBRDCODE",userId);
										break;
									}
									if(errString != null && errString.trim().length() > 0)
									{
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("brand_weightage"))
							{
								String brandWeight = checkNull(genericUtility.getColumnValue("brand_weightage", dom));
								
								if(brandWeight.length() > 0)
								{
									int brndWeight  = Integer.parseInt(brandWeight);
									if(brndWeight < 0)
									{
										System.out.println("brndWeight ["+brndWeight+"]");
										errString = getErrorString("brand_weightage","NEGBRNDWGT",userId);
										break;
									}
								}
							
							}
						
						}//inner for
						if(errString != null && errString.trim().length() > 0)
						{
							break;
						}
						
				    }//outer for
                    break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception ["+e+"]");
			throw new ITMException(e);
		}
		finally
		{ 
			try
			{
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println(e);
				throw new ITMException(e);			
			}
		}
		
		return errString;
	}
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println ( "**********************itemChanged Called********");
			System.out.println ( "xmlString :" + xmlString);
			System.out.println ( "xmlString1 :" + xmlString1);
			System.out.println ( "xmlString2 :" + xmlString2);

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			//System.out.println ( "ErrString :" + errString);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		System.out.println ( "returning from StrgBrandCampaign itemChanged" );
		return errString;
	}
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws ITMException
	{
		System.out.println(":::Inside itemchanged :::");
		int currentFormNo = 0;
		StringBuffer valueXmlString =null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		try
		{
			System.out.println("objContext :::"+objContext);
			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			if(conn==null)
			{
				conn = getConnection();
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentform no"+currentFormNo);
			switch (currentFormNo)
			{
				case 1:
					System.out.println("Current form should be 1 ::::"+currentFormNo);
					valueXmlString.append("<Detail1>\r\n");
					if (currentColumn.equalsIgnoreCase("itm_default"))
					{
						System.out.println("Entered itm_default");
					}
					if(currentColumn.equalsIgnoreCase("item_ser"))
					{
						String divisionDescr = "";
						String division = checkNull(genericUtility.getColumnValue("item_ser", dom));
						sql = "SELECT DESCR FROM ITEMSER WHERE ITEM_SER=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, division);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							divisionDescr = checkNull(rs.getString("DESCR"));
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<itemser_descr><![CDATA[").append(checkNull(divisionDescr)).append("]]></itemser_descr>\r\n");
					}
					else if(currentColumn.equalsIgnoreCase("campaign_type"))
					{
						String cmpTypeDescr = "";
						String cmpType = checkNull(genericUtility.getColumnValue("campaign_type", dom));
						sql = "SELECT DESCR FROM CAMPAIGN_TYPE WHERE CAMPAIGN_TYPE=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, cmpType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cmpTypeDescr = checkNull(rs.getString("DESCR"));
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<campaign_type_descr><![CDATA[").append(checkNull(cmpTypeDescr)).append("]]></campaign_type_descr>\r\n");
						
					}
					valueXmlString.append("</Detail1>\r\n");
					break;
				case 2:
					System.out.println("Current form should be 2 ::::"+currentFormNo);
					valueXmlString.append("<Detail2>\r\n");
					if(currentColumn.equalsIgnoreCase("brand_code"))
					{
						String brandDescr = "";
						String brandCode = checkNull(genericUtility.getColumnValue("brand_code", dom));
						System.out.println("BRAND CODE VALUE ::: ["+brandCode+"]");
						sql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, brandCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							brandDescr = rs.getString("DESCRIPTION");
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<brand_description><![CDATA[").append(checkNull(brandDescr)).append("]]></brand_description>\r\n");
					}
					valueXmlString.append("</Detail2>\r\n");
					break;
					
			}
		}
		catch (Exception e)
		{
				System.out.println ("Exception :StrgBrandCampaign :itemChanged(Document,String):" + e.getMessage() + ":");
				valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
				throw new ITMException(e);
		}
		finally
		{ 
			try
			{
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println(e);
				throw new ITMException(e);			
			}
			System.out.println("Connection closed");
		}
			
		valueXmlString.append("</Root>\r\n");
		return valueXmlString.toString();
	}
	
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	private String getAttributeVal(Node parentNode, String attribName)throws ITMException
	{
		String attribVal = "";
		try
		{
			NodeList childList = parentNode.getChildNodes();
			int noOfChilds = childList.getLength();

			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				Node childNode = childList.item( ctr );
				String childNodeName = childNode.getNodeName();
				if("attribute".equalsIgnoreCase(childNodeName))
				{
					if(childNode.getAttributes().getNamedItem(attribName) != null)
					{
						attribVal = childNode.getAttributes().getNamedItem(attribName).getNodeValue();
						break;
					}
				}
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		System.out.println("attribVal = ["+attribVal+"]");
		return attribVal;
	}
	private String validateOverllapEntry(String campaignDescr,String effFrom, String validUpto, String itemSer, String campgnId, Connection conn) throws ITMException
	{
		String checkOverLap = "";
		System.out.println("Entered overlapping method");
		System.out.println("paramvalues are ["+campaignDescr+"] ["+effFrom+"] ["+validUpto+"] ["+itemSer+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Date effFromDate = sdf.parse(effFrom);
			Date validUptoDate = sdf.parse(validUpto);
			
			String sql = "SELECT EFF_FROM, VALID_UPTO, CAMPGN_ID FROM STRG_CAMPAIGN WHERE DESCR=? AND ITEM_SER=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, campaignDescr);
			pstmt.setString(2, itemSer);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				Date effFromTemp = rs.getTimestamp("EFF_FROM");
                Date validUptoTemp = rs.getTimestamp("VALID_UPTO");
                String campaignId = rs.getString("CAMPGN_ID");
				Date effFromDB = sdf.parse(sdf.format(effFromTemp));
				Date validUptoDB = sdf.parse(sdf.format(validUptoTemp));
				
				int compareEffToEffDB = effFromDate.compareTo(effFromDB);
				int compareValidUptoToEffDB = validUptoDate.compareTo(effFromDB);
				int compareEffToValidUptoDB = effFromDate.compareTo(validUptoDB);
                int compareValidUptoToValidUptoDB = validUptoDate.compareTo(validUptoDB);
                if(!campaignId.trim().equalsIgnoreCase(campgnId.trim()))
                {
                    System.out.println("if condition:["+campaignId+"] ["+campgnId+"] ["+compareEffToEffDB+"] ["+compareValidUptoToEffDB+"] ["+compareEffToValidUptoDB+"] ["+compareValidUptoToValidUptoDB+"]");
                    if(compareEffToEffDB<=0 && compareValidUptoToEffDB>=0 || compareEffToValidUptoDB<=0 && compareValidUptoToValidUptoDB>=0)
                    {
                        checkOverLap = "true";
                        System.out.println("Condition 1 satisfied");
                        break;
                    }
                    else if(effFromDate.compareTo(effFromDB)>0 && validUptoDate.compareTo(validUptoDB)<0)
                    {
                        checkOverLap = "true";
                        System.out.println("condition 2 satisfied");
                        break;
                    }
                    System.out.println("else if condition:["+effFromDate.compareTo(effFromDB)+"] ["+validUptoDate.compareTo(validUptoDB)+"]");
                }
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println(e);
				throw new ITMException(e);
			}
		}
		System.out.println("checkOverLap ["+checkOverLap+"]");
		return checkOverLap;
	}
}
