package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Calendar;
import java.text.Format;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class SfaTime extends ValidatorEJB {
	E12GenericUtility genericUtility=new E12GenericUtility();
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SfaTime: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SfaTime wfValData");
		return (errString);
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,
			String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Inside SfaTime validation");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String childNodeName = null;
		String errorString="";
		String userId="";
		int ctr=0;
		int currentFormNo=0;
		int childNodeListLength=0;
		int count=0;
		try 
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if(objContext!=null && objContext.trim().length()>0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentNodeList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for(ctr = 0; ctr < childNodeListLength; ctr++)
			{
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
				case 1:
					if(childNodeName.equalsIgnoreCase("dt"))
					{
						if(childNode.getFirstChild()==null)
						{
							errorString= getErrorString("dt","VMDATENULL",userId);
							break;
						}
						else
						{
							String date = genericUtility.getValidDateTimeString(genericUtility.getColumnValue( "dt", dom ), genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
							String sql = "SELECT COUNT(*) AS COUNT FROM SFA_TIME WHERE DT = ?" ;
							pstmt = conn.prepareStatement(sql);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(date));
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								count = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if (count == 1)
							{
								errorString = getErrorString("dt","VMDATEDUP2",userId);
								break;
							}
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception: SfaTime: wfValData: " + e.getMessage() + ":");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception: SfaTime: Finally Exception in wfValData:" + e.getMessage() + ":");
				e.printStackTrace();
			}

		}
		return errorString;
	}
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SfaTime :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from SfaTime itemChanged");
		return errString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Inside itemchange");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = null;
		SimpleDateFormat sdf = null;
		Calendar cal = null;
		Format fDay=null,fMonth=null,fYear=null,fMonthName=null;
		int currentFormNo = 0;
		try
		{
			conn = getConnection();
			sdf = new SimpleDateFormat("dd/MM/yy");
			fDay = new SimpleDateFormat("EEEE");
			fMonth = new SimpleDateFormat("M");
			fYear = new SimpleDateFormat("yyyy");
			fMonthName = new SimpleDateFormat("MMMM");
			cal = Calendar.getInstance();
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch(currentFormNo)
			{
			case 1:
				valueXmlString.append("<Detail1>");
				if ("itm_default".equalsIgnoreCase(currentColumn.trim()))
				{
					valueXmlString.append("<day protect=\"1\">").append("<![CDATA[]]>").append("</day>\r\n");
					valueXmlString.append("<month protect=\"1\">").append("<![CDATA[]]>").append("</month>\r\n");
					valueXmlString.append("<month_no protect=\"1\">").append("<![CDATA[]]>").append("</month_no>\r\n");
					valueXmlString.append("<qtr protect=\"1\">").append("<![CDATA[]]>").append("</qtr>\r\n");
					valueXmlString.append("<year protect=\"1\">").append("<![CDATA[]]>").append("</year>\r\n");
				}
				else if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
				{
					String date = checkNull(genericUtility.getColumnValue("dt",dom));
					if (date!=null && date.trim().length()>0) 
					{
						Date toDate = sdf.parse(date);
						String day = fDay.format(toDate).toUpperCase();
						String monthNo = fMonth.format(toDate);
						String year = fYear.format(toDate);
						String monthName = fMonthName.format(toDate).toUpperCase();
						cal.setTime(toDate);
						int quarter = (cal.get(Calendar.MONTH) / 3) + 1;
						valueXmlString.append("<day protect=\"1\">").append("<![CDATA[" + day +"]]>").append("</day>\r\n");
						valueXmlString.append("<month protect=\"1\">").append("<![CDATA[" + monthName + "]]>").append("</month>\r\n");
						valueXmlString.append("<month_no protect=\"1\">").append("<![CDATA["+ monthNo +"]]>").append("</month_no>\r\n");
						valueXmlString.append("<qtr protect=\"1\">").append("<![CDATA["+ quarter +"]]>").append("</qtr>\r\n");
						valueXmlString.append("<year protect=\"1\">").append("<![CDATA["+ year +"]]>").append("</year>\r\n");
					}
					else
					{
						valueXmlString.append("<day>").append("<![CDATA["+" "+"]]>").append("</day>\r\n");
						valueXmlString.append("<month>").append("<![CDATA["+" "+"]]>").append("</month>\r\n");
						valueXmlString.append("<month_no>").append("<![CDATA["+" "+"]]>").append("</month_no>\r\n");
						valueXmlString.append("<qtr>").append("<![CDATA["+" "+"]]>").append("</qtr>\r\n");
						valueXmlString.append("<year>").append("<![CDATA["+" "+"]]>").append("</year>\r\n");
					}
					
				}
				else if("dt".equalsIgnoreCase(currentColumn.trim()))
				{
					String date = checkNull(genericUtility.getColumnValue("dt",dom));
					if (date!=null && date.trim().length()>0) 
					{
						Date toDate = sdf.parse(date);
						String day = fDay.format(toDate).toUpperCase();
						String monthNo = fMonth.format(toDate);
						String year = fYear.format(toDate);
						String monthName = fMonthName.format(toDate).toUpperCase();
						cal.setTime(toDate);
						int quarter = (cal.get(Calendar.MONTH) / 3) + 1;
						valueXmlString.append("<day>").append("<![CDATA[" + day + "]]>").append("</day>\r\n");
						valueXmlString.append("<month>").append("<![CDATA[" + monthName + "]]>").append("</month>\r\n");
						valueXmlString.append("<month_no>").append("<![CDATA[" + monthNo + "]]>").append("</month_no>\r\n");
						valueXmlString.append("<qtr>").append("<![CDATA[" + quarter + "]]>").append("</qtr>\r\n");
						valueXmlString.append("<year>").append("<![CDATA[" + year + "]]>").append("</year>\r\n");
					}
					else
					{
						valueXmlString.append("<day>").append("<![CDATA["+" "+"]]>").append("</day>\r\n");
						valueXmlString.append("<month>").append("<![CDATA["+" "+"]]>").append("</month>\r\n");
						valueXmlString.append("<month_no>").append("<![CDATA["+" "+"]]>").append("</month_no>\r\n");
						valueXmlString.append("<qtr>").append("<![CDATA["+" "+"]]>").append("</qtr>\r\n");
						valueXmlString.append("<year>").append("<![CDATA["+" "+"]]>").append("</year>\r\n");
					}
				}
				valueXmlString.append ("</Detail1>\r\n");
				break;
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch(Exception e)
		{
			System.out.println("Exception :SfaTime :itemChanged(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :SfaTime :Exception in SQL" + e.getMessage() + ":");
				e.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}
	
	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		}
		else 
		{
			input = input.trim();
		}
		return input;
	}
}