/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMModel;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.XMLBuilderEJB;
import ibase.webitm.utility.DW2XSLGenerator;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.PopUpHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ITMProcessModel
extends ITMModel
implements Serializable {
    private UserInfoBean userInfo = null;
    private String objName = "";
    private HttpSession sessionCtx = null;
    public int noOfForms = -1;
    private ArrayList contextTitlesList;
    public String editFlag = "V";
    ArrayList titleList = null;
    PopUpHandler popUpHandler;
    private String userLang = "en";
    private String userCountry = "US";
    public TreeMap htmlMap = new TreeMap();

    public ITMProcessModel() {
        this(null, null);
    }

    public ITMProcessModel(String objName) {
        this(objName, null);
    }

    public ITMProcessModel(String objName, String pkNames) {
        this.objName = objName;
    }

    public void setSessionContext(HttpSession session) throws ITMException {
        try {
            if (session == null) {
                throw new Exception("Invalid Session");
            }
            this.sessionCtx = session;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    public void setObjName(String objName) throws ITMException {
        try {
            this.objName = objName;
            if (this.sessionCtx != null) {
                UserInfoBean userInfo = (UserInfoBean)this.sessionCtx.getAttribute("USER_INFO");
                if (userInfo != null) {
                    this.setUserInfo(userInfo);
                }
                if (this.userInfo == null) {
                    throw new Exception("Invalid Session");
                }
                this.noOfForms = this.contextTitlesList.size();
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setTitleList() throws ITMException {
        try {
            InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            ArrayList objFormsDetailList = null;
            String transDB = this.userInfo.getTransDB();
            BaseLogger.log("3", this.userInfo, null, "setTitleList transDB :" + transDB);
            if (transDB != null && transDB.trim().length() > 0) {
                objFormsDetailList = dbAccess.getObjProcessDetailList(this.objName, this.userInfo);
            }
            BaseLogger.log("3", this.userInfo, null, "objFormsDetailList" + objFormsDetailList.size());
            ArrayList tempList = new ArrayList();
            int cnt = 0;
            while (cnt < objFormsDetailList.size()) {
                tempList.add(((ArrayList)objFormsDetailList.get(cnt)).get(0));
                ++cnt;
            }
            BaseLogger.log("3", this.userInfo, null, "tempList :" + tempList);
            this.titleList = tempList;
            Object var2_4 = null;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setTitleList(UserInfoBean userInfo) throws ITMException {
        try {
            InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            ArrayList objFormsDetailList = dbAccess.getObjProcessDetailList(this.objName, userInfo);
            BaseLogger.log("3", userInfo, null, "objFormsDetailList" + objFormsDetailList.size());
            ArrayList tempList = new ArrayList();
            int cnt = 0;
            while (cnt < objFormsDetailList.size()) {
                tempList.add(((ArrayList)objFormsDetailList.get(cnt)).get(0));
                ++cnt;
            }
            BaseLogger.log("3", userInfo, null, "tempList :" + tempList);
            this.titleList = tempList;
            Object var3_5 = null;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public ArrayList getTitleList() {
        return this.titleList;
    }

    @Override
    public String getObjName() {
        return this.objName;
    }

    @Override
    public void setUserInfo(UserInfoBean userInfo) throws ITMException {
        try {
            if (userInfo == null) {
                throw new Exception("Invalid UserInfo");
            }
            this.userInfo = userInfo;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    @Override
    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public Map getHTMLDataMap() {
        return this.htmlMap;
    }

    public String getXMLData(String objContext, String editFlag, String pgContext) throws ITMException {
        E12GenericUtility genericUtility = new E12GenericUtility();
        String blankDomStr = "";
        String XTRA_PARAMS_SEPARATOR = "~~";
        BaseLogger.log("2", this.userInfo, null, "Getting XML Data ......");
        BaseLogger.log("2", this.userInfo, null, "Getting XML data string for objContext :[" + objContext + "] editFlag :[" + editFlag + "] pgContext :[" + pgContext + "]");
        String retXMLStr = null;
        try {
            String defaultPathForMetadataXML = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;
            String standardNameForXML = String.valueOf(this.objName) + pgContext + objContext + ".xml";
            String chgTerm = this.userInfo.getRemoteHostName();
            if (chgTerm != null && chgTerm.length() > 15) {
                chgTerm = chgTerm.substring(0, 15);
            } else if (chgTerm == null || chgTerm.length() == 0) {
                chgTerm = this.userInfo.getRemoteHost();
            }
            String xtra_params = "loginCode=" + this.userInfo.getLoginCode() + XTRA_PARAMS_SEPARATOR + "loginEmpCode=" + this.userInfo.getEmpCode() + XTRA_PARAMS_SEPARATOR + "loginSiteCode=" + this.userInfo.getSiteCode() + XTRA_PARAMS_SEPARATOR + "entityCode=" + this.userInfo.getEntityCode() + XTRA_PARAMS_SEPARATOR + "profileId=" + this.userInfo.getProfileId() + XTRA_PARAMS_SEPARATOR + "userType=" + this.userInfo.getUserType() + XTRA_PARAMS_SEPARATOR + "runMode=I" + XTRA_PARAMS_SEPARATOR + "user_lang=en" + XTRA_PARAMS_SEPARATOR + "user_country=US" + XTRA_PARAMS_SEPARATOR + "site_code=" + this.userInfo.getSiteCode() + XTRA_PARAMS_SEPARATOR + "termId=BASE" + XTRA_PARAMS_SEPARATOR + "chgTerm=" + chgTerm;
            InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
            XMLBuilderEJB xmlBuilderEJB = new XMLBuilderEJB();
            String transDB = this.userInfo.getTransDB();
            blankDomStr = xmlBuilderEJB.getDomForAdd(this.objName, objContext, standardNameForXML, xtra_params, this.userInfo);
            xmlBuilderEJB = null;
            Document detailDom = genericUtility.parseString(blankDomStr);
            NodeList detailList = detailDom.getElementsByTagName("Detail1");
            if (detailList.getLength() > 0) {
                detailList.item(0).getAttributes().getNamedItem("domID").setNodeValue("1");
            }
            String changeString = "<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>" + "<Root>" + "<header>" + "<objContext>" + objContext + "</objContext>" + "<focusedColumn><![CDATA[itm_default]]></focusedColumn>" + "<keyValue><![CDATA[1]]></keyValue>" + "<saveLevel><![CDATA[1]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "</header>" + "</Root>";
            EventManagerEJB eventManager = new EventManagerEJB();
            eventManager.setUserInfo(this.userInfo);
            blankDomStr = genericUtility.serializeDom(detailDom);
            String eventRetString = "";
            eventRetString = transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 ? eventManager.executeSystemEvent(this.objName, "post_item_change", "1", changeString, blankDomStr, xtra_params, "1", this.userInfo) : eventManager.executeSystemEvent(this.objName, "post_item_change", "1", changeString, blankDomStr, xtra_params, "1");
            if (eventRetString.indexOf("<Errors>") == -1) {
                this.applyEventRetString(eventRetString, detailDom);
                blankDomStr = genericUtility.serializeDom(detailDom);
            } else {
                blankDomStr = eventRetString;
            }
            BaseLogger.log("3", this.userInfo, null, "blankDomStr" + blankDomStr);
            eventManager.remove();
            eventManager = null;
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("9", this.userInfo, null, "Retrieved XML Data from MasterStateful :[" + retXMLStr + "]");
        return blankDomStr;
    }

    public String getHTMLData(String objContext, String editFlag, String pgContext) throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "Getting HTML Data ...........");
        BaseLogger.log("2", this.userInfo, null, "Getting detail HTML string for objContext :[" + objContext + "] editFlag :[" + editFlag + "] pgContext :[" + pgContext + "]");
        String retHTMLStr = "";
        Object xslString = null;
        try {
            String xslFileName = this.getXSLFileName(objContext, editFlag, pgContext);
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
            String xmlData = this.getXMLData(objContext, editFlag, pgContext);
            if (xmlData != null && xmlData.length() > 0) {
                retHTMLStr = new E12GenericUtility().transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    private String getXSLFileName(String objContext, String editFlag, String pgContext) throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "Getting XSLFileName........." + CommonConstants.APPLICATION_CONTEXT);
        BaseLogger.log("2", this.userInfo, null, "Getting detail XSLFileName string for objContext :[" + objContext + "] editFlag :[" + editFlag + "] pgContext :[" + pgContext + "]");
        String retFileName = null;
        try {
            String defaultPath = null;
            defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            BaseLogger.log("3", this.userInfo, null, "Default Path :[" + defaultPath + "]+this.objName[" + this.objName + "]");
            String fileName = String.valueOf(this.objName) + pgContext + objContext + "_" + this.userLang + "_" + this.userCountry + "_" + editFlag + ".xsl";
            if (!new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).exists()) {
                BaseLogger.log("3", this.userInfo, null, "ITMProcessModel :: creating  theme folder");
                new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME).mkdir();
            }
            File xslFile = new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME, fileName);
            BaseLogger.log("9", this.userInfo, null, " ITMProcessModel::getXSLFileName::xslFile[" + xslFile + "]");
            BaseLogger.log("9", this.userInfo, null, "FileName :[" + xslFile.getAbsolutePath() + "] exists :[" + xslFile.exists() + "]");
            if (xslFile.exists()) {
                retFileName = xslFile.getAbsolutePath();
            } else {
                String xslString;
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                BaseLogger.log("3", this.userInfo, null, "Looking up for XSLBuilder...");
                DW2XSLGenerator xslGen = null;
                String transDB = this.userInfo.getTransDB();
                BaseLogger.log("3", this.userInfo, null, "DW2XSLGenerator transDB :" + transDB);
                if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0) {
                    xslGen = new DW2XSLGenerator(this.objName, objContext, pgContext, editFlag, this.userInfo);
                }
                if (!(xslString = xslGen.generateXSLString(this.userInfo)).endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    BaseLogger.log("3", this.userInfo, null, "Writing XSL String to file :[" + xslFile.getAbsolutePath() + "]");
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getAbsolutePath();
                } else {
                    retFileName = xslString;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Getting XSLFileName Data ...........retFileName:[" + retFileName + "]");
        return retFileName;
    }

    private void applyEventRetString(String toApplyString, Document detailDom) throws ITMException {
        try {
            if (toApplyString.length() > 0) {
                Document dom = new E12GenericUtility().parseString(toApplyString);
                NodeList rootNodeList = dom.getElementsByTagName("Root");
                if (rootNodeList.getLength() == 0) {
                    rootNodeList = dom.getElementsByTagName("DocumentRoot");
                }
                if (rootNodeList.getLength() == 1) {
                    NodeList domChildList = rootNodeList.item(0).getChildNodes();
                    int noOfDomChild = domChildList.getLength();
                    int detailLength = 6;
                    int domChildCtr = 0;
                    while (domChildCtr < noOfDomChild) {
                        Node domChildNode = domChildList.item(domChildCtr);
                        String nodeName = "";
                        String nodeValue = "";
                        if (domChildNode.getNodeType() == 1 && (nodeName = domChildNode.getNodeName()).startsWith("Detail")) {
                            String ctxNo = nodeName.substring(nodeName.indexOf("Detail") + detailLength);
                            NodeList detailChildList = domChildNode.getChildNodes();
                            int noOfDetailChild = detailChildList.getLength();
                            int detChildCtr = 0;
                            while (detChildCtr < noOfDetailChild) {
                                Node colNameNode = detailChildList.item(detChildCtr);
                                if (colNameNode.getNodeType() == 1 && (nodeName = colNameNode.getNodeName()) != null && !nodeName.equals("attribute")) {
                                    this.setValueOnDom(ctxNo, colNameNode, detailDom);
                                }
                                ++detChildCtr;
                            }
                        }
                        ++domChildCtr;
                    }
                }
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void setValueOnDom(String objContext, Node fromNode, Document detailDom) throws ITMException {
        try {
            BaseLogger.log("3", this.userInfo, null, "Setting value for obj context :[" + objContext + "]");
            if (objContext == null || objContext != null && objContext.length() == 0) {
                objContext = "1";
            }
            NodeList detailList = detailDom.getElementsByTagName("Detail" + objContext);
            int noOfDetails = detailList.getLength();
            int detCtr = 0;
            while (detCtr < noOfDetails) {
                Node detailNode = detailList.item(detCtr);
                NodeList detailChildList = detailNode.getChildNodes();
                int noOfDetailChild = detailChildList.getLength();
                int detChildCtr = 0;
                while (detChildCtr < noOfDetailChild) {
                    Node toColNameNode = detailChildList.item(detChildCtr);
                    if (toColNameNode.getNodeType() == 1 && fromNode.getNodeName().equals(toColNameNode.getNodeName())) {
                        Node toColValueNode = toColNameNode.getFirstChild();
                        Node fromColValueNode = fromNode.getFirstChild();
                        String nodeValue = "";
                        if (fromColValueNode != null && ((nodeValue = fromColValueNode.getNodeValue()) == null || "null".equalsIgnoreCase(nodeValue))) {
                            nodeValue = "";
                        }
                        if (toColValueNode != null && toColValueNode.getNodeValue() != null) {
                            toColValueNode.setNodeValue(nodeValue);
                        } else {
                            CDATASection cDataSection = detailDom.createCDATASection(nodeValue);
                            toColNameNode.appendChild(cDataSection);
                        }
                        NamedNodeMap fromColAttrMap = fromNode.getAttributes();
                        NamedNodeMap toColAttrMap = toColNameNode.getAttributes();
                        int fromColAttrMapLength = fromColAttrMap.getLength();
                        int toColAttrMapLength = toColAttrMap.getLength();
                        int fromAttrCnt = 0;
                        while (fromAttrCnt < fromColAttrMapLength) {
                            Node eachAttribute = fromColAttrMap.item(fromAttrCnt);
                            String attributeName = eachAttribute.getNodeName().trim();
                            String attributeValue = eachAttribute.getNodeValue().trim();
                            boolean isAttrFound = false;
                            int toAttrCnt = 0;
                            while (toAttrCnt < toColAttrMapLength) {
                                Node currDetAttr = toColAttrMap.item(toAttrCnt);
                                String currAttrName = currDetAttr.getNodeName().trim();
                                if (attributeName.equals(currAttrName)) {
                                    isAttrFound = true;
                                    currDetAttr.setNodeValue(attributeValue);
                                }
                                ++toAttrCnt;
                            }
                            if (!isAttrFound) {
                                ((Element)toColNameNode).setAttribute(attributeName, attributeValue);
                            }
                            ++fromAttrCnt;
                        }
                    }
                    ++detChildCtr;
                }
                ++detCtr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getTranComplMsg(String objName, UserInfoBean userInfo) throws ITMException {
        String winName = "";
        String tranComplMsg = "";
        try {
            if (objName != null && objName.trim().length() > 0) {
                winName = objName.trim().toLowerCase().startsWith("w_") ? objName.trim() : "w_" + objName.trim();
            }
            BaseLogger.log("3", userInfo, null, "this.userInfo11 :" + this.userInfo.toString());
            DBAccessEJB dbAccess = new DBAccessEJB();
            tranComplMsg = dbAccess.getTranComplMsg(winName, userInfo);
            dbAccess = null;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return tranComplMsg;
    }
}

