/*
 * Request ID :  W15BMIT002
 * Purpose : StrgMeetDCRWiz for implementing logic of itemchange and validation method.
 * 			To Achive the functionality of DSR Mobile Reporting for MR.
 * Date : 02-JUN-2015
 * Changes Done By : Gaurav Singh
 */
package ibase.webitm.ejb.wsfa.transactions;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;
import java.util.Map.Entry;

import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.dis.DistCommon;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;

import org.apache.commons.io.FileUtils;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.BaseLogger;
//changed by sumit sarkar om 20/02/12 [ import CommonConstants ]
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility; changed by rahul on 10-apr-2015
import ibase.utility.E12GenericUtility; //changed by rahul on 10-apr-2015
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wsfa.WSFACommon;
import ibase.webitm.ejb.wsfa.transactions.WsfaZuviusDsrMobileWizardEJB;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;

import org.xml.sax.InputSource;

import java.net.InetAddress;

import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.jfree.io.FileUtilities;
import org.json.JSONObject;


//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].
public class StrgMeetDCRWiz extends StrgMeetDCRWizard implements  StrgMeetDCRWizLocal,StrgMeetDCRWizRemote
{
	private String user_lang ="en";
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	// For Next action
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			System.out.println("wfValData:DOM ON NEXT ["+xmlString+"]");
			System.out.println("wfValData:DOM1 ON NEXT["+xmlString1+"]");
			System.out.println("wfValData:DOM2 ON NEXT["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgMeetDCRWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	// For Next action
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams,  String formName) throws RemoteException,ITMException
	{
		System.out.println("Inside wfvaldata for on next");
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
		String errString = "";

		int currentFormNo = 0;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		ResultSet stpRs = null;
		String empCodeHO="";
		String empCodeMGR=""; //added by shraddha M[01-dec-2020]
		String stpStatus="";
		String usrTypeLogin = "";
		//String customerName = "";
		String scCode = "";
		String custType = "";
		
		//added by prachi
		StringBuffer errStringXml1;
		String errorString2="";
		errStringXml1 = new StringBuffer();
		errStringXml1.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		//end

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		int noOfChilds = 0;
		try
		{
			String dbName =CommonConstants.DB_NAME;
			connectionObject = getConnection();
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			userId = getEmpCode(userId, connectionObject);
			//System.out.println("call valdata");
			System.out.println("wfValData objContext   ["+objContext+"]");
			//Added by Bhagyashri T for check perticular division
			ArrayList gradeArrayList = new ArrayList();
			String gradeS ="";
			String gradeArray = getGradeForSTP(userId,connectionObject);
			String gradesql = "SELECT GRADE FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = connectionObject.prepareStatement(gradesql);
			pstmt.setString(1, userId);

			rSet = pstmt.executeQuery();
			if( rSet.next() )
			{
				gradeS  = checkNull(rSet.getString("GRADE"));
			}
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Added by bhagyashri to check perticular Div Check
			// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stockist_code [start]
			String parmValue = "";
			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
			pstmt = connectionObject.prepareStatement(sfaParmSql);
			rSet = pstmt.executeQuery();
			if (rSet.next())
			{
				parmValue = checkNull(rSet.getString("PARM_VALUE"));
			}
			if(rSet != null)
			{
				rSet.close();
				rSet = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			String stockistTable = getSfaParmValue(loginEmpCode,"GET_STOCKIST_DETAILS",connectionObject);
			// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stockist_code [start]

			//0- Don't allow if created from real time reporting, 1-Always Allow, 2-Never allow.
			String allowEditPlace = "0",allowEditCust = "0";
			allowEditPlace = getSfaParmValue(userId,"ALLOW_EDIT_PLACE_DCR",connectionObject);
			allowEditCust = getSfaParmValue(userId,"ALLOW_EDIT_CUST_DCR",connectionObject);
			//System.out.println("allowEditPlace:::"+allowEditPlace+"  allowEditCust:::"+allowEditCust);
			//Added by mrunalini sinkar on 12-jan-2022 Start
			String isFormMandatory = checkNull(getSfaParmValue(userId, "IS_FORM_MANDATORY", connectionObject));
			String sfaparmBrand = checkNull(getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", connectionObject));

			String [] parmTemp = isFormMandatory.split(",");
			List<String> parmNamelist = new ArrayList<String>();

			for(int i = 0 ;i < parmTemp.length;i++)
			{
				if(!parmNamelist.contains(parmTemp[i]) )
				{
					parmNamelist.add(parmTemp[i]);
				}
			}
			//Added by mrunalini sinkar on 12-jan-2022 End
			//Added by bhagyashri T for EUIN VALIDATION of Fortune[06/01/22]
			DARCommonBean darCommonBean= new DARCommonBean();
			String isFortuneAct  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			if("mainform".equalsIgnoreCase(formName))
			{
				String updateFlag="";
				errString = wfValSalesPersAct(dom, dom2, objContext, userId,connectionObject);
				//ADDED BY PRACHI FOR HOLIDAY VALIDATION
				System.out.println("ErrorString is::: ["+errString+"]");
				if(errString.length()>0)
				{
				   int indexoftype =errString.indexOf("</type>");
				   String erorrTyp = (Character.toString(errString.charAt(indexoftype-1))).trim();
				   if(erorrTyp.equals("W"))
				   {
					   String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
					   errStringXml1.append(bifurErrString);
					   errString = "";
				   }
				} 
				// commented by Mrunalini sinkar on 12/07/18 validation not working on holiday
				//if( errString.indexOf( "<Errors>" ) == -1 )
				//{
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength inside case 1"+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
						//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)

						if(childNodeName.equalsIgnoreCase("event_date"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
								break;
							}
							else
							{
								String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom ));

								SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
								java.util.Date eventDate = null;
								try
								{
									eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
									//System.out.println("eventDate is : ["+eventDate+"]");
								}
								catch ( Exception e )
								{
									//System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

								String evtdat=childNode.getFirstChild().getNodeValue();
								if (!sdfFormat.format(eventDate).equals(evtdat))
								{
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(start)
								String futureDate="";
								String eventType = checkNull(genericUtility.getColumnValue( "activity_code" , dom2 ,objContext));
								String itemSer = getItemSer(userId,connectionObject);
								//String actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? AND ITEM_SER = ? ";
								String actSql = "SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? "+
										 "AND (ITEM_SER IS NULL OR ITEM_SER = 'ALL' OR ITEM_SER = ?) "+
										 "AND (SITE_CODE IS NULL OR SITE_CODE = 'ALL' OR (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?) IN "+
										 "(SELECT REGEXP_SUBSTR(SITE_CODE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(SITE_CODE, '[^,]+', 1, LEVEL) IS NOT NULL) ) "+
										 "ORDER BY DESCR ";
								pstmt = connectionObject.prepareStatement(actSql);
								pstmt.setString(1, eventType);
								pstmt.setString(2, itemSer);
								pstmt.setString(3, userId);
								rSet = pstmt.executeQuery();
								if (rSet.next())
								{
									futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(end)
								//if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
								if (( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 && (futureDate.equalsIgnoreCase("0") || futureDate.trim().length() == 0)))
								{

									errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
									break;
								}

								//changed by rahul on 19-may-2016 [START] to check whether plan is confirm for selected work date
								String sfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
								String copyPlanValue = checkNull(genericUtility.getColumnValue( "copy_plan" , dom ));
								//System.out.println("workDate.....::::"+workDate+"....copyPlanValue......."+copyPlanValue);
								String actTranSql = "SELECT * FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ? ";
								actPstmt = connectionObject.prepareStatement(actTranSql);
								actPstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
								actPstmt.setString(2,userId);
								actRs = actPstmt.executeQuery();
								if(!actRs.next())
								{
									String planSql = "select * from  SPRS_PLAN_HDR where plan_date = ? and confirm = ? and SPRS_CODE__PLAN = ?";
									pstmt = connectionObject.prepareStatement(planSql);
									pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
									pstmt.setString(2,"Y");
									pstmt.setString(3,userId);
									ResultSet rs = pstmt.executeQuery();
									if(!rs.next() && "Y".equalsIgnoreCase(copyPlanValue) && sfaParmData.equalsIgnoreCase("Y"))
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "UNCONFPLAN" , userId );
										break;
									}
									//Added by kailash on 06-04-18 for closing prepare statement [Start]
									if (rs!= null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									//Added by kailash on 06-04-18 for closing prepare statement [End]

									// added by mrunalini sinkar for ALLOW_DAR_WO_MAP sun changes on 01-april-2019(start)
										// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(start)
										String holiday="";
										/*if(!updateFlag.equalsIgnoreCase("E"))
										{*/
											holiday = valHoliday( evtdat, userId, userId, itmDBAccessLocal, connectionObject,updateFlag);
										/*}*/
										// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(end)

									if(holiday == null || holiday.trim().length() == 0)
									{
										boolean blockConfirmation = isNoMAPForTheWorkDate(userId,workDate,connectionObject);
										if (blockConfirmation)
										{
											errString = itmDBAccessLocal.getErrorString( "event_date" , "DARNOMAP" , userId);
											break;

										}
									}

									// added by mrunalini sinkar for ALLOW_DAR_WO_MAP sun changes on 01-april-2019(end)

								}
								//Added by kailash on 06-04-18 for closing prepare statement [Start]
								if (actRs!= null)
								{
									actRs.close();
									actRs = null;
								}
								if(actPstmt!=null)
								{
									actPstmt.close();
									actPstmt = null;
								}
								//Added by kailash on 06-04-18 for closing prepare statement [End]
								// added by mrunalini sinkar on 26-june-2018 to add validation if first form date & travel date is different(start)
								String travelDate=checkNull(genericUtility.getColumnValue("travel_date", dom2));
								if(travelDate!=null && travelDate.trim().length()>0)
								{
									Date place= sdfFormat.parse(travelDate);
									if(eventDate.compareTo(place) != 0)
									{
										errString = itmDBAccessLocal.getErrorString( "event_date" , "INVPREDATE" , userId );
										break;
									}
								}
								// added by mrunalini sinkar on 26-june-2018 to add validation if first form date & travel date is different(end)

								//changed by rahul on 19-may-2016 [END] to check whether plan is confirm for selected work date
								// added

								//Added by Hariom  on 19-August-2019 for bangladesh user(start)
								String code="";
								String fromDate="";
								String brndParmData  = checkNull(getSfaParmValue(userId,"DAR_BRAND_MANDATE",connectionObject));

								if(brndParmData.equalsIgnoreCase("Y"))
								{

									String frDate="SELECT FR_DATE-1 AS FR_DATE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(frDate);
									pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										fromDate= checkNull(rSet.getString("FR_DATE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}


									String periodCode="SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(periodCode);
									pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(fromDate));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										code= checkNull(rSet.getString("CODE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}

									String brandSql = "SELECT * FROM STRG_BRAND_ACT WHERE SALES_PERS = ? AND PRD_CODE = ? ";
									pstmt = connectionObject.prepareStatement(brandSql);
									pstmt.setString(1,userId);
									pstmt.setString(2,code);
									rSet = pstmt.executeQuery();

									if(rSet.next())
									{
										System.out.println("Records are Present........");
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "INVLIDDAR" , userId );
										break;

									}
									//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}
                                    //Added by Hariom for dirty connection close - 11-Feb-2021 [End]
								}

								//Added by Hariom  on 19-August-2019 for bangladesh user(end)

								// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [start]
								empCodeHO = getHOEmployee( userId, connectionObject );
								empCodeMGR = getMGREmployee(userId,connectionObject); //added by shraddha M for STP DAR block Issue [W20HSUN035] 01-dec-2020 
								System.out.println("empCodeMGR Code value DAR MR Comp: ["+empCodeMGR+"]["+empCodeHO+"]");
								String stpChksql="SELECT STP_STATUS FROM SALES_PERS WHERE SALES_PERS = ?";
								pstmt = connectionObject.prepareStatement(stpChksql);
								pstmt.setString(1,userId);
								stpRs = pstmt.executeQuery();
								if(stpRs.next())
								{
                                    stpStatus = checkNull(stpRs.getString("STP_STATUS"));
                                }
                                if(stpRs != null)
								{
									stpRs.close();
									stpRs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
								{
                                    usrTypeLogin = "H";
								}
								else if(empCodeMGR !=null && empCodeMGR.length() > 0)  //added by shraddha M for STP DAR block Issue [W20HSUN035] 01-dec-2020 
								{
                                    usrTypeLogin = "M";
								}
								else
								{
                                    usrTypeLogin = "SO";
								}
								System.out.println("usrTypeLogin wfValDAta["+usrTypeLogin+"]");
								
								if( (!"H".equalsIgnoreCase(usrTypeLogin)) && ((!"M".equalsIgnoreCase(usrTypeLogin))) ) //changes by shraddha M for STP DAR block Issue [W20HSUN035] 01-dec-2020
								{
									if(stpStatus.equalsIgnoreCase("2"))
									{
										// changes by Jatin M for STP Resubmit issue [W20JSUN024] 19-JAN-2021 [start]
										int salesPersCnt = 0;
										String stpStatSql = "SELECT COUNT(*) AS CNT FROM SPRS_STP_STAT WHERE SALES_PERS=?";  
										PreparedStatement pstmtStat = connectionObject.prepareStatement(stpStatSql);
										pstmtStat.setString(1, userId);
										ResultSet stpStatRs = pstmtStat.executeQuery();
										if(stpStatRs.next())
										{
											salesPersCnt = stpStatRs.getInt("CNT");
										}
										if(stpStatRs!=null)
										{
											stpStatRs.close();
											stpStatRs=null;
										}
										if(pstmtStat!=null)
										{
											pstmtStat.close();
											pstmtStat = null;			
										}
										/*if(salesPersCnt > 0)
										{
											int darBkdy=0;
											long daysDiff = getSTPApproveDateDiff(userId,connectionObject);
											String darBckDys = checkNull(getSfaParmValue(userId, "STP_DAR_BLOCK_DAYS", connectionObject));
											if(darBckDys != null && darBckDys.trim().length()>0)//Added by mrunalini sinkar if sfaparm is not exist
											{
												darBkdy = Integer.parseInt(darBckDys);
											}
											//System.out.println("daysDiff::["+daysDiff+"]::itemSer::["+itemSer+"]::darBckDys::["+darBckDys+"]::darBkdy::["+darBkdy+"]");
											if(daysDiff > darBkdy )
											{
												errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
												return errString;
											}
										}
										else
										{
											errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
											return errString;
										}*/
										// changes by Jatin M for STP Resubmit issue [W20JSUN024] 19-JAN-2021 [end]
										System.out.println("Inside StrgMeetDCRWiz wfvaldata");
										if(gradeArray != null && gradeArray.trim().length() > 0)
										{
											String[] grdArray = gradeArray.split(",");
											System.out.println("GradeCode StrgMeetDCRWiz wfvaldata::>>::"+grdArray);

											for( int cntr = 0 ; cntr < grdArray.length ; cntr++ )
						                    {
												gradeArrayList.add(checkNull(grdArray[cntr]));
						                    }
										}
										System.out.println("GradearrayList StrgMeetDCRWiz wfvaldata ::::>>::["+gradeArrayList+"]::SalesGradeCode StrgMeetDCRWiz wfvaldatal::["+gradeS+"]");
										if(gradeArrayList.contains(gradeS) )
										{
											System.out.println("gradeArrayList.contains(gradeS):StrgMeetDCRWiz wfvaldata");
											if(salesPersCnt > 0)
											{
												System.out.println("Inside salesPersCnt > 0 :StrgMeetDCRWiz wfvaldata");
												int darBkdy=0;
												long daysDiff = getSTPApproveDateDiff(userId,connectionObject);
												String darBckDys = checkNull(getSfaParmValue(userId, "STP_DAR_BLOCK_DAYS", connectionObject));
												if(darBckDys != null && darBckDys.trim().length()>0)//Added by mrunalini sinkar if sfaparm is not exist
												{
													darBkdy = Integer.parseInt(darBckDys);
												}
												if(daysDiff > darBkdy )
												{
													System.out.println("Inside daysDiff > darBkdy :StrgMeetDCRWiz wfvaldata");
													errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
													return errString;
												}
											}
											else
											{
												System.out.println("Inside else salesPersCnt > 0 :StrgMeetDCRWiz wfvaldata");
												errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
												return errString;
											}
										}
										System.out.println("outside :StrgMeetDCRWiz wfvaldata");
									}
								}
								/*if(stpRs != null)
								{
									stpRs.close();
									stpRs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}*/
								// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [end]
								int dojValidCount = 0;
								String sDobj = "SELECT COUNT(1) AS CNT FROM EMPLOYEE E WHERE EMP_CODE = ? AND ? < E.DATE_JOIN";
								pstmt = connectionObject.prepareStatement(sDobj);
								pstmt.setString(1, userId);
								pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( evtdat, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

								rSet = pstmt.executeQuery();
								if (rSet.next())
								{
									dojValidCount = rSet.getInt("CNT");
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								if(dojValidCount > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "INVDTJWRK" , userId );
									break;
								}

								String salesMode = "", deviceType = "";
								String modeSql = "SELECT MODE_REPO FROM SALES_PERS WHERE SALES_PERS= ? ";
								pstmt = connectionObject.prepareStatement(modeSql);
								pstmt.setString(1,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	salesMode = checkNull(rSet.getString("MODE_REPO"));
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								/*String deviceTypeSql = "SELECT DEVICE_TYPE, TO_CHAR(LOGINTIME, 'DD-MM-YYYY HH24:MI:SS A.M.') FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = (SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ?)";
								pstmt = connectionObject.prepareStatement(deviceTypeSql);
								pstmt.setString(1,userId);
								pstmt.setString(2,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	deviceType = checkNull(rSet.getString("DEVICE_TYPE"));
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}*/

								deviceType = getUserInfo().getDeviceType();
								System.out.println("deviceType is wfvaldata:::::::::::::::["+deviceType+"]");

							    if (!deviceType.trim().equalsIgnoreCase("Browser") && salesMode.equalsIgnoreCase("W"))
							    {
								    errString = itmDBAccessLocal.getErrorString( "event_date" , "INVLIDMODE" , userId );
							    }

							    String propValue = fetchPropertyValue("NETREPORT_MOBMODE_DISSALLOW" , itemSer , connectionObject);
							    if (deviceType.trim().equalsIgnoreCase("Browser"))
								{
									if (salesMode.equalsIgnoreCase("M") && propValue.indexOf(updateFlag) >= 0)
									{
											errString = itmDBAccessLocal.getErrorString( "work_date" , "MOBNETNA" , userId );
											break;
									}
								}

							    String activityType = checkNull(genericUtility.getColumnValue( "activity_type" , dom2 ,objContext));
							    //if(!(updateFlag.equalsIgnoreCase("E")))
								if(!(updateFlag.equalsIgnoreCase("E")) && "FW".equalsIgnoreCase(activityType))
								{
									int alwdDelPrd = 0;
									checkSQL = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
									pstmt = connectionObject.prepareStatement(checkSQL);
									pstmt.setString(1, userId);
									rSet = pstmt.executeQuery();
									if (rSet.next())
									{
										alwdDelPrd = rSet.getInt("ALLWD_DELAY_PRD");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if (alwdDelPrd <= 0)
									{
										alwdDelPrd = 0;
									}

									int totDelPrd = 0;
									long diffDays = 0;
									java.util.Date currDate = new java.util.Date();
									java.util.Date tempDate = null;
									DateFormat applFormat = new SimpleDateFormat(getApplDateFormat());
									ArrayList<String> holiList = new ArrayList<String>();
									String holDate = genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());

									String holtblno = getHoltblno(userId,holDate, connectionObject);

									Calendar cal = Calendar.getInstance();
									SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
									cal.setTime( sdf.parse(evtdat) );
									tempDate = cal.getTime();
									long diff = currDate.getTime() - tempDate.getTime();
									diffDays = diff / (24 * 60 * 60 * 1000);
									Calendar calBef = Calendar.getInstance();
									//calBef.add(Calendar.DAY_OF_MONTH,-alwdDelPrd);//Commended by Hariom for holiday check -03-Nov-20
									//java.util.Date befoDate = calBef.getTime(); //Commended by Hariom for holiday check -03-Nov-20
									//String befoDateAppl = applFormat.format( befoDate ); //Commended by Hariom for holiday check -03-Nov-20
									String befoDateDB= genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());//Changes by Hariom for holiday check -03-Nov-20

									Calendar calAft = Calendar.getInstance();
									java.util.Date aftDate = calAft.getTime();
									String aftDateAppl = applFormat.format( aftDate );
									String aftDateDB= genericUtility.getValidDateTimeString( aftDateAppl , getApplDateFormat() , getDBDateFormat());
									holiList = getHolidayList(befoDateDB,aftDateDB,holtblno,userId,connectionObject);//userId added by mrunalini sinkar for change_holiday(start)

									int holCnt = holiList.size();
									totDelPrd = alwdDelPrd + holCnt;
									if (diffDays > totDelPrd)
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "MAXDELYPRD" , userId );
										break;
									}

									/*java.util.Date currDate  =new java.util.Date();
									java.util.Date tempDate = null;

									long diffDays = 0;
									Calendar cal = Calendar.getInstance();
									SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
									cal.setTime( sdf.parse(evtdat) );
									tempDate = cal.getTime();
									long diff = currDate.getTime() - tempDate.getTime();
									diffDays = diff / (24 * 60 * 60 * 1000);
									System.out.println(diffDays + " ssssdays, ");

									long holCnt = 0L;
									java.util.Date inputDt = (java.util.Date)sdf.parse(evtdat);

									for (int i = 0; i < diffDays-1 ;i++ )
									{
										evtdat = sdf.format(inputDt);
										if (i > 0)
										{
											errString = valHoliday( evtdat, userId, userId, itmDBAccessLocal, connectionObject);
											if (errString != null && errString.trim().length() > 0)
											{
												holCnt = holCnt + 1L;
											}
											errString = "";
										}
										inputDt = (java.util.Date)sdf.parse(evtdat);
										inputDt = getNextDate(inputDt);
									}

									System.out.println("alwdDelPrd::["+alwdDelPrd+"] diffDays:::["+diffDays+"] holCnt:::["+holCnt+"]");
									diffDays = diffDays - holCnt;

									if (diffDays > alwdDelPrd)
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "MAXDELYPRD" , userId );
										break;
									}*/
								}

								int Count=0;
								String count= "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ?";
								pstmt = connectionObject.prepareStatement(count);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
								pstmt.setString(2, userId);
								rSet = pstmt.executeQuery();

								if(rSet.next())
								{
									Count=rSet.getInt("COUNT");
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}

								if(pstmt !=null)
								{
									pstmt.close();
									pstmt = null;
								}
								String dcrId=checkNull(genericUtility.getColumnValue( "dcr_id" , dom ));

								if((dcrId ==null || dcrId.trim().length()==0) && Count >=1)
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "INVDATA" , userId );
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("activity_code"))
						{
							//added by kailash on 29/03/17 for validating blank activity code: start

							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","NULLACTCOD",userId);
								break;
							}
							//added by kailash on 29/03/17 for validating blank activity code: end
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))
							{
								if (columnValue.trim().length() > 2)
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
									break;
								}
								else
								{
									//Added By Gaurav Singh on 02/06/15[W15BMIT002 | to validate Leave] Start
									String eventDate = genericUtility.getColumnValue( "event_date" , dom );
									String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
									String placeRequired = genericUtility.getColumnValue( "place_required" , dom );//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
									String pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());
									ArrayList halfDayActList = halfDayActivityList("HALF_DAY_ACTIVITIES",connectionObject);
									int recCount = 0;
									ArrayList activityList = new ArrayList();
									String activitySql = "SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS=? ";
									PreparedStatement pstmtActivity = connectionObject.prepareStatement(activitySql);
									pstmtActivity.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));
									pstmtActivity.setString(2, salesPers);
									ResultSet rsActivity = pstmtActivity.executeQuery();
									while ( rsActivity.next() )
									{
										activityList.add(rsActivity.getString("ACTIVITY_CODE"));
									}
									rsActivity.close(); rsActivity = null;
									pstmtActivity.close(); pstmtActivity = null;
									recCount = activityList.size();

									//Added by Gaurav Singh on 11-06-2015 [Start]

									String actCode = genericUtility.getColumnValue( "activity_code" , dom );
									String actType ="";
									//System.out.println("actCode::"+actCode);
									int actCount = 0;

									String actSQL = " SELECT ACTIVITY_TYPE, COUNT(*) AS COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? GROUP BY ACTIVITY_TYPE ";
									pstmt = connectionObject.prepareStatement(actSQL);
									pstmt.setString(1, actCode);
									rSet =pstmt.executeQuery();
									if( rSet.next() )
									{
										actType = rSet.getString("ACTIVITY_TYPE") == null ?"":rSet.getString("ACTIVITY_TYPE");
										actCount = rSet.getInt("COUNT");
									}
									//System.out.println("actType::"+actType);
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(actCount == 0)
									{
										errString = itmDBAccessLocal.getErrorString( "activity_code", "ACTNOTFND", userId );
										break;
									}

									//added by mrunalini sinkar on 25-june-2018 for nfw select one loclaity(start)
									/*if( actType.equalsIgnoreCase("LEAVE") || actType.equalsIgnoreCase("NFW"))
										{
											errString = itmDBAccessLocal.getErrorString( "event_type", "INVACTF", userId );
											break;
										}*/
									//Changes for PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
									//if( actType.equalsIgnoreCase("LEAVE"))
									if(!"Y".equalsIgnoreCase(placeRequired))
									{
										errString = itmDBAccessLocal.getErrorString( "event_type", "INVACTF", userId );
										break;
									}

									//added by mrunalini sinkar on 25-june-2018 for nfw select one loclaity(end)
									//checkSQL = "SELECT ACTIVITY_TYPE FROM STRG_MEET,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND FIELDACTIVITY.ACTIVITY_CODE = STRG_MEET.EVENT_TYPE";
									checkSQL = "SELECT SPRS_ACT_TRAN.ACTIVITY_CODE,FIELDACTIVITY.ACTIVITY_TYPE FROM SPRS_ACT_TRAN,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND SPRS_ACT_TRAN.ACTIVITY_CODE = FIELDACTIVITY.ACTIVITY_CODE ";
									PreparedStatement pstmtMeetActivity = connectionObject.prepareStatement(checkSQL);
									pstmtMeetActivity.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));
									pstmtMeetActivity.setString(2, salesPers);
									ResultSet rSetMeetActivity = pstmtMeetActivity.executeQuery();
									while ( rSetMeetActivity.next() )
									{
										String selActivityType = "";
										String activityType = rSetMeetActivity.getString(2);
										activityType = checkNull(activityType).trim().toUpperCase();
										//Added By Shahu Mali on 11-APR-13.START
										String activityCode = checkNull(rSetMeetActivity.getString(1)).toUpperCase();
										//Added By Shahu Mali on 11-APR-13.END
										if(activityType.indexOf("LEAVE")!=-1)
										{
											String actTypeL="";
											checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
											pstmt = connectionObject.prepareStatement(checkSQL);
											pstmt.setString(1, columnValue);
											rSet =pstmt.executeQuery();
											if( rSet.next() )
											{
												//added by Bhagyahsri to check dirty connection[11/01/22][START]
												actTypeL=rSet.getString(1).trim();
												System.out.println("ActType LEAVE::"+actTypeL);
												/*if(!activityType.equalsIgnoreCase(rSet.getString(1)))
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
													break;
												}*/
												//added by Bhagyahsri to check dirty connection[11/01/22][END]
											}
											if (rSet!= null)
											{
												rSet.close();
												rSet = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}
											//added by Bhagyahsri to check dirty connection[11/01/22][START]
											if(!activityType.equalsIgnoreCase(actTypeL))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
											//added by Bhagyahsri to check dirty connection[11/01/22][END]
										}
										//else if (activityType.indexOf("NFW")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
										else if (!(activityType.equalsIgnoreCase("FW") && activityType.equalsIgnoreCase("LEAVE")))
										{
											//Changed By Vidhya on 29/09/09[WI89BAS028 | FOR EDIT CASE] Start
											String ActType ="";
											checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
											pstmt = connectionObject.prepareStatement(checkSQL);
											pstmt.setString(1, columnValue);
											rSet =pstmt.executeQuery();
											if( rSet.next() )
											{
												//added by Bhagyahsri to check dirty connection[07/01/22][START]
												ActType=rSet.getString(1).trim();
												System.out.println("ActType::"+ActType);
												/*if(!activityType.equalsIgnoreCase(rSet.getString(1)))
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
													break;
												}*/
												//added by Bhagyahsri to check dirty connection[07/01/22][START]
												}
											if (rSet!= null)
											{
												rSet.close();
												rSet = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}
											//added by Bhagyahsri to check dirty connection[07/01/22][START]
											if(!activityType.equalsIgnoreCase(ActType))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
												break;
											}
											//added by Bhagyahsri to check dirty connection[07/01/22][START]
										}
										else if (activityType.indexOf("FW")!=-1)
										{/*
												checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
												pstmt = connectionObject.prepareStatement(checkSQL);
												pstmt.setString(1, columnValue);
												rSet =pstmt.executeQuery();
												if( rSet.next() )
												{
													selActivityType = rSet.getString(1);
												}
												if (rSet!= null)
												{
													rSet.close();
													rSet = null;
												}
												if(pstmt!=null)
												{
													pstmt.close();
													pstmt = null;
												}

												//If one record present of Half day activity
												if(recCount == 1 && halfDayActList.contains(activityCode) && !halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
													break;
												}
												//If one record present of Full day activity and trying to select half day activity
												if(recCount == 1 && !halfDayActList.contains(activityCode) && halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG1", userId );
													break;
												}
												//If one record present of Full day activity and type is mismatch means other activity is selected like : LEAVE, NFW etc
												if(recCount == 1 && !halfDayActList.contains(activityCode) && !activityType.equalsIgnoreCase(selActivityType) )
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG2", userId );
													break;
												}
												//Two records present(one mktev and one FW) and the selected
												if(recCount > 1 && !halfDayActList.contains(columnValue))//OK
												{
													//errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG3", userId );
													break;
												}
										 */}
										else
										{/*
												checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
												pstmt = connectionObject.prepareStatement(checkSQL);
												pstmt.setString(1, columnValue);
												rSet =pstmt.executeQuery();
												if( rSet.next() )
												{
													selActivityType = rSet.getString(1);
												}
												if (rSet!= null)
												{
													rSet.close();
													rSet = null;
												}
												if(pstmt!=null)
												{
													pstmt.close();
													pstmt = null;
												}
												//If one record present of Half day MKTEV and Trying to put Full Day activity
												if(recCount == 1 && halfDayActList.contains(activityCode) && !halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG4", userId );
													break;
												}
												//If one record present of Full day MKTEV and trying to put half day MKTEV
												if(recCount == 1 && !halfDayActList.contains(activityCode) && halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG5", userId );
													break;
												}
												//If one record present of Full day MKTEV activity and type is mismatch means other activity is selected like : LEAVE, NFW etc
												if(recCount == 1 && !halfDayActList.contains(activityCode) && !activityType.equalsIgnoreCase(selActivityType) )
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG6", userId );
													break;
												}
												//Two records present(one mktev and one FW) and the selected
												if(recCount > 1 && !halfDayActList.contains(columnValue))//OK
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG7", userId );
													break;
												}
										 */}
									}
									if (rSetMeetActivity!= null)
									{
										rSetMeetActivity.close();
										rSetMeetActivity = null;
									}
									if(pstmtMeetActivity!=null)
									{
										pstmtMeetActivity.close();
										pstmtMeetActivity = null;
									}

								}//else of if (columnValue.trim().length() > 2)
							}//if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))
						}//if(childNodeName.equalsIgnoreCase("activity_code"))
						else if(childNodeName.equalsIgnoreCase("remark"))
						{
							//System.out.println("Inside remark");
							if(columnValue != null && columnValue.length() >100)
							{
								errString = itmDBAccessLocal.getErrorString( "remark", "INVALREMRK", userId );
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("oth_participant"))
						{
							//System.out.println("oth_participant remark");
							if(columnValue != null && columnValue.length() >120)
							{
								errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
								break;
							}
						}
						// added by rupali on 06/08/17 for visited with validation[start]
						else if(childNodeName.equalsIgnoreCase("visited_with"))
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								int index ;
								String reportToSql = "";
								ArrayList teamList = new ArrayList();
								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								if(dbName.equalsIgnoreCase("DB2"))
								{
									reportToSql ="select DISTINCT REPORT_TO from employee where fn_emp_hierarcy_up(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
								}
								else if(dbName.equalsIgnoreCase("ORACLE"))
								{
									reportToSql ="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
								}
								// added by rupali on 13/04/18 for org_structure related changes [start]
								String eventDate = genericUtility.getColumnValue( "event_date" , dom );
								String isOrgStrcture = getSfaParmValue(salesPers,"HIERARCY_FRM_ORG_STR",connectionObject);
								if("Y".equalsIgnoreCase(isOrgStrcture))
								{
								OrgStructure orgStructure = new OrgStructure();
								teamList = orgStructure.reportToUp(salesPers,eventDate,connectionObject);
								}
								// added by rupali on 13/04/18 for org_structure related changes [end]
								if(teamList == null || teamList.isEmpty()) // added by rupali on 13/04/18 for org_structure related changes
								{
									pstmt = connectionObject.prepareStatement(reportToSql);
									pstmt.setString(1, salesPers);
									rSet =pstmt.executeQuery();
									while(rSet.next())
									{
										String teamMember = checkNull(rSet.getString("REPORT_TO"));
										teamList.add(teamMember);

									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
								}
								String visitedWith = genericUtility.getColumnValue( "visited_with" , dom );
								String [] temp = visitedWith.split(",");
								for(int i = 0 ;i < temp.length;i++)
								{
									String visitTeam = temp[i];
									if(visitTeam!=null || !visitTeam.equalsIgnoreCase(""))
									{
										if(visitTeam.indexOf("(") != -1 && visitTeam.indexOf(")") != -1)
										{
											String selTeam = checkNull(visitTeam.substring(visitTeam.indexOf("(")+1, visitTeam.indexOf(")")));
											if(!teamList.contains(selTeam))
											{
												String division=getItemSer(salesPers, connectionObject);
												int rolCnt=0;
												String sql2="SELECT COUNT(*) AS CNT FROM EMPLOYEE EMP, GRADE G " + 
														"WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
														"WHERE ORG_UNIT=? CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE AND EMP.EMP_CODE=? ";
												pstmt = connectionObject.prepareStatement(sql2);
												pstmt.setString(1, division);
												pstmt.setString(2, selTeam);

												rSet =pstmt.executeQuery();
												if(rSet.next())
												{
													rolCnt=rSet.getInt("CNT");
												}
												if (rSet!= null)
												{
													rSet.close();
													rSet = null;
												}
												if(pstmt!=null)
												{
													pstmt.close();
													pstmt = null;
												}
												if(rolCnt==0)
												{
													errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
													return errString;
												}

											}

										}
										else
										{
											errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
											return errString;
										}
									}

								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("sprs_locality_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
									errString =getErrorString("sales_pers","NULLJOURN",userId);
									break;
							}
							else
							{
								int count=0;
								String sql="SELECT COUNT(*) AS COUNT " + 
										"FROM SPRS_ROUTE SR, STATION ST WHERE SR.STAN_CODE = ST.STAN_CODE AND SR.SPRS_CODE =? AND SR.STATUS='Y' " + 
										"AND SR.LOCALITY_CODE=?";
								pstmt = connectionObject.prepareStatement(sql);

								pstmt.setString(1, userId);
								pstmt.setString(2, columnValue);

								rSet =pstmt.executeQuery();
								if( rSet.next() )
								{
									count=rSet.getInt("COUNT");
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count ==0)
								{
									errString = itmDBAccessLocal.getErrorString( "sprs_locality_code", "INVALLOCFR", userId );
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString =getErrorString("sales_pers","NULSPCODNM",userId);
								break;
							}
							/*else
							{
								DARCommonBean darCommonBean= new DARCommonBean();
								String standCodeHQ=darCommonBean.getStandCodeHq(userId, connectionObject);
								System.out.println("standCodeHQ is:["+standCodeHQ+"]");
								if(standCodeHQ==null || standCodeHQ.trim().length()==0)
								{
									errString = itmDBAccessLocal.getErrorString( "sales_pers", "HQNTCONFIG", userId );
									break;
								}
								else
								{
									boolean isRouteConfig=darCommonBean.checkHeadquarterRouteIsAvilable(userId, standCodeHQ, connectionObject);
									System.out.println("isRouteConfig is:["+isRouteConfig+"]");

									if(!isRouteConfig)
									{
										errString = itmDBAccessLocal.getErrorString( "sales_pers", "ROUTCONFIG", userId );
										break;
									}
								}
							}*/
						}
						// added by rupali on 06/08/17 for visited with validation[start]
					}//inner for

					if ( errString != null && errString.trim().length() > 0 )
					{
						break;
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
				}//outer for
				//}//if (indexOf("Errors")
				//Changed by Vidhya on 10/1/2009 [ WI89BAS033 Extending Validation for Edit ] End
			}
			// Added by Harion S for fortune server -18-May-2021 [Start]
			else if("activity".equalsIgnoreCase(formName))
			{
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				String updateFlag = "";
				String CheckUpdateFlag = "";
				
				SimpleDateFormat date12Format = new SimpleDateFormat("hh:mm a");
			    SimpleDateFormat date24Format = new SimpleDateFormat("HH:mm");
			  
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";


					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
					}
					//System.out.println("Checking update flag for 3+"+updateFlag);
					if(updateFlag != null)
					{
						updateFlagCnt++;
					}
				}
				//System.out.println("selectedFlagCnt [case 2] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("activity_code","ACTNOTSEL",userId);
				}
				if(parentNodeListLength == 0 )
				{
					errString = getErrorString("activity_code","ACTNOTSEL",userId);
				}

				if(selectedFlagCnt > 0)
				{
					String visitTimeFr = "";
					String visitTimeTo = "";
				    ArrayList<String> fromTime = new ArrayList<String> ();
					ArrayList<String>  toTime = new ArrayList<String> ();
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Checking update flag for 2:--"+CheckUpdateFlag);
							if(!"D".equalsIgnoreCase(CheckUpdateFlag))
							{
								//visitTimeFr = "";
								//visitTimeTo = "";
								if(childNodeName.equalsIgnoreCase("visit_time_fr"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || 
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))				
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_fr","NULEVENTTS",userId);
										break;
									}
									else
									{
										if(childNode.getFirstChild() != null)
										{
											visitTimeFr = checkNull(childNode.getFirstChild().getNodeValue());
										}
										String time1 = date24Format.format(date12Format.parse(visitTimeFr));
										System.out.println("visit time from fromTime.size()  ::::::: ["+fromTime.size()+"]");
										System.out.println("visit time from toTime.size()  ::::::: ["+toTime.size()+"]");
										System.out.println("visit time from time1  ::::::: ["+time1+"]");

										if(fromTime.size() !=0 && toTime.size() !=0)
										{
											String minFromTime=(String) Collections.min(fromTime);  
											String maxTOTime=(String) Collections.max(toTime);  
											System.out.println("visit time from child nameminFromTime ::::::: ["+minFromTime+"]maxTOTime["+maxTOTime+"]");
											SimpleDateFormat format = new SimpleDateFormat("hh:mm");

											java.util.Date visitfromTime =  format.parse(time1);
											java.util.Date listFromTime =  format.parse(minFromTime);
											java.util.Date listToTime =  format.parse(maxTOTime);
											System.out.println("visit time from child visitfromTime ::::::: ["+visitfromTime+"]listFromTime["+listFromTime+"]listToTime["+listToTime+"]");


											if(fromTime.contains(time1))
											{
												System.out.println("*****validate....visit_time_fr.*****");
												errString = itmDBAccessLocal.getErrorString("visit_time_to","VTVSTTIM07",userId);
												break;
											}
											else
											{
												fromTime.add(time1);

											}
										}
										else
										{
											fromTime.add(time1);
										}
										
										
									
									}
								}
								else if(childNodeName.equalsIgnoreCase("visit_time_to"))
								{
									
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || 
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))				
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_to","NULEVENTED",userId);
										break;
									}
									else
									{
										if(childNode.getFirstChild() != null)
										{
											visitTimeTo = checkNull(childNode.getFirstChild().getNodeValue());
										}
										String time2 = date24Format.format(date12Format.parse(visitTimeTo));
										
										System.out.println("visit_time_to fromTime.size()  ::::::: ["+fromTime.size()+"]");
										System.out.println("visit_time_to toTime.size()  ::::::: ["+toTime.size()+"]");
										System.out.println("visit_time_to time2  ::::::: ["+time2+"]");
										
										if(fromTime.size() !=0 && toTime.size() !=0)
										{
											String minFromTime=(String) Collections.min(fromTime);  
											String maxTOTime=(String) Collections.max(toTime);  
											System.out.println("visit_time_to child nameminFromTime ::::::: ["+minFromTime+"]maxTOTime["+maxTOTime+"]");

											SimpleDateFormat format = new SimpleDateFormat("hh:mm");

											java.util.Date visitToTime =  format.parse(time2);
											java.util.Date listFromTime =  format.parse(minFromTime);
											java.util.Date listToTime =  format.parse(maxTOTime);
											System.out.println("visit_time_to child visitToTime ::::::: ["+visitToTime+"]listFromTime["+listFromTime+"]listToTime["+listToTime+"]");


												if(toTime.contains(time2))
												{
													System.out.println("*****validate....visit_time_to.*****");

													errString = itmDBAccessLocal.getErrorString("visit_time_to","VTVSTTIM07",userId);
													break;

												}
											else
											{
												toTime.add(time2);
											}
										}
										else
										{
											toTime.add(time2);

										}
									}
								}
						
							}

							

						}
					}
					if(errString == null || errString.length()==0 )
					{

						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{
							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							for (int ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}

								if ( childNode != null && childNode.getFirstChild() != null )
								{
									columnValue = childNode.getFirstChild().getNodeValue();
								}
								childNodeName = childNode.getNodeName();
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}
								childNodeName = childNode.getNodeName();
								if(childNodeName.equalsIgnoreCase("attribute"))
								{
									if(childNode.getAttributes().getNamedItem("updateFlag") != null)
									{
										CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
									}
								}
								if(!"D".equalsIgnoreCase(CheckUpdateFlag))
								{
									System.out.println("fromTime  ::::::: ["+fromTime+"]");
									System.out.println("toTime  ::::::: ["+toTime+"]");
									
									
									if( fromTime.size() > 0 && toTime.size() > 0 )
									{
										

										for(int i=0 ;i<toTime.size();i++)
										{
											String maxToDate=(String) Collections.max(toTime);
											System.out.println("maxToDate in string fromat  ::::::: ["+maxToDate+"]");

											SimpleDateFormat format = new SimpleDateFormat("hh:mm");
											java.util.Date maxDateFormat =  format.parse(maxToDate);
											System.out.println("maxDateFormat in Date fromat  ::::::: ["+maxDateFormat+"]");

											String currentTime=toTime.get(i);
											System.out.println("currentTime in string fromat  ::::::: ["+currentTime+"]");

											java.util.Date curentDate =  format.parse(currentTime);
											System.out.println("curentDate in Date fromat  ::::::: ["+curentDate+"]");
											System.out.println("maxDateFormat.compareTo(curentDate)  ::::::: ["+maxDateFormat.compareTo(curentDate)+"]");

											if(maxDateFormat.compareTo(curentDate)!=0)
											{
												System.out.println("fromTime.contains ::::::: ["+fromTime.contains(toTime.get(i))+"]");

												if(!fromTime.contains(toTime.get(i)))
												{
													errString = itmDBAccessLocal.getErrorString("visit_time_to","VTVSTTIM06",userId);
													break;
												}
											}
											

										}
										

										
											
										String arrayFromData=(String) Collections.min(fromTime);  
										String arrayToData=(String) Collections.max(toTime);  
										System.out.println("arrayFromData  ::::::: ["+arrayFromData+"]");
										System.out.println("arrayToData  ::::::: ["+arrayToData+"]");
						
										
										SimpleDateFormat format = new SimpleDateFormat("hh:mm");
										java.util.Date date1 =  format.parse(arrayFromData);
										java.util.Date date2 =  format.parse(arrayToData);
										
										long difference = date2.getTime() - date1.getTime(); 
										
										//String fixedTime="08:30";
										String fixedTime =checkNull(getSfaParmValue(loginEmpCode,"FIXED_TIME_FORTUNE_ACTIVITY",connectionObject));
										
										System.out.println("fixedTime  ::::::: ["+fixedTime+"]");
										
										String fixedHours=fixedTime.split(":")[0];
										int fixedHours1 =Integer.parseInt(fixedHours);

										String fixedMin=fixedTime.split(":")[1];
										int fixedMin1 =Integer.parseInt(fixedMin);

										java.util.Date fixedTimeDate =  format.parse(fixedTime);
										
										System.out.println("From and To Between Time - "+(difference / 3600000) + ":" + (difference % 3600000) / 60000);
										String differentTime= (difference / 3600000)+":"+(difference % 3600000) / 60000;
										java.util.Date differentTimeDate =  format.parse(differentTime);
												
										String actualHours=differentTime.split(":")[0];
										int actualHours1 =Integer.parseInt(actualHours);
										String actualMin=differentTime.split(":")[1];
										int actualMin1 =Integer.parseInt(actualMin);
										/*if(differentTimeDate.getTime() < fixedTimeDate.getTime())
										{
											
											System.out.println(" validate.............");
											errString = itmDBAccessLocal.getErrorString("visit_time_to","VTVSTTIM05",userId);
											break;
										}*/
																			
										if(actualHours1 < fixedHours1 )
										{
											
											System.out.println(" validate.............");
											errString = itmDBAccessLocal.getErrorString("visit_time_to","VTVSTTIM05",userId);
											break;
										}
										else if(actualHours1 == fixedHours1 && actualMin1 < fixedMin1 )
										{
											System.out.println(" validate.............");
											errString = itmDBAccessLocal.getErrorString("visit_time_to","VTVSTTIM05",userId);
											break;
										}
										else
										{
											System.out.println("Not validate.............");
										}
										
										
										
									}
								}
							}
						}
					
					}

					
					
					
				}
			
			
			}
			// Added by Harion S for fortune server -18-May-2021 [End]

			else if("place".equalsIgnoreCase(formName))
			{
				//System.out.println("Case 2 : validation ::");
				String localityDescr = "";
				int counter = 0;
				Hashtable hs = new Hashtable();
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				ArrayList orderVisitList = new ArrayList ();
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				String updateFlag = "";
				String CheckUpdateFlag = "";
				List selLocCodeList = new ArrayList();
				//added by mrunalini sinkar on 25-june-2018(start)
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
				String actType= checkNull(getColumnValue("activity_type", dom2, mainFormNo));
				//added by mrunalini sinkar on 25-june-2018(end)
				String placeParamValue=checkNull(getSfaParmValue(userId,"NO_VISIT_SEL_VAL_REQ",connectionObject));

				int selUpdtFlagCnt = 0;
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";


					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
					}
					//System.out.println("Checking update flag for 3+"+updateFlag);
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "travel_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)

					//if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))//Commented by poonam
					if(updateFlag != null)
					{
						updateFlagCnt++;
						if("D".equalsIgnoreCase(updateFlag))
						{
							selUpdtFlagCnt++;
						}
					}
				}
				if((selectedFlagCnt == 0 && updateFlagCnt > 0) || updateFlagCnt == selUpdtFlagCnt)
				{
					errString = getErrorString("locality_code","LOCNOTSEL",userId);
				}
				if(parentNodeListLength == 0 )
				{
					errString = getErrorString("locality_code","LOCNOTSEL",userId);
				}

				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Checking update flag for 3:--"+CheckUpdateFlag);
							if(!"D".equalsIgnoreCase(CheckUpdateFlag))
							{
								if(childNodeName.equalsIgnoreCase("locality_code"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = getErrorString("locality_code","NULLOCCD",userId);
										break;
									}
									else
									{
										String locality = childNode.getFirstChild().getNodeValue();
										//System.out.println("case 3 :: locality :: ["+locality+"]");
									}
									//System.out.println("Column Value "+ columnValue +":updateFlag:"+updateFlag);
									/*if(!("D".equalsIgnoreCase(CheckUpdateFlag)))
									{
										selLocCodeList.add(checkNull(columnValue));
									}*/
									//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
									if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditPlace))
									{
										errString = itmDBAccessLocal.getErrorString("locality_code","DESELLOCLT",userId);
										break;
									}
									//TODO
								}
								else if(childNodeName.equalsIgnoreCase("sales_pers"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = getErrorString("sales_pers","NULSLSPRS",userId);
										break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("order_of_visit"))
								{
									//System.out.println("order_of_visit :: case3");
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = getErrorString("order_of_visit","NULORDRV",userId);
										break;
									}
									//Added by Poonam Gole on 10-12-2015 for validation of order_of_visit:Start
									else
									{
										//System.out.println("order_of_visit :: case3 else loop");
										String OrderVisit = childNode.getFirstChild().getNodeValue();
										//System.out.println("OrderVisit :: "+OrderVisit);

										//System.out.println("orderVisitList :: "+orderVisitList);
										boolean OrderOfVisit = OrderVisit.matches("\\d+");

										if(OrderOfVisit == false)
										{
											errString = getErrorString("order_of_visit","INVAIDNUM",userId);
											break;
										}
										else if(OrderVisit.trim().length() > 3)
										{
											//System.out.println("wfValPlace ::: Order of visit length greater than three");
											errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST03",userId);
											break;
										}
										else if( ( Integer.parseInt( OrderVisit ) <= 0 ) )
										{
											//System.out.println("wfValPlace ::: Order of visit is negative/blank");
											errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST01",userId);
											break;
										}
										else
										{
											if (orderVisitList.contains(OrderVisit.trim()))
											{
												//System.out.println("Duplicate Order of Visit::");
												errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST02",userId);
												break;
											}
											else
											{
												//System.out.println("Array before adding in orderVisitList"+orderVisitList);
												orderVisitList.add(OrderVisit.trim());
											}
										}
									}
									//Added by Poonam Gole on 10-12-2015 for validation of order_of_visit:End
								}
							}

							String isDrVisit = getSelectedRowVal(dom2, objContext, "dr_visit",prntCtr);
							String isChemVisit = getSelectedRowVal(dom2, objContext, "chem_visit",prntCtr);
							String isStockVisit = getSelectedRowVal(dom2, objContext, "stockist_visit",prntCtr);
							String isNCWVisit = getSelectedRowVal(dom2, objContext, "other_visit",prntCtr);
							String routeType = checkNull(getSelectedRowVal(dom2, objContext, "route_type",prntCtr));

							if("N".equalsIgnoreCase(isDrVisit) && "N".equalsIgnoreCase(isChemVisit) && "N".equalsIgnoreCase(isStockVisit) && "FW".equalsIgnoreCase(actType) && !"H".equalsIgnoreCase(routeType) && !"M".equalsIgnoreCase(routeType) && "Y".equalsIgnoreCase(placeParamValue))
							{
								errString = itmDBAccessLocal.getErrorString("dr_visit","NOVISITSEL",userId);
								break;
							}
							String fortuneAct = checkNull(getSelectedRowVal(dom2, objContext, "is_place_fortune_act",prntCtr));
							String buttondisable = checkNull(getSelectedRowVal(dom2, objContext, "is_button_disable",prntCtr));
							
								if( !"FW".equalsIgnoreCase(actType) && !"Y".equalsIgnoreCase(fortuneAct)) //added by mrunalini sinkar on 25-june-2018
								{
									errString = itmDBAccessLocal.getErrorString( "activity_type", "INVACTF", userId );
									break;
								}
							
							//added by mrunalini sinkar on 25-june-2018(start)

							//added by mrunalini sinkar on 25-june-2018(end)
						}
					}
				}
			}

			else if("doctor".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int updateFlagCount = 0;

				int selUpdtFlagCnt = 0;
				//System.out.println("Case 3 Next: validation Doctor of Next::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				ArrayList drVisitList = new ArrayList();
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					System.out.println("Updated flag in next:"+updateFlag);
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null)
					{
						updateFlagCnt++;
						if("D".equalsIgnoreCase(updateFlag))
						{
							selUpdtFlagCnt++;
						}
					}
					
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCount++;
					}

				}
				drVisitList = getSelCustList(dom2, locFormNo, "dr_visit");
				String isDocMan = checkNull(getSfaParmValue(userId,"DOCTOR_MANDATORY",connectionObject));

				System.out.println("drVisitList on next :- "+drVisitList);
				System.out.println("selectedFlagCnt [doctor] on next=["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCount > 0 && "Y".equalsIgnoreCase(isDocMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isDocMan) || updateFlagCnt == selUpdtFlagCnt)
				{
					String drVisitval = "Y";
					if(drVisitList.contains(drVisitval))
					{
						errString = itmDBAccessLocal.getErrorString( "strg_code", "NODOCVISEL", userId );
					}
				}
				if(selectedFlagCnt > 0)
				{
					System.out.println("Selected flag count is greter than 0");
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName DAR:: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");
							//System.out.println("columnValue in:::"+columnValue);

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									CheckUpdateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								}
							}
							
							System.out.println("CheckUpdateFlag DAR:: ["+CheckUpdateFlag+ "]");

							

							//System.out.println("Value of update flag is in case 3 and wf vald data:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}

							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))//19/01
							{
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									String custTyp = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										//else if(uniqStrgcod.equalsIgnoreCase(strgCode))
										else if(StrgCodeCnts <=0)
										{
											//System.out.println("Inside strg code by default generated");
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										System.out.println("euinNoDupList is:::::["+euinNoDupList+"]columnValue EUIN is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
										
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												System.out.println("Duplicate EUIN NO::");
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							// added by rupali on 06/11/17 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmValue))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom2, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							// added by rupali on 06/11/17 for displaying preffered stockist field [end]
							else if(childNodeName.equalsIgnoreCase("event_time_start") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{

									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									customerName = " for "+customerName;
									errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
									errString = getDescrModifiedErrorString(errString, customerName);
									break;
									
								}
							}
							else if(childNodeName.equalsIgnoreCase("member_present") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								String memberPresent  = checkNull(getSelectedRowValue(dom2, objContext, "member_present",prntCtr));

								scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
								custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));
								if ( "0000000000".equalsIgnoreCase( scCode ) || "UR00000000".equalsIgnoreCase( scCode ) || "US00000000".equalsIgnoreCase( scCode ))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										if ("0000000000".equalsIgnoreCase(scCode))  
										{
											String customerName = " for customer Unlisted Doctor";
											errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
											errString = getDescrModifiedErrorString(errString, customerName);
											break;
										}
										
									}
									else
									{
										if(Integer.parseInt(memberPresent) <= 0)
										{
											if ("0000000000".equalsIgnoreCase(scCode)) 
											{
												String customerName = " for customer Unlisted Doctor";
												errString = itmDBAccessLocal.getErrorString( "member_present" , "INVMEMPRE" , userId );
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
									}
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{

									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));
									if ( "0000000000".equalsIgnoreCase( scCode ) || "UR00000000".equalsIgnoreCase( scCode ) || "US00000000".equalsIgnoreCase( scCode ) || custType.indexOf("UNLISTED")!= -1 )
									{
										String customerName = " for customer Unlisted Doctor";
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
								
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									if ( "0000000000".equalsIgnoreCase( scCode )  || custType.indexOf("UNLISTED")!= -1 )
									{
										String customerName = " for customer Unlisted Doctor";
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
										
								}
								else
								{
									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, objContext));
									//String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									//scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
									String startVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_start",prntCtr));
									String endVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_end",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("startVisitTime doctor:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime doctor:["+endVisitTime+"]scCode["+scCode+"]");
									if (!retFlag && "0000000000".equalsIgnoreCase( scCode ))
									{
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);

										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								System.out.println("Inside strg_code DOCTOR wf");
							
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
                                    //System.out.println("scCodeDupList is IN DOCTOR::::::::["+scCodeDupList+"]columnValue is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
									if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											System.out.println("Duplicate Doctor visited Visit DAR::");
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPDOCTR",userId);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}

									//changes done by prachi [W22FBAS009] start
									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									String invoiceFormNo = checkNull(getFormNo(objName, "invoice", connectionObject));
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside inv subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");
												
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collection", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;
									String subStrgCode="";
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									
									System.out.println("flg parmNamelist doctor in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("brand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("invoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										System.out.println("line no 2564");
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collection") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
									//changes done by prachi [W22FBAS009] end
								}
							
							}
							
							else if(formName.equalsIgnoreCase("doctor"))
							{/*
								objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
								locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
								String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
								String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
								String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom, docFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom, docFormNo, "meet_summ", prntCtr));
									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									String teamFormNo = subFormsMap.get("team");
									String displayFormNo = subFormsMap.get("display");
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}

								}
							 */}
							//TODO validation
							
						}

					}
				}

			}

			else if("retailer".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int updateFlagCount = 0;

				int selUpdtFlagCnt = 0;
				String paramValue = checkNull(genericUtility.getColumnValue("allow_stockist_dar", dom1));//Added by shradha
				//System.out.println("Case 6 Next : validation ");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				//ArrayList drVisitList = new ArrayList();
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				
				ArrayList chemVisitList = new ArrayList();
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null)
					{
						updateFlagCnt++;
						if("D".equalsIgnoreCase(updateFlag))
						{
							selUpdtFlagCnt++;
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCount++;
					}
				}
				chemVisitList = getSelCustList(dom2, "2", "chem_visit");
				String isChemMan = checkNull(getSfaParmValue(userId,"RETAILER_MANDATORY",connectionObject));

				//System.out.println("drVisitList :- "+drVisitList);
				//System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCount > 0 && "Y".equalsIgnoreCase(isChemMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isChemMan) || updateFlagCnt == selUpdtFlagCnt)
				{
					String chemVisitval = "Y";
					if(chemVisitList.contains(chemVisitval))
					{
						errString = itmDBAccessLocal.getErrorString( "strg_code", "NORETSEL", userId );
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName in retailer:: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								{
									//System.out.println("Value of updateFlag flag is in case 3:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case 3:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}

							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//System.out.println("Inside Oth_paticipant in Next Retailer");
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										//System.out.println("Inside EUIN NO validation for ADDNEW Retailer Next");
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										System.out.println("euinNoDupList is:::::["+euinNoDupList+"]columnValue EUIN is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
										
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												System.out.println("Duplicate EUIN NO::");
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name RETAILER::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							// added by rupali on 05/01/18 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmValue))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom2, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("event_time_start") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									customerName = " for "+customerName;
									errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
									errString = getDescrModifiedErrorString(errString, customerName);

									break;
									
								}
							}
							else if(childNodeName.equalsIgnoreCase("member_present") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								
								String memberPresent  = checkNull(getSelectedRowValue(dom2, objContext, "member_present",prntCtr));
								scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
								custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));
								
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if("UR00000000".equalsIgnoreCase(scCode)) 
									{
										String customerName = " for customer Unlisted Chemist";
										errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
								else
								{
									if(Integer.parseInt(memberPresent) <= 0)
									{
										if("UR00000000".equalsIgnoreCase(scCode)) 
										{
											String customerName  = " for customer Unlisted Chemist";
											errString = itmDBAccessLocal.getErrorString( "member_present" , "INVMEMPRE" , userId );
											errString = getDescrModifiedErrorString(errString, customerName);

											break;
										}
									}
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{

									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));	
									
									System.out.println("scCode is visit time retailer["+scCode+"]custType is vissit time["+custType+"]");
									if ( "0000000000".equalsIgnoreCase( scCode ) || "UR00000000".equalsIgnoreCase( scCode ) || "US00000000".equalsIgnoreCase( scCode ) || custType.indexOf("UNLISTED")!= -1 )
									{
										String customerName = " for customer Unlisted Chemist";
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSTFRC",userId);
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									
									if ( "UR00000000".equalsIgnoreCase( scCode )  || custType.indexOf("UNLISTED")!= -1 )
									{
										String customerName  = " for customer Unlisted Chemist";
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									
									
								}
								else
								{

									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, objContext));
									//String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									//scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
									String startVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_start",prntCtr));
									String endVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_end",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("retFlag["+retFlag+"scCode["+scCode+"]");
									System.out.println("startVisitTime retailer:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime retailer:["+endVisitTime+"]scCode["+scCode+"]");
									if (!retFlag && "UR00000000".equalsIgnoreCase( scCode ))
									{

										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}

								}
							}
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{

								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									//System.out.println("scCodeDupList is IN RETAILER::::::::["+scCodeDupList+"]columnValue is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
									if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											System.out.println("Duplicate Doctor visited retailer next::");
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPCHEM",userId);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}
									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;
									System.out.println("before retailer brand code");
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									System.out.println("after retailer brand");
									
									String invoiceFormNo = checkNull(getFormNo(objName, "retailerinvoice", connectionObject));
									//System.out.println("invoiceFormNo::"+invoiceFormNo);
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									//System.out.println("subParentNodeListLength1::"+subParentNodeListLength1);
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										System.out.println("subNoOfChilds::"+subNoOfChilds);
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											System.out.println("subChildNode::"+subChildNode);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collectionRetailer", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									System.out.println("flg parmNamelist retailer in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("retailerbrand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("retailerinvoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										System.out.println("line no 2564");
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collectionRetailer") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
								
								}
							}
							// added by rupali on 05/01/18 for displaying preffered stockist field [end]
							//TODO validation
							else if(formName.equalsIgnoreCase("retailer"))
							{/*
								String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
								String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom, docFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom, docFormNo, "meet_summ", prntCtr));
									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									String teamFormNo = subFormsMap.get("team");
									String displayFormNo = subFormsMap.get("display");
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}

								}
							 */}
							
						}

					}
				}


			}
			// Added by Mrunalini Sinkar on 08-may-2017 for stockist form validation(start)
			else if("stockist".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int updateFlagCount = 0;
				int selUpdtFlagCnt = 0;

				//System.out.println("Case 3 Next: validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				ArrayList stockistVisitList = new ArrayList();
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null)
					{
						updateFlagCnt++;
						if("D".equalsIgnoreCase(updateFlag))
						{
							selUpdtFlagCnt++;
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCount++;
					}
				}
				stockistVisitList = getSelCustList(dom2, locFormNo, "stockist_visit");
				String isStockMan = checkNull(getSfaParmValue(userId,"STOCKIST_MANDATORY",connectionObject));

				//System.out.println("drVisitList :- "+drVisitList);
				//System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCount > 0 && "Y".equalsIgnoreCase(isStockMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isStockMan) || updateFlagCnt == selUpdtFlagCnt)
				{
					String stockistVisitval = "Y";
					if(stockistVisitList.contains(stockistVisitval))
					{
						errString = itmDBAccessLocal.getErrorString( "strg_code", "NOSTOCKSEL", userId );
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								{
									//System.out.println("Value of updateFlag flag is in case 3:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case 3:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}

							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//System.out.println("Inside null blank Oth_paticipant next Stockist ");
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										//System.out.println("Inside EUIN NO validation for ADDNEW In stockist");
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											//System.out.println("Inside strg code by default generated in stockist next");
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										System.out.println("euinNoDupList is:::::["+euinNoDupList+"]columnValue EUIN is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
										
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												System.out.println("Duplicate EUIN NO Stockist Next::");
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name STOACKIST::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							// added by rupali on 05/01/18 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmValue))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom2, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							// added by rupali on 05/01/18 for displaying preffered stockist field [end]
							else if(childNodeName.equalsIgnoreCase("event_time_start") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
																										
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									customerName = " for "+customerName;																		
									errString = itmDBAccessLocal.getErrorString("event_time_start","NULLVSITFR",userId);
									errString = getDescrModifiedErrorString(errString, customerName);

									break;
									
								}
							}
							else if(childNodeName.equalsIgnoreCase("member_present") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								
								String memberPresent  = checkNull(getSelectedRowValue(dom2, objContext, "member_present",prntCtr));
								scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
								custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("US00000000".equalsIgnoreCase(scCode))  
									{									
										String customerName = " for customer Unlisted Stockist";
										errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
								else
								{
									if(Integer.parseInt(memberPresent) <= 0)
									{
										if ("US00000000".equalsIgnoreCase(scCode)) 
										{
											String customerName = " for customer Unlisted Stockist";
											errString = itmDBAccessLocal.getErrorString( "member_present" , "INVMEMPRE" , userId );
											errString = getDescrModifiedErrorString(errString, customerName);

											break;
										}
									}
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									if ( "0000000000".equalsIgnoreCase( scCode ) || "UR00000000".equalsIgnoreCase( scCode ) || "US00000000".equalsIgnoreCase( scCode ) || custType.indexOf("UNLISTED")!= -1 )
									{
										String customerName = " for customer Unlisted Stockist ";									
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									
									//String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									if ( "US00000000".equalsIgnoreCase( scCode ) || custType.indexOf("UNLISTED")!= -1 )
									{
										String customerName = " for customer Unlisted Stockist";
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}																	
								}
								else
								{

									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, objContext));
									//String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									//scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
									String startVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_start",prntCtr));
									String endVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_end",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("retFlag["+retFlag+"scCode["+scCode+"]");
									System.out.println("startVisitTime stockist:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime stockist:["+endVisitTime+"]scCode["+scCode+"]");
									if (!retFlag && "US00000000".equalsIgnoreCase( scCode ))
									{
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}

								}
								
							}
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								//System.out.println("Inside strg_code Stockist Next");
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									//System.out.println("scCodeDupList is STOCKIST::::::::["+scCodeDupList+"]columnValue is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
									if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											System.out.println("Duplicate Doctor visited Visit::");
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPSTKST",userId);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}

									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									String invoiceFormNo = checkNull(getFormNo(objName, "stockistinvoice", connectionObject));
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collectionStockist", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									System.out.println("flg parmNamelist  stockist in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("stockistbrand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("stockistinvoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collectionStockist") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
								
								}
							
							}
							
						}

					}
				}

			}
			// Added by Mrunalini Sinkar on 08-may-2017 for stockist form validation(end)

			// Added by Prathmesh Jangam on 08-may-2017 for ncw form validation(start)
			else if("ncw".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int selUpdtFlagCnt = 0;
				int updateFlagCount  = 0;
				//System.out.println("Case 3 Next: validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				ArrayList ncwVisitList = new ArrayList();
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null)
					{
						updateFlagCnt++;
						if("D".equalsIgnoreCase(updateFlag))
						{
							selUpdtFlagCnt++;
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCount++;
					}
				}
				ncwVisitList = getSelCustList(dom2, locFormNo, "other_visit");
				//System.out.println("drVisitList :- "+drVisitList);
				//System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCount > 0)
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				if(selectedFlagCnt == 0  || updateFlagCnt == selUpdtFlagCnt)
				{
					String ncwVisitval = "Y";
					if(ncwVisitList.contains(ncwVisitval))
					{
						errString = itmDBAccessLocal.getErrorString( "strg_code", "NONCWVISEL", userId );
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								{
									//System.out.println("Value of updateFlag flag is in case 3:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case 3:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}

							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//System.out.println("Inside Oth_paticipant in Next NCW");
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										//System.out.println("Inside EUIN NO validation for ADDNEW next ncw");
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												System.out.println("Duplicate EUIN NO::");
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name NCW::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							
							// added by rupali on 05/01/18 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmValue))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom2, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									
									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									
                                    if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											System.out.println("Duplicate Doctor visited Visit::");
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPCUST",userId);
											errString = getDescrModifiedErrorString(errString, customerName);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}

									
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									String invoiceFormNo = checkNull(getFormNo(objName, "ncwinvoice", connectionObject));
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collectionNcw", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									System.out.println("flg parmNamelist ncw in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("ncwbrand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("ncwinvoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collectionNcw") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
								
								}
								
							}
							// added by rupali on 05/01/18 for displaying preffered stockist field [end]

						}

					}
				}

			}
			// Added by Prathmesh Jangam on 08-may-2017 for ncw form validation(end)
			/*if(errString.indexOf("<Errors>")!=-1)
			{
				if( errString.length() > 0 )
				{
					String msgDescr = "";
					//msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;
					msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + customerName ;

					if( customerName.length() != 0 && !customerName.equalsIgnoreCase("") )
					{
						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
					}
				}
			}*/
		}
		catch(Exception e)
		{
			e.printStackTrace();
			copyLogFile();//Gulzar 16/11/12
			errString = "";

			errString = genericUtility.createErrorString( e ) ;
			String messageValue="",message = "";

			if( errString.indexOf("<Errors>")!=-1 )
			{
				if( errString.length() > 0 )
				{
					String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
					messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
					String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
					message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

					StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
					valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
					valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
					valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
					valueXmlErrorString.append("<type>E</type>\r\n");
					valueXmlErrorString.append("<option></option>\r\n");
					valueXmlErrorString.append("<time></time>\r\n");
					valueXmlErrorString.append("<alarm></alarm>\r\n");
					valueXmlErrorString.append("<source></source>\r\n");
					valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
					valueXmlErrorString.append("<redirect>1</redirect>\r\n");
					valueXmlErrorString.append("</error>\r\n");
					valueXmlErrorString.append("</Errors>\r\n");
					valueXmlErrorString.append("</Header>\r\n");
					valueXmlErrorString.append( "</Root>\r\n" );
					errString =valueXmlErrorString.toString();
				}

			}
		}
		finally
		{
			try
			{
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if(actRs != null)
				{
					actRs.close();
					actRs = null;
				}
				if(actPstmt != null)
				{
					actPstmt.close();
					actPstmt = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				errString = "";

				errString = genericUtility.createErrorString( e ) ;
				//System.out.println( "errString :Dipak:" +errString + ":" );
				String messageValue="",message = "";

				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
						messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
						String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
						message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

						StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
						valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
						valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
						valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
						valueXmlErrorString.append("<type>E</type>\r\n");
						valueXmlErrorString.append("<option></option>\r\n");
						valueXmlErrorString.append("<time></time>\r\n");
						valueXmlErrorString.append("<alarm></alarm>\r\n");
						valueXmlErrorString.append("<source></source>\r\n");
						valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
						valueXmlErrorString.append("<redirect>1</redirect>\r\n");
						valueXmlErrorString.append("</error>\r\n");
						valueXmlErrorString.append("</Errors>\r\n");
						valueXmlErrorString.append("</Header>\r\n");
						valueXmlErrorString.append( "</Root>\r\n" );
						errString =valueXmlErrorString.toString();

					}
				}
			}
		}
		//ADDED BY PRACHI ON 28-FEB-2022
		if ( errString.length() <= 0)
		{
			errStringXml1.append("</Errors></Root>\r\n");
			//return errString;
			errorString2 = errStringXml1.toString();
			Document responseDom = genericUtility.parseString( errorString2 );
			Node errorsNode = responseDom.getElementsByTagName( "Errors" ).item( 0 );
			System.out.println("errNode is::"+errorsNode);
			if( errorsNode != null )
			{
				NodeList errorChildNodeList = errorsNode.getChildNodes();
				for(int appCnt = 0; appCnt < errorChildNodeList.getLength(); appCnt++)
				{
					Node currChild = errorChildNodeList.item(appCnt);
					if (currChild.getNodeName().equalsIgnoreCase("error"))
					{
						errString = errStringXml1.toString();
						break;
					}
					else
					{
						errString =  "";

					}
				}
			}
		}

		System.out.println("errString ["+errString+"]");
		return errString;
	}

	// For Done action
	public String wfValOnDone(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams,String formName) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			System.out.println("wfValOnDonexmlStringaaaaaaaa ["+xmlString+"]");
			System.out.println("wfValOnDone:xmlString1bbbbbb["+xmlString1+"]");
			System.out.println("wfValData:xmlString2cccccccc["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("wfValOnDone000is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("wfValOnDoneis1111 null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2222222222 is null");
			}
			System.out.println("Before call valdata formName:- "+formName);
			errString = wfValOnDone(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgMeetDCRWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	// For Done action
	public String wfValOnDone(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		
		String siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
		String loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String errString = "";

		int currentFormNo = 0;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		PreparedStatement pspPstmt=null;
		ResultSet pspRS=null;
		parentList = dom.getElementsByTagName("Detail"+ currentFormNo);

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		int noOfChilds = 0;
		String errString1 = "";
		String customerName = "";
		String scCode = "";
		StringBuffer errStringXml1;
		String errorString2="";
		errStringXml1 = new StringBuffer();
		errStringXml1.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		try
		{
			connectionObject = getConnection();
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			userId = getEmpCode(userId, connectionObject);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
		//	String isMemberPresent  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present

			//String itemSer = checkNull(getItemSer(userId,connectionObject));// added by hariom on 29/01/2020
			String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
			String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
			String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
			String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
			String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
			String stockistFormNo = checkNull(getFormNo(objName, "stockist", connectionObject));
			String ncwFormNo = checkNull(getFormNo(objName, "ncw", connectionObject));
			//Added by Bhagyashri T for Fortune EUIN NO[]06/01/22]
			DARCommonBean darCommonBean= new DARCommonBean();
			String isFortuneAct  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
			/*SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
			String currDate = dtFormat.format(new java.util.Date());*/
			//String parmValue = "";
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			String currDate1 =  genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			/*String sqlVisit = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='VALIDATE_NO_VISIT' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
			pstmt = connectionObject.prepareStatement(sqlVisit);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDate1));
			rSet = pstmt.executeQuery();

			if (rSet.next())
			{
				parmValue = checkNull(rSet.getString("PARM_VALUE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rSet != null)
			{
				rSet.close();
				rSet = null;
			}*/
			/*// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [start]
			String parmVal = "";
			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
			pstmt = connectionObject.prepareStatement(sfaParmSql);
			rSet = pstmt.executeQuery();
			if (rSet.next())
			{
				parmVal = checkNull(rSet.getString("PARM_VALUE"));
			}
			if(rSet != null)
			{
				rSet.close();
				rSet = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [end]
*/
			//String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);

			/*String allowEditPlace = "0",allowEditCust = "0";
			allowEditPlace = getSfaParmValue(userId,"ALLOW_EDIT_PLACE_DCR",connectionObject);
			allowEditCust = getSfaParmValue(userId,"ALLOW_EDIT_CUST_DCR",connectionObject);*/
			
			//0- Don't allow if created from real time reporting, 1-Always Allow, 2-Never allow.
			//String placeParamValue=checkNull(getSfaParmValue(userId,"NO_VISIT_SEL_VAL_REQ",connectionObject));

			String totAllwCallList ="";

			if("activity".equalsIgnoreCase(formName))
			{
		
				//parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);  //// commented and change by shweta for remark not getting proper 29-06-2021
				parentList = dom1.getElementsByTagName("Detail"+ currentFormNo);
				System.out.println("currentFormNo["+currentFormNo+"]");
				int parentNodeListLength = parentList.getLength();
				System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				String updateFlag = "";
				String CheckUpdateFlag = "";
				String selected = "";
				SimpleDateFormat date12Format = new SimpleDateFormat("hh:mm a");
			    SimpleDateFormat date24Format = new SimpleDateFormat("HH:mm");
			    //String errString = "";
				//String errString1 = "";
			//	String errString2 = "";
			    String fromVisitTime = "";
				String toVisitTime = "";
			    
			    ArrayList<String> fromTime = new ArrayList<String> ();
				ArrayList<String>  toTime = new ArrayList<String> ();
				
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";


					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
					}
					//System.out.println("Checking update flag for 3+"+updateFlag);
					if(updateFlag != null)
					{
						updateFlagCnt++;
					}
				}
				//System.out.println("selectedFlagCnt [case 2] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("activity_code","ACTNOTSEL",userId);
				}
				if(parentNodeListLength == 0 )
				{
					errString = getErrorString("activity_code","ACTNOTSEL",userId);
				}

				if(selectedFlagCnt > 0)
				{
					
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
									selected = checkNull(childNode.getAttributes().getNamedItem("selected").getNodeValue());
								}
							}
							System.out.println("Checking update flag for 2:--"+CheckUpdateFlag);
							System.out.println("Checking selected for 2:--"+selected);
							if(!"D".equalsIgnoreCase(CheckUpdateFlag))
							{

								if(childNodeName.equalsIgnoreCase("visit_time_fr"))
								{


									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || 
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))				
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_fr","NULEVENTTS",userId);
										break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("visit_time_to"))
								{

									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || 
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))				
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_to","NULEVENTED",userId);
										break;
									}

									else
									{

										boolean retFlag=true;

										String startVisitTime = checkNull(getColumnValue("visit_time_fr", dom1, objContext));
										String endVisitTime = checkNull(getColumnValue("visit_time_to", dom1, objContext));

										System.out.println("startVisitTime["+startVisitTime+"]endVisitTime["+endVisitTime+"]");
										retFlag = validateEndTime(startVisitTime , endVisitTime);
										if (!retFlag && "UN00000000".equalsIgnoreCase( scCode ))
										{
											errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
											break;
										}
									}
								}
								// added by shweta m for remakr validation on 24-01-2021 ( started)
								else if(childNodeName.equalsIgnoreCase("remark"))
								{

								//	System.out.println("inside the remark field ["+columnValue);
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || 
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))				
									{
										String acivityType="";
										String activityCode = checkNull(getColumnValue("activity_code", dom1, objContext));
										//		System.out.println("inside the activityCode field from activity form["+activityCode+"]");

										acivityType=getActivityType(activityCode,connectionObject);
										if (!acivityType.equalsIgnoreCase("FW") && !acivityType.equalsIgnoreCase("LEAVE"))
										{
											errString = itmDBAccessLocal.getErrorString("remark","NULLREMARK",userId);
											break;
										}


									}
								}
								// added by shweta m for remakr validation on 24-01-2021 ( end)



							}



						}
					}
				}
			
			}
			
			
			else if("place".equalsIgnoreCase(formName))
			{
				String localityDescr = "";
				int counter = 0;
				Hashtable hs = new Hashtable();
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				ArrayList orderVisitList = new ArrayList ();
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				String updateFlag = "";
				String CheckUpdateFlag = "";
				List selLocCodeList = new ArrayList();
				ArrayList custTypeList = getCustType(connectionObject,userId,loginCode);
				String placeParamValue=checkNull(getSfaParmValue(userId,"NO_VISIT_SEL_VAL_REQ",connectionObject));
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";


					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
					}
					//System.out.println("Checking update flag for 3+"+updateFlag);
					if(updateFlag != null)
					{
						updateFlagCnt++;
					}
				}
				//System.out.println("selectedFlagCnt [case 2] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("locality_code","LOCNOTSEL",userId);
					//break;
				}
				//vinayakkk
				if(parentNodeListLength == 0 )
				{
					errString = getErrorString("locality_code","LOCNOTSEL",userId);
					//break;
				}

				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Checking update flag for 2:--"+CheckUpdateFlag);
							if(!"D".equalsIgnoreCase(CheckUpdateFlag))
							{
								if(childNodeName.equalsIgnoreCase("locality_code"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = getErrorString("locality_code","NULLOCCD",userId);
										break;
									}
									else
									{
										String locality = childNode.getFirstChild().getNodeValue();
										//System.out.println("case 3 :: locality :: ["+locality+"]");
									}
									//System.out.println("Column Value "+ columnValue +":updateFlag:"+updateFlag);
								}
								else if(childNodeName.equalsIgnoreCase("sales_pers"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = getErrorString("sales_pers","NULSLSPRS",userId);
										break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("order_of_visit"))
								{
									//System.out.println("order_of_visit :: case3");
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = getErrorString("order_of_visit","NULORDRV",userId);
										break;
									}
									else
									{
										//System.out.println("order_of_visit :: case3 else loop");
										String OrderVisit = childNode.getFirstChild().getNodeValue();
										//System.out.println("OrderVisit :: "+OrderVisit);

										//System.out.println("orderVisitList :: "+orderVisitList);
										boolean OrderOfVisit = OrderVisit.matches("\\d+");

										if(OrderOfVisit == false)
										{
											errString = getErrorString("order_of_visit","INVAIDNUM",userId);
											break;
										}
										else if(OrderVisit.trim().length() > 3)
										{
											//System.out.println("wfValPlace ::: Order of visit length greater than three");
											errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST03",userId);
											break;
										}
										else if( ( Integer.parseInt( OrderVisit ) <= 0 ) )
										{
											//System.out.println("wfValPlace ::: Order of visit is negative/blank");
											errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST01",userId);
											break;
										}
										else
										{
											if (orderVisitList.contains(OrderVisit.trim()))
											{
												//System.out.println("Duplicate Order of Visit::");
												errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST02",userId);
												break;
											}
											else
											{
												//System.out.println("Array before adding in orderVisitList"+orderVisitList);
												orderVisitList.add(OrderVisit.trim());
											}
										}
									}
								}
							}

							ArrayList customerVisit = new ArrayList();
							//ArrayList custTypeList = getCustType(connectionObject);
							if(custTypeList.contains("D"))
							{
								String isDrVisit = getSelectedRowVal(dom2, objContext, "dr_visit",prntCtr);
								customerVisit.add(isDrVisit);

							}
							if(custTypeList.contains("C"))
							{
								String isChemVisit = getSelectedRowVal(dom2, objContext, "chem_visit",prntCtr);
								customerVisit.add(isChemVisit);
							}
							if(custTypeList.contains("S"))
							{
								String isStockVisit = getSelectedRowVal(dom2, objContext, "stockist_visit",prntCtr);
								customerVisit.add(isStockVisit);
							}
							String activityType = checkNull(getColumnValue("activity_type", dom2, mainFormNo));
							String routeType = checkNull(getSelectedRowVal(dom2, objContext, "route_type",prntCtr));
							if(!customerVisit.contains("Y") && "FW".equalsIgnoreCase(activityType) && !"H".equalsIgnoreCase(routeType) && !"M".equalsIgnoreCase(routeType) && "Y".equalsIgnoreCase(placeParamValue))
							{
								errString = itmDBAccessLocal.getErrorString("chem_visit","NOVISITSEL",userId);
								break;
							}

							//added by mrunalini sinkar on 25-june-2018 for nfw(start)
							/*if(parentNodeListLength > 1 && !"FW".equalsIgnoreCase(activityType))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","NOVISIT",userId);
								break;
							}*/
							//added by mrunalini sinkar on 25-june-2018 for nfw(end)
							/*String isDrVisit = getSelectedRowVal(dom2, objContext, "dr_visit",prntCtr);
							String isChemVisit = getSelectedRowVal(dom2, objContext, "chem_visit",prntCtr);
							String isStockVisit = getSelectedRowVal(dom2, objContext, "stockist_visit",prntCtr);// Added by Mrunalini Sinkar on 08-may-2017
							String isNCWVisit = getSelectedRowVal(dom2, objContext, "other_visit",prntCtr);*/// Added by prathmesh jangam on 08-may-2017
							/*if("N".equalsIgnoreCase(isDrVisit) && "N".equalsIgnoreCase(isChemVisit) && "N".equalsIgnoreCase(isStockVisit) && "N".equalsIgnoreCase(isNCWVisit) )
							{
								//System.out.println("::");
								errString = itmDBAccessLocal.getErrorString("chem_visit","NOVISITSEL",userId);
								break;
							}*/

						}
					}
				}
			}

			else if("doctor".equalsIgnoreCase(formName))
			{
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int numberOfVisit = 0;
				String  strgType="";//Added by kailash on 10-09-18.
				String  cusType="";//Added by kailash on 10-09-18.
				String isMemberPresent  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);

				String itemSer = checkNull(getItemSer(userId,connectionObject));
				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [start]
				String parmVal = "";
				String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
				pstmt = connectionObject.prepareStatement(sfaParmSql);
				rSet = pstmt.executeQuery();
				if (rSet.next())
				{
					parmVal = checkNull(rSet.getString("PARM_VALUE"));
				}
				if(rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [end]
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(start)
				int visit=0;
				String noOfVisit = genericUtility.getColumnValue("strg_no_visit", dom1, docFormNo);
				if(noOfVisit!=null)
				{
					numberOfVisit = Integer.parseInt(noOfVisit);
				}
				String actualVisit = genericUtility.getColumnValue("doc_visit_dates", dom1, docFormNo);
				if(actualVisit!=null)
				{
					visit = Integer.parseInt(actualVisit);
				}
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(END)
				customerName = checkNull(genericUtility.getColumnValue("cust_name", dom1, docFormNo));
				scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, docFormNo));

				if("0000000000".equalsIgnoreCase(scCode))
				{
					customerName = " for customer Unlisted Doctor";
				}
				else
				{
					customerName = " for "+customerName;
				}

				//System.out.println("Case 4 : validation ::");
				parentList = dom1.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				//System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
						/*if(parmValue.equalsIgnoreCase("Y"))
						{
							if(numberOfVisit < visit && noOfVisit!= null) //added by mrunalini sinkar
							{
								errString = itmDBAccessLocal.getErrorString("strg_no_visit","NOOFVISIT",userId);
								break;
							}
						}*/
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//Added by kailash on 10-09-18[start]
							/*cusType = checkNull(genericUtility.getColumnValue("cust_type", dom2, docFormNo));
							strgType = checkNull(genericUtility.getColumnValue("strg_type", dom2, docFormNo));*/

							cusType = checkNull(genericUtility.getColumnValueFromNode("cust_type", parentNode));
							strgType = genericUtility.getColumnValueFromNode("strg_type", parentNode);
							String routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));

							//Added by kailash on 10-09-18[end]
							
							if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[start]
								else
								{
									if("UNLISTED-DOCTOR".equalsIgnoreCase(cusType))
									{
										ArrayList locFromDom = new ArrayList();
										String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));
										locFromDom = getSelectedLocFromDom(dom2,locFormNo,connectionObject);
										if(!(locFromDom.contains(locCode)))
										{
											errString = itmDBAccessLocal.getErrorString( "locality_code" , "INVLOCSELD" , userId );
											break;
										}
									}
								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[end]
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//System.out.println("Inside Oth_paticipant Done Doctor ");
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom1, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom1, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							else if(childNodeName.equalsIgnoreCase("strg_code"))
							{
								System.out.println("Inside doctor wfval on done strg_code::"+cusType);
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									errString = itmDBAccessLocal.getErrorString("strg_code","BLNKSCCODE",userId);
									break;
								}
								else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									if(cusType.contains("UNLISTED-") && "Y".equalsIgnoreCase(isFortuneAct) )
									{
										System.out.println("Inside dotcor  unlist on Done :"+cusType);
										int cnt=0;
										String uniqStrgcd = checkNull(genericUtility.getColumnValue("uniq_strg_code", dom1, objContext));
										String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
										String strgtype = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										System.out.println("Inside dotcor  unlist uniqStrgcd Done:"+uniqStrgcd);
										System.out.println("Inside dotcor  unlist strgCode done:"+strgCode);
										System.out.println("Inside dotcor  unlist strgtype Done:"+strgtype);
										String sql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE TRIM(SC_CODE)=TRIM(?) AND STATUS='U' AND TRIM(CUST_TYPE)=TRIM(?)";
										PreparedStatement strgcode=connectionObject.prepareStatement(sql);
										strgcode.setString(1, strgCode);
										strgcode.setString(2, strgtype);
										ResultSet strgCdRs=strgcode.executeQuery();
										if(strgCdRs.next())
										{
											cnt=strgCdRs.getInt("COUNT");
										}
										if (strgCdRs != null)
										{
											strgCdRs.close();
											strgCdRs = null;
										}
										if (strgcode != null)
										{
											strgcode.close();
											strgcode = null;
										}
										if(cnt == 0)
										{
											System.out.println("Inside STRG_code on done");
											if(!(uniqStrgcd.equalsIgnoreCase(strgCode)))
											{
												System.out.println("Inside STRG_code done inside");
												errString = itmDBAccessLocal.getErrorString("strg_code","INVALSTDC",userId);
												break;
											}
										}
									}
									
								}
								
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							// added by rupali on 06/11/17 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmVal))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom1, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									String sprsActCode = checkNull(genericUtility.getColumnValue("sprs_act_code", dom1, objContext));
									if(sprsActCode!=null && sprsActCode.trim().length()>0)
									{
										String eventType = checkNull(genericUtility.getColumnValue("event_type", dom1, objContext));
										int actCnt=0;
										String sql="SELECT COUNT(*) AS COUNT FROM FIELDACTIVITY FA WHERE FA.STATUS = 'Y' " + 
												"AND FA.ACTIVITY_TYPE NOT IN ('PR') AND FA.ACTIVITY_CODE NOT IN ('JW') AND FA.ACTIVITY_CODE IN ("+sprsActCode+") AND FA.ACTIVITY_TYPE='FW' AND FA.ACTIVITY_CODE=? " + 
												"AND (FA.ITEM_SER='ALL' OR (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?) IN(SELECT regexp_substr( ITEM_SER,'[^,]+', 1, LEVEL) FROM " + 
												"DUAL CONNECT BY regexp_substr(ITEM_SER, '[^,]+', 1, LEVEL) IS NOT NULL ) ) " + 
												"ORDER BY FA.DESCR,FA.ACTIVITY_CODE";
										
										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, eventType);
										pstmt.setString(2, userId);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											actCnt = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(actCnt == 0)
										{
											errString = itmDBAccessLocal.getErrorString("event_type", "ACTNOTFND", userId);
											break;
										}
										
									}
									

								}
							}
							// added by rupali on 06/11/17 for displaying preffered stockist field [end]
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [start]
							else if(childNodeName.equalsIgnoreCase("event_time_start"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									/*if ("0000000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLVSITFR",userId);
										break;
									}*/
									/*else
									{
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
										break;
									}*/
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("0000000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										break;
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLEVNTFR",userId);
										break;
									}
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									/*if ("0000000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										break;
									}*/
									/*else
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLEVNTTO",userId);
										break;
									}*/
								}
								else
								{
									boolean retFlag=true;
									String startVisitTime = checkNull(genericUtility.getColumnValue("event_time_start", dom1, objContext));
									String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("startVisitTime doctor:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime doctor:["+endVisitTime+"]scCode["+scCode+"]");
									if (!retFlag && "0000000000".equalsIgnoreCase( scCode ))
									{
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}
								}
							}
							
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [end]
							//Added by kailash on 10-09-18 for unlisted dorctor changes[start]
							//else if("UNLISTED-DOCTOR".equalsIgnoreCase(cusType) && !"Y".equalsIgnoreCase(isMemberPresent) && !"M".equalsIgnoreCase(routeType))
							else if(cusType.contains("UNLISTED-") && !"Y".equalsIgnoreCase(isMemberPresent) && !"M".equalsIgnoreCase(routeType))
							{
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [Start]
								//String totAllwCallList ="";
								String maxStrgCustomr="";
								WSFACommon wsfaCommon=new WSFACommon();
								HashMap<String,String> totCustList=  new HashMap<String, String>();
								totCustList =wsfaCommon.getVisitData(userId, itemSer, connectionObject);
								for(Map.Entry<String, String> m:totCustList.entrySet())
								{
									maxStrgCustomr =(String)m.getKey();
								}
								if(maxStrgCustomr != null && maxStrgCustomr.trim().length() != 0)
								{
									totAllwCallList = maxStrgCustomr;
								}
								else
								{
									totAllwCallList = checkNull(getSfaParmValue(userId, "TOT_ALLOW_CALL_LIST", connectionObject));
								}
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [End]
								if(!"".equalsIgnoreCase(totAllwCallList) && ("UNLISTED-RETAILER".equalsIgnoreCase(cusType) || "UNLISTED-WHOLESALER".equalsIgnoreCase(cusType)))
								{
									int listCnt = 0;
									int totAllwCallListCnt = Integer.parseInt(totAllwCallList);
									String sqlCount = "SELECT "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SALES_PERS = ? AND SC.CUST_TYPE IN ('C','W') AND SS.STATUS = 'Y') "+
													  "+ "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND WF_STATUS NOT IN ('A','R') AND STRG_TYPE IN ('C','W')) AS COUNT FROM DUAL ";
									pstmt = connectionObject.prepareStatement(sqlCount);
									pstmt.setString(1, userId);
									pstmt.setString(2, userId);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										listCnt = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(listCnt >= totAllwCallListCnt)
									{
										errString = itmDBAccessLocal.getErrorString("cust_type", "UNLSTNTALW", userId);
										break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("address_as"))
								{
									scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
									String locality = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));

									if(scCode != null && scCode.trim().length() > 0 && locality != null && locality.trim().length() > 0)
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString( "address_as" , "NULLADDAS" , userId );
											break;
										}
									}

								}
								else if(childNodeName.equalsIgnoreCase("strg_name"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "strg_name" , "BLANKCUST" , userId );
										break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("gender"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										/*errString = itmDBAccessLocal.getErrorString( "gender" , "NULLGENDR" , userId );
										break;*/
									}
								}
								else if( "email_addr".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null email_addr
										//removed comment on 24/01/19 for applying validation on mobile number for chc
										/*System.out.println( "email_addr cannot be null:" );
										errString = itmDBAccessLocal.getErrorString( "email_addr" , "NULEMAILID" , userId );
										break;*/
									}
									else
									{
										String emailAddr = checkNull(genericUtility.getColumnValue("email_addr", dom1, objContext));
										boolean isEmail = true;
										String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
										if(emailAddr != null )
										{
											isEmail = emailAddr.matches(ePattern);
											if(!(isEmail))
											{
												errString = itmDBAccessLocal.getErrorString("email_addr","INVDEMAILD",userId);
												break;
											}
										}
									}
								}
								else if ( "mobile_no".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
										//removed comment on 24/01/19 for applying validation on mobile number for chc
										errString = itmDBAccessLocal.getErrorString( "mobile_no" , "NULPHONNO" , userId );
										break;
									}
									else
									{
										String custCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
										String phoneNo = checkNull(genericUtility.getColumnValue("mobile_no", dom1, objContext));
										phoneNo = (phoneNo == null) ?"":phoneNo.trim();
										if(phoneNo == null || phoneNo.trim().length() <= 0)
										{
											//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
											//removed comment on 24/01/19 for applying validation on mobile number for chc
											errString = itmDBAccessLocal.getErrorString( "mobile_no","NULPHONENO",userId );
											break;
										}
										else if(phoneNo.length() < 10 || phoneNo.length() > 10 || phoneNo.startsWith("0"))
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","INVDPHNLNO",userId);
											break;
										}
										
										int custAddCnt=0;
										String custAddsql="SELECT COUNT(*) AS CNT FROM STRG_CUST_ADD WHERE MOBILE_NO = ? AND STRG_CODE<>? AND WF_STATUS='P'";
										PreparedStatement custPstmt=connectionObject.prepareStatement(custAddsql);
										custPstmt.setString(1,phoneNo);
										custPstmt.setString(2,custCode);
										ResultSet custRS=custPstmt.executeQuery();
										if(custRS.next())
										{
											custAddCnt=custRS.getInt("CNT");
										}
										if (custRS != null)
										{
											custRS.close();
											custRS = null;
										}
										if (custPstmt != null)
										{
											custPstmt.close();
											custPstmt = null;
										}
										if(custAddCnt>0)
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCSNT",userId);
											break;
										}
										else
										{
											int customerCnt=0;
											String customersql="SELECT COUNT(*) AS CNT FROM STRG_CUSTOMER WHERE MOBILE_NO = ? AND SC_CODE<>?";
											custPstmt=connectionObject.prepareStatement(customersql);
											custPstmt.setString(1,phoneNo);
											custPstmt.setString(2,custCode);
											custRS=custPstmt.executeQuery();
											if(custRS.next())
											{
												customerCnt=custRS.getInt("CNT");
											}
											if (custRS != null)
											{
												custRS.close();
												custRS = null;
											}
											if (custPstmt != null)
											{
												custPstmt.close();
												custPstmt = null;
											}
											if(customerCnt>0)
											{
												errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCNT",userId);
												break;
											}
										}
									}
								}
								else if(childNodeName.equalsIgnoreCase("strg_class_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
										break;
									}
									else
									{
										// added by mrunalini sinkar on 31-jan-2019 for class code validation(start)
										int count = 0;
										String codeSql = "";
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										//String itemSer = checkNull(getItemSer(userId,connectionObject));		// commended by hariom and added inside method

										int classCount = getCountFromSerClass(itemSer,classCode,connectionObject); // added by mrunalini sinkar for class code pophelp on 31-jan-2019(start)
										if(classCount==0)
										{
											codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
											pstmt = connectionObject.prepareStatement(codeSql);
											pstmt.setString(1,custType);
											pstmt.setString(2,classCode);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
												break;
											}
										}
										/*int count = 0;
										String codeSql = "";
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										System.out.println("classCode>>["+classCode+"]custType["+custType+"]");
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
											break;
										}*/
										// added by mrunalini sinkar on 31-jan-2019 for class code validation(end)

									}
								}
								else if(childNodeName.equalsIgnoreCase("spl_code") && "D".equalsIgnoreCase(strgType) )
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										if( !"M".equalsIgnoreCase(routeType))
										{
											errString = itmDBAccessLocal.getErrorString( "spl_code" , "NULLSPL" , userId );
											break;
										}

									}
									else
									{
										columnValue = childNode.getFirstChild().getNodeValue().trim();
										if( columnValue != null )
										{
											String splCodeSql = "";
											int count = 0;
											splCodeSql = "SELECT COUNT(*) AS COUNT FROM SPECIALITY WHERE SPL_CODE = ?";
											pstmt = connectionObject.prepareStatement(splCodeSql);
											pstmt.setString(1, columnValue);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVSPLCODE",userId);
												break;
											}
										}
									}
								}
								// added by kailash on 24/01/19 for applying validation on subclass [start]
								else if(childNodeName.equalsIgnoreCase("subclass_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										/*errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
										break;*/
									}
									else
									{
										int count = 0;
										String codeSql = "";
										String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code", dom1, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_SUBCLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ? AND SUBCLASS_CODE = ? ";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										pstmt.setString(3,subClassCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString("subclass_code","INVSUBCLS",userId);
											break;
										}
									}
								}
								// added by kailash on 24/01/19  for applying validation on subclass [end]
							}
							/*else if("Y".equalsIgnoreCase(isMemberPresent) && "UNLISTED-DOCTOR".equalsIgnoreCase(cusType))
							{
								if(childNodeName.equalsIgnoreCase("member_present"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "member_present" , "VTDOCTNO2" , userId );
										break;
									}
									else
									{
										String memberPresent = checkNull(genericUtility.getColumnValue("member_present", dom1, objContext));
										int noOfChem =Integer.parseInt(memberPresent);
										if (noOfChem <= 0)
										{
											errString = itmDBAccessLocal.getErrorString( "noof_chemist" , "VTDOCTNO1" , userId );
											break;
										}
									}
								}
							}*/

							//Added by kailash on 10-09-18 for unlisted dorctor changes[end]
							else if (childNodeName.equalsIgnoreCase("next_plan_date"))//Added by mrunalini sinkar for next_plan_date validaiton
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
									java.util.Date nextPlanDate = null;
									java.util.Date eventDate = null;

									String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom1,objContext ));

									try
									{
										nextPlanDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
										eventDate = sdfFormat.parse( workDate);

									}
									catch ( Exception e )
									{
										errString = itmDBAccessLocal.getErrorString( "next_plan_date", "INVDTFRMT", userId );
										break;
									}

									String planDat=childNode.getFirstChild().getNodeValue();
									if (!sdfFormat.format(nextPlanDate).equals(planDat))
									{
										errString = itmDBAccessLocal.getErrorString( "next_plan_date", "INVDTFRMT", userId );
										break;
									}

									if  ( nextPlanDate.compareTo(eventDate) <= 0)
									{

										errString = itmDBAccessLocal.getErrorString( "next_plan_date", "INVPLDATE", userId );
										break;
									}
								}
							}
														//Added by mrunalini sinkar for fortune changes (sart)
							else if (childNodeName.equalsIgnoreCase("meeting_status"))//Added by mrunalini sinkar for fortune changes (sart)
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									int cnt=0;
									String callOutCome = checkNull(getSelectedRowVal(dom1, docFormNo, "meeting_status", prntCtr));
									String sprsActCode = checkNull(getSelectedRowVal(dom1, docFormNo, "event_type", prntCtr));


									columnValue = childNode.getFirstChild().getNodeValue().trim();
									System.out.println("columnValue of meeting status["+columnValue+"]");
									String sql="SELECT COUNT(*) AS COUNT FROM CALL_OUTCOME WHERE TRIM(UPPER(CALL_OUTCOME_DESCR))=? AND ACTIVITY_CODE=? ";
									PreparedStatement meetingPstmt=connectionObject.prepareStatement(sql);
									meetingPstmt.setString(1, callOutCome.toUpperCase());
									meetingPstmt.setString(2, sprsActCode);

									ResultSet meetingRS=meetingPstmt.executeQuery();
									if(meetingRS.next())
									{
										cnt=meetingRS.getInt("COUNT");
									}
									if (meetingRS != null)
									{
										meetingRS.close();
										meetingRS = null;
									}
									if (meetingPstmt != null)
									{
										meetingPstmt.close();
										meetingPstmt = null;
									}
									if(cnt == 0)
									{
										errString = itmDBAccessLocal.getErrorString("meeting_status","IVMETSTAS",userId);
										break;
									}
								}
							}
							
							//Added by mrunalini sinkar for fortune changes (End)
							
							else if(formName.equalsIgnoreCase("doctor"))
							{
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									String callOutCome = checkNull(getSelectedRowVal(dom1, docFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom1, docFormNo, "meet_summ", prntCtr));
									String strgCode = checkNull(getSelectedRowVal(dom1, docFormNo, "strg_code", prntCtr));

									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									//System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									String teamFormNo = subFormsMap.get("team");
									String displayFormNo = subFormsMap.get("display");
									String brandFormNo = subFormsMap.get("brand");
									String sampleOrderFormNo= subFormsMap.get("sampleorder");
									boolean isSampleOrderEmpty = isDeSelEmptyDOM(dom2, ""+sampleOrderFormNo,strgCode);
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo,strgCode);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo,strgCode);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo,strgCode);
									boolean isbrandEmpty = isDeSelEmptyDOM(dom2, ""+brandFormNo,strgCode);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty || !isbrandEmpty || !isSampleOrderEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}
								}
							}
							/*0307
							System.out.println("before mandatory validation");
							if(errString==null || errString.trim().length()==0)
				            {
				            	   System.out.println("line 5924");
				            	   objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				            	   String win_name = "w_"+objName;
				            	   String invoiceFormNo = darCommonBean.getFormNo(connectionObject, win_name,"invoice");
				            	   errString = darCommonBean.darCollectionPosSave(dom2, connectionObject,invoiceFormNo, "invoice", userId);
				            	   if(errString!=null || errString.trim().length()>0)
				            	   {
				            		   break;
					               }
				            	   else if(errString==null || errString.trim().length()==0)
				            	   {
				            		   String collectionFormNo = darCommonBean.getFormNo(connectionObject, win_name,"collection");
					            	   errString = darCommonBean.darCollectionPosSave(dom2, connectionObject,invoiceFormNo, "collection", userId);
					            	   System.out.println("line 5939 errString:"+errString);
					            	   if(errString!=null || errString.trim().length()>0)
					            	   {
					            		   break;
						               }
				            	   }
				            }
							*/
							//else if(childNodeName.equalsIgnoreCase("strg_code"))
							//{
								/*String isDrVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom2, "3"));
								System.out.println("dr_visit dfs:- "+isDrVisit+"::columnValue:"+columnValue);
								if("Y".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() <= 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NODOCVISEL", userId );
									break;
								}
								else if("N".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELDOCT", userId );
									break;
								}*/
							//}

						}

					}
				}
			}

			else if("retailer".equalsIgnoreCase(formName))
			{
				System.out.println("Inside WFVal on done Retailer");
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int numberOfVisit=0;
				String  strgType="";//Added by kailash on 10-09-18.
				String  cusType="";//Added by kailash on 10-09-18.
				String isMemberPresent  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);

				String itemSer = checkNull(getItemSer(userId,connectionObject));
				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [start]
				String parmVal = "";
				String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
				pstmt = connectionObject.prepareStatement(sfaParmSql);
				rSet = pstmt.executeQuery();
				if (rSet.next())
				{
					parmVal = checkNull(rSet.getString("PARM_VALUE"));
				}
				if(rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [end]
				
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(start)
				int visit=0;
				String noOfVisit = genericUtility.getColumnValue("strg_no_visit", dom1, retailFormNo);
				if(noOfVisit!=null)
				{
					numberOfVisit = Integer.parseInt(noOfVisit);
				}
				String actualVisit = genericUtility.getColumnValue("doc_visit_dates", dom1, retailFormNo);
				if(actualVisit!=null)
				{
					visit = Integer.parseInt(actualVisit);
				}
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(end)
				customerName = checkNull(genericUtility.getColumnValue("cust_name", dom1, retailFormNo));
				scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, retailFormNo));

				if("UR00000000".equalsIgnoreCase(scCode))
				{
					//customerName = " for customer No of Chemists";
					customerName = "";
				}
				else
				{
					customerName = " for "+customerName;
				}

				NodeList custParentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int custParentNodeListLength = custParentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				int selCallList = 0;
				for (int prntCtr = 0; prntCtr < custParentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = custParentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = custParentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue());
						}
						childNodeName = childNode.getNodeName();

						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}

						if(childNodeName.equalsIgnoreCase("cust_type") && selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag) && updateFlag != null)
						{
							if("UNLISTED-RETAILER".equalsIgnoreCase(columnValue) || "UNLISTED-WHOLESALER".equalsIgnoreCase(columnValue))
							{
								if("A".equalsIgnoreCase(updateFlag))
								{
									selCallList++;
								}
								else if("D".equalsIgnoreCase(updateFlag))
								{
									selCallList--;
								}
							}
						}
					}
				}

				//System.out.println("Case 4 : validation ::");
				parentList = dom1.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				/*if(selectedFlagCnt == 0 )
				{
					String isDrVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom2, "3"));
					if("Y".equalsIgnoreCase(isDrVisit))
					{
						errString = itmDBAccessLocal.getErrorString( "strg_code", "NODOCVISEL", userId );
						break;
					}
				}*/

				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
						/*if(parmValue.equalsIgnoreCase("Y"))
						{
							if(numberOfVisit < visit && noOfVisit!= null) //added by mrunalini sinkar
							{
								errString = itmDBAccessLocal.getErrorString("strg_no_visit","NOOFVISIT",userId);
								break;
							}
						}*/
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//Added by kailash on 10-09-18[start]
							//cusType = checkNull(genericUtility.getColumnValue("cust_type", dom2, retailFormNo));
							cusType = checkNull(genericUtility.getColumnValueFromNode("cust_type", parentNode));
							System.out.println("cusType ==="+cusType);
							String routeType="";
							routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));
							System.out.println("routeType ==="+routeType);
							//Added by kailash on 10-09-18[end]
							
							 if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[start]
								else
								{
									if("UNLISTED-RETAILER".equalsIgnoreCase(cusType))
									{
										ArrayList locFromDom = new ArrayList();
										String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));
										locFromDom = getSelectedLocFromDom(dom2,locFormNo,connectionObject);
										if(!(locFromDom.contains(locCode)))
										{
											errString = itmDBAccessLocal.getErrorString( "locality_code" , "INVLOCSELD" , userId );
											break;
										}
									}
								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[end]
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom1, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom1, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							else if(childNodeName.equalsIgnoreCase("strg_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									errString = itmDBAccessLocal.getErrorString("strg_code","BLNKSCCODE",userId);
									break;
								}
								else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									if(cusType.contains("UNLISTED-") && "Y".equalsIgnoreCase(isFortuneAct))
									{
										int cnt=0;
										String uniqStrgcd = checkNull(genericUtility.getColumnValue("uniq_strg_code", dom1, objContext));
										String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
										String strgtype = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										String sql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE TRIM(SC_CODE)=TRIM(?) AND STATUS='U' AND TRIM(CUST_TYPE)=TRIM(?)";
										PreparedStatement strgcode=connectionObject.prepareStatement(sql);
										strgcode.setString(1, strgCode);
										strgcode.setString(2, strgtype);
										ResultSet strgCdRs=strgcode.executeQuery();
										if(strgCdRs.next())
										{
											cnt=strgCdRs.getInt("COUNT");
										}
										if (strgCdRs != null)
										{
											strgCdRs.close();
											strgCdRs = null;
										}
										if (strgcode != null)
										{
											strgcode.close();
											strgcode = null;
										}
										if(cnt == 0)
										{
											if(!(uniqStrgcd.equalsIgnoreCase(strgCode)))
											{
												errString = itmDBAccessLocal.getErrorString("strg_code","INVALSTDC",userId);
												break;
											}
										}
									}
									
								}
								
							}
							 //Added by bhagyashir EUIN NO[19/01/22]
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									String sprsActCode = checkNull(genericUtility.getColumnValue("sprs_act_code", dom1, objContext));
									if(sprsActCode!=null && sprsActCode.trim().length()>0)
									{
										String eventType = checkNull(genericUtility.getColumnValue("event_type", dom1, objContext));
										int actCnt=0;
										String sql="SELECT COUNT(*) AS COUNT FROM FIELDACTIVITY FA WHERE FA.STATUS = 'Y' " + 
												"AND FA.ACTIVITY_TYPE NOT IN ('PR') AND FA.ACTIVITY_CODE NOT IN ('JW') AND FA.ACTIVITY_CODE IN ("+sprsActCode+") AND FA.ACTIVITY_TYPE='FW' AND FA.ACTIVITY_CODE=? " + 
												"AND (FA.ITEM_SER='ALL' OR (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?) IN(SELECT regexp_substr( ITEM_SER,'[^,]+', 1, LEVEL) FROM " + 
												"DUAL CONNECT BY regexp_substr(ITEM_SER, '[^,]+', 1, LEVEL) IS NOT NULL ) ) " + 
												"ORDER BY FA.DESCR,FA.ACTIVITY_CODE";
										
										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, eventType);
										pstmt.setString(2, userId);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											actCnt = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(actCnt == 0)
										{
											errString = itmDBAccessLocal.getErrorString("event_type", "ACTNOTFND", userId);
											break;
										}
										
									}

								}
							}
							else if (childNodeName.equalsIgnoreCase("next_plan_date"))//Added by mrunalini sinkar for next_plan_date validaiton
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
									java.util.Date nextPlanDate = null;
									java.util.Date eventDate = null;

									String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom1,objContext ));


									try
									{
										nextPlanDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
										eventDate = sdfFormat.parse( workDate);

									}
									catch ( Exception e )
									{
										errString = itmDBAccessLocal.getErrorString( "next_plan_date", "INVDTFRMT", userId );
										break;
									}

									String planDat=childNode.getFirstChild().getNodeValue();
									if (!sdfFormat.format(nextPlanDate).equals(planDat))
									{
										errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
										break;
									}

									if  ( nextPlanDate.compareTo(eventDate) <= 0)
									{

										errString = itmDBAccessLocal.getErrorString( "event_date", "INVPLDATE", userId );
										break;
									}
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("call_outcome"))
							{
								System.out.println("inside Calloutcome7");
								String callOutCome = checkNull(getSelectedRowVal(dom, retailFormNo, "call_outcome", prntCtr));
								String meetSumm = checkNull(getSelectedRowVal(dom, retailFormNo, "meet_summ", prntCtr));
								if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
								{
									errString = itmDBAccessLocal.getErrorString("call_outcome","DELCALNOTE",userId);
									break;
								}
							}*/
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [start]
							/*else if(childNodeName.equalsIgnoreCase("event_time_start"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("UR00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLVSTFRC",userId);
										break;
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("visit_time_from"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("UR00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSTFRC",userId);
										break;
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLEVNTFR",userId);
										break;
									}
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									/*if ("UR00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSTTOC",userId);
										break;
									}*/
									/*else
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLEVNTTO",userId);
										break;
									}*/
								}
								else
								{

									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, objContext));
									//String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									String startVisitTime = checkNull(genericUtility.getColumnValue("event_time_start", dom1, objContext));
									String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("retFlag["+retFlag+"scCode["+scCode+"]");
									System.out.println("startVisitTime retailer:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime retailer:["+endVisitTime+"]scCode["+scCode+"]");
									if (!retFlag && "UR00000000".equalsIgnoreCase( scCode ))
									{
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}

								}
							}
							
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [end]
							//Added by kailash on 10-09-18 for unlisted dorctor changes[start]
							else if(cusType.contains("UNLISTED-") && !"Y".equalsIgnoreCase(isMemberPresent) && !"M".equalsIgnoreCase(routeType))
							//else if("UNLISTED-RETAILER".equalsIgnoreCase(cusType) && !"Y".equalsIgnoreCase(isMemberPresent) && !"M".equalsIgnoreCase(routeType))
							{
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [Start]
								//String totAllwCallList ="";
								String maxStrgCustomr="";
								WSFACommon wsfaCommon=new WSFACommon();
								HashMap<String,String> totCustList=  new HashMap<String, String>();
								totCustList =wsfaCommon.getVisitData(userId, itemSer, connectionObject);
								for(Map.Entry<String, String> m:totCustList.entrySet())
								{
									maxStrgCustomr =(String)m.getKey();
								}
								if(maxStrgCustomr != null && maxStrgCustomr.trim().length() != 0)
								{
									totAllwCallList = maxStrgCustomr;
								}
								else
								{
								 totAllwCallList = checkNull(getSfaParmValue(userId, "TOT_ALLOW_CALL_LIST", connectionObject));
								}
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [End]
								if(!"".equalsIgnoreCase(totAllwCallList) && ("UNLISTED-RETAILER".equalsIgnoreCase(cusType) || "UNLISTED-WHOLESALER".equalsIgnoreCase(cusType)))
								{
									int listCnt = 0;
									int totAllwCallListCnt = Integer.parseInt(totAllwCallList);
									String sqlCount = "SELECT "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SALES_PERS = ? AND SC.CUST_TYPE IN ('C','W') AND SS.STATUS = 'Y') "+
													  "+ "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND WF_STATUS NOT IN ('A','R') AND STRG_TYPE IN ('C','W')) AS COUNT FROM DUAL ";
									pstmt = connectionObject.prepareStatement(sqlCount);
									pstmt.setString(1, userId);
									pstmt.setString(2, userId);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										listCnt = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									listCnt = listCnt + selCallList;
									if(listCnt > totAllwCallListCnt)
									{
										errString = itmDBAccessLocal.getErrorString("cust_type", "UNLSTNTALW", userId);
										break;
									}
								}
								if(childNodeName.equalsIgnoreCase("address_as"))
								{
									scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
									String locality = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));
									if(scCode != null && scCode.trim().length() > 0 && locality != null && locality.trim().length() > 0)
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString( "address_as" , "NULLADDAS" , userId );
											break;
										}
									}

								}
								else if(childNodeName.equalsIgnoreCase("strg_name"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "strg_name" , "BLANKCUST" , userId );
										break;
									}
								}

								else if(childNodeName.equalsIgnoreCase("gender"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										/*errString = itmDBAccessLocal.getErrorString( "gender" , "NULLGENDR" , userId );
										break;*/
									}
								}
								else if( "email_addr".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null email_addr
										//removed comment on 16/01/19 for applying validation on mobile number for chc
										/*System.out.println( "email_addr cannot be null:" );
										errString = itmDBAccessLocal.getErrorString( "email_addr" , "NULEMAILID" , userId );
										break;*/
									}
									else
									{
										String emailAddr = checkNull(genericUtility.getColumnValue("email_addr", dom1, objContext));
										boolean isEmail = true;
										String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
										if(emailAddr != null )
										{
											isEmail = emailAddr.matches(ePattern);
											if(!(isEmail))
											{
												errString = itmDBAccessLocal.getErrorString("email_addr","INVDEMAILD",userId);
												break;
											}
										}
									}
								}
								else if ( "mobile_no".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
										//removed comment on 16/01/19 for applying validation on mobile number for chc
										errString = itmDBAccessLocal.getErrorString( "mobile_no" , "NULPHONNO" , userId );
										break;
									}
									else
									{
										String custCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));

										String phoneNo = checkNull(genericUtility.getColumnValue("mobile_no", dom1, objContext));
										phoneNo = (phoneNo == null) ?"":phoneNo.trim();
										if(phoneNo == null || phoneNo.trim().length() <= 0)
										{
											//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
											//removed comment on 16/01/19 for applying validation on mobile number for chc
											errString = itmDBAccessLocal.getErrorString( "mobile_no","NULPHONENO",userId );
											break;
										}
										else if(phoneNo.length() < 10 || phoneNo.length() > 10 || phoneNo.startsWith("0"))
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","INVDPHNLNO",userId);
											break;
										}
										
										int custAddCnt=0;
										String custAddsql="SELECT COUNT(*) AS CNT FROM STRG_CUST_ADD WHERE MOBILE_NO = ? AND STRG_CODE<>? AND WF_STATUS='P'";
										PreparedStatement custPstmt=connectionObject.prepareStatement(custAddsql);
										custPstmt.setString(1,phoneNo);
										custPstmt.setString(2,custCode);
										ResultSet custRS=custPstmt.executeQuery();
										if(custRS.next())
										{
											custAddCnt=custRS.getInt("CNT");
										}
										if (custRS != null)
										{
											custRS.close();
											custRS = null;
										}
										if (custPstmt != null)
										{
											custPstmt.close();
											custPstmt = null;
										}
										if(custAddCnt>0)
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCSNT",userId);
											break;
										}
										else
										{
											int customerCnt=0;
											String customersql="SELECT COUNT(*) AS CNT FROM STRG_CUSTOMER WHERE MOBILE_NO = ? AND SC_CODE<>?";
											custPstmt=connectionObject.prepareStatement(customersql);
											custPstmt.setString(1,phoneNo);
											custPstmt.setString(2,custCode);
											custRS=custPstmt.executeQuery();
											if(custRS.next())
											{
												customerCnt=custRS.getInt("CNT");
											}
											if (custRS != null)
											{
												custRS.close();
												custRS = null;
											}
											if (custPstmt != null)
											{
												custPstmt.close();
												custPstmt = null;
											}
											if(customerCnt>0)
											{
												errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCNT",userId);
												break;
											}
										}
										
										

									}
								}
								else if(childNodeName.equalsIgnoreCase("strg_class_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
										break;
									}
									else
									{

										// added by mrunalini sinkar on 31-jan-2019 for class code validation(start)
										int count = 0;
										String codeSql = "";
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										//String itemSer = checkNull(getItemSer(userId,connectionObject)); // commended by hariom and added inside method

										int classCount = getCountFromSerClass(itemSer,classCode,connectionObject); // added by mrunalini sinkar for class code pophelp on 31-jan-2019(start)
										if(classCount==0)
										{
											codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
											pstmt = connectionObject.prepareStatement(codeSql);
											pstmt.setString(1,custType);
											pstmt.setString(2,classCode);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
												break;
											}
										}
										/*int count = 0;
										String codeSql = "";
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										System.out.println("classCode>>["+classCode+"]custType["+custType+"]");
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
											break;
										}*/
										// added by mrunalini sinkar on 31-jan-2019 for class code validation(end)

									}
								}
								else if(childNodeName.equalsIgnoreCase("spl_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{

									}
									else
									{
										columnValue = childNode.getFirstChild().getNodeValue().trim();
										if( columnValue != null )
										{
											String splCodeSql = "";
											int count = 0;
											splCodeSql = "SELECT COUNT(*) AS COUNT FROM SPECIALITY WHERE SPL_CODE = ?";
											pstmt = connectionObject.prepareStatement(splCodeSql);
											pstmt.setString(1, columnValue);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVSPLCODE",userId);
												break;
											}
										}
									}
								}
								// added by kailash on 24/01/19 for applying validation on subclass [start]
								else if(childNodeName.equalsIgnoreCase("subclass_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										/*errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
										break;*/
									}
									else
									{
										int count = 0;
										String codeSql = "";
										String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code", dom1, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_SUBCLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ? AND SUBCLASS_CODE = ? ";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										pstmt.setString(3,subClassCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString("subclass_code","INVSUBCLS",userId);
											break;
										}
									}
								}
								// added by kailash on 24/01/19  for applying validation on subclass [end]
							}
							/*else if("Y".equalsIgnoreCase(isMemberPresent) && "UNLISTED-CHEMIST".equalsIgnoreCase(cusType))//Added by mrunalini sinkar for member presnt
							{
								if(childNodeName.equalsIgnoreCase("member_present"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "member_present" , "VTCHMNO2" , userId );
										break;
									}
									else
									{
										String memberPresent = checkNull(genericUtility.getColumnValue("member_present", dom1, objContext));
										int noOfChem =Integer.parseInt(memberPresent);
										if (noOfChem <= 0)
										{
											errString = itmDBAccessLocal.getErrorString( "noof_chemist" , "VTCHMNO1" , userId );
											break;
										}
									}
								}
							}*/
							//Added by kailash on 10-09-18 for unlisted doctor changes[end]
							// added by rupali on 05/01/18 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmVal))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom1, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							// added by rupali on 05/01/18 for displaying preffered stockist field [end]
														//Added by mrunalini sinkar for fortune changes (sart)
							else if (childNodeName.equalsIgnoreCase("meeting_status"))//Added by mrunalini sinkar for fortune changes (sart)
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									int cnt=0;
									String callOutCome = checkNull(getSelectedRowVal(dom1, retailFormNo, "meeting_status", prntCtr));
									String sprsActCode = checkNull(getSelectedRowVal(dom1, retailFormNo, "event_type", prntCtr));


									columnValue = childNode.getFirstChild().getNodeValue().trim();
									System.out.println("columnValue of meeting status["+columnValue+"]");
									String sql="SELECT COUNT(*) AS COUNT FROM CALL_OUTCOME WHERE TRIM(UPPER(CALL_OUTCOME_DESCR))=? AND ACTIVITY_CODE=? ";
									PreparedStatement meetingPstmt=connectionObject.prepareStatement(sql);
									meetingPstmt.setString(1, callOutCome.toUpperCase());
									meetingPstmt.setString(2, sprsActCode);

									ResultSet meetingRS=meetingPstmt.executeQuery();
									if(meetingRS.next())
									{
										cnt=meetingRS.getInt("COUNT");
									}
									if (meetingRS != null)
									{
										meetingRS.close();
										meetingRS = null;
									}
									if (meetingPstmt != null)
									{
										meetingPstmt.close();
										meetingPstmt = null;
									}
									if(cnt == 0)
									{
										errString = itmDBAccessLocal.getErrorString("meeting_status","IVMETSTAS",userId);
										break;
									}
								}
							}
							//Added by mrunalini sinkar for fortune changes (End)
							else if(formName.equalsIgnoreCase("retailer"))
							{
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									//System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom1, retailFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom1, retailFormNo, "meet_summ", prntCtr));
									String strgCode = checkNull(getSelectedRowVal(dom1, retailFormNo, "strg_code", prntCtr));
									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									//System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("retailersampleitem");
									String teamFormNo = subFormsMap.get("retailerteam");
									String displayFormNo = subFormsMap.get("retailerdisplay");
									String brandFormNo = subFormsMap.get("retailerbrand");
									String orderFormNo = subFormsMap.get("retailersampleorder");
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo,strgCode);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo,strgCode);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo,strgCode);
									boolean isbrandEmpty = isDeSelEmptyDOM(dom2, ""+brandFormNo,strgCode);
									boolean isorderEmpty = isDeSelEmptyDOM(dom2, ""+orderFormNo,strgCode);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty || !isbrandEmpty || !isorderEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}

								}
							}
							//else if(childNodeName.equalsIgnoreCase("strg_code"))
							//{
								/*String isDrVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom2, "3"));
								System.out.println("dr_visit dfs:- "+isDrVisit+"::columnValue:"+columnValue);
								if("Y".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() <= 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NODOCVISEL", userId );
									break;
								}
								else if("N".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELDOCT", userId );
									break;
								}*/
							//}

						}

					}
				}
			}
			//added by mrunalini sinkar on 8-may-2017 for stockist form(start)
			else if("stockist".equalsIgnoreCase(formName))
			{
				System.out.println("Inside WFVALONDone of Stockist");
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int numberOfVisit = 0;
				String  strgType="";//Added by kailash on 10-09-18.
				String  cusType="";//Added by kailash on 10-09-18.
				String isMemberPresent  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);

				String itemSer = checkNull(getItemSer(userId,connectionObject));
				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [start]
				String parmVal = "";
				String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
				pstmt = connectionObject.prepareStatement(sfaParmSql);
				rSet = pstmt.executeQuery();
				if (rSet.next())
				{
					parmVal = checkNull(rSet.getString("PARM_VALUE"));
				}
				if(rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [end]
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(start)
				int visit = 0;
				String noOfVisit = genericUtility.getColumnValue("strg_no_visit", dom1, stockistFormNo);
				if(noOfVisit!=null)
				{
					numberOfVisit = Integer.parseInt(noOfVisit);
				}
				String actualVisit = genericUtility.getColumnValue("doc_visit_dates", dom1, stockistFormNo);
				if(actualVisit!=null)
				{
					visit = Integer.parseInt(actualVisit);
				}
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(end)

				customerName = checkNull(genericUtility.getColumnValue("cust_name", dom1, stockistFormNo));
				scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, stockistFormNo));
				if("US00000000".equalsIgnoreCase(scCode))
				{
					customerName = " for customer Stockist Details";
				}
				else
				{
					customerName = " for customer "+customerName;
				}

				NodeList custParentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int custParentNodeListLength = custParentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				int selCallList = 0;
				for (int prntCtr = 0; prntCtr < custParentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = custParentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = custParentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = checkNull(childNode.getFirstChild().getNodeValue());
						}
						childNodeName = childNode.getNodeName();

						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}

						if(childNodeName.equalsIgnoreCase("cust_type") && selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag) && updateFlag != null)
						{
							if("UNLISTED-RETAILER".equalsIgnoreCase(columnValue) || "UNLISTED-WHOLESALER".equalsIgnoreCase(columnValue))
							{
								if("A".equalsIgnoreCase(updateFlag))
								{
									selCallList++;
								}
								else if("D".equalsIgnoreCase(updateFlag))
								{
									selCallList--;
								}
							}
						}
					}
				}

				//System.out.println("Case 4 : validation ::");
				parentList = dom1.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				//System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
						/*if(parmValue.equalsIgnoreCase("Y"))
						{
							if(numberOfVisit < visit && noOfVisit!= null)   //added by mrunalini sinkar
							{
								errString = itmDBAccessLocal.getErrorString("strg_no_visit","NOOFVISIT",userId);
								break;
							}
						}*/
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//Added by kailash on 10-09-18[start]
							//cusType = checkNull(genericUtility.getColumnValue("cust_type", dom2, stockistFormNo));
							cusType = checkNull(genericUtility.getColumnValueFromNode("cust_type", parentNode));
							String routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));
							//System.out.println("cusType3468["+cusType+"]");
							//Added by kailash on 10-09-18[end]
							if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[start]
								else
								{
									if("UNLISTED-STOCKIST".equalsIgnoreCase(cusType))
									{
										ArrayList locFromDom = new ArrayList();
										String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));
										locFromDom = getSelectedLocFromDom(dom2,locFormNo,connectionObject);
										if(!(locFromDom.contains(locCode)))
										{
											errString = itmDBAccessLocal.getErrorString( "locality_code" , "INVLOCSELD" , userId );
											break;
										}
									}
								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[end]
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside WFVALONDone of Stockist");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom1, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom1, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							else if(childNodeName.equalsIgnoreCase("strg_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									errString = itmDBAccessLocal.getErrorString("strg_code","BLNKSCCODE",userId);
									break;
								}
								else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									if(cusType.contains("UNLISTED-") && "Y".equalsIgnoreCase(isFortuneAct) )
									{
										//System.out.println("Inside stokist  unlist:"+cusType);
										int cnt=0;
										String uniqStrgcd = checkNull(genericUtility.getColumnValue("uniq_strg_code", dom1, objContext));
										String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
										String strgtype = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										String sql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE TRIM(SC_CODE)=TRIM(?) AND STATUS='U' AND TRIM(CUST_TYPE)=TRIM(?)";
										PreparedStatement strgcode=connectionObject.prepareStatement(sql);
										strgcode.setString(1, strgCode);
										strgcode.setString(2, strgtype);
										ResultSet strgCdRs=strgcode.executeQuery();
										if(strgCdRs.next())
										{
											cnt=strgCdRs.getInt("COUNT");
										}
										if (strgCdRs != null)
										{
											strgCdRs.close();
											strgCdRs = null;
										}
										if (strgcode != null)
										{
											strgcode.close();
											strgcode = null;
										}
										if(cnt == 0)
										{
											//System.out.println("Inside STRG_code stokist");
											if(!(uniqStrgcd.equalsIgnoreCase(strgCode)))
											{
												System.out.println("Inside STRG_code stokist inside");
												errString = itmDBAccessLocal.getErrorString("strg_code","INVALSTDC",userId);
												break;
											}
										}
									}
									
								}
								
							}

							else if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									String sprsActCode = checkNull(genericUtility.getColumnValue("sprs_act_code", dom1, objContext));
									if(sprsActCode!=null && sprsActCode.trim().length()>0)
									{
										String eventType = checkNull(genericUtility.getColumnValue("event_type", dom1, objContext));
										int actCnt=0;
										String sql="SELECT COUNT(*) AS COUNT FROM FIELDACTIVITY FA WHERE FA.STATUS = 'Y' " + 
												"AND FA.ACTIVITY_TYPE NOT IN ('PR') AND FA.ACTIVITY_CODE NOT IN ('JW') AND FA.ACTIVITY_CODE IN ("+sprsActCode+") AND FA.ACTIVITY_TYPE='FW' AND FA.ACTIVITY_CODE=? " + 
												"AND (FA.ITEM_SER='ALL' OR (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?) IN(SELECT regexp_substr( ITEM_SER,'[^,]+', 1, LEVEL) FROM " + 
												"DUAL CONNECT BY regexp_substr(ITEM_SER, '[^,]+', 1, LEVEL) IS NOT NULL ) ) " + 
												"ORDER BY FA.DESCR,FA.ACTIVITY_CODE";
										
										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, eventType);
										pstmt.setString(2, userId);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											actCnt = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(actCnt == 0)
										{
											errString = itmDBAccessLocal.getErrorString("event_type", "ACTNOTFND", userId);
											break;
										}
									}

									
								}
							}
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [start]
							/*else if(childNodeName.equalsIgnoreCase("event_time_start"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("US00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLVSITFR",userId);
										break;
									}
									else
									{
										//errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLVSITFR",userId);
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("visit_time_from"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("US00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										break;
									}
									else
									{
										//errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										break;
									}
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									/*if ("US00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										break;
									}*/
									/*else
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLEVNTTO",userId);
										break;
									}*/
								}
								else
								{

									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, objContext));
									//String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									String startVisitTime = checkNull(genericUtility.getColumnValue("event_time_start", dom1, objContext));
									String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("retFlag["+retFlag+"scCode["+scCode+"]");
									System.out.println("startVisitTime stockist:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime stockist:["+endVisitTime+"]scCode["+scCode+"]");
									if (!retFlag && "US00000000".equalsIgnoreCase( scCode ))
									{
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}

								}
							}
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [end]
							//Added by kailash on 10-09-18 for unlisted dorctor changes[start]
							else if (childNodeName.equalsIgnoreCase("next_plan_date"))//Added by mrunalini sinkar for next_plan_date validaiton
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
									java.util.Date nextPlanDate = null;
									java.util.Date eventDate = null;

									String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom1,objContext ));

									try
									{
										nextPlanDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
										eventDate = sdfFormat.parse( workDate);

									}
									catch ( Exception e )
									{
										errString = itmDBAccessLocal.getErrorString( "next_plan_date", "INVDTFRMT", userId );
										break;
									}

									String planDat=childNode.getFirstChild().getNodeValue();
									if (!sdfFormat.format(nextPlanDate).equals(planDat))
									{
										errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
										break;
									}

									if  ( nextPlanDate.compareTo(eventDate) <= 0)
									{

										errString = itmDBAccessLocal.getErrorString( "event_date", "INVPLDATE", userId );
										break;
									}
								}
							}
							
							//else if("UNLISTED-STOCKIST".equalsIgnoreCase(cusType) && !"Y".equalsIgnoreCase(isMemberPresent) && !"M".equalsIgnoreCase(routeType))
							else if(cusType.contains("UNLISTED-") && !"Y".equalsIgnoreCase(isMemberPresent) && !"M".equalsIgnoreCase(routeType))
							{
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [Start]
								//String totAllwCallList ="";
								String maxStrgCustomr="";
								WSFACommon wsfaCommon=new WSFACommon();
								HashMap<String,String> totCustList=  new HashMap<String, String>();
								totCustList =wsfaCommon.getVisitData(userId, itemSer, connectionObject);
								for(Map.Entry<String, String> m:totCustList.entrySet())
								{
									maxStrgCustomr =(String)m.getKey();
								}
								if(maxStrgCustomr != null && maxStrgCustomr.trim().length() != 0)
								{
									totAllwCallList = maxStrgCustomr;
								}
								else
								{
								 totAllwCallList = checkNull(getSfaParmValue(userId, "TOT_ALLOW_CALL_LIST", connectionObject));
								}
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [End]
								if(!"".equalsIgnoreCase(totAllwCallList) && ("UNLISTED-RETAILER".equalsIgnoreCase(cusType) || "UNLISTED-WHOLESALER".equalsIgnoreCase(cusType)))
								{
									int listCnt = 0;
									int totAllwCallListCnt = Integer.parseInt(totAllwCallList);
									String sqlCount = "SELECT "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SALES_PERS = ? AND SC.CUST_TYPE IN ('C','W') AND SS.STATUS = 'Y') "+
													  "+ "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND WF_STATUS NOT IN ('A','R') AND STRG_TYPE IN ('C','W')) AS COUNT FROM DUAL ";
									pstmt = connectionObject.prepareStatement(sqlCount);
									pstmt.setString(1, userId);
									pstmt.setString(2, userId);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										listCnt = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									//if(listCnt >= totAllwCallListCnt)
									listCnt = listCnt + selCallList;
									if(listCnt > totAllwCallListCnt)
									{
										errString = itmDBAccessLocal.getErrorString("cust_type", "UNLSTNTALW", userId);
										break;
									}
								}
								if(childNodeName.equalsIgnoreCase("address_as"))
								{
									scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
									String locality = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));

									if(scCode != null && scCode.trim().length() > 0 && locality != null && locality.trim().length() > 0)
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString( "address_as" , "NULLADDAS" , userId );
											break;
										}
									}

								}
								else if(childNodeName.equalsIgnoreCase("strg_name"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "strg_name" , "BLANKCUST" , userId );
										break;
									}
								}

								else if(childNodeName.equalsIgnoreCase("gender"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										/*errString = itmDBAccessLocal.getErrorString( "gender" , "NULLGENDR" , userId );
										break;*/
									}
								}
								else if( "email_addr".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null email_addr
										//removed comment on 16/01/19 for applying validation on mobile number for chc
										/*System.out.println( "email_addr cannot be null:" );
										errString = itmDBAccessLocal.getErrorString( "email_addr" , "NULEMAILID" , userId );
										break;*/
									}
									else
									{
										String emailAddr = checkNull(genericUtility.getColumnValue("email_addr", dom1, objContext));
										boolean isEmail = true;
										String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
										if(emailAddr != null )
										{
											isEmail = emailAddr.matches(ePattern);
											if(!(isEmail))
											{
												errString = itmDBAccessLocal.getErrorString("email_addr","INVDEMAILD",userId);
												break;
											}
										}
									}
								}
								else if ( "mobile_no".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
										//removed comment on 16/01/19 for applying validation on mobile number for chc
										errString = itmDBAccessLocal.getErrorString( "mobile_no" , "NULPHONNO" , userId );
										break;
									}
									else
									{
										String custCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
										String phoneNo = checkNull(genericUtility.getColumnValue("mobile_no", dom1, objContext));
										phoneNo = (phoneNo == null) ?"":phoneNo.trim();
										if(phoneNo == null || phoneNo.trim().length() <= 0)
										{
											//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
											//removed comment on 16/01/19 for applying validation on mobile number for chc
											errString = itmDBAccessLocal.getErrorString( "mobile_no","NULPHONENO",userId );
											break;
										}
										else if(phoneNo.length() < 10 || phoneNo.length() > 10 || phoneNo.startsWith("0"))
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","INVDPHNLNO",userId);
											break;
										}

										int custAddCnt=0;
										String custAddsql="SELECT COUNT(*) AS CNT FROM STRG_CUST_ADD WHERE MOBILE_NO = ? AND STRG_CODE<>? AND WF_STATUS='P'";
										PreparedStatement custPstmt=connectionObject.prepareStatement(custAddsql);
										custPstmt.setString(1,phoneNo);
										custPstmt.setString(2,custCode);
										ResultSet custRS=custPstmt.executeQuery();
										if(custRS.next())
										{
											custAddCnt=custRS.getInt("CNT");
										}
										if (custRS != null)
										{
											custRS.close();
											custRS = null;
										}
										if (custPstmt != null)
										{
											custPstmt.close();
											custPstmt = null;
										}
										if(custAddCnt>0)
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCSNT",userId);
											break;
										}
										else
										{
											int customerCnt=0;
											String customersql="SELECT COUNT(*) AS CNT FROM STRG_CUSTOMER WHERE MOBILE_NO = ? AND SC_CODE<>?";
											custPstmt=connectionObject.prepareStatement(customersql);
											custPstmt.setString(1,phoneNo);
											custPstmt.setString(2,custCode);
											custRS=custPstmt.executeQuery();
											if(custRS.next())
											{
												customerCnt=custRS.getInt("CNT");
											}
											if (custRS != null)
											{
												custRS.close();
												custRS = null;
											}
											if (custPstmt != null)
											{
												custPstmt.close();
												custPstmt = null;
											}
											if(customerCnt>0)
											{
												errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCNT",userId);
												break;
											}
										}
									}
								}
								else if(childNodeName.equalsIgnoreCase("strg_class_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										if(!stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
										{
											errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
											break;
										}
									}
									else
									{
										// added by mrunalini sinkar on 31-jan-2019 for class code validation(start)
										int count = 0;
										String codeSql = "";
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										//String itemSer = checkNull(getItemSer(userId,connectionObject));   //commended by hariom and added inside method

										int classCount = getCountFromSerClass(itemSer,classCode,connectionObject); // added by mrunalini sinkar for class code pophelp on 31-jan-2019(start)
										if(classCount==0)
										{
											codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
											pstmt = connectionObject.prepareStatement(codeSql);
											pstmt.setString(1,custType);
											pstmt.setString(2,classCode);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
												break;
											}
										}
										/*int count = 0;
										String codeSql = "";
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										System.out.println("classCode>>["+classCode+"]custType["+custType+"]");
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
											break;
										}*/
										// added by mrunalini sinkar on 31-jan-2019 for class code validation(end)
									}
								}
								else if(childNodeName.equalsIgnoreCase("spl_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{

									}
									else
									{
										columnValue = childNode.getFirstChild().getNodeValue().trim();
										if( columnValue != null )
										{
											String splCodeSql = "";
											int count = 0;
											splCodeSql = "SELECT COUNT(*) AS COUNT FROM SPECIALITY WHERE SPL_CODE = ?";
											pstmt = connectionObject.prepareStatement(splCodeSql);
											pstmt.setString(1, columnValue);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVSPLCODE",userId);
												break;
											}
										}
									}
								}
								// added by kailash on 24/01/19 for applying validation on subclass [start]
								else if(childNodeName.equalsIgnoreCase("subclass_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										/*errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
										break;*/
									}
									else
									{
										int count = 0;
										String codeSql = "";
										String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code", dom1, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_SUBCLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ? AND SUBCLASS_CODE = ? ";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										pstmt.setString(3,subClassCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString("subclass_code","INVSUBCLS",userId);
											break;
										}
									}
								}
								// added by kailash on 24/01/19  for applying validation on subclass [end]
							}
							/*else if("Y".equalsIgnoreCase(isMemberPresent) && "UNLISTED-STOCKIST".equalsIgnoreCase(cusType))//Added by mrunalini sinkar for member presnt
							{
								if(childNodeName.equalsIgnoreCase("member_present"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
										break;
									}
									else
									{
										String memberPresent = checkNull(genericUtility.getColumnValue("member_present", dom1, objContext));
										int noOfChem =Integer.parseInt(memberPresent);
										if (noOfChem <= 0)
										{
											errString = itmDBAccessLocal.getErrorString( "noof_chemist" , "VTMEMPRE" , userId );
											break;
										}
									}
								}
							}*/
							//Added by kailash on 10-09-18 for unlisted dorctor changes[end]
							// added by rupali on 05/01/18 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmVal))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom1, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							// added by rupali on 05/01/18 for displaying preffered stockist field [end]
							//Added by mrunalini sinkar for fortune changes (sart)
							else if (childNodeName.equalsIgnoreCase("meeting_status"))//Added by mrunalini sinkar for fortune changes (sart)
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									int cnt=0;
									String callOutCome = checkNull(getSelectedRowVal(dom1, stockistFormNo, "meeting_status", prntCtr));
									String sprsActCode = checkNull(getSelectedRowVal(dom1, stockistFormNo, "event_type", prntCtr));
									columnValue = childNode.getFirstChild().getNodeValue().trim();
									String sql="SELECT COUNT(*) AS COUNT FROM CALL_OUTCOME WHERE TRIM(UPPER(CALL_OUTCOME_DESCR))=? AND ACTIVITY_CODE=? ";
									PreparedStatement meetingPstmt=connectionObject.prepareStatement(sql);
									meetingPstmt.setString(1, callOutCome.toUpperCase());
									meetingPstmt.setString(2, sprsActCode);
									ResultSet meetingRS=meetingPstmt.executeQuery();
									if(meetingRS.next())
									{
										cnt=meetingRS.getInt("COUNT");
									}
									if (meetingRS != null)
									{
										meetingRS.close();
										meetingRS = null;
									}
									if (meetingPstmt != null)
									{
										meetingPstmt.close();
										meetingPstmt = null;
									}
									if(cnt == 0)
									{
										errString = itmDBAccessLocal.getErrorString("meeting_status","IVMETSTAS",userId);
										break;
									}
								}
							}
						//Added by mrunalini sinkar for fortune changes (End)
							else if(formName.equalsIgnoreCase("stockist"))
							{
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									String callOutCome = checkNull(getSelectedRowVal(dom1, stockistFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom1, stockistFormNo, "meet_summ", prntCtr));
									String strgCode = checkNull(getSelectedRowVal(dom1, stockistFormNo, "strg_code", prntCtr));

									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									//System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleorderFormNo = subFormsMap.get("stockistsampleorder");
									String sampleitemFormNo = subFormsMap.get("stockistsampleitem");
									String teamFormNo = subFormsMap.get("stockistteam");
									String displayFormNo = subFormsMap.get("stockistdisplay");
									String brandFormNo = subFormsMap.get("stockistbrand");
									boolean isSampleOrderEmpty = isDeSelEmptyDOM(dom2, ""+sampleorderFormNo,strgCode);
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo,strgCode);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo,strgCode);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo,strgCode);
									boolean isbrandEmpty = isDeSelEmptyDOM(dom2, ""+brandFormNo,strgCode);
									if(callOutCome.equalsIgnoreCase("0") && (!isSampleOrderEmpty || !isDisplayEmpty || !isTeamEmpty || !isbrandEmpty || !isSampleItemEmpty ))
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}
								}
							}

						}

					}

				}
			}
			//added by mrunalini sinkar on 8-may-2017 for stockist form(end)

			//added by prathmesh jangam  on 8-may-2017 for ncw form(start)

			else if("ncw".equalsIgnoreCase(formName))
			{
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int numberOfVisit = 0;
				String  strgType="";//Added by kailash on 10-09-18.
				String  cusType="";//Added by kailash on 10-09-18.
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(start)
				String itemSer = checkNull(getItemSer(userId,connectionObject));
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);

				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [start]
				String parmVal = "";
				String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
				pstmt = connectionObject.prepareStatement(sfaParmSql);
				rSet = pstmt.executeQuery();
				if (rSet.next())
				{
					parmVal = checkNull(rSet.getString("PARM_VALUE"));
				}
				if(rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				// added by rupali on 06/11/17 for applying condition of sfaparm for validation of stock_qty and lot_no fields [end]
				int visit = 0;
				String noOfVisit = genericUtility.getColumnValue("strg_no_visit", dom1, ncwFormNo);
				if(noOfVisit!=null)
				{
					numberOfVisit = Integer.parseInt(noOfVisit);
				}
				String actualVisit = genericUtility.getColumnValue("doc_visit_dates", dom1, ncwFormNo);
				if(actualVisit!=null)
				{
					visit = Integer.parseInt(actualVisit);
				}
				//added by mrunalini sinkar on 17-may-2017 to throw the exception if number of visit is less than actual visit(end)
				//System.out.println("Case 4 : validation ::");
				parentList = dom1.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				//System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
						/*if(numberOfVisit < visit && noOfVisit!= null) // added by mrunalini sinkar
						{
							errString = itmDBAccessLocal.getErrorString("strg_no_visit","NOOFVISIT",userId);
							break;
						}*/
						//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//Added by kailash on 10-09-18[start]
							//cusType = checkNull(genericUtility.getColumnValue("cust_type", dom2, ncwFormNo));
							cusType = checkNull(genericUtility.getColumnValueFromNode("cust_type", parentNode));
							//System.out.println("cusType3920["+cusType+"]");
							//Added by kailash on 10-09-18[end]

							if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[start]
								else
								{
									if("UNLISTED-OTHER".equalsIgnoreCase(cusType))
									{
										ArrayList locFromDom = new ArrayList();
										String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));
										locFromDom = getSelectedLocFromDom(dom2,locFormNo,connectionObject);
										if(!(locFromDom.contains(locCode)))
										{
											errString = itmDBAccessLocal.getErrorString( "locality_code" , "INVLOCSELD" , userId );
											break;
										}
									}

								}
								//Added by kailash on 10-09-18 for unlisted case locality validation[end]
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//System.out.println("Inside oth_participant on Done of NCW");
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom1, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom1, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom1, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							else if(childNodeName.equalsIgnoreCase("strg_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									errString = itmDBAccessLocal.getErrorString("strg_code","BLNKSCCODE",userId);
									break;
								}
								else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									if(cusType.contains("UNLISTED-")&& "Y".equalsIgnoreCase(isFortuneAct))
									{
										int cnt=0;
										String uniqStrgcd = checkNull(genericUtility.getColumnValue("uniq_strg_code", dom1, objContext));
										String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
										String strgtype = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										String sql="SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE TRIM(SC_CODE)=TRIM(?) AND STATUS='U' AND TRIM(CUST_TYPE)=TRIM(?)";
										PreparedStatement strgcode=connectionObject.prepareStatement(sql);
										strgcode.setString(1, strgCode);
										strgcode.setString(2, strgtype);
										ResultSet strgCdRs=strgcode.executeQuery();
										if(strgCdRs.next())
										{
											cnt=strgCdRs.getInt("COUNT");
										}
										if (strgCdRs != null)
										{
											strgCdRs.close();
											strgCdRs = null;
										}
										if (strgcode != null)
										{
											strgcode.close();
											strgcode = null;
										}
										if(cnt == 0)
										{
											if(!(uniqStrgcd.equalsIgnoreCase(strgCode)))
											{
												System.out.println("Inside STRG_code NCW done inside");
												errString = itmDBAccessLocal.getErrorString("strg_code","INVALSTDC",userId);
												break;
											}
										}
									}
									
								}
								
							}
							else if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									String sprsActCode = checkNull(genericUtility.getColumnValue("sprs_act_code", dom1, objContext));
									String eventType = checkNull(genericUtility.getColumnValue("event_type", dom1, objContext));
									if(sprsActCode!=null && sprsActCode.trim().length()>0)
									{
										int actCnt=0;
										String sql="SELECT COUNT(*) AS COUNT FROM FIELDACTIVITY FA WHERE FA.STATUS = 'Y' " + 
												"AND FA.ACTIVITY_TYPE NOT IN ('PR') AND FA.ACTIVITY_CODE NOT IN ('JW') AND FA.ACTIVITY_CODE IN ("+sprsActCode+") AND FA.ACTIVITY_TYPE='FW' AND FA.ACTIVITY_CODE=? " + 
												"AND (FA.ITEM_SER='ALL' OR (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?) IN(SELECT regexp_substr( ITEM_SER,'[^,]+', 1, LEVEL) FROM " + 
												"DUAL CONNECT BY regexp_substr(ITEM_SER, '[^,]+', 1, LEVEL) IS NOT NULL ) ) " + 
												"ORDER BY FA.DESCR,FA.ACTIVITY_CODE";
										
										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, eventType);
										pstmt.setString(2, userId);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											actCnt = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(actCnt == 0)
										{
											errString = itmDBAccessLocal.getErrorString("event_type", "ACTNOTFND", userId);
											break;
										}
									}
									

									
								}
							}
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [start]
							else if(childNodeName.equalsIgnoreCase("event_time_start"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("UN00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLVSITFR",userId);
										break;
									}
									/*else
									{
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
										break;
									}*/
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("UN00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										break;
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLEVNTFR",userId);
										break;
									}
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("UN00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										break;
									}
									/*else
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLEVNTTO",userId);
										break;
									}*/
								}
								else
								{

									boolean retFlag=true;
									String startVisitTime = checkNull(genericUtility.getColumnValue("event_time_start", dom1, objContext));
									String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									scCode = checkNull(genericUtility.getColumnValue("strg_code", dom2, objContext));


									retFlag = validateEndTime(startVisitTime , endVisitTime);
									if (!retFlag  && "UN00000000".equalsIgnoreCase(scCode))
									{
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}

								}
							}
							
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [end]
							//Added by kailash on 10-09-18 for unlisted dorctor changes[start]
							//else if("UNLISTED-OTHER".equalsIgnoreCase(cusType))
							else if(cusType.contains("UNLISTED-"))
							{
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [Start]
								//String totAllwCallList ="";
								String maxStrgCustomr="";
								WSFACommon wsfaCommon=new WSFACommon();
								HashMap<String,String> totCustList=  new HashMap<String, String>();
								totCustList =wsfaCommon.getVisitData(userId, itemSer, connectionObject);
								for(Map.Entry<String, String> m:totCustList.entrySet())
								{
									maxStrgCustomr =(String)m.getKey();
								}
								if(maxStrgCustomr != null && maxStrgCustomr.trim().length() != 0)
								{
									totAllwCallList = maxStrgCustomr;
									//System.out.println("totAllwCallList ["+totAllwCallList+"]");
								}
								else
								{
								 totAllwCallList = checkNull(getSfaParmValue(userId, "TOT_ALLOW_CALL_LIST", connectionObject));
								}
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [End]
								if(!"".equalsIgnoreCase(totAllwCallList) && ("UNLISTED-RETAILER".equalsIgnoreCase(cusType) || "UNLISTED-WHOLESALER".equalsIgnoreCase(cusType)))
								{
									int listCnt = 0;
									int totAllwCallListCnt = Integer.parseInt(totAllwCallList);
									String sqlCount = "SELECT "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SALES_PERS = ? AND SC.CUST_TYPE IN ('C','W') AND SS.STATUS = 'Y') "+
													  "+ "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND WF_STATUS NOT IN ('A','R') AND STRG_TYPE IN ('C','W')) AS COUNT FROM DUAL ";
									pstmt = connectionObject.prepareStatement(sqlCount);
									pstmt.setString(1, userId);
									pstmt.setString(2, userId);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										listCnt = rSet.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(listCnt >= totAllwCallListCnt)
									{
										errString = itmDBAccessLocal.getErrorString("cust_type", "UNLSTNTALW", userId);
										break;
									}
								}
								if(childNodeName.equalsIgnoreCase("address_as"))
								{
									scCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
									String locality = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));

									if(scCode != null && scCode.trim().length() > 0 && locality != null && locality.trim().length() > 0)
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString( "address_as" , "NULLADDAS" , userId );
											break;
										}
									}

								}
								else if(childNodeName.equalsIgnoreCase("strg_name"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//System.out.println( "customer name cannot be null:" +childNodeName);
										errString = itmDBAccessLocal.getErrorString( "strg_name" , "BLANKCUST" , userId );
										break;
									}
								}

								else if(childNodeName.equalsIgnoreCase("gender"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										/*errString = itmDBAccessLocal.getErrorString( "gender" , "NULLGENDR" , userId );
										break;*/
									}
								}
								else if( "email_addr".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null email_addr
										//removed comment on 16/01/19 for applying validation on mobile number for chc
										/*System.out.println( "email_addr cannot be null:" );
										errString = itmDBAccessLocal.getErrorString( "email_addr" , "NULEMAILID" , userId );
										break;*/
									}
									else
									{
										String emailAddr = checkNull(genericUtility.getColumnValue("email_addr", dom1, objContext));
										//System.out.println("email_addr ::::["+emailAddr+"]");
										boolean isEmail = true;
										String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
										if(emailAddr != null )
										{
											isEmail = emailAddr.matches(ePattern);
											if(!(isEmail))
											{
												errString = itmDBAccessLocal.getErrorString("email_addr","INVDEMAILD",userId);
												break;
											}
										}
									}
								}
								else if ( "mobile_no".equalsIgnoreCase(childNodeName))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
										//removed comment on 16/01/19 for applying validation on mobile number for chc
										//System.out.println( "mobile_no cannot be null:" );
										errString = itmDBAccessLocal.getErrorString( "mobile_no" , "NULPHONNO" , userId );
										break;
									}
									else
									{
										String custCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
										String phoneNo = checkNull(genericUtility.getColumnValue("mobile_no", dom1, objContext));
										phoneNo = (phoneNo == null) ?"":phoneNo.trim();
										if(phoneNo == null || phoneNo.trim().length() <= 0)
										{
											//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
											//removed comment on 16/01/19 for applying validation on mobile number for chc
											errString = itmDBAccessLocal.getErrorString( "mobile_no","NULPHONENO",userId );
											break;
										}
										else if(phoneNo.length() < 10 || phoneNo.length() > 10 || phoneNo.startsWith("0"))
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","INVDPHNLNO",userId);
											break;
										}
										int custAddCnt=0;
										String custAddsql="SELECT COUNT(*) AS CNT FROM STRG_CUST_ADD WHERE MOBILE_NO = ? AND STRG_CODE<>? AND WF_STATUS='P'";
										PreparedStatement custPstmt=connectionObject.prepareStatement(custAddsql);
										custPstmt.setString(1,phoneNo);
										custPstmt.setString(2,custCode);
										ResultSet custRS=custPstmt.executeQuery();
										if(custRS.next())
										{
											custAddCnt=custRS.getInt("CNT");
										}
										if (custRS != null)
										{
											custRS.close();
											custRS = null;
										}
										if (custPstmt != null)
										{
											custPstmt.close();
											custPstmt = null;
										}
										if(custAddCnt>0)
										{
											errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCSNT",userId);
											break;
										}
										else
										{
											int customerCnt=0;
											String customersql="SELECT COUNT(*) AS CNT FROM STRG_CUSTOMER WHERE MOBILE_NO = ? AND SC_CODE<>?";
											custPstmt=connectionObject.prepareStatement(customersql);
											custPstmt.setString(1,phoneNo);
											custPstmt.setString(2,custCode);
											custRS=custPstmt.executeQuery();
											if(custRS.next())
											{
												customerCnt=custRS.getInt("CNT");
											}
											if (custRS != null)
											{
												custRS.close();
												custRS = null;
											}
											if (custPstmt != null)
											{
												custPstmt.close();
												custPstmt = null;
											}
											if(customerCnt>0)
											{
												errString = itmDBAccessLocal.getErrorString("mobile_no","DUPMOBCNT",userId);
												break;
											}
										}
										

									}
								}
								else if(childNodeName.equalsIgnoreCase("strg_class_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
										break;
									}
									else
									{
										// added by mrunalini sinkar on 31-jan-2019 for class code validation(start)
										int count = 0;
										String codeSql = "";
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										//String itemSer = checkNull(getItemSer(userId,connectionObject));   // commended by hariom and added inside method
										//System.out.println("INSIDE CLASS CODE itemSer" +itemSer);

										int classCount = getCountFromSerClass(itemSer,classCode,connectionObject); // added by mrunalini sinkar for class code pophelp on 31-jan-2019(start)
										if(classCount==0)
										{
											codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
											pstmt = connectionObject.prepareStatement(codeSql);
											pstmt.setString(1,custType);
											pstmt.setString(2,classCode);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												//System.out.println("INVALID CLASS CODE::");
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
												break;
											}
										}
										/*int count = 0;
										String codeSql = "";
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										System.out.println("classCode>>["+classCode+"]custType["+custType+"]");
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
											break;
										}*/
										// added by mrunalini sinkar on 31-jan-2019 for class code validation(end)
									}
								}
								else if(childNodeName.equalsIgnoreCase("spl_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{

									}
									else
									{
										columnValue = childNode.getFirstChild().getNodeValue().trim();
										if( columnValue != null )
										{
											String splCodeSql = "";
											int count = 0;
											splCodeSql = "SELECT COUNT(*) AS COUNT FROM SPECIALITY WHERE SPL_CODE = ?";
											pstmt = connectionObject.prepareStatement(splCodeSql);
											pstmt.setString(1, columnValue);
											rSet = pstmt.executeQuery();
											if(rSet.next())
											{
												count = rSet.getInt("COUNT");
											}
											if (rSet != null)
											{
												rSet.close();
												rSet = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVSPLCODE",userId);
												break;
											}
										}
									}
								}
								// added by kailash on 24/01/19 for applying validation on subclass [start]
								else if(childNodeName.equalsIgnoreCase("subclass_code"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//System.out.println( "subclass_code code cannot be null" );
										/*errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
										break;*/
									}
									else
									{
										int count = 0;
										String codeSql = "";
										String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code", dom1, objContext));
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1, objContext));
										String custType = checkNull(genericUtility.getColumnValue("strg_type", dom1, objContext));
										//System.out.println("classCode =["+classCode+"], custType = ["+custType+"]");
										codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_SUBCLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ? AND SUBCLASS_CODE = ? ";
										pstmt = connectionObject.prepareStatement(codeSql);
										pstmt.setString(1,custType);
										pstmt.setString(2,classCode);
										pstmt.setString(3,subClassCode);
										rSet = pstmt.executeQuery();
										if(rSet.next())
										{
											count = rSet.getInt("COUNT");
										}
										if (rSet != null)
										{
											rSet.close();
											rSet = null;
										}
										if (pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											//System.out.println("INVALID SUBCLASS CODE::");
											errString = itmDBAccessLocal.getErrorString("subclass_code","INVSUBCLS",userId);
											break;
										}
									}
								}
								else if (childNodeName.equalsIgnoreCase("meeting_status"))//Added by mrunalini sinkar for fortune changes (sart)
								{
									if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
									{
										int cnt=0;
										String callOutCome = checkNull(getSelectedRowVal(dom1, ncwFormNo, "meeting_status", prntCtr));
										String sprsActCode = checkNull(getSelectedRowVal(dom1, ncwFormNo, "event_type", prntCtr));
										columnValue = childNode.getFirstChild().getNodeValue().trim();
										System.out.println("columnValue of meeting status["+columnValue+"]");
										String sql="SELECT COUNT(*) AS COUNT FROM CALL_OUTCOME WHERE TRIM(UPPER(CALL_OUTCOME_DESCR))=? AND ACTIVITY_CODE=? ";
										PreparedStatement meetingPstmt=connectionObject.prepareStatement(sql);
										meetingPstmt.setString(1, callOutCome.toUpperCase());
										meetingPstmt.setString(2, sprsActCode);

										ResultSet meetingRS=meetingPstmt.executeQuery();
										if(meetingRS.next())
										{
											cnt=meetingRS.getInt("COUNT");
										}
										if (meetingRS != null)
										{
											meetingRS.close();
											meetingRS = null;
										}
										if (meetingPstmt != null)
										{
											meetingPstmt.close();
											meetingPstmt = null;
										}
										if(cnt == 0)
										{
											errString = itmDBAccessLocal.getErrorString("meeting_status","IVMETSTAS",userId);
											break;
										}
									}
								}
								// added by kailash on 24/01/19  for applying validation on subclass [end]
							}
							//Added by kailash on 10-09-18 for unlisted dorctor changes[end]
							// added by rupali on 05/01/18 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmVal))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "stockist code cannot be null:" +childNodeName);
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom1, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE = ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										count = rSet.getInt("COUNT");
									}
									//System.out.println("count =["+count+"]");
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										//System.out.println("INVALID STOCK CODE::");
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							// added by rupali on 05/01/18 for displaying preffered stockist field [end]
														//Added by mrunalini sinkar for fortune changes (sart)
							else if (childNodeName.equalsIgnoreCase("meeting_status"))//Added by mrunalini sinkar for fortune changes (sart)
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									int cnt=0;
									String callOutCome = checkNull(getSelectedRowVal(dom1, ncwFormNo, "meeting_status", prntCtr));
									String sprsActCode = checkNull(getSelectedRowVal(dom1, ncwFormNo, "event_type", prntCtr));
									columnValue = childNode.getFirstChild().getNodeValue().trim();
									System.out.println("columnValue of meeting status["+columnValue+"]");
									String sql="SELECT COUNT(*) AS COUNT FROM CALL_OUTCOME WHERE TRIM(UPPER(CALL_OUTCOME_DESCR))=? AND ACTIVITY_CODE=? ";
									PreparedStatement meetingPstmt=connectionObject.prepareStatement(sql);
									meetingPstmt.setString(1, callOutCome.toUpperCase());
									meetingPstmt.setString(2, sprsActCode);

									ResultSet meetingRS=meetingPstmt.executeQuery();
									if(meetingRS.next())
									{
										cnt=meetingRS.getInt("COUNT");
									}
									if (meetingRS != null)
									{
										meetingRS.close();
										meetingRS = null;
									}
									if (meetingPstmt != null)
									{
										meetingPstmt.close();
										meetingPstmt = null;
									}
									if(cnt == 0)
									{
										errString = itmDBAccessLocal.getErrorString("meeting_status","IVMETSTAS",userId);
										break;
									}
								}
							}
							//Added by mrunalini sinkar for fortune changes (End)
							else if(formName.equalsIgnoreCase("ncw"))
							{
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									//System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom1, ncwFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom1, ncwFormNo, "meet_summ", prntCtr));
									String strgCode = checkNull(getSelectedRowVal(dom1, ncwFormNo, "strg_code", prntCtr));
									//System.out.println(" strgCode  :::::::: "+strgCode);

									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									//System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleorderFormNo = subFormsMap.get("ncwsampleorder");
									String sampleitemFormNo = subFormsMap.get("ncwsampleitem");
									String teamFormNo = subFormsMap.get("ncwteam");
									String displayFormNo = subFormsMap.get("ncwdisplay");
									String brandFormNo = subFormsMap.get("ncwbrand");
									boolean isSampleOrderEmpty = isDeSelEmptyDOM(dom2, ""+sampleorderFormNo,strgCode);
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo,strgCode);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo,strgCode);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo,strgCode);
									boolean isbrandEmpty = isDeSelEmptyDOM(dom2, ""+brandFormNo,strgCode);
									if(callOutCome.equalsIgnoreCase("0") &&(!isTeamEmpty || !isSampleOrderEmpty || !isSampleItemEmpty || !isDisplayEmpty || !isbrandEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}
								}
							}
						}

					}
				}
			}
			//added by prathmesh jangam  on 8-may-2017 for ncw form(end)
			else if("sampleitem".equalsIgnoreCase(formName) || "retailersampleitem".equalsIgnoreCase(formName) || "sampleorder".equalsIgnoreCase(formName) || "retailersampleorder".equalsIgnoreCase(formName) || "stockistsampleorder".equalsIgnoreCase(formName) || "ncwsampleorder".equalsIgnoreCase(formName) || "stockistsampleitem".equalsIgnoreCase(formName) || "ncwsampleitem".equalsIgnoreCase(formName))
			{
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int itemAllow=0;
				String sampleDescr = "";
				String orderParam = checkNull(getSfaParmValue(userId, "ORDER_QTY", connectionObject));
				String MaxItemAllow=checkNull(getSfaParmValue(userId, "NO_ITEM_ALLOW", connectionObject));
				String isStockInfo = checkNull(getSfaParmValue(userId,"IS_STOCK_INFO",connectionObject)); 

				//System.out.println("inside MaxItemAllow MaxItemAllow["+MaxItemAllow+"]");
				if(MaxItemAllow != null && MaxItemAllow.trim().length()>0)//Added by mrunalini sinkar if sfaparm is not exist
				{
					itemAllow = Integer.parseInt(MaxItemAllow);
				}
				//System.out.println("Case 4 : validation ::");
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";
					sampleDescr = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");

						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						else if ( "quantity".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("quantity inside is null");
								if("sampleitem".equalsIgnoreCase(formName) || "retailersampleitem".equalsIgnoreCase(formName) || "stockistsampleitem".equalsIgnoreCase(formName) || "ncwsampleitem".equalsIgnoreCase(formName))
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","INVITEMQTY",userId);
									break;
								}
								if("Y".equalsIgnoreCase(orderParam))
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
									break;
								}
							}
							else
							{
								try
								{
									int minQuantity=0;
									//String quantity = checkNull(genericUtility.getColumnValue("quantity", dom, ""+currentFormNo));
									String quantity = genericUtility.getColumnValueFromNode("quantity", currDetail);
									//Added by Mrunalini Sinkar for chc enhancment(Start)
									String minQuan = genericUtility.getColumnValueFromNode("min_quantity", currDetail);
									String remark = genericUtility.getColumnValueFromNode("remark_descr", currDetail);

									int quan = Integer.parseInt(quantity);
									if(minQuan!=null && minQuan.trim().length()>0)
									{
										minQuantity = Integer.parseInt(minQuan);
									}									//System.out.println("quanquan :::::"+quan);
									if( quan <= 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
										break;
									}
									if( quan < minQuantity && (remark==null || remark.trim().length()==0))
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","LESSQUAN",userId);
										break;
									}
									//Added by Mrunalini Sinkar for chc enhancment(End)
									String sampPlaniseItem = getSfaParmValue(userId,"SAMP_PLAN_WISE_ITEM",connectionObject);
									System.out.println("sampPlaniseItem == ["+sampPlaniseItem+"]");
									
									if(sampPlaniseItem.trim().equalsIgnoreCase("Y"))
									{
										String planValue="",consValue="";
										int planValueInt=0,consValueInt=0;
										int plannedQuantity=0;
										int consumeQuantity=0;
										int currentQuantity=0;
										String acctPrd="";
										String itemCode = checkNull(genericUtility.getColumnValueFromNode("item_code", currDetail));
										scCode = checkNull(genericUtility.getColumnValueFromNode("strg_code", currDetail));
										//String workDate = checkNull(genericUtility.getColumnValueFromNode("event_date", parentNode)).trim();
										String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2,"1" ));
										//System.out.println("VALUE OF WORKDATE IS"+workDate);
										//System.out.println("VALUE OF itemCode IS"+itemCode);
										//System.out.println("VALUE OF scCode IS"+scCode);

										//String workDate = checkNull(genericUtility.getColumnValueFromNode( "event_date" , dom1,objContext ));

										String aactPrdSql="SELECT CODE from ACCTPRD WHERE ? BETWEEN FR_DATE AND TO_DATE";
										PreparedStatement aactPrdPstmt=connectionObject.prepareStatement(aactPrdSql);
										aactPrdPstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
										ResultSet aactPrdRS=aactPrdPstmt.executeQuery();
										while(aactPrdRS.next())
										{
											acctPrd=checkNull(aactPrdRS.getString("CODE"));
										}
										if (aactPrdRS != null)
										{
											aactPrdRS.close();
											aactPrdRS = null;
										}
										if (aactPrdPstmt != null)
										{
											aactPrdPstmt.close();
											aactPrdPstmt = null;
										}

										String pspSql="SELECT SUM(SSPD.APRV_QTY) AS QUANTITY FROM  SPRS_SAMP_PLAN SSP, SPRS_SAMP_PLAN_DET SSPD " + 
												"WHERE SSP.TRAN_ID=SSPD.TRAN_ID AND SSP.SALES_PERS = ? AND SSP.ACCT_PRD = ? AND SC_CODE = ? AND ITEM_CODE = ? "
												+ " AND SSP.CONFIRMED ='Y' AND SSP.WORKFLOW_STATUS = 'A' ";
										pspPstmt=connectionObject.prepareStatement(pspSql);
										pspPstmt.setString(1, userId);
										pspPstmt.setString(2, acctPrd);
										pspPstmt.setString(3, scCode);
										pspPstmt.setString(4, itemCode);

										pspRS=pspPstmt.executeQuery();
										if(pspRS.next())
										{
											plannedQuantity=pspRS.getInt("QUANTITY");
										}
										if (pspRS != null)
										{
											pspRS.close();
											pspRS = null;
										}
										if (pspPstmt != null)
										{
											pspPstmt.close();
											pspPstmt = null;
										}			

										String darIemSql="SELECT SUM(QUANTITY) AS QUANTITY FROM STRG_MEET_ITEMS WHERE ITEM_CODE = ? AND STRG_CODE = ?" + 
												" AND DCR_ID IN (SELECT DCR_ID FROM STRG_MEET WHERE EVENT_DATE BETWEEN "
												+ "(SELECT FR_DATE FROM ACCTPRD WHERE CODE = ?) AND (SELECT TO_DATE FROM ACCTPRD WHERE CODE = ?))";
										pspPstmt=connectionObject.prepareStatement(darIemSql);
										pspPstmt.setString(1, itemCode);
										pspPstmt.setString(2, scCode);
										pspPstmt.setString(3, acctPrd);
										pspPstmt.setString(4, acctPrd);

										pspRS=pspPstmt.executeQuery();
										if(pspRS.next())
										{
											consumeQuantity=pspRS.getInt("QUANTITY");
										}
										if (pspRS != null)
										{
											pspRS.close();
											pspRS = null;
										}
										if (pspPstmt != null)
										{
											pspPstmt.close();
											pspPstmt = null;
										}
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										currentQuantity=plannedQuantity-consumeQuantity;
										//System.out.println(" sampleDescr=== ["+sampleDescr);
										//System.out.println(" currentQuantity=== ["+currentQuantity);
										//System.out.println(" plannedQuantity=== ["+plannedQuantity);
										//System.out.println(" consumeQuantity=== ["+consumeQuantity);
										//System.out.println(" quan=== ["+quan);
										if(plannedQuantity <= 0)
										{
											System.out.println("Unplanned validation.........");
											sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
											errString = itmDBAccessLocal.getErrorString("rate","UNPLANVAL",userId);
											errString = getModifiedErrorString(errString, sampleDescr);
											//break;
											if(errString.length()>0)
											{
												int indexoftype =errString.indexOf("</type>");
												String erorrTyp = (Character.toString(errString.charAt(indexoftype-1))).trim();
												if(erorrTyp.equals("W"))
												{
													String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
													errStringXml1.append(bifurErrString);
													errString = "";
												}
											}
										}
										if(plannedQuantity > 0)
										{
											if(currentQuantity < quan)
											{
												System.out.println("greater than plan quantity.........");
												sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
												errString = itmDBAccessLocal.getErrorString("rate","INSFNTQTY",userId);
												errString = getModifiedErrorString(errString, sampleDescr);
												//break;
												if(errString.length()>0)
												{
													int indexoftype =errString.indexOf("</type>");
													String erorrTyp = (Character.toString(errString.charAt(indexoftype-1))).trim();
													if(erorrTyp.equals("W"))
													{
														String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
														errStringXml1.append(bifurErrString);
														errString = "";
													}
												}
											}
										}
										if(consumeQuantity > 0)
										{
											if(currentQuantity > quan)
											{
												System.out.println("2nd time alert validation for quantity left.........");
												sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
												errString = itmDBAccessLocal.getErrorString("rate","QTYPENDING",userId);
												errString = getModifiedErrorString(errString, sampleDescr);
												//break;
												if(errString.length()>0)
												{
													int indexoftype =errString.indexOf("</type>");
													String erorrTyp = (Character.toString(errString.charAt(indexoftype-1))).trim();
													if(erorrTyp.equals("W"))
													{
														String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
														errStringXml1.append(bifurErrString);
														errString = "";
													}
												}
											}
										}
										System.out.println("ErrorString is::: ["+errString+"]");
									}
								}
								catch(NumberFormatException num)
								{
									//System.out.println("NumberFormatException occours for ");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
								}
							}
						}
						// added by rupali on 08/09/17 for applying validation on rate field [start]
						else if ( "rate".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("quantity inside is null");
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								errString = itmDBAccessLocal.getErrorString("rate","NULRATE",userId);
								break;
							}
							else
							{
								try
								{
									//String quantity = checkNull(genericUtility.getColumnValue("quantity", dom, ""+currentFormNo));
									String quantity = genericUtility.getColumnValueFromNode("rate", currDetail);
									//System.out.println("quantity inside:- "+quantity);
									int quan = Integer.parseInt(quantity);
									//System.out.println("quanquan :::::"+quan);
									if( quan < 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("rate","INVLIDRATE",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
									//	sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									//	errString = itmDBAccessLocal.getErrorString("rate","INVLDRATE",userId);
								}
							}
						}
						// added by rupali on 08/09/17 for applying validation on rate field [end]
						// added by rupali on 06/11/17 for applying validation on stock_qty and lot_no fields [start]
						else if ( "stock_qty".equalsIgnoreCase( childNodeName ) && "Y".equalsIgnoreCase(isStockInfo) )
						{
							//System.out.println("inside stock qunatity");
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								String quantity = genericUtility.getColumnValueFromNode("quantity", currDetail);
								//System.out.println("inside quantity qunatity["+quantity+"]");

								if(quantity!=null && quantity.trim().length()>0)
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									//System.out.println("inside quantity qunatity["+sampleDescr+"]");

									errString = itmDBAccessLocal.getErrorString("stock_qty","NULLSTOCK",userId);
									break;
								}

							}
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									String quantity = genericUtility.getColumnValueFromNode("stock_qty", currDetail);
									int quan = Integer.parseInt(quantity);
									if( quan < 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("stock_qty","INVLDSTOCK",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									//System.out.println("NumberFormatException occours for ");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("stock_qty","INVLDSTOCK",userId);
								}
							}
						}
						else if ( "lot_no".equalsIgnoreCase( childNodeName ) && "Y".equalsIgnoreCase(isStockInfo))
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								/*errString = itmDBAccessLocal.getErrorString("lot_no","NULLOTNUM",userId);
								break;*/
							}
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								String lotNumber = genericUtility.getColumnValueFromNode("lot_no", currDetail);
								String itemCode = genericUtility.getColumnValueFromNode("item_code", currDetail);
								int count = 0;
								String codeSql = "";
								//System.out.println("itemCode =["+itemCode+"], lotNumber = ["+lotNumber+"]");
								codeSql = "SELECT COUNT(*) AS COUNT FROM ITEM_LOT_INFO WHERE LOT_NO = ? AND ITEM_CODE = ?";
								pstmt = connectionObject.prepareStatement(codeSql);
								pstmt.setString(1,lotNumber);
								pstmt.setString(2,itemCode);
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("COUNT");
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									//System.out.println("INVALID lot_no::");
									errString = itmDBAccessLocal.getErrorString("lot_no","INVLOTNUM",userId);
									break;
								}
							}
						}
						// added by rupali on 06/11/17 for applying validation on stock_qty and lot_no fields [end]
						// added by rupali on 27/12/17 for applying validation on stock_info field in order form [start]
						else if ( "stock_info".equalsIgnoreCase( childNodeName ) && "Y".equalsIgnoreCase(isStockInfo))
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								String stockInfo = genericUtility.getColumnValueFromNode("stock_info", currDetail);
								String itemCode = genericUtility.getColumnValueFromNode("item_code", currDetail);
								//System.out.println("itemCode =["+itemCode+"], stockInfo = ["+stockInfo+"]");
								if("{\"name\":\"stock_info|stock|expiry_date\", \"disp_name\":\"Batch No.|Stock|Expiry\", \"type\":\"text|number|text\", \"protect\":\"0|0|1\", \"1\":\"||\"}".equals(stockInfo))
								{
									errString = itmDBAccessLocal.getErrorString("stock_info","BLNKSTKINF",userId);
									break;
								}
								else
								{
									JSONObject jsonData = new JSONObject(stockInfo);
									Iterator<String> jsonKeys = jsonData.keys();
									String jsonKey = "";
									int totalStock = 0;
									while (jsonKeys.hasNext())
									{
										jsonKey = jsonKeys.next();
										if(!("name".equals(jsonKey) ||"disp_name".equals(jsonKey) || "type".equals(jsonKey) || "protect".equals(jsonKey)))
										{
											int count = 0;
											String jsonValue = jsonData.getString(jsonKey);
											String batchCode = jsonValue.substring(0,jsonValue.indexOf("|"));
											if(batchCode.trim().length() == 0)
											{
												//System.out.println("Blank lot_no::");
												errString = itmDBAccessLocal.getErrorString("lot_no","BLNKLOTNUM",userId);
												break;
											}
											else
											{
												String codeSql = "SELECT COUNT(*) AS COUNT FROM ITEM_LOT_INFO WHERE LOT_NO = ? AND ITEM_CODE = ?";
												pstmt = connectionObject.prepareStatement(codeSql);
												pstmt.setString(1,batchCode);
												pstmt.setString(2,itemCode);
												rSet = pstmt.executeQuery();
												if(rSet.next())
												{
													count = rSet.getInt("COUNT");
												}
												if (rSet != null)
												{
													rSet.close();
													rSet = null;
												}
												if (pstmt != null)
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													//System.out.println("INVALID lot_no::");
													errString = itmDBAccessLocal.getErrorString("lot_no","INVLOTNUM",userId);
													break;
												}
											}
										}
									}

								}
							}
						}
						// added by rupali on 27/12/17 for applying validation on stock_info field in order form [end]
						else if(childNodeName.equalsIgnoreCase("promo_code"))
						{
							// added by Niraj on 10/12/17 for applying validation on promo_code field [start]
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								String promoCode = checkNull(genericUtility.getColumnValueFromNode("promo_code", currDetail));
								String itemCode = checkNull(genericUtility.getColumnValueFromNode("item_code", currDetail));
								scCode = checkNull(genericUtility.getColumnValueFromNode("strg_code", currDetail));
								String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2));
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								//System.out.println("eventDate:::"+eventDate);
								String promocodeSql = "";
								int cnt = 0;

								promocodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST " +
										"PM ON ITEM.ITEM_CODE = PM.ITEM_CODE LEFT OUTER JOIN SCHEME_APPLICABILITY SA ON (ITEM.ITEM_CODE = SA.ITEM_CODE OR SA.PROD_SCH='Y'), " +
										"BOM B, SCHEME_APPLICABILITY_DET SAD WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
										"AND SA.SCHEME_CODE = B.BOM_CODE AND SA.SCHEME_CODE = SAD.SCHEME_CODE AND SA.APP_FROM<= ? AND SA.VALID_UPTO>= ? " +
										"AND SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND (SAD.SITE_CODE= ? OR SAD.STATE_CODE= S.STATE_CODE " +
										"OR SAD.COUNT_CODE = S.COUNT_CODE) AND SC.SC_CODE= ? AND ITEM.ITEM_CODE = ? AND SA.SCHEME_CODE = ? ";

								pstmt = connectionObject.prepareStatement(promocodeSql);
								pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setString(3, siteCode);
								pstmt.setString(4, scCode);
								pstmt.setString(5, itemCode);
								pstmt.setString(6, promoCode);
								ResultSet rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(cnt == 0)
								{
									//System.out.println( "scheme not available for this item" );
									errString = itmDBAccessLocal.getErrorString( "promo_code" , "SCHMNOTAVL" , userId );
									break;
								}
							}
							// added by Niraj on 10/12/17 for applying validation on promo_code field [end]
						}

						// added by mrunalini sinkar for dicount and promo_perc validation(start)
						else if ( "disc_perc".equalsIgnoreCase( childNodeName ) )
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									String quantity = genericUtility.getColumnValueFromNode("disc_perc", currDetail);
									double quan = Double.parseDouble(quantity);
									//System.out.println("disc_perc :::::"+quan);
									if( quan > 100 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("disc_perc","INVALDDISC",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									//System.out.println("NumberFormatException occours for ");
									//	sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									//	errString = itmDBAccessLocal.getErrorString("rate","INVLDRATE",userId);
								}
							}
						}
						else if ( "promo_perc".equalsIgnoreCase( childNodeName ) )
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									String quantity = genericUtility.getColumnValueFromNode("promo_perc", currDetail);
									double quan = Double.parseDouble(quantity);
									//System.out.println("promo_perc :::::"+quan);
									if( quan > 100 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("promo_perc","INVALSCHEM",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									//System.out.println("NumberFormatException occours for ");
									//	sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									//	errString = itmDBAccessLocal.getErrorString("rate","INVLDRATE",userId);
								}
							}
						}
						// added by mrunalini sinkar for dicount and promo_perc validation(end)
						//added by Bhagyashri T on [21/08/21][start] for focus_devi_reas validation
						else if ( "focus_devi_reas".equalsIgnoreCase( childNodeName ) )
						{
							//System.out.println("Focus Dev reason Field Before strgMeet");
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								System.out.println("Focus Dev reason inside is null");
							}
							else
							{
								//System.out.println("Focus Dev reason Field after strgmeet");
								String focusDeviRes = genericUtility.getColumnValueFromNode("focus_devi_reas", currDetail);
								String remarksRes = genericUtility.getColumnValueFromNode("remarks_ord", currDetail);
								//System.out.println("focusDeviRes inside strgMeet:- "+focusDeviRes);
								//System.out.println("remarksRes inside strgMeet:- "+remarksRes);
								if(("6".equalsIgnoreCase(focusDeviRes))  && (remarksRes==null || remarksRes.trim().length()==0))
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("focus_devi_reas","FOCRESMAN",userId);
									break;
								}
							}
						}
						//added by Bhagyashri T on [21/08/21][end] for focus_devi_reas validation
						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{
							updateFlagCnt++;
						}
					}
					if(errString == null || errString.trim().length() == 0)
					{
						if(MaxItemAllow!=null && MaxItemAllow.trim().length()>0 && parentNodeListLength > itemAllow )
						{
							errString = itmDBAccessLocal.getErrorString("item_code","NOMORESEL",userId);
						}
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				if(errString != null && errString.trim().length() > 0)
				{
					if("sampleitem".equalsIgnoreCase(formName) || "retailersampleitem".equalsIgnoreCase(formName) || "stockistsampleitem".equalsIgnoreCase(formName) || "ncwsampleitem".equalsIgnoreCase(formName))
					{
						sampleDescr =  " Promo Material for "+sampleDescr;
						//System.out.println("sampleDescr =["+sampleDescr+"]");
						errString = getModifiedErrorString(errString, sampleDescr);
					}
					else
					{
						//System.out.println("sampleDescr =["+sampleDescr+"]");
						errString = getModifiedErrorString(errString, sampleDescr);
					}
				}
			}
			else if("brand".equalsIgnoreCase(formName) || "retailerbrand".equalsIgnoreCase(formName) || "stockistbrand".equalsIgnoreCase(formName) || "ncwbrand".equalsIgnoreCase(formName))
			{
				//Added by mrunalini sinkar on 12-jan-2022 Start
				String isFormMandatory = checkNull(getSfaParmValue(userId, "IS_FORM_MANDATORY", connectionObject));
				String sfaparmBrand = checkNull(getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", connectionObject));

				String [] temp = isFormMandatory.split(",");
				List<String> parmNamelist = new ArrayList<String>();

				for(int i = 0 ;i < temp.length;i++)
				{
					if(!parmNamelist.contains(temp[i]) )
					{
						parmNamelist.add(temp[i]);
					}
				}
				//Added by mrunalini sinkar on 12-jan-2022 End
				
				
				int selectedFlagCnt = 0;
				
				int updateFlagCnt = 0;
				//Added by Mrunalini Sinkar For 05-May-2021 Fortune server start
				//Added by Mrunalini Sinkar For 05-May-2021 Fortune End
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//Added by mrunalini sinkar on 12-jan-2022 Start
				if(parmNamelist.contains(formName) && "Y".equalsIgnoreCase(sfaparmBrand))
				{
					if(parentNodeListLength == 0)
					{
						errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
					}
				}
				//Added by mrunalini sinkar on 12-jan-2022 End

				String brandDescr = "";
				int setSize=0;//added by mrunalini sinkar on 26-july-2017
				int listsize=0;
				HashSet hashset = new HashSet();//added by mrunalini sinkar on 26-july-2017
				ArrayList list = new ArrayList();

				int brandCnt=0;
				String Sql="SELECT COUNT(*) AS COUNT FROM BRAND BR , SALES_PERS SP WHERE BR.ITEM_SER = SP.ITEM_SER AND SP.SALES_PERS=?";
				pstmt=connectionObject.prepareStatement(Sql);
				pstmt.setString(1, userId);
				rSet=pstmt.executeQuery();
				if(rSet.next())
				{
					brandCnt = rSet.getInt("COUNT");
				}
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";
					brandDescr = "";
					boolean flg=true;
					
					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						else if ( "pitch_sequence".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								
								if("Y".equalsIgnoreCase(sfaparmBrand))//Added by Mrunalini Sinkar For 05-May-2021 Fortune
								{
									System.out.println("pitchsequence not mandatory");
								}
								else
								{
									brandDescr = genericUtility.getColumnValueFromNode("brand_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("pitch_sequence","INVPITCH",userId);
									break;
								}
							}
							else
							{
								try
								{
									//String quantity = checkNull(genericUtility.getColumnValue("pitch_sequence", dom, ""+currentFormNo));
									String quantity = genericUtility.getColumnValueFromNode("pitch_sequence", currDetail);
									System.out.println("pitch_sequence inside:- "+quantity);
									int quan = Integer.parseInt(quantity);
									////added by mrunalini sinkar on 26-july-2017
									if(quantity!=null && quantity.trim().length()>0)
									{
										list.add(quan);
									}
									if(quantity!=null && quantity.trim().length()>0)
									{
										hashset.add(quan);
									}
									if( quan <= 0 )
									{
										brandDescr = genericUtility.getColumnValueFromNode("brand_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("pitch_sequence","INVPITCH",userId);
										break;
									}

									if(quan > brandCnt)
									{
										//System.out.println("insidecondition");
										brandDescr = genericUtility.getColumnValueFromNode("brand_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("pitch_sequence","ACOIGTNUMB",userId);
										break;
									}

									
									//added by mrunalini sinkar  to throw error if actual order greater than total number of brand on 26-july-2017(end)

								}
								catch(NumberFormatException num)
								{
									//System.out.println("NumberFormatException occurs..");
									brandDescr = genericUtility.getColumnValueFromNode("brand_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("pitch_sequence","INVPITCH",userId);
									break;
								}
							}
						}
						//Added By Mrunalini S on 05-May-2021 for fortune Server(Start)
						else if(childNodeName.equalsIgnoreCase("pitch_detail"))
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if("Y".equalsIgnoreCase(sfaparmBrand))
								{
									brandDescr = genericUtility.getColumnValueFromNode("brand_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("pitch_detail","NULLPITCDT",userId);
									break;
								}
							}
							else
							{
								objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
								String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));

								String brandStrgCode =checkNull(genericUtility.getColumnValueFromNode("strg_code", currDetail));

								String pitchDetail =checkNull(genericUtility.getColumnValueFromNode("pitch_detail", currDetail));
								String meetinStatus=checkNull(getParentMeetingStatus(dom2,parentFormNo,brandStrgCode,"Y",connectionObject));

								int count=0;
								System.out.println("currentFormNo pitch_detail::["+pitchDetail+"]");
								System.out.println("currentFormNo meetinStatus::["+meetinStatus+"]");
								String pitchCatSql = "SELECT COUNT(*) COUNT FROM GENCODES WHERE FLD_NAME = 'PITCH_DETAIL' AND MOD_NAME = 'W_WSFA_FORTUNE' " +
										"AND ACTIVE = 'Y' AND FLD_VALUE= ? AND TRIM(UPPER(UDF_STR1)) = ?";
								pstmt = connectionObject.prepareStatement(pitchCatSql);
								pstmt.setString(1, pitchDetail);
								pstmt.setString(2, meetinStatus.toUpperCase());
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("COUNT");
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								System.out.println("pitch_detail currentFormNo count::["+count+"]");
									if(count == 0)
									{
										System.out.println("Inside pitch_detail Invalid ");
										errString = getErrorString("pitch_detail","INVPTCHCAT",userId);
										break;
									}
								
							
							}
						}
						//Added By Mrunalini S on 05-May-2021 for fortune Server(End)

						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{							
							updateFlagCnt++;
						}
						//Added by mrunalini sinkar on 12-jan-2022 Start
						if(!updateFlag.equalsIgnoreCase("D"))
						{
							childNode = childList.item(ctr);
							if(childNode.getFirstChild() != null)
							{
								flg=false;
							}

						}
						//Added by mrunalini sinkar on 12-jan-2022 End
					}
					//Added by mrunalini sinkar on 12-jan-2022 Start			 
					if(parmNamelist.contains(formName) && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
					{
						errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
					}
					//Added by mrunalini sinkar on 12-jan-2022 End
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				if(errString != null && errString.trim().length() > 0)
				{
					errString = getModifiedErrorString(errString, brandDescr);
				}
				//added by mrunalini sinkar if duplicate actual order then throw validation on 26-july-2017(start)
				if(hashset!=null)
				{
					setSize = hashset.size();
				}
				if(list!=null)
				{
					listsize = list.size();
				}
				if(setSize < listsize)
				{
					errString = itmDBAccessLocal.getErrorString("quantity","DUPAOFOND",userId);
				}
				//added by mrunalini sinkar if duplicate actual order then throw validation on 26-july-2017(end)


			}
			// added by rupali on 12/09/18 for adding survey subform in DAR [start]
			else if("survey".equalsIgnoreCase(formName) || "retailersurvey".equalsIgnoreCase(formName) || "stockistsurvey".equalsIgnoreCase(formName) || "ncwsurvey".equalsIgnoreCase(formName))
			{
				// added by rupali on 16/07/19 to validate survey question [start]
				String surveyDescr = "", surveyCode = "";
				ArrayList surveyList = new ArrayList();
				ArrayList custTypeList = new ArrayList();

				String objectName = checkNull(getObjNameFromDom(dom2, "objName",1));

				String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objectName, connectionObject ));

				String surveyTemplate=getSelectedRowValue(dom2, parentFormNo, "survey_templ", 0);
				String strgType=getSelectedRowValue(dom2, parentFormNo, "strg_type", 0);

				String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2));
				String sfaParmVal  = getSfaParmValue(userId,"CHC_SURVEY",connectionObject);
				// added by rupali on 16/07/19 to validate survey question [end]

				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
                int parentNodeListLength = parentList.getLength();
                
                String minRange = "" ;
                String maxRange = "" ;
                String result1 = "";
                String result3 = "";

                System.out.println("Inside minimum range :::"+minRange);
                System.out.println("Inside maximum range :::"+maxRange);
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectBox = "";
					String updateFlag = "";
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						if(childNodeName.equalsIgnoreCase("strg_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString( "strg_code" , "NULSTRGCD" , userId );
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("survey_code"))
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVCD",userId);
								break;
							}
							// added by rupali on 16/07/19 to validate survey question [start]
							else
							{
								surveyCode = checkNull(genericUtility.getColumnValueFromNode("survey_code", parentNode));
								surveyDescr = checkNull(genericUtility.getColumnValueFromNode("survey_descr", parentNode));
								surveyList.add(surveyCode);
							}
							// added by rupali on 16/07/19 to validate survey question [end]
						}
						else if(childNodeName.equalsIgnoreCase("result1") || childNodeName.equalsIgnoreCase("result2") || childNodeName.equalsIgnoreCase("result3"))
						{
							String resultType = genericUtility.getColumnValueFromNode("result_type", parentNode);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if((childNodeName.equalsIgnoreCase("result1") && (resultType.equalsIgnoreCase("N"))) || (childNodeName.equalsIgnoreCase("result3") && (resultType.equalsIgnoreCase("T")))
										|| (childNodeName.equalsIgnoreCase("result2") && (resultType.equalsIgnoreCase("D") || resultType.equalsIgnoreCase("L"))))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVRES",userId);
									break;
								}
                            }
                            else
                            {
                                result1 = genericUtility.getColumnValueFromNode("result1", parentNode);
                                result3 = genericUtility.getColumnValueFromNode("result3", parentNode);
                            }
						}
						else if(childNodeName.equalsIgnoreCase("doc_id_2"))
						{
							String attachOPT = checkNull(genericUtility.getColumnValueFromNode("attach_opt", parentNode));
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if("1".equalsIgnoreCase(attachOPT))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULLATTACH",userId);
									break;

								}
							}
                        }
                        else if(childNodeName.equalsIgnoreCase("result_range_min"))
                        {
                            minRange = checkNull(genericUtility.getColumnValueFromNode("result_range_min", parentNode)); 

                       
                        }
                        else if(childNodeName.equalsIgnoreCase("result_range_max"))
                        {
                            maxRange = checkNull(genericUtility.getColumnValueFromNode("result_range_max", parentNode)); 
                           
                        }
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
                    }
                    try
                    {
                    int minRangeValue = 0;
                    int maxRangeValue = 0;
                    if( !minRange.equals("") || !maxRange.equals("")) 
                    {
                        minRangeValue = Integer.parseInt(minRange);
                        maxRangeValue = Integer.parseInt(maxRange);
                    }
                    System.out.println("MinRangeValue:::"+minRangeValue);
                    System.out.println("MaxRangeVallue:::"+maxRangeValue);
                    System.out.println("Result1:::"+result1);
                    System.out.println("Result3:::"+result3);

                    if(  maxRangeValue > 0 || minRangeValue > 0 )
		                {
		                    if( minRangeValue > 0 )
		                    {
		                       
		                            if(result1 != null && result1.length() > 0)
		                            {
		                                if(minRangeValue > result1.length())
		                                {
		                                   
                                            errString = itmDBAccessLocal.getErrorString("result_range_min","MINLENGTH",userId);
									        break;
		                                }
		                            }
		                            if(result3 != null && result3.length() > 0)
		                            {
		                                if(minRangeValue > result3.length())
		                                {
		                                    errString = itmDBAccessLocal.getErrorString("result_range_min","MINLENGTH",userId);
									        break;
		                                }
		                            }		
                            }
                            if( maxRangeValue > 0 )
		                    {
		                       
		                            if(result1 != null && result1.length() > 0)
		                            {
		                                if( maxRangeValue < result1.length())
		                                {
		                                 	
                                          errString = itmDBAccessLocal.getErrorString("result_range_max","MAXLENGTH",userId);
									        break;                                 
		                                }
		                            }
		                            if(result3 != null && result3.length() > 0)
		                            {
		                                if( maxRangeValue < result3.length())
		                                {
		                                  
                                           errString = itmDBAccessLocal.getErrorString("result_range_max","MAXLENGTH",userId);
									        break;                                  
		                                }
		                            }		
		                    }
					    }

                    }
                    catch(Exception e)
                    {
                        System.out.println(e);
                    }
                    
				}
				custTypeList=getTemplateSurvey(connectionObject, userId);
				if(errString == null || errString.trim().length() == 0)
				{
					if(custTypeList.contains(strgType)  && parentNodeListLength > 0)
					{
						String surveySql = "SELECT B.SURVEY_CODE SURVEY_CODE, C.DESCR SURVEY_DESCR,C.MANDATORY FROM SURVEY_TEMPLATE A, SURVEY_TEMPL_DET B, SURVEY_MASTER C, SURVEY_GROUP G " +
								"WHERE A.SURVEY_TEMPL = B.SURVEY_TEMPL AND C.SURVEY_GROUP = G.SURVEY_GROUP AND A.SURVEY_TEMPL IN(SELECT SURVEY_TEMPL FROM SURVEY_TEMPLATE " +
								"WHERE SURVEY_TEMPL = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO AND CONFIRMED ='Y') AND B.SURVEY_CODE = C.SURVEY_CODE " +
								"AND C.ACTIVE='Y' AND C.MANDATORY = 'Y'";
						PreparedStatement pstmtSurvey =  connectionObject.prepareStatement(surveySql);
						pstmtSurvey.setString(1,surveyTemplate);
						pstmtSurvey.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
						ResultSet rsSurvey = pstmtSurvey.executeQuery();
						while (rsSurvey.next())
						{
							surveyCode = checkNull(rsSurvey.getString("SURVEY_CODE"));
							surveyDescr = checkNull(rsSurvey.getString("SURVEY_DESCR"));
							if(!surveyList.contains(surveyCode))
							{
								errString = itmDBAccessLocal.getErrorString("survey_code","SURVENTSEL",userId);
								break;
							}
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
						if (rsSurvey!= null)
						{
							rsSurvey.close();
							rsSurvey = null;
						}
						if(pstmtSurvey!=null)
						{
							pstmtSurvey.close();
							pstmtSurvey = null;
						}
						//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
						if(errString != null && errString.trim().length() > 0)
						{
							errString = getModifiedErrorString(errString, surveyDescr);
						}
					}
				}

			}
			// added by rupali on 12/09/18 for adding survey subform in DAR [end]
			//added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(start)
			else if("display".equalsIgnoreCase(formName) || "retailerdisplay".equalsIgnoreCase(formName) || "stockistdisplay".equalsIgnoreCase(formName) || "ncwdisplay".equalsIgnoreCase(formName))
			{
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectBox = "";
					String updateFlag = "";
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						//Changed by Niraj s on 14-Dec-2018 for validation to change Item_code to brand_code in display form(start)
						if(childNodeName.equalsIgnoreCase("brand_code"))
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								int count = 0;
								String brandCode = checkNull((genericUtility.getColumnValue("brand_code", dom1, objContext)));
								String brandSql="SELECT COUNT(*) AS COUNT FROM BRAND WHERE BRAND_CODE=?";
								PreparedStatement itmPstmt= connectionObject.prepareStatement(brandSql);
								itmPstmt.setString(1, columnValue);
								ResultSet rs = itmPstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (itmPstmt != null)
								{
									itmPstmt.close();
									itmPstmt = null;
								}
								//System.out.println("count is :["+count+"]");

								if(count == 0)
								{
									errString = itmDBAccessLocal.getErrorString("brand_code","INVBRNCD",userId);
									break;
								}

							}


						}
						//Changed by Niraj s on 14-Dec-2018 for validation to change Item_code to brand_code in display form(start)
					}
				}
			}
			//added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(end)
			//Added by bhagyashri T for Validation on Invoice subform[20/09/2022][start]
			else if("invoice".equalsIgnoreCase(formName) || "retailerinvoice".equalsIgnoreCase(formName) || "stockistinvoice".equalsIgnoreCase(formName) || "ncwinvoice".equalsIgnoreCase(formName))
			{

				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				int itemAllow=0;
				String sampleDescr = "";
				
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				System.out.println("inside done invoice parentNodeListLength:"+parentNodeListLength);
				
				//added by prachi on 22-sep-22 [W22FBAS008] start
				System.out.println("line no 1012828 errString:"+errString);
				if(parentNodeListLength==0)
	            {
	               System.out.println("line 101245");
	               errString = darCommonBean.darCollectionPosSave(dom, connectionObject, ""+currentFormNo, formName, userId);
	            }//end
				
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";
					sampleDescr = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						System.out.println("invoice childNodeName:"+childNodeName);
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						else if ( "quantity".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
								break;
							}
							else
							{
								try
								{
									String quantity = genericUtility.getColumnValueFromNode("quantity", currDetail);
									String currStock = genericUtility.getColumnValueFromNode("curr_stock", currDetail);
									int quan = Integer.parseInt(quantity);
									int stock =0;
									if(currStock!=null && currStock.trim().length()>0)
									{
										stock = Integer.parseInt(currStock);

									}
									if( quan <= 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
										break;
									}
									if(quan > stock)
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","LARGEQUAN",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
								}
							}
						}
						else if ( "rate".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								errString = itmDBAccessLocal.getErrorString("rate","NULRATE",userId);
								break;
							}
							else
							{
								try
								{
									String quantity = genericUtility.getColumnValueFromNode("rate", currDetail);
									int quan = Integer.parseInt(quantity);
									if( quan <= 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("rate","INVLIDRATE",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
								}
							}
						}
						else if ( "curr_stock".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								String currStock = genericUtility.getColumnValueFromNode("curr_stock", currDetail);

								if(currStock == null && currStock.trim().length()<=0) 
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("curr_stock","NULLSTOCK",userId);
									break;
								}
								
							}
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									String currStock = genericUtility.getColumnValueFromNode("curr_stock", currDetail);
									int quan = Integer.parseInt(currStock);
									if( quan < 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("curr_stock","INVLDSTOCK",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for stock");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("curr_stock","INVLDSTOCK",userId);
								}
							}
						}
						
						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{
							updateFlagCnt++;
						}
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				if(errString != null && errString.trim().length() > 0)
				{
					errString = getModifiedErrorString(errString, sampleDescr);
				}
			}
			//Added y bhagayshri T For Validation of Invoice in MR DAR[20/09/2022][end]
			
			// Added by Jay for giving validation on Amount selected in collection form [27-09-2022]- start
			//added by prachi on 22-sep-22 [W22FBAS008]
			else if("collection".equalsIgnoreCase(formName) || "collectionNcw".equalsIgnoreCase(formName) || "collectionRetailer".equalsIgnoreCase(formName) || "collectionStockist".equalsIgnoreCase(formName))
			{
               errString = darCommonBean.collectionValidate(dom, currentFormNo, xtraParams, connectionObject);
               System.out.println("errString:::::["+errString+"]");
               
               if(errString==null || errString.trim().length()==0)
               {
            	   errString = darCommonBean.darCollectionPosSave(dom, connectionObject, ""+currentFormNo, formName, userId);
               }
               
               return errString;
			}
			//added by prachi on 22-sep-22 [W22FBAS008] end
			
			if(errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
			{
				if( errString.length() > 0 )
				{
					String msgDescr = "";
					//msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;
					msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + customerName ;
					if(errString.contains("UNLSTNTALW"))
					{
						String strData = msgDescr.substring( msgDescr.indexOf("having")+("having").length(), msgDescr.indexOf("customers"));
						msgDescr = msgDescr.replace(strData, " "+totAllwCallList+" ");
					}
					if( customerName.length() != 0 && !customerName.equalsIgnoreCase("") )
					{
						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
					}
				}
				else if( errString1.length() > 0 )
				{
					errString = errString1;
				}

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			copyLogFile();//Gulzar 16/11/12
			//Changed By Gaurav Singh on 16/09/09[ W15BMIT002 | to catch exception and send errorstring] Start
			errString = "";

			errString = genericUtility.createErrorString( e ) ;
			String messageValue="",message = "";

			if( errString.indexOf("<Errors>")!=-1 )
			{
				if( errString.length() > 0 )
				{
					String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
					messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
					String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
					message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

					System.out.println("errorMessage==>"+messageValue);
					StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
					valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
					valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
					valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
					valueXmlErrorString.append("<type>E</type>\r\n");
					valueXmlErrorString.append("<option></option>\r\n");
					valueXmlErrorString.append("<time></time>\r\n");
					valueXmlErrorString.append("<alarm></alarm>\r\n");
					valueXmlErrorString.append("<source></source>\r\n");
					valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
					valueXmlErrorString.append("<redirect>1</redirect>\r\n");
					valueXmlErrorString.append("</error>\r\n");
					valueXmlErrorString.append("</Errors>\r\n");
					valueXmlErrorString.append("</Header>\r\n");
					valueXmlErrorString.append( "</Root>\r\n" );
					System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
					errString =valueXmlErrorString.toString();
				}

			}
		}
		finally
		{
			try
			{
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				//System.out.println( "Exception :StrgMeetDCRWiz :defaultDataWiz :==>\n"+e.getMessage());
				errString = "";

				errString = genericUtility.createErrorString( e ) ;
				//System.out.println( "errString :Dipak:" +errString + ":" );
				String messageValue="",message = "";

				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
						messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
						String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
						message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

						//System.out.println("errorMessage==>"+messageValue);
						StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
						valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
						valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
						valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
						valueXmlErrorString.append("<type>E</type>\r\n");
						valueXmlErrorString.append("<option></option>\r\n");
						valueXmlErrorString.append("<time></time>\r\n");
						valueXmlErrorString.append("<alarm></alarm>\r\n");
						valueXmlErrorString.append("<source></source>\r\n");
						valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
						valueXmlErrorString.append("<redirect>1</redirect>\r\n");
						valueXmlErrorString.append("</error>\r\n");
						valueXmlErrorString.append("</Errors>\r\n");
						valueXmlErrorString.append("</Header>\r\n");
						valueXmlErrorString.append( "</Root>\r\n" );
						//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
						errString =valueXmlErrorString.toString();

					}
				}
			}
		}
		if ( errString.length() <= 0)
		{
			errStringXml1.append("</Errors></Root>\r\n");
			//return errString;
			errorString2 = errStringXml1.toString();
			System.out.println("errorString2 ==== "+errorString2);
			Document responseDom = genericUtility.parseString( errorString2 );
			Node errorsNode = responseDom.getElementsByTagName( "Errors" ).item( 0 );
			System.out.println("errNode is::"+errorsNode);
			if( errorsNode != null )
			{
				NodeList errorChildNodeList = errorsNode.getChildNodes();
				for(int appCnt = 0; appCnt < errorChildNodeList.getLength(); appCnt++)
				{
					Node currChild = errorChildNodeList.item(appCnt);
					if (currChild.getNodeName().equalsIgnoreCase("error"))
					{
						errString = errStringXml1.toString();
						break;
					}
					else
					{
						errString =  "";

					}
				}
			}
		}
		//System.out.println("errString ["+errString+"]");
		return errString;
	}

	// For Previous action
	public String wfValOnPrevious(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			System.out.println("wfValData:xmlStringaaaaaaaa ["+xmlString+"]");
			System.out.println("wfValData:xmlString1bbbbbb["+xmlString1+"]");
			System.out.println("wfValData:xmlString2cccccccc["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValOnPrevious(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgMeetDCRWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	// For Previous action
	public String wfValOnPrevious(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String errString = "";

		int currentFormNo = 0;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		int noOfChilds = 0;
		try
		{
			connectionObject = getConnection();
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			userId = getEmpCode(userId, connectionObject);
			//System.out.println("wfValOnPrevious call valdata");
			//System.out.println("wfValOnPrevious objContext   ["+objContext+"]");

			//0- Don't allow if created from real time reporting, 1-Always Allow, 2-Never allow.
			String allowEditPlace = "0",allowEditCust = "0";
			allowEditPlace = getSfaParmValue(userId,"ALLOW_EDIT_PLACE_DCR",connectionObject);
			allowEditCust = getSfaParmValue(userId,"ALLOW_EDIT_CUST_DCR",connectionObject);
			//System.out.println("allowEditPlace:::"+allowEditPlace+"  allowEditCust:::"+allowEditCust);

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
			String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
			String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
			if("doctor".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				ArrayList drVisitList = new ArrayList();
				//System.out.println("doctor : validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}
				String isDocMan = checkNull(getSfaParmValue(userId,"DOCTOR_MANDATORY",connectionObject));

				//System.out.println("selectedFlagCnt [case ] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0 && "Y".equalsIgnoreCase(isDocMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				drVisitList = getSelCustList(dom2, locFormNo, "dr_visit");
				//System.out.println("drVisitList drVisitList"+drVisitList);
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isDocMan))
				{
					String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, locFormNo));
					if(dcrId.length() > 0 )
					{
						String drVisitval = "Y";
						if(drVisitList.contains(drVisitval))
						{
							errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELNCW", userId );
						}
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									//System.out.println("Value of updateFlag flag is in case retailer:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case retailer:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}
							if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
									//break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							else if(formName.equalsIgnoreCase("doctor"))
							{/*
								objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
								locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
								mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
								String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
								String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom, docFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom, docFormNo, "meet_summ", prntCtr));
									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									String teamFormNo = subFormsMap.get("team");
									String displayFormNo = subFormsMap.get("display");
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}

								}
							 */}
							else if(childNodeName.equalsIgnoreCase("strg_code"))
							{
								/*String isDrVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom2, "3"));
								System.out.println("dr_visit dfs:- "+isDrVisit+"::columnValue:"+columnValue);
								if("Y".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() <= 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NODOCVISEL", userId );
									break;
								}*/
								/*else if("N".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELDOCT", userId );
									break;
								}*/
							}
						}

					}
				}
			}

			if("retailer".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				ArrayList chemVisitList = new ArrayList();
				//System.out.println("Case retailer : validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						/*if(childNodeName.equalsIgnoreCase("dr_visit"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{

								drVisitList.add(checkNull(columnValue));
							}
						}*/
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}
				String isChemMan = checkNull(getSfaParmValue(userId,"RETAILER_MANDATORY",connectionObject));

				//System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0 && "Y".equalsIgnoreCase(isChemMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				chemVisitList = getSelCustList(dom2, locFormNo, "chem_visit");
				//System.out.println("drVisitList drVisitList"+chemVisitList);
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isChemMan))
				{
					String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, locFormNo));
					if(dcrId.length() > 0 )
					{
						String chemVisitval = "Y";
						if(chemVisitList.contains(chemVisitval))
						{
							errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELNCW", userId );
						}
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									//System.out.println("Value of updateFlag flag is in case retailer- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case 4:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}
							if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
									//break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							else if(formName.equalsIgnoreCase("retailer"))
							{/*
								objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
								 locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
								 mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
								String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom, docFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom, docFormNo, "meet_summ", prntCtr));
									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									String teamFormNo = subFormsMap.get("team");
									String displayFormNo = subFormsMap.get("display");
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}

								}
							 */}
							else if(childNodeName.equalsIgnoreCase("strg_code"))
							{
								/*String isDrVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom2, "3"));
								System.out.println("dr_visit dfs:- "+isDrVisit+"::columnValue:"+columnValue);
								if("Y".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() <= 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NODOCVISEL", userId );
									break;
								}*/
								/*else if("N".equalsIgnoreCase(isDrVisit) && checkNull(columnValue).length() > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELDOCT", userId );
									break;
								}*/
							}
						}

					}
				}
			}
			// Added by Mrunalini Sinkar on 08-may-2017 for Stockist form validation(start)
			if("stockist".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				ArrayList stockistVisitList = new ArrayList();
				//System.out.println("doctor : validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}
				String isStockMan = checkNull(getSfaParmValue(userId,"STOCKIST_MANDATORY",connectionObject));

				//System.out.println("selectedFlagCnt [case ] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0 && "Y".equalsIgnoreCase(isStockMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				stockistVisitList = getSelCustList(dom2, locFormNo, "stockist_visit");
				//System.out.println("drVisitList drVisitList"+drVisitList);
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isStockMan))
				{
					String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, locFormNo));
					if(dcrId.length() > 0 )
					{
						String stockistVisitval = "Y";
						if(stockistVisitList.contains(stockistVisitval))
						{
							errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELNCW", userId );
						}
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									//System.out.println("Value of updateFlag flag is in case retailer:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case retailer:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}
							if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
									//break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}

						}

					}
				}
			}
			// Added by Mrunalini Sinkar on 08-may-2017 for Stockist form validation(end)

			// Added by Prathmesh Jangam on 08-may-2017 for ncw form validation(start)
			if("ncw".equalsIgnoreCase(formName))
			{
				String CheckUpdateFlag = "";
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				ArrayList ncwVisitList = new ArrayList();
				//System.out.println("doctor : validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				//System.out.println("selectedFlagCnt [case ] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				ncwVisitList = getSelCustList(dom2, locFormNo, "other_visit");
				//System.out.println("drVisitList drVisitList"+drVisitList);
				if(selectedFlagCnt == 0 )
				{
					String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, locFormNo));
					if(dcrId.length() > 0 )
					{
						String ncwVisitval = "Y";
						if(ncwVisitList.contains(ncwVisitval))
						{
							errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELNCW", userId );
						}
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									//System.out.println("Value of updateFlag flag is in case retailer:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case retailer:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("locality_code","DESELCUSTM",userId);
								break;
							}
							if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
									//break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}

						}

					}
				}
			}
			// Added by Prathmesh Jangam on 08-may-2017 for ncw form validation(end)


		}
		catch(Exception e)
		{
			e.printStackTrace();
			copyLogFile();//Gulzar 16/11/12
			//Changed By Gaurav Singh on 16/09/09[ W15BMIT002 | to catch exception and send errorstring] Start
			errString = "";

			errString = genericUtility.createErrorString( e ) ;
			String messageValue="",message = "";

			if( errString.indexOf("<Errors>")!=-1 )
			{
				if( errString.length() > 0 )
				{
					String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
					messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
					String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
					message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

					//System.out.println("errorMessage==>"+messageValue);
					StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
					valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
					valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
					valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
					valueXmlErrorString.append("<type>E</type>\r\n");
					valueXmlErrorString.append("<option></option>\r\n");
					valueXmlErrorString.append("<time></time>\r\n");
					valueXmlErrorString.append("<alarm></alarm>\r\n");
					valueXmlErrorString.append("<source></source>\r\n");
					valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
					valueXmlErrorString.append("<redirect>1</redirect>\r\n");
					valueXmlErrorString.append("</error>\r\n");
					valueXmlErrorString.append("</Errors>\r\n");
					valueXmlErrorString.append("</Header>\r\n");
					valueXmlErrorString.append( "</Root>\r\n" );
					//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
					errString =valueXmlErrorString.toString();
				}

			}
		}
		finally
		{
			try
			{
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				//System.out.println( "Exception :StrgMeetDCRWiz :defaultDataWiz :==>\n"+e.getMessage());
				errString = "";

				errString = genericUtility.createErrorString( e ) ;
				//System.out.println( "errString :Dipak:" +errString + ":" );
				String messageValue="",message = "";

				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
						messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
						String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
						message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

						//System.out.println("errorMessage==>"+messageValue);
						StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
						valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
						valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
						valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
						valueXmlErrorString.append("<type>E</type>\r\n");
						valueXmlErrorString.append("<option></option>\r\n");
						valueXmlErrorString.append("<time></time>\r\n");
						valueXmlErrorString.append("<alarm></alarm>\r\n");
						valueXmlErrorString.append("<source></source>\r\n");
						valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
						valueXmlErrorString.append("<redirect>1</redirect>\r\n");
						valueXmlErrorString.append("</error>\r\n");
						valueXmlErrorString.append("</Errors>\r\n");
						valueXmlErrorString.append("</Header>\r\n");
						valueXmlErrorString.append( "</Root>\r\n" );
						//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
						errString =valueXmlErrorString.toString();

					}
				}
			}
		}
		System.out.println("errString ["+errString+"]");
		return errString;
	}

	// For Finish action
	public String wfValOnFinish(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		System.out.println("Inside wfval finish");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			System.out.println("wfValData:xmlStringaaaaaaaa ["+xmlString+"]");
			System.out.println("wfValData:xmlString1bbbbbb["+xmlString1+"]");
			System.out.println("wfValData:xmlString2cccccccc["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata finish");
			errString = wfValOnFinish(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [StrgMeetDCRWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	// For Finish action
	public String wfValOnFinish(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		System.out.println("Inside wfvalfinish method");
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String errString = "";

		int currentFormNo = 0;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		PreparedStatement pStmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		ResultSet rs = null;
		//connectionObject = getConnection();
		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		int noOfChilds = 0;
		//String customerName = "";
		String scCode = "";
		String custType ="";
		ResultSet stpRs = null;
		String empCodeHO="";
		String empCodeMGR=""; //added by shraddha M[27-11-2020]
		String stpStatus="";
		String usrTypeLogin = "";
		
		//added by prachi
		StringBuffer errStringXml1;
		String errorString2="";
		errStringXml1 = new StringBuffer();
		errStringXml1.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");

		try
		{
			connectionObject = getConnection();
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			String objName = checkNull(getObjNameFromDom(dom2, "objName",Integer.parseInt(objContext)));
			//System.out.println("objName+++"+objName+"+++++objContext+++");
			String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
			String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
			String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
			String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
			String stockistFormNo = checkNull(getFormNo(objName, "stockist", connectionObject));
			userId = getEmpCode(userId, connectionObject);
			//System.out.println("wfValOnFinish call valdata");
			//System.out.println("wfValOnFinish objContext   ["+objContext+"]");
			//Added by Bhagyashri T for check perticular division
			ArrayList gradeArrayList = new ArrayList();
			String gradeS ="";
			String gradeArray = getGradeForSTP(userId, connectionObject);
			String gradesql = "SELECT GRADE FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pStmt = connectionObject.prepareStatement(gradesql);
			pStmt.setString(1, userId);

			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				gradeS  = checkNull(rs.getString("GRADE"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			//Added by bhagyashri to check perticular Div Check
			//0- Don't allow if created from real time reporting, 1-Always Allow, 2-Never allow.
			String allowEditPlace = "0",allowEditCust = "0";
			allowEditPlace = getSfaParmValue(userId,"ALLOW_EDIT_PLACE_DCR",connectionObject);
			allowEditCust = getSfaParmValue(userId,"ALLOW_EDIT_CUST_DCR",connectionObject);
			//System.out.println("allowEditPlace:::"+allowEditPlace+"  allowEditCust:::"+allowEditCust);
			//Added by mrunalini sinkar on 12-jan-2022 Start
			String isFormMandatory = checkNull(getSfaParmValue(userId, "IS_FORM_MANDATORY", connectionObject));
			String sfaparmBrand = checkNull(getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", connectionObject));

			String [] parmTemp = isFormMandatory.split(",");
			List<String> parmNamelist = new ArrayList<String>();

			for(int i = 0 ;i < parmTemp.length;i++)
			{
				if(!parmNamelist.contains(parmTemp[i]) )
				{
					parmNamelist.add(parmTemp[i]);
				}
			}
			//Added by mrunalini sinkar on 12-jan-2022 End
			//Added by Bhagyashri T for Fortune[]06/01/22]
			DARCommonBean darCommonBean= new DARCommonBean();
			String isFortuneAct  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
			//System.out.println("Is Fortune Activity Is in Finish:::"+isFortuneAct);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			if("mainform".equalsIgnoreCase(formName))
			{
				String updateFlag="";
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
						//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
						if(childNodeName.equalsIgnoreCase("event_date"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
								break;
							}
							else
							{
								SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
								java.util.Date eventDate = null;
								try
								{
									eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
									//System.out.println("eventDate is : ["+eventDate+"]");
								}
								catch ( Exception e )
								{
									//System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

								String evtdat=childNode.getFirstChild().getNodeValue();
								if (!sdfFormat.format(eventDate).equals(evtdat))
								{
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(start)
								String futureDate="";
								String eventType = checkNull(genericUtility.getColumnValue( "activity_code" , dom2 ,objContext));
								String itemSer = getItemSer(userId,connectionObject);
								//String actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? AND ITEM_SER = ? ";
								String actSql = "SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? "+
										 "AND (ITEM_SER IS NULL OR ITEM_SER = 'ALL' OR ITEM_SER = ?) "+
										 "AND (SITE_CODE IS NULL OR SITE_CODE = 'ALL' OR (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?) IN "+
										 "(SELECT REGEXP_SUBSTR(SITE_CODE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(SITE_CODE, '[^,]+', 1, LEVEL) IS NOT NULL) ) "+
										 "ORDER BY DESCR ";
								pstmt = connectionObject.prepareStatement(actSql);
								pstmt.setString(1, eventType);
								pstmt.setString(2, itemSer);
								pstmt.setString(3, userId);
								rSet = pstmt.executeQuery();
								if (rSet.next())
								{
									futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(end)
								//if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
								if (( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 && (futureDate.equalsIgnoreCase("0") || futureDate.trim().length() == 0)))
								{

									errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
									break;
								}

								//changed by rahul on 19-may-2016 [START] to check whether plan is confirm for selected work date
								String sfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
								String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom ));
								String copyPlanValue = checkNull(genericUtility.getColumnValue( "copy_plan" , dom ));
								//System.out.println("workDate.....::::"+workDate+"....copyPlanValue......."+copyPlanValue);
								String actTranSql = "SELECT * FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ? ";
								actPstmt = connectionObject.prepareStatement(actTranSql);
								actPstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
								actPstmt.setString(2,userId);
								actRs = actPstmt.executeQuery();
								if(!actRs.next() && sfaParmData.equalsIgnoreCase("Y"))
								{
									String planSql = "select * from  SPRS_PLAN_HDR where plan_date = ? and confirm = ? and SPRS_CODE__PLAN = ?";
									pstmt = connectionObject.prepareStatement(planSql);
									pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
									pstmt.setString(2,"Y");
									pstmt.setString(3,userId);
									rs = pstmt.executeQuery();
									if(!rs.next() && "Y".equalsIgnoreCase(copyPlanValue))
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "UNCONFPLAN" , userId );
										break;
									}
									//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
									if (rs!= null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}
									//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
								}
								//changed by rahul on 19-may-2016 [END] to check whether plan is confirm for selected work date
								//added by kailash on 05/04/17 :Start
								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								String activityCode = checkNull(genericUtility.getColumnValue( "activity_code" , dom ));
								String activityType = checkNull(genericUtility.getColumnValue( "activity_type" , dom ));
								String evtDate=childNode.getFirstChild().getNodeValue();
								//System.out.println("before activityCode"+ activityCode);
								//System.out.println("before activity"+ activityType);
								if(activityCode==null || activityCode.length()==0)
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","NULLACTCOD",userId);
									break;
								}

								if(activityType==null || activityType.length()==0)
								{
									String sql= "select activity_type from fieldactivity where activity_code= ?";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, activityCode);
									rSet = pstmt.executeQuery();
									if( rSet.next() )
									{
										activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
										//System.out.println("In If"+ activityType);
									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}

								}
								if( salesPers != null && evtDate != null )
								{
									//added by Rupali on 23/05/17 for defining sfaparam value for sequential reporting[start]
									//commented by mrunalini sinkar on 21- feb-2018 for adding org unit(start)
									/*SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
									String currDate = dtFormat.format(new java.util.Date());
									String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SEQUENTIAL_DAR' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
									PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
									pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
									ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
									if (rsSfaParm.next())
									{
										parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
									}
									if(rsSfaParm != null)
									{
										rsSfaParm.close();
										rsSfaParm = null;
									}
									if(pstmtSfaParm != null)
									{
										pstmtSfaParm.close();
										pstmtSfaParm = null;
									}*/
									//commented by mrunalini sinkar on 21- feb-2018 for adding org unit(end)

									String parmValue = getSfaParmValue(userId,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)
									//System.out.println("In 1 If parmValue is"+ parmValue);
									//added by Rupali on 23/05/17 for defining sfaparam value for sequential reporting[end]
									if(parmValue.equalsIgnoreCase("Y"))
									{
										String errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
										if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
										{
											errString = errStringNew;
											break;
										}
									}
									// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [start]
									//commenetd & Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(START)

									/*String parmVal = "";
									String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='VALIDATE_UNCONFIRM_DCR' AND ACTIVE='Y' ";
									PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
									ResultSet  rsSfaParm = pstmtSfaParm.executeQuery();
									if (rsSfaParm.next())
									{
										parmVal = checkNull(rsSfaParm.getString("PARM_VALUE"));
									}
									if(rsSfaParm != null)
									{
										rsSfaParm.close();
										rsSfaParm = null;
									}
									if(pstmtSfaParm != null)
									{
										pstmtSfaParm.close();
										pstmtSfaParm = null;
									}
									if(parmVal.equalsIgnoreCase("Y"))*/
									int maxUnconfAllow=0;
									String parmVal = getSfaParmValue(userId, "UNCONF_DAR", connectionObject);
									//System.out.println("UNCONF_DAR IS["+parmVal+"]");
									if (parmVal.trim().length() > 0)
									{
										try
										{
											maxUnconfAllow = Integer.parseInt(parmVal.trim());
										}
										catch (NumberFormatException ne)
										{
											maxUnconfAllow = 0;
										}
									}
									//System.out.println("maxUnconfAllow IS["+maxUnconfAllow+"]");
									//commenetd & Added by mrunalini sinkar for adding Sun Changes of unconfirm dar on 1-april-2019(END)
									if(maxUnconfAllow > 0)
									{
										String oldData=checkNull(getSfaParmValue(salesPers, "OLD_METIS_DAR_DATA", connectionObject));

										String unConfDcrDates="";
										int count=0;
										int MeetCount=0;

										String selectConfirmSql = "SELECT DISTINCT EVENT_DATE FROM SPRS_ACT_TRAN  WHERE SALES_PERS = ? " +
												" AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END ) <> 'Y'" +
												" AND  EVENT_DATE < ? ORDER BY EVENT_DATE ";
										PreparedStatement pstmtSelect = connectionObject.prepareStatement(selectConfirmSql);
										pstmtSelect.setString(1, salesPers);
										pstmtSelect.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
										ResultSet resultSelect = pstmtSelect.executeQuery();
										while(resultSelect.next())
										{
											MeetCount++;
											String unConfDcrDate = (resultSelect.getString("EVENT_DATE")) == null ?"":resultSelect.getString("EVENT_DATE").trim();
											unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
											unConfDcrDates += unConfDcrDate+",";

										}
										resultSelect.close(); resultSelect = null;
										pstmtSelect.close(); pstmtSelect = null;
										if(MeetCount==0 && "Y".equalsIgnoreCase(oldData))
										{
											int drCount=0;
											String oldConfirmSql = "SELECT DISTINCT WORK_DATE FROM DR_MAIN  WHERE SALES_PERS = ? " +
													" AND (CASE WHEN CONFIRMATION_FLAG IS NULL THEN 'N' ELSE CONFIRMATION_FLAG END ) <> 'Y'" +
													" AND  WORK_DATE < ? ORDER BY WORK_DATE ";
											PreparedStatement pstmtOld = connectionObject.prepareStatement(oldConfirmSql);
											pstmtOld.setString(1, salesPers);
											pstmtSelect.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
											ResultSet resultSelectOld = pstmtOld.executeQuery();
											while(resultSelectOld.next())
											{
												drCount++;
												String unConfDcrDate = (resultSelectOld.getString("WORK_DATE")) == null ?"":resultSelectOld.getString("WORK_DATE").trim();
												unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
												unConfDcrDates += unConfDcrDate+",";

											}
											resultSelectOld.close(); resultSelectOld = null;
											pstmtOld.close(); pstmtOld = null;
											count=drCount;
										}
										else
										{
											count=MeetCount;
										}
										//System.out.println( "Event Dates >>> ["+unConfDcrDates+"] count["+count+"]");
										//if(count >=3)
										if(count >= maxUnconfAllow)
										{
											String message=getMsgDescr("DCRUNCONFD",connectionObject);
											errString = "";
											String messageValue ="\r\n"+message+"\n"+unConfDcrDates;
											StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
											valueXmlErrorString.append("<error id=\"DCRUNCONFD\" type=\"E\" >");
											valueXmlErrorString.append("<message><![CDATA[").append("").append("]]></message>\r\n");
											valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
											valueXmlErrorString.append("<type>E</type>\r\n");
											valueXmlErrorString.append("<option></option>\r\n");
											valueXmlErrorString.append("<time></time>\r\n");
											valueXmlErrorString.append("<alarm></alarm>\r\n");
											valueXmlErrorString.append("<source></source>\r\n");
											valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
											valueXmlErrorString.append("<redirect>1</redirect>\r\n");
											valueXmlErrorString.append("</error>\r\n");
											valueXmlErrorString.append("</Errors>\r\n");
											valueXmlErrorString.append("</Header>\r\n");
											valueXmlErrorString.append( "</Root>\r\n" );
											errString =valueXmlErrorString.toString();
											return errString;
										}
									}
									// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [end]
									// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(start)
									/*if(!updateFlag.equalsIgnoreCase("E"))
									{*/
										errString = valHoliday( evtDate, salesPers, userId, itmDBAccessLocal, connectionObject,updateFlag);
										if(errString != null && errString.length()>0 && (errString.indexOf("ERRORS")!=-1 || errString.indexOf("Errors")!=-1))
										{
											//System.out.println("CAME HERE");
											//System.out.println("activity"+ activityType);
											if(activityType !=null && activityType.length() > 0 && "LEAVE".equalsIgnoreCase(activityType))
											{
												//System.out.println("Checking leave not allowed");
												errString = itmDBAccessLocal.getErrorString("activity_code","LVENOTALOW",userId);
												break;
											}
											else
											{
												//ADDED BY PRACHI FOR W21KSUN026
												errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
												if ( errString.length() > 0)
												{
													String bifurErrString = errString.substring( errString.indexOf("<Errors>")+8,errString.indexOf("</Errors>"));
													errStringXml1.append(bifurErrString);
													errString = "";
												}
											}

											

										}
									/*}*/
									//added by mrunalini sinkar for sun changes ALLOW_DAR_WO_MAP on 01-april-2019(start)
									//System.out.println("errString holiday is :["+errString);
									/*
									if(errString == null || errString.trim().length() == 0)
									{
										String planSfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
										boolean blockConfirmation = isNoMAPForTheWorkDate(userId,workDate,connectionObject);
										if (blockConfirmation)
										{
											errString = itmDBAccessLocal.getErrorString( "event_date" , "DARNOMAP" , userId);
											break;

										}
									}*/
									String holiday="";
									holiday = valHoliday( evtdat, userId, userId, itmDBAccessLocal, connectionObject,updateFlag);
										
									if(holiday == null || holiday.trim().length() == 0)
									{
										
										boolean blockConfirmation = isNoMAPForTheWorkDate(userId,workDate,connectionObject);
										if (blockConfirmation)
										{
											errString = itmDBAccessLocal.getErrorString( "event_date" , "DARNOMAP" , userId);
											break;

										}
									}	
									//added by mrunalini sinkar for sun changes ALLOW_DAR_WO_MAP on 01-april-2019(end)

								}
								//added by kailash on 05/04/17 :End


								//Added by Hariom  on 19-August-2019 for bangladesh user(start)
								String code="";
								String fromDate="";
								String brndParmData  = checkNull(getSfaParmValue(userId,"DAR_BRAND_MANDATE",connectionObject));

								if(brndParmData.equalsIgnoreCase("Y"))
								{

									String frDate="SELECT FR_DATE-1 AS FR_DATE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(frDate);
									pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										fromDate= checkNull(rSet.getString("FR_DATE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}


									String periodCode="SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(periodCode);
									pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(fromDate));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										code= checkNull(rSet.getString("CODE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}

									String brandSql = "SELECT * FROM STRG_BRAND_ACT WHERE SALES_PERS = ? AND PRD_CODE = ? ";
									pstmt = connectionObject.prepareStatement(brandSql);
									pstmt.setString(1,userId);
									pstmt.setString(2,code);
									rSet = pstmt.executeQuery();

									if(rSet.next())
									{
										System.out.println("Records are Present........");
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "INVLIDDAR" , userId );
										break;

									}
								}

								//Added by Hariom  on 19-August-2019 for bangladesh user(end)

								// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [start]
								empCodeHO = getHOEmployee( userId, connectionObject );
								empCodeMGR = getMGREmployee(userId,connectionObject); //added by shraddha M for STP DAR block Issue [W20HSUN035] 01-dec-2020
								System.out.println("HO Code value DAR Comp Finish: ["+empCodeHO+"]["+empCodeMGR+"]");
								String stpChksql="SELECT STP_STATUS FROM SALES_PERS WHERE SALES_PERS = ?";
								pstmt = connectionObject.prepareStatement(stpChksql);
								pstmt.setString(1,userId);
								stpRs = pstmt.executeQuery();
								if(stpRs.next())
								{
									stpStatus = checkNull(stpRs.getString("STP_STATUS"));
								}
								//System.out.println("stpStatus:::>>["+stpStatus+"]");
								if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
								{
									usrTypeLogin = "H";
								}
								else if(empCodeMGR !=null && empCodeMGR.length() > 0) //added by shraddha M for STP DAR block Issue [W20HSUN035] 01-dec-2020
								{
									usrTypeLogin = "M";
								}
								else
								{
									usrTypeLogin = "SO";
								}
								System.out.println("usrTypeLogin wfvalFinish["+usrTypeLogin+"]");
								
								if( (!"H".equalsIgnoreCase(usrTypeLogin)) && ((!"M".equalsIgnoreCase(usrTypeLogin))) ) //added by shraddha M for STP DAR block Issue [W20HSUN035] 01-dec-2020
								{
									if(stpStatus.equalsIgnoreCase("2"))
									{
										int darBkdy=0;
										long daysDiff = getSTPApproveDateDiff(userId,connectionObject);
										String darBckDys = checkNull(getSfaParmValue(userId, "STP_DAR_BLOCK_DAYS", connectionObject));
										if(darBckDys != null && darBckDys.trim().length()>0)//Added by mrunalini sinkar if sfaparm is not exist
										{
											darBkdy = Integer.parseInt(darBckDys);
										}

										//System.out.println("daysDiff::["+daysDiff+"]::itemSer::["+itemSer+"]::darBckDys::["+darBckDys+"]::darBkdy::["+darBkdy+"]");
										/*if(daysDiff > darBkdy )
										{
											errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
											return errString;
										}*/
										
										System.out.println("Inside StrgMeetDCRWizFinish");
										if(gradeArray != null && gradeArray.trim().length() > 0)
										{
											String[] grdArray = gradeArray.split(",");
											System.out.println("GradeCode is StrgMeetDCRWizFinish::>>::"+grdArray);

											for( int cntr = 0 ; cntr < grdArray.length ; cntr++ )
						                    {
												gradeArrayList.add(checkNull(grdArray[cntr]));
						                    }
										}
										System.out.println("GradearrayList StrgMeetDCRWizFinish ::::>>::["+gradeArrayList+"]::SalesGradeCode StrgMeetDCRWizFinish val::["+gradeS+"]");
										if(gradeArrayList.contains(gradeS) )
										{
											System.out.println("Inside StrgMeetDCRWizFinish gradeArrayList.contains(gradeS)");
											if(daysDiff > darBkdy )
											{
												System.out.println("Inside StrgMeetDCRWizFinish daysDiff > darBkdy");
												errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
												return errString;
											}
										}
										System.out.println("Outside StrgMeetDCRWizFinish gradeArrayList.contains(gradeS)");
									}
								}
								if(stpRs != null)
								{
									stpRs.close();
									stpRs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [start]
								int dojValidCount = 0;
								String sDobj = "SELECT COUNT(1) AS CNT FROM EMPLOYEE E WHERE EMP_CODE = ? AND ? < E.DATE_JOIN";
								pstmt = connectionObject.prepareStatement(sDobj);
								pstmt.setString(1, userId);
								pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( evtdat, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

								rSet = pstmt.executeQuery();
								if (rSet.next())
								{
									dojValidCount = rSet.getInt("CNT");
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								if(dojValidCount > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "work_date" , "INVDTJWRK" , userId );
									break;
								}

								String salesMode = "", deviceType = "";
								String modeSql = "SELECT MODE_REPO FROM SALES_PERS WHERE SALES_PERS= ? ";
								pstmt = connectionObject.prepareStatement(modeSql);
								pstmt.setString(1,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	salesMode = checkNull(rSet.getString("MODE_REPO"));
							    	//System.out.println("Records are Present........");
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								/*String deviceTypeSql = "SELECT DEVICE_TYPE, TO_CHAR(LOGINTIME, 'DD-MM-YYYY HH24:MI:SS A.M.') FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = (SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ?)";
								pstmt = connectionObject.prepareStatement(deviceTypeSql);
								pstmt.setString(1,userId);
								pstmt.setString(2,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	deviceType = checkNull(rSet.getString("DEVICE_TYPE"));
							    	//System.out.println("DEVICE_TYPE........"+deviceType);
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}*/
								deviceType = getUserInfo().getDeviceType();
								System.out.println("deviceType is wfvalonfinsh:::::::::::::::["+deviceType+"]");
							    //System.out.println(": MODE :"+salesMode);
							    if (!deviceType.trim().equalsIgnoreCase("Browser") && salesMode.equalsIgnoreCase("W"))
							    {
								    errString = itmDBAccessLocal.getErrorString( "event_date" , "INVLIDMODE" , userId );
							    }

							    String propValue = fetchPropertyValue("NETREPORT_MOBMODE_DISSALLOW" , itemSer , connectionObject);
							    if (deviceType.trim().equalsIgnoreCase("Browser"))
								{
									if (salesMode.equalsIgnoreCase("M") && propValue.indexOf(updateFlag) >= 0)
									{
											errString = itmDBAccessLocal.getErrorString( "work_date" , "MOBNETNA" , userId );
											break;
									}
								}

							    String actType = checkNull(genericUtility.getColumnValue( "activity_type" , dom2 ,objContext));
							    //if(!(updateFlag.equalsIgnoreCase("E")))
								if(!(updateFlag.equalsIgnoreCase("E")) && "FW".equalsIgnoreCase(actType))
								{
									int alwdDelPrd = 0;
									checkSQL = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
									pstmt = connectionObject.prepareStatement(checkSQL);
									pstmt.setString(1, userId);
									rSet = pstmt.executeQuery();
									if (rSet.next())
									{
										alwdDelPrd = rSet.getInt("ALLWD_DELAY_PRD");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if (alwdDelPrd <= 0)
									{
										alwdDelPrd = 0;
									}

									int totDelPrd = 0;
									long diffDays = 0;
									java.util.Date currDate = new java.util.Date();
									java.util.Date tempDate = null;
									DateFormat applFormat = new SimpleDateFormat(getApplDateFormat());
									ArrayList<String> holiList = new ArrayList<String>();
									String holDAte = genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());
									String holtblno = getHoltblno(userId,holDAte, connectionObject);

									Calendar cal = Calendar.getInstance();
									SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
									cal.setTime( sdf.parse(evtdat) );
									tempDate = cal.getTime();
									long diff = currDate.getTime() - tempDate.getTime();
									diffDays = diff / (24 * 60 * 60 * 1000);
									//System.out.println(diffDays + " ssssdays, ");

									Calendar calBef = Calendar.getInstance();
									//calBef.add(Calendar.DAY_OF_MONTH,-alwdDelPrd);//Commended by Hariom for holiday check -03-Nov-20
									//java.util.Date befoDate = calBef.getTime();//Commended by Hariom for holiday check -03-Nov-20
									//String befoDateAppl = applFormat.format( evtdat );//Commended by Hariom for holiday check -03-Nov-20
									String befoDateDB= genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());//Changes by Hariom for holiday check -03-Nov-20

									Calendar calAft = Calendar.getInstance();
									java.util.Date aftDate = calAft.getTime();
									String aftDateAppl = applFormat.format( aftDate );
									String aftDateDB= genericUtility.getValidDateTimeString( aftDateAppl , getApplDateFormat() , getDBDateFormat());
									holiList = getHolidayList(befoDateDB,aftDateDB,holtblno,userId,connectionObject);//userId added by mrunalini sinkar for change_holiday(start)

									int holCnt = holiList.size();
									totDelPrd = alwdDelPrd + holCnt;
									//System.out.println("totDelPrd::["+totDelPrd+"] alwdDelPrd:::["+totDelPrd+"] holCnt:::["+holCnt+"]");

									if (diffDays > totDelPrd)
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "MAXDELYPRD" , userId );
										break;
									}
								}

							}
						}
						if(childNodeName.equalsIgnoreCase("activity_code"))
						{
							String actCode = genericUtility.getColumnValue( "activity_code" , dom );
							// added by rupali on 10/08/17 for applying validation on activity type if we select differrent activity type on previous
							String trvDate = genericUtility.getColumnValue( "travel_date" , dom2 );
							String placeRequired = genericUtility.getColumnValue( "place_required" , dom2 );//added for PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
							String actType ="";
							int actCount = 0;

							//System.out.println("actCode::"+actCode);
							//System.out.println("trvDate::"+trvDate);

							//	String actSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";

							String actSQL = " SELECT ACTIVITY_TYPE,COUNT(*) AS COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? GROUP BY ACTIVITY_TYPE ";

							pstmt = connectionObject.prepareStatement(actSQL);
							pstmt.setString(1, actCode);
							rSet =pstmt.executeQuery();
							if( rSet.next() )
							{
								actType = rSet.getString("ACTIVITY_TYPE") == null ?"":rSet.getString("ACTIVITY_TYPE");
								actCount = rSet.getInt("COUNT");
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							// added by rupali on 28/04/17 for validating wrong activity [start]
							if(actCount == 0)
							{
								//System.out.println("inside actCount...."+actCount);
								errString = itmDBAccessLocal.getErrorString( "activity_code", "ACTNOTFND", userId );
								break;
							}
							// added by rupali on 28/04/17 for validating wrong activity [end]
							//Changes for PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
							//if( actType.equalsIgnoreCase("FW") || actType.equalsIgnoreCase("NFW")) //added by mrunalini sinkar on 25-june-2018
							if("Y".equalsIgnoreCase(placeRequired))
							{
								errString = itmDBAccessLocal.getErrorString( "event_type", "INVACTC", userId );
								break;
							}

							// added by rupali on 10/08/17 for applying validation on activity type if we select differrent activity type on previous [start]
							if(!"FW".equalsIgnoreCase(actType) && trvDate != null && trvDate.trim().length() != 0   )
							{
								errString = itmDBAccessLocal.getErrorString( "activity_code", "INVACTSEL", userId );
								break;
							}
							// added by rupali on 10/08/17 for applying validation on activity type if we select differrent activity type on previous [end]
							//Added by Gaurav Singh on 10-06-2015 [Start]

							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))
							{
								if (columnValue.trim().length() > 2)
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
									break;
								}
								else
								{
									String eventDate = genericUtility.getColumnValue( "event_date" , dom );
									String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
									String pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());

									ArrayList halfDayActList = halfDayActivityList("HALF_DAY_ACTIVITIES",connectionObject);
									int recCount = 0;
									ArrayList activityList = new ArrayList();
									String activitySql = "SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS=? ";
									PreparedStatement pstmtActivity = connectionObject.prepareStatement(activitySql);
									pstmtActivity.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));
									pstmtActivity.setString(2, salesPers);
									ResultSet rsActivity = pstmtActivity.executeQuery();
									while ( rsActivity.next() )
									{
										activityList.add(rsActivity.getString("ACTIVITY_CODE"));
									}
									rsActivity.close(); rsActivity = null;
									pstmtActivity.close(); pstmtActivity = null;
									recCount = activityList.size();

									checkSQL = "SELECT SPRS_ACT_TRAN.ACTIVITY_CODE,FIELDACTIVITY.ACTIVITY_TYPE FROM SPRS_ACT_TRAN,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND SPRS_ACT_TRAN.ACTIVITY_CODE = FIELDACTIVITY.ACTIVITY_CODE ";
									PreparedStatement pstmtMeetActivity = connectionObject.prepareStatement(checkSQL);
									pstmtMeetActivity.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
									pstmtMeetActivity.setString(2, salesPers);
									ResultSet rSetMeetActivity = pstmtMeetActivity.executeQuery();
									if ( rSetMeetActivity.next() )
									{
										String selActivityType = "";
										String activityType = rSetMeetActivity.getString(2);
										activityType = checkNull(activityType).trim().toUpperCase();
										//System.out.println("ACTIVITY TYPE IS:"+activityType);
										String activityCode = checkNull(rSetMeetActivity.getString(1)).toUpperCase();

										if(activityType.indexOf("LEAVE")!=-1)
										{
											checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
											pstmt = connectionObject.prepareStatement(checkSQL);
											pstmt.setString(1, columnValue);
											rSet =pstmt.executeQuery();
											if( rSet.next() )
											{
												if(!activityType.equalsIgnoreCase(rSet.getString(1)))
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
													break;
												}
											}
											if (rSet!= null)
											{
												rSet.close();
												rSet = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}

										}
										//else if (activityType.indexOf("NFW")!=-1)
										else if (!(activityType.equalsIgnoreCase("FW") && activityType.equalsIgnoreCase("LEAVE")))//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
										{
											checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
											pstmt = connectionObject.prepareStatement(checkSQL);
											pstmt.setString(1, columnValue);
											rSet =pstmt.executeQuery();
											if( rSet.next() )
											{
												if(!activityType.equalsIgnoreCase(rSet.getString(1)))
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
													break;
												}
											}
											if (rSet!= null)
											{
												rSet.close();
												rSet = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}
										}
										else if (activityType.indexOf("FW")!=-1)
										{
											//System.out.println("INSIDE FW");
											checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
											pstmt = connectionObject.prepareStatement(checkSQL);
											pstmt.setString(1, columnValue);
											rSet =pstmt.executeQuery();
											if( rSet.next() )
											{
												String eventType = checkNull(rSet.getString("ACTIVITY_TYPE"));
												//System.out.println("activity type is:"+eventType);
												if(!activityType.equalsIgnoreCase(eventType))
												{
													errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
													break;
												}
											}
											if (rSet!= null)
											{
												rSet.close();
												rSet = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}

											/*
											//If one record present of Half day activity
											if(recCount == 1 && halfDayActList.contains(activityCode) && !halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
												break;
											}
											//If one record present of Full day activity and trying to select half day activity
											if(recCount == 1 && !halfDayActList.contains(activityCode) && halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG1", userId );
												break;
											}
											//If one record present of Full day activity and type is mismatch means other activity is selected like : LEAVE, NFW etc
											if(recCount == 1 && !halfDayActList.contains(activityCode) && !activityType.equalsIgnoreCase(selActivityType) )
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG2", userId );
												break;
											}
											//Two records present(one mktev and one FW) and the selected
											if(recCount > 1 && !halfDayActList.contains(columnValue))//OK
											{
												//errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG3", userId );
												break;
											}
											 */}
										else
										{/*
											checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
											pstmt = connectionObject.prepareStatement(checkSQL);
											pstmt.setString(1, columnValue);
											rSet =pstmt.executeQuery();
											if( rSet.next() )
											{
												selActivityType = rSet.getString(1);
											}
											if (rSet!= null)
											{
												rSet.close();
												rSet = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}
											//If one record present of Half day MKTEV and Trying to put Full Day activity
											if(recCount == 1 && halfDayActList.contains(activityCode) && !halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG4", userId );
												break;
											}
											//If one record present of Full day MKTEV and trying to put half day MKTEV
											if(recCount == 1 && !halfDayActList.contains(activityCode) && halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG5", userId );
												break;
											}
											//If one record present of Full day MKTEV activity and type is mismatch means other activity is selected like : LEAVE, NFW etc
											if(recCount == 1 && !halfDayActList.contains(activityCode) && !activityType.equalsIgnoreCase(selActivityType) )
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG6", userId );
												break;
											}
											//Two records present(one mktev and one FW) and the selected
											if(recCount > 1 && !halfDayActList.contains(columnValue))//OK
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG7", userId );
												break;
											}
										 */}
									}
									if (rSetMeetActivity!= null)
									{
										rSetMeetActivity.close();
										rSetMeetActivity = null;
									}
									if(pstmtMeetActivity!=null)
									{
										pstmtMeetActivity.close();
										pstmtMeetActivity = null;
									}

								}//else of if (columnValue.trim().length() > 2)
							}
							//Added by Gaurav Singh on 10-06-2015 [End]
						}
						else if(childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString =getErrorString("sales_pers","NULSPCODNM",userId);
								break;
							}
							/*else
							{
								DARCommonBean darCommonBean= new DARCommonBean();
								String standCodeHQ=darCommonBean.getStandCodeHq(userId, connectionObject);
								System.out.println("standCodeHQ is:["+standCodeHQ+"]");
								if(standCodeHQ==null || standCodeHQ.trim().length()==0)
								{
									errString = itmDBAccessLocal.getErrorString( "sales_pers", "HQNTCONFIG", userId );
									break;
								}
								else
								{
									boolean isRouteConfig=darCommonBean.checkHeadquarterRouteIsAvilable(userId, standCodeHQ, connectionObject);
									System.out.println("isRouteConfig is:["+isRouteConfig+"]");

									if(!isRouteConfig)
									{
										errString = itmDBAccessLocal.getErrorString( "sales_pers", "ROUTCONFIG", userId );
										break;
									}
								}
							}*/
						}
						else if(childNodeName.equalsIgnoreCase("remark"))
						{
							//System.out.println("Inside remark");
							if(columnValue != null && columnValue.length() >100)
							{
								errString = itmDBAccessLocal.getErrorString( "remark", "INVALREMRK", userId );
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("oth_participant"))
						{
							//System.out.println("oth_participant remark");
							if(columnValue != null && columnValue.length() >120)
							{
								errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
								break;
							}
						}
					}//inner for
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}//outer for
			}
			//added by mrunalini sinkar 25-june-2018  for place form validation(start)
			if("place".equalsIgnoreCase(formName))
			{
				//System.out.println("Case 2 : validation ::");
				String localityDescr = "";
				int counter = 0;
				Hashtable hs = new Hashtable();
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				ArrayList orderVisitList = new ArrayList ();
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				String updateFlag = "";
				String CheckUpdateFlag = "";
				List selLocCodeList = new ArrayList();
				String actType = checkNull(getColumnValue("activity_type", dom2, mainFormNo));
				String placeParamValue=checkNull(getSfaParmValue(userId,"NO_VISIT_SEL_VAL_REQ",connectionObject));

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";


					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "travel_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					//System.out.println("Checking update flag for 3+"+updateFlag);
					//if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))//Commented by poonam
					if(updateFlag != null)
					{
						updateFlagCnt++;
					}
				}
				//System.out.println("selectedFlagCnt [case 3] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("locality_code","NOPLACESEL",userId);
				}
				if(parentNodeListLength == 0 )
				{
					errString = getErrorString("locality_code","NOPLACESEL",userId);
				}

				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName =["+childNodeName+"]");
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Checking update flag for 3:--"+CheckUpdateFlag);
							if(!"D".equalsIgnoreCase(CheckUpdateFlag))
							{
							if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
								else
								{
									String locality = childNode.getFirstChild().getNodeValue();
									//System.out.println("case 3 :: locality :: ["+locality+"]");
								}
								//System.out.println("Column Value "+ columnValue +":updateFlag:"+updateFlag);
								/*if(!("D".equalsIgnoreCase(CheckUpdateFlag)))
								{
									selLocCodeList.add(checkNull(columnValue));
								}*/
								//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
								if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","DESELLOCLT",userId);
									break;
								}
								//TODO
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("order_of_visit"))
							{
								//System.out.println("order_of_visit :: case3");
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = getErrorString("order_of_visit","NULORDRV",userId);
									break;
								}
								//Added by Poonam Gole on 10-12-2015 for validation of order_of_visit:Start
								else
								{
									//System.out.println("order_of_visit :: case3 else loop");
									String OrderVisit = childNode.getFirstChild().getNodeValue();
									//System.out.println("OrderVisit :: "+OrderVisit);

									//System.out.println("orderVisitList :: "+orderVisitList);
									boolean OrderOfVisit = OrderVisit.matches("\\d+");

									if(OrderOfVisit == false)
									{
										errString = getErrorString("order_of_visit","INVAIDNUM",userId);
										break;
									}
									else if(OrderVisit.trim().length() > 3)
									{
										//System.out.println("wfValPlace ::: Order of visit length greater than three");
										errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST03",userId);
										break;
									}
									else if( ( Integer.parseInt( OrderVisit ) <= 0 ) )
									{
										//System.out.println("wfValPlace ::: Order of visit is negative/blank");
										errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST01",userId);
										break;
									}
									else
									{
										if (orderVisitList.contains(OrderVisit.trim()))
										{
											//System.out.println("Duplicate Order of Visit::");
											errString = itmDBAccessLocal.getErrorString("order_of_visit","VTORDVST02",userId);
											break;
										}
										else
										{
											//System.out.println("Array before adding in orderVisitList"+orderVisitList);
											orderVisitList.add(OrderVisit.trim());
										}
									}
								}
								//Added by Poonam Gole on 10-12-2015 for validation of order_of_visit:End
							}
							}
							
							String isDrVisit = getSelectedRowVal(dom2, objContext, "dr_visit",prntCtr);
							String isChemVisit = getSelectedRowVal(dom2, objContext, "chem_visit",prntCtr);
							String isStockVisit = getSelectedRowVal(dom2, objContext, "stockist_visit",prntCtr);
							String isNCWVisit = getSelectedRowVal(dom2, objContext, "other_visit",prntCtr);
							String routeType = checkNull(getSelectedRowVal(dom2, objContext, "route_type",prntCtr));

							if("N".equalsIgnoreCase(isDrVisit) && "N".equalsIgnoreCase(isChemVisit) && "N".equalsIgnoreCase(isStockVisit) && "FW".equalsIgnoreCase(actType) && !"H".equalsIgnoreCase(routeType) && !"M".equalsIgnoreCase(routeType) && "Y".equalsIgnoreCase(placeParamValue))
							{
								//System.out.println("::");
								errString = itmDBAccessLocal.getErrorString("dr_visit","NOVISITSEL",userId);
								break;
							}

							//added by mrunalini sinkar on 25-june-2018(start)
							String fortuneAct = checkNull(getSelectedRowVal(dom2, objContext, "is_place_fortune_act",prntCtr));
							String buttondisable = checkNull(getSelectedRowVal(dom2, objContext, "is_button_disable",prntCtr));
							
								if( actType.equalsIgnoreCase("FW") && !"Y".equalsIgnoreCase(fortuneAct)) //added by mrunalini sinkar on 25-june-2018
								{
									errString = itmDBAccessLocal.getErrorString( "activity_type", "INVACTC", userId );
									break;
								}
							

							//added by mrunalini sinkar on 25-june-2018(end)
						}
					}
				}
			}

			//added by mrunalini sinkar for place form 25-june-2018  validation (end)
			if("doctor".equalsIgnoreCase(formName))
			{
				boolean isNotSelectedOnFinish = false;
				String CheckUpdateFlag ="";
				ArrayList chemVisitList = new ArrayList();
				ArrayList drVisitList = new ArrayList();
				ArrayList stockistVisitList = new ArrayList();
				ArrayList ncwVisitList = new ArrayList();
				isNotSelectedOnFinish = isEmptyDOM(dom2 , ""+currentFormNo);
				//System.out.println("isSelectedOnFinish isSelectedOnFinish:- "+isNotSelectedOnFinish);
				chemVisitList = getSelCustList(dom2, locFormNo, "chem_visit");
				drVisitList = getSelCustList(dom2, locFormNo, "dr_visit");
				stockistVisitList = getSelCustList(dom2, locFormNo, "stockist_visit");
				ncwVisitList = getSelCustList(dom2, locFormNo, "other_visit");
				String affirmativeVar = "Y";
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]

				//System.out.println("chemVisitList+++"+chemVisitList+"++++"+drVisitList+"+");
				//System.out.println("chemVisitList.contains(affirmativeVar)"+chemVisitList.contains(affirmativeVar));
				if((isNotSelectedOnFinish && chemVisitList.contains(affirmativeVar)))
				{
					errString = getErrorString("strg_code","NEXTCHEMFN",userId);

				}
				if((isNotSelectedOnFinish && stockistVisitList.contains(affirmativeVar)))
				{
					errString = getErrorString("strg_code","NEXTCHEMFN",userId);

				}
				if((isNotSelectedOnFinish && ncwVisitList.contains(affirmativeVar)))
				{
					errString = getErrorString("strg_code","NEXTCHEMFN",userId);

				}
				if((!isNotSelectedOnFinish && drVisitList.contains(affirmativeVar) && chemVisitList.contains(affirmativeVar)&& ncwVisitList.contains(affirmativeVar)&& stockistVisitList.contains(affirmativeVar)))
				{
					errString = getErrorString("strg_code","NEXTCHEMFN",userId);

				}
				if(isNotSelectedOnFinish && drVisitList.contains(affirmativeVar))
				{
					errString = getErrorString("strg_code","NOCUSTSETD",userId);
				}
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;

				//System.out.println("retailer: validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}
				String isDocMan = checkNull(getSfaParmValue(userId,"DOCTOR_MANDATORY",connectionObject));

				if(selectedFlagCnt == 0 && updateFlagCnt > 0 && "Y".equalsIgnoreCase(isDocMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}

				//TODO
				//chemVisitList = getSelCustList(dom2, locFormNo, "chem_visit");
				if(errString.trim().length() !=0)
				{
					drVisitList = getSelCustList(dom2, locFormNo, "dr_visit");
					if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isDocMan))
					{
						//	String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, "3"));
						//if(dcrId.length() > 0 )
						{
							//String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, "3"));
							String drVisitval = "Y";
							if(drVisitList.contains(drVisitval))
							{
								errString = itmDBAccessLocal.getErrorString( "strg_code", "NODOCVISEL", userId );
							}
						}
					}
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									//System.out.println("Value of updateFlag flag is in case retailer:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case retailer:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("strg_code","DESELCUSTM",userId);
								break;
							}
							if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
									//break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										System.out.println("euinNoDupList is:::::["+euinNoDupList+"]columnValue EUIN is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
										
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												System.out.println("Duplicate EUIN NO::");
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							else if(childNodeName.equalsIgnoreCase("event_time_start") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
								
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									customerName = " for "+customerName;		
									errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
									errString = getDescrModifiedErrorString(errString, customerName);

									break;
									
								}
							}
							else if(childNodeName.equalsIgnoreCase("member_present") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								String memberPresent  = checkNull(getSelectedRowValue(dom2, objContext, "member_present",prntCtr));
								scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
								custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));
								
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("0000000000".equalsIgnoreCase(scCode))  
									{
										String customerName = " for customer Unlisted Doctor";
										errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
								else
								{
									if(Integer.parseInt(memberPresent) <= 0)
									{
										if ("0000000000".equalsIgnoreCase(scCode)) 
										{
											String customerName = " for customer Unlisted Doctor";
											errString = itmDBAccessLocal.getErrorString( "member_present" , "INVMEMPRE" , userId );
											errString = getDescrModifiedErrorString(errString, customerName);

											break;
										}
									}
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
								
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									customerName = " for "+customerName;		
									
									if ( "0000000000".equalsIgnoreCase( scCode ) || "UR00000000".equalsIgnoreCase( scCode ) || "US00000000".equalsIgnoreCase( scCode ) || custType.indexOf("UNLISTED")!= -1 )
									{
										customerName = " for customer Unlisted Doctor";
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
									//String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));																		
									if ("0000000000".equalsIgnoreCase(scCode) || custType.indexOf("UNLISTED")!= -1 ) 
									{
										String customerName = " for customer Unlisted Doctor";				
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									
								}
								else
								{
									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom2, objContext));
									//String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom2, objContext));
									String startVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_start",prntCtr));
									String endVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_end",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("startVisitTime doctor:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime doctor:["+endVisitTime+"]scCode["+scCode+"]");
									if (!retFlag && "0000000000".equalsIgnoreCase( scCode ))
									{
										System.out.println("inside validation");
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									//changes done by prachi [W22FBAS009] start
									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									
									if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPDOCTR",userId);
											errString = getDescrModifiedErrorString(errString, customerName);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										String subStrgCode="";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									String invoiceFormNo = checkNull(getFormNo(objName, "invoice", connectionObject));
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collection", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									System.out.println("flg finish doctor parmNamelist  in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("brand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("invoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										System.out.println("line no 2564");
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collection") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
									////changes done by prachi [W22FBAS009] end
								}
							}
							else if(formName.equalsIgnoreCase("doctor"))
							{/*
								objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
								locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
								mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
								String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
								String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom, docFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom, docFormNo, "meet_summ", prntCtr));
									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									String teamFormNo = subFormsMap.get("team");
									String displayFormNo = subFormsMap.get("display");
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}

								}
							 */}
							

						}

					}
				}
			}
			if("retailer".equalsIgnoreCase(formName))
			{
				boolean isNotSelectedOnFinish = false;
				String CheckUpdateFlag ="";
				ArrayList chemVisitList = new ArrayList();
				isNotSelectedOnFinish = isEmptyDOM(dom2 , ""+currentFormNo);
				//System.out.println("isSelectedOnFinish isSelectedOnFinish:- "+isNotSelectedOnFinish);
				chemVisitList = getSelCustList(dom2, locFormNo, "chem_visit");
				String okVar = "Y";
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;


				//System.out.println("retailer: validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}
				String isChemMan = checkNull(getSfaParmValue(userId,"RETAILER_MANDATORY",connectionObject));

				//System.out.println("selectedFlagCnt [] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0 && "Y".equalsIgnoreCase(isChemMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				//TODO
				chemVisitList = getSelCustList(dom2, locFormNo, "chem_visit");
				
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isChemMan))
				{
					//	String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, "3"));
					//if(dcrId.length() > 0 )
					{
						//String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, "3"));
						String chemVisitval = "Y";
						if(chemVisitList.contains(chemVisitval))
						{
							errString = itmDBAccessLocal.getErrorString( "strg_code", "NORETSEL", userId );
						}
					}
				}

				if(isNotSelectedOnFinish && (chemVisitList.contains(okVar)) && "Y".equalsIgnoreCase(isChemMan))
				{
					errString = getErrorString("strg_code","NORETSEL",userId);
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									//System.out.println("Value of updateFlag flag is in case retailer:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case retailer:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("strg_code","DESELCUSTM",userId);
								break;
							}
							if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
									//break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								System.out.println("Inside oth_participant Finish Of Retailer");
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										System.out.println("Inside EUIN NO validation for ADDNEW");
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										//System.out.println("Inside EUIN NO validation strgCode finish Retailer::"+strgCode);
										//System.out.println("Inside EUIN NO validation uniqStrgcod Finish Retailer::"+uniqStrgcod);
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											System.out.println("Inside strg code from pophelp Finish Retailer");
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										System.out.println("euinNoDupList is:::::["+euinNoDupList+"]columnValue EUIN is["+columnValue+"]checkupdateflag id:"+CheckUpdateFlag+"]");
										
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												System.out.println("Duplicate EUIN NO::");
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [start]
							else if(childNodeName.equalsIgnoreCase("event_time_start") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									customerName = " for "+customerName;
									
										errString = itmDBAccessLocal.getErrorString("event_time_start","NULLEVNTFR",userId);
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									
								}
							}
							else if(childNodeName.equalsIgnoreCase("member_present") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								String memberPresent  = checkNull(getSelectedRowValue(dom2, objContext, "member_present",prntCtr));
								scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
								custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));
								
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if("UR00000000".equalsIgnoreCase(scCode)) 
									{
										String customerName = " for customer Unlisted Chemist";
										errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
								else
								{
									if(Integer.parseInt(memberPresent) <= 0)
									{
										if("UR00000000".equalsIgnoreCase(scCode)) 
										{
											String customerName = " for customer Unlisted Chemist";
											errString = itmDBAccessLocal.getErrorString( "member_present" , "INVMEMPRE" , userId );
											errString = getDescrModifiedErrorString(errString, customerName);

											break;
										}
									}
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{

									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									customerName = " for "+customerName;
									
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSTFRC",userId);
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									
								
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									
									if ("UR00000000".equalsIgnoreCase(scCode) || custType.indexOf("UNLISTED")!= -1 ) 
									{
										String customerName = " for customer Unlisted Chemist";
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									
									
								}
								else
								{

									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, objContext));
									//String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									String startVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_start",prntCtr));
									String endVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_end",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("retFlag["+retFlag+"scCode["+scCode+"]");
									System.out.println("startVisitTime retailer:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime retailer:["+endVisitTime+"]scCode["+scCode+"]");

									if (!retFlag && "UR00000000".equalsIgnoreCase( scCode ))
									{
										System.out.println("inside validation");

										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}

								}
							}
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									//changes done by prachi [W22FBAS009] start
									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											System.out.println("Duplicate Doctor visited Visit::");
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPCHEM",userId);
											errString = getDescrModifiedErrorString(errString, customerName);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										String subStrgCode="";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									String invoiceFormNo = checkNull(getFormNo(objName, "retailerinvoice", connectionObject));
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collectionRetailer", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									System.out.println("flg finish retailer parmNamelist  in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("retailerbrand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("retailerinvoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collectionRetailer") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
									//changes done by prachi [W22FBAS009] end
								}
							}
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [end]
							else if(formName.equalsIgnoreCase("retailer"))
							{/*
								objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
								locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
								mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
								String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
								if(childNodeName.equalsIgnoreCase("call_outcome"))
								{
									System.out.println("inside Calloutcome7");
									String callOutCome = checkNull(getSelectedRowVal(dom, docFormNo, "call_outcome", prntCtr));
									String meetSumm = checkNull(getSelectedRowVal(dom, docFormNo, "meet_summ", prntCtr));
									if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
									{
										errString = getErrorString("call_outcome","DELCALNOTE",userId);
										break;
									}

									objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
									HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
									System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
									String sampleitemFormNo = subFormsMap.get("sampleitem");
									String teamFormNo = subFormsMap.get("team");
									String displayFormNo = subFormsMap.get("display");
									boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo);
									boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo);
									boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo);
									if(callOutCome.equalsIgnoreCase("0") &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty) )
									{
										errString = getErrorString("call_outcome","DELSUBFMDA",userId);
										break;
									}

								}
							 */}
							

						}

					}
				}
			}
			// Added by Mrunalini Sinkar on 08-may-2017 for Stockist form validation(start)

			if("stockist".equalsIgnoreCase(formName))
			{
				boolean isNotSelectedOnFinish = false;
				String CheckUpdateFlag ="";
				ArrayList stockistVisitList = new ArrayList();
				isNotSelectedOnFinish = isEmptyDOM(dom2 , ""+currentFormNo);
				//System.out.println("isSelectedOnFinish isSelectedOnFinish:- "+isNotSelectedOnFinish);
				stockistVisitList = getSelCustList(dom2, locFormNo, "stockist_visit");
				String okVar = "Y";
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;

				//System.out.println("retailer: validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				//System.out.println("selectedFlagCnt [] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				String isStockMan = checkNull(getSfaParmValue(userId,"STOCKIST_MANDATORY",connectionObject));

				if(selectedFlagCnt == 0 && updateFlagCnt > 0 && "Y".equalsIgnoreCase(isStockMan))
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				//TODO
				stockistVisitList = getSelCustList(dom2, locFormNo, "stockist_visit");
				if(selectedFlagCnt == 0 && "Y".equalsIgnoreCase(isStockMan))
				{
					//	String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, "3"));
					//if(dcrId.length() > 0 )
					{
						//String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, "3"));
						String chemVisitval = "Y";
						if(stockistVisitList.contains(chemVisitval))
						{
							errString = itmDBAccessLocal.getErrorString( "strg_code", "NOSTOCKSEL", userId );
						}
					}
				}

				if(isNotSelectedOnFinish && (stockistVisitList.contains(okVar)) && "Y".equalsIgnoreCase(isStockMan))
				{
					errString = getErrorString("strg_code","NOSTOCKSEL",userId);
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									System.out.println("Value of updateFlag flag is in case retailer:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case retailer:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("strg_code","DESELCUSTM",userId);
								break;
							}
							if(childNodeName.equalsIgnoreCase("event_type"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
									//break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											System.out.println("Inside strg code from pophelp");
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												System.out.println("Duplicate EUIN NO::");
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [start]
							else if(childNodeName.equalsIgnoreCase("event_time_start") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{

									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									customerName = " for "+customerName;
									errString = itmDBAccessLocal.getErrorString("event_time_start","NULLVSITFR",userId);
									errString = getDescrModifiedErrorString(errString, customerName);
									break;
									
								}
							}
							else if(childNodeName.equalsIgnoreCase("member_present") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								String  memberPresent = checkNull(getSelectedRowValue(dom2, objContext, "member_present",prntCtr));
								scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
								custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));	
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if ("US00000000".equalsIgnoreCase(scCode))  
									{
										String customerName = " for customer Unlisted Stockist";
										errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
								else
								{
									if(Integer.parseInt(memberPresent) <= 0)
									{
										if ("US00000000".equalsIgnoreCase(scCode)) 
										{
											String customerName = " for customer Unlisted Stockist";
											errString = itmDBAccessLocal.getErrorString( "member_present" , "INVMEMPRE" , userId );
											errString = getDescrModifiedErrorString(errString, customerName);

											break;
										}
									}
								}
							}
							/*else if(childNodeName.equalsIgnoreCase("visit_time_from") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									if ( "0000000000".equalsIgnoreCase( scCode ) || "UR00000000".equalsIgnoreCase( scCode ) || "US00000000".equalsIgnoreCase( scCode ) || custType.indexOf("UNLISTED")!= -1 )
									{
										String customerName = " for customer Unlisted Stockist";
										errString = itmDBAccessLocal.getErrorString("visit_time_from","NULLVSITFR",userId);
										errString = getDescrModifiedErrorString(errString, customerName);

										break;
									}
									
								}
							}*/
							else if(childNodeName.equalsIgnoreCase("event_time_end") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									custType = checkNull(getSelectedRowValue(dom2, objContext, "cust_type",prntCtr));									
									
									if ("US00000000".equalsIgnoreCase(scCode) || custType.indexOf("UNLISTED")!= -1 ) 
									{
										String customerName = " for customer Unlisted Stockist";
										errString = itmDBAccessLocal.getErrorString("event_time_end","NULLVSITTO",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									
									
								}
								else
								{

									boolean retFlag=true;
									//String startVisitTime = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, objContext));
								   //String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom1, objContext));
									String startVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_start",prntCtr));
									String endVisitTime = checkNull(getSelectedRowValue(dom2, objContext, "event_time_end",prntCtr));
									scCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									retFlag = validateEndTime(startVisitTime , endVisitTime);
									System.out.println("retFlag["+retFlag+"scCode["+scCode+"]");
									System.out.println("startVisitTime stockist:["+startVisitTime+"]retFlag["+scCode+"]");
									System.out.println("endVisitTime stockist:["+endVisitTime+"]scCode["+scCode+"]");

									if (!retFlag && "US00000000".equalsIgnoreCase( scCode ))
									{
										errString = itmDBAccessLocal.getErrorString("chem_last_visit_time","VTVSTTIM02",userId);
										break;
									}

								}
								
							}
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{

									//changes done by prachi [W22FBAS009]
									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPSTKST",userId);
											errString = getDescrModifiedErrorString(errString, customerName);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										String subStrgCode="";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									String invoiceFormNo = checkNull(getFormNo(objName, "stockistinvoice", connectionObject));
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collectionStockist", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									System.out.println("flg finish stockist parmNamelist  in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("stockistbrand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("stockistinvoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collectionStockist") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
									//changes done by prachi [W22FBAS009]
								}
							}
						}

					}
				}

			}
			// Added by Mrunalini Sinkar on 08-may-2017 for Stockist form validation(end)

			// Added by Prathmesh Jangam on 08-may-2017 for ncw form validation(start)
			if("ncw".equalsIgnoreCase(formName))
			{
				boolean isNotSelectedOnFinish = false;
				String CheckUpdateFlag ="";
				ArrayList ncwVisitList = new ArrayList();
				isNotSelectedOnFinish = isEmptyDOM(dom2 , ""+currentFormNo);
				//System.out.println("isSelectedOnFinish isSelectedOnFinish:- "+isNotSelectedOnFinish);
				ncwVisitList = getSelCustList(dom2, locFormNo, "other_visit");
				String okVar = "Y";
				ArrayList scCodeDupList=new ArrayList();//Added by Bhagyashri T for Duplicate SC code[21/01/22]
				ArrayList euinNoDupList=new ArrayList();//Added by Bhagyashri T for Duplicate EUIN NO[24/01/22]
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;

				//System.out.println("retailer: validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(start)
					if(updateFlag.equalsIgnoreCase("E"))
					{
						String eventDate = checkNull(genericUtility.getColumnValue( "event_date",dom));
						int headerCount = wfValsprsActTran(eventDate, userId,connectionObject);
						if(headerCount==0)
						{
							errString = itmDBAccessLocal.getErrorString(userId,"NORECORD",userId);
							break;
						}

					}
					//added by mrunalini sinkar on 12-july-2018 to remove TRan Id null issue in franco client(end)
					if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
					{
						updateFlagCnt++;
					}
				}

				//System.out.println("selectedFlagCnt [] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
				if(selectedFlagCnt == 0 && updateFlagCnt > 0)
				{
					errString = getErrorString("cust_code","CUSTNOTSEL",userId);
				}
				//TODO
				ncwVisitList = getSelCustList(dom2, locFormNo, "other_visit");
				if(selectedFlagCnt == 0 )
				{
					//	String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, "3"));
					//if(dcrId.length() > 0 )
					{
						//String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, "3"));
						String chemVisitval = "Y";
						if(ncwVisitList.contains(chemVisitval))
						{
							errString = itmDBAccessLocal.getErrorString( "strg_code", "NONCWVISEL", userId );
						}
					}
				}

				if(isNotSelectedOnFinish && (ncwVisitList.contains(okVar)))
				{
					errString = getErrorString("strg_code","NOCUSTSETD",userId);
				}
				if(selectedFlagCnt > 0)
				{
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						//System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}

							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
							//System.out.println("childNodeName =["+childNodeName+"]");

							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									//System.out.println("Value of updateFlag flag is in case retailer:- "+CheckUpdateFlag);
									CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							//System.out.println("Value of update flag is in case retailer:- "+CheckUpdateFlag);
							//if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							if(("D".equalsIgnoreCase(CheckUpdateFlag)) && "2".equals(allowEditCust))
							{
								errString = itmDBAccessLocal.getErrorString("strg_code","DESELCUSTM",userId);
								break;
							}

							if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("sales_pers"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("remarks"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
									break;
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
							else if(childNodeName.equalsIgnoreCase("oth_participant"))
							{
								if(columnValue != null && columnValue.length() >120)
								{
									errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
									break;
								}
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers"))
							{
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][START]
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println("Inside null blank Oth_paticipant next Doctor ");
								}
								else
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
										String uniqStrgcod = checkNull(getSelectedRowValue(dom2, objContext, "uniq_strg_code",prntCtr));
										int StrgCodeCnts = darCommonBean.getStrgCode(strgCode,connectionObject);
										if(StrgCodeCnts >0)
										{
											int EUINnoCnts = darCommonBean.getCntPers(EUINno,strgCode,connectionObject);
											if(EUINnoCnts <= 0)
											{
												String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
												customerName = " for "+customerName;
												errString = itmDBAccessLocal.getErrorString("contact_pers","INVALCNPER",userId);
												errString = getDescrModifiedErrorString(errString, customerName);
												break;
											}
										}
										else if(StrgCodeCnts <=0)
										{
											if(EUINno != null && EUINno.trim().length() < 7 && EUINno.trim().length() >0)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else if(EUINno != null && EUINno.trim().length() > 7)
											{
												errString = itmDBAccessLocal.getErrorString( "contact_pers", "VENTCONCLN", userId );
												break;
											}
											else
											{
												int validEUINCnts = darCommonBean.getValidEuin(EUINno,connectionObject);
												if(validEUINCnts <= 0)
												{
													String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
													customerName = " for "+customerName;
													errString = itmDBAccessLocal.getErrorString("contact_pers","VETCCPSTX",userId);
													errString = getDescrModifiedErrorString(errString, customerName);
													break;
												}
												else
												{
													int DupEUINCntS = darCommonBean.getDupdEuin(EUINno,strgCode,connectionObject);
													if(DupEUINCntS > 0)
													{
														String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
														customerName = " for "+customerName;
														errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
														errString = getDescrModifiedErrorString(errString, customerName);
														break;
													}
													
												}
												
											}
											
										}
									}//end else if
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										if(!CheckUpdateFlag.equalsIgnoreCase("D"))
										{
											if (euinNoDupList.contains(EUINno))
											{
												errString = itmDBAccessLocal.getErrorString("contact_pers","VTDUPEUIN",userId);
												break;
											}
											else
											{
												euinNoDupList.add(EUINno);
											}	
										}
										
									}//end duplicate in dom
								}//end else
								//Changes By Bhagyashri T for EUIN NO VALIDATION[06/01/22][END]
							}
							else if(childNodeName.equalsIgnoreCase("contact_pers_name"))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String EUINno = checkNull(getSelectedRowValue(dom2, objContext, "contact_pers",prntCtr));
									System.out.println("Euin no in sontact pers name::"+EUINno);
									if(EUINno != null && EUINno.trim().length() >0 && "Y".equalsIgnoreCase(isFortuneAct))
									{
										errString = itmDBAccessLocal.getErrorString("contact_pers_name","VMEMBKCNAM",userId);
										break;
									}
								}
							}
							//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][END]
							else if(childNodeName.equalsIgnoreCase("strg_code") && !(CheckUpdateFlag.equalsIgnoreCase("D")))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									
								}
								else
								{
									//changes done by prachi [W22FBAS009] start
									
									String strgCode = checkNull(getSelectedRowValue(dom2, objContext, "strg_code",prntCtr));
									String customerName = checkNull(getSelectedRowValue(dom2, objContext, "strg_name",prntCtr));
									String totalAmount = checkNull(getSelectedRowValue(dom2, objContext, "amount",prntCtr));
									String collectionAmount="";
									String brandFormNo = checkNull(getSelectedRowValue(dom2, objContext, "brand_form_no",prntCtr));
									if(!CheckUpdateFlag.equalsIgnoreCase("D"))
									{
										if (scCodeDupList.contains(columnValue))
										{
											errString = itmDBAccessLocal.getErrorString("sc_code","VTDUPCUST",userId);
											errString = getDescrModifiedErrorString(errString, customerName);
											break;
										}
										else
										{
											scCodeDupList.add(columnValue);
										}	
									}
									NodeList subParentList = dom2.getElementsByTagName("Detail"+ brandFormNo);
									int subParentNodeListLength = subParentList.getLength();
									boolean flg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										String subStrgCode="";
										
										Node subParentNode = subParentList.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "sc_code".equalsIgnoreCase( subChildNodeName ) )
											{
												subStrgCode = genericUtility.getColumnValueFromNode("sc_code", subParentNode);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														flg=false;
														break;
													}

												}
											}
											
										}

									}
									String invoiceFormNo = checkNull(getFormNo(objName, "ncwinvoice", connectionObject));
									NodeList subParentList1 = dom2.getElementsByTagName("Detail"+ invoiceFormNo);
									int subParentNodeListLength1 = subParentList1.getLength();
									boolean invoiceflg=true;
									
									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength1; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList1.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"]");

												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													if(subChildNode.getFirstChild() != null)
													{
														invoiceflg=false;
														break;
													}

												}
											}
											
										}

									}
									String collectionFormNo = checkNull(getFormNo(objName, "collectionNcw", connectionObject));
									NodeList subParentList2 = dom2.getElementsByTagName("Detail"+ collectionFormNo);
									int subParentNodeListLength2 = subParentList2.getLength();
									boolean collectionflg=true;

									for (int subPrntCtr = 0; subPrntCtr < subParentNodeListLength2; subPrntCtr++ )
									{
										String subUpdateFlag = "";
										
										Node subParentNode = subParentList2.item(subPrntCtr);
										NodeList subChildList = subParentNode.getChildNodes();
										int subNoOfChilds = subChildList.getLength();
										for (int subCtr = 0; subCtr < subNoOfChilds; subCtr++)
										{
											Node subChildNode = subChildList.item(subCtr);
											//System.out.println("childnode is: "+childNode);
											if( subChildNode.getNodeType() != Node.ELEMENT_NODE )
											{
												continue;
											}
											String subChildNodeName = subChildNode.getNodeName();
											//System.out.println("childNodeName =["+childNodeName+"]");
											if(subChildNodeName.equalsIgnoreCase("attribute"))
											{
												if(subChildNode.getAttributes().getNamedItem("updateFlag") != null)
												{
													subUpdateFlag = subChildNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
												}
											}
											else if ( "strg_code".equalsIgnoreCase( subChildNodeName ) )
											{
												String subStrgCode = genericUtility.getColumnValueFromNode("strg_code", subParentNode);
												System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] subUpdateFlag:"+subUpdateFlag);
												if(subStrgCode.equalsIgnoreCase(strgCode) && !subUpdateFlag.equalsIgnoreCase("D"))
												{
													subChildNode = subChildList.item(subCtr);
													collectionAmount = genericUtility.getColumnValueFromNode("amount", subParentNode);
													System.out.println("Inside subStrgCode["+subStrgCode+"]strgCode["+strgCode+"] collectionAmount:"+collectionAmount+" totalAmount:"+totalAmount);

													if(subChildNode.getFirstChild() != null)
													{
														collectionflg=false;
														if((!totalAmount.equals(collectionAmount)))
														{
															errString = itmDBAccessLocal.getErrorString( "amount" , "AMTMISMTC" ,userId);
															errString = getDescrModifiedErrorString(errString, customerName);
															break;
														}
														else
														{
														  break;
														}  
													}

												}
												
											}
											
										}

									}
									
									System.out.println("flg finish ncw parmNamelist  in wfvaldata: :["+parmNamelist+"]sfaparmBrand["+sfaparmBrand+"]flg["+flg+"] invoiceflg:"+invoiceflg+" collectionflg:"+collectionflg);

									if(parmNamelist.contains("ncwbrand") && "Y".equalsIgnoreCase(sfaparmBrand) && flg==true)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","PROMANDATE",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("ncwinvoice") && "Y".equalsIgnoreCase(sfaparmBrand) && invoiceflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("item_code","MANFORMINV",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									else if(parmNamelist.contains("collectionNcw") && "Y".equalsIgnoreCase(sfaparmBrand) && collectionflg==true)
									{
										errString = itmDBAccessLocal.getErrorString("pay_mode","MANFORMCOL",userId);
										errString = getDescrModifiedErrorString(errString, customerName);
										break;
									}
									if(flg==false && invoiceflg==false && collectionflg==false)
									{
										break;
									}
									//changes done by prachi [W22FBAS009] end
								}
							}


						}

					}
				}
			}
			
			//ADDED BY PRACHI FOR W21KSUN026
			if ( errString.length() <= 0)
			{
				errStringXml1.append("</Errors></Root>\r\n");
				//return errString;
				errorString2 = errStringXml1.toString();
				Document responseDom = genericUtility.parseString( errorString2 );
				Node errorsNode = responseDom.getElementsByTagName( "Errors" ).item( 0 );
				if( errorsNode != null )
				{
					NodeList errorChildNodeList = errorsNode.getChildNodes();
					for(int appCnt = 0; appCnt < errorChildNodeList.getLength(); appCnt++)
					{
						Node currChild = errorChildNodeList.item(appCnt);
						if (currChild.getNodeName().equalsIgnoreCase("error"))
						{
							errString = errStringXml1.toString();
							break;
						}
						else
						{
							errString =  "";

						}
					}
				}
			}

			// Added by Prathmesh Jangam on 08-may-2017 for ncw form validation(end)

			/*if(errString.indexOf("<Errors>")!=-1)
			{
				//System.out.println("inside the error");
				if( errString.length() > 0 )
				{
					String msgDescr = "";
					//msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;
					msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + customerName ;
					//System.out.println("msgDescr the error["+msgDescr+"]cust name["+customerName+"]");

					if( customerName.length() != 0 && !customerName.equalsIgnoreCase("") )
					{
						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
					}
				}
			}*/
		}
		catch(Exception e)
		{
			e.printStackTrace();
			copyLogFile();//Gulzar 16/11/12
			//Changed By Gaurav Singh on 16/09/09[ W15BMIT002 | to catch exception and send errorstring] Start
			errString = "";

			errString = genericUtility.createErrorString( e ) ;
			String messageValue="",message = "";

			if( errString.indexOf("<Errors>")!=-1 )
			{
				if( errString.length() > 0 )
				{
					String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
					messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
					String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
					message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

					//System.out.println("errorMessage==>"+messageValue);
					StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
					valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
					valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
					valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
					valueXmlErrorString.append("<type>E</type>\r\n");
					valueXmlErrorString.append("<option></option>\r\n");
					valueXmlErrorString.append("<time></time>\r\n");
					valueXmlErrorString.append("<alarm></alarm>\r\n");
					valueXmlErrorString.append("<source></source>\r\n");
					valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
					valueXmlErrorString.append("<redirect>1</redirect>\r\n");
					valueXmlErrorString.append("</error>\r\n");
					valueXmlErrorString.append("</Errors>\r\n");
					valueXmlErrorString.append("</Header>\r\n");
					valueXmlErrorString.append( "</Root>\r\n" );
					//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
					errString =valueXmlErrorString.toString();
				}

			}
		}
		finally
		{
			try
			{
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(actRs != null)
				{
					actRs.close();
					actRs = null;
				}
				if (actPstmt != null)
				{
					actPstmt.close();
					actPstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				//System.out.println( "Exception :StrgMeetDCRWiz :defaultDataWiz :==>\n"+e.getMessage());
				errString = "";

				errString = genericUtility.createErrorString( e ) ;
				//System.out.println( "errString :Dipak:" +errString + ":" );
				String messageValue="",message = "";

				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
						messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
						String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
						message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

						//System.out.println("errorMessage==>"+messageValue);
						StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
						valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
						valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
						valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
						valueXmlErrorString.append("<type>E</type>\r\n");
						valueXmlErrorString.append("<option></option>\r\n");
						valueXmlErrorString.append("<time></time>\r\n");
						valueXmlErrorString.append("<alarm></alarm>\r\n");
						valueXmlErrorString.append("<source></source>\r\n");
						valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
						valueXmlErrorString.append("<redirect>1</redirect>\r\n");
						valueXmlErrorString.append("</error>\r\n");
						valueXmlErrorString.append("</Errors>\r\n");
						valueXmlErrorString.append("</Header>\r\n");
						valueXmlErrorString.append( "</Root>\r\n" );
						//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
						errString =valueXmlErrorString.toString();

					}
				}
			}
		}
		System.out.println("errString ["+errString+"]");
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println ( "**********************itemChanged Called********");
			System.out.println ( "xmlString :" + xmlString);
			System.out.println ( "xmlString1 :" + xmlString1);
			System.out.println ( "xmlString2 :" + xmlString2);

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams, formName );
			//System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{

			String errString1 = "";
			StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
			System.out.println( "Exception :StrgMeetDCRWiz :defaultDataWiz(String,String):" + e.getMessage() + ":" );
			errString1 = genericUtility.createErrorString( e ) ;
			System.out.println( "errString :Exception :StrgMeetDCRWiz :defaultDataWiz(String,String)::" +errString1 + ":" );

			if ( errString.length() > 0)
			{
				String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
				bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
				bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
				errStringXml.append(bifurErrString);
				System.out.println("errStringXml .........."+errStringXml);
				errString1 = "";
			}
			errStringXml.append("</Errors></Root>\r\n");
			errString = errStringXml.toString();
			System.out.println("retString ...DIPAK......."+errString);
			throw new ITMException(e);

		}
		System.out.println ( "returning from StrgMeetDCRWiz defaultDataWiz" );
		return errString;
	}

	//Code for Default Data
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		System.out.println("Inside itemchange strgMeetDCRWiz");
		String returnStr="";
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,k=0,childNodeListLength=0;
		String columnValue = null;
		String childNodeName = null;
		Connection conn = null;
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",descr ="";
		String userId = "",loginSite = "" ,empFname = "",empLname = "",query ="";
		String deptHead="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try{

			System.out.println("currentColumn::"+currentColumn+" formName:"+formName);
			returnStr = defaultDataWiz(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams, formName);
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if(objContext != null && objContext.trim().length() > 0)
				k = Integer.parseInt(objContext);
		}
		catch(Exception e){
			e.printStackTrace();
			throw new ITMException(e);
		}
		return returnStr;
	}


	public String defaultDataWiz() throws RemoteException, ITMException
	{
		return "";
	}

	private String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName ) throws RemoteException,ITMException
	{
		//System.out.println("Inside itemchange defaultDataWiz");
		ResultSet rs = null;
		Connection connectionObject = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;

		String sql = "";
		String userId = "";
		String sprsName = "";
		String actDescr = "";
		String currDate = "";
		String datetime="";
		String locDescr ="";
		String chgTerm ="";
		String preFormDet ="";
		String [] temp = new String [10];
		String returnStr = "";
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		PreparedStatement planPstmt = null;
		ResultSet planRs = null;

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String []placeOfReturn = new String [2];
		String placeOfReturnDescr="";
		String placeOfReturnStr="";
		String lastDispDCRDate = "";
		String lastConfirmed = "";
		
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			connectionObject = getConnection();
			String loginCode=checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			userId = getEmpCode(userId, connectionObject);
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dateTimeFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			datetime=dateTimeFormat.format( date );
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
			if("mainform".equalsIgnoreCase(formName))
			{
				DARCommonBean darCommonBean= new DARCommonBean();
				String defaultVal = getSfaParmValue(userId,"DEFAULT_DATE_SET",connectionObject);
				String empDesign = getDesignName(userId, connectionObject);
				String grade = getGrade(userId, connectionObject);
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));

					String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
					String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
					String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
					String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
					String stockistFormNo = checkNull(getFormNo(objName, "stockist", connectionObject));
					String ncw = checkNull(getFormNo(objName, "ncw", connectionObject));
					String eventDateDom = checkNull(genericUtility.getColumnValue("event_date", dom2, "1"));
					String callReport = checkNull(genericUtility.getColumnValue("call_report", dom2, "1"));
					String currEventDate = "";
					String dateFormat = getApplDateFormat();
					String planDataString="";
					sprsName=darCommonBean.getSalesPersName(userId, connectionObject);

					//Added by mrunalini sinkar to showing headquarter in summary page (start)
					String stanCodeHQ="",headQaurter="";
					String hqSql="SELECT EMP.STAN_CODE__HQ AS STAN_CODE__HQ,ST.DESCR AS HEADQAURTER FROM EMPLOYEE EMP,STATION ST WHERE EMP.EMP_CODE=? AND EMP.STAN_CODE__HQ=ST.STAN_CODE";
					pstmt =  connectionObject.prepareStatement(hqSql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stanCodeHQ = checkNull(rs.getString("STAN_CODE__HQ"));
						headQaurter = checkNull(rs.getString("HEADQAURTER"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					String allowDrUnlist = checkNull(getSfaParmValue(userId,"ALLOW_DR_UNLIST_DAR",connectionObject));
					String allowChemistUnlist = checkNull(getSfaParmValue(userId,"ALLOW_CH_UNLIST_DAR",connectionObject));
					String allowStockistVisit = checkNull(getSfaParmValue(userId,"ALLOW_SK_UNLIST_DAR",connectionObject));
					String darParmData = checkNull(getSfaParmValue(userId, "ALLOW_STOCKIST_DAR", connectionObject));//Added by shradha
					String editSumDefData = checkNull(getSfaParmValue(userId, "DEF_SUMRY_EDIT_DATA", connectionObject));
					String isFortuneActivity = checkNull(getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", connectionObject));
					String locCodeFrom = getStanCodeFrom( connectionObject, userId, currDate,"" );
					locDescr=darCommonBean.getLocalityDescr(locCodeFrom, connectionObject);

					String lastDCRDate ="";
					String eventDate1="";
					java.util.Date lastDCRDate1 = null;
					java.util.Date jDate = null;
					java.util.Date applStartDate = null;
					String propSql = "";
					PreparedStatement selectPstmt = null;
					ResultSet selectRs = null;
					boolean isNewEmpJoin=false;
					int count = 0;
					int cntActTran = 0;
					//Added by mrunalini to remove excced limit start
					count=darCommonBean.getCountFromTable("SPRS_ACT_TRAN",userId,connectionObject);
					cntActTran=count;
					/*String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ?";
					selectPstmt = connectionObject.prepareStatement(selectSql);
					selectPstmt.setString(1,userId);
					selectRs = selectPstmt.executeQuery();
					if(selectRs.next())
					{
						count = selectRs.getInt("COUNT");
						cntActTran = count;
					}
					if(selectRs != null)
					{
						selectRs.close();
						selectRs = null;
					}
					if(selectPstmt != null)
					{
						selectPstmt.close();
						selectPstmt = null;
					}*/
					//Added by mrunalini to remove excced limit End

					String oldData=checkNull(getSfaParmValue(userId, "OLD_METIS_DAR_DATA", connectionObject));
					boolean oldDataCheck=false;
					int drMainCnt=0;
					if("Y".equalsIgnoreCase(oldData))
					{
						//Added by mrunalini to remove excced limit Start

						drMainCnt=darCommonBean.getCountFromTable("DR_MAIN",userId,connectionObject);
						/*String oldSelectSql = "SELECT COUNT(*) AS COUNT FROM DR_MAIN WHERE SALES_PERS = ?";
						selectPstmt = connectionObject.prepareStatement(oldSelectSql);
						selectPstmt.setString(1,userId);
						selectRs = selectPstmt.executeQuery();
						if(selectRs.next())
						{
							drMainCnt = selectRs.getInt("COUNT");
						}
						if(selectRs != null)
						{
							selectRs.close();
							selectRs = null;
						}
						if(selectPstmt != null)
						{
							selectPstmt.close();
							selectPstmt = null;
						}*/
						//Added by mrunalini to remove excced limit End
					}
					//Added By Mrunalini Sinkar for showing data old metis data wise (end)

					if(count > 0)
					{
						String actTranDcrDate="";
						//Added by mrunalini to remove excced limi(Start)

						actTranDcrDate=darCommonBean.getMaxDate(userId, currDate, "SPRS_ACT_TRAN", "EVENT_DATE", connectionObject);
						/*sql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE EVENT_DATE <= ? AND SALES_PERS = ? "+
								"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')"; // added by condition rupali on 14/03/17 for separate pr menu
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						pstmt.setString(2, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							actTranDcrDate = rs.getString("LAST_DCR_DATE");
							//System.out.println("lastDCRDate =["+lastDCRDate+"]");
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}*/
						//Added by mrunalini to remove excced limi(End)

						//Added By Mrunalini Sinkar for showing data old metis data wise (Start)
						if(drMainCnt>0 && "Y".equalsIgnoreCase(oldData))
						{
							String drMainDcrDate="";
							
							drMainDcrDate=darCommonBean.getMaxDate(userId, currDate, "DR_MAIN", "WORK_DATE", connectionObject);

							//Added by mrunalini to remove excced limi(Start)
							/*sql = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE WORK_DATE <= ? AND SALES_PERS = ? "+
									"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')"; // added by condition rupali on 14/03/17 for separate pr menu
							pstmt =  connectionObject.prepareStatement(sql);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							pstmt.setString(2, userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								drMainDcrDate = rs.getString("LAST_DCR_DATE");
								//System.out.println("lastDCRDate =["+lastDCRDate+"]");
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}*/
							//Added by mrunalini to remove excced limi(End)

							SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
							java.util.Date drMainDate = null;
							java.util.Date actTranDate = null;
							if (drMainDcrDate != null && drMainDcrDate.trim().length() > 0)
							{
								drMainDate = dbFormat.parse(drMainDcrDate);
							}
							if (actTranDcrDate != null && actTranDcrDate.trim().length() > 0)
							{
								actTranDate = dbFormat.parse(actTranDcrDate);
							}

							if (drMainDate != null && actTranDate != null )
							{
								if(drMainDate.after(actTranDate))
								{
									oldDataCheck=true;
									lastDCRDate = drMainDcrDate;
								}
								else
								{
									lastDCRDate = actTranDcrDate;
								}
							}
						}
						else
						{
							lastDCRDate = actTranDcrDate;
						}
						//Added By Mrunalini Sinkar for showing data old metis data wise (end)
					}
					//Added By Mrunalini Sinkar for showing data old metis data wise (Start)

					else if(drMainCnt>0 && "Y".equalsIgnoreCase(oldData) && count==0)
					{
						String drMainDcrDate="";

						sql = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE WORK_DATE <= ? AND SALES_PERS = ? "+
								"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')"; // added by condition rupali on 14/03/17 for separate pr menu
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						pstmt.setString(2, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							oldDataCheck=true;
							lastDCRDate = rs.getString("LAST_DCR_DATE");
							//System.out.println("lastDCRDate =["+lastDCRDate+"]");
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					//Added By Mrunalini Sinkar for showing data old metis data wise (End)
					else
					{
						// changes made by rupali on  15/02/19 as suggected by gulzar sir
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
						 String propDate=darCommonBean.getPropVal("APPL_START_DAR", connectionObject);
						//System.out.println("Appl_Start_Date =====["+propDate+"]");
						//propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'APPL_START_DCR'";
						/*propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'APPL_START_DAR'";
						propPstmt =  connectionObject.prepareStatement(propSql);
						propRs = propPstmt.executeQuery();
						if(propRs.next())
						{
							propDate = propRs.getString("PROP_VALUE");
							propDate = genericUtility.getValidDateString(propDate, genericUtility.getDBDateFormat() ); // commented by rupali on 09/11/17 for slving date parsing issue while entering first dcr
						}
						//System.out.println("Appl_Start_Date =====["+propDate+"]");
						if (propRs!= null)
						{
							propRs.close();
							propRs = null;
						}
						if(propPstmt!=null)
						{
							propPstmt.close();
							propPstmt = null;
						}
							*/
						String joinDate=darCommonBean.getJoinDate(userId, connectionObject);
						//System.out.println("joinDate=== ["+joinDate + "]");
						/*joinDateSql = "SELECT DATE_JOIN-1 AS DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = ? ";
						joinDatePstmt =connectionObject.prepareStatement(joinDateSql);
						joinDatePstmt.setString(1,userId);
						joinDateRs = joinDatePstmt.executeQuery();
						if(joinDateRs.next())
						{
							joinDate = joinDateRs.getString("DATE_JOIN");
						}
						//System.out.println("joinDate=== ["+joinDate + "]");
						if (joinDateRs!= null)
						{
							joinDateRs.close();
							joinDateRs = null;
						}
						if(joinDatePstmt!=null)
						{
							joinDatePstmt.close();
							joinDatePstmt = null;
						}*/
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
						SimpleDateFormat formatter = new SimpleDateFormat(genericUtility.getDBDateFormat());

						if (joinDate != null && joinDate.trim().length() > 0)
						{
							isNewEmpJoin=true;
							lastDCRDate = joinDate;
							jDate = formatter.parse(joinDate);
						}
						if (propDate != null && propDate.trim().length() > 0)
						{
							/*// added by rupali on 09/11/17 for slving date parsing issue while entering first dcr [start]
							SimpleDateFormat inputFormat=new SimpleDateFormat("dd/MM/yyyy");
							Date eventDate=null;
							eventDate = inputFormat.parse(propDate);
						    DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
						    propDate=sdf.format(eventDate);
						    // added by rupali on 09/11/17 for slving date parsing issue while entering first dcr [end]
							 */							
							applStartDate = formatter.parse(propDate);
						}
						if (jDate != null && applStartDate != null )
						{
							if(jDate.after(applStartDate))
							{
								isNewEmpJoin=true;
								lastDCRDate = joinDate;
							}
							else
							{
								isNewEmpJoin=false;
								lastDCRDate = propDate;
							}
						}
						//System.out.println("lastDCRDate ====["+lastDCRDate+"]");
					}

					//Changed by rahul on 24 jul 2015 [ for getting last_dcr_date from employee or properties master if not present in sprs_act_tran | END]

					sql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE CONFIRMED='Y' and SALES_PERS = ?";
					PreparedStatement pstmtMaxDt =  connectionObject.prepareStatement(sql);
					pstmtMaxDt.setString(1, userId);
					ResultSet rsMaxDt = pstmtMaxDt.executeQuery();
					if(rsMaxDt.next())
					{
						lastConfirmed = rsMaxDt.getString("LAST_DCR_DATE");
						//System.out.println("lastConfirmedDate =["+lastConfirmed+"]");
					}
					if (rsMaxDt!= null)
					{
						rsMaxDt.close();
						rsMaxDt = null;
					}
					if(pstmtMaxDt!=null)
					{
						pstmtMaxDt.close();
						pstmtMaxDt = null;
					}

					Date lastConfirmedDate = null;
					DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
					if(lastConfirmed == null || lastConfirmed.trim().length() == 0)
					{
						//System.out.println("lastConfirmed is null =["+lastConfirmed+"]");
					}
					else
					{
						lastConfirmedDate=dbFormat.parse( lastConfirmed );
						date=dbFormat.parse( dbFormat.format(date) );
					}

					String propValue = getPropertiesVal(connectionObject, "DISP_NEXT_DCR_DATE");
					String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
					String workWith = checkNull(genericUtility.getColumnValue("visited_with_display", dom1));

					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
					Calendar cal = Calendar.getInstance();
					Date currDates =cal.getTime();// added by mrunalini sinkar to set current date if lastdcrdate same as currentdate

					cal.setTime( sdf.parse(lastDCRDate) );
					cal.add(Calendar.DATE, 1);
					sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					// added by mrunalini sinkar to set current date if lastdcrdate same as currentdate(start)
					SimpleDateFormat sdfDB = new SimpleDateFormat(genericUtility.getDBDateFormat());
					lastDCRDate1=sdfDB.parse(lastDCRDate);
					//System.out.println("lastDCRDates["+lastDCRDate1+"]");
					String currentDates=sdfDB.format(currDates);
					Date currenDate = sdfDB.parse(currentDates);
					// added by mrunalini sinkar to set current date if lastdcrdate same as currentdate(end)
					String isPrExist = "N";

					if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(defaultVal) && !(lastDCRDate1.equals(lastConfirmedDate)) && cntActTran > 0 && oldDataCheck==false)
					{
						SimpleDateFormat sdfFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
						Calendar calDate = Calendar.getInstance();
						calDate.setTime( sdfFormat.parse(lastDCRDate) );
						currEventDate = sdf.format(calDate.getTime());
					}
					else if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue) &&  !(lastDCRDate1.compareTo(currenDate)==0))
					{
						currEventDate = sdf.format(cal.getTime());
					}
					else
					{
						currEventDate = currDate;
					}

					//System.out.println("currDate::"+currDate);
					//System.out.println("currEventDate is:["+currEventDate+"]");
					String  validWorkDate = checkNull(getNextValidWorkDate( currEventDate, userId,connectionObject ));
					//System.out.println("validWorkDate["+validWorkDate+"]");

					String countPrSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.SALES_PERS = ? AND A.EVENT_DATE = ? AND B.ACTIVITY_TYPE='PR'";
					PreparedStatement prPstmt = connectionObject.prepareStatement(countPrSql);
					prPstmt.setString(1,userId);
					prPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					ResultSet prRs = prPstmt.executeQuery();
					if(prRs.next())
					{
						count = prRs.getInt("COUNT");
					}
					if(prRs != null)
					{
						prRs.close();
						prRs = null;
					}
					if(prPstmt != null)
					{
						prPstmt.close();
						prPstmt = null;
					}
					if(count > 0)
					{
						isPrExist = "Y";
					}

					//Added by mrunalini sinkar for journey from add mode changes(start)
					String eventDateDBFmt="";
					String routeId="";
					String sprsCode="",lastLocCode="",lastStanCode="",lastLocDescr="";
					HashMap<String, String> routeSprsMap =new HashMap<String, String>();

					if("Y".equalsIgnoreCase(callReport))
					{
						eventDateDBFmt = genericUtility.getValidDateTimeString( eventDateDom, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					}
					else
					{
						eventDateDBFmt = genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					}
					routeSprsMap = getRouteId(userId,eventDateDBFmt,connectionObject);
					//System.out.println("routeSprsMap is:["+routeSprsMap+"]");

					if(!routeSprsMap.isEmpty())
					{
						for (Entry<String, String> entry: routeSprsMap.entrySet())
						{
							routeId= entry.getKey();
							sprsCode= entry.getValue();
						}
					}

					String lastRouteId=routeId;
					String locCodeSql = "SELECT SR.LOCALITY_CODE,SR.STAN_CODE AS STAN_CODE,ST.DESCR AS DESCR FROM SPRS_ROUTE SR,STATION ST WHERE SPRS_CODE = ? AND ROUTE_ID= ? AND SR.STAN_CODE = ST.STAN_CODE AND SR.STATUS='Y'";
					pstmt = connectionObject.prepareStatement(locCodeSql);
					pstmt.setString(1, sprsCode);
					pstmt.setString(2, lastRouteId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lastLocCode = checkNull(rs.getString("LOCALITY_CODE"));
						lastLocDescr=checkNull(rs.getString("DESCR"));
						lastStanCode =checkNull(rs.getString("STAN_CODE"));
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}


					//Added by mrunalini sinkar for journey add mode from changes(end)
					//Added by mrunalini sinkar for journey edit mode from changes(start)
					int cnt=0;
					String countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, SPRS_TRAVEL B WHERE A.EVENT_DATE = B.TRAVEL_DATE AND A.SALES_PERS = B.SALES_PERS AND  A.SALES_PERS = ? AND A.EVENT_DATE = ?";
					pstmt = connectionObject.prepareStatement(countSql);
					pstmt.setString(1,userId);
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						cnt = rs.getInt("COUNT");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(cnt>0)
					{
						String locEdiCodeSql = "SELECT LOCALITY_CODE_FROM,STAN_CODE__FROM,ROUTE_ID_FROM FROM SPRS_TRAVEL ST,SPRS_ROUTE SR  "
								+ "WHERE TRAVEL_DATE=? AND SALES_PERS=? AND ORDER_OF_VISIT=(SELECT MIN(ORDER_OF_VISIT) FROM SPRS_TRAVEL WHERE "
								+ "TRAVEL_DATE=? AND SALES_PERS=?) " +
								"AND SR.SPRS_CODE=ST.SALES_PERS AND SR.ROUTE_ID=ST.ROUTE_ID AND SR.LOCALITY_CODE=ST.LOCALITY_CODE";
						pstmt = connectionObject.prepareStatement(locEdiCodeSql);
						pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						pstmt.setString(2, userId);
						pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						pstmt.setString(4, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lastLocCode = checkNull(rs.getString("LOCALITY_CODE_FROM"));
							lastStanCode=checkNull(rs.getString("STAN_CODE__FROM"));
							lastRouteId=checkNull(rs.getString("ROUTE_ID_FROM"));

						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						String locDescrOldSql = "SELECT ROUTE_DESCR__START AS DESCR FROM SPRS_ACT_TRAN  WHERE EVENT_DATE=? AND SALES_PERS=?";
						pstmt = connectionObject.prepareStatement(locDescrOldSql);
						pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						pstmt.setString(2, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lastLocDescr = checkNull(rs.getString("DESCR"));

						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}

						if(lastLocDescr==null && lastLocDescr.trim().length()==0)
						{
							//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
							lastLocDescr=darCommonBean.getlocDescrOld(userId,lastRouteId, connectionObject);
							//System.out.println("lastLocDescr::"+lastLocDescr);
							/*String locDescrOldSql1 = "SELECT ST.DESCR AS DESCR FROM SPRS_ROUTE SR,STATION ST WHERE SPRS_CODE = ? AND ROUTE_ID= ? AND SR.STAN_CODE = ST.STAN_CODE AND SR.STATUS='Y'";
							pstmt = connectionObject.prepareStatement(locDescrOldSql1);
							pstmt.setString(1, userId);
							pstmt.setString(2, lastRouteId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								lastLocDescr = checkNull(rs.getString("DESCR"));

							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}*/
							//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
						}
					}

					String []planDataArr = new String [2];
					String formNum = "";
					if(isPlanCumpulsory.equalsIgnoreCase("Y"))
					{
						planDataArr = getPlanData(userId,validWorkDate, connectionObject);
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
						formNum = darCommonBean.getFormNum(connectionObject);
						//System.out.println("formNum are::"+formNum);
						/*String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= 'w_strg_meet_dcr_wiz' AND FORM_NAME IN('place','doctor','retailer','stockist') ORDER BY TO_NUMBER(FORM_NO)";
						PreparedStatement objFormpstmt = connectionObject.prepareStatement(objFormSql);
						ResultSet objFormrs = objFormpstmt.executeQuery();
						while(objFormrs.next())
						{
							String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
							if(formNum == null || formNum.trim().length() == 0)
							{
								formNum = objFormNo;
							}
							else
							{
								formNum = formNum + "," + objFormNo;
							}
						}
						if(objFormrs != null)
						{
							objFormrs.close();
							objFormrs = null;
						}
						if(objFormpstmt != null)
						{
							objFormpstmt.close();
							objFormpstmt = null;
						}*/
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
					}


					//Added by mrunalini sinkar for journey edit mode from changes(end)
					//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
					String sqlActivity = "SELECT SP.ACTIVITY_CODE CODE,SP.OTH_PARTICIPANT OTHERS,FD.DESCR DESCR,FD.ACTIVITY_TYPE ATYPE,FD.PLACE_REQUIRED AS PLACE_REQUIRED,SP.COPY_PLAN AS COPY_PLAN,SP.DCR_ID AS DCR_ID , SP.TRAN_ID AS TRAN_ID " //tran id added by Gulzar on 04/07/17
							+" , SP.TOT_CALLS, SP.PRODUCTIVE_CALLS, SP.UDF_STR1, SP.UDF_NUM1,SP.SUBMISSION_DATE,SP.REMARK REMARK " //Added by kailash on 12/dec/17
							+" FROM SPRS_ACT_TRAN SP,FIELDACTIVITY FD WHERE EVENT_DATE=? "
							+" AND SALES_PERS=? AND FD.ACTIVITY_CODE = SP.ACTIVITY_CODE AND FD.ACTIVITY_TYPE <> 'PR'";
					pstmt =  connectionObject.prepareStatement(sqlActivity);

					if("Y".equalsIgnoreCase(callReport))
					{
						pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDateDom, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					}
					else
					{
						pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					}
					pstmt.setString(2, checkNull(userId));
					rs = pstmt.executeQuery();

					if(rs.next())
					{
						String submissionDate=checkNull(rs.getString("SUBMISSION_DATE"));
						String dcrId=checkNull(rs.getString("DCR_ID"));
						String actType= checkNull(rs.getString("ATYPE")) ;
						String actCode= checkNull(rs.getString("CODE")) ;
						String otherParticipant=checkNull(rs.getString("OTHERS"));
						
						String useDate="";
						String subDispDAte="";
						String teamDetail = getExistingTeamDetail(userId,validWorkDate,connectionObject); //chnged by sachin satre on [9-nov-16] to get connection

						if(teamDetail.length() > 0)
						{
							workWith = getWorkWithList(teamDetail,docFormNo);
						}
						//System.out.println("workWith :: ["+workWith+"]");
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gulzar on 05/05/14
						if("Y".equalsIgnoreCase(callReport))
						{
							useDate=eventDateDom;
							valueXmlString.append( "<event_date><![CDATA[" ).append( eventDateDom ).append("]]></event_date>\r\n" );
							lastDispDCRDate = getMaxDisplayDCRDate(userId,eventDateDom,connectionObject);
						}
						else
						{
							useDate=validWorkDate;

							//if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue) &&  !(lastDCRDate1.compareTo(currenDate)==0))
							//{
								valueXmlString.append( "<event_date><![CDATA[" ).append( validWorkDate ).append("]]></event_date>\r\n" );
							//}
							//else
							//{
								//valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append("]]></event_date>\r\n" );
							//}
							lastDispDCRDate = getMaxDisplayDCRDate(userId,validWorkDate,connectionObject);
						}
						if(isFortuneActivity.equalsIgnoreCase("Y"))
						{
							valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull(actCode) ).append( "]]></activity_code>\r\n" );					
						}
						else
						{
							valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull(actCode) ).append( "]]></activity_code>\r\n" );
						}
						//valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull(actCode) ).append( "]]></activity_code>\r\n" );
						valueXmlString.append( "<activity_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR")) ).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append( checkNull(actType) ).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<place_required><![CDATA[" ).append( checkNull(rs.getString("PLACE_REQUIRED")) ).append( "]]></place_required>\r\n" ); //Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
						valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(sprsName).append( "]]></sales_pers_sp_name>\r\n" );
						//valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( locCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
						//valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( locDescr ).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<sprs_locality_code><![CDATA[" ).append( lastLocCode ).append( "]]></sprs_locality_code>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( lastLocDescr ).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<route_descr__start><![CDATA[" ).append( lastLocDescr ).append( "]]></route_descr__start>\r\n" );
						valueXmlString.append( "<sprs_route_route_id><![CDATA[" ).append( lastRouteId ).append( "]]></sprs_route_route_id>\r\n" );
						valueXmlString.append( "<sprs_route_stan_code><![CDATA[" ).append( lastStanCode ).append( "]]></sprs_route_stan_code>\r\n" );
						if (lastDispDCRDate != null && lastDispDCRDate.trim().length()>0 )
						{
							valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDispDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
						}
						else if (lastDCRDate != null && lastDCRDate.trim().length()>0 )
						{
							valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
						}
						valueXmlString.append( "<oth_participant><![CDATA[" ).append( otherParticipant ).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with_display><![CDATA[" ).append("").append( "]]></visited_with_display>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<remark><![CDATA[" ).append(checkNull(rs.getString("REMARK"))).append( "]]></remark>\r\n" );//Gulzar

						if (submissionDate != null && submissionDate.trim().length()>0 )
						{
							subDispDAte=checkNull(getEditSubmitDate(userId,useDate,connectionObject));
							valueXmlString.append( "<submission_date><![CDATA[" ).append(checkNull(genericUtility.getValidDateString( submissionDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat()))).append( "]]></submission_date>\r\n" );//Added by Mrunalini Sinkar
						}
						else
						{
							subDispDAte=checkNull(getSubmissionDisplayDate(connectionObject));
							valueXmlString.append( "<submission_date><![CDATA[" ).append(datetime).append( "]]></submission_date>\r\n" );
						}
						valueXmlString.append( "<submit_show_date><![CDATA[" ).append(subDispDAte).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<copy_plan><![CDATA[" ).append(rs.getString("COPY_PLAN")).append( "]]></copy_plan>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrId).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append(rs.getString("TRAN_ID")).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
						if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue))
						{
							//System.out.println("in ifff!!!!");
							planDataString=getDSRPlanData(userId, sdf.format(cal.getTime()),connectionObject);
						}
						else
						{
							//System.out.println("in elseee!!!!");
							planDataString=getDSRPlanData(userId, currDate,connectionObject);
						}
						//System.out.println("planDataString=["+planDataString+"]");
						valueXmlString.append(planDataString);
						//valueXmlString.append("<Detail"+objContext+" domID='1'>");
						valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );
						//Change by Gulzar on 08/12/17 start
						//System.out.println("tOT_CALLSL----------------");
						valueXmlString.append( "<tot_calls><![CDATA[" ).append( checkNull(rs.getString("TOT_CALLS")) ).append("]]></tot_calls>\r\n" );
						valueXmlString.append( "<productive_calls><![CDATA[" ).append( checkNull(rs.getString("PRODUCTIVE_CALLS")) ).append("]]></productive_calls>\r\n" );
						valueXmlString.append( "<udf_str1><![CDATA[" ).append( checkNull(rs.getString("UDF_STR1")) ).append("]]></udf_str1>\r\n" );
						valueXmlString.append( "<udf_num1><![CDATA[" ).append( checkNull(rs.getString("UDF_NUM1")) ).append("]]></udf_num1>\r\n" );
						//Change by Gulzar on 08/12/17 end
						//addded by mrunalini sinkar 27-june-2018 on(start)
						valueXmlString.append( "<oth_participant><![CDATA[" ).append(checkNull(rs.getString("OTHERS"))).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with><![CDATA[" ).append(teamDetail).append( "]]></visited_with>\r\n" );
						//addded by mrunalini sinkar 27-june-2018 on(end)
						//Added by mrunalini sinkar for dar migration changes (start)
						valueXmlString.append( "<allow_dr_unlist_dar><![CDATA[" ).append(checkNull(allowDrUnlist)).append( "]]></allow_dr_unlist_dar>\r\n" );
						valueXmlString.append( "<allow_ch_unlist_dar><![CDATA[" ).append(checkNull(allowChemistUnlist)).append( "]]></allow_ch_unlist_dar>\r\n" );
						valueXmlString.append( "<allow_sk_unlist_dar><![CDATA[" ).append(checkNull(allowStockistVisit)).append( "]]></allow_sk_unlist_dar>\r\n" );
						//Added by mrunalini sinkar for dar migration changes (end)
						valueXmlString.append( "<allow_stockist_dar><![CDATA[" ).append(checkNull(darParmData)).append( "]]></allow_stockist_dar>\r\n" );
						valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "EDIT REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19
						valueXmlString.append( "<planed_locality><![CDATA[" ).append( planDataArr[0] ).append( "]]></planed_locality>\r\n" );
						valueXmlString.append( "<planed_customer><![CDATA[" ).append( planDataArr[1] ).append( "]]></planed_customer>\r\n" );
						valueXmlString.append( "<mainform_no><![CDATA[" ).append( formNum ).append( "]]></mainform_no>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );//Added by Hariom shukla 10-June-2020
						//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] start
						valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
						valueXmlString.append( "<grade_code><![CDATA[" ).append( grade ).append( "]]></grade_code>\r\n" );
						//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] end
						valueXmlString.append("</Detail"+objContext+">");
						//Added By mrunalini Sinkar for summary changes on 12-jun-2020(Start)
						String eventDate="";
						if("Y".equalsIgnoreCase(callReport))
						{
							eventDate=eventDateDom;
						}
						else
						{
							eventDate=validWorkDate;
						}
						if("FW".equalsIgnoreCase(actType) && "Y".equalsIgnoreCase(editSumDefData))
						{
							String editData=checkNull(getEditModeData(objName,dcrId,eventDate,userId,otherParticipant,actType,actCode,teamDetail,connectionObject));
							valueXmlString.append( editData );
						}
						//Added By mrunalini Sinkar for summary changes on 12-jun-2020(End)
					}
					else
					{
						//Added by Hariom for connection related changes -09-12-20 [Start]
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						//Added by Hariom for connection related changes -09-12-20 [End]

						if(oldDataCheck==true && "Y".equalsIgnoreCase(oldData))
						{
							String LastDateSql="SELECT WORK_ROUTE_ID,WORK_STAN_CODE,WRK_ROUTE_DESCR,WORK_LOCALITY_CODE,WORK_LOCALITY_DESCR FROM DR_TRAVEL_DETAILS "
									+ " WHERE SALES_PERS = ? AND WORK_DATE =(SELECT MAX(WORK_DATE) FROM DR_TRAVEL_DETAILS WHERE WORK_DATE < ? AND SALES_PERS = ? AND WORK_ROUTE_ID IS NOT NULL ) "
									+ "ORDER BY LINE_NO DESC " ;
							pstmt = connectionObject.prepareStatement(LastDateSql);
							pstmt.setString(1, checkNull(userId));							;
							pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							pstmt.setString(3, checkNull(userId));
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								lastLocCode=checkNull(rs.getString("WORK_LOCALITY_CODE"));
								lastLocDescr=checkNull(rs.getString("WRK_ROUTE_DESCR"));
								lastRouteId=checkNull(rs.getString("WORK_ROUTE_ID"));
								lastStanCode=checkNull(rs.getString("WORK_STAN_CODE"));
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}

						lastDispDCRDate = getMaxDisplayDCRDate(userId,validWorkDate,connectionObject);
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]
						String subDispDAte=checkNull(getSubmissionDisplayDate(connectionObject));

						String actCode = checkNull(getSfaParmValue(userId, "DEF_ACT_CODE", connectionObject));
						String actDscr="",actType="",plceRequired="";
						String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						pstmt = connectionObject.prepareStatement(defACtsql);
						pstmt.setString(1, actCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							actDscr = checkNull(rs.getString("ACTIVITY_DESCR"));
							actType = checkNull(rs.getString("ACTIVITY_TYPE"));
							plceRequired = checkNull(rs.getString("PLACE_REQUIRED"));
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]



						String sfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
						sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
						cal = Calendar.getInstance();
						cal.setTime( sdf.parse(lastDCRDate) );
						cal.add(Calendar.DATE, 1);
						sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
						String workDate = sdf.format(cal.getTime());
						//System.out.println("workDate.....["+workDate+"]");
						if(sfaParmData.equalsIgnoreCase("Y"))
						{
							sql =" SELECT PLAN.PLAN_DATE AS PLAN_DATE,PLAN.PLAN_ACTIVITY AS PLAN_ACTIVITY,FLD.ACTIVITY_CODE AS ACTIVITY_CODE,PLAN.PLAN_ID, " +
									" FLD.ACTIVITY_TYPE AS ACTIVITY_TYPE,FLD.DESCR AS DESCR,FLD.PLACE_REQUIRED AS PLACE_REQUIRED "+ //Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
									" FROM SPRS_PLAN_HDR PLAN,FIELDACTIVITY FLD WHERE PLAN_DATE= ?" +
									" AND PLAN.PLAN_ACTIVITY = FLD.ACTIVITY_CODE AND SPRS_CODE__PLAN = ? AND CONFIRM = ?";
							planPstmt =  connectionObject.prepareStatement(sql);
							planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validWorkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							planPstmt.setString(2, checkNull(userId));
							planPstmt.setString(3, checkNull("Y"));
							planRs = planPstmt.executeQuery();
							if(planRs.next())
							{
								actType = planRs.getString("ACTIVITY_TYPE");
								actDscr = planRs.getString("DESCR");
								actCode = planRs.getString("ACTIVITY_CODE");
								plceRequired = planRs.getString("PLACE_REQUIRED");//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
								String planId=checkNull(planRs.getString("PLAN_ID")) ;
								String visitedWith= getPlanTeamData(planId,connectionObject);

								valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gulzar on 05/05/14

								//	valueXmlString.append( "<activity_code><![CDATA[" ).append( actCode ).append( "]]></activity_code>\r\n" );
								//	valueXmlString.append( "<activity_descr><![CDATA[" ).append( actDscr ).append( "]]></activity_descr>\r\n" );
								//	valueXmlString.append( "<activity_type><![CDATA[" ).append( actType ).append( "]]></activity_type>\r\n" );
								if("Y".equalsIgnoreCase(isPlanCumpulsory))
								{
									valueXmlString.append( "<copy_plan><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
								}
								else
								{
									valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
								}
								valueXmlString.append( "<is_plan><![CDATA[" ).append("Y").append( "]]></is_plan>\r\n" );
								valueXmlString.append( "<visited_with><![CDATA[" ).append( visitedWith ).append( "]]></visited_with>\r\n" );

							}
							else
							{
								valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gulzar on 05/05/14
								valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
								//	valueXmlString.append( "<activity_code><![CDATA[" ).append( "FW" ).append( "]]></activity_code>\r\n" );
								//	valueXmlString.append( "<activity_descr><![CDATA[" ).append( "WHOLE DAY FIELD WORK" ).append( "]]></activity_descr>\r\n" );
								//	valueXmlString.append( "<activity_type><![CDATA[" ).append( "FW" ).append( "]]></activity_type>\r\n" );
								valueXmlString.append( "<is_plan><![CDATA[" ).append("N").append( "]]></is_plan>\r\n" );
								valueXmlString.append( "<visited_with><![CDATA[" ).append( "" ).append( "]]></visited_with>\r\n" );

							}

							if(planRs != null)
							{
								planRs.close();
								planRs = null;
							}
							if(planPstmt != null)
							{
								planPstmt.close();
								planPstmt = null;
							}

						}
						else
						{
							valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gulzar on 05/05/14
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
							//	valueXmlString.append( "<activity_code><![CDATA[" ).append( "FW" ).append( "]]></activity_code>\r\n" );
							//	valueXmlString.append( "<activity_descr><![CDATA[" ).append( "WHOLE DAY FIELD WORK" ).append( "]]></activity_descr>\r\n" );
							//	valueXmlString.append( "<activity_type><![CDATA[" ).append( "FW" ).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<is_plan><![CDATA[" ).append("N").append( "]]></is_plan>\r\n" );
							valueXmlString.append( "<visited_with><![CDATA[" ).append( "" ).append( "]]></visited_with>\r\n" );

						}
						if("Y".equalsIgnoreCase(callReport))
						{
							valueXmlString.append( "<event_date><![CDATA[" ).append( eventDateDom ).append("]]></event_date>\r\n" );
							lastDispDCRDate = getMaxDisplayDCRDate(userId,eventDateDom,connectionObject);
						}
						else
						{
							//if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue) &&  !(lastDCRDate1.compareTo(currenDate)==0))
							//{
								valueXmlString.append( "<event_date><![CDATA[" ).append( validWorkDate ).append("]]></event_date>\r\n" );
							//}
							//else
							//{
								//valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append("]]></event_date>\r\n" );
							//}
							lastDispDCRDate = getMaxDisplayDCRDate(userId,validWorkDate,connectionObject);
						}
						valueXmlString.append( "<activity_code><![CDATA[" ).append( actCode ).append( "]]></activity_code>\r\n" ); //Disallow multiple activity for submitted report [shraddha:27-08-2019]
						valueXmlString.append( "<activity_descr><![CDATA[" ).append( actDscr ).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append( actType ).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<place_required><![CDATA[" ).append(plceRequired).append( "]]></place_required>\r\n"  ); //Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
						valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(sprsName).append( "]]></sales_pers_sp_name>\r\n" );
						//valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( locCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
						//valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( locDescr ).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<sprs_locality_code><![CDATA[" ).append( lastLocCode ).append( "]]></sprs_locality_code>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( lastLocDescr ).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<route_descr__start><![CDATA[" ).append( lastLocDescr ).append( "]]></route_descr__start>\r\n" );
						valueXmlString.append( "<sprs_route_route_id><![CDATA[" ).append( lastRouteId ).append( "]]></sprs_route_route_id>\r\n" );
						valueXmlString.append( "<sprs_route_stan_code><![CDATA[" ).append( lastStanCode ).append( "]]></sprs_route_stan_code>\r\n" );

						if(isNewEmpJoin)
						{
							valueXmlString.append( "<last_dcr_date><![CDATA[" ).append("").append( "]]></last_dcr_date>\r\n" );

						}
						else
						{
							if (lastDispDCRDate != null && lastDispDCRDate.trim().length()>0 && oldDataCheck==false)
							{
								valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDispDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
							}
							else if (lastDCRDate != null && lastDCRDate.trim().length()>0 )
							{
								valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
							}
						}

						valueXmlString.append( "<oth_participant><![CDATA[]]></oth_participant>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[]]></tran_id>\r\n" );//Gulzar on 04/07/17
						valueXmlString.append( "<visited_with_display><![CDATA[]]></visited_with_display>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<submission_date><![CDATA[" ).append(datetime).append( "]]></submission_date>\r\n" );//Added by Mrunalini Sinkar
						valueXmlString.append( "<submit_show_date><![CDATA[" ).append(subDispDAte).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						//valueXmlString.append( "<copy_plan><![CDATA[" ).append("").append( "]]></copy_plan>\r\n" );
						if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue))
						{
							//System.out.println("in ifff:::");
							planDataString=getDSRPlanData(userId, sdf.format(cal.getTime()),connectionObject); //chnged by sachin satre on [9-nov-16] to get connection
						}
						else
						{
							//System.out.println("in elseee:::");
							planDataString=getDSRPlanData(userId, currDate,connectionObject); //chnged by sachin satre on [9-nov-16] to get connection
						}
						//System.out.println("planDataString=["+planDataString+"]");
						valueXmlString.append(planDataString);
						//valueXmlString.append( "</Detail1>");
						valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );
						//Change by Gulzar on 08/12/17 start
						valueXmlString.append( "<tot_calls><![CDATA[" ).append( "" ).append("]]></tot_calls>\r\n" );
						valueXmlString.append( "<productive_calls><![CDATA[" ).append( "" ).append("]]></productive_calls>\r\n" );
						valueXmlString.append( "<udf_str1><![CDATA[" ).append( "" ).append("]]></udf_str1>\r\n" );
						valueXmlString.append( "<udf_num1><![CDATA[" ).append( "" ).append("]]></udf_num1>\r\n" );
						//Change by Gulzar on 08/12/17 end
						//Added by mrunalini sinkar for dar migration changes (start)
						valueXmlString.append( "<allow_dr_unlist_dar><![CDATA[" ).append(checkNull(allowDrUnlist)).append( "]]></allow_dr_unlist_dar>\r\n" );
						valueXmlString.append( "<allow_ch_unlist_dar><![CDATA[" ).append(checkNull(allowChemistUnlist)).append( "]]></allow_ch_unlist_dar>\r\n" );
						valueXmlString.append( "<allow_sk_unlist_dar><![CDATA[" ).append(checkNull(allowStockistVisit)).append( "]]></allow_sk_unlist_dar>\r\n" );
						//Added by mrunalini sinkar for dar migration changes (end)
						valueXmlString.append( "<allow_stockist_dar><![CDATA[" ).append(checkNull(darParmData)).append( "]]></allow_stockist_dar>\r\n" );
						valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "ADD REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19
						valueXmlString.append( "<planed_locality><![CDATA[" ).append( planDataArr[0] ).append( "]]></planed_locality>\r\n" );
						valueXmlString.append( "<planed_customer><![CDATA[" ).append( planDataArr[1] ).append( "]]></planed_customer>\r\n" );
						valueXmlString.append( "<mainform_no><![CDATA[" ).append( formNum ).append( "]]></mainform_no>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );//Added by Hariom shukla 10-June-2020
						//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] start
						valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
						valueXmlString.append( "<grade_code><![CDATA[" ).append( grade ).append( "]]></grade_code>\r\n" );
						//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] end
						valueXmlString.append("</Detail"+objContext+">");
					}//
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}

				else if( currentColumn.equalsIgnoreCase( "activity_code" ))
				{
					//added by Mrunalini Sinkar on 06/04/2017 to show edit or add mode (start)
					String activityCode = checkNull(genericUtility.getColumnValue("activity_code", dom2, "1"));
					String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2, "1"));//checknull added by shraddha m for null pointer in exception log[14/10/2020]]
					int prCount = 0;
					if(eventDate != null && eventDate.length() > 0) //added by shraddha m for null pointer in exception log[14/10/2020] start
					{
						String activitySql ="SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS= ? AND EVENT_DATE= ?";
						pstmt =  connectionObject.prepareStatement(activitySql);
						pstmt.setString(1,userId );
						pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						rs = pstmt.executeQuery();

						if(rs.next())
						{
							prCount = rs.getInt("COUNT");
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
					} 
					//added by shraddha m for null pointer in exception log[14/10/2020] end
					 
						//System.out.println("prCount =["+prCount+"]");
						if(prCount > 0 )
						{
							valueXmlString.append( "<Detail"+objContext+" dbID='' domID='1' objContext='"+currentFormNo+"' selected='Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
						}
						else
						{
							valueXmlString.append( "<Detail"+objContext+" dbID='' domID='1' objContext='"+currentFormNo+"' selected='N' formName='"+formName+"'>\r\n" );
							valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
						}					
					//added by Mrunalini Sinkar on 06/04/2017 to show edit or add mode (end)

					String activityDescr = "";
					String activityType = "";
					String placerequired = "";
					sql = "SELECT DESCR, ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
					pstmt =  connectionObject.prepareStatement(sql);
					pstmt.setString(1, activityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						activityDescr = (rs.getString("DESCR") == null) ?"":rs.getString("DESCR").trim();
						activityType = (rs.getString("ACTIVITY_TYPE") == null) ?"":rs.getString("ACTIVITY_TYPE").trim();
						placerequired = (rs.getString("PLACE_REQUIRED") == null) ?"":rs.getString("PLACE_REQUIRED").trim(); //Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					//System.out.println("activityDescr:---"+activityDescr);
					valueXmlString.append( "<activity_code><![CDATA[" ).append( activityCode ).append( "]]></activity_code>\r\n" );
					valueXmlString.append( "<activity_descr><![CDATA[" ).append( activityDescr ).append( "]]></activity_descr>\r\n" );
					valueXmlString.append( "<activity_type><![CDATA[" ).append( activityType ).append( "]]></activity_type>\r\n" );
					valueXmlString.append( "<place_required><![CDATA[" ).append( placerequired ).append( "]]></place_required>\r\n" );	//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
					//added by mrunalini sinkar on 26-june-2018(start)

					if("FW".equalsIgnoreCase(activityType))
					{

						valueXmlString.append( "<oth_participant protect='0' visible='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with protect='0' visible='1'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" );


					}
					else
					{
						valueXmlString.append( "<oth_participant protect='1' visible='0'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with protect='1' visible='0'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" );

					}
					//added by mrunalini sinkar on 26-june-2018(end)
					//valueXmlString.append("</Detail1>\r\n");
					valueXmlString.append("</Detail"+objContext+">");


				}
				else if( currentColumn.equalsIgnoreCase( "event_date" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
					String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
					String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
					String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
					String eventDate = genericUtility.getColumnValue("event_date", dom2, "1");

					if(eventDate != null && eventDate.trim().length() > 0)
					{
						//System.out.println("currDate"+currDate);
						String dateFormat = getApplDateFormat();
						//System.out.println("dateFormat:::::...."+dateFormat);
						String planDataString="";
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
						sprsName=darCommonBean.getSalesPersName(userId, connectionObject);
						/*sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							sprsName = rs.getString("SP_NAME");

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}*/
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
						//System.out.println("sprsName 2 >> "+sprsName);
						String isPrExist = "";
						int prCount = 0;
						String countPrSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.SALES_PERS = ? AND A.EVENT_DATE = ? AND B.ACTIVITY_TYPE='PR'";
						PreparedStatement prPstmt = connectionObject.prepareStatement(countPrSql);
						prPstmt.setString(1,userId);
						prPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						ResultSet prRs = prPstmt.executeQuery();
						if(prRs.next())
						{
							prCount = prRs.getInt("COUNT");
						}
						if(prRs != null)
						{
							prRs.close();
							prRs = null;
						}
						if(prPstmt != null)
						{
							prPstmt.close();
							prPstmt = null;
						}
						if(prCount > 0)
						{
							isPrExist = "Y";
						}
						else
						{
							isPrExist = "N";
						}


						//for journey from
						String locCodeFrom = getStanCodeFrom( connectionObject, userId, currDate,"" );
						//System.out.println("locCodeFrom >> "+locCodeFrom);
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
						locDescr=darCommonBean.getLocalityDescr(locCodeFrom, connectionObject);
						/*sql = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, locCodeFrom);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							locDescr = rs.getString("DESCR");

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}*/
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
						//System.out.println("locDescr2 >>"+locDescr);

						String lastDCRDate ="";
						//String joinDate = ""; //Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
						//String propDate = ""; //Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
						String eventDate1="";
						java.util.Date lastDCRDate1 = null;
						java.util.Date jDate = null;
						java.util.Date applStartDate = null;
						//String propSql = ""; //Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
						//String joinDateSql = ""; //Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
						PreparedStatement selectPstmt = null;
						ResultSet selectRs = null;
						//PreparedStatement propPstmt = null; //Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
						//ResultSet propRs = null; //Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
						//PreparedStatement joinDatePstmt = null; //Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
						//ResultSet joinDateRs = null;
						boolean isNewEmpJoin=false;
						//Changed by rahul on 24 jul 2015 [ for getting last_dcr_date from employee or properties master if not present in sprs_act_tran | START]
						int count = 0;

						//added by mrunalini sinkar for exceed limit start
						count=darCommonBean.getCountFromTable("SPRS_ACT_TRAN", userId, connectionObject);
						/*String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ?";
						selectPstmt = connectionObject.prepareStatement(selectSql);
						selectPstmt.setString(1,userId);
						selectRs = selectPstmt.executeQuery();
						if(selectRs.next())
						{
							count = selectRs.getInt("COUNT");
						}
						if(selectRs != null)
						{
							selectRs.close();
							selectRs = null;
						}
						if(selectPstmt != null)
						{
							selectPstmt.close();
							selectPstmt = null;
						}*/
						//added by mrunalini sinkar for exceed limit End

						//Added By Mrunalini Sinkar for showing data old metis data wise (Start)
						String oldData=checkNull(getSfaParmValue(userId, "OLD_METIS_DAR_DATA", connectionObject));
						boolean oldDataCheck=false;
						int drMainCnt=0;
						if("Y".equalsIgnoreCase(oldData))
						{
							//added by mrunalini sinkar for exceed limit Start

							drMainCnt=darCommonBean.getCountFromTable("DR_MAIN", userId, connectionObject);

							/*String oldSelectSql = "SELECT COUNT(*) AS COUNT FROM DR_MAIN WHERE SALES_PERS = ?";
							selectPstmt = connectionObject.prepareStatement(oldSelectSql);
							selectPstmt.setString(1,userId);
							selectRs = selectPstmt.executeQuery();
							if(selectRs.next())
							{
								drMainCnt = selectRs.getInt("COUNT");
							}
							if(selectRs != null)
							{
								selectRs.close();
								selectRs = null;
							}
							if(selectPstmt != null)
							{
								selectPstmt.close();
								selectPstmt = null;
							}*/
							//added by mrunalini sinkar for exceed limit End

						}
						//Added By Mrunalini Sinkar for showing data old metis data wise (end)
						if(count > 0)
						{
							String actTranDcrDate="";

							sql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE EVENT_DATE <= ? AND SALES_PERS = ?";
							pstmt =  connectionObject.prepareStatement(sql);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							pstmt.setString(2, userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								actTranDcrDate = rs.getString("LAST_DCR_DATE");
								//System.out.println("lastDCRDate =["+lastDCRDate+"]");
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							//Added By Mrunalini Sinkar for showing data old metis data wise (Start)
							if(drMainCnt>0 && "Y".equalsIgnoreCase(oldData))
							{
								String drMainDcrDate="";
								sql = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE WORK_DATE <= ? AND SALES_PERS = ? "+
										"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')"; // added by condition rupali on 14/03/17 for separate pr menu
								pstmt =  connectionObject.prepareStatement(sql);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setString(2, userId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									drMainDcrDate = rs.getString("LAST_DCR_DATE");
									//System.out.println("lastDCRDate =["+lastDCRDate+"]");
								}
								if (rs!= null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
								java.util.Date drMainDate = null;
								java.util.Date actTranDate = null;
								if (drMainDcrDate != null && drMainDcrDate.trim().length() > 0)
								{
									drMainDate = dbFormat.parse(drMainDcrDate);
								}
								if (actTranDcrDate != null && actTranDcrDate.trim().length() > 0)
								{
									actTranDate = dbFormat.parse(actTranDcrDate);
								}

								if (drMainDate != null && actTranDate != null )
								{
									if(drMainDate.after(actTranDate))
									{
										oldDataCheck=true;
										lastDCRDate = drMainDcrDate;
									}
									else
									{
										lastDCRDate = actTranDcrDate;
									}
								}
							}
							else
							{
								lastDCRDate = actTranDcrDate;
							}
							//Added By Mrunalini Sinkar for showing data old metis data wise (end)
						}
						//Added By Mrunalini Sinkar for showing data old metis data wise (end)
						else if(drMainCnt>0 && "Y".equalsIgnoreCase(oldData) && count==0)
						{
							String drMainDcrDate="";
							sql = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE WORK_DATE <= ? AND SALES_PERS = ? "+
									"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')"; // added by condition rupali on 14/03/17 for separate pr menu
							pstmt =  connectionObject.prepareStatement(sql);
							pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							pstmt.setString(2, userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								oldDataCheck=true;
								lastDCRDate = rs.getString("LAST_DCR_DATE");
								//System.out.println("lastDCRDate =["+lastDCRDate+"]");
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						//Added By Mrunalini Sinkar for showing data old metis data wise (End)
						else
						{
							// changes made by rupali on  15/02/19 as suggected by gulzar sir
							//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
							String propDate=darCommonBean.getPropVal("APPL_START_DAR", connectionObject);
							//System.out.println("Appl_Start_Date2 =====["+propDate+"]");
							//propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'APPL_START_DCR'";
							/*propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'APPL_START_DAR'";
							propPstmt =  connectionObject.prepareStatement(propSql);
							propRs = propPstmt.executeQuery();
							if(propRs.next())
							{
								propDate = propRs.getString("PROP_VALUE");
								propDate = genericUtility.getValidDateString(propDate, genericUtility.getDBDateFormat() );
							}
							//System.out.println("Appl_Start_Date =====["+propDate+"]");
							if (propRs != null)
							{
								propRs.close();
								propRs = null;
							}
							if(propPstmt !=null)
							{
								propPstmt.close();
								propPstmt = null;
							}*/
							String joinDate=darCommonBean.getJoinDate1(userId, connectionObject);
							//System.out.println("joinDate2=== ["+joinDate + "]");
							/*joinDateSql = "SELECT DATE_JOIN FROM EMPLOYEE WHERE EMP_CODE = ? ";
							joinDatePstmt =connectionObject.prepareStatement(joinDateSql);
							joinDatePstmt.setString(1,userId);
							joinDateRs = joinDatePstmt.executeQuery();
							if(joinDateRs.next())
							{
								joinDate = joinDateRs.getString("DATE_JOIN");
							}
							//System.out.println("joinDate=== ["+joinDate + "]");
							if (joinDateRs!= null)
							{
								joinDateRs.close();
								joinDateRs = null;
							}
							if(joinDatePstmt!=null)
							{
								joinDatePstmt.close();
								joinDatePstmt = null;
							}*/
							//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
							SimpleDateFormat formatter = new SimpleDateFormat(genericUtility.getDBDateFormat());

							if (joinDate != null && joinDate.trim().length() > 0)
							{
								isNewEmpJoin=true;
								lastDCRDate = joinDate;
								jDate = formatter.parse(joinDate);
							}
							if (propDate != null && propDate.trim().length() > 0)
							{
								applStartDate = formatter.parse(propDate);
							}
							if (jDate != null && applStartDate != null )
							{
								if(jDate.after(applStartDate))
								{
									isNewEmpJoin=true;
									lastDCRDate = joinDate;
								}
								else
								{
									isNewEmpJoin=false;
									lastDCRDate = propDate;
								}
							}
							//System.out.println("lastDCRDate ====["+lastDCRDate+"]");
						}


						String propValue = getPropertiesVal(connectionObject, "DISP_NEXT_DCR_DATE");
						String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
						String workWith = checkNull(genericUtility.getColumnValue("visited_with_display", dom1));
						String editSumDefData = checkNull(getSfaParmValue(userId, "DEF_SUMRY_EDIT_DATA", connectionObject));

						SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
						Calendar cal = Calendar.getInstance();
						cal.setTime( sdf.parse(lastDCRDate) );
						cal.add(Calendar.DATE, 1);
						sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());

						//System.out.println("eventDate.....["+eventDate+"]");
						if(eventDate != null && eventDate.trim().length() > 0 )
						{
							String lastLocCode="",lastStanCode="",lastLocDescr="",lastRouteId="";


							int cnt=0;
							String countSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, SPRS_TRAVEL B WHERE A.EVENT_DATE = B.TRAVEL_DATE AND A.SALES_PERS = B.SALES_PERS AND  A.SALES_PERS = ? AND A.EVENT_DATE = ?";
							pstmt = connectionObject.prepareStatement(countSql);
							pstmt.setString(1,userId);
							pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}


							if(cnt > 0)
							{
								String locEdiCodeSql = "SELECT LOCALITY_CODE_FROM,STAN_CODE__FROM,ROUTE_ID_FROM FROM SPRS_TRAVEL ST,SPRS_ROUTE SR  "
										+ "WHERE TRAVEL_DATE=? AND SALES_PERS=? AND ORDER_OF_VISIT=(SELECT MIN(ORDER_OF_VISIT) FROM SPRS_TRAVEL WHERE "
										+ "TRAVEL_DATE=? AND SALES_PERS=?) " +
										"AND SR.SPRS_CODE=ST.SALES_PERS AND SR.ROUTE_ID=ST.ROUTE_ID AND SR.LOCALITY_CODE=ST.LOCALITY_CODE";
								pstmt = connectionObject.prepareStatement(locEdiCodeSql);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setString(2, userId);
								pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setString(4, userId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									lastLocCode = checkNull(rs.getString("LOCALITY_CODE_FROM"));
									lastStanCode=checkNull(rs.getString("STAN_CODE__FROM"));
									lastRouteId=checkNull(rs.getString("ROUTE_ID_FROM"));
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								String locDescrOldSql = "SELECT ROUTE_DESCR__START AS DESCR FROM SPRS_ACT_TRAN  WHERE EVENT_DATE=? AND SALES_PERS=?";
								pstmt = connectionObject.prepareStatement(locDescrOldSql);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setString(2, userId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									lastLocDescr = checkNull(rs.getString("DESCR"));

								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(lastLocDescr==null && lastLocDescr.trim().length()==0)
								{
									//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
									lastLocDescr=darCommonBean.getlocDescrOld(userId,lastRouteId,connectionObject);
									//System.out.println("lastLocDescr2::"+lastLocDescr);
									/*String locDescrOldSql1 = "SELECT ST.DESCR AS DESCR FROM SPRS_ROUTE SR,STATION ST WHERE SPRS_CODE = ? AND ROUTE_ID= ? AND SR.STAN_CODE = ST.STAN_CODE AND SR.STATUS='Y'";
									pstmt = connectionObject.prepareStatement(locDescrOldSql1);
									pstmt.setString(1, userId);
									pstmt.setString(2, lastRouteId);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										lastLocDescr = checkNull(rs.getString("DESCR"));

									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}*/
									//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
								}

							}
							else
							{

								String routeId="";
								String sprsCode="";
								HashMap<String, String> routeSprsMap =new HashMap<String, String>();

								String eventDateDBFmt = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
								routeSprsMap = getRouteId(userId,eventDateDBFmt,connectionObject);
								//System.out.println("routeSprsMap is:["+routeSprsMap+"]");

								if(!routeSprsMap.isEmpty())
								{
									for (Entry<String, String> entry: routeSprsMap.entrySet())
									{
										routeId= entry.getKey();
										sprsCode= entry.getValue();
									}
								}

								lastRouteId=routeId;
								String locCodeSql = "SELECT SR.LOCALITY_CODE,SR.STAN_CODE AS STAN_CODE,ST.DESCR AS DESCR FROM SPRS_ROUTE SR,STATION ST WHERE SPRS_CODE = ? AND ROUTE_ID= ? AND SR.STAN_CODE = ST.STAN_CODE AND SR.STATUS='Y'";
								pstmt = connectionObject.prepareStatement(locCodeSql);
								pstmt.setString(1, sprsCode);
								pstmt.setString(2, lastRouteId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									lastLocCode = checkNull(rs.getString("LOCALITY_CODE"));
									lastLocDescr=checkNull(rs.getString("DESCR"));
									lastStanCode =checkNull(rs.getString("STAN_CODE"));

								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

							String []planDataArr = new String [2];
							String formNum = "";
							if(isPlanCumpulsory.equalsIgnoreCase("Y"))
							{
								planDataArr = getPlanData(userId,eventDate, connectionObject);
								//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
								formNum = darCommonBean.getFormNum(connectionObject);
								//System.out.println("formNum are2::"+formNum);
								/*String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= 'w_strg_meet_dcr_wiz' AND FORM_NAME IN('place','doctor','retailer','stockist') ORDER BY TO_NUMBER(FORM_NO)";
								PreparedStatement objFormpstmt = connectionObject.prepareStatement(objFormSql);
								ResultSet objFormrs = objFormpstmt.executeQuery();
								while(objFormrs.next())
								{
									String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
									if(formNum == null || formNum.trim().length() == 0)
									{
										formNum = objFormNo;
									}
									else
									{
										formNum = formNum + "," + objFormNo;
									}
								}
								if(objFormrs != null)
								{
									objFormrs.close();
									objFormrs = null;
								}
								if(objFormpstmt != null)
								{
									objFormpstmt.close();
									objFormpstmt = null;
								}*/
								//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
							}

							//Commented and modified in query by kailash on 01/Dec/17 for displayin total call ,prodctive call and TLSD in edit mode [Start]
							//String sqlActivity = "SELECT SP.DCR_ID, SP.ACTIVITY_CODE CODE,SP.REMARK REMARK,SP.OTH_PARTICIPANT OTHERS,FD.DESCR DESCR,FD.ACTIVITY_TYPE ATYPE,SP.COPY_PLAN AS COPY_PLAN, SP.TRAN_ID AS TRAN_ID "
							//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
							String sqlActivity = "SELECT SP.DCR_ID, SP.ACTIVITY_CODE CODE,SP.REMARK REMARK,SP.OTH_PARTICIPANT OTHERS,FD.DESCR DESCR,FD.ACTIVITY_TYPE ATYPE,FD.PLACE_REQUIRED AS PLACE_REQUIRED,SP.COPY_PLAN AS COPY_PLAN, SP.TRAN_ID AS TRAN_ID, SP.TOT_CALLS AS TOT_CALLS, SP.PRODUCTIVE_CALLS AS PRODUCTIVE_CALLS, "+
									"SP.UDF_STR1 AS UDF_STR1, SP.UDF_NUM1 AS UDF_NUM1,SP.SUBMISSION_DATE "+
									" FROM SPRS_ACT_TRAN SP,FIELDACTIVITY FD WHERE EVENT_DATE=? "+
									" AND SALES_PERS=? AND FD.ACTIVITY_CODE = SP.ACTIVITY_CODE AND FD.ACTIVITY_TYPE <> 'PR'";
							//Commented and modified by kailash on 01/Dec/17 for displayin total call & prodctive call in edit mode [End]
							pstmt =  connectionObject.prepareStatement(sqlActivity);
							pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							pstmt.setString(2, checkNull(userId));
							rs = pstmt.executeQuery();

							if(rs.next())
							{
								String dcrId=checkNull(rs.getString("DCR_ID"));
								String otherParticipant=checkNull(rs.getString("OTHERS"));
								String actType=checkNull(rs.getString("ATYPE")) ;
								String actCode=checkNull(rs.getString("CODE"));

								String subDispDAte="";
								String submissionDate=checkNull(rs.getString("SUBMISSION_DATE"));
								//System.out.println("submissionDate is["+submissionDate+"]");

								lastDispDCRDate = getMaxDisplayDCRDate(userId,eventDate,connectionObject);
								//String teamDetail = getExistingTeamDetail(userId,currDate,connectionObject);
								String teamDetail = getExistingTeamDetail(userId,eventDate,connectionObject);
								if(teamDetail.length() > 0)
								{
									//System.out.println("Inside teamDeatils");
									workWith = getWorkWithList(teamDetail,docFormNo);
								}
								String activityType = checkNull(rs.getString("ATYPE")); //added by mrunalini sinkar on 26-june-2018(start)
								//System.out.println("workWith :: ["+workWith+"]");

								valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
								valueXmlString.append( "<event_date><![CDATA[" ).append( eventDate ).append("]]></event_date>\r\n" );
								valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull(actCode) ).append( "]]></activity_code>\r\n" );//Disallow multiple activity for submitted report [shraddha:27-08-2019]
								valueXmlString.append( "<activity_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR")) ).append( "]]></activity_descr>\r\n" );
								valueXmlString.append( "<activity_type><![CDATA[" ).append( checkNull(actType) ).append( "]]></activity_type>\r\n" );
								valueXmlString.append( "<place_required><![CDATA[" ).append( checkNull(rs.getString("PLACE_REQUIRED")) ).append( "]]></place_required>\r\n" );//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
								valueXmlString.append( "<sales_pers><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
								valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(sprsName).append( "]]></sales_pers_sp_name>\r\n" );
								//valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( locCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
								//valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( locDescr ).append( "]]></sprs_route_descr>\r\n" );
								valueXmlString.append( "<sprs_locality_code><![CDATA[" ).append( lastLocCode ).append( "]]></sprs_locality_code>\r\n" );
								valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( lastLocDescr ).append( "]]></sprs_route_descr>\r\n" );
								valueXmlString.append( "<route_descr__start><![CDATA[" ).append( lastLocDescr ).append( "]]></route_descr__start>\r\n" );
								valueXmlString.append( "<sprs_route_route_id><![CDATA[" ).append( lastRouteId ).append( "]]></sprs_route_route_id>\r\n" );
								valueXmlString.append( "<sprs_route_stan_code><![CDATA[" ).append( lastStanCode ).append( "]]></sprs_route_stan_code>\r\n" );

								if(isNewEmpJoin)
								{
									valueXmlString.append( "<last_dcr_date><![CDATA[" ).append("").append( "]]></last_dcr_date>\r\n" );

								}
								else
								{
									if (lastDispDCRDate != null && lastDispDCRDate.trim().length()>0 )
									{
										valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDispDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
									}
									else if (lastDCRDate != null && lastDCRDate.trim().length()>0 )
									{
										valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
									}
								}
								//added by mrunalini sinkar on 26-june-2018(start)
								if("FW".equalsIgnoreCase(activityType))
								{
									valueXmlString.append( "<oth_participant protect='0' visible='1'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
									valueXmlString.append( "<visited_with protect='0' visible='1'><![CDATA[" ).append(teamDetail).append( "]]></visited_with>\r\n" );


								}
								else
								{
									valueXmlString.append( "<oth_participant protect='1' visible='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
									valueXmlString.append( "<visited_with protect='1' visible='0'><![CDATA[" ).append(teamDetail).append( "]]></visited_with>\r\n" );

								}
								//added by mrunalini sinkar on 26-june-2018(end)
								valueXmlString.append( "<remark><![CDATA[" ).append(checkNull(rs.getString("REMARK"))).append( "]]></remark>\r\n" );//Gulzar
								valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
								if (submissionDate != null && submissionDate.trim().length()>0 )
								{
									subDispDAte=checkNull(getEditSubmitDate(userId,eventDate,connectionObject));
									valueXmlString.append( "<submission_date><![CDATA[" ).append(checkNull(genericUtility.getValidDateString( submissionDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat()))).append( "]]></submission_date>\r\n" );//Added by Mrunalini Sinkar
								}
								else
								{
									subDispDAte=checkNull(getSubmissionDisplayDate(connectionObject));
									valueXmlString.append( "<submission_date><![CDATA[" ).append(datetime).append( "]]></submission_date>\r\n" );
								}
								valueXmlString.append( "<submit_show_date><![CDATA[" ).append(subDispDAte).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar

								valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
								valueXmlString.append( "<copy_plan><![CDATA[" ).append(rs.getString("COPY_PLAN")).append( "]]></copy_plan>\r\n" );
								valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrId).append( "]]></dcr_id>\r\n" );
								valueXmlString.append( "<tran_id><![CDATA[" ).append(rs.getString("TRAN_ID")).append( "]]></tran_id>\r\n" );//Gulzar on 04/07/17
								if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue))
								{
									//System.out.println("in ifff!!!!");
									planDataString=getDSRPlanData(userId, sdf.format(cal.getTime()),connectionObject);
								}
								else
								{
									//	System.out.println("in elseee!!!!");
									planDataString=getDSRPlanData(userId, currDate,connectionObject);
								}
								//System.out.println("planDataString=["+planDataString+"]");
								valueXmlString.append(planDataString);
								//valueXmlString.append( "</Detail1>");
								valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );
								//Added by kailash on 01/Dec/17 [Start]
								valueXmlString.append( "<tot_calls><![CDATA[" ).append(rs.getString("TOT_CALLS")).append( "]]></tot_calls>\r\n" );
								valueXmlString.append( "<productive_calls><![CDATA[" ).append(rs.getString("PRODUCTIVE_CALLS")).append( "]]></productive_calls>\r\n" );
								valueXmlString.append( "<udf_str1><![CDATA[" ).append(rs.getString("UDF_STR1")).append( "]]></udf_str1>\r\n" );
								valueXmlString.append( "<udf_num1><![CDATA[" ).append(rs.getString("UDF_NUM1")).append( "]]></udf_num1>\r\n" );
								valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "EDIT REPORT" ).append( "]]></dcr_mode>\r\n" );//added by hariom 19-oct-19
								//Added by kailash on 01/Dec/17 [End]
								valueXmlString.append( "<planed_locality><![CDATA[" ).append( planDataArr[0] ).append( "]]></planed_locality>\r\n" );
								valueXmlString.append( "<planed_customer><![CDATA[" ).append( planDataArr[1] ).append( "]]></planed_customer>\r\n" );
								valueXmlString.append( "<mainform_no><![CDATA[" ).append( formNum ).append( "]]></mainform_no>\r\n" );
								valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );//Added by Hariom shukla 10-June-2020

								valueXmlString.append("</Detail"+objContext+">");
								//Added By mrunalini Sinkar for summary changes on 12-jun-2020(Start)
								if("FW".equalsIgnoreCase(actType) && "Y".equalsIgnoreCase(editSumDefData))
								{
									String editData=checkNull(getEditModeData(objName,dcrId,eventDate,userId,otherParticipant,actType,actCode,teamDetail,connectionObject));
									valueXmlString.append( editData );
								}
								//Added By mrunalini Sinkar for summary changes on 12-jun-2020(end)
							}
							else
							{
							//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
								lastDispDCRDate = getMaxDisplayDCRDate(userId,eventDate,connectionObject);
								String subDispDAte=checkNull(getSubmissionDisplayDate(connectionObject));
								if(oldDataCheck==true && "Y".equalsIgnoreCase(oldData))
								{
									String LastDateSql="SELECT WORK_ROUTE_ID,WORK_STAN_CODE,WRK_ROUTE_DESCR,WORK_LOCALITY_CODE,WORK_LOCALITY_DESCR FROM DR_TRAVEL_DETAILS "
											+ " WHERE SALES_PERS = ? AND WORK_DATE =(SELECT MAX(WORK_DATE) FROM DR_TRAVEL_DETAILS WHERE WORK_DATE < ? AND SALES_PERS = ? AND WORK_ROUTE_ID IS NOT NULL ) "
											+ "ORDER BY LINE_NO DESC " ;
									pstmt = connectionObject.prepareStatement(LastDateSql);
									pstmt.setString(1, checkNull(userId));							;
									pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
									pstmt.setString(3, checkNull(userId));
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										lastLocCode=checkNull(rs.getString("WORK_LOCALITY_CODE"));
										lastLocDescr=checkNull(rs.getString("WRK_ROUTE_DESCR"));
										lastRouteId=checkNull(rs.getString("WORK_ROUTE_ID"));
										lastStanCode=checkNull(rs.getString("WORK_STAN_CODE"));
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
								}

								// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]

								/*String actDscr = "WHOLE DAY FIELD WORK";
								String actType = "FW";
								String actCode = "FW";
								String placeRequired="Y"; //Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018*/

								String actCode = checkNull(getSfaParmValue(userId, "DEF_ACT_CODE", connectionObject));
								String actDscr="",actType="",placeRequired="";
								String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
								pstmt = connectionObject.prepareStatement(defACtsql);
								pstmt.setString(1, actCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									actDscr = checkNull(rs.getString("ACTIVITY_DESCR"));
									actType = checkNull(rs.getString("ACTIVITY_TYPE"));
									placeRequired = checkNull(rs.getString("PLACE_REQUIRED"));
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]
								String sfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject); //chnged by sachin satre on [9-nov-16] to get connection
								sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
								cal = Calendar.getInstance();
								cal.setTime( sdf.parse(lastDCRDate) );
								cal.add(Calendar.DATE, 1);
								sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
								String workDate = sdf.format(cal.getTime());
								//	System.out.println("workDate.....["+workDate+"]");
								if(sfaParmData.equalsIgnoreCase("Y"))
								{
									//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
									sql =" SELECT PLAN.PLAN_DATE AS PLAN_DATE,PLAN.PLAN_ACTIVITY AS PLAN_ACTIVITY,FLD.ACTIVITY_CODE AS ACTIVITY_CODE,PLAN.PLAN_ID, " +
											" FLD.PLACE_REQUIRED AS PLACE_REQUIRED,FLD.ACTIVITY_TYPE AS ACTIVITY_TYPE,FLD.DESCR AS DESCR "+
											" FROM SPRS_PLAN_HDR PLAN,FIELDACTIVITY FLD WHERE PLAN_DATE= ?" +
											" AND PLAN.PLAN_ACTIVITY = FLD.ACTIVITY_CODE AND SPRS_CODE__PLAN = ? AND CONFIRM = ?";
									planPstmt =  connectionObject.prepareStatement(sql);
									planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
									planPstmt.setString(2, checkNull(userId));
									planPstmt.setString(3, checkNull("Y"));
									planRs = planPstmt.executeQuery();
									if(planRs.next())
									{
										actType = planRs.getString("ACTIVITY_TYPE");
										actDscr = planRs.getString("DESCR");
										actCode = planRs.getString("ACTIVITY_CODE");
										placeRequired = checkNull(planRs.getString("PLACE_REQUIRED"));//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
										String planId=checkNull(planRs.getString("PLAN_ID"));
										String visitedWith= getPlanTeamData(planId,connectionObject);
										valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>");
										valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gulzar on 05/05/14

										//	valueXmlString.append( "<activity_code><![CDATA[" ).append( actCode ).append( "]]></activity_code>\r\n" );
										//	valueXmlString.append( "<activity_descr><![CDATA[" ).append( actDscr ).append( "]]></activity_descr>\r\n" );
										//	valueXmlString.append( "<activity_type><![CDATA[" ).append( actType ).append( "]]></activity_type>\r\n" );
										if("Y".equalsIgnoreCase(isPlanCumpulsory))
										{
											//System.out.println("inside eventdate ifff...");
											valueXmlString.append( "<copy_plan protect='0'><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
										}
										else
										{
											valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
										}
										valueXmlString.append( "<is_plan><![CDATA[" ).append("Y").append( "]]></is_plan>\r\n" );
										valueXmlString.append( "<visited_with><![CDATA[" ).append(visitedWith).append( "]]></visited_with>\r\n" );// added by mrunalini sinkar

									}
									else
									{
										//System.out.println("inside planRs else...");
										valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
										valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gulzar on 05/05/14
										valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
										//	valueXmlString.append( "<activity_code><![CDATA[" ).append( "FW" ).append( "]]></activity_code>\r\n" );
										//	valueXmlString.append( "<activity_descr><![CDATA[" ).append( "WHOLE DAY FIELD WORK" ).append( "]]></activity_descr>\r\n" );
										//	valueXmlString.append( "<activity_type><![CDATA[" ).append( "FW" ).append( "]]></activity_type>\r\n" );
										valueXmlString.append( "<is_plan><![CDATA[" ).append("N").append( "]]></is_plan>\r\n" );
										valueXmlString.append( "<visited_with><![CDATA[" ).append("").append( "]]></visited_with>\r\n" );

									}
									if(planRs != null)
									{
										planRs.close();
										planRs = null;
									}
									if(planPstmt != null)
									{
										planPstmt.close();
										planPstmt = null;
									}
								}
								else
								{
									valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
									valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
									valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
									valueXmlString.append( "<is_plan><![CDATA[" ).append("N").append( "]]></is_plan>\r\n" );
									valueXmlString.append( "<visited_with><![CDATA[" ).append("").append( "]]></visited_with>\r\n" );

								}
								if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue))
								{
									//valueXmlString.append( "<event_date><![CDATA[" ).append( sdf.format(cal.getTime()) ).append("]]></event_date>\r\n" );
								}
								else
								{
									//valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append("]]></event_date>\r\n" );
								}
								valueXmlString.append( "<activity_code><![CDATA[" ).append( actCode ).append( "]]></activity_code>\r\n" );//Disallow multiple activity for submitted report [shraddha:27-08-2019]
								valueXmlString.append( "<activity_descr><![CDATA[" ).append( actDscr ).append( "]]></activity_descr>\r\n" );
								valueXmlString.append( "<activity_type><![CDATA[" ).append( actType ).append( "]]></activity_type>\r\n" );
								valueXmlString.append( "<place_required><![CDATA[" ).append(placeRequired).append( "]]></place_required>\r\n" );//Adding PLACE_REQUIRED by mrunalini sinkar for place  required changes on 11-09-2018
								valueXmlString.append( "<sales_pers><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
								valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(sprsName).append( "]]></sales_pers_sp_name>\r\n" );
								//valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( locCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
								//valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( locDescr ).append( "]]></sprs_route_descr>\r\n" );
								valueXmlString.append( "<sprs_locality_code><![CDATA[" ).append( lastLocCode ).append( "]]></sprs_locality_code>\r\n" );
								valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( lastLocDescr ).append( "]]></sprs_route_descr>\r\n" );
								valueXmlString.append( "<route_descr__start><![CDATA[" ).append( lastLocDescr ).append( "]]></route_descr__start>\r\n" );
								valueXmlString.append( "<sprs_route_route_id><![CDATA[" ).append( lastRouteId ).append( "]]></sprs_route_route_id>\r\n" );
								valueXmlString.append( "<sprs_route_stan_code><![CDATA[" ).append( lastStanCode ).append( "]]></sprs_route_stan_code>\r\n" );

								if(isNewEmpJoin)
								{
									valueXmlString.append( "<last_dcr_date><![CDATA[" ).append("").append( "]]></last_dcr_date>\r\n" );

								}
								else
								{
									if (lastDispDCRDate != null && lastDispDCRDate.trim().length()>0 && oldDataCheck==false)
									{
										valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDispDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
									}
									else if (lastDCRDate != null && lastDCRDate.trim().length()>0 )
									{
										valueXmlString.append( "<last_dcr_date><![CDATA[" ).append( checkNull(genericUtility.getValidDateString( lastDCRDate, genericUtility.getDBDateFormat() , genericUtility.getApplDateFormat())) ).append( "]]></last_dcr_date>\r\n" );
									}	
								}

								valueXmlString.append( "<oth_participant><![CDATA[]]></oth_participant>\r\n" );
								valueXmlString.append( "<visited_with_display><![CDATA[]]></visited_with_display>\r\n" );
								//Added By Bhushan on 15-Feb-17
								valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
								valueXmlString.append( "<submission_date><![CDATA[" ).append(datetime).append( "]]></submission_date>\r\n" );
								valueXmlString.append( "<submit_show_date><![CDATA[" ).append(subDispDAte).append( "]]></submit_show_date>\r\n" );//Added by Mrunalini Sinkar

								valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
								valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
								//		valueXmlString.append( "<copy_plan><![CDATA[" ).append("").append( "]]></copy_plan>\r\n" );
								if(lastDCRDate != null && lastDCRDate.trim().length() > 0 && "Y".equalsIgnoreCase(propValue))
								{
									//System.out.println("in ifff:::");
									planDataString=getDSRPlanData(userId, sdf.format(cal.getTime()),connectionObject); //chnged by sachin satre on [9-nov-16] to get connection
								}
								else
								{
									//System.out.println("in elseee:::");
									planDataString=getDSRPlanData(userId, currDate,connectionObject); //chnged by sachin satre on [9-nov-16] to get connection
								}
								//System.out.println("planDataString=["+planDataString+"]");
								valueXmlString.append(planDataString);
								valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );
								valueXmlString.append( "<tran_id><![CDATA[" ).append( "" ).append("]]></tran_id>\r\n" );
								valueXmlString.append( "<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
								//Added by kailash on 11/dec/17 [start]
								valueXmlString.append( "<tot_calls><![CDATA[" ).append( "" ).append("]]></tot_calls>\r\n" );
								valueXmlString.append( "<productive_calls><![CDATA[" ).append( "" ).append("]]></productive_calls>\r\n" );
								valueXmlString.append( "<udf_str1><![CDATA[" ).append( "" ).append("]]></udf_str1>\r\n" );
								valueXmlString.append( "<udf_num1><![CDATA[" ).append( "" ).append("]]></udf_num1>\r\n" );
								valueXmlString.append( "<dcr_mode><![CDATA[" ).append( "ADD REPORT" ).append("]]></dcr_mode>\r\n" );//added by hariom 19-oct-19

								//Added by kailash on 11/dec/17 [End]
								valueXmlString.append( "<planed_locality><![CDATA[" ).append( planDataArr[0] ).append( "]]></planed_locality>\r\n" );
								valueXmlString.append( "<planed_customer><![CDATA[" ).append( planDataArr[1] ).append( "]]></planed_customer>\r\n" );
								valueXmlString.append( "<mainform_no><![CDATA[" ).append( formNum ).append( "]]></mainform_no>\r\n" );
								valueXmlString.append( "<remark><![CDATA[" ).append("").append( "]]></remark>\r\n" );//Gulzar
								valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );//Added by Hariom shukla 10-June-2020
								valueXmlString.append("</Detail"+objContext+">");
							}

							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}//
					}
				}
			}
			// Added by Harion S for fortune server -18-May-2021 [End]
			else if("activity".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String activityFormNo = checkNull(getFormNo(objName, "activity", connectionObject));
				int currForm=0;
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					String actCode = genericUtility.getColumnValue("activity_code", dom1);
					String trvDate = genericUtility.getColumnValue("event_date", dom1);
					String sprsCode = checkNull(genericUtility.getColumnValue("sales_pers", dom1));
					if(activityFormNo != null && activityFormNo.trim().length() > 0)
						currForm  = Integer.parseInt(activityFormNo);

					String locDetail = getActivityDetails( dom, dom2, objContext,formName, userId, sprsCode, actCode, trvDate, "HTML",loginCode,connectionObject );
					valueXmlString.append( locDetail );

					
				}
				/*else if(currentColumn.equalsIgnoreCase("visit_time_fr"))
				{
					String domId = checkNull(getDomID(dom1, objContext));
					String drVisit = checkNull(genericUtility.getColumnValue("visit_time_fr", dom1, objContext));
					
					valueXmlString.append( "<Detail"+objContext+" dbID='' domID='"+domId+"' objContext='"+currentFormNo+"' selected='N' formName='"+formName+"'>\r\n" );

					System.out.println("drVisit ========["+drVisit+"]");
					System.out.println("drVisit ========["+drVisit.length()+"]");

					if( drVisit.trim().length() != 0)
					{
						System.out.println("drVisit IF========["+drVisit+"]");
					valueXmlString.append("<visit_time_to protect='1'><![CDATA[" ).append( drVisit ).append( "]]></visit_time_to>\r\n" );
					valueXmlString.append("<remark protect='1'><![CDATA[" ).append( "TEST" ).append( "]]></remark>\r\n" );

					}
					else
					{
						System.out.println("else ========["+drVisit+"]");
						valueXmlString.append("<visit_time_to protect='0'><![CDATA[" ).append( drVisit ).append( "]]></visit_time_to>\r\n" );
						valueXmlString.append("<remark protect='0'><![CDATA[" ).append( "" ).append( "]]></remark>\r\n" );

					}
					valueXmlString.append("</Detail"+objContext+">");

				}*/
			}
				// Added by Harion S for fortune server -18-May-2021 [End]
			else if("place".equalsIgnoreCase(formName))
			{
				valueXmlString.append(getPlaceDetail(currentColumn,objContext,currentFormNo,formName,dom,dom1,dom2,connectionObject,userId,currDate,loginCode,chgTerm));
			}
			else if("doctor".equalsIgnoreCase(formName))
			{
				//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
				DARCommonBean darCommonBean= new DARCommonBean();
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
				//Added by kailash on 21-09-18[start]
				String selLocality="",selRouteId="";
				String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
				String salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom2, mainFormNo));
				selLocality = getLocFromDom(dom2, locFormNo , salesPers,connectionObject );
				String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present
				//Added by kailash on 21-09-18[end]
				selRouteId = getRouteIdFromDom(dom2, locFormNo , salesPers,connectionObject );// added by mrunalini sinkar for selected route id on 27-april-2019
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, mainFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, mainFormNo);
					String actCode = genericUtility.getColumnValue("activity_code", dom2, mainFormNo);



					String custDetail="";
					//Commetned and added by kailash on 21-09-18[start]
					//custDetail = getCustomerDetail( dom, dom2, objContext, userId, sprsCode, actCode, trvDate,"D" ,formName,connectionObject);
					custDetail = getCustomerDetail( dom, dom2, objContext, userId, sprsCode, actCode, trvDate,"D" ,formName,selLocality,selRouteId,connectionObject);
					//Commetned and added by kailash on 21-09-18[end]
					//System.out.println("itemchange custDetail in 3th form:::::::"+custDetail);
					valueXmlString.append( custDetail );
					String customers = getCustFromDom( genericUtility.parseString("<Root>"+custDetail+"</Root>"), objContext, sprsCode, "Y",connectionObject);
					//System.out.println("customers in itemchange:::::::"+customers);
					temp = customers.split(",");

					HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
					//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
					if(subFormsMap.containsKey("sampleitem"))
					{
						String sampleitemFormNo = subFormsMap.get("sampleitem");
						if ( preDomExists( dom2, sampleitemFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, sampleitemFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingItem = getSampleExistingItemsDetail( sprsCode, trvDate , customers,sampleitemFormNo,"sampleitem",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					if(subFormsMap.containsKey("sampleorder"))
					{
						String sampleorderFormNo = subFormsMap.get("sampleorder");
						if ( preDomExists( dom2, sampleorderFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, sampleorderFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							
							String existingItem = getExistingItemsDetail( sprsCode, trvDate , customers,sampleorderFormNo,"sampleorder",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					if(subFormsMap.containsKey("brand"))
					{
						String brandFormNo = subFormsMap.get("brand");
						if ( preDomExists( dom2, brandFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, brandFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingBrand = getExistingPitchForDoctor( sprsCode, trvDate, customers, "", "", brandFormNo,"brand",connectionObject );
							//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingBrand + "]" );
							if( existingBrand !=null && existingBrand.length() > 0 )
							{
								valueXmlString.append( existingBrand);
							}
						}
					}
					if(subFormsMap.containsKey("display"))
					{
						String displayFormNo = subFormsMap.get("display");
						if ( preDomExists( dom2, displayFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, displayFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingDnd = getExistingDndDetailDisplay( sprsCode, trvDate, customers, connectionObject,displayFormNo,"display") ;
							//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingDnd + "]" );
							if( existingDnd !=null && existingDnd.length() > 0 )
							{
								valueXmlString.append( existingDnd);
							}
						}
					}
					if(subFormsMap.containsKey("team"))
					{
						String teamFormNo = subFormsMap.get("team");
						if ( preDomExists( dom2, teamFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, teamFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingTeam = getSalesExistingTeamDetail( sprsCode, trvDate , customers,teamFormNo,"team",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existiteam [ " + existingTeam + "]" );
							if( existingTeam !=null && existingTeam.length() > 0 )
							{
								valueXmlString.append( existingTeam);
							}
						}
					}
					// added by rupali on 11/09/17 for new subfrom [start]
					if(subFormsMap.containsKey("brandsurvey"))
					{
						String brandSurveyFormNo = subFormsMap.get("brandsurvey");
						if ( preDomExists( dom2, brandSurveyFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, brandSurveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingBrandSurvey = getExistingBrandSurveyDetail( sprsCode, trvDate, customers, brandSurveyFormNo,"brandsurvey", connectionObject );
							//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingBrand + "]" );
							if( existingBrandSurvey !=null && existingBrandSurvey.length() > 0 )
							{
								valueXmlString.append( existingBrandSurvey);
							}
						}
					}
					// added by rupali on 11/09/17 for new subfrom [end]
					// added by rupali on 12/09/18 for adding survey subform in DAR [start]
					if(subFormsMap.containsKey("survey"))
					{
						String surveyFormNo = subFormsMap.get("survey");
						if ( preDomExists( dom2, surveyFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, surveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingSurvey = getExistingSurveyDetail( userId, trvDate, customers, surveyFormNo,"survey", connectionObject );
							//System.out.println( "DefaultDataDAR :: existingSurvey [ " + existingSurvey + "]" );
							if( existingSurvey !=null && existingSurvey.length() > 0 )
							{
								valueXmlString.append( existingSurvey);
							}
						}
					}
					// added by rupali on 12/09/18 for adding survey subform in DAR [end]
					//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] start
					if(subFormsMap.containsKey("coaching"))
					{
						String coachingFormNo = subFormsMap.get("coaching");
						String sprsCodeWrkWith = getSelectedRowValue(dom2, mainFormNo, "sprs_code__ww", 0);
						String vistedWith = getSelectedRowValue(dom2, mainFormNo, "visited_with", 0);
						//System.out.println("sprsCodeWrkWith ["+sprsCodeWrkWith+"]vistedWith["+ vistedWith +"]");
						if ( preDomExists( dom2, coachingFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, coachingFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingCoaching = getExistingCoachingDetail( userId, trvDate, customers, coachingFormNo,"coaching", connectionObject,sprsCodeWrkWith,vistedWith );
							//System.out.println( "DefaultDataDAR :: existingSurvey [ " + existingSurvey + "]" );
							if( existingCoaching !=null && existingCoaching.length() > 0 )
							{
								valueXmlString.append( existingCoaching);
							}
						}
					}
					//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] end
					//Added by Bhagyashri T for Invoice form[22/08/2022][start]
					if(subFormsMap.containsKey("invoice"))
					{
						String invoiceFormNo = subFormsMap.get("invoice");
						if ( preDomExists( dom2, invoiceFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, invoiceFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
						//System.out.println( "DefaultDataDAR :: prevFormValues for invoice [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
							//String prcListTemp= getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
							String existingItem = getExistingInvoiceDetail( dom,sprsCode, trvDate , customers,invoiceFormNo,"invoice",dom2,"",connectionObject) ;
							//System.out.println( "DefaultDataDAR :: existingItem in invoice [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					//Added by Bhagyashri T for Invoice form[22/08/22][end]
					
					//added by prachi 16-sep
					if(subFormsMap.containsKey("collection"))
					{
						String collectionFormNo = subFormsMap.get("collection");
						if ( preDomExists( dom2, collectionFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, collectionFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
						    valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							/*
							if(customers.contains("'"))
							{
								customers = customers.replace("'", "");
							}
							*/
							String existingItem = getExistingCollectionDetail(sprsCode, trvDate, customers, connectionObject,collectionFormNo,"collection","",true) ;
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
				}
				else if( currentColumn.equalsIgnoreCase( "call_outcome" ))
				{
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					String outCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1, ""+currentFormNo));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					String call = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom1, ""+currentFormNo));
					String contactPerson = checkNull(genericUtility.getColumnValue("contact_pers", dom1, ""+currentFormNo));
					String meetSumm = checkNull(genericUtility.getColumnValue("meet_summ", dom1, ""+currentFormNo));


					//System.out.println("outCome call_outcome: ["+outCome+"]domIDcall_outcome["+domID+"]call_outcomestrgCode["+strgCode);
					//System.out.println("outCome : ["+outCome+"]domID["+domID);
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );

					if(outCome.equalsIgnoreCase("0"))
					{
						valueXmlString.append( "<oth_participant protect='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='1'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						//valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
						if(outCome.equalsIgnoreCase("0"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					else
					{
						valueXmlString.append( "<meet_summ protect='0'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<oth_participant protect='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='0'><![CDATA[" ).append(contactPerson).append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						if(outCome.equalsIgnoreCase("4"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("3"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("2"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("1"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("5"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("6"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("7"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");

				}
				else if( currentColumn.equalsIgnoreCase( "itm_defaultedit" ))
				{
					//System.out.println("itm_defaultedit OF DAR doctor");
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					String outCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1, ""+currentFormNo));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					//Prasad Unlisted_customer
					String custName = checkNull(genericUtility.getColumnValue("cust_name", dom1, ""+currentFormNo));// Added by Hariom S for Table View ralated Changes -08-Jult-2021
					//System.out.println("outCome itm_defaultedit: ["+outCome+"]domIDitm_defaultedit["+domID+"]strgCode in itemdefaultedit["+strgCode);
					String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom1, ""+currentFormNo));
					String contactPerson = checkNull(genericUtility.getColumnValue("contact_pers", dom1, ""+currentFormNo));//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
					String meetSumm = checkNull(genericUtility.getColumnValue("meet_summ", dom1, ""+currentFormNo));
					String visitTimeFrom = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, ""+currentFormNo)); //Added by Hariom S for Table View ralated Changes -08-July-2021
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<uniq_strg_code protect = '1' visible = '0'><![CDATA[" ).append(strgCode).append( "]]></uniq_strg_code>\r\n" );
					if(outCome.equalsIgnoreCase("0"))
					{

						valueXmlString.append( "<oth_participant protect='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='1'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						if(outCome.equalsIgnoreCase("0"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					else
					{
						valueXmlString.append( "<meet_summ protect='0'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<oth_participant protect='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='0'><![CDATA[" ).append(contactPerson).append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]
						if ( "0000000000".equalsIgnoreCase( strgCode ) || "UR00000000".equalsIgnoreCase( strgCode ) || "US00000000".equalsIgnoreCase( strgCode ) || "UO00000000".equalsIgnoreCase( strgCode ) )
						{
							valueXmlString.append( "<cust_name visible='0'><![CDATA[" ).append(custName).append( "]]></cust_name>\r\n" );
							valueXmlString.append( "<visit_time_from visible='0'><![CDATA[" ).append(visitTimeFrom).append( "]]></visit_time_from>\r\n" );
						}
						//Added by Hariom S for Table View ralated Changes -08-July-2021 [End]
						if(outCome.equalsIgnoreCase("4"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("3"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("2"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("1"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("5"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("6"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("7"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");

				}
				// added by rupali on 06/11/17 for displaying preffered stockist field [start]
				else if( currentColumn.equalsIgnoreCase("stockist_code"))
				{
					//System.out.println("INSIDE stockist_code itemchange................");
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom1,objContext));
					//System.out.println("stockist code is  :"+stockistCode);
					String stockistName="";
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						sql = "SELECT CUST_NAME AS STRG_NAME FROM CUSTOMER WHERE CUST_CODE = ? ";
					}
					else
					{
						sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME FROM STRG_CUSTOMER SC WHERE SC_CODE = ? ";
					}
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, stockistCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stockistName = checkNull(rs.getString("STRG_NAME"));
						//System.out.println("stockistName"+stockistName);

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<stockist_name><![CDATA[" ).append(checkNull(stockistName)).append( "]]></stockist_name>\r\n" );
					valueXmlString.append("<stockist_code><![CDATA[" ).append(checkNull(stockistCode)).append( "]]></stockist_code>\r\n" );
					valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				}
				// added by rupali on 06/11/17 for displaying preffered stockist field [end]
				// added by kailash on 10-09-18 for unlisted customer addition changes [start]
				else if( currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					//added by mrunalini sinkar to showing custoerwise form number12-03-2019(start)
					//System.out.println("itm_default_add OF DAR doctor");
					String isFortune  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
					String activityFormNo = checkNull(getFormNo(objName, "activity", connectionObject));
					String formMandatory = getSfaParmValue(userId,"IS_FORM_MANDATORY",connectionObject);
					String actCode = genericUtility.getColumnValue("activity_code", dom2, mainFormNo);//Added by kailash

					String sprsActCode="";
					if("Y".equalsIgnoreCase(isFortune))
					{
						sprsActCode = checkNull(getActCodeFromActivityFormDom(dom2, activityFormNo ,connectionObject ));
					}
					else
					{
						sprsActCode="'"+actCode+"'";
					}
					
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
					String teamFormName="";
					String sampleOrder=checkNull(getFormNo(objName, "sampleorder", connectionObject));
					String samplItem=checkNull(getFormNo(objName, "sampleitem", connectionObject));
					String display=checkNull(getFormNo(objName, "display", connectionObject));
					String brand=checkNull(getFormNo(objName, "brand", connectionObject));
					String prescription=checkNull(getFormNo(objName, "brandsurvey", connectionObject));
					String survey=checkNull(getFormNo(objName, "survey", connectionObject));
					String coaching=checkNull(getFormNo(objName, "coaching", connectionObject));
					String doctorTeam=checkNull(getFormNo(objName, "team", connectionObject));
					teamFormName=doctorTeam;
					String visitedWithTeam = checkNull(genericUtility.getColumnValue("visited_with" , dom2 ));
					String visitedWithDisp=darCommonBean.getVisitedWithDisp(visitedWithTeam, connectionObject);
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
					//System.out.println("outside getVisitedWithDisp::"+visitedWithDisp);
					//added by mrunalini sinkar to showing custoerwise form number12-03-2019(end)
					int maxDomId= 0;
					String subFormDetails = "";
					String formNo = "";
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int maxVal = Collections.max(domIdList);
					maxDomId = maxVal;
					String itemSer = checkNull(getItemSer(userId, connectionObject));// added by mrunalini sinkar for class code changes(start)
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, mainFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, mainFormNo);
					String evtType = genericUtility.getColumnValue("activity_type", dom2, mainFormNo);
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, locFormNo));
					String routeId = checkNull(genericUtility.getColumnValue("route_id", dom2, locFormNo));
					String descr = checkNull(genericUtility.getColumnValue("sprs_route_descr", dom2, locFormNo));

					//System.out.println("sprsCode["+localityCode+"]trvDate["+routeId+"]evtType["+evtType+"]actCode["+actCode+"]");

					HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);

					Iterator itrt= subFormsMap.entrySet().iterator();
					while(itrt.hasNext())
					{
						Map.Entry en = (Map.Entry) itrt.next();
						formNo =   (String) en.getKey();
						String subformNa =  (String)en.getValue();
						if(subFormDetails == null || subFormDetails.trim().length() == 0)
						{
							subFormDetails = subformNa;
						}
						else
						{
							subFormDetails = subFormDetails + "," + subformNa;
						}
					}
					String templateId=checkNull(getTemplateIdForUnlisted(salesPers,"D",connectionObject));
					//System.out.println( "subFormDetails"+ subFormDetails  );
					String strgCode = generateCustomerCode(connectionObject);
					//System.out.println("strgCode["+strgCode+"]");
					String dcrGroup = getDcrGroup("D",connectionObject); // adde by mrunalini sinkar on 29-jan-2019
					
					// added by shweta for removing hardcode cust_type value and get value form dcrGroup 28-05-21 [started]
					// String custTypeName= getCustTypeDcr(dcrGroup,salesPers,connectionObject);
					 
					 String	custTypeName="";
					 String custStrgType="";
						String custTypeNamesql=" SELECT  G.FLD_VALUE AS CUST_TYPE,SCT.SH_DESCR AS SH_DESCR,SCT.TYPE AS STRG_TYPE FROM GENCODES G , STRG_CUST_TYPE SCT " +
								   " WHERE (INSTR(FLD_VALUE,'-')) > 0 AND SUBSTR(G.FLD_VALUE,INSTR(G.FLD_VALUE,'-')+1,LENGTH(G.FLD_VALUE))=SCT.SH_DESCR " +
								   " AND G.MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' AND sct.dcr_group='D' AND (ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE =?) " +
								   " IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL )) ";
						
						   pstmt = connectionObject.prepareStatement(custTypeNamesql);
							pstmt.setString(1, userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
						  	custTypeName = checkNull(rs.getString("CUST_TYPE"));
						  	custStrgType=checkNull(rs.getString("STRG_TYPE"));
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
					 
				   // System.out.println("inside ncw form line no 17463 ::::::::::["+custTypeName+"]");
					// added by shweta for removing hardcode cust_type value and get value form dcrGroup 28-05-21 [ended]
					 
					//Added by kailash on 20-02-19[start]
					String []eventTime = new String [2];
					eventTime = getEventStartEndTime(connectionObject,userId,trvDate);
					//System.out.println("eventTime::"+eventTime);
					//Added by kailash on 20-02-19[end]

					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+maxDomId+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					if("Y".equalsIgnoreCase(isFortune))
					{
						valueXmlString.append("<event_type visible='1'><![CDATA[" ).append("").append( "]]></event_type>\r\n" );
					}
					else
					{
						valueXmlString.append("<event_type visible='0'><![CDATA[" ).append(checkNull(actCode)).append( "]]></event_type>\r\n" );
					}
					
					valueXmlString.append("<member_present><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
					valueXmlString.append("<event_time_start protect = '0' visible = '1'><![CDATA[" ).append(eventTime[0]).append( "]]></event_time_start>\r\n" );
					valueXmlString.append("<event_time_end protect = '0' visible = '1'><![CDATA[" ).append(eventTime[1]).append( "]]></event_time_end>\r\n" );
					valueXmlString.append("<visit_time_from protect = '0' visible = '0'><![CDATA[" ).append(eventTime[0]).append( "]]></visit_time_from>\r\n" );


					if(!isMemberPresnt.equalsIgnoreCase("Y")) // added condition by mrunalini sinkar for memberpresent validation
					{
						valueXmlString.append("<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append("<locality_descr protect = '1' visible='1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );

						valueXmlString.append("<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );

						valueXmlString.append("<stockist_code visible='1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						valueXmlString.append("<stockist_name visible='1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						//valueXmlString.append("<strg_name protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_name visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_class_code visible='1'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<class_code_descr visible='1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<spl_code visible='1'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr visible='1'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<pin visible='1'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
						valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
						valueXmlString.append("<man_power visible='1'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
						valueXmlString.append("<image_id visible='1'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
						valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
						//added by prachi
						valueXmlString.append("<age visible='1'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
					}
					// added condition by mrunalini sinkar for memberpresent validation(start)
					else
					{
						valueXmlString.append("<locality_code protect = '0' visible='0'><![CDATA[" ).append(localityCode).append( "]]></locality_code>\r\n" );
						valueXmlString.append("<locality_descr protect = '1' visible='0'><![CDATA[" ).append(descr).append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<route_id protect = '0' visible='0'><![CDATA[" ).append(routeId).append( "]]></route_id>\r\n" );
						valueXmlString.append("<sku_value protect = '0' visible = '1'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
						valueXmlString.append("<stockist_code visible='0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						valueXmlString.append("<stockist_name visible='0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("UNLISTED DOCTOR MET").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<pin visible='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
						valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
						valueXmlString.append("<man_power visible='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
						valueXmlString.append("<image_id visible='0'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
						valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
						valueXmlString.append("<address_as visible='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append("<addr1 visible='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 visible='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 visible='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						//added by prachi
						valueXmlString.append("<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						valueXmlString.append("<gender visible='0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
						valueXmlString.append("<mobile_no visible='0'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<email_addr visible='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append("<strg_class_code visible='0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<class_code_descr visible='0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<spl_code visible='0'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr visible='0'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date



					}
					// added condition by mrunalini sinkar for memberpresent validation(end)
					valueXmlString.append("<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
					valueXmlString.append("<cust_name protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></cust_name>\r\n");
					//Commented and changed by kailash on 20-02-19 for solving issue of time validation after change in property editor[start]
					//valueXmlString.append("<event_time_start protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></event_time_start>\r\n" );
					//valueXmlString.append("<event_time_end protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></event_time_end>\r\n" );
					//Commented and changed by kailash on 20-02-19 for solving issue of time validation after change in property editor[end]
					valueXmlString.append("<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[" ).append(sprsCode).append( "]]></sales_pers>\r\n" );
					valueXmlString.append("<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );

					//valueXmlString.append("<call_outcome><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
					valueXmlString.append("<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
					valueXmlString.append("<strg_code protect = '0' visible = '1'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
					valueXmlString.append("<uniq_strg_code protect = '1' visible = '0'><![CDATA[" ).append(strgCode).append( "]]></uniq_strg_code>\r\n" );
					//  valueXmlString.append("<cust_type protect = '0' visible = '1'><![CDATA[" ).append("UNLISTED-DOCTOR").append( "]]></cust_type>\r\n" );
					valueXmlString.append("<cust_type protect = '0' visible = '1'><![CDATA[" ).append(custTypeName).append( "]]></cust_type>\r\n" );  // change by shweta 28-05-21 for removing hardcode cust_type value 
				//  valueXmlString.append("<strg_type protect = '1' visible = '0'><![CDATA[" ).append("D").append( "]]></strg_type>\r\n" );
					
					valueXmlString.append("<strg_type protect = '1' visible = '0'><![CDATA[" ).append(custStrgType).append( "]]></strg_type>\r\n" ); // chnages by shweta 31-05-21
					valueXmlString.append("<dcr_group protect = '1' visible = '0'><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
					valueXmlString.append("<current_form_subform><![CDATA[" ).append(subFormDetails).append( "]]></current_form_subform>\r\n" );
					valueXmlString.append("<sel_loc_code><![CDATA[" ).append(selLocality).append( "]]></sel_loc_code>\r\n" );
					//Added by kailash on 23-01-19 for chc related changes[start].
					valueXmlString.append("<order_form_no><![CDATA[" ).append(sampleOrder).append( "]]></order_form_no>\r\n" );
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
					valueXmlString.append("<team_form_no><![CDATA[" ).append(doctorTeam).append( "]]></team_form_no>\r\n" );
					valueXmlString.append("<item_form_no><![CDATA[" ).append(samplItem).append( "]]></item_form_no>\r\n" );
					valueXmlString.append("<brand_form_no><![CDATA[" ).append(brand).append( "]]></brand_form_no>\r\n" );
					valueXmlString.append("<display_form_no><![CDATA[" ).append(display).append( "]]></display_form_no>\r\n" );
					valueXmlString.append("<prescription_form_no><![CDATA[" ).append(prescription).append( "]]></prescription_form_no>\r\n" );
					valueXmlString.append("<survey_form_no><![CDATA[" ).append(survey).append( "]]></survey_form_no>\r\n" );
					valueXmlString.append("<coaching_form_no><![CDATA[" ).append(coaching).append( "]]></coaching_form_no>\r\n" );
					valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
					//Added by kailash on 23-01-19 for chc related changes[end].
					// added by mrunalini sinkar for class code changes (start)

					int clsCount= getClassCodeCount(userId,itemSer,connectionObject);
					if(clsCount > 0)
					{
						valueXmlString.append("<cust_class_input>").append(itemSer).append("</cust_class_input>\r\n");

					}
					else
					{
						valueXmlString.append("<cust_class_input>").append("D").append("</cust_class_input>\r\n");

					}
					// added by mrunalini sinkar for class code changes (end)
					valueXmlString.append("<sel_route_id><![CDATA[" ).append(selRouteId).append( "]]></sel_route_id>\r\n" );// added by mrunalini sinakr for route id condtion
					valueXmlString.append("<survey_templ>").append(templateId).append("</survey_templ>\r\n");
					valueXmlString.append("<is_form_mandatory><![CDATA[" ).append(formMandatory).append( "]]></is_form_mandatory>\r\n" );
					valueXmlString.append("<sprs_act_code><![CDATA[" ).append(sprsActCode).append( "]]></sprs_act_code>\r\n" );
					valueXmlString.append("<is_fortune_activity><![CDATA[" ).append(isFortune).append( "]]></is_fortune_activity>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );

				}
				//added by mrunalini sinkar for cust_type itemchange on 30-01-2019(start)
				else if( currentColumn.equalsIgnoreCase("cust_type"))
				{
					String custType = checkNull(genericUtility.getColumnValue("cust_type", dom1,objContext));
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom1,objContext));

					String stockistName = checkNull(genericUtility.getColumnValue("stockist_name", dom1,objContext));

					if(custType.contains("-"))
					{
						String strgType="",dcrGroup="";
						sql = "SELECT  TYPE AS STRG_TYPE,DCR_GROUP FROM  STRG_CUST_TYPE " +
								"WHERE SUBSTR(?,INSTR(?,'-')+1,LENGTH(?))=SH_DESCR ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1,custType);
						pstmt.setString(2,custType);
						pstmt.setString(3,custType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							strgType = checkNull(rs.getString("STRG_TYPE"));
							dcrGroup = checkNull(rs.getString("DCR_GROUP"));

						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						String templateId=checkNull(getTemplateIdForUnlisted(salesPers,strgType,connectionObject));

						valueXmlString.append("<Detail"+currentFormNo+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append(strgType).append( "]]></strg_type>\r\n" );
						valueXmlString.append("<dcr_group protect = '0'><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
						if("D".equalsIgnoreCase(strgType) || "C".equalsIgnoreCase(strgType))
						{
							valueXmlString.append("<stockist_code protect = '0' visible='1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible='1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );

						}
						else
						{
							valueXmlString.append("<stockist_code protect = '0' visible='0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible='0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );

						}
						// added by mrunalini sinkar for class code changes (start)
						String itemSer = checkNull(getItemSer(userId, connectionObject));
						int clsCount= getClassCodeCount(userId,itemSer,connectionObject);
						if(clsCount > 0)
						{
							valueXmlString.append("<cust_class_input>").append(itemSer).append("</cust_class_input>\r\n");

						}
						else
						{
							valueXmlString.append("<cust_class_input>").append(strgType).append("</cust_class_input>\r\n");

						}
						valueXmlString.append("<survey_templ>").append(templateId).append("</survey_templ>\r\n");

						// added by mrunalini sinkar for class code changes (end)
						valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );

					}

				}
				//added by mrunalini sinkar for cust_type itemchange on 30-01-2019(end)
				//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]
				else if( currentColumn.equalsIgnoreCase( "cust_name" ))
				{
					try 
					{
						//System.out.println("In cust_name condition in itemchnage");
						String domID = checkNull(getDomID(dom1, ""+currentFormNo));
						String custName = checkNull(genericUtility.getColumnValue("cust_name", dom1, ""+currentFormNo));
						//System.out.println("domID["+domID+"], custName is ["+custName+"]");
						
						if ( custName != null && custName.length() > 0 )
						{
							JSONObject custNameDetJson = new JSONObject(custName);
							//System.out.println("custNameDetJson ["+ custNameDetJson +"]");
							String formatFieldName = custNameDetJson.getString("FORMAT_FIELD_NAME");
							//System.out.println("formatFieldName ["+ formatFieldName +"]");
							String formatFieldVal = custNameDetJson.getString("FORMAT_FIELD_VAL");
							//System.out.println("formatFieldVal ["+ formatFieldVal +"]");
							String custNameVal = custNameDetJson.getString("FIELD_VAL");
							//System.out.println("custNameVal ["+ custNameVal +"]");
							String fieldFormat = custNameDetJson.getString("FIELD_FORMAT");
							//System.out.println("fieldFormat ["+ fieldFormat +"]");
							
							valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n");
							/*valueXmlString.append("<cust_name format='").append( fieldFormat ).append("'><![CDATA[" ).append(checkNull(custNameVal)).append("]]></cust_name>\r\n");*/
							valueXmlString.append("<").append( formatFieldName ).append("><![CDATA[").append(checkNull(formatFieldVal)).append("]]></").append( formatFieldName ).append(">\r\n");
							//valueXmlString.append("<member_present><![CDATA[").append(checkNull(formatFieldVal)).append("]]></member_present>\r\n");
							valueXmlString.append("</Detail"+currentFormNo+">\r\n");
						}
					}
					catch (Exception e) 
					{
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				else if( currentColumn.equalsIgnoreCase( "member_present" ))
				{
					
					String domID = checkNull(getDomID(dom1, ""+currentFormNo));
					String custName = checkNull(genericUtility.getColumnValue("cust_name", dom1, ""+currentFormNo));
					String memberPresent = checkNull(genericUtility.getColumnValue("member_present", dom1, ""+currentFormNo));
					try 
					{
						if ( custName != null && custName.length() > 0 )
						{
							
							valueXmlString.append( darCommonBean.getCustNameOnMeberPresent(domID,custName, memberPresent ,""+currentFormNo,formName,connectionObject));						
						}
					}
					catch (Exception e) 
					{
						e.printStackTrace();
					}
				}
				//Added by Hariom S for Table View ralated Changes -08-July-2021 [End]
				// added by kailash on 10-09-18 for unlisted customer addition changes [start]
				else if( currentColumn.equalsIgnoreCase("locality_code"))
				{

					String localityDes = "";
					String stockistCode = "";
					String stockistName = "",routeType="";
					String trvDate = checkNull(genericUtility.getColumnValue("event_date", dom2, mainFormNo));
					String custTYpe = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
					String callOutcome = checkNull(genericUtility.getColumnValue("call_outcome", dom2, objContext));

					//System.out.println("callOutcome islocality_code ["+callOutcome+"]");
					String []eventTime = new String [2];
					eventTime = getEventStartEndTime(connectionObject,userId,trvDate);
					//Added by bhagyashri To check proper DomId [28/02/22]
					String domID1 = checkNull(getDomID(dom1, ""+currentFormNo));
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom1,objContext));
					//System.out.println("localityCode9463["+localityCode+"]");
					//commented & and added by mrunalinin sinkar for beat descr changes on 27-04-2019(start)
					//sql = " SELECT DESCR, DEF_DISTRIBUTOR, SC.FIRST_NAME || ' ' || SC.LAST_NAME AS STRG_NAME FROM LOCALITY L LEFT OUTER JOIN STRG_CUSTOMER SC ON SC.SC_CODE = L.DEF_DISTRIBUTOR WHERE L.LOCALITY_CODE = ? ";
					String routeId = checkNull(genericUtility.getColumnValue("route_id", dom1,objContext));
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						sql = "SELECT (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) DESCR, L.DEF_DISTRIBUTOR, SR.ROUTE_TYPE, "+
							  "CUST.CUST_NAME AS STRG_NAME FROM LOCALITY L LEFT OUTER JOIN CUSTOMER CUST ON CUST.CUST_CODE = L.DEF_DISTRIBUTOR, SPRS_ROUTE SR "+
							  "WHERE L.LOCALITY_CODE = ? AND SR.LOCALITY_CODE = L.LOCALITY_CODE AND SR.SPRS_CODE = ? AND SR.ROUTE_ID = ? ";
					}
					else
					{
						sql="SELECT (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) DESCR, " +
								"  L.DEF_DISTRIBUTOR, SR.ROUTE_TYPE, " +
								" SC.FIRST_NAME || ' '|| SC.LAST_NAME AS STRG_NAME FROM LOCALITY L LEFT OUTER JOIN STRG_CUSTOMER SC ON SC.SC_CODE = L.DEF_DISTRIBUTOR,SPRS_ROUTE SR " +
								" WHERE L.LOCALITY_CODE = ?  AND SR.LOCALITY_CODE=L.LOCALITY_CODE AND SR.SPRS_CODE=? AND SR.ROUTE_ID=? ";
					}


					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,localityCode);
					pstmt.setString(2,salesPers);
					pstmt.setString(3,routeId);
					//commented & and added by mrunalinin sinkar for beat descr changes on 27-04-2019(start)

					rs = pstmt.executeQuery();
					if(rs.next())
					{
						localityDes = checkNull(rs.getString("DESCR"));
						stockistCode = checkNull(rs.getString("DEF_DISTRIBUTOR"));
						stockistName = checkNull(rs.getString("STRG_NAME"));
						routeType = checkNull(rs.getString("ROUTE_TYPE"));

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					if(custTYpe.contains("UNLISTED"))
					{
					if("M".equalsIgnoreCase(routeType))
					{
						valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID1+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<locality_descr protect = '1' visible='1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<stockist_code protect =  '0' visible='0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
						valueXmlString.append("<stockist_name protect =  '1' visible='0'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("UNLISTED DOCTOR MET").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<pin visible='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
						valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
						valueXmlString.append("<man_power visible='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
						valueXmlString.append("<image_id visible='0'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
						valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
						valueXmlString.append("<address_as visible='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append("<addr1 visible='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 visible='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 visible='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append("<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );

						valueXmlString.append("<meet_summ visible='0'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append("<route_type visible='0'><![CDATA[" ).append(checkNull(routeType)).append( "]]></route_type>\r\n" );


						if("Y".equalsIgnoreCase(isMemberPresnt))
						{
							valueXmlString.append("<sku_value protect = '0' visible = '1'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
							valueXmlString.append("<member_present visible = '1'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );

						}
						else
						{
							valueXmlString.append("<sku_value protect = '1' visible = '0'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
							valueXmlString.append("<member_present visible = '0'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
						}


						valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
						valueXmlString.append( "<gender visible='0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
						valueXmlString.append("<mobile_no visible='0'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<email_addr visible='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						//valueXmlString.append("<strg_class_code visible='0'><![CDATA[ ]]></strg_class_code>\r\n" );
						//valueXmlString.append("<class_code_descr visible='0'><![CDATA[ ]]></class_code_descr>\r\n" );
						//valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						//valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<spl_code visible='0'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr visible='0'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );
						valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
					}
					else
					{
						valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID1+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<locality_descr protect = '1' visible='1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<member_present visible = '1'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
						valueXmlString.append("<sku_value protect = '0' visible = '1'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
						valueXmlString.append("<route_type visible='0'><![CDATA[" ).append(checkNull(routeType)).append( "]]></route_type>\r\n" );


						if(!isMemberPresnt.equalsIgnoreCase("Y")) // added condition by mrunalini sinkar for memberpresent validation
						{
							valueXmlString.append("<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
							valueXmlString.append("<stockist_code visible='1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name visible='1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
							valueXmlString.append("<strg_name protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
							valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
							valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
							valueXmlString.append("<pin visible='1'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
							valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
							valueXmlString.append("<man_power visible='1'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
							valueXmlString.append("<image_id visible='1'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
							valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
							valueXmlString.append("<meet_summ visible='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );

							valueXmlString.append("<address_as visible='1'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
							valueXmlString.append("<addr1 visible='1'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
							valueXmlString.append("<addr2 visible='1'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
							valueXmlString.append("<addr3 visible='1'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
							valueXmlString.append("<age visible='1'><![CDATA[" ).append("").append( "]]></age>\r\n" );
							valueXmlString.append("<call_outcome visible='1'><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
							valueXmlString.append("<gender visible='1'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append("<mobile_no visible='1'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
							valueXmlString.append("<email_addr visible='1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
							//valueXmlString.append("<strg_class_code visible='1'><![CDATA[ ]]></strg_class_code>\r\n" );
							//valueXmlString.append("<class_code_descr visible='1'><![CDATA[ ]]></class_code_descr>\r\n" );
							valueXmlString.append("<spl_code visible='1'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
							valueXmlString.append("<speciality_descr proetct='1' visible='1'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
							valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
						}
						// added condition by mrunalini sinkar for memberpresent validation(start)
						else
						{
							valueXmlString.append("<stockist_code visible='0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name visible='0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
							valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("UNLISTED DOCTOR MET").append( "]]></strg_name>\r\n" );
							valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
							valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
							valueXmlString.append("<pin visible='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
							valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
							valueXmlString.append("<man_power visible='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
							valueXmlString.append("<image_id visible='0'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
							valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
							valueXmlString.append("<address_as visible='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
							valueXmlString.append("<addr1 visible='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
							valueXmlString.append("<addr2 visible='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
							valueXmlString.append("<addr3 visible='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
							valueXmlString.append("<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
							valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
							valueXmlString.append("<gender visible='0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );

							valueXmlString.append("<mobile_no visible='0'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
							valueXmlString.append("<email_addr visible='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
							//valueXmlString.append("<strg_class_code visible='0'><![CDATA[ ]]></strg_class_code>\r\n" );
							//valueXmlString.append("<class_code_descr visible='0'><![CDATA[ ]]></class_code_descr>\r\n" );
							valueXmlString.append("<spl_code visible='0'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
							valueXmlString.append("<speciality_descr visible='0'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
							valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
						}

						valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
					}
					}else
					{
						valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID1+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<locality_descr protect = '1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<locality_code protect = '0'><![CDATA[" ).append(checkNull(localityCode)).append( "]]></locality_code>\r\n" );
						valueXmlString.append("<stockist_code protect = '0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
						valueXmlString.append("<stockist_name protect = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
					}

				}
				else if( currentColumn.equalsIgnoreCase("event_type"))
				{
					String sprsActCode = checkNull(genericUtility.getColumnValue("sprs_act_code", dom1, objContext));
					String domID1 = checkNull(getDomID(dom1, ""+currentFormNo));
					if(sprsActCode!=null && sprsActCode.trim().length()>0)
					{			
						String eventType = checkNull(genericUtility.getColumnValue("event_type", dom1, objContext));
						valueXmlString.append( darCommonBean.getEventType(domID1,sprsActCode, eventType , salesPers,""+currentFormNo,formName,connectionObject));						

					}					
				}
				
				else if( currentColumn.equalsIgnoreCase("visit_time_from"))
				{
					String visitTimeStart = checkNull(genericUtility.getColumnValue("visit_time_from", dom1,objContext));
					//System.out.println("visitTimeStart["+visitTimeStart+"]");
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));// Added By Hariom S for proper dom id data set -14-Sep-2021
					
					valueXmlString.append("<Detail"+objContext+" domID='"+domID+"' formName='"+formName+"'>\r\n" );// Added By Hariom S for proper dom id data set -14-Sep-2021																				
					valueXmlString.append("<event_time_start><![CDATA[" ).append(visitTimeStart).append( "]]></event_time_start>\r\n" );
					//valueXmlString.append("<event_time_end><![CDATA[" ).append(visitTimeStart).append( "]]></event_time_end>\r\n" );
					valueXmlString.append("</Detail"+objContext+">\r\n" );

				}
				else if( currentColumn.equalsIgnoreCase("event_time_start"))
				{
					String eventTimeStart = checkNull(genericUtility.getColumnValue("event_time_start", dom1,objContext));

					String domID=checkNull(getDomID(dom1, ""+currentFormNo));// Added By Hariom S for proper dom id data set -14-Sep-2021
					
					valueXmlString.append("<Detail"+objContext+" domID='"+domID+"' formName='"+formName+"'>\r\n" );// Added By Hariom S for proper dom id data set -14-Sep-2021																				
					valueXmlString.append("<visit_time_from visible='0'><![CDATA[" ).append(eventTimeStart).append( "]]></visit_time_from>\r\n" );
					//valueXmlString.append("<event_time_end visible='0'><![CDATA[" ).append(eventTimeStart).append( "]]></event_time_end>\r\n" );

					valueXmlString.append("</Detail"+objContext+">\r\n" );
				}
				else if( currentColumn.equalsIgnoreCase("strg_code"))
				{
					String strgCodeDom = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
					String locCodeDom = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(locCodeDom!=null)
					{
						valueXmlString.append( darCommonBean.getStrgCodedata(domID,strgCodeDom, locCodeDom ,""+currentFormNo,formName,connectionObject));
					}
				}
				//Added by bhagyashri T For Add contact_pers itemchange[25/MAR/22][W21KFOR011][START]
				else if( currentColumn.equalsIgnoreCase("contact_pers"))
				{
					String euinNo = checkNull(genericUtility.getColumnValue("contact_pers", dom1, objContext));
					String strgCodeC = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
					String domID1 = checkNull(getDomID(dom1, ""+currentFormNo));
					if(strgCodeC!=null && strgCodeC.trim().length()>0)
					{			
						valueXmlString.append( darCommonBean.getContactPersName(domID1,strgCodeC, euinNo ,""+currentFormNo,formName,connectionObject));
						
					}					
				}
				else if( currentColumn.equalsIgnoreCase("meeting_status"))
				{
					String eventType = checkNull(getColumnValue("event_type", dom1, objContext));
					String meetingStatus = checkNull(genericUtility.getColumnValue("meeting_status", dom1, objContext));
					String domID = checkNull(getDomID(dom1, ""+currentFormNo));
					valueXmlString.append( darCommonBean.getCallOutcome(domID,eventType, meetingStatus ,""+currentFormNo,formName,connectionObject));
				}
				//Added by bhagyashri T For Add contact_pers itemchange[25/MAR/22][W21KFOR011][END]
			}
			else if("sampleitem".equalsIgnoreCase(formName) || "retailersampleitem".equalsIgnoreCase(formName) || "stockistsampleitem".equalsIgnoreCase(formName) || "ncwsampleitem".equalsIgnoreCase(formName) )
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);

					salePersCode = checkNull(getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0));
					wrkDate = checkNull(getSelectedRowValue(dom2, parentFormNo, "event_date", 0));
					scCode = checkNull(getSelectedRowValue(dom2, parentFormNo, "strg_code", 0));
					String editScCode = checkNull(getSelectedYesRowValue(dom2, parentFormNo, "strg_code", 0));
					if(editScCode==null || editScCode.trim().length()==0)
					{
						editScCode="X";
					}
					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getSampleItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,editScCode,formName ));
				}

			}
			else if("sampleorder".equalsIgnoreCase(formName) || "retailersampleorder".equalsIgnoreCase(formName) || "stockistsampleorder".equalsIgnoreCase(formName) || "ncwsampleorder".equalsIgnoreCase(formName))
			{
				DARCommonBean darCommonBean= new DARCommonBean();

				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String prcListTemp=getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					//valueXmlString.append( getItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName));
					valueXmlString.append( getItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,prcListTemp ));
				}
				else if( currentColumn.equalsIgnoreCase( "quantity" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					//System.out.println("Inside order quantity itemchange...........");
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					String parentFormDomId="";
					//System.out.println("dom1 >>domID::["+domID+"] ");
					String qtyDom = checkNull(genericUtility.getColumnValue("quantity", dom1, ""+currentFormNo));
					String rateDom = checkNull(genericUtility.getColumnValue("landing_rate", dom1, ""+currentFormNo));
					String strgCodeDummy = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom1, ""+currentFormNo));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					String itemCode = checkNull(genericUtility.getColumnValue("item_code", dom1, ""+currentFormNo));
					double value = 0d;
					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--started
					double totPOBVal=0.0;
					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--ended
					//System.out.println("qtyDom::["+qtyDom+"] dom1 >>domID::["+domID+"] strg_code_dummy::["+strgCode+"]");
					//System.out.println("rateDom ::["+rateDom+"] itemCode:["+itemCode+"]");
					//	String objName = "strg_meet_pr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("parentFormNo::["+parentFormNo+"] ");


					parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					//System.out.println("parentFormDomId::["+parentFormDomId+"]");
					//System.out.println("dom2>>parentFormDomId::["+parentFormDomId+"]");
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--started
					String pobValueParent=checkNull(genericUtility.getColumnValue("sku_value", dom2,""+parentFormNo, parentFormDomId));

					totPOBVal =  getTotalPOBValue( dom2, ""+currentFormNo, "value", strgCode);
					//System.out.println("pobValueParent ::["+pobValueParent+"] ");
					if(pobValueParent == null || pobValueParent.trim().length() == 0)
					{
						pobValueParent = "0";
					}

					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--ended

					try
					{
						//valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"'>\r\n" );
						DecimalFormat df = new DecimalFormat("###.##");
						if(qtyDom != null && qtyDom.trim().length()!= 0)
						{
							double qty = 0d;
							double rate = 0d;
							qty = Double.parseDouble(qtyDom);
							rate = Double.parseDouble(rateDom);
							//System.out.println("qty : ["+qty+"]  rate:["+rate+"]");
							value = qty * rate;
							//System.out.println("value : ["+value+"]");
							valueXmlString.append("<value><![CDATA[" ).append(df.format(value)).append( "]]></value>\r\n" );
						}
						else
						{
							value=0;
							valueXmlString.append("<value><![CDATA[" ).append("").append( "]]></value>\r\n" );
						}

						/*totPOBVal = totPOBVal + value;
						 *
						System.out.println("totPOBVal ::::["+totPOBVal+"] ");*/
						//totPOBVal = Double.parseDouble(pobValueParent) + value  ;
						valueXmlString.append("<Detail"+parentFormNo+"."+parentFormDomId+".sku_value><![CDATA[" ).append(df.format(totPOBVal)).append( "]]></Detail"+parentFormNo+"."+parentFormDomId+".sku_value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}
					catch(NumberFormatException e)
					{
						//System.out.println("NumberFormatException......");
						valueXmlString.append("<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}

				}
				// added by rupali on 06/11/17 for applying itemchange on lot_no field [start]
				else if( currentColumn.equalsIgnoreCase( "lot_no" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					//System.out.println("Inside lot_no itemchange...........");
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					String parentFormDomId="";
				//	System.out.println("dom1 >>domID::["+domID+"] ");
					/*String lotNo = checkNull(genericUtility.getColumnValue("lot_no", dom1, ""+currentFormNo));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom1, ""+currentFormNo));
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom1, ""+currentFormNo));*/

					String lotNo = checkNull(genericUtility.getColumnValue("lot_no", dom1));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom1));
					String itemCode = checkNull(genericUtility.getColumnValue("item_code", dom1));
					//System.out.println("lotNo::["+lotNo+"] itemCode::["+itemCode+"] strg_code_dummy::["+strgCode+"]");
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("parentFormNo::["+parentFormNo+"] ");

					parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					String totMonths = darCommonBean.getTotalMonths(itemCode,lotNo,connectionObject);
					/*String expDate = "";
					sql = "select exp_date from item_lot_info where item_code = ? and  lot_no = ?";
					pstmt =  connectionObject.prepareStatement(sql);
					pstmt.setString(1, itemCode);
					pstmt.setString(2, lotNo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						expDate = (rs.getString("exp_date") == null) ?"":rs.getString("exp_date").trim();
						System.out.println("expDate is::::::"+expDate);
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					Date date1 = Calendar.getInstance().getTime();
			        DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			        String today = sdf.format(date1);
			        System.out.println("Today : " + today);
			        String totMonths = "";
			        if(expDate.trim().length() != 0)
			        {
				        SimpleDateFormat inputFormat=new SimpleDateFormat(getDBDateFormat());
						Date eventDate1=null;
						eventDate1 = inputFormat.parse(expDate);
						expDate=sdf.format(eventDate1);
						System.out.println("expDate is:::::"+expDate);

				        Date date3 = sdf.parse(today);
				        Date date2 = sdf.parse(expDate);

				        if (date3.compareTo(date2) < 0)
				        {
				        	totMonths = Integer.toString(monthsBetween(sdf.parse(today), sdf.parse(expDate)));
				        }
					    System.out.println("totMonths:::::"+totMonths);
			        }*/
					//System.out.println("parentFormDomId::["+parentFormDomId+"]");
					//System.out.println("dom2>>parentFormDomId::["+parentFormDomId+"]");
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<expiry_date><![CDATA[" ).append( totMonths ).append( "]]></expiry_date>\r\n" );
					/*if(totMonths.trim().length() != 0)
					{
						valueXmlString.append( "<expiry_date><![CDATA[" ).append( totMonths+" M" ).append( "]]></expiry_date>\r\n" );
					}
					else
					{
						valueXmlString.append( "<expiry_date><![CDATA[" ).append("0 M").append( "]]></expiry_date>\r\n" );
					}*/

					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				}
				// added by rupali on 06/11/17 for applying itemchange on lot_no field [end]
				// added by rupali on 22/12/17 for applying itemchange on stock_info field [start]
				else if( currentColumn.equalsIgnoreCase("stock_info"))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					//System.out.println("dom1 >>domID::["+domID+"] ");

					String stockInfo = checkNull(genericUtility.getColumnValue(currentColumn, dom1));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom1));
					String itemCode = checkNull(genericUtility.getColumnValue("item_code", dom1));
					//System.out.println("stockInfo::["+stockInfo+"] itemCode::["+itemCode+"] strg_code_dummy::["+strgCode+"]");
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("parentFormNo::["+parentFormNo+"] ");

					String parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					String totMonths = darCommonBean.getTotalMonths(itemCode,stockInfo,connectionObject);
					//System.out.println("totMonths::["+totMonths+"] ");
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<expiry_date><![CDATA[" ).append( totMonths ).append( "]]></expiry_date>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				}
				// added by rupali on 22/12/17 for applying itemchange on stock_info field [end]
				// added by Niraj on 10/12/17 for applying itemchange on promo_code field [start]
				else if(currentColumn.trim().equalsIgnoreCase("promo_code"))
				{
					//System.out.println("INSIDE PROMO CODE................");
					String PromoCode = checkNull(genericUtility.getColumnValue("promo_code", dom1));
					//System.out.println("Promo code is  :"+PromoCode);
					String descr="";
					sql = "SELECT DESCR FROM BOM WHERE BOM_CODE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,PromoCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = checkNull(rs.getString("DESCR"));
						//System.out.println("Descr"+descr);

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					else
					{
						domID = domID;
					}
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<description><![CDATA[" ).append(descr).append( "]]></description>\r\n" );
					valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );

				}
				else if(currentColumn.trim().equalsIgnoreCase("remarks"))
				{
					System.out.println("inside remarks::::");

					String remarks = checkNull(genericUtility.getColumnValue("remarks", dom1));
					System.out.println("remarks code is  :"+remarks);
					String descr="";
					sql = "SELECT FLD_VALUE,DESCR AS REMARK_DESCR FROM GENCODES WHERE MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' AND FLD_NAME='ORDER_REMARK' AND FLD_VALUE=?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,remarks);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = checkNull(rs.getString("REMARK_DESCR"));

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("REMARK_DESCR"+descr);

					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					else
					{
						domID = domID;
					}
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<remark_descr><![CDATA[" ).append(descr).append( "]]></remark_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				}
				// added by Niraj on 10/12/17 for applying itemchange on promo_code field [end]
			}
			else if("brand".equalsIgnoreCase(formName) || "retailerbrand".equalsIgnoreCase(formName) || "stockistbrand".equalsIgnoreCase(formName) || "ncwbrand".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "",localityCode="";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					//Added by mrunalini Sinkar 05-May-2021 for fortune 
					String callOutcome=getSelectedRowValue(dom2, parentFormNo, "meeting_status", 0);
					//String callOutcome="Supporter";
					//Added by mrunalini Sinkar 05-May-2021 for fortune (End)
					//System.out.println("salePersCode : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					//added by mrunalini sinkar for adding localityCode Edetailin changes----10-02-2018(start)
					localityCode = getSelectedRowValue(dom2, parentFormNo, "locality_code", 0);
					String copyPlan=getSelectedRowValue(dom2, parentFormNo, "copy_plan", 0); // added by mrunalini sinkar to get the attachment from MAP 27-07-2018(start)
					valueXmlString.append( getPitchDetails( salePersCode, wrkDate,copyPlan, scCode,localityCode, xtraParams, "", callOutcome, ""+currentFormNo,formName,connectionObject));
				}
			}
			else if("display".equalsIgnoreCase(formName) || "retailerdisplay".equalsIgnoreCase(formName) || "stockistdisplay".equalsIgnoreCase(formName) || "ncwdisplay".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);

					//System.out.println("salePersCode : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getDNDDetails( dom2 , salePersCode, wrkDate, scCode, "", xtraParams, objContext,formName, connectionObject ));
				}
				//added by mrunalini sinkar on 30-nov-2018 for disp_type changes(start)
				else if(currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					//System.out.println("in detail display...........itm_default_add");
					String itmOption="",disType="";
					String salePersCode = "";
					String wrkDate = "";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					String dcrID = getDCRId(connectionObject,salePersCode, wrkDate);

					String dispSql="SELECT ITEM_OPTION,DISP_TYPE FROM DISPLAY_TYPE ORDER BY DISP_TYPE" ;
					//System.out.println(" dispSql is:["+dispSql+"]");
					PreparedStatement dispPstmt = connectionObject.prepareStatement(dispSql) ;
					ResultSet dispRs = dispPstmt.executeQuery();
					if(dispRs.next())
					{
						itmOption = checkNull(dispRs.getString("ITEM_OPTION"));
						disType = checkNull(dispRs.getString("DISP_TYPE"));

					}
					if (dispRs != null)
					{
						dispRs.close();
						dispRs = null;
					}
					if (dispPstmt != null)
					{
						dispPstmt.close();
						dispPstmt = null;
					}
					//System.out.println("itmoption:["+itmOption+"]disType["+disType+"]");
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					valueXmlString.append( "<Root>\r\n" );
					valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
					valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<disp_type><![CDATA[" ).append("").append("]]></disp_type>\r\n");
					if(itmOption.equalsIgnoreCase("1"))
					{
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else if(itmOption.equalsIgnoreCase("2"))
					{
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else if(itmOption.equalsIgnoreCase("3"))
					{
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else
					{
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					valueXmlString.append("</Detail"+objContext+">\r\n" );
					valueXmlString.append( "</Root>\r\n" );
				}
				//added by mrunalini sinkar on 30-nov-2018 for disp_type changes(start)
				else if(currentColumn.equalsIgnoreCase("disp_type"))
				{

					String dispType = checkNull(genericUtility.getColumnValue(currentColumn, dom1));

					//System.out.println("dispType:::::::["+dispType+"]");
					//String dispType = checkNull(genericUtility.getColumnValue(currentColumn, dom1,domId1));
					String itmOption ="";
					String dispSql="SELECT ITEM_OPTION FROM DISPLAY_TYPE WHERE DISP_TYPE=?";
					PreparedStatement dispPstmt = connectionObject.prepareStatement(dispSql) ;
					dispPstmt.setString(1, dispType);
					ResultSet dispRs = dispPstmt.executeQuery();
					if(dispRs.next())
					{
						itmOption = checkNull(dispRs.getString("ITEM_OPTION"));
					}
					if (dispRs != null)
					{
						dispRs.close();
						dispRs = null;
					}
					if (dispPstmt != null)
					{
						dispPstmt.close();
						dispPstmt = null;
					}
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					else
					{
						domID =domID;
					}
					if(itmOption.equalsIgnoreCase("1"))
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                                 //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");

					}
					else if(itmOption.equalsIgnoreCase("2"))
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                                 //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '1'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");

					}
					else if(itmOption.equalsIgnoreCase("3"))
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                                  //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");

					}
				}
				else if(currentColumn.equalsIgnoreCase("brand_code"))
				{
					String brandCode = checkNull(genericUtility.getColumnValue(currentColumn, dom1));
					String custCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					String dispEventDate = checkNull(genericUtility.getColumnValue("event_date", dom2, "1"));
					String brandDescr ="";
					String targetQty ="";
					String remarks ="";

					/*String brandSql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE = ?";
					pstmt = connectionObject.prepareStatement(brandSql) ;
					pstmt.setString(1, brandCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						brandDescr = checkNull(rs.getString("DESCRIPTION"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}*/

					String dispBrandSql= "SELECT BRAND.BRAND_CODE, BRAND.DESCRIPTION ,DET.TARGET_QTY, DET.REMARKS AS REMARKS FROM BRAND BRAND, SALES_PERS SP, DND_DEAL DEAL, DND_DEAL_DET DET "+
							"WHERE SP.ITEM_SER = BRAND.ITEM_SER AND SP.SALES_PERS = DEAL.SALES_PERS AND BRAND.BRAND_CODE = DET.BRAND_CODE "+
							"AND DEAL.TRAN_ID = DET.TRAN_ID AND DEAL.APRV_STAT = 'A' AND DEAL.STRG_CODE = ? AND SP.SALES_PERS = ? AND DEAL.EFF_FROM <= ? "+
							"AND DEAL.VALID_UPTO >= ? AND DET.BRAND_CODE = ? AND DEAL.STATUS_DATE = (SELECT MAX(STATUS_DATE) FROM DND_DEAL DND,DND_DEAL_DET DND_DET "+
							"WHERE DND.APRV_STAT = DEAL.APRV_STAT AND DND.STRG_CODE = DEAL.STRG_CODE AND DND.SALES_PERS = SP.SALES_PERS "+
							"AND DND.EFF_FROM <= ? AND DND.VALID_UPTO >= ? AND DND_DET.BRAND_CODE = DET.BRAND_CODE)";

					pstmt = connectionObject.prepareStatement(dispBrandSql) ;
					pstmt.setString(1, custCode);
					pstmt.setString(2, userId);
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setString(5, brandCode);
					pstmt.setTimestamp(6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setTimestamp(7, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						brandDescr = checkNull(rs.getString("DESCRIPTION"));
						targetQty = checkNull(rs.getString("TARGET_QTY"));
						remarks = checkNull(rs.getString("REMARKS"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<brand_descr><![CDATA[" ).append( brandDescr ).append( "]]></brand_descr>\r\n" );                                 //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
					valueXmlString.append( "<target_qty><![CDATA[" ).append( targetQty ).append( "]]></target_qty>\r\n" );
					valueXmlString.append( "<display_area><![CDATA[").append( remarks ).append("]]></display_area>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				}
				//added by mrunalini sinkar on 30-nov-2018 for disp_type changes(end)

			}
			else if("team".equalsIgnoreCase(formName) || "retailerteam".equalsIgnoreCase(formName) || "ncwteam".equalsIgnoreCase(formName) || "stockistteam".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				//System.out.println("in case 4....");
				if( currentColumn.equalsIgnoreCase("itm_default") )
				{

					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = checkNull(getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0));
					wrkDate = checkNull(getSelectedRowValue(dom2, parentFormNo, "event_date", 0));
					scCode = checkNull(getSelectedRowValue(dom2, parentFormNo, "strg_code", 0));
					String editScCode = checkNull(getSelectedYesRowValue(dom2, parentFormNo, "strg_code", 0));
					if(editScCode==null || editScCode.trim().length()==0)
					{
						editScCode="X";
					}
					//System.out.println("**********************In WsfaZuviusDsrWizEJB defaultDataDAR : salePersCode : ["+salePersCode+"] wrkDate:["+wrkDate+"] scCode:["+scCode+"]" );
					valueXmlString.append( getSalesTeamDetails( dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,formName, connectionObject,editScCode, objContext ));//commented by vinayakk
				}

			}
			//changes done by prachi [W22FBAS008] end
			else if("collection".equalsIgnoreCase(formName) || "collectionNcw".equalsIgnoreCase(formName) || "collectionRetailer".equalsIgnoreCase(formName) || "collectionStockist".equalsIgnoreCase(formName))
			{
				System.out.println("inside collection");
				valueXmlString.append(getCollectionDetail(dom2,currDate,currentFormNo,formName,connectionObject,currentColumn));
				
			}
			//changes done by prachi [W22FBAS008] start
			else if("brandsurvey".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);

					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);

					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getBrandSurveyDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName ));
				}

			}
			// added by rupali on 10/09/17 for new subform [end]
			// added by rupali on 12/09/18 for adding survey subform in DAR [start]
			else if("survey".equalsIgnoreCase(formName) || "retailersurvey".equalsIgnoreCase(formName) || "stockistsurvey".equalsIgnoreCase(formName) || "ncwsurvey".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);

					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);

					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					String surveyTemplate=getSelectedRowValue(dom2, parentFormNo, "survey_templ", 0);

					valueXmlString.append( getSurveyDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,surveyTemplate ));
				}

			}
			//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] start
			else if("coaching".equalsIgnoreCase(formName) || "retailercoaching".equalsIgnoreCase(formName) || "stockistcoaching".equalsIgnoreCase(formName) || "ncwcoaching".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] start
				String empDesign = getDesignName(userId, connectionObject);
				String grade = getGrade(userId, connectionObject);
				//ystem.out.println("empDesign ["+empDesign +"] grade ["+ grade +"]");
				//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] End
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					String salePersCode = "";
					String wrkDate = "";
					String vistedWith = "";
					String scCode = "",sprsCodeWrkWith ="";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					vistedWith = getSelectedRowValue(dom2, parentFormNo, "visited_with", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					sprsCodeWrkWith = getSelectedRowValue(dom2, parentFormNo, "sprs_code__ww", 0);
					String shDescr = getSelectedRowValue(dom2, parentFormNo, "cust_type", 0);
					String eventType = getSelectedRowValue(dom2, parentFormNo, "event_type", 0);
					String coachingTemplate = getSelectedRowValue(dom2, parentFormNo, "coaching_templ", 0);
					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getCoachingDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,coachingTemplate,eventType,shDescr,empDesign,grade,sprsCodeWrkWith,vistedWith ));
				}
			}
			//Added by Pooja S on 27-JULY-2020 [Coaching form realted implementation] End
			//Added by Bhagyashri T for Invoice subforms[start]
			else if("invoice".equalsIgnoreCase(formName) || "retailerinvoice".equalsIgnoreCase(formName) || "stockistinvoice".equalsIgnoreCase(formName) || "ncwinvoice".equalsIgnoreCase(formName))
			{
				DARCommonBean darCommonBean= new DARCommonBean();
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail of itm_default invoice...........");
					String salePersCode = "",wrkDate = "",scCode = "";
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String prcListTemplate=getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
					//System.out.println("Inside the subform invoice prcListTemplate::"+prcListTemplate);
					valueXmlString.append( getInvoiceItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,prcListTemplate));
				}
			}
			//Added by Bhagyashri T for Invoice subforms[end]
			// added by rupali on 12/09/18 for adding survey subform in DAR [end]
			else if("retailer".equalsIgnoreCase(formName))
			{
				//System.out.println("Inside itemchange for retailer Form");
				//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
				DARCommonBean darCommonBean= new DARCommonBean();
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
				//Added by kailash on 21-09-18[start]
				String selLocality="",selRouteId="";
				String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
				String salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom2, mainFormNo));
				selLocality = getLocFromDom(dom2, locFormNo , salesPers,connectionObject );
				selRouteId = getRouteIdFromDom(dom2, locFormNo , salesPers,connectionObject );// added by mrunalini sinkar for selected route id on 27-april-2019
				String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present
				//Added by kailash on 21-09-18[end]
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail retailer");
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, mainFormNo);
					String actCode = genericUtility.getColumnValue("activity_code", dom2, mainFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, mainFormNo);

					//System.out.println("sprsCode=["+sprsCode+"], actCode=["+actCode+"] trvDate=["+trvDate+"] ");
					String objectName = getObjNameFromDom( dom2, "objName" , currentFormNo);
					HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
					//System.out.println(" retailer subFormsMap  :::::::: "+subFormsMap);
					String custDetail="";
					//Commented and added by kailash on 21-09-18[start]
					//custDetail = getCustomerDetail( dom, dom2, objContext, userId, sprsCode, actCode, trvDate,"C" ,formName, connectionObject);
					custDetail = getCustomerDetail( dom, dom2, objContext, userId, sprsCode, actCode, trvDate,"C" ,formName,selLocality,selRouteId,connectionObject);
					//Commented and added by kailash on 21-09-18[end]
					//System.out.println("custDetail in retailer the form:::::::"+custDetail);
					valueXmlString.append( custDetail );
					String customers = getCustFromDom( genericUtility.parseString("<Root>"+custDetail+"</Root>"), objContext, sprsCode, "Y",connectionObject); //Chnaged by sachin satre on 09-nov-16
					//System.out.println("customers:::::::"+customers);
					//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					temp = customers.split(",");
					if(subFormsMap.containsKey("retailersampleitem"))
					{
						String sampleitemFormNo = subFormsMap.get("retailersampleitem");
						if ( preDomExists( dom2, sampleitemFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, sampleitemFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingItem = getSampleExistingItemsDetail( sprsCode, trvDate , customers,sampleitemFormNo,"retailersampleitem",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					if(subFormsMap.containsKey("retailersampleorder"))
					{
						String sampleorderFormNo = subFormsMap.get("retailersampleorder");
						if ( preDomExists( dom2, sampleorderFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, sampleorderFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingItem = getExistingItemsDetail( sprsCode, trvDate , customers,sampleorderFormNo,"retailersampleorder",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					if(subFormsMap.containsKey("retailerbrand"))
					{
						String brandFormNo = subFormsMap.get("retailerbrand");
						if ( preDomExists( dom2, brandFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, brandFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingBrand = getExistingPitchForDoctor( sprsCode, trvDate, customers, "", "", brandFormNo,"retailerbrand", connectionObject );
							//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingBrand + "]" );
							if( existingBrand !=null && existingBrand.length() > 0 )
							{
								valueXmlString.append( existingBrand);
							}
						}
					}
					if(subFormsMap.containsKey("retailerdisplay"))
					{
						String displayFormNo = subFormsMap.get("retailerdisplay");
						if ( preDomExists( dom2, displayFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, displayFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingDnd = getExistingDndDetailDisplay( sprsCode, trvDate, customers, connectionObject,displayFormNo,"retailerdisplay") ;
							//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingDnd + "]" );
							if( existingDnd !=null && existingDnd.length() > 0 )
							{
								valueXmlString.append( existingDnd);
							}
						}
					}
					if(subFormsMap.containsKey("retailerteam"))
					{
						String teamFormNo = subFormsMap.get("retailerteam");
						if ( preDomExists( dom2, teamFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, teamFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingTeam = getSalesExistingTeamDetail( sprsCode, trvDate , customers,teamFormNo,"retailerteam",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existiteam [ " + existingTeam + "]" );
							if( existingTeam !=null && existingTeam.length() > 0 )
							{
								valueXmlString.append( existingTeam);
							}
						}
					}
					// added by rupali on 12/09/18 for adding survey subform in DAR [start]
					if(subFormsMap.containsKey("retailersurvey"))
					{
						String surveyFormNo = subFormsMap.get("retailersurvey");
						if ( preDomExists( dom2, surveyFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, surveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingSurvey = getExistingSurveyDetail( userId, trvDate, customers, surveyFormNo,"retailersurvey", connectionObject );
							//System.out.println( "DefaultDataDAR :: existingSurvey [ " + existingSurvey + "]" );
							if( existingSurvey !=null && existingSurvey.length() > 0 )
							{
								valueXmlString.append( existingSurvey);
							}
						}
					}
					// added by rupali on 12/09/18 for adding survey subform in DAR [end]
					//Added by Bhagyashri T for Invoice form[22/08/2022][start]
					if(subFormsMap.containsKey("retailerinvoice"))
					{
						String invoiceFormNo = subFormsMap.get("retailerinvoice");
						if ( preDomExists( dom2, invoiceFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, invoiceFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
						//System.out.println( "DefaultDataDAR :: prevFormValues for invoice [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
							//String prcListTemp= getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
							String existingItem = getExistingInvoiceDetail( dom,sprsCode, trvDate , customers,invoiceFormNo,"retailerinvoice",dom2,"",connectionObject) ;
							//System.out.println( "DefaultDataDAR :: existingItem in invoice [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					//Added by Bhagyashri T for Invoice form[22/08/22][end]
					
					if(subFormsMap.containsKey("collectionRetailer"))
					{
						String collectionFormNo = subFormsMap.get("collectionRetailer");
						if ( preDomExists( dom2, collectionFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, collectionFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
						//System.out.println( "DefaultDataDAR :: prevFormValues for invoice [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingItem = getExistingCollectionDetail(sprsCode, trvDate, customers, connectionObject,collectionFormNo,"collectionRetailer","",true) ;
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
				}
				else if( currentColumn.equalsIgnoreCase( "call_outcome" ))
				{
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					String outCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1, ""+currentFormNo));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					String call = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom1, ""+currentFormNo));
					String contactPerson = checkNull(genericUtility.getColumnValue("contact_pers", dom1, ""+currentFormNo));//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
					String meetSumm = checkNull(genericUtility.getColumnValue("meet_summ", dom1, ""+currentFormNo));


					//System.out.println("outCome call_outcome: ["+outCome+"]domIDcall_outcome["+domID+"]call_outcomestrgCode["+strgCode);
					//System.out.println("outCome : ["+outCome+"]domID["+domID);
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );

					if(outCome.equalsIgnoreCase("0"))
					{
						valueXmlString.append( "<oth_participant protect='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<contact_pers protect='1'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						//valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
						if(outCome.equalsIgnoreCase("0"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					else
					{
						valueXmlString.append( "<meet_summ protect='0'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<oth_participant protect='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='0'><![CDATA[" ).append(contactPerson).append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						if(outCome.equalsIgnoreCase("4"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("3"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("2"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("1"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("5"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("6"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("7"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");

				}
				else if( currentColumn.equalsIgnoreCase( "itm_defaultedit" ))
				{
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					String outCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1, ""+currentFormNo));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					//System.out.println("outCome itm_defaultedit: ["+outCome+"]domIDitm_defaultedit["+domID+"]strgCode["+strgCode);
					String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom1, ""+currentFormNo));
					String contactPerson = checkNull(genericUtility.getColumnValue("contact_pers", dom1, ""+currentFormNo));//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
					String meetSumm = checkNull(genericUtility.getColumnValue("meet_summ", dom1, ""+currentFormNo));
					//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]
					String custName = checkNull(genericUtility.getColumnValue("cust_name", dom1, ""+currentFormNo));
					String visitTimeFrom = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, ""+currentFormNo));
					//Added by Hariom S for Table View ralated Changes -08-July-2021[End]
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<uniq_strg_code protect = '1' visible = '0'><![CDATA[" ).append(strgCode).append( "]]></uniq_strg_code>\r\n" );
					if(outCome.equalsIgnoreCase("0"))
					{

						valueXmlString.append( "<oth_participant protect='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<contact_pers protect='1'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						if(outCome.equalsIgnoreCase("0"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					else
					{
						//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]
						if ( "0000000000".equalsIgnoreCase( strgCode ) || "UR00000000".equalsIgnoreCase( strgCode ) || "US00000000".equalsIgnoreCase( strgCode ) || "UO00000000".equalsIgnoreCase( strgCode ) )
						{
							valueXmlString.append( "<cust_name visible='0'><![CDATA[" ).append(custName).append( "]]></cust_name>\r\n" );
							valueXmlString.append( "<visit_time_from visible='0'><![CDATA[" ).append(visitTimeFrom).append( "]]></visit_time_from>\r\n" );//Added by Hariom S for Table View ralated Changes -08-July-2021
						}
						//Added by Hariom S for Table View ralated Changes -08-July-2021 [End]
						valueXmlString.append( "<meet_summ protect='0'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<oth_participant protect='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='0'><![CDATA[" ).append(contactPerson).append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						if(outCome.equalsIgnoreCase("4"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("3"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("2"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("1"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("5"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("6"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("7"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				}
				// added by rupali on 05/01/18 for displaying preffered stockist field [start]
				else if( currentColumn.equalsIgnoreCase("stockist_code"))
				{
					//System.out.println("INSIDE stockist_code itemchange................");
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom1,objContext));
					//System.out.println("stockist code is  :"+stockistCode);
					String stockistName="";
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						sql = "SELECT CUST.CUST_NAME AS STRG_NAME FROM CUSTOMER CUST WHERE CUST_CODE = ? ";
					}
					else
					{
						sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME FROM STRG_CUSTOMER SC WHERE SC_CODE = ? ";
					}
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, stockistCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stockistName = checkNull(rs.getString("STRG_NAME"));
						//System.out.println("stockistName"+stockistName);

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<stockist_name><![CDATA[" ).append(checkNull(stockistName)).append( "]]></stockist_name>\r\n" );
					valueXmlString.append("<stockist_code><![CDATA[" ).append(checkNull(stockistCode)).append( "]]></stockist_code>\r\n" );
					valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				}
				// added by rupali on 05/01/18 for displaying preffered stockist field [end]
				// added by kailash on 10-09-18 for unlisted customer addition changes [start]
				else if( currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					//System.out.println("itm_default_add OF DAR retailer DAR form");
					int maxDomId= 0;
					String subFormDetails = "";
					String formNo = "";
					
					String isFortune  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
					String activityFormNo = checkNull(getFormNo(objName, "activity", connectionObject));
					String formMandatory = getSfaParmValue(userId,"IS_FORM_MANDATORY",connectionObject);
					String actCode = genericUtility.getColumnValue("activity_code", dom2, mainFormNo);//Added by kailash

					String sprsActCode="";
					if("Y".equalsIgnoreCase(isFortune))
					{
						sprsActCode = checkNull(getActCodeFromActivityFormDom(dom2, activityFormNo ,connectionObject ));
					}
					else
					{
						sprsActCode="'"+actCode+"'";
					}
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
					String teamFormName="";
					String chemSampleOrder=checkNull(getFormNo(objName, "retailersampleorder", connectionObject));
					String chemSamplItem=checkNull(getFormNo(objName, "retailersampleitem", connectionObject));
					String chemDisplay=checkNull(getFormNo(objName, "retailerdisplay", connectionObject));
					String chembrand=checkNull(getFormNo(objName, "retailerbrand", connectionObject));
					String chemPrescription=checkNull(getFormNo(objName, "retailerbrandsurvey", connectionObject));
					String chemSurvey=checkNull(getFormNo(objName, "retailersurvey", connectionObject));
					String chemCoaching=checkNull(getFormNo(objName, "retailercoaching", connectionObject));
					String retailerTeam=checkNull(getFormNo(objName, "retailerteam", connectionObject));
					teamFormName=retailerTeam;
					String visitedWithTeam = checkNull(genericUtility.getColumnValue("visited_with" , dom2 ));
					String visitedWithDisp=darCommonBean.getVisitedWithDisp(visitedWithTeam, connectionObject);
					//System.out.println("outside getVisitedWithDisp retailer::"+visitedWithDisp);
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int maxVal = Collections.max(domIdList);
					maxDomId = maxVal;
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, mainFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, mainFormNo);
					String evtType = genericUtility.getColumnValue("activity_type", dom2, mainFormNo);
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, locFormNo));
					String routeId = checkNull(genericUtility.getColumnValue("route_id", dom2, locFormNo));
					String descr = checkNull(genericUtility.getColumnValue("sprs_route_descr", dom2, locFormNo));

					//System.out.println("actCode["+actCode+"]");
					HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);

					Iterator itrt= subFormsMap.entrySet().iterator();
					while(itrt.hasNext())
					{
						Map.Entry en = (Map.Entry) itrt.next();
						formNo =   (String) en.getKey();
						String subformNa =  (String)en.getValue();
						if(subFormDetails == null || subFormDetails.trim().length() == 0)
						{
							subFormDetails = subformNa;
						}
						else
						{
							subFormDetails = subFormDetails + "," + subformNa;
						}
					}
					String templateId=checkNull(getTemplateIdForUnlisted(salesPers,"C",connectionObject));

				//	System.out.println( "retailer subFormDetails"+ subFormDetails  );
					String strgCode = generateCustomerCode(connectionObject);
					//System.out.println("retailer strgCode["+strgCode+"]");
					String dcrGroup = getDcrGroup("C",connectionObject); // adde by mrunalini sinkar on 29-jan-2019
					
					// added by shweta for removing hardcode cust_type value and get value form dcrGroup 28-05-21 [started]
					//String custTypeName= getCustTypeDcr(dcrGroup,salesPers,connectionObject);
					 
					 String	custTypeName="";
					 String custStrgType="";
					 String custTypeNamesql=" SELECT  G.FLD_VALUE AS CUST_TYPE,SCT.SH_DESCR AS SH_DESCR,SCT.TYPE AS STRG_TYPE FROM GENCODES G , STRG_CUST_TYPE SCT " +
								   " WHERE (INSTR(FLD_VALUE,'-')) > 0 AND SUBSTR(G.FLD_VALUE,INSTR(G.FLD_VALUE,'-')+1,LENGTH(G.FLD_VALUE))=SCT.SH_DESCR " +
								   " AND G.MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' AND sct.dcr_group='C'AND (ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE =?) " +
								   " IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL )) ";
						
						   pstmt = connectionObject.prepareStatement(custTypeNamesql);
							pstmt.setString(1, userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
						  	custTypeName = checkNull(rs.getString("CUST_TYPE"));
						  	custStrgType = checkNull(rs.getString("STRG_TYPE"));
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
				
				   // System.out.println("inside ncw form line no 17463 ::::::::::["+custTypeName+"]");
					// added by shweta for removing hardcode cust_type value and get value form dcrGroup 28-05-21 [ended]
				    
					//Added by kailash on 20-02-19[start]
					String []eventTime = new String [2];
					eventTime = getEventStartEndTime(connectionObject,userId,trvDate);
					//Added by kailash on 20-02-19[end]
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+maxDomId+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					if("Y".equalsIgnoreCase(isFortune))
					{
						valueXmlString.append("<event_type visible='1'><![CDATA[" ).append("").append( "]]></event_type>\r\n" );
					}
					else
					{
						valueXmlString.append("<event_type visible='0'><![CDATA[" ).append(checkNull(actCode)).append( "]]></event_type>\r\n" );
					}
					
					valueXmlString.append("<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
					valueXmlString.append("<member_present><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
					valueXmlString.append("<event_time_start protect = '0' visible = '1'><![CDATA[" ).append(eventTime[0]).append( "]]></event_time_start>\r\n" );
					valueXmlString.append("<event_time_end protect = '0' visible = '1'><![CDATA[" ).append(eventTime[1]).append( "]]></event_time_end>\r\n" );
					valueXmlString.append("<visit_time_from protect = '0' visible = '0'><![CDATA[" ).append(eventTime[0]).append( "]]></visit_time_from>\r\n" );

					if(!isMemberPresnt.equalsIgnoreCase("Y")) // added condition by mrunalini sinkar for memberpresent validation
					{
						valueXmlString.append("<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append("<locality_descr protect = '1' visible='1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
						valueXmlString.append("<stockist_code visible='1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						valueXmlString.append("<stockist_name visible='1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append("<strg_name protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_class_code visible='1'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<class_code_descr visible='1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<spl_code visible='1'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr visible='1'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<pin visible='1'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
						valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
						valueXmlString.append("<man_power visible='1'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
						valueXmlString.append("<image_id visible='1'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
						valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
						valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
						//added by prachi
						valueXmlString.append("<age visible='1'><![CDATA[" ).append("").append( "]]></age>\r\n" );
					}
					// added condition by mrunalini sinkar for memberpresent validation(start)
					else
					{
						valueXmlString.append("<locality_code protect = '0' visible='0'><![CDATA[" ).append(localityCode).append( "]]></locality_code>\r\n" );
						valueXmlString.append("<locality_descr protect = '1' visible='0'><![CDATA[" ).append(descr).append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<route_id protect = '0' visible='0'><![CDATA[" ).append(routeId).append( "]]></route_id>\r\n" );
						valueXmlString.append("<sku_value protect = '0' visible = '1'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
						valueXmlString.append("<stockist_code visible='0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						valueXmlString.append("<stockist_name visible='0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("NO OF CHEMISTS").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<pin visible='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
						valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
						valueXmlString.append("<man_power visible='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
						valueXmlString.append("<image_id visible='0'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
						valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
						valueXmlString.append("<address_as visible='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append("<addr1 visible='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 visible='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 visible='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						//added by prachi
						valueXmlString.append("<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						valueXmlString.append( "<gender visible='0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
						valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
						valueXmlString.append("<mobile_no visible='0'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<email_addr visible='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append("<strg_class_code visible='0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<class_code_descr visible='0'><![CDATA[" ).append("").append("]]></class_code_descr>\r\n" );
						valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
						valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
						valueXmlString.append("<spl_code visible='0'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr visible='0'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
					}
					// added condition by mrunalini sinkar for memberpresent validation(end

					valueXmlString.append("<cust_name protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></cust_name>\r\n");
					//Commented and changed by kailash on 20-02-19 for solving issue of time validation after change in property editor[start]
					//valueXmlString.append("<event_time_start protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></event_time_start>\r\n" );
					//valueXmlString.append("<event_time_end protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></event_time_end>\r\n" );
					//valueXmlString.append("<event_time_start protect = '1' visible = '0'><![CDATA[" ).append(eventTime[0]).append( "]]></event_time_start>\r\n" );
					//valueXmlString.append("<event_time_end protect = '1' visible = '0'><![CDATA[" ).append(eventTime[1]).append( "]]></event_time_end>\r\n" );
					//Commented and changed by kailash on 20-02-19 for solving issue of time validation after change in property editor[end]
					valueXmlString.append("<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[" ).append(sprsCode).append( "]]></sales_pers>\r\n" );
					valueXmlString.append("<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
					//valueXmlString.append("<stockist_code><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
					//valueXmlString.append("<stockist_name><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
					//valueXmlString.append("<call_outcome><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
					valueXmlString.append("<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
					valueXmlString.append("<strg_code protect = '0' visible = '1'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
					valueXmlString.append("<uniq_strg_code protect = '1' visible = '0'><![CDATA[" ).append(strgCode).append( "]]></uniq_strg_code>\r\n" );
					//	valueXmlString.append("<cust_type protect = '0' visible = '1'><![CDATA[" ).append("UNLISTED-RETAILER").append( "]]></cust_type>\r\n" );
				    valueXmlString.append("<cust_type protect = '0' visible = '1'><![CDATA[" ).append(custTypeName).append( "]]></cust_type>\r\n" ); //changes by shweta 28-05-21 for removing hardcode cust_type value
				//	valueXmlString.append("<strg_type protect = '1' visible = '0'><![CDATA[" ).append("C").append( "]]></strg_type>\r\n" );
					valueXmlString.append("<strg_type protect = '1' visible = '0'><![CDATA[" ).append(custStrgType).append( "]]></strg_type>\r\n" ); //changes by shweta 31-05-21 for removing hardcode cust_type value
					valueXmlString.append("<dcr_group protect = '1' visible = '0'><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );// adde by mrunalini sinkar on 29-jan-2019
					//valueXmlString.append("<strg_name protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
					valueXmlString.append("<current_form_subform><![CDATA[" ).append(subFormDetails).append( "]]></current_form_subform>\r\n" );
					valueXmlString.append("<sel_loc_code><![CDATA[" ).append(selLocality).append( "]]></sel_loc_code>\r\n" );
					//Added by kailash on 23-01-19 for chc related changes[start].
					//valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
					//valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
					//valueXmlString.append("<pin visible='1'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
					//valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
					//valueXmlString.append("<man_power visible='1'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
					//valueXmlString.append("<image_id visible='1'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
					//valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
					valueXmlString.append("<order_form_no><![CDATA[" ).append(chemSampleOrder).append( "]]></order_form_no>\r\n" );
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
					valueXmlString.append("<team_form_no><![CDATA[" ).append(retailerTeam).append( "]]></team_form_no>\r\n" );
					valueXmlString.append("<item_form_no><![CDATA[" ).append(chemSamplItem).append( "]]></item_form_no>\r\n" );
					valueXmlString.append("<brand_form_no><![CDATA[" ).append(chembrand).append( "]]></brand_form_no>\r\n" );
					valueXmlString.append("<display_form_no><![CDATA[" ).append(chemDisplay).append( "]]></display_form_no>\r\n" );
					valueXmlString.append("<prescription_form_no><![CDATA[" ).append(chemPrescription).append( "]]></prescription_form_no>\r\n" );
					valueXmlString.append("<survey_form_no><![CDATA[" ).append(chemSurvey).append( "]]></survey_form_no>\r\n" );
					valueXmlString.append("<coaching_form_no><![CDATA[" ).append(chemCoaching).append( "]]></coaching_form_no>\r\n" );
					valueXmlString.append("<visited_with_display><![CDATA[" ).append(visitedWithDisp).append( "]]></visited_with_display>\r\n" );
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
					//Added by kailash on 23-01-19 for chc related changes[end].

					// added by mrunalini sinkar for class code changes (start)
					String itemSer = checkNull(getItemSer(userId, connectionObject));
					int clsCount= getClassCodeCount(userId,itemSer,connectionObject);
					if(clsCount > 0)
					{
						valueXmlString.append("<cust_class_input>").append(itemSer).append("</cust_class_input>\r\n");

					}
					else
					{
						valueXmlString.append("<cust_class_input>").append("C").append("</cust_class_input>\r\n");

					}
					// added by mrunalini sinkar for class code changes (end)
					valueXmlString.append("<sel_route_id><![CDATA[" ).append(selRouteId).append( "]]></sel_route_id>\r\n" );// added by mrunalini sinakr for route id condtion
					valueXmlString.append("<survey_templ>").append(templateId).append("</survey_templ>\r\n");

					valueXmlString.append("<is_form_mandatory><![CDATA[" ).append(formMandatory).append( "]]></is_form_mandatory>\r\n" );
					valueXmlString.append("<sprs_act_code><![CDATA[" ).append(sprsActCode).append( "]]></sprs_act_code>\r\n" );
					valueXmlString.append("<is_fortune_activity><![CDATA[" ).append(isFortune).append( "]]></is_fortune_activity>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );

				}
				//added by mrunalini sinkar for cust_type itemchange on 30-01-2019(start)
				else if( currentColumn.equalsIgnoreCase("cust_type"))
				{
					String custType = checkNull(genericUtility.getColumnValue("cust_type", dom1,objContext));
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom1,objContext));

					String stockistName = checkNull(genericUtility.getColumnValue("stockist_name", dom1,objContext));

					if(custType.contains("-"))
					{
						String strgType="",dcrGroup="";
						sql = "SELECT  TYPE AS STRG_TYPE,DCR_GROUP FROM  STRG_CUST_TYPE " +
								"WHERE SUBSTR(?,INSTR(?,'-')+1,LENGTH(?))=SH_DESCR ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1,custType);
						pstmt.setString(2,custType);
						pstmt.setString(3,custType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							strgType = checkNull(rs.getString("STRG_TYPE"));
							dcrGroup = checkNull(rs.getString("DCR_GROUP"));

						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						String templateId=checkNull(getTemplateIdForUnlisted(salesPers,strgType,connectionObject));

						valueXmlString.append("<Detail"+currentFormNo+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append(strgType).append( "]]></strg_type>\r\n" );
						valueXmlString.append("<dcr_group protect = '0'><![CDATA[" ).append(dcrGroup).append( "]]></dcr_group>\r\n" );
						if("D".equalsIgnoreCase(strgType) || "C".equalsIgnoreCase(strgType))
						{
							valueXmlString.append("<stockist_code protect = '0' visible='1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible='1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );

						}
						else
						{
							valueXmlString.append("<stockist_code protect = '0' visible='0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible='0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );

						}

						// added by mrunalini sinkar for class code changes (start)
						String itemSer = checkNull(getItemSer(userId, connectionObject));
						int clsCount= getClassCodeCount(userId,itemSer,connectionObject);
						if(clsCount > 0)
						{
							valueXmlString.append("<cust_class_input>").append(itemSer).append("</cust_class_input>\r\n");

						}
						else
						{
							valueXmlString.append("<cust_class_input>").append(strgType).append("</cust_class_input>\r\n");

						}
						// added by mrunalini sinkar for class code changes (end)
						valueXmlString.append("<survey_templ>").append(templateId).append("</survey_templ>\r\n");

						valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );

					}

				}
				//added by mrunalini sinkar for cust_type itemchange on 30-01-2019(end)
				else if( currentColumn.equalsIgnoreCase("locality_code"))
				{

					String localityDes = "";
					String stockistCode = "";
					String stockistName = "",routeType="";
					String trvDate = checkNull(genericUtility.getColumnValue("event_date", dom2, mainFormNo));
					String custTYpe = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
					String callOutcome = checkNull(genericUtility.getColumnValue("call_outcome", dom2, objContext));

					//System.out.println("callOutcome islocality_code ["+callOutcome+"]");
					String []eventTime = new String [2];
					eventTime = getEventStartEndTime(connectionObject,userId,trvDate);
					//Added by bhagyashri To check proper DomId [28/02/22]
					String domID1 = checkNull(getDomID(dom1, ""+currentFormNo));
					System.out.println("Domid1 on locality itmchange Retailer ["+domID1+"]");
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom1,objContext));
					//System.out.println("localityCode9463["+localityCode+"]");
					//commented & and added by mrunalinin sinkar for beat descr changes on 27-04-2019(start)
					//sql = " SELECT DESCR, DEF_DISTRIBUTOR, SC.FIRST_NAME || ' ' || SC.LAST_NAME AS STRG_NAME FROM LOCALITY L LEFT OUTER JOIN STRG_CUSTOMER SC ON SC.SC_CODE = L.DEF_DISTRIBUTOR WHERE L.LOCALITY_CODE = ? ";
					String routeId = checkNull(genericUtility.getColumnValue("route_id", dom1,objContext));
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						sql = "SELECT (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) DESCR, L.DEF_DISTRIBUTOR, SR.ROUTE_TYPE, "+
							  "CUST.CUST_NAME AS STRG_NAME FROM LOCALITY L LEFT OUTER JOIN CUSTOMER CUST ON CUST.CUST_CODE = L.DEF_DISTRIBUTOR, SPRS_ROUTE SR "+
							  "WHERE L.LOCALITY_CODE = ? AND SR.LOCALITY_CODE = L.LOCALITY_CODE AND SR.SPRS_CODE = ? AND SR.ROUTE_ID = ? ";
					}
					else
					{
						sql="SELECT (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) DESCR, " +
								"  L.DEF_DISTRIBUTOR, SR.ROUTE_TYPE, " +
								" SC.FIRST_NAME || ' '|| SC.LAST_NAME AS STRG_NAME FROM LOCALITY L LEFT OUTER JOIN STRG_CUSTOMER SC ON SC.SC_CODE = L.DEF_DISTRIBUTOR,SPRS_ROUTE SR " +
								" WHERE L.LOCALITY_CODE = ?  AND SR.LOCALITY_CODE=L.LOCALITY_CODE AND SR.SPRS_CODE=? AND SR.ROUTE_ID=? ";
					}

					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,localityCode);
					pstmt.setString(2,salesPers);
					pstmt.setString(3,routeId);
					//commented & and added by mrunalinin sinkar for beat descr changes on 27-04-2019(start)

					rs = pstmt.executeQuery();
					if(rs.next())
					{
						localityDes = checkNull(rs.getString("DESCR"));
						stockistCode = checkNull(rs.getString("DEF_DISTRIBUTOR"));
						stockistName = checkNull(rs.getString("STRG_NAME"));
						routeType = checkNull(rs.getString("ROUTE_TYPE"));

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					if(custTYpe.contains("UNLISTED"))
					{
						if("M".equalsIgnoreCase(routeType))
						{
							valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID1+"' formName='"+formName+"'>\r\n" );
							valueXmlString.append("<locality_descr protect = '1' visible='1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
							valueXmlString.append("<stockist_code protect =  '0' visible='0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect =  '1' visible='0'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
							valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("NO OF CHEMISTS").append( "]]></strg_name>\r\n" );
							valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
							valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
							valueXmlString.append("<pin visible='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
							valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
							valueXmlString.append("<man_power visible='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
							valueXmlString.append("<image_id visible='0'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
							valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
							valueXmlString.append("<address_as visible='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
							valueXmlString.append("<addr1 visible='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
							valueXmlString.append("<addr2 visible='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
							valueXmlString.append("<addr3 visible='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
							valueXmlString.append("<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
							valueXmlString.append("<meet_summ visible='0'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
							valueXmlString.append("<route_type visible='0'><![CDATA[" ).append(checkNull(routeType)).append( "]]></route_type>\r\n" );

							if("Y".equalsIgnoreCase(isMemberPresnt))
							{
								valueXmlString.append("<sku_value protect = '0' visible = '1'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
								valueXmlString.append("<member_present visible = '1'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );

							}
							else
							{
								valueXmlString.append("<sku_value protect = '1' visible = '0'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
								valueXmlString.append("<member_present visible = '0'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );

							}


							valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
							valueXmlString.append( "<gender visible='0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append("<mobile_no visible='0'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
							valueXmlString.append("<email_addr visible='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
							//valueXmlString.append("<strg_class_code visible='0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
							//valueXmlString.append("<class_code_descr visible='0'><![CDATA[" ).append("").append("]]></class_code_descr>\r\n" );
							//valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
							//valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
							valueXmlString.append("<spl_code visible='0'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
							valueXmlString.append("<speciality_descr visible='0'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
							valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );
							valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
						}
						else
						{
							valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID1+"' formName='"+formName+"'>\r\n" );
							valueXmlString.append("<locality_descr protect = '1' visible='1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
							valueXmlString.append("<member_present visible = '1'><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
							valueXmlString.append("<sku_value protect = '0' visible = '1'><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
							valueXmlString.append("<route_type visible='0'><![CDATA[" ).append(checkNull(routeType)).append( "]]></route_type>\r\n" );


							if(!isMemberPresnt.equalsIgnoreCase("Y")) // added condition by mrunalini sinkar for memberpresent validation
							{
								valueXmlString.append("<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
								valueXmlString.append("<stockist_code visible='1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
								valueXmlString.append("<stockist_name visible='1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
								valueXmlString.append("<strg_name protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
								valueXmlString.append("<subclass_code visible='1'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
								valueXmlString.append("<subclass_descr visible='1'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
								valueXmlString.append("<pin visible='1'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
								valueXmlString.append("<promoter_name visible='1'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
								valueXmlString.append("<man_power visible='1'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
								valueXmlString.append("<image_id visible='1'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
								valueXmlString.append("<gst_no visible='1'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
								valueXmlString.append("<meet_summ visible='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );

								valueXmlString.append("<address_as visible='1'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
								valueXmlString.append("<addr1 visible='1'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
								valueXmlString.append("<addr2 visible='1'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
								valueXmlString.append("<addr3 visible='1'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
								valueXmlString.append("<age visible='1'><![CDATA[" ).append("").append( "]]></age>\r\n" );
								valueXmlString.append("<call_outcome visible='1'><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
								//added by prachi
								valueXmlString.append("<gender visible='1'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
								valueXmlString.append("<mobile_no visible='1'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
								valueXmlString.append("<email_addr visible='1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
								//valueXmlString.append("<strg_class_code visible='1'><![CDATA[" ).append("").append( " ]]></strg_class_code>\r\n" );
								//valueXmlString.append("<class_code_descr visible='1'><![CDATA[ " ).append("").append( "]]></class_code_descr>\r\n" );
								valueXmlString.append("<spl_code visible='1'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
								valueXmlString.append("<speciality_descr proetct='1' visible='1'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
								valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date
							}
							// added condition by mrunalini sinkar for memberpresent validation(start)
							else
							{

								valueXmlString.append("<stockist_code visible='0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
								valueXmlString.append("<stockist_name visible='0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
								valueXmlString.append("<strg_name protect = '0' visible = '0'><![CDATA[" ).append("NO OF CHEMISTS").append( "]]></strg_name>\r\n" );
								valueXmlString.append("<subclass_code visible='0'><![CDATA[" ).append("").append( "]]></subclass_code>\r\n" );
								valueXmlString.append("<subclass_descr visible='0'><![CDATA[" ).append("").append( "]]></subclass_descr>\r\n" );
								valueXmlString.append("<pin visible='0'><![CDATA[" ).append("").append( "]]></pin>\r\n" );
								valueXmlString.append("<promoter_name visible='0'><![CDATA[" ).append("").append( "]]></promoter_name>\r\n" );
								valueXmlString.append("<man_power visible='0'><![CDATA[" ).append("").append( "]]></man_power>\r\n" );
								valueXmlString.append("<image_id visible='0'><![CDATA[" ).append("").append( "]]></image_id>\r\n" );
								valueXmlString.append("<gst_no visible='0'><![CDATA[" ).append("").append( "]]></gst_no>\r\n" );
								valueXmlString.append("<address_as visible='0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
								valueXmlString.append("<addr1 visible='0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
								valueXmlString.append("<addr2 visible='0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
								valueXmlString.append("<addr3 visible='0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
								valueXmlString.append("<age visible='0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
								valueXmlString.append("<call_outcome visible='0'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
								valueXmlString.append( "<gender visible='0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );

								valueXmlString.append("<mobile_no visible='0'><![CDATA[" ).append( "").append( "]]></mobile_no>\r\n" );
								valueXmlString.append("<email_addr visible='0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
								//valueXmlString.append("<strg_class_code visible='0'><![CDATA[" ).append("").append( " ]]></strg_class_code>\r\n" );
								//valueXmlString.append("<class_code_descr visible='0'><![CDATA[" ).append("").append( " ]]></class_code_descr>\r\n" );
								valueXmlString.append("<spl_code visible='0'><![CDATA[" ).append( "" ).append( "]]></spl_code>\r\n" );
								valueXmlString.append("<speciality_descr visible='0'><![CDATA[" ).append( "" ).append( "]]></speciality_descr>\r\n" );
								valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append("").append( "]]></next_plan_date>\r\n" );//Added by mrunalini sinkar for next plan date



							}

							valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
						}




					}else
					{
						valueXmlString.append("<Detail"+currentFormNo+" domID='"+domID1+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<locality_descr protect = '1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<locality_code protect = '0'><![CDATA[" ).append(checkNull(localityCode)).append( "]]></locality_code>\r\n" );
						valueXmlString.append("<stockist_code protect = '0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
						valueXmlString.append("<stockist_name protect = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
					}

				}
				else if( currentColumn.equalsIgnoreCase("event_type"))
				{
					String activityType="";
					String activityDescr="";
					String sprsActCode = checkNull(genericUtility.getColumnValue("sprs_act_code", dom1, objContext));
					//Added by bhagyashri To check proper DomId [28/02/22]
					String domID1 = checkNull(getDomID(dom1, ""+currentFormNo));
					System.out.println("Domid1 on eventType itmchange Retailer ["+domID1+"]");
					if(sprsActCode!=null && sprsActCode.trim().length()>0)
					{			
						String eventType = checkNull(genericUtility.getColumnValue("event_type", dom1, objContext));
						//System.out.println("eventType is1:"+eventType);
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
						valueXmlString.append( darCommonBean.getEventType(domID1,sprsActCode, eventType , salesPers,""+currentFormNo,formName,connectionObject));
						//System.out.println("formName is1:"+formName);
						/*System.out.println("sprsActCode deafultdatawiz["+sprsActCode+"]eventType deafultdatawiz["+eventType+"]salesPers["+salesPers+"]");
						String actSql="SELECT FA.ACTIVITY_TYPE AS ACTIVITY_TYPE,FA.DESCR AS ACTIVITY_DESCR FROM FIELDACTIVITY FA WHERE FA.STATUS = 'Y' " + 
								"AND FA.ACTIVITY_TYPE NOT IN ('PR') AND FA.ACTIVITY_CODE NOT IN ('JW') AND FA.ACTIVITY_CODE IN ("+sprsActCode+") AND FA.ACTIVITY_TYPE='FW' AND FA.ACTIVITY_CODE=? " + 
								"AND (FA.ITEM_SER='ALL' OR (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?) IN(SELECT regexp_substr( ITEM_SER,'[^,]+', 1, LEVEL) FROM " + 
								"DUAL CONNECT BY regexp_substr(ITEM_SER, '[^,]+', 1, LEVEL) IS NOT NULL ) ) " + 
								"ORDER BY FA.DESCR,FA.ACTIVITY_CODE";

						pstmt = connectionObject.prepareStatement(actSql);
						pstmt.setString(1, eventType);
						pstmt.setString(2, salesPers);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							activityType=checkNull(rs.getString("ACTIVITY_TYPE"));
							activityDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<Detail"+currentFormNo+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<activity_type protect = '1'><![CDATA[" ).append(checkNull(activityType)).append( "]]></activity_type>\r\n" );
						valueXmlString.append("<event_type_descr protect = '1'><![CDATA[" ).append(checkNull(activityDescr)).append( "]]></event_type_descr>\r\n" );
						valueXmlString.append("<meeting_status><![CDATA[" ).append("").append( "]]></meeting_status>\r\n" );
						valueXmlString.append("<call_outcome protect = '1'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );*/
						//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]

					}

					
				}
				//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]
				else if( currentColumn.equalsIgnoreCase( "cust_name" ))
				{
					try 
					{
						System.out.println("In cust_name condition");
						
						String domID = checkNull(getDomID(dom1, ""+currentFormNo));
						String custName = checkNull(genericUtility.getColumnValue("cust_name", dom1, ""+currentFormNo));
						System.out.println("domID["+domID+"], custName["+custName+"]");
						
						if ( custName != null && custName.length() > 0 )
						{
							JSONObject custNameDetJson = new JSONObject(custName);
							System.out.println("custNameDetJson ["+ custNameDetJson +"]");
							String formatFieldName = custNameDetJson.getString("FORMAT_FIELD_NAME");
							System.out.println("formatFieldName ["+ formatFieldName +"]");
							String formatFieldVal = custNameDetJson.getString("FORMAT_FIELD_VAL");
							System.out.println("formatFieldVal ["+ formatFieldVal +"]");
							String custNameVal = custNameDetJson.getString("FIELD_VAL");
							System.out.println("custNameVal ["+ custNameVal +"]");
							String fieldFormat = custNameDetJson.getString("FIELD_FORMAT");
							System.out.println("fieldFormat ["+ fieldFormat +"]");
							
							valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n");
							/*valueXmlString.append("<cust_name format='").append( fieldFormat ).append("'><![CDATA[" ).append(checkNull(custNameVal)).append("]]></cust_name>\r\n");*/
							valueXmlString.append("<").append( formatFieldName ).append("><![CDATA[").append(checkNull(formatFieldVal)).append("]]></").append( formatFieldName ).append(">\r\n");
							
							valueXmlString.append("</Detail"+currentFormNo+">\r\n");
						}
					}
					catch (Exception e) 
					{
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				else if( currentColumn.equalsIgnoreCase( "member_present" ))
				{
					
					String domID = checkNull(getDomID(dom1, ""+currentFormNo));
					String custName = checkNull(genericUtility.getColumnValue("cust_name", dom1, ""+currentFormNo));
					String memberPresent = checkNull(genericUtility.getColumnValue("member_present", dom1, ""+currentFormNo));
					try 
					{
						if ( custName != null && custName.length() > 0 )
						{
							
							valueXmlString.append( darCommonBean.getCustNameOnMeberPresent(domID,custName, memberPresent ,""+currentFormNo,formName,connectionObject));						
						}
					}
					catch (Exception e) 
					{
						e.printStackTrace();
					}
				}
				//Added by Hariom S for Table View ralated Changes -08-July-2021 [End]
				/*else if( currentColumn.equalsIgnoreCase("strg_class_code"))
				{
					String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1,objContext));
					String strgTyp = checkNull(genericUtility.getColumnValue("strg_type", dom1,objContext));
					String classCodeDescr = getClassCodeDesc( classCode, strgTyp,userId, connectionObject );

					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<class_code_descr protect = '1'><![CDATA[" ).append(checkNull(classCodeDescr)).append( "]]></class_code_descr>\r\n" );
					valueXmlString.append("</Detail"+objContext+">\r\n" );
				}*/
				//Added by kailash on 29-01-19 for chc related changes[start]
				/*else if( currentColumn.equalsIgnoreCase("subclass_code"))
				{
					String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom1,objContext));
					String strgTyp = checkNull(genericUtility.getColumnValue("strg_type", dom1,objContext));
					String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code", dom1,objContext));
					String subClassDescr = getSubclassCodeDesc( classCode, strgTyp,subClassCode, connectionObject );
					System.out.println("classCode["+classCode+"]strgTyp["+strgTyp+"]subClassCode["+subClassCode+"]subClassDescr["+subClassDescr+"]");
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<subclass_descr protect = '1'><![CDATA[" ).append(checkNull(subClassDescr)).append( "]]></subclass_descr>\r\n" );
					valueXmlString.append("</Detail"+objContext+">\r\n" );
				}*/
				//Added by kailash on 29-01-19 for chc related changes[end]
				/*else if( currentColumn.equalsIgnoreCase("spl_code"))
				{
					String unlistedStrgType = checkNull(genericUtility.getColumnValue("cust_type", dom1,objContext));
					String specialityCode = checkNull(genericUtility.getColumnValue("spl_code", dom1,objContext));
					String specialityDescr="";
					sql = "SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, specialityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						specialityDescr = checkNull(rs.getString("DESCR"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<Detail"+currentFormNo+" domID='1' formName='"+formName+"'>\r\n" );
					if("UNLISTED-RETAILER".equalsIgnoreCase(unlistedStrgType))
					{
						valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append(checkNull(specialityDescr)).append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<spl_code protect = '0'><![CDATA[" ).append(checkNull(specialityCode)).append( "]]></spl_code>\r\n" );
					}
					else
					{
						valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );

					}
					valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );

				}*/
				// added by kailash on 10-09-18 for unlisted customer addition changes [end]
				else if( currentColumn.equalsIgnoreCase("visit_time_from"))
				{
					String visitTimeStart = checkNull(genericUtility.getColumnValue("visit_time_from", dom1,objContext));

					String domID=checkNull(getDomID(dom1, ""+currentFormNo));// Added By Hariom S for proper dom id data set -14-Sep-2021
					
					valueXmlString.append("<Detail"+objContext+" domID='"+domID+"' formName='"+formName+"'>\r\n" );// Added By Hariom S for proper dom id data set -14-Sep-2021																				
					valueXmlString.append("<event_time_start><![CDATA[" ).append(visitTimeStart).append( "]]></event_time_start>\r\n" );
					//valueXmlString.append("<event_time_end><![CDATA[" ).append(visitTimeStart).append( "]]></event_time_end>\r\n" );
					valueXmlString.append("</Detail"+objContext+">\r\n" );
				}
				else if( currentColumn.equalsIgnoreCase("event_time_start"))
				{
					String eventTimeStart = checkNull(genericUtility.getColumnValue("event_time_start", dom1,objContext));

					String domID=checkNull(getDomID(dom1, ""+currentFormNo));// Added By Hariom S for proper dom id data set -14-Sep-2021
					
					valueXmlString.append("<Detail"+objContext+" domID='"+domID+"' formName='"+formName+"'>\r\n" );// Added By Hariom S for proper dom id data set -14-Sep-2021																				
					valueXmlString.append("<visit_time_from><![CDATA[" ).append(eventTimeStart).append( "]]></visit_time_from>\r\n" );
					valueXmlString.append("<event_time_end><![CDATA[" ).append(eventTimeStart).append( "]]></event_time_end>\r\n" );

					valueXmlString.append("</Detail"+objContext+">\r\n" );
				}
				else if( currentColumn.equalsIgnoreCase("strg_code"))
				{
					String strgCodeDom = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
					String locCodeDom = checkNull(genericUtility.getColumnValue("locality_code", dom1, objContext));
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(locCodeDom!=null)
					{
						valueXmlString.append( darCommonBean.getStrgCodedata(domID, strgCodeDom, locCodeDom ,""+currentFormNo,formName,connectionObject));
					}
				}
				//Added by bhagyashri T For Add contact_pers itemchange[25/MAR/22][W21KFOR011][START]
				else if( currentColumn.equalsIgnoreCase("contact_pers"))
				{
					String euinNo = checkNull(genericUtility.getColumnValue("contact_pers", dom1, objContext));
					String strgCodeC = checkNull(genericUtility.getColumnValue("strg_code", dom1, objContext));
					String domID1 = checkNull(getDomID(dom1, ""+currentFormNo));
					if(strgCodeC!=null && strgCodeC.trim().length()>0)
					{			
						valueXmlString.append( darCommonBean.getContactPersName(domID1,strgCodeC, euinNo ,""+currentFormNo,formName,connectionObject));
						
					}					
				}
				else if( currentColumn.equalsIgnoreCase("meeting_status"))
				{
					String eventType = checkNull(getColumnValue("event_type", dom1, objContext));
					String meetingStatus = checkNull(genericUtility.getColumnValue("meeting_status", dom1, objContext));
					String domID = checkNull(getDomID(dom1, ""+currentFormNo));
					valueXmlString.append( darCommonBean.getCallOutcome(domID,eventType, meetingStatus ,""+currentFormNo,formName,connectionObject));
				}
				//Added by bhagyashri T For Add contact_pers itemchange[25/MAR/22][W21KFOR011][END]
			}
			// Added by mrunalini sinkar on 8-may-2017 for stockist form (start)
			else if("stockist".equalsIgnoreCase(formName))
			{
				//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004]
				DARCommonBean darCommonBean= new DARCommonBean();
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
				//Added by kailash on 21-09-18[start]
				String selLocality="",selRouteId="";
				String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
				String salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom2, mainFormNo));
				selLocality = getLocFromDom(dom2, locFormNo , salesPers,connectionObject );
				//Added by kailash on 21-09-18[end]
				selRouteId = getRouteIdFromDom(dom2, locFormNo , salesPers,connectionObject );// added by mrunalini sinkar for selected route id on 27-april-2019
				String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));//Added by mrunalini sinkar for showing member present
				String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ");
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, mainFormNo);
					String actCode = genericUtility.getColumnValue("activity_code", dom2, mainFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, mainFormNo);

					//System.out.println("sprsCode=["+sprsCode+"], actCode=["+actCode+"] trvDate=["+trvDate+"] ");

					String custDetail="";

					//Commented and added by kailash on 21-09-18[start]
					//custDetail = getCustomerDetail( dom, dom2, objContext, userId, sprsCode, actCode, trvDate,"S" ,formName,connectionObject);
					custDetail = getCustomerDetail( dom, dom2, objContext, userId, sprsCode, actCode, trvDate,"S" ,formName,selLocality,selRouteId,connectionObject);
					//Commented and added by kailash on 21-09-18[end]

					//System.out.println("custDetail in 3th form:::::::"+custDetail);
					valueXmlString.append( custDetail );
					String customers = getCustFromDom( genericUtility.parseString("<Root>"+custDetail+"</Root>"), objContext, sprsCode, "Y",connectionObject);
					//System.out.println("customers:::::::"+customers);
					temp = customers.split(",");

					HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
					//System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
					if(subFormsMap.containsKey("stockistsampleitem"))
					{
						String sampleitemFormNo = subFormsMap.get("stockistsampleitem");
						if ( preDomExists( dom2, sampleitemFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, sampleitemFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingItem = getSampleExistingItemsDetail( sprsCode, trvDate , customers,sampleitemFormNo,"stockistsampleitem",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					if(subFormsMap.containsKey("stockistsampleorder"))
					{
						String sampleorderFormNo = subFormsMap.get("stockistsampleorder");
						if ( preDomExists( dom2, sampleorderFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, sampleorderFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingItem = getExistingItemsDetail( sprsCode, trvDate , customers,sampleorderFormNo,"stockistsampleorder",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					if(subFormsMap.containsKey("stockistbrand"))
					{
						String brandFormNo = subFormsMap.get("stockistbrand");
						if ( preDomExists( dom2, brandFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, brandFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingBrand = getExistingPitchForDoctor( sprsCode, trvDate, customers, "", "", brandFormNo,"stockistbrand", connectionObject );
							//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingBrand + "]" );
							if( existingBrand !=null && existingBrand.length() > 0 )
							{
								valueXmlString.append( existingBrand);
							}
						}
					}
					if(subFormsMap.containsKey("stockistdisplay"))
					{
						String displayFormNo = subFormsMap.get("stockistdisplay");
						if ( preDomExists( dom2, displayFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, displayFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingDnd = getExistingDndDetailDisplay( sprsCode, trvDate, customers, connectionObject,displayFormNo,"stockistdisplay") ;
							//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingDnd + "]" );
							if( existingDnd !=null && existingDnd.length() > 0 )
							{
								valueXmlString.append( existingDnd);
							}
						}
					}
					if(subFormsMap.containsKey("stockistteam"))
					{
						String teamFormNo = subFormsMap.get("stockistteam");
						if ( preDomExists( dom2, teamFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, teamFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingTeam = getSalesExistingTeamDetail( sprsCode, trvDate , customers,teamFormNo,"stockistteam",connectionObject ) ;
							//System.out.println( "DefaultDataDAR :: existiteam [ " + existingTeam + "]" );
							if( existingTeam !=null && existingTeam.length() > 0 )
							{
								valueXmlString.append( existingTeam);
							}
						}
					}
					// added by rupali on 12/09/18 for adding survey subform in DAR [start]
					if(subFormsMap.containsKey("stockistsurvey"))
					{
						String surveyFormNo = subFormsMap.get("stockistsurvey");
						if ( preDomExists( dom2, surveyFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, surveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
							//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingSurvey = getExistingSurveyDetail( userId, trvDate, customers, surveyFormNo,"stockistsurvey", connectionObject );
							//System.out.println( "DefaultDataDAR :: existingSurvey [ " + existingSurvey + "]" );
							if( existingSurvey !=null && existingSurvey.length() > 0 )
							{
								valueXmlString.append( existingSurvey);
							}
						}
					}
					// added by rupali on 12/09/18 for adding survey subform in DAR [end]
					//Added by Bhagyashri T for Invoice form[22/08/2022][start]
					if(subFormsMap.containsKey("stockistinvoice"))
					{
						String invoiceFormNo = subFormsMap.get("stockistinvoice");
						if ( preDomExists( dom2, invoiceFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, invoiceFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
						//System.out.println( "DefaultDataDAR :: prevFormValues for invoice [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
							//String prcListTemp= getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
							String existingItem = getExistingInvoiceDetail( dom,sprsCode, trvDate , customers,invoiceFormNo,"stockistinvoice",dom2,"",connectionObject) ;
							//System.out.println( "DefaultDataDAR :: existingItem in invoice [ " + existingItem + "]" );
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
					//Added by Bhagyashri T for Invoice form[22/08/22][end]
					
					if(subFormsMap.containsKey("collectionStockist"))
					{
						String collectionFormNo = subFormsMap.get("collectionStockist");
						if ( preDomExists( dom2, collectionFormNo ) )
						{
							String prevFormValues =  getPrevFormVal( dom2, collectionFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
						//System.out.println( "DefaultDataDAR :: prevFormValues for invoice [ " + prevFormValues + "]" );
							valueXmlString.append( prevFormValues );
						}
						else if( !"".equalsIgnoreCase( customers ) )
						{
							String existingItem = getExistingCollectionDetail(sprsCode, trvDate, customers, connectionObject,collectionFormNo,"collectionStockist","",true) ;
							if( existingItem !=null && existingItem.length() > 0 )
							{
								valueXmlString.append( existingItem);
							}
						}
					}
				}
				else if( currentColumn.equalsIgnoreCase( "call_outcome" ))
				{
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					String outCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1, ""+currentFormNo));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					String call = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom1, ""+currentFormNo));
					String contactPerson = checkNull(genericUtility.getColumnValue("contact_pers", dom1, ""+currentFormNo));//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
					String meetSumm = checkNull(genericUtility.getColumnValue("meet_summ", dom1, ""+currentFormNo));


					//System.out.println("outCome call_outcome: ["+outCome+"]domIDcall_outcome["+domID+"]call_outcomestrgCode["+strgCode);
					//System.out.println("outCome : ["+outCome+"]domID["+domID);
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );

					if(outCome.equalsIgnoreCase("0"))
					{
						valueXmlString.append( "<oth_participant protect='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<contact_pers protect='1'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						//valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
						if(outCome.equalsIgnoreCase("0"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					else
					{
						valueXmlString.append( "<meet_summ protect='0'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<oth_participant protect='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='0'><![CDATA[" ).append(contactPerson).append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						if(outCome.equalsIgnoreCase("4"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("3"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("2"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("1"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("5"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("6"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("7"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");

				}
				else if( currentColumn.equalsIgnoreCase( "itm_defaultedit" ))
				{
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					String outCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1, ""+currentFormNo));
					String strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1, ""+currentFormNo));
					//System.out.println("outCome itm_defaultedit: ["+outCome+"]domIDitm_defaultedit["+domID+"]strgCode["+strgCode);
					String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom1, ""+currentFormNo));
					String contactPerson = checkNull(genericUtility.getColumnValue("contact_pers", dom1, ""+currentFormNo));//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
					String meetSumm = checkNull(genericUtility.getColumnValue("meet_summ", dom1, ""+currentFormNo));
					//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]
					String custName = checkNull(genericUtility.getColumnValue("cust_name", dom1, ""+currentFormNo));
					String visitTimeFrom = checkNull(genericUtility.getColumnValue("visit_time_from", dom1, ""+currentFormNo));
					//Added by Hariom S for Table View ralated Changes -08-July-2021 [End]
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<uniq_strg_code protect = '1' visible = '0'><![CDATA[" ).append(strgCode).append( "]]></uniq_strg_code>\r\n" );
					if(outCome.equalsIgnoreCase("0"))
					{

						valueXmlString.append( "<oth_participant protect='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<contact_pers protect='1'><![CDATA[" ).append("").append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						if(outCome.equalsIgnoreCase("0"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					else
					{
						//Added by Hariom S for Table View ralated Changes -08-July-2021 [Start]//bhagyashriSS
						if ( "0000000000".equalsIgnoreCase( strgCode ) || "UR00000000".equalsIgnoreCase( strgCode ) || "US00000000".equalsIgnoreCase( strgCode ) || "UO00000000".equalsIgnoreCase( strgCode ) )
						{
							valueXmlString.append( "<cust_name visible='0'><![CDATA[" ).append(custName).append( "]]></cust_name>\r\n" );
							valueXmlString.append( "<visit_time_from visible='0'><![CDATA[" ).append(visitTimeFrom).append( "]]></visit_time_from>\r\n" );
						}
						//Added by Hariom S for Table View ralated Changes -08-July-2021 [End]
						valueXmlString.append( "<meet_summ protect='0'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<oth_participant protect='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<contact_pers protect='0'><![CDATA[" ).append(contactPerson).append( "]]></contact_pers>\r\n" );//Added by bhagyashri T For Change OTH_PARTICIPANT TO CONTACT_PERS[22/02/22][START]
						if(outCome.equalsIgnoreCase("4"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("3"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("2"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("1"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("5"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("6"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("7"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");

				}
				// added by rupali on 05/01/18 for displaying preffered stockist field [start]
				else if( currentColumn.equalsIgnoreCase("stockist_code"))
				{
					//System.out.println("INSIDE stockist_code itemchange................");
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom1,objContext));
					//System.out.println("stockist code is  :"+stockistCode);
					String stockistName="";
					if (stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
					{
						sql = "SELECT CUST.CUST_NAME AS STRG_NAME FROM CUSTOMER CUST WHERE CUST_CODE = ? ";
					}
					else
					{
						sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME FROM STRG_CUSTOMER SC WHERE SC_CODE = ? ";
					}
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, stockistCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stockistName = checkNull(rs.getString("STRG_NAME"));
						//System.out.println("stockistName"+stockistName);

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<stockist_name><![CDATA[" ).append(checkNull(stockistName)).append( "]]></stockist_name>\r\n" );
					valueXmlString.append("<stockist_code><![CDATA[" ).append(checkNull(stockistCode)).append( "]]></stockist_code>\r\n" );
					valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				}
				// added by rupali on 05/01/18 for displaying preffered stockist field [end]
				// added by kailash on 10-09-18 for unlisted customer addition changes [start]
				else if( currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					//System.out.println("itm_default_add OF DAR Stockist DAR form");
					int maxDomId= 0;
					String subFormDetails = "";
					String formNo = "";
					String isFortune  = checkNull(getSfaParmValue(userId,"IS_FORTUNE_ACTIVITY",connectionObject));
					String activityFormNo = checkNull(getFormNo(objName, "activity", connectionObject));
					String formMandatory = getSfaParmValue(userId,"IS_FORM_MANDATORY",connectionObject);
					String actCode = genericUtility.getColumnValue("activity_code", dom2, mainFormNo);//Added by kailash

					String sprsActCode="";
					if("Y".equalsIgnoreCase(isFortune))
					{
						sprsActCode = checkNull(getActCodeFromActivityFormDom(dom2, activityFormNo ,connectionObject ));
					}
					else
					{
						sprsActCode="'"+actCode+"'";
					}
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][START]
					String teamFormName="";
					String stockSampleOrder=checkNull(getFormNo(objName, "stockistsampleorder", connectionObject));
					String stockSamplItem=checkNull(getFormNo(objName, "stockistsampleitem", connectionObject));
					String stockDisplay=checkNull(getFormNo(objName, "stockistdisplay", connectionObject));
					String stockbrand=checkNull(getFormNo(objName, "stockistbrand", connectionObject));
					String stockPrescription=checkNull(getFormNo(objName, "stockistbrandsurvey", connectionObject));
					String stockSurvey=checkNull(getFormNo(objName, "stockistsurvey", connectionObject));
					String stockCoaching=checkNull(getFormNo(objName, "stockistcoaching", connectionObject));
					String stockistTeam=checkNull(getFormNo(objName, "stockistteam", connectionObject));
					teamFormName=stockistTeam;
					String visitedWithTeam = checkNull(genericUtility.getColumnValue("visited_with" , dom2 ));
					String visitedWithDisp=darCommonBean.getVisitedWithDisp(visitedWithTeam, connectionObject);
					//System.out.println("outside getVisitedWithDisp stockist::"+visitedWithDisp);
					//Added by bhagyashri T For Add unlist cust subform issue[15/11/21][W21HPRO004][END]
					String templateId=checkNull(getTemplateIdForUnlisted(salesPers,"S",connectionObject));
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int maxVal = Collections.max(domIdList);
					maxDomId = maxVal;
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, mainFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, mainFormNo);
					String evtType = genericUtility.getColumnValue("activity_type", dom2, mainFormNo);
					HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, locFormNo));
					String descr = checkNull(genericUtility.getColumnValue("sprs_route_descr", dom2, locFormNo));

					String routeId = checkNull(genericUtility.getColumnValue("route_id", dom2, locFormNo));

					Iterator itrt= subFormsMap.entrySet().iterator();
					while(itrt.hasNext())
					{
						Map.Entry en = (Map.Entry) itrt.next();
						formNo =   (String) en.getKey();
						String subformNa =  (String)en.getValue();
						if(subFormDetails == null || subFormDetails.trim().length() == 0)
						{
							subFormDetails = subformNa;
						}
						else
						{
							subFormDetails = subFormDetails + "," + subformNa;
						}
					}

					String strgCode = generateCustomerCode(connectionObject);
					String dcrGroup = getDcrGroup("S",connectionObject); // adde by mrunalini sinkar on 29-jan-2019
					
					// added by shweta for removing hardcode cust_type value and get value form dcrGroup 28-05-21 [started]
					   //String custTypeName= getCustTypeDcr(dcrGroup,salesPers,connectionObject);
					
					String	custTypeName="";
					String  custStrgType="";
					String custTypeNamesql=" SELECT  G.FLD_VALUE AS CUST_TYPE,SCT.SH_DESCR AS SH_DESCR,SCT.TYPE AS STRG_TYPE FROM GENCODES G , STRG_CUST_TYPE SCT " +
							   " WHERE (INSTR(FLD_VALUE,'-')) > 0 AND SUBSTR(G.FLD_VALUE,INSTR(G.FLD_VALUE,'-')+1,LENGTH(G.FLD_VALUE))=SCT.SH_DESCR " +
							   " AND G.MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ' AND sct.dcr_group='S' AND (ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE =?) " +
							   " IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL )) ";
					
					   pstmt = connectionObject.prepareStatement(custTypeNamesql);
						pstmt.setString(1, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
					  	custTypeName = checkNull(rs.getString("CUST_TYPE"));
					  	custStrgType = checkNull(rs.getString("STRG_TYPE"));
					  	
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
				
				   // System.out.println("inside ncw form line no 17463 ::::::::::["+custTypeName+"]");
					// added by shweta for removing hardcode cust_type value and get value form dcrGroup 28-05-21 [ended]
				    
					//Added by kailash on 20-02-19[start]
					String []eventTime = new String [2];
					eventTime = getEventStartEndTime(connectionObject,userId,trvDate);
					//Added by kailash on 20-02-19[end]
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+maxDomId+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
					if("Y".equalsIgnoreCase(isFortune))
					{
						valueXmlString.append("<event_type visible='1'><![CDATA[" ).append("").append( "]]></event_type>\r\n" );
					}
					else
					{
						valueXmlString.append("<event_type visible='0'><![CDATA[" ).append(checkNull(actCode)).append( "]]></event_type>\r\n" );
					}
					
					
					//valueXmlString.append("<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
					valueXmlString.append("<member_present><![CDATA[" ).append("0").append( "]]></member_present>\r\n" );
					valueXmlString.append("<event_time_start protect = '0' visible = '1'><![CDATA[" ).append(eventTime[0]).append( "]]></event_time_start>\r\n" );
					valueXmlString.append("<event_time_end protect = '0' visible = '1'><![CDATA[" ).append(eventTime[1]).append( "]]></event_time_end>\r\n" );
					va