/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.ReCalculateTax;
import ibase.webitm.utility.TaxCalculation;
import ibase.webitm.utility.XMLBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class E12TaxCalculation {
    private Document detailDom;
    private Node taxNode;
    private Node currRecordNode;
    private E12GenericUtility utility = new E12GenericUtility();

    public void setDetailDom(String xmlString, String objContext) {
        try {
            BaseLogger.log("3", null, null, xmlString + "]");
            this.detailDom = this.utility.parseString(xmlString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String reCalculateTax(String qtyFldStr, String rateFldStr, String objContext, String detailDomId, UserInfoBean userInfo, String objName) {
        String data = "";
        try {
            ReCalculateTax reCalcTax = new ReCalculateTax();
            if (this.taxNode == null) {
                this.taxNode = this.getCurrTaxNode(objContext, detailDomId);
            }
            reCalcTax.setTaxTranDom(this.currRecordNode, this.taxNode, objContext, detailDomId);
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            String refSer = "";
            String tranDateCol = "";
            if (objDetailMap != null) {
                refSer = objDetailMap.get("REF_SER") != null ? (String)objDetailMap.get("REF_SER") : null;
                tranDateCol = objDetailMap.get("TRAN_DATE_COL") != null ? (String)objDetailMap.get("TRAN_DATE_COL") : "";
            }
            Node currNode = this.searchNode(this.detailDom, "1", "1");
            String taxDate = this.getValueOfField(currNode, tranDateCol);
            data = reCalcTax.reCalculate(qtyFldStr, rateFldStr, userInfo, this.getValueOfField(this.searchNode(this.detailDom, "1", "1"), "curr_code"), refSer, taxDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public String calculateTax(String objName, String objContext, String detailDomId, UserInfoBean userInfo) throws ITMException {
        StringBuffer data = new StringBuffer();
        data = new StringBuffer("<Root>");
        try {
            String refSer = "";
            String headerPKFieldValues = "";
            String rateCol = "";
            String qtyCol = "";
            String tranDateCol = "";
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext initialContext = new InitialContext(appConnect.getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            if (objDetailMap != null) {
                refSer = objDetailMap.get("REF_SER") != null ? (String)objDetailMap.get("REF_SER") : null;
                rateCol = objDetailMap.get("RATE_COL") != null ? (String)objDetailMap.get("RATE_COL") : null;
                qtyCol = objDetailMap.get("QTY_COL") != null ? (String)objDetailMap.get("QTY_COL") : null;
                tranDateCol = objDetailMap.get("TRAN_DATE_COL") != null ? (String)objDetailMap.get("TRAN_DATE_COL") : "";
            }
            Node currNode = this.searchNode(this.detailDom, "1", "1");
            String taxDate = this.getValueOfField(currNode, tranDateCol);
            BaseLogger.log("3", userInfo, null, "taxDate :[" + taxDate + "]refSer[" + refSer + "]rateCol[" + rateCol + "]qtyCol[" + qtyCol + "]tranDateCol[" + tranDateCol + "]");
            NodeList detailNodeList = this.detailDom.getElementsByTagName("Detail" + objContext);
            if (detailNodeList != null) {
                Document chgDataDom;
                BaseLogger.log("3", userInfo, null, "[E12TaxCalculation]CALCULATING TAX.................. for objContext[" + objContext + "]detailDomId[" + detailDomId + "]");
                this.appendOrReplaceTaxesNode(objContext, detailDomId);
                headerPKFieldValues = this.currRecordNode.getAttributes().getNamedItem("dbID").getNodeValue();
                BaseLogger.log("3", userInfo, null, "headerPKFieldValues[" + headerPKFieldValues + "]");
                TaxCalculation taxCal = new TaxCalculation(objName, userInfo);
                taxCal.setUpdatedTaxDom(this.getCurrTaxNode());
                Node currTaxNode = this.getCurrTaxNode();
                taxCal.setTaxDom(currTaxNode);
                taxCal.setDataNode(this.currRecordNode, objContext, detailDomId);
                String taxChgStr = taxCal.taxCalc(refSer, headerPKFieldValues, taxDate, "rate__stduom", "quantity__stduom", rateCol, qtyCol, this.getValueOfField(this.searchNode(this.detailDom, "1", "1"), "curr_code"), userInfo.getSiteCode(), objContext, userInfo.getTransDB(), "", "", this.getValueOfField(currNode, "exch_rate"));
                if (taxChgStr != null && taxChgStr.length() > 0 && taxChgStr.indexOf("<Errors>") != -1) {
                    return taxChgStr;
                }
                Hashtable<String, Node> changedDataMap = new Hashtable<String, Node>();
                if (taxChgStr != null && taxChgStr.length() > 0 && (chgDataDom = this.utility.parseString(taxChgStr)).getElementsByTagName("Root").item(0) != null) {
                    Node rootNode = chgDataDom.getElementsByTagName("Root").item(0);
                    NodeList chgDataNodeList = rootNode.getChildNodes();
                    int noOfChgDataNodes = chgDataNodeList.getLength();
                    int i = 0;
                    while (i < noOfChgDataNodes) {
                        Node chgDataDetailNode = chgDataNodeList.item(i);
                        String tagName = chgDataDetailNode.getNodeName();
                        String formNo = null;
                        String domIdStr = null;
                        BaseLogger.log("3", userInfo, null, "tagName [" + tagName + "]");
                        if (tagName.startsWith("Detail")) {
                            String string = formNo = tagName.length() > "Detail".length() ? tagName.substring("Detail".length()) : "1";
                            if (chgDataDetailNode.getAttributes().getNamedItem("domID") != null) {
                                domIdStr = chgDataDetailNode.getAttributes().getNamedItem("domID").getNodeValue();
                            }
                            NodeList chgColNodeList = chgDataDetailNode.getChildNodes();
                            int noOfChgColNodes = chgColNodeList.getLength();
                            int j = 0;
                            while (j < noOfChgColNodes) {
                                Node chgColNode = chgColNodeList.item(j);
                                if (chgColNode != null && chgColNode.getNodeType() == 1) {
                                    changedDataMap.put(String.valueOf(formNo) + "_" + domIdStr + "_" + chgColNode.getNodeName(), chgColNode);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                currTaxNode = this.getCurrTaxNode();
                String changedXMLString = this.getChangedXMLString(changedDataMap, objContext, detailDomId, true);
                changedXMLString = changedXMLString.replace("<Root>", "");
                changedXMLString = changedXMLString.replace("</Root>", "");
                data.append(changedXMLString);
                taxChgStr = taxChgStr.replace("<Root>", "");
                taxChgStr = taxChgStr.replace("</Root>", "");
                data.append(taxChgStr);
                BaseLogger.log("3", userInfo, null, "\n\n\n\n\n\n\n taxChgStr :[" + taxChgStr + "]getChangedXMLString[" + changedXMLString);
            }
            data.append("</Root>");
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception : E12TaxCalculation : calculateTax :" + e);
            throw new ITMException(e);
        }
        return data.toString();
    }

    private String getChangedXMLString(Hashtable<String, Node> changedDataMap, String objContext, String detailDomId, boolean isTaxChanged) throws ITMException {
        BaseLogger.log("2", null, null, "Building Changed XML String for ChaNge Data Map size :[" + changedDataMap.size() + "]");
        String retString = "";
        int noOfForms = 2;
        try {
            StringBuffer changedXMLStrBuff = new StringBuffer("<Root>\n");
            if (changedDataMap.size() > 0) {
                Set<String> keySet = changedDataMap.keySet();
                Iterator<String> iterator = keySet.iterator();
                Object domID = null;
                boolean i = true;
                ArrayList allList = new ArrayList(noOfForms);
                int ctr = 0;
                while (ctr < noOfForms) {
                    allList.add(null);
                    ++ctr;
                }
                while (iterator.hasNext()) {
                    StringBuffer currRecordColBuffer;
                    String id = iterator.next();
                    String currObjContext = id.substring(0, id.indexOf("_"));
                    int domIdLen = id.indexOf("_", id.indexOf("_") + 1);
                    String currDomID = id.substring(id.indexOf("_") + 1, domIdLen);
                    String tagName = id.substring(domIdLen + 1);
                    Node curDetChild = changedDataMap.get(id);
                    BaseLogger.log("9", null, null, "tagName[" + tagName + "]changedDataMap[" + changedDataMap + "]curDetChild[" + this.utility.serializeDom(curDetChild) + "]");
                    ArrayList<StringBuffer> currFormList = (ArrayList<StringBuffer>)allList.get(Integer.parseInt(currObjContext) - 1);
                    if (currFormList == null) {
                        currFormList = new ArrayList<StringBuffer>();
                        allList.set(Integer.parseInt(currObjContext) - 1, currFormList);
                    }
                    int currFormListSize = currFormList.size();
                    if (Integer.parseInt(currDomID) > currFormListSize) {
                        while (currFormListSize < Integer.parseInt(currDomID)) {
                            currFormList.add(null);
                            ++currFormListSize;
                        }
                    }
                    if ((currRecordColBuffer = (StringBuffer)currFormList.get(Integer.parseInt(currDomID) - 1)) == null) {
                        currRecordColBuffer = new StringBuffer();
                    }
                    currFormList.set(Integer.parseInt(currDomID) - 1, currRecordColBuffer.append(this.utility.serializeDom(curDetChild)));
                }
                int formCtr = 0;
                while (formCtr < noOfForms) {
                    ArrayList currFormList = (ArrayList)allList.get(formCtr);
                    if (currFormList != null) {
                        int noOfRecs = currFormList.size();
                        int recCtr = 0;
                        while (recCtr < noOfRecs) {
                            if (currFormList.get(recCtr) != null) {
                                changedXMLStrBuff.append("<Detail" + (formCtr + 1) + "  domID='" + (recCtr + 1) + "'>");
                                changedXMLStrBuff.append(currFormList.get(recCtr).toString());
                                if (isTaxChanged && formCtr + 1 == Integer.parseInt(objContext) && recCtr + 1 == Integer.parseInt(detailDomId)) {
                                    changedXMLStrBuff.append(this.getAllTaxesXMLString(objContext, detailDomId));
                                    isTaxChanged = false;
                                }
                                changedXMLStrBuff.append("</Detail" + (formCtr + 1) + ">");
                            }
                            ++recCtr;
                        }
                    }
                    ++formCtr;
                }
            }
            if (isTaxChanged) {
                changedXMLStrBuff.append("<Detail" + objContext + "  domID='" + detailDomId + "'>");
                changedXMLStrBuff.append(this.getAllTaxesXMLString(objContext, detailDomId));
                changedXMLStrBuff.append("</Detail" + objContext + ">");
            }
            changedXMLStrBuff.append("</Root>\n");
            retString = changedXMLStrBuff.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB : getChangedXMLString :" + e);
            throw new ITMException(e);
        }
        return retString;
    }

    private String getAllTaxesXMLString(String objContext, String domID) throws ITMException {
        BaseLogger.log("2", null, null, "[MasterStatefulEJB]Getting all taxes string for objContext :" + objContext + ":");
        StringBuffer taxXmlBuff = new StringBuffer();
        String taxesXmlString = "";
        try {
            NodeList detailList = this.detailDom.getElementsByTagName("Detail" + objContext);
            int i = 0;
            while (i < detailList.getLength()) {
                Node currDetail = detailList.item(i);
                if (currDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(domID)) {
                    NodeList currDetailList = currDetail.getChildNodes();
                    int j = 0;
                    while (j < currDetailList.getLength()) {
                        Node currChild = currDetailList.item(j);
                        if (currChild.getNodeName().equalsIgnoreCase("Taxes")) {
                            taxXmlBuff.append(this.utility.serializeDom(currChild)).append("\n");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            taxesXmlString = taxXmlBuff.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :MasterStatefulEJB :getAllTaxesString :==>" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", null, null, "changed all taxesXmlString.length() :[" + taxesXmlString.length() + "]");
        return taxesXmlString;
    }

    private void appendOrReplaceTaxesNode(String objContext, String detailDomId) throws ITMException {
        boolean found = false;
        try {
            String blankTaxString = this.getBlankTaxDomForAdd(objContext);
            if (this.currRecordNode == null) {
                this.currRecordNode = this.searchNode(this.detailDom, objContext, detailDomId);
            }
            NodeList dataNodeChildList = this.currRecordNode.getChildNodes();
            int dataNodeChildListLen = dataNodeChildList.getLength();
            int i = 0;
            while (i < dataNodeChildListLen) {
                if (dataNodeChildList.item(i) != null && dataNodeChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) {
                    this.currRecordNode.replaceChild(this.currRecordNode.getOwnerDocument().importNode(this.utility.parseString(blankTaxString).getFirstChild(), true), dataNodeChildList.item(i));
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.currRecordNode.appendChild(this.currRecordNode.getOwnerDocument().importNode(this.utility.parseString(blankTaxString).getFirstChild(), true));
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TaxCalculation: removeTaxNodeInDetail :==>\n" + e);
            throw new ITMException(e);
        }
    }

    public String getBlankTaxDomForAdd(String objContext) throws Exception {
        StringBuffer blankTaxStringBuff = new StringBuffer("<Taxes status='N'>");
        try {
            XMLBuilder xmlBuilder = new XMLBuilder();
            String defaultPathForMetadataXML = "." + File.separator + "metadata" + File.separator;
            String standardNameForXML = "Taxtran.xml";
            String blankTaxString = xmlBuilder.getDomForAdd("Taxtran", "", String.valueOf(defaultPathForMetadataXML) + standardNameForXML);
            Document blankTaxDom = this.utility.parseString(blankTaxString);
            NodeList headerChildList = blankTaxDom.getElementsByTagName("Header0").item(0).getChildNodes();
            int len = headerChildList.getLength();
            int i = 0;
            while (i < len) {
                if (headerChildList.item(i).getNodeName().equalsIgnoreCase("Tax")) {
                    CDATASection cDataSection = null;
                    cDataSection = blankTaxDom.createCDATASection(objContext);
                    if (blankTaxDom.getElementsByTagName("form_no") != null && blankTaxDom.getElementsByTagName("form_no").item(0) != null) {
                        blankTaxDom.getElementsByTagName("form_no").item(0).appendChild(cDataSection);
                    }
                    blankTaxStringBuff.append(this.utility.serializeDom(headerChildList.item(i)));
                }
                ++i;
            }
            blankTaxStringBuff.append("</Taxes>");
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return blankTaxStringBuff.toString();
    }

    private String getValueOfField(Node node, String currFieldName) throws Exception {
        String currFieldValue = null;
        NodeList childNodeList = node.getChildNodes();
        int noOfChilds = childNodeList.getLength();
        int ctr = 0;
        while (ctr < noOfChilds) {
            Node currChild = childNodeList.item(ctr);
            if (currChild.getNodeName().equalsIgnoreCase(currFieldName) && currChild.getFirstChild() != null) {
                currFieldValue = currChild.getFirstChild().getNodeValue();
                break;
            }
            ++ctr;
        }
        return currFieldValue;
    }

    public Node searchNode(Document dom, String objContext, String nodeID) throws ITMException {
        Node detailNode = null;
        try {
            objContext = objContext == null || objContext.length() == 0 ? "1" : objContext;
            nodeID = nodeID == null || nodeID.length() == 0 ? "1" : nodeID;
            NodeList detailList = dom.getElementsByTagName("Detail" + objContext);
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node curDetail = detailList.item(ctr);
                if (curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(nodeID)) {
                    detailNode = curDetail;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : E12TaxCalculation : searchNode :" + e);
            throw new ITMException(e);
        }
        return detailNode;
    }

    private Node getCurrTaxNode() throws Exception {
        Node taxNode = null;
        try {
            NodeList currRecordChildList = this.currRecordNode.getChildNodes();
            int childListLength = currRecordChildList.getLength();
            int i = 0;
            while (i < childListLength) {
                if (currRecordChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) {
                    taxNode = currRecordChildList.item(i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:E12TaxCalculation: getCurrTaxNode:" + e);
            throw new ITMException(e);
        }
        return taxNode;
    }

    public Node getCurrTaxNode(String objContext, String domID) throws Exception {
        Node taxNode = null;
        try {
            BaseLogger.log("3", null, null, "E12TaxCalculation : getCurrTaxNode : objContext :" + objContext + ": domID :" + domID + ":");
            Node currNode = this.searchNode(this.detailDom, objContext, domID);
            if (currNode != null) {
                NodeList currRecordChildList = currNode.getChildNodes();
                int childListLength = currRecordChildList.getLength();
                int i = 0;
                while (i < childListLength) {
                    if (currRecordChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) {
                        taxNode = currRecordChildList.item(i);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception:E12TaxCalculation: getCurrTaxNode(String objContext, String domID):" + e);
            throw new ITMException(e);
        }
        return taxNode;
    }
}

