/* Name : WsfaSampleGiftValidity
 * Purpose : Validation of Sample and Gift
 * Developed By : Shahu Mali
 * */
package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
//import java.sql.Date;
import java.util.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].
public class WsfaSampleGiftValidity extends ValidatorEJB implements WsfaSampleGiftValidityLocal,WsfaSampleGiftValidityRemote
{

	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	String winName = null;
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		System.out.println("===>\n****xmlString****\n["+xmlString+"]\n****xmlString1****\n["+xmlString1+"]***xmlString2***\n["+xmlString2+"]");

		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			System.out.println("===>****,==== \n****dom****\n["+dom+"]\n****dom1****\n["+dom1+"]***dom2***\n["+dom2+"]");
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams );
			System.out.println("[WsfaSampleGiftValidity][wfValData][ErrString:] " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: WsfaSampleGiftValidity: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SpgrpTarget wfValData");
		return errString;
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String sql="";
		String errCode="";
		String errorType = "";
		String errString = "";
		String	itemCode="";
		String	specialityCode="" ;
		String	validFrom ="";
		String	validUpto="" ;
		String itemType="";

		java.util.Date validFromDate = null;
		java.util.Date validUptoDate = null;
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		//ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");

		try
		{
			/*conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			SimpleDateFormat sdf= new SimpleDateFormat();

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("item_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errList.add( "NULLITEMCO" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
							specialityCode = checkNull(genericUtility.getColumnValue("spl_code", dom));
							validFrom = checkNull(genericUtility.getColumnValue("valid_from", dom));
							validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom));
							//itemType = checkNull(genericUtility.getColumnValue("item_type", dom));
							System.out.println("itemtype==>"+itemType);

								sql="SELECT ITEM_TYPE FROM ITEM_OWN WHERE ITEM_CODE = ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,itemCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									itemType = rs.getString("ITEM_TYPE");
								}
								if(!("G".equalsIgnoreCase(itemType)))
								{
									errList.add("INVAILTYPE");
									errFields.add(childNodeName.toLowerCase());
								}

								sql="SELECT COUNT(*) FROM ITEM_OWN WHERE ITEM_CODE= ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,itemCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								if ( cnt <= 0 )
								{
									errList.add("INVITEMVC");
									errFields.add(childNodeName.toLowerCase());
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;






						}
	    	  			if((itemCode.trim().length() > 0) && (specialityCode.trim().length() > 0) && (validFrom.trim().length() > 0) && (validUpto.trim().length() > 0) )
	    	  			{
	    	  				boolean isExist =checkUniqueValue(itemCode,specialityCode,validFrom,validUpto,editFlag);
	    	  				if(isExist)
	    	  				{
	    	  					errList.add("DUPRECORD");
								errFields.add(childNodeName.toLowerCase());
	    	  				}
	    	  			}
					}
					else if(childNodeName.equalsIgnoreCase("spl_code"))
					{
						if( childNode.getFirstChild() == null )
						{
							errCode = "NULLSPLCOD";
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
							specialityCode = checkNull(genericUtility.getColumnValue("spl_code", dom));
							validFrom = checkNull(genericUtility.getColumnValue("valid_from", dom));
							validUpto = checkNull(genericUtility.getColumnValue("valid_upto", dom));

							sql="SELECT COUNT(*) FROM SPECIALITY WHERE SPL_CODE= ? ";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,specialityCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							if ( cnt <= 0 )
							{
								errCode = "INVSPELCOD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

		    	  			if((itemCode.trim().length() > 0) && (specialityCode.trim().length() > 0) && (validFrom.trim().length() > 0) && (validUpto.trim().length() > 0) )
    	    	  			{
		    	  				boolean isExist =checkUniqueValue(itemCode,specialityCode,validFrom,validUpto,editFlag);
		    	  				if(isExist)
		    	  				{
		    	  					errList.add("DUPRECORD");
									errFields.add(childNodeName.toLowerCase());
									System.out.println(">> validation for Duplicated Record <<");
		    	  				}
    	    	  			}
						}

					}
					else if ( "valid_from".equalsIgnoreCase( childNodeName ) )
					{
					    itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
					 	specialityCode = checkNull(genericUtility.getColumnValue("spl_code", dom));
						String validFromDateStr = checkNull(genericUtility.getColumnValue( "valid_from", dom ));
						String validUptoDateStr = checkNull(genericUtility.getColumnValue( "valid_upto", dom ));

						if ( validFromDateStr == null || validFromDateStr.trim().length() == 0 )
						{
							errList.add( "NULLVALFRD" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							System.out.println(">> Inside validation for validfrom <<");

								if(validFromDateStr != null && validFromDateStr.trim().length() > 0)
								{
									validFromDate = dtFormat.parse(validFromDateStr);
									System.out.println(">> Inside parse validfrom <<");
								}
								if(validUptoDateStr != null && validUptoDateStr.trim().length() > 0)
								{
									 validUptoDate = dtFormat.parse(validUptoDateStr);
									 System.out.println(">> Inside parse validupto <<");
								}
								if( validFromDate != null && validUptoDate != null )
								{
									if( validFromDate != null && validUptoDate != null && validUptoDate.before(validFromDate )  )
									{
										errList.add( "INVVALFRD" );
										errFields.add( childNodeName.toLowerCase() );
										System.out.println(">> validation for validfrom <<");
									}
									else if((itemCode.trim().length() > 0)&& (specialityCode.trim().length() > 0) && (validFrom.trim().length() > 0) && (validUpto.trim().length() > 0) )
									{
										boolean isExist =checkUniqueValue(itemCode,specialityCode,validFrom,validUpto,editFlag);
										if(isExist)
										{
											errList.add("DUPRECORD");
											errFields.add(childNodeName.toLowerCase());
											System.out.println(">> validation for Duplicated Record <<");
										}

									}
								}

						}

					}
					else if ( "valid_upto".equalsIgnoreCase( childNodeName ) )
					{
					    itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
					 	specialityCode = checkNull(genericUtility.getColumnValue("spl_code", dom));
					    String validUptoDateStr = checkNull(genericUtility.getColumnValue( "valid_upto", dom ));
					    String validFromDateStr = checkNull(genericUtility.getColumnValue( "valid_from", dom ));
						if ( validUptoDateStr == null || validUptoDateStr.trim().length() == 0  )
						{
							errList.add( "NULLVALUPD" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							System.out.println(">> Inside validation for validupto <<");

								if(validFromDateStr != null && validFromDateStr.trim().length() > 0)
								{
									validFromDate = dtFormat.parse(validFromDateStr);
									System.out.println(">> Inside parse validfrom <<");
								}
								if(validUptoDateStr != null && validUptoDateStr.trim().length() > 0)
								{
									 validUptoDate = dtFormat.parse(validUptoDateStr);
									 System.out.println(">> Inside parse validupto <<");
								}
								if( validFromDate != null && validUptoDate != null )
								{
									if( validFromDate != null && validUptoDate != null && validUptoDate.before(validFromDate) )
									{
										errList.add( "INVVALUPD" );
										errFields.add( childNodeName.toLowerCase() );
										System.out.println(">> validation for validupto <<");
									}
									else if((itemCode.trim().length() > 0)&& (specialityCode.trim().length() > 0) && (validFrom.trim().length() > 0) && (validUpto.trim().length() > 0) )
				    	  			{
										boolean isExist =checkUniqueValue(itemCode,specialityCode,validFrom,validUpto,editFlag);
				    	  				if(isExist)
				    	  				{
				    	  					errList.add("DUPRECORD");
											errFields.add(childNodeName.toLowerCase());
				    	  				}

				    	  			}
							    }
						}
					}
				}
				break;
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [scheme][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("i am from itemchanged method==========>");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String itemOwnDescr="";
		String specialityDescr="";
		String sql = "";
		String itemCode="";
		String splCode="";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		//ConnDriver connDriver = new ConnDriver();
		try
		{
			/*conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			conn.setAutoCommit(false);
			//connDriver = null;
			if(objContext != null && objContext.trim().length() > 0)
			{
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			valueXmlString.append("<Detail1>");

			if(currentColumn.trim().equalsIgnoreCase("item_code"))
			{
				itemCode= genericUtility.getColumnValue("item_code", dom);
				sql = "select descr from item_own where item_code = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					itemOwnDescr = checkNull(rs.getString("descr"));
				}
				valueXmlString.append("<item_descr>").append("<![CDATA[" + itemOwnDescr +"]]>").append("</item_descr>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			if(currentColumn.trim().equalsIgnoreCase("spl_code"))
			{
				splCode= genericUtility.getColumnValue("spl_code", dom);
				sql = "select descr from speciality where spl_code = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,splCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					specialityDescr = checkNull(rs.getString("descr"));
				}
				valueXmlString.append("<speciality_descr>").append("<![CDATA[" + specialityDescr +"]]>").append("</speciality_descr>");
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}


			valueXmlString.append("</Detail1>");
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(rs != null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}

				if(conn != null)
				{
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		System.out.println("valueXmlString ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	private String errorType(Connection conn , String errorCode) throws ITMException // throws added by kailash on 11-04-18.
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}
	private boolean checkUniqueValue(String itemcode, String specialitycode ,String validFromDateStr,String validUptoDateStr,String editFlag) throws ITMException, Exception
	{
  		String sql = "";
  		String errCode="";
		String errString = "";
  		int cnt=0;
  		Connection conn = null;
  		Date validFromDate;
  		Date validUptoDate;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		//ConnDriver connDriver = new ConnDriver();
		boolean isExist = false;
        try
		{
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			/*conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			Calendar currentDate = Calendar.getInstance();
			String currDateStr = dtFormat.format(currentDate.getTime());
			System.out.println("itemCode<===>"+itemcode+"validFrom<==>"+validFromDateStr+"validUpto<===>"+validUptoDateStr);
			System.out.println("EditFlag========================================>"+editFlag);
			if (editFlag != null && "A".equalsIgnoreCase(editFlag.trim()) )
			{
				sql = "select count(*) as count from item_own_validity where "
    	  		  +" item_code = ? and spl_code = ? "
    	  		  +" and valid_from <= ? and valid_upto >= ? ";

				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,itemcode);
				pstmt.setString(2,specialitycode);
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validFromDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( validUptoDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

				rs = pstmt.executeQuery();
				if(rs.next())
				{
					cnt = rs.getInt(1);
				}
				rs.close(); rs = null;
				pstmt.close(); pstmt = null;
	  	    }
			if ( cnt > 0 )
  			{
				isExist = true;
  		    }
       }
       catch(Exception e)
       {
        	System.out.println("Exception ====>"+e);
        	throw new ITMException(e); //added by Kailash on 11-04-2018.
       }
       finally
       {
    	   try
    	   {
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null)
						rs.close();
					if(pstmt != null)
						pstmt.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
    	   }
			catch(Exception e)
			{
				System.out.println("Exception  getMessage====>"+e.getMessage());
			}
		}
		return isExist;

	}
}
