package ibase.webitm.utility;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.imageio.ImageIO;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.InfinispanLocal;

public class ResourceImageServiceUtility {

	private String imageFieldValue;
	private String altImageFieldValue;
	private Connection connectionObject;
	private boolean isOval;

	private UserInfoBean userInfo = null;
	static InfinispanLocal infinispanLocalObj = null;

	public Response getResourceImage(String fldValue, String object, String objName, String altFldValue,
			String tokenIDfromHeader, HttpServletRequest request, HttpServletResponse response) {
		HttpSession session = request.getSession();
		session = request.getSession();

//		Map<String, Object> returnMap = new HashMap<>();
//		
//		returnMap.put("status","success");
//		returnMap.put("image",byte[]);
//		return returnMap;

		if (userInfo == null) {
			APIUtility apiUtility = new APIUtility();
			userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
			session.setAttribute("userInfo", userInfo);
			BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
		}

		Connection connectionObject = null; // Assuming this is initialized elsewhere

		try {
			BaseLogger.log("3", null, null, "XXXXXXXXCustomMenuImageServletXXXXXXXXXXXXXX");

			String value = fldValue; // Use method parameter directly
			String alt_Fld_Value = altFldValue; // Use method parameter directly
			String docAttachType = checkNull(request.getParameter("docAttachType"));
			String bgColor = checkNull(request.getParameter("bg_color"));

			response.setHeader("Cache-Control", "max-age=86400, public");

			imageFieldValue = checkNull(value);
			altImageFieldValue = checkNull(alt_Fld_Value);

// Handling oval parameter...
			String refSer = checkNull(getRefSer(object, connectionObject, userInfo));
			String docId = "";

			if (refSer.length() > 0) {
				docId = checkNull(getDocID(refSer, value, docAttachType, connectionObject, userInfo.getTransDB()));
			}

// Building cache key...
			if (!"".equalsIgnoreCase(docId) && docId.length() > 0) {
// Forwarding to another servlet if document ID exists...
				String action = "GET_DOCUMENT";
				String docType = "image/png";
				String path = "WebITMDocumentHandlerServlet?CUSTOM_IMG_ACTION=" + action + "&CUSTOM_IMG_DOC_ID=" + docId
						+ "&CUSTOM_IMG_DOC_TYPE=" + docType + "&fldValue=" + value;

				RequestDispatcher rd = request.getRequestDispatcher(path);
				rd.forward(request, response);
				return null; // Forwarded response, so return null
			} else if (fileExist(value, object)) {
				File f = new File(CommonConstants.RIALITE_PROFILE_PATH + File.separator + object + File.separator
						+ value + ".png");
				BufferedImage bi = ImageIO.read(f);
				try {

					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					ImageIO.write(bi, "png", baos);

					byte[] byteArray = baos.toByteArray();
					return Response.ok(new ByteArrayInputStream(byteArray)).type("image/png").build();

				} catch (Exception e) {
					BaseLogger.log("0", userInfo, null,
							"Exception :CustomMenuImageServlet : Unable write image : " + e.getMessage());
					ImageIO.setUseCache(false);
				}
			} else {
				BufferedImage bi = createLabelImage(value, alt_Fld_Value, bgColor);
				try {
					ByteArrayOutputStream baos = new ByteArrayOutputStream();
					ImageIO.write(bi, "png", baos);

					byte[] byteArray = baos.toByteArray();
					return Response.ok(new ByteArrayInputStream(byteArray)).type("image/png").build();
				} catch (Exception e) {
					BaseLogger.log("0", userInfo, null,
							"Exception :CustomMenuImageServlet : Unable write image : " + e.getMessage());
					ImageIO.setUseCache(false);
				} finally {
					try {
						if (connectionObject != null && !connectionObject.isClosed()) {
							connectionObject.close();
							connectionObject = null;
						}
					} catch (SQLException e) {
						BaseLogger.log("0", userInfo, null,
								"Exception in CustomMenuImage closing main connectionObject ===>" + e.getMessage());
						e.printStackTrace();
						throw new ITMException(e);
					}
				}

			}
		}

		catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception :CustomMenuImageServlet : ==>\n" + e.getMessage());

			try {
				response.setHeader("Cache-Control", "max-age=86400, public");
				BufferedImage bi = createLabelImage(imageFieldValue, altImageFieldValue, "");
				ImageIO.setUseCache(false);

			} catch (Exception e1) {
				BaseLogger.log("3", userInfo, null, "IOException in CustomMenuImageServlet: " + e1.getMessage());
			}
		} finally {
			try {
				if (connectionObject != null && !connectionObject.isClosed()) {
					connectionObject.close();
				}
			} catch (SQLException sqlException) {
				BaseLogger.log("3", userInfo, null,
						"Exception in CustomMenuImage closing main connectionObject ===>" + sqlException.getMessage());
			}
		}

		return null;
	}

	public static String checkNull(String value) {
		if (value == "undefined" || value == null || "null".equalsIgnoreCase(value))

		{
			value = "";
		}
		return value.trim();
	}

	private String getRefSer(String objName, Connection connectionObject, UserInfoBean userInfo) {
		String sql = "";
		String refSer = "";
		PreparedStatement pstmtDescr = null;
		ResultSet rs = null;
		boolean isLocalConnection = false;
		Connection mConnection = connectionObject;
		try {
			if (mConnection == null) {
				ConnDriver mConnDriver = new ConnDriver();
				mConnection = mConnDriver.getConnectDB(userInfo.getTransDB());
				isLocalConnection = true;
			}
			sql = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmtDescr = mConnection.prepareStatement(sql);
			pstmtDescr.setString(1, "w_" + objName);
			rs = pstmtDescr.executeQuery();

			if (rs.next()) {
				refSer = rs.getString("REF_SER");
			}
			BaseLogger.log("3", userInfo, null, "REF_SER for[" + imageFieldValue + "] == [" + refSer + "]");
		} catch (SQLException e) {
			e.printStackTrace();
			BaseLogger.log("3", userInfo, null,
					"SQLException inside CustomMenuImageServlet getRefSer : [" + e.getMessage() + "]");
		} catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("3", userInfo, null,
					"Exception inside CustomMenuImageServlet getRefSer : [" + e.getMessage() + "]");
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmtDescr != null) {
					pstmtDescr.close();
					pstmtDescr = null;
				}
				// if( connectionObject != null && ! connectionObject.isClosed() )
				if (mConnection != null && isLocalConnection) {
					// connectionObject.close();
					// connectionObject = null;
					mConnection.close();
					mConnection = null;
				}
			} catch (Exception e) {
				// BaseLogger.log("3", userInfo, null,"finally Exception :CustomMenuImageServlet
				// getRefSer : ==>\n"+imageFieldValue+"=="+e.getMessage());
			}
		}
		return refSer;
	}

	private String getDocID(String refSer, String refId, String docTypeAttach, Connection connectionObject,
			String transDB) throws ITMException {
		String sql = "";
		String docId = "";
		PreparedStatement pstmtDescr = null;
		ResultSet rs = null;
		boolean isLocalConnection = false;
		Connection mConnection = connectionObject;
		try {
			if (mConnection == null) {
				ConnDriver mConnDriver = new ConnDriver();
				mConnection = mConnDriver.getConnectDB(transDB); // $NON-NLS-1$
				isLocalConnection = true;
			}
			sql = "SELECT DOC_ID FROM DOC_TRANSACTION_LINK WHERE REF_SER = ? AND REF_ID = ? AND DOC_TYPE_ATTACH = ? AND (DELETE_FLAG <> 'Y' OR DELETE_FLAG IS NULL)";
			pstmtDescr = mConnection.prepareStatement(sql);
			pstmtDescr.setString(1, refSer);
			refId = refId != null ? refId.trim() : refId;
			pstmtDescr.setString(2, refId);
			if (docTypeAttach != null && docTypeAttach.length() > 0) {
				pstmtDescr.setString(3, docTypeAttach);
			} else {
				pstmtDescr.setString(3, "Icon");
			}
			rs = pstmtDescr.executeQuery();

			while (rs.next()) {
				docId = rs.getString("DOC_ID");
				BaseLogger.log("3", null, null, "===>DOC_ID for refId[" + refId + "==" + docId + "]");
			}
		} catch (SQLException e) {
			e.printStackTrace();
			BaseLogger.log("0", null, null,
					"SQLException inside CustomMenuImageServlet getDocID : [ " + e.getMessage() + " ]");
			throw new ITMException(e);
		} catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("0", null, null,
					"Exception inside CustomMenuImageServlet getDocID : [ " + e.getMessage() + " ]");
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmtDescr != null) {
					pstmtDescr.close();
					pstmtDescr = null;
				}
				if (mConnection != null && isLocalConnection) {
					mConnection.close();
					mConnection = null;

				}
			} catch (Exception e) {
				BaseLogger.log("0", null, null,
						"Exception :CustomMenuImageServlet getDocID : ==>\n[" + refId + "]" + e.getMessage());
			}
		}
		return docId;
	}

	private boolean fileExist(String value, String object) {
		boolean flag = true;
		try {
			String path = CommonConstants.RIALITE_PROFILE_PATH + File.separator + object + File.separator + value
					+ ".png";
			BaseLogger.log("3", null, null, "CustomImage servlet path[" + path + "]");
			File f = new File(path);
			if (!f.exists()) {
				flag = false;
			} else {
				flag = true;
			}
		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception :CustomMenuImageServlet fileExist : ==>\n" + e.getMessage());
		}
		return flag;
	}

	public BufferedImage createLabelImage(String value, String alt_Fld_Value, String bgColor) {
		int width = 100, height = 100;
		BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		try {
			Graphics2D g = bi.createGraphics();
			String text = "";
			if (!"".equalsIgnoreCase(checkNull(alt_Fld_Value))) {
				text = checkNull(dynamicMenuImage(alt_Fld_Value));
			}
			if ("".equalsIgnoreCase(text)) {
				text = checkNull(dynamicMenuImage(value));
			}
			int centerX = 50, centerY = 50;
			int ovalWidth = 100, ovalHeight = 100;
			Font font = new Font("TimesRoman", Font.PLAIN, 50);
			g.setFont(font);
			if ("green".equalsIgnoreCase(bgColor)) {
				g.setColor(Color.decode("#3abf62"));
			} else if ("red".equalsIgnoreCase(bgColor)) {
				g.setColor(Color.decode("#ff6a6a"));
			} else {
				g.setColor(Color.decode("#cfbebe"));
			}
			BaseLogger.log("3", null, null, "this.isOval - [" + this.isOval + "]");
			if (this.isOval) {
				g.fillOval(centerX - ovalWidth / 2, centerY - ovalHeight / 2, ovalWidth, ovalHeight);
			} else {
				g.fillRect(centerX - ovalWidth / 2, centerY - ovalHeight / 2, ovalWidth, ovalHeight);
			}
			FontMetrics fm = g.getFontMetrics();
			double textWidth = fm.getStringBounds(text, g).getWidth();
			g.setColor(Color.WHITE);
			g.drawString(text, (int) (centerX - textWidth / 2), (int) ((centerY + fm.getMaxAscent() / 2)) - 2);
		} catch (Exception e) {
			BaseLogger.log("0", null, null,
					"Exception :CustomMenuImageServlet createLabelImage : ==>\n" + e.getMessage());
		}
		return bi;
	}

	private String dynamicMenuImage(String objDescr) {
		StringBuffer mnIconBuffer = new StringBuffer();
		String[] refSr = null;

		objDescr = objDescr.toUpperCase();
		objDescr = checkNull(objDescr);
		objDescr = objDescr.trim();
		if (objDescr != "") {
			if (objDescr.indexOf(" ") != -1) {
				refSr = objDescr.split(" ");
			} else if (objDescr.indexOf("-") != -1) {
				refSr = objDescr.split("-");
			} else if (objDescr.indexOf("_") != -1) {
				refSr = objDescr.split("_");
			} else if (objDescr.indexOf(":") != -1) {
				refSr = objDescr.split(":");
			}
			String menuStr = "";

			if (refSr != null) {
				for (int i = 0; i < refSr.length; i++) {
					if (mnIconBuffer.length() < 2 && checkNull(refSr[i]) != "") {
						menuStr = refSr[i];
						menuStr = menuStr.trim(); // Added by Sandeep S. on 3-10-16
						if (menuStr != ":" && !"".equalsIgnoreCase(menuStr)) {
							boolean flag = false;
							for (int indx = 0; indx < menuStr.length(); indx++) {
								char dummyChar = menuStr.charAt(indx);
								String dummyStr = Character.toString(dummyChar);
								flag = isSpecialChar(dummyStr);
								if (!flag && dummyStr.trim().length() > 0) {
									mnIconBuffer.append(dummyChar);
									break;
								}
							}
						}
					}
				}
			} else {
				mnIconBuffer.append(objDescr.charAt(0));
			}
		}

		String menuIconPath = mnIconBuffer.toString();
		return menuIconPath;
	}

	private boolean isSpecialChar(String value) {
		Pattern p = Pattern.compile("[^a-z0-9 ]", Pattern.CASE_INSENSITIVE);
		Matcher m = p.matcher(value);
		boolean b = m.find();

		return b;
	}

	public Response getMenuImageIcon(String fileName, String tokenIDfromHeader, HttpServletRequest request,
			HttpServletResponse response) {

		
		BaseLogger.log("3", null, null, "getMenuImageIcon Service called " );


		// HttpSession session = request.getSession();

//        if (userInfo == null) {
//            APIUtility apiUtility = new APIUtility();
//            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
//            session.setAttribute("userInfo", userInfo);
//            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
//        }

		String filePath = CommonConstants.APPLICATION_CONTEXT + "images" +  File.separator +"galaxy"+ File.separator+ fileName;
		File file = new File(filePath);
		
		BaseLogger.log("3", null, null, "FilePath :" +filePath );


		if (file.exists()) {
			BaseLogger.log("3", null, null, "File exists:" +fileName );


			StreamingOutput fileStream = output -> {
				try (FileInputStream in = new FileInputStream(file)) {
					byte[] buffer = new byte[4096];
					int bytesRead;
					while ((bytesRead = in.read(buffer)) != -1) {
						output.write(buffer, 0, bytesRead);
					}
				}
			};

			return Response.ok(fileStream, "image/png")
					.header("Content-Disposition", "inline; filename=\"" + file.getName() + "\"").build();
		} 
		else {
			
			BaseLogger.log("3", null, null, "File not exists:" +fileName );
			return Response.status(Response.Status.NOT_FOUND).entity("File not found").build();
		}
	}

}
