/*
 * Developed by	: shraddha M [17-12-19]
 * 
 */
package ibase.webitm.ejb.wsfa.transactions;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.*;

import java.util.*;
import java.sql.*;
import java.io.*;

import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import ibase.ejb.E12EMAILComp;
import ibase.system.config.AppConnectParm;

//Changes by Dayanand on 25/04/09 [ Changes For ejb3 ] start
import javax.annotation.Resource;
@javax.ejb.Stateless
 
public class UnconfEventProcess extends ProcessEJB implements UnconfEventProcessLocal,UnconfEventProcessRemote
{	
	protected static String database = CommonConstants.DB_NAME;
	
	private @Resource SessionContext cSessionContext;
	
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom2 = null;		
		String errString = "";		
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
				System.out.println("dom ["+xmlString+"]");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
				System.out.println("dom2 ["+xmlString2+"]");
			}
			
			errString = process(dom,dom2,windowName,xtraParams);			
		}
		catch(Exception e)
		{					
			errString = genericUtility.createErrorString(e);
		}		
		return errString;
	}

public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{				
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 				
			}			
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :EventProcess :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			rtrStr = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		return rtrStr; 
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("in getData*****");
		ResultSet rSet = null ;
		String empCode = "";
		String empName="";
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility e12genericUtility = new ibase.utility.E12GenericUtility();
		String database = CommonConstants.DB_NAME;
		StringBuffer valueXmlString  = null;
		int daysCnt = 0;
		String sqlgetEvent = "";
		PreparedStatement pstmtEvnt =  null;
		ResultSet rsEvent  =  null;
		Connection conn = null;
		boolean flag = false;	
		int domID = 1;
		String editFlag="";
		String confirmDate = "";
		
		try
		{			
			ConnDriver connDriver = new ConnDriver();
			conn = getConnection();
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB ();
			empCode = e12genericUtility.getColumnValue( "sales_pers", detailDom );
			empName =  e12genericUtility.getColumnValue( "sales_pers_name", detailDom );
			
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			String periodCode=e12genericUtility.getColumnValue( "period_code", detailDom );
			sqlgetEvent ="SELECT DISTINCT SP.SP_NAME,EVT.CONFIRMED, EVT.SALES_PERS ,EVT.PRD_CODE,SP.EMAIL_ADDR , EVT.CONF_DATE FROM SALES_PERS SP," +
					"STRG_EVENT_TRACK EVT WHERE EVT.PRD_CODE= ? AND EVT.CONFIRMED='Y' AND SP.SALES_PERS=EVT.SALES_PERS";
			pstmtEvnt =  conn.prepareStatement( sqlgetEvent );
			pstmtEvnt.setString(1, periodCode);
						
					 rsEvent = pstmtEvnt.executeQuery();
					System.out.println("Sql------>"+rsEvent);	
					while( rsEvent.next())
					{
						String salesPers=  ( e12genericUtility.checkNull( rsEvent.getString("SALES_PERS") ) );	
						String salesPersName = ( e12genericUtility.checkNull( rsEvent.getString("SP_NAME") ) );						
						String confirmed = ( e12genericUtility.checkNull(rsEvent.getString("CONFIRMED") ) );
						String emailAdd = ( e12genericUtility.checkNull(rsEvent.getString("EMAIL_ADDR") ) );
						String confDate = ( e12genericUtility.checkNull(rsEvent.getString("CONF_DATE") ) );
						//System.out.println("salesPers>>"+salesPers+"["+salesPersName+"]["+confirmed+"]["+emailAdd+"]["+periodCode+"]["+confDate+"]");
						
						//String confirmDate =	GenericUtility.getInstance().getValidDateString(confDate, GenericUtility.getInstance().getDBDateTimeFormat(), GenericUtility.getInstance().getApplDateFormat() );
						//System.out.println("Confirmation Date["+confirmDate+"]");
						
						valueXmlString.append( "<Detail2 domID='"+ domID +"' selected = 'N' >\r\n" );
						valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(salesPers).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<name><![CDATA[" ).append(salesPersName).append( "]]></name>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append(confirmed).append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<send_mail_to><![CDATA[" ).append(emailAdd).append( "]]></send_mail_to>\r\n" );
						valueXmlString.append( "<period_code><![CDATA[" ).append(periodCode).append( "]]></period_code>\r\n" );
					//	valueXmlString.append( "<conf_date><![CDATA[" ).append(confirmDate).append( "]]></conf_date>\r\n" );
						if(confDate != null && confDate.length() > 0 )
						{
							 confirmDate =(checkNull (GenericUtility.getInstance().getValidDateString(confDate, GenericUtility.getInstance().getDBDateTimeFormat(), GenericUtility.getInstance().getApplDateFormat() )));
							System.out.println("Confirmation Date["+confirmDate+"]");
							
							valueXmlString.append( "<conf_date><![CDATA[" ).append(confirmDate).append( "]]></conf_date>\r\n" );
						}
						else if(confDate.length() == 0) 
						{
							valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
						}
						
						valueXmlString.append("</Detail2>\r\n");
						domID ++;
					}
					valueXmlString.append("</Header0>\r\n");
					valueXmlString.append("</group0>\r\n");
					valueXmlString.append("</DocumentRoot>\r\n");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
				}		
				if(pstmtEvnt != null)
				{
					pstmtEvnt.close();
				}
				if(rsEvent != null)
				{
					rsEvent.close();
				}
				
			
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return valueXmlString.toString();
	}
	
/*	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}	*/
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	public String process(Document dom, Document dom2, String windowName, String xtraParams) throws RemoteException,ITMException
	{		
		
		System.out.println("in process>>>>>>>>>>>>>>"+xtraParams);
		String loginCode  =  "";
		Connection conn = null;
		PreparedStatement pStmt = null;
		String retStr ="";	
		AppConnectParm appConnect = new AppConnectParm();
		
		GenericUtility genericUtility = GenericUtility.getInstance();	
		try
		{			
			int ctr;
			int updateStrgEventTrackCnt = 0;
			String childNodeName = "";
			String columnValue ="";
			String sendMail = "";
			String salesPers = "";
			String periodCode = "";
			
		//	ConnDriver connDriver = new ConnDriver();
		//	conn = connDriver.getConnectDB( "DriverITM" );
			conn = getConnection();
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			
			NodeList parentNodeList = dom2.getElementsByTagName("Detail2");
			int parentNodeListLength = parentNodeList.getLength();
			
			loginCode=checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
			System.out.println("loginCode>>"+loginCode);
			CommonDBAccessRemote dbAccessRemote = new CommonDBAccessEJB();
		    UserInfoBean userInfo = dbAccessRemote.createUserInfo(loginCode);
		    System.out.println("userInfo>>"+userInfo);
			
			for(int parent = 0; parent < parentNodeListLength; parent++)
			{
				Node parentNode = parentNodeList.item(parent);
				NodeList childNodeList = parentNode.getChildNodes();
				System.out.println("childNodeList...."+childNodeList+"["+parentNodeListLength+"]");
				int childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength........"+childNodeListLength);
				
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{	
					Node childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					columnValue = "";
					if(childNode.getFirstChild() != null) 
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					
					if (childNodeName.equals("sales_pers"))
					{
						if(childNode.getFirstChild()!=null)
						{
							salesPers = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("period_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							periodCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("send_mail_to"))
					{
						if(childNode.getFirstChild()!=null)
						{
							sendMail = childNode.getFirstChild().getNodeValue();
						}
					}
				}
				
                if(salesPers != null && salesPers.trim().length() >0)               
                {
                	//System.out.println("salesPers>>"+salesPers);
                	//System.out.println("send mail to  --->>>"+sendMail);
                	//System.out.println("periodCode>>"+periodCode);
                	
                	String updateStrgEventTrack = "UPDATE STRG_EVENT_TRACK SET CONFIRMED = ? WHERE SALES_PERS = ? AND  PRD_CODE = ?";
                	 pStmt = conn.prepareStatement(updateStrgEventTrack);
                	 pStmt.setString(1,"N");
                	 pStmt.setString(2,salesPers);
                	 pStmt.setString(3,periodCode);
                     updateStrgEventTrackCnt = pStmt.executeUpdate();
                    System.out.println("updateStrgEventTrackCnt>>"+updateStrgEventTrackCnt);
                    
                    if( pStmt != null )
					{
						pStmt.close();
						pStmt = null ;
					}
                    
                    
                    String xmlVal="<ROOT><TRANS_INFO><OBJ_NAME>TRANS_INFO</OBJ_NAME></TRANS_INFO>" +
                    		"<Detail1 dbID='' domID='1' objContext='1' objName='TRANS_INFO' selected='N'><period_code><![CDATA["+periodCode+"]]></period_code></Detail1>" +
                    		"<Detail2><sales_pers><![CDATA["+salesPers+"]]></sales_pers><send_mail_to><![CDATA["+sendMail+"]]></send_mail_to></Detail2></ROOT>";
                           
                    String selTranId = "";
                    String selectTranIdSql="SELECT TRAN_ID FROM  STRG_EVENT_TRACK WHERE SALES_PERS = ? AND  PRD_CODE = ?";
                    PreparedStatement selPstmt = conn.prepareStatement(selectTranIdSql);
                    selPstmt.setString(1, salesPers);
                    selPstmt.setString(2, periodCode);
                    ResultSet selRs = selPstmt.executeQuery();
                    while(selRs.next())
                    {
                    	selTranId = checkNull(selRs.getString("TRAN_ID"));
                    }
                    System.out.println("selTranId....."+selTranId);
                    
                    E12EMAILComp e12EmailComp = new E12EMAILComp();    
                    String xtraParamsvalue = "loginCode="+salesPers+"~~loginEmpCode"+salesPers;
                   // System.out.println("xtraParamsvalue>>"+xtraParamsvalue);
                    e12EmailComp.sendEMAIL(xmlVal , "UNCONF_STRG_EVENT", xtraParamsvalue,  "", "",userInfo, conn );
                    
                    if( selRs != null )
					{
                    	selRs.close();
                    	selRs = null ;
					}

                    if( selPstmt != null )
					{
                    	selPstmt.close();
                    	selPstmt = null ;
					}

                }
                System.out.println("updateStrgEventTrackCnt>>"+updateStrgEventTrackCnt);
				if(updateStrgEventTrackCnt > 0)
				{
					retStr = "";
					
				}
				//System.out.println("retStr>>>>"+retStr);
				if (retStr == null || retStr.trim().length() == 0)
				{
					conn.commit();
					retStr = itmDBAccessEJB.getErrorString("", "EVNTUNCONF", "", "",	conn);//Added By Nilesh Start :: 26-03-19
				}
				else
				{
					conn.rollback();
					retStr = itmDBAccessEJB.getErrorString("", "VTPRNT", "", "",	conn);//Added By Nilesh Start :: 26-03-19
				}
             
			}
		//}
		}
		catch(Exception e)
		{
			System.out.println("Error ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.commit();
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//return returnString;
		 return retStr;
	}
	
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			System.out.println("UnconfEventProcessItemEJB:errorType:sql["+sql+"]");
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, checkNull(errorCode));			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	
	private String getValueOfField(Node node, String currFieldName)throws Exception
	{
		String currFieldValue = null;
		NodeList childNodeList = node.getChildNodes();
		int noOfChilds = childNodeList.getLength();
		for(int ctr = 0; ctr < noOfChilds; ctr++)
		{
			Node currChild = childNodeList.item(ctr);
			if(currChild.getNodeName().equalsIgnoreCase(currFieldName) && currChild.getFirstChild() != null)
			{
				currFieldValue = currChild.getFirstChild().getNodeValue().trim();
				break;
			}
		}
		return currFieldValue;
	}

}	