package ibase.webitm.ejb.wsfa.transactions;



import java.io.*;

import java.rmi.RemoteException;

import java.sql.*;

import java.text.*;

import java.util.*;

import java.util.Date;



import javax.ejb.*;

import javax.naming.InitialContext;

import javax.xml.parsers.*;



import org.json.simple.JSONObject;

import org.w3c.dom.*;



import ibase.ejb.*;

import ibase.system.config.*;

import ibase.utility.BaseLogger;

import ibase.utility.CommonConstants;

import ibase.webitm.bean.wsfa.DARCommonBean;

import ibase.webitm.bean.wsfa.OrgStructure;

import ibase.webitm.ejb.*;

import ibase.utility.E12GenericUtility;

import ibase.webitm.utility.GenericUtility;

import ibase.webitm.utility.ITMException;

import ibase.webitm.utility.TransIDGenerator;



import javax.xml.transform.*;

import javax.xml.transform.dom.*;

import javax.xml.transform.TransformerFactory;

import javax.xml.transform.Transformer;

import javax.xml.transform.stream.StreamSource;

import javax.xml.transform.stream.StreamResult;

import javax.xml.transform.TransformerException;

import javax.xml.transform.TransformerConfigurationException;



import org.xml.sax.InputSource;



import ibase.utility.UserInfoBean;





public class SprsSampPlanApproval

{



	public String SprsSamplePlanApproval(String tranID, String salesPers, String periodCode,String userInfostr) throws ITMException

	{

		System.out.println("Inside SprsSamplePlanApproval()....." );

		PreparedStatement pStmt = null;

		ResultSet rs = null;

		String retString = "";



		ConnDriver connDriver = null;

		Connection conn = null;



		boolean isError = false;



		try

		{



			E12GenericUtility genericUtility = new E12GenericUtility();

			UserInfoBean userInfo = new UserInfoBean(userInfostr);

			String userId="";

			if( userInfo != null && userInfo.getTransDB() != null )

			{

				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );

				userId = E12GenericUtility.checkNull( userInfo.getEmpCode() );

				connDriver = new ConnDriver();

				conn = connDriver.getConnectDB(transDB);

			}

			conn.setAutoCommit(false);

			connDriver = null;

			//added by mrunalini sinkar on 27-April-2018(end)





			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			java.util.Date date = Calendar.getInstance().getTime();

			String currDate = dtFormat.format( date );

			String pDate = genericUtility.getValidDateTimeString( currDate , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());



			String updStrgCustSql = "UPDATE SPRS_SAMP_PLAN SET WORKFLOW_STATUS = 'A', EMP_CODE__APRV = ?,APRV_DATE=? WHERE TRAN_ID = ? ";



			pStmt = conn.prepareStatement(updStrgCustSql);

			pStmt.setString(1, userId);

			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(pDate));

			pStmt.setString(3, tranID);



			int updCnt = pStmt.executeUpdate();

			if(pStmt != null)

			{

				pStmt.close();

				pStmt = null;

			}

			

			String acctCode="";

			String sql="SELECT ACCT_PRD FROM SPRS_SAMP_PLAN WHERE TRAN_ID=? ";

			

			pStmt = conn.prepareStatement(sql);

			pStmt.setString( 1, tranID);

			rs = pStmt.executeQuery();

			if(rs.next())

			{

				acctCode=checkNull(rs.getString("ACCT_PRD"));

			}



			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pStmt != null)

			{

				pStmt.close();

				pStmt = null;

			}

			

			

			insertIntoSumTable(tranID,acctCode,userId,conn);



			//insertIntoTraceTable(tranID,acctCode,periodCode,conn);

			

			

			System.out.println("@@@@ updCnt===>>"+updCnt);



			retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";

			

		}

		catch (Exception e)

		{

			isError = true;

			try

			{

				conn.rollback();

			}

			catch(Exception ee)

			{



			}

			e.printStackTrace();

			throw new ITMException(e);

		}

		finally

		{

			try

			{

				if( rs != null )

				{

					rs.close();

					rs = null;

				}

				if(pStmt != null )

				{

					pStmt.close();

					pStmt = null;

				}

				if(conn != null )

				{

					if(!isError)

					{

						conn.commit();

					}

					conn.close();

					conn = null;

				}



			}

			catch(Exception e)

			{

				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());

			}

		}



		return retString;

	}

	public String SprsSamplePlanReject(String tranID, String salesPers, String periodCode,String userInfostr) throws ITMException

	{



		System.out.println("Inside SprsSamplePlanReject()....." );

		PreparedStatement pStmt = null;

		ResultSet rs = null;

		String retString = "";



		ConnDriver connDriver = null;

		Connection conn = null;



		boolean isError = false;



		try

		{



			E12GenericUtility genericUtility = new E12GenericUtility();

			UserInfoBean userInfo = new UserInfoBean(userInfostr);

			String userId="";

			if( userInfo != null && userInfo.getTransDB() != null )

			{

				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );

				userId = E12GenericUtility.checkNull( userInfo.getEmpCode() );

				connDriver = new ConnDriver();

				conn = connDriver.getConnectDB(transDB);

			}

			conn.setAutoCommit(false);

			connDriver = null;





			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			java.util.Date date = Calendar.getInstance().getTime();

			String currDate = dtFormat.format( date );

			String pDate = genericUtility.getValidDateTimeString( currDate , genericUtility.getApplDateFormat() , genericUtility.getDBDateFormat());



			String updStrgCustSql = "UPDATE SPRS_SAMP_PLAN SET WORKFLOW_STATUS = 'P',CONFIRMED='N', EMP_CODE__APRV = ?,APRV_DATE=? WHERE TRAN_ID = ? ";



			pStmt = conn.prepareStatement(updStrgCustSql);

			pStmt.setString(1, userId);

			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(pDate));

			pStmt.setString(3, tranID);



			int updCnt = pStmt.executeUpdate();

			if(pStmt != null)

			{

				pStmt.close();

				pStmt = null;

			}



			System.out.println("@@@@ updCnt===>>"+updCnt);



			retString = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Success]]></RESULT></ROOT>";

			

		}

		catch (Exception e)

		{

			isError = true;

			try

			{

				conn.rollback();

			}

			catch(Exception ee)

			{



			}

			e.printStackTrace();

			throw new ITMException(e);

		}

		finally

		{

			try

			{

				if( rs != null )

				{

					rs.close();

					rs = null;

				}

				if(pStmt != null )

				{

					pStmt.close();

					pStmt = null;

				}

				if(conn != null )

				{

					if(!isError)

					{

						conn.commit();

					}

					conn.close();

					conn = null;

				}



			}

			catch(Exception e)

			{

				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());

			}

		}



		return retString;

	

		

	}

	public void insertIntoSumTable(String tranID,String acctCode,String userID,Connection connectionObject) throws Exception

	{





		System.out.println("Inside SprsSamplePlanReject()....." );

		PreparedStatement pstmt = null;

		ResultSet rs = null;

		String retString = "";

		PreparedStatement updatePstmt=null;

		try

		{		

			ArrayList<String> temp = new ArrayList<String>();

			String scCodeIn="";

			HashMap scCodeCntMap = new HashMap();







			String scCodeSql="SELECT SC_CODE FROM SPRS_SAMP_PLAN_DET WHERE TRAN_ID=? ";

			

			pstmt = connectionObject.prepareStatement(scCodeSql);

			pstmt.setString( 1, tranID);

			rs = pstmt.executeQuery();

			while(rs.next())

			{

				String strgCode = checkNull(rs.getString("SC_CODE"));

				temp.add(strgCode.trim());



			}



			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}

			if(!temp.isEmpty()) 

			{

				OrgStructure orgStructure = new OrgStructure();

				scCodeIn=orgStructure.getFormattedList(temp);

			}

			if(scCodeIn==null || scCodeIn.trim().length()==0)

			{

				scCodeIn="'X'";

			}



			String customerExistSql="SELECT FIN_ENT,SC_CODE,COUNT(*) AS CNT FROM  STRG_SAMP_PLAN_SUM WHERE SC_CODE IN("+scCodeIn+") AND ACCT_PRD=? "

					+ "GROUP BY FIN_ENT,SC_CODE " ;

			

			pstmt = connectionObject.prepareStatement(customerExistSql);

			pstmt.setString( 1, acctCode);			

			rs = pstmt.executeQuery();

			while(rs.next())

			{

				String scCode=checkNull(rs.getString("SC_CODE"));

				String finEnt=checkNull(rs.getString("FIN_ENT"));

				String mapKey=scCode+"@"+finEnt;

				int count=rs.getInt("CNT");

				scCodeCntMap.put(mapKey, count);

			}



			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}

			

			String valueSumSql="SELECT SSPD.FIN_ENTITY, SSPD.SC_CODE,SUM(APRV_VALUE) AS SUM_APRV_VALUE FROM SPRS_SAMP_PLAN SSP,SPRS_SAMP_PLAN_DET SSPD " + 

					"WHERE SSP.TRAN_ID=SSPD.TRAN_ID AND SSPD.SC_CODE IN("+scCodeIn+") " + 

					"AND ACCT_PRD=? GROUP BY SSPD.FIN_ENTITY,SSPD.SC_CODE " ;

			

			pstmt = connectionObject.prepareStatement(valueSumSql);

			pstmt.setString( 1, acctCode);			

			rs = pstmt.executeQuery();

			while(rs.next())

			{

				String finentity=checkNull(rs.getString("FIN_ENTITY"));

				String scCode=checkNull(rs.getString("SC_CODE"));

				int sumAprvvalue=rs.getInt("SUM_APRV_VALUE");

				String mapKey=scCode+"@"+finentity;



				if(scCodeCntMap.containsKey(mapKey))

				{

					//int custCount=(int) scCodeCntMap.get(scCode);

					//if(custCount>0)

					//{

					String UpdateStrgSum = "UPDATE STRG_SAMP_PLAN_SUM SET PLAN_VALUE = ?,PLAN_UNCONF=? WHERE SC_CODE=? AND ACCT_PRD=? AND FIN_ENT=? ";

					updatePstmt = connectionObject.prepareStatement(UpdateStrgSum);

					updatePstmt.setInt(1,sumAprvvalue);

					updatePstmt.setString(2,"P");

					updatePstmt.setString(3,scCode);

					updatePstmt.setString(4,acctCode);

					updatePstmt.setString(5,finentity);



					int UpdateStrgSumCnt = updatePstmt.executeUpdate();

					if ( updatePstmt != null )

					{

						updatePstmt.close();

						updatePstmt = null;

					}



					System.out.println("UpdateStrgSumCnt for update::::["+UpdateStrgSumCnt+"]");

				}

				else

				{

					String insertStrgSampleSumSql = "INSERT INTO STRG_SAMP_PLAN_SUM ( ACCT_PRD , SC_CODE , PLAN_VALUE , PLAN_UNCONF,FIN_ENT ) VALUES (? , ? , ?, ?,?  )";



					updatePstmt = connectionObject.prepareStatement(insertStrgSampleSumSql);

					updatePstmt.setString(1,acctCode);

					updatePstmt.setString(2,scCode);

					updatePstmt.setInt(3,sumAprvvalue);

					updatePstmt.setString(4,"P");

					updatePstmt.setString(5,finentity);



					int UpdateStrgSumCnt = updatePstmt.executeUpdate();

					if ( updatePstmt != null )

					{

						updatePstmt.close();

						updatePstmt = null;

					}

					System.out.println("UpdateStrgSumCnt for insert::::["+UpdateStrgSumCnt+"]");



				}

					

				//}



			}



			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}

			



			

			

			

		

		}

		catch (Exception e)

		{

			

			e.printStackTrace();

			throw new ITMException(e);

		}

		finally

		{

			try

			{

				if( rs != null )

				{

					rs.close();

					rs = null;

				}

				if(pstmt != null )

				{

					pstmt.close();

					pstmt = null;

				}

				if(updatePstmt != null )

				{

					updatePstmt.close();

					updatePstmt = null;

				}

			



			}

			catch(Exception e)

			{

				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());

			}

		}

	}

	public void insertIntoTraceTable(String tranID,String acctCode ,String periodCode,Connection connectionObject) throws Exception

	{







		System.out.println("Inside SprsSamplePlanReject()....." );

		PreparedStatement pstmt = null;

		ResultSet rs = null;

		PreparedStatement updatePstmt=null;

		try

		{

			

			String prdCode[]=periodCode.split("-");

			String prCode=prdCode[0];

			System.out.println("periodCode::::"+prCode);

			ArrayList<String> temp = new ArrayList<String>();

			String prdCodeIn="";

			

			String prdQtrSql ="SELECT DISTINCT PRD_QTR FROM PERIOD  WHERE " + 

					"FR_DATE >= (SELECT FR_DATE FROM ACCTPRD WHERE CODE=?) AND " + 

					"TO_DATE<=(SELECT FR_DATE-1 FROM PERIOD WHERE CODE=?) ";

			pstmt = connectionObject.prepareStatement(prdQtrSql);

			pstmt.setString( 1, acctCode);	

			pstmt.setString( 2, prCode);			



			rs = pstmt.executeQuery();

			while(rs.next())

			{

				String prdQtr=checkNull(rs.getString("PRD_QTR"));

				temp.add(prdQtr);

			}

			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}

			OrgStructure orgStructure = new OrgStructure();

			prdCodeIn=orgStructure.getFormattedList(temp);



			String sql ="SELECT SSPD.FIN_ENTITY,SSP.PRD_QTR,SSPD.SC_CODE,SSPD.LINE_NO,SSP.SALES_PERS,SSPD.ITEM_CODE,SSPD.APRV_VALUE FROM  " + 

					"SPRS_SAMP_PLAN SSP,SPRS_SAMP_PLAN_DET SSPD  " + 

					"WHERE SSP.TRAN_ID=SSPD.TRAN_ID AND SSP.TRAN_ID=? ";

			

			pstmt = connectionObject.prepareStatement(sql);

			pstmt.setString( 1, tranID);			

			rs = pstmt.executeQuery();

			while(rs.next())

			{

				

				

				String finentity=checkNull(rs.getString("FIN_ENTITY"));

				String prdQtr=checkNull(rs.getString("PRD_QTR"));

				String scCode=checkNull(rs.getString("SC_CODE"));

				String lineNo=checkNull(rs.getString("LINE_NO"));

				String salesPers=checkNull(rs.getString("SALES_PERS"));

				String itemCode=checkNull(rs.getString("ITEM_CODE"));

				int effValue=rs.getInt("APRV_VALUE");



				int beforeValue=0;

				String Prevsql ="SELECT SUM(SSPD.APRV_VALUE) AS APRV_VALUE  FROM SPRS_SAMP_PLAN SSP,SPRS_SAMP_PLAN_DET SSPD WHERE SSP.TRAN_ID=SSPD.TRAN_ID  " + 

						"AND SSPD.SC_CODE=? AND SSPD.ITEM_CODE=? AND SSP.ACCT_PRD=? AND SSP.PRD_QTR IN("+prdCodeIn+") AND SSP.SALES_PERS=? ";

				PreparedStatement pstmt1 = connectionObject.prepareStatement(Prevsql);

				pstmt1.setString( 1, scCode);		

				pstmt1.setString( 2, itemCode);			

				pstmt1.setString( 3, acctCode);			

				pstmt1.setString( 4, salesPers);			



				ResultSet rs1 = pstmt1.executeQuery();

				if(rs1.next())

				{

					beforeValue=rs.getInt("APRV_VALUE");



				}

				if(rs1 != null)

				{

					rs1.close();

					rs1 = null;

				}

				if(pstmt1 != null)

				{

					pstmt1.close();

					pstmt1 = null;

				}

				String tranIDS=generateTranID(connectionObject);

				int afterValue=beforeValue+effValue;

				String itemSer=getItemSer(salesPers,connectionObject);

				String insertStrgSampleSumSql = "INSERT INTO STRG_SAMP_PLAN_TRACE "

						+ "( TRAN_ID , FIN_ENT , PRD_QTR , SC_CODE,REF_SER,REF_ID,REF_LINE_NO,SALES_PERS,ITEM_SER,ITEM_CODE,TRAN_TYPE,VALIE_BEF,VALUE_EFF,VALUE_AFTER ) VALUES (? , ? , ?, ?,?,?,?,?,?,?,?,?,?,?  )";

				

				 updatePstmt = connectionObject.prepareStatement(insertStrgSampleSumSql);

				updatePstmt.setString(1,tranIDS);

				updatePstmt.setString(2,finentity);

				updatePstmt.setString(3,prdQtr);

				updatePstmt.setString(4,scCode);

				updatePstmt.setString(5,"S-PLN");

				updatePstmt.setString(6,tranID);

				updatePstmt.setString(7,lineNo);

				updatePstmt.setString(8,salesPers);

				updatePstmt.setString(9,itemSer);

				updatePstmt.setString(10,itemCode);

				updatePstmt.setString(11,"P");

				updatePstmt.setInt(12,beforeValue);

				updatePstmt.setInt(13,effValue);

				updatePstmt.setInt(14,afterValue);







				int UpdateStrgSumCnt = updatePstmt.executeUpdate();

				if ( updatePstmt != null )

				{

					updatePstmt.close();

					updatePstmt = null;

				}

				System.out.println("UpdateStrgSumCnt for insert::::["+UpdateStrgSumCnt+"]");

				

			}



			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}

			

			

			

			

		}

		catch (Exception e)

		{

			

			e.printStackTrace();

			throw new ITMException(e);

		}

		finally

		{

			try

			{

				if( rs != null )

				{

					rs.close();

					rs = null;

				}

				if(pstmt != null )

				{

					pstmt.close();

					pstmt = null;

				}

				if(updatePstmt != null )

				{

					updatePstmt.close();

					updatePstmt = null;

				}

			



			}

			catch(Exception e)

			{

				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());

			}

		}

	

	}

	public String getItemSer(String salesPers,Connection conn)

	{

		PreparedStatement pstmt = null;

		ResultSet rs = null;

		String itemSer="";

		try

		{

			String sql="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS=?";

			pstmt = conn.prepareStatement(sql);

			pstmt.setString(1, salesPers);

			rs = pstmt.executeQuery();

			if(rs.next())

			{

				itemSer = checkNull(rs.getString("ITEM_SER"));

			}

			if (rs!= null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt!=null)

			{

				pstmt.close();

				pstmt = null;

			}



		}

		catch(Exception e)

		{

			e.printStackTrace();

		}

		finally

		{



			try

			{

				if (rs!= null)

				{

					rs.close();

					rs = null;

				}

				if(pstmt!=null)

				{

					pstmt.close();

					pstmt = null;

				}

			}

			catch(Exception e)

			{

				e.printStackTrace();

			}



		}

		return itemSer;

	}

	public String checkNull(String input)

	{

		if (input == null || "null".equalsIgnoreCase(input))

		{

			input= "";

		}

		return input.trim();

	}

	

	private String generateTranID( Connection conn ) throws ITMException

	{

		String uniqueKey = null;

		PreparedStatement pstmt = null;

		ResultSet rs = null;

		try

		{

			//System.out.println("RealTimeReportPos : Generating Primary Key ...........");



			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_strg_samp_plan_trace' ";

			pstmt = conn.prepareStatement(keyStringQuery);

			rs = pstmt.executeQuery();



			if(rs.next())

			{

				String keyString = rs.getString("KEY_STRING");

				String keyCol = rs.getString("TRAN_ID_COL");

				String tranSer = rs.getString("REF_SER");

				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";

				xmlValues = xmlValues + "<Header></Header>";

				xmlValues = xmlValues + "<Detail1>";

				xmlValues = xmlValues +        "<tran_id></tran_id>";

				xmlValues = xmlValues + "</Detail1></Root>";

				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);

				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);

			}

			rs.close();	rs = null;

			pstmt.close();

			pstmt = null;

		}

		catch(Exception exp)

		{

			System.out.println("Exception : RealTimeReportPos :generateTransID :==>\n");

			throw new ITMException(exp);

		}

		finally

		{

			try

			{

				if(rs != null)

				{

					rs.close();

					rs = null;

				}

				if(pstmt != null)

				{

					pstmt.close();

					pstmt = null;

				}

			}

			catch (Exception e)

			{

				System.out.println("Exception : RealTimeReportPos :getUniqueKey :finally==>");

				throw new ITMException(e);

			}

		}

		System.out.println("Generated Primary Key :"+uniqueKey);

		return uniqueKey;

	}

	

	public String SprsSampSaveAprrovalData(String tranID, String periodCode, String salesPers,String acctPrd,String userInfostr,String xmlString,String refSer,String signByRoleCode) throws ITMException

	{

		System.out.println("Inside SprsSampSaveAprrovalData() :::::::::" );



		String retString = "YES";

		PreparedStatement pstmt = null;

		ResultSet rs = null;

		ConnDriver connDriver = null;

		Connection conn = null;

		Document dom = null;

		PreparedStatement instPstmt=null;

		PreparedStatement updatePstmt=null;



		boolean isError = false;

		NodeList parentNodeList = null;

		//Node parentNode = null;

		NodeList childNodeList = null;

		int childNodeListLength = 0;

		Node childNode = null;

		String childNodeName = "";

		HashMap<String,String> chgAprvQtyMap=new HashMap<String,String>();



		try

		{

			

			E12GenericUtility genericUtility = new E12GenericUtility();

			UserInfoBean userInfo = new UserInfoBean(userInfostr);

			if( userInfo != null && userInfo.getTransDB() != null )

			{

				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );

				connDriver = new ConnDriver();

				conn = connDriver.getConnectDB(transDB);

			}

			conn.setAutoCommit(false);

			connDriver = null;





			HashMap<String,String> detQtyMap=new HashMap<String,String>();

			String detSql = "SELECT SC_CODE,ITEM_CODE,APRV_QTY FROM SPRS_SAMP_PLAN_DET WHERE TRAN_ID=?  ";

			pstmt = conn.prepareStatement(detSql);

			pstmt.setString(1, tranID);

			rs = pstmt.executeQuery();



			while(rs.next())

			{

				String scCode = checkNull(rs.getString("SC_CODE"));

				String itemCode = checkNull(rs.getString("ITEM_CODE"));

				String aprvQty = checkNull(rs.getString("APRV_QTY"));



				

				String customerItem=scCode+"@"+itemCode;

				detQtyMap.put(customerItem, aprvQty);

			}



			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}



			int lineNo=0;

			String maxLinesql = "SELECT MAX(LINE_NO) AS LINENO FROM SPRS_SAMP_PLAN_DET WHERE TRAN_ID=?  ";

			pstmt = conn.prepareStatement(maxLinesql);

			pstmt.setString(1, tranID);

			rs = pstmt.executeQuery();



			if(rs.next())

			{

				lineNo = rs.getInt("LINENO");

			}



			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}

			int linenumber=lineNo+1;

			



			String dataStr="";

			String query = "SELECT OST.TRANS_INFO_XML.GETCLOBVAL() from OBJ_SIGN_TRANS OST where REF_SER = ? and REF_ID = ? AND ROLE_CODE__SIGN =?";

			pstmt = conn.prepareStatement(query);

			pstmt.setString(1, refSer);

			pstmt.setString(2, tranID);

			pstmt.setString(3, signByRoleCode);

			rs = pstmt.executeQuery();

			if (rs.next())

			{

				dataStr = (rs.getString(1) == null) ?"":rs.getString(1);

			}



			if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</DocumentRoot>") != -1)

			{

				dataStr = dataStr.substring(0, dataStr.indexOf("</DocumentRoot>") + 15);

			}

			else if (dataStr != null && dataStr.length() > 0 && dataStr.indexOf("</Root>") != -1)

			{

				dataStr = dataStr.substring(0, dataStr.indexOf("</Root>") + 7);

			}

			if(rs != null)

			{

				rs.close();

				rs = null;

			}

			if(pstmt != null)

			{

				pstmt.close();

				pstmt = null;

			}

			if(dataStr != null && dataStr.trim().length()!=0)

			{

				dom = genericUtility.parseString(dataStr); 

			}

			parentNodeList = dom.getElementsByTagName("Detail3");

			int parentNodeListLength = parentNodeList.getLength();



			if(parentNodeListLength > 0)

			{



				for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)

				{



					Node parentNode = parentNodeList.item(selectedRow);

					String recChg = "";

					if(parentNode.getAttributes().getNamedItem("isChg") != null)

					{

						recChg = parentNode.getAttributes().getNamedItem("isChg").getNodeValue();

					}





					if(recChg != null && recChg.equals("1"))

					{



						childNodeList = parentNode.getChildNodes();

						childNodeListLength = childNodeList.getLength();

						String strgCode="",itemCodeDetail="",aprvQtr="",rate="",finEntity="",siteCode="";

						for (int childRow = 0; childRow < childNodeListLength; childRow++)

						{

							childNode = childNodeList.item(childRow);

							childNodeName = childNode.getNodeName();

							if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("sc_code") )

							{



								strgCode = childNode.getFirstChild().getNodeValue();





							}

							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("item_code") )



							{

								itemCodeDetail = childNode.getFirstChild().getNodeValue();



							}

							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("aprv_qty") )

							{

								aprvQtr = childNode.getFirstChild().getNodeValue();

								



							}

							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("rate") )

							{

								rate = childNode.getFirstChild().getNodeValue();



							}

							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("fin_entity") )

							{

								finEntity = childNode.getFirstChild().getNodeValue();



							}

							else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("site_code") )

							{

								siteCode = childNode.getFirstChild().getNodeValue();



							}



						}

						String custCompareItem=checkNull(strgCode)+"@"+checkNull(itemCodeDetail);

						System.out.println("aprvQtr ==="+aprvQtr);

						if(aprvQtr == null || aprvQtr.trim().length() == 0)

						{

							aprvQtr="0";

						}

						System.out.println("aprvQtr === :: "+aprvQtr);

						if(aprvQtr!=null && aprvQtr.trim().length()>0)

						{

							if(detQtyMap.containsKey(custCompareItem))

							{

								String  approveQuantity=detQtyMap.get(custCompareItem);

								if(approveQuantity!=aprvQtr)

								{

									double quantity=0, rateDetail=0, value=0;

									quantity=Double.parseDouble(checkNull(aprvQtr));

									rateDetail=Double.parseDouble(checkNull(rate));



									value=quantity*rateDetail;

									

									String updateStrgBrandAct = "UPDATE SPRS_SAMP_PLAN_DET SET APRV_QTY = ?,APRV_VALUE=? WHERE TRAN_ID=? AND SC_CODE=? AND ITEM_CODE=? ";

									updatePstmt = conn.prepareStatement(updateStrgBrandAct);

									updatePstmt.setString(1,aprvQtr);

									updatePstmt.setDouble(2,value);

									updatePstmt.setString(3,tranID);

									updatePstmt.setString(4,strgCode);

									updatePstmt.setString(5,itemCodeDetail);



									int updateStrgBrandActCnt = updatePstmt.executeUpdate();



									//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]

									if ( updatePstmt != null )

									{

										updatePstmt.close();

										updatePstmt = null;

									}

								}

							}

							else

							{

								double quantity=0, rateDetail=0, value=0;

								quantity=Double.parseDouble(checkNull(aprvQtr));

								rateDetail=Double.parseDouble(checkNull(rate));

								value=quantity*rateDetail;

								if(quantity>0)

								{





									String insSql="INSERT INTO SPRS_SAMP_PLAN_DET(TRAN_ID,LINE_NO,SC_CODE,SITE_CODE,FIN_ENTITY,ITEM_CODE,RATE,APRV_QTY,APRV_VALUE) " +

									" VALUES (?,?,?,?,?,?,?,?,?)";

									instPstmt = conn.prepareStatement(insSql);

									instPstmt.setString(1,tranID);

									instPstmt.setInt(2,linenumber);

									instPstmt.setString(3,strgCode);

									instPstmt.setString(4,siteCode);

									instPstmt.setString(5,finEntity);

									instPstmt.setString(6,itemCodeDetail);

									instPstmt.setString(7,rate);

									instPstmt.setString(8,aprvQtr);

									instPstmt.setDouble(9,value);





									int instStrgBrandActCnt = instPstmt.executeUpdate();



									//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]

									if ( instPstmt != null )

									{

										instPstmt.close();

										instPstmt = null;

									}

									linenumber++;

								}



							}

						}

					}

					

					

				}

			}

			

			

			

		}

		catch (Exception e)

		{

			retString = "NO";

			isError = true;

			try

			{

				conn.rollback();

			}

			catch(Exception ee)

			{



			}

			e.printStackTrace();

			throw new ITMException(e);

		}

		finally

		{

			try

			{



				if(rs != null)

				{

					rs.close();

					rs = null;

				}

				if(pstmt != null)

				{

					pstmt.close();

					pstmt = null;

				}

				if(updatePstmt != null)

				{

					updatePstmt.close();

					updatePstmt = null;

				}

				if(instPstmt != null)

				{

					instPstmt.close();

					instPstmt = null;

				}

			

				if(conn != null )

				{

					if(!isError)

					{

						conn.commit();

					}

					conn.close();

					conn = null;

				}



			}

			catch(Exception e)

			{

				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());

			}

		}



		return retString;

	}

	

}



