package ibase.webitm.ejb.wsfa.masters;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.JSONArray;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wsfa.ExceptionUtility;

public class SellsStock
{
	private E12GenericUtility genericUtility = new E12GenericUtility();
	private ExceptionUtility excpUtility = new ExceptionUtility();
	private String DATE_FORMAT = "dd-MMM-yyyy";

	public String getFirstFormItemChange( String columnName, String columnValue, String paramValue, UserInfoBean userInfoBean ) throws ITMException
	{
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String transDB = userInfoBean.getTransDB();
		String sql = "", userCode = "",loginEmpCode = "",terrCode = "",terrDescr = "";
		String prdCode = "", fromDate = "";
		JSONObject jsonObject = new JSONObject();
		JSONArray jsonArray = new JSONArray();
		try
		{
			conn = connDriver.getConnectDB(transDB);
			userCode = checkNull(userInfoBean.getLoginCode()).trim();
			loginEmpCode = checkNull(userInfoBean.getEmpCode()).trim();
			System.out.println("userCode :("+userCode +")"+"loginEmpCode :("+loginEmpCode+")");

			//InetAddress ownIP=InetAddress.getLocalHost();
			//chgTerm = ownIP.getHostAddress();

			System.out.println("columnName :("+columnName +")"+"columnValue :("+columnValue+") paramValue ("+ paramValue +")");
			paramValue = checkNull( paramValue );
			/*if( paramValue.contains( "," ) )
			{
				paramValue = paramValue.replace(",", "','");
			}*/

			if("terr_code".equalsIgnoreCase(columnName))
			{
				sql ="SELECT FN_GET_TERRITORY(?,?) AS TERR_CODE FROM DUAL";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, userCode);
				pStmt.setString(2, loginEmpCode);
				rs = pStmt.executeQuery();
				if(rs.next())
				{
					terrCode = rs.getString("TERR_CODE");
					jsonObject.put("terr_code", terrCode);
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}

				sql = "SELECT DESCR FROM STATION WHERE STAN_CODE = ?";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, terrCode);
				rs = pStmt.executeQuery();
				while(rs.next())
				{
					terrDescr = rs.getString("DESCR");
					jsonObject.put("territory_descr", terrDescr);
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			else if("sp_name".equalsIgnoreCase(columnName))
			{
				/*
				sql = "SELECT SC_CODE FROM STRG_CUSTOMER WHERE FIRST_NAME = ?";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, columnValue);
				rs = pStmt.executeQuery();
				if(rs.next())
				{
					scCode = rs.getString("SC_CODE");
					jsonObject.put("sc_code", scCode);
				}
				sql = "";
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				*/

				org.json.simple.JSONObject  jsonOBJ = new org.json.simple.JSONObject();;
				sql = "  SELECT ITEMSER.ITEM_SER ,ITEMSER.DESCR, COUNT(ITEMSER.ITEM_SER ) AS NO_OF_SALE_PERSON " +
					  "  FROM  SALES_PERS LEFT OUTER JOIN ITEMSER ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER " +
					  "  WHERE SALES_PERS.SALES_PERS IN (SELECT DISTINCT EMP_CODE " +
					  "  FROM ORG_STRUCTURE WHERE POOL_CODE IN (SELECT POOL_CODE FROM ORG_STRUCTURE " +
					  "  WHERE EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE = ? ))) AND ACTIVE_YN = ? GROUP BY ITEMSER.ITEM_SER ,ITEMSER.DESCR ";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, loginEmpCode);
				pStmt.setString(2, "Y");
				rs = pStmt.executeQuery();
				while(rs.next())
				{
					jsonOBJ.put(checkNull(rs.getString("DESCR")), checkNull(rs.getString("NO_OF_SALE_PERSON")));
				}
				jsonObject.put("DIVISION", jsonOBJ);
				jsonOBJ = null;

			}
			else if("prd_code_descr".equalsIgnoreCase(columnName))
			{
				sql = "SELECT CODE,FR_DATE FROM PERIOD WHERE SH_DESCR = ?";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1,columnValue);
				rs = pStmt.executeQuery();
				if(rs.next())
				{
					prdCode = rs.getString("CODE");
					fromDate = rs.getString("FR_DATE");
					jsonObject.put("prd_code", prdCode);
					jsonObject.put("from_date", fromDate);
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if( ! paramValue.equalsIgnoreCase( "null" ) )
				{
					getMgrData( loginEmpCode, paramValue, prdCode, jsonObject, conn );
				}
			}
			else if("pos_code_descr".equalsIgnoreCase(columnName))
			{
				String posCode = "", standCodeHq = "";
				int levelNo= 0;
				if ( columnValue.contains( "," ) )
				{
					columnValue = columnValue.replaceAll( ",", "','" );
				}
				sql = "SELECT LISTAGG(O1.POS_CODE, ',') WITHIN GROUP (ORDER BY O1.POS_CODE) POS_CODE, "
						+ " LISTAGG(O1.STAN_CODE__HQ, ',') WITHIN GROUP (ORDER BY O1.STAN_CODE__HQ) STAN_CODE__HQ, "
						+ " O1.LEVEL_NO "
						+ " FROM ORG_STRUCTURE O1 "
						+ " WHERE DESCR IN ( '"+ columnValue +"' ) "
						+ "GROUP BY O1.LEVEL_NO";
				pStmt = conn.prepareStatement(sql);
				//pStmt.setString(1,columnValue);
				rs = pStmt.executeQuery();
				if ( rs.next() )
				{
					posCode = rs.getString("POS_CODE");
					standCodeHq = rs.getString("STAN_CODE__HQ");

					levelNo = rs.getInt("level_no");
					jsonObject.put("pos_code", posCode);
					jsonObject.put("stan_code_hq", standCodeHq);
					//jsonObject.put("level_no", levelNo);
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}

				boolean isMgr = isPlanningMgr( posCode, conn );
				/*if ( ! isMgr )
				{
					levelNo = 8;
					jsonObject.put("level_no", levelNo);
				}*/
				jsonObject.put( "is_mgr", isMgr );

				if( ! paramValue.equalsIgnoreCase( "null" ) )
				{
					getMgrData( loginEmpCode, posCode, paramValue, jsonObject, conn );
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("SellStocks.getOnItemChange()"+e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e) {
				System.out.println("SellsStock.getFirstFormItemChange()"+e);
			}
		}
		jsonArray.add(jsonObject);
		return jsonArray.toString();
	}

	public String getFirstFormValidation(String columnName,String columnValue,UserInfoBean userInfoBean)
	{
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String transDB = userInfoBean.getTransDB();
		String sql ="",userCode ="",loginEmpCode = "",validTerrCode ="",custCode = "",fromDateStr = "",errSting = "";
		JSONObject jsonObject = new JSONObject();
		Timestamp fromDate = null,toDateTs = null;
		int count = 0;
		JSONArray jsonArray = new JSONArray();
		try
		{
			System.out.println("columnName["+columnName+"]  columnValue["+columnValue+"]");
			userCode = userInfoBean.getLoginCode();
			loginEmpCode = userInfoBean.getEmpCode();
			conn = connDriver.getConnectDB(transDB);

			String custType = getCustType( conn );

			if("sc_code".equalsIgnoreCase(columnName))
			{
				if(columnValue == null || columnValue.trim().length() == 0)
				{
					errSting = genericUtility.getErrorString("sc_code", "VTCUSTNULL", userCode);
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
				}
				else
				{
					sql = "SELECT COUNT(1) FROM STRG_CUSTOMER WHERE CUST_TYPE = ? AND SC_CODE = ?";
					pStmt = conn.prepareStatement(sql);
					pStmt.setString(1, custType);
					pStmt.setString(2, columnValue);
					rs = pStmt.executeQuery();
					if(rs.next())
					{
						count = (rs.getInt(1));
						System.out.println("count   "+count);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if( count < 1)
					{
						//errSting = genericUtility.getErrorString("sc_code", "VTINVCUSTN", userCode);
						errSting = genericUtility.getErrorString("sc_code", "VMCUSTCDX", userCode);
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					}
					jsonArray.add(jsonObject);
					return jsonArray.toString();
				}
			}
			else if("prd_code_descr".equalsIgnoreCase(columnName))
			{
				if(columnValue == null || columnValue.trim().length() == 0)
				{
					errSting = genericUtility.getErrorString("prd_code_descr", "VPATDPRC01", userCode);
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
				}
				else
				{
					sql = "SELECT COUNT(1) FROM PERIOD WHERE SH_DESCR = ?";
					pStmt = conn.prepareStatement(sql);
					pStmt.setString(1, columnValue);
					rs = pStmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					if(count == 0)
					{
						errSting = genericUtility.getErrorString("prd_code_descr", "INVPRDCD", userCode);
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					}
				}
				jsonArray.add(jsonObject);
				return jsonArray.toString();
			}
			else if("from_date".equalsIgnoreCase(columnName))
			{
				fromDateStr = columnValue;
				if(columnValue.length() <= 0 )
				{
					errSting = genericUtility.getErrorString("from_date", "VPSHFTCH03", userCode);
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
				}
				else
				{
					fromDate = Timestamp.valueOf(genericUtility.getValidDateString(columnValue,DATE_FORMAT,genericUtility.getDBDateFormat())
							+ " 00:00:00.0");
					if(fromDate == null)
					{
						errSting = genericUtility.getErrorString("from_date", "INVAFRDATE", userCode);
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					}
				}
			}
			else if("to_date".equalsIgnoreCase(columnName))
			{
				try
				{
					System.out.println("Date Info      :: "+columnValue);
					JSONObject dateInfo = new JSONObject(columnValue);
					fromDateStr = dateInfo.getString("from_date");
					String toDateStr = checkNull(dateInfo.getString("to_date"));
					//Added by Pooja S on 20-JUL-2020 [date issue on server side take the previous date] start
					fromDateStr = new Date(fromDateStr.substring(0, 16)).toString();
					toDateStr = new Date(toDateStr.substring(0, 16)).toString();
					//Added by Pooja S on 20-JUL-2020 [date issue on server side take the previous date] End
					System.out.println("#  fromDateStr    ["+fromDateStr+"]   #toDateStr["+toDateStr+"]");

					if("".equalsIgnoreCase(toDateStr))
					{
						errSting = genericUtility.getErrorString("from_date", "VTTODTNULL", userCode);
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					}
					else
					{
						//SimpleDateFormat input = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
						//Changed by Pooja S on 20-JUL-2020 [date issue on server side take the previous date]
						SimpleDateFormat input = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
						//SimpleDateFormat output = new SimpleDateFormat(CommonConstants.APPL_DATE_FORMAT);
						SimpleDateFormat output = new SimpleDateFormat(DATE_FORMAT);

						Date frDate = null;
						Date toDate = null;

						try
						{
							frDate = input.parse(fromDateStr);
							toDate = input.parse(toDateStr);
							System.out.println("frDate ["+frDate+"], toDate ["+ toDate +"]" );
						}
						catch (Exception e)
						{
							e.printStackTrace();
						}
						fromDateStr = output.format(frDate);
						toDateStr = output.format(toDate);
						//Added by Amey W. [to_date should not be greater than today] on 02-07-2020
						String currentDateStr = output.format(new Date());

						Timestamp fromDtTStmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(fromDateStr,DATE_FORMAT,genericUtility.getDBDateFormat()) + " 00:00:00.00");
						Timestamp toDtTStmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(toDateStr,DATE_FORMAT,genericUtility.getDBDateFormat()) + " 00:00:00.00");
						Timestamp currentDtStamp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(currentDateStr,DATE_FORMAT,genericUtility.getDBDateFormat()) + " 00:00:00.00");

						if( toDtTStmp.before(fromDtTStmp) )
						{
							errSting = genericUtility.getErrorString("to_date", "VTTODTINVA", userCode);
							jsonObject = excpUtility.convertXmlToJsonInError(errSting);
						}
						//Added by Amey W. [to_date should not be greater than today] on 02-07-2020 START
						else if( toDtTStmp.after(currentDtStamp) )
						{
							errSting = genericUtility.getErrorString("to_date", "VTTODTINTD", userCode);
							jsonObject = excpUtility.convertXmlToJsonInError(errSting);
						}
						//Added by Amey W. [to_date should not be greater than today] on 02-07-2020 END
						else
						{
							//Added by Pooja 20-06-2020 [allow to_date from same period] START
							Calendar fromDtCalendar = Calendar.getInstance();
							fromDtCalendar.setTime( frDate );
							fromDtCalendar.set( Calendar.DAY_OF_MONTH, fromDtCalendar.getActualMaximum( Calendar.DAY_OF_MONTH ) );
							Date lastDateOfMonth = fromDtCalendar.getTime();
							
							System.out.println( "lastDateOfMonth ["+ lastDateOfMonth +"]" );
							String lastDtOfMonth = output.format( lastDateOfMonth );
							Timestamp currentDtTStmp = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( lastDtOfMonth, DATE_FORMAT, genericUtility.getDBDateFormat() ) + " 00:00:00.00" );
							if( toDtTStmp.after( currentDtTStmp ) )
							{
								errSting = genericUtility.getErrorString( "to_date", "VTTODTCRT", userCode );
								jsonObject = excpUtility.convertXmlToJsonInError(errSting);
							}
							//Added by Pooja 20-06-2020 [allow to_date from same period] END
							//Added by Ravindra on 26/10/2020 [to_date validation for Friday and last day of previous month] START
							else
							{
								Calendar toMthCalendar = Calendar.getInstance();
								toMthCalendar.setTime( toDate );
								int dayOfWeek = toMthCalendar.get(Calendar.DAY_OF_WEEK);
								
								Calendar currMthCalendar = Calendar.getInstance();
								currMthCalendar.setTime( new Date() );
								int fromMonth = fromDtCalendar.get(Calendar.MONTH);
								int toMonth = fromDtCalendar.get(Calendar.MONTH);
								int currMonth = currMthCalendar.get(Calendar.MONTH);
								System.out.println( "fromMonth ["+ fromMonth +"], toMonth ["+ toMonth +"], currMonth ["+ currMonth +"]" );
								System.out.println( "lastDtOfMonth ["+ lastDtOfMonth +"], toDateStr ["+ toDateStr +"]" );
								
								if ( toMonth == currMonth && dayOfWeek != 6 )
								{
									errSting = genericUtility.getErrorString( "to_date", "INVTODTDAY", userCode );
									jsonObject = excpUtility.convertXmlToJsonInError(errSting);
								}
								else if ( fromMonth != currMonth && ! lastDtOfMonth.equalsIgnoreCase( toDateStr ) )
								{
									errSting = genericUtility.getErrorString( "to_date", "INVTODTMTH", userCode );
									jsonObject = excpUtility.convertXmlToJsonInError(errSting);
								}
							}
							//Added by Ravindra on 26/10/2020 [to_date validation for Friday and last day of previous month] END
						}
					}
				}
				catch (Exception e)
				{
					System.out.println("Exception on itemchange of to_date     "+e.getMessage());
				}

				jsonArray.add(jsonObject);
				return jsonArray.toString();
			}
			else if("all_form_validation".equalsIgnoreCase(columnName))
			{
				System.out.println("Inside  allFormValidation .................");
				JSONObject allFormData = new JSONObject(columnValue);
				String str = "";
				Iterator keys = allFormData.keys();
				while (keys.hasNext())
				{
					String colName = (String) keys.next();
					if("to_date".equalsIgnoreCase(colName))
					{
						JSONObject dateObj = (JSONObject) allFormData.get(colName);
						str = checkNull(getFirstFormValidation(colName,dateObj.toString(), userInfoBean));
					}
					else
					{
						String colValue = allFormData.getString(colName);
						System.out.println("Calling validation with ["+colName+"]  colValue["+colValue+"]");
						str = checkNull(getFirstFormValidation(colName, colValue, userInfoBean));
					}
					org.json.JSONArray jsArr = new org.json.JSONArray(str);
					JSONObject object = (JSONObject) jsArr.get(0);
					System.out.println(object.length());
					if(object.length() > 0)
					{
						return str;
					}
				}
				return str;
			}
			else if("pos_code_descr".equalsIgnoreCase(columnName))
			{
				if(columnValue == null || columnValue.trim().length() == 0)
				{
					errSting = genericUtility.getErrorString("pos_code_descr", "VTNLLPOSCD", userCode);
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
				}
				else
				{
					if(columnValue.contains(","))
					{
						columnValue = columnValue.replace(",", "','");
					}
					sql = " SELECT COUNT(1) FROM ORG_STRUCTURE WHERE DESCR IN ( '"+ columnValue +"' )";
					pStmt = conn.prepareStatement(sql);
					rs = pStmt.executeQuery();
					rs = pStmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}

					if(count == 0)
					{
						errSting = genericUtility.getErrorString("pos_code_descr", "VTTERRCD", userCode);
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
				}
			}
			else if("stan_code".equalsIgnoreCase(columnName))
			{
				if(columnValue == null || columnValue.trim().length() == 0)
				{
					errSting = genericUtility.getErrorString("stan_code", "VTNLLSTNCD", userCode);
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
				}
				else
				{
					if( columnValue.contains(",") )
					{
						columnValue = columnValue.replace(",", "','");
					}
					sql = " SELECT COUNT(1) FROM ORG_STRUCTURE WHERE STAN_CODE__HQ IN ( '"+ columnValue +"' )";
					pStmt = conn.prepareStatement(sql);
					rs = pStmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}

					if(count == 0)
					{
						errSting = genericUtility.getErrorString("stan_code", "VTSTNCDINV", userCode);
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
				}
			}
			else if("pos_code".equalsIgnoreCase(columnName))
			{
				if(columnValue == null || columnValue.trim().length() == 0)
				{
					errSting = genericUtility.getErrorString("pos_code", "VTNLLPOSCD", userCode);
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
				}
				else
				{
					if( columnValue.contains(",") )
					{
						columnValue = columnValue.replace(",", "','");
					}
					sql = " SELECT COUNT(1) FROM ORG_STRUCTURE WHERE POS_CODE IN ( '"+ columnValue+"' )";
					pStmt = conn.prepareStatement(sql);
					rs = pStmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}

					if(count == 0)
					{
						errSting = genericUtility.getErrorString("pos_code", "NOPOS", userCode);
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.getFirstFormValidation() Exception "+e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e) {

			}
		}
		jsonArray.add(jsonObject);
		System.out.println("Return Validation Data  "+jsonArray.toString());
		return jsonArray.toString();
	}
	
	//public String getSellsStockData( String stanCode, String posCode, String scCode, String prdCode, String fromDateStr, String toDateStr, String forceSave, UserInfoBean userInfoBean )
	public String getSellsStockData( String data, UserInfoBean userInfoBean )
	{
		System.out.println( "Inside getSellsStockData................... :: ["+ data +"]");
		String stanCode = "",  posCode = "",  scCode = "",  prdCode = "",  fromDateStr = "",  toDateStr = "",  forceSave ="";
		ConnDriver connDriver = new ConnDriver();
		Connection con = null;
		PreparedStatement pStmt = null;
		PreparedStatement orgPstmt = null;
		ResultSet rs = null, orgRs = null;
		String transDB = userInfoBean.getTransDB();

		JSONArray columnArray = new org.json.simple.JSONArray();
		JSONArray tempArr = new org.json.simple.JSONArray();
		double sellInVal = 0 ;
		int salesPersCnt = 0,cnt = 0;

		ArrayList<String> itmCodeArr = new ArrayList<String>();
		ArrayList<String> itmDescrArr = new ArrayList<String>();
		ArrayList<String> itmMktArr = new ArrayList<String>();
		ArrayList<String> sellInQtyArr = new ArrayList<String>();
		ArrayList<String> sellInValArr = new ArrayList<String>();

		//ArrayList<String> sellInQtyMthArr = new ArrayList<String>();
		//ArrayList<String> sellInValMthArr = new ArrayList<String>();
		ArrayList<String> sellOutQtyArr = new ArrayList<String>();
		ArrayList<String> sellOutValArr = new ArrayList<String>();
		//Added by Sainath T. on 28-02-2020
		//ArrayList<String> sellInOther = new ArrayList<String>();
		HashMap<String, String> sellInQtyMthMap = new HashMap<String, String>();
		HashMap<String, String> sellInValMthMap = new HashMap<String, String>();
		HashMap<String, String> sellInOtherMap = new HashMap<String, String>();

		//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
		HashMap<String, ArrayList<String>> salesPersMapping = new HashMap<String,ArrayList<String>>();
		StringBuilder builder = null;
		String sql = "", tranId = "";
		try
		{
			org.json.JSONObject jsonData = new org.json.JSONObject(data);
			System.out.println( "#jsonData ["+ jsonData.toString() +"]" );
			stanCode = jsonData.getString("stan_code");
			posCode = jsonData.getString("pos_code");
			scCode = jsonData.getString("sc_code");
			prdCode = jsonData.getString("prd_code");
			fromDateStr = jsonData.getString("from_date");
			toDateStr = jsonData.getString("to_date");
			forceSave = jsonData.getString("force_save");
			//Added by Pooja S on 20-JUL-2020 [date issue on server side take the previous date] start
			fromDateStr = new Date(fromDateStr.substring(0, 16)).toString();
			toDateStr = new Date(toDateStr.substring(0, 16)).toString();
			//Added by Pooja S on 20-JUL-2020 [date issue on server side take the previous date] End
			//2020-02-01T12:00:30.027Z
			String loginCode = userInfoBean.getLoginCode();
			//DateFormat inputFormat = new SimpleDateFormat("E MMM dd yyyy HH:mm:ss 'GMT'z");
			//Changed by Pooja S on 20-JUL-2020 [date issue on server side take the previous date]
			SimpleDateFormat inputFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
			//SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
			//SimpleDateFormat formatter = new SimpleDateFormat(CommonConstants.APPL_DATE_FORMAT);
			SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);

			Date fromDate = inputFormat.parse(fromDateStr);
			fromDateStr = formatter.format(fromDate);

			Date toDate = inputFormat.parse(toDateStr);
			toDateStr = formatter.format(toDate);

			System.out.println("toDateStr : ["+ toDateStr +"], fromDate : ["+ fromDateStr +"]" );

			//System.out.println(fromDate);
			con = connDriver.getConnectDB(transDB);

			Date frDate = null;
			sql = "SELECT FR_DATE FROM PERIOD WHERE CODE = ? ";
			pStmt = con.prepareStatement(sql);
			pStmt.setString(1, prdCode);
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				frDate = rs.getDate("FR_DATE");
			}
			sql = "";
			if ( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
			HashMap<String, List<String>> groupWiseRoleCode = getGroupWiseRole( "ROLE_WISE_GRP", con );

			DateFormat df = new SimpleDateFormat(DATE_FORMAT);
			String dateStr = df.format(frDate);

			Timestamp fromDtTStmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(fromDateStr,DATE_FORMAT,genericUtility.getDBDateFormat()) + " 00:00:00.00");
			Timestamp toDtTStmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(toDateStr,DATE_FORMAT,genericUtility.getDBDateFormat()) + " 00:00:00.00");

			//Added By Vikas Lagad on 04-02-2020[check DSR is uploaded or not]Start
			if("N".equalsIgnoreCase(forceSave))
			{
				sql = "SELECT COUNT(1) AS CNT FROM SELL_IN WHERE REF_DATE BETWEEN ? AND ? AND SC_CODE = ?";
				pStmt = con.prepareStatement(sql);
				pStmt.setTimestamp(1, fromDtTStmp);
				pStmt.setTimestamp(2, toDtTStmp);
				pStmt.setString(3, scCode);
				System.out.println("sql["+sql+"]");
				rs = pStmt.executeQuery();
				if(rs.next())
				{
					cnt = rs.getInt(1);
				}

				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}

				if( cnt == 0)
				{
					String errSting = genericUtility.getErrorString("no_data_dsr", "VTSELNDF", userInfoBean.getLoginCode());
					JSONObject jsonObject = new JSONObject();
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					tempArr.add(jsonObject);
					return tempArr.toString();
				}
			}
			//Added By Vikas Lagad on 04-02-2020[check DSR is uploaded or not]End

			//tranId = isSellStockExist( loginCode, scCode, prdCode, fromDtTStmp, toDtTStmp, con );
			tranId = isSellStockExistInMonth( posCode, stanCode, scCode, prdCode, fromDtTStmp, toDtTStmp, con );
			builder = new StringBuilder();
			//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
			builder.append("SELECT SP.ITEM_SER,SP.SALES_PERS,EMP.DESIGN_CODE, ");
			builder.append("(TRIM(ORG.STAN_CODE__HQ) || ',' || TRIM(ORG.POS_CODE)) STAN_POS_CODE " );
			builder.append("FROM SALES_PERS SP,EMPLOYEE EMP, ORG_STRUCTURE ORG ");
			builder.append("WHERE SP.EMP_CODE = EMP.EMP_CODE ");
			builder.append("AND ORG.EMP_CODE = EMP.EMP_CODE ");
			builder.append("AND EMP.EMP_CODE IN ( SELECT DISTINCT EMP_CODE FROM ORG_STRUCTURE  ");
			builder.append("WHERE POOL_CODE IN ( SELECT POOL_CODE FROM ORG_STRUCTURE ORG WHERE ORG.STAN_CODE__HQ = ? AND ORG.POS_CODE = ? ) " );
			builder.append("AND ORG_STRUCTURE.ACTIVE = 'Y' ) AND SP.ACTIVE_YN = ? ");

			orgPstmt = con.prepareStatement(builder.toString());
			orgPstmt.setString(1, stanCode);
			orgPstmt.setString(2, posCode);
			orgPstmt.setString(3, "Y");
			orgRs = orgPstmt.executeQuery();
			while(orgRs.next())
			{
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] start
				ArrayList<String> itemSerDesignCodeArr = new ArrayList<String>();
				String orgItemSer = checkNull(orgRs.getString("ITEM_SER"));
				String designCode = checkNull(orgRs.getString("DESIGN_CODE"));
				String salesPers = checkNull(orgRs.getString("SALES_PERS"));
				String stanPosCode = checkNull(orgRs.getString("STAN_POS_CODE"));

				itemSerDesignCodeArr.add(0, orgItemSer);
				itemSerDesignCodeArr.add(1, designCode);

				//salesPersMapping.put(salesPers, itemSerDesignCodeArr);
				salesPersMapping.put(stanPosCode, itemSerDesignCodeArr);
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
			}
			if(orgRs != null)
			{
				orgRs.close();
				orgRs = null;
			}
			if(orgPstmt != null)
			{
				orgPstmt.close();
				orgPstmt = null;
			}
			System.out.println("salesPersMapping : ["+salesPersMapping+"]");

			if( tranId.trim().length() > 0 )
			{
				builder = new StringBuilder();
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
				builder.append("SELECT SID.ITEM_CODE,I.DESCR,I.SGRP_CODE, ");
				builder.append("NVL( SID.SELL_IN_QTY, 0) SELL_IN_MONTH,NVL( SID.SELL_IN_VALUE, 0) SELL_IN_MONTH_VAL, ");
				builder.append("NVL( SID.SELL_IN_QTY, 0) SELL_IN_QTY,NVL( SID.SELL_IN_VALUE, 0) SELL_IN_VALUE, ");
				builder.append("NVL( SID.SELL_OUT_QTY, 0) SELL_OUT_QTY,SID.LINE_NO, NVL( SID.SELL_OUT_QTY, 0) SELL_OUT_VALUE ,SID.MKT_ARR ");
				builder.append("FROM STK_SELL_IN_OUT SIH, STK_SELL_IN_OUT_DET SID, ITEM I LEFT OUTER JOIN PRODUCT ");
				builder.append("PROD ON PROD.PRODUCT_CODE = I.PRODUCT_CODE WHERE SIH.TRAN_ID = SID.TRAN_ID ");
				builder.append("AND SID.TRAN_ID = ? AND SIH.STATUS = ? ");
				builder.append("AND SID.ITEM_CODE = I.ITEM_CODE ORDER BY PROD.SORT_ORDER, I.DESCR ");

				//pStmt = con.prepareStatement(builder.toString(),ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
				pStmt = con.prepareStatement(builder.toString());//Added by bhagyashri T
				pStmt.setString( 1, tranId );
				pStmt.setString(2, "A");
			}
			else
			{
				builder = new StringBuilder();
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
				builder.append("SELECT ITEM.ITEM_CODE, ITEM.DESCR,ITEM.SGRP_CODE, " +
						" SUM(NVL( SELL_IN_ITEM.SELL_IN_QTY, 0)) SELL_IN_MONTH, " +
						" SUM(NVL( SELL_IN_ITEM.SELL_IN_QTY, 0)) SELL_IN_QTY, "+
						" SUM(NVL( SELL_IN_ITEM.SELL_IN_VALUE, 0 )) SELL_IN_VALUE, " +
						" SUM(NVL( SELL_IN_ITEM.SELL_IN_VALUE, 0 )) SELL_IN_MONTH_VAL, " +
						" CASE WHEN PRODUCT.MKT_ARR IS NULL THEN 'N' ELSE PRODUCT.MKT_ARR END AS MKT_ARR,PRODUCT.SORT_ORDER " +
						" FROM PRODUCT PRODUCT, " +
						" ITEM ITEM LEFT OUTER JOIN SELL_IN_ITEM SELL_IN_ITEM ON ITEM.ITEM_CODE = SELL_IN_ITEM.ITEM_CODE " +
						//"AND TRAN_ID IN ( SELECT TRAN_ID FROM SELL_IN SELL_IN WHERE SELL_IN.SALES_PERS = ? AND SELL_IN.SC_CODE = ? AND SELL_IN.STATUS = 'Y'" +
						" AND TRAN_ID IN ( SELECT TRAN_ID FROM SELL_IN SELL_IN WHERE SELL_IN.SC_CODE = ? AND SELL_IN.STATUS = 'Y' " +
						" and SELL_IN.REF_DATE BETWEEN ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),0) AND LAST_DAY(ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),0) ) ) " +
						" WHERE ITEM.PRODUCT_CODE = PRODUCT.PRODUCT_CODE " +
						//"AND PRODUCT.ITEM_SER = SALES_PERS.ITEM_SER" +
						" AND TRIM(ITEM.PRODUCT_CODE) NOT IN ( SELECT COLUMN_VALUE FROM TABLE( CSV_TO_ROW( (SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT = 'PRODUCT_CODE' AND PARM_NAME = 'PLANNING_NOT_ALLOW') ) ) ) " +
						" GROUP BY ITEM.ITEM_CODE, ITEM.DESCR, PRODUCT.SORT_ORDER, MKT_ARR,ITEM.SGRP_CODE " +
						" ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR ");

				//pStmt = con.prepareStatement(builder.toString(),ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
				pStmt = con.prepareStatement(builder.toString());//Added By Bhagyashri T
				//pStmt.setString(1, userInfoBean.getLoginCode());
				pStmt.setString(1, scCode);
				pStmt.setString(2, dateStr);
				pStmt.setString(3, dateStr);
				//pStmt.setString(4, "GRP03");
			}

			try
			{
				columnArray.add("ITEM_DESCR");
				columnArray.add("SELL_IN_MTH");
				//Added by Sainath T. on 28-02-2020
				columnArray.add("SELL_IN_OTHER");
				columnArray.add("SELL_IN");
				columnArray.add("SELL_OUT");
				tempArr.add(columnArray);
				columnArray = null;

				columnArray = new org.json.simple.JSONArray();
				columnArray.add("Items");
				columnArray.add("Sell-in (Month) from DSR");
				//Added by Sainath T. on 28-02-2020
				columnArray.add("Sell-in (Other)");
				columnArray.add("Sell-in (Own Contribution)");
				columnArray.add("Sell-out");
				tempArr.add(columnArray);
				columnArray = null;

				columnArray = new org.json.simple.JSONArray();
				JSONObject tempJson1 = getJSONObject();
				tempJson1.put("INPUT_TYPE", "text");
				JSONObject tempJson2 = getJSONObject();
				tempJson2.put("INPUT_TYPE", "number");
				JSONObject tempJson3 = getJSONObject();
				tempJson3.put("INPUT_TYPE", "number");
				JSONObject tempJson4 = getJSONObject();
				tempJson4.put("INPUT_TYPE", "number");
				//Added by Sainath T. on 28-02-2020
				JSONObject tempJson5 = getJSONObject();
				tempJson5.put("INPUT_TYPE", "number");

				columnArray.add(tempJson1);
				columnArray.add(tempJson2);
				columnArray.add(tempJson3);
				columnArray.add(tempJson4);
				//Added by Sainath T. on 28-02-2020
				columnArray.add(tempJson5);

				tempArr.add(columnArray);
				columnArray = null;
				//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
				//String itemCode = "";
				rs = pStmt.executeQuery();
				String stanPosCode = (checkNull( stanCode ) + "," + checkNull( posCode ));
				ArrayList<String> designCodeArr = salesPersMapping.get( stanPosCode );
				String designCode = "";
				if ( designCodeArr != null && designCodeArr.size() > 1 )
				{
					designCode = designCodeArr.get(1);
				}

				if( designCode == null || designCode.length() == 0 )
				{
					String errSting = genericUtility.getErrorString( "no_data_stk", "USERNOTMAP", userInfoBean.getLoginCode() );
					JSONObject jsonObject = new JSONObject();
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					tempArr = new org.json.simple.JSONArray();
					tempArr.add(jsonObject);
					return tempArr.toString();
				}

				while(rs.next())
				{
					//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] start
					String sgrpCode = checkNull( rs.getString("SGRP_CODE") );
					List<String> roleCodes = groupWiseRoleCode.get( sgrpCode );
					//if( roleCodes != null && roleCodes.contains( designCode ) )
					if( roleCodes == null || ( roleCodes != null && roleCodes.contains( designCode ) ) )
					{
						itmDescrArr.add(checkNull(rs.getString("DESCR")));
						/*if(tranId.trim().length() == 0)
						{
							sellInQtyMthArr.add(checkNull(rs.getString("SELL_IN_MONTH")));
							sellInValMthArr.add(checkNull(rs.getString("SELL_IN_MONTH_VAL")));
						}*/
						sellInQtyArr.add(checkNull(rs.getString("SELL_IN_QTY")));
						sellInValArr.add(checkNull(rs.getString("SELL_IN_VALUE")));
						itmCodeArr.add(checkNull(rs.getString("ITEM_CODE")));
						itmMktArr.add(checkNull(rs.getString("MKT_ARR")));

						if( tranId.trim().length() > 0 )
						{
							sellOutQtyArr.add(checkNull(rs.getString("SELL_OUT_QTY")));
							sellOutValArr.add(checkNull(rs.getString("SELL_OUT_VALUE")));
						}
						//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
					}
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}

				System.out.println("sellInQtyMthArr Before :: "+sellInQtyMthMap);
				System.out.println("sellInValMthArr Before :: "+sellInValMthMap);

				if( itmCodeArr == null || itmCodeArr.size() == 0 )
				{
					String errSting = genericUtility.getErrorString( "no_data_stk", "ITEMNOTMAP", userInfoBean.getLoginCode() );
					JSONObject jsonObject = new JSONObject();
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					tempArr = new org.json.simple.JSONArray();
					tempArr.add(jsonObject);
					return tempArr.toString();
				}

				builder = new StringBuilder();
				builder.append("SELECT ITEM.ITEM_CODE, ITEM.DESCR,ITEM.SGRP_CODE, ");
				builder.append("SUM(NVL( SELL_IN_ITEM.SELL_IN_QTY, 0)) SELL_IN_MONTH, ");
				builder.append("SUM(NVL( SELL_IN_ITEM.SELL_IN_QTY, 0 )) SELL_IN_MONTH_VAL, ");
				builder.append("FN_GET_SELL_IN_OTHER( ?, ?, ITEM.ITEM_CODE, ?, ? ) SELL_IN_QTY_OTHER, ");
				builder.append("PRODUCT.SORT_ORDER ");
				builder.append("FROM PRODUCT PRODUCT, ");
				builder.append("ITEM ITEM LEFT OUTER JOIN SELL_IN_ITEM SELL_IN_ITEM ON ITEM.ITEM_CODE = SELL_IN_ITEM.ITEM_CODE ");
				//builder.append("AND TRAN_ID IN ( SELECT TRAN_ID FROM SELL_IN SELL_IN WHERE SELL_IN.SALES_PERS = ? AND ");
				builder.append("AND TRAN_ID IN ( SELECT TRAN_ID FROM SELL_IN SELL_IN WHERE ");
				builder.append("SELL_IN.SC_CODE = ? AND SELL_IN.STATUS = ? AND SELL_IN.REF_DATE BETWEEN ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),0) ");
				builder.append("AND LAST_DAY(ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),0) ) ) ");
				builder.append("WHERE ITEM.PRODUCT_CODE = PRODUCT.PRODUCT_CODE ");
				//builder.append("AND PRODUCT.ITEM_SER = SALES_PERS.ITEM_SER ");
				builder.append("AND TRIM(ITEM.PRODUCT_CODE) NOT IN ( SELECT COLUMN_VALUE FROM TABLE( CSV_TO_ROW( (SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT = 'PRODUCT_CODE' AND PARM_NAME = 'PLANNING_NOT_ALLOW') ) ) ) ");
				builder.append("GROUP BY ITEM.ITEM_CODE, ITEM.DESCR, PRODUCT.SORT_ORDER, MKT_ARR,ITEM.SGRP_CODE ");
				builder.append("ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR ");
				/*String strSellMthSql = "SELECT ITEM.ITEM_CODE, ITEM.DESCR," +
						"SUM(NVL( SELL_IN_ITEM.SELL_IN_QTY, 0)) SELL_IN_MONTH," +
						"SUM(NVL( SELL_IN_ITEM.SELL_IN_VALUE, 0 )) SELL_IN_MONTH_VAL," +
						"PRODUCT.SORT_ORDER" +
						"FROM SALES_PERS SALES_PERS, PRODUCT PRODUCT," +
						"ITEM ITEM LEFT OUTER JOIN SELL_IN_ITEM SELL_IN_ITEM ON ITEM.ITEM_CODE = SELL_IN_ITEM.ITEM_CODE" +
						"AND TRAN_ID IN ( SELECT TRAN_ID FROM SELL_IN SELL_IN WHERE SELL_IN.SALES_PERS = ? AND SELL_IN.SC_CODE = ? AND SELL_IN.STATUS = 'Y'" +
						"and SELL_IN.TRAN_DATE BETWEEN ADD_MONTHS(TRUNC(SYSDATE,'mm'),0) AND LAST_DAY(ADD_MONTHS(TRUNC(SYSDATE,'mm'),0) ) )" +
						"WHERE ITEM.PRODUCT_CODE = PRODUCT.PRODUCT_CODE" +
						"AND PRODUCT.ITEM_SER = SALES_PERS.ITEM_SER" +
						"AND SALES_PERS.SALES_PERS = ?  and PRODUCT.PRODUCT_CODE not in (?)" +
						"ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR";*/
				//pStmt = con.prepareStatement( builder.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE );
				pStmt = con.prepareStatement( builder.toString());//Added By Bhagyashri T
				//pStmt.setString(1, userInfoBean.getLoginCode());
				pStmt.setString( 1, scCode );
				pStmt.setString( 2, prdCode );
				pStmt.setString( 3, stanCode );
				pStmt.setString( 4, posCode );
				pStmt.setString( 5, scCode );
				pStmt.setString( 6, "Y" );
				pStmt.setString( 7, dateStr );
				pStmt.setString( 8, dateStr );
				//pStmt.setString( 9, "GRP03" );
				rs = pStmt.executeQuery();
				while(rs.next())
				{
					String sgrpCode = checkNull( rs.getString("SGRP_CODE") );
					List<String> roleCodes = groupWiseRoleCode.get( sgrpCode );
					//if( roleCodes != null && roleCodes.contains( designCode ) )
					if( roleCodes == null || ( roleCodes != null && roleCodes.contains( designCode ) ) )
					{
						//sellInQtyMthArr.add(checkNull(rs.getString("SELL_IN_MONTH")));
						//sellInValMthArr.add(checkNull(rs.getString("SELL_IN_MONTH_VAL")));
						//Added by Sainath T. on 28-02-2020
						//sellInOther.add(checkNull(rs.getString("SELL_IN_QTY_OTHER")));
						String itemCode = checkNull( rs.getString("ITEM_CODE") );
						if( itmCodeArr.contains( itemCode ) )
						{
							sellInQtyMthMap.put( itemCode, checkNull( rs.getString("SELL_IN_MONTH") ) );
							sellInValMthMap.put( itemCode, checkNull( rs.getString("SELL_IN_MONTH_VAL") ) );
							sellInOtherMap.put( itemCode, checkNull( rs.getString("SELL_IN_QTY_OTHER") ) );
						}
					}
				}
				if(rs != null)
				{
					rs.close();
				}
				if(pStmt != null)
				{
					pStmt.close();
				}

				//Map<String, Integer> closingStkMthMp = getLastMthClosingStk(con,scCode,dateStr);
				//System.out.println("closingStkMthMp : "+closingStkMthMp);
				//Changed by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020
				String protectValue = getPRPDetails( con, posCode, scCode );

				System.out.println("sellInQtyMthArr  After :: "+sellInQtyMthMap);
				System.out.println("sellInValMthArr  After :: "+sellInValMthMap);
				//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
				HashMap<String, HashMap<String, String>> itemDetailMap = getItemDetails( itmCodeArr, con );
				for( int itemCodeCtr = 0; itemCodeCtr < itmCodeArr.size(); itemCodeCtr++ )
				{
					//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
					String itemCode = itmCodeArr.get(itemCodeCtr);

					HashMap itemDetmap = (HashMap)itemDetailMap.get(itemCode);
					//Changed by Pooja S on 27/11/20 [to resolve the item mismatch issue in sellInOut]
					double openingStk = 0;
					salesPersCnt = getSalesPersCount( itemDetailMap, itemCode, salesPersMapping, groupWiseRoleCode );
					//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
					System.out.println("Sales Person New Cont ::: itemCode : ["+ itemCode +"], salesPersCnt : ["+ salesPersCnt +"]" );

					if(salesPersCnt == 0)
						salesPersCnt = 1;

					JSONObject tempJson = getJSONObject();
					tempJson.put("ITEM_DESCR", itmDescrArr.get(itemCodeCtr));
					tempJson.put("ITEM_DESCR_P", "1");
					if( "Y".equalsIgnoreCase( itmMktArr.get( itemCodeCtr ) ) )
					{
						//Changed by Prasad on 14/03/2020 [to display only sell in from current month] START
						/*if(closingStkMthMp.get(itemCode) != null)
							openingStk = Integer.parseInt(sellInValMthArr.get(itemCodeCtr)) + closingStkMthMp.get(itemCode);
						else
							openingStk = Integer.parseInt(sellInValMthArr.get(itemCodeCtr));*/
						//openingStk = Integer.parseInt(sellInValMthMap.get(itemCodeCtr));
						if ( sellInValMthMap.get( itemCode ) != null )
						{
							openingStk = Double.parseDouble( sellInValMthMap.get( itemCode ) );
						}
						//Changed by Prasad on 14/03/2020 [to display only sell in from current month] END

						if(salesPersCnt > 0)
						{
							sellInVal = Math.round(openingStk / salesPersCnt);
						}
						tempJson.put("SELL_IN", (int)sellInVal + "");//Changed By Vikas Lagad
						tempJson.put("SELL_IN_P", "1");
						//tempJson.put("SELL_IN_MTH", sellInValMthArr.get(itemCodeCtr));
						tempJson.put("SELL_IN_MTH", openingStk+"");
						tempJson.put("SELL_IN_MTH_P", "1");
						tempJson.put("MKT_ARR", "Y");
						tempJson.put("MKT_ARR_P", "1");
						if(tranId.trim().length() > 0)
						{
							tempJson.put("SELL_OUT", sellOutValArr.get(itemCodeCtr));
							//Changed by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020
							//tempJson.put("SELL_OUT_P", "0");
							tempJson.put("SELL_OUT_P", protectValue);
						}
						else
						{
							tempJson.put("SELL_OUT", "0");
							//Changed by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020
							//tempJson.put("SELL_OUT_P", "0");
							tempJson.put("SELL_OUT_P", protectValue);
						}
					}
					else
					{
						//Changed by Prasad on 14/03/2020 [to display only sell in from current month] START
						/*if(closingStkMthMp.get(itemCode) != null)
							openingStk = Integer.parseInt(sellInQtyMthArr.get(itemCodeCtr)) + closingStkMthMp.get(itemCode);
						else
							openingStk = Integer.parseInt(sellInQtyMthArr.get(itemCodeCtr));*/
						//openingStk = Integer.parseInt(sellInQtyMthMap.get(itemCodeCtr));
						if ( sellInQtyMthMap.get( itemCode ) != null )
						{
							openingStk = Double.parseDouble( sellInQtyMthMap.get( itemCode ) );
						}
						//Changed by Prasad on 14/03/2020 [to display only sell in from current month] END

						tempJson.put("SELL_IN", sellInQtyArr.get(itemCodeCtr));
						tempJson.put("SELL_IN_P", "0");
						//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
						//tempJson.put("SELL_IN_MTH", sellInQtyMthArr.get(itemCodeCtr));
						tempJson.put("SELL_IN_MTH", openingStk+"");
						tempJson.put("SELL_IN_MTH_P", "1");
						tempJson.put("MKT_ARR", "N");
						tempJson.put("MKT_ARR_P", "0");
						if(tranId.trim().length() > 0)
						{
							tempJson.put("SELL_OUT", sellOutQtyArr.get(itemCodeCtr));
							tempJson.put("SELL_OUT_P", "0");
						}
						else
						{
							tempJson.put("SELL_OUT", "0");
							tempJson.put("SELL_OUT_P", "0");
						}
					}
					//Added by Sainath T. on 28-02-2020-Start

					String sellInOther = "";
					if ( sellInOtherMap.get( itemCode ) != null )
					{
						sellInOther = sellInOtherMap.get( itemCode );
					}
					tempJson.put("SELL_IN_OTHER", sellInOther);
					tempJson.put("SELL_IN_OTHER_P", "1");
					//Added by Sainath T. on 28-02-2020-End
					tempJson.put("ITEM_CODE", itmCodeArr.get(itemCodeCtr));
					tempJson.put("ITEM_CODE_P", "1");

					tempJson.put("BG_COLOR", itemDetmap.get("PRODUCT_COLOR"));

					tempArr.add(tempJson);
				}
				//System.out.println("tempArray : "+tempArr);
			}
			catch(Exception e)
			{
				System.out.println("SellsStock.getSalesPlanData() Exception : "+e);
			}
		}
		catch( Exception e )
		{
			e.printStackTrace();
			System.out.println( "Exception :: SellsStock.getSalesPlanData() : ["+ e.getMessage() +"]" );

			tempArr = excpUtility.handleException( e );
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(orgPstmt != null)
				{
					orgPstmt.close();
					orgPstmt = null;
				}
				if(orgRs != null)
				{
					orgRs.close();
					orgRs = null;
				}
				if(con != null)
				{
					con.close();
					con = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("SellsStock.getFirstFormItemChange()"+e);
			}
		}
		return tempArr.toString();
	}

	private static JSONObject getJSONObject()
	{
		JSONObject jsonObject = null;
		try
		{
			jsonObject= new JSONObject();
			java.lang.reflect.Field map = jsonObject.getClass().getDeclaredField("map");
			map.setAccessible(true);
			map.set(jsonObject, new LinkedHashMap<>());
			map.setAccessible(false);
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.getJSONObject() Exception : "+e);
		}
		return jsonObject;
	}

	private static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	public String insertStkInOutData( String sellPlanningata, final UserInfoBean userInfo )
	{
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		Connection conn = null;
		String userId = userInfo.getLoginCode();
		String terrCode = "",scCode = "",prdCode = "",fromDateStr = "",toDateStr ="",previousMonday = "", stanCode = "", posCode = "";
		Timestamp fromDtTStmp = null, toDtTStmp = null;
		String tranID = "";
		String fromDateStr2 = "";
        String toDateStr2 = "";
        String fromAndToDate = "";
		JSONObject errorJson = new JSONObject();
		JSONArray jsonArray = new JSONArray();
		JSONObject	headerJson = null;
		//ResultSet rs = null;
		try
		{
			if( userInfo != null )
			{
				conn = connDriver.getConnectDB(userInfo.getTransDB());
				conn.setAutoCommit( false );
			}
			JSONObject json = null;
			try
			{
				json = new JSONObject(sellPlanningata);

				headerJson = (JSONObject)json.get("headerFormData");
				stanCode = headerJson.getString("stan_code");
				posCode = headerJson.getString("pos_code");
				prdCode = headerJson.getString("prd_code");
				fromDateStr = headerJson.getString("from_date");
				toDateStr = headerJson.getString("to_date");
				scCode = headerJson.getString("sc_code");
				previousMonday = headerJson.getString("prev_monday");
			}
			catch (Exception e)
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();
			}
			System.out.println( "toDateStr : ["+ toDateStr + "], fromDate : ["+ fromDateStr +"], previousMonday : ["+ previousMonday +"]" );

			DBAccessEJB dbAcc = new DBAccessEJB();
			Map<String, Integer> closingLstMthMp = new HashMap<>();
			closingLstMthMp = getLastMthClosingStk( conn, scCode, fromDateStr );
			System.out.println( "closingLstMthMp : "+ closingLstMthMp );

			try
			{
				fromDtTStmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(fromDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.00");
				toDtTStmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(toDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.00");
				//previousMonStamp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(previousMonday,DATE_FORMAT,genericUtility.getDBDateFormat()) + " 00:00:00.00");
				tranID = isSellStockExist(stanCode, posCode, scCode, prdCode, fromDtTStmp, toDtTStmp, conn);

				if( tranID.trim().length() == 0 )
				{
					//if(tranID.trim().length() > 0)
					/*{*/
						//String updateStatus = "UPDATE STK_SELL_IN_OUT SET STATUS = ? WHERE TRAN_ID = ?";
					String updateStatus = "UPDATE STK_SELL_IN_OUT SET STATUS = ? WHERE SC_CODE = ? AND PRD_CODE = ? AND STAN_CODE = ? AND POS_CODE = ?";
					pstmt = conn.prepareStatement(updateStatus);
					pstmt.setString(1, "C");
					pstmt.setString(2, scCode);
					pstmt.setString(3, prdCode);
					pstmt.setString(4, stanCode);
					pstmt.setString(5, posCode);
					int updateCount = pstmt.executeUpdate();
					System.out.println( "STK_SELL_IN_OUT :: updatecount ["+ updateCount +"]" );
					/*if(count > 0)
					{
						conn.commit();
					}*/
					//tranID = "";
					/*}*/
					/*if(rs != null)
					{
						rs.close();
					}*/
					if(pstmt != null)
					{
						pstmt.close();
					}
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception while Generating TranId...................."+e);
			}

			if( tranID.trim().length() > 0 )
			{
				org.json.JSONArray jsonArr = (org.json.JSONArray)json.get("detailFormData");

				deleteStkInOutDet( tranID, conn );
				//Changed by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out]
				errorJson = insertStkInOutDetData( jsonArr, tranID, conn, false, closingLstMthMp, prdCode, scCode, stanCode, userInfo );
			}
			else
			{
				tranID = dbAcc.generateTranId("W_STK_SELL_IN_OUT", userInfo.getSiteCode(), userInfo.getLoginCode(), conn);
				String insertSql = "Insert into STK_SELL_IN_OUT (TRAN_ID,TRAN_DATE,SC_CODE,PRD_CODE,FROM_DATE,TO_DATE,ADD_DATE,"
						+ "ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM,SALES_PERS, STATUS, STAN_CODE, POS_CODE) " +
						"values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)" ;

				//Date currDate = new Date();
				//SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.APPL_DATE_FORMAT);
				//String date = sdf.format(currDate);

				pstmt = conn.prepareStatement(insertSql);
				pstmt.setString(1, tranID);
				pstmt.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(3, scCode);
				pstmt.setString(4, prdCode);
				pstmt.setTimestamp(5, fromDtTStmp);
				pstmt.setTimestamp(6, toDtTStmp);
				pstmt.setTimestamp(7, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(8, userId);
				pstmt.setString(9, userInfo.getRemoteHost());
				pstmt.setTimestamp(10, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString(11, userId);
				pstmt.setString(12, userInfo.getRemoteHost());
				pstmt.setString(13, userId);
				pstmt.setString(14, "A");
				pstmt.setString(15, stanCode);
				pstmt.setString(16, posCode);

				int updatedheader = pstmt.executeUpdate();
				if( pstmt != null)
				{
					pstmt.close();
					pstmt =  null;
				}

				if( updatedheader > 0 )
				{
					org.json.JSONArray jsonArr = (org.json.JSONArray)json.get("detailFormData");
					//Changed by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out]
					errorJson = insertStkInOutDetData(jsonArr,tranID,conn, false, closingLstMthMp, prdCode, scCode, stanCode,userInfo);
				}
			}
			System.out.println( "errorJson : ["+ errorJson +"]" );
			//Changed by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out] START
			if( errorJson != null && errorJson.length() > 0 )
			{
				if ( conn != null )
				{
					conn.rollback();
				}
			}
			else
			{
				if ( conn != null )
				{
					conn.commit();
				}
				String errSting = genericUtility.getErrorString( "tran_id", "VTEDISUCC", userInfo.getLoginCode() );
				JSONObject successMsg = excpUtility.convertXmlToJsonInError( errSting );

				errorJson = new JSONObject();
				errorJson.put("tran_id", tranID);
				errorJson.put("success_msg", successMsg);

				if ( ! isPlanningMgr( posCode, conn ) )
				{
					updatePoolSellOut( posCode, stanCode, scCode, prdCode, "stkInOut", userInfo );
				}
				//Added by Amey W. [On submission of Sell In-Out by salesperson notify to Manager] on 01-07-2020 START
			    //fromAndToDate = fromDateStr + " - " + toDateStr;
				//sendNotification( sellPlanningata, fromAndToDate, tranID, "", "sellInOut", userInfo );
				//Added by Amey W. [On submission of Sell In-Out by salesperson notify to Manager] on 01-07-2020 END
			}
			//Changed by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out] END
			jsonArray.add(errorJson);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :: SellsStock.insertData() : ["+ e.getMessage() +"]" );
			try
			{
				if ( conn != null )
				{
					conn.rollback();
				}
			}
			catch (SQLException e1)
			{
				e1.printStackTrace();
			}
			jsonArray = excpUtility.handleException( e );
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt =  null;
				}
				if( conn != null )
				{
					conn.close();
					conn =  null;
				}
			}
			catch (SQLException e)
			{
				System.out.println("Exeption while closing connection in insertData :: "+e.getMessage());
			}
		}
		return jsonArray.toString();
	}

	private JSONObject insertStkInOutDetData( org.json.JSONArray jsonArr, String tranId, Connection conn, boolean toUpdate, Map<String, Integer> closingLstMthMp, String prdCode, String scCode, String stanCode,UserInfoBean userInfoBean ) throws ITMException
	{
		PreparedStatement pstmt = null;
		double sellInVal = 0;
		double sellOutVal = 0;
		String detailSql = "";
		JSONObject errorJson = null;
		try
		{
			DistCommon distCommon = new DistCommon();
			Date curDate = new Date();
			SimpleDateFormat sdf = new SimpleDateFormat( genericUtility.getApplDateFormat() );

			org.json.JSONArray columnArray = new org.json.JSONArray();
			columnArray = (org.json.JSONArray)jsonArr.get(0);
			columnArray.put("ITEM_CODE");
			columnArray.put("MKT_ARR");
			System.out.println( "columnArray : ["+ columnArray +"]" );

			ArrayList<String> itemCodeArray = new ArrayList<String>();
			for (int i = 3; i < jsonArr.length(); i++)
			{
				try
				{
					JSONObject tempJson = (JSONObject)jsonArr.get(i);
					String itemCode = tempJson.getString((String)columnArray.get(5));
					itemCodeArray.add( itemCode );
				}
				catch( Exception e )
				{
					e.printStackTrace();
				}
			}
			HashMap<String, HashMap<String, String>> itemDetailMap = getItemDetails( itemCodeArray, conn );

			int lineNo = 0;
			if(toUpdate)
			{
				detailSql = "UPDATE STK_SELL_IN_OUT_DET SET SELL_IN_QTY = ? , SELL_OUT_QTY = ? , SELL_IN_VALUE = ? , SELL_OUT_VALUE = ?, CLOSING_STK = ?" +
						"WHERE TRAN_ID = ? AND ITEM_CODE = ?";
			}
			else
			{
				detailSql = "INSERT INTO STK_SELL_IN_OUT_DET (TRAN_ID,LINE_NO,ITEM_CODE,SELL_IN_QTY,SELL_OUT_QTY,SELL_IN_VALUE,SELL_OUT_VALUE,MKT_ARR,CLOSING_STK) " +
						"VALUES (?,?,?,?,?,?,?,?,?)";
			}

			pstmt = conn.prepareStatement(detailSql);
			for (int i = 3; i < jsonArr.length(); i++)
			{
				lineNo++;

				//Changed by Pooja S on 27/11/20 [to resolve the item mismatch issue in sellInOut] START
				JSONObject tempJson = (JSONObject)jsonArr.get(i);
				String sellInOtherQty = tempJson.getString((String)columnArray.get(2));
				String sellInQty = tempJson.getString((String)columnArray.get(3));
				String sellOutQty = tempJson.getString((String)columnArray.get(4));
				String itemCode = tempJson.getString((String)columnArray.get(5));
				String mktArr = tempJson.getString((String)columnArray.get(6));
				String itemDescr = tempJson.getString((String)columnArray.get(0));
				//String sellInValStr = "",sellOutVaStrl = "";
				sellInQty = checkNull( sellInQty );
				if ( sellInQty.length() == 0 )
				{
					sellInQty = "0";
				}
				sellOutQty = checkNull( sellOutQty );
				if ( sellOutQty.length() == 0 )
				{
					sellOutQty = "0";
				}
				//Changed by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out ] Start
				double finalSellInQty = 0;
				if ( closingLstMthMp != null && closingLstMthMp.containsKey( itemCode ) )
				{
					finalSellInQty = closingLstMthMp.get( itemCode ) + (Double.parseDouble(sellInQty));
				}
				else
				{
					finalSellInQty = (Double.parseDouble(sellInQty));
				}
				System.out.println( "finalSellInQty : ["+ finalSellInQty +"] sellInOUT["+ (Double.parseDouble(sellOutQty)) +"]" );
				/*if( (Integer.parseInt(sellOutQty)) > finalSellInQty )
				{
					String errSting = genericUtility.getErrorString( "no_data_stk", "VTOUTQTY", userInfoBean.getLoginCode() );
					StringBuilder traceMsg = new StringBuilder();
					traceMsg.append( "[ " ).append( itemCode ).append( " : " ).append( itemDescr ).append( " ]" );
					errorJson = excpUtility.convertXmlToJsonInError( errSting, traceMsg.toString() );
					break;
				}*/
				//Changed by Pooja S on 20-JUNE-2020 [Negative stock validation in Sell In Out ] End
				double rate = 0;
				if ( itemDetailMap.containsKey( itemCode ) )
				{
					HashMap<String, String> itemCodeMap = itemDetailMap.get( itemCode );
					rate = Double.parseDouble( itemCodeMap.get( "RATE" ) );
				}
				else
				{
					rate = distCommon.pickRate( getPriceList( itemCode, conn ), sdf.format(curDate), itemCode, conn);
				}
				System.out.println( "sellInQty : ["+ sellInQty +"], sellOutQty : ["+ sellOutQty +"], mktArr ["+ mktArr +"], itemCode ["+ itemCode +"], rate ["+ rate +"]" );
				/*if( !mktArr.equalsIgnoreCase("Y") )
				{*/
				//double rate = distCommon.pickRate(getPriceList(itemCode,conn), sdf.format(curDate), itemCode, conn);
				sellInVal = Double.parseDouble(sellInQty) * rate;
				sellOutVal = Double.parseDouble(sellOutQty) * rate;
				/*}*/
				int closingLstMthStk = 0;

				if(toUpdate)
				{
					if(!mktArr.equalsIgnoreCase("Y"))
					{
						pstmt.setString(1, sellInQty);
						pstmt.setString(2, sellOutQty);
						pstmt.setDouble(3, sellInVal);
						pstmt.setDouble(4, sellOutVal);
					}
					else
					{
						pstmt.setString(1, sellInQty);
						pstmt.setString(2, sellOutQty);
						pstmt.setDouble(3, sellInVal);
						pstmt.setDouble(4, sellOutVal);
					}
					if ( closingLstMthMp != null && closingLstMthMp.containsKey( itemCode ) )
					{
						closingLstMthStk = closingLstMthMp.get( itemCode );
					}
					double closingStk = (closingLstMthStk + (Double.parseDouble(sellInQty))) - (Double.parseDouble(sellOutQty));
					pstmt.setDouble(5, closingStk);
					pstmt.setString(6, tranId);
					pstmt.setString(7, itemCode);
					/*pstmt.setString(7, lineNo+"");*/
					pstmt.addBatch();
				}
				else
				{
					pstmt.setString(1, tranId);
					pstmt.setString(2, lineNo+"");
					pstmt.setString(3, itemCode);
					if( ! mktArr.equalsIgnoreCase( "Y" ) )
					{
						pstmt.setString(4, sellInQty);
						pstmt.setString(5, sellOutQty);
						pstmt.setDouble(6, sellInVal);
						pstmt.setDouble(7, sellOutVal);
					}
					else
					{
						pstmt.setString(4, sellInQty);
						pstmt.setString(5, sellOutQty);
						pstmt.setDouble(6, sellInVal);
						pstmt.setDouble(7, sellOutVal);
					}
					/*pstmt.setString(4, "0");
					pstmt.setString(5, "0");
					pstmt.setDouble(6, sellInVal);
					pstmt.setDouble(7, sellOutVal);*/
					pstmt.setString(8, mktArr);
					if ( closingLstMthMp != null && closingLstMthMp.containsKey( itemCode ) )
					{
						closingLstMthStk = closingLstMthMp.get( itemCode );
					}
					double closingStk = closingLstMthStk + (Double.parseDouble(sellInQty)) - (Double.parseDouble(sellOutQty));
					pstmt.setDouble(9, closingStk);
					pstmt.addBatch();
				}
				//Changed by Pooja S on 27/11/20 [to resolve the item mismatch issue in sellInOut] END
			}
			System.out.println( "errorJson ["+ errorJson +"]" );
			if( errorJson == null )
			{
				int result[] = pstmt.executeBatch();
				System.out.println( "["+ result.length +"] rows inserted" );
			}
			/*if(result.length > 0)
			{
				conn.commit();
			}*/
		}
		catch (SQLException e)
		{
			System.out.println( "SellsStock.getDataFromJson() SQLException : ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
		catch (Exception e)
		{
			System.out.println( "SellsStock.getDataFromJson() Exception : ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return errorJson;
	}

	public String itmDefault(UserInfoBean userInfoBean)
	{
		System.out.println("## itmDefault  ");
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String transDB = userInfoBean.getTransDB();
		JSONObject jsonObject = new JSONObject();
		Date currDate = new Date();
		String sql ="",userCode = "",loginEmpCode = "",posCodeDescr = "",terrDescr = "",startDate ="";
		String prdCode = "",chgTerm ="",prdCodeDescr = "",endDate ="",posCode = "",stanCode = "";
		Timestamp valueOfCurrDate;
		try
		{
			conn = connDriver.getConnectDB(transDB);
			userCode = checkNull(userInfoBean.getLoginCode()).trim();
			loginEmpCode = checkNull(userInfoBean.getEmpCode()).trim();

			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			SimpleDateFormat sdfAppl = new SimpleDateFormat(DATE_FORMAT);
			valueOfCurrDate = Timestamp.valueOf(genericUtility.getValidDateString(sdfAppl.format(currDate),DATE_FORMAT,genericUtility.getDBDateFormat())
					+ " 00:00:00.0");
			System.out.println("valueOfCurrDate................"+valueOfCurrDate);

			//Changed By Vikas Lagad Start
			/*sql = "SELECT FN_GET_TERRITORY(?,?) AS POS_CODE_DESCR FROM DUAL";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, loginEmpCode);
			pStmt.setString(2, loginEmpCode);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				posCodeDescr = checkNull(rs.getString("POS_CODE_DESCR"));
				jsonObject.put("pos_code_descr", posCodeDescr);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}*/
			posCodeDescr = getPosCodeDescr( loginEmpCode, conn );
			jsonObject.put("pos_code_descr", posCodeDescr);

			sql = "SELECT POS_CODE,STAN_CODE__HQ FROM ORG_STRUCTURE WHERE EMP_CODE = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, loginEmpCode);
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				posCode = rs.getString("POS_CODE");
				stanCode = rs.getString("STAN_CODE__HQ");
				jsonObject.put("pos_code", posCode);
				jsonObject.put("stan_code", stanCode);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			//Changed By Vikas Lagad End
			sql = "SELECT SH_DESCR,CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			pStmt = conn.prepareStatement(sql);
			//pStmt.setString(1, sdfAppl.format(currDate));
			pStmt.setTimestamp(1, valueOfCurrDate);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				prdCode = rs.getString("CODE");
				prdCodeDescr = rs.getString("SH_DESCR");
				jsonObject.put("prd_code", prdCode);
				jsonObject.put("prd_code_descr", prdCodeDescr);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			Calendar c = Calendar.getInstance();
			c.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
			startDate = sdfAppl.format(c.getTime());

			c.add(Calendar.DATE, 6);
			endDate = sdfAppl.format(c.getTime());

			jsonObject.put("tran_date", sdfAppl.format(currDate));
			jsonObject.put("from_date", startDate);
			jsonObject.put("to_date", endDate);
			jsonObject.put("chg_date", sdfAppl.format(currDate));
			jsonObject.put("chg_user", userCode);
			jsonObject.put("chg_term", chgTerm);
			jsonObject.put("add_date", sdfAppl.format(currDate));
			jsonObject.put("add_user", userCode);
			jsonObject.put("add_term", chgTerm);

		}
		catch (Exception e)
		{
			System.out.println("SellsStock.itmDefault() Exception "+e);
		}
		finally {
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e) {
				System.out.println("SellsStock.getFirstForrmItmDefault()"+e);
			}
		}
		return jsonObject.toString();
	}

	private String isSellStockExist(String stanCode, String posCode, String scCode, String prdCode, Timestamp fromDtTStmp, Timestamp toDtTStmp, Connection con)
	{
		String tranId = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;

		try
		{
			String str = "SELECT TRAN_ID FROM STK_SELL_IN_OUT WHERE SC_CODE = ? AND PRD_CODE = ? AND FROM_DATE = ? "
					+ "AND TO_DATE = ? AND STAN_CODE = ? AND POS_CODE = ? AND STATUS = ?";
			pStmt = con.prepareStatement(str);
			pStmt.setString(1, scCode);
			pStmt.setString(2, prdCode);
			pStmt.setTimestamp(3, fromDtTStmp);
			pStmt.setTimestamp(4, toDtTStmp);
			pStmt.setString(5, stanCode);
			pStmt.setString(6, posCode);
			pStmt.setString(7, "A");
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				tranId = E12GenericUtility.checkNull(rs.getString("TRAN_ID"));
			}

			System.out.println("StkSellInOutIC.isDataExist() tranId : "+tranId);

			rs.close();
			pStmt.close();

			if(tranId.trim().length() > 0)
			{
				return tranId;
			}
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.isSellStockExist() Exception :"+e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return tranId;
	}

	private String isSellStockExistInMonth( String posCode, String stanCode, String scCode, String prdCode, Timestamp fromDtTStmp, Timestamp toDtTStmp, Connection con)
	{
		String tranId = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;

		try
		{
			String str = "SELECT TRAN_ID FROM STK_SELL_IN_OUT "
					+ "WHERE SC_CODE = ? AND PRD_CODE = ? AND STAN_CODE = ? AND POS_CODE = ? AND STATUS = ? "
					+ "ORDER BY TO_DATE";
			pStmt = con.prepareStatement(str);
			pStmt.setString(1, scCode);
			pStmt.setString(2, prdCode);
			pStmt.setString(3, stanCode);
			pStmt.setString(4, posCode);
			pStmt.setString(5, "A");
			rs = pStmt.executeQuery();
			while( rs.next() )
			{
				tranId = E12GenericUtility.checkNull(rs.getString("TRAN_ID"));
			}

			System.out.println("StkSellInOutIC.isDataExist() tranId : "+tranId);

			rs.close();
			pStmt.close();

			if(tranId.trim().length() > 0)
			{
				return tranId;
			}
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.isSellStockExist() Exception :"+e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return tranId;
	}

	private String getPriceList(String itemCode, Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		String priceList = "";
		try
		{
			String str = "SELECT PRICE_LIST FROM ITEM WHERE ITEM_CODE = ?";
			pstmt = conn.prepareStatement(str);
			pstmt.setString(1, itemCode);
			resultSet = pstmt.executeQuery();
			if(resultSet.next())
			{
				priceList = resultSet.getString("PRICE_LIST");
			}
			resultSet.close();
			pstmt.close();
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.getPriceList() Exception "+e);
		}
		finally
		{
			try
			{
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return priceList;
	}

	//public String getSellsPlanData( String stanCode, String posCode, String salesPers, String prdCode, String forceSave, UserInfoBean userInfoBean ) throws JSONException
	public String getSellsPlanData( String data ,UserInfoBean userInfoBean ) throws JSONException
	{
		String stanCode="",posCode="",salesPers = "",prdCode ="",forceSave = "";
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs1 = null;
		ResultSet rs = null;
		String dealerName = "";
		String transDB = userInfoBean.getTransDB();
		Date fromDate=null;
		String tranId = "", status = "";
		JSONArray columnArray = new org.json.simple.JSONArray();
		JSONArray tempArr = new org.json.simple.JSONArray();
		ArrayList<String> itmCodeArr = new ArrayList<String>();
		ArrayList<String> sellInQtyArr = new ArrayList<String>();
		ArrayList<String> sellOutQtyArr = new ArrayList<String>();
		//ArrayList<String> sellInValArr = new ArrayList<String>();
		//ArrayList<String> sellOutValArr = new ArrayList<String>();
		ArrayList<String> rateArr = new ArrayList<String>();
		ArrayList<String> closingStockArray = new ArrayList<String>();
		//ArrayList<String> closingStkValArr = new ArrayList<String>();
		//ArrayList<String> scCodeArr = new ArrayList<String>();
		ArrayList<String> avgSellInQtyArr = new ArrayList<String>();
		ArrayList<String> avgSellOutQtyArr = new ArrayList<String>();
		//ArrayList<String> avgSellInValArr = new ArrayList<String>();
		//ArrayList<String> avgSellOutValArr = new ArrayList<String>();
		ArrayList<String> mktArr = new ArrayList<String>();
		//Set<String> scCodeSet = new HashSet<String>();
		Iterator<String> itr  = null;
		ArrayList<String> labelArr = new ArrayList<String>();
		int counter = 0, cntStkSellData = 0;
		String sql,scCode = "",scCodeName ="";

		Map<String, ArrayList<String>> itmMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellInMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellOutMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellInValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellOutValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> rateMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> closingMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> closingValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellInQtyMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellOutQtyMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> mktArrMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellInValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellOutValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgData = new HashMap<String, ArrayList<String>>();
		Map<String, String> statusMap = new HashMap<String, String>();

		Map<String, ArrayList<String>> productCodeMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> scCodeMapVal = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sgroupMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> groupMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> itemDescrMap = new HashMap<String, ArrayList<String>>();

		boolean isMgr = false;

		try
		{
			org.json.JSONObject jsonData = new org.json.JSONObject(data);
			System.out.println( "#jsonData ["+ jsonData.toString() +"]" );

			stanCode = jsonData.getString("stan_code");
			posCode = jsonData.getString("pos_code");
			//scCode = jsonData.getString("sc_code");
			prdCode = jsonData.getString("prd_code");
			salesPers = jsonData.getString("sales_pers");
			forceSave = jsonData.getString("force_save");
			//int loginUserGrade = jsonData.getInt("level_no");

			if( posCode.contains(",") )
			{
				posCode = posCode.replace(",", "','");
			}
			if( stanCode.contains(",") )
			{
				stanCode = stanCode.replace(",", "','");
			}
			conn = connDriver.getConnectDB(transDB);

			isMgr = isPlanningMgr( posCode, conn );

			sql = "SELECT FR_DATE FROM PERIOD WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, prdCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				fromDate = rs.getDate("FR_DATE");
			}
			sql = "";
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
			String dateStr = df.format(fromDate);

			statusMap = isSellsPlanDataExist( stanCode, posCode, userInfoBean.getLoginCode(), prdCode, conn );
			System.out.println( "statusMap : ["+ statusMap +"]" );
			if( statusMap != null &&  statusMap.size() > 0)
			{
				tranId = statusMap.get("TRAN_ID");
				status = statusMap.get("STATUS");
			}
			if( "N".equalsIgnoreCase( forceSave ) && ( ! "S".equalsIgnoreCase( status ) ) && ( ! isMgr ) )
			{
				if( ! isPrvAllMonthsSellInOutExist( posCode, stanCode, prdCode, conn ) )
				{
					String errSting = genericUtility.getErrorString( "no_data_stk", "VTSELPLNDF", userInfoBean.getLoginCode() );
					JSONObject jsonObject = new JSONObject();
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					tempArr = new JSONArray();
					tempArr.add( jsonObject );
					return tempArr.toString();
				}
			}
			//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
			String designCode = getDesignCode( stanCode, posCode, conn );
			HashMap<String, List<String>> groupWiseRoleCode = getGroupWiseRole("ROLE_WISE_GRP",conn);
			//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
			HashMap<String, String> scCodeNameMap = new LinkedHashMap<String,String>();
			//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
			HashMap<String, String> scCodeNamePRPwiseMap = new LinkedHashMap<String,String>();

			/*int gradeCode = 0;
			String gradeCodeSql = "SELECT LEVEL_NO FROM ORG_STRUCTURE WHERE POS_CODE in ( '"+posCode+"' )" ;
			pstmt = conn.prepareStatement( gradeCodeSql );
			rs1 = pstmt.executeQuery();
			while(rs1.next())
			{
				String gradeCodeStr = checkNull( rs1.getString( "LEVEL_NO" ) );
				if( gradeCodeStr.length() > 0 )
				{
					gradeCode = Integer.parseInt( gradeCodeStr );
				}
			}
			System.out.println( "gradeCode : ["+ gradeCode +"], loginUserGrade : ["+ loginUserGrade +"]" );
			if(rs1 != null)
			{
				rs1.close();
			}
			if(pstmt != null)
			{
				pstmt.close();
			}*/

			if( isMgr )
			{
				Map<String, Map<String, ArrayList<String>>> mgrSalesPlanDataMap = new HashMap<String,Map<String, ArrayList<String>>>();
				mgrSalesPlanDataMap = getMgrSellPanningData( tranId, conn, scCode, stanCode, posCode.replace("','", ","), salesPers, prdCode, dateStr, groupWiseRoleCode, designCode );

				scCodeMapVal = mgrSalesPlanDataMap.get("SC_CODE");
				productCodeMap = mgrSalesPlanDataMap.get("PRODUCT_CODE");
				sgroupMap = mgrSalesPlanDataMap.get("SGRP_CODE");
				groupMap = mgrSalesPlanDataMap.get("GRP_CODE");
				itemDescrMap = mgrSalesPlanDataMap.get("ITEM_DESCR");
				itmMap = mgrSalesPlanDataMap.get("ITEM_CODE");
				sellInMap = mgrSalesPlanDataMap.get("SELL_IN_QTY");
				sellOutMap = mgrSalesPlanDataMap.get("SELL_OUT_QTY");
				sellInValMap = mgrSalesPlanDataMap.get("SELL_IN_VAL");
				sellOutValMap = mgrSalesPlanDataMap.get("SELL_OUT_VAL");
				closingMap = mgrSalesPlanDataMap.get("CLOSING_STOCK");
				closingValMap = mgrSalesPlanDataMap.get("CLOSING_STOCK_VAL");
				rateMap = mgrSalesPlanDataMap.get("RATE");
				avgSellInQtyMap = mgrSalesPlanDataMap.get("AVG_SELL_IN_QTY");
				avgSellOutQtyMap = mgrSalesPlanDataMap.get("AVG_SELL_OUT_QTY");
				mktArrMap = mgrSalesPlanDataMap.get("MKT_ARR");
				avgSellInValMap = mgrSalesPlanDataMap.get("AVG_SELL_IN_VAL");
				avgSellOutValMap = mgrSalesPlanDataMap.get("AVG_SELL_OUT_VAL");

				if ( scCodeMapVal == null || scCodeMapVal.size() == 0 )
				{
					String errSting = genericUtility.getErrorString( "no_data_stk", "VTNOPLNDT", userInfoBean.getLoginCode() );
					JSONObject jsonObject = new JSONObject();
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					tempArr = new JSONArray();
					tempArr.add( jsonObject );
					return tempArr.toString();
				}

				for ( Entry<String, ArrayList<String>> entry : scCodeMapVal.entrySet() )
				{
					ArrayList<String> dealerNameVal = entry.getValue();
					scCodeNameMap.put( entry.getKey(), dealerNameVal.get(0) );
					if(counter == 0)
					{
						columnArray.add("SC_CODE");
						columnArray.add("LABEL");
						LinkedHashSet<String> itemCodeSet = new LinkedHashSet<String>(itmMap.get(entry.getKey()));
						LinkedHashSet<String> itemDescrSet = new LinkedHashSet<String>(itemDescrMap.get(entry.getKey()));
						ArrayList<String> mktArr1 = mktArrMap.get(entry.getKey());
						ArrayList<String> groupArr = productCodeMap.get(entry.getKey());
						ArrayList<String> groupCodeArr = groupMap.get(entry.getKey());
						ArrayList<String> subGroupArr = sgroupMap.get(entry.getKey());
						itr = itemCodeSet.iterator();
						while(itr.hasNext())
						{
							String itemCode = itr.next().trim();
							columnArray.add(itemCode);
							columnArray.add(itemCode+"_RATE");
							columnArray.add(itemCode+"_TOTAL_VAL");
							columnArray.add(itemCode+"_TOTAL_QTY");
						}
						tempArr.add(columnArray);
						columnArray = null;

						columnArray = new org.json.simple.JSONArray();
						columnArray.add("Dealer");
						columnArray.add("LABEL");

						itr = itemDescrSet.iterator();
						while(itr.hasNext())
						{
							String itemCodeDescr = itr.next().trim();
							columnArray.add(itemCodeDescr);
							columnArray.add(itemCodeDescr+"_RATE");
							columnArray.add(itemCodeDescr+"_TOTAL_VAL");
							columnArray.add(itemCodeDescr+"_TOTAL_QTY");
						}
						tempArr.add(columnArray);
						columnArray = null;
						itr = null;
						columnArray = null;

						columnArray = new org.json.simple.JSONArray();
						JSONObject tempJson1 = getJSONObject();
						tempJson1.put("INPUT_TYPE", "text");
						tempJson1.put("FORMAT", "N");
						tempJson1.put("GROUP_ID", "--");
						tempJson1.put("DISPLAY", "Y");
						columnArray.add(tempJson1);
						JSONObject tempJson2 = getJSONObject();
						tempJson2.put("INPUT_TYPE", "text");
						tempJson2.put("FORMAT", "N");
						tempJson2.put("GROUP_ID", "--");
						tempJson2.put("DISPLAY", "Y");
						columnArray.add(tempJson2);
						//columnArray.add("text");
						//columnArray.add("text");
						itr = mktArr1.iterator();
						for(int i = 0 ; i < mktArr1.size(); i++)
						{
							JSONObject tempJson = getJSONObject();
							tempJson.put("INPUT_TYPE", "number");
							tempJson.put("FORMAT", mktArr1.get(i));
							//tempJson.put("FORMAT", "N");
							tempJson.put("GROUP_ID", subGroupArr.get(i));
							tempJson.put("DISPLAY", "Y");
							columnArray.add(tempJson);

							JSONObject temp1 = getJSONObject();
							temp1.put("INPUT_TYPE", "number");
							temp1.put("FORMAT", mktArr1.get(i));
							//temp1.put("FORMAT", "N");
							temp1.put("GROUP_ID", subGroupArr.get(i));
							temp1.put("DISPLAY", "N");
							columnArray.add(temp1);

							JSONObject temp2 = getJSONObject();
							temp2.put("INPUT_TYPE", "number");
							temp2.put("FORMAT", mktArr1.get(i));
							//temp2.put("FORMAT", "N");
							temp2.put("GROUP_ID", subGroupArr.get(i));
							temp2.put("DISPLAY", "N");
							columnArray.add(temp2);

							JSONObject temp3 = getJSONObject();
							temp3.put("INPUT_TYPE", "number");
							temp3.put("FORMAT", mktArr1.get(i));
							//temp3.put("FORMAT", "N");
							temp3.put("GROUP_ID", subGroupArr.get(i));
							temp3.put("DISPLAY", "N");
							columnArray.add(temp3);

						}
						tempArr.add(columnArray);
						columnArray = null;
						itr = null;
					}

					itmCodeArr = new ArrayList<String>();
					sellInQtyArr = new ArrayList<String>();
					sellOutQtyArr = new ArrayList<String>();
					rateArr = new ArrayList<String>();
					closingStockArray = new ArrayList<String>();

					labelArr = new ArrayList<String>();
					labelArr.add( "Sell-in(LM)" );
					labelArr.add( "Sell-out(LM)" );
					labelArr.add( "Closing stock" );
					labelArr.add( "Sell-in(plan)" );
					labelArr.add( "Sell-out(plan)" );

					counter++;
				}
			}
			else
			{
				boolean isDealerFound = false;
				sql = "SELECT COUNT(*) AS COUNT FROM ORG_STRUCTURE_STAN WHERE POS_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, posCode);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					if ( rs.getInt( "COUNT" ) > 0 )
					{
						isDealerFound = true;
					}
				}
				sql="";
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				boolean isVacantPos = isVacantPos( posCode, conn );
				String custType = getCustType(conn);
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
				String scSql= "";
				
				if ( "S".equalsIgnoreCase( status ) && tranId.length() > 0 )
				{
					scSql = "SELECT * FROM ( "
							+ " SELECT DISTINCT SELL_PLAN_DET.SC_CODE, DDF_GET_SC_CODE_NAME( SELL_PLAN_DET.SC_CODE ) DEALER_NAME "
							+ " FROM SELLS_PLANNING SELL_PLAN, SELLS_PLANNING_DET SELL_PLAN_DET "
							+ " WHERE SELL_PLAN.TRAN_ID = SELL_PLAN_DET.TRAN_ID "
							+ " AND SELL_PLAN.TRAN_ID = ? ) STRG_DET "
							+ " ORDER BY STRG_DET.DEALER_NAME, STRG_DET.SC_CODE ";
					
					//pstmt = conn.prepareStatement( scSql, ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE );
					pstmt = conn.prepareStatement( scSql);//Added By Bhagyashri T
					pstmt.setString(1, tranId);
				}
				else
				{
				if ( ! isDealerFound )
				{
					/*scSql = "SELECT * FROM ( "
							+ " SELECT DISTINCT CUST.SC_CODE,DDF_GET_SC_CODE_NAME( CUST.SC_CODE ) DEALER_NAME "
							+ " FROM STRG_SERIES SER, STRG_CUSTOMER CUST "
							+ " WHERE CUST.SC_CODE = SER.SC_CODE "
							+ " AND CUST.CUST_TYPE = ? And CUST.STATUS = ? and SER.SALES_PERS = ? ) STRG_DET "
							+ " ORDER BY STRG_DET.DEALER_NAME, STRG_DET.SC_CODE ";*/
					//Added by Bhagyashri T for DEactive Dealer Issue on[19/08/2022][start][W22EJOH005]
					scSql = "SELECT * FROM ( "
							+ " SELECT DISTINCT CUST.SC_CODE,DDF_GET_SC_CODE_NAME( CUST.SC_CODE ) DEALER_NAME "
							+ " FROM STRG_SERIES SER, STRG_CUSTOMER CUST "
							+ " WHERE CUST.SC_CODE = SER.SC_CODE "
							+ " AND CUST.CUST_TYPE = ? And CUST.STATUS = ? and SER.SALES_PERS = ? AND SER.STATUS = 'Y' ) STRG_DET "
							+ " ORDER BY STRG_DET.DEALER_NAME, STRG_DET.SC_CODE ";
					//Added by Bhagyashri T for DEactive Dealer Issue on[19/08/2022][end]
				}
				else
				{
					/*scSql = "SELECT * FROM ( "
							+ " SELECT DISTINCT CUST.SC_CODE,DDF_GET_SC_CODE_NAME( CUST.SC_CODE ) DEALER_NAME "
							+ " FROM STRG_SERIES SER, STRG_CUSTOMER CUST, ORG_STRUCTURE_STAN OS "
							+ " WHERE CUST.SC_CODE = SER.SC_CODE "
							+ " AND CUST.CUST_TYPE = ? And CUST.STATUS = ? "
							+ " AND OS.POS_CODE = ? "
							+ " AND CUST.STAN_CODE = OS.STAN_CODE "
							+ ") STRG_DET "
							+ " ORDER BY STRG_DET.DEALER_NAME, STRG_DET.SC_CODE";*/
					/*scSql = "SELECT * FROM ( "
							+ " SELECT DISTINCT CUST.SC_CODE,DDF_GET_SC_CODE_NAME( CUST.SC_CODE ) DEALER_NAME "
							+ " FROM STRG_SERIES SER, STRG_CUSTOMER CUST, ORG_STRUCTURE_STAN OS, SPRS_ROUTE SR "
							+ " WHERE CUST.SC_CODE = SER.SC_CODE AND CUST.CUST_TYPE = ? And CUST.STATUS = ? "
							+ " AND OS.POS_CODE = ? "
							+ " AND CUST.STAN_CODE = OS.STAN_CODE AND SR.ROUTE_ID = SER.ROUTE_ID "
							+ " AND SER.SALES_PERS = ? ) STRG_DET "
							+ " ORDER BY STRG_DET.DEALER_NAME, STRG_DET.SC_CODE ";*/
					//Added by Bhagyashri T for DEactive Dealer Issue on[19/08/2022][start][W22EJOH005]
					scSql = "SELECT * FROM ( "
							+ " SELECT DISTINCT CUST.SC_CODE,DDF_GET_SC_CODE_NAME( CUST.SC_CODE ) DEALER_NAME "
							+ " FROM STRG_SERIES SER, STRG_CUSTOMER CUST, ORG_STRUCTURE_STAN OS, SPRS_ROUTE SR "
							+ " WHERE CUST.SC_CODE = SER.SC_CODE AND CUST.CUST_TYPE = ? And CUST.STATUS = ? "
							+ " AND OS.POS_CODE = ? "
							+ " AND CUST.STAN_CODE = OS.STAN_CODE AND SR.ROUTE_ID = SER.ROUTE_ID "
							+ " AND SER.SALES_PERS = ?  AND SER.STATUS = 'Y' ) STRG_DET "
							+ " ORDER BY STRG_DET.DEALER_NAME, STRG_DET.SC_CODE ";
					//Added by Bhagyashri T for DEactive Dealer Issue on[19/08/2022][end]
				}
				//pstmt = conn.prepareStatement(scSql,ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
				pstmt = conn.prepareStatement(scSql);//added by Bhagyashri T
				pstmt.setString(1, custType);
				pstmt.setString(2, "A");
				if( ! isDealerFound )
				{
					if( isVacantPos )
					{
						pstmt.setString(3, userInfoBean.getLoginCode());
					}
					else
					{
						pstmt.setString(3, salesPers);
					}
				}
				else
				{
					pstmt.setString(3, posCode);
					pstmt.setString(4, userInfoBean.getLoginCode());
				}
				}
				rs1 = pstmt.executeQuery();
				while(rs1.next())
				{
					scCode = checkNull(rs1.getString("SC_CODE")).trim();;
					//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
					scCodeName = checkNull(rs1.getString("DEALER_NAME")).trim();
					scCodeNameMap.put( scCode, scCodeName );
					//scCodeSet.add(scCode);
				}
				if(rs1 != null)
				{
					rs1.close();
				}
				if(pstmt != null)
				{
					pstmt.close();
				}

				for( Map.Entry<String, String> scCodeMap : scCodeNameMap.entrySet()  )
				{
					scCode = scCodeMap.getKey();

					columnArray = new org.json.simple.JSONArray();
					//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
					if(tranId.length() > 0)
					{
						//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
						avgData = getExistingSellsPlanData( tranId,status, conn, scCode, stanCode, posCode, salesPers, prdCode, dateStr, groupWiseRoleCode, designCode );
					}
					else
					{
						//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
						avgData = getSellPanningData( tranId, conn, scCode, stanCode, posCode, salesPers, prdCode, dateStr, groupWiseRoleCode, designCode );
					}

					if(counter == 0 && avgData != null && ! avgData.isEmpty() )
					{
						columnArray.add("SC_CODE");
						columnArray.add("LABEL");
						LinkedHashSet<String> itemCodeSet = new LinkedHashSet<String>(avgData.get("ITEM_CODE"));
						LinkedHashSet<String> itemDescrSet = new LinkedHashSet<String>(avgData.get("ITEM_DESCR"));
						ArrayList<String> mktArr1 = avgData.get("MKT_ARR");
						ArrayList<String> groupArr = avgData.get("PRODUCT_CODE");
						ArrayList<String> groupCodeArr = avgData.get("GRP_CODE");
						ArrayList<String> subGroupArr = avgData.get("SGRP_CODE");
						itr = itemCodeSet.iterator();
						while(itr.hasNext())
						{
							String itemCode = itr.next().trim();
							columnArray.add(itemCode);
							columnArray.add(itemCode+"_RATE");
							columnArray.add(itemCode+"_TOTAL_VAL");
							columnArray.add(itemCode+"_TOTAL_QTY");
						}
						tempArr.add(columnArray);
						columnArray = null;

						columnArray = new org.json.simple.JSONArray();
						columnArray.add("Dealer");
						columnArray.add("LABEL");

						itr = itemDescrSet.iterator();
						while(itr.hasNext())
						{
							String itemCodeDescr = itr.next().trim();
							columnArray.add(itemCodeDescr);
							columnArray.add(itemCodeDescr+"_RATE");
							columnArray.add(itemCodeDescr+"_TOTAL_VAL");
							columnArray.add(itemCodeDescr+"_TOTAL_QTY");
						}
						tempArr.add(columnArray);
						columnArray = null;
						itr = null;
						columnArray = null;

						columnArray = new org.json.simple.JSONArray();
						JSONObject tempJson1 = getJSONObject();
						tempJson1.put("INPUT_TYPE", "text");
						tempJson1.put("FORMAT", "N");
						tempJson1.put("GROUP_ID", "--");
						tempJson1.put("DISPLAY", "Y");
						columnArray.add(tempJson1);
						JSONObject tempJson2 = getJSONObject();
						tempJson2.put("INPUT_TYPE", "text");
						tempJson2.put("FORMAT", "N");
						tempJson2.put("GROUP_ID", "--");
						tempJson2.put("DISPLAY", "Y");
						columnArray.add(tempJson2);
						/*columnArray.add("text");
						columnArray.add("text");*/
						itr = mktArr1.iterator();
						for(int i = 0 ; i < mktArr1.size(); i++)
						{
							JSONObject tempJson = getJSONObject();
							tempJson.put("INPUT_TYPE", "number");
							tempJson.put("FORMAT", mktArr1.get(i));
							/*tempJson.put("FORMAT", "N");*/
							tempJson.put("GROUP_ID", subGroupArr.get(i));
							tempJson.put("DISPLAY", "Y");
							columnArray.add(tempJson);

							JSONObject temp1 = getJSONObject();
							temp1.put("INPUT_TYPE", "number");
							temp1.put("FORMAT", mktArr1.get(i));
							/*temp1.put("FORMAT", "N");*/
							temp1.put("GROUP_ID", subGroupArr.get(i));
							temp1.put("DISPLAY", "N");
							columnArray.add(temp1);

							JSONObject temp2 = getJSONObject();
							temp2.put("INPUT_TYPE", "number");
							temp2.put("FORMAT", mktArr1.get(i));
							/*temp2.put("FORMAT", "N");*/
							temp2.put("GROUP_ID", subGroupArr.get(i));
							temp2.put("DISPLAY", "N");
							columnArray.add(temp2);

							JSONObject temp3 = getJSONObject();
							temp3.put("INPUT_TYPE", "number");
							temp3.put("FORMAT", mktArr1.get(i));
							/*temp3.put("FORMAT", "N");*/
							temp3.put("GROUP_ID", subGroupArr.get(i));
							temp3.put("DISPLAY", "N");
							columnArray.add(temp3);

						}
						tempArr.add(columnArray);
						columnArray = null;
						itr = null;
					}
					//System.out.println(" avgData : "+avgData);

					itmMap.put(scCode, avgData.get("ITEM_CODE"));
					sellInMap.put(scCode, avgData.get("SELL_IN_QTY"));
					sellOutMap.put(scCode, avgData.get("SELL_OUT_QTY"));
					sellInValMap.put(scCode, avgData.get("SELL_IN_VAL"));
					sellOutValMap.put(scCode, avgData.get("SELL_OUT_VAL"));
					closingMap.put(scCode, avgData.get("CLOSING_STOCK"));
					closingValMap.put(scCode, avgData.get("CLOSING_STOCK_VAL"));
					rateMap.put(scCode, avgData.get("RATE"));
					avgSellInQtyMap.put(scCode, avgData.get("AVG_SELL_IN_QTY"));
					avgSellOutQtyMap.put(scCode, avgData.get("AVG_SELL_OUT_QTY"));
					mktArrMap.put(scCode, avgData.get("MKT_ARR"));
					avgSellInValMap.put(scCode, avgData.get("AVG_SELL_IN_VAL"));
					avgSellOutValMap.put(scCode, avgData.get("AVG_SELL_OUT_VAL"));

					itmCodeArr = new ArrayList<String>();
					sellInQtyArr = new ArrayList<String>();
					sellOutQtyArr = new ArrayList<String>();
					rateArr = new ArrayList<String>();
					closingStockArray = new ArrayList<String>();

					labelArr = new ArrayList<String>();
					labelArr.add( "Sell-in(LM)" );
					labelArr.add( "Sell-out(LM)" );
					labelArr.add( "Closing stock" );
					labelArr.add( "Sell-in(plan)" );
					labelArr.add( "Sell-out(plan)" );
					counter++;
				}
			}

			HashMap<String, String> scCodeNamePRPMap = getPRPDealerMap( conn, posCode, scCodeNameMap );
			scCodeNamePRPwiseMap.putAll( scCodeNamePRPMap );
			
			for( Map.Entry<String, String> scCodeMap : scCodeNameMap.entrySet()  )
			{
				scCode = scCodeMap.getKey();
				dealerName = scCodeMap.getValue();

				if( ! scCodeNamePRPwiseMap.containsKey( scCode ) )
				{
					scCodeNamePRPwiseMap.put( scCode, dealerName );
				}
			}
			System.out.println( "after adding :: scCodeNamePRPMap ["+ scCodeNamePRPwiseMap +"]" );

			if( scCodeNamePRPwiseMap == null || scCodeNamePRPwiseMap.size() == 0 )
			{
				String errSting = genericUtility.getErrorString( "no_data_stk", "DLRNOTMAP", userInfoBean.getLoginCode() );
				JSONObject jsonObject = new JSONObject();
				jsonObject = excpUtility.convertXmlToJsonInError(errSting);
				tempArr = new org.json.simple.JSONArray();
				tempArr.add(jsonObject);
				return tempArr.toString();
			}

			scCode = "";
			//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
			for( Map.Entry<String, String> scCodeMap : scCodeNamePRPwiseMap.entrySet()  )
			{
				scCode = scCodeMap.getKey();
				dealerName = scCodeMap.getValue();

				itmCodeArr = itmMap.get(scCode);

				if ( itmCodeArr == null || itmCodeArr.size() == 0 )
				{
					String errSting = genericUtility.getErrorString( "no_data_stk", "ITEMNOTMAP", userInfoBean.getLoginCode() );
					JSONObject jsonObject = new JSONObject();
					jsonObject = excpUtility.convertXmlToJsonInError(errSting);
					tempArr = new org.json.simple.JSONArray();
					tempArr.add(jsonObject);
					return tempArr.toString();
				}

				sellInQtyArr = sellInMap.get(scCode);
				sellOutQtyArr = sellOutMap.get(scCode);
				//sellInValArr = sellInValMap.get(scCode);
				//sellOutValArr = sellOutValMap.get(scCode);
				closingStockArray = closingMap.get(scCode) ;
				//closingStkValArr = closingValMap.get(scCode) ;
				rateArr = rateMap.get(scCode);
				avgSellInQtyArr = avgSellInQtyMap.get(scCode);
				avgSellOutQtyArr = avgSellOutQtyMap.get(scCode);
				mktArr = mktArrMap.get(scCode);
				//avgSellInValArr = avgSellInValMap.get(scCode);
				//avgSellOutValArr = avgSellOutValMap.get(scCode);
				System.out.println("scCode : ["+scCode+"]  dealerName : ["+dealerName+"]");

				//Changed by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020
				//String isPrp = getPRPDetails( conn, posCode, scCode );
				String isPrp = "1";
				if ( scCodeNamePRPMap != null && scCodeNamePRPMap.containsKey( scCode ) )
				{
					isPrp = "0";
				}
				System.out.println( "isPrp ["+ isPrp +"]" );

				for ( int ctr = 0; ctr < labelArr.size(); ctr++ )
				{
					JSONObject tempJson = getJSONObject();
					tempJson.put( "SC_CODE_ACTUAL", scCode );
					tempJson.put( "SC_CODE", dealerName );
					tempJson.put( "SC_CODE_P", "1" );
					if("Sell-in(LM)".equalsIgnoreCase(labelArr.get( ctr )))
					{
						tempJson.put( "LABEL", labelArr.get( ctr ) );
						tempJson.put( "LABEL_P", "1" );
						for ( int ctr2 = 0; ctr2 < itmCodeArr.size(); ctr2++ )
						{
							/*if("Y".equalsIgnoreCase(mktArr.get(ctr2)))
							{
								tempJson.put( itmCodeArr.get( ctr2 ), sellInValArr.get( ctr2 ) );
								tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
								//tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", "1" );
							}
							else
							{*/
								tempJson.put( itmCodeArr.get( ctr2 ), ""+Math.round( Double.parseDouble( sellInQtyArr.get( ctr2 ) ) ) );
								tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
							//}
							tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", rateArr.get( ctr2 ) );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_VAL", "" );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_QTY", "" );

						}
					}
					else if("Sell-out(LM)".equalsIgnoreCase(labelArr.get( ctr )))
					{
						tempJson.put( "LABEL", labelArr.get( ctr ) );
						tempJson.put( "LABEL_P", "1" );
						for ( int ctr2 = 0; ctr2 < itmCodeArr.size(); ctr2++ )
						{
							/*if("Y".equalsIgnoreCase(mktArr.get(ctr2)))
							{
								tempJson.put( itmCodeArr.get( ctr2 ), sellOutValArr.get( ctr2 ) );
								tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
								tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", "1" );
							}
							else
							{*/
								tempJson.put( itmCodeArr.get( ctr2 ), ""+Math.round( Double.parseDouble( sellOutQtyArr.get( ctr2 ) ) ) );
								tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
							//}
							tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", rateArr.get( ctr2 ) );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_VAL", "" );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_QTY", "" );
						}
					}
					else if("Closing stock".equalsIgnoreCase(labelArr.get( ctr )))
					{
						tempJson.put( "LABEL", labelArr.get( ctr ) );
						tempJson.put( "LABEL_P", "1" );
						for ( int ctr2 = 0; ctr2 < itmCodeArr.size(); ctr2++ )
						{
							/*if("Y".equalsIgnoreCase(mktArr.get(ctr2)))
							{
								tempJson.put( itmCodeArr.get( ctr2 ), closingStkValArr.get( ctr2 ) );
								tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
								tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", "1" );
							}
							else
							{*/
								tempJson.put( itmCodeArr.get( ctr2 ), ""+Math.round( Double.parseDouble( closingStockArray.get( ctr2 ) ) ) );
								tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
							//}
							tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", rateArr.get( ctr2 ) );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_VAL", "" );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_QTY", "" );
						}
					}
					else if("Sell-in(plan)".equalsIgnoreCase(labelArr.get( ctr )))
					{
						if( "S".equalsIgnoreCase(status) || isMgr )
						{
							tempJson.put( "LABEL", labelArr.get( ctr ) );
							tempJson.put( "LABEL_P", "1" );
						}
						else
						{
							tempJson.put( "LABEL", labelArr.get( ctr ) );
							tempJson.put( "LABEL_P", "0" );
						}
						for ( int ctr2 = 0; ctr2 < itmCodeArr.size(); ctr2++ )
						{
							/*if("Y".equalsIgnoreCase(mktArr.get(ctr2)))
							{
								tempJson.put( itmCodeArr.get( ctr2 ), avgSellInValArr.get( ctr2 ) );
								if("S".equalsIgnoreCase(status))
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
								}
								else
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "0" );
								}
								tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", "1" );
							}
							else
							{*/
								if( ! isMgr && isPrp.equalsIgnoreCase( "1" ) && "Y".equalsIgnoreCase( mktArr.get(ctr2) )  )
								{
									tempJson.put( itmCodeArr.get( ctr2 ), "0" );
								}
								else
								{
									tempJson.put( itmCodeArr.get( ctr2 ), ""+Math.round( Double.parseDouble( avgSellInQtyArr.get( ctr2 ) ) ) );
								}
								//tempJson.put( itmCodeArr.get( ctr2 ), ""+Math.round( Double.parseDouble( avgSellInQtyArr.get( ctr2 ) ) ) );
								//Changed by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020
								if( "S".equalsIgnoreCase(status) || isMgr || ( isPrp.equalsIgnoreCase( "1" ) && "Y".equalsIgnoreCase( mktArr.get(ctr2) ) ) )
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
								}
								else
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "0" );
								}
							//}
							tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", rateArr.get( ctr2 ) );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_VAL", "" );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_QTY", "" );
						}
					}
					else if("Sell-out(plan)".equalsIgnoreCase(labelArr.get( ctr )))
					{
						if( "S".equalsIgnoreCase(status) || isMgr )
						{
							tempJson.put( "LABEL", labelArr.get( ctr ) );
							tempJson.put( "LABEL_P", "1" );
						}
						else
						{
							tempJson.put( "LABEL", labelArr.get( ctr ) );
							tempJson.put( "LABEL_P", "0" );
						}
						for ( int ctr2 = 0; ctr2 < itmCodeArr.size(); ctr2++ )
						{
							/*if("Y".equalsIgnoreCase(mktArr.get(ctr2)))
							{
								tempJson.put( itmCodeArr.get( ctr2 ), avgSellOutValArr.get( ctr2 ) );
								if("S".equalsIgnoreCase(status))
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
								}
								else
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "0" );
								}

								tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", "1" );
							}
							else
							{*/
								if( ! isMgr && isPrp.equalsIgnoreCase( "1" ) && "Y".equalsIgnoreCase( mktArr.get(ctr2) ) )
								{
									tempJson.put( itmCodeArr.get( ctr2 ), "0" );
								}
								else
								{
									tempJson.put( itmCodeArr.get( ctr2 ), ""+Math.round( Double.parseDouble( avgSellOutQtyArr.get( ctr2 ) ) ) );
								}
								//tempJson.put( itmCodeArr.get( ctr2 ), ""+Math.round( Double.parseDouble( avgSellOutQtyArr.get( ctr2 ) ) ) );
								//Changed by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020
								if( "S".equalsIgnoreCase(status) || isMgr || ( isPrp.equalsIgnoreCase( "1" ) && "Y".equalsIgnoreCase( mktArr.get(ctr2) ) ) )
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "1" );
								}
								else
								{
									tempJson.put( itmCodeArr.get( ctr2 )+"_P", "0" );
								}
							//}
							tempJson.put( itmCodeArr.get( ctr2 ) +"_RATE", rateArr.get( ctr2 ) );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_VAL", "" );
							tempJson.put( itmCodeArr.get( ctr2 )+ "_TOTAL_QTY", "" );
						}
					}
					tempArr.add(tempJson);
				}
			}

			for(int ctr = 3; ctr < labelArr.size() ; ctr ++)
			{
				//System.out.println(""+labelArr.get(3));
				JSONObject jsonObject = getJSONObject();
				jsonObject.put("SC_CODE", "Total Quantity");
				jsonObject.put("SC_CODE_P", "1");
				jsonObject.put("LABEL" ,labelArr.get(ctr));
				jsonObject.put("LABEL_P" ,"1");
				for( int ctr1 = 0 ; ctr1 < itmCodeArr.size() ; ctr1 ++)
				{
					jsonObject.put(itmCodeArr.get(ctr1), "");
					jsonObject.put(itmCodeArr.get(ctr1)+"_P", "1");
					jsonObject.put(itmCodeArr.get(ctr1) + "_RATE", "1");
					jsonObject.put(itmCodeArr.get(ctr1) + "_TOTAL_VAL", "");
					jsonObject.put(itmCodeArr.get(ctr1) + "_TOTAL_QTY", "");
				}
				tempArr.add(jsonObject);
				jsonObject = null;
			}

			for(int ctr = 3; ctr < labelArr.size() ; ctr ++)
			{
				//System.out.println(""+labelArr.get(3));
				JSONObject jsonObject = getJSONObject();
				jsonObject.put("SC_CODE", "Total Value in INR(000)");
				jsonObject.put("SC_CODE_P", "1");
				jsonObject.put("LABEL" ,labelArr.get(ctr));
				jsonObject.put("LABEL_P" ,"1");
				for( int ctr1 = 0 ; ctr1 < itmCodeArr.size() ; ctr1 ++)
				{
					jsonObject.put(itmCodeArr.get(ctr1), "");
					jsonObject.put(itmCodeArr.get(ctr1)+"_P", "1");
					jsonObject.put(itmCodeArr.get(ctr1) + "_RATE", "1");
					jsonObject.put(itmCodeArr.get(ctr1) + "_TOTAL_VAL", "");
					jsonObject.put(itmCodeArr.get(ctr1) + "_TOTAL_QTY", "");
				}
				tempArr.add(jsonObject);
				jsonObject = null;
			}
			if( "S".equalsIgnoreCase(status) )
			{
				JSONObject jsonObject = getJSONObject();
				jsonObject.put("status", status);
				tempArr.add(jsonObject);
			}
			//System.out.println("scCodeSet : "+scCodeSet);
		}
		catch( Exception e )
		{
			e.printStackTrace();
			System.out.println( "Exception :: SellsStock.getSalesPlanData() : ["+ e.getMessage() +"]" );

			tempArr = excpUtility.handleException( e );
		}
		finally
		{
			if(conn != null)
			{
				try
				{
					conn.close();
					conn = null;
					if( rs1 != null)
					{
						rs1.close();
						rs1= null;
					}
					if( pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
			}
		}
		//System.out.println("JSONArray "+ tempArr.toString());
		return tempArr.toString();
	}

	/*private static JSONObject getStkSellsData(String scCode,String label,ArrayList<String> itmCodeArr,ArrayList<String> list,ArrayList<String> rate)
	{
		JSONObject jsonObject1 = getJSONObject();
		try
		{
			jsonObject1.put("SC_CODE",scCode);
			jsonObject1.put("LABEL",label);
			for (int i = 0; i < itmCodeArr.size(); i++)
			{
				jsonObject1.put(itmCodeArr.get(i).trim(),list.get(i));
				jsonObject1.put(itmCodeArr.get(i).trim()+ "_RATE",rate.get(i));
				jsonObject1.put(itmCodeArr.get(i).trim()+ "_TOTAL","");
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception getStkSellsData "+e.getMessage());
		}
		System.out.println("getStkSellsData    :: "+jsonObject1);
		return jsonObject1;
	}*/

	public String insertPlanningData( final String allData, final UserInfoBean userInfo )
	{
		System.out.println( "SellAndStockService.insertPlanningData() ["+ allData +"]" );
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null;
		String tranID = "", status = "", allTranIds = "";
		Map<String, String> statusMap = new HashMap<>();
		String action = "";
		JSONObject responseObject = new JSONObject();
		JSONArray jsonArray = new JSONArray();
		try
		{
			if( userInfo != null )
			{
				conn = connDriver.getConnectDB(userInfo.getTransDB());
				conn.setAutoCommit( false );
			}

			JSONObject json = new JSONObject(allData);
			JSONObject headerJson = (JSONObject)json.get("headerFormData");

			String salesPers = headerJson.getString("sales_pers");
			String prdCode = headerJson.getString("prd_code");
			String stanCode = headerJson.getString("stan_code");
			String posCode = headerJson.getString("pos_code");
			//String levelNo = headerJson.getString("level_no");
			action = headerJson.getString("flag");
			final String prdDescr = headerJson.getString("descr");

			String tempPosCode = posCode.replace(",", "','");
			boolean isMgr = isPlanningMgr( tempPosCode, conn );
			if ( isMgr )
			{
				String str = "SELECT PE.POS_CODE, PE.STAN_CODE, PE.EMP_CODE, PE.STATUS " +
						" FROM TABLE( GETPLANNINGTEAMDATA.GETPOSCODESTANCODEDET( '"+ posCode +"', ? ) ) PE ";
				pstmt = conn.prepareStatement(str);
				pstmt.setString(1, prdCode);
				ResultSet rs = pstmt.executeQuery();
				while ( rs.next() )
				{
					if ( ! "S".equalsIgnoreCase( rs.getString( "STATUS" ) ) )
					{
						String errSting = genericUtility.getErrorString( "no_data_stk", "VTALPLNSUB", userInfo.getLoginCode() );
						JSONObject jsonObject = new JSONObject();
						jsonObject = excpUtility.convertXmlToJsonInError(errSting);
						jsonArray = new JSONArray();
						jsonArray.add( jsonObject );
						return jsonArray.toString();
					}
				}

				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}

			DBAccessEJB dbAcc = new DBAccessEJB();

			String[] posCodeArr = posCode.split(",");
			String[] stanCodeArr = stanCode.split(",");

			org.json.JSONArray jsonArr = (org.json.JSONArray)json.get("detailFormData");
			for ( int ctr = 0; ctr < posCodeArr.length; ctr++ )
			{
				tranID = "";
				String posCodeTemp = checkNull( posCodeArr[ctr] );
				String stanCodeTemp = checkNull( stanCodeArr[ctr] );
				System.out.println( "posCodeTemp : ["+ posCodeTemp +"], stanCodeTemp ["+ stanCodeTemp +"]" );

				JSONObject posCodeJson = new JSONObject();
				posCodeJson.put( "stan_code", stanCodeTemp );
				posCodeJson.put( "pos_code", posCodeTemp );
				posCodeJson.put( "prd_code", prdCode );
				posCodeJson.put( "sales_pers", salesPers );
				//posCodeJson.put( "level_no", levelNo );
				posCodeJson.put( "force_save", "Y" );

				if( posCodeArr.length > 1 )
				{
					jsonArr = new org.json.JSONArray( getSellsPlanData( posCodeJson.toString(), userInfo ) );
					System.out.println( "pos_code : ["+ posCodeTemp +"], jsonArr : ["+ jsonArr +"]" );
				}

				statusMap = isSellsPlanDataExist( stanCodeTemp, posCodeTemp, salesPers, prdCode, conn );
				if( statusMap.size() > 0 )
				{
					tranID = statusMap.get("TRAN_ID");
					status = statusMap.get("STATUS");
				}

				if( tranID.trim().length() > 0 )
				{
					//org.json.JSONArray jsonArr = (org.json.JSONArray)json.get("detailFormData");

					deleteSellPlanningDet( tranID, conn );
					sellPlanDetData( jsonArr, tranID, conn, false );
				}
				else
				{
					tranID = dbAcc.generateTranId("W_SELL_PLANNING", userInfo.getSiteCode(), userInfo.getLoginCode(), conn);
					String insertSql = "Insert into SELLS_PLANNING (TRAN_ID,TRAN_DATE,SALES_PERS,PRD_CODE,STATUS,ADD_DATE,ADD_USER,"
							+ "ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM, STAN_CODE, POS_CODE) " +
							"values (?,?,?,?,?,?,?,?,?,?,?,?,?)" ;

					//Date currDate = new Date();
					//SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.APPL_DATE_FORMAT);
					//String date = sdf.format(currDate);

					pstmt = conn.prepareStatement(insertSql);
					pstmt.setString(1, tranID);
					pstmt.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));
					pstmt.setString(3, salesPers);
					pstmt.setString(4, prdCode);
					pstmt.setString(5, "D");
					pstmt.setTimestamp(6, new java.sql.Timestamp(System.currentTimeMillis()));
					pstmt.setString(7, userInfo.getLoginCode());
					pstmt.setString(8, userInfo.getRemoteHost());
					pstmt.setTimestamp(9, new java.sql.Timestamp(System.currentTimeMillis()));
					pstmt.setString(10, userInfo.getLoginCode());
					pstmt.setString(11, userInfo.getRemoteHost());
					pstmt.setString(12, stanCodeTemp);
					pstmt.setString(13, posCodeTemp);

					//System.out.println("insertSql Header SQL "+insertSql);
					int updatedheader = pstmt.executeUpdate();

					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if( updatedheader > 0 )
					{
						//org.json.JSONArray jsonArr = (org.json.JSONArray)json.get("detailFormData");
						sellPlanDetData( jsonArr, tranID, conn, false );
					}
				}
				if( allTranIds.length() == 0)
				{
					allTranIds = tranID;
				}
				else
				{
					allTranIds += "," + tranID;
				}
			}
			if( action.equals("submit") || action.equals("approve") )
			{
				System.out.println( "allTranIds ["+ allTranIds +"]" );
				if( allTranIds.contains(",") )
				{
					allTranIds = allTranIds.replace( ",", "','" );
				}
				final String tranIDRef = allTranIds;

				String str = "UPDATE SELLS_PLANNING SET STATUS = ?, CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ? WHERE TRAN_ID in ( '"+ tranIDRef +"' )";
				pstmt = conn.prepareStatement(str);
				pstmt.setString(1, "S");
				pstmt.setString(2, userInfo.getRemoteHost());
				pstmt.setString(3, userInfo.getLoginCode());
				int count = pstmt.executeUpdate();
				System.out.println( "["+ count +"] status updated" );

				String errSting = "";
				if( action.equals("approve") )
				{
					errSting = genericUtility.getErrorString( "tran_id", "VTSUBAPPRV", userInfo.getLoginCode() );
				}
				else
				{
					errSting = genericUtility.getErrorString( "tran_id", "VTSUBSUCFL", userInfo.getLoginCode() );
				}

				JSONObject successMsg = excpUtility.convertXmlToJsonInError(errSting);

				responseObject.put( "tran_id", allTranIds );
				responseObject.put( "success_msg", successMsg );
				//jsonArray.add(responseObject);

				sendNotification( allData, prdCode, tranIDRef, "", action, userInfo );
				if ( ! isMgr )
				{
					updatePoolSellOut( posCode, stanCode, null, prdCode, "salesPlanning", userInfo );
				}
			}
			else
			{
				//System.out.println("No Notification.............  ");
				String errSting = genericUtility.getErrorString( "tran_id", "VTEDISUCC", userInfo.getLoginCode() );
				JSONObject successMsg = excpUtility.convertXmlToJsonInError(errSting);

				responseObject.put( "tran_id", allTranIds );
				responseObject.put( "success_msg", successMsg );
			}
			if( conn != null )
			{
				conn.commit();
			}
			jsonArray.add( responseObject );
		}
		catch (Exception e)
		{
			try
			{
				if( conn != null )
				{
					conn.rollback();
				}
			}
			catch (SQLException e1)
			{
				e1.printStackTrace();
			}
			//throw new ITMException( e );
			e.printStackTrace();
			System.out.println( "Exception :: SellsStock.insertPlanningData() : ["+ e.getMessage() +"]" );

			jsonArray = excpUtility.handleException( e );
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return jsonArray.toString();
	}

	private void sellPlanDetData( org.json.JSONArray jsonArr, String tranID,Connection conn, boolean updateFlag ) throws ITMException
	{
		String scCode ="";
		//ArrayList<String> itemCodeValueArr = new ArrayList<String>();
		ArrayList<String> scCodeArr = new ArrayList<String>();
		//ArrayList<String> sellOutValueArr = new ArrayList<String>();
		Map<String, ArrayList<String>> sellInDetMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellOutDetMap = new HashMap<String, ArrayList<String>>();
		org.json.JSONArray columnSellPlanDetArr = new org.json.JSONArray();
		//org.json.JSONArray labelSellPlanDetArr = new org.json.JSONArray();
		Map<String, Multivalues> allData = new HashMap<String, Multivalues>();
		//DistCommon distCommon = new DistCommon();
		//Date curDate = new Date();
		try
		{
			//SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
			columnSellPlanDetArr = (org.json.JSONArray)jsonArr.get(0);
			//labelSellPlanDetArr = (org.json.JSONArray)jsonArr.get(1);
			ArrayList<String> wRateTotalArr = new ArrayList<String>();

			for( int columnCtr = 0; columnCtr < columnSellPlanDetArr.length(); columnCtr++ )
			{
				if(((String)columnSellPlanDetArr.get(columnCtr)).contains("_RATE")|| ((String)columnSellPlanDetArr.get(columnCtr)).contains("_TOTAL"))
					continue;

				wRateTotalArr.add(((String)columnSellPlanDetArr.get(columnCtr)).trim());
			}

			for( int jsonCtr = 3; jsonCtr < jsonArr.length(); jsonCtr++ )
			{
				JSONObject tempJsonObj = (JSONObject)jsonArr.get(jsonCtr);
				if(((String)tempJsonObj.get("LABEL")).equals("Sell-out(LM)") || ((String)tempJsonObj.get("LABEL")).equals("Closing stock")
						|| ((String)tempJsonObj.get("LABEL")).equals("Sell-in(LM)") || ((String)tempJsonObj.get("SC_CODE")).equals("Total Quantity")
						|| ((String)tempJsonObj.get("SC_CODE")).equals("Total Value in INR(000)") )
				{
					continue;
				}
				else
				{
					//scCode = (String)tempJsonObj.get("SC_CODE");
					scCode = (String)tempJsonObj.get("SC_CODE_ACTUAL");
					scCodeArr.add(scCode);
					if(((String)tempJsonObj.get("LABEL")).equals("Sell-in(plan)"))
					{
						ArrayList<String> sellInDatArr = new ArrayList<String>();
						for( int ctr = 2; ctr < wRateTotalArr.size(); ctr++ )
						{
							sellInDatArr.add((String)tempJsonObj.get(wRateTotalArr.get(ctr)));
						}
						sellInDetMap.put(scCode, sellInDatArr);
					}
					else if(((String)tempJsonObj.get("LABEL")).equals("Sell-out(plan)"))
					{
						ArrayList<String> SellOutDatArr = new ArrayList<String>();
						for(int ctr = 2; ctr < wRateTotalArr.size(); ctr++)
						{
							SellOutDatArr.add((String)tempJsonObj.get(wRateTotalArr.get(ctr)));
						}
						sellOutDetMap.put(scCode, SellOutDatArr);
					}
				}
			}
			System.out.println( "wRateTotalArr.size() :: ["+ wRateTotalArr.size() +"]" );
			System.out.println( "scCodeArr.size() :: ["+ scCodeArr.size() +"]" );
			System.out.println( "sellInDetMap.size() :: ["+ sellInDetMap.size() +"]" );
			System.out.println( "sellOutDetMap.size() :: ["+ sellOutDetMap.size() +"]" );

			for ( int i = 0; i < scCodeArr.size(); i++ )
			{
				scCode = scCodeArr.get( i );
				System.out.println( "scCode :: ["+ scCode +"]" );
				ArrayList<String> sellInArr = sellInDetMap.get( scCodeArr.get(i) );
				ArrayList<String> sellOutArr = sellOutDetMap.get( scCodeArr.get(i) );
				Multivalues multivalues = new Multivalues( sellInArr, sellOutArr );
				allData.put( scCodeArr.get(i), multivalues );
			}
			wRateTotalArr.remove(0);
			wRateTotalArr.remove(0);
			/*System.out.println("allData Size ::: "+allData.size());
			System.out.println("wRateTotalArr Size ::: "+wRateTotalArr);*/
			//double rate = distCommon.pickRate( priceList, sdf.format(curDate), itemCode, conn );

			/*if(updateFlag)
			{
				insertSellPlanDetDat(tranID, allData, wRateTotalArr, conn, true);
			}
			else
			{
				insertSellPlanDetDat(tranID, allData, wRateTotalArr, conn, false);
			}*/
			insertSellPlanDetData( tranID, allData, wRateTotalArr, conn, updateFlag );
		}
		catch (Exception e)
		{
			System.out.println( "SellsStock.sellPlanDetData() Exception : ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
	}

	private void insertSellPlanDetData( String tranId, Map<String, Multivalues> allData, ArrayList<String> itemArray, Connection conn, boolean updateFlag ) throws ITMException
	{
		String sellInQty = "", sellOutQty = "", itemCode = "", scCode = "";
		int lineNo = 0;
		PreparedStatement pstmt = null;
		//PreparedStatement pstmt1 = null;
		//ResultSet rs1 = null;
		StringBuilder builder = null;
		//DistCommon distCommon = new DistCommon();
		//Date curDate = new Date();
		try
		{
			HashMap<String, HashMap<String, String>> itemDetailMap = getItemDetails( itemArray, conn );

			//SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
			Set<Map.Entry<String, Multivalues>> allDataKeySet = allData.entrySet();
			Iterator<Map.Entry<String, Multivalues>> allDataItr = allDataKeySet.iterator();
			if( updateFlag )
			{
				builder = new StringBuilder();
				builder.append("UPDATE SELLS_PLANNING_DET SET SELL_IN_QTY = ? , SELL_OUT_QTY = ? , SELL_IN_VALUE = ? , SELL_OUT_VALUE = ? ");
				builder.append("WHERE TRAN_ID = ? AND SC_CODE = ? AND ITEM_CODE = ? AND LINE_NO = ?");
			}
			else
			{
				builder = new StringBuilder();
				builder = builder.append("INSERT INTO SELLS_PLANNING_DET ( TRAN_ID,LINE_NO,ITEM_CODE,SC_CODE,SELL_IN_QTY,SELL_OUT_QTY,SELL_IN_VALUE,SELL_OUT_VALUE, MKT_ARR) ");
				builder.append("values (?,?,?,?,?,?,?,?,?)");
			}
			pstmt = conn.prepareStatement(builder.toString());

			double sellInVal = 0;
			double sellOutVal = 0;
			while(allDataItr.hasNext())
			{
				Map.Entry<String, Multivalues> obj = allDataItr.next();
				Multivalues sellInOutValues = obj.getValue();
				scCode = obj.getKey();
				ArrayList<String> sellInArr = sellInOutValues.getInArr();
				ArrayList<String> sellOutArr = sellInOutValues.getOutArr();
				lineNo = 0;
				for (int i = 0; i < sellInArr.size(); i++)
				{
					lineNo++;
					sellInQty = checkNull( sellInArr.get(i) );
					if ( sellInQty.length() == 0 )
					{
						sellInQty = "0";
					}
					sellOutQty = checkNull( sellOutArr.get(i) );
					if ( sellOutQty.length() == 0 )
					{
						sellOutQty = "0";
					}
					itemCode = itemArray.get(i);

					HashMap<String, String> itemCodeMap = itemDetailMap.get( itemCode );
					String mktArr = itemCodeMap.get( "MKT_ARR" );
					double rate = Double.parseDouble(itemCodeMap.get( "RATE" ));

					sellInVal = Double.parseDouble(sellInQty) * rate;
					sellOutVal = Double.parseDouble(sellOutQty) * rate;

					if( updateFlag )
					{
						if ( ! mktArr.equalsIgnoreCase("Y") )
						{
							pstmt.setString(1, sellInQty);
							pstmt.setString(2, sellOutQty);
							pstmt.setDouble(3, sellInVal);
							pstmt.setDouble(4, sellOutVal);
						}
						else
						{
							/*pstmt.setString(1, "0");
							pstmt.setString(2, "0");
							pstmt.setString(3, sellInQty);
							pstmt.setString(4, sellOutQty);*/
							pstmt.setString(1, sellInQty);
							pstmt.setString(2, sellOutQty);
							pstmt.setDouble(3, sellInVal);
							pstmt.setDouble(4, sellOutVal);
						}
						pstmt.setString(5, tranId);
						pstmt.setString(6, scCode);
						pstmt.setString(7, itemCode);
						pstmt.setString(8, lineNo+"");
						pstmt.addBatch();
					}
					else
					{
						pstmt.setString(1, tranId);
						pstmt.setString(2, lineNo+"");
						pstmt.setString(3, itemCode);
						pstmt.setString(4, scCode);
						if( ! mktArr.equalsIgnoreCase("Y") )
						{
							pstmt.setString(5, sellInQty);
							pstmt.setString(6, sellOutQty);
							pstmt.setDouble(7, sellInVal);
							pstmt.setDouble(8, sellOutVal);
						}
						else
						{
							/*pstmt.setString(5, "0");
							pstmt.setString(6, "0");
							pstmt.setString(7, sellInQty);
							pstmt.setString(8, sellOutQty);*/
							pstmt.setString(5, sellInQty);
							pstmt.setString(6, sellOutQty);
							pstmt.setDouble(7, sellInVal);
							pstmt.setDouble(8, sellOutVal);
						}
						pstmt.setString(9, mktArr);
						pstmt.addBatch();
					}
				}
				int result[] = pstmt.executeBatch();
				System.out.println( "For scCode : ["+ scCode +"], ["+ result.length +"] rows inserted" );
				/*if( result.length > 0 )
				{
					conn.commit();
				}*/
			}
			if(pstmt != null)
			{
				pstmt.close();
			}
		}
		catch (SQLException e)
		{
			System.out.println( "SellsStock.insertSellPlanDetDat() SQLException : ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
		catch (Exception e)
		{
			System.out.println( "SellsStock.insertSellPlanDetDat() Exception : ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
	}

	private Map<String, String> isSellsPlanDataExist( String stanCode, String posCode, String salesPers, String prdCode, Connection con )
	{
		Map<String, String> map = new HashMap<String, String>();
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		try
		{
			String tranId = "", status = "";

			String str = "SELECT TRAN_ID, STATUS FROM SELLS_PLANNING WHERE STAN_CODE = ? AND POS_CODE = ? AND PRD_CODE = ?";
			pStmt = con.prepareStatement(str);
			pStmt.setString(1, stanCode);
			pStmt.setString(2, posCode);
			pStmt.setString(3, prdCode);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				tranId = checkNull( rs.getString("TRAN_ID") );
				status = checkNull( rs.getString("STATUS") );

				map.put("TRAN_ID", tranId);
				map.put("STATUS", status);
			}

			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :: SellsStock.isSellsPlanDataExist() : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return map;
	}

	class Multivalues
	{
		ArrayList<String> inArr;
		ArrayList<String> outArr;
		public Multivalues() {
		}

		public Multivalues(ArrayList<String> inArr , ArrayList<String> outArr)
		{
			this.inArr = inArr;
			this.outArr = outArr;
		}

		public ArrayList<String> getInArr() {
			return inArr;
		}

		public void setInArr(ArrayList<String> inArr) {
			this.inArr = inArr;
		}

		public ArrayList<String> getOutArr() {
			return outArr;
		}

		public void setOutArr(ArrayList<String> outArr) {
			this.outArr = outArr;
		}

		@Override
		public String toString() {
			return (this.inArr+" ::: "+this.outArr);
		}
	}

	public String itmDefaultSellsPlanning( UserInfoBean userInfoBean )
	{
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String transDB = userInfoBean.getTransDB();
		JSONObject jsonObject = new JSONObject();
		Date currDate = new Date();
		String sql ="",userCode = "",loginEmpCode = "",sales_pers = "",sp_name="";
		String prdCode = "",prdCodeDescr = "",posCodeDescr = "",posCode ="",stanCode ="";
		Timestamp valueOfCurrDate;
		try
		{
			conn = connDriver.getConnectDB(transDB);
			userCode = checkNull(userInfoBean.getLoginCode());
			loginEmpCode = checkNull(userInfoBean.getEmpCode());

			SimpleDateFormat sdfAppl = new SimpleDateFormat(DATE_FORMAT);
			valueOfCurrDate = Timestamp.valueOf(genericUtility.getValidDateString(sdfAppl.format(currDate),DATE_FORMAT,genericUtility.getDBDateFormat())
					+ " 00:00:00.0");

			//Changed By Vikas Lagad Start
			/*sql = "SELECT FN_GET_TERRITORY(?,?) AS POS_CODE_DESCR FROM DUAL";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, loginEmpCode);
			pStmt.setString(2, loginEmpCode);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				posCodeDescr = checkNull(rs.getString("POS_CODE_DESCR"));
				jsonObject.put("pos_code_descr", posCodeDescr);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			if( posCodeDescr.contains(",") )
			{
				posCodeDescr = posCodeDescr.replace(",", "','");
			}*/
			int levelNo = 0;
			sql = "SELECT LISTAGG(POS_CODE, ',') WITHIN GROUP (ORDER BY POS_CODE) POS_CODE, "
					+ " LISTAGG(DESCR, ',') WITHIN GROUP (ORDER BY DESCR) POS_CODE_DESCR, "
					+ " LISTAGG(STAN_CODE__HQ, ',') WITHIN GROUP (ORDER BY STAN_CODE__HQ) STAN_CODE__HQ,"
					+ " LEVEL_NO "
					+ " FROM ORG_STRUCTURE WHERE EMP_CODE = ? "
					+ " GROUP BY LEVEL_NO";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString( 1, loginEmpCode );
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				posCode = rs.getString("POS_CODE");
				stanCode = rs.getString("STAN_CODE__HQ");
				levelNo = rs.getInt("LEVEL_NO");
				posCodeDescr = checkNull(rs.getString("POS_CODE_DESCR"));
				jsonObject.put("pos_code", posCode);
				jsonObject.put("stan_code", stanCode);
				//jsonObject.put("level_no", levelNo);
				jsonObject.put("pos_code_descr", posCodeDescr);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			String tempPosCode = posCode.replace(",", "','");
			boolean isMgr = isPlanningMgr( tempPosCode, conn );
			/*if ( ! isMgr )
			{
				levelNo = 8;
				jsonObject.put("level_no", levelNo);
			}*/
			jsonObject.put( "is_mgr", isMgr );

			/*sql = "SELECT POS_CODE,STAN_CODE__HQ FROM ORG_STRUCTURE WHERE emp_code = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, loginEmpCode);
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				posCode = rs.getString("POS_CODE");
				stanCode = rs.getString("STAN_CODE__HQ");
				jsonObject.put("pos_code", posCode);
				jsonObject.put("stan_code", stanCode);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}*/
			//Changed By Vikas Lagad End

			sql ="SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, loginEmpCode);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				sales_pers = rs.getString("SP_NAME");
				jsonObject.put("sp_name", sales_pers);
				jsonObject.put("sales_pers", loginEmpCode);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			sql = "SELECT SH_DESCR,CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			pStmt = conn.prepareStatement(sql);
			pStmt.setTimestamp(1, valueOfCurrDate);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				prdCode = rs.getString("CODE");
				prdCodeDescr = rs.getString("SH_DESCR");
				jsonObject.put("prd_code", prdCode);
				jsonObject.put("prd_code_descr", prdCodeDescr);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			System.out.println( "Sells Planning jsonObject ["+ jsonObject.toString() +"]" );
			getMgrData( loginEmpCode, posCode, prdCode, jsonObject, conn );
		}
		catch (Exception e)
		{
			System.out.println("Sells Planning Exception  ["+e.getMessage()+"]");
		}
		finally {
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Sells Planning Itm default"+e);
			}
		}
		return jsonObject.toString();
	}
	//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]

	private Map<String, ArrayList<String>> getExistingSellsPlanData( String tranId,String status, Connection conn, String scCode, String stanCode, String posCode, String salesPers, String prdCode, String dateStr, HashMap<String, List<String>> groupWiseRoleCode, String designCode) throws ITMException
	{
		String sql = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList<String> itmCodeArr = new ArrayList<String>();
		ArrayList<String> sellInQtyArr = new ArrayList<String>();
		ArrayList<String> sellOutQtyArr = new ArrayList<String>();
		ArrayList<String> sellInValArr = new ArrayList<String>();
		ArrayList<String> sellOutValArr = new ArrayList<String>();
		ArrayList<String> rateArr = new ArrayList<String>();
		ArrayList<String> closingStockArray = new ArrayList<String>();
		ArrayList<String> closingStkValArr = new ArrayList<String>();
		ArrayList<String> scCodeArr = new ArrayList<String>();
		ArrayList<String> avgSellInQtyArr = new ArrayList<String>();
		ArrayList<String> avgSellOutQtyArr = new ArrayList<String>();
		Map<String, ArrayList<String>> avgSellInOutMap = new HashMap<String, ArrayList<String>>();
		ArrayList<String> itmDescrArr = new ArrayList<String>();
		ArrayList<String> mktArr = new ArrayList<String>();
		ArrayList<String> groupArr = new ArrayList<String>();
		ArrayList<String> groupCodeArr = new ArrayList<String>();
		ArrayList<String> subGroupArr = new ArrayList<String>();
		ArrayList<String> avgSellInValArr = new ArrayList<String>();
		ArrayList<String> avgSellOutValArr = new ArrayList<String>();
		StringBuilder builder = new StringBuilder();
		try
		{
			if( "S".equalsIgnoreCase( status ) )
			{
				builder = new StringBuilder();
				builder.append("SELECT SPD.ITEM_CODE, ITEM.DESCR, ITEM.PRICE_LIST, ");
				builder.append("NVL( FN_GET_PRICELIST_RATE( ITEM.ITEM_CODE, ITEM.PRICE_LIST ), 1 ) AS RATE, ");
				builder.append("NVL( IN_OUT_DET.SELL_IN_QTY, 0) SELL_IN_QTY, ");
				builder.append("NVL( IN_OUT_DET.SELL_OUT_QTY, 0 ) SELL_OUT_QTY, ");
				builder.append("NVL( IN_OUT_DET.SELL_IN_VALUE, 0) SELL_IN_VAL, ");
				builder.append("NVL( IN_OUT_DET.SELL_OUT_VALUE, 0 ) SELL_OUT_VAL, ");
				builder.append("NVL( SPD.SELL_IN_QTY, 1 ) AS AVG_SELL_IN_QTY, ");
				builder.append("NVL( SPD.SELL_IN_VALUE, 1 ) AS AVG_SELL_IN_VAL, ");
				builder.append("NVL( SPD.SELL_OUT_QTY, 1 ) AS AVG_SELL_OUT_QTY, ");
				builder.append("NVL( SPD.SELL_OUT_VALUE, 1 ) AS AVG_SELL_OUT_VAL, ");
				//				builder.append("NVL( IN_OUT_DET.SELL_IN_QTY - IN_OUT_DET.SELL_OUT_QTY, 0 ) AS CLOSING_STOCK, ");
				//				builder.append("NVL( IN_OUT_DET.SELL_IN_VALUE - IN_OUT_DET.SELL_OUT_VALUE, 0 ) AS CLOSING_STOCK_VAL, ");
				builder.append("NVL ( IN_OUT_DET.CLOSING_STK, 0 ) AS CLOSING_STOCK, ");
				builder.append("PRODUCT.MKT_ARR, PRODUCT.PRODUCT_CODE,ITEM.GRP_CODE, ITEM.SGRP_CODE ");
				builder.append("FROM PRODUCT PRODUCT, ITEM ITEM ,SELLS_PLANNING_DET SPD ");
				builder.append("LEFT OUTER JOIN STK_SELL_IN_OUT_DET IN_OUT_DET ON SPD.ITEM_CODE = IN_OUT_DET.ITEM_CODE ");
				builder.append("AND IN_OUT_DET.TRAN_ID IN ( SELECT TRAN_ID FROM STK_SELL_IN_OUT IN_OUT ");
				builder.append("WHERE IN_OUT.SC_CODE = ? AND IN_OUT.STAN_CODE = ? AND IN_OUT.POS_CODE = ? ");
				builder.append("AND IN_OUT.FROM_DATE BETWEEN ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),-1) ");
				builder.append("AND LAST_DAY(ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),-1 ) ) AND IN_OUT.STATUS = 'A' ) ");
				builder.append("WHERE SPD.ITEM_CODE = ITEM.ITEM_CODE AND ITEM.PRODUCT_CODE = PRODUCT.PRODUCT_CODE ");
				builder.append("AND SPD.TRAN_ID = ? AND SPD.SC_CODE = ? " );
				builder.append("AND TRIM(ITEM.PRODUCT_CODE) NOT IN ( SELECT COLUMN_VALUE FROM TABLE( CSV_TO_ROW( (SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT = 'PRODUCT_CODE' AND PARM_NAME = 'PLANNING_NOT_ALLOW') ) ) ) ");
				builder.append("ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR ");

				//pstmt = conn.prepareStatement( builder.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE );
				pstmt = conn.prepareStatement( builder.toString());//Added By bhagyashri t
				pstmt.setString(1, scCode);
				pstmt.setString(2, stanCode);
				pstmt.setString(3, posCode);
				pstmt.setString(4, dateStr);
				pstmt.setString(5, dateStr);
				pstmt.setString(6, tranId);
				pstmt.setString(7, scCode);
				//pstmt2.setString(29, "GRP03");
				//rs2 = pstmt2.executeQuery();
			}
			else
			{
				builder = new StringBuilder();
				builder.append("SELECT ITEM.ITEM_CODE, ITEM.DESCR, ITEM.PRICE_LIST, ");
				builder.append("NVL( FN_GET_PRICELIST_RATE( ITEM.ITEM_CODE, ITEM.PRICE_LIST ), 1 ) AS RATE, ");
				builder.append("NVL( IN_OUT_DET.SELL_IN_QTY, 0) SELL_IN_QTY, ");
				builder.append("NVL( IN_OUT_DET.SELL_OUT_QTY, 0 ) SELL_OUT_QTY, ");
				builder.append("NVL( IN_OUT_DET.SELL_IN_VALUE, 0) SELL_IN_VAL, ");
				builder.append("NVL( IN_OUT_DET.SELL_OUT_VALUE, 0 ) SELL_OUT_VAL, ");
				builder.append("NVL( FN_GET_SELL_IN( ?, ?, ITEM.ITEM_CODE, ?, ?, ?, 'QTY' ), 1 ) AS AVG_SELL_IN_QTY, ");
				builder.append("NVL( FN_GET_SELL_OUT( ?, ?, ITEM.ITEM_CODE, ?, ?, ?, 'QTY' ), 1 ) AS AVG_SELL_OUT_QTY, ");
				builder.append("NVL( FN_GET_SELL_IN( ?, ?, ?, ITEM.ITEM_CODE, ?, ?, 'VALUE' ), 1 ) AS AVG_SELL_IN_VAL, ");
				builder.append("NVL( FN_GET_SELL_OUT( ?, ?, ITEM.ITEM_CODE, ?, ?, ?, 'VALUE' ), 1 ) AS AVG_SELL_OUT_VAL, ");
				//				builder.append("NVL( IN_OUT_DET.SELL_IN_QTY - IN_OUT_DET.SELL_OUT_QTY, 0 ) AS CLOSING_STOCK, ");
				//				builder.append("NVL( IN_OUT_DET.SELL_IN_VALUE - IN_OUT_DET.SELL_OUT_VALUE, 0 ) AS CLOSING_STOCK_VAL, ");
				builder.append("FN_GET_SELLS_CLOSING_STK( ?, ?, ITEM.ITEM_CODE, ? ) AS CLOSING_STOCK, ");
				builder.append("PRODUCT.MKT_ARR, PRODUCT.PRODUCT_CODE,ITEM.GRP_CODE, ITEM.SGRP_CODE ");
				builder.append("FROM PRODUCT PRODUCT, ITEM ITEM ");
				builder.append("LEFT OUTER JOIN STK_SELL_IN_OUT_DET IN_OUT_DET ON ITEM.ITEM_CODE = IN_OUT_DET.ITEM_CODE ");
				builder.append("AND IN_OUT_DET.TRAN_ID IN ( SELECT TRAN_ID FROM STK_SELL_IN_OUT IN_OUT ");
				builder.append("WHERE IN_OUT.SC_CODE = ? AND IN_OUT.STAN_CODE = ? AND IN_OUT.POS_CODE = ? ");
				builder.append("AND IN_OUT.FROM_DATE BETWEEN ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),-1) ");
				builder.append("AND LAST_DAY(ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),-1 ) ) AND IN_OUT.STATUS = 'A' ) ");
				builder.append("WHERE ITEM.PRODUCT_CODE = PRODUCT.PRODUCT_CODE " );
				builder.append("AND TRIM(ITEM.PRODUCT_CODE) NOT IN ( SELECT COLUMN_VALUE FROM TABLE( CSV_TO_ROW( (SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT = 'PRODUCT_CODE' AND PARM_NAME = 'PLANNING_NOT_ALLOW') ) ) ) ");
				builder.append("ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR ");

				//pstmt = conn.prepareStatement( builder.toString(), ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE );
				pstmt = conn.prepareStatement( builder.toString());//Added by bhagyashri T
				pstmt.setString(1, tranId);
				pstmt.setString(2, scCode);
				pstmt.setString(3, stanCode);
				pstmt.setString(4, posCode);
				pstmt.setString(5, prdCode);

				pstmt.setString(6, tranId);
				pstmt.setString(7, scCode);
				pstmt.setString(8, stanCode);
				pstmt.setString(9, posCode);
				pstmt.setString(10, prdCode);

				pstmt.setString(11, tranId);
				pstmt.setString(12, scCode);
				pstmt.setString(13, stanCode);
				pstmt.setString(14, posCode);
				pstmt.setString(15, prdCode);

				pstmt.setString(16, tranId);
				pstmt.setString(17, scCode);
				pstmt.setString(18, stanCode);
				pstmt.setString(19, posCode);
				pstmt.setString(20, prdCode);

				pstmt.setString(21, stanCode);
				pstmt.setString(22, scCode);
				pstmt.setString(23, dateStr);
				pstmt.setString(24, scCode);
				pstmt.setString(25, stanCode);
				pstmt.setString(26, posCode);
				pstmt.setString(27, dateStr);
				pstmt.setString(28, dateStr);
				//pstmt2.setString(29, "GRP03");
			}
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
				String sgrpCode = checkNull( rs.getString("SGRP_CODE") );
				List<String> roleCodes = groupWiseRoleCode.get( sgrpCode );

				if ( ! "S".equalsIgnoreCase( status ) )
				{
					if( roleCodes != null && ! roleCodes.contains( designCode ) )
					{
						continue;
					}
				}
				//if( roleCodes != null && roleCodes.contains(designCode) )
				//	if( roleCodes == null || ( roleCodes != null && roleCodes.contains( designCode ) ) )
				//{
				itmCodeArr.add(checkNull(rs.getString("ITEM_CODE")));
				sellInQtyArr.add(checkNull(rs.getString("SELL_IN_QTY")));
				sellOutQtyArr.add(checkNull(rs.getString("SELL_OUT_QTY")));
				sellInValArr.add(checkNull(rs.getString("SELL_IN_VAL")));
				sellOutValArr.add(checkNull(rs.getString("SELL_OUT_VAL")));
				rateArr.add(checkNull(rs.getString("RATE")));
				closingStockArray.add(checkNull(rs.getString("CLOSING_STOCK")));
				closingStkValArr.add(checkNull(rs.getString("CLOSING_STOCK")));
				groupCodeArr.add(checkNull(rs.getString("GRP_CODE")));
				subGroupArr.add(checkNull(rs.getString("SGRP_CODE")));

				itmDescrArr.add(checkNull(rs.getString("DESCR")));
				mktArr.add(checkNull(rs.getString("MKT_ARR")));
				groupArr.add(checkNull(rs.getString("PRODUCT_CODE")));

				avgSellInQtyArr.add(String.valueOf(rs.getDouble("AVG_SELL_IN_QTY")));
				avgSellOutQtyArr.add(String.valueOf(rs.getDouble("AVG_SELL_OUT_QTY")));
				avgSellInValArr.add(String.valueOf(rs.getDouble("AVG_SELL_IN_VAL")));
				avgSellOutValArr.add(String.valueOf(rs.getDouble("AVG_SELL_OUT_VAL")));
				//}
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( ! itmDescrArr.isEmpty() )
			{
				avgSellInOutMap.put("ITEM_DESCR", itmDescrArr);
				avgSellInOutMap.put("MKT_ARR", mktArr);
				avgSellInOutMap.put("PRODUCT_CODE", groupArr);
				avgSellInOutMap.put("ITEM_CODE", itmCodeArr);
				avgSellInOutMap.put("SELL_IN_QTY", sellInQtyArr);
				avgSellInOutMap.put("SELL_OUT_QTY", sellOutQtyArr);
				avgSellInOutMap.put("SELL_IN_VAL", sellInValArr);
				avgSellInOutMap.put("SELL_OUT_VAL", sellOutValArr);
				avgSellInOutMap.put("CLOSING_STOCK", closingStockArray);
				avgSellInOutMap.put("CLOSING_STOCK_VAL", closingStkValArr);
				avgSellInOutMap.put("RATE", rateArr);
				avgSellInOutMap.put("AVG_SELL_IN_QTY", avgSellInQtyArr);
				avgSellInOutMap.put("AVG_SELL_OUT_QTY", avgSellOutQtyArr);
				avgSellInOutMap.put("AVG_SELL_IN_VAL", avgSellInValArr);
				avgSellInOutMap.put("AVG_SELL_OUT_VAL", avgSellOutValArr);
				avgSellInOutMap.put("GRP_CODE", groupCodeArr);
				avgSellInOutMap.put("SGRP_CODE", subGroupArr);
			}

			System.out.println( "SellsStock.getExistingData() :: avgSellInOutMap : ["+ avgSellInOutMap +"]" );
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.getExistingData() Exception :  "+e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return avgSellInOutMap;
	}

	//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
	private Map<String, ArrayList<String>> getSellPanningData(String tranId, Connection conn, String scCode, String stanCode, String posCode, String salesPers,String prdCode, String dateStr,HashMap<String, List<String>> rollCodes, String designCode) throws ITMException
	{
		String sql = null;
		Date fromDate=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList<String> itmCodeArr = new ArrayList<String>();
		ArrayList<String> itmDescrArr = new ArrayList<String>();
		ArrayList<String> sellInQtyArr = new ArrayList<String>();
		ArrayList<String> sellOutQtyArr = new ArrayList<String>();
		ArrayList<String> sellInValArr = new ArrayList<String>();
		ArrayList<String> sellOutValArr = new ArrayList<String>();
		ArrayList<String> rateArr = new ArrayList<String>();
		ArrayList<String> closingStockArray = new ArrayList<String>();
		ArrayList<String> closingStkValArr = new ArrayList<String>();
		ArrayList<String> scCodeArr = new ArrayList<String>();
		ArrayList<String> avgSellInQtyArr = new ArrayList<String>();
		ArrayList<String> avgSellOutQtyArr = new ArrayList<String>();
		ArrayList<String> avgSellInValArr = new ArrayList<String>();
		ArrayList<String> avgSellOutValArr = new ArrayList<String>();
		ArrayList<String> mktArr = new ArrayList<String>();
		ArrayList<String> groupArr = new ArrayList<String>();
		ArrayList<String> groupCodeArr = new ArrayList<String>();
		ArrayList<String> subGroupArr = new ArrayList<String>();
		Map<String, ArrayList<String>> avgSellInOutMap = new HashMap<String, ArrayList<String>>();
		StringBuilder builder = new StringBuilder();
		try
		{
			builder = new StringBuilder();
			builder.append("SELECT ITEM.ITEM_CODE, ITEM.DESCR, ITEM.PRICE_LIST, ");
			builder.append("NVL( FN_GET_PRICELIST_RATE( ITEM.ITEM_CODE, ITEM.PRICE_LIST ), 1 ) AS RATE, ");
			builder.append("NVL( IN_OUT_DET.SELL_IN_QTY, 0) SELL_IN_QTY, " );
			builder.append("NVL( IN_OUT_DET.SELL_OUT_QTY, 0 ) SELL_OUT_QTY, ");
			builder.append("NVL( IN_OUT_DET.SELL_IN_VALUE, 0) SELL_IN_VAL, ");
			builder.append("NVL( IN_OUT_DET.SELL_OUT_VALUE, 0 ) SELL_OUT_VAL, ");
			builder.append("NVL( FN_GET_SELL_IN( ?, ?, ITEM.ITEM_CODE, ?, ?, ?, 'QTY' ), 1 ) AS AVG_SELL_IN_QTY, ");
			builder.append("NVL( FN_GET_SELL_OUT( ?, ?, ITEM.ITEM_CODE, ?, ?, ?, 'QTY' ), 1 ) AS AVG_SELL_OUT_QTY, ");
			builder.append("NVL( FN_GET_SELL_IN( ?, ?, ?, ITEM.ITEM_CODE, ?, ?, 'VALUE' ), 1 ) AS AVG_SELL_IN_VAL, ");
			builder.append("NVL( FN_GET_SELL_OUT( ?, ?, ITEM.ITEM_CODE, ?, ?, ?, 'VALUE' ), 1 ) AS AVG_SELL_OUT_VAL, ");
			//builder.append("NVL( IN_OUT_DET.SELL_IN_QTY - IN_OUT_DET.SELL_OUT_QTY, 0 ) AS CLOSING_STOCK, ");
			//builder.append("NVL( IN_OUT_DET.SELL_IN_VALUE - IN_OUT_DET.SELL_OUT_VALUE, 0 ) AS CLOSING_STOCK_VAL, ");
			builder.append("FN_GET_SELLS_CLOSING_STK( ?, ?, ITEM.ITEM_CODE, ? ) AS CLOSING_STOCK, ");
			builder.append("PRODUCT.MKT_ARR, PRODUCT.PRODUCT_CODE,ITEM.GRP_CODE, ITEM.SGRP_CODE ");
			builder.append("FROM PRODUCT PRODUCT, ITEM ITEM ");
			builder.append("LEFT OUTER JOIN STK_SELL_IN_OUT_DET IN_OUT_DET ON ITEM.ITEM_CODE = IN_OUT_DET.ITEM_CODE ");
			builder.append("AND IN_OUT_DET.TRAN_ID IN ( SELECT TRAN_ID FROM STK_SELL_IN_OUT IN_OUT ");
			builder.append("WHERE IN_OUT.SC_CODE = ? ");
			builder.append("AND IN_OUT.STAN_CODE = ? AND IN_OUT.POS_CODE = ? ");
			builder.append("AND IN_OUT.FROM_DATE BETWEEN ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),-1) ");
			builder.append("AND LAST_DAY(ADD_MONTHS(TRUNC(TO_DATE(?),'mm'),-1)) AND IN_OUT.STATUS = 'A') ");
			builder.append("WHERE ITEM.PRODUCT_CODE = PRODUCT.PRODUCT_CODE ");
			//builder.append("AND PRODUCT.ITEM_SER = SALES_PERS.ITEM_SER ");
			builder.append("AND TRIM(ITEM.PRODUCT_CODE) NOT IN ( SELECT COLUMN_VALUE FROM TABLE( CSV_TO_ROW( (SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT = 'PRODUCT_CODE' AND PARM_NAME = 'PLANNING_NOT_ALLOW') ) ) ) ");
			builder.append("ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR ");

			//pstmt = conn.prepareStatement(builder.toString(),ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
			pstmt = conn.prepareStatement(builder.toString());//added by bhagyashri T
			pstmt.setString(1, tranId);
			pstmt.setString(2, scCode);
			pstmt.setString(3, stanCode);
			pstmt.setString(4, posCode);
			pstmt.setString(5, prdCode);

			pstmt.setString(6, tranId);
			pstmt.setString(7, scCode);
			pstmt.setString(8, stanCode);
			pstmt.setString(9, posCode);
			pstmt.setString(10, prdCode);

			pstmt.setString(11, tranId);
			pstmt.setString(12, scCode);
			pstmt.setString(13, stanCode);
			pstmt.setString(14, posCode);
			pstmt.setString(15, prdCode);

			pstmt.setString(16, tranId);
			pstmt.setString(17, scCode);
			pstmt.setString(18, stanCode);
			pstmt.setString(19, posCode);
			pstmt.setString(20, prdCode);

			pstmt.setString(21, stanCode);
			pstmt.setString(22, scCode);
			pstmt.setString(23, dateStr);
			pstmt.setString(24, scCode);
			pstmt.setString(25, stanCode);
			pstmt.setString(26, posCode);
			pstmt.setString(27, dateStr);
			pstmt.setString(28, dateStr);
			//pstmt.setString(29, "GRP03");
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
				String sgrpCode = checkNull( rs.getString("SGRP_CODE") );
				List<String> roleCodes = rollCodes.get( sgrpCode );
				if( roleCodes == null || ( roleCodes != null && roleCodes.contains( designCode ) ) )
				{
					itmCodeArr.add( checkNull( rs.getString("ITEM_CODE" ) ) );
					sellInQtyArr.add( checkNull( rs.getString("SELL_IN_QTY" ) ) );
					sellOutQtyArr.add( checkNull( rs.getString("SELL_OUT_QTY" ) ) );
					sellInValArr.add( checkNull( rs.getString("SELL_IN_VAL" ) ) );
					sellOutValArr.add( checkNull( rs.getString("SELL_OUT_VAL" ) ) );
					rateArr.add( checkNull( rs.getString("RATE" ) ) );
					closingStockArray.add( checkNull( rs.getString("CLOSING_STOCK" ) ) );
					closingStkValArr.add( checkNull( rs.getString("CLOSING_STOCK" ) ) );
					itmDescrArr.add( checkNull( rs.getString("DESCR" ) ) );
					mktArr.add( checkNull( rs.getString("MKT_ARR" ) ) );
					groupArr.add( checkNull( rs.getString("PRODUCT_CODE" ) ) );
					groupCodeArr.add( checkNull( rs.getString("GRP_CODE" ) ) );
					subGroupArr.add( checkNull( rs.getString("SGRP_CODE" ) ) );

					avgSellInQtyArr.add( String.valueOf( rs.getDouble("AVG_SELL_IN_QTY" ) ) );
					avgSellOutQtyArr.add( String.valueOf( rs.getDouble("AVG_SELL_OUT_QTY" ) ) );
					avgSellInValArr.add( String.valueOf( rs.getDouble("AVG_SELL_IN_VAL" ) ) );
					avgSellOutValArr.add( String.valueOf( rs.getDouble("AVG_SELL_OUT_VAL" ) ) );
				}
				//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
			}
			pstmt.close();
			rs.close();

			if( ! itmDescrArr.isEmpty() )
			{
				avgSellInOutMap.put("ITEM_DESCR", itmDescrArr);
				avgSellInOutMap.put("MKT_ARR", mktArr);
				avgSellInOutMap.put("PRODUCT_CODE", groupArr);
				avgSellInOutMap.put("ITEM_CODE", itmCodeArr);
				avgSellInOutMap.put("SELL_IN_QTY", sellInQtyArr);
				avgSellInOutMap.put("SELL_OUT_QTY", sellOutQtyArr);
				avgSellInOutMap.put("SELL_IN_VAL", sellInValArr);
				avgSellInOutMap.put("SELL_OUT_VAL", sellOutValArr);
				avgSellInOutMap.put("CLOSING_STOCK", closingStockArray);
				avgSellInOutMap.put("CLOSING_STOCK_VAL", closingStkValArr);
				avgSellInOutMap.put("RATE", rateArr);
				avgSellInOutMap.put("AVG_SELL_IN_QTY", avgSellInQtyArr);
				avgSellInOutMap.put("AVG_SELL_OUT_QTY", avgSellOutQtyArr);
				avgSellInOutMap.put("AVG_SELL_IN_VAL", avgSellInValArr);
				avgSellInOutMap.put("AVG_SELL_OUT_VAL", avgSellOutValArr);
				avgSellInOutMap.put("GRP_CODE", groupCodeArr);
				avgSellInOutMap.put("SGRP_CODE", subGroupArr);
			}

			System.out.println( "SellsStock.getSellPanningData() :: avgSellInOutMap : ["+ avgSellInOutMap +"]" );
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.getSellPanningData() : "+e );
		}
		//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End

		return avgSellInOutMap;
	}

	//Added by Prasad on 25/01/20 [to display sell performance related data] START
	//public String getSellPerformance( String stanCode, String posCode, String prdCode, UserInfoBean userInfo )
	public String getSellPerformance( String data, UserInfoBean userInfo )
	{
		System.out.println( "In getSellPerformance" );
		JSONArray sellPerformanceArr = new JSONArray();

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		try
		{
			ArrayList<Integer> groupCntList = new ArrayList<Integer>();
			String stanCode ="", posCode = "",  prdCode = "";
			boolean isFromPlanning = true;
			StringBuilder builder = null;

			org.json.JSONObject jsonData = new org.json.JSONObject(data);
			System.out.println( "jsonData ["+ jsonData +"]" );
			stanCode = jsonData.getString("stan_code");
			posCode = jsonData.getString("pos_code");
			prdCode = jsonData.getString("prd_code");

			String transDB = checkNull( userInfo.getTransDB() );

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB );
			String userCode = checkNull( userInfo.getLoginCode() );
			String loginEmpCode = checkNull( userInfo.getEmpCode() );

			//Added By Sainath T. on 18/04/2020 [if called from dashboard] -Start
			if(stanCode.length() == 0 && posCode.length() == 0)
			{
				String stanPosStr = getStanAndPosCode( conn, loginEmpCode );
				String[] stanPosCodeArr = stanPosStr.split( ":" );
				System.out.println( "stanPosCodeArr : ["+ stanPosCodeArr +"]" );

				if( stanPosCodeArr.length > 0 )
				{
					posCode = stanPosCodeArr[0];
					stanCode = stanPosCodeArr[1];
				}
				isFromPlanning = false;
			}
			//Added By Sainath T. on 18/04/2020 [if called from dashboard] -End

			if( posCode.contains(",") )
			{
				posCode = posCode.replace(",", "','");
			}
			if( stanCode.contains(",") )
			{
				stanCode = stanCode.replace(",", "','");
			}

			/*int gradeCode = 0;
			String gradeCodeSql = "SELECT LEVEL_NO FROM ORG_STRUCTURE WHERE POS_CODE in ( '"+posCode+"' )" ;
			pstmt = conn.prepareStatement( gradeCodeSql );
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String gradeCodeStr = checkNull( rs.getString( "LEVEL_NO" ) );
				if( gradeCodeStr.length() > 0 )
				{
					gradeCode = Integer.parseInt( gradeCodeStr );
				}
			}
			System.out.println("gradeCode : "+gradeCode);
			if( rs != null )
			{
				rs.close();
			}
			if(pstmt != null)
			{
				pstmt.close();
			}*/

			boolean isMgr = isPlanningMgr( posCode, conn );

			HashMap<String, String> mainGroupMap = new LinkedHashMap<String, String>();

			builder = new StringBuilder();
			//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
			builder.append("SELECT RTRIM(GRP.FLD_VALUE) VALUE, GRP.DESCR, ");
			builder.append("(SELECT COUNT(*) FROM GENCODES WHERE FLD_NAME = 'SGRP_CODE' AND FLD_VALUE <> UDF_STR1 AND UDF_STR1 = RTRIM(GRP.FLD_VALUE)) GRP_CNT ");
			builder.append("FROM GENCODES GRP ");
			builder.append("WHERE GRP.FLD_NAME='GRP_CODE' AND GRP.MOD_NAME='W_ITEM' ");
			builder.append("AND GRP.ACTIVE = 'Y' AND GRP.UDF_STR1 IS NOT NULL ORDER BY TO_NUMBER(GRP.UDF_STR1) ");

			pstmt = conn.prepareStatement( builder.toString() );
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				mainGroupMap.put( rs.getString( 1 ), rs.getString( 2 ) );
				groupCntList.add( rs.getInt(3) );
			}
			System.out.println( "mainGroupMap : ["+ mainGroupMap +"] grupCnt ["+ groupCntList +"]" );

			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}

			//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise]
			builder = new StringBuilder();
			if( isMgr )
			{
				builder.append("SELECT SELL_DATA.GROUP_CODE, SELL_DATA.GROUP_DESCR, SELL_DATA.FULL_GROUP_DESCR, SELL_DATA.TO_DISPLAY, SELL_DATA.MAIN_GRP, SELL_DATA.MKT_ARR, ");
				builder.append(" SELL_DATA.MONTH_TRGT, SELL_DATA.SELL_OUT_MONTH_QTY, SELL_DATA.SELL_OUT_MONTH_VALUE, ");
				builder.append(" NVL(FN_CALC_SELL_OUT_ACHIEVEMENT( 'MONTH', SELL_DATA.SELL_OUT_MONTH_QTY, SELL_DATA.SELL_OUT_MONTH_VALUE, SELL_DATA.MKT_ARR, SELL_DATA.MONTH_TRGT ),0) MTH_ACHIEVEMENT, ");
				builder.append(" SELL_DATA.YTD_TRGT, SELL_DATA.SELL_OUT_YTD_QTY, SELL_DATA.SELL_OUT_YTD_VALUE, ");
				builder.append(" NVL(FN_CALC_SELL_OUT_ACHIEVEMENT( 'YEAR', SELL_DATA.SELL_OUT_YTD_QTY, SELL_DATA.SELL_OUT_YTD_VALUE, SELL_DATA.MKT_ARR, SELL_DATA.YTD_TRGT ),0) YTD_ACHIEVEMENT ");
				builder.append(" FROM( ");
				builder.append(" WITH TEAM AS ( " );
				builder.append(" SELECT PE.POS_CODE AS POS_CODE,PE.STAN_CODE AS STAN_CODE__HQ, PE.STATUS FROM TABLE(GETPLANNINGTEAMDATA.GETPOSCODESTANCODEDET('"+posCode.replace("','", ",")+"',?)) PE " );
				builder.append(" ) " );
				builder.append(" SELECT RTRIM(GENCODE_SGRP.FLD_VALUE) GROUP_CODE,GENCODE_SGRP.SH_DESCR GROUP_DESCR,GENCODE_SGRP.DESCR FULL_GROUP_DESCR,GENCODE_SGRP.UDF_STR2 TO_DISPLAY, " );
				builder.append(" GENCODE_SGRP.UDF_STR1 MAIN_GRP,PRODUCT.MKT_ARR AS MKT_ARR, " );
				builder.append(" SUM(NVL(FN_GET_MGR_SELL_TRGT( T.STAN_CODE__HQ, T.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'MONTH' ),0)) MONTH_TRGT, " );
				builder.append(" SUM(NVL(FN_GET_MGR_MONTH_SELL_OUT( T.STAN_CODE__HQ, T.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'QTY' ),0)) SELL_OUT_MONTH_QTY, " );
				builder.append(" SUM(NVL(FN_GET_MGR_MONTH_SELL_OUT( T.STAN_CODE__HQ, T.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'VALUE' ),0)) SELL_OUT_MONTH_VALUE, " );
				builder.append(" SUM(NVL(FN_GET_MGR_SELL_TRGT( T.STAN_CODE__HQ, T.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'YEAR' ),0)) YTD_TRGT, " );
				builder.append(" SUM(NVL(FN_GET_MGR_YTD_SELL_OUT( T.STAN_CODE__HQ, T.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'QTY' ),0)) SELL_OUT_YTD_QTY, " );
				builder.append(" SUM(NVL(FN_GET_MGR_YTD_SELL_OUT( T.STAN_CODE__HQ, T.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'VALUE' ),0)) SELL_OUT_YTD_VALUE " );
				builder.append(" FROM GENCODES GENCODE_SGRP, TEAM T, PRODUCT PRODUCT " );
				builder.append(" WHERE RTRIM(PRODUCT.PRODUCT_CODE) = GENCODE_SGRP.UDF_STR3 ");
				builder.append(" AND GENCODE_SGRP.FLD_NAME = 'SGRP_CODE' " );
				builder.append(" AND GENCODE_SGRP.MOD_NAME = 'W_ITEM' ");
				builder.append(" AND GENCODE_SGRP.UDF_STR1 = ? ");
				builder.append(" GROUP BY GENCODE_SGRP.FLD_VALUE, GENCODE_SGRP.SH_DESCR, GENCODE_SGRP.DESCR, GENCODE_SGRP.UDF_STR2, GENCODE_SGRP.UDF_STR1, PRODUCT.MKT_ARR, PRODUCT.SORT_ORDER " );
				builder.append(" ORDER BY PRODUCT.SORT_ORDER, GENCODE_SGRP.DESCR DESC ) SELL_DATA");
			}
			else
			{
				builder.append("SELECT SELL_DATA.GROUP_CODE, SELL_DATA.GROUP_DESCR, SELL_DATA.FULL_GROUP_DESCR, SELL_DATA.TO_DISPLAY, SELL_DATA.MAIN_GRP, SELL_DATA.MKT_ARR, ");
				builder.append(" SELL_DATA.MONTH_TRGT, SELL_DATA.SELL_OUT_MONTH_QTY, SELL_DATA.SELL_OUT_MONTH_VALUE, ");
				builder.append(" NVL(FN_CALC_SELL_OUT_ACHIEVEMENT( 'MONTH', SELL_DATA.SELL_OUT_MONTH_QTY, SELL_DATA.SELL_OUT_MONTH_VALUE, SELL_DATA.MKT_ARR, SELL_DATA.MONTH_TRGT ),0) MTH_ACHIEVEMENT, ");
				builder.append(" SELL_DATA.YTD_TRGT, SELL_DATA.SELL_OUT_YTD_QTY, SELL_DATA.SELL_OUT_YTD_VALUE, ");
				builder.append(" NVL(FN_CALC_SELL_OUT_ACHIEVEMENT( 'YEAR', SELL_DATA.SELL_OUT_YTD_QTY, SELL_DATA.SELL_OUT_YTD_VALUE, SELL_DATA.MKT_ARR, SELL_DATA.YTD_TRGT ),0) YTD_ACHIEVEMENT ");
				builder.append(" FROM( ");
				builder.append(" WITH ORG_STR AS ( ");
				builder.append(" SELECT POS_CODE AS POS_CODE, STAN_CODE__HQ AS STAN_CODE FROM ORG_STRUCTURE WHERE POS_CODE = '"+ posCode.replace("','", ",") +"' ");
				builder.append(" ) ");
				builder.append(" SELECT RTRIM(GENCODE_SGRP.FLD_VALUE) GROUP_CODE, GENCODE_SGRP.SH_DESCR GROUP_DESCR, GENCODE_SGRP.DESCR FULL_GROUP_DESCR, ");
				builder.append(" GENCODE_SGRP.UDF_STR2 TO_DISPLAY, GENCODE_SGRP.UDF_STR1 MAIN_GRP, PRODUCT.MKT_ARR, ");
				builder.append(" NVL(FN_GET_SELL_TRGT( ORG.STAN_CODE, ORG.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'MONTH' ),0) MONTH_TRGT, ");
				builder.append(" NVL(FN_GET_MONTH_SELL_OUT( ORG.STAN_CODE, ORG.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'QTY', ?, ? ),0) SELL_OUT_MONTH_QTY, ");
				builder.append(" NVL(FN_GET_MONTH_SELL_OUT( ORG.STAN_CODE, ORG.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'VALUE', ?, ? ),0) SELL_OUT_MONTH_VALUE, ");
				builder.append(" NVL(FN_GET_SELL_TRGT( ORG.STAN_CODE, ORG.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'YEAR' ),0) YTD_TRGT, ");
				builder.append(" NVL(FN_GET_YTD_SELL_OUT( ORG.STAN_CODE, ORG.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'QTY', ?, ? ),0) SELL_OUT_YTD_QTY, ");
				builder.append(" NVL(FN_GET_YTD_SELL_OUT( ORG.STAN_CODE, ORG.POS_CODE, RTRIM(GENCODE_SGRP.FLD_VALUE), ?, 'VALUE', ?, ? ),0) SELL_OUT_YTD_VALUE ");
				builder.append(" FROM GENCODES GENCODE_SGRP, ORG_STR ORG, PRODUCT PRODUCT ");
				builder.append(" WHERE RTRIM(PRODUCT.PRODUCT_CODE) = GENCODE_SGRP.UDF_STR3 ");
				builder.append(" AND GENCODE_SGRP.FLD_NAME = 'SGRP_CODE' ");
				builder.append(" AND GENCODE_SGRP.MOD_NAME = 'W_ITEM' ");
				builder.append(" AND GENCODE_SGRP.UDF_STR1 = ? ");
				builder.append(" ORDER BY PRODUCT.SORT_ORDER, GENCODE_SGRP.DESCR DESC ) SELL_DATA ");
			}
			pstmt = conn.prepareStatement( builder.toString() );
			String designCode = getDesignCode( stanCode, posCode, conn );

			if( posCode.contains(",") )
			{
				posCode = posCode.replace("','", ",");
			}
			if( stanCode.contains(",") )
			{
				stanCode = stanCode.replace("','", ",");
			}

			int mainGroupCount = 0;
			HashMap<String, List<String>> groupWiseRoleCode = getGroupWiseRole("ROLE_WISE_GRP",conn);

			for ( Map.Entry<String, String> entry : mainGroupMap.entrySet() )
			{
				String grpCode = entry.getKey();
				String grpDescr = entry.getValue();

				if( isMgr )
				{
					pstmt.setString(1, prdCode);
					pstmt.setString(2, prdCode);
					pstmt.setString(3, prdCode);
					pstmt.setString(4, prdCode);
					pstmt.setString(5, prdCode);
					pstmt.setString(6, prdCode);
					pstmt.setString(7, prdCode);
					pstmt.setString(8, grpCode);
				}
				else
				{
					pstmt.setString(1, prdCode);
					pstmt.setString(2, prdCode);
					pstmt.setString(3, Boolean.toString(isMgr).toUpperCase() );
					pstmt.setString(4, Boolean.toString(isFromPlanning).toUpperCase() );
					pstmt.setString(5, prdCode);
					pstmt.setString(6, Boolean.toString(isMgr).toUpperCase() );
					pstmt.setString(7, Boolean.toString(isFromPlanning).toUpperCase() );
					pstmt.setString(8, prdCode);
					pstmt.setString(9, prdCode);
					pstmt.setString(10, Boolean.toString(isMgr).toUpperCase() );
					pstmt.setString(11, Boolean.toString(isFromPlanning).toUpperCase() );
					pstmt.setString(12, prdCode);
					pstmt.setString(13, Boolean.toString(isMgr).toUpperCase() );
					pstmt.setString(14, Boolean.toString(isFromPlanning).toUpperCase() );
					pstmt.setString(15, grpCode);
				}
				rs = pstmt.executeQuery();

				double mthTarget = 0, sellOutMthQty = 0, sellOutMthVal = 0, ytdTarget = 0, sellOutYtdQty = 0, sellOutYtdVal = 0, mthAch = 0, ytdAch = 0;
				int rowCnt = 0;
				String mktArr = "";
				while( rs.next() )
				{
					if( isMgr )
					{
						double sellOutMthQtyTemp = rs.getDouble( "SELL_OUT_MONTH_QTY" );
						double sellOutMthValTemp = rs.getDouble( "SELL_OUT_MONTH_VALUE" );

						double sellOutYtdQtyTemp = rs.getDouble( "SELL_OUT_YTD_QTY" );
						double sellOutYtdValTemp = rs.getDouble( "SELL_OUT_YTD_VALUE" );

						mktArr = rs.getString( "MKT_ARR" );

						JSONObject jsonObject = getJSONObject();
						jsonObject.put( "GROUP_CODE", rs.getString( "GROUP_CODE" ) );
						jsonObject.put( "GROUP_DESCR", rs.getString( "GROUP_DESCR" ) );
						//Added by Sainath T. on 18/04/2020 [to display description if called from dashboard]
						jsonObject.put( "FULL_GROUP_DESCR", rs.getString( "FULL_GROUP_DESCR" ) );
						jsonObject.put( "TO_DISPLAY", rs.getString( "TO_DISPLAY" ) );
						jsonObject.put( "MAIN_GRP", rs.getString( "MAIN_GRP" ) );
						jsonObject.put( "MKT_ARR", mktArr );
						jsonObject.put( "MONTH_TRGT", rs.getDouble( "MONTH_TRGT" ) );
						jsonObject.put( "SELL_OUT_MONTH_QTY", sellOutMthQtyTemp );
						jsonObject.put( "SELL_OUT_MONTH_VALUE", sellOutMthValTemp );
						jsonObject.put( "MTH_ACHIEVEMENT", rs.getDouble( "MTH_ACHIEVEMENT" ) );
						jsonObject.put( "YTD_TRGT", rs.getDouble( "YTD_TRGT" ) );
						jsonObject.put( "SELL_OUT_YTD_QTY", sellOutYtdQtyTemp );
						jsonObject.put( "SELL_OUT_YTD_VALUE", rs.getDouble( "SELL_OUT_YTD_VALUE" ) );
						jsonObject.put( "YTD_ACHIEVEMENT", rs.getDouble( "YTD_ACHIEVEMENT" ) );

						sellPerformanceArr.add( jsonObject );

						mthTarget += rs.getDouble( "MONTH_TRGT" );
						sellOutMthQty += sellOutMthQtyTemp;
						sellOutMthVal += sellOutMthValTemp;
						ytdTarget += rs.getDouble( "YTD_TRGT" );
						sellOutYtdQty += sellOutYtdQtyTemp;
						sellOutYtdVal += sellOutYtdValTemp;

						rowCnt++;
					}
					else
					{
						List<String> roleCodes = groupWiseRoleCode.get(rs.getString("GROUP_CODE"));
						//if( roleCodes != null && roleCodes.contains( designCode ) )
						if( roleCodes == null || ( roleCodes != null && roleCodes.contains( designCode ) ) )
						{
							double sellOutMthQtyTemp = rs.getDouble( "SELL_OUT_MONTH_QTY" );
							double sellOutMthValTemp = rs.getDouble( "SELL_OUT_MONTH_VALUE" );

							double sellOutYtdQtyTemp = rs.getDouble( "SELL_OUT_YTD_QTY" );
							double sellOutYtdValTemp = rs.getDouble( "SELL_OUT_YTD_VALUE" );

							mktArr = rs.getString( "MKT_ARR" );

							JSONObject jsonObject = getJSONObject();
							jsonObject.put( "GROUP_CODE", rs.getString( "GROUP_CODE" ) );
							jsonObject.put( "GROUP_DESCR", rs.getString( "GROUP_DESCR" ) );
							//Added by Sainath T. on 18/04/2020 [to display description if called from dashboard]
							jsonObject.put( "FULL_GROUP_DESCR", rs.getString( "FULL_GROUP_DESCR" ) );
							jsonObject.put( "TO_DISPLAY", rs.getString( "TO_DISPLAY" ) );
							jsonObject.put( "MAIN_GRP", rs.getString( "MAIN_GRP" ) );
							jsonObject.put( "MKT_ARR", mktArr );
							jsonObject.put( "MONTH_TRGT", rs.getDouble( "MONTH_TRGT" ) );
							jsonObject.put( "SELL_OUT_MONTH_QTY", sellOutMthQtyTemp );
							jsonObject.put( "SELL_OUT_MONTH_VALUE", sellOutMthValTemp );
							jsonObject.put( "MTH_ACHIEVEMENT", rs.getDouble( "MTH_ACHIEVEMENT" ) );
							jsonObject.put( "YTD_TRGT", rs.getDouble( "YTD_TRGT" ) );
							jsonObject.put( "SELL_OUT_YTD_QTY", sellOutYtdQtyTemp );
							jsonObject.put( "SELL_OUT_YTD_VALUE", sellOutYtdValTemp );
							jsonObject.put( "YTD_ACHIEVEMENT", rs.getDouble( "YTD_ACHIEVEMENT" ) );

							sellPerformanceArr.add( jsonObject );

							mthTarget += rs.getDouble( "MONTH_TRGT" );
							sellOutMthQty += sellOutMthQtyTemp;
							sellOutMthVal += sellOutMthValTemp;
							ytdTarget += rs.getDouble( "YTD_TRGT" );
							sellOutYtdQty += sellOutYtdQtyTemp;
							sellOutYtdVal += sellOutYtdValTemp;

							rowCnt++;
						}
					}
				}

				/*if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}*/
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}

				if ( rowCnt > 0 && groupCntList.get( mainGroupCount ) > 0 )
				{
					//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
					if( mthTarget > 0)
					{
						if ( "Y".equalsIgnoreCase( mktArr ) )
						{
							mthAch = ( sellOutMthVal / mthTarget ) * 100;
						}
						else
						{
							mthAch = ( sellOutMthQty / mthTarget ) * 100;
						}
					}
					if( ytdTarget > 0 )
					{
						if ( "Y".equalsIgnoreCase( mktArr ) )
						{
							ytdAch = ( sellOutYtdVal / ytdTarget ) * 100;
						}
						else
						{
							ytdAch = ( sellOutYtdQty / ytdTarget ) * 100;
						}
						//Changed by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End
					}

					JSONObject jsonObject = getJSONObject();
					jsonObject.put( "GROUP_CODE", grpCode+"_TOTAL" );
					jsonObject.put( "GROUP_DESCR", grpDescr );
					//Added by Sainath T. on 18/04/2020 [to display description if called from dashboard]
					jsonObject.put( "FULL_GROUP_DESCR", grpDescr );
					jsonObject.put( "TO_DISPLAY", "Y" );
					jsonObject.put( "MAIN_GRP", grpCode );
					jsonObject.put( "MKT_ARR", mktArr );
					jsonObject.put( "MONTH_TRGT", mthTarget );
					jsonObject.put( "SELL_OUT_MONTH_QTY", sellOutMthQty );
					jsonObject.put( "SELL_OUT_MONTH_VALUE", sellOutMthVal );
					jsonObject.put( "MTH_ACHIEVEMENT", mthAch );
					jsonObject.put( "YTD_TRGT", ytdTarget );
					jsonObject.put( "SELL_OUT_YTD_QTY", sellOutYtdQty );
					jsonObject.put( "SELL_OUT_YTD_VALUE", sellOutYtdVal );
					jsonObject.put( "YTD_ACHIEVEMENT", ytdAch );

					//System.out.println( "jsonObject : ["+ jsonObject +"]" );
					sellPerformanceArr.add( jsonObject );
				}
				mainGroupCount++;
			}

			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//System.out.println( "sellPerformanceArr : ["+ sellPerformanceArr +"]" );
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.getAvgSellInOut() : "+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return sellPerformanceArr.toString();
	}
	//Added by Prasad on 25/01/20 [to display sell performance related data] END

	private Timestamp getTimeStampValue(String dateStr)
	{
		Timestamp timeStampValue = null;
		try
		{
			timeStampValue = Timestamp.valueOf(genericUtility.getValidDateTimeString(dateStr,DATE_FORMAT,genericUtility.getDBDateFormat()));
		}
		catch(Exception e)
		{
			return null;
		}
		return timeStampValue;
	}

	//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] Start
	private HashMap<String, HashMap<String, String>> getItemDetails( ArrayList<String> itemCodeArray, Connection conn ) throws ITMException
	{
		HashMap<String, HashMap<String, String>> itemDetailsMap = new HashMap<String, HashMap<String, String>>();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		DistCommon distCommon = new DistCommon();
		Date curDate = new Date();
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String itemCode = "", priceList = "";

			String itemCodes = getFormattedCode( itemCodeArray.toString() );
			itemCodes = itemCodes.replace("[", "");
			itemCodes = itemCodes.replace("]", "");

			HashMap<String, String> productColourMap = getProductColour( itemCodes, conn );
			/*String itemDetSql = "SELECT ITEM.ITEM_CODE, ITEM.PHY_ATTRIB_7, ITEM.SGRP_CODE, PRODUCT.MKT_ARR, ITEM.PRICE_LIST "
					+ " FROM ITEM ITEM, PRODUCT PRODUCT "
					+ " WHERE PRODUCT.PRODUCT_CODE = ITEM.PRODUCT_CODE "
					+ " AND ITEM.ITEM_CODE IN ("+ itemCodes +")";*/
			String itemDetSql = "SELECT ITEM.ITEM_CODE, ITEM.PHY_ATTRIB_7, ITEM.SGRP_CODE, PRODUCT.MKT_ARR, ITEM.PRICE_LIST, "
					+ " SFAPARM.PARM_VALUE PRODUCT_COLOR, PRODUCT.PRODUCT_CODE  "
					+ " FROM ITEM ITEM, PRODUCT PRODUCT "
					+ " LEFT OUTER JOIN SFAPARM SFAPARM ON SFAPARM.ORG_UNIT = TRIM(PRODUCT.PRODUCT_CODE) AND PARM_NAME = 'PRODUCT_COLOR' AND SFAPARM.ACTIVE = 'Y' "
					+ " WHERE PRODUCT.PRODUCT_CODE = ITEM.PRODUCT_CODE "
					+ " AND ITEM.ITEM_CODE IN (" + itemCodes + ") ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR ";
			pstmt = conn.prepareStatement(itemDetSql);
			rs = pstmt.executeQuery();
			ResultSetMetaData rsmd = rs.getMetaData();
			while(rs.next())
			{
				itemCode = checkNull( rs.getString( "ITEM_CODE" ) );
				priceList = checkNull( rs.getString( "PRICE_LIST" ) );
				//int noOfColumns = rsmd.getColumnCount();

				HashMap<String, String> tempMap = new HashMap<String, String>();
				tempMap.put( "ITEM_CODE", itemCode );
				tempMap.put( "PRICE_LIST", priceList );
				tempMap.put( "PHY_ATTRIB_7", checkNull( rs.getString("PHY_ATTRIB_7") ) );
				tempMap.put( "SGRP_CODE", checkNull( rs.getString("SGRP_CODE") ) );
				tempMap.put( "MKT_ARR", checkNull( rs.getString("MKT_ARR") ) );
				tempMap.put( "PRODUCT_COLOR", checkNull( productColourMap.get( rs.getString("PRODUCT_CODE") ) ) );

				double rate = distCommon.pickRate( priceList, sdf.format(curDate), itemCode, conn );
				tempMap.put("RATE", rate+"");

				itemDetailsMap.put( itemCode, tempMap );
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :: getItemDetails : ["+ e.getMessage() +"]" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "itemDetailMap ["+ itemDetailsMap +"]" );
		return itemDetailsMap;
	}

	private HashMap<String, List<String>> getGroupWiseRole(String paramName, Connection connectionObject ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String paramValue="",orgUnit="";
		HashMap<String, List<String>> groupWiseRoleCodeMap = new HashMap<String, List<String>>();
		try
		{
			String sql=" SELECT ORG_UNIT,PARM_VALUE FROM SFAPARM WHERE ACTIVE = ? AND PARM_NAME = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, "Y");
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				orgUnit  = checkNull(rs.getString("ORG_UNIT"));
				paramValue  = checkNull(rs.getString("PARM_VALUE"));

				List<String> rolCode = Arrays.asList(paramValue.split(","));
				System.out.println("orgUnit["+ orgUnit+"]rolCode["+ rolCode +"]");

				groupWiseRoleCodeMap.put(orgUnit, rolCode);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return groupWiseRoleCodeMap;
	}

	private int getSalesPersCount( HashMap<String, HashMap<String, String>> itemCodeMap, String itemCode, HashMap<String, ArrayList<String>> salesPersMapping, HashMap<String, List<String>> roleCodes )
	{
		String phyItemSer= "",sgroupCode = "";
		int salesPersCnt = 0;
		HashMap<String, String> itemDetmap = itemCodeMap.get( itemCode );
		phyItemSer = checkNull( itemDetmap.get( "PHY_ATTRIB_7" ) );
		sgroupCode = checkNull( itemDetmap.get( "SGRP_CODE" ) );
		if(phyItemSer.length() > 0)
		{
			for ( Map.Entry<String,ArrayList<String>> salesPersSeriesMap : salesPersMapping.entrySet() )
			{
				String salesPers = salesPersSeriesMap.getKey();
				ArrayList<String> itemSeriesDesignCodeArray = salesPersSeriesMap.getValue();

				String orgItemSer = itemSeriesDesignCodeArray.get(0);
				String designCode = itemSeriesDesignCodeArray.get(1);
				if(phyItemSer.contains(orgItemSer))
				{
					List<String >roles = roleCodes.get(sgroupCode);
					if( roles.contains(designCode) )
					{
						salesPersCnt++;
					}
				}
			}
		}

		return salesPersCnt;
	}

	private String getFormattedCode( String code )
	{
		StringBuffer codeStrBuff = new StringBuffer();
		if( !"".equalsIgnoreCase( code ) )
		{
			String[] docIdArr = code.split(",");
			int len = docIdArr.length;
			for( int counter = 0; counter < len; counter++ )
			{
				codeStrBuff.append("'").append( E12GenericUtility.checkNull( docIdArr[counter] ) ).append("'");
				if( counter < len - 1 )
				{
					codeStrBuff.append(",");
				}
			}
		}
		if( "".equalsIgnoreCase( codeStrBuff.toString() ) )
		{
			codeStrBuff.append("");
		}
		System.out.println("getFormattedDocId :["+ codeStrBuff.toString() + "]");
		return codeStrBuff.toString();
	}

	private String getDesignCode( String stanCode, String posCode, Connection conn) throws ITMException
	{
		String designation="";
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT DESIGN_CODE FROM EMPLOYEE "
					+ " WHERE EMP_CODE IN ( SELECT EMP_CODE FROM ORG_STRUCTURE WHERE STAN_CODE__HQ IN ( '"+stanCode+"' ) AND POS_CODE IN ( '"+posCode+"' ) )";
			pstmt = conn.prepareStatement(nameSql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				designation = checkNull(rs.getString("DESIGN_CODE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return designation;
	}
	//Added by Pooja S on 3-FEB-2020 [to display the items and group rolewise] End

	/*private ArrayList<String> sendingMailList(String empCode,int grade,ArrayList<String> empCodeList,Connection conn)
	{
		String sql = "",reportTo ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT REPORT_TO,GRADE FROM EMPLOYEE WHERE EMP_CODE= ? AND GRADE > ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setString(2, "6");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				reportTo = rs.getString("REPORT_TO");
				grade = rs.getInt("GRADE");
				empCodeList.add(reportTo);
				sendingMailList(reportTo, grade, empCodeList, conn);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.sendingMailList()"+e);
		}
		return empCodeList;
	}*/

	private Map<String, Integer> getLastMthClosingStk( Connection con, String scCode, String fromDateStr )
	{
		HashMap<String, Integer> closingStkMthMp = new HashMap<>();
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		try
		{
			String prevMonthClosingSql = "SELECT ITEM_CODE, NVL(CLOSING_STK, 0) AS CLOSING_STK "
					+ "FROM STRG_SELL_STK "
					+ "WHERE SC_CODE = ? "
					//+ "AND STAN_CODE = (SELECT STAN_CODE FROM STRG_CUSTOMER WHERE SC_CODE = ?) "
					+ "AND PRD_CODE = (SELECT CODE FROM PERIOD WHERE FR_DATE = (SELECT ADD_MONTHS(TRUNC(TO_DATE(?),'MM'),-1) FROM DUAL))";
			pStmt = con.prepareStatement(prevMonthClosingSql);
			pStmt.setString(1, scCode);
			pStmt.setString(2, scCode);
			pStmt.setString(3, fromDateStr);
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				closingStkMthMp.put(rs.getString("ITEM_CODE").trim(), rs.getInt("CLOSING_STK"));
			}
			if( pStmt != null )
			{
				pStmt.close();
			}
			if( rs != null )
			{
				rs.close();
			}
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.getLastMthClosingStk()");
		}

		return closingStkMthMp;
	}

	private void deleteSellPlanningDet( String tranId, Connection conn )
	{
		PreparedStatement pStmt = null;
		ResultSet rs =  null;
		String sql ="";
		try
		{
			sql = "DELETE FROM SELLS_PLANNING_DET WHERE TRAN_ID = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, tranId);
			int deletCnt = pStmt.executeUpdate();

			System.out.println( "["+ deletCnt +"] rows deleted" );

			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
	}

	private void deleteStkInOutDet( String tranId, Connection conn )
	{
		PreparedStatement pStmt = null;
		ResultSet rs =  null;
		String sql ="";
		try
		{
			sql = "DELETE FROM STK_SELL_IN_OUT_DET WHERE TRAN_ID = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, tranId);
			int deletCnt = pStmt.executeUpdate();

			System.out.println( "["+ deletCnt +"] rows deleted" );

			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
	}

	private void getMgrData( String loginEmpCode, String posCode, String prdCode, JSONObject jsonObject, Connection conn )
	{
		PreparedStatement pStmt = null;
		ResultSet rs =  null;
		try
		{
			String stanCode = "", posCodeDescr = "";
			posCode = checkNull( posCode );
			stanCode = checkNull( stanCode );
			if( posCode.contains(",") )
			{
				posCode = posCode.replace(",", "','");
			}
			if( stanCode.contains(",") )
			{
				stanCode = stanCode.replace(",", "','");
			}

			/*String sql = "SELECT EMP_CODE, LEVEL_NO, "
					+ " LISTAGG(POS_CODE, ',') WITHIN GROUP (ORDER BY POS_CODE) AS POS_CODE, "
					+ " LISTAGG(STAN_CODE__HQ, ',') WITHIN GROUP (ORDER BY STAN_CODE__HQ) AS STAN_CODE__HQ, "
					+ " FN_GET_TERRITORY(EMP_CODE,EMP_CODE) AS POS_CODE_DESCR "
					+ " FROM ORG_STRUCTURE WHERE POS_CODE IN ('"+ posCode +"')  "
					+ " GROUP BY LEVEL_NO,EMP_CODE";
			pStmt = conn.prepareStatement(sql);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				levelNo = rs.getInt("LEVEL_NO");
				posCode = rs.getString("POS_CODE");
				posCodeDescr = rs.getString("POS_CODE_DESCR");
				stanCode = rs.getString("STAN_CODE__HQ");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}*/
			JSONObject posDetailJson = getPosDetails( posCode, loginEmpCode, conn );
			posCodeDescr = checkNull( posDetailJson.getString("POS_CODE_DESCR") );
			posCode = checkNull( posDetailJson.getString("POS_CODE") );
			stanCode = checkNull( posDetailJson.getString("STAN_CODE") );
			/*String levelNoStr = checkNull( posDetailJson.getString("LEVEL_NO") );
			int levelNo = 0;
			if ( levelNoStr.length() > 0 )
			{
				levelNo = Integer.parseInt( levelNoStr );
			}*/
			boolean isMgr = posDetailJson.getBoolean( "IS_MGR" );
			System.out.println( "is_mgr : ["+ isMgr +"], pos_code : ["+ posCode +"]" );

			JSONArray mgrJsonArr = new JSONArray();
			JSONObject mgrJsonObj = new JSONObject();
			if( posCode.contains(",") )
			{
				posCode = posCode.replace(",", "','");
			}
			/*if( stanCode.contains(",") )
			{
				stanCode = stanCode.replace(",", "','");
			}*/
			String status = "";
			String sql = "SELECT STATUS FROM SELLS_PLANNING WHERE POS_CODE IN ( '"+ posCode +"' ) AND PRD_CODE = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, prdCode);
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				status = checkNull(rs.getString("STATUS"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			mgrJsonObj.put("pos_code_descr", posCodeDescr.replace("','", ","));
			mgrJsonObj.put("pos_code", posCode.replace("','", ","));
			mgrJsonObj.put("stan_code", stanCode.replace("','", ","));
			mgrJsonObj.put("sp_name", "All");
			mgrJsonObj.put("sales_pers", loginEmpCode);
			//mgrJsonObj.put("level_no", levelNo);
			mgrJsonObj.put("planning_status", status);
			mgrJsonObj.put( "is_mgr", isMgr );

			mgrJsonArr.add( mgrJsonObj );

			status = "";
			//boolean isMgr = isPlanningMgr( posCode, conn );
			boolean isPlanSubmitted = false;
			if( isMgr )
			{
				sql = "SELECT PE.POS_CODE_DESCR, PE.DESCR, PE.POS_CODE, PE.STAN_CODE,"
						+ " PE.EMP_CODE ,PE.EMP_NAME, PE.STATUS, PE.DESIGN_CODE, FN_GET_IS_PLANNING_MGR( PE.POS_CODE ) IS_MGR "
						+ " FROM TABLE( GETPLANNINGTEAMDATA.GETPOSCODESTANCODEDET( '"+posCode.replace("','", ",")+"', ? ) ) pe ";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, prdCode);
				rs = pStmt.executeQuery();
				while(rs.next())
				{
					mgrJsonObj = new JSONObject();

					mgrJsonObj.put("pos_code_descr", checkNull(rs.getString("POS_CODE_DESCR")));
					mgrJsonObj.put("descr", checkNull(rs.getString("DESCR")));
					mgrJsonObj.put("pos_code", checkNull(rs.getString("POS_CODE")));
					mgrJsonObj.put("stan_code", checkNull(rs.getString("STAN_CODE")));
					mgrJsonObj.put("sp_name", checkNull(rs.getString("EMP_NAME")));
					mgrJsonObj.put("sales_pers", checkNull(rs.getString("EMP_CODE")));
					//mgrJsonObj.put("level_no", rs.getInt("LEVEL_NO"));
					mgrJsonObj.put("is_mgr", Boolean.parseBoolean( checkNull(rs.getString("IS_MGR")).toLowerCase() ) );

					status = checkNull(rs.getString("STATUS"));
					mgrJsonObj.put( "planning_status", status );

					if( ! isPlanSubmitted && ( "".equalsIgnoreCase(status) || ! "S".equalsIgnoreCase(status) ) )
					{
						isPlanSubmitted = true;
					}

					mgrJsonArr.add( mgrJsonObj );
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			boolean isApprover = isPlanningApprover( posCode, conn );

			jsonObject.put( "subordinate_data", mgrJsonArr );
			jsonObject.put( "status_flag", isPlanSubmitted );
			jsonObject.put( "is_approver", isApprover );
		}
		catch(Exception e)
		{
			System.out.println( "Exception in getMgrData ["+e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
	}

	private Map<String, Map<String, ArrayList<String>>> getMgrSellPanningData(String tranId, Connection conn, String scCode, String stanCode, String posCode, String salesPers,String prdCode, String dateStr,HashMap<String, List<String>> rollCodes, String designCode) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		ArrayList<String> itmCodeArr = new ArrayList<String>();
		ArrayList<String> itmDescrArr = new ArrayList<String>();
		ArrayList<String> sellInQtyArr = new ArrayList<String>();
		ArrayList<String> sellOutQtyArr = new ArrayList<String>();
		ArrayList<String> sellInValArr = new ArrayList<String>();
		ArrayList<String> sellOutValArr = new ArrayList<String>();
		ArrayList<String> rateArr = new ArrayList<String>();
		ArrayList<String> closingStockArray = new ArrayList<String>();
		ArrayList<String> closingStkValArr = new ArrayList<String>();
		ArrayList<String> avgSellInQtyArr = new ArrayList<String>();
		ArrayList<String> avgSellOutQtyArr = new ArrayList<String>();
		ArrayList<String> avgSellInValArr = new ArrayList<String>();
		ArrayList<String> avgSellOutValArr = new ArrayList<String>();
		ArrayList<String> mktArr = new ArrayList<String>();
		ArrayList<String> groupArr = new ArrayList<String>();
		ArrayList<String> groupCodeArr = new ArrayList<String>();
		ArrayList<String> subGroupArr = new ArrayList<String>();
		ArrayList<String> scCodeArr = new ArrayList<String>();
		Map<String, Map<String, ArrayList<String>>> avgSellInOutMap = new HashMap<String, Map<String, ArrayList<String>>>();

		Map<String, ArrayList<String>> itmMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellInMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellOutMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> rateMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> closingMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> closingValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellInQtyMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellOutQtyMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> mktArrMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> productCodeMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sgroupMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> groupMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> itemDescrMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellInValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> sellOutValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellInValMap = new HashMap<String, ArrayList<String>>();
		Map<String, ArrayList<String>> avgSellOutValMap = new HashMap<String, ArrayList<String>>();

		Map<String, ArrayList<String>> scCodeMap = new LinkedHashMap<String, ArrayList<String>>();

		String sql = null;
		Date fromDate=null;

		JSONObject jsonData = new JSONObject();
		StringBuilder builder = new StringBuilder();
		try
		{
			builder = new StringBuilder();

			builder.append("SELECT * FROM ( WITH TEAM as (SELECT PE.POS_CODE AS POS_CODE,PE.STAN_CODE AS STAN_CODE__HQ ");
			builder.append("FROM TABLE(GETPLANNINGTEAMDATA.GETPOSCODESTANCODEDET( '"+posCode+"',? )) PE ");
			builder.append("WHERE PE.STATUS = 'S' ) ");
			builder.append("SELECT SPD.SC_CODE AS SC_CODE, DDF_GET_SC_CODE_NAME( SPD.SC_CODE ) DEALER_NAME, ");
			builder.append("SPD.ITEM_CODE AS ITEM_CODE, I.DESCR as DESCR, ");
			builder.append("NVL( FN_GET_PRICELIST_RATE( SPD.ITEM_CODE, I.PRICE_LIST ), 1 ) AS RATE, ");
			builder.append("I.PRODUCT_CODE AS PRODUCT_CODE, P.MKT_ARR AS MKT_ARR, P.SORT_ORDER, I.GRP_CODE AS GRP_CODE, ");
			builder.append("I.SGRP_CODE AS SGRP_CODE, ");
			builder.append("SUM(NVL(FN_GET_STK_SELL_IN( SPD.SC_CODE, SPD.ITEM_CODE, T.STAN_CODE__HQ, T.POS_CODE, ?, ?, 'QTY' ),0 )) AS SELL_IN_QTY, ");
			builder.append("SUM(NVL(FN_GET_STK_SELL_OUT( SPD.SC_CODE, SPD.ITEM_CODE, T.STAN_CODE__HQ, T.POS_CODE, ?, ?, 'QTY' ),0)) AS SELL_OUT_QTY, ");
			builder.append("SUM(NVL(FN_GET_STK_SELL_IN( SPD.SC_CODE, SPD.ITEM_CODE, T.STAN_CODE__HQ, T.POS_CODE, ?, ?, 'VALUE' ),0)) AS SELL_IN_VAL, ");
			builder.append("SUM(NVL(FN_GET_STK_SELL_OUT( SPD.SC_CODE, SPD.ITEM_CODE, T.STAN_CODE__HQ, T.POS_CODE, ?, ?,'VALUE' ),0)) AS SELL_OUT_VAL, ");
			builder.append("FN_GET_MGR_SELLS_CLOSING_STK( '', SPD.SC_CODE, SPD.ITEM_CODE, ? ) AS CLOSING_STOCK, ");
			builder.append("ROUND(SUM(SPD.SELL_IN_QTY),0) AS AVG_SELL_IN_QTY, ");
			builder.append("SUM(SPD.SELL_IN_VALUE) AS AVG_SELL_IN_VAL, ");
			builder.append("ROUND(SUM(SPD.SELL_OUT_QTY),0) AS AVG_SELL_OUT_QTY, ");
			builder.append("SUM(SPD.SELL_OUT_VALUE) AS AVG_SELL_OUT_VAL ");
			builder.append("FROM TEAM T ");
			builder.append("LEFT OUTER JOIN SELLS_PLANNING SP ON SP.POS_CODE = T.POS_CODE AND SP.STAN_CODE = T.STAN_CODE__HQ ");
			builder.append("LEFT OUTER JOIN SELLS_PLANNING_DET SPD ON SP.TRAN_ID = SPD.TRAN_ID ");
			builder.append("LEFT OUTER JOIN strg_customer STRG ON STRG.sc_code = SPD.SC_CODE ");
			builder.append("LEFT OUTER JOIN ITEM I ON SPD.ITEM_CODE = I.ITEM_CODE ");
			builder.append("LEFT OUTER JOIN PRODUCT P ON I.PRODUCT_CODE = P.PRODUCT_CODE ");
			builder.append("WHERE SP.PRD_CODE = (CASE WHEN NVL(?,'NA') = 'NA' THEN TO_CHAR(SYSDATE, 'YYYYMM') ELSE ? END) ");
			builder.append("AND SP.STATUS = 'S' AND P.PRODUCT_CODE NOT IN ('GRP03') ");
			builder.append("GROUP BY SPD.SC_CODE, SPD.ITEM_CODE, I.DESCR, I.PRICE_LIST, I.PRODUCT_CODE, P.MKT_ARR, P.SORT_ORDER, I.GRP_CODE, I.SGRP_CODE ) PLAN_DET ");
			builder.append("ORDER by PLAN_DET.DEALER_NAME, PLAN_DET.SC_CODE, PLAN_DET.SORT_ORDER, PLAN_DET.DESCR ");

			pstmt = conn.prepareStatement(builder.toString(),ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_UPDATABLE);
			pstmt.setString(1, prdCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, dateStr);
			pstmt.setString(4, prdCode);
			pstmt.setString(5, dateStr);
			pstmt.setString(6, prdCode);
			pstmt.setString(7, dateStr);
			pstmt.setString(8, prdCode);
			pstmt.setString(9, dateStr);
			pstmt.setString(10, dateStr);
			pstmt.setString(11, prdCode);
			pstmt.setString(12, prdCode);

			rs = pstmt.executeQuery();
			String lastSelectedScCode = "";
			int sizeOfArray = 0;
			String greatestSizeScCode ="";
			while(rs.next())
			{
				String currentSelectedScCode = checkNull( rs.getString("SC_CODE") );
				if( currentSelectedScCode.equals(lastSelectedScCode) )
				{
					itmCodeArr.add( checkNull( rs.getString("ITEM_CODE") ) );
					sellInQtyArr.add( checkNull( rs.getString("SELL_IN_QTY") ) );
					sellOutQtyArr.add( checkNull( rs.getString("SELL_OUT_QTY") ) );
					sellInValArr.add( checkNull( rs.getString("SELL_IN_VAL") ) );
					sellOutValArr.add( checkNull( rs.getString("SELL_OUT_VAL") ) );
					rateArr.add( checkNull( rs.getString("RATE") ) );
					closingStockArray.add( checkNull( rs.getString("CLOSING_STOCK") ) );
					closingStkValArr.add( checkNull( rs.getString("CLOSING_STOCK") ) );
					itmDescrArr.add( checkNull( rs.getString("DESCR") ) );
					mktArr.add( checkNull( rs.getString("MKT_ARR") ) );
					groupArr.add( checkNull( rs.getString("PRODUCT_CODE") ) );
					groupCodeArr.add( checkNull( rs.getString("GRP_CODE") ) );
					subGroupArr.add( checkNull( rs.getString("SGRP_CODE") ) );
					avgSellInQtyArr.add(String.valueOf(rs.getDouble("AVG_SELL_IN_QTY") ) );
					avgSellOutQtyArr.add(String.valueOf(rs.getDouble("AVG_SELL_OUT_QTY") ) );
					avgSellInValArr.add(String.valueOf(rs.getDouble("AVG_SELL_IN_VAL") ) );
					avgSellOutValArr.add(String.valueOf(rs.getDouble("AVG_SELL_OUT_VAL") ) );
					scCodeArr.add( checkNull( rs.getString("DEALER_NAME") ) );
					lastSelectedScCode = currentSelectedScCode;

					if(rs.isLast())
					{
						if( itmCodeArr.size() > 0 )
						{
							if(itmCodeArr.size() > sizeOfArray)
							{
								sizeOfArray = itmCodeArr.size();
								greatestSizeScCode = lastSelectedScCode;
							}
							itmMap.put(lastSelectedScCode, itmCodeArr);
							sellInMap.put(lastSelectedScCode, sellInQtyArr);
							sellOutMap.put(lastSelectedScCode, sellOutQtyArr);
							sellInValMap.put(lastSelectedScCode, sellInValArr);
							sellOutValMap.put(lastSelectedScCode, sellOutValArr);
							closingMap.put(lastSelectedScCode, closingStockArray);
							closingValMap.put(lastSelectedScCode, closingStkValArr );
							rateMap.put(lastSelectedScCode, rateArr);
							avgSellInQtyMap.put(lastSelectedScCode, avgSellInQtyArr);
							avgSellOutQtyMap.put(lastSelectedScCode, avgSellOutQtyArr);
							mktArrMap.put(lastSelectedScCode, mktArr);
							productCodeMap.put(lastSelectedScCode, groupArr);
							sgroupMap.put(lastSelectedScCode, subGroupArr);
							groupMap.put(lastSelectedScCode, groupCodeArr);
							itemDescrMap.put(lastSelectedScCode, itmDescrArr);
							scCodeMap.put(lastSelectedScCode, scCodeArr);
							avgSellInValMap.put(lastSelectedScCode, avgSellInValArr);
							avgSellOutValMap.put(lastSelectedScCode, avgSellOutValArr);
						}
					}
				}
				else
				{
					if( itmCodeArr.size() > 0 )
					{
						if(itmCodeArr.size() > sizeOfArray)
						{
							sizeOfArray = itmCodeArr.size();
							greatestSizeScCode = lastSelectedScCode;
						}
						itmMap.put(lastSelectedScCode, itmCodeArr);
						sellInMap.put(lastSelectedScCode, sellInQtyArr);
						sellOutMap.put(lastSelectedScCode, sellOutQtyArr);
						sellInValMap.put(lastSelectedScCode, sellInValArr);
						sellOutValMap.put(lastSelectedScCode, sellOutValArr);
						closingMap.put(lastSelectedScCode, closingStockArray);
						closingValMap.put(lastSelectedScCode, closingStkValArr );
						rateMap.put(lastSelectedScCode, rateArr);
						avgSellInQtyMap.put(lastSelectedScCode, avgSellInQtyArr);
						avgSellOutQtyMap.put(lastSelectedScCode, avgSellOutQtyArr);
						mktArrMap.put(lastSelectedScCode, mktArr);
						productCodeMap.put(lastSelectedScCode, groupArr);
						sgroupMap.put(lastSelectedScCode, subGroupArr);
						groupMap.put(lastSelectedScCode, groupCodeArr);
						itemDescrMap.put(lastSelectedScCode, itmDescrArr);
						scCodeMap.put(lastSelectedScCode, scCodeArr);
						avgSellInValMap.put(lastSelectedScCode, avgSellInValArr);
						avgSellOutValMap.put(lastSelectedScCode, avgSellOutValArr);
					}
					itmCodeArr = new ArrayList<String>();
					itmDescrArr = new ArrayList<String>();
					sellInQtyArr = new ArrayList<String>();
					sellOutQtyArr = new ArrayList<String>();
					sellInValArr = new ArrayList<String>();
					sellOutValArr = new ArrayList<String>();
					rateArr = new ArrayList<String>();
					closingStockArray = new ArrayList<String>();
					closingStkValArr = new ArrayList<String>();
					avgSellInQtyArr = new ArrayList<String>();
					avgSellOutQtyArr = new ArrayList<String>();
					avgSellInValArr = new ArrayList<String>();
					avgSellOutValArr = new ArrayList<String>();
					mktArr = new ArrayList<String>();
					groupArr = new ArrayList<String>();
					groupCodeArr = new ArrayList<String>();
					subGroupArr = new ArrayList<String>();
					scCodeArr = new ArrayList<String>();

					itmCodeArr.add( checkNull( rs.getString("ITEM_CODE") ) );
					sellInQtyArr.add( checkNull( rs.getString("SELL_IN_QTY") ) );
					sellOutQtyArr.add( checkNull( rs.getString("SELL_OUT_QTY") ) );
					sellInValArr.add( checkNull( rs.getString("SELL_IN_VAL") ) );
					sellOutValArr.add( checkNull( rs.getString("SELL_OUT_VAL") ) );
					rateArr.add( checkNull( rs.getString("RATE") ) );
					closingStockArray.add( checkNull( rs.getString("CLOSING_STOCK") ) );
					closingStkValArr.add( checkNull( rs.getString("CLOSING_STOCK") ) );
					itmDescrArr.add( checkNull( rs.getString("DESCR") ) );
					mktArr.add( checkNull( rs.getString("MKT_ARR") ) );
					groupArr.add( checkNull( rs.getString("PRODUCT_CODE") ) );
					groupCodeArr.add( checkNull( rs.getString("GRP_CODE") ) );
					subGroupArr.add( checkNull( rs.getString("SGRP_CODE") ) );
					avgSellInQtyArr.add(String.valueOf(rs.getDouble("AVG_SELL_IN_QTY") ) );
					avgSellOutQtyArr.add(String.valueOf(rs.getDouble("AVG_SELL_OUT_QTY") ) );
					avgSellInValArr.add(String.valueOf(rs.getDouble("AVG_SELL_IN_VAL") ) );
					avgSellOutValArr.add(String.valueOf(rs.getDouble("AVG_SELL_OUT_VAL") ) );
					scCodeArr.add( checkNull( rs.getString("DEALER_NAME") ) );

					lastSelectedScCode = currentSelectedScCode;
				}
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}

			itmCodeArr = itmMap.get(greatestSizeScCode);
			itmDescrArr = itemDescrMap.get(greatestSizeScCode);
			sellInQtyArr = sellInMap.get(greatestSizeScCode);
			sellOutQtyArr = sellOutMap.get(greatestSizeScCode);
			sellInValArr = sellInValMap.get(greatestSizeScCode);
			sellOutValArr = sellOutValMap.get(greatestSizeScCode);
			rateArr = rateMap.get(greatestSizeScCode);
			closingStockArray = closingMap.get(greatestSizeScCode);
			closingStkValArr = closingValMap.get(greatestSizeScCode);
			avgSellInQtyArr = avgSellInQtyMap.get(greatestSizeScCode);
			avgSellOutQtyArr = avgSellOutQtyMap.get(greatestSizeScCode);
			avgSellInValArr = avgSellInValMap.get(greatestSizeScCode);
			avgSellOutValArr = avgSellOutValMap.get(greatestSizeScCode);
			mktArr = mktArrMap.get(greatestSizeScCode);
			groupArr = productCodeMap.get(greatestSizeScCode);
			groupCodeArr = groupMap.get(greatestSizeScCode);
			subGroupArr = sgroupMap.get(greatestSizeScCode);
			scCodeArr = scCodeMap.get(greatestSizeScCode);

			for (Entry<String, ArrayList<String>> entry : itmMap.entrySet())
			{
				ArrayList<String> itemArrayList = itmMap.get( entry.getKey() );
				if( itemArrayList.size() < sizeOfArray)
				{
					for(int arrCnt= 0;arrCnt < sizeOfArray;arrCnt++)
					{
						if( !itemArrayList.contains( itmCodeArr.get(arrCnt)) )
						{
							itmMap.get( entry.getKey() ).add(itmCodeArr.get(arrCnt));
							itemDescrMap.get( entry.getKey() ).add(itmDescrArr.get(arrCnt));
							mktArrMap.get( entry.getKey() ).add(mktArr.get(arrCnt));
							sellInMap.get( entry.getKey() ).add("0");
							sellOutMap.get( entry.getKey() ).add("0");
							sellInValMap.get( entry.getKey() ).add("0");
							sellOutValMap.get( entry.getKey() ).add("0");
							rateMap.get( entry.getKey() ).add(rateArr.get(arrCnt));
							closingMap.get( entry.getKey() ).add("0");
							closingValMap.get( entry.getKey() ).add("0");
							avgSellInQtyMap.get( entry.getKey() ).add("0");
							avgSellOutQtyMap.get( entry.getKey() ).add("0");
							avgSellInValMap.get( entry.getKey() ).add("0");
							avgSellOutValMap.get( entry.getKey() ).add("0");
							productCodeMap.get( entry.getKey() ).add(groupArr.get(arrCnt));
							groupMap.get( entry.getKey() ).add(groupCodeArr.get(arrCnt));
							sgroupMap.get( entry.getKey() ).add(subGroupArr.get(arrCnt));
							scCodeMap.get( entry.getKey() ).add(scCodeArr.get(arrCnt));
						}
					}
				}
			}
			if( ! itemDescrMap.isEmpty() )
			{
				avgSellInOutMap.put("ITEM_DESCR", itemDescrMap);
				avgSellInOutMap.put("MKT_ARR", mktArrMap);
				avgSellInOutMap.put("PRODUCT_CODE", productCodeMap);
				avgSellInOutMap.put("ITEM_CODE", itmMap);
				avgSellInOutMap.put("SELL_IN_QTY", sellInMap);
				avgSellInOutMap.put("SELL_OUT_QTY", sellOutMap);
				avgSellInOutMap.put("SELL_IN_VAL", sellInValMap);
				avgSellInOutMap.put("SELL_OUT_VAL", sellOutValMap);
				avgSellInOutMap.put("CLOSING_STOCK", closingMap);
				avgSellInOutMap.put("CLOSING_STOCK_VAL", closingValMap);
				avgSellInOutMap.put("RATE", rateMap);
				avgSellInOutMap.put("AVG_SELL_IN_QTY", avgSellInQtyMap);
				avgSellInOutMap.put("AVG_SELL_OUT_QTY", avgSellOutQtyMap);
				avgSellInOutMap.put("AVG_SELL_IN_VAL", avgSellInValMap);
				avgSellInOutMap.put("AVG_SELL_OUT_VAL", avgSellOutValMap);
				avgSellInOutMap.put("GRP_CODE", groupMap);
				avgSellInOutMap.put("SGRP_CODE", sgroupMap);
				avgSellInOutMap.put("SGRP_CODE", sgroupMap);
				avgSellInOutMap.put("SC_CODE", scCodeMap);
			}
		}
		catch(Exception e)
		{
			System.out.println("SellsStock.getSellPanningData() : "+e );
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return avgSellInOutMap;
	}

	private String sendingMailList( String empCode, int levelNo, Connection conn )
	{
		String sql = "",reportTo ="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT LISTAGG(TRIM(O1.EMP_CODE), ',') WITHIN GROUP (ORDER BY O1.EMP_CODE) AS REPORT_TO "
					+ "FROM ORG_STRUCTURE O1 "
					+ "WHERE O1.LEVEL_NO >= ? AND O1.EMP_CODE <> ? "
					+ "START WITH O1.EMP_CODE = ? CONNECT BY PRIOR O1.POS_CODE__REPTO = O1.POS_CODE";
			pstmt = conn.prepareStatement(sql);
			if( levelNo <= 6 )
			{
				pstmt.setInt( 1, levelNo-1 );
			}
			else
			{
				pstmt.setInt( 1, 6 );
			}
			pstmt.setString( 2, empCode );
			pstmt.setString( 3, empCode );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				reportTo = checkNull( rs.getString("REPORT_TO") );
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println( "sendingMailList :: reportTo : ["+ reportTo +"]" );
			if ( reportTo.length() == 0 )
			{
				sql = "SELECT O2.EMP_CODE AS REPORT_TO "
						+ " FROM ORG_STRUCTURE O1, ORG_STRUCTURE O2 "
						+ " WHERE O1.POS_CODE__REPTO = O2.POS_CODE AND O1.EMP_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString( 1, empCode );
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					reportTo = checkNull( rs.getString("REPORT_TO") );
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch( Exception e )
		{
			e.printStackTrace();
			System.out.println( "SellsStock.sendingMailList() ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return reportTo;
	}

	public String updatePlanningData( final String allData, final UserInfoBean userInfo )
	{
		System.out.println( "In updatePlanningData" );
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		JSONObject responseObject = new JSONObject();
		JSONArray jsonArray = new JSONArray();
		try
		{
			String tranID = "", status = "";
			ConnDriver connDriver = new ConnDriver();
			if(userInfo != null)
			{
				conn = connDriver.getConnectDB(userInfo.getTransDB());
				conn.setAutoCommit( false );
			}

			String tranId = "";
			String loginEmpCode = userInfo.getLoginCode();
			JSONObject json = new JSONObject(allData);
			JSONObject headerJson = (JSONObject)json.get("headerFormData");

			String salesPers = headerJson.getString("sales_pers");
			String prdCode = headerJson.getString("prd_code");
			String stanCode = headerJson.getString("stan_code");
			String posCode = headerJson.getString("pos_code");
			final String prdDescr = headerJson.getString("descr");

			System.out.println( "posCode ["+ posCode +"], salesPers ["+ salesPers +"]" );
			DBAccessEJB dbAcc = new DBAccessEJB();
			if( loginEmpCode.equalsIgnoreCase( salesPers ) )
			{
				String str = "SELECT LISTAGG(PE.POS_CODE, ',') WITHIN GROUP (ORDER BY PE.POS_CODE) AS POS_CODE, " +
						" LISTAGG(PE.STAN_CODE, ',') WITHIN GROUP (ORDER BY PE.STAN_CODE) AS STAN_CODE, " +
						" LISTAGG(PE.EMP_CODE, ',') WITHIN GROUP (ORDER BY PE.EMP_CODE) AS EMP_CODE " +
						" FROM TABLE( GETPLANNINGTEAMDATA.GETPOSCODESTANCODEDET( '"+ posCode +"', ? ) ) PE " +
						" WHERE PE.STATUS = 'S' ";
				pstmt = conn.prepareStatement(str);
				pstmt.setString(1, prdCode);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					posCode = rs.getString("POS_CODE");
					stanCode = rs.getString("STAN_CODE");
					salesPers = rs.getString("EMP_CODE");
				}
				posCode = posCode.replace(",", "','");
				stanCode = stanCode.replace(",", "','");
				salesPers = salesPers.replace(",", "','");

				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}

			String str = "UPDATE SELLS_PLANNING SET STATUS = 'R', CHG_DATE = SYSDATE, CHG_TERM = ?, CHG_USER = ? "
					+ " WHERE STAN_CODE IN ( '"+ stanCode +"' ) "
					+ " AND POS_CODE IN ( '"+ posCode +"' ) "
					+ " AND PRD_CODE = ? "
					+ " AND STATUS ='S'";
			pstmt = conn.prepareStatement(str);
			pstmt.setString(1, userInfo.getRemoteHost());
			pstmt.setString(2, userInfo.getLoginCode());
			pstmt.setString(3, prdCode);
			int count = pstmt.executeUpdate();
			System.out.println( "In updatePlanningData :: ["+ count +"] rows updated" );
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			if( count > 0 )
			{
				conn.commit();
			}

			String errSting = genericUtility.getErrorString("tran_id", "VTEDIRESET", userInfo.getLoginCode());
			JSONObject successMsg = excpUtility.convertXmlToJsonInError(errSting);

			responseObject.put("tran_id", tranID);
			responseObject.put("success_msg", successMsg);

			//String loginPosCode = getPosCode( loginEmpCode, conn );
			getMgrData( userInfo.getLoginCode(), null, prdCode, responseObject, conn );

			jsonArray.add(responseObject);

			sendNotification( allData, prdCode, tranId, salesPers, "sendBack", userInfo );
			if ( ! isPlanningMgr( posCode, conn ) )
			{
				updatePoolSellOut( posCode, stanCode, null, prdCode, "sendBack", userInfo );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :: SellsStock.updatePlanningData() : ["+ e.getMessage() +"]" );

			jsonArray = excpUtility.handleException( e );
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e)
			{
				System.out.println("Exeption while closing connection in insertData :: "+e.getMessage());
			}
		}
		return jsonArray.toString();
	}

	/*private void sendEmailAndNotificationOnReset( UserInfoBean userInfo, String prdCode, String allData, String tranID, String empCodes, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList sendMailAndNotfication = new ArrayList();
		try
		{
			JSONObject json = new JSONObject(allData);
			JSONObject	headerJson = (JSONObject)json.get("headerFormData");
			String salesPersName = headerJson.getString("sales_pers_name");

			String reportTo = "", emailId ="", objName ="sell_planning", refSer ="SELL-P";
			String msgText = "Testing for mail", subText = "Testing for mail", lineNo="1", entityCode ="", sql ="";
			ArrayList<String> userIdList = new ArrayList<String>();

			String loginEmpCode = userInfo.getEmpCode();
			System.out.println( "loginEmpCode : ["+ loginEmpCode +"]" );

			if(salesPersName.equalsIgnoreCase("All"))
			{
				sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, userInfo.getLoginCode());
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					salesPersName = rs.getString("SP_NAME");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			System.out.println( "empCodes : ["+ empCodes +"] salesPersName ["+ salesPersName +"]" );
			String subject = "Sales Plan is send back by "+ salesPersName;
			String postMessage = "Sales Plan is send back by "+ salesPersName +" for the month of "+ prdCode +".";

			sql = "SELECT LISTAGG(EMAIL_ID_OFF, ',') WITHIN GROUP (ORDER BY EMAIL_ID_OFF) AS EMAIL_ID_OFF "
					+ " FROM EMPLOYEE WHERE EMP_CODE IN ( '"+ empCodes +"' )";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				emailId = rs.getString("EMAIL_ID_OFF");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println( "emailId : ["+ emailId +"]" );

			sql = "SELECT LISTAGG(ENTITY_CODE, ',') WITHIN GROUP (ORDER BY ENTITY_CODE) AS ENTITY_CODE "
					+ " FROM USERS WHERE EMP_CODE in ( '"+ empCodes +"' )";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				entityCode = rs.getString("ENTITY_CODE");
				userIdList.add(entityCode);
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println( "userIdList : ["+ userIdList +"]" );

			StringBuffer mailDomStr = new StringBuffer( "<ROOT>" );
			mailDomStr.append( "<TRANS_INFO>" );
			mailDomStr.append( "<OBJ_NAME>" ).append( objName ).append( "</OBJ_NAME>" );
			mailDomStr.append( "<REF_SER>" ).append( refSer ).append( "</REF_SER>" );
			mailDomStr.append( "<REF_ID>" ).append( tranID ).append( "</REF_ID>" );
			mailDomStr.append( "<LINE_NO>" ).append( lineNo ).append( "</LINE_NO>" );
			mailDomStr.append( "<XSL_FILE_NAME></XSL_FILE_NAME>" );
			mailDomStr.append( "</TRANS_INFO>" );
			mailDomStr.append( "<MAIL>" );
			mailDomStr.append( "<EMAIL_TYPE>page</EMAIL_TYPE>" );
			mailDomStr.append( "<ENTITY_CODE>" ).append( entityCode ).append( "</ENTITY_CODE>" ); //TO DO
			mailDomStr.append( "<ENTITY_TYPE>" ).append( "E" ).append( "</ENTITY_TYPE>" );
			mailDomStr.append( "<SUBJECT>" ).append( subject ).append( "</SUBJECT>" );
			mailDomStr.append( "<BODY_TEXT>" ).append( postMessage ).append( "</BODY_TEXT>" );
			mailDomStr.append( "<TO_ADD>" ).append( emailId ).append( "</TO_ADD>" );
			mailDomStr.append( "<CC_ADD></CC_ADD>" );
			mailDomStr.append( "<FORMAT_CODE></FORMAT_CODE>" );
			mailDomStr.append( "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" );
			mailDomStr.append( "</MAIL>" );
			mailDomStr.append( "<XML_DATA></XML_DATA>" );
			mailDomStr.append( "</ROOT>" );

			EMail email = new EMail();
			email.sendMail( mailDomStr.toString(), "ITM", conn );

			PublishPushNotificationEJB publishPushNotificationEJB = new PublishPushNotificationEJB();
			publishPushNotificationEJB.invockPushNotification(postMessage, "", PublishPushNotificationRemote.OPEN_TARGET_TRANSACTION,tranID, userIdList , "", tranID, refSer, loginEmpCode, 0,userInfo);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "SellsStock.sendEmailAndNotificationOnReset() :: ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}*/

	//Added By Sainath T. on 18/04/2020 [if called from dashboard]-Start
	private String getStanAndPosCode( Connection conn, String loginEmpCode )
	{
		PreparedStatement pStmt = null;
		ResultSet rs =  null;
		String sql ="";
		String respString = "";
		String posCode = "", stanCode = "";
		try
		{
			sql = "SELECT LISTAGG(O1.POS_CODE, ',') WITHIN GROUP (ORDER BY O1.POS_CODE) POS_CODE, " +
				" LISTAGG(O1.STAN_CODE__HQ, ',') WITHIN GROUP (ORDER BY O1.STAN_CODE__HQ) STAN_CODE " +
				" FROM ORG_STRUCTURE O1 " +
				" WHERE O1.EMP_CODE = ? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, loginEmpCode);
			rs = pStmt.executeQuery();
			while(rs.next())
			{
				posCode = rs.getString("POS_CODE");
				stanCode = rs.getString("STAN_CODE");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		respString = (posCode + ":" + stanCode);
		return respString;
	}
	//Added By Sainath T. on 18/04/2020 [if called from dashboard]-End

	private void updatePoolSellOut( final String posCode, final String stanCode, final String scCode, final String prdCode, final String poolSelloutFor, final UserInfoBean userInfo ) throws ITMException
	{
		try
		{
			new Thread( poolSelloutFor + "_pool_sell_out_thread" )
			{
				Connection connRef = null;
				PreparedStatement pstmt =  null;
				ResultSet rs = null;
				public void run()
				{
					try
					{
						ConnDriver connDriver = new ConnDriver();
						connRef = connDriver.getConnectDB(userInfo.getTransDB());
						connRef.setAutoCommit( false );

						String sql = "";
						String loginCode = userInfo.getLoginCode();
						String chgTerm = userInfo.getRemoteHost();
						boolean isFromPlanning = false;
						if ( "stkInOut".equalsIgnoreCase( poolSelloutFor ) )
						{
							isFromPlanning = false;

							sql = "SELECT IN_OUT.SC_CODE, IN_OUT.PRD_CODE, IN_OUT.POS_CODE, IN_OUT_DET.ITEM_CODE, ORG.POOL_CODE, "
									+ " FN_GET_POOL_SELL_OUT_ACT( IN_OUT.STAN_CODE, IN_OUT.POS_CODE, IN_OUT.SC_CODE, IN_OUT_DET.ITEM_CODE, IN_OUT.PRD_CODE, 'QTY' ) SELL_OUT_QTY ,"
									+ " FN_GET_POOL_SELL_OUT_ACT( IN_OUT.STAN_CODE, IN_OUT.POS_CODE, IN_OUT.SC_CODE, IN_OUT_DET.ITEM_CODE, IN_OUT.PRD_CODE, 'VALUE' ) SELL_OUT_VAL "
									+ " FROM STK_SELL_IN_OUT IN_OUT, STK_SELL_IN_OUT_DET IN_OUT_DET, ITEM ITEM, ORG_STRUCTURE ORG "
									+ " WHERE IN_OUT.TRAN_ID = IN_OUT_DET.TRAN_ID "
									+ " AND ITEM.ITEM_CODE = IN_OUT_DET.ITEM_CODE "
									+ " AND IN_OUT.POS_CODE = ORG.POS_CODE "
									+ " AND IN_OUT.STAN_CODE = ORG.STAN_CODE__HQ "
									+ " AND IN_OUT.PRD_CODE = ? "
									+ " AND IN_OUT.POS_CODE IN ( '"+ posCode +"' ) "
									+ " AND IN_OUT.STAN_CODE IN ( '"+ stanCode +"' ) "
									+ " AND IN_OUT.SC_CODE = ? "
									+ " AND IN_OUT.STATUS = 'A' "
									+ " AND IN_OUT_DET.MKT_ARR = 'Y'";

							pstmt = connRef.prepareStatement( sql );
							pstmt.setString(1, prdCode);
							pstmt.setString(2, scCode);
						}
						else if ( "salesPlanning".equalsIgnoreCase( poolSelloutFor ) )
						{
							isFromPlanning = true;

							sql = "SELECT PLAN_DET.SC_CODE, PLAN.PRD_CODE, PLAN.POS_CODE, PLAN.STAN_CODE, PLAN_DET.ITEM_CODE, ORG.POOL_CODE, "
									+ " FN_GET_POOL_SELL_OUT_PLAN( PLAN.STAN_CODE, PLAN.POS_CODE, PLAN_DET.SC_CODE, PLAN_DET.ITEM_CODE, PLAN.PRD_CODE, 'QTY' ) SELL_OUT_QTY ,"
									+ " FN_GET_POOL_SELL_OUT_PLAN( PLAN.STAN_CODE, PLAN.POS_CODE, PLAN_DET.SC_CODE, PLAN_DET.ITEM_CODE, PLAN.PRD_CODE, 'VALUE' ) SELL_OUT_VAL "
									+ " FROM SELLS_PLANNING PLAN, SELLS_PLANNING_DET PLAN_DET, ITEM ITEM, ORG_STRUCTURE ORG "
									+ " WHERE PLAN.TRAN_ID = PLAN_DET.TRAN_ID "
									+ " AND ITEM.ITEM_CODE = PLAN_DET.ITEM_CODE "
									+ " AND PLAN.POS_CODE = ORG.POS_CODE "
									+ " AND PLAN.STAN_CODE = ORG.STAN_CODE__HQ "
									+ " AND PLAN.PRD_CODE = ? "
									+ " AND PLAN.POS_CODE IN ( '"+ posCode +"' ) "
									+ " AND PLAN.STAN_CODE IN ( '"+ stanCode +"' ) "
									+ " AND PLAN.STATUS = 'S' "
									+ " AND PLAN_DET.MKT_ARR = 'Y' ";

							pstmt = connRef.prepareStatement( sql );
							pstmt.setString(1, prdCode);
						}
						else
						{
							isFromPlanning = true;

							sql = "SELECT PLAN.PRD_CODE, PLAN_DET.SC_CODE, PLAN.POS_CODE, PLAN.STAN_CODE, PLAN_DET.ITEM_CODE, ORG.POOL_CODE, " +
									" FN_GET_POOL_SELL_OUT_PLAN( PLAN.STAN_CODE, PLAN.POS_CODE, PLAN_DET.SC_CODE, PLAN_DET.ITEM_CODE, PLAN.PRD_CODE, 'QTY' ) SELL_OUT_QTY , " +
									" FN_GET_POOL_SELL_OUT_PLAN( PLAN.STAN_CODE, PLAN.POS_CODE, PLAN_DET.SC_CODE, PLAN_DET.ITEM_CODE, PLAN.PRD_CODE, 'VALUE' ) SELL_OUT_VAL " +
									" FROM SELLS_PLANNING PLAN, SELLS_PLANNING_DET PLAN_DET, ITEM ITEM, ORG_STRUCTURE ORG " +
									" WHERE PLAN.TRAN_ID = PLAN_DET.TRAN_ID " +
									" AND ITEM.ITEM_CODE = PLAN_DET.ITEM_CODE " +
									" AND PLAN.POS_CODE = ORG.POS_CODE " +
									" AND PLAN.STAN_CODE = ORG.STAN_CODE__HQ " +
									" AND PLAN.PRD_CODE = ? " +
									" AND TRIM(PLAN.POS_CODE) IN ( '"+ posCode +"' ) " +
									" AND TRIM(PLAN.STAN_CODE) IN ( '"+ stanCode +"' ) " +
									" AND PLAN.STATUS = 'R' " +
									" AND PLAN_DET.MKT_ARR = 'Y' ";

							pstmt = connRef.prepareStatement( sql );
							pstmt.setString(1, prdCode);
						}
						rs = pstmt.executeQuery();
						while( rs.next() )
						{
							insertPoolSellOut( checkNull(rs.getString("POOL_CODE")), checkNull(rs.getString("ITEM_CODE")), checkNull(rs.getString("POS_CODE")), checkNull(rs.getString("SC_CODE")), checkNull(rs.getString("PRD_CODE")), rs.getInt("SELL_OUT_QTY"), rs.getInt("SELL_OUT_VAL"), loginCode, chgTerm, isFromPlanning, connRef );
						}
						if( rs != null )
						{
							rs.close();
							rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
						if( connRef != null )
						{
							connRef.commit();

							connRef.close();
							connRef = null;
						}
						System.out.println( "pool_sell_out updation done" );
					}
					catch (Exception e)
					{
						System.out.println( "Exception :: updatePoolSellOut : inside thread : ["+ e.getMessage() +"]" );
						e.printStackTrace();
			        	try
			        	{
			        		if( connRef != null )
			        		{
			        			connRef.rollback();
			        		}
			        	}
			        	catch (SQLException e1)
			        	{
			        		e1.printStackTrace();
			        	}
			        }
					finally
					{
						try
						{
							if( rs != null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if( connRef != null )
							{
								connRef.close();
								connRef = null;
							}
						}
						catch (Exception e)
						{
							e.printStackTrace();
						}
					}
				}
			}.start();
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: updatePoolSellOut : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}

	private void insertPoolSellOut( String poolCode, String itemCode, String posCode, String scCode, String prdCode, int sellOutQty, int sellOutVal, String empCode, String remoteHost, Boolean isFromPlanning, Connection conn ) throws ITMException
	{
		StringBuilder builder = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String seqQuery = "";
			Date currDate = new Date();
			SimpleDateFormat sdfAppl = new SimpleDateFormat(DATE_FORMAT);
			Timestamp valueOfCurrDate = Timestamp.valueOf(genericUtility.getValidDateString(sdfAppl.format(currDate),DATE_FORMAT,genericUtility.getDBDateFormat()) + " 00:00:00.0");

			boolean isUpdate = isPoolSellOutExist( itemCode, posCode, scCode, prdCode, poolCode, conn );

			if( isUpdate )
			{
				if( isFromPlanning )
				{
					seqQuery = "UPDATE POOL_SELL_OUT SET SELL_OUT_PLAN_QTY = ?,SELL_OUT_PLAN_VAL = ?,POS_CODE = ?,CHG_DATE = ?,CHG_USER = ?,CHG_TERM= ? WHERE POOL_CODE = ? AND PRD_CODE = ? AND ITEM_CODE = ? AND SC_CODE = ? ";
				}
				else
				{
					seqQuery = "UPDATE POOL_SELL_OUT SET SELL_OUT_ACT_QTY = ?,SELL_OUT_ACT_VAL = ?,POS_CODE = ?,CHG_DATE = ?,CHG_USER = ?,CHG_TERM= ? WHERE POOL_CODE = ? AND PRD_CODE = ? AND ITEM_CODE = ? AND SC_CODE = ? ";
				}
				pstmt = conn.prepareStatement( seqQuery );
				pstmt.setInt(1, sellOutQty);
				pstmt.setInt(2, sellOutVal);
				pstmt.setString(3, posCode);
				pstmt.setTimestamp(4, valueOfCurrDate);
				pstmt.setString(5, empCode);
				pstmt.setString(6, remoteHost);
				pstmt.setString(7, poolCode);
				pstmt.setString(8, prdCode);
				pstmt.setString(9, itemCode);
				pstmt.setString(10, scCode);

				int updateCnt = pstmt.executeUpdate();
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			else
			{
				String tranId = "";
				seqQuery = "SELECT POOL_SELL_OUT_SEQ.NEXTVAL FROM DUAL";
				pstmt = conn.prepareStatement( seqQuery );
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					tranId = rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				builder = new StringBuilder();
				builder = builder.append("INSERT INTO POOL_SELL_OUT (TRAN_ID,TRAN_DATE,POS_CODE,POOL_CODE,SC_CODE,ITEM_CODE,PRD_CODE,SELL_OUT_PLAN_QTY,SELL_OUT_ACT_QTY,SELL_OUT_PLAN_VAL,SELL_OUT_ACT_VAL,CHG_DATE,CHG_USER,CHG_TERM) ");
				builder.append("VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
				pstmt = conn.prepareStatement(builder.toString());

				pstmt.setString(1, tranId);
				pstmt.setTimestamp(2, valueOfCurrDate);
				pstmt.setString(3, posCode);
				pstmt.setString(4, poolCode);
				pstmt.setString(5, scCode);
				pstmt.setString(6, itemCode);
				pstmt.setString(7, prdCode);
				if( isFromPlanning )
				{
					pstmt.setInt(8, sellOutQty);
					pstmt.setInt(9, 0);
					pstmt.setInt(10, sellOutVal);
					pstmt.setInt(11, 0);
				}
				else
				{
					pstmt.setInt(8, 0);
					pstmt.setInt(9, sellOutQty);
					pstmt.setInt(10, 0);
					pstmt.setInt(11, sellOutVal);
				}
				pstmt.setTimestamp(12, valueOfCurrDate);
				pstmt.setString(13, empCode);
				pstmt.setString(14, remoteHost);

				int updateCnt = pstmt.executeUpdate();
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :: insertPoolSellOut : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
	}

	private boolean isPoolSellOutExist( String itemCode, String posCode, String scCode, String prdCode, String poolCode, Connection conn ) throws ITMException
	{
		StringBuilder builder = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int count = 0;
		Timestamp valueOfCurrDate;
		Date currDate = new Date();
		try
		{
			String seqQuery = "SELECT COUNT(*) AS COUNT FROM POOL_SELL_OUT WHERE POOL_CODE = ? AND PRD_CODE = ? AND ITEM_CODE = ? AND SC_CODE = ? ";
			pstmt = conn.prepareStatement( seqQuery );
			pstmt.setString(1, poolCode);
			pstmt.setString(2, prdCode);
			pstmt.setString(3, itemCode);
			pstmt.setString(4, scCode);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				count = rs.getInt("COUNT");
			}
			if( count > 0 )
			{
				return true;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :: isPoolSellOutExist : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return false;
	}

	//Added by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020 START
	private String getPRPDetails( Connection con, String posCode, String scCode )
	{
		System.out.println( "SellsStock.getPRPDetails() :: posCode : ["+ posCode +"], scCode : ["+ scCode +"]" );
		String protectValue = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		try
		{
			String prpSql = "SELECT POS_CODE FROM ORG_STRUCTURE_CUST WHERE POS_CODE = ? AND CUST_CODE = ?";
			pStmt = con.prepareStatement( prpSql );
			pStmt.setString(1, posCode);
			pStmt.setString(2, scCode);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				protectValue = "0";
			}
			else
			{
				protectValue = "1";
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.Exception()"+e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("SellsStock.Exc()"+e);
			}
		}
		if( protectValue.equalsIgnoreCase("") || protectValue == null )
		{
			protectValue = "0";
		}
		System.out.println("return.protectValue = "+protectValue);
		return protectValue;
	}

	private HashMap<String, String> getPRPDealerMap( Connection con, String posCode, HashMap<String, String> scCodeNameMap )
	{
		System.out.println( "SellsStock.getPRPDealerMap() :: posCode : ["+ posCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		HashMap<String, String> scCodeNamePRPMap = new LinkedHashMap<String,String>();
		try
		{
			String custType = getCustType(con);
			String scCode = "", scCodeName = "";
			String prpSql = "SELECT CUST.SC_CODE, DDF_GET_SC_CODE_NAME( CUST.SC_CODE ) DEALER_NAME " +
					" FROM ORG_STRUCTURE_CUST ORG_CUST, STRG_CUSTOMER CUST " +
					" WHERE ORG_CUST.CUST_CODE = CUST.SC_CODE " +
					" AND CUST.CUST_TYPE = ? " +
					" AND POS_CODE = ? ";
			pStmt = con.prepareStatement( prpSql );
			pStmt.setString(1, custType);
			pStmt.setString(2, posCode);
			rs = pStmt.executeQuery();
			while( rs.next() )
			{
				scCode = checkNull(rs.getString("SC_CODE")).trim();
				scCodeName = checkNull(rs.getString("DEALER_NAME")).trim();
				System.out.println( "scCode ["+ scCode +"], scCodeName ["+ scCodeName +"]" );

				if ( scCodeNameMap.containsKey( scCode ) )
				{
					scCodeNamePRPMap.put( scCode, scCodeName );
				}
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.Exception()"+e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("SellsStock.Exc()"+e);
			}
		}
		System.out.println( "scCodeNamePRPMap ["+ scCodeNamePRPMap +"]" );
		return scCodeNamePRPMap;
	}
	//Added by Amey W. [Only PRP should get access to all the SKUs mapped for the dealer] on 21-04-2020 END

	private HashMap<String, String> getProductColour( String itemCodes, Connection conn )
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String productColour = "";
		HashMap<String, String> productClrMap = new HashMap<String, String>();
		ArrayList<String>productCodes = new ArrayList<>();
		try
		{
			System.out.println("getProductColour"+itemCodes);
			String sql ="SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT ='PRODUCT_COLOR' AND PARM_NAME = 'PRODUCT_COLOR'";
			pStmt = conn.prepareStatement( sql );
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				productColour = rs.getString("PARM_VALUE");
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			List<String> productColourArr = Arrays.asList( productColour.split(",") );

			System.out.println("productColourArr "+productColourArr );

			sql ="SELECT PRODUCT.PRODUCT_CODE AS PRODUCT_CODE "
					+ "FROM ITEM ITEM, PRODUCT PRODUCT "
					+ "WHERE PRODUCT.PRODUCT_CODE = ITEM.PRODUCT_CODE "
					+ "AND ITEM.ITEM_CODE IN (" + itemCodes + ") "
					+ "ORDER BY PRODUCT.SORT_ORDER, ITEM.DESCR";
			pStmt = conn.prepareStatement( sql );
			rs = pStmt.executeQuery();
			while( rs.next() )
			{
				if( ! productCodes.contains( rs.getString("PRODUCT_CODE") ) )
				{
					productCodes.add(rs.getString("PRODUCT_CODE"));
				}
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			System.out.println( "productCodes :: ["+ productCodes +"]" );

			int count = 0;
			int countSet = 0;
			for( int productCtr = 0; productCtr < productCodes.size(); productCtr++ )
			{
				System.out.println( "productCodes : ["+ productCodes.get(productCtr) +"], productCodes : ["+ productColourArr.get(count) +"]" );

				productClrMap.put( productCodes.get(productCtr), productColourArr.get(count) );

				countSet = count + 1;
				System.out.println( "countSet : ["+countSet +"], productCodes ["+productColourArr.size() +"]" );
				if ( countSet == productColourArr.size() )
				{
					count = 0;
				}
				else
				{
					count++;
				}
			}
			System.out.println( "productClrMap ["+ productClrMap +"]" );
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.Exception()"+e);
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("SellsStock.Exc()"+e);
			}
		}
		return productClrMap;
	}

	private boolean isPlanningMgr( String posCode, Connection con )
	{
		System.out.println( "SellsStock.isPlanningMgr :: posCode : ["+ posCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		boolean isMgr = false;
		try
		{
			String mgrSql = "SELECT FN_GET_IS_PLANNING_MGR('"+posCode.replace("','", ",")+"') AS IS_MGR FROM DUAL";
			pStmt = con.prepareStatement( mgrSql );
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				String isMgrStr = rs.getString( 1 );
				if ( "true".equalsIgnoreCase( isMgrStr ) )
				{
					isMgr = true;
				}
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :: isPlanningMgr : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "isMgr ["+ isMgr +"]" );
		return isMgr;
	}

	/*private boolean isPlanningAllow( String posCode, Connection con )
	{
		System.out.println( "SellsStock.isPlanningAllow :: posCode : ["+ posCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		boolean isPlanningAllow = false;
		try
		{
			String mgrSql = "SELECT COUNT(*) FROM ORG_STRUCTURE ORG, EMPLOYEE E, SFAPARM S " +
				" WHERE E.EMP_CODE = ORG.EMP_CODE " +
				" AND S.PARM_NAME = 'IS_PLANNING_ALLOW' " +
				" AND S.ORG_UNIT = 'DESIGN_CODE' " +
				" AND S.PARM_VALUE LIKE ('%'|| TRIM(E.DESIGN_CODE) || '%') " +
				" AND ORG.POS_CODE IN ( '"+ posCode +"' ) ";
			pStmt = con.prepareStatement( mgrSql );
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				if ( rs.getInt( 1 ) > 0 )
				{
					isPlanningAllow = true;
				}
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: isPlanningAllow : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "isPlanningAllow ["+ isPlanningAllow +"]" );
		return isPlanningAllow;
	}*/

	private boolean isPrvAllMonthsSellInOutExist( String posCode, String stanCode, String prdCode, Connection conn )
	{
		System.out.println( "SellsStock.isPrvAllMonthsSellInOutExist() :: posCode : ["+ posCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		boolean isPrvAllMonthsSellInOutExist = true;
		try
		{
			StringBuilder stockSellSql = new StringBuilder(" SELECT PRD.CODE, ( SELECT COUNT(1) FROM STK_SELL_IN_OUT IN_OUT WHERE IN_OUT.PRD_CODE = PRD.CODE AND IN_OUT.STAN_CODE = ? AND IN_OUT.POS_CODE = ? AND IN_OUT.STATUS = 'A' ) IN_OUT_CNT ");
			stockSellSql.append(" FROM PERIOD PRD ");
			stockSellSql.append(" WHERE PRD.CODE IN ( SELECT CODE FROM PERIOD WHERE ACCT_PRD IN ( SELECT ACCT_PRD FROM PERIOD WHERE CODE = ? ) AND CODE < ? ) ");
			stockSellSql.append(" ORDER by PRD.CODE ");
			pStmt = conn.prepareStatement( stockSellSql.toString() );
			pStmt.setString(1, stanCode);
			pStmt.setString(2, posCode);
			pStmt.setString(3, prdCode);
			pStmt.setString(4, prdCode);
			rs = pStmt.executeQuery();
			while( rs.next() )
			{
				if ( rs.getInt( "IN_OUT_CNT" ) == 0 )
				{
					isPrvAllMonthsSellInOutExist = false;
				}
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: isPrvMonthSellInOutExist : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "isPrvAllMonthsSellInOutExist ["+ isPrvAllMonthsSellInOutExist +"]" );
		return isPrvAllMonthsSellInOutExist;
	}

	private boolean isVacantPos( String posCode, Connection con )
	{
		System.out.println( "SellsStock.isVacantPos :: posCode : ["+ posCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		boolean isVacantPos = false;
		try
		{
            //Commented and changes by pramod s for chnages status condition of employee master on 18-05-2022
			String mgrSql = "SELECT COUNT(1) " +
					" FROM ORG_STRUCTURE ORG, EMPLOYEE E " +
					" WHERE E.EMP_CODE = ORG.EMP_CODE " +
                    //" AND E.STATUS = 'N' " +
                    " AND E.STATUS = 'S' " +
					" AND ORG.POS_CODE IN ( '"+ posCode +"' ) ";
			pStmt = con.prepareStatement( mgrSql );
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				if ( rs.getInt( 1 ) > 0 )
				{
					isVacantPos = true;
				}
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: isVacantPos : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "isVacantPos ["+ isVacantPos +"]" );
		return isVacantPos;
	}

	private boolean isPlanningApprover( String posCode, Connection conn )
	{
		System.out.println( "SellsStock.isApprover :: posCode : ["+ posCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		boolean isApprover = false;
		try
		{
			String sql = "SELECT COUNT(*) AS COUNT "
					+ " FROM ORG_STRUCTURE ORG LEFT OUTER JOIN EMPLOYEE E "
					+ " ON E.EMP_CODE = ORG.EMP_CODE LEFT OUTER JOIN SFAPARM S ON S.ORG_UNIT = 'DESIGN_CODE' AND S.PARM_NAME = 'PLAN_APPROVER_DESIGN_CODE' "
					+ " WHERE ORG.POS_CODE IN ( '"+ posCode +"' ) "
					+ " AND S.PARM_VALUE LIKE ('%'|| TRIM(E.DESIGN_CODE) || '%') ";
			pStmt = conn.prepareStatement(sql);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				if( rs.getInt("COUNT") > 0)
				{
					isApprover =true;
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :: isPlanningApprover : ["+ e.getMessage() +"]" );
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "isApprover ["+ isApprover +"]" );
		return isApprover;
	}

	/*private String getPosCode( String empCode, Connection conn )
	{
		System.out.println( "SellsStock.getPosCode :: empCode : ["+ empCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String posCode = "";
		try
		{
			String strSql = "SELECT LISTAGG(POS_CODE, ',') WITHIN GROUP (ORDER BY POS_CODE) AS POS_CODE FROM ORG_STRUCTURE WHERE EMP_CODE = ? ";
			pStmt = conn.prepareStatement(strSql);
			pStmt.setString(1, empCode);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				posCode = rs.getString("POS_CODE");
			}
			if ( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: getPosCode : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "posCode ["+ posCode +"]" );
		return posCode;
	}*/

	private String getPosCodeDescr( String empCode, Connection conn )
	{
		System.out.println( "SellsStock.getPosCode :: empCode : ["+ empCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String posCode = "";
		try
		{
			String sql = "SELECT FN_GET_TERRITORY( ?, ? ) AS POS_CODE_DESCR FROM DUAL";
			pStmt = conn.prepareStatement( sql );
			pStmt.setString( 1, empCode );
			pStmt.setString( 2, empCode );
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				posCode = rs.getString( "POS_CODE_DESCR" );
			}
			if ( pStmt != null )
			{
				pStmt.close();
				pStmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: getPosCode : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "posCode ["+ posCode +"]" );
		return posCode;
	}

	private String getEmailId( String empCodes, Connection conn )
	{
		System.out.println( "SellsStock.getEmailId :: empCodes : ["+ empCodes +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String emailIds = "";
		try
		{
			String sql = "SELECT LISTAGG(EMAIL_ID_OFF, ',') WITHIN GROUP (ORDER BY EMAIL_ID_OFF) AS EMAIL_ID "
					+ " FROM EMPLOYEE WHERE EMP_CODE IN ( '"+ empCodes +"' )";
			pStmt = conn.prepareStatement(sql);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				emailIds = rs.getString("EMAIL_ID");
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: getEmailId : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "emailIds ["+ emailIds +"]" );
		return emailIds;
	}

	private String getEntityCodes( String empCodes, Connection conn )
	{
		System.out.println( "SellsStock.getEntityCodes :: empCodes : ["+ empCodes +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String entityCodes = "";
		try
		{
			String sql = "SELECT LISTAGG(ENTITY_CODE, ',') WITHIN GROUP (ORDER BY ENTITY_CODE) AS ENTITY_CODE "
					+ " FROM USERS WHERE EMP_CODE in ('"+ empCodes +"')";
			pStmt = conn.prepareStatement(sql);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				entityCodes = rs.getString("ENTITY_CODE");
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: getEntityCodes : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "entityCodes ["+ entityCodes +"]" );
		return entityCodes;
	}

	private void sendNotification( final String allData, final String prdCode, final String tranId, final String reportToCodes, final String action, final UserInfoBean userInfo )
	{
		try
		{
			new Thread("Sending_Notification")
			{
				Connection connRef = null;
				public void run()
				{
					try
					{
						ConnDriver connDriver = new ConnDriver();
						connRef = connDriver.getConnectDB( userInfo.getTransDB() );
						sendNotification( allData, prdCode, tranId, reportToCodes, action, userInfo, connRef );
						if(connRef != null)
						{
							connRef.close();
							connRef = null;
						}
					}
					catch (Exception e)
					{
						System.out.println( "Exception :: sendNotification : inside thread : ["+ e.getMessage() +"]" );
			        	e.printStackTrace();
			        }
					finally
					{
						try
						{
							if( connRef != null )
							{
								connRef.close();
								connRef = null;
							}
						}
						catch (Exception e)
						{
							e.printStackTrace();
						}
					}
				}
			}.start();
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: sendNotification : thread : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}

	private void sendNotification( String allData, String prdCode, String tranId, String mailToEmpCodes, String action, UserInfoBean userInfo, Connection conn )
	{
		try
		{
			System.out.println( "action ["+ action +"]" );
			String reportTo = "", emailId = "", objName = "sell_planning", refSer = "SELL-P", entityCode = "";
			String subject = "";
			String bodyText = "";
			String posCodeDescr = "";
			String salesPers = "";
			String spName = "";
			String levelNoStr = "";
			int levelNo = 0;
			JSONObject posDetailJson = null;

			String loginEmpCode = userInfo.getEmpCode();
			System.out.println( "loginEmpCode ["+ loginEmpCode +"]" );

			JSONObject json = new JSONObject(allData);
			JSONObject headerJson = (JSONObject)json.get("headerFormData");
			System.out.println( "headerJson ["+ headerJson +"]" );

			String posCode = "";
			if ( headerJson.has("pos_code") )
			{
				posCode = checkNull( headerJson.getString("pos_code") );
			}
			System.out.println( "posCode ["+ posCode +"]" );
			if( "sendBack".equalsIgnoreCase( action ) )
			{
				posDetailJson = getPosDetails( null, loginEmpCode, conn );

				posCodeDescr = checkNull( posDetailJson.getString("POS_CODE_DESCR") );
				spName = checkNull( posDetailJson.getString("SP_NAME") );

				if ( posCodeDescr.length() > 0 )
				{
					posCodeDescr = " (" + posCodeDescr + ")";
				}
				subject = "Your Sales Plan is Sent back by "+ spName + posCodeDescr;
				bodyText = "Your Sales Plan is Sent back by "+ spName + posCodeDescr +" for the month of "+ prdCode +".";
			}
			else
			{
				posDetailJson = getPosDetails( posCode, null, conn );

				posCodeDescr = checkNull( posDetailJson.getString("POS_CODE_DESCR") );
				salesPers = checkNull( posDetailJson.getString("EMP_CODE") );
				spName = checkNull( posDetailJson.getString("SP_NAME") );
				levelNoStr = checkNull( posDetailJson.getString("LEVEL_NO") );
				if ( levelNoStr.length() > 0 )
				{
					levelNo = Integer.parseInt( levelNoStr );
				}

				if ( posCodeDescr.length() > 0 )
				{
					posCodeDescr = " (" + posCodeDescr + ")";
				}
				//Added by Amey W. [On submission of Sell In-Out by salesperson notify to Manager] on 01-07-2020 START
				if( "sellInOut".equalsIgnoreCase( action ) )
				{
					subject = "Sell In and Sell Out is entered by "+ spName + posCodeDescr;
					bodyText = "Sell In and Sell Out is entered by "+ spName + posCodeDescr +" for the " +prdCode + " period";
				}//Added by Amey W. [On submission of Sell In-Out by salesperson notify to Manager] on 01-07-2020 END
				else
				{
				subject = "Sales Plan is Submitted by "+ spName + posCodeDescr;
				bodyText = "Sales Plan is Submitted by "+ spName + posCodeDescr +" for the month of " +prdCode + ".";
				}
				System.out.println( "subject : ["+ subject +"]" );
				System.out.println( "bodyText : ["+ bodyText +"]" );
				mailToEmpCodes = sendingMailList( salesPers, levelNo, conn );
				System.out.println( "mailToEmpCodes : ["+ mailToEmpCodes +"]" );
				mailToEmpCodes = mailToEmpCodes.replace( ",", "','" );
			}
			mailToEmpCodes = checkNull( mailToEmpCodes );

			emailId = checkNull( getEmailId( mailToEmpCodes, conn ) );
			System.out.println( "emailId : ["+ emailId +"]" );

			entityCode = checkNull( getEntityCodes( mailToEmpCodes, conn ) );
			System.out.println( "entityCode : ["+ entityCode +"]" );

			sendEmailAndNotification( subject, bodyText, objName, tranId, refSer, loginEmpCode, entityCode, emailId, userInfo, conn );

			if( "approve".equalsIgnoreCase( action ) )
			{
				subject = "Your Sales Plan is Approved by "+ spName + posCodeDescr;
				bodyText = "Your Sales Plan is Approved by "+ spName + posCodeDescr +" for the month of " +prdCode + ".";

				String mailToEmpCodesGSM = sendingMailListForGSM( loginEmpCode, conn );
				mailToEmpCodes = mailToEmpCodesGSM.replace( ",", "','" );
				System.out.println( "mailToEmpCodes : ["+ mailToEmpCodes +"]" );

				emailId = checkNull( getEmailId( mailToEmpCodes, conn ) );
				System.out.println( "emailId : ["+ emailId +"]" );

				entityCode = checkNull( getEntityCodes( mailToEmpCodes, conn ) );
				System.out.println( "entityCode : ["+ entityCode +"]" );

				sendEmailAndNotification( subject, bodyText, objName, tranId, refSer, loginEmpCode, entityCode, emailId, userInfo, conn );
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :: sendNotification : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}

	private String sendingMailListForGSM( String empCode, Connection conn )
	{
		System.out.println( "SellsStock.sendingMailListForGSM :: empCode : ["+ empCode +"]" );
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String reportingEmp = "";
		try
		{
            //Commented and changes by pramod s for chnages status condition of employee master on 18-05-2022
			StringBuilder sql = new StringBuilder();
			sql.append( "SELECT LISTAGG(TRIM(O1.EMP_CODE), ',') WITHIN GROUP (ORDER BY O1.EMP_CODE) AS EMP_CODE " )
			.append( " FROM ORG_STRUCTURE O1, EMPLOYEE E LEFT OUTER JOIN SFAPARM PARM ON PARM.PARM_NAME = 'PLANNING_NOT_ALLOW' AND PARM.ORG_UNIT = 'DESIGN_CODE' " )
			.append( " WHERE E.EMP_CODE = O1.EMP_CODE " )
			.append( " AND PARM.PARM_VALUE NOT LIKE ('%'|| TRIM(E.DESIGN_CODE) || '%') " )
			.append( " AND O1.EMP_CODE <> ? " )
            //.append( " AND E.STATUS <> 'N' " )
            .append( " AND E.STATUS <> 'S' " )
			.append( " START WITH O1.EMP_CODE = ? CONNECT BY PRIOR O1.POS_CODE = O1.POS_CODE__REPTO " );
			pstmt = conn.prepareStatement( sql.toString() );
			pstmt.setString( 1, empCode );
			pstmt.setString( 2, empCode );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				reportingEmp = rs.getString("EMP_CODE");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch( Exception e )
		{
			System.out.println( "Exception :: sendingMailListForGsm : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "reportingEmp ["+ reportingEmp +"]" );
		return reportingEmp;
	}

	private void sendEmailAndNotification( String subject, String bodyText, String objName, String tranId, String refSer, String loginEmpCode, String entityCode, String emailId, UserInfoBean userInfo, Connection conn ) throws Exception
	{
		try
		{
			StringBuffer mailDomStr = new StringBuffer();
			mailDomStr.append( "<ROOT>" );
			mailDomStr.append( "<TRANS_INFO>" );
			mailDomStr.append( "<OBJ_NAME>" ).append( objName ).append( "</OBJ_NAME>" );
			mailDomStr.append( "<REF_SER>" ).append( refSer ).append( "</REF_SER>" );
			mailDomStr.append( "<REF_ID>" ).append( tranId ).append( "</REF_ID>" );
			mailDomStr.append( "<LINE_NO>" ).append( "1" ).append( "</LINE_NO>" );
			mailDomStr.append( "<XSL_FILE_NAME></XSL_FILE_NAME>" );
			mailDomStr.append( "</TRANS_INFO>" );
			mailDomStr.append( "<MAIL>" );
			mailDomStr.append( "<EMAIL_TYPE>page</EMAIL_TYPE>" );
			mailDomStr.append( "<ENTITY_CODE>" ).append( entityCode ).append( "</ENTITY_CODE>" ); //TO DO
			mailDomStr.append( "<ENTITY_TYPE>" ).append( "E" ).append( "</ENTITY_TYPE>" );
			mailDomStr.append( "<SUBJECT>" ).append( subject ).append( "</SUBJECT>" );
			mailDomStr.append( "<BODY_TEXT>" ).append( bodyText ).append( "</BODY_TEXT>" );
			mailDomStr.append( "<TO_ADD>" ).append( emailId ).append( "</TO_ADD>" );
			mailDomStr.append( "<CC_ADD></CC_ADD>" );
			mailDomStr.append( "<FORMAT_CODE></FORMAT_CODE>" );
			mailDomStr.append( "<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>" );
			mailDomStr.append( "</MAIL>" );
			mailDomStr.append( "<XML_DATA></XML_DATA>" );
			mailDomStr.append( "</ROOT>" );

			EMail email = new EMail();
			email.sendMail( mailDomStr.toString(), "ITM", conn );

			String[] entityCodeArr = entityCode.split(",");
			List<String> entityCodeList = Arrays.asList( entityCodeArr );
			ArrayList<String> userIdList = new ArrayList<String>(entityCodeList);
			System.out.println( "userIdList : ["+ userIdList +"]" );

			PublishPushNotificationEJB publishPushNotificationEJB = new PublishPushNotificationEJB();
			publishPushNotificationEJB.invockPushNotification(bodyText, "", PublishPushNotificationRemote.OPEN_TARGET_TRANSACTION, tranId, userIdList , "", tranId, refSer, loginEmpCode, 0, userInfo );
		}
		catch (RemoteException e)
		{
			System.out.println( "RemoteException :: sendNotification : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (ITMException e)
		{
			System.out.println( "ITMException :: sendNotification : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: sendNotification : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}

	private JSONObject getPosDetails( String posCode, String empCode, Connection conn )
	{
		System.out.println( "SellsStock.getPositionDetails :: posCode : ["+ posCode +"], empCode : ["+ empCode +"]" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		JSONObject posDetailJson = new JSONObject();
		try
		{
			StringBuilder sql = new StringBuilder();
			sql.append( " SELECT ORG_DET.*, FN_GET_IS_PLANNING_MGR( ORG_DET.POS_CODE ) AS IS_MGR FROM ( " );
			sql.append( " SELECT O1.EMP_CODE, SP.SP_NAME, " );
			sql.append( " LISTAGG(O1.POS_CODE, ',') WITHIN GROUP (ORDER BY O1.LEVEL_NO) AS POS_CODE, " );
			sql.append( " LISTAGG(O1.STAN_CODE__HQ, ',') WITHIN GROUP (ORDER BY O1.LEVEL_NO) AS STAN_CODE, " );
			sql.append( " FN_GET_TERRITORY(O1.EMP_CODE, O1.EMP_CODE) AS POS_CODE_DESCR, O1.LEVEL_NO " );
			sql.append( " FROM ORG_STRUCTURE O1, SALES_PERS SP " );
			sql.append( " WHERE O1.EMP_CODE = SP.EMP_CODE " );
			if ( posCode != null && posCode.length() > 0 )
			{
				sql.append( " AND O1.POS_CODE IN ('"+ posCode +"') " );
			}
			else
			{
				sql.append( " AND O1.EMP_CODE IN ('"+ empCode +"') " );
			}
			sql.append( " GROUP BY O1.EMP_CODE, O1.LEVEL_NO, SP.SP_NAME ) ORG_DET " );

			pStmt = conn.prepareStatement( sql.toString() );
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				posDetailJson.put( "EMP_CODE", checkNull( rs.getString( "EMP_CODE" ) ) );
				posDetailJson.put( "SP_NAME", checkNull( rs.getString( "SP_NAME" ) ) );
				posDetailJson.put( "POS_CODE", checkNull( rs.getString( "POS_CODE" ) ) );
				posDetailJson.put( "STAN_CODE", checkNull( rs.getString( "STAN_CODE" ) ) );
				posDetailJson.put( "POS_CODE_DESCR", checkNull( rs.getString( "POS_CODE_DESCR" ) ) );
				posDetailJson.put( "LEVEL_NO", checkNull( rs.getString( "LEVEL_NO" ) ) );
				posDetailJson.put( "IS_MGR", Boolean.parseBoolean( checkNull( rs.getString("IS_MGR") ).toLowerCase() ) );
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: getPositionDetails : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "posDetailJson ["+ posDetailJson +"]" );
		return posDetailJson;
	}

	private String getCustType( Connection conn )
	{
		System.out.println( "SellsStock.getCustType" );
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String custType = "";
		try
		{
			String sql = "SELECT PARM_VALUE FROM SFAPARM WHERE ORG_UNIT = 'CUST_TYPE' AND PARM_NAME = 'PLANNING_CUST_TYPE'";
			pStmt = conn.prepareStatement(sql);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				custType = rs.getString("PARM_VALUE");
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception e)
		{
			System.out.println( "Exception :: getCustType : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println( "getCustType ["+ custType +"]" );
		return custType;
	}
	
	public HashMap<String, HashMap<String, HashMap<String,String>>> getMissingSellInOutNotificationDetails( Connection conn, UserInfoBean userInfo )
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean localConn = false;
		
		HashMap<String, HashMap<String, HashMap<String,String>>> sellInOutNotificationDetailMap = new HashMap<String, HashMap<String, HashMap<String,String>>>();
		try 
		{
			ArrayList<String> salesPersonEmailIdList = new ArrayList<String>();
			
			HashMap<String, HashMap<String,String>> reportToSPEmailIdMap = new HashMap<String, HashMap<String,String>>();
			HashMap<String, HashMap<String,String>> reportToRSMEmailIdMap = new HashMap<String, HashMap<String,String>>();
			HashMap<String, HashMap<String,String>> spEmailIdMap = new HashMap<String, HashMap<String,String>>();
			
			HashMap<String, String> salesPersonEmailIdMap = new HashMap<String, String>();
			
			ConnDriver connDriver = new ConnDriver();
			String transDB = checkNull( userInfo.getTransDB() );
			if( transDB.length() > 0 && conn == null )
			{
				conn = connDriver.getConnectDB( transDB );
				localConn = true;
			}
			connDriver = null;
			//Commented and changes by pramod s for chnages status condition of employee master on 18-05-2022
            String getSalesPersonEmailId = "SELECT (TRIM(SP.SP_NAME) || ' (' || O1.DESCR || ')' ) SP_NAME, O1.EMP_CODE, "
                    //+ " (CASE WHEN E1.STATUS = 'Y' THEN E1.EMAIL_ID_OFF ELSE '' END) EMAIL_ID, " 
					+ " (CASE WHEN E1.STATUS != 'S' THEN E1.EMAIL_ID_OFF ELSE '' END) EMAIL_ID, " 
					+ " (SELECT O2.EMP_CODE FROM ORG_STRUCTURE O2 WHERE O2.POS_CODE = O1.POS_CODE__REPTO) REPORT_TO, " 
                    + " (SELECT E2.EMAIL_ID_OFF FROM ORG_STRUCTURE O2, EMPLOYEE E2 WHERE O2.POS_CODE = O1.POS_CODE__REPTO "
                        //+ " AND O2.EMP_CODE = E2.EMP_CODE AND E2.STATUS = 'Y') REPORT_TO_EMAIL, " 
						+ " AND O2.EMP_CODE = E2.EMP_CODE AND E2.STATUS != 'S') REPORT_TO_EMAIL, " 
					+ " (SELECT O3.EMP_CODE FROM ORG_STRUCTURE O2, ORG_STRUCTURE O3 WHERE O2.POS_CODE = O1.POS_CODE__REPTO "
						+ " AND O2.POS_CODE__REPTO = O3.POS_CODE ) RSM,"  
                    + " (SELECT E3.EMAIL_ID_OFF FROM ORG_STRUCTURE O2, ORG_STRUCTURE O3, EMPLOYEE E3 WHERE O2.POS_CODE = O1.POS_CODE__REPTO AND O2.POS_CODE__REPTO = O3.POS_CODE "
                        //+ " AND O3.EMP_CODE = E3.EMP_CODE AND E3.STATUS = 'Y') RSM_EMAIL " 
                        + " AND O3.EMP_CODE = E3.EMP_CODE AND E3.STATUS != 'S') RSM_EMAIL " 
					+ " FROM EMPLOYEE E1, SALES_PERS SP, ORG_STRUCTURE O1 "
					+ " LEFT OUTER JOIN STK_SELL_IN_OUT IN_OUT ON IN_OUT.POS_CODE = O1.POS_CODE AND IN_OUT.STAN_CODE = O1.STAN_CODE__HQ "  
						+ " AND IN_OUT.TO_DATE BETWEEN ( TRUNC(sysdate, 'DAY') - 6 ) AND ( TRUNC( SYSDATE, 'DAY' ) - 1 ) " 
					+ " WHERE O1.EMP_CODE = E1.EMP_CODE " 
					+ " AND E1.EMP_CODE = SP.EMP_CODE "
					+ " AND IN_OUT.STATUS IS NULL "
					+ " AND FN_GET_IS_PLANNING_MGR( O1.POS_CODE ) = 'FALSE' "  
					+ " START WITH O1.EMP_CODE = '85041946' " 
					+ " CONNECT BY PRIOR O1.POS_CODE = O1.POS_CODE__REPTO "  
					+ " ORDER BY O1.LEVEL_NO DESC, O1.POS_CODE__REPTO ";
			
			System.out.println( "getSalesPersonEmailId : [" + getSalesPersonEmailId + "]" );
			pstmt = conn.prepareStatement( getSalesPersonEmailId );
			rs = pstmt.executeQuery();

			while ( rs.next() )
			{
				HashMap<String, String> salesPersonMap = new HashMap<String, String>();
				HashMap<String, String> rsmMap = new HashMap<String, String>();

				String empCode = checkNull( rs.getString( "EMP_CODE" ) );
				String spName = checkNull( rs.getString( "SP_NAME" ) );
				String spEmailId = checkNull( rs.getString( "EMAIL_ID" ) );
				String reportToMail = checkNull( rs.getString( "REPORT_TO_EMAIL" ) );
				String rsmCode = checkNull( rs.getString( "RSM" ) );
				String rsmMail = checkNull( rs.getString( "RSM_EMAIL" ) );

				salesPersonEmailIdList.add( spEmailId ); //sale_pers emailId

				salesPersonMap.put( empCode, spName );
				rsmMap.put( rsmMail, rsmCode );

				if( reportToMail.length() > 0 )
				{
					if( reportToSPEmailIdMap.containsKey( reportToMail ) )
					{
						salesPersonMap = reportToSPEmailIdMap.get( reportToMail );
						salesPersonMap.put( empCode, spName );
					}
					reportToSPEmailIdMap.put( reportToMail, salesPersonMap ); //reporting sales_pers emailId 

					if( reportToRSMEmailIdMap.containsKey( reportToMail ) )
					{
						rsmMap = reportToRSMEmailIdMap.get( reportToMail );
						rsmMap.put( rsmMail, rsmCode );
					}
					reportToRSMEmailIdMap.put( reportToMail, rsmMap ); //reporting RSM emailId
				}
				else if( rsmMail.length() > 0 )
				{
					if( reportToSPEmailIdMap.containsKey( rsmMail ) )
					{
						salesPersonMap = reportToSPEmailIdMap.get( rsmMail );
						salesPersonMap.put( empCode, spName );
					}
					reportToSPEmailIdMap.put( rsmMail, salesPersonMap ); //reporting sales_pers emailId
				}
			}
			salesPersonEmailIdMap.put( "EMAIL_ID", salesPersonEmailIdList.toString() );
			spEmailIdMap.put( "EMAIL_ID", salesPersonEmailIdMap );

			sellInOutNotificationDetailMap.put( "EMAIL_ID", spEmailIdMap );
			sellInOutNotificationDetailMap.put( "REPORT_TO", reportToSPEmailIdMap );
			sellInOutNotificationDetailMap.put( "RSM", reportToRSMEmailIdMap );
			
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if( localConn && conn != null )
			{
				conn.close();
				conn = null;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println( "Inside the getSalesPersonEmail Exception Catch Block : ["+ e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( localConn && conn != null )
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		return sellInOutNotificationDetailMap;
	}
}