/*
	Author: Deepak
	Date: 30-03-09
	Reason: To update data on post save
*/

package ibase.webitm.ejb.wsfa.masters;

import java.sql.*;
import java.rmi.RemoteException;
import java.util.*;
import org.w3c.dom.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;
import ibase.webitm.utility.*;
import ibase.utility.*;
import ibase.webitm.ejb.*;
import java.text.*;
//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].
public class WsfaEffCovgPos extends ValidatorEJB implements WsfaEffCovgPosRemote,WsfaEffCovgPosLocal//implements SessionBean
{/*
	public void ejbCreate() throws RemoteException, CreateException
	{
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate()
	{
	}
	public void ejbPassivate()
	{
	}*/
	public String postSave() throws RemoteException, ITMException
	{
		return "";
	}
	public String postSave(String winName, String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException, ITMException
	{
		System.out.println("WsfaEffCovgPosEJB Called............!");
		Document dom = null;
		String errMessage = "";
		try
		{
			if ( domString != null && domString.trim().length() > 0 )
			{
				//changed by Rahul Barve on 3-sep-2014
				//dom =   ibase.webitm.utility. GenericUtility.getInstance() .parseString(domString);
				dom = new ibase.utility.E12GenericUtility().parseString(domString);
				errMessage = postSave(winName, editFlag, xtraParams, conn, dom);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :WsfaEffCovgPosEJB :postSave(): " + e.getMessage()+ ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errMessage;
	}
	private String postSave(String winName, String editFlag, String xtraParams, Connection conn, Document dom) throws RemoteException, ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String sql = "";
		String errorMsg = "";
		String custType  =	checkNull( genericUtility.getColumnValue("cust_type", dom) );
		String classCode  =	checkNull( genericUtility.getColumnValue("class_code", dom) );
		String salesPdGrp =	checkNull( genericUtility.getColumnValue("sales_prod_grp", dom) );
		String splCode  =	checkNull( genericUtility.getColumnValue("spl_code", dom) );
		String effFrom  =	checkNull( genericUtility.getColumnValue("eff_from", dom) );
		String validUpto  =	checkNull( genericUtility.getColumnValue("valid_upto", dom) );
		try
		{
			sql="SELECT EFF_FROM, VALID_UPTO FROM EFF_COVG WHERE SALES_PROD_GRP= ? AND CUST_TYPE= ? AND CLASS_CODE= ? AND SPL_CODE= ? AND  ( ? BETWEEN EFF_FROM AND VALID_UPTO)" ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPdGrp);
			pstmt.setString(2, custType);
			pstmt.setString(3, classCode);
			pstmt.setString(4, splCode);
			pstmt.setTimestamp(5, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( effFrom, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				java.util.Calendar calendar = java.util.Calendar.getInstance();
				java.text.SimpleDateFormat sdtf = new java.text.SimpleDateFormat( genericUtility.getApplDateFormat() );
				java.util.Date effectiveFrom = sdtf.parse( effFrom );
				calendar.setTime( effectiveFrom );
				calendar.add( calendar.DATE, -1 );
				java.text.SimpleDateFormat  sdf =  new java.text.SimpleDateFormat( genericUtility.getDBDateFormat() );
				java.sql.Date effectFrom = java.sql.Date.valueOf( sdf.format( calendar.getTime() ) );
				sql = "UPDATE EFF_COVG SET VALID_UPTO = ? WHERE SALES_PROD_GRP= ? AND CUST_TYPE= ? AND CLASS_CODE= ? AND SPL_CODE= ? AND  ( ? BETWEEN EFF_FROM AND VALID_UPTO)  " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setDate(1, effectFrom);
				pstmt.setString(2, salesPdGrp);
				pstmt.setString(3, custType);
				pstmt.setString(4, classCode);
				pstmt.setString(5, splCode);
				pstmt.setDate(6, effectFrom);
				pstmt.executeUpdate();
			}
		}
		catch(Exception e)
	   {
			e.printStackTrace();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				pstmt.close();
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return errorMsg;
	}
	private String checkNull( String input )
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}
}