package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class DaySummary extends ValidatorEJB
{
	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("....wfValData method called from externalFactor....");
		System.out.println("xmlString : "+xmlString);
		System.out.println("xmlString1 : "+xmlString1);
		System.out.println("xmlString2 : "+xmlString2);
		System.out.println("editFlag : "+editFlag);
		System.out.println("xtraParams : "+xtraParams);
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = genericUtility.parseString(xmlString);
			dom1 = genericUtility.parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = genericUtility.parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("errString : "+errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[wfValData()] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}

		return errString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String errString = "" , errCode = "";
		String userId = "";
		String objName = "";
		String errorType = "";
		String columnValue ="";
		String totalBusiness = "";
		String businessToUS = "";
		Connection conn = null;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		int parentNodeListLength = 0;
		int ctr = 0 , cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
        StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
        String description = "", salesPers = "", itemSer = "", custType = "", firstNae = "", middleName = "", lastName = "", classCode = "", classCodeDescr = "",
                itemCode = "", itemCodeDescr = "", productCode = "", productDescr = "",
                brandCode = "", brandDescr = "", minQty = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
		try
		{
			System.out.println("Inside try of wfValData : "+genericUtility.serializeDom(dom));
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			objName = checkNullAndTrim(getObjNameFromDom(dom, "objName", objContext ));
			System.out.println("objName: "+objName);
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("currentFormNo: "+currentFormNo);
			switch(currentFormNo)
			{
			case 1: 
				parentNodeList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentNodeList.getLength();
				System.out.println("parentNodeListLength: "+parentNodeListLength);
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					System.out.println("childNodeListLength: "+childNodeListLength);
					for(ctr = 0; ctr < childNodeListLength; ctr ++)
					{
						columnValue ="";
						childNode = childNodeList.item(ctr);
						System.out.println("childNode: "+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
                        System.out.println("columnValue: "+columnValue);
                        
						childNodeName = childNode.getNodeName();
						System.out.println("childNodeName: "+childNodeName);
						if(childNodeName.equalsIgnoreCase("sales_pers"))
						{
                            System.out.println("childNodeName: "+childNodeName);
                            
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("sales_pers cannot be null");
								errString = itmDBAccessEJB.getErrorString("sales_pers","SPNULL",userId,"",conn);

								break;
                            }
                            else
                            {
                                int count = 0;
                                String salesPerson = E12GenericUtility.checkNull(genericUtility.getColumnValue("sales_pers",dom));
                                String sql = "select count(sales_pers) as Count from sales_pers where sales_pers=? and active='Y'" ;
                                
                                pstmt =  conn.prepareStatement(sql);	
                                pstmt.setString(1, salesPerson);	
                                rs = pstmt.executeQuery();

                                if( rs.next() )
                                {
                                    count = rs.getInt("Count");
                                }
                                if(rs != null)
                                {
                                    rs.close();
                                    rs= null;
                                }
                                if(pstmt != null)
                                {
                                    pstmt.close();
                                    pstmt= null;
                                }
                                if("A".equalsIgnoreCase(editFlag))
                                {
                                    if(count==0)
                                    {
                                        errString = getErrorString( "sales_pers","SPINV",userId );
                                        break;
                                    }
                                }
                                
                               

                            }
						}
						if(childNodeName.equalsIgnoreCase("event_date"))
						{
                            System.out.println("childNodeName: "+childNodeName);
                            
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("route_id cannot be null");
								errString = itmDBAccessEJB.getErrorString("route_id","NULEDATE",userId,"",conn);

								break;
                            }
						}	
						if(childNodeName.equalsIgnoreCase("route_id"))
						{
                            System.out.println("childNodeName: "+childNodeName);
                            
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								System.out.println("route_id cannot be null");
								errString = itmDBAccessEJB.getErrorString("route_id","ROUTENULL",userId,"",conn);

								break;
                            }
                            else
                            {
                                int count = 0;
                                String salesPerson = E12GenericUtility.checkNull(genericUtility.getColumnValue("sales_pers",dom));
                                String routeId = E12GenericUtility.checkNull(genericUtility.getColumnValue("route_id",dom));
                                String loadNo = E12GenericUtility.checkNull(genericUtility.getColumnValue("load_no",dom));
                                String sql = "select count(route_id) AS COUNT from sprs_route where sprs_code=? AND route_id=? and status='Y'" ;          
                                pstmt =  conn.prepareStatement(sql);	
                                pstmt.setString(1, salesPerson);	
                                pstmt.setString(2, routeId);
                                rs = pstmt.executeQuery();

                                if( rs.next() )
                                {
                                    count = rs.getInt("Count");
                                }
                                if(rs != null)
                                {
                                    rs.close();
                                    rs= null;
                                }
                                if(pstmt != null)
                                {
                                    pstmt.close();
                                    pstmt= null;
                                }
                                if("A".equalsIgnoreCase(editFlag))
                                {
                                    if(count == 0)
                                    {
                                        errString = getErrorString( "route_id","ROUTEINV",userId );
                                        break;
                                    }
                                    else
                                    {
                                    	String eventDate = E12GenericUtility.checkNull(genericUtility.getColumnValue("event_date",dom));
                                    	String sql1 = "select count(*) as count from sprs_day_summ where sales_pers=? AND route_id=? AND event_date=? AND load_no=?" ;
                                        int count2=0;
                                        pstmt =  conn.prepareStatement(sql1);	
                                        pstmt.setString(1, salesPerson);	
                                        pstmt.setString(2, routeId);
                                        pstmt.setTimestamp(3,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
                                        pstmt.setString(4, loadNo);
                                        rs = pstmt.executeQuery();

                                        if( rs.next() )
                                        {
                                        	count2 = rs.getInt("count");
                                        }
                                        if(rs != null)
                                        {
                                            rs.close();
                                            rs= null;
                                        }
                                        if(pstmt != null)
                                        {
                                            pstmt.close();
                                            pstmt= null;
                                        }
                                        
                                        if(count2>0)
                                        {
                                        	errString = getErrorString( "route_id","DUPDSUM",userId );
                                            break;
                                        }
                                    }
                                }
                                
                               

                            }
						}
						
						

					}    
				}
				break;
			}
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return errString;
	}
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			System.out.println("Inside itemChanged of DaySummary.java : xmlString :"+xmlString);
			dom = genericUtility.parseString(xmlString);
			dom1 = genericUtility.parseString(xmlString1);
			dom2 = genericUtility.parseString(xmlString2);

			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :[itemChanged()] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("valueXmlString :" + valueXmlString);
		return valueXmlString;

	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		
		String currDate = "";
		String userId = "";
		String chgTerm = "";
		Connection conn = null;
        int currentFormNo = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;

        try
		{
			conn = getConnection();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("currDate:"+currDate);
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			System.out.println("userId:"+userId);
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"term_id");
			System.out.println("chgTerm:"+chgTerm);
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch ( currentFormNo )
			{
			case 1:
			{
				valueXmlString.append("<Detail1>");
				if(currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					valueXmlString.append( "<event_date><![CDATA[" ).append(currDate).append( "]]></event_date>\r\n" );
					valueXmlString.append("<invoice_sr_no protect=\"1\">").append("<![CDATA[]]>").append("</invoice_sr_no>\r\n");
                }
				if(currentColumn.trim().equalsIgnoreCase( "itm_defaultedit" ))
				{
                    String invoiceNo = E12GenericUtility.checkNull(genericUtility.getColumnValue("invoice_sr_no",dom));
                    String loadStatus = E12GenericUtility.checkNull(genericUtility.getColumnValue("load_status",dom));
					valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					valueXmlString.append("<invoice_sr_no protect=\"1\"><![CDATA[").append(invoiceNo).append("]]></invoice_sr_no>\r\n");
					
					//To only allow edit the loadStatus value if the load is open
					if(loadStatus.equalsIgnoreCase("Y"))
					{
						valueXmlString.append("<load_status protect = \"1\">").append("<![CDATA["+loadStatus+"]]>").append("</load_status>\r\n");
					}
					else
					{
						valueXmlString.append("<load_status protect = \"0\">").append("<![CDATA["+loadStatus+"]]>").append("</load_status>\r\n");
					}
					//To only allow edit the loadStatus value if the load is open

                }
                else if(currentColumn.trim().equalsIgnoreCase( "sales_pers" )) //industry_code
                {
                    String salesPers = E12GenericUtility.checkNull(genericUtility.getColumnValue("sales_pers",dom));
                    String spName="";
                    String sql = "select sp_name from sales_pers where sales_pers=?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, salesPers);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						spName = E12GenericUtility.checkNull(rs.getString("sp_name"));
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<sp_name protect='1'><![CDATA[").append(spName).append("]]></sp_name>\r\n");
                }
                else if(currentColumn.trim().equalsIgnoreCase( "route_id" )) //industry_code
                {
                    String salesPers = E12GenericUtility.checkNull(genericUtility.getColumnValue("sales_pers",dom));
                    String routeId = E12GenericUtility.checkNull(genericUtility.getColumnValue("route_id",dom));
                    String routeDescr="";
                    String sql = "SELECT DESCR FROM SPRS_ROUTE WHERE SPRS_CODE=? and Route_id=?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, salesPers);
                    pstmt.setString(2, routeId);
					rs = pstmt.executeQuery();
					if( rs.next())
					{
						routeDescr = E12GenericUtility.checkNull(rs.getString("DESCR"));
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
                    }
                    valueXmlString.append("<descr protect='1'><![CDATA[").append(routeDescr).append("]]></descr>\r\n");
                }
                
				valueXmlString.append("</Detail1>");	
			}
			break;
			}		
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		valueXmlString.append("</Root>");
		System.out.println("valueXmlString ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	
	
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}
	
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
	
	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	public String postSave(String xmlStringAll, String tranId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		String resString="",salesPerson="",evenDate="",routeId="",planDays="",NewplanDays="",invoiceSrNo="",finYear = "";
		Document dom=null;
		//boolean flag=true;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		Node currentDetail = null;
		try
		{
			System.out.println("xmlStringAll posave InventoryTransferWiz::"+xmlStringAll);
			dom = genericUtility.parseString(xmlStringAll);
			evenDate = checkNull(genericUtility.getColumnValue("event_date", dom, "1"));
			salesPerson = checkNull(genericUtility.getColumnValue("sales_pers", dom, "1"));
			routeId = checkNull(genericUtility.getColumnValue("route_id", dom, "1"));
			invoiceSrNo = checkNull(genericUtility.getColumnValue("invoice_sr_no", dom, "1"));
			
	//		System.out.println("salesPerson: "+salesPerson+" evenDate:"+evenDate+" routeId:"+routeId+" invoiceSrNo:"+invoiceSrNo);
			/*
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
			Date evDate = dbFormat.parse(evenDate);
			evenDate = dtFormat.format(evDate);
			System.out.println("evenDate:: "+evenDate);
			*/
			DateFormat dtAppFormat = new SimpleDateFormat(getApplDateFormat());
			Date parsedDate = dtAppFormat.parse(evenDate);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parsedDate);
			System.out.println("evenDate:: "+evenDate);
			String days[] = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
			String prefixes[] = new String[]{"1st", "2nd", "3rd", "4th", "5th"};
			String dayName = days[parsedDate.getDay()];
            String weekDayString = "";
			
            if(parsedDate.getDate() % 7 == 0)
			{
				weekDayString = prefixes[(int)Math.floor((parsedDate.getDate() / 7) - 1)] + ' ' + days[parsedDate.getDay()];
			}
			else
			{
				weekDayString = prefixes[(int)Math.floor(parsedDate.getDate() / 7)] + ' ' + days[parsedDate.getDay()];
			}
			System.out.println("weekDayString:: "+weekDayString);
			String invoiceNo = "";
			String eventDate = genericUtility.getValidDateTimeString(genericUtility.getColumnValue( "event_date", dom ), genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			
			//Start--InvoiceNo Changes
			String finYearSql = "SELECT SUBSTR(CODE,-3) AS FIN_YEAR FROM ACCTPRD WHERE SYSDATE BETWEEN FR_DATE AND TO_DATE";
			pstmt = conn.prepareStatement(finYearSql);
			rs= pstmt.executeQuery();
			if(rs.next())
			{
				finYear = rs.getString("FIN_YEAR");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("Financial Year is::"+finYear);
			
			invoiceSrNo = salesPerson + finYear;
			
			System.out.println("New Invoice serial number is::"+invoiceSrNo);
			
			//End--InvoiceNo Changes

			/*if(editFlag.equalsIgnoreCase("A"))
			{
				invoiceNo = getNextSequenceInvoice(conn);
			}
			else if(editFlag.equalsIgnoreCase("E"))
			{
				String sql = "SELECT INVOICE_SR_NO FROM SPRS_DAY_SUMM WHERE SALES_PERS = ? AND EVENT_DATE = ? AND ROUTE_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,salesPerson);
				pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventDate));
				pstmt.setString(3,routeId);
				rs= pstmt.executeQuery();
				if(rs.next())
				{
					invoiceNo = checkNull(rs.getString("INVOICE_SR_NO"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(invoiceNo.trim().length() == 0)
				{
					invoiceNo = getNextSequenceInvoice(conn);
				}
			}*/
			//System.out.println("salesPerson: "+salesPerson+" evenDate:"+eventDate+" routeId:"+routeId+" invoiceSrNo:"+invoiceNo);
			System.out.println("salesPerson: "+salesPerson+" evenDate:"+eventDate+" routeId:"+routeId+" invoiceSrNo:"+invoiceSrNo);

			
			String sql1 = "UPDATE SPRS_DAY_SUMM SET INVOICE_SR_NO = ? WHERE SALES_PERS = ? AND EVENT_DATE = ? AND ROUTE_ID = ?";
			pstmt = conn.prepareStatement(sql1);
			//pstmt.setString(1,invoiceNo);
			pstmt.setString(1,invoiceSrNo);
			pstmt.setString(2,salesPerson);
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(4,routeId);
			int countInv = pstmt.executeUpdate();
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("countInv:: "+countInv);
			/*
			String sql ="select Plan_days from sprs_route where sprs_code=? AND ROUTE_ID=?";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPerson);
			pstmt.setString(2,routeId);
			
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				planDays = checkNull(rs.getString("Plan_days"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("planDays:"+planDays);
			if(planDays.trim().length()==0 || planDays==null)
			{
				NewplanDays=weekDayString;
			}
			else
			{
				if(planDays.contains(weekDayString))
				{
					NewplanDays=planDays;
				}
				else
				{
					NewplanDays=weekDayString+","+planDays;
				}
			}	
			
			System.out.println("NewplanDays:: "+NewplanDays);
			*/
			String updPlanDaysNullSql="Update sprs_route set plan_days= null where  sprs_code=?  ";
			pstmt = conn.prepareStatement(updPlanDaysNullSql);
			pstmt.setString(1,salesPerson);
			int updCnt = pstmt.executeUpdate();
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("updCnt =["+updCnt+"]");
			
			String sql2="Update sprs_route set plan_days=?,invoice_sr_no=? where  sprs_code=? AND ROUTE_ID=? ";
			pstmt = conn.prepareStatement(sql2);
			pstmt.setString(1,weekDayString);
			//pstmt.setString(2,invoiceNo);
			pstmt.setString(2,invoiceSrNo);
			pstmt.setString(3,salesPerson);
			pstmt.setString(4,routeId);
			int count = pstmt.executeUpdate();
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("count:: "+count);
			
			//To update the data models as Dirty on new load creation. Gulzar on 10-May-2023
			String userCode = "";
			String userCodeSql = "SELECT CODE FROM USERS WHERE EMP_CODE = ?";
			
			pstmt = conn.prepareStatement(userCodeSql);
			pstmt.setString(1,salesPerson);
			
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				userCode = checkNull(rs.getString("CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			System.out.println("userCode=["+userCode+"]");
			
			String updateDMSql = "UPDATE DATA_MODEL_USER SET IS_DIRTY = 'T' WHERE DATA_MODEL IN(SELECT DATA_MODEL FROM DATA_MODEL_USE WHERE IS_CRITICAL = 'Y') AND USER_CODE= ?";
			pstmt = conn.prepareStatement(updateDMSql);
			pstmt.setString(1,userCode);
			int updDMcount = pstmt.executeUpdate();
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("updDMcount=["+updDMcount+"]");
			//To update the data models as Dirty on new load creation. Gulzar on 10-May-2023 . END
			
		}
		catch(Exception e)
		{
			System.out.println("Exception DaySummary posSave :==>\n" + e.getMessage());
			e.printStackTrace();
		}
		
		return resString;
	
	}
	
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return errString;
	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return objName;
	}
	
	public String getNextSequenceInvoice(Connection conn) throws Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String squence = "";
		int sprsInvId = 0;
		try
		{
			String seq1 ="SELECT SPRS_DAY_SUMM_INVOICE.nextVal AS SPRSInvId FROM DUAL";
			pstmt = conn.prepareStatement(seq1);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				sprsInvId = rs.getInt("SPRSInvId");
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			squence = String.format(String.format("%%0%dd", 7),sprsInvId);
			System.out.println("Beginning Sequence:::"+squence);
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally 
		{
			try 
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return squence;
	}
}
