package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

/**
 * This class contains business logic to handle brands.
 *
 * @author yogesh
 *
 */
//@Stateless		commented by Sagar M [22 Nov 2018].
public class Brands extends ValidatorEJB implements BrandsLocal, BrandsRemote
{

	/**  Used to access DB*/
	ITMDBAccessEJB dbAccEjb = new ITMDBAccessEJB();

	/**
	 * This method handles itemchange.
	 *
	 * @param xmlString contains form data
	 * @param xmlString1 contains form data
	 * @param objContext contains form no.
	 * @param currentColumn contains currentColumn to be item changed
	 * @param editFlag contains  editFlag eg. "A" or "E"
	 * @param xtraParams contains user info.
	 */
	public String itemChanged(String xmlString, String xmlString1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		String thGroup = "";
		String itmser="";
		Document dom = null;
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null ;

		/*System.out.println("SANJAY : currentColumn :" + currentColumn);
		System.out.println("SANJAY : xmlString :" + xmlString);
		System.out.println("SANJAY : xmlString1 :" + xmlString1);
		System.out.println("SANJAY : objContext :" + objContext);
		System.out.println("SANJAY : editFlag :" + editFlag);
		System.out.println("SANJAY : xtraParams :" + xtraParams);
		 */
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Added By Arpit On 08-June-2015 - START @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
			int currentFormNo = 0;
			String addDate="";
			String addUser="";
			String addTerm="";
			String chgDate = "";
			String chgUser = "";
			String chgTerm = "";
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			addDate = sdf.format(new java.util.Date());
			addUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			addTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			chgDate = sdf.format(new java.util.Date());
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");

			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo)
			{
				case 1:
					if (currentColumn.equalsIgnoreCase("itm_default"))
					{

						valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>");
						valueXmlString.append("<Root><header><editFlag>").append(editFlag).append("</editFlag></header>");
						valueXmlString.append("<Detail1>");
						valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
						//valueXmlString.append("<active_yn>").append("<![CDATA[Y]]>").append("</active_yn>");
						valueXmlString.append("</Detail1></Root>");
					}
			}
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Added By Arpit On 08-June-2015 - END @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
			if( "item_ser".equalsIgnoreCase(currentColumn) )
			{
				valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>");
				valueXmlString.append("<Root><header><editFlag>").append(editFlag).append("</editFlag></header>");
				valueXmlString.append("<Detail1>");

				dom = parseString( xmlString );
				System.out.println("sss dom"+dom);
				itmser = genericUtility.getColumnValue("item_ser",dom);
				System.out.println("itmser ["+itmser+"]");
				// commented & added by rupali for removing condition of ser_type [start]
				//String sql = "SELECT DESCR FROM ITEMSER WHERE item_ser = '"+itmser+"' and ser_type='F'";
				String sql = "SELECT DESCR FROM ITEMSER WHERE item_ser = '"+itmser+"'";
				// commented & added by rupali for removing condition of ser_type [end]
				System.out.println("itmser sql["+sql+"]");
				/*ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("Driver");*/
				conn = getConnection();
				stmt = conn.createStatement();
				rs = stmt.executeQuery( sql );
				if( rs.next() )
				{
					valueXmlString.append("<item_desc>").append(rs.getString("DESCR")).append("</item_desc>");
				}
				else
				{
					valueXmlString.append("<item_desc>").append("").append("</item_desc>");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				valueXmlString.append("</Detail1></Root>");
			}
			else if( "therapeutic_group".equalsIgnoreCase(currentColumn) )
			{
				valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
				valueXmlString.append(editFlag).append("</editFlag></header>");
				valueXmlString.append("<Detail1>");

				dom = parseString( xmlString );
				thGroup = genericUtility.getColumnValue("therapeutic_group",dom);
				System.out.println("thGroup ["+thGroup+"]");
				String sql = "SELECT DESCR FROM GENCODES WHERE FLD_VALUE = '"+thGroup+"'";
				System.out.println("thGroup sql["+sql+"]");
				//ConnDriver connDriver = new ConnDriver();
				//conn = connDriver.getConnectDB("Driver");
				conn = getConnection();
				stmt = conn.createStatement();
				rs = stmt.executeQuery( sql );
				if( rs.next() )
				{
					String genDescription = rs.getString("DESCR") != null ? rs.getString("DESCR").trim() : "" ;
					valueXmlString.append("<gencodes_descr>").append( genDescription ).append("</gencodes_descr>");
				}
				else
				{
					valueXmlString.append("<gencodes_descr>").append("").append("</gencodes_descr>");
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				valueXmlString.append("</Detail1></Root>");
			}
			else
			{
				System.out.println("SSSSSSSSSSSSSSSSSSERROR");
				//Added by arpit on 08-June-2015 - START

				valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>");
				valueXmlString.append("<Root><header><editFlag>").append(editFlag).append("</editFlag></header>");
				valueXmlString.append("<Detail1>");
				valueXmlString.append("<chg_date><![CDATA[").append(checkNull(chgDate)).append("]]></chg_date>\r\n");
				valueXmlString.append("<chg_user><![CDATA[").append(checkNull(chgUser)).append("]]></chg_user>\r\n");
				valueXmlString.append("<chg_term><![CDATA[").append(checkNull(chgTerm)).append("]]></chg_term>\r\n");
				if(editFlag.equals("A"))
				{
					valueXmlString.append("<pitch_priority>").append("<![CDATA[]]>").append("</pitch_priority>");
					valueXmlString.append("<active_yn>").append("<![CDATA[Y]]>").append("</active_yn>");
				}
				else if(editFlag.equals("E"))
				{
					String brandCode= genericUtility.getColumnValue("code",dom);
					String validFrom= genericUtility.getColumnValue("valid_from",dom);
					String validTo= genericUtility.getColumnValue("valid_to",dom);
					String sql1="select pitch_priority from brand where code='"+brandCode+"' and valid_from='"+validFrom+"' and valid_to='"+validTo+"'";
					//ConnDriver connDriver = new ConnDriver();
					//conn = connDriver.getConnectDB("Driver");
					conn = getConnection();
					stmt = conn.createStatement();
					rs = stmt.executeQuery( sql1 );
					if( rs.next() )
					{
						String pitchPriority = rs.getString("pitch_priorty") != null ? rs.getString("pitch_priority").trim() : "1" ;
						valueXmlString.append("<pitch_priorty>").append( pitchPriority ).append("</pitch_priorty>");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
				}
				valueXmlString.append("</Detail1></Root>");
				//Added by arpit on 08-june-2015 - END
			}
		}
		catch( Exception e )
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
				
			}
			catch (SQLException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}

	/**
	 * This method validates the form
	 *
	 * @param xmlString contains form data
	 * @param xmlString1 contains form data
	 * @param objContext contains form no.
	 * @param editFlag contains  editFlag eg. "A" or "E"
	 * @param xtraParams contains user info.
	 */
	public String wfValData(String xmlString, String xmlString1, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Brands : wfValData() : xmlString["+xmlString+"]editFlag["+editFlag+"]");
		Document dom = null;
		String itemCode = "";
		String thGroup = "";
		String retString = "";
		String userId = "";
		String errCode = "";
		String priority = "";
		String itmser = "";
		String desc="";
		SimpleDateFormat sdf = null;//added by arpit on 08-june-2015
		String effDate="";//added by arpit on 08-june-2015
		String validUptoDate="";//added by arpit on 08-june-2015
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null ;
		String sql = "";
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		String brandCode="";//added by arpit on 09-june-2015

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();//added by arpit on 08-june-2015
			sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());//Added by arpit on 08-june-2015

			String currDate = sdf.format(new java.util.Date());

			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("userId:- "  + userId);
			dom = parseString( xmlString );
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				//System.out.println("nodeName:"+childNodeName);
				if (childNodeName.equalsIgnoreCase("code"))
				{

					boolean hasChildNode = childNode.hasChildNodes();
					if( hasChildNode )
					{
						try
						{
							itemCode = childNode.getFirstChild().getNodeValue().trim();
							System.out.println("itemCode:"+itemCode);
							if(itemCode.trim().isEmpty()){

								errCode = "DDBLNKBRCD";
								retString = dbAccEjb.getErrorString("code",	errCode, userId, 1);
								break;//added by arpit on 22-june-2015
							}
							brandCode=itemCode;
							/*if (editFlag.equals("A"))	//IF BLOCK COMMENTED BY ARPIT ON 09-JUNE-2015
							{

								sql = "SELECT COUNT(1) FROM BRAND WHERE CODE = '"+ itemCode + "'";
								ConnDriver connDriver = new ConnDriver();
								conn = connDriver.getConnectDB("Driver");
								stmt = conn.createStatement();
								rs = stmt.executeQuery(sql);
								if (rs.next())
								{
									int count = rs.getInt(1);
									if (count > 0)
									{
										errCode = "DDDUPBRNCD";
										retString = dbAccEjb.getErrorString("code",	errCode, userId, 1);
									}
								}
							}*/
						}
						catch (Exception e)
						{
							e.printStackTrace();
						}
						finally
						{
							try
							{
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(stmt != null)
								{
									stmt.close();
									stmt = null;
								}
								if(conn != null)
								{
									conn.close();
									conn = null;
								}
								
							}
							catch (SQLException e)
							{
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					}
					else
					{
						errCode = "DDNULLITCD";
						retString = dbAccEjb.getErrorString("code",errCode,userId, 1);
						break;//added by arpit on 22-june-2015
					}
				}
				//below else if block commented by arpit on 09-june-2015, as a brand can exists for multiple range,thus multiple brands allowed
				/*else if( childNodeName.equalsIgnoreCase("description") )
				{
					boolean hasChildNode = childNode.hasChildNodes();
					try{
						if(hasChildNode)
						{
							desc= childNode.getFirstChild().getNodeValue().trim();
							sql = "SELECT COUNT(1) FROM BRAND WHERE DESCRIPTION = '"+ desc + "'";
							ConnDriver connDriver = new ConnDriver();
							conn = connDriver.getConnectDB("Driver");
							stmt = conn.createStatement();
							rs = stmt.executeQuery(sql);
							if (rs.next())
							{
								int count = rs.getInt(1);
								//Changed By Mahesh Patidar on 21-JUN-13 [duplicate descr not allow to brand]
								if (count > 0 && editFlag.equals("A"))
								{
									errCode = "DDDUPDESC";
									retString = dbAccEjb.getErrorString("description",	errCode, userId, 1);
								}
								else if (count == 1 && editFlag.equals("E"))
								{
									rs.close();
									rs = null;
									stmt.close();
									stmt = null;

									String code = GenericUtility.getInstance().getColumnValue("code", dom);
									System.out.println("Brand Code[" + code + "]");
									if(code == null)
									{
										code = "";
									}
									sql = "SELECT CODE FROM BRAND WHERE DESCRIPTION = '"+ desc + "'";
									stmt = conn.createStatement();
									rs = stmt.executeQuery(sql);
									if (rs.next())
									{
										String dbBrandCode = rs.getString("CODE") == null?"" : rs.getString("CODE");
										System.out.println("dbBrandCode[" + dbBrandCode + "]");
										if(! code.equals(dbBrandCode))
										{
											errCode = "DDDUPDESC";
											retString = dbAccEjb.getErrorString("description",	errCode, userId, 1);
										}
									}
								}
								else if(count > 1)
								{
									errCode = "DDDUPDESC";
									retString = dbAccEjb.getErrorString("description",	errCode, userId, 1);
								}
								//Ended By Mahesh Patidar
							}
						}
						else
						{
							errCode = "DDNULDESCR";
							retString = dbAccEjb.getErrorString("description",errCode,userId, 1);
						}
					}catch (Exception e) {
						e.printStackTrace();
					}
					finally
					{
						try
						{
							if(stmt != null)
							{
								stmt.close();
								stmt = null;
							}
							
							if(rs != null)
							{
								rs.close();
							}
							rs = null;
							if(conn != null)
							{
								conn.close();
								conn = null;
							}
							
						}
						catch (SQLException e)
						{
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
			}*/
			//Commented as per Kandarp Sir for Validation to be done from GenValidate
			// uncommented and changes made by rupali on 05/06/18 as per Gulzar Sir's instruction
			else if( childNodeName.equalsIgnoreCase("therapeutic_group") )
			{
				boolean hasChildNode = childNode.hasChildNodes();
				if( hasChildNode )
				{
					int count = 0;
					thGroup = childNode.getFirstChild().getNodeValue().trim();
					sql = "SELECT COUNT(1) FROM GENCODES WHERE FLD_NAME = 'THERAPEUTIC_GROUP' AND MOD_NAME = 'W_PRODUCT' AND  FLD_VALUE = '"+ thGroup + "'";
					/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("Driver");*/
					conn = getConnection();
					stmt = conn.createStatement();
					rs = stmt.executeQuery(sql);
					if (rs.next())
					{
						count = rs.getInt(1);
						/*if (count == 0)
						{
							errCode = "DDINVDTHGR";
							retString = dbAccEjb.getErrorString("therapeutic_group",errCode,userId, 1);
						}*/
					}
					//Added by Hariom S for dirty connection close  -- 07-Sep-21 [Start]	
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
					//Added by Hariom S for dirty connection close  -- 07-Sep-21 [End]	
					//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [Start]
					if (count == 0)
					{
						errCode = "DDINVDTHGR";
						retString = dbAccEjb.getErrorString("therapeutic_group",errCode,userId, 1);
					}
					//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [End]
				}
				else
				{
					errCode = "DDNULLTHGR";
					retString = dbAccEjb.getErrorString("therapeutic_group",errCode,userId, 1);
				}
			}
			else if(childNodeName.equalsIgnoreCase("item_ser")){

				boolean hasChildNode = childNode.hasChildNodes();
				if( hasChildNode )
				{
					int count=0;
					itmser = childNode.getFirstChild().getNodeValue().trim();
					//added by mrunalini sinkar on 10-may-2018 to remove ser typeCondition(satrt)
					//sql = "SELECT COUNT(1) FROM ITEMSER WHERE ITEM_SER = '"+ itmser + "' and ser_type='F'";
					sql = "SELECT COUNT(1) FROM ITEMSER WHERE ITEM_SER = '"+ itmser + "'";
					//added by mrunalini sinkar on 10-may-2018 to remove ser typeCondition(end)
					/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("Driver");*/
					conn = getConnection();
					stmt = conn.createStatement();
					rs = stmt.executeQuery(sql);
					if (rs.next())
					{
						count = rs.getInt(1);
						/*if (count == 0)
						{
							errCode = "DVINVDITDS";
							retString = dbAccEjb.getErrorString("item_desc",errCode,userId, 1);
							break;//added by arpit on 22-june-2015
						}*/
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
					//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [Start]
					if (count == 0)
					{
						errCode = "DVINVDITDS";
						retString = dbAccEjb.getErrorString("item_desc",errCode,userId, 1);
						break;//added by arpit on 22-june-2015
					}
					//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [END]
					
				}
				else
				{
					errCode = "DVNULLITDS";
					retString = dbAccEjb.getErrorString("item_desc",errCode,userId, 1);
					break;//added by arpit on 22-june-2015
				}
			}
			/*else if( "pitch_priority".equalsIgnoreCase( childNodeName ) )
			{
				boolean hasChildNode = childNode.hasChildNodes();
				if( hasChildNode )
				{
					priority = childNode.getFirstChild().getNodeValue().trim();
					if( isInteger( priority ) )
					{
						int intPriority = Integer.parseInt( priority );
						if( intPriority <= 0 )
						{
							errCode = "PRNUMGT0";
							retString = dbAccEjb.getErrorString("brand_pitch_priority",errCode,userId, 1);
							break;//added by arpit on 22-june-2015
						}
						else
						{
							if( priority.length() > 5 )
							{
								errCode = "PRNUMSIZE";
								retString = dbAccEjb.getErrorString("brand_pitch_priority",errCode,userId, 1);
								break;//added by arpit on 22-june-2015
							}
						}

					}
					else
					{
						errCode = "PRNUMER";
						retString = dbAccEjb.getErrorString("brand_pitch_priority",errCode,userId, 1);
						break;//added by arpit on 22-june-2015
					}

				}

			}*/

			// Added by Vishakha [10/12/2015] To add validation for pitch priority [Start]

			else if( "pitch_priority".equalsIgnoreCase( childNodeName ) )
			{
				boolean hasChildNode = childNode.hasChildNodes();
				if( hasChildNode )
				{
					int count=0;
					priority = childNode.getFirstChild().getNodeValue().trim();
					sql = "select COUNT(*) from gencodes where fld_name = 'PITCH_PRIORITY' and mod_name = 'W_PRODUCT' and trim(fld_value) ='"+priority+"' ";
					/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("Driver");*/
					conn = getConnection();
					stmt = conn.createStatement();
					rs = stmt.executeQuery(sql);
					if (rs.next())
					{
						count = rs.getInt(1);
					}
					/*if (count == 0)
					{
						errCode = "VMINVPITCH";
						retString = dbAccEjb.getErrorString("pitch_priority",errCode,userId, 1);
						break;
					}*/
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
					//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [Start]
					if (count == 0)
					{
						errCode = "VMINVPITCH";
						retString = dbAccEjb.getErrorString("pitch_priority",errCode,userId, 1);
						break;
					}
					//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [Start]

				}
				// added by rupali on 06/12/17 for validating null pitch priority [start]
				else
				{
					errCode = "NULLPITCH";
					retString = dbAccEjb.getErrorString("pitch_priority",errCode,userId, 1);
					break;
				}
				// added by rupali on 06/12/17 for validating null pitch priority [end]
			}
			// Added by Vishakha [10/12/2015] To add validation for pitch priority [End]


			// Added by Vishakha [01/10/2015] To add validation for Brand Code & Description [Start]
			// commented by rupali for not validating brand_code because it is auto generated field [start]
			/*else if( "brand_code".equalsIgnoreCase( childNodeName ) )	//Start Here
			{
				boolean hasChildNode = childNode.hasChildNodes();
				if( hasChildNode )
				{
					brandCode= childNode.getFirstChild().getNodeValue().trim();
					ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("Driver");
					int cnt =  isValueExist("BRAND","BRAND_CODE",brandCode, conn);
					if("A".equalsIgnoreCase(editFlag))
					{
						if(cnt>0)
						{
							errCode = "DDDUPBRNCD";
							retString = dbAccEjb.getErrorString("brand_code",errCode,userId, 1);
							break ;
						}
					}
				}
				else
				{
					errCode = "DDNULLBRCD";
					retString = dbAccEjb.getErrorString("brand_code",errCode,userId, 1);
					break;
				}
			}*/
			// commented by rupali for not validating brand_code because it is auto generated field [end]
			else if( "description".equalsIgnoreCase( childNodeName ) )	//Start Here
			{
				boolean hasChildNode = childNode.hasChildNodes();
				if( !hasChildNode )
				{
					errCode = "DDNULDESCR";
					retString = dbAccEjb.getErrorString("description",errCode,userId, 1);
					break;
				}
				else
				{

				}
			}

			// Added by Vishakha [01/10/2015] To add validation for Brand Code & Description [Start]



			else if( "active_yn".equalsIgnoreCase( childNodeName ) )	//Start Here
			{
				boolean hasChildNode = childNode.hasChildNodes();
				String activeStatus="";
				if( hasChildNode )
				{
					activeStatus= childNode.getFirstChild().getNodeValue().trim();
				}
				if(activeStatus.equalsIgnoreCase("N"))
				{
					if("A".equalsIgnoreCase(editFlag))
					{
						errCode = "VTSRET16";
						retString = dbAccEjb.getErrorString("active_yn",errCode,userId, 1);
						break;
					}
					else if("E".equalsIgnoreCase(editFlag))
					{
						boolean flagEdit= false;
						System.out.println("currDate:"+currDate);
						System.out.println("activeStatus:"+activeStatus);
						System.out.println("brand code:"+brandCode);
						brandCode=brandCode.trim();
						sql="select * from strg_product x where x.brand_code='"+brandCode+"' and '"+currDate+"' between x.valid_from and x.valid_to";
						System.out.println("sql:"+sql);
						/*ConnDriver connDriver = new ConnDriver();
						conn = connDriver.getConnectDB("Driver");*/
						conn = getConnection();
						stmt = conn.createStatement();
						rs = stmt.executeQuery(sql);
						if(rs.next())
						{
							flagEdit= true;
							/*errCode = "VTBRSTAT";
							retString = dbAccEjb.getErrorString("active_yn",errCode,userId, 1);
							break;*/
							//added by arpit on 22-june-2015
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(stmt != null)
						{
							stmt.close();
							stmt = null;
						}
						if(conn != null)
						{
							conn.close();
							conn = null;
						}
						//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [Start]
						if (flagEdit)
						{
							errCode = "VTBRSTAT";
							retString = dbAccEjb.getErrorString("active_yn",errCode,userId, 1);
							break;//added by arpit on 22-june-2015
						}
						//Added by Bhagyashri T for dirty connection close  -- 25-Jan-21 [END]
					}
				}
			}



// Commented By Arpit [24/07/2015][Validity Date Range Removed][Start]
			/*else if(childNodeName.equalsIgnoreCase("valid_from"))//added by arpit on 08-june-2015
			{
				if(childNode.getFirstChild() == null )
				{
					retString = getErrorString("valid_from","NULLVLDF",userId);
					break;//added by arpit on 22-june-2015
				}
				else
				{
					effDate=childNode.getFirstChild().getNodeValue().trim();
				}
			}
			else if(childNodeName.equalsIgnoreCase("valid_to"))//added by arpit on 08-june-2015
			{
				if(childNode.getFirstChild() == null )
				{
					retString = getErrorString("valid_to","NULLVLDT",userId);
				}
				else
				{
					validUptoDate=childNode.getFirstChild().getNodeValue().trim();
				}
			}*/
		}
// Commented By Arpit [24/07/2015][Validity Date Range Removed][End]
// Commented By Arpit [24/07/2015][Validity Date Range Removed][Start]
			/*Date date1 = sdf.parse(effDate);
			Date date2 = sdf.parse(validUptoDate);

			if(date1.compareTo(date2)>0){
				System.out.println("Date1 is after Date2");
				retString = getErrorString("valid_to","INVDTRNG",userId);
			}
			if(brandCode.length()>0 && effDate.length()>0 && validUptoDate.length()>0 && editFlag.equals("A"))
			{
				sql="select count(1) from brand x"
					+" where (x.valid_from='"+effDate+"' and x.valid_to='"+validUptoDate+"' and x.code='"+brandCode+"') or"
					+" (x.valid_from='"+effDate+"' and x.code='"+brandCode+"') or"
					+" (x.valid_to='"+validUptoDate+"' and x.code='"+brandCode+"')";
				sql="SELECT COUNT(1) FROM brand x "
					+" where ('"+effDate+"' between valid_from and valid_to and x.code='"+brandCode+"')"
					+" or ('"+validUptoDate+"' between valid_from and valid_to and x.code='"+brandCode+"')";
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("Driver");
				stmt = conn.createStatement();
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					int count = rs.getInt(1);
					if (count > 0)
					{
						errCode = "DUBRVLR";
						retString = dbAccEjb.getErrorString("code",	errCode, userId, 1);

					}
				}
			}*/
// Commented By Arpit [24/07/2015][Validity Date Range Removed][End]
	}
	catch (Exception e)
	{
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(stmt != null)
			{
				stmt.close();
				stmt = null;
			}
			if(conn != null)
			{
				conn.close();
				conn = null;
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}
	return retString ;
}

public boolean isInteger(String inputString) throws ITMException
{
	try
	{
		Integer.parseInt(inputString);
		return true;
	}
	catch(NumberFormatException nFE)
	{
		return false;
	}
	catch(Exception ex)
	{
		throw new ITMException(ex);
	}
}
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@ Added By Arpit On 08-June-2015 - START @@@@@@@@@@@@@@@@@@@@@@@
	private String checkNull( String input )
	{
		if(input == null)
		{
		input = "";
		}
		return input;
	}
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@ Added By Arpit On 08-June-2015 - END @@@@@@@@@@@@@@@@@@@@@@@



	// Added by Vishakha [01/10/2015] To add validation for Brand Code & Description [Start]

	private int isValueExist(String tableName, String columnName, String columnValue,Connection conn) throws ITMException
    {
    	PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = null;
        int cnt = 0 ;
        sql = " select count(1) as count from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
        try
        {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
            if(rs.next())
            {
            	cnt = rs.getInt("count");
            }
            rs.close();
            pstmt.close();
            System.out.println("cnt--------------"+cnt);
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            System.out.println("Exception ::" + exception.getMessage());
            throw new ITMException(exception); //added by Kailash on 11-04-2018
        }
        return cnt;
    }


	// Added by Vishakha [01/10/2015] To add validation for Brand Code & Description [End]


}

