package ibase.webitm.utility;

import java.io.BufferedInputStream;		
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.spec.KeySpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import ibase.bean.ChangePasswordBean;
import ibase.bean.EventLogInfoBean;
import ibase.bean.ExtAuthAppAPIBean;
import ibase.bean.ExtAuthApplicationBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.ejb.ExtServiceEJB;
import ibase.ejb.UserEventLogEJB;
import ibase.servlet.Messages;
import ibase.sessionnotification.ClientWebsocketNotification;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.utility.CommonConstants.WebSocketMessageType;
import ibase.webitm.bean.ITMTransactionEditorBean;
import ibase.webitm.ejb.AuditTrailExtEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.DocumentHandlerRemote;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.ExtServiceEventManagerEJB;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.PopUpEJB;
import ibase.webitm.ejb.sys.UserAccountsLock;
import ibase.webitm.ejb.UserActivationEJB;
import ibase.webitm.ejb.UserEnterpriseEJB;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.hrp.Attd_eSalarySlip;
import ibase.wrkflw.E12FollowUpActionEJB;
import ibase.wrkflw.SignManagerEJB;

/*
 * Author: Gagan B.
 * 
 * Purpose: Created new class which contains the logic for E12ExtService.
 * 
 * */

public class E12ExtServiceUtility extends RestAPIServiceUtility
{
	HttpServletRequest requestGlobal = null; // Added by Gagan B. to create a global variable for request.
	private UserInfoBean userInfo = null;
	private E12GenericUtility genericUtility = new E12GenericUtility();
	private CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
	private APIUtility apiUtility = new APIUtility();
	
	public String getExtServiceData(String dataFor, String userCode, String password, String isPwdEncrypt, String serviceParam1, String serviceParam2, 
			String serviceParam3, String serviceParam4, HttpServletRequest request) throws ITMException
	{
		//Changed by Prasad on 18/02/16 [for validating user] START
		JSONObject resultJson = new JSONObject();
		String result = "";
		String status = "error";
		try
		{
			dataFor = E12GenericUtility.checkNull( dataFor );
			userCode = E12GenericUtility.checkNull( userCode );
			password = E12GenericUtility.checkNull( password );
			isPwdEncrypt = E12GenericUtility.checkNull( isPwdEncrypt ).length() > 0 ? E12GenericUtility.checkNull( isPwdEncrypt ) : "false";
			String authStatus = "";
			if ( userCode.length() > 0 )
			{
				authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
				//if ( isValidLogin )
				if ( "VALID".equalsIgnoreCase( authStatus ) )
				{
					// Changes by Gagan B. on 11-08-23 [for checking daily API limit] 
					if (userInfo == null) {
						userInfo = commonDBAccessEJB.createUserInfo(userCode);
					}
					if (apiUtility.checkDailyAPILimit(userInfo)) {
						status = "Reject"; 
						result = "Daily API call limit exceeded";
					} else {
						//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] START
						/*String clientIP = E12GenericUtility.checkNull( request.getRemoteAddr() );
						InetAddress inetAddress = null;
						inetAddress = InetAddress.getLocalHost();
						String hostName = inetAddress.getHostName();
						String hostIP = inetAddress.getHostAddress();
						if ( getUserInfo() != null )
						{
							getUserInfo().setRemoteHost( ( clientIP.length() > 0 ) ? clientIP : "SYSTEM" );
							getUserInfo().setSessionId( request.getSession().getId() );
							getUserInfo().setHostName( hostName );
							getUserInfo().setHostIP( hostIP );
						}*/
						//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] END
						String xtraParams = getXtraParams();
						result = executeSystemEvent( dataFor, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams );
						status = "success";
						resultJson.put( "status", status );
					
					}
				}
				else
				{
					status = "error";
					result = authStatus;
					resultJson.put( "status", status );
				}
			}
			else
			{
				result = "You are not authorized to access.";
				resultJson.put( "status", "error" );
			}
			resultJson.put( "results", result );
			//Changed by Prasad on 18/02/16 [for validating user] END
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getExtServiceData : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		writeAPICallLog("getExtServiceData ( /getExtServiceData )", status, result, null, request, userInfo);
		return resultJson.toString();
	}
	
	public String getExtnServiceData(String dataFor, String userCode, String password, String isPwdEncrypt, String serviceParam1, String serviceParam2, 
			String serviceParam3, String serviceParam4, HttpServletRequest request) throws ITMException
	{
		String status = "";
		String result = "";
		JSONObject resultJson = new JSONObject();
		try
		{
			dataFor = E12GenericUtility.checkNull( dataFor );
			userCode = E12GenericUtility.checkNull( userCode );
			password = E12GenericUtility.checkNull( password );
			isPwdEncrypt = E12GenericUtility.checkNull( isPwdEncrypt ).length() > 0 ? E12GenericUtility.checkNull( isPwdEncrypt ) : "false";
			String authStatus = "";
			if ( userCode.length() > 0 )
			{
				authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
				//if ( isValidLogin )
				if ( "VALID".equalsIgnoreCase( authStatus ) )
				{
					// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
					if (userInfo == null) {
						userInfo = commonDBAccessEJB.createUserInfo(userCode);
					}
					if (apiUtility.checkDailyAPILimit(userInfo)) {
						status = "Reject";
						result = "Daily API call limit exceeded";
					} else {
						//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] START
						/*String clientIP = E12GenericUtility.checkNull( request.getRemoteAddr() );
						InetAddress inetAddress = null;
						inetAddress = InetAddress.getLocalHost();
						String hostName = inetAddress.getHostName();
						String hostIP = inetAddress.getHostAddress();
						if ( getUserInfo() != null )
						{
							getUserInfo().setRemoteHost( ( clientIP.length() > 0 ) ? clientIP : "SYSTEM" );
							getUserInfo().setSessionId( request.getSession().getId() );
							getUserInfo().setHostName( hostName );
							getUserInfo().setHostIP( hostIP );
						}*/
						//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] END
						String xtraParams = getXtraParams();
						result = executeSystemEvent( dataFor, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams );
						status = "success";
						resultJson.put( "status", status );
					}
				}
				else
				{
					status = "error";
					resultJson.put( "status", status );
					result = authStatus;
				}
			}
			else
			{
				resultJson.put( "status", "error" );
				result = "You are not authorized to access.";
			}
			resultJson.put( "results", result );
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getExtServiceData : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		writeAPICallLog("getExtnServiceData ( /getExtServiceClient )", status, result, null, request, userInfo);
		return resultJson.toString();
	}
	
	public String authenticateUser(String userCode, String password, String isPwdEncrypt, String dataFormat, boolean isDestroySession, String appId, HttpServletRequest request) throws BaseException
	{
		String result = "";
		String params = "";
		//Added by Prasad on 13/04/17 [to insert tokenId while login]
		String tokenId = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode );
				paramString.append("&PASSWORD="+ password );
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt );
				paramString.append("&DATA_FORMAT="+ dataFormat );
				paramString.append("&IS_DESTROY_SESSION="+ isDestroySession );
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			result = validateRequest( request, dataFormat, null, false, appId, "login" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					userCode = checkNull( userCode );
					password = checkNull( password );
					isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
					String isValidLogin = "false";
					if ( userCode.length() > 0 )
					{
						isValidLogin = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
						if ( "VALID".equalsIgnoreCase( isValidLogin ) )
						{
							//Changed by Prasad on 13/04/17 [to insert tokenId while login] START
							/*String tokenId = userCode + ":" + UUID.randomUUID().toString().toUpperCase();
							if ( tokenId.length() > 30 )
							{
								tokenId = tokenId.substring( 0, 30 );
							}*/
							tokenId = generateNewTokenId( userCode );
							//Changed by Prasad on 13/04/17 [to insert tokenId while login] END
							BaseLogger.log("3",null,null,"tokenId - "+ tokenId.length());

							request.getSession().setAttribute( "TOKEN_ID", tokenId );
							request.getSession().setAttribute( "USER_INFO", getUserInfo() );

							JSONObject resultDtlJson = new JSONObject();
							resultDtlJson.put( "TOKEN_ID", tokenId );
							resultDtlJson.put( "EMP_ID", getUserInfo().getEmpCode() );
							//resultDtlJson.put( "LOGIN_CODE", getUserInfo().getLoginCode() );
							//result = resultDtlJson.toString();
							//result = getUserDtl(resultDtlJson);

							//result = resultDtlJson.toString();
							resultDtlJson = getUserDtl(resultDtlJson);

							//result=resultDtlJson.toString();
							resultDtlJson.put( "LOGIN_CODE", getUserInfo().getLoginCode() );
							result=resultDtlJson.toString();
							BaseLogger.log("3",null,null,"login code in result " + result );
							//resultDtlJson.put( "LOGIN_CODE", getUserInfo().getLoginCode() );
							request.getSession().setAttribute( "USER_INFO", getUserInfo() );

							if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
							{
								result = genericUtility.jsonToXMLString( result );
							}
							status = "success";
						}
						else
						{
							result = isValidLogin;
							status = "error";
						}
					}
					else
					{
						result = "Please enter username.";
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : authenticateUser : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "login", params, tokenId, dataFormat, status, result);
			BaseLogger.log("3",null,null,"result---> authernticateUser() ["+ result  +"]");
			//Added By Ravindra C on 25-02-19 - to check Is sesson is distroy or not - Start
			BaseLogger.log("3",null,null,"isSessionDestroy ["+ isDestroySession  +"]");
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, tokenId, dataFormat, status, result );
			}
			//Added By Ravindra C on 25-02-19 - to check Is sesson is distroy or not - End
		}
		writeAPICallLog("authenticateUser ( /login )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String authenticateUserClient(String userCode, String password, String isPwdEncrypt, String inputString, String dataFormat, HttpServletRequest request,
			boolean isDestroySession, String appId) throws BaseException
	{
		requestGlobal = request;
		String result = "";
		String params = "";
		//Added by Prasad on 13/04/17 [to insert tokenId while login]
		String tokenId = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&PASSWORD="+ password);
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&IS_DESTROY_SESSION="+ isDestroySession);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			result = validateRequest( request, dataFormat, null, false, appId, "login" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					userCode = checkNull( userCode );
					password = checkNull( password );
					isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
					String isValidLogin = "false";
					if ( userCode.length() > 0 )
					{
						isValidLogin = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
						if ( "VALID".equalsIgnoreCase( isValidLogin ) )
						{
							//Changed by Prasad on 13/04/17 [to insert tokenId while login] START
							/*String tokenId = userCode + ":" + UUID.randomUUID().toString().toUpperCase();
							if ( tokenId.length() > 30 )
							{
								tokenId = tokenId.substring( 0, 30 );
							}*/
							tokenId = generateNewTokenId( userCode );
							//Changed by Prasad on 13/04/17 [to insert tokenId while login] END
							BaseLogger.log("3",null,null,"tokenId - "+ tokenId.length());

							request.getSession().setAttribute( "TOKEN_ID", tokenId );
							request.getSession().setAttribute( "USER_INFO", getUserInfo() );

							JSONObject resultDtlJson = new JSONObject();
							resultDtlJson.put( "TOKEN_ID", tokenId );
							resultDtlJson.put( "EMP_ID", getUserInfo().getEmpCode() );
							//result = resultDtlJson.toString();
							resultDtlJson = getUserDtl(resultDtlJson);
							resultDtlJson.put( "LOGIN_CODE", getUserInfo().getLoginCode());
							result=resultDtlJson.toString();
							if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
							{
								result = genericUtility.jsonToXMLString( result );
							}
							status = "success";
						}
						else
						{
							result = isValidLogin;
							status = "error";
						}
					}
					else
					{
						result = "Please enter username.";
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : authenticateUser : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "login", params, tokenId, dataFormat, status, result);
			//Added By Ravindra C on 25-02-19 - to check Is sesson is distroy or not - Start
			BaseLogger.log("3",null,null,"isSessionDestroy ["+ isDestroySession  +"]");
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, tokenId, dataFormat, status, result );
			}
			//Added By Ravindra C on 25-02-19 - to check Is sesson is distroy or not - End
		}
		writeAPICallLog("authenticateUserClient ( /login )", status, result, appId, request, userInfo);
		return result;
	}
	//Added By Ankush S on [04-DEC-2023][to get JSON response]START
	public String authenticateUserClientJSON(String userCode, String password, String isPwdEncrypt, String inputString, String dataFormat, HttpServletRequest request,
			boolean isDestroySession, String appId) throws BaseException
	{
		String result = "";
		String params = "";
		//Added by Prasad on 13/04/17 [to insert tokenId while login]
		String tokenId = "";
		String status = "error";
		
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&PASSWORD="+ password);
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&IS_DESTROY_SESSION="+ isDestroySession);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			result = validateRequest( request, dataFormat, null, false, appId, "login" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				userCode = checkNull( userCode );
				password = checkNull( password );
				isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
				String isValidLogin = "false";
				if ( userCode.length() > 0 )
				{
					isValidLogin = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
					if ( "VALID".equalsIgnoreCase( isValidLogin ) )
					{
						//Changed by Prasad on 13/04/17 [to insert tokenId while login] START
						/*String tokenId = userCode + ":" + UUID.randomUUID().toString().toUpperCase();
						if ( tokenId.length() > 30 )
						{
							tokenId = tokenId.substring( 0, 30 );
						}*/
						//tokenId = generateNewTokenId( userCode );
						tokenId = CryptographyUtil.createBase64EncodedPermanentJWT(appId,userCode);
						//Changed by Prasad on 13/04/17 [to insert tokenId while login] END
						BaseLogger.log("3",null,null,"tokenId - "+ tokenId.length());
						BaseLogger.log("3",null,null,"permanent Token ID ======== "+ tokenId);

						request.getSession().setAttribute( "TOKEN_ID", tokenId );
						request.getSession().setAttribute( "USER_INFO", getUserInfo() );

						JSONObject resultDtlJson = new JSONObject();
						resultDtlJson.put( "TOKEN_ID", tokenId );
						resultDtlJson.put( "EMP_ID", getUserInfo().getEmpCode() );
						//result = resultDtlJson.toString();
						
						resultDtlJson = getUserDtl(resultDtlJson);
						resultDtlJson.put( "LOGIN_CODE", getUserInfo().getLoginCode());
						
						//Add by Ankush S on[04-JAN-24 [userinfo in response in json format]START
						String userInfoStr = genericUtility.xmlToJSONString(getUserInfo().toString()).replace("\\", "");
						BaseLogger.log("3",null,null," slash result json userInfoStr - "+ userInfoStr);
						resultDtlJson.put("USER_INFO", new JSONObject(userInfoStr));
						//Add by Ankush S on[04-JAN-24 [userinfo in response in json format]END
						result=resultDtlJson.toString();
						BaseLogger.log("3",null,null,"result json String - "+ result);
						if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.jsonToXMLString( result );
						}
						status = "success";
					}
					else
					{
						result = isValidLogin;
						status = "error";
					}
				}
				else
				{
					result = "Please enter username.";
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : authenticateUser : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateJSONResponse(request, "login", params, tokenId, dataFormat, status, result);
			//Added By Ravindra C on 25-02-19 - to check Is sesson is distroy or not - Start
			BaseLogger.log("3",null,null,"isSessionDestroy ["+ isDestroySession  +"]");
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, tokenId, dataFormat, status, result );
			}
			//Added By Ravindra C on 25-02-19 - to check Is sesson is distroy or not - End
		}
		return result;
	}
	//Added By Ankush S on [04-DEC-2023][to get JSON response]START
	
	public String forgotPassword(String userCode, String dataFormat, String applicationHashCode, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat );
			result = validateRequest( request, dataFormat, null, false, appId, "forgot_password" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String empStatus = getCommonDBAccess().checkEmpStatus( userCode );
					Date empDeactDate = getCommonDBAccess().checkEmpDeactDate( userCode );
					Date currentDate = new Date();
					if( "".equals( empStatus ) || "A".equalsIgnoreCase( empStatus ) )
					{
						if ( empDeactDate != null && empDeactDate.before( currentDate ) )
						{
							result = Messages.getString( "AuthenticateServlet_notAnActiveUser", getUserLangAndCountry( userCode ) );
							status = "error";
						}
						else
						{
							// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
							//DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
							DBAccessEJB dbAccessEJB = new DBAccessEJB();
							// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
							String condition =  " CODE = '" + userCode + "' ";
							String emailId = dbAccessEJB.getDBColumnValue( "USERS", "EMAIL_ID", condition );
							dbAccessEJB = null;
							BaseLogger.log("3",null,null,"emailId - ["+ emailId +"]");
							String clientIP = checkNull( request.getRemoteAddr() );
							clientIP = ( clientIP.length() > 0 ) ? clientIP : "SYSTEM";
							if ( checkNull( emailId ).length() > 0 )
							{
								//Changed by Pravin k on 1-MAR-19 [For appHash] START
								String varCode = getCommonDBAccess().sendVarificationCode(userCode, applicationHashCode);
								//Changed by Pravin k on 1-MAR-19 [For appHash] START
								result = "Verification Code : "+varCode;
								//Two arguement added by sadique 25-6-2019
								//getCommonDBAccess().secureAccount( userCode, "0", userInfo );
								getCommonDBAccess().secureAccount( userCode, "0", userInfo,clientIP,"");
								getCommonDBAccess().updatePasswordChgLog( userCode, clientIP, "Browser" );
								result = Messages.getString( "AuthenticateServlet_newPasswordIsSentToYourEmaiID", getUserLangAndCountry( userCode ) ) + " [" + emailId +"]" ;
								status = "success";
							}
							else
							{
								result = "Email Id Not Found !";
								status = "error";
							}
						}
					}
					else
					{
						result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUser", getUserLangAndCountry( userCode ) );
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : forgotPassword : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
		}
		writeAPICallLog("forgotPassword ( /forgot_password )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String forgotPasswordClient(String userCode, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat );
			result = validateRequest( request, dataFormat, null, false, appId, "forgot_password" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String empStatus = getCommonDBAccess().checkEmpStatus( userCode );
					Date empDeactDate = getCommonDBAccess().checkEmpDeactDate( userCode );
					Date currentDate = new Date();
					if( "".equals( empStatus ) || "A".equalsIgnoreCase( empStatus ) )
					{
						if ( empDeactDate != null && empDeactDate.before( currentDate ) )
						{
							result = Messages.getString( "AuthenticateServlet_notAnActiveUser", getUserLangAndCountry( userCode ) );
							status = "error";
						}
						else
						{
							// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
							//DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
							DBAccessEJB dbAccessEJB = new DBAccessEJB();
							// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
							String condition =  " CODE = '" + userCode + "' ";
							String emailId = dbAccessEJB.getDBColumnValue( "USERS", "EMAIL_ID", condition );
							dbAccessEJB = null;
							BaseLogger.log("3",null,null,"emailId - ["+ emailId +"]");
							String clientIP = checkNull( request.getRemoteAddr() );
							clientIP = ( clientIP.length() > 0 ) ? clientIP : "SYSTEM";
							if ( checkNull( emailId ).length() > 0 )
							{
								String varCode = getCommonDBAccess().sendVarificationCode( userCode );
								result = "Verification Code : "+varCode;
								//Two arguement added by sadique 25-6-2019
								//getCommonDBAccess().secureAccount( userCode, "0", userInfo );
								getCommonDBAccess().secureAccount( userCode, "0", userInfo,clientIP,"");
								getCommonDBAccess().updatePasswordChgLog( userCode, clientIP, "Browser" );
								result = Messages.getString( "AuthenticateServlet_newPasswordIsSentToYourEmaiID", getUserLangAndCountry( userCode ) ) + " [" + emailId +"]" ;
								status = "success";
							}
							else
							{
								result = "Email Id Not Found !";
								status = "error";
							}
						}
					}
					else
					{
						result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUser", getUserLangAndCountry( userCode ) );
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : forgotPassword : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
		}
		writeAPICallLog("forgotPasswordClient ( /forgot_password )", status, result, appId, request, userInfo);
		return result;
	}
	
	
	public String changePassword(String userCode, String oldPassword, String newPassword, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		//http://192.168.0.160:9092/ibase/REST/E12ExtService/login?USER_CODE=I99993&PASSWORD=PASSWORD&IS_PWD_ENCRYPT=false&DATA_FORMAT=&IS_DESTROY_SESSION=false
		String result = "";
		String params = "";
		String status = "error";
		String newPwdSHA256 = request.getParameter("newPwdSHA256"); 

		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&OLD_PASS="+ oldPassword);
				paramString.append("&NEW_PASS="+ newPassword);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "change_password" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			//Added by sadique shaikh 24-6-2019
			String deviceId = request.getParameter("MAC_ADDRESS");
			if( deviceId == null || deviceId.trim().length() == 0 )
			{
				deviceId = request.getParameter("DEVICEID");
			}
			//end 24-06-2019
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					if( getCommonDBAccess().checkOldPassword( userCode, oldPassword, userInfo ) )
					{
						//Added By Pankaj T. on 04-06-2020 for sun vulnerabilities added server side validation of old & new password - start
						if( getCommonDBAccess().validatePassword(newPassword, userInfo) )
						{
							/*
							 * 1. Verify getCommonDBAccess().checkPassHistory and ChangePassworddb.checkPassHistory() are same 
							 * 2. Use ChangePasswordBean.checkPassHistory()*/
							if( ! getCommonDBAccess().checkPassHistory( userCode, newPassword, userInfo ) )
							{
								
								//ChangePasswordBean.updatePassword( userCode, newPassword, newPwdSHA256, userInfo.getUserLanguage().toString(), "0", userInfo,request.getRemoteAddr(),deviceId );
								//commonDBAccessEJB.updatePassword( userCode, newPassword, newPwdSHA256, userInfo.getUserLanguage(), "0", userInfo,request.getRemoteAddr(),deviceId );

								//Two new arguement added by sadique 25-6-2019 for change password
								//Changed by Amol S on 25-01-24 ,when changing password via change_password API, to not show prompt for change password again -- [START]
								//getCommonDBAccess().updatePassword( userCode, newPassword, userInfo,request.getRemoteAddr(),deviceId );
								ChangePasswordBean chgPasswordBean = new ChangePasswordBean();
								chgPasswordBean.updatePassword( userCode,newPassword, newPwdSHA256, userInfo.getUserLanguage(), userInfo, request.getRemoteAddr() ,deviceId );
								//Changed by Amol S on 25-01-24 ,when changing password via change_password API, to not show prompt for change password again -- [END]
								
								result = "Password updated successfully";
								status = "success";
							}
							else
							{
								result = "Password already use. Please enter new password.";
								status = "error";
							}
						}
						else
						{
							result = "The password must contain at least one uppercase character, lowercase character, special character and a digit.";
							status = "error";
						}
						//Added By Pankaj T. on 04-06-2020 for sun vulnerabilities added server side validation of old & new password - end
					}
					else
					{
						result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword", getUserLangAndCountry( userCode ) );
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : chgPassword : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("changePassword ( /change_password )", status, result, appId, request, userInfo);
		return result;
	}

	
	
	public String changePasswordClient(String userCode, String oldPassword, String newPassword, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		String newPwdSHA256 = request.getParameter("newPwdSHA256"); //added by amol

		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&OLD_PASS="+ oldPassword);
				paramString.append("&NEW_PASS="+ newPassword);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "change_password" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");

			//Added by sadique shaikh 24-6-2019
			String deviceId = request.getParameter("MAC_ADDRESS");
			if( deviceId == null || deviceId.trim().length() == 0 )
			{
				deviceId = request.getParameter("DEVICEID");
			}
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					if( getCommonDBAccess().checkOldPassword( userCode, oldPassword, userInfo ) )
					{
						//Added By Pankaj T. on 04-06-2020 for sun vulnerabilities added server side validation of old & new password - start
						if( getCommonDBAccess().validatePassword(newPassword, userInfo) )
						{
							if( ! getCommonDBAccess().checkPassHistory( userCode, newPassword, userInfo ) )
							{
								//Changed by Amol S on 25-01-24 ,when changing password via change_password API, to not show prompt for change password again -- [START]

								ChangePasswordBean chgPasswordBean = new ChangePasswordBean();
								chgPasswordBean.updatePassword( userCode,newPassword, E12GenericUtility.checkNull(newPwdSHA256), userInfo.getUserLanguage(), userInfo, request.getRemoteAddr() ,deviceId );
								//Changed by Amol S on 25-01-24 ,when changing password via change_password API, to not show prompt for change password again -- [End]

								result = "Password updated successfully";
							}
							else
							{
								result = "Password exists.";
								status = "error";
							}
						}
						else
						{
							result = "The password must contain at least one uppercase character, lowercase character, special character and a digit.";
							status = "error";
						}
						//Added By Pankaj T. on 04-06-2020 for sun vulnerabilities added server side validation of old & new password - end
					}
					else
					{
						result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword", getUserLangAndCountry( userCode ) );
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : chgPassword : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("changePasswordClient ( /change_password )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String logout(String userCode, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "logout" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					if ( checkNull( userCode ).length() > 0 )
					{
						String sessionUserCode = userInfo.getLoginCode();
						if ( userCode.equals( sessionUserCode ) )
						{
							if ( validateUserSession( request, tokenId ) )
							{
								logout( userCode, request );
								result = "Logout successfully";
								status = "success";
							}
						}
						else
						{
							result = "Invalid user.";
							status = "error";
						}
					}
					else
					{
						result = "Please enter username.";
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("3",null,null, "Exception : chgPassword : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("logout ( /logout )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String logoutClient(String userCode, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "logout" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = commonDBAccessEJB.createUserInfo(userCode);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					if ( checkNull( userCode ).length() > 0 )
					{
						String sessionUserCode = userInfo.getLoginCode();
						if ( userCode.equals( sessionUserCode ) )
						{
							if ( validateUserSession( request, tokenId ) )
							{
								logout( userCode, request );
								result = "Logout successfully";
								status = "success";
							}
						}
						else
						{
							result = "Invalid user.";
							status = "error";
						}
					}
					else
					{
						result = "Please enter username.";
						status = "error";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : chgPassword : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("logoutClient ( /logout )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String callSystemAction(String action, String objName, String inputString, String tokenId, String dataFormat, String appId, HttpServletRequest request, ServletContext context)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION="+ action);
				BaseLogger.log("3",null,null,"action = "+action);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "callSystemAction" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					inputString = checkNull( inputString );
					if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
					{
						inputString = genericUtility.jsonToXMLString( inputString );
					}
					//BaseLogger.log("3",null,null,"inputString - ["+ inputString +"]");
					//Added by Prasad on 30/08/2020 [to check object rights for processRequest] START
					boolean isRightsAvailable = isObjectRightsAvailable( inputString );
					if ( isRightsAvailable )
					{
						result = checkNull( processRequest( inputString, context ) );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
					else
					{
						status = "error";
						result = "Rights not available for a provided object.";
					}
					//Added by Prasad on 30/08/2020 [to check object rights for processRequest] END
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : callSystemAction : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("callSystemAction ( /callSystemAction )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String callSystemActionClient(String action, String objName, String inputString, String tokenId, String dataFormat,
			String appId, HttpServletRequest request, ServletContext context )
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION="+ action);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "callSystemAction" );
			BaseLogger.log("3",null,null,"validateRequest :: 888 :: - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					inputString = checkNull( inputString );
					if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
					{
						inputString = genericUtility.jsonToXMLString( inputString );
					}
					//BaseLogger.log("3",null,null,"inputString - ["+ inputString +"]");
					//Added by Prasad on 30/08/2020 [to check object rights for processRequest] START
					boolean isRightsAvailable = isObjectRightsAvailable( inputString );
					if ( isRightsAvailable )
					{
						result = checkNull( processRequest( inputString, context ) );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
					else
					{
						status = "error";
						result = "Rights not available for a provided object.";
					}
					//Added by Prasad on 30/08/2020 [to check object rights for processRequest] END
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : callSystemAction ["+ e.getMessage() +"]");
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("callSystemActionClient ( /callSystemAction )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String callSystemEvent(String objName, String eventCode, String inputString, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("EVENT_CODE="+ eventCode);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "callSystemEvent" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					BaseLogger.log("3",null,null,"getUserInfo() - "+ getUserInfo().toString());
					//EventManagerRemote eventManager = (EventManagerRemote) getInitialContext().lookup("ibase/EventManagerEJB/remote");
					EventManagerEJB eventManager = new EventManagerEJB();
					//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
					if ( eventManager.isEventExist( objName, eventCode, userInfo ) )
					{
						String transDB = userInfo.getTransDB();
						String xmlString = inputString;
						if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
						{
							xmlString = genericUtility.jsonToXMLString( inputString );
						}
						if( checkNull( transDB ).length() > 0 )
						{
							result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams(), userInfo );
						}
						else
						{
							result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams() );
						}
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
					else
					{
						status = "error";
						result = "Event Code not found.";
					}
					eventManager = null;
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : callSystemEvent : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("callSystemEvent ( /callSystemEvent )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String callSystemEventClient(String objName, String eventCode, String inputString, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("EVENT_CODE="+ eventCode);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "callSystemEvent" );
			BaseLogger.log("9",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					BaseLogger.log("3",null,null,"getUserInfo() - "+ getUserInfo().toString());
					//EventManagerRemote eventManager = (EventManagerRemote) getInitialContext().lookup("ibase/EventManagerEJB/remote");
					EventManagerEJB eventManager = new EventManagerEJB();
					//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
					if ( eventManager.isEventExist( objName, eventCode, userInfo ) )
					{
						String transDB = userInfo.getTransDB();
						String xmlString = inputString;
						if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
						{
							xmlString = genericUtility.jsonToXMLString( inputString );
						}
						if( checkNull( transDB ).length() > 0 )
						{
							result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams(), userInfo );
						}
						else
						{
							result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams() );
						}
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
					else
					{
						status = "error";
						result = "Event Code not found.";
					}
					eventManager = null;
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : callSystemEvent : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("callSystemEventClient ( /callSystemEvent )", status, result, appId, request, userInfo);
		return result;
	
	}
	
	public String getData(String objName, String refId, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		BaseLogger.log("3",null,null, "Inside getData : E12ExtServiceUtility ");
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getData" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					result = getDetailXMLDomString( objName, "1", "V", refId, null );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getData : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
			/*if(!result.isEmpty())
			{
		        StringBuilder resultSB = new StringBuilder("Response: ");  
		        resultSB.append(result);
		        resultSB.append("\nStatus: ");
		        resultSB.append(status);
		        BaseLogger.log("3",null,null, " variable: resultSB: " + "[" + resultSB + "]" +  "method: getData : class: E12ExtServiceUtility ");
		        result = resultSB.toString();
		        BaseLogger.log("3",null,null, " variable: result1: " + "[" + result + "]" +  "method: getData : class: E12ExtServiceUtility ");
			}*/
		}
		writeAPICallLog("getData ( /getData )", status, result, appId, request, userInfo);
		return result;
	}
	// Changes in getDataClient method on 21-FEB-23 by Gagan B. -- To make getData accessible via both short lived and long lived token. 
	public String getDataClient(String objName, String refId, String tokenId, String enterprise, String dataFormat, String appId, HttpServletRequest request) {
		BaseLogger.log("3", null, null, "Inside getDataClient : E12ExtServiceUtility ");
		String result = "";
		String params = "";
		String status = "error";
		try {
			RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
			params = request.getQueryString();
			BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());

			/*
			 * if ( checkNull( params ).length() == 0 ) { StringBuffer paramString = new
			 * StringBuffer(); paramString.append("OBJ_NAME="+ objName);
			 * paramString.append("&REF_ID="+ refId); paramString.append("&TOKEN_ID="+
			 * tokenId); paramString.append("&DATA_FORMAT="+ dataFormat);
			 * paramString.append("&APP_ID="+ appId ); params = paramString.toString(); }
			 */

			if (checkNull(params).length() == 0) {
				StringBuffer paramString = new StringBuffer();
				paramString.append("/ibase/rest/E12ExtService/getData/").append(objName).append("/").append(enterprise).append("/").append(appId);
				params = paramString.toString();
			}

			BaseLogger.log("3", null, null, "params gsb- " + params);

			ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails(params, null);
			BaseLogger.log("3", null, null, "visionEdiBean : [" + authAppAPIBean + "]");

			if (authAppAPIBean == null) {
				status = "Reject"; // Changes by Jatin M on 17/02/2022 as suggested by Danish sir to change error to Reject
				result = "This service not available";
			} else {
				// Added by Gagan B. : To show this message when blank token ID is passed [START] 
				tokenId = checkNull(tokenId);
				if (tokenId.length() == 0) {
					status = "Reject";
					result = "Blank Token ID passed.";
				// Added by Gagan B. : To show this message when blank token ID is passed [END]
				} else {
					// Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
					// result = validateRequest( request, dataFormat, tokenId );

					result = validateRequest(request, dataFormat, tokenId, true, appId, params);
					BaseLogger.log("3", null, null, "validateRequest - [" + result + "]");

					if ("valid".equalsIgnoreCase(result)) {
						// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
						if (userInfo == null) {
							userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
						}
						if (apiUtility.checkDailyAPILimit(userInfo)) {
							status = "Reject";
							result = "Daily API call limit exceeded";
						} else {
							result = getDetailXMLDomString(objName, "1", "V", refId, null);
							BaseLogger.log("3", null, null, " variable: resultinXML: " + "[" + result + "]" + "method: getDataClient : class: E12ExtServiceUtility ");
							if ("JSON".equalsIgnoreCase(dataFormat)) {
								result = genericUtility.xmlToJSONString(result);
								BaseLogger.log("3", null, null, " variable: resultinJSON: " + "[" + result + "]" + "method: getDataClient : class: E12ExtServiceUtility ");
							}
							status = "success";
						
						}
					} else {
						status = "error";
					}
				}
			}
		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
			// Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			// result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		} finally {
			result = generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
		}
		writeAPICallLog("getExtServiceData ( /getExtServiceData )", status, result, appId, request, userInfo);
		return result;
	}

	
	public String getPopHelpData(String objName, String fieldName, String inputString, String tokenId, String dataFormat, String inputStringAllXml, String formNo,
			String reqParams, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&FIELDNAME="+ fieldName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [START]
				paramString.append("&INPUT_STR_ALL="+ inputStringAllXml);
				paramString.append("&FORM_NO="+ formNo);
				paramString.append("&REQ_PARAMS="+ reqParams);
				//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [END]
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "fieldPophelp" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					fieldName = checkNull( fieldName );
					inputString = checkNull( inputString );
					//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [START]
					inputStringAllXml = checkNull( inputStringAllXml );
					formNo = checkNull( formNo );
					reqParams = checkNull( reqParams );
					//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [END]

					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else if ( fieldName.length() == 0 )
					{
						result = "Please enter valid Field Name.";
						status = "error";
					}
					else
					{
						String xmlString = inputString;
						if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
						{
							xmlString = genericUtility.jsonToXMLString( inputString );
						}
						//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data[start]
						String xmlStringAll = inputStringAllXml;
						if ( "JSON".equalsIgnoreCase( dataFormat ) && inputStringAllXml.length() > 0 )
						{
							xmlStringAll = genericUtility.jsonToXMLString( inputStringAllXml );
						}
						//result = getpopUpKeyStr(objName, fieldName, xmlString, getUserInfo());
						result = getpopUpKeyStr(objName, fieldName, xmlString, getUserInfo(), xmlStringAll, formNo, reqParams);
						//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data[end]
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getPopHelpData : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "fieldPophelp", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getPopHelpData ( /fieldPophelp )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getPopHelpDataClient(String objName, String fieldName, String inputString, String tokenId, String dataFormat, String inputStringAllXml, String formNo,
			String reqParams, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&FIELDNAME="+ fieldName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [START]
				paramString.append("&INPUT_STR_ALL="+ inputStringAllXml);
				paramString.append("&FORM_NO="+ formNo);
				paramString.append("&REQ_PARAMS="+ reqParams);
				//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [END]
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "fieldPophelp" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					fieldName = checkNull( fieldName );
					inputString = checkNull( inputString );
					//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [START]
					inputStringAllXml = checkNull( inputStringAllXml );
					formNo = checkNull( formNo );
					reqParams = checkNull( reqParams );
					//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data [END]

					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else if ( fieldName.length() == 0 )
					{
						result = "Please enter valid Field Name.";
						status = "error";
					}
					else
					{
						String xmlString = inputString;
						if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
						{
							xmlString = genericUtility.jsonToXMLString( inputString );
						}
						//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data[start]
						String xmlStringAll = inputStringAllXml;
						if ( "JSON".equalsIgnoreCase( dataFormat ) && inputStringAllXml.length() > 0 )
						{
							xmlStringAll = genericUtility.jsonToXMLString( inputStringAllXml );
						}
						//result = getpopUpKeyStr(objName, fieldName, xmlString, getUserInfo());
						result = getpopUpKeyStr(objName, fieldName, xmlString, getUserInfo(), xmlStringAll, formNo, reqParams);
						//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data[end]
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("3",null,null, "Exception : getPopHelpData : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "fieldPophelp", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getPopHelpDataClient ( /fieldPophelp )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getBrowData(String objName, String argNames, String argValues, String argTypes, String advQuery, String searchParam, String tokenId,
			String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&ARG_NAMES="+ argNames);
				paramString.append("&ARG_VALUES="+ argValues);
				paramString.append("&ARG_TYPES="+ argTypes);
				paramString.append("&ADV_QRY="+ advQuery);
				paramString.append("&SEARCH_PARAM="+ searchParam);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "objectBrowse" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					argNames = checkNull(argNames);
					argValues = checkNull(argValues);
					argTypes = checkNull(argTypes);
					advQuery = checkNull(advQuery);
					searchParam = checkNull(searchParam);
					String editorId = new SimpleDateFormat("ddMMyyHHmmssSSS").format(new Date());

					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else
					{
						result = getXMLDataForHeader( objName, argValues, argTypes, advQuery, request, searchParam, editorId );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getBrowData : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "objectBrowse", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getBrowData ( /objectBrowse )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getBrowDataClient(String objName, String argNames, String argValues, String argTypes, String advQuery, String searchParam, String tokenId,
			String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&ARG_NAMES="+ argNames);
				paramString.append("&ARG_VALUES="+ argValues);
				paramString.append("&ARG_TYPES="+ argTypes);
				paramString.append("&ADV_QRY="+ advQuery);
				paramString.append("&SEARCH_PARAM="+ searchParam);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "objectBrowse" );
			BaseLogger.log("9",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					argNames = checkNull( argNames );
					argValues = checkNull(argValues );
					argTypes = checkNull( argTypes );
					advQuery = checkNull( advQuery );
					searchParam = checkNull( searchParam );
					String editorId = new SimpleDateFormat("ddMMyyHHmmssSSS").format(new Date());

					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else
					{
						result = getXMLDataForHeader( objName, argValues, argTypes, advQuery, request, searchParam, editorId );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getBrowData : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse( request, "objectBrowse", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getBrowDataClient ( /objectBrowse )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getItemChange(String objName, String transDomStr, String detailDomStr, String domId, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&TRANS_DOM="+ transDomStr);
				paramString.append("&DETAIL_DOM="+ detailDomStr);
				paramString.append("&DOM_ID="+ domId);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "performItemChange" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					transDomStr = checkNull(transDomStr);
					detailDomStr = checkNull(detailDomStr);
					domId = checkNull(domId);

					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else if ( domId.length() == 0 )
					{
						result = "Please enter valid Dom Id.";
						status = "error";
					}
					else if ( transDomStr.length() == 0 )
					{
						result = "Please enter Transaction Dom data.";
						status = "error";
					}
					else if ( detailDomStr.length() == 0 )
					{
						result = "Please enter Detail Dom data.";
						status = "error";
					}
					else
					{
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							if ( transDomStr.length() > 0 )
							{
								transDomStr = genericUtility.jsonToXMLString( transDomStr );
							}
							if ( detailDomStr.length() > 0 )
							{
								detailDomStr = genericUtility.jsonToXMLString( detailDomStr );
							}
						}
						result = getItemChangeData( objName, domId, transDomStr, detailDomStr );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getItemChange : "+ e.getMessage() );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			result = generateResponse( request, "performItemChange", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getItemChange ( /performItemChange )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getItemChangeClient(String objName, String transDomStr, String detailDomStr, String domId, String tokenId, String dataFormat,
			String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&TRANS_DOM="+ transDomStr);
				paramString.append("&DETAIL_DOM="+ detailDomStr);
				paramString.append("&DOM_ID="+ domId);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "performItemChange" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					transDomStr = checkNull(transDomStr);
					detailDomStr = checkNull(detailDomStr);
					domId = checkNull(domId);

					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else if ( domId.length() == 0 )
					{
						result = "Please enter valid Dom Id.";
						status = "error";
					}
					else if ( transDomStr.length() == 0 )
					{
						result = "Please enter Transaction Dom data.";
						status = "error";
					}
					else if ( detailDomStr.length() == 0 )
					{
						result = "Please enter Detail Dom data.";
						status = "error";
					}
					else
					{
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							if ( transDomStr.length() > 0 )
							{
								transDomStr = genericUtility.jsonToXMLString( transDomStr );
							}
							if ( detailDomStr.length() > 0 )
							{
								detailDomStr = genericUtility.jsonToXMLString( detailDomStr );
							}
						}
						result = getItemChangeData( objName, domId, transDomStr, detailDomStr );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getItemChange : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "performItemChange", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getItemChangeClient ( /performItemChange )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getWrkFlwInbox(String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getInbox" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String signStatus = "U";
					String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
					result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getWrkFlwInbox : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getInbox", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getWrkFlwInbox ( /getInbox )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getWrkFlwInboxClient(String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getInbox" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String signStatus = "U";
					String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
					result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getWrkFlwInbox : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getInbox", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getWrkFlwInboxClient ( /getInbox )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getWrkFlwApproved(String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//result = validateRequest( request, dataFormat, tokenId );
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getApproved" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String signStatus = "S";
					String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
					result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getWrkFlwApproved : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getApproved", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getWrkFlwApproved ( /getApproved )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getWrkFlwApprovedClient(String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getApproved" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String signStatus = "S";
					String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
					result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getWrkFlwApproved : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getApproved", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getWrkFlwApprovedClient ( /getApproved )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getWrkFlwRejected(String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getRejected" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String signStatus = "R";
					String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
					result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getWrkFlwRejected : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getRejected", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getWrkFlwRejected ( /getRejected )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getWrkFlwRejectedClient(String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getRejected" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					String signStatus = "R";
					String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
					result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getWrkFlwRejected : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getRejected", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getWrkFlwRejectedClient ( /getRejected )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getSignTransDet(String refSer, String refId, String lineNo, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&LINE_NO="+ lineNo);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getSignTransDet" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					refSer = checkNull( refSer );
					refId = checkNull( refId );
					lineNo = checkNull( lineNo );

					if ( refSer.length() == 0 )
					{
						result = "Please enter valid Ref Series.";
						status = "error";
					}
					else if ( refId.length() == 0 )
					{
						result = "Please enter valid Ref Id.";
						status = "error";
					}
					else if ( lineNo.length() == 0 )
					{
						result = "Please enter valid line No.";
						status = "error";
					}
					else
					{
						int lineNum = Integer.parseInt( lineNo );
						result = getSignTransDetData( refSer, refId, lineNum, getUserInfo() );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getSignTransDet : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getSignTransDet", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getSignTransDet ( /getSignTransDet )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getSignTransDetClient(String refSer, String refId, String lineNo, String tokenId, String dataFormat, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&LINE_NO="+ lineNo);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getSignTransDet" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					refSer = checkNull( refSer );
					refId = checkNull( refId );
					lineNo = checkNull( lineNo );

					if ( refSer.length() == 0 )
					{
						result = "Please enter valid Ref Series.";
						status = "error";
					}
					else if ( refId.length() == 0 )
					{
						result = "Please enter valid Ref Id.";
						status = "error";
					}
					else if ( lineNo.length() == 0 )
					{
						result = "Please enter valid line No.";
						status = "error";
					}
					else
					{
						int lineNum = Integer.parseInt( lineNo );
						result = getSignTransDetData( refSer, refId, lineNum, getUserInfo() );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("3",null,null, "Exception : getSignTransDet : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getSignTransDet", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getSignTransDetClient ( /getSignTransDet )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String updateSignStatusClient(String actionCode, String xmlString, String tokenId, String dataFormat, String uuid,
			String appId, HttpServletRequest request, ServletContext context )
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION_CODE="+ actionCode);
				paramString.append("&XML_STRING="+ xmlString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&UUID="+ uuid);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] Start
			if ( checkNull( uuid ).length() > 0 )
			{
				String condition = "UUID = '" + uuid +"' ";
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
				DBAccessEJB dbAccessEJB = new DBAccessEJB();
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
				String userId = dbAccessEJB.getDBColumnValue("NOTIFICATION_LOG", "USER_ID__TO", condition);
				dbAccessEJB = null;
				if ( checkNull( userId ).length() > 0 )
				{
					result = "valid";
					setUserInfo(getCommonDBAccess().createUserInfo(userId));
				}
				else
				{
					result = "invalid";
				}
				BaseLogger.log("3",null,null,"validateUUId - ["+ result +"]/n UserId:::["+userId+"]");
			}
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] End
			else
			{
				//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
				//result = validateRequest( request, dataFormat, tokenId );
				result = validateRequest( request, dataFormat, tokenId, true, appId, "updateSignStatus" );
				BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			}

			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					actionCode = checkNull( actionCode );
					xmlString = checkNull( xmlString );

					if ( actionCode.length() == 0 )
					{
						result = "Please enter valid Action Code.";
						status = "error";
					}
					else if ( xmlString.length() == 0 )
					{
						result = "Please enter XML Data.";
						status = "error";
					}
					else
					{
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							if ( xmlString.length() > 0 )
							{
								xmlString = genericUtility.jsonToXMLString( xmlString );
							}
						}
						//Change by Sandeep S. on 26-Sep-17 [To resolve issue of accep/reject workflow from push notification ]Start
						result = updateSignStatus( xmlString, actionCode, getUserInfo(), context );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : updateSignStatus : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "updateSignStatus", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("updateSignStatusClient ( /updateSignStatus )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String updateSignStatus(String actionCode, String xmlString, String tokenId, String dataFormat, String uuid,
			String appId, HttpServletRequest request, ServletContext context)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION_CODE="+ actionCode);
				paramString.append("&XML_STRING="+ xmlString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&UUID="+ uuid);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("9",null,null,"params - " + params);
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] Start
			if ( checkNull( uuid ).length() > 0 )
			{
				String condition = "UUID = '" + uuid +"' ";
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
				DBAccessEJB dbAccessEJB = new DBAccessEJB();
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
				String userId = dbAccessEJB.getDBColumnValue("NOTIFICATION_LOG", "USER_ID__TO", condition);
				dbAccessEJB = null;
				if ( checkNull( userId ).length() > 0 )
				{
					result = "valid";
					setUserInfo(getCommonDBAccess().createUserInfo(userId));
				}
				else
				{
					result = "invalid";
				}
				BaseLogger.log("9",null,null,"validateUUId - ["+ result +"]/n UserId:::["+userId+"]");
			}
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] End
			else
			{
				//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
				//result = validateRequest( request, dataFormat, tokenId );
				result = validateRequest( request, dataFormat, tokenId, true, appId, "updateSignStatus" );
				BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			}
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					actionCode = checkNull( actionCode );
					xmlString = checkNull( xmlString );

					if ( actionCode.length() == 0 )
					{
						result = "Please enter valid Action Code.";
						status = "error";
					}
					else if ( xmlString.length() == 0 )
					{
						result = "Please enter XML Data.";
						status = "error";
					}
					else
					{
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							if ( xmlString.length() > 0 )
							{
								xmlString = genericUtility.jsonToXMLString( xmlString );
							}
						}
						//Change by Sandeep S. on 26-Sep-17 [To resolve issue of accep/reject workflow from push notification ]Start
						result = updateSignStatus( xmlString, actionCode, getUserInfo(), context );
						if ( "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.xmlToJSONString( result );
						}
						status = "success";
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : updateSignStatus : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "updateSignStatus", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("updateSignStatus ( /updateSignStatus )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getUserImage(String tokenId, String dataFormat, String appId, HttpServletRequest request, HttpServletResponse response)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getUserImage" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					result = getUserImage( response );
					if ( "success".equalsIgnoreCase( result ) )
			        {
			        	status = "success";
			        }
			        else
			        {
			        	status = "error";
			        }
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getUserImage : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getUserImage", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getUserImage ( /getUserImage )", status, result, appId, request, userInfo);
		return result;
	
	}
	
	public String getUserImageClient(String tokenId, String dataFormat, String appId, HttpServletRequest request, HttpServletResponse response)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getUserImage" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					result = getUserImage( response );
					if ( "success".equalsIgnoreCase( result ) )
			        {
			        	status = "success";
			        }
			        else
			        {
			        	status = "error";
			        }
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getUserImageClient : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getUserImage", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getUserImage ( /getUserImageClient )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String getAttachDocument(String objName, String refSer, String refId, String docType, String tokenId, String dataFormat,
			String appId, HttpServletRequest request, HttpServletResponse response)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&DOC_TYPE="+ docType);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getAttachDocument" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					refSer = checkNull( refSer );
					if ( refSer.length() == 0 )
					{
						// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
						// DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
						DBAccessEJB dbAccessEJB = new DBAccessEJB();
						// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
						refSer = dbAccessEJB.getRefSer( null, objName, getUserInfo() );
						dbAccessEJB = null;
					}

					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else if ( refId.length() == 0 )
					{
						result = "Please enter valid Ref Id.";
						status = "error";
					}
					else
					{
						result = getAttachDocument( refId, refSer, docType, response );
				        if ( "success".equalsIgnoreCase( result ) )
				        {
				        	status = "success";
				        }
				        else
				        {
				        	status = "error";
				        }
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getAttachDocument : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getAttachDocument", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getAttachDocument ( /getAttachDocument )", status, result, appId, request, userInfo);
		return result;
	
	}
	
	public String getAttachDocumentClient(String objName, String refSer, String refId, String docType, String tokenId, String dataFormat,
			String appId, HttpServletRequest request, HttpServletResponse response)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&DOC_TYPE="+ docType);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, dataFormat, tokenId );
			result = validateRequest( request, dataFormat, tokenId, true, appId, "getAttachDocument" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					objName = checkNull( objName );
					refSer = checkNull( refSer );
					if ( refSer.length() == 0 )
					{
						// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
						//DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
						DBAccessEJB dbAccessEJB = new DBAccessEJB();
						// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
						refSer = dbAccessEJB.getRefSer( null, objName, getUserInfo() );
						dbAccessEJB = null;
					}
					if ( objName.length() == 0 )
					{
						result = "Please enter valid Object Name.";
						status = "error";
					}
					else if ( refId.length() == 0 )
					{
						result = "Please enter valid Ref Id.";
						status = "error";
					}
					else
					{
				        result = getAttachDocument( refId, refSer, docType, response );
				        if ( "success".equalsIgnoreCase( result ) )
				        {
				        	status = "success";
				        }
				        else
				        {
				        	status = "error";
				        }
					}
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getAttachDocumentClient : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			result = generateResponse( request, "getAttachDocument", params, tokenId, dataFormat, status, result );
		}
		writeAPICallLog("getAttachDocumentClient ( /getAttachDocument )", status, result, appId, request, userInfo);
		return result;
	
	}
	
	public String keepSessionAlive(String tokenId, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//result = validateRequest( request, "JSON", tokenId );
			result = validateRequest( request, "JSON", tokenId, true, appId, "keepAlive" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					if ( getUserInfo() != null )
					{
						result = getUserInfo().getDesignation()+":"+getUserInfo().getDivision()+":"+getUserInfo().getSiteCode()+":"+getUserInfo().getDateJoin()+":"+getUserInfo().getEmpName()+":"+getUserInfo().getEmpCode();
					}
					else
					{
						result = "";
					}
					status = "success";
				
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : keepAlive : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, "JSON");
		}
		finally
		{
			result = generateResponse( request, "keepAlive", params, tokenId, "JSON", status, result );
		}
		writeAPICallLog("keepSessionAlive ( /keepAlive )", status, result, appId, request, userInfo);
		return result;
	}
	
	public String keepSessionAliveClient(String tokenId, String appId, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			//result = validateRequest( request, "JSON", tokenId );
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			result = validateRequest( request, "JSON", tokenId, true, appId, "keepAlive" );
			BaseLogger.log("3",null,null,"validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				// Changes by Gagan B. on 11-08-23 [for checking daily API limit]
				if (userInfo == null) {
					// 	userInfo = commonDBAccessEJB.createUserInfo(userCode);
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenId);
				}
				if (apiUtility.checkDailyAPILimit(userInfo)) {
					status = "Reject";
					result = "Daily API call limit exceeded";
				} else {
					if ( getUserInfo() != null )
					{
						result = getUserInfo().getDesignation()+":"+getUserInfo().getDivision()+":"+getUserInfo().getSiteCode()+":"+getUserInfo().getDateJoin()+":"+getUserInfo().getEmpName()+":"+getUserInfo().getEmpCode();
					}
					else
					{
						result = "";
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : keepAlive : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, "JSON");
		}
		finally
		{
			result = generateResponse( request, "keepAlive", params, tokenId, "JSON", status, result );
		}
		writeAPICallLog("keepSessionAliveClient ( /keepAlive )", status, result, appId, request, userInfo);
		return result;
	
	}
	
	public String upload(HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			result = uploadDocument( request );
			status = "success";
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : uploadDocument : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, "JSON");
		}
		finally
		{
			result = generateResponse( request, "uploadDocument", params, "", "JSON", status, result );
		}
		writeAPICallLog("upload ( /uploadDocument )", status, result, null, request, userInfo);
		return result;
	
	}
	
	public String getDocument(String docId, String userInfoStr, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		byte[] docArr = {0};
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);
			userInfoStr = checkNull( userInfoStr );
			if ( userInfoStr != null && userInfoStr.length() > 0 )
			{
				userInfo = new UserInfoBean( userInfoStr );
			}
			//DocumentHandlerWrapperRemote docHandler = (DocumentHandlerWrapperRemote) getInitialContext().lookup( "ibase/DocumentHandlerWrapperEJB/remote" );
			DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
			docArr = docHandler.getDocument( docId, getUserInfo() );
			docHandler = null;

			status = "success";
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getDocument : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, "JSON");
		}
		finally
		{
			result = generateResponse( request, "getDocument", params, "", "JSON", status, result );
		}
		writeAPICallLog("getDocument ( /getDocument )", status, result, null, request, userInfo);
		return result;
	
	}
	
	public String deleteDocument(String docId, String refId, String refSer, String refCol, String objName, String userInfoStr, HttpServletRequest request)
	{
		String result = "";
		String params = "";
		String status = "error";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				params = paramString.toString();
			}
			BaseLogger.log("3",null,null,"params - " + params);

			userInfoStr = checkNull( userInfoStr );
			if ( userInfoStr != null && userInfoStr.length() > 0 )
			{
				userInfo = new UserInfoBean( userInfoStr );
			}
			//DocumentHandlerWrapperRemote docHandler = (DocumentHandlerWrapperRemote) getInitialContext().lookup( "ibase/DocumentHandlerWrapperEJB/remote" );
			DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
			result = docHandler.removeAttach( docId, refSer, refId, objName, refCol, getUserInfo() );
			docHandler = null;

			status = "success";
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : deleteDocument : "+ e.getMessage() );
			status = "exception";
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, "JSON");
		}
		finally
		{
			result = generateResponse( request, "deleteDocument", params, "", "JSON", status, result );
		}
		writeAPICallLog("deleteDocument ( /deleteDocument )", status, result, null, request, userInfo);
		return result;
	}
	
	public JSONObject getAppsurveyInfo(@QueryParam("USER_ID") String userId, @QueryParam("APP_ID") String appId,
			@QueryParam("EASE_USE") String easeUse, @QueryParam("FUNC_COVERED") String funcCovered, @QueryParam("PERFORMANCE") String performance,
			@QueryParam("FEEDBACK") String feedback ) throws JSONException
	{
		JSONObject resultJSON = new JSONObject();
		String result = "";
		String status = "";
		try
		{
			BaseLogger.log("3",null,null,"USER_ID:[ "+userId+" ]\nAPP_ID:[ "+appId+"] \nEASE_USE:[ "+easeUse+" ]");

			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
			DBAccessEJB dbAccessEJB = new DBAccessEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			result = dbAccessEJB.getUserFeedbackOnAppsurvey(userId, appId, easeUse, funcCovered, performance, feedback);
			dbAccessEJB = null;
			BaseLogger.log("3",null,null,"Result::[ "+result+" ]");
			status = "sucess";
			resultJSON.put("result", status);
			resultJSON.put("message", result);
		}
		catch(Exception ae){
			result = "Exception: "+ae.getMessage();
			status = "exception";
			resultJSON.put("result", status);
			resultJSON.put("message", result);
			ae.printStackTrace();
			BaseLogger.log("0",null,null,"[POST]Exception in getAppsurveyInfo method:: "+ae.getMessage());
		}
		writeAPICallLog("getAppsurveyInfo ( /getAppSurvey )", status, result, null, requestGlobal, userInfo);
		return resultJSON;
	}
	
	public JSONObject getAppsurveyInformation(String userId, String appId, String easeUse, String funcCovered, String performance, String feedback ) throws JSONException
	{
		JSONObject resultJSON = new JSONObject();
		String result = "";
		String status = "";
		try{
			BaseLogger.log("3",null,null,"USER_ID:[ "+userId+" ]\nAPP_ID:[ "+appId+"] \nEASE_USE:[ "+easeUse+" ]");

			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//DBAccessRemote dbAccessEJB = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
			DBAccessEJB dbAccessEJB = new DBAccessEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			result = dbAccessEJB.getUserFeedbackOnAppsurvey(userId, appId, easeUse, funcCovered, performance, feedback);
			dbAccessEJB = null;
			BaseLogger.log("3",null,null,"Result::[ "+result+" ]");
			status = "success";
			resultJSON.put("result", status);
			resultJSON.put("message", result);
		}
		catch(Exception ae){
			result = "Exception: "+ae.getMessage();
			status = "exception";
			resultJSON.put("result", status);
			resultJSON.put("message", result);
			ae.printStackTrace();
			BaseLogger.log("0",null,null,"[POST]Exception in getAppsurveyInfo method:: "+ae.getMessage());
		}
		writeAPICallLog("getAppsurveyInformation ( /getAppSurvey )", status, result, null, requestGlobal, userInfo);
		return resultJSON;
	}
	
	public JSONObject saveAnnoataionData(String userId, String docId, String annotationData, HttpServletRequest request)
	{
		String result = null;
		JSONObject resultJson = null;
		String newAnnotatedData = null;
		DBAccessEJB dbAccessEJB = null;
		boolean status = false;
		try
		{
			docId = checkNull( docId );
			userId = checkNull( userId );
			annotationData = checkNull( annotationData );

			resultJson = new JSONObject();
			if( docId.trim().length() == 0 )
			{
				result = "ERROR: DOC ID is null.";
			}
			if( userId.trim().length() == 0 )
			{
				result = "ERROR: USER ID is null.";
			}
			if( annotationData.trim().length() == 0 )
			{
				result = "ERROR: Annotation Data is null.";
			}
			else
			{
				dbAccessEJB = new DBAccessEJB();
				String condition = "CODE = '"+userId+"'";
				String verifyUser = dbAccessEJB.getDBColumnValue("USERS", "CODE", condition);
				if( verifyUser != null && verifyUser.length() > 0)
				{
					this.userInfo = dbAccessEJB.createUserInfo(userId);
					BaseLogger.log("2", null, "saveAnnoataionData", "this.userInfo:["+this.userInfo+"]");

					if( this.userInfo != null )
					{
						newAnnotatedData = annotationData;
						result = new DocumentHandlerWrapperEJB().saveAnnotationData(docId, newAnnotatedData, this.userInfo);
						BaseLogger.log("2", null, "saveAnnoataionData", "result:["+result+"]");
						if(result.equalsIgnoreCase("success"))
						{
							status = true;
							result = "Annotation Data Saved Successfully.";
						}
						else
						{
							result = "EXCEPTION: "+result;
						}
					}
				}
				else
				{
					result = "ERROR: Invalid User.";
				}
			}
			resultJson.put("status", String.valueOf(status));
			resultJson.put("message", result);
			return resultJson;
		}
		catch (Exception e)
		{
			try
			{
				resultJson.put("status", String.valueOf(status));
				result = "EXCEPTION: "+e.getMessage();
				resultJson.put("message", result);
			}
			catch(JSONException jse)
			{
				jse.printStackTrace();
			}
			e.printStackTrace();
			writeAPICallLog("saveAnnoataionData ( /saveAnnotationData )", String.valueOf(status), result, null, request, userInfo);
			return resultJson;
		}
	}
	
	public JSONObject uploadCaptureImage(HttpServletRequest request)
	{
		String refId = null;
		File DUMP_DIR = null;
		String result = null;
		String refSer = null;
		String userId = null;
		String objName = null;
		String dirName = null;
		String fileName = null;
		String newfileName = null;
		String docAttachType = null;
		JSONObject resultJson = new JSONObject();
		boolean status = false;
		try
		{
			BaseLogger.log("3",null,null,"[uploadCaptureImage] method called::[ "+request+" ]");
			BaseLogger.log("3",null,null,"[uploadCaptureImage method session is::= "+request.getSession());

			//if(request != null && request.getSession() != null && request.getSession().getAttribute("USER_INFO") != null)
			if( request != null && request.getSession() != null )
			{
				this.userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");					
				BaseLogger.log("3",null,null,"[uploadCaptureImage] userInfo is::= "+this.userInfo );

				BaseLogger.log("3",null,null,"[uploadCaptureImage] isMultipartContent::[ "+ServletFileUpload.isMultipartContent(request)+" ]");
				if( ServletFileUpload.isMultipartContent(request) )
				{
					dirName = new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent()+ File.separator + "dump";
					DUMP_DIR = new File(dirName);
					if(!DUMP_DIR.exists())
					{
						DUMP_DIR.mkdirs();
					}

					int MEMORY_THRESHOLD   = 1024 * 1024 * 3;  // 3MB
					int MAX_FILE_SIZE      = 1024 * 1024 * 700; // 700MB
					int MAX_REQUEST_SIZE   = 1024 * 1024 * 710; // 710MB

					DiskFileItemFactory factory = new DiskFileItemFactory();
					factory.setSizeThreshold( MEMORY_THRESHOLD );
					factory.setRepository( new File( System.getProperty("java.io.tmpdir")) );

					ServletFileUpload upload = new ServletFileUpload(factory);
					upload.setFileSizeMax( MAX_FILE_SIZE );
					upload.setSizeMax( MAX_REQUEST_SIZE );

					List<FileItem> formItems = upload.parseRequest(request);
					if( formItems != null && formItems.size() > 0 )
					{
						for(FileItem item : formItems)
						{
							String fieldName = item.getFieldName();
							if( item.isFormField() )
							{
								String fieldValue = item.getString();
								if("OBJ_NAME".equalsIgnoreCase( fieldName )) { objName = fieldValue; }
								else if("REF_ID".equalsIgnoreCase( fieldName )) { refId = fieldValue; }
								else if("REF_SER".equalsIgnoreCase( fieldName )) { refSer = fieldValue; }
								else if("filename".equalsIgnoreCase( fieldName )) { fileName = fieldValue; }
								else if("DOC_TYPE_ATTACH".equalsIgnoreCase( fieldName ) ) { docAttachType = fieldValue; }
								else if("USER_ID".equalsIgnoreCase( fieldName ))
								{
									userId = fieldValue;
									if( this.userInfo == null)
										this.userInfo = new DBAccessEJB().createUserInfo(userId);
								}
							}
							else if ( !item.isFormField() )
							{
								newfileName = new File( item.getName() ).getName();
								String newfilePath = DUMP_DIR + File.separator + newfileName;
								File storeFile = new File( newfilePath );
								item.write( storeFile );
							}
						}
					}
					if( newfileName != null )
					{
						DocumentHandlerRemote docHandler = new DocumentHandlerEJB();
						String filePath = dirName + File.separator + fileName;
						File file = new File( filePath );
						String retXMLStringBuff = getAttachmentDetailStr(objName, refSer, refId, filePath, file, getUserInfo());
						if(retXMLStringBuff.indexOf("Exception") == -1)//No exception occurred
						{
							FileInputStream input = new FileInputStream( file );
							BufferedInputStream bfr = new BufferedInputStream( input );
							ByteArrayOutputStream bout = new ByteArrayOutputStream();
							int i = -1;
							while( (i = bfr.read())!= -1 )
							{
								bout.write( i );
							}
							byte[] byteArray = bout.toByteArray();
							byte[] previewImage = { 0 };
							String retString = docHandler.addDocument(retXMLStringBuff, byteArray, previewImage, getUserInfo());
							if( retString != null && retString.trim().length() > 0)
							{
								String chgTerm = getUserInfo().getRemoteHostName();
								if( chgTerm != null && chgTerm.length() > 15 )
								{
									chgTerm = chgTerm.substring(0, 15);
								}
								else if( chgTerm == null || chgTerm.length() == 0 )
								{
									chgTerm = userInfo.getRemoteHost();
								}
								AuditTrailExtEJB auditTrailExtEJB = new AuditTrailExtEJB();
								String auditTranId = auditTrailExtEJB.saveActionPerformedInAudit(objName, refId, "UPLOAD_ATTACHMENT", "UPLOAD_ATTACHMENT", 	getUserInfo().getLoginCode(), chgTerm, getUserInfo().getTransDB(), getUserInfo());
								auditTrailExtEJB.updateAuditResponse( auditTranId, "Success", retString , userInfo );

								ArrayList<String> userIdList = new ArrayList<String>();
								userIdList.add( getUserInfo().getLoginCode() );
								sendWebSocketNotification(retString, docAttachType, userIdList, fileName, WebSocketMessageType.UPLOAD_DELEGATE);
								status = true;
								result = "successfully Uploaded Cropper Image.";
							}
							else
							{
								result = "No Response DATA Found.";
							}
						}
					}
				}
				else
				{
					result = "Error: Form must has enctype=multipart/form-data.";
				}
			}
			else
			{
				result ="Error: Invalid Request.";
			}
			resultJson.put("status", String.valueOf(status));
			resultJson.put("message", result);
			BaseLogger.log("2", null,  null, "{uploadCaptureImage method} result::[ "+resultJson.toString()+" ]" );
			return resultJson;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			result = "EXCEPTION:: "+e.getMessage();
			try
			{
				resultJson.put("status", String.valueOf(status));
				resultJson.put("message", result);
			}
			catch (JSONException jsonEx)
			{
				jsonEx.printStackTrace();
				BaseLogger.log("0",null,null,"[POST]JSONException in uploadCaptureImage method:: "+jsonEx.getMessage());
			}
			BaseLogger.log("0", null,  null, "{uploadCaptureImage method} Exception result::[ "+resultJson.toString()+" ]" );
			writeAPICallLog("uploadCaptureImage ( /uploadCaptureImage )", String.valueOf(status), result, null, request, userInfo);
			return resultJson;
		}
	
	}
	
	//Added by Umakanta Das on 05/MAY/2017 [ A16LSUN004 ] [ Receive request from third party mobile app and return Pay slip data with json format ]Start
	
	public String getPaySlipDataClient(String userCode, String password, String isPwdEncrypt, String dataFormat, String apiUrl, String token, String guid,  
		String apIPwd, String imei, String appId, String projectName, HttpServletRequest request) throws JSONException, ITMException, SQLException
	{
		JSONObject responseJson = new JSONObject();
		JSONObject resultJson = new JSONObject();
		HashMap empInfoListMap = new HashMap();
		ConnDriver connDriver =  new ConnDriver();
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rst = null;
		String result = "";
		String params = "";
		String sql = "";
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USERCODE="+ userCode);
				paramString.append("&PASSWORD="+ password);
				paramString.append("&ISPWDENCRYPT="+ isPwdEncrypt);
				paramString.append("&DATAFORMAT="+ dataFormat);
				paramString.append("&URL="+ apiUrl);
				paramString.append("&Token="+ token);
				paramString.append("&APIPwd="+ apIPwd);
				paramString.append("&GUID="+ guid);
				paramString.append("&IMEI="+ imei);
				paramString.append("&AppID="+ appId);
				paramString.append("&ProjectName="+ projectName);
				params = paramString.toString();

			}
			BaseLogger.log("3",null,null,"params - " + params);
			/*if ( request.isSecure() )
			{*/
				userCode =   checkNull( userCode );
				password =  checkNull( password ) ;
				isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
				if ( "true".equalsIgnoreCase(isPwdEncrypt ) )
				{
					userCode =  decrypt( userCode );
					password = decrypt( password );
				}
				dataFormat = checkNull( dataFormat );
				apiUrl = checkNull( apiUrl );
				token = checkNull( token );
				apIPwd = checkNull( apIPwd );
				guid = checkNull( guid );
				imei = checkNull( imei );
				appId = checkNull( appId );
				projectName = checkNull( projectName );

				String isValidLogin = "false";

				if ( isValidDataFormat( dataFormat ) )
				{
					if ( userCode.length() > 0 )
					{
						isValidLogin = getAuthStatus( request, userCode, password, "", "I", "false" );
						if ( "VALID".equalsIgnoreCase( isValidLogin ) )
						{
							conn = connDriver.getConnectDB( getUserInfo().getTransDB() );
							conn.setAutoCommit( false );
							String empCode = "";
							String periodCode = "";
							String year = "";
							String mongth = "";
							String resStatus = "";
							String remarks = "";
							String empcodeDB = "";
							String deptDescr = "";
							String empName = "";
							String addr1 = "";
							String addr2 = "";
							String addr3 = "";
							String city = "";
							String curPin = "";
							String bnkName = "";
							String bnkAcNo = "";
							String empSite = "";
							String finentity = "";
							String prtSeq1 = "";
							String adCode1 = "";
							String lveCode = "";
							String logo = "";
							String desgn = "";
							String location = "";
							String status = "";
							String bankDet = "";
							String paytable = "";
							String grades = "";
							String cadre = "";
							String paysite = "";
							String panNo = "";
							String shDescr = "";
							String shDescr1 = "";
							String adCode = "";
							String prtSeq = "";
							String emppfno = "";
							String remark = "";
							String payMode = "";
							String headQtr = "";
							String periodDescr = "";
							String code = "";
							String propdays = "";


							int empCnt = 0;
							int empCntResign = 0;

							double amt = 0.0d;
							double amtBal1 = 0.0d;
							double avalidlve = 0.0d;
							double balLve = 0.0d;
							double workDays = 0.0d;
							double woffDays = 0.0d;
							double paidDays = 0.0d;
							double absdays = 0.0d;
							double totEarn = 0.0d;
							double totDedu = 0.0d;
							double netPaid = 0.0d;
							double mrndoff = 0.0d;
							double projAmt = 0.0d;
							double payAmt = 0.0d;
							double diffAmt = 0.0d;
							double totaldays = 0.0d;;
							double lwp = 0.0d;;

							request.getSession().setAttribute( "USER_INFO", getUserInfo() );
							JSONObject resultDtlJson = new JSONObject();
							resultDtlJson.put( "Token", token );
							try
							{
								StringBuffer responseBuff = new StringBuffer();
								JSONObject paySlipServiceReqJson = new JSONObject();
								paySlipServiceReqJson.put( "Token", token );
								paySlipServiceReqJson.put( "APIPwd", apIPwd );
								paySlipServiceReqJson.put( "GUID", guid );
								paySlipServiceReqJson.put( "IMEI", imei );
								paySlipServiceReqJson.put( "AppID", appId );
								paySlipServiceReqJson.put( "ProjectName", projectName );
								URL url = new URL( apiUrl );
								HttpURLConnection urlConn = ( HttpURLConnection ) url.openConnection();
								urlConn.setRequestMethod("POST");
								urlConn.setDoInput(true);
								urlConn.setDoOutput(true);
								urlConn.setRequestProperty("Content-Type", "application/json");
								OutputStream outputStream = (urlConn.getOutputStream());
								outputStream.write( paySlipServiceReqJson.toString().getBytes() );
								outputStream.flush();
								outputStream.close();
								/*if (urlConn.getResponseCode() != 200)
									{
										throw new RuntimeException("Failed : HTTP error code : ["+ urlConn.getResponseCode()+"]");
									}*/
								BufferedReader br = new BufferedReader( new InputStreamReader( ( urlConn.getInputStream() ) ) );
								String output = "";
								BaseLogger.log("3",null,null,"Output from Server .... \n");
								while ( ( output = br.readLine() ) != null )
								{
									responseBuff.append( output );
								}
								JSONObject paySlipServiceResJson = new JSONObject( responseBuff.toString() );
								empCode = checkNull( paySlipServiceResJson.getJSONObject("d").getString("MetisCode") );
								year = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Year") );
								mongth = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Month") );
								periodCode = year+mongth;
								resStatus = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Status") );
								remarks = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Remarks") );

								if ( urlConn != null )
								{
									urlConn.disconnect();
								}
							}
							catch (MalformedURLException e)
							{
								e.printStackTrace();

							}
							catch (IOException e)
							{
								e.printStackTrace();
							}

							if ( "Success".equalsIgnoreCase( resStatus ) )
							{
								if ( empCode.length() > 0 )
								{
									sql = " SELECT COUNT(*) AS EMP_COUNT FROM EMPLOYEE WHERE EMP_CODE = ? ";
									pStmt = conn.prepareStatement( sql );
									pStmt.setString( 1 , empCode );
									rst = pStmt.executeQuery();
									if( rst.next() )
									{
										empCnt = rst.getInt("EMP_COUNT");
									}
									if ( rst != null )
									{
										rst.close();
										rst = null;
									}
									if ( pStmt != null )
									{
										pStmt.close();
										pStmt = null;
									}

									if ( empCnt > 0 )
									{
										sql = " SELECT COUNT(*) AS EMP_COUNT__RESIGN FROM EMPLOYEE WHERE EMP_CODE = ? AND RELIEVE_DATE IS NULL ";
										pStmt = conn.prepareStatement( sql );
										pStmt.setString( 1 , empCode );
										rst = pStmt.executeQuery();
										if( rst.next() )
										{
											empCntResign = rst.getInt("EMP_COUNT__RESIGN");
										}
										if ( rst != null )
										{
											rst.close();
											rst = null;
										}
										if ( pStmt != null )
										{
											pStmt.close();
											pStmt = null;
										}

										if ( empCntResign > 0 )
										{
											sql = "";
											sql = " SELECT EMPLOYEE.EMP_CODE empcode,DEPARTMENT.SH_DESCR deptDescr,"//EMPLOYEE.EMP_CODE, "//EMP_CODE should be remove TODO
													+" EMPLOYEE.NAME_PREFIX || ' ' || TRIM(EMPLOYEE.EMP_FNAME) || ' ' || "
													+" TRIM(EMPLOYEE.EMP_MNAME) || ' ' || TRIM(EMPLOYEE.EMP_LNAME) "
													+" AS EMP_NAME,employee.cur_add1 addr1, employee.cur_add2 addr2, "
													+" NVL(employee.cur_add3,'') addr3,EMPLOYEE.CUR_CITY city,"
													+" EMPLOYEE.CUR_PIN pin,STATE.DESCR state, "
													+" BANK.BANK_NAME bnkName,EMPLOYEE.BANK_ACCT bnkAcNo,PAYROLL.SITE_CODE__WORK empSite, "
													+" SITE.FIN_ENTITY finentity, "
													+" (select VAR_VALUE from payrparm where var_name = 'LOGO_PATH' AND PRD_CODE =	'999999') || trim(SITE.FIN_ENTITY)||'.gif' AS LOGO, "
													+" PAYROLL.WORK_DAYS workdays, PAYROLL.PAID_DAYS paiddays,PAYROLL.WOFF_DAYS woffdays,PAYROLL.ABS_DAYS absdays,"
													+" PAYROLL.REMARKS remarks,EMPLOYEE.PAY_MODE payMode,PAYROLL.DESIGNATION desgn,"
													+" STATION.DESCR HQ,PERIOD.DESCR periodDescr, PERIOD.code,GENCODES.descr location, "
													+" (case when EMPLOYEE.CONFIRMED = 'Y' then 'CONFIRMED' when EMPLOYEE.PROBATION = 'Y' then 'PROBATION' else 'TRAINEE' end) status, "
													+" ddf_company_pf(payroll.site_code__pay,employee.pf_no) AS emppfno, "
													+" ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','EARN')) AS as_mtot_earn, "
													+" ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','DEDN')) AS as_mtot_dedu, "
													+" ddf_payslip_payroll( ? , employee.emp_code, HRAPPL_GET_ENV('999999','NETWR')) AS as_mnetpaid, "
													+" ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','RNDOFF_AD')) AS as_mrndoff, "
													+" ddf_bank_details(employee.emp_code,payroll.voucher_no) AS as_bank_det, "
													+" PAYROLL.PAY_TABLE AS as_paytable,PAYROLL.grade AS as_grades,PAYROLL.cadre AS as_cadre, "
													+" PAYROLL.SITE_CODE__WORK AS as_paysite, "
													+" employee.it_no AS PAN_NO "
													+" FROM PERIOD,EMPLOYEE,PAYROLL,DEPARTMENT,SITE,BANK,STATE,STATION,GENCODES "
													+" WHERE PAYROLL.PRD_CODE = PERIOD.CODE "
													+" AND PAYROLL.EMP_CODE = EMPLOYEE.EMP_CODE "
													+" AND department.dept_code(+) = payroll.dept_code "
													+" AND site.site_code = payroll.site_code__pay "
													+" AND bank.bank_code(+) = employee.bank_code "
													+" AND state.state_code(+) = employee.cur_state "
													+" AND station.stan_code(+) = employee.stan_code__hq "
													+" AND PERIOD.CODE = ? "
													+" AND EMPLOYEE.EMP_CODE = ? "
													+" AND PAYROLL.VOUCHER_NO IS NOT NULL "
													+" AND gencodes.fld_name(+) = 'GEO_LOC' "
													+" AND gencodes.mod_name(+) = 'X' "
													+" AND gencodes.fld_value(+) = site.geo_loc ";
											//" AND ddf_hr_sal_bonus_display( $P{as_empcode},$P{as_sal_period},$P{as_user_id},'SSEMP' ) = 'Y' ";
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , periodCode );
											pStmt.setString( 3 , periodCode );
											pStmt.setString( 4 , periodCode );
											pStmt.setString( 5 , periodCode );
											pStmt.setString( 6 , empCode );
											rst = pStmt.executeQuery();
											if ( rst.next() )
											{
												empcodeDB = checkNull( rst.getString("empcode") );
												deptDescr = checkNull( rst.getString("deptDescr") );
												empName = checkNull( rst.getString("EMP_NAME") );
												addr1 = checkNull( rst.getString("addr1") );
												addr2 = checkNull( rst.getString("addr2") );
												addr3 = checkNull( rst.getString("addr3") );
												city = checkNull( rst.getString("city") );
												curPin = checkNull( rst.getString("pin") );
												bnkName = checkNull( rst.getString("bnkName") );
												bnkAcNo = checkNull( rst.getString("bnkAcNo") );
												empSite = checkNull( rst.getString("empSite") );
												finentity = checkNull( rst.getString("finentity") );
												logo = checkNull( rst.getString("LOGO") );
												workDays =  rst.getDouble("workdays");
												paidDays =  rst.getDouble("paiddays");
												woffDays =  rst.getDouble("woffdays");
												absdays =  rst.getDouble("absdays");
												remark = checkNull( rst.getString("remarks") );
												payMode = checkNull( rst.getString("payMode") );
												desgn = checkNull( rst.getString("desgn") );
												headQtr = checkNull( rst.getString("HQ") );
												periodDescr = checkNull( rst.getString("periodDescr") );
												code = checkNull( rst.getString("code") );
												location = checkNull( rst.getString("location") );
												status = checkNull( rst.getString("status") );
												emppfno =  checkNull( rst.getString("emppfno") );
												totEarn = rst.getDouble("as_mtot_earn");
												totDedu = rst.getDouble("as_mtot_dedu");
												netPaid = rst.getDouble("as_mnetpaid");
												mrndoff =  rst.getDouble("as_mrndoff");
												bankDet = checkNull( rst.getString("as_bank_det") );
												paytable = checkNull( rst.getString("as_paytable") );
												grades = checkNull( rst.getString("as_grades") );
												cadre = checkNull( rst.getString("as_cadre") );
												paysite = checkNull( rst.getString("as_paysite") );
												panNo = checkNull( rst.getString("PAN_NO") );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}
											//Modified by Umakanta Das on 06-JUN-2017[]Start
											Attd_eSalarySlip attdeSalarySlip = new Attd_eSalarySlip();
											propdays = checkNull( attdeSalarySlip.getPropDays( periodCode, "Y", empCode, paytable, grades, cadre, paysite  ) );
											totaldays = Double.parseDouble( propdays );
											//Modified by Umakanta Das on 06-JUN-2017[]Start
											lwp = totaldays - paidDays;
											//empInfoListMap.put( "Token", token );
											empInfoListMap.put( "EMP_CODE", empcodeDB );
											empInfoListMap.put( "DEPT_DESCR", deptDescr );
											empInfoListMap.put( "EMP_NAME", empName );
											empInfoListMap.put( "ADDR1", addr1 );
											empInfoListMap.put( "ADDR2", addr2 );
											empInfoListMap.put( "ADDR3", addr3 );
											empInfoListMap.put( "CITY", city );
											empInfoListMap.put( "PIN", curPin );
											empInfoListMap.put( "BNK_NAME", bnkName );
											empInfoListMap.put( "BNK_AC__NO", bnkAcNo );
											empInfoListMap.put( "EMP_SITE", empSite );
											empInfoListMap.put( "FINENTITY", finentity );
											empInfoListMap.put( "LOGO", logo );
											empInfoListMap.put( "WORK_DAYS", workDays );
											empInfoListMap.put( "PAID_DAYS", paidDays );
											empInfoListMap.put( "WOFF_DAYS", woffDays );
											empInfoListMap.put( "ABS_DAYS", absdays );
											//Modified by Umakanta Das on 06-JUN-2017[]Start
											empInfoListMap.put( "TOTAL_DAYS", totaldays );
											empInfoListMap.put( "LWP", lwp );
											//Modified by Umakanta Das on 06-JUN-2017[]End
											empInfoListMap.put( "REMARK", remark );
											empInfoListMap.put( "PAY_MODE", payMode );
											empInfoListMap.put( "DESGN", desgn );
											empInfoListMap.put( "HQ", headQtr );
											empInfoListMap.put( "PERIOD_DESCR", periodDescr );
											empInfoListMap.put( "CODE", code );
											empInfoListMap.put( "LOCATION", location );
											empInfoListMap.put( "STATUS", status );
											empInfoListMap.put( "EMP_PF__NO", emppfno );
											empInfoListMap.put( "MRND_OFF", mrndoff );
											empInfoListMap.put( "BANK_DET", bankDet );
											empInfoListMap.put( "PAY_TABLE", paytable );
											empInfoListMap.put( "GRADES", grades );
											empInfoListMap.put( "CADRE", cadre );
											empInfoListMap.put( "PAY_SITE", paysite );
											empInfoListMap.put( "PAN_NO", panNo );

											resultDtlJson.put( "EMPLOYEE_INFO", empInfoListMap );
											resultDtlJson.put( "TOTAL_EARNINGS", totEarn );
											resultDtlJson.put( "TOTAL_DEDUCATION", totDedu );
											resultDtlJson.put( "NET_PAID", netPaid );

											ArrayList deductionList = new ArrayList();
											sql = "";
											sql = " SELECT ALLWDEDN.SH_DESCR sh_descr,PAYARR_DET.AMOUNT amt,ALLWDEDN.PRT_SEQ prt1_seq,ALLWDEDN.AD_CODE ad1_code, "
													+" PAYARR_DET.AMT_BAL amt1_bal "
													+" FROM PAYARR_DET,ALLWDEDN "
													+" WHERE ALLWDEDN.AD_CODE = PAYARR_DET.AD_CODE "
													+" AND payarr_det.prd_code = ? "
													+" AND payarr_det.emp_code = ? "
													+" AND payarr_det.payable = 'D' AND payarr_det.amount != 0 AND payarr_det.ad_code != 'ROFF' "
													+" ORDER BY prt1_seq,sh_descr ";
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , empCode );
											rst = pStmt.executeQuery();
											while ( rst.next() )
											{
												shDescr = checkNull( rst.getString("sh_descr") );
												amt = rst.getDouble("amt");
												prtSeq1 = checkNull( rst.getString("prt1_seq") );
												adCode1 = checkNull( rst.getString("ad1_code") );
												amtBal1 = rst.getDouble("amt1_bal");
												HashMap deductionMap = new HashMap();
												deductionMap.put( "SH_DESCR__DEDN", shDescr );
												deductionMap.put( "AMT__DEDN", amt );
												deductionMap.put( "PRT_SEQ__DEDN", prtSeq1 );
												deductionMap.put( "AD_CODE__DEDN", adCode1 );
												deductionMap.put( "AMT_BAL_DEDN", amtBal1 );

												deductionList.add( deductionMap );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}
											resultDtlJson.put( "DEDUCTION_INFO", deductionList );
											ArrayList leaveList = new ArrayList();
											sql = "";
											sql = " SELECT REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 1) lve_code, "
													+" REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 2) AVAILED_LVE, "
													+" REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 3) BAL_LVE "
													+" FROM (SELECT REPLACE(TRIM(LVE_DET) ,'-',' ') LVE_DETAIL "
													+" FROM (select regexp_substr(m.lve_cols,'[^, ]+',1,level) as LVE_DET "
													+" from (SELECT REPLACE(TRIM(lve_DESC) ,'*',' ') lve_cols "
													+" FROM (SELECT REPLACE(TRIM(lve_code) ,'>','') lve_desc "
													+" FROM (SELECT REPLACE(TRIM(LVE_DET) ,'<','') lve_code "
													+" FROM (select regexp_substr(my.str,'[^,]+',1,level) as LVE_DET "
													+" from (SELECT fn_r_get_lve_descr( ? , ?, ?, ? ) as str FROM DUAL) "
													+" my connect by level <= length(regexp_replace(TRIM(my.str),'[^, ]+')) + 1)))) "
													+" m connect by level <= length(regexp_replace(m.lve_cols,'[^, ]+')) + 1))T";
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , empCode );
											pStmt.setString( 3 , empSite );
											pStmt.setString( 4 , userCode );
											rst = pStmt.executeQuery();
											while ( rst.next() )
											{
												lveCode = checkNull( rst.getString("lve_code") );
												avalidlve = rst.getDouble("AVAILED_LVE");
												balLve =  rst.getDouble("BAL_LVE") ;
												HashMap leaveMap = new HashMap();
												leaveMap.put( "LVE_CODE", lveCode );
												leaveMap.put( "AVALID_LVE", avalidlve );
												leaveMap.put( "BAL_LVE", balLve );

												leaveList.add( leaveMap );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}
											resultDtlJson.put( "LEAVE_INFO", leaveList );
											ArrayList arrearList = new ArrayList();
											sql = "";
											sql = " SELECT SUM(PROJ_AMT) AS PROJ_AMT,sh_descr,ad_code,SUM(pay_amt) AS PAY_AMT,SUM(diff_amt) AS DIFF_AMT,prt_seq "
													+" FROM ( "
													+" SELECT (case nvl(allwdedn.print_opt,'M') when 'M' then payroll_projdet.amount "
													+"  else round(payroll_projdet.amount / payroll_projhdr.paid_days,2) end) AS PROJ_AMT, "
													+" allwdedn.sh_descr AS SH_DESCR,payroll_projdet.ad_code AS AD_CODE,0 AS PAY_AMT,0 AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ "
													+" FROM payroll_projdet,allwdedn,payroll_projhdr "
													+" WHERE allwdedn.ad_code = payroll_projdet.ad_code "
													+" AND payroll_projhdr.prd_code = payroll_projdet.prd_code "
													+" AND payroll_projhdr.emp_code = payroll_projdet.emp_code "
													+" AND payroll_projdet.prd_code = ? "
													+" AND payroll_projdet.emp_code = ? "
													+" AND payroll_projdet.payable = 'A' "
													+" UNION ALL "
													+" SELECT 0 AS PROJ_AMT,allwdedn.sh_descr AS SH_DESCR,PAYROLLDET.ad_code AS AD_CODE,payrolldet.amount AS PAY_AMT, "
													+" 0 AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ "
													+" FROM payrolldet,allwdedn "
													+" WHERE allwdedn.ad_code = PAYROLLDET.ad_code "
													+" AND PAYROLLDET.prd_code = ? "
													+" AND PAYROLLDET.emp_code = ? "
													+" AND PAYROLLDET.payable = 'A' "
													+" UNION ALL "
													+" SELECT 0 AS PROJ_AMT,allwdedn.sh_descr AS SH_DESCR,arreardet.ad_code AS AD_CODE,0 AS PAY_AMT, "
													+" arreardet.diff_amt AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ "
													+" FROM arreardet,allwdedn,arrears "
													+" WHERE allwdedn.ad_code = arreardet.ad_code "
													+" AND arrears.prd_code = arreardet.prd_code "
													+" AND arrears.emp_code = arreardet.emp_code "
													+" AND arrears.prd_code__acc = arreardet.prd_code__acc "
													+" AND arrears.voucher_no IS NOT NULL "
													+" AND arreardet.prd_code__acc = ? "
													+" AND arreardet.emp_code = ? "
													+" AND arreardet.payable = 'A' "
													+" ) "
													+" GROUP BY sh_descr,ad_code,prt_seq "
													+" HAVING SUM(proj_amt) != 0 OR SUM(diff_amt) != 0 OR SUM(pay_amt) != 0 "
													+" ORDER BY prt_seq,sh_descr";
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , empCode );
											pStmt.setString( 3 , periodCode );
											pStmt.setString( 4 , empCode );
											pStmt.setString( 5 , periodCode );
											pStmt.setString( 6 , empCode );
											rst = pStmt.executeQuery();
											while ( rst.next() )
											{
												projAmt = rst.getDouble("PROJ_AMT");
												shDescr1 = checkNull( rst.getString("sh_descr") );
												adCode =  checkNull( rst.getString("ad_code") );
												payAmt =  rst.getDouble("PAY_AMT");
												diffAmt =  rst.getDouble("DIFF_AMT");
												prtSeq =  checkNull( rst.getString("prt_seq") );
												HashMap arrearMap = new HashMap();
												arrearMap.put( "PROJ_AMT", projAmt );
												arrearMap.put( "SH_DESCR1", shDescr1 );
												arrearMap.put( "AD_CODE", adCode );
												arrearMap.put( "PAY_AMT", payAmt );
												arrearMap.put( "DIFF_AMT", diffAmt );
												arrearMap.put( "PRT_SEQ", prtSeq );

												arrearList.add( arrearMap );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}

											resultDtlJson.put( "EARNINGS_INFO", arrearList );
											result = resultDtlJson.toString();
											if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
											{
												result = genericUtility.jsonToXMLString( result );
											}

											resultJson.put( "Status", "success" );
											resultJson.put( "Remarks", "success" );
										}
										else
										{
											result = "Employee already resigned.";
											resultJson.put( "Status", "Failure" );
											resultJson.put( "Remarks", "Employee already resigned." );
										}
									}
									else
									{
										resultJson.put( "Status", "Failure" );
										result = "Employee code does not exist in employee master";
										resultJson.put( "Remarks", "Employee code does not exist in employee master." );
									}
								}
								else
								{
									resultJson.put( "Status", "Failure" );
									resultJson.put( "Remarks", "Employee code can not be blank." );
									result = "Employee code can not be blank";
								}
							}
							else
							{
								result = remarks;
								resultJson.put( "Status", "Failure" );
								resultJson.put( "Remarks", remarks );
							}
						}
						else
						{
							result = isValidLogin;
							resultJson.put( "Status", "Failure" );
							resultJson.put( "Remarks", isValidLogin );
						}
					}
					else
					{
						result = "Please enter username.";
						resultJson.put( "Status", "Failure" );
						resultJson.put( "Remarks", "Please enter username." );
					}
				}
				else
				{
					result = "Please enter valid Data Format.";
					resultJson.put( "Status", "Failure" );
					resultJson.put( "Remarks", "Please enter valid Data Format." );
				}
			/*}
			else
			{
				//	result = "This option is only available with 'Https'.";
				resultJson.put( "Status", "Failure" );
			}*/
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : authenticateUser : "+ e.getMessage() );
			resultJson.put( "Status", "Failure" );
			resultJson.put( "Remarks", "Something went wrong." );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			result = getStackTrace(e, dataFormat);
		}
		finally
		{
			if ( conn != null )
			{
				if ( rst != null )
				{
					rst.close();
					rst = null;
				}
				if ( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				conn.close();
				conn = null;
			}
			result = checkNull( result );
			if ( result.indexOf( "<Errors>" ) != -1 )
			{
				resultJson.put( "Status", "Failure" );
				resultJson.put( "Remarks", "Something went wrong." );
			}
			else if ( result.indexOf( "Exception" ) != -1 )
			{
				resultJson.put( "Status", "Failure" );
				resultJson.put( "Remarks", "Something went wrong." );
			}
			String responseType = ""+ resultJson.get( "Status" );
			try
			{
				String logResult = generateExtServiceLog( request, "", "getPaySlipData", params, responseType, result, getUserInfo() );
				BaseLogger.log("3",null,null,"logResult - ["+ logResult +"]");
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			resultJson.put( "results", result );
			responseJson.put( "Response", resultJson );
			result = responseJson.toString();
			if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
			{
				result = genericUtility.jsonToXMLString( result );
				result = genericUtility.remAllXmlDec( result );
			}
		}
		String status = resultJson.getString("Status");
		BaseLogger.log("3",null,null,"status - ["+ status +"]");
		writeAPICallLog("getPaySlipDataClient ( /getPaySlipData )", status, result, null, request, userInfo);
		return result;
	
	}
	
	public String getHashCode(String tranId, String enterprise, String activeUsrCnt, String usrLicType, String transDb, HttpServletRequest request) throws ITMException, JSONException
	{
		BaseLogger.log("2",null,null,"tranId["+tranId+"]activeUsrCnt["+activeUsrCnt+"]usrLicType["+usrLicType+"]enterprise["+enterprise+"]request["+request+"]");

		String responseString="";

		//Updated By Saitej D [On 16 April 2019] [To move getHashCode method in UserActivationEJB]
		UserActivationEJB userActEjb = new UserActivationEJB();
		responseString = userActEjb.getHashCode(tranId, enterprise, activeUsrCnt, usrLicType, transDb);
		//Updated By Saitej D [On 16 April 2019] [To move getHashCode method in UserActivationEJB]
		writeAPICallLog("getHashCode ( /getHashCode )", null, responseString, null, request, userInfo);
		return responseString;
	}
	
	//START: Added by Arti: 09-Feb-23: For activate/deactivate the users 
	public String setToggleUserLock(String tranId, String enterprise, String acctLock, String transDb, HttpServletRequest request) throws ITMException, JSONException
	{
		BaseLogger.log("2",null,null,"tranId["+tranId+"]enterprise["+enterprise+"]request["+request+"]");

		String responseString="";
		ibase.webitm.ejb.sys.UserAccountsLock userAccLock = new ibase.webitm.ejb.sys.UserAccountsLock();
		responseString = userAccLock.setToggleUserLock(tranId, enterprise, acctLock, transDb);
		writeAPICallLog("setToggleUserLock ( /setToggleUserLock )", null, responseString, null, request, userInfo);
		return responseString;
	}
	//END: Added by Arti: 09-Feb-23: For activate/deactivate the users 
	
	//START: Added by Arti: 06-Mar-23: For getting Enterprise from proteusvision.com
	public String getEnterpriseCode(String userId, String usrLicType, HttpServletRequest request) throws ITMException, JSONException
	{
		BaseLogger.log("2",null,null,"userId["+userId+"]usrLicType["+usrLicType+"]request["+request+"]");

		String responseString="";
		UserEnterpriseEJB userEntpEjb = new UserEnterpriseEJB();
		responseString = userEntpEjb.getEnterpriseCode(userId, usrLicType);
		writeAPICallLog("getEnterpriseCode ( /getEnterpriseCode )", null, responseString, null, request, userInfo);
		return responseString;
	}
	//END: Added by Arti: 06-Mar-23: For getting Enterprise from proteusvision.com
	
	public String getLicUserCount(String enterprise, String usrLicType ) throws ITMException
	{
		BaseLogger.log("2",null,null,"usrLicType["+usrLicType+"]enterprise["+enterprise+"]");

		String responseString="";
		UserActivationEJB userActEjb = new UserActivationEJB();
		int validLicUserCount = userActEjb.getLicUserLimit(usrLicType, enterprise);
		responseString = validLicUserCount + "";
		BaseLogger.log("2",null,null,"validLicUserCount["+validLicUserCount+"]");
		writeAPICallLog("getLicUserCount ( /getLicUserCount )", null, responseString, null, requestGlobal, userInfo);
		return responseString;
	
	}
	
	
	public String getReportArg(String objName, String userCode, String password, String isPwdEncrypt, String tokenId, String dataFormat, String appId, HttpServletRequest request) throws BaseException
	{
		String params = "";
		boolean isDestroySession = false;
		boolean isValidSession = false;
		String status = "error";
		String respArgString = "";

		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName );
				paramString.append("&USER_CODE="+ userCode );
				paramString.append("&PASSWORD="+ password );
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt );
				paramString.append("&DATA_FORMAT="+ dataFormat );
				paramString.append("&TOKEN_ID="+ tokenId );
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//respArgString = validateRequest( request, dataFormat );
			respArgString = validateRequest( request, dataFormat, null, false, appId, "getReportArg" );
			if( respArgString.equalsIgnoreCase("valid"))
			{
				if(!"".equalsIgnoreCase(checkNull(objName)))
				{
					if(request.getSession().getAttribute("USER_INFO") != null)
					{
						userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
						userCode = (!"".equals(checkNull( userCode ))) ? userCode : userInfo.getLoginCode();
					}
					//BaseLogger.log("3", userInfo,null, "userInfo:: ["+ userInfo +"]" );

					tokenId = checkNull( tokenId );
					if(tokenId.trim().length() > 0)
					{
						if(validateUserSession( request, tokenId ))
						{
							isValidSession = true;
						}
					}
					else
					{
						JSONObject respJson = (JSONObject) createSession(userCode, password, isPwdEncrypt, request);
						respArgString = respJson.getString("result");
						status = respJson.getString("status");
						if("true".equals(respArgString))
						{
							isValidSession = true;
							isDestroySession = true;
							BaseLogger.log("3", userInfo,null,"params - " + params);
						}
					}
					if( isValidSession )
					{
						BaseLogger.log("3", userInfo,null,"Valid session!!" );
						XSDParser xsdParser = new XSDParser( objName, userInfo );
						String attachType = "pdf";
						String argXmlString = xsdParser.getArgumentMetaDataString();
						//BaseLogger.log("3", userInfo,null,"argXmlString:: ["+ argXmlString +"]" );
						if(argXmlString.length() > 0)
						{
							JSONObject repArgsJosn = (JSONObject) getReportArgStr( objName, attachType, argXmlString, userInfo );
							respArgString = repArgsJosn.getString("response");
							status = repArgsJosn.getString("status");
						}
						else
						{
							respArgString = "Something went wrong, please check object name!!";
							status = "error";
						}
					}
					else
					{
						respArgString = "You are not authorized to access.";
						status = "error";
					}
				}
				else
				{
					respArgString = "Object name is missing!!";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception: @genReportArg ["+ e.getMessage() +"]" );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			respArgString = getStackTrace(e, dataFormat);
			status = "Exception";
		}
		finally
		{
			respArgString = generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);

			//BaseLogger.log("0", userInfo,null,"isSessionDestroy ["+ isDestroySession  +"]");
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, tokenId, dataFormat, status, respArgString );
			}
		}
		//BaseLogger.log("0", userInfo,null, "reportargStr::6292 ["+ respArgString +"]" );
		writeAPICallLog("getReportArg ( /getReportArg )", status, respArgString, appId, request, userInfo);
		return respArgString;
	}
	
	public String getReportArgClient(String objName, String userCode, String password, String isPwdEncrypt, String dataFormat, String tokenId, String appId, HttpServletRequest request) throws BaseException
	{
		String params = "";
		boolean isDestroySession = false;
		boolean isValidSession = false;
		String status = "error";
		String respArgString = "";

		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName );
				paramString.append("&USER_CODE="+ userCode );
				paramString.append("&PASSWORD="+ password );
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt );
				paramString.append("&DATA_FORMAT="+ dataFormat );
				paramString.append("&TOKEN_ID="+ tokenId );
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//respArgString = validateRequest( request, dataFormat );
			respArgString = validateRequest( request, dataFormat, null, false, appId, "getReportArg" );
			if( respArgString.equalsIgnoreCase("valid"))
			{
				if(!"".equalsIgnoreCase(checkNull(objName)))
				{
					if(request.getSession().getAttribute("USER_INFO") != null)
					{
						userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
						userCode = (!"".equals(checkNull( userCode ))) ? userCode : userInfo.getLoginCode();
					}
					//BaseLogger.log("3", userInfo,null, "userInfo:: ["+ userInfo +"]" );

					tokenId = checkNull( tokenId );
					if(tokenId.trim().length() > 0)
					{
						if(validateUserSession( request, tokenId ))
						{
							isValidSession = true;
						}
					}
					else
					{
						JSONObject respJson = (JSONObject) createSession(userCode, password, isPwdEncrypt, request);
						respArgString = respJson.getString("result");
						status = respJson.getString("status");
						if("true".equals(respArgString))
						{
							isValidSession = true;
							isDestroySession = true;
							BaseLogger.log("3", userInfo,null,"params - " + params);
						}
					}
					if( isValidSession )
					{
						BaseLogger.log("3", userInfo,null,"Valid session!!" );
						XSDParser xsdParser = new XSDParser( objName, userInfo );
						String attachType = "pdf";
						String argXmlString = xsdParser.getArgumentMetaDataString();
						//BaseLogger.log("3", userInfo,null,"argXmlString:: ["+ argXmlString +"]" );
						if(argXmlString.length() > 0)
						{
							JSONObject repArgsJosn = (JSONObject) getReportArgStr( objName, attachType, argXmlString, userInfo );
							respArgString = repArgsJosn.getString("response");
							status = repArgsJosn.getString("status");
						}
						else
						{
							respArgString = "Something went wrong, please check object name!!";
							status = "error";
						}
					}
					else
					{
						respArgString = "You are not authorized to access.";
						status = "error";
					}
				}
				else
				{
					respArgString = "Object name is missing!!";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception: @genReportArg ["+ e.getMessage() +"]" );
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//result = getStackTrace(e);
			respArgString = getStackTrace(e, dataFormat);
			status = "Exception";
		}
		finally
		{
			respArgString = generateResponse(request, "getReportArg", params, tokenId, dataFormat, status, respArgString);

			//BaseLogger.log("0", userInfo,null,"isSessionDestroy ["+ isDestroySession  +"]");
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, tokenId, dataFormat, status, respArgString );
			}
		}
		//BaseLogger.log("0", userInfo,null,"reportargStr::6292 ["+ respArgString +"]" );
		writeAPICallLog("getReportArgClient ( /getReportArg )", status, respArgString, appId, request, userInfo);
		return respArgString;
	}
	
	public String executeReport(String objName, String reportArgStr, String userCode, String password, String isPwdEncrypt, String dataFormat, String tokenId, String appId,
			HttpServletRequest request, HttpServletResponse response) throws BaseException
	{
		String params = "";
		String status = "error";
		String retString = "";
		boolean isValidSession = false;
		boolean isDestroySession = false;
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName );
				paramString.append("&USER_CODE="+ userCode );
				paramString.append("&PASSWORD="+ password );
				paramString.append("&REPORT_ARG_STR="+ reportArgStr );
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt );
				paramString.append("&DATA_FORMAT="+ dataFormat );
				paramString.append("&TOKEN_ID="+ tokenId );
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//retString = validateRequest( request, dataFormat );
			retString = validateRequest( request, dataFormat, null, false, appId, "executeReport" );
			if( retString.equalsIgnoreCase("valid"))
			{
				if( !"".equalsIgnoreCase( checkNull( objName ) ) && !"".equalsIgnoreCase( checkNull( reportArgStr ) ) )
				{
					if(request.getSession().getAttribute("USER_INFO") != null)
					{
						userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
						userCode = (!"".equals(checkNull( userCode ))) ? userCode : userInfo.getLoginCode();
					}

					tokenId = checkNull( tokenId );
					if(tokenId.trim().length() > 0)
					{
						if(validateUserSession( request, tokenId ))
						{
							isValidSession = true;
						}
					}
					else
					{
						JSONObject respJson = (JSONObject) createSession(userCode, password, isPwdEncrypt, request);
						retString = respJson.getString("result");
						status = respJson.getString("status");
						if("true".equals(retString))
						{
							isDestroySession = true;
							isValidSession = true;
						}
					}
					if( isValidSession )
					{
						JSONObject repResoJson = (JSONObject) getReportResp(retString, objName, userCode, reportArgStr,status, request , response );
						retString = repResoJson.getString("result");
						status = repResoJson.getString("status");
					}
					else
					{
						retString = "You are not authorized to access.";
						status = "error";
					}
				}
				else
				{
					retString = "Object name or report arguments are is missing!!";
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch(Exception e)
		{
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//retString = getStackTrace(e);
			retString = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			retString = generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
			//BaseLogger.log("0", userInfo,null,"isSessionDestroy ["+ isDestroySession  +"]");
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, tokenId, dataFormat, status, retString );
			}
		}
		//BaseLogger.log("0", userInfo,null, "getReportResponseMsg: "+ retString);
		writeAPICallLog("executeReport ( /executeReport )", status, retString, appId, request, userInfo);
		return retString;
	}
	
	public String executeReportClient(String objName, String reportArgStr, String userCode, String password, String isPwdEncrypt, String dataFormat, String tokenId, String appId,
			HttpServletRequest request, HttpServletResponse response) throws BaseException
	{
		String params = "";
		String status = "error";
		String retString = "";
		boolean isValidSession = false;
		boolean isDestroySession = false;
		try
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName );
				paramString.append("&REPORT_ARG_STR="+ reportArgStr );
				paramString.append("&USER_CODE="+ userCode );
				paramString.append("&PASSWORD="+ password );
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt );
				paramString.append("&DATA_FORMAT="+ dataFormat );
				paramString.append("&TOKEN_ID="+ tokenId );
				paramString.append("&APP_ID="+ appId );
				params = paramString.toString();
			}
			//Changed by Amey W. on 21-09-2020 [ for app_id related implementation ]
			//retString = validateRequest( request, dataFormat );
			retString = validateRequest( request, dataFormat, null, false, appId, "executeReport" );
			if( retString.equalsIgnoreCase("valid"))
			{
				if( !"".equalsIgnoreCase( checkNull( objName ) ) && !"".equalsIgnoreCase( checkNull( reportArgStr ) ) )
				{
					if(request.getSession().getAttribute("USER_INFO") != null)
					{
						userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
						userCode = (!"".equals(checkNull( userCode ))) ? userCode : userInfo.getLoginCode();
					}

					tokenId = checkNull( tokenId );
					if(tokenId.trim().length() > 0)
					{
						if(validateUserSession( request, tokenId ))
						{
							isValidSession = true;
						}
					}
					else
					{
						JSONObject respJson = (JSONObject) createSession(userCode, password, isPwdEncrypt, request);
						retString = respJson.getString("result");
						status = respJson.getString("status");
						if("true".equals(retString))
						{
							isDestroySession = true;
							isValidSession = true;
						}
					}
					if( isValidSession )
					{
						JSONObject repResoJson = (JSONObject) getReportResp(retString, objName, userCode, reportArgStr,status, request , response );
						retString = repResoJson.getString("result");
						status = repResoJson.getString("status");
						//BaseLogger.log("3", userInfo,null,"retString ["+retString+"] objName[" +objName+ "] userCode["+userCode+"] reportargStr["+reportargStr+"] status[" + status +"" );
					}
					else
					{
						retString = "You are not authorized to access.";
						status = "error";
					}
				}
				else
				{
					retString = "Object name or report arguments are is missing!!";
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch(Exception e)
		{
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//retString = getStackTrace(e);
			retString = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			retString = generateResponse(request, "executeReport", params, tokenId, dataFormat, status, retString);
			//BaseLogger.log("0", userInfo,null,("isSessionDestroy ["+ isDestroySession  +"]");
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, tokenId, dataFormat, status, retString );
			}
		}
		//BaseLogger.log("0", userInfo,null,"getReportResponseMsg: "+ retString);
		writeAPICallLog("executeReport ( /executeReportClient )", status, retString, appId, request, userInfo);
		return retString;
	}
	
	public String executeReportAndSendMail(String data, HttpServletRequest request, HttpServletResponse response) throws BaseException
	{
		String params = "";
		String status = "error";
		String retString = "";
		boolean isDestroySession = false;
		String userCode ="",objName="",dataFormat="",courseName= "";

		try
		{
			params = request.getQueryString();
			org.json.JSONObject jsonObject = new org.json.JSONObject(data); 
			objName=jsonObject.getString("OBJ_NAME");
			dataFormat = jsonObject.getString("DATA_FORMAT");
			courseName = jsonObject.getString("course_name");
			System.out.println("E12ExtService.executeReportAndSendMail() objName["+objName+"] dataFormat ["+dataFormat+"] courseName"+courseName+"]");
			System.out.println("DATA:"+data);

			if( !"".equalsIgnoreCase( checkNull( objName ) ) )
			{
				if(request.getSession().getAttribute("USER_INFO") != null)
				{
					userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
					userCode = userInfo.getLoginCode();
				}

				if( userInfo != null)
				{
					XSDParser xsdParser = new XSDParser( objName, userInfo );
					String attachType = "pdf";
					String argXmlString = xsdParser.getArgumentMetaDataString();
					BaseLogger.log("3", userInfo,null,"reportArgStr:: ["+ argXmlString +"] data:: ["+ data +"]" );


					JSONObject repArgsJosn = (JSONObject) getReportArgStr(objName, attachType, argXmlString, userInfo, jsonObject );
					String reportArgStr = repArgsJosn.getString("response");
					BaseLogger.log("3", userInfo,null,"12333 reportArgStr:: ["+ reportArgStr +"]" );
					JSONObject repResoJson = (JSONObject) getReportResp("SEND_MAIL", objName, userCode, reportArgStr,status, request , response );
					retString = repResoJson.getString("result");
					status = repResoJson.getString("status");
				}
				else
				{
					retString = "You are not authorized to access.";
					status = "error";
				}
			}
			else
			{
				retString = "Object name or report arguments are is missing!!";
				status = "error";
			}
			BaseLogger.log("3", userInfo,null, "getReportResponseMsg: userInfo  "+ userInfo.toString());
			BaseLogger.log("3", userInfo,null, "getReportResponseMsg: retString "+ retString);
			sendMail(userInfo, retString, "SRVG_COURSE_COMPL");
		}
		catch(Exception e)
		{
			//Changed By Ravindra C on 25-05-21 to write a exception in input Data format
			//retString = getStackTrace(e);
			retString = getStackTrace(e, dataFormat);
			status = "exception";
		}
		finally
		{
			retString = generateResponse(request, "executeReportAndSendMail", params, "", dataFormat, status, retString);
			if( isDestroySession )
			{
				logout( userCode, request );
				generateResponse( request, "logout", params, "", dataFormat, status, retString );
			}
		}
		BaseLogger.log("3", userInfo,null, "getReportResponseMsg: "+ retString);
		writeAPICallLog("executeReportSendMail ( /executeReportAndSendMail )", status, retString, null, request, userInfo);
		return retString;
	}
	
	
	
	// Dependent methods Gagan B.
	
	/**
	 * Get User Valid or not
	 *
	 * @param request
	 * @param userCode
	 * @param password
	 * @param siteCode
	 * @param authMode
	 * @param isSHA256Appld
	 * @return
	 * @throws Exception
	 * @throws BaseException
	 */
	private String getAuthStatus(HttpServletRequest request, String userCode, String password, String siteCode, String authMode, String isSHA256Appld) throws Exception, BaseException
	{
		String authStatus = "false";
		try
		{
			String xmlInfo = "";
			if ( getCommonDBAccess() != null )
			{
				//CommonDBAccessRemote commDBAccess = (CommonDBAccessRemote) getInitialContext().lookup("ibase/CommonDBAccessEJB/remote");
				//authStatus = commDBAccess.authenticate(userCode, password, siteCode, authMode, isSHA256Appld);
				//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password
				xmlInfo = getCommonDBAccess().authenticate(userCode, password, siteCode, authMode, isSHA256Appld, request);
				BaseLogger.log("3",null,null, "xmlInfo - ["+ xmlInfo +"]" );
				
				// Added by Gagan B. for handling condition -- when user call's login API and uses mobile no. as user_code on 11-JAN-23. [START]
				Document xmlInfodocument = genericUtility.parseString( xmlInfo );
				String statusCodeFromxmlInfodocument = xmlInfodocument.getElementsByTagName("STATUS").item(0).getNodeName();
				statusCodeFromxmlInfodocument = genericUtility.getColumnValue(statusCodeFromxmlInfodocument, xmlInfodocument);
				BaseLogger.log("3",null,null, "statusCodeFromxmlInfodocument - ["+ statusCodeFromxmlInfodocument +"]" );
				
				if(!statusCodeFromxmlInfodocument.equalsIgnoreCase("false")) {
					String authenticatedUsing = xmlInfodocument.getElementsByTagName("AUTHENTICATED_USING").item(0).getNodeName();
					authenticatedUsing = genericUtility.getColumnValue(authenticatedUsing, xmlInfodocument);
					BaseLogger.log("3",null,null, "authenticatedUsing - ["+ authenticatedUsing +"]" );
					
					String userCodeFromxmlInfodocument = xmlInfodocument.getElementsByTagName("USER_CODE").item(0).getNodeName();
					userCodeFromxmlInfodocument = genericUtility.getColumnValue(userCodeFromxmlInfodocument, xmlInfodocument);
					BaseLogger.log("3",null,null, "userCodeFromxmlInfodocument - ["+ userCodeFromxmlInfodocument +"]" );
					
					if(authenticatedUsing.contains("MOBILE_NO ")) {
						userCode = userCodeFromxmlInfodocument;
					}
				}
				// Added by Gagan B. for handling condition -- when user call's login API and uses mobile no. as user_code on 11-JAN-23. [END]
				authStatus = generateResponse(request, userCode, authMode, xmlInfo);
				BaseLogger.log("3",null,null, "authStatus --- ["+ authStatus +"]" );
				//isValidLogin = getAuthenticationStatus( authStatus );
				//if ( isValidLogin )
				if ( "VALID".equalsIgnoreCase( authStatus ) )
				{
					Document document = genericUtility.parseString( xmlInfo );
					setUserInfo( createUserInfo( userCode, password, document ) );
					request.getSession().setAttribute( "IS_EMP_INFO_SET", "true" );

					//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] START
					InetAddress inetAddress = InetAddress.getLocalHost();
					String hostName = inetAddress.getHostName();
					String hostIP = inetAddress.getHostAddress();
					String clientIP = checkNull( request.getRemoteAddr() );
					if ( getUserInfo() != null )
					{
						getUserInfo().setRemoteHost( ( clientIP.length() > 0 ) ? clientIP : "SYSTEM" );
						getUserInfo().setSessionId( request.getSession().getId() );
						getUserInfo().setHostName( hostName );
						getUserInfo().setHostIP( hostIP );
						getUserInfo().setRemoteHostName( hostName );
					}
					//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] END
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: getAuthStatus: "+ e.getMessage());
			throw new BaseException(e);
		}
		BaseLogger.log("2",null,null,"isValidLogin - ["+ authStatus +"]");
		return authStatus;
	}
	
	/**
	 * Creating xtraParams String
	 *
	 * @return
	 * @throws Exception
	 */
	private String getXtraParams() throws Exception
	{
		StringBuffer xtraParamsBuff = new StringBuffer();
		try
		{
			if ( getUserInfo() != null )
			{
				UserInfoBean userInfo = getUserInfo();
				String XTRA_PARAMS_SEPARATOR = "~~";
				xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfo.getEmpCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfo.getSiteCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfo.getEntityCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfo.getProfileId());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfo.getUserType());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfo.getCharEnc());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId=" + userInfo.getRemoteHost());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfo.getUserLanguage());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfo.getUserCountry());

				String chgTerm = userInfo.getRemoteHostName();
				if (chgTerm != null && chgTerm.length() > 15)
				{
					chgTerm = chgTerm.substring(0, 15);
				}
				else if (chgTerm == null || chgTerm.length() == 0)
				{
					chgTerm = userInfo.getRemoteHost();
				}
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm);
			}
			BaseLogger.log("3",null,null,"xtraParamsBuff ["+xtraParamsBuff+"]");
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		return xtraParamsBuff.toString();
	}
	
	
	/**
	 * Validate User Request
	 *
	 * @param request
	 * @param dataFormat
	 * @param tokenId
	 * @return
	 */
	public String validateRequest( HttpServletRequest request, String dataFormat, String tokenId, boolean toValidateSession, String appId, String endpoint )
	{
		String validStr = "valid";
		try
		{
			//Commented by Prasad on 02/Sep/2020 [As suggested by KB Sir, no need to check at code level, it should be handled at application level] START
			/*if ( request.isSecure() )
			{
				BaseLogger.log("3",null,null,"in validat request1 ");
				validStr = "This option is only available with 'Https'.";
			}
			else*/ 
			//Commented by Prasad on 02/Sep/2020 [As suggested by KB Sir, no need to check at code level, it should be handled at application level] END
			appId = checkNull( appId );
			if ( appId.length() == 0 )
			{
				validStr = "You are not authorized to access.";
			}
			else
			{
				validStr = validateAppId( request, appId, endpoint );
				if ( "valid".equalsIgnoreCase( validStr ) )
				{
					if ( ! isValidDataFormat( dataFormat ) )
					{
						validStr = "Please enter valid Data Format.";
					}
					//else if ( toValidateSession && ! validateUserSession( request, tokenId ) )
					else if ( toValidateSession && ! validateUserSession( request, tokenId, appId, endpoint ) )
					{
						validStr = "You are not authorized to access.";
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : validateRequest : "+ e.getMessage() );
			validStr = getStackTrace(e);
		}
		return validStr;
	}
	
	/**
	 * check valid Data Format or not (XML/JSON)
	 *
	 * @param dataFormat
	 * @return
	 */
	public boolean isValidDataFormat( String dataFormat )
	{
		boolean isValidDataFormat = false;
		dataFormat = checkNull( dataFormat );
		if ( "JSON".equalsIgnoreCase(dataFormat) || "XML".equalsIgnoreCase(dataFormat) )
		{
			isValidDataFormat = true;
		}
		return isValidDataFormat;
	}
	
	/**
	 * Generate Service Response
	 *
	 * @param request
	 * @param serviceName
	 * @param params
	 * @param tokenId
	 * @param dataFormat
	 * @param status
	 * @param result
	 * @return
	 */
	public String generateResponse( HttpServletRequest request, String serviceName, String params, String tokenId, String dataFormat, String status, String result )
	{
		String response = "";
		try
		{
			JSONObject responseJson = new JSONObject();
			JSONObject resultJson = new JSONObject();

			result = checkNull( result );
			//Added by vaishali P on 13/09/23 for handling the Rest api response[Start].
			if(dataFormat.equals("JSON"))
			{
				if(isJSONValid(result)) 
				{
					JSONObject resultStringToJSON = new JSONObject(result);
	
					if (resultStringToJSON.has("Warning")) 
					{
					    status = "warning";
					} 
					else if (resultStringToJSON.has("Errors"))
					{
					    status = "error";
					} 
					else if (resultStringToJSON.has("Exception"))
					{
					    status = "exception";
					}
				}
			}
			else 
			{
				if(genericUtility.isXMLString(result)) 
				{
					try 
					{
						Document resultDoc = convertStringToDocument(result);
						if(resultDoc != null)
						{
							NodeList warningList  = resultDoc.getElementsByTagName("Warning");
							NodeList errorsList  = resultDoc.getElementsByTagName("Errors");
							NodeList exceptionList  = resultDoc.getElementsByTagName("Exception");
							if (warningList.getLength() > 0) 
							{
				            	status = "warning";
						    }
							else if (errorsList.getLength() > 0)
							{
				            	status = "error";
							}
							else if (exceptionList.getLength() > 0)
							{
				            	status = "exception";
							}
						}
					}
					catch(Exception e) 
					{
						BaseLogger.log("0",null,null, "ITMException : generateResponse 5318 : "+ e.getMessage() );
						e.printStackTrace();
					}
				}
			}
			//Added by vaishali P on 13/09/23 for handling the Rest api response[End].
			//Commented by vaishali P on 13/09/23 for handling the Rest api response[End].
			//Added by Prasad 29/11/16 [to check warning status also] START
//			if ( result.indexOf( "Warning" ) != -1 )
//			{
//				status = "warning";
//			}
//			//Added by Prasad 29/11/16 [to check warning status also] END
//			else if ( result.indexOf( "Errors" ) != -1 )
//			{
//				status = "error";
//			}
//			else if ( result.indexOf( "Exception" ) != -1 )
//			{
//				status = "exception";
//			}
			resultJson.put( "status", status );
			try
			{
				String logResult = generateExtServiceLog( request, tokenId, serviceName, params, status, result, getUserInfo() );
				BaseLogger.log("3",null,null,"logResult - ["+ logResult +"]");
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			//Changed by Ravindra on 11/05/2021 [to handle json response] START
			resultJson.put( "results", result );
			//Added by Gagan B. for generating proper output from API. [START] on 30th-JAN-23
			/*if(genericUtility.isJSONValid(result)) {
				JSONObject resultStringToJSON = new JSONObject(result);
				resultJson.put( "results", resultStringToJSON );
			} else {
				resultJson.put( "results", result );
			}*/
			//BaseLogger.log("3",null,null,"result E12ExtserviceUtility- ["+ result +"]");
			//Added by Gagan B. for generating proper output from API. [END] on 30th-JAN-23
			/*if ( "JSON".equalsIgnoreCase( dataFormat ) )
			{
				try 
				{
					resultJson.put( "results", new JSONObject( result ) );
				}
				catch (Exception e) 
				{
					e.printStackTrace();
					resultJson.put( "results", result );
				}
			}
			else
			{
				resultJson.put( "results", result );
			}*/
			//Changed by Ravindra on 11/05/2021 [to handle json response] END
			responseJson.put( "Response", resultJson );
			response = responseJson.toString();
			//BaseLogger.log("3",null,null,"response E12ExtserviceUtility- ["+ response +"]");
			if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
			{
				response = genericUtility.jsonToXMLString( response );
				response = genericUtility.remAllXmlDec( response );
			}
		}
		catch (ITMException e)
		{
			BaseLogger.log("0",null,null, "ITMException : generateResponse : "+ e.getMessage() );
			response = getStackTrace(e);
		}
		catch (JSONException e)
		{
			BaseLogger.log("0",null,null, "JSONException : generateResponse : "+ e.getMessage() );
			response = getStackTrace(e);
		}
		return response;

	}
	//Added By Ankush s on [04-Dec-2023][to get response in JSON]START
	public String generateJSONResponse( HttpServletRequest request, String serviceName, String params, String tokenId, String dataFormat, String status, String result)
	{
		BaseLogger.log("3",null,null,"Result String for JSON - ["+result);
		String response = "";
		try
		{
			JSONObject responseJson = new JSONObject();
			JSONObject resultJson = new JSONObject();

			result = checkNull( result );
			//Added by Prasad 29/11/16 [to check warning status also] START
			if ( result.indexOf( "Warning" ) != -1 )
			{
				status = "warning";
			}
			//Added by Prasad 29/11/16 [to check warning status also] END
			else if ( result.indexOf( "Errors" ) != -1 )
			{
				status = "error";
			}
			else if ( result.indexOf( "Exception" ) != -1 )
			{
				status = "exception";
			}
			resultJson.put( "status", status );
			try
			{
				String logResult = generateExtServiceLog( request, tokenId, serviceName, params, status, result, getUserInfo() );
				BaseLogger.log("3",null,null,"logResult - ["+ logResult +"]");
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			//Changed by Ravindra on 11/05/2021 [to handle json response] START
			
			if(result.contains("TOKEN_ID")) {
			
				BaseLogger.log("3",null,null,"Adding Json result - [");
				JSONObject resultJsonObj = new JSONObject(result);
				resultJson.put( "results",resultJsonObj);
			}
			else {
				resultJson.put( "results", result );	
			}
			
			//Added by Gagan B. for generating proper output from API. [START] on 30th-JAN-23
			/*if(genericUtility.isJSONValid(result)) {
				JSONObject resultStringToJSON = new JSONObject(result);
				resultJson.put( "results", resultStringToJSON );
			} else {
				resultJson.put( "results", result );
			}*/
			//BaseLogger.log("3",null,null,"result E12ExtserviceUtility- ["+ result +"]");
			//Added by Gagan B. for generating proper output from API. [END] on 30th-JAN-23
			/*if ( "JSON".equalsIgnoreCase( dataFormat ) )
			{
				try 
				{
					resultJson.put( "results", new JSONObject( result ) );
				}
				catch (Exception e) 
				{
					e.printStackTrace();
					resultJson.put( "results", result );
				}
			}
			else
			{
				resultJson.put( "results", result );
			}*/
			//Changed by Ravindra on 11/05/2021 [to handle json response] END
			responseJson.put( "Response", resultJson );
			response = responseJson.toString();
			//BaseLogger.log("3",null,null,"response E12ExtserviceUtility- ["+ response +"]");
			if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
			{
				response = genericUtility.jsonToXMLString( response );
				response = genericUtility.remAllXmlDec( response );
			}
		}
		catch (ITMException e)
		{
			BaseLogger.log("0",null,null, "ITMException : generateResponse : "+ e.getMessage() );
			response = getStackTrace(e);
		}
		catch (JSONException e)
		{
			BaseLogger.log("0",null,null, "JSONException : generateResponse : "+ e.getMessage() );
			response = getStackTrace(e);
		}
		return response;

	}
	//Added By Ankush s on [04-Dec-2023][to get response in JSON]END
	/**
	 * get detail xmlstring from MasterStatefulEJB for provided object
	 *
	 * @param objName
	 * @param objContext
	 * @param editFlag
	 * @param pkValues
	 * @param argFieldValues
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String getDetailXMLDomString( String objName, String objContext, String editFlag, String pkValues, String argFieldValues )throws RemoteException,ITMException
	{
		String resultString = "";
		//Added By Nilesh Start ::12-05-2017
		MasterStatefulLocal masterStateful=null;
		//Added By Nilesh End ::12-05-2017
		try
		{
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			int randInt = new Random().nextInt();
			masterStateful.setEditorId( ""+randInt );
			masterStateful.setUserInfo( userInfo );
			resultString = masterStateful.getDetailXMLDomString( objName, objContext, editFlag, pkValues, argFieldValues );
		}
		catch (NamingException e)
		{
			BaseLogger.log("0",null,null,"NamingException :: getDetailXMLDomString() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		//Added By Nilesh Start ::12-05-2017
		finally
		{
			if(masterStateful!=null)
			{
				masterStateful.remove();
				masterStateful=null;
			}
		}
		//Added By Nilesh End ::12-05-2017
		return resultString;
	}
	

	
	
	/**
	 * @return the userInfo
	 */
	public UserInfoBean getUserInfo()
	{
		return userInfo;
	}

	/**
	 * @param userInfo the userInfo to set
	 */
	public void setUserInfo(UserInfoBean userInfo)
	{
		this.userInfo = userInfo;
	}
	
	/**
	 * log created to keep record of web service calls
	 *
	 * @param tokenId
	 * @param action
	 * @param params
	 * @param responseType
	 * @param response
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 */
	private String generateExtServiceLog( HttpServletRequest request, String tokenId, String action, String params, String responseType, String response, UserInfoBean userInfo) throws ITMException
	{
		String result = "";
		String requestedTerm = "", requestedUser = "";
		try
		{
			//Added by Prasad on 11/05/17 [to set hostName and hostAddress in log table] START
			String hostName = "", hostIP = "";
			InetAddress inetAddress = InetAddress.getLocalHost();
			hostName = inetAddress.getHostName();
			hostIP = inetAddress.getHostAddress();
			if ( userInfo != null )
			{
				requestedTerm = checkNull( userInfo.getRemoteHost() );
				if( requestedTerm.length() > 15 )
				{
					requestedTerm = requestedTerm.substring(0, 15);
				}
				requestedUser = checkNull( userInfo.getLoginCode() );
			}
			else
			{
				requestedTerm = checkNull( request.getRemoteAddr() );
				if( requestedTerm.length() > 15 )
				{
					requestedTerm = requestedTerm.substring(0, 15);
				}
				/*InetAddress inetAddress = InetAddress.getLocalHost();
    			requestedUser = inetAddress.getHostName();
				if ( requestedUser.length() > 10 )
				{
					requestedUser = requestedUser.substring(0, 10);
				}*/
				if ( hostName.length() > 10 )
				{
					requestedUser = hostName.substring(0, 10);
				}
			}
			//DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
			//result = dbAccess.createExtServiceLog(tokenId, action, params, responseType, response, requestedTerm, requestedUser, userInfo);
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//ExtServiceRemote extServices = (ExtServiceRemote) getInitialContext().lookup("ibase/ExtServiceEJB/remote");
			ExtServiceEJB extServices = new ExtServiceEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			result = extServices.createExtServiceLog(tokenId, action, params, responseType, response, requestedTerm, requestedUser, hostName, hostIP, userInfo);
			//Added by Prasad on 11/05/17 [to set hostName and hostAddress in log table] END
		}
		/*catch (NamingException e)
    	{
			e.printStackTrace();
			throw new ITMException(e);
		}*/
		catch (UnknownHostException e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		if ( "error".equals( responseType ) )
		{
			String fileName = requestedUser + "_log_" + System.currentTimeMillis() + ".log";
			generateErrorLog( response, fileName );
		}
		return result;
	}
	
	/**
	 * Generate a log file for upload document
	 *
	 * @param log
	 * @param fileName
	 */
	private void generateErrorLog( String log, String fileName )
	{
		try
		{
			String logDir = CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + "webService_Log" + File.separator + fileName;
			File outFile = new File( CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + "webService_Log" );
			if ( ! outFile.exists() )
			{
				outFile.mkdir();
			}
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logDir, true)));
			out.println( log );
			out.close();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * It creates a object of InitialContext & returns the same.
	 *
	 * @return
	 * @throws ITMException
	 */
	private InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			BaseLogger.log("0",null,null, "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
	
	/**
	 * Executing System events for provided object Name and Event
	 *
	 * @param objName
	 * @param eventCode
	 * @param serviceParam1
	 * @param serviceParam2
	 * @param serviceParam3
	 * @param serviceParam4
	 * @param xtraParams
	 * @return
	 * @throws ITMException
	 */
	private String executeSystemEvent( String objName, String eventCode, String serviceParam1, String serviceParam2, String serviceParam3, String serviceParam4, String xtraParams ) throws ITMException
	{
		String returnValue = "";
		try
		{
			String userInfo = "";
			if ( getUserInfo() != null )
			{
				userInfo = getUserInfo().toString();
			}
			//ExtServiceEventManagerLocal eventManager = (ExtServiceEventManagerLocal) getInitialContext().lookup( "ibase/ExtServiceEventManagerEJB/local" );
			ExtServiceEventManagerEJB eventManager = new ExtServiceEventManagerEJB();
			returnValue = eventManager.executeSystemEvent( objName, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams, userInfo, getUserInfo() );
			eventManager = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: executeSystemEvent: "+ e.getMessage());
			throw new ITMException(e);
		}
		BaseLogger.log("2",null,null,"executeSystemEvent :["+ returnValue +"]");
		return returnValue;
	}
	
	//Changed by Prasad on 18/02/16 [for validating user] START
		/**
		 * Generating server response after login
		 *
		 * @param request
		 * @param userCode
		 * @param loginMode
		 * @param xmlInfo
		 * @return
		 * @throws BaseException
		 */
	private String generateResponse( HttpServletRequest request, String userCode, String loginMode, String xmlInfo )throws BaseException
	{
		BaseLogger.log("2",null,null, "Generating Response...." );
		String responseString = "";
		try
		{
			HttpSession session = request.getSession();
			if ( checkNull( xmlInfo ).length() > 0 )
			{
				Document document = genericUtility.parseString( xmlInfo );
				if ( document.getElementsByTagName( "STATUS_CODE" ).item(0) != null && document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild() != null )
				{
					String statusCode = document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild().getNodeValue();
					responseString = statusCode;
					if ( statusCode.equalsIgnoreCase("RESIGNED") )
					{
						responseString = Messages.getString( "AuthenticateServlet_employeeHasResigned", getUserLangAndCountry(userCode) );
					}
					else if ( statusCode.equalsIgnoreCase("LOCKED") )
					{
						responseString = Messages.getString( "AuthenticateServlet_accountIsLockedContactAdmin", getUserLangAndCountry(userCode) );
					}
					else if ( statusCode.indexOf("INVALID") != -1 )
					{
						if ( statusCode.equalsIgnoreCase("INVALID_USR") )
						{
							responseString = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword",getUserLangAndCountry(userCode) );
						}
						//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - start
						else if (statusCode.equalsIgnoreCase("ACCOUNT_LOCKED"))
						{
							responseString = Messages.getString("AuthenticateServlet_accountIsLocked",getUserLangAndCountry(request.getParameter("USER")))+" "+CommonConstants.WRONG_LOGIN_COUNT+" times. "+Messages.getString("AuthenticateServlet_newPasswordIsSentToYourEmaiID",getUserLangAndCountry(request.getParameter("USER")))+" "+Messages.getString("AuthenticateServlet_accountUnlocked",getUserLangAndCountry(request.getParameter("USER")));
						}
						else if (statusCode.equalsIgnoreCase("WRONG_LOGIN_COUNT_EXCEED"))
						{
							responseString = Messages.getString("AuthenticateServlet_passwordBlockedSinceWronglyEntered",getUserLangAndCountry(request.getParameter("USER")))+CommonConstants.WRONG_LOGIN_COUNT+Messages.getString("AuthenticateServlet_newPasswordSentToEmailID",getUserLangAndCountry(request.getParameter("USER")));
						}
						//Added By Pankaj T. on 18-11--2020 for removing weak account lock vulnerability - if user wrongly enter password more than 5 times then lock the account and send new password on email/mobile and unlock account using new password - end
						else if ( statusCode.equalsIgnoreCase("INVALID_PWD") )
						{
							responseString = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword",getUserLangAndCountry(userCode) );
						}
						if ( session.getAttribute( "INVALID_COUNT" ) == null )
						{
							session.setAttribute( "INVALID_COUNT", new Integer( 1 ) );
						}
						else
						{
							int maxCount = 5;
							int invaildCount = ( ( Integer )session.getAttribute( "INVALID_COUNT" ) ).intValue();
							if (invaildCount == maxCount-1)
							{
								if (document.getElementsByTagName( "RES_TYPE" ) != null && document.getElementsByTagName( "RES_TYPE" ).item( 0 ) != null)
								{
									String resType = document.getElementsByTagName("RES_TYPE").item(0).getFirstChild().getNodeValue();
									//Two arguement added by sadique 25-6-2019
									//getCommonDBAccess().secureAccount( userCode, "0", userInfo );
									getCommonDBAccess().secureAccount( userCode, "0", userInfo,request.getRemoteAddr(),"");

									if ( Integer.parseInt( resType ) == 0 )
									{
										String emailIdOff = null;
										if (document.getElementsByTagName("EMAIL_ID") != null && document.getElementsByTagName("EMAIL_ID").item(0) != null)
										{
											emailIdOff = document.getElementsByTagName("EMAIL_ID").item(0).getFirstChild().getNodeValue();
										}
										responseString = Messages.getString( "AuthenticateServlet_passwordBlockedSinceWronglyEntered", getUserLangAndCountry(userCode))
												+ maxCount + Messages.getString( "AuthenticateServlet_newPasswordSentToEmailID", getUserLangAndCountry(userCode) ) + emailIdOff;
									}
									else if ( Integer.parseInt( resType ) == 1)
									{
										responseString = Messages.getString( "AuthenticateServlet_accountIsLockedContactAdmin",getUserLangAndCountry(userCode) );
									}
									else
									{
										BaseLogger.log("3",null,null,"Invaild Response Type(resType) Found :"+resType);
									}
								}
								session.setAttribute( "INVALID_COUNT", new Integer( 0 ) );
							}
							else
							{
								session.setAttribute( "INVALID_COUNT", new Integer( invaildCount+1 ) );
							}
						}
					}
					else if( statusCode.indexOf("PASS_EXP") != -1 )
					{
						if ( statusCode.equalsIgnoreCase("PASS_EXP_NOGRACE") )
						{
							responseString = Messages.getString( "AuthenticateServlet_passwordExpiredChangeIt",getUserLangAndCountry(userCode) );
						}
						//Added by Amey W. [To changes in system messages in case of password grace period which return from api] on 09/05/2019 START
						else if( statusCode.equalsIgnoreCase("PASS_EXP_GRACE") )
						{
							responseString = Messages.getString( "AuthenticateServlet_passwordExpiredWouldYouLikeToChange",getUserLangAndCountry(userCode) );
						}
						//Added by Amey W. [To changes in system messages in case of password grace period which return from api] on 09/05/2019 END
					}
					else if( statusCode.equalsIgnoreCase("VALID") )
					{
						if(document.getElementsByTagName( "SITE_CODE" ).item(0) != null)
						{
							String siteCodeValue = document.getElementsByTagName("SITE_CODE").item(0).getFirstChild().getNodeValue();
							if ( siteCodeValue.equalsIgnoreCase("INVALID_SITE") )
							{
								responseString = Messages.getString( "AuthenticateServlet_NotValidSite",getUserLangAndCountry(userCode) );
								session.setAttribute( "USER_INFO", null );
							}
							else if ( siteCodeValue.equalsIgnoreCase("INACCESSIBLE_SITE")  )
							{
								responseString = Messages.getString( "AuthenticateServlet_InAccessibleSite",getUserLangAndCountry(userCode) );
								session.setAttribute( "USER_INFO", null );
							}
						}
					}
					else if ( statusCode.equalsIgnoreCase("FIRST_LOGIN") )
					{
						responseString = Messages.getString( "AuthenticateServlet_compulsoryChangePasswordPleaseDoSo",getUserLangAndCountry(userCode) );
					}
					else if(statusCode.equalsIgnoreCase("ATTENDANCE_MISSING"))
					{
						responseString = Messages.getString( "AuthenticateServlet_entryInDailyAttendanceNotFound",getUserLangAndCountry(userCode) );
					}
					//Added by Amey W. [To changes in system messages in case of INVALID_LICENCE which return from api] on 09/05/2019 START
					else if (statusCode.equalsIgnoreCase("INVALID_LICENCE"))
					{
						BaseLogger.log("3",null,null,"statusCode final["+statusCode+"]");
						responseString = Messages.getString("Invalid Activation Code",getUserLangAndCountry(userCode) );
					}
					//Added by Amey W. [To changes in system messages in case of INVALID_LICENCE which return from api] on 09/05/2019 START
					//Added by Amey W. [To changes in system messages in case of RELEASE which return from api] on 09/05/2019 START
					else if ( statusCode.equalsIgnoreCase("RELEASE") )
					{
						responseString = Messages.getString("AuthenticateServlet_employeeHasResigned", getUserLangAndCountry(userCode));
					}
					//Added by Amey W. [To changes in system messages in case of RELEASE which return from api] on 09/05/2019 END
				}
			}
		}
		catch( BaseException be )
		{
			BaseLogger.log("0",null,null,"Exception: generateResponse:==>\n"+be);
			throw be;
		}
		catch( Exception e )
		{
			BaseLogger.log("0",null,null,"Exception: generateResponse:==>\n"+e);
			throw new BaseException( e );
		}
		BaseLogger.log("2",null,null, "responseString - ["+ responseString +"]" );
		return responseString;
	}
		
	/**
	 * Creating userInfo
	 *
	 * @param userCode
	 * @param passwd
	 * @param document
	 * @return
	 * @throws BaseException
	 */
	private UserInfoBean createUserInfo( String userCode, String passwd, Document document ) throws BaseException
	{
		UserInfoBean userInfo = null;
		try
		{
			userInfo = new ibase.utility.UserInfoBean();
			userInfo.setLoginCode( userCode );
			userInfo.setLoginPwd( passwd );
			if ( document.getElementsByTagName( "PROFILE_ID" ).item(0) != null
					&& document.getElementsByTagName( "PROFILE_ID" ).item(0).getFirstChild() != null )
			{
				userInfo.setProfileId( document.getElementsByTagName( "PROFILE_ID" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_CODE" ).item(0) != null
					&& document.getElementsByTagName( "EMP_CODE" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpCode( document.getElementsByTagName("EMP_CODE").item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_FNAME" ).item(0) != null
					&& document.getElementsByTagName( "EMP_FNAME" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpFName( document.getElementsByTagName( "EMP_FNAME" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_MNAME" ).item(0) != null
					&& document.getElementsByTagName( "EMP_MNAME" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpMName( document.getElementsByTagName( "EMP_MNAME" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_LNAME" ).item(0) != null
					&& document.getElementsByTagName( "EMP_LNAME" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpLName( document.getElementsByTagName( "EMP_LNAME" ).item(0).getFirstChild().getNodeValue() );
			}
			if (document.getElementsByTagName( "SITE_CODE" ).item(0) != null
					&& document.getElementsByTagName( "SITE_CODE" ).item(0).getFirstChild() != null)
			{
				userInfo.setSiteCode( document.getElementsByTagName( "SITE_CODE" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "IS_BI_USER" ).item(0) != null
					&& document.getElementsByTagName( "IS_BI_USER" ).item(0).getFirstChild() != null )
			{
				userInfo.setIsBIUser( document.getElementsByTagName("IS_BI_USER").item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "PROFILE_ID__RES" ).item(0) != null
					&& document.getElementsByTagName( "PROFILE_ID__RES" ).item(0).getFirstChild() != null )
			{
				userInfo.setProfileIdRes( document.getElementsByTagName( "PROFILE_ID__RES" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "LOGGER_TYPE" ).item(0) != null
					&& document.getElementsByTagName( "LOGGER_TYPE" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoggerType( document.getElementsByTagName( "LOGGER_TYPE" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "STAN_CD__HQ_DESCR" ).item(0) != null
					&& document.getElementsByTagName( "STAN_CD__HQ_DESCR" ).item(0).getFirstChild() != null )
			{
				userInfo.setStanCode( document.getElementsByTagName( "STAN_CD__HQ_DESCR" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "DESIGNATION" ).item(0) != null
					&& document.getElementsByTagName( "DESIGNATION" ).item(0).getFirstChild() != null )
			{
				userInfo.setDesignation( document.getElementsByTagName( "DESIGNATION" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "DATE_JOIN" ).item(0) != null
					&& document.getElementsByTagName( "DATE_JOIN" ).item(0).getFirstChild() != null )
			{
				userInfo.setDateJoin( document.getElementsByTagName( "DATE_JOIN" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "TRANS_DB" ).item(0) != null
					&& document.getElementsByTagName( "TRANS_DB" ).item(0).getFirstChild() != null )
			{
				userInfo.setTransDB( document.getElementsByTagName( "TRANS_DB" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "USER_THEME" ).item(0) != null
					&& document.getElementsByTagName( "USER_THEME" ).item(0).getFirstChild() != null )
			{
				userInfo.setUserTheme( document.getElementsByTagName( "USER_THEME" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "USER_GEO_FENCE_ENABLED" ).item(0) != null
					&& document.getElementsByTagName( "USER_GEO_FENCE_ENABLED" ).item(0).getFirstChild() != null )
			{
				userInfo.setUserGeoFence( document.getElementsByTagName( "USER_GEO_FENCE_ENABLED" ).item(0).getFirstChild().getNodeValue() );
			}
			// Added by Sandeshs 09-Feb-2016 [Req:S15JBAS002 Social Post] START
			if ( document.getElementsByTagName( "USER_NAME" ).item(0) != null && document.getElementsByTagName( "USER_NAME" ).item(0).getFirstChild() != null ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				userInfo.setUserName(document.getElementsByTagName( "USER_NAME" ).item(0).getFirstChild().getNodeValue() ); //$NON-NLS-1$
			}
			// Added by Sandeshs 09-Feb-2016 [Req:S15JBAS002 Social Post] END

			// Added by Sandeshs 23-Feb-2016 [Req:S15KBAS001 Social Post] START
			if ( document.getElementsByTagName( "IS_PASSWORD_STORE" ).item(0) != null && document.getElementsByTagName( "IS_PASSWORD_STORE" ).item(0).getFirstChild() != null )
			{
				userInfo.setIsPasswordStore(document.getElementsByTagName( "IS_PASSWORD_STORE" ).item(0).getFirstChild().getNodeValue() );
			}
			// Added by Sandeshs 23-Feb-2016 [Req:S15KBAS001 Social Post] END

			// Added by Sandeshs 21-Jun-2016 [Req:W15BSUN011] START
			if ( document.getElementsByTagName( "DEFAULT_MENU" ).item(0) != null && document.getElementsByTagName( "DEFAULT_MENU" ).item(0).getFirstChild() != null )
			{
				userInfo.setDefaultMenu(document.getElementsByTagName( "DEFAULT_MENU" ).item(0).getFirstChild().getNodeValue() );
			}
			// Added by Sandeshs 21-Jun-2016 [Req:W15BSUN011] END
			//Added By Suraj on 20-March-2017 [To configure slide menu footer options ]Start
			if ( document.getElementsByTagName( "FEATURES" ).item(0) != null && document.getElementsByTagName( "FEATURES" ).item(0).getFirstChild() != null )
			{
				userInfo.setFeatures( document.getElementsByTagName( "FEATURES" ).item(0).getFirstChild().getNodeValue() );
			}
			//Added By Suraj on 20-March-2017 [To configure slide menu footer options ]End
			//Added by Pankaj R on 26-Oct-17 to add a enterprise image in this column [STARt]
			if ( document.getElementsByTagName( "ENTERPRISE" ).item(0) != null && document.getElementsByTagName( "ENTERPRISE" ).item(0).getFirstChild() != null ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				userInfo.setEnterprise( document.getElementsByTagName( "ENTERPRISE" ).item(0).getFirstChild().getNodeValue() ); //$NON-NLS-1$
			}
			//Added by Pankaj R on 26-Oct-17 to add a enterprise image in this column [END]
			//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]START
			if ( document.getElementsByTagName( "USER_GEO_POS_OPTION" ).item(0) != null && document.getElementsByTagName( "USER_GEO_POS_OPTION" ).item(0).getFirstChild() != null ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				userInfo.setGeoPosOption(( document.getElementsByTagName( "USER_GEO_POS_OPTION" ).item(0).getFirstChild().getNodeValue()) ); //$NON-NLS-1$
			}
			//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]END
			//Added by Sagar B. to show descr in slide menu panel[18-Sep-18]START
			if ( document.getElementsByTagName( "ENTERPRISE_DESCR" ).item(0) != null && document.getElementsByTagName( "ENTERPRISE_DESCR" ).item(0).getFirstChild() != null ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				userInfo.setEnterpriseDescr( document.getElementsByTagName( "ENTERPRISE_DESCR" ).item(0).getFirstChild().getNodeValue() ); //$NON-NLS-1$
			}
			//Added by Sagar B. to show descr in slide menu panel[18-Sep-18]END
			//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]START
			if ( document.getElementsByTagName( "NETWORK_OPTION" ).item(0) != null && document.getElementsByTagName( "NETWORK_OPTION" ).item(0).getFirstChild() != null ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				userInfo.setUserNetworkOption(( document.getElementsByTagName( "NETWORK_OPTION" ).item(0).getFirstChild().getNodeValue()) ); //$NON-NLS-1$
			}
			//Added by Sagar B. to track GPS configuration on user level on [11-JAN-18]END
			//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]START
			if ( document.getElementsByTagName( "IS_ALLOW_OFFLINE_EDIT" ).item(0) != null && document.getElementsByTagName( "IS_ALLOW_OFFLINE_EDIT" ).item(0).getFirstChild() != null ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				userInfo.setIsAllowOfflineEdit(( document.getElementsByTagName( "IS_ALLOW_OFFLINE_EDIT" ).item(0).getFirstChild().getNodeValue()) ); //$NON-NLS-1$
			}
			if ( document.getElementsByTagName( "IS_ALLOW_OFFLINE_DELETE" ).item(0) != null && document.getElementsByTagName( "IS_ALLOW_OFFLINE_DELETE" ).item(0).getFirstChild() != null ) //$NON-NLS-1$ //$NON-NLS-2$
			{
				userInfo.setIsAllowOfflineDelete(( document.getElementsByTagName( "IS_ALLOW_OFFLINE_DELETE" ).item(0).getFirstChild().getNodeValue()) ); //$NON-NLS-1$
			}
			//Added by Sagar B. to set offline edit/delete configuration enterprise-wise[13-Mar-19]END
			//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo - start
			if ( document.getElementsByTagName( "USER_ID" ).item(0) != null && document.getElementsByTagName( "USER_ID" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginUserId(( document.getElementsByTagName( "USER_ID" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "MOBILE_NO" ).item(0) != null && document.getElementsByTagName( "MOBILE_NO" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginMobileNo(( document.getElementsByTagName( "MOBILE_NO" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "EMAIL_ID" ).item(0) != null && document.getElementsByTagName( "EMAIL_ID" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "EMAIL_ID" ).item(0).getFirstChild().getNodeValue()) );
			}
			//Changed By Pankaj T. on 21-10-19 set USER_CODE, MOBILE_NO, EMAIL_ID of user in userInfo - end

			//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - start
			if ( document.getElementsByTagName( "SMTP_HOST" ).item(0) != null && document.getElementsByTagName( "SMTP_HOST" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "SMTP_HOST" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "SMTP_PORT" ).item(0) != null && document.getElementsByTagName( "SMTP_PORT" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "SMTP_PORT" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "SMTP_USER" ).item(0) != null && document.getElementsByTagName( "SMTP_USER" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "SMTP_USER" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "SMTP_PASS_WD" ).item(0) != null && document.getElementsByTagName( "SMTP_PASS_WD" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "SMTP_PASS_WD" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "SMTP_PROTOCOL_TYPE" ).item(0) != null && document.getElementsByTagName( "SMTP_PROTOCOL_TYPE" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "SMTP_PROTOCOL_TYPE" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "SMTP_MAILFROM" ).item(0) != null && document.getElementsByTagName( "SMTP_MAILFROM" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "SMTP_MAILFROM" ).item(0).getFirstChild().getNodeValue()) );
			}
			if ( document.getElementsByTagName( "ADMIN_EMAIL_ID" ).item(0) != null && document.getElementsByTagName( "ADMIN_EMAIL_ID" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoginEmailId(( document.getElementsByTagName( "ADMIN_EMAIL_ID" ).item(0).getFirstChild().getNodeValue()) );
			}
			//Added by Pankaj T. on 10-04-2020 for Configure SMTP mail server against ENTERPRISE - end
			if ( getCommonDBAccess() != null )
			{
				userInfo.setEmpInfo( getCommonDBAccess().getEmpInfo( userInfo.getLoginCode(), userInfo.getSiteCode(), userInfo.getTransDB() ) );
			}
		}
		catch( Exception e )
		{
			BaseLogger.log("0",null,null,"Exception: createUserInfo:==>\n"+e);
			throw new BaseException( e );
		}
		BaseLogger.log("2",null,null, "UserInfoBean Created....." );
		return userInfo;
	}
	
	/**
	 * This method will get the user language and user country
	 * from User table depend upon user code
	 *
	 * @param userCode the user id from login page
	 * @return the list of user lang and user country
	 */
	private ArrayList<String> getUserLangAndCountry( String userCode )
	{
		ArrayList<String> langAndCountryList = new ArrayList<String>();
		try
		{
			String userLanguage = getCommonDBAccess().getDBColumnValue( "USERS", "USER_LANG","WHERE CODE = "+"'" +userCode+"'" );
			String userCountry = getCommonDBAccess().getDBColumnValue( "USERS", "USER_COUNTRY", "WHERE CODE = "+"'" +userCode+"'" );
			if( userLanguage != null && userCountry != null )
			{
				langAndCountryList.add( userLanguage );
				langAndCountryList.add( userCountry );
			}
			BaseLogger.log("3",null,null, "User Language["+userLanguage+"], User Country["+userCountry+"], List["+langAndCountryList.toString()+"]" );
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: while accessing user country and user language from database. ");
			e.printStackTrace();
		}

		return langAndCountryList;
	}
	
	//Changed by Prasad on 13/04/17 [to generate new tokenId] START
	/**
	 * get new tokenId after login successful
	 *
	 * @param userCode
	 * @return
	 */
	private String generateNewTokenId( String userCode )
	{
		String tokenId = userCode + ":" + UUID.randomUUID().toString().toUpperCase();
		if ( tokenId.length() > 30 )
		{
			tokenId = tokenId.substring( 0, 30 );
		}
		return tokenId;
	}
	//Changed by Prasad on 13/04/17 [to generate new tokenId] END
	
	//Added by Parikshit on 09/03/17 [to get employee details] START
	private JSONObject getUserDtl( JSONObject resultDtlJson ) throws ITMException, NamingException
	{
		try
		{
			BaseLogger.log("3",null,null,"in get user dtl");
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//ExtServiceRemote extServices = (ExtServiceRemote) getInitialContext().lookup("ibase/ExtServiceEJB/remote");
			ExtServiceEJB extServices = new ExtServiceEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			BaseLogger.log("3",null,null,"User InfoBean in getUserDtl = "+getUserInfo());
			UserInfoBean userInfoBean = extServices.updateUseInfo(getUserInfo());
			setUserInfo(userInfoBean);

			HashMap<String, String> resultMap = extServices.getLoginUserDetails( getUserInfo());

			if( resultMap != null && resultMap.size() > 0 )
			{
				for ( Map.Entry<String, String> entry : resultMap.entrySet() )
				{
					resultDtlJson.put( entry.getKey(), entry.getValue() );
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception in getUserDtl "+e.getMessage());
			e.printStackTrace();
		}
		BaseLogger.log("2",null,null, "resultDtlJson-["+ resultDtlJson +"]" );
		return resultDtlJson;
	}
	//Added by Parikshit on 09/03/17 [to get employee details] END
	
	
	//Added by Prasad on 01/04/2021 [token_id basis authentication changes] START
	/**
	 * Validate a User using Token Id (which is provided after successful login)
	 *
	 * @param request
	 * @param tokenId
	 * @return isValidUser - true if the user is valid, otherwise false
	 */
	public boolean validateUserSession( HttpServletRequest request, String tokenId )
	{
		return validateUserSession( request, tokenId, null, null );
	}
	//Added by Prasad on 01/04/2021 [token_id basis authentication changes] END

	/**
	 * Validate a User using Token Id (which is provided after successful login)
	 *
	 * @param request
	 * @param tokenId
	 * @return isValidUser - true if the user is valid, otherwise false
	 */
	private boolean validateUserSession( HttpServletRequest request, String tokenId, String appId, String endPoint )
	{
		boolean isValidUser = false;
		try
		{
			String sessionTokenId = request.getSession().getAttribute( "TOKEN_ID" ) != null ? ""+request.getSession().getAttribute( "TOKEN_ID" ) : "";
			tokenId = checkNull( tokenId );
			BaseLogger.log("3",null,null, "sessionTokenId - ["+ sessionTokenId +"], tokenId - ["+ tokenId +"]");
			//Changed by Shruti J on 29/03/2021 [USER_ACC_CHANNEL related implementation, get token details from USER_ACC_CHANNEL] START
			/*if ( tokenId.length() > 0 && sessionTokenId.equals( tokenId ) )
			{
				isValidUser = true;
				if ( request.getSession().getAttribute( "USER_INFO" ) != null )
				{
					UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute( "USER_INFO" );
					setUserInfo( userInfo );
				}
			}*/
			if ( tokenId.length() > 0 )
			{
				if ( sessionTokenId.equals( tokenId ) )
				{
					isValidUser = true;
					if ( request.getSession().getAttribute( "USER_INFO" ) != null )
					{
						UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute( "USER_INFO" );
						setUserInfo( userInfo );
					}
					// Added by Gagan B. on 21-MAR-23 : called separate method for validating LLT [START]
				} else {
					isValidUser = validateLLT(tokenId, appId, endPoint);
					// Added by Gagan B. on 21-MAR-23 : called separate method for validating LLT [START]
				}
			}
			else if ( appId != null && appId.trim().length() > 0 && endPoint != null && endPoint.trim().length() > 0 )
			{
				// Changed by Gagan B. on 21-MAR-23 : called separate method for validating LLT [START]
				isValidUser = validateLLT(tokenId, appId, endPoint);
				// Changed by Gagan B. on 21-MAR-23 : called separate method for validating LLT [START]
			}
			//Changed by Shruti J on 29/03/2021 [USER_ACC_CHANNEL related implementation, get token details from USER_ACC_CHANNEL] END
		}
		catch (Exception e)
		{
			isValidUser = false;
			e.printStackTrace();
		}
		return isValidUser;
	}
	
	// Added by Gagan B. on 21-MAR-23 : created separate method for validating LLT [START]
	public boolean validateLLT(String tokenId, String appId, String endPoint ) {
		boolean isValidUser = false;
		try {
			ExtAuthAppAPIBean authAppAPIBean = getCommonDBAccess().getAuthAppAPIDetails( endPoint, appId);
			BaseLogger.log( "3", null, null, "visionEdiBean : ["+ authAppAPIBean +"]");
			if ( authAppAPIBean != null )
			{
				String authAppUserId = checkNull( authAppAPIBean.getUserId() );
				BaseLogger.log( "3", null, null, "authAppUserId : ["+ authAppUserId +"]");
				String enterprise = getCommonDBAccess().getUserEnterprise( authAppUserId );
				BaseLogger.log( "3", null, null, "enterprise : ["+ enterprise +"]");
				
				DBAccessEJB dbAccess = new DBAccessEJB();
				appId = checkNull(appId);
				if(appId.length() == 0) {
					tokenId = dbAccess.getDBColumnValue( "USER_ACC_CHANNEL", "TOKEN_ID", (" ENTERPRISE = '"+ enterprise +"' AND USER_ID = '"+ authAppUserId +"' ") );
				} else {
					tokenId = dbAccess.getDBColumnValue( "USER_ACC_CHANNEL", "TOKEN_ID", (" ENTERPRISE = '"+ enterprise +"' AND USER_ID = '"+ authAppUserId + "' AND APP_ID = '" + appId + "' ") );
				}
				dbAccess = null;
				ExtAuthApplicationBean applicationBean = getCommonDBAccess().getExtAuthApplicationInfo( appId );
				if ( applicationBean != null )
				{
	                BaseLogger.log( "3", null, null, "E12ExtService :: validateUserSession :: SHARED_KEY : ["+ applicationBean.getSharedKey() +"]");
					String validateJWTResult = validateJWT( tokenId, appId, applicationBean.getSharedKey() );
					if ( "valid".equalsIgnoreCase( validateJWTResult ) )
					{
						isValidUser = true;
						HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken( tokenId, applicationBean.getSharedKey() );
						setUserInfo( createUserInfo( jwtData ) );
					}
				}
			}
		} catch (Exception e) {
			isValidUser = false;
			e.printStackTrace();
		}
		return isValidUser;
	}
	// Added by Gagan B. on 21-MAR-23 : created separate method for validating LLT [END]	
	
	//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] START
	/**
	 * User Logout
	 *
	 * @param userCode
	 * @param sessionId
	 * @throws BaseException
	 */
	private void logout( String userCode, HttpServletRequest request ) throws BaseException
	{
		String sessionId = request.getSession().getId();
		try
		{
			EventLogInfoBean eventInfoBean = new EventLogInfoBean( userCode );
			eventInfoBean.removeSessionActivity( sessionId );
			getCommonDBAccess().updateSessionTrace( userCode, sessionId );
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			HttpSession session = request.getSession(false);
			if(session != null)
			{
				session.invalidate();
			}
		}
	}
	
	private boolean isObjectRightsAvailable( String xmlStr )
	{
		boolean isRightsAvailable = true;
		try 
		{
			String userLevel = getUserInfo().getUserLevel();
			if ( ! "0".equalsIgnoreCase( userLevel ) && xmlStr != null && ! xmlStr.equalsIgnoreCase( "-1" ) )
			{
				Document xmlStrDoc = new E12GenericUtility().parseString( xmlStr );
				String editFlag = getInputXMLDetails( xmlStrDoc, "editFlag" );
				String objName = getInputXMLDetails( xmlStrDoc, "objName" );
				isRightsAvailable = new ITMTransactionEditorBean().getRightsInfo( objName, getUserInfo(), editFlag );
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log( "0", userInfo, null, "Exception :: isRightsAvailable : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		BaseLogger.log( "3", userInfo, null, "isRightsAvailable : ["+ isRightsAvailable +"]" );
		return isRightsAvailable;
	}
	
	private String getInputXMLDetails( Document xmlStrDoc, String tagName )
	{
		String tagValue = "";
		try 
		{
			BaseLogger.log( "3", userInfo, null, "tagName : ["+ tagName +"]" );
			if ( xmlStrDoc != null && tagName != null && tagName.trim().length() > 0 )
			{
				if( xmlStrDoc.getElementsByTagName( tagName ).item(0) != null && xmlStrDoc.getElementsByTagName( tagName ).item(0).getFirstChild() != null )
				{
					tagValue = ((String)xmlStrDoc.getElementsByTagName( tagName ).item(0).getFirstChild().getNodeValue()).trim();
				}
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log( "0", userInfo, null, "Exception :: getEditFlag : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		BaseLogger.log( "3", userInfo, null, "tagValue : ["+ tagValue +"]" );
		return tagValue;
	}
	
	/**
	 * Process request of MasterStatefulEJB
	 *
	 * @param xmlString
	 * @return
	 * @throws ITMException
	 */
	private String processRequest( String xmlString, ServletContext context ) throws ITMException
	{
		String resultString = "";
		Connection conn = null;
		boolean isError = false;
		//Added By Nilesh Start::12-05-2017
		MasterStatefulLocal masterStateful=null;
		//Added By Nilesh End::12-05-2017
		try
		{
			String userInfoStr = getUserInfo().toString();
			BaseLogger.log("3",null,null, "getUserInfo() - "+ userInfoStr );
			String transDB = getUserInfo().getTransDB();
			ConnDriver connDriver = new ConnDriver();
			//if( checkNull( transDB ).length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}

			connDriver = null;
			conn.setAutoCommit( false );
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			int randInt = new Random().nextInt();
			masterStateful.setEditorId( ""+randInt );
			masterStateful.setUserInfo( userInfoStr, xmlString );
			resultString = checkNull( masterStateful.processRequest( getUserInfo(), xmlString, true, conn ) );

			//Added by Prasad on 29/11/16 [for adding follow up actions] START
			if ( checkNull( xmlString ).length() > 0 )
			{
				String saveLevel = "";
				Node saveLevelNode = genericUtility.parseString( xmlString ).getElementsByTagName( "saveLevel" ).item(0);
				if ( saveLevelNode != null && saveLevelNode.getFirstChild() != null )
				{
					saveLevel = saveLevelNode.getFirstChild().getNodeValue();
				}
				if ( ( saveLevel != null && resultString != null ) && ( saveLevel.equals( "1" ) && resultString.indexOf( "Success" ) != -1 ) )
				{
					try
					{
						String tranID = "";
						Node tranIdNode = genericUtility.parseString( resultString ).getElementsByTagName( "TranID" ).item(0);
						if ( tranIdNode != null && tranIdNode.getFirstChild() != null)
						{
							tranID = tranIdNode.getFirstChild().getNodeValue();
						}
						String objName = "";
						Node objNameNode = genericUtility.parseString( xmlString ).getElementsByTagName( "objName" ).item(0);
						if ( objNameNode != null && objNameNode.getFirstChild() != null )
						{
							objName = objNameNode.getFirstChild().getNodeValue();
						}
						BaseLogger.log("3",null,null, "objName - ["+ objName +"], tranID - ["+ tranID +"]" );
						String userId = getUserInfo().getLoginCode();
						String randomNo = ""+ new Random().nextInt();
						addFollowUpAction( userId, randomNo, tranID, objName, context );
					}
					catch (Exception e)
					{
						e.printStackTrace();
					}
				}
			}
			//Added by Prasad on 29/11/16 [for adding follow up actions] END
		}
		catch (ITMException e)
		{
			BaseLogger.log("0",null,null,"ITMException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (RemoteException e)
		{
			BaseLogger.log("0",null,null,"RemoteException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (SQLException e)
		{
			BaseLogger.log("0",null,null,"SQLException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (NamingException e)
		{
			BaseLogger.log("0",null,null,"NamingException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			if ( resultString.indexOf( "<Errors>" ) != -1 || resultString.indexOf( "Exception" ) != -1 )
			{
				isError = true;
			}
			if( conn !=null )
			{
				try
				{
					if ( isError )
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
				catch (SQLException e)
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			//Added By Nilesh Start::12-05-2017
			if(masterStateful!=null)
			{
				masterStateful.remove();
				masterStateful=null;
			}
			//Added By Nilesh End::12-05-2017
		}
		return resultString;
	}
	
	//Added by Prasad on 29/11/16 [for adding follow up actions] START
	/**
	 * Add follow up actions
	 *
	 * @param userId
	 * @param editorId
	 * @param tranId
	 * @param objName
	 */
	private void addFollowUpAction( String userId, String editorId, String tranId, String objName, ServletContext context )
	{
		try
		{
			String pendingWrkflwMapKey = userId + "~" + editorId;
			String pendingWrkflwMapValue = objName + "~" + tranId;
			Map<String, String> pendingWrkflwMap = new HashMap<String, String>();
			if ( context.getAttribute( "pendingWrkflwMap" ) != null )
			{
				pendingWrkflwMap = (Map<String, String>) context.getAttribute( "pendingWrkflwMap" );
				if ( pendingWrkflwMap != null )
				{
					pendingWrkflwMap.put( pendingWrkflwMapKey, pendingWrkflwMapValue );
				}
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext( appConnect.getProperty() );
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
				//E12FollowUpActionLocal followUpActionLocal = (E12FollowUpActionLocal) ctx.lookup( "ibase/E12FollowUpActionEJB/local" );
				E12FollowUpActionEJB followUpActionLocal = new E12FollowUpActionEJB();
				// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
				//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
				followUpActionLocal.followUpAction( pendingWrkflwMapKey, context, userInfo );
				followUpActionLocal = null;
			}
			BaseLogger.log("3",null,null,"pendingWrkflwMap - "+ context.getAttribute( "pendingWrkflwMap" ));
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception - "+ e.getMessage() );
			e.printStackTrace();
		}
	}
	//Added by Prasad on 29/11/16 [for adding follow up actions] END
	
	/**
	 * Executing system events
	 *
	 * @param objName
	 * @param eventCode
	 * @param transDomString
	 * @param detailDomString
	 * @param domId
	 * @param xtraParams
	 * @return
	 * @throws ITMException
	 */
	private String executeSystemEvent( String objName, String eventCode, String transDomString, String detailDomString, String domId, String xtraParams ) throws ITMException
	{
		String retStr = "";
		try
		{
			InitialContext ctx = getInitialContext();

			//EventManagerRemote eventManager = (EventManagerRemote)ctx.lookup("ibase/EventManagerEJB/remote");
			EventManagerEJB eventManager = new EventManagerEJB();
			retStr = eventManager.executeSystemEvent( objName, eventCode, null, transDomString, detailDomString, xtraParams, domId );
			eventManager.remove();
			eventManager = null;
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0",null,null,"ITMException :: executeSystemEvent :==>"+ itme.getMessage());
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: executeSystemEvent :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		return retStr;
	}

	/**
	 * Executing system events
	 *
	 * @param objName
	 * @param eventCode
	 * @param transDomString
	 * @param detailDomString
	 * @param domId
	 * @param xtraParams
	 * @param userInfoBean
	 * @return
	 * @throws ITMException
	 */
	private String executeSystemEvent( String objName, String eventCode, String transDomString, String detailDomString, String domId, String xtraParams,UserInfoBean userInfoBean ) throws ITMException
	{
		String retStr = "";
		try
		{
			InitialContext ctx = getInitialContext();

			//EventManagerRemote eventManager = (EventManagerRemote)ctx.lookup("ibase/EventManagerEJB/remote");
			EventManagerEJB eventManager = new EventManagerEJB();
			retStr = eventManager.executeSystemEvent( objName, eventCode, null, transDomString, detailDomString, xtraParams, domId, userInfoBean );
			eventManager.remove();
			eventManager = null;
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0",null,null,"ITMException :: executeSystemEvent :==>"+ itme.getMessage());
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: executeSystemEvent :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		return retStr;
	}
	
	/**
	 * Get Item Change Data
	 *
	 * @param objName
	 * @param domId
	 * @param transDomStr
	 * @param detailDomStr
	 * @return
	 * @throws ITMException
	 */
	private String getItemChangeData( String objName, String domId, String transDomStr, String detailDomStr ) throws ITMException
	{
		String resultString = "";
		try
		{
			String transDB = checkNull( getUserInfo().getTransDB() );
			if( transDB.length() > 0 )
			{
				resultString = executeSystemEvent( objName, "post_item_change", transDomStr, detailDomStr, domId, getXtraParams(), getUserInfo() );
			}
			else
			{
				resultString = executeSystemEvent( objName, "post_item_change", transDomStr, detailDomStr, domId, getXtraParams() );
			}
			if(resultString != null && resultString.indexOf("Errors") == -1)
			{
				Document transDom = genericUtility.parseString( transDomStr );
				String objContext = getValueOfField( transDom, "objContext" );
				if(resultString != null && resultString.indexOf("Detail"+objContext) == -1)
				{
					resultString = resultString.replaceAll("Detail", "Detail"+objContext);
				}
				BaseLogger.log("3",null,null,"responseStr[After updating the objContext] ::"+resultString);

				Document responseDom = genericUtility.parseString(resultString);
				Element element = (Element)responseDom.getElementsByTagName("Detail"+objContext).item(0);
				if(element != null)
				{
					element.setAttribute("domID", domId);
				}
				resultString = genericUtility.serializeDom(responseDom);
				BaseLogger.log("3",null,null,"responseStr[After updating the domID] ::"+resultString);
			}
		}
		catch (ITMException e)
		{
			BaseLogger.log("0",null,null,"ITMException :: getItemChangeData() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		catch (DOMException e)
		{
			BaseLogger.log("0",null,null,"DOMException :: getItemChangeData() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: getItemChangeData() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return resultString;
	}
	//Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] END
	
	/**
	 * Get value from document
	 *
	 * @param parentDom
	 * @param currFieldName
	 * @return
	 * @throws ITMException
	 */
	private String getValueOfField( Document parentDom, String currFieldName ) throws ITMException
	{
		BaseLogger.log("2",null,null,"Getting value for field : ["+currFieldName+"]");
		String fieldValue = null;
		try
		{
			NodeList detailNodeList = parentDom.getElementsByTagName("Detail1");
			if (detailNodeList.getLength() > 0)
			{
				if (detailNodeList.item(0).getAttributes().getNamedItem(currFieldName) != null)
				{
					fieldValue = detailNodeList.item(0).getAttributes().getNamedItem(currFieldName).getNodeValue();
				}
				else
				{
					fieldValue = null;
				}
			}
			if (fieldValue == null)
			{
				BaseLogger.log("3",null,null,"Seraching dom value as an element from dom.........");
				NodeList currFieldList = parentDom.getElementsByTagName(currFieldName);
				if (currFieldList.getLength() > 0)
				{
					if (currFieldList.item(0).getFirstChild() != null)
					{
						fieldValue = currFieldList.item(0).getFirstChild().getNodeValue();
					}
					else
					{
						fieldValue = null;
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: getValueOfField() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		BaseLogger.log("2",null,null,"getValueOfField() - fieldName : ["+currFieldName+"], value : ["+fieldValue+"]");
		return fieldValue;
	}
	
	/**
	 * Get pophelp data
	 *
	 * @param objName
	 * @param fieldName
	 * @param paramXmlStr
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 */
	//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data
	private String getpopUpKeyStr(String objName, String fieldName, String paramXmlStr, UserInfoBean userInfo, String allDetailXml, String formNo, String reqParams) throws ITMException
	{
		String xmlString = "";
		try
		{
			//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data - START
			reqParams = ( reqParams == null || reqParams.trim().length() == 0 ) ? null : reqParams;
			formNo = ( formNo == null || formNo.trim().length() == 0 ) ? "1" : formNo;
			//PopUpRemote popUp = ( PopUpRemote )getInitialContext().lookup( "ibase/PopUpEJB/remote" );
			PopUpEJB popUp = new PopUpEJB();
			//xmlString = popUp.getpopUpKeyStr(objName, fieldName, paramXmlStr, userInfo, "", "", null );
			xmlString = popUp.getpopUpKeyStr(objName, fieldName, paramXmlStr, userInfo, allDetailXml, formNo, reqParams);
			//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data - END
			popUp = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :: getPopUpKeyStr ["+e.getMessage()+"]");
			throw new ITMException( e );
		}
		return xmlString;
	}
	
	/**
	 * get brow data
	 *
	 * @param objName
	 * @param argFieldValues
	 * @param argFieldTypes
	 * @param advQuery
	 * @param request
	 * @param searchParam
	 * @param editorId
	 * @return
	 * @throws ITMException
	 */
	private String getXMLDataForHeader( String objName, String argFieldValues, String argFieldTypes, String advQuery, HttpServletRequest request, String searchParam, String editorId) throws ITMException
	{
		String retXMLStr = null;
		try
		{
			UserInfoBean userInfo = ( UserInfoBean )request.getSession().getAttribute( "USER_INFO" );
			if(userInfo != null)
			{
				//MasterDataRemote mDataRem = ( MasterDataRemote ) this.getInitialContext().lookup( "ibase/MasterDataEJB/remote" );
				MasterDataEJB masterDataEJB = new MasterDataEJB();
				masterDataEJB.setEditorId(editorId);
				retXMLStr = masterDataEJB.getXMLFromDBForBrow( objName, "1", "1", argFieldValues, argFieldTypes, advQuery, userInfo, true, searchParam );
				masterDataEJB = null;
			}
			else
			{
				retXMLStr = "You have not logged on or your session has expired.";
			}
		}
		catch ( ITMException itme )
		{
			BaseLogger.log("0",null,null, "ITMException :: getXMLDataForHeader :"+ itme.getMessage() );
			throw itme;
		}
		catch ( Exception e )
		{
			BaseLogger.log("0",null,null, "Exception :: getXMLDataForHeader :"+ e.getMessage() );
			throw new ITMException( e );
		}
		return retXMLStr;
	}
	
	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] START
	/**
	 * Get sign details (Inbox/Approved/Rejected)
	 *
	 * @param signStatus
	 * @param roles
	 * @param context1
	 * @param context2
	 * @param context3
	 * @param applName
	 * @param userInfo
	 * @return
	 * @throws RemoteException
	 * @throws Exception
	 */
	private String getWrkFlwBrowData( String signStatus, String roles, String context1, String context2, String context3, String applName, UserInfoBean userInfo ) throws ITMException, Exception
	{
		String signXMLData = "";
		try
		{
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//SignManagerRemote signManager =(SignManagerRemote) getInitialContext().lookup("ibase/SignManagerEJB/remote");
			SignManagerEJB signManager = new SignManagerEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			String entityCode = "";
			//Added by sunny soni for getting trans db to resolving signXMLData not getting issue[Start]
			String transDb = "";
			//Added by sunny soni for getting trans db to resolving signXMLData not getting issue[End]
			if( userInfo != null )
			{
				entityCode = userInfo.getEntityCode();
				transDb = userInfo.getTransDB();
			}
			//signXMLData = signManager.getBrowData( "", signStatus, roles, context1, context2, context3, entityCode, userInfo.toString(), applName );
			//Added by sunny soni for getting trans db to resolving signXMLData not getting issue[Start]
			signXMLData = signManager.getBrowData( "", signStatus, roles, context1, context2, context3, entityCode, userInfo.toString(), applName, transDb);
			//Added by sunny soni for getting trans db to resolving signXMLData not getting issue[End]
		}
		catch (Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception: getWrkFlwBrowData: "+ e.getMessage());
			throw new ITMException(e);
		}
		BaseLogger.log("2",userInfo,null,"signXMLData - ["+ signXMLData +"]");
		return signXMLData;
	}
	
	/**
	 * get Sign transaction details
	 *
	 * @param refSer
	 * @param refId
	 * @param lineNo
	 * @param userInfo
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String getSignTransDetData( String refSer, String refId, int lineNo, UserInfoBean userInfo ) throws RemoteException, ITMException
	{
		String signTransXMLData = "";
		try
		{
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//SignManagerRemote signManager =(SignManagerRemote) getInitialContext().lookup("ibase/SignManagerEJB/remote");\
			SignManagerEJB signManager = new SignManagerEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
			String userCode = "";
			String siteCode = "";
			if( userInfo != null )
			{
				userCode = userInfo.getLoginCode();
				siteCode = userInfo.getSiteCode();
			}
			String transDetailXML = signManager.getTransXMLString( userCode, siteCode, refSer, refId, lineNo, userInfo.toString(), null );

			HashMap<String, String> transDetailMap = new HashMap<String, String>();
			if( checkNull( transDetailXML ).length() > 0 )
			{
				Document doc = genericUtility.parseString( transDetailXML );
				NodeList detailNodeList = doc.getElementsByTagName( "Detail" );
				Node detailNode = detailNodeList.item(0);
				NodeList detailChildList = detailNode.getChildNodes();
				int detailChildListLength = detailChildList.getLength();
				for(int dCtr = 0; dCtr < detailChildListLength; dCtr++)
				{
					Node currChild = detailChildList.item( dCtr );
					if( ! currChild.getNodeName().equalsIgnoreCase("attribute"))
					{
						if (currChild.getFirstChild() != null)
						{
							if (currChild.getFirstChild().getNodeType() == Node.ELEMENT_NODE)
							{
								transDetailMap.put( currChild.getNodeName(), genericUtility.serializeDom(currChild) );
							}
							else
							{
								transDetailMap.put( currChild.getNodeName(), currChild.getFirstChild().getNodeValue() );
							}
						}
						else
						{
							transDetailMap.put( currChild.getNodeName(), "" );
						}
					}
				}
			}
			signTransXMLData = transDetailMap.get( "TRANS_INFO" );
		}
		catch (Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception: getWrkFlwTransXMLData: "+ e.getMessage());
			throw new ITMException(e);
		}
		BaseLogger.log("2",userInfo,null,"signTransXMLData - ["+ signTransXMLData +"]");
		return signTransXMLData;
	}
	
	/**
	 * Update Sign status
	 *
	 * @param xmlString
	 * @param actionCode
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 * @throws Exception
	 */
	private String updateSignStatus( String xmlString, String actionCode, UserInfoBean userInfo, ServletContext context ) throws ITMException, Exception
	{
		String responseStr = "";

		//Added by shrutika on 25-12-18 [Start] for update status as Exception.
		UserEventLogEJB userEventLogEJB = new UserEventLogEJB();
		String tempobjName = "",newEditorId = "",tempAction = "",tempEvent = "", argsParam = "",tempTranId ="";
		Date tempstartTime = null;
		//Added by shrutika on 25-12-18 [End] for update status as Exception.
		try
		{
			String SIGN_ACTION = "1";
			String REJECT_ACTION = "2";
			String SAVE_ACTION = "3";
			String SIGN_CLOSE_ACTION = "4";
			String REVERT_ACTION = "5";

			String eventCode = "Workflow";
			if ( SIGN_ACTION.equals( actionCode ) )
			{
				eventCode = "SIGN_ACTION";
			}
			else if ( SIGN_CLOSE_ACTION.equals( actionCode ) )
			{
				eventCode = "SIGN_CLOSE_ACTION";
			}
			else if ( REVERT_ACTION.equals( actionCode ) )
			{
				eventCode = "REVERT_ACTION";
			}
			else if ( REJECT_ACTION.equals( actionCode ) )
			{
				eventCode = "REJECT_ACTION";
			}
			else if ( SAVE_ACTION.equals( actionCode ) )
			{
				eventCode = "SAVE_ACTION";
			}
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//SignManagerRemote signManager = (SignManagerRemote) getInitialContext().lookup("ibase/SignManagerEJB/remote");
			SignManagerEJB signManager = new SignManagerEJB();
			//UserEventLogEJBLocal userEventLogEJB = (UserEventLogEJBLocal) getInitialContext().lookup("ibase/UserEventLogEJB/local");
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]

			ArrayList<String> signDetailList = getSignDetailList( xmlString );
			String objName = checkNull( signDetailList.get( 0 ) );
			String refSer = checkNull( signDetailList.get(1) );
			String refId = checkNull( signDetailList.get( 2 ) );
			String lineNo = checkNull( signDetailList.get( 3 ) );
			String userId = checkNull( signDetailList.get( 4 ) );
			String signRemarks = checkNull( signDetailList.get( 5 ) );
			String signStatus = checkNull( signDetailList.get( 6 ) );
			String siteCode = checkNull( signDetailList.get( 7 ) );
			String signReason = "";
			if(signDetailList.size() > 8)
			{
				signReason = checkNull( signDetailList.get( 8 ) );
			}
			Date startTime = new Date();
			String chgString = "";
			String signBy = "";
			if(userId.length() == 0)
			{
				userId = userInfo.getLoginCode();
			}
			if(siteCode.length() == 0)
			{
				siteCode = userInfo.getSiteCode();
			}
			if ( SIGN_ACTION.equals( actionCode ) || SIGN_CLOSE_ACTION.equals( actionCode ) || REVERT_ACTION.equals( actionCode ) || REJECT_ACTION.equals( actionCode ) )
			{
				StringTokenizer refIdST = new StringTokenizer( refId, "," );
				StringTokenizer lineNoST = new StringTokenizer( lineNo, ",");
				TreeMap<String, String> signStatusMap = new TreeMap<String, String>();
				while ( refIdST.hasMoreTokens() )
				{
					String refID = refIdST.nextToken();
					int lineNum = Integer.parseInt(lineNoST.nextToken().trim());
					//added by shrutika on 03-12-18 [start] for updateEventLog.
					String temEditorId = ""+ new Date().getTime();

					//Added by shrutika on 25-12-18 [Start] for update status as Exception.
					tempobjName = objName;
					newEditorId = temEditorId;
					tempstartTime = startTime;
					tempAction = eventCode;
					tempEvent = eventCode;
					argsParam = "";
					tempTranId = refID;
					//Added by shrutika on 25-12-18 [End] for update status as Exception.

					//Change by shrutika on 05-01-19 for add exception.
					userEventLogEJB.setEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), temEditorId, eventCode, eventCode, startTime, null, "" , refID, "Pending", "WF","");
					responseStr = signManager.sign( lineNum, refID, refSer, objName, signStatus, userId, siteCode, signRemarks, chgString, userInfo.toString(), actionCode, signBy, signReason );
					BaseLogger.log("3",userInfo,null,"response String1:"+responseStr);
					String eventResult = "Success";
					if( responseStr.indexOf("<Errors>") != -1 )
					{
						eventResult = "Failure";
					}

					if( userEventLogEJB != null && userInfo != null )
					{
						//added by shrutika on 03-12-18  for updateEventLog.
						//userEventLogEJB.setEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), "", eventCode, eventCode, startTime, new Date(), "" , refID, eventResult, "WF" );
						//Change by shrutika on 05-01-19 for add exception.
						userEventLogEJB.updateEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), temEditorId, eventCode, eventCode, startTime, new Date(), "" , refID, eventResult, "WF","");
					}
					signStatusMap.put( refSer+"-"+refID, responseStr);
					//Change by Sandeep S. on 26-Sep-17 [To resolve issue of accep/reject workflow from push notification ]Start
					try
					{
						if( responseStr.indexOf("<Errors>") == -1 )
						{
							if ( refID != null && refID.trim().length() > 0)
							{
								BaseLogger.log("3",userInfo,null,"refID - ["+ refID +"]");
								addFollowUpAction( userId, "", refID, objName, context );
							}
						}
					}
					catch (Exception e)
					{
						e.printStackTrace();
					}
					//Change by Sandeep S. on 26-Sep-17 [To resolve issue of accep/reject workflow from push notification ]End
				}
				responseStr = multipleSignStatus( signStatusMap );
				BaseLogger.log("3",userInfo,null,"response String2:"+responseStr);
			}
			else if( SAVE_ACTION.equals( actionCode ) )
			{
				//added by shrutika on 03-12-18 [start] for updateEventLog.
				String tempEditorId = ""+new Date().getTime();
				//Added by shrutika on 25-12-18 [Start] for update status as Exception.
				tempobjName = objName;
				newEditorId = tempEditorId;
				tempstartTime = startTime;
				tempAction = eventCode;
				tempEvent = eventCode;
				argsParam = "";
				tempTranId = refId;
				//Added by shrutika on 25-12-18 [End] for update status as Exception.
				if( userEventLogEJB != null && userInfo != null )
				{
					//Change by shrutika on 05-01-19 for add exception.
					userEventLogEJB.setEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, eventCode, eventCode, startTime, null , "" , refId, "Pending", "WF","");
				}
				//added by shrutika on 03-12-18 [start] for updateEventLog.
				responseStr = signManager.saveTrans( objName, refSer, refId, lineNo, chgString, userInfo.toString(), signRemarks, null );
				String eventResult = "Success";
				if( responseStr.indexOf("<Errors>") != -1 )
				{
					eventResult = "Failure";
				}
				if( userEventLogEJB != null && userInfo != null )
				{
					//added by shrutika on 03-12-18 [start] for updateEventLog.
					//userEventLogEJB.setEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), "", eventCode, eventCode, startTime, new Date(), "" , refId, eventResult, "WF" );
					//Change by shrutika on 05-01-19 for add exception.
					userEventLogEJB.updateEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorId, eventCode, eventCode, startTime, new Date(), "" , refId, eventResult, "WF","");
				}
			}
		}
		catch (Exception e)
		{
			//Added by shrutika on 25-12-18 [Start] for update status as Exception.
			if( userEventLogEJB != null && userInfo != null )
			{
				//change by shrutika on 22-01-19 for parsing issue for writePrintStacktrace in updateEventLog.
				ITMException ie = new ITMException(e);
				userEventLogEJB.updateEventLog( userInfo.getLoginCode(), tempobjName, userInfo.getSesstionId(), newEditorId, tempAction, tempEvent, tempstartTime, new Date(), argsParam , tempTranId, "Exception", "WF",e.getMessage());
			}
			//Added by shrutika on 25-12-18 [End] for update status as Exception.

			BaseLogger.log("0",userInfo,null,"Exception: updateWrkFlwStatus :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		BaseLogger.log("0",userInfo,null,"response String3:"+responseStr);
		return responseStr;
	}
	
	/**
	 * Get Sign details
	 *
	 * @param signXMLStr
	 * @return
	 * @throws ITMException
	 */
	private ArrayList<String> getSignDetailList( String signXMLStr )throws ITMException
	{
		ArrayList<String> signDetailList = new ArrayList<String>();
		try
		{
			String signXML = genericUtility.getNormalizeString( signXMLStr );
			Document signDataDom = genericUtility.parseString( signXML );
			NodeList detailNodeList = signDataDom.getElementsByTagName("Detail");
			Node detailNode = detailNodeList.item(0);

			NodeList detailChildList = detailNode.getChildNodes();
			for(int dCtr = 0; dCtr < detailChildList.getLength(); dCtr++)
			{
				Node currChild = detailChildList.item(dCtr);
				if(!currChild.getNodeName().equalsIgnoreCase("attribute"))
				{
					if (currChild.getFirstChild() != null)
					{
						signDetailList.add( currChild.getFirstChild().getNodeValue() );
					}
					else
					{
						signDetailList.add( "" );
					}
				}
			}
		}
		catch (ITMException itme)
		{
			BaseLogger.log("0",userInfo,null,"ITMException :getSignDetailList :==>"+ itme.getMessage());
			throw itme;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",userInfo,null,"Exception :getSignDetailList :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		BaseLogger.log("2",userInfo,null, "signDetailList : "+ signDetailList );
		return signDetailList;
	}
	
	/**
	 * Return Treemap into string || Only One Transaction should get signed @ a time.
	 * input TreeMap : Due to display in accending order
	 *
	 * @param signStatusMap
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String multipleSignStatus( TreeMap<String, String> signStatusMap)throws RemoteException, ITMException
	{
		StringBuffer responseString = new StringBuffer();
		try
		{
			String str = "";
			BaseLogger.log("3",null,null, "multipleSignStatus: signStatusMap - ["+ signStatusMap +"]" );
			responseString.append( "<?xml version='1.0'?><Root>" );
			Iterator<String> iterator = signStatusMap.keySet().iterator();
			while (iterator.hasNext())
			{
				String refSerRefID = iterator.next();
				responseString.append( "<Detail id=\""+refSerRefID+"\">" );
				str = signStatusMap.get( refSerRefID ).toString();
				str = str.substring( str.indexOf(">") + 1, str.length() );
				responseString.append( str );
				responseString.append( "</Detail>" );
			}
			responseString.append( "</Root>" );
		}
		catch( Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: multipleSignStatus:==>"+ e.getMessage());
			throw new ITMException(e);
		}
		BaseLogger.log("2",null,null,"multipleSignStatus - ["+ responseString.toString() +"]");
		return responseString.toString();
	}
	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] END
	
	/**
	 * User Image write into ServletOutputStream if exist
	 *
	 * @param response
	 * @return
	 */
	private String getUserImage( HttpServletResponse response )
	{
		String result = "";
		try
		{
			String userId = "";
			if ( getUserInfo() != null )
			{
				userId = checkNull( getUserInfo().getLoginCode() );
			}
			if ( userId.length() > 0 )
			{
				String fileName = userId + ".png";
				String profileImagesPath = CommonConstants.APPLICATION_CONTEXT + "resource" + File.separator + "images" + File.separator + "users" + File.separator + fileName;
				File dir = new File( profileImagesPath );
				if( dir.exists() )
				{
					ServletOutputStream outputStream = response.getOutputStream();
					FileInputStream fis = new FileInputStream( profileImagesPath );
					byte[] buffer = new byte[(int) dir.length()];
					int length = 0;
					while ( (length = fis.read( buffer )) > 0 )
					{
						outputStream.write( buffer, 0, length );
					}
					fis.close();
					outputStream.flush();
					result = "success";
					response.setContentType( "image/png" );
					response.setBufferSize( buffer.length );
				}
				else
				{
					result = "User Image not found.";
				}
			}
			else
			{
				result = "Invalid User.";
			}
		}
		catch (FileNotFoundException e)
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		catch (IOException e)
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}

		return result;
	}
	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] END
	
	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] START
	/**
	 * Get attachment and write into ServletOutputStream
	 *
	 * @param refId
	 * @param refSer
	 * @param docType
	 * @param response
	 * @return
	 */
	private String getAttachDocument( String refId, String refSer, String docType, HttpServletResponse response )
	{
		String result = "";
		try
		{
			String resultXML = "";
			//DocumentHandlerRemote docHandler = (DocumentHandlerRemote) getInitialContext().lookup("ibase/DocumentHandlerEJB/remote");
			DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
			if ( refId != null && refId.indexOf(",") != -1 )
			{
				resultXML = docHandler.getMultiDocumentInfoList( refSer, refId, "", userInfo.getTransDB() );
			}
			else
			{
				resultXML = docHandler.getDocumentInfoList( refSer, refId, "", userInfo.getTransDB() );
			}
			HashMap<String, String> docIdMap = getDocumentIds( resultXML, docType );

			if ( docIdMap.size() > 0 )
			{
				byte[] byteArray = null;
				int count = 0;
				for ( Map.Entry<String, String> docIdEntry : docIdMap.entrySet() )
				{
					String docId = checkNull( docIdEntry.getKey() );
					String fileName = checkNull( docIdEntry.getValue() );
					String fileType = "";
					if ( fileName.length() > 0 )
					{
						fileType = fileName.substring( fileName.lastIndexOf(".") + 1 );
					}
					BaseLogger.log("3",null,null,"docId - ["+ docId +"], fileName - ["+ fileName +"], fileType - ["+ fileType +"]");
					if ( count == 0 )
					{
						//Changed by Prasad on 25/05/18 [enterprise implementation in attachment]
						//byteArray = docHandler.getDocument( docId, userInfo.getTransDB() );
						byteArray = docHandler.getDocument( docId, userInfo );
						setContentType( fileName, fileType, response );
						ServletOutputStream outputStream = response.getOutputStream();
						outputStream.write( byteArray );
						outputStream.flush();
						outputStream.close();
						break;
					}
					count++;
				}
				response.setBufferSize( byteArray.length );
				result = "success";
			}
			else
			{
				result = "No Document attached.";
			}
		}
		catch (ITMException e)
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		catch (RemoteException e)
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		/*catch (NamingException e)
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}*/
		catch (IOException e)
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}

		return result;
	}
	
	/**
	 * Set Content Type as per file type
	 *
	 * @param byteArray
	 * @param fileType
	 * @param response
	 */
	private void setContentType( String fileName, String fileType, HttpServletResponse response )
	{
		try
		{
			response.setHeader( "Content-disposition", "filename = \"" + fileName + "\"");
			if(fileType.equalsIgnoreCase("pdf"))
			{
				response.setContentType( "application/pdf; charset="+CommonConstants.ENCODING );
			}
			else if(fileType.equalsIgnoreCase("bmp"))
			{
				response.setContentType( "image/bmp" );
			}
			else if(fileType.equalsIgnoreCase("txt") || fileType.equalsIgnoreCase("dtd") || fileType.equalsIgnoreCase("java"))
			{
				response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
			}
			else if(fileType.equalsIgnoreCase("html") || fileType.equalsIgnoreCase("htm"))
			{
				response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("doc")  || fileType.equalsIgnoreCase("odt") )
			{
				response.setContentType( "application/msword; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("xls"))
			{
				response.setContentType( "application/msexcel; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("gif"))
			{
				response.setContentType( "image/gif" );
			}
			else if (fileType.equalsIgnoreCase("ai"))
			{
				response.setContentType( "application/postscript; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("abs"))
			{
				response.setContentType( "audio/x-mpeg" );
			}
			else if (fileType.equalsIgnoreCase("bin") || fileType.equalsIgnoreCase("exe"))
			{
				response.setContentType( "application/octet-stream; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("class"))
			{
				response.setContentType( "application/java; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("jpe") || fileType.equalsIgnoreCase("jpg") || fileType.equalsIgnoreCase("jpeg"))
			{
				response.setContentType( "image/jpeg" );
			}
			else if (fileType.equalsIgnoreCase("mpg") || fileType.equalsIgnoreCase("mpeg"))
			{
				response.setContentType( "video/mpeg" );
			}
			else if (fileType.equalsIgnoreCase("pic") || fileType.equalsIgnoreCase("pict") || fileType.equalsIgnoreCase("pict"))
			{
				response.setContentType( "image/pict" );
			}
			else if (fileType.equalsIgnoreCase("aif") || fileType.equalsIgnoreCase("aifc") || fileType.equalsIgnoreCase("aiff") )
			{
				response.setContentType( "audio/x-aiff" );
			}
			else if (fileType.equalsIgnoreCase("aim"))
			{
				response.setContentType( "application/x-aim" );
			}
			else if (fileType.equalsIgnoreCase("art"))
			{
				response.setContentType( "image/x-jg" );
			}
			else if (fileType.equalsIgnoreCase("asf") || fileType.equalsIgnoreCase("asx"))
			{
				response.setContentType( "video/x-ms-asf" );
			}
			else if (fileType.equalsIgnoreCase("avi"))
			{
				response.setContentType( "video/x-msvideo" );
			}
			else if (fileType.equalsIgnoreCase("avx"))
			{
				response.setContentType( "video/x-rad-screenplay" );
			}
			else if (fileType.equalsIgnoreCase("body"))
			{
				response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("css"))
			{
				response.setContentType( "text/css; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("dib"))
			{
				response.setContentType( "image/bmp" );
			}
			else if (fileType.equalsIgnoreCase("gz"))
			{
				response.setContentType( "application/x-gzip" );
			}
			else if (fileType.equalsIgnoreCase("jar"))
			{
				response.setContentType( "application/java-archive" );
			}
			else if (fileType.equalsIgnoreCase("js"))
			{
				response.setContentType( "text/javascript; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("midi"))
			{
				response.setContentType( "audio/x-midi" );
			}
			else if (fileType.equalsIgnoreCase("rtf"))
			{
				response.setContentType( "application/rtf" );
			}
			else if (fileType.equalsIgnoreCase("rtx"))
			{
				response.setContentType( "text/richtext; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("tif") || fileType.equalsIgnoreCase("tiff"))
			{
				response.setContentType( "image/tiff" );
			}
			else if (fileType.equalsIgnoreCase("xml") || fileType.equalsIgnoreCase("xsl"))
			{
				response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("ppt"))
			{
				response.setContentType( "application/powerpoint" );
			}
			else if (fileType.equalsIgnoreCase("ppm"))
			{
				response.setContentType( "image/x-portable-pixmap" );
			}
			else if (fileType.equalsIgnoreCase("png"))
			{
				response.setContentType( "image/png" );
			}
			else if (fileType.equalsIgnoreCase("oda"))
			{
				response.setContentType( "application/oda" );
			}
			else if (fileType.equalsIgnoreCase("zip"))
			{
				response.setContentType( "application/zip" );
			}
			else
			{
				response.setContentType( "application/octet-stream; charset="+CommonConstants.ENCODING );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * Get document id from xmlstring
	 *
	 * @param xmlStr
	 * @param docType
	 * @return
	 * @throws ITMException
	 */
	private HashMap<String, String> getDocumentIds( String xmlStr, String docType ) throws ITMException
	{
		HashMap<String, String> docIdMap = new LinkedHashMap<String, String>();
		try
		{
			Node childNode = null;
			Node node = null;
			NodeList childList = null;
			docType = checkNull( docType );
			if( checkNull( xmlStr ).length() > 0 )
			{
				Document dom = genericUtility.parseString( xmlStr );
				NodeList nodeList = dom.getElementsByTagName( "ID" );
				for( int cnt = 0; cnt < nodeList.getLength(); cnt++ )
				{
					String docId = "";
					node = nodeList.item(cnt);
					if( node.hasAttributes() )
					{
						docId = node.getAttributes().getNamedItem("Document_Id").getNodeValue();
					}
					childList = node.getChildNodes();
					String attachDocType = "";
					String docName = "";
					for( int cnt1 = 0; cnt1 < childList.getLength() ; cnt1++ )
					{
						childNode = childList.item(cnt1);
						if( childNode.getNodeName().equalsIgnoreCase( "docTypeAttach" ) )
						{
							attachDocType = checkNull( childNode.getNodeValue() );
							if( childNode.getFirstChild() != null )
							{
								attachDocType = checkNull( childNode.getFirstChild().getNodeValue() );
							}
						}
						else if( childNode.getNodeName().equalsIgnoreCase( "Name" ) )
						{
							docName = checkNull( childNode.getNodeValue() );
							if( childNode.getFirstChild() != null )
							{
								docName = checkNull( childNode.getFirstChild().getNodeValue() );
							}
						}
					}
					BaseLogger.log("3",null,null,"attachDocType - ["+ attachDocType +"], docId - ["+ docId +"], docName - ["+ docName +"]");
					if ( docType.length() > 0 )
					{
						if ( attachDocType.length() > 0 && attachDocType.equals( docType ) )
						{
							docIdMap.put( docId, docName );
						}
					}
					else
					{
						docIdMap.put( docId, docName );
					}
				}
			}
			BaseLogger.log("3",null,null,"docIdMap - "+ docIdMap);
		}
		catch (DOMException e)
		{
			e.printStackTrace();
		}
		return docIdMap;
	}
	
	private String uploadDocument( HttpServletRequest request ) throws ITMException
	{
		String retString = "";
		try
		{
			String retXMLStr = "";
			byte[] byteArray = {0};
			byte[] videoFrameBytes = {0};

			int MEMORY_THRESHOLD   = 1024 * 1024 * 3;  // 3MB
			int MAX_FILE_SIZE      = 1024 * 1024 * 40; // 40MB
			int MAX_REQUEST_SIZE   = 1024 * 1024 * 50; // 50MB

			// configures upload settings
			DiskFileItemFactory factory = new DiskFileItemFactory();
			// sets memory threshold - beyond which files are stored in disk
			factory.setSizeThreshold(MEMORY_THRESHOLD);
			// sets temporary location to store files
			factory.setRepository(new File(System.getProperty("java.io.tmpdir")));

			ServletFileUpload upload = new ServletFileUpload(factory);

			// sets maximum size of upload file
			upload.setFileSizeMax(MAX_FILE_SIZE);

			// sets maximum size of request (include file + form data)
			upload.setSizeMax(MAX_REQUEST_SIZE);

			// parses the request's content to extract file data
			List<FileItem> formItems = upload.parseRequest(request);

			if (formItems != null && formItems.size() > 0)
			{
				String fieldName = "";
				// iterates over form's fields
				for (FileItem item : formItems)
				{
					// processes only fields that are not form fields
					fieldName = item.getFieldName();
					BaseLogger.log("3",null,null, "fieldName : ["+ fieldName +"]" );
					if ( item.isFormField() )
					{
						String fieldValue = item.getString();
						BaseLogger.log("3",null,null, "fieldValue : ["+ fieldValue +"]" );

						if ( "UPLOAD_XML_STR".equalsIgnoreCase( fieldName ) )
						{
							retXMLStr = fieldValue;
						}
						else if ( "USER_INFO".equalsIgnoreCase( fieldName ) )
						{
							if ( fieldValue != null )
							{
								this.userInfo = new UserInfoBean( fieldValue );
							}
						}
					}
					else if ( ! item.isFormField() )
					{
						String fileName = new File( item.getName() ).getName();
						BaseLogger.log("3",null,null, "fileName : ["+ fileName +"]" );

						if ( "fileBytes".equalsIgnoreCase( fieldName ) )
						{
							byteArray = item.get();
							BaseLogger.log("3",null,null, "byteArray : ["+ byteArray +"]" );
						}
						else if ( "videoFrameBytes".equalsIgnoreCase( fieldName ) )
						{
							videoFrameBytes = item.get();
							BaseLogger.log("3",null,null, "videoFrameBytes : ["+ videoFrameBytes +"]" );
						}
					}
				}
			}
			//DocumentHandlerWrapperRemote docHandler = (DocumentHandlerWrapperRemote) getInitialContext().lookup( "ibase/DocumentHandlerWrapperEJB/remote" );
			//DocumentHandlerWrapperEJB docHandler = new DocumentHandlerWrapperEJB();
			DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
			retString = docHandler.addDocument( retXMLStr, byteArray, videoFrameBytes, getUserInfo() );
			docHandler = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception :: uploadDocument : ["+ e.getMessage() +"]" );
			throw new ITMException(e);
		}
		return retString;
	}
	
	//Added by sunny soni on 03-OCT-19 for uploading CaptureImage from browser notification sent in attachments and return websocket message[Start]
	private String getAttachmentDetailStr(String objName, String refSer, String refId, String filePath, File file, UserInfoBean userinfobean)
	{
		StringBuffer retXMLStringBuff = new StringBuffer();
		try
		{
			String fileName = file.getName();
			String fileType = filePath.substring( filePath.lastIndexOf(".") + 1 );

			retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\""+CommonConstants.ENCODING+"\"?>");
			retXMLStringBuff.append("<DocumentRoot>");
			retXMLStringBuff.append("<description>Datawindow Root</description>");
			retXMLStringBuff.append("<group0>");
			retXMLStringBuff.append("<description>Group0 description</description>");
			retXMLStringBuff.append("<Header0>");
			retXMLStringBuff.append("<description>Header0 members</description>");
			retXMLStringBuff.append("<header>");
			retXMLStringBuff.append("<ref_id><![CDATA[").append(refId).append("]]></ref_id>");
			retXMLStringBuff.append("<ref_col><![CDATA[").append(" ").append("]]></ref_col>");
			retXMLStringBuff.append("<obj_name><![CDATA[").append(objName).append("]]></obj_name>");
			retXMLStringBuff.append("<ref_ser><![CDATA[").append(refSer).append("]]></ref_ser>");
			retXMLStringBuff.append("<doc_name><![CDATA[").append(fileName).append("]]></doc_name>");
			retXMLStringBuff.append("<doc_type><![CDATA[").append(fileType).append("]]></doc_type>");
			//retXMLStringBuff.append("<document_type><![CDATA[").append("null").append("]]></document_type>");
			//retXMLStringBuff.append("<file_type><![CDATA[").append(attachFileType).append("]]></file_type>");
			retXMLStringBuff.append("<created_by><![CDATA[").append(userinfobean.getLoginCode()).append("]]></created_by>");
			//retXMLStringBuff.append("<doc_link_optn><![CDATA[" + docLinkOptn + "]]></doc_link_optn>");
			//retXMLStringBuff.append("<ref_descr><![CDATA[" + refDescr + "]]></ref_descr>");
			//retXMLStringBuff.append("<doc_pages><![CDATA[" + noOfPages + "]]></doc_pages>");
			//retXMLStringBuff.append("<extracted_data><![CDATA[" + extractedData + "]]></extracted_data>");
			// Changed by Pravin K on 25-JAN-19 [ Added fileMetadata To store last modify date]
			//retXMLStringBuff.append("<file_metadata><![CDATA[" + fileMetadata + "]]></file_metadata>");// pa // 25-JAN

			//Added by Saitej D on [14-Mar-2019] [To get expiry date & allow download of document for content library] START
			//retXMLStringBuff.append("<exp_date><![CDATA[" + expDate + "]]></exp_date>");
			//retXMLStringBuff.append("<cache_opt><![CDATA[" + cacheOpt + "]]></cache_opt>");
			//Added by Saitej D on [14-Mar-2019] [To get expiry date & allow download of document for content library] END

			//retXMLStringBuff.append("<module><![CDATA[" + module + "]]></module>");
			retXMLStringBuff.append("</header>");
			retXMLStringBuff.append("</Header0>");
			retXMLStringBuff.append("</group0>");
			retXMLStringBuff.append("</DocumentRoot>");

			BaseLogger.log("3", userInfo, null, "getAttachmentDetailStr [" + retXMLStringBuff + "]");
			return retXMLStringBuff.toString();
		}
		catch (Exception e)
		{
			retXMLStringBuff.delete(0, retXMLStringBuff.length());
			retXMLStringBuff.append("[getAttachmentDetailStr] Exception :: "+e.getMessage());
			e.printStackTrace();
			BaseLogger.log("0",null,null,"[getAttachmentDetailStr] Exception :: "+e.getMessage());
			return retXMLStringBuff.toString();
		}
	}
	
	private void sendWebSocketNotification(String xmlString, String docAttachType, ArrayList<String> userIdList, String fileName, WebSocketMessageType type)
	{
		try
		{
			xmlString = checkNull( xmlString );
			docAttachType = checkNull( docAttachType );
			fileName = checkNull( fileName );
			if( userIdList != null && userIdList.size() > 0 && xmlString.length() > 0 )
			{
				String wsMessageStr = xmlString+ " ~ " + fileName + " ~ "+ docAttachType;
				JSONObject wsMessage = new JSONObject();
				JSONArray userIds = new JSONArray(userIdList);
				wsMessage.put("user_ids", userIds);

				JSONObject webSocketMsgWithType = new JSONObject();
				webSocketMsgWithType.put("type", String.valueOf(type));
				webSocketMsgWithType.put("data", wsMessageStr);
				wsMessage.put("message", webSocketMsgWithType);

				ClientWebsocketNotification clientWebsocketNotification = new ClientWebsocketNotification();
				clientWebsocketNotification.sendMessage( wsMessage );
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"[sendWebSocketNotification] Exception :: "+e.getMessage());
			e.printStackTrace();
		}
	}
	//Added by sunny soni on 03-OCT-19 for uploading CaptureImage from browser notification sent in attachments and return websocket message[End]
	
	/**
	 * Get Authentication Status value
	 *
	 * @param xmlInfo
	 * @return
	 * @throws BaseException
	 */
	private boolean getAuthenticationStatus( String xmlInfo ) throws BaseException
	{
		boolean flag = false;
		try
		{
			Document document = genericUtility.parseString( xmlInfo );
			if ( document.getElementsByTagName("STATUS").item(0) != null
					&& document.getElementsByTagName("STATUS").item(0).getFirstChild() != null )
			{
				flag = Boolean.valueOf(	document.getElementsByTagName("STATUS").item(0).getFirstChild().getNodeValue() ).booleanValue();
			}
		}
		catch (BaseException be)
		{
			BaseLogger.log("0",null,null,"BaseException: getAuthenticationStatus: "+ be.getMessage());
			throw be;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: getAuthenticationStatus: "+ e.getMessage());
			throw new BaseException(e);
		}
		BaseLogger.log("2",null,null,"Authentication Status :["+ flag +"]");
		return flag;
	}
	
	/**
	 * to check null and undefined value
	 *
	 * @param input
	 * @return
	 */
	/*private String checkNull(String input)
	{
		if ( input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input) )
		{
			input= "";
		}
		return input.trim();
	}*/
	
	/**
	 * get a print stack trace
	 *
	 * @param e
	 * @return
	 */
	/*private String getStackTrace( Exception e )
	{
		//StringWriter exception = new StringWriter();
		//try
		//{
		//	e.printStackTrace( new PrintWriter( exception ) );
		//}
		//catch (Exception e1)
		//{
		//	e1.printStackTrace();
		//}
		String exception = "";
		if ( genericUtility == null )
		{
			genericUtility = new E12GenericUtility();
		}
		exception = genericUtility.createErrorString(e);
		return exception;
	}*/
	//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] END
	
	//Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] START
	/**
	 * Validate User Request
	 *
	 * @param request
	 * @param dataFormat
	 * @param tokenId
	 * @return
	 */
	private String validateRequest( HttpServletRequest request, String dataFormat )
	{
		String validStr = "valid";
		try
		{
			//Commented by Prasad on 02/Sep/2020 [As suggested by KB Sir, no need to check at code level, it should be handled at application level] START
			/*if ( request.isSecure() )
			{
				BaseLogger.log("3",null,null,"in validat request ");
				validStr = "This option is only available with 'Https'.";
			}
			else*/
			//Commented by Prasad on 02/Sep/2020 [As suggested by KB Sir, no need to check at code level, it should be handled at application level] END
			if ( ! isValidDataFormat( dataFormat ) )
			{
				validStr = "Please enter valid Data Format.";
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : validateRequest : "+ e.getMessage() );
			validStr = getStackTrace(e);
		}
		return validStr;
	}
	
	/**
	 * To get CommonDBAccessRemote object
	 *
	 * @return
	 * @throws BaseException
	 */
	/*private CommonDBAccessEJB getCommonDBAccess() throws BaseException
	{
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
		//CommonDBAccessRemote ejbObj = null;
		CommonDBAccessEJB ejbObj = null;
		// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
		try
		{
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [START]
			//ejbObj = (CommonDBAccessRemote) getInitialContext().lookup("ibase/CommonDBAccessEJB/remote");
			ejbObj = new CommonDBAccessEJB();
			// Commented and Added by Pankaj R on 20-JUL-18 to change calling of EJB to JB [END]
		}
		//catch( BaseException be )
		//{
		//	BaseLogger.log("9",null,null,"Exception: getCommonDBAccess:==>\n"+be);
		//	throw be;
		//}
		catch( Exception e )
		{
			BaseLogger.log("0",null,null,"Exception: getCommonDBAccess:==>\n"+e);
			throw new BaseException( e );
		}
		return ejbObj;
	}*/
	//Changed by Prasad on 18/02/16 [for validating user] END
	
	//Added by Umakanta Das on 05-MAY-2017 [ A16LSUN004 ] [ To decript data as per encrypted data on mobile app.]Start
	/**
	 * This Metod returns decrypt value.
	 * @param CIPHER_TEXT
	 * @return decrypt value
	 */
	private  String  decrypt( String CIPHER_TEXT )
	{
		String IV =   "07000000000000000000000000000008";
		String SALT = "07000000000000000000000000000008";
		int KEY_SIZE = 128;
		int ITERATION_COUNT = 10000;
		String PASSPHRASE = "sunpharmametis";
		String decrypt = decrypt(SALT, IV, PASSPHRASE, CIPHER_TEXT, ITERATION_COUNT, KEY_SIZE );
		return decrypt;
	}

	private String decrypt( String salt, String iv, String passphrase, String ciphertext, int iterationCount, int keySize )
	{
		try
		{
			SecretKey key = generateKey( salt, passphrase , iterationCount, keySize );
			byte[] decrypted = doFinal( Cipher.DECRYPT_MODE, key, iv, base64(ciphertext) );
			return new String(decrypted, "UTF-8");
		}
		catch ( UnsupportedEncodingException e )
		{
			throw fail(e);
		}
	}

	private SecretKey generateKey( String salt, String passphrase, int iterationCount, int keySize )
	{
		try
		{
			SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
			KeySpec spec = new PBEKeySpec(passphrase.toCharArray(), hex(salt), iterationCount, keySize);
			SecretKey key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
			return key;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return null;
		}
	}

	public static byte[] base64(String str)
	{
		return DatatypeConverter.parseBase64Binary(str);
	}

	public static String hex(byte[] bytes)
	{
		return DatatypeConverter.printHexBinary(bytes);
	}

	public static byte[] hex(String str)
	{
		return DatatypeConverter.parseHexBinary(str);
	}

	private IllegalStateException fail(Exception e)
	{
		return new IllegalStateException(e);
	}
	
	private byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes)
	{
		try
		{
			Cipher cipher;

			cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
			cipher.init(encryptMode, key, new IvParameterSpec(hex(iv)));
			return cipher.doFinal(bytes);

		}
		catch (Exception e) {
			e.printStackTrace();
			throw fail(e);
		}
	}
	//Added by Umakanta Das on 05-MAY-2017 [ A16LSUN004 ] [ To decript data as per encrypted data on mobile app.]End
	//Added by Umakanta Das on 05/MAY/2017 [ A16LSUN004 ] [ Receive request from third party mobile app and return Pay slip data with json format ]End
	
	private int validateRequest( String usrLicType, String enterprise ) throws ITMException
	{
		int licUsrsCnt = 0;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver conDriver = null;
		ResultSet rs = null;
		try
		{
			conDriver = new ConnDriver();
			conn = conDriver.getConnectDB("Driver");

			String sql = "SELECT LIC_USERS FROM ENTP_USERS_LICENCE WHERE TRIM(ENTERPRISE)=? AND USER_LIC_TYPE=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, enterprise );
			pstmt.setString( 2, usrLicType );

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				licUsrsCnt = rs.getInt(1);
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt = null;
			conn.close(); conn = null;
		}
		catch(ITMException itme)
		{
			BaseLogger.log("0",null,null,"ITMException ::E12ExtService :validateRequest :==>["+itme.getMessage()+"]");
			throw itme;
		}
		catch(SQLException ie)
		{
			BaseLogger.log("0",null,null,"SQLException ::E12ExtService :validateRequest:==>["+ie.getMessage()+"]");
			throw new ITMException(ie);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception ::E12ExtService :validateRequest:==>["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
					{
						pstmt.close(); pstmt = null;
					}
					conn.close(); conn = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		return licUsrsCnt;
	}
	
	private String createHashCode(String data) throws UnsupportedEncodingException, ITMException
	{
		String encData=encrypt(data);
		BaseLogger.log("2",null,null,"encoded["+encData+"]");
		return encData;
	}

	private String encrypt(String as_passwd)
	{
		BaseLogger.log("2",null,null,"E12ExtService..................encrypt...............");
		String ls_return = "";
		try
		{
			BaseLogger.log("3",null,null, "Encrypting Password....." );
			int li_len, li_count, li_Seed, li_passAsc;
			li_len = as_passwd.length();
			for(li_count = 0; li_count < li_len;li_count++)
			{
				Random li_Seed_r = new Random();
				li_Seed = li_Seed_r.nextInt(10);
				li_passAsc  =(int) as_passwd.charAt(li_count);
				li_passAsc = li_passAsc + li_Seed + li_count;
				ls_return +=""+(char)(li_passAsc) +""+ (char)(li_Seed + li_count);
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception: E12ExtService: encrypt:==>\n"+e.getMessage());
		}
		BaseLogger.log("2",null,null,"E12ExtService..................encrypt.......["+ls_return+"]....");
		return ls_return;
	}
	//added by vishal pathare on 1.8.18 for[users licence related security]End
	
	private Object getReportArgStr( String reportFileName, String attachType, String xsdString, UserInfoBean userInfo ) throws ITMException, JSONException
	{
		JSONObject repArgJson = new JSONObject();
		StringBuffer reportArgString = new StringBuffer();
		String respArgString = "";
		String status = "";
		try
		{
			reportArgString.append( "<Arguments>" );
			if ( xsdString != null && xsdString.length() > 0 )
			{
				HashMap<String, String> userInfoMap = getUserInfoMapJasper( userInfo );

				Document doc = genericUtility.parseString( xsdString );
				NodeList argNodeList = doc.getElementsByTagName( "argument" );
				if( argNodeList != null )
				{
					for( int argCnt = 0; argCnt <= argNodeList.getLength(); argCnt++ )
					{
						Node argNode = argNodeList.item(argCnt);
						if(argNode != null)
						{
							String argName = "";
							String argType = "";
							String argValue = "";
							Node attribute = null;
							attribute = argNode.getAttributes().getNamedItem("name");
							if( attribute != null && attribute.getFirstChild() != null )
							{
								argName = attribute.getFirstChild().getNodeValue();
							}
							attribute = argNode.getAttributes().getNamedItem("type");
							if( attribute != null && attribute.getFirstChild() != null )
							{
								argType = attribute.getFirstChild().getNodeValue();
							}
							attribute = argNode.getAttributes().getNamedItem("value");
							if( attribute != null && attribute.getFirstChild() != null )
							{
								argValue = attribute.getFirstChild().getNodeValue();
							}
							if ( userInfoMap != null && userInfoMap.containsKey( argValue.toLowerCase() ) )
							{
								argValue = userInfoMap.get( argValue.toLowerCase() );
								reportArgString.append( "<Argument id=\""+argName+"\" name=\""+argName+"\"><argType>"+argType+"</argType><value>"+argValue+"</value></Argument>" );
							}
							else
							{
								if("report_save_type".equalsIgnoreCase(argName))
								{
									reportArgString.append( "<Argument id=\""+argName+"\" name=\""+argName+"\"><argType>"+argType+"</argType><value>"+attachType.toUpperCase()+"</value></Argument>" );
								}
								else
								{
									reportArgString.append( "<Argument id=\""+argName+"\" name=\""+argName+"\"><argType>"+argType+"</argType><value>"+argValue+"</value></Argument>" );
								}
							}
						}
					}
				}
			}
			reportArgString.append( "</Arguments>" );
			respArgString = reportArgString.toString();
			BaseLogger.log("3", userInfo,null,"In genReportArgStr : ["+ respArgString +"]" );

			status = "Success";
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception :: genReportArgStr : ["+ e.getMessage() +"]" );

			respArgString = getStackTrace(e);
			status = "Exception";
		}
		repArgJson.put("response", respArgString);
		repArgJson.put("status", status);
		return repArgJson;
	}
	
	private Object createSession(String userCode, String password, String isPwdEncrypt, HttpServletRequest request) throws JSONException
	{
		JSONObject respJson = new JSONObject();

		userCode = checkNull( userCode );
		password = checkNull( password );
		String result = "";
		String status = "";
		try
		{
			isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
			String isValidLogin = "false";
			if ( userCode.length() > 0 )
			{
				isValidLogin = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
				if ( "VALID".equalsIgnoreCase( isValidLogin ) )
				{
					request.getSession().setAttribute( "USER_INFO", getUserInfo() );
					result = "true";
					status = "Success";
				}
				else
				{
					result = isValidLogin;
					status = "error";
				}
			}
			else
			{
				result = "Please enter username.";
				status = "error";
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception: @createSession ["+ e.getMessage() +"]" );
			result = getStackTrace(e);
			status = "Exception";
		}
		respJson.put("status", status);
		respJson.put("result", result);
		return respJson;
	}
	
	private HashMap<String, String> getUserInfoMapJasper( UserInfoBean userInfo ) throws ITMException
	{
		HashMap<String, String> userInfoMap = new HashMap<String, String>();
		try
		{
			if ( userInfo != null )
			{
				String user = userInfo.getLoginCode();
				String entityCode = userInfo.getEntityCode();
				String profileId = userInfo.getProfileId();
				String empCode = userInfo.getEmpCode();
				String reportTo = userInfo.getReportTo();
				String deptCode = userInfo.getDeptCode();
				String userLev = userInfo.getUserLevel();
				String userType = userInfo.getUserType();
				String loginSite = userInfo.getSiteCode();
				if ( entityCode == null )
				{
					entityCode = "";
				}
				if ( user == null )
				{
					user = "";
				}

				userInfoMap.put( "login_site", loginSite );
				userInfoMap.put( "login_code", user );
				userInfoMap.put( "entity_code", entityCode );
				userInfoMap.put( "profile_id", profileId );
				userInfoMap.put( "report_to", reportTo );
				userInfoMap.put( "dept_code", deptCode );
				userInfoMap.put( "user_lev", userLev );
				userInfoMap.put( "user_type", userType );
				userInfoMap.put( "emp_code", empCode );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		return userInfoMap;
	}
	
	private Object getReportResp(String retString, String objName, String userCode, String reportargStr, String status, HttpServletRequest request, HttpServletResponse response) throws ITMException, JSONException
	{
		JSONObject reportResp = new JSONObject();

		try
		{
			String path = CommonConstants.TOMCAT_HOME;

			if(request.getSession().getAttribute("USER_INFO") != null)
			{
				userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
				userCode = userInfo.getLoginCode();
			}
			//BaseLogger.log("3", userInfo,null,"userInfo:: ["+ userInfo +"]" );
			String attachType = "PDF";
			double dummyInt = Math.random();
			String profileId = userInfo.getProfileId();
			String isExplore = "Yes";
			String browserType = "IE";
			//BaseLogger.log("3", userInfo,null,"profileId:: ["+ profileId +"]" );
			attachType = URLEncoder.encode( attachType, CommonConstants.ENCODING);
			profileId = URLEncoder.encode( profileId, CommonConstants.ENCODING);
			reportargStr = URLEncoder.encode( reportargStr, CommonConstants.ENCODING);

			String urlStr = path+"/ibase/WebITMRequestHandlerServlet?ACTION=VIEW_REPORT"
					+ "&OBJ_NAME="+ objName +""
					+ "&PROFILEID="+ profileId +""
					+ "&ARGUMENTXML="+ reportargStr +""
					+ "&report_save_type="+ attachType +""
					+ "&USER_CODE="+ userCode +""
					+ "&ISExplore="+ isExplore +""
					+ "&BROWSER_TYPE="+ browserType +"" //Added by Sainath To get the file path in response
					+ "&dummyInt="+ dummyInt;

			//BaseLogger.log("3", userInfo,null,"urlStr :: 1682["+ urlStr +"] \n userInfo.getSesstionId() ["+userInfo.getSesstionId()+"]");
			String response_ = "";
			E12GenericUtility genericUtility = new E12GenericUtility();
			FileInputStream fileInput = null;

			response_ = makeRequest( urlStr, "", userInfo.getSesstionId() );
			//BaseLogger.log("3", userInfo,null,"openReportIntent response: "+ response_);

			//changed by sainath T. 21-Nov-19 [to avoid file separator issue]
			//if(response_.indexOf("<Errors>") == -1 && response_.indexOf("/ibase") != -1)
			if(response_.indexOf("<Errors>") == -1 && (response_.indexOf(File.separator + "ibase") != -1 )) 
			{
				response_ = response_.substring(6,response_.length());
				//BaseLogger.log("3", userInfo,null,"response substring: "+ response_);
				String fileName = response_.substring(response_.lastIndexOf( File.separator ) + 1);
				String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
				String filepath = CommonConstants.APPLICATION_CONTEXT + response_;
				//BaseLogger.log("3", userInfo,null,"fileName - ["+ fileName +"], fileType - ["+ fileType +"] filepath[" +filepath+ "]");
				fileInput = new FileInputStream(filepath) ;
				//Added by Saiprasad G. 16-MAR-2020[Mail Jasper Report] START 
				if("SEND_MAIL".equalsIgnoreCase(retString))
				{
					retString = filepath;
					System.out.println("SEND_MAIL retString :[" + retString + "]");
				}
				else
				{
					setContentType( fileName, fileType, response );
					ServletOutputStream outputStream = response.getOutputStream();
					IOUtils.copy(fileInput, outputStream);
					outputStream.flush();
					outputStream.close();
				}
				//Added by Saiprasad G. 16-MAR-2020[Mail Jasper Report] END
				status = "Success";
			}
			//else if(response_.indexOf("<Errors>") == -1 && response_.indexOf("/ibase") == -1)
			else if(response_.indexOf("<Errors>") == -1 && response_.indexOf(File.separator + "ibase") == -1)
			{
				/*retString = "Error in executing the report.";
				status = "error";*/
				retString = "No data found.";
				status = "success";
			}
			else if(response_.indexOf("<Errors>") != -1)
			{
				retString = genericUtility.getErrorMsgDescr(response_);
				status = "error";
			}
			//BaseLogger.log("3", userInfo,null,"retString11 ["+retString+"] objName[" +objName+ "] userCode["+userCode+"] reportargStr["+reportargStr+"] status[" + status +"" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("3", userInfo,null, "getReportResp IOException - 1734 ["+ e.getMessage() +"]" );
			retString = getStackTrace(e);
			status = "exception";
		}
		reportResp.put("result", retString);
		reportResp.put("status", status);
		return reportResp;
	}
	
	/**
	 * Create a request and return response
	 *
	 * @param urlStr
	 * @param xmlString
	 * @param userInfo
	 * @return
	 */
	public String makeRequest(String urlStr, String xmlString, String sessionId )
	{
		String response = "";
		URL url = null;
		HttpURLConnection conn = null;
		StringBuffer responseBuff = new StringBuffer();
		try
		{
			url = new URL( urlStr );
			conn = (HttpURLConnection) url.openConnection();
			conn.setDoOutput( true );
			conn.setRequestMethod( "POST" );
			conn.setRequestProperty( "Content-Type", "application/x-www-form-urlencoded" );
			conn.setRequestProperty( "Cookie", "JSESSIONID=" + URLEncoder.encode(sessionId, CommonConstants.ENCODING) );
			BaseLogger.log("3", userInfo,null,"URL: ["+ url +"]" );

			DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
			wr.writeBytes( xmlString );
			wr.flush();

			BufferedReader br = new BufferedReader( new InputStreamReader( ( conn.getInputStream() ) ) );
			while ( ( response = br.readLine() ) != null )
			{
				responseBuff.append( response );
			}
			response = responseBuff.toString();
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,null,"RequestHandlerServlet makeRequest Exception 1710- ["+ e.getMessage()+"]" );
		}
		finally
		{
			conn.disconnect();
		}
		BaseLogger.log("0", userInfo,null, "Final response retString: "+ response );
		return response;
	}
	//Added by Sainath T. on 01-NOV-2019[Jasper report related implementation] -End
	
	private void sendMail(UserInfoBean userInfo, String retString, String mailFormatCode) 
	{
		Connection userConn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String to="",cc="",sub="",emailID="",message="";
		try
		{		
			ibase.utility.EMail emailObj = new ibase.utility.EMail();
			StringBuffer mailInfoXml = new StringBuffer();
			ConnDriver connDriver = new ConnDriver();
			if(userInfo != null)
			{
				userConn = connDriver.getConnectDB( userInfo.getTransDB() );
			}
			else
			{
				userConn = connDriver.getConnectDB( "Driver" );
			}
			String userSql = "SELECT SEND_TO,COPY_TO,BLIND_COPY,SUBJECT,BODY_TEXT FROM MAIL_FORMAT WHERE FORMAT_CODE = ? ";

			pstmt = userConn.prepareStatement(userSql);
			pstmt.setString(1, mailFormatCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				to = rs.getString("SEND_TO");
				cc = rs.getString("COPY_TO");
				sub = rs.getString("SUBJECT");
				message = rs.getString("BODY_TEXT");
			}
			if( "user_id__attend".equalsIgnoreCase( to ))
			{
				emailID = userInfo.getLoginEmailId();
			}
			else
			{
				emailID = to;
			}
			System.out.println("E12ExtService.sendMail() : emailID "+emailID);

			pstmt.close();
			rs.close();
			userConn.close();

			mailInfoXml.append("<ROOT>");
			mailInfoXml.append("<MESSAGE_TYPE><![CDATA[text/html]]></MESSAGE_TYPE>");
			mailInfoXml.append("<EMAIL_TYPE><![CDATA[page]]></EMAIL_TYPE>");
			mailInfoXml.append("<TO_ADD><![CDATA["+ (emailID)+"]]></TO_ADD>");  
			mailInfoXml.append("<CC_ADD><![CDATA["+cc+"]]></CC_ADD>");   
			mailInfoXml.append("<SUBJECT><![CDATA["+sub+"]]></SUBJECT>");
			mailInfoXml.append("<BODY_TEXT><![CDATA["+message+"]]></BODY_TEXT>");
			mailInfoXml.append("<XML_DATA_FILE_PATH><![CDATA["+retString+"]]></XML_DATA_FILE_PATH>");
			mailInfoXml.append("</ROOT>");
			emailObj.sendMail(mailInfoXml.toString(),"ITM", userInfo);
		}
		catch(Exception e)
		{
			System.out.println("exception"+e);
		}
		finally 
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(userConn != null)
				{
					userConn.close();
					userConn = null;
				}
			}
			catch (Exception e) {


			}
		}
	}
	
	private Object getReportArgStr( String reportFileName, String attachType, String xsdString, UserInfoBean userInfo, JSONObject argValues ) throws ITMException, JSONException
	{
		JSONObject repArgJson = new JSONObject();
		StringBuffer reportArgString = new StringBuffer();
		String respArgString = "";
		String status = "";
		try
		{
			reportArgString.append( "<Arguments>" );
			if ( xsdString != null && xsdString.length() > 0 )
			{
				HashMap<String, String> userInfoMap = getUserInfoMapJasper( userInfo );

				Document doc = genericUtility.parseString( xsdString );
				NodeList argNodeList = doc.getElementsByTagName( "argument" );
				if( argNodeList != null )
				{
					for( int argCnt = 0; argCnt <= argNodeList.getLength(); argCnt++ )
					{
						Node argNode = argNodeList.item(argCnt);
						if(argNode != null)
						{
							String argName = "";
							String argType = "";
							String argValue = "";
							Node attribute = null;
							attribute = argNode.getAttributes().getNamedItem("name");
							if( attribute != null && attribute.getFirstChild() != null )
							{
								argName = attribute.getFirstChild().getNodeValue();
							}
							attribute = argNode.getAttributes().getNamedItem("type");
							if( attribute != null && attribute.getFirstChild() != null )
							{
								argType = attribute.getFirstChild().getNodeValue();
							}
							attribute = argNode.getAttributes().getNamedItem("value");
							if( attribute != null && attribute.getFirstChild() != null )
							{
								argValue = attribute.getFirstChild().getNodeValue();
							}
							if ( userInfoMap != null && userInfoMap.containsKey( argValue.toLowerCase() ) )
							{
								argValue = userInfoMap.get( argValue.toLowerCase() );
								reportArgString.append( "<Argument id=\""+argName+"\" name=\""+argName+"\"><argType>"+argType+"</argType><value>"+argValue+"</value></Argument>" );
							}
							else
							{
								if("report_save_type".equalsIgnoreCase(argName))
								{
									argValue = attachType.toUpperCase();
								}
								else if( argValues != null && argValues.has(argName) )
								{
									argValue = argValues.optString(argName);
								}
								reportArgString.append( "<Argument id=\""+argName+"\" name=\""+argName+"\"><argType>"+argType+"</argType><value>"+argValue+"</value></Argument>" );
							}
						}
					}
				}
			}
			reportArgString.append( "</Arguments>" );
			respArgString = reportArgString.toString();
			BaseLogger.log("3", userInfo,null,"In genReportArgStr : ["+ respArgString +"]" );

			status = "Success";
		}
		catch (Exception e)
		{
			BaseLogger.log("0", userInfo,null,"Exception :: genReportArgStr : ["+ e.getMessage() +"]" );

			respArgString = getStackTrace(e);
			status = "Exception";
		}
		repArgJson.put("response", respArgString);
		repArgJson.put("status", status);
		return repArgJson;
	}
	

	
	//Added by Amey W. [ For validate WHITE_LIST_IP ] on 21-09-2020 START
	/*private String validateAppId( HttpServletRequest request, String appId, String endpoint )
	{
		String result = "valid";
		try
		{
			appId = checkNull( appId );
			boolean isWhiteListIP = isWhiteListIP( request, appId );
			if ( ! isWhiteListIP )
			{
				result = "Requested IP not registered for AppID ("+ appId +")";
			}
			else
			{
				boolean isExtAppEndpointAllowed = getCommonDBAccess().isExtAppEndpointAllowed( endpoint, appId );
				if( ! isExtAppEndpointAllowed )
				{
					result = "This service not available for the AppID ("+ appId +")";
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : validateRequest : "+ e.getMessage() );
			result = getStackTrace(e);
		}
		return result;
	}*/
	
	/*private boolean isWhiteListIP( HttpServletRequest request, String appId )
	{
		String ipAddress = "";
		try
		{
			if ( ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0 ) 
			{  
				ipAddress = request.getHeader("X-FORWARDED-FOR");  
			}
			if ( ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0 ) 
			{
				ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
			}
			if ( ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0 ) 
			{ 
				ipAddress = request.getHeader("Remote_Addr");
			}
			if ( ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0 )
			{
				ipAddress = request.getRemoteAddr();
			}
			ipAddress = E12GenericUtility.checkNull(ipAddress);
			BaseLogger.log( "0", null, null, "isWhiteListIP :: ipAddress : ["+ ipAddress +"]" );

			appId = E12GenericUtility.checkNull(appId);
			BaseLogger.log( "0", null, null, "isWhiteListIP :: appId : ["+ appId +"]" );

			ExtAuthApplicationBean applicationBean = getCommonDBAccess().getExtAuthApplicationInfo( appId );
			if( applicationBean != null )
			{
				String whiteListIP = E12GenericUtility.checkNull( applicationBean.getWhiteListIP() );
				BaseLogger.log( "0", null, null, "isWhiteListIP :: whiteListIp : ["+ whiteListIP +"]" );
				
				if ( whiteListIP.length() > 0 )
				{
					String whiteListIPArr[] = whiteListIP.split( "," );
					for( int i = 0; i < whiteListIPArr.length; i++ )
					{
						String IP = E12GenericUtility.checkNull( whiteListIPArr[i] );
						if( ! "".equals( IP ) && ipAddress.equals( IP ) )
						{
							return true;
						}
						else if( ! "".equals( IP ) && IP.endsWith( "*" ) )
						{
							IP = IP.substring( 0, IP.length() - 1 );
							if( ipAddress.startsWith( IP ) )
							{
								return true;
							}
						}
					}
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log( "0",null,null, "Exception :: isWhiteListIP : ["+ e.getMessage() +"]" );
			e.printStackTrace();
			return false;
		}
		return false;
	}*/
	//Added by Amey W. [ For validate WHITE_LIST_IP ] on 21-09-2020 END
	
	public void writeAPICallLog(String endpointName, String status, String result, String appId, HttpServletRequest request, UserInfoBean userInfo) {
	// Added By Gagan B. to store API status in API_CALL_LOG table on 23-FEB-23 [START]
		//Added by Gagan B. to avoid NullPointer Exception [START]
		status = checkNull(status);
		appId = checkNull(appId);
		result = checkNull(result);
		//Added by Gagan B. to avoid NullPointer Exception [END]
		BaseLogger.log( "3",userInfo,null, "Inside E12ExtServiceUtility :: writeAPICallLog : []" );
		StringBuffer responseInfo = new StringBuffer(""); //Added by Gagan B. to store RESPONSE_INFO in API_CALL_LOG.
		responseInfo.append("1)" + endpointName +  " called."); //Added by Gagan B. to store RESPONSE_INFO in API_CALL_LOG.
		responseInfo.append("\n2) Status: " + status + " Result: " + result);

		// Added by Gagan B to store API call status in api_call_log [START]
		String callStatus = "";
		
		if (status.equalsIgnoreCase("error") || status.equalsIgnoreCase("Reject") || status.equalsIgnoreCase("exception")) {
			callStatus = "F";
		} else {
			callStatus = "Y";
		}			
		// Added by Gagan B to store API call status in api_call_log [END]
		
		APIUtility APIUtility = new APIUtility();
		try {
			APIUtility.writeApiCallLog(userInfo, responseInfo, callStatus, appId, request.getRemoteAddr());
		} catch (ITMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}			
	}
	// Added By Gagan B. to store API status in API_CALL_LOG table on 23-FEB-23 [END]
	
	// Added by Gagan B. to validate TOKEN ID on 05-APR-23 [START]
	public boolean validateToken(HttpServletRequest request, String tokenId, boolean toValidateSession, String appId) {
		boolean isValid = false;
		String result = "valid";
		if (toValidateSession && !validateUserSession(request, tokenId)) {
			result = "You are not authorized to access.";
		}
		userInfo = getUserInfo();
		BaseLogger.log("3", null, null, "result from  validateToken VisionEDIUtility: [" + result + "]");
		if (!result.equalsIgnoreCase("valid")) {
			isValid = validateLLT(tokenId);
			BaseLogger.log("3", null, null, "isValid from  validateToken VisionEDIUtility: [" + isValid + "]");
		} else {
			isValid = true;
		}
		return isValid;
	}
	// Added by Gagan B. to validate TOKEN ID on 05-APR-23 [END]

	// Added by Gagan B. on 21-MAR-23 : created separate method for validating LLT
	// [START]
	private boolean validateLLT(String tokenId) {
		String sharedKey = "a3edd11a09ea4e0ccd09c6cd2828021b";

		boolean isValidUser = false;
		String result = "";
		result = validateJWT(tokenId, "", sharedKey);
		if (result.equalsIgnoreCase("valid")) {
			isValidUser = true;
			HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(tokenId, sharedKey);
			userInfo = createUserInfo(jwtData);
		}
		return isValidUser;
	}
	// Added by Gagan B. on 21-MAR-23 : created separate method for validating LLT
	// [END]
	private  Document convertStringToDocument(String xmlStr) {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
		DocumentBuilder builder;  
		try  
		{  
			builder = factory.newDocumentBuilder();  
			Document doc = builder.parse( new InputSource( new StringReader( xmlStr ) ) ); 
			return doc;
		} catch (Exception e) {  
			e.printStackTrace();  
		} 
		return null;
	}
	
	private boolean isJSONValid( String jsonString )
	{
		try
		{
			new JSONObject( jsonString );
		}
		catch (JSONException ex)
		{
			return false;
		}
		return true;
	}
	
	//Added By Ankush S on 04-DEC-2023[to get the Application list]START
		public String getApplList(HttpServletRequest request) {
			// E12DataModelComponent e12DataModelComp = new E12DataModelComponent();
			UserInfoBean userInfo = getUserInfoFromRequest(request);
			if (userInfo == null) {
				return "Error: Unauthorized Access";
			}
			try {
				JSONArray groupArray = new JSONArray();
				JSONObject appObj = new JSONObject();
				try (Connection userConn = new ConnDriver().getConnectDB(userInfo.getTransDB());
						PreparedStatement preparedStatement = userConn.prepareStatement(
								"SELECT DISTINCT APPL_GROUP, APPL_GRP_DESCR, APPL_GROUP_COLOR FROM appl_mst")) 
				{

					try (ResultSet resultSet = preparedStatement.executeQuery()) {
						while (resultSet.next()) {
							
							BaseLogger.log("3", null, null,"Value of APPL_GROUP= "+resultSet.getString("APPL_GROUP"));
							String applGroup = checkNull(resultSet.getString("APPL_GROUP"));
			                String applGroupDescr =checkNull(resultSet.getString("APPL_GRP_DESCR"));
			                String applGroupColor = checkNull(resultSet.getString("APPL_GROUP_COLOR"));
			                JSONObject groupObject = new JSONObject();
			                groupObject.put("group_id", applGroup);
			                groupObject.put("group_descr", applGroupDescr);
			                groupObject.put("group_color", applGroupColor);
			                groupArray.put(groupObject);
			                BaseLogger.log("3", null, null,"Value of applGroup= "+applGroup);
			                BaseLogger.log("3", null, null,"Value of applGroupDescr= "+applGroupDescr);
			                BaseLogger.log("3", null, null,"Value of applGroupColor= "+applGroupColor);
			                   
						}
						BaseLogger.log("3", null, null,"Value of Group Array= "+groupArray.toString());
						ResultSet resultSet2 = null;
						PreparedStatement preparedStatement2 = null;
						JSONArray applArray = new JSONArray();
						for(int i=0;i<groupArray.length();i++) {
							JSONObject groupObj = groupArray.getJSONObject(i);
							String applGroup = groupObj.getString("group_id");
							String query = "SELECT APP_NAME,APPL_COLOR,DESCR,APPL_ORDER,APPL_TYPE,SEARCH_DOMAIN FROM appl_mst WHERE APPL_GROUP=?";
							preparedStatement2 =userConn.prepareStatement(query);
							preparedStatement2.setString(1, applGroup);
							resultSet2 = preparedStatement2.executeQuery();
							
							JSONObject applObj = new JSONObject();
							applObj.put("group_id", groupObj.get("group_id"));
							applObj.put("group_descr",groupObj.get("group_descr"));
							applObj.put("group_color",groupObj.get("group_color"));
							JSONArray appList = new JSONArray();
							BaseLogger.log("3", null, null,"Getting App values ");
							while(resultSet2.next()) {
								JSONObject app = new JSONObject();
								app.put("app_id", checkNull(resultSet2.getString("APP_NAME")));
								BaseLogger.log("3", null, null,"Value of appl= "+app.get("app_id"));
								
								app.put("appl_color", checkNull(resultSet2.getString("APPL_COLOR")));
								BaseLogger.log("3", null, null,"Value of appl= "+app.get("appl_color"));
								
								app.put("appl_descr", checkNull(resultSet2.getString("DESCR")));
								BaseLogger.log("3", null, null,"Value of appl= "+app.get("appl_descr"));
								
								app.put("appl_order", resultSet2.getInt("APPL_ORDER"));
								BaseLogger.log("3", null, null,"Value of appl= "+app.get("appl_order"));
								
								app.put("appl_type", checkNull(resultSet2.getString("APPL_TYPE")));
								BaseLogger.log("3", null, null,"Value of appl= "+app.get("appl_type"));
								
								app.put("appl_search_domain", checkNull(resultSet2.getString("SEARCH_DOMAIN")));
								BaseLogger.log("3", null, null,"Value of appl= "+app.get("appl_search_domain"));
								
								appList.put(app);
							}
							applObj.put("appl", appList);
							applArray.put(applObj);
						}
						resultSet2 = null;
						preparedStatement2 = null;
						
						BaseLogger.log("3", null, null,"Value of applArray= "+applArray.toString());
						JSONObject groupObj = new JSONObject();
						groupObj.put("appl_group",applArray );
						
						appObj.put("applications",groupObj);
						BaseLogger.log("3", null, null,"Value of applications= "+appObj.toString());
					}
				}			
				return appObj.toString();
			} catch (Exception e) {
				// Handle the exception appropriately
				e.printStackTrace();
				//return "status:Error in getting Data Model List";
				return "status:"+e.getMessage();
			}

		}
			//Added by Ankush S on 01-DEC-2023 [to getDatamodel list JSON]END
		
		//Added By Ankush S on 30-NOV-2023[to get user info from Request]START
		public UserInfoBean getUserInfoFromRequest(HttpServletRequest request)
		{
			UserInfoBean userInfo =null;
			String userInfoStr = "";
			try {
				HttpSession session = request.getSession();
				java.util.Enumeration<String> attributeNames = session.getAttributeNames();
				while (attributeNames.hasMoreElements()) {	
					if (attributeNames.nextElement().equals("USER_INFO")) {
						userInfoStr = session.getAttribute("USER_INFO").toString();				
					}
				}
				if (!userInfoStr.equals("")) {
					userInfo = new UserInfoBean(userInfoStr);
					}
				return userInfo;
			} catch (Exception e) {
				BaseLogger.log("0", null, null, "Error in getting User info from Request [" + e.getMessage()+"]");
				return null;
			}
		}
		//Added By Ankush S on 30-NOV-2023[to get user info from Request]END
	
}
