/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.common.scheduler;

import ibase.bi.common.scheduler.ScheduleParser;
import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class StarterListener
implements NotificationListener {
    ScheduleParser sp = new ScheduleParser();

    StarterListener() {
    }

    @Override
    public void handleNotification(Notification pNotification, Object handback) {
        String fileName = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xml" + File.separator + "Scheduler" + File.separator + "Scheduler.xml";
        try {
            File f = new File(fileName);
            ArrayList<MBeanServer> mbList = MBeanServerFactory.findMBeanServer(null);
            MBeanServer mb = mbList.get(0);
            if (f.exists()) {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(f);
                NodeList ndList = doc.getElementsByTagName("NAME");
                String[] names = new String[ndList.getLength()];
                int i = 0;
                while (i < ndList.getLength()) {
                    Node node = ndList.item(i);
                    names[i] = node.getFirstChild().getNodeValue();
                    ++i;
                }
                i = 0;
                while (i < names.length) {
                    HashMap map = this.sp.getDetails("", names[i]);
                    String strDate = (String)map.get("STARTDATE");
                    String strTime = (String)map.get("STARTTIME");
                    String status = (String)map.get("STATUS");
                    String interval_msec = (String)map.get("INTERVAL_MSEC");
                    Date date = this.getDate(strDate, strTime);
                    long interval = new Double(interval_msec).longValue();
                    if (status.equalsIgnoreCase("U_START")) {
                        ObjectName obName = new ObjectName("DefaultDomain:service=" + names[i]);
                        ObjectInstance obj = mb.createMBean("ibase.bi.common.scheduler.MyTimer", obName);
                        mb.invoke(obName, "init", new Object[0], new String[0]);
                        mb.invoke(obName, "setTimeout", new Object[]{new Long(interval)}, new String[]{Long.TYPE.getName()});
                        mb.invoke(obName, "start", new Object[]{names[i], map, date}, new String[]{String.class.getName(), "java.util.HashMap", "java.util.Date"});
                        BaseLogger.log("3", null, null, "Scheduler " + names[i] + " started");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
        }
    }

    private Date getDate(String strDate, String strTime) throws Exception {
        Calendar cal = Calendar.getInstance();
        StringTokenizer tokens = new StringTokenizer(strDate, "/");
        String strDay = tokens.nextToken();
        String strMonth = tokens.nextToken();
        String strYear = tokens.nextToken();
        int day = Integer.parseInt(strDay.trim());
        int month = Integer.parseInt(strMonth.trim());
        int year = Integer.parseInt(strYear.trim());
        tokens = new StringTokenizer(strTime, ":");
        String strHour = tokens.nextToken();
        String strMinute = tokens.nextToken();
        int hour = Integer.parseInt(strHour.trim());
        int minute = Integer.parseInt(strMinute.trim());
        cal.set(year, month - 1, day, hour, minute, 0);
        return cal.getTime();
    }
}

