package ibase.webitm.utility;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.w3c.dom.Node;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterDataStatefulEJB;
import ibase.webitm.ejb.XML2DBEJB;
import ibase.wrkflw.utility.WorkflowLogger;
import ibase.wrkflw.utility.WorkflowMetaDataManager;
import org.json.JSONObject;

public class E12WorkFlowServiceUtility  extends RestAPIServiceUtility
{
	private static final long serialVersionUID = 1L;

	//invokeWorkFlow
	
	public String invokeWorkFlow(String  objName, String refId , String refSer,String tokenIDfromHeader) throws ServletException, IOException {
		// TODO Auto-generated method stub
		BaseLogger.log("3", null, null, "invokeWorkFlow mehtod Called --->>>");

		UserInfoBean userInfo = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		String wrkXmlFile="";
		String entityCode="";
		//HttpSession sess = null;
		//sess = request.getSession();
		String retString="";
	    JSONObject jsonResponse = new JSONObject();

		boolean isWorkflowExist=true;
		Connection conn=null;
		String ret= "Success";
		try
		{
			/*
			userInfo = ( ibase.utility.UserInfoBean )sess.getAttribute( "USER_INFO" );
			if( userInfo != null )
			{
				entityCode = userInfo.getEntityCode();
			}
			*/

				if (userInfo == null) { 
					APIUtility apiUtility = new APIUtility();
					userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
					entityCode = userInfo.getEntityCode();
					BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
				}
				
			//Get userinfo [END]
					
			//Get obj name and transaction id [START]
				
			//CommonConstants.setAPPLICATION_CONTEXT(this.servletContext.getRealPath("/"));
			BaseLogger.log("3", userInfo,  null,"CommonConstants.APPLICATION_CONTEXT :"+CommonConstants.APPLICATION_CONTEXT);
			//String refId = (String)request.getParameter("REF_ID");
			//String objName =request.getParameter("OBJ_NAME");
			//Get obj name and transaction id [END]
			
			//Get noOfForms and refser [START]
			DBAccessEJB dbAccess = new DBAccessEJB();
			//Changed by Pankaj T on 04-01-18 [changes for multitenancy]
			ArrayList objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
			int noOfForms = objFormsDetailList.size();
			HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
			/*
			String refSer="";
			if (objDetailMap != null)
			{
				refSer = (objDetailMap.get("REF_SER") != null)?(String)objDetailMap.get("REF_SER"):null; 
			}	
			*/
			
			dbAccess=null;
			//Get noOfForms and refser [END]
			
			//Get primary key name and data type [START]
			String metaDataFileName = objName + "21";
			//Changes By Ajinkya Gopalkar on 4-Apr-17
//			DWFactory dws = DWFactory.getDWFactory();
			DWFactory dws = new DWFactory(userInfo);
			DWObject dwObj = (DWObject)dws.getDataWindow(metaDataFileName);
			ArrayList primaryKeyLogNameList = dwObj.getPrimaryKeyLogNameList();
			ArrayList primaryKeyDataTypeList = dwObj.getPrimaryKeyDataTypeList();
			StringBuffer headerPKFieldNamesBuff = new StringBuffer();
			StringBuffer headerPKFieldDataTypesBuff = new StringBuffer();
			for(int i = 0; i < primaryKeyLogNameList.size(); i++)
			{
				headerPKFieldNamesBuff.append((String)primaryKeyLogNameList.get(i)).append(":"); //$NON-NLS-1$
				headerPKFieldDataTypesBuff.append((String)primaryKeyDataTypeList.get(i)).append(":"); //$NON-NLS-1$
			}
			if (headerPKFieldNamesBuff.length() > 0)
			{
				headerPKFieldNamesBuff.deleteCharAt((headerPKFieldNamesBuff.length() - 1));
			}
			String headerPKFieldNames = headerPKFieldNamesBuff.toString();
			String headerPKFieldDataTypes = headerPKFieldDataTypesBuff.toString();
			BaseLogger.log("3", userInfo,  null,"[E12InvokeWorkflow]Header primary key field names :[ "+headerPKFieldNames+" ] noOfForms :[ "+noOfForms+" ]"); //$NON-NLS-1$ //$NON-NLS-2$
			//Get primary key name and data type [END]
			
			BaseLogger.log("3", userInfo,  null,"refId:[ "+refId+" ] objName:[ "+objName+" ] userInfo:["+userInfo+"] refSer:[ "+refSer+" ] " );
			
			String tempDetailXMLStr="";
			MasterDataStatefulEJB masterDataStateful = new MasterDataStatefulEJB();
			BaseLogger.log("3", userInfo,  null,"@@@@ masterDataStateful :[ "+masterDataStateful.toString()+" ]");
			BaseLogger.log("3", userInfo,  null,"@@@@ tempDetailXMLStr :]");
			tempDetailXMLStr = masterDataStateful.getTransactionXMLForEdit(objName, "2", noOfForms, refId, headerPKFieldDataTypes, null, null, refSer, userInfo.toString() );
			BaseLogger.log("3", userInfo,  null,"@@@@ tempDetailXMLStr before:[ " +tempDetailXMLStr+" ]");
			E12GenericUtility genericUtility = new E12GenericUtility();
			tempDetailXMLStr = genericUtility.remAllXmlDec( tempDetailXMLStr );
			BaseLogger.log("3", userInfo,  null,"@@@@ tempDetailXMLStr after:[ " +tempDetailXMLStr+" ]");
			
			Node dataDom = genericUtility.parseString(tempDetailXMLStr);
			
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			
			String selQuery = "SELECT WRKFLW_INIT FROM TRANSETUP WHERE TRAN_WINDOW  = 'w_"+objName+"'";
			stmt = conn.prepareStatement(selQuery);
			rs = stmt.executeQuery();			
			if(rs.next())
			{
				wrkXmlFile=rs.getString(1);
			}
			rs.close();
			rs = null;
			BaseLogger.log("3", userInfo,  null,"@@@@ wrkXmlFile :[ " +wrkXmlFile+" ] loginCode : [ "+entityCode+ " ]");
			XML2DBEJB xml2DBRem = new XML2DBEJB();
			try {
			isWorkflowExist=isWorkflowInitiated(refSer, objName, refId, wrkXmlFile, userInfo);
			BaseLogger.log("3", userInfo,  null,"isWorkflowExist valuee:::[ "+isWorkflowExist+" ]  " );
			}
			catch(Exception e)
			{
				    jsonResponse.put("Status :", "Error");
				    jsonResponse.put("Response :", e.getMessage());
					BaseLogger.log("3", userInfo,  null," Exception::[ "+e.getMessage()+" ]  " );
				    return jsonResponse.toString();


			}

			if (!(isWorkflowExist)) {
			    retString = xml2DBRem.invokeWorkflowExternal(dataDom, entityCode, wrkXmlFile, objName, refSer, refId, conn);
			    BaseLogger.log("3", userInfo, null, "retString value:::[ " + retString + " ]");

			    jsonResponse.put("Status :", "Success"); // Indicating workflow does not exist
			    jsonResponse.put("response :", retString);
			}
			/*
			else
			{
					String errMsg = "ERR_MSG: Workflow is already initiated for this transaction";
					
					OutputStream outStream = response.getOutputStream();
					BaseLogger.log("3", userInfo,  null," CommonConstants.ENCODING ["+CommonConstants.ENCODING+"] errMsg ["+errMsg+"]");
					byte buffer[] = errMsg.getBytes(CommonConstants.ENCODING);
					int bytes = buffer.length;
					outStream.write(buffer,0,bytes);
					outStream.flush();
					outStream.close();
			}	
			*/
			else {
			    // Create the JSON response for the error message
			    BaseLogger.log("3", userInfo, null, "Inside the else block..... ");
			    //JSONObject jsonResponse = new JSONObject();
			    jsonResponse.put("Status", "error");
			    jsonResponse.put("Response", "ERR_MSG: Workflow is already initiated for this transaction");
			    String jsonResponseString = jsonResponse.toString();
			    BaseLogger.log("3", userInfo, null, "CommonConstants.ENCODING [" + CommonConstants.ENCODING + "] errMsg [" + jsonResponseString + "]");
			    BaseLogger.log("3", null, null, " Json Response:: [" + jsonResponseString + "]");
			    return jsonResponseString;
			    
			     }
			
		}
		catch(ServletException se)
		{
			se.printStackTrace();
			throw se;
		}
		catch(IOException ioe)
		{
			ioe.printStackTrace();
			throw ioe;
		}
		catch(SQLException sqe)
		{
		     	sqe.printStackTrace();
			    jsonResponse.put("Status :", "Error");
			    jsonResponse.put("Response :", sqe.getMessage());
				BaseLogger.log("3", userInfo,  null," Exception case 1::[ "+sqe.getMessage()+" ]  " );
			    return jsonResponse.toString();
		}
		catch(Exception e)
		{
			e.printStackTrace();
			 jsonResponse.put("Status :", "Error");
			 jsonResponse.put("Response :", e.getMessage());
			 BaseLogger.log("3", userInfo,  null," Exception case  2::[ "+e.getMessage()+" ]  " );
			    return jsonResponse.toString();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn =null;
				}
			}
			catch (Exception e) 
			{
				BaseLogger.log("0", userInfo,  null, "Exception in releasing file resource :" );
				e.printStackTrace();
			}
			
		}
	    return jsonResponse.toString();
	}
	
	//method isWorkflowInitiated
	public boolean isWorkflowInitiated(String refSer, String objName, String refId, String processId, UserInfoBean userInfo)throws BaseException
	{
		BaseLogger.log("2", userInfo,  null,"Insdie the isWorkflowInitiated.... ");
		boolean isExists = false;
		Connection con = null;
		Statement stmt = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			//con = connDriver.getConnectDB(CommonConstants.WRKFLW_DB);
			BaseLogger.log("3", userInfo,  null,"transDB In isWorkflowInitiated:["+userInfo.getTransDB()+"]");
			con = connDriver.getConnectDB(userInfo.getTransDB());
			stmt = con.createStatement();
			//Commnented by Ashish Sonawane on 29-Jan-13 [checking abort status of workflow ]
			//String prcStatusSelQry = "SELECT COUNT(1) FROM WF_PRC_STATUS WHERE PROCESS_ID='"+processId+"' AND ACTIVITY_ID='"+processId+"' AND REF_SER='"+refSer+"' AND REF_ID='"+refId+"' AND OBJ_NAME='"+objName+"'";
			
			//Commented and change the query , added trim() on both side to avoid the space in the data as well as in db : Gulzar - 03/07/14
			refId = (refId == null)?"":refId.trim();
			//String prcStatusSelQry = "SELECT COUNT(1) FROM WF_PRC_STATUS WHERE PROCESS_ID='"+processId+"' AND ACTIVITY_ID='"+processId+"' AND REF_SER='"+refSer+"' AND REF_ID='"+refId+"' AND OBJ_NAME='"+objName+"' AND WF_ABORT IS NULL";

			//Commented and changed by by Gulzar on 20/01/16 to check for edit of transaction
			/*
			String prcStatusSelQry = "SELECT COUNT(1) FROM WF_PRC_STATUS WHERE PROCESS_ID='"+processId+"' AND ACTIVITY_ID='"+processId+"' AND REF_SER='"+refSer+"' AND ltrim(rtrim(REF_ID))='"+refId+"' AND OBJ_NAME='"+objName+"' AND WF_ABORT IS NULL";
			BaseLogger.log("3", userInfo,  null,"@@@@ prcStatusSelQry: ["+prcStatusSelQry+"]");
			ResultSet rs = stmt.executeQuery(prcStatusSelQry);
			if(rs.next())
			{
				int prcStatus = rs.getInt(1);
				if(prcStatus > 0)
				{
					isExists = true;
				}
			}
			rs.close();
			rs = null;
			stmt.close();
			stmt = null;
			*/
			String activity = "";
			int prcStatus = 0;
			ArrayList endActivitiesList = WorkflowMetaDataManager.getInstance().getEndActivitiesList( processId );
			String prcStatusSelQry = "SELECT ACTIVITY_ID, PROCESS_STATUS FROM WF_PRC_STATUS WHERE PROCESS_ID='"+processId+"' AND OBJ_NAME='"+objName+"' AND REF_SER='"+refSer+"' AND REF_ID='"+refId+"' AND WF_ABORT IS NULL";
			ResultSet rs = stmt.executeQuery(prcStatusSelQry);
			while( rs.next() )
			{
				WorkflowLogger.info( "isWorkflowInitiated >> Found Process existing in WF_PRC_STATUS" );
				activity = rs.getString( "ACTIVITY_ID" );
				if ( ! activity.equalsIgnoreCase(processId) )
				{
					isExists = true;
				}
				
				prcStatus = rs.getInt( "PROCESS_STATUS" );
				
				BaseLogger.log("3", userInfo,  null,"E12InvokeWorkflowServlet >> isWorkflowInitiated >> prcStatus =["+prcStatus+"]");
				
				if(prcStatus == 0 || prcStatus == 1 || prcStatus == 2)
				{
					isExists = true;
				}
				if( endActivitiesList.contains( activity ) && prcStatus == 3 )
				{
					WorkflowLogger.info( "isWorkflowInitiated >> Found End Activity :["+activity+"] with status = 3 for process" );
					isExists = false;
					break;
				}
			}
			rs.close();
			rs = null;

			stmt.close();
			stmt = null;
		}
		catch (BaseException be)
		{
			throw be;
		}
		catch (Exception e)
		{
			throw new BaseException(e);
		}
		finally
		{
			try
			{
				if(con != null)
				{
					if(stmt != null)
					{
						stmt.close();
						stmt = null;
					}
					//DANISH 03-JAN-2011 [ Common Connection ]
					if(!con.isClosed() )
					{
						con.close();
						con = null;
					}
				}
			}
			catch (Exception e)
			{
				throw new BaseException(e);
			}
			
		}
		WorkflowLogger.info("Returning Process Exists Status :["+isExists+"]");
		return isExists;
	}

}
