/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserTasksServiceUtility {
    private UserInfoBean userInfo = null;

    public String getUserTasksService(String refser, String refId, String tokenIDfromHeader) throws Exception {
        JSONArray jsonArray;
        block35: {
            BaseLogger.log("3", null, null, "Inside the getUserTasksService():");
            Statement pstmt = null;
            ResultSet resultSet = null;
            Connection connection = null;
            jsonArray = new JSONArray();
            if (this.userInfo == null) {
                APIUtility apiUtility = new APIUtility();
                this.userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
                String transDB = this.userInfo.getTransDB();
                String tableName = "USER_TASKS";
                BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + this.userInfo + "]");
                String query = "SELECT * FROM " + tableName + " WHERE REF_SER = ? AND REF_ID = ?";
                try {
                    try {
                        ConnDriver connDriver = new ConnDriver();
                        connection = connDriver.getConnectDB(transDB);
                        pstmt = connection.prepareStatement(query);
                        pstmt.setString(1, refser);
                        pstmt.setString(2, refId);
                        resultSet = pstmt.executeQuery();
                        ResultSetMetaData metaData = resultSet.getMetaData();
                        int columnCount = metaData.getColumnCount();
                        while (resultSet.next()) {
                            JSONObject jsonObject = new JSONObject();
                            int i = 1;
                            while (i <= columnCount) {
                                String columnName = metaData.getColumnLabel(i);
                                jsonObject.put(columnName, (Object)resultSet.getString(columnName));
                                ++i;
                            }
                            jsonArray.put((Object)jsonObject);
                        }
                    }
                    catch (SQLException e) {
                        BaseLogger.log("3", null, null, "Error occurred while retrieving user tasks: " + e.getMessage());
                        e.printStackTrace();
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (pstmt != null) {
                            try {
                                pstmt.close();
                            }
                            catch (SQLException e3) {
                                e3.printStackTrace();
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e4) {
                                e4.printStackTrace();
                            }
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        BaseLogger.log("3", null, null, "jsonArray: [" + jsonArray.toString() + "]");
        return jsonArray.toString();
    }

    public String addUserTask(String transXMLHeader, UserInfoBean userInfo) throws Exception {
        String result = "";
        Connection connection = null;
        BaseLogger.log("3", null, null, "Inside updatePaymentStatus.. ");
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext initialContext = new InitialContext(appConnect.getProperty());
            ConnDriver connDriver = new ConnDriver();
            connection = connDriver.getConnectDB(userInfo.getTransDB());
            StringBuffer userTaskXmlString = new StringBuffer();
            userTaskXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
            userTaskXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>");
            userTaskXmlString.append("<objName><![CDATA[user_tasks]]></objName>");
            userTaskXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
            userTaskXmlString.append("<objContext><![CDATA[1]]></objContext>");
            userTaskXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
            userTaskXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
            userTaskXmlString.append("<action><![CDATA[SAVE]]></action>");
            userTaskXmlString.append("<elementName><![CDATA[]]></elementName>");
            userTaskXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
            userTaskXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
            userTaskXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
            userTaskXmlString.append("<Detail1 dbID='' domID='1'  objContext='1'  objName='user_tasks'>");
            userTaskXmlString.append("<attribute IS_CHANGE='Y' pkNames='TRAN_ID' selected='N' status='N' updateFlag='A'/>");
            userTaskXmlString.append(transXMLHeader);
            userTaskXmlString.append("</Detail1>");
            userTaskXmlString.append("</Header0></group0></DocumentRoot>");
            String xmlString = userTaskXmlString.toString();
            BaseLogger.log("3", null, null, " Xml String... " + xmlString);
            MasterStatefulLocal masterStateful = (MasterStatefulLocal)initialContext.lookup("ibase/MasterStatefulEJB/local");
            String retString = masterStateful.processRequest(userInfo, xmlString, false, connection);
            result = UserTasksServiceUtility.getErrorStrFromRetString(retString, "getErrorStrFromRetString Cancellation");
            BaseLogger.log("3", null, null, "'w_user_tasks' cellation retString.." + result);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return result;
    }

    public String addUserTask(String refId, String refser, String taskDescr, String userIdAssigned, String tokenIDfromHeader) {
        String result = "";
        BaseLogger.log("3", null, null, "addUserTask calle ams");
        if (this.userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            this.userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + this.userInfo + "]");
        }
        try {
            String transResult;
            CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
            String tranID = commonDBAccessEJB.generateSeq("USER_TASKS_SEQ", 10, this.userInfo.getTransDB());
            BaseLogger.log("3", null, null, " generated tranID :: " + tranID);
            LocalDate tranDate = LocalDate.now();
            LocalTime tranTime = LocalTime.now();
            String formattedTranDate = UserTasksServiceUtility.formatDateTime(tranDate, tranTime);
            String userId = "";
            userId = this.userInfo.getLoginCode();
            String taskType = "";
            String taskDomain = "";
            String taskCode = "";
            String expComplDate = "28-05-24";
            String currStatus = "28-05-24";
            String statusDate = "28-05-24";
            String complRemarks = "";
            String addDate = "28-05-24";
            String addUser = "";
            String addTerm = "";
            String chgDate = "28-05-24";
            String chgUser = "";
            String chgTerm = "";
            String transXMLHeader = this.generateTransXMLForHeader(tranID, formattedTranDate, userId, taskDescr, taskType, taskDomain, taskCode, userIdAssigned, expComplDate, currStatus, statusDate, complRemarks, addDate, addUser, addTerm, chgDate, chgUser, chgTerm, refser, refId);
            result = transResult = this.addUserTask(transXMLHeader, this.userInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "Result of addUserTask: [" + result + "]");
        return result;
    }

    public JSONObject getSuppPendingTaskList(String suppCode, String tokenIDfromHeader) {
        JSONObject result = new JSONObject();
        JSONArray taskList = new JSONArray();
        if (this.userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            this.userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, " getSuppPendingTaskList USER_INFO created from TOKEN: [" + this.userInfo + "]");
        }
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(this.userInfo.getTransDB());
                String getSuppPendingTaskListSQL = "SELECT pd.tran_id, pd.line_no, a.descr as task_descr, item.descr as task_site FROM PROJ_EST_BASELINE ph, PROJ_EST_BSL_ITEM pd, activity a, sorder sh, sorddet sd, item item WHERE ph.tran_id = pd.tran_id AND pd.activity_code = a.activity_code AND sh.sale_order = sd.sale_order AND ph.proj_code = sh.proj_code AND TRIM(sd.line_no) = TRIM(pd.line_no__ord) AND sd.item_code = item.item_code AND NVL(pd.task_status, 'P') = 'P' AND pd.supp_code = ?";
                pstmt = connection.prepareStatement(getSuppPendingTaskListSQL);
                pstmt.setString(1, suppCode);
                rs = pstmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                int srNo = 1;
                while (rs.next()) {
                    JSONObject task = new JSONObject();
                    task.put("SR_NO", srNo);
                    System.out.println(" getSuppPendingTaskList SR_NO : [" + srNo + "]");
                    int i = 1;
                    while (i <= columnCount) {
                        String columnName = metaData.getColumnName(i);
                        String columnValue = rs.getString(i);
                        columnValue = columnValue != null ? columnValue.trim() : " ";
                        task.put(columnName, (Object)columnValue);
                        ++i;
                    }
                    taskList.put((Object)task);
                    ++srNo;
                }
                result.put("PENDING_TASKS", (Object)taskList);
                if (taskList.length() == 0) {
                    result.put("result", (Object)"No data available");
                }
                System.out.println("suppPendingTaskList gsb JSON Object: [" + result + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    result.put("result", (Object)"Error fetching data");
                }
                catch (JSONException jsonException) {
                    jsonException.printStackTrace();
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String generateTransXMLForHeader(String tranId, String formattedTranDate, String userId, String taskDescr, String taskType, String taskDomain, String taskCode, String userIdAssigned, String expComplDate, String currStatus, String statusDate, String complRemarks, String addDate, String addUser, String addTerm, String chgDate, String chgUser, String chgTerm, String refser, String refId) throws ITMException {
        BaseLogger.log("3", null, null, "generateTransXML calling gsb:[" + refId + "]");
        StringBuffer transXML = new StringBuffer();
        transXML.append("<tran_id><![CDATA[" + tranId + "]]></tran_id>");
        transXML.append("<tran_date><![CDATA[" + UserTasksServiceUtility.dateFormatter(formattedTranDate) + "]]></tran_date>");
        transXML.append("<user_id><![CDATA[" + userId + "]]></user_id>");
        transXML.append("<task_descr><![CDATA[" + taskDescr + "]]></task_descr>");
        transXML.append("<task_type><![CDATA[" + taskType + "]]></task_type>");
        transXML.append("<task_domain><![CDATA[" + taskDomain + "]]></task_domain>");
        transXML.append("<task_code><![CDATA[" + taskCode + "]]></task_code>");
        transXML.append("<user_id__assigned><![CDATA[" + userIdAssigned + "]]></user_id__assigned>");
        transXML.append("<exp_compl_Date><![CDATA[" + UserTasksServiceUtility.dateFormatter(expComplDate) + "]]></exp_compl_Date>");
        transXML.append("<curr_status><![CDATA[" + currStatus + "]]></curr_status>");
        transXML.append("<status_date><![CDATA[" + UserTasksServiceUtility.dateFormatter(statusDate) + "]]></status_date>");
        transXML.append("<compl_remarks><![CDATA[" + complRemarks + "]]></compl_remarks>");
        transXML.append("<add_date><![CDATA[" + UserTasksServiceUtility.dateFormatter(addDate) + "]]></add_date>");
        transXML.append("<add_user><![CDATA[" + addUser + "]]></add_user>");
        transXML.append("<add_term><![CDATA[" + addTerm + "]]></add_term>");
        transXML.append("<chg_term><![CDATA[" + chgTerm + "]]></chg_term>");
        transXML.append("<chg_user><![CDATA[" + chgUser + "]]></chg_user>");
        transXML.append("<confirmed><![CDATA[Y]]></confirmed>");
        System.out.println("User_tasks transXML [" + transXML + "]");
        return transXML.toString();
    }

    public static String getErrorStrFromRetString(String returnXML, String calledFrom) {
        StringBuilder errorStr = new StringBuilder();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(returnXML.getBytes()));
            NodeList errorList = document.getElementsByTagName("error");
            int i = 0;
            while (i < errorList.getLength()) {
                Node errorNode = errorList.item(i);
                if (errorNode.getNodeType() != 1) {
                    return String.valueOf(calledFrom) + " Transaction is Saved.";
                }
                Element errorElement = (Element)errorNode;
                String message = errorElement.getElementsByTagName("message").item(0).getTextContent();
                String description = errorElement.getElementsByTagName("description").item(0).getTextContent();
                errorStr.append("Message From " + calledFrom + ":").append(message).append("\n");
                errorStr.append("Description: ").append(description).append("\n");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorStr.toString();
    }

    public static String dateFormatter(String inputDateString) {
        String result = "";
        String inputFormat = "yyyy-MM-dd HH:mm:ss";
        String outputFormat = "dd/MM/yy HH:mm:ss";
        try {
            SimpleDateFormat inputFormatter = new SimpleDateFormat(inputFormat);
            Date date = inputFormatter.parse(inputDateString);
            SimpleDateFormat outputFormatter = new SimpleDateFormat(outputFormat);
            String outputDateString = outputFormatter.format(date);
            System.out.println("Input Date: " + inputDateString);
            System.out.println("Formatted Date: " + outputDateString);
            result = outputDateString;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String formatDateTime(LocalDate tranDate, LocalTime tranTime) {
        LocalDateTime tranDateTime = LocalDateTime.of(tranDate, tranTime);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = tranDateTime.format(formatter);
        return formattedDateTime;
    }
}

