package ibase.webitm.ejb.wsfa.transactions;

import java.io.StringWriter;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.TreeMap;

import javax.naming.InitialContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.json.JSONObject;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wsfa.WSFACommon;

/**
 * Session Bean implementation class RealTimeReport
 */
//@Stateless		commented by Sagar M [22 Nov 2018].
public class RealTimeReportEJB extends StrgMeetDCRWizard implements RealTimeReportEJBRemote, RealTimeReportEJBLocal
{
	/**
	 * Default constructor.
	 */
	public RealTimeReportEJB()
	{
		// TODO Auto-generated constructor stub
	}
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	
	private E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("xmlString ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2:::::: ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams, formName);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: RealTimeReportEJB: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		//System.out.println ( "Returning from RealTimeReportEJB wfValData" );
		return (errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		//System.out.println("wfValData calling in realtime.............:::");
		String errString = "";
		PreparedStatement pstmtActivity = null;// modified by kailash.
		ResultSet rsActivity = null; // modified by kailash.
		ResultSet rs = null;
		ResultSet rSet = null; //added by rupali on 15/09/17 for worked with field
		Connection connectionObject = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		PreparedStatement pstmt = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList parentList =null;
		NodeList childList= null;
		String childNodeName = "";
		int parentNodeListLength =0;
		int noOfChilds = 0;
		int ctr = 0;
		ResultSet stpRs = null;
		String empCodeHO="";
		String stpStatus="";
		String usrTypeLogin = "";
		
		try
		{
			String dbName =CommonConstants.DB_NAME; //added by rupali on 15/09/17 for worked with field
			String columnValue = "";
			String strgCode="";
			String strgType="";
			String dcrDate="";
			String sql = "";
			int currentFormNo = 0;
			String sprsCodeWW = "";	// added by rupali on 03/05/18 for single screen mgr reporting
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB("DriverValidator");
			connectionObject = getConnection();
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			userId = getEmpCode(userId, connectionObject);
			//Added by Bhagyashri T for check perticular division
			ArrayList gradeArrayList = new ArrayList();
			String gradeS ="";
			String gradeArray = getGradeForSTP(userId,connectionObject);
			
			String gradesql = "SELECT GRADE FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = connectionObject.prepareStatement(gradesql);
			pstmt.setString(1, userId);

			rSet = pstmt.executeQuery();
			if( rSet.next() )
			{
				gradeS  = checkNull(rSet.getString("GRADE"));
			}
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			//Added by bhagyashri to check perticular Div Check
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			DARCommonBean darCommonBean= new DARCommonBean();
			
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			//System.out.println("currentFormNo in wfValData:::"+currentFormNo);
			// added by rupali on 30/10/17 for applying condition of sfaparm for validation of stockist_code [start]
			String parmValue = "";
			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_PREF_STOCKIST' AND ACTIVE='Y' ";
			pstmt = connectionObject.prepareStatement(sfaParmSql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				parmValue = checkNull(rs.getString("PARM_VALUE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));  //added by mrunalini sinkar for member present
			String RealParmData = checkNull(getSfaParmValue(userId, "ALLOW_STOCKIST_DAR", connectionObject));// added by shraddha M for stockist validation[31-08-19]
			String isFortuneActivity = checkNull(getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", connectionObject));//added by Bhagyashri T for fortune validation[16-12-21]
			// added by rupali on 30/10/17 for applying condition of sfaparm for validation of stockist_code [start]
			String mgrCode = getMGREmployee(userId, connectionObject);// added by rupali on 03/05/18 for single screen mgr reporting

			String stockistTable = getSfaParmValue(userId,"GET_STOCKIST_DETAILS",connectionObject);
			String totAllwCallList="";
			
			if("doctor".equalsIgnoreCase(formName))
			{
				String updateFlag = ""; // added by rupali on 23/02/18 for edit mode of realtime report
				errString = wfValSalesPersAct(dom, dom2, objContext, userId,connectionObject);
				// commented by rupali on 18/10/17 for not allowing to finish the report if mandatory fields are blank on holiday
				//if( errString.indexOf( "<Errors>" ) == -1 )
				//{
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						columnValue ="";
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						String actType = checkNull(genericUtility.getColumnValue( "activity_type" , dom2 ,objContext));
						//System.out.println("activity type is:"+actType);
						strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
						String cusType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
						// added by rupali on 23/02/18 for edit mode of realtime report [start]
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
							//System.out.println("updateFlag is:::::::"+updateFlag);
						}
						// added by rupali on 23/02/18 for edit mode of realtime report [end]
						if (childNodeName.equalsIgnoreCase("event_date"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Tran date cannot be null:");
								errString = itmDBAccessLocal.getErrorString("event_date","NULEVTDATE",userId);

								break;
							}
							else
							{
								SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
								java.util.Date eventDate = null;
								try
								{
									eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
									//System.out.println("eventdate is:"+eventDate);
									//System.out.println("eventDate is : ["+eventDate+"]");
								}
								catch ( Exception e )
								{
									//System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

								String evtdat=childNode.getFirstChild().getNodeValue();
								if (!sdfFormat.format(eventDate).equals(evtdat))
								{
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}
								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(start) 
								String futureDate="";
								String eventType = checkNull(genericUtility.getColumnValue( "event_type" , dom2 ,objContext));
								String itemSer = getItemSer(userId,connectionObject);
								//String actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? AND ITEM_SER = ? ";
								String actSql = "SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? "+
										 "AND (ITEM_SER IS NULL OR ITEM_SER = 'ALL' OR ITEM_SER = ?) "+
										 "AND (SITE_CODE IS NULL OR SITE_CODE = 'ALL' OR (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?) IN "+
										 "(SELECT REGEXP_SUBSTR(SITE_CODE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(SITE_CODE, '[^,]+', 1, LEVEL) IS NOT NULL) ) "+
										 "ORDER BY DESCR ";
								pstmt = connectionObject.prepareStatement(actSql);
								pstmt.setString(1, eventType);
								pstmt.setString(2, itemSer);  
								pstmt.setString(3, userId);  
								rSet = pstmt.executeQuery();
								if (rSet.next())
								{
									futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								
								// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(end)
								//if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
								if (( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 && (futureDate.equalsIgnoreCase("0") || futureDate.trim().length() == 0)))
								{

									errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
									break;
								}
								// commentted and added by rupali on 26/06/19 for getting allow delay period from table [start]
								//String allDealyPrd = checkNull(genericUtility.getColumnValue( "allwd_delay_prd" , dom2 ,objContext));
								//String allDealyPrd = "";
								String entryMode = checkNull(genericUtility.getColumnValue( "entry_mode" , dom2 ,objContext));
								System.out.println("entryMode is:["+entryMode+"]");
								int allDealyPrd = 0;
								String allDelaySql = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
								pstmt =  connectionObject.prepareStatement(allDelaySql);
								pstmt.setString(1, checkNull(userId));
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									allDealyPrd = rs.getInt("ALLWD_DELAY_PRD");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								// commentted and added by rupali on 26/06/19 for getting allow delay period from table [end]
								try
								{
									/*java.util.Date date = Calendar.getInstance().getTime();
									String currDate = sdfFormat.format( date );
									Date currenDate = sdfFormat.parse(currDate);
									long difference = currenDate.getTime() - eventDate.getTime();
									long daysBetween = (difference / (1000*60*60*24));
									String days=String.valueOf(daysBetween);
									int diffDays=Integer.parseInt(days);
									int allwPrd=Integer.parseInt(allDealyPrd);
									if(diffDays > allwPrd)
									{
										errString = itmDBAccessLocal.getErrorString( "event_date", "NOTALLWREP", userId );
										break;
									}*/
									
									int totDelPrd = 0;
									long diffDays = 0;
									java.util.Date currDate = new java.util.Date();
									java.util.Date tempDate = null;
									DateFormat applFormat = new SimpleDateFormat(getApplDateFormat());
									ArrayList<String> holiList = new ArrayList<String>();
									String eventdate = genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());
									String holtblno = getHoltblno(userId,eventdate, connectionObject);
									
									Calendar cal = Calendar.getInstance();
									SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
									cal.setTime( sdf.parse(evtdat) );
									tempDate = cal.getTime();
									long diff = currDate.getTime() - tempDate.getTime();
									diffDays = diff / (24 * 60 * 60 * 1000);
									System.out.println(diffDays + " ssssdays, ");
									
									Calendar calBef = Calendar.getInstance(); 
									calBef.add(Calendar.DAY_OF_MONTH,-allDealyPrd);
									java.util.Date befoDate = calBef.getTime();
									String befoDateAppl = applFormat.format( befoDate );
									String befoDateDB= genericUtility.getValidDateTimeString( befoDateAppl , getApplDateFormat() , getDBDateFormat());
									
									Calendar calAft = Calendar.getInstance(); 
									java.util.Date aftDate = calAft.getTime();
									//String aftDateAppl = applFormat.format( aftDate );//Commended by Hariom for holiday check -03-Nov-20
									String aftDateDB= genericUtility.getValidDateTimeString( evtdat , getApplDateFormat() , getDBDateFormat());//Changed by Hariom for holiday check -03-Nov-20
									holiList = getHolidayList(befoDateDB,aftDateDB,holtblno,userId,connectionObject);//userId added by mrunalini sinkar for change_holiday(start)
									
									int holCnt = holiList.size();
									totDelPrd = allDealyPrd + holCnt;
									System.out.println("totDelPrd::["+totDelPrd+"] alwdDelPrd:::["+allDealyPrd+"] holCnt:::["+holCnt+"]");

									if (diffDays > totDelPrd && !"A".equalsIgnoreCase(entryMode))
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "MAXDELYPRD" , userId );
										break;
									}
	
								}
								catch(Exception e)
								{
									System.out.println("------------- INVALIDFRMT ---------------");
									
								}
								
								// added by mrunalini sinkar for ALLOW_DAR_WO_MAP sun changes on 01-april-2019(start)
								
								// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(start)

								String holiday="";
								//if(!updateFlag.equalsIgnoreCase("E"))
								//{
									System.out.println("updateFlag111+++++"+updateFlag);
								 holiday = valHoliday( evtdat, userId, userId, itmDBAccessLocal, connectionObject,updateFlag);
								//}
								// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(end)

								String sfaParmData  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
								if(holiday == null || holiday.trim().length() == 0)
								{
									boolean blockConfirmation = isNoMAPForTheWorkDate(userId,evtdat,connectionObject);										
									if (blockConfirmation )
									{	
										errString = itmDBAccessLocal.getErrorString( "event_date" , "DARNOMAP" , userId);
										break;
																					
									}
								}
								
								// added by mrunalini sinkar for ALLOW_DAR_WO_MAP sun changes on 01-april-2019(end)


								//Added by Hariom  on 19-August-2019 for bangladesh user(start)
								String code="";
								String fromDate="";
								String brndParmData  = checkNull(getSfaParmValue(userId,"DAR_BRAND_MANDATE",connectionObject));
								String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom ));

								if(brndParmData.equalsIgnoreCase("Y"))
								{

									String frDate="SELECT FR_DATE-1 AS FR_DATE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(frDate);
									pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										fromDate= checkNull(rSet.getString("FR_DATE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}

									String periodCode="SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE" ;
									pstmt = connectionObject.prepareStatement(periodCode);
									pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(fromDate));
									rSet = pstmt.executeQuery();
									if(rSet.next())
									{
										code= checkNull(rSet.getString("CODE"));
									}

									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}

									String brandSql = "SELECT * FROM STRG_BRAND_ACT WHERE SALES_PERS = ? AND PRD_CODE = ? ";
									pstmt = connectionObject.prepareStatement(brandSql);
									pstmt.setString(1,userId);
									pstmt.setString(2,code);
									rSet = pstmt.executeQuery();

									if(rSet.next())
									{
										System.out.println("Records are Present........");
									}
									else
									{
										errString = itmDBAccessLocal.getErrorString( "work_date" , "INVLIDDAR" , userId );
										break;

									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}

									if(pstmt !=null)
									{
										pstmt.close();
										pstmt = null;
									}
								}

								//Added by Hariom  on 19-August-2019 for bangladesh user(end)
	
								// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [start]
								empCodeHO = getHOEmployee( userId, connectionObject );
								System.out.println("HO Code value DAR Comp: ["+empCodeHO+"]");
								String stpChksql="SELECT STP_STATUS FROM SALES_PERS WHERE SALES_PERS = ?";
								pstmt = connectionObject.prepareStatement(stpChksql);
								pstmt.setString(1,userId);
								stpRs = pstmt.executeQuery();
								if(stpRs.next())
								{
									stpStatus = checkNull(stpRs.getString("STP_STATUS"));
								}
								System.out.println("stpStatus:::>>["+stpStatus+"]");
								if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
								{
									usrTypeLogin = "H";
								}
								if(!"H".equalsIgnoreCase(usrTypeLogin))
								{
									if(stpStatus.equalsIgnoreCase("2"))
									{
										int darBkdy=0;
										long daysDiff = getSTPApproveDateDiff(userId,connectionObject);
										String darBckDys = checkNull(getSfaParmValue(userId, "STP_DAR_BLOCK_DAYS", connectionObject));
										if(darBckDys != null && darBckDys.trim().length()>0)//Added by mrunalini sinkar if sfaparm is not exist
										{
											darBkdy = Integer.parseInt(darBckDys);
										}
										
										System.out.println("daysDiff::["+daysDiff+"]::itemSer::["+itemSer+"]::darBckDys::["+darBckDys+"]::darBkdy::["+darBkdy+"]");
										/*if(daysDiff > darBkdy )
										{	
											errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
											return errString;
										}*/
										//System.out.println("Inside DAR RTEJB");
										if(gradeArray != null && gradeArray.trim().length() > 0)
										{
											String[] grdArray = gradeArray.split(",");
											System.out.println("GradeCode isDAR RTEJB::>>::"+grdArray);

											for( int cntr = 0 ; cntr < grdArray.length ; cntr++ )
						                    {
												gradeArrayList.add(checkNull(grdArray[cntr]));
						                    }
										}
										System.out.println("GradearrayListDAR RTEJB ::::>>::["+gradeArrayList+"]::SalesGradeCodecDAR val RTEJB::["+gradeS+"]");
										if(gradeArrayList.contains(gradeS) )
										{
											System.out.println("INSIDE gradeArrayList.contains(gradeS) RTEJB");
											if(daysDiff > darBkdy )
											{	
												System.out.println("daysDiff > darBkdy");
												errString  = getErrorString(stpStatus,"VTCCARESTP",userId);
												return errString;
											}
										}
										System.out.println("OUTSIDE gradeArrayList.contains(gradeS) RTEJB");
									}
								}
								if(stpRs != null)
								{
									stpRs.close();
									stpRs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								// added by rupali on 24-08-19 for STP_DAR_BLOCK_DAYS validation [start]
								int dojValidCount = 0;
								String sDobj = "SELECT COUNT(1) AS CNT FROM EMPLOYEE E WHERE EMP_CODE = ? AND ? < E.DATE_JOIN";
								pstmt = connectionObject.prepareStatement(sDobj);
								pstmt.setString(1, userId);
								pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( evtdat, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

								rSet = pstmt.executeQuery();
								if (rSet.next())
								{
									dojValidCount = rSet.getInt("CNT");
								}
								if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								if(dojValidCount > 0)
								{
									errString = itmDBAccessLocal.getErrorString( "work_date" , "INVDTJWRK" , userId );
									break;
								}
								
								/*String salesMode = "", deviceType = "";
								String modeSql = "SELECT MODE_REPO FROM SALES_PERS WHERE SALES_PERS= ? ";
								pstmt = connectionObject.prepareStatement(modeSql);
								pstmt.setString(1,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	salesMode = checkNull(rSet.getString("MODE_REPO"));
							    	System.out.println("Records are Present........");
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
							    
								String deviceTypeSql = "SELECT DEVICE_TYPE, TO_CHAR(LOGINTIME, 'DD-MM-YYYY HH24:MI:SS A.M.') FROM LOGINTRACE WHERE USERID = ? AND LOGINTIME = (SELECT MAX(LOGINTIME) FROM LOGINTRACE WHERE USERID = ?)";
								pstmt = connectionObject.prepareStatement(deviceTypeSql);
								pstmt.setString(1,userId);
								pstmt.setString(2,userId);
								rSet = pstmt.executeQuery();
							    if(rSet.next())
							    {
							    	deviceType = checkNull(rSet.getString("DEVICE_TYPE"));
							    	System.out.println("DEVICE_TYPE........"+deviceType);
							    }
							    if (rSet != null)
								{
									rSet.close();
									rSet = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								
							    System.out.println(": MODE :"+salesMode);
							    if (!deviceType.trim().equalsIgnoreCase("Browser") && salesMode.equalsIgnoreCase("W"))
							    {
								    errString = itmDBAccessLocal.getErrorString( "event_date" , "INVLIDMODE" , userId );
							    }
							    
							    String propValue = fetchPropertyValue("NETREPORT_MOBMODE_DISSALLOW" , itemSer , connectionObject);
							    if (deviceType.trim().equalsIgnoreCase("Browser"))
								{									
									if (salesMode.equalsIgnoreCase("M") && propValue.indexOf(updateFlag) >= 0)
									{
											errString = itmDBAccessLocal.getErrorString( "work_date" , "MOBNETNA" , userId );
											break;
									}
								}*/
							}
						}
						else if (childNodeName.equalsIgnoreCase("next_plan_date"))//Added by mrunalini sinkar for next_plan_date validaiton
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
								java.util.Date nextPlanDate = null;
								java.util.Date eventDate = null;

								String workDate = checkNull(genericUtility.getColumnValue( "event_date" , dom ));

								try
								{
									nextPlanDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
									eventDate = sdfFormat.parse( workDate);

									System.out.println("nextPlanDate is:"+nextPlanDate);
								}
								catch ( Exception e )
								{
									errString = itmDBAccessLocal.getErrorString( "next_plan_date", "INVDTFRMT", userId );
									break;
								}

								String planDat=childNode.getFirstChild().getNodeValue();
								if (!sdfFormat.format(nextPlanDate).equals(planDat))
								{
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}

								if  ( nextPlanDate.compareTo(eventDate) <= 0)
								{

									errString = itmDBAccessLocal.getErrorString( "event_date", "INVPLDATE", userId );
									break;
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("event_type"))
						{
							//System.out.println("Inside eventtype");
							String actCode = checkNull(genericUtility.getColumnValue("event_type", dom2, objContext));
							//System.out.println("actCode =["+actCode+"]");
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Activity cannot be null:");
								errString = itmDBAccessLocal.getErrorString("event_type","NULACTCODE",userId);

								break;
							}
							else
							{
								String actSql = "";
								int count = 0;

								actSql = "SELECT COUNT(*) AS COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(actSql);
								pstmt.setString(1, actCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									errString = itmDBAccessLocal.getErrorString("event_type","ACTNOTPRE",userId);
									break;
								}
								//added by mrunalini sinkar on 1-june-2017 for activity type validation (start)
								String eventDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,objContext));
								String salesPers = checkNull(genericUtility.getColumnValue( "sales_pers" , dom2 ,objContext));

								String pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());

								//ArrayList halfDayActList = halfDayActivityList("HALF_DAY_ACTIVITIES",connectionObject);
								//int recCount = 0;
								ArrayList activityList = new ArrayList();
								String activitySql = "SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS=? ";
								pstmt = connectionObject.prepareStatement(activitySql);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));
								pstmt.setString(2, salesPers);
								rs = pstmt.executeQuery();
								while (rs.next())
								{
									activityList.add(rs.getString("ACTIVITY_CODE"));
									//System.out.println("arraylsit"+activityList);
								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}

								//recCount = activityList.size();
								columnValue = checkNull( columnValue );
								String checkSQL="";
								checkSQL = "SELECT SPRS_ACT_TRAN.ACTIVITY_CODE AS ACTIVITY_CODE,FIELDACTIVITY.ACTIVITY_TYPE AS ACTIVITY_TYPE FROM SPRS_ACT_TRAN,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND SPRS_ACT_TRAN.ACTIVITY_CODE = FIELDACTIVITY.ACTIVITY_CODE ";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
								pstmt.setString(2, salesPers);
								rs = pstmt.executeQuery();
								while(rs.next())
								{
									String activityCode =checkNull( rs.getString("ACTIVITY_CODE"));
									activityCode = checkNull(activityCode).trim().toUpperCase();
									//System.out.println("ACTIVITY CODE IS:"+activityCode);
									String activityType = checkNull(rs.getString("ACTIVITY_TYPE"));
									activityType = checkNull(activityType).trim().toUpperCase();
									//System.out.println("ACTIVITY TYPE IS:"+activityType);


									if(activityType.indexOf("LEAVE")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmtActivity = connectionObject.prepareStatement(checkSQL);
										pstmtActivity.setString(1, columnValue);
										rsActivity =pstmtActivity.executeQuery();
										if(rsActivity.next())
										{
											String eventType = checkNull(rsActivity.getString("ACTIVITY_TYPE"));
											//changed by vishal pathare on 6.11.17 for[ alert msg should display if activity code changed].
											//if(!columnValue.equalsIgnoreCase( activityCode ))
											if(!activityType.equalsIgnoreCase(eventType))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
											else
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "LEAVEDAY", userId );
												break;
											} // added by mrunalini sinkar to cannot allow LEAVE on same day
										}
									}
									//else if (activityType.indexOf("NFW")!=-1)//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
									else if (!activityType.equalsIgnoreCase("FW") && !activityType.equalsIgnoreCase("LEAVE"))
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmtActivity = connectionObject.prepareStatement(checkSQL);
										pstmtActivity.setString(1, columnValue);
										rsActivity =pstmtActivity.executeQuery();
										if(rsActivity.next())
										{
											String eventType = checkNull(rsActivity.getString("ACTIVITY_TYPE"));
											//changed by vishal pathare on 6.11.17 for[ alert msg should display if activity code changed].											//if(!activityType.equalsIgnoreCase(eventType))
											//if(!columnValue.equalsIgnoreCase( activityCode ))
											if(!activityType.equalsIgnoreCase(eventType))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
												break;
											}
											else
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "NFWDAY", userId );
												break;
											} // added by mrunalini sinkar to cannot allow NFW on same day
										}

									}
									else if (activityType.indexOf("FW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmtActivity = connectionObject.prepareStatement(checkSQL);
										pstmtActivity.setString(1, columnValue);
										rsActivity =pstmtActivity.executeQuery();
										if( rsActivity.next() )
										{
											String eventType = checkNull(rsActivity.getString("ACTIVITY_TYPE"));
											//System.out.println("activity type is:"+eventType);
											//changed by vishal pathare on 6.11.17 for[ alert msg should display if activity code changed].
											//if(!columnValue.equalsIgnoreCase( activityCode ))
											if(!activityType.equalsIgnoreCase(eventType))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
												break;
											}
										}

									}

									if (rsActivity!= null)
									{
										rsActivity.close();
										rsActivity = null;
									}
									if(pstmtActivity!=null)
									{
										pstmtActivity.close();
										pstmtActivity = null;
									}


								}
								if(rs!=null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
							//added by mrunalini sinkar on 1-june-2017 for activity type validation (end)

						}
						//added by mrunalini sinkar on 2-june-2017 for call outcome  validation (start)
						//added by mrunalini sinkar on 09-sep-2018 for place required changes (start)
						else if(childNodeName.equalsIgnoreCase("locality_code"))
						{
							String placeRequired = checkNull(genericUtility.getColumnValue( "place_required" , dom2 ,objContext));
							String vistedWithTeam = checkNull((genericUtility.getColumnValue("visited_with_team", dom2, objContext)));
							if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{

								if("Y".equalsIgnoreCase(placeRequired))	//added by mrunalini sinkar on 09-sep-2018 for place required changes
								{
									errString = itmDBAccessLocal.getErrorString( "locality_code" , "NULLOCCODE" , userId );
									break;
								}
							}
							// added condition by rupali on 30/10/17 for validation of new customer types
							else if("UNLISTED-DOCTOR".equalsIgnoreCase(strgType) || "UNLISTED-RETAILER".equalsIgnoreCase(strgType) || "UNLISTED-STOCKIST".equalsIgnoreCase(strgType) || "UNLISTED-OTHER".equalsIgnoreCase(strgType)
									|| "UNLISTED TRADE".equalsIgnoreCase(strgType) || "UNLISTED GEN TRADE".equalsIgnoreCase(strgType) || "UNLISTED INST SALE".equalsIgnoreCase(strgType) || "OTHER".equalsIgnoreCase(strgType)
									|| "LISTED".equalsIgnoreCase(strgType) || "LISTED-CLIENT".equalsIgnoreCase(strgType) || "LISTED-FRANCHISE".equalsIgnoreCase(strgType))
							{
								strgType = checkNull(genericUtility.getColumnValue("cust_type", dom));
								String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, objContext));
								String routeSql="";
								int count = 0;

								routeSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ? AND STATUS = 'Y'";
								pstmt = connectionObject.prepareStatement(routeSql);
								//pstmt.setString(1, userId);
								//added by mrunalini sinkar on 09-sep-2018 for place required changes(start)
								if(mgrCode.trim().length()== 0)
								{
									pstmt.setString(1, userId);
								}
								else
								{
									pstmt.setString(1, vistedWithTeam);
								}
								//added by mrunalini sinkar on 09-sep-2018 for place required changes(end)
								pstmt.setString(2, locCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									//System.out.println( "locality is not present in route " );
									errString = itmDBAccessLocal.getErrorString( "locality_code" , "ROUTENTPRE" , userId );
									break;
								}

								String localitySql = "";
								int cnt = 0;

								localitySql = "SELECT COUNT(*) AS COUNT FROM LOCALITY WHERE LOCALITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(localitySql);
								pstmt.setString(1, locCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(cnt == 0)
								{
									//System.out.println( "locality is not present in locality master " );
									errString = itmDBAccessLocal.getErrorString( "locality_code" , "LOCNOTPRE" , userId );
									break;
								}
							}


						}
						//added by mrunalini sinkar on 09-sep-2018 for place required changes (end)
						else if(childNodeName.equalsIgnoreCase("call_outcome"))
						{
							//System.out.println("inside Calloutcome7");
							String callOutCome = checkNull(getSelectedRowVal(dom2, objContext, "call_outcome", prntCtr));
							//System.out.println("callOutCome"+callOutCome);

							String meetSumm = checkNull(getSelectedRowVal(dom2, objContext, "meet_summ", prntCtr));
							///System.out.println("meetSumm"+meetSumm);

							strgCode = checkNull(getSelectedRowVal(dom2, objContext, "strg_code", prntCtr));
							//System.out.println(" strgCode  :::::::: "+strgCode);

							//commented by mrunalini sikar on 11-JUNE-2018 because the call note field is protect in case of refused(start)
							/*if(callOutCome.equalsIgnoreCase("0") && meetSumm.length() > 0)
							{
								System.out.println("inside if");
								errString = getErrorString("call_outcome","DELCALNOTE",userId);
								break;
							}*/
							//commented by mrunalini sikar on 11-JUNE-2018 because the call note field is protect in case of refused(end)
							String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
							//System.out.println("obj name is"+objName);
							//String doctorFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));

							HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
							//System.out.println(" doctor subFormsMap  :::::::: "+subFormsMap);
							String sampleitemFormNo = subFormsMap.get("sampleitem");
							String teamFormNo = subFormsMap.get("team");
							String displayFormNo = subFormsMap.get("display");
							String brandFormNo = subFormsMap.get("brand");
							String sampleOrderFormNo= subFormsMap.get("sampleorder");
							String invoiceFormNo= subFormsMap.get("invoice");//Added by Bhagyashri t for Invoice form no[W22EBAS004]
							boolean isinvoiceEmpty = isDeSelEmptyDOM(dom2, ""+invoiceFormNo,strgCode);//Added by Bhagyashri t for Invoice form no[W22EBAS004]
							boolean isSampleOrderEmpty = isDeSelEmptyDOM(dom2, ""+sampleOrderFormNo,strgCode);
							boolean isSampleItemEmpty = isDeSelEmptyDOM(dom2, ""+sampleitemFormNo,strgCode);
							boolean isDisplayEmpty = isDeSelEmptyDOM(dom2, ""+displayFormNo,strgCode);
							boolean isTeamEmpty = isDeSelEmptyDOM(dom2, ""+teamFormNo,strgCode);
							boolean isbrandEmpty = isDeSelEmptyDOM(dom2, ""+brandFormNo,strgCode);
							if((callOutCome.equalsIgnoreCase("0") || callOutCome.equalsIgnoreCase("9")) &&(!isSampleItemEmpty || !isDisplayEmpty || !isTeamEmpty || !isbrandEmpty || !isSampleOrderEmpty || !isinvoiceEmpty) )
							{
								//System.out.println("inside call outcome");
								errString = getErrorString("call_outcome","DELSUBFMDA",userId);
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("oth_participant"))
						{
							//System.out.println("oth_participant remark");
							if(columnValue != null && columnValue.length() >120)
							{
								errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
								break;
							}
						}
						//added by mrunalini sinkar on 2-june-2017 for call outcome  validation (end)
						//Added by Bhagyshri T for fortune validation of meeting status [start][17/12/21]						
						else if(childNodeName.equalsIgnoreCase("meeting_status"))
						{
							System.out.println(" isFortuneActivity is::"+isFortuneActivity);
							if("Y".equalsIgnoreCase(isFortuneActivity))
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									String activityType = checkNull(getSelectedRowVal(dom1, objContext, "activity_type", prntCtr));
									
									if(activityType.equalsIgnoreCase("FW"))
									{
									   errString =getErrorString("meeting_status","NULLMTSTAT",userId);
									   break;
									} //if condition added by prachi because getting meeting status alert on leave type  
								}
								else if(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{	
									int cnt=0;
									String callOutCome = checkNull(getSelectedRowVal(dom1, objContext, "meeting_status", prntCtr));
									String sprsActCode = checkNull(getSelectedRowVal(dom1, objContext, "event_type", prntCtr));
									System.out.println("columnValue of callOutCome is["+callOutCome+"]");
									System.out.println("columnValue of sprsActCode is["+sprsActCode+"]");
									columnValue = childNode.getFirstChild().getNodeValue().trim();
									System.out.println("columnValue of meeting status is["+columnValue+"]");
									String sqlc="SELECT COUNT(*) AS COUNT FROM CALL_OUTCOME WHERE TRIM(UPPER(CALL_OUTCOME_DESCR))=? AND ACTIVITY_CODE=? ";
									PreparedStatement meetingPstmt=connectionObject.prepareStatement(sqlc);
									meetingPstmt.setString(1, callOutCome.toUpperCase());
									meetingPstmt.setString(2, sprsActCode);

									ResultSet meetingRS=meetingPstmt.executeQuery();
									if(meetingRS.next())
									{
										cnt=meetingRS.getInt("COUNT");
									}
									if (meetingRS != null)
									{
										meetingRS.close();
										meetingRS = null;
									}
									if (meetingPstmt != null)
									{
										meetingPstmt.close();
										meetingPstmt = null;
									}
									if(cnt == 0)
									{
										errString = getErrorString("meeting_status","IVMETSTAS",userId);
										break;
									}
								}
							}
						}
						//Added by Bhagyshri T for fortune validation of meeting status [end][17/12/21]

						//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
						//else if(!("LEAVE".equalsIgnoreCase(actType) ||"NFW".equalsIgnoreCase(actType)))//added by mrunalini sinkar for leave and nfw validation on 31-may-2017
						else if("FW".equalsIgnoreCase(actType))//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
						{
							//Added by Pooja S on 18/12/19 [validation for COACHING_ACTIVITY]
							String actCode = checkNull(genericUtility.getColumnValue("event_type", dom2, objContext));
							if ( childNodeName.equalsIgnoreCase("strg_code"))
							{
								String routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));

								//System.out.println("IN SIDE STRG_CODE:::>>>"+childNodeName);
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "strg_code cannot be null:" );
									//Added by Pooja S on 18/12/19 [validation for COACHING_ACTIVITY]
									//if(!"H".equalsIgnoreCase(routeType) && !"M".equalsIgnoreCase(routeType))
									//if(!"H".equalsIgnoreCase(routeType) && !"M".equalsIgnoreCase(routeType) && !actCode.equalsIgnoreCase("CA") )
									//{}
									//if condition commented by prachi
									errString = itmDBAccessLocal.getErrorString( "strg_code" , "NULSTRGCOD" , userId );
									break;
									
								}
								else if("LISTED".equalsIgnoreCase(strgType) || "LISTED-CLIENT".equalsIgnoreCase(strgType) || "LISTED-FRANCHISE".equalsIgnoreCase(strgType))
								{
									dcrDate = checkNull((genericUtility.getColumnValue("event_date", dom2, objContext)));
									strgCode = checkNull((genericUtility.getColumnValue("strg_code", dom2, objContext)));
									//Added by Pooja S on 18/12/19 [validation for COACHING_ACTIVITY] START
									if( strgCode.equalsIgnoreCase("NA") )
									{
										continue;
									}
									//Added by Pooja S on 18/12/19 [validation for COACHING_ACTIVITY] END
									sprsCodeWW = checkNull((genericUtility.getColumnValue("visited_with_team", dom2, objContext))); // added by rupali on 03/05/18 for single screen mgr reporting
									String strgCustType = checkNull((genericUtility.getColumnValue("strg_type", dom2, objContext)));
									int count = 0;
									String strgCodeSql = "";
									String custActiveSql = "";
									if(strgCustType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										strgCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE= ? ";
									}
									else
									{
										strgCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? ";
									}
									pstmt = connectionObject.prepareStatement(strgCodeSql);
									pstmt.setString(1,strgCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										count = rs.getInt("COUNT");
									}
									//System.out.println("count =["+count+"]");
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										//System.out.println("INVALID STRG CODE::");
										errString = itmDBAccessLocal.getErrorString("strg_code","CUSTNTEXT",userId);
										break;
									}

									int custCount = 0;
									String custExistSql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ? AND STRG_CODE = ?";
									pstmt = connectionObject.prepareStatement(custExistSql);
									pstmt.setString(1, userId);
									pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
									pstmt.setString(3, strgCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										custCount = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(custCount > 0 && !"E".equalsIgnoreCase(updateFlag)) // added condition of by updateFlag rupali on 23/02/18 for edit mode of realtime report
									{
										//System.out.println("Customer Already Exist");
										//errString = itmDBAccessLocal.getErrorString("strg_code","CUSTEXST",userId);
										//break;
									}
									// added by rupali on 01/12/17 for validating inactive customer [start]
									int custActiveCnt = 0;
									String locCode = checkNull((genericUtility.getColumnValue("locality_code", dom2, objContext)));
									// commented and added by rupali on 10/02/17 for removing condition of strg_status_hist table [start]
									/*String custActiveSql = "SELECT COUNT (*) AS COUNT FROM STRG_SERIES SS, SPRS_ROUTE SR, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE "+
											"AND SR.LOCALITY_CODE = SC.LOCALITY_CODE AND SS.SALES_PERS = SR.SPRS_CODE AND SR.SPRS_CODE = ? "+
											"AND SR.LOCALITY_CODE = ? AND SS.SC_CODE IN (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' AND EFF_FROM <= ? "+
											"AND VALID_UPTO >= ? AND SALES_PERS = SS.SALES_PERS   AND SC_CODE = SC.SC_CODE ) AND SS.STATUS='Y' AND SS.SC_CODE = ? ";*/
									//commented by & added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)

									/*String custActiveSql = "SELECT COUNT (*) AS COUNT FROM STRG_SERIES SS, SPRS_ROUTE SR, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE "+
											"AND SR.LOCALITY_CODE = SC.LOCALITY_CODE AND SS.SALES_PERS = SR.SPRS_CODE AND SR.SPRS_CODE = ? "+
											"AND SR.LOCALITY_CODE = ? AND SS.STATUS='Y' AND SS.SC_CODE = ? ";*/

									if(strgCustType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										custActiveSql = "SELECT COUNT (*) AS COUNT FROM SPRS_STOCKIST SS, SPRS_ROUTE SR, CUSTOMER CUST LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON CUST.CUST_CODE = SVH.SC_CODE "+ 
												"WHERE SS.CUST_CODE = CUST.CUST_CODE AND (SR.LOCALITY_CODE = CUST.LOCALITY_CODE OR SR.LOCALITY_CODE = SVH.LOCALITY_CODE) "+
												"AND SS.SPRS_CODE = SR.SPRS_CODE AND SR.SPRS_CODE = ? AND SR.LOCALITY_CODE = ? AND SS.STATUS='Y' AND SS.CUST_CODE = ? ";
									}
									else
									{
										custActiveSql = "SELECT COUNT (*) AS COUNT FROM STRG_SERIES SS, SPRS_ROUTE SR, STRG_CUSTOMER SC LEFT OUTER JOIN STRG_VISIT_HOURS SVH ON SC.SC_CODE=SVH.SC_CODE "+
												"WHERE SS.SC_CODE = SC.SC_CODE AND (SR.LOCALITY_CODE = SC.LOCALITY_CODE OR SR.LOCALITY_CODE=SC.RES_LOCALITY_CODE OR SR.LOCALITY_CODE=SVH.LOCALITY_CODE)  "+
												"AND SS.SALES_PERS = SR.SPRS_CODE AND SR.SPRS_CODE = ? AND SR.LOCALITY_CODE = ? AND SS.STATUS='Y' AND SS.SC_CODE = ? ";
									}

									//commented by & added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

									pstmt = connectionObject.prepareStatement(custActiveSql);
									// added by rupali on 03/05/18 for single screen mgr reporting
									if(mgrCode.trim().length()== 0)
									{
										pstmt.setString(1, userId);
									}
									else
									{
										pstmt.setString(1, sprsCodeWW);
									}
									// added by rupali on 03/05/18 for single screen mgr reporting
									pstmt.setString(2, locCode);
									/*pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
									pstmt.setString(5, strgCode);*/
									pstmt.setString(3, strgCode);
									// commented and added by rupali on 10/02/17 for removing condition of strg_status_hist table [end]
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										custActiveCnt = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(custActiveCnt == 0)
									{
										errString = itmDBAccessLocal.getErrorString("strg_code","CUSTNOTACT",userId);
										break;
									}
									// added by rupali on 01/12/17 for validating inactive customer [end]
									// added by shraddha M for stockist validation[31-08-19:end]
									cusType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
									if ("S".equalsIgnoreCase(cusType) && "N".equalsIgnoreCase(RealParmData)) 
									{
										errString = itmDBAccessLocal.getErrorString("strg_type", "STKNOTALOW", userId);
										break;
									}
									// added by shraddha M for stockist validation[31-08-19:end]
								}
							}
							else if(childNodeName.equalsIgnoreCase("cust_type"))
							{
								strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
								strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2, objContext));
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									errString = itmDBAccessLocal.getErrorString( "cust_type" , "NULCUSTTYP" , userId );
									break;
								}
								else
								{
									// added by shraddha M for stockist validation[31-08-19:end]
									cusType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
									if ("S".equalsIgnoreCase(cusType) && "N".equalsIgnoreCase(RealParmData)) 
									{
										errString = itmDBAccessLocal.getErrorString("strg_type", "STKNOTALOW", userId);
										break;
									}
									// added by shraddha M for stockist validation[31-08-19:end]
								}
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [Start]
								//String totAllwCallList="";
								String maxStrgCustomr="";
								String itemSer = checkNull(getItemSer(userId,connectionObject));
								WSFACommon wsfaCommon=new WSFACommon();
								HashMap<String,String> totCustList=  new HashMap<String, String>();
								totCustList =wsfaCommon.getVisitData(userId, itemSer, connectionObject);
								for(Map.Entry<String, String> m:totCustList.entrySet())
								{
									maxStrgCustomr =(String)m.getKey();
								}
								if(maxStrgCustomr != null && maxStrgCustomr.trim().length() != 0)
								{
									totAllwCallList = maxStrgCustomr;
									System.out.println("totAllwCallList ["+totAllwCallList+"]");
								}
								else
								{
								 totAllwCallList = checkNull(getSfaParmValue(userId, "TOT_ALLOW_CALL_LIST", connectionObject));
								}
								//added by hariom shukla on 29/01/2020 for maximum customer allow validation [End]
								if(!"".equalsIgnoreCase(totAllwCallList) && ("UNLISTED-RETAILER".equalsIgnoreCase(strgType) || "UNLISTED-WHOLESALER".equalsIgnoreCase(strgType)))
								{
									int listCnt = 0;
									int totAllwCallListCnt = Integer.parseInt(totAllwCallList);
									String sqlCount = "SELECT "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SALES_PERS = ? AND SC.CUST_TYPE IN ('C','W') AND SS.STATUS = 'Y') "+
													  "+ "+
													  "(SELECT COUNT(*) AS COUNT FROM STRG_CUST_ADD WHERE SALES_PERS = ? AND WF_STATUS NOT IN ('A','R') AND STRG_TYPE IN ('C','W')) AS COUNT FROM DUAL ";
									pstmt = connectionObject.prepareStatement(sqlCount);
									pstmt.setString(1, userId);
									pstmt.setString(2, userId);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										listCnt = rs.getInt("COUNT");
									}
									if (rSet != null)
									{
										rSet.close();
										rSet = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(listCnt >= totAllwCallListCnt)
									{
										errString = itmDBAccessLocal.getErrorString("cust_type", "UNLSTNTALW", userId);
										break;
									}
								}

							}
							/*else if(childNodeName.equalsIgnoreCase("address_as"))
							{
								String scCode = checkNull(genericUtility.getColumnValue("strg_code", dom2, objContext));// added by mrunalini sinkar to add sc code condition
								String locality = checkNull(genericUtility.getColumnValue("locality_code", dom2, objContext));// added by mrunalini sinkar to add sc code condition

								if(scCode != null && scCode.trim().length() > 0 && locality != null && locality.trim().length() > 0)
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										System.out.println( "address_as cannot be null:" +childNodeName);
										errString = itmDBAccessLocal.getErrorString( "address_as" , "NULLADDAS" , userId );
										break;
									}
								}

							}*/
							else if(childNodeName.equalsIgnoreCase("gender"))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "gender cannot be null:" +childNodeName);
									/*errString = itmDBAccessLocal.getErrorString( "gender" , "NULLGENDR" , userId );
									break;*/
								}
							}
							//added by mrunalini sinkar on 20-july-2017 to add speciality code validation(start)
							//else if(childNodeName.equalsIgnoreCase("spl_code") && "D".equalsIgnoreCase(cusType))
							else if(childNodeName.equalsIgnoreCase("spl_code") && (strgType.equalsIgnoreCase("LISTED") || (!strgType.equalsIgnoreCase("LISTED") && !isMemberPresnt.equalsIgnoreCase("Y") )))
							{
								String routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));

								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									if("D".equalsIgnoreCase(cusType))//W22BGOC003 routetype M condition removed by prachi
									{
										//System.out.println( "speciality cannot be null:" +childNodeName);
										errString = itmDBAccessLocal.getErrorString( "spl_code" , "NULLSPL" , userId );
										break;
									}
								}
								// added by rupali on 13/11/18 for adding validation on invalid speciality[start]
								else
								{
									String splCode = checkNull(genericUtility.getColumnValue("spl_code", dom2, objContext));
									String splCodeSql = "";
									int cnt = 0;

									splCodeSql = "SELECT COUNT(*) AS COUNT FROM SPECIALITY WHERE SPL_CODE = ?";
									pstmt = connectionObject.prepareStatement(splCodeSql);
									pstmt.setString(1, splCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(cnt == 0)
									{
										//System.out.println( "Speciality is not present in speciality master " );
										errString = itmDBAccessLocal.getErrorString( "spl_code" , "SPLNOTPRE" , userId );
										break;
									}
								}
								// added by rupali on 13/11/18 for adding validation on invalid speciality[end]
							}
							//commented by mrunalini sinkar on 26-june-2018(start)
							//added by mrunalini sinkar on 20-july-2017 to add speciality code validation(end)
							/*else if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								System.out.println("INSIDE Listed locality_code.......>"+childNodeName);
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									System.out.println( "locality cannot be null:" );
									errString = itmDBAccessLocal.getErrorString( "locality_code" , "NULLOCCODE" , userId );
									break;
								}
								// added condition by rupali on 30/10/17 for validation of new customer types
								else if("UNLISTED-DOCTOR".equalsIgnoreCase(strgType) || "UNLISTED-RETAILER".equalsIgnoreCase(strgType) || "UNLISTED-STOCKIST".equalsIgnoreCase(strgType) || "UNLISTED-OTHER".equalsIgnoreCase(strgType)
										|| "UNLISTED TRADE".equalsIgnoreCase(strgType) || "UNLISTED GEN TRADE".equalsIgnoreCase(strgType) || "UNLISTED INST SALE".equalsIgnoreCase(strgType) || "OTHER".equalsIgnoreCase(strgType))
								{
									System.out.println("inside unlisted condition of locCode");
									strgType = checkNull(genericUtility.getColumnValue("cust_type", dom));
									String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, objContext));
									String routeSql="";
									int count = 0;

									routeSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ? AND STATUS = 'Y'";
									pstmt = connectionObject.prepareStatement(routeSql);
									pstmt.setString(1, userId);
									pstmt.setString(2, locCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										count = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										System.out.println( "locality is not present in route " );
										errString = itmDBAccessLocal.getErrorString( "locality_code" , "ROUTENTPRE" , userId );
										break;
									}

									String localitySql = "";
									int cnt = 0;

									localitySql = "SELECT COUNT(*) AS COUNT FROM LOCALITY WHERE LOCALITY_CODE = ?";
									pstmt = connectionObject.prepareStatement(localitySql);
									pstmt.setString(1, locCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(cnt == 0)
									{
										System.out.println( "locality is not present in locality master " );
										errString = itmDBAccessLocal.getErrorString( "locality_code" , "LOCNOTPRE" , userId );
										break;
									}
								}

							}*/
							//commented by mrunalini sinkar on 26-june-2018(end)
							//added by rupali on 18/09/17 for worked with field [start]
							// added by rupali on 27/10/17 for displaying preffered stockist field [start]
							else if(childNodeName.equalsIgnoreCase("stockist_code") && "Y".equalsIgnoreCase(parmValue) && (strgType.equalsIgnoreCase("LISTED") || (!strgType.equalsIgnoreCase("LISTED") && !isMemberPresnt.equalsIgnoreCase("Y"))))
							{
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "stockist code cannot be null:" +childNodeName);
									errString = itmDBAccessLocal.getErrorString( "stockist_code" , "NULSTKCODE" , userId );
									break;
								}
								else
								{
									String stockCode = checkNull((genericUtility.getColumnValue("stockist_code", dom2, objContext)));
									int count = 0;
									String stockCodeSql = "";
									if(stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE= ? AND CUST_TYPE = 'S'";
									}
									else
									{
										stockCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE= ? AND CUST_TYPE = 'S'";
									}
									pstmt = connectionObject.prepareStatement(stockCodeSql);
									pstmt.setString(1,stockCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										count = rs.getInt("COUNT");
									}
									//System.out.println("count =["+count+"]");
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										//System.out.println("INVALID STOCK CODE::");
										errString = itmDBAccessLocal.getErrorString("stockist_code","STKSTNTEXT",userId);
										break;
									}
								}
							}
							// added by rupali on 27/10/17 for displaying preffered stockist field [end]
							else if(childNodeName.equalsIgnoreCase("visited_with") && mgrCode.trim().length()== 0 )
							{
								if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
								{
									int index ;
									String reportToSql = "";
									ArrayList teamList = new ArrayList();
									String salesPers = genericUtility.getColumnValue( "sales_pers" , dom2 , objContext);
									//System.out.println("in visited_with salesPers:::: "+salesPers);
									if(dbName.equalsIgnoreCase("DB2"))
									{
										reportToSql ="select DISTINCT REPORT_TO from employee where fn_emp_hierarcy_up(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
									}
									else if(dbName.equalsIgnoreCase("ORACLE"))
									{
										reportToSql ="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
									}
									// added by rupali on 13/04/18 for org_structure related changes [start]
									String eventDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,objContext));
									String isOrgStrcture = getSfaParmValue(salesPers,"HIERARCY_FRM_ORG_STR",connectionObject);
									if("Y".equalsIgnoreCase(isOrgStrcture)) 
									{
										OrgStructure orgStructure = new OrgStructure();
										teamList = orgStructure.reportToUp(salesPers,eventDate,connectionObject);
									}
									//System.out.println("teamList is::::"+teamList);
									// added by rupali on 13/04/18 for org_structure related changes [start]
									if(teamList == null || teamList.isEmpty() || dbName.equalsIgnoreCase("DB2")) // added by rupali on 13/04/18 for org_structure related changes
									{
										pstmt = connectionObject.prepareStatement(reportToSql);
										pstmt.setString(1, salesPers);
										rSet =pstmt.executeQuery();
										while(rSet.next())
										{
											String teamMember = checkNull(rSet.getString("REPORT_TO"));
											teamList.add(teamMember);
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									String visitedWith = checkNull(genericUtility.getColumnValue( "visited_with", dom2 ));
									//Added by Pooja S on [9-JAN-2020] - if visited_with without (emp_code) then pass code
									String visitedWithCode = checkNull(genericUtility.getColumnValue( "visited_with_code", dom2 ));
									System.out.println( "visited_with::::["+ visitedWith +"] visitedWithCode ["+ visitedWithCode +"]" );
									if( visitedWith.indexOf("(") != -1 && visitedWith.indexOf(")") != -1 )
									{
										String[] temp = visitedWith.split( "," );
										for ( int i = 0; i < temp.length; i++ )
										{
											String visitTeam = temp[i];
											if( visitTeam.indexOf("(") != -1 && visitTeam.indexOf(")") != -1 )
											{
												String selTeam = checkNull(visitTeam.substring(visitTeam.indexOf("(")+1, visitTeam.indexOf(")")));
												if(!teamList.contains(selTeam))
												{
													
													String division=getItemSer(userId, connectionObject);
													int rolCnt=0;
													String sql2="SELECT COUNT(*) AS CNT FROM EMPLOYEE EMP, GRADE G " + 
															"WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
															"WHERE ORG_UNIT=? CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE AND EMP.EMP_CODE=? ";
													pstmt = connectionObject.prepareStatement(sql2);
													pstmt.setString(1, division);
													pstmt.setString(2, selTeam);

													rSet =pstmt.executeQuery();
													if(rSet.next())
													{
														rolCnt=rSet.getInt("CNT");
													}
													if (rSet!= null)
													{
														rSet.close();
														rSet = null;
													}
													if(pstmt!=null)
													{
														pstmt.close();
														pstmt = null;
													}
													if(rolCnt==0)
													{
														errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
														return errString;
													}
													
													
													
													

												}
											}
											else
											{
												errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
												return errString;
											}
										}
									} 
									else
									{
										//Changed by Pooja S on [9-JAN-2020] - if visited_with without (emp_code) then pass code
										//if( ! teamList.contains( visitedWithCode.trim() ) )
										if( ! teamList.contains( visitedWithCode.trim() )  &&  ! teamList.contains( visitedWith.trim() ))
										{
											errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALVISIT", userId );
											return errString;
										}
									}
								}
							}
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [start]
							else if (childNodeName.equalsIgnoreCase("event_time_start"))
							{
								//System.out.println("INSIDE event_time_start.......>"+childNodeName);
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "event_time_start cannot be null:" );
									errString = itmDBAccessLocal.getErrorString( "event_time_start" , "NULLEVNTFR" , userId );
									break;
								}
							}
							else if (childNodeName.equalsIgnoreCase("event_time_end"))
							{
								//System.out.println("INSIDE event_time_end.......>"+childNodeName);
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "event_time_to cannot be null:" );
									errString = itmDBAccessLocal.getErrorString( "event_time_end" , "NULLEVNTTO" , userId );
									break;
								}
								else 
								{
									boolean retFlag=true;
									String startVisitTime = checkNull(genericUtility.getColumnValue("event_time_start", dom2, objContext));
									String endVisitTime = checkNull(genericUtility.getColumnValue("event_time_end", dom2, objContext));

									retFlag = validateEndTime(startVisitTime , endVisitTime);
									if (!retFlag)
									{
										errString = itmDBAccessLocal.getErrorString("event_time_end","VTVSTTIM02",userId);
										break;
									}
								}
							}
							// added by rupali on 15/12/17 for validating event_time_start and event_time_end fields [end]
							//added by rupali on 18/09/17 for worked with field [end]
							// added by rupali on 03/05/18 for single screen mgr reporting [start]
							else if(childNodeName.equalsIgnoreCase("visited_with") && mgrCode.trim().length() != 0)
							{
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "visited_with_team cannot be null:" );
									errString = itmDBAccessLocal.getErrorString( "visited_with" , "NULLTEAM" , userId );
									break;
								}
								else
								{
									int index ;
									String reportToSql = "";
									ArrayList teamList = new ArrayList();
									String salesPers = genericUtility.getColumnValue( "sales_pers" , dom2 , objContext);
									//System.out.println("in visited_with salesPers:::: "+salesPers);
									if(dbName.equalsIgnoreCase("DB2"))
									{
										reportToSql ="select DISTINCT EMP_CODE AS SALES_TEAM from employee where fn_emp_hierarcy_dn(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
									}
									else if(dbName.equalsIgnoreCase("ORACLE"))
									{
										reportToSql ="SELECT EMP_CODE AS SALES_TEAM FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL ";
									}
									String eventDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,objContext));
									String resignEmp = checkNull(genericUtility.getColumnValue( "resign_emp" , dom2 ,objContext));
									String isOrgStrcture = getSfaParmValue(salesPers,"HIERARCY_FRM_ORG_STR",connectionObject);
									if("Y".equalsIgnoreCase(isOrgStrcture))
									{
										OrgStructure orgStructure = new OrgStructure();
										teamList = orgStructure.reportToDown(salesPers,eventDate,resignEmp,connectionObject);
									}

									System.out.println("teamList is::::"+teamList);
									if(teamList == null || teamList.isEmpty() || dbName.equalsIgnoreCase("DB2"))
									{
										pstmt = connectionObject.prepareStatement(reportToSql);
										pstmt.setString(1, salesPers);
										rSet =pstmt.executeQuery();
										while(rSet.next())
										{
											String teamMember = checkNull(rSet.getString("SALES_TEAM"));
											teamList.add(teamMember);
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									String visitedWith = checkNull(genericUtility.getColumnValue( "visited_with", dom2 ));
									//Added by Pooja S on [9-JAN-2020] - if visited_with without (emp_code) then pass code 
									String visitedWithCode = checkNull(genericUtility.getColumnValue( "visited_with_code", dom2 ));
									System.out.println( "visited_with:::: ::: :::["+ visitedWith +"] visitedWithCode ["+ visitedWithCode +"]" );
									if( visitedWith.indexOf("(") != -1 && visitedWith.indexOf(")") != -1 )
									{
										String [] temp = visitedWith.split( "," );
										for( int i = 0; i < temp.length; i++ )
										{
											String visitTeam = temp[i];
											if(visitTeam.indexOf("(") != -1 && visitTeam.indexOf(")") != -1)
											{
												String selTeam = checkNull(visitTeam.substring( visitTeam.indexOf("(")+1, visitTeam.indexOf(")") ) );
												if( ! teamList.contains( selTeam ) )
												{
													String division=getItemSer(userId, connectionObject);
													int rolCnt=0;
													String sql2="SELECT COUNT(*) AS CNT FROM EMPLOYEE EMP, GRADE G " + 
															"WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
															"WHERE ORG_UNIT=? CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE AND EMP.EMP_CODE=? ";
													pstmt = connectionObject.prepareStatement(sql2);
													pstmt.setString(1, division);
													pstmt.setString(2, selTeam);

													rSet =pstmt.executeQuery();
													if(rSet.next())
													{
														rolCnt=rSet.getInt("CNT");
													}
													if (rSet!= null)
													{
														rSet.close();
														rSet = null;
													}
													if(pstmt!=null)
													{
														pstmt.close();
														pstmt = null;
													}
													if(rolCnt==0)
													{
														errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALTEAM", userId );
														return errString;
													}
												}
											}
											else if(!"SELF".equalsIgnoreCase(visitedWith))
											{
												errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALTEAM", userId );
												return errString;
											}
										}
									}
									else
									{
										//Changed by Pooja S on [9-JAN-2020] - if visited_with without (emp_code) then pass code 
										if( ! "SELF".equalsIgnoreCase(visitedWith) && ! teamList.contains( visitedWithCode.trim() ) )
										{
											errString = itmDBAccessLocal.getErrorString( "visited_with", "INVALTEAM", userId );
											return errString;
										}
									}
								}
							}
							// added by rupali on 03/05/18 for single screen mgr reporting [end]
							else if (childNodeName.equalsIgnoreCase("unlist_locality"))
							{
								//System.out.println("INSIDE unlist_locality-.......>"+childNodeName);
								if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									//System.out.println( "client_name cannot be null:" );
									errString = itmDBAccessLocal.getErrorString( "unlist_locality" , "NULLOCCODE" , userId );
									break;
								}
							}
							// added condition by rupali on 30/10/17 for validation of new customer types
							else if(!"LISTED".equalsIgnoreCase(strgType) && !isMemberPresnt.equalsIgnoreCase("Y")) //Added by mrunalini sinkar for member presnt
							{
								String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, objContext));
								String custName = checkNull(genericUtility.getColumnValue("strg_name", dom2, objContext));
								String routeType = checkNull((genericUtility.getColumnValue("route_type", dom2, objContext)));

								String addressAs = checkNull(genericUtility.getColumnValue("address_as", dom2, objContext));								
								if( locCode.trim().length() != 0 && custName.trim().length() != 0)//W22BGOC003 routetype M condition removed by prachi
								{
									if ( "email_addr".equalsIgnoreCase(childNodeName))
									{
										//System.out.println("INSIDE email_addr-.......>"+childNodeName);
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//commented by rupali on 09/10/17 as per client requirement for not validating null email_addr
											//removed comment on 16/01/19 for applying validation on mobile number for chc
											//System.out.println( "email_addr cannot be null:" );
											//aded by mrunalini sinka as per gulzar si on 29-03-2019(start)
											/*errString = itmDBAccessLocal.getErrorString( "email_addr" , "NULEMAILID" , userId );
											break;*/
											//aded by mrunalini sinka as per gulzar si on 29-03-2019(end)
										}
										else
										{
											String emailAddr = checkNull(genericUtility.getColumnValue("email_addr", dom2, objContext));
											//System.out.println("email_addr ::::["+emailAddr+"]");
											boolean isEmail = true;
											String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
											if(emailAddr != null )
											{
												isEmail = emailAddr.matches(ePattern);
												if(!(isEmail))
												{
													errString = itmDBAccessLocal.getErrorString("email_addr","INVDEMAILD",userId);
													break;
												}
											}
										}
									}
									//Added by prachi on 26/04/2022 [ W22AGOC002 ] start
									else if ( "qualification".equalsIgnoreCase(childNodeName))
									{
										String qualification = checkNull(genericUtility.getColumnValue("qualification", dom2, objContext));
										String custType = checkNull(genericUtility.getColumnValue("cust_type", dom2, objContext));
										int cnt=0;
										if(custType=="UNLISTED-DOCTOR")
									    {
											if(qualification == null || qualification.trim().length() == 0)
											{
												errString = itmDBAccessLocal.getErrorString("qualification","QULINULL",userId);
												break;
											}
									    }
										if(qualification.trim().length()>0)
										{
											String sql2 = "SELECT COUNT(*) AS COUNT FROM QUALIFICATION WHERE QLF_CODE=?";
											pstmt = connectionObject.prepareStatement(sql2);
											pstmt.setString(1,qualification.trim());
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												cnt = rs.getInt("COUNT");
											}
											if (rs != null)
											{
												rs.close();
												rs = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(cnt == 0)
											{
												errString = itmDBAccessLocal.getErrorString("qualification","QULIINVLD",userId);
												break;
											}

										}	
									}
									//Added by prachi on 26/04/2022 [ W22AGOC002 ] end

									else if ( "mobile_no".equalsIgnoreCase(childNodeName))
									{
										//System.out.println("INSIDE mobile_no-.......>"+childNodeName);
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
											//removed comment on 16/01/19 for applying validation on mobile number for chc
											//System.out.println( "mobile_no cannot be null:" );
											errString = itmDBAccessLocal.getErrorString( "mobile_no" , "NULPHONNO" , userId );
											break;
										}
										else
										{
											String phoneNo = checkNull(genericUtility.getColumnValue("mobile_no", dom2, objContext));
											phoneNo = (phoneNo == null) ?"":phoneNo.trim();
											//System.out.println("phone::::["+phoneNo+"]");
											if(phoneNo == null || phoneNo.trim().length() <= 0)
											{
												//commented by rupali on 09/10/17 as per client requirement for not validating null mobile_no
												//removed comment on 16/01/19 for applying validation on mobile number for chc
												errString = itmDBAccessLocal.getErrorString( "mobile_no","NULPHONENO",userId );
												break;
											}
											else if(phoneNo.length() < 10 || phoneNo.length() > 10 || phoneNo.startsWith("0"))
											{
												//System.out.println("Invalid PHONE no.....");
												errString = itmDBAccessLocal.getErrorString("mobile_no","INVDPHNLNO",userId);
												break;
											}
	
										}
									}
									//added by mrunalini sinkar on 19-june-2017 for customer name is blank validation(start)
									/*else if(childNodeName.equalsIgnoreCase("strg_name"))
									{
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											System.out.println( "customer name cannot be null:" +childNodeName);
											errString = itmDBAccessLocal.getErrorString( "strg_name" , "BLANKCUST" , userId );
											break;
										}
									}*/
									//added by mrunalini sinkar on 19-june-2017 for customer name is blank validation(end)
									//added by rupali on 16/01/19 for applying validation on address1 field for chc [start]
									else if(childNodeName.equalsIgnoreCase("addr1") && addressAs.trim().length() != 0)
									{
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//System.out.println( "addr1 cannot be null:" +childNodeName);
											errString = itmDBAccessLocal.getErrorString( "addr1" , "NULLADDR" , userId );
											break;
										}
									}
									//added by rupali on 16/01/19 for applying validation on address1 field for chc [end]
	
									//else if(childNodeName.equalsIgnoreCase("strg_class_code") && "D".equalsIgnoreCase(cusType))
									else if(childNodeName.equalsIgnoreCase("strg_class_code"))
									{
										String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom2, objContext));
	
										//System.out.println("INSIDE CLASS CODE CONDITION" +classCode);
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//System.out.println( "Class code cannot be null" );
											errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
											break;
										}
										else
										{
											int count = 0;
											String codeSql = "";
											String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
											// added by mrunalini sinkar on 31-jan-2019 for class code validation(start)
											String vistedWithTeam = checkNull((genericUtility.getColumnValue("visited_with_team", dom2, objContext)));
	
											String salesPerson="";
											if(mgrCode.trim().length()== 0)
											{
												salesPerson= userId;
											}
											else
											{
												salesPerson=vistedWithTeam;
											}
											String itemSer = checkNull(getItemSer(salesPerson,connectionObject));
											//System.out.println("INSIDE CLASS CODE itemSer" +itemSer);
	
											int classCount = getCountFromSerClass(itemSer,classCode,connectionObject); // added by mrunalini sinkar for class code pophelp on 31-jan-2019(start)
											if(classCount==0)
											{
												codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
												pstmt = connectionObject.prepareStatement(codeSql);
												pstmt.setString(1,custType);
												pstmt.setString(2,classCode);
												rs = pstmt.executeQuery();
												if(rs.next())
												{
													count = rs.getInt("COUNT");
												}
												if (rs != null)
												{
													rs.close();
													rs = null;
												}
												if (pstmt != null)
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													//System.out.println("INVALID CLASS CODE::");
													errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
													break;
												}
											}
	
	
											// added by mrunalini sinkar on 31-jan-2019 for class code validation(end)
										
											/*System.out.println("classCode =["+classCode+"], custType = ["+custType+"]");
											codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_CLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ?";
											pstmt = connectionObject.prepareStatement(codeSql);
											pstmt.setString(1,custType);
											pstmt.setString(2,classCode);
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												count = rs.getInt("COUNT");
											}
											if (rs != null)
											{
												rs.close();
												rs = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												System.out.println("INVALID CLASS CODE::");
												errString = itmDBAccessLocal.getErrorString("strg_class_code","INVCLSCODE",userId);
												break;
											}*/
										}
									}
									// added by rupali on 18/01/19 for applying validation on subclass [start]
									else if(childNodeName.equalsIgnoreCase("subclass_code"))
									{
										if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//System.out.println( "subclass_code code cannot be null" );
											/*errString = itmDBAccessLocal.getErrorString( "strg_class_code" , "NULCLSCODE" , userId );
											break;*/
										}
										else
										{
											int count = 0;
											String codeSql = "";
											String subClassCode = checkNull(genericUtility.getColumnValue("subclass_code", dom2, objContext));
											String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom2, objContext));
											String custType = checkNull(genericUtility.getColumnValue("strg_type", dom2, objContext));
											//System.out.println("classCode =["+classCode+"], custType = ["+custType+"]");
											codeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUST_SUBCLASS WHERE CUST_TYPE = ? AND CLASS_CODE = ? AND SUBCLASS_CODE = ? ";
											pstmt = connectionObject.prepareStatement(codeSql);
											pstmt.setString(1,custType);
											pstmt.setString(2,classCode);
											pstmt.setString(3,subClassCode);
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												count = rs.getInt("COUNT");
											}
											if (rs != null)
											{
												rs.close();
												rs = null;
											}
											if (pstmt != null)
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												//System.out.println("INVALID SUBCLASS CODE::");
												errString = itmDBAccessLocal.getErrorString("subclass_code","INVSUBCLS",userId);
												break;
											}
										}
									}
									// added by rupali on 18/01/19 for applying validation on subclass [end]
									else if(childNodeName.equalsIgnoreCase("address_as"))
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//System.out.println( "address_as cannot be null:" +childNodeName);
											errString = itmDBAccessLocal.getErrorString( "address_as" , "NULLADDAS" , userId );
											break;
										}
									}
								}	
								//added by mrunalini sinkar on 19-june-2017 for customer name is blank validation(start)
								//else if(childNodeName.equalsIgnoreCase("strg_name") && !"M".equalsIgnoreCase(routeType))
								else if(childNodeName.equalsIgnoreCase("strg_name"))	
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//System.out.println( "customer name cannot be null:" +childNodeName);
										errString = itmDBAccessLocal.getErrorString( "strg_name" , "BLANKCUST" , userId );
										break;
									}
								}
								//added by mrunalini sinkar on 19-june-2017 for customer name is blank validation(end)
							}
							else if(!"LISTED".equalsIgnoreCase(strgType) && isMemberPresnt.equalsIgnoreCase("Y"))//Added by mrunalini sinkar for member presnt
							{
								if(childNodeName.equalsIgnoreCase("member_present"))
								{
									if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString( "member_present" , "NULMEMPRE" , userId );
										break;
									}
								}
								
							}
						}
						if (childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString =getErrorString("sales_pers","NULSPCODNM",userId);
								break;
							}
							/*else
							{
								DARCommonBean darCommonBean= new DARCommonBean();
								String standCodeHQ=darCommonBean.getStandCodeHq(userId, connectionObject);
								System.out.println("standCodeHQ is:["+standCodeHQ+"]");
								if(standCodeHQ==null || standCodeHQ.trim().length()==0)
								{
									errString = itmDBAccessLocal.getErrorString( "sales_pers", "HQNTCONFIG", userId );
									break;
								}
								else
								{
									boolean isRouteConfig=darCommonBean.checkHeadquarterRouteIsAvilable(userId, standCodeHQ, connectionObject);
									System.out.println("isRouteConfig is:["+isRouteConfig+"]");

									if(!isRouteConfig)
									{
										errString = itmDBAccessLocal.getErrorString( "sales_pers", "ROUTCONFIG", userId );
										break;
									}
								}
							}*/
						}
						//added by mrunalini sinkar on 26-june-2018 for place required changes(start)
						//changes by mrunalini sinkar on 09-sep-2018(start)
						/*if(!("LEAVE".equalsIgnoreCase(actType)))
						{
							if(childNodeName.equalsIgnoreCase("locality_code"))
							{
								System.out.println("INSIDE Listed locality_code.......>"+childNodeName);
								if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
										( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
								{
									System.out.println( "locality cannot be null:" );
									errString = itmDBAccessLocal.getErrorString( "locality_code" , "NULLOCCODE" , userId );
									break;
								}
								// added condition by rupali on 30/10/17 for validation of new customer types
								else if("UNLISTED-DOCTOR".equalsIgnoreCase(strgType) || "UNLISTED-RETAILER".equalsIgnoreCase(strgType) || "UNLISTED-STOCKIST".equalsIgnoreCase(strgType) || "UNLISTED-OTHER".equalsIgnoreCase(strgType)
										|| "UNLISTED TRADE".equalsIgnoreCase(strgType) || "UNLISTED GEN TRADE".equalsIgnoreCase(strgType) || "UNLISTED INST SALE".equalsIgnoreCase(strgType) || "OTHER".equalsIgnoreCase(strgType))
								{
									System.out.println("inside unlisted condition of locCode");
									strgType = checkNull(genericUtility.getColumnValue("cust_type", dom));
									String locCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, objContext));
									String routeSql="";
									int count = 0;

									routeSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ? AND STATUS = 'Y'";
									pstmt = connectionObject.prepareStatement(routeSql);
									pstmt.setString(1, userId);
									pstmt.setString(2, locCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										count = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(count == 0)
									{
										System.out.println( "locality is not present in route " );
										errString = itmDBAccessLocal.getErrorString( "locality_code" , "ROUTENTPRE" , userId );
										break;
									}

									String localitySql = "";
									int cnt = 0;

									localitySql = "SELECT COUNT(*) AS COUNT FROM LOCALITY WHERE LOCALITY_CODE = ?";
									pstmt = connectionObject.prepareStatement(localitySql);
									pstmt.setString(1, locCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt("COUNT");
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(cnt == 0)
									{
										System.out.println( "locality is not present in locality master " );
										errString = itmDBAccessLocal.getErrorString( "locality_code" , "LOCNOTPRE" , userId );
										break;
									}
								}

							}
						}*/
						//changes by mrunalini sinkar on 09-sep-2018(start)
						//added by mrunalini sinkar on 26-june-2018 for place required changes(end)
					}
				}
				if(errString != null && errString.length()>0 && errString.indexOf("Errors")!=-1)
				{
					System.out.println(" Detail contaning :: errString :: []");
					String msgDescr = "";
					msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
					if(errString.contains("UNLSTNTALW"))
					{
						String strData = msgDescr.substring( msgDescr.indexOf("having")+("having").length(), msgDescr.indexOf("customers"));
						msgDescr = msgDescr.replace(strData, " "+totAllwCallList+" ");
						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
					}
					return errString;
				}

				//	}
			}
			//added by mrunalini sinkar for quantity validation in order and sample item subform on 16-june-2017(start)
			else if("sampleitem".equalsIgnoreCase(formName) || "retailersampleitem".equalsIgnoreCase(formName) || "sampleorder".equalsIgnoreCase(formName) || "retailersampleorder".equalsIgnoreCase(formName) || "stockistsampleorder".equalsIgnoreCase(formName) || "ncwsampleorder".equalsIgnoreCase(formName) || "stockistsampleitem".equalsIgnoreCase(formName) || "ncwsampleitem".equalsIgnoreCase(formName))
			{
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;

				String sampleDescr = "";

				//System.out.println("Case 4 : validation ::");
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");
				String orderParam = checkNull(getSfaParmValue(userId, "ORDER_QTY", connectionObject));
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";
					sampleDescr = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						String isStockInfo = checkNull(getSfaParmValue(userId,"IS_STOCK_INFO",connectionObject)); // added by mrunalini sinkar on 10-august-2018(start)

						//System.out.println("isStockInfo =["+isStockInfo+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
								{
									System.out.println("INSIDE THE FLAG");
									break;
								}
							}
						}
						else if ( "quantity".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("quantity inside is null");
								if("Y".equalsIgnoreCase(orderParam))// add sfaparm condtion by mrunalini sinkar for quantity validation(start)
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
									break;
								}
								
							}
							else
							{
								try
								{
									//String quantity = checkNull(genericUtility.getColumnValue("quantity", dom, ""+currentFormNo));
									int minQuantity=0;
									String quantity = checkNullNum(genericUtility.getColumnValueFromNode("quantity", currDetail));
									//Added by Mrunalini Sinkar for chc enhancment(Start)
									String minQuan = checkNullNum(genericUtility.getColumnValueFromNode("min_quantity", currDetail));
									String remark = genericUtility.getColumnValueFromNode("remark_descr", currDetail);
									
									//System.out.println("quantity inside:- "+quantity);
									int quan = Integer.parseInt(quantity);
									if(minQuan!=null && minQuan.trim().length()>0)
									{
										minQuantity = Integer.parseInt(minQuan);
									}
									//Added by Mrunalini Sinkar for chc enhancment(End)
									//System.out.println("quanquan :::::"+quan);
									if( quan <= 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
										break;
									}
									//Added by Mrunalini Sinkar for chc enhancment(Start)
									if( quan < minQuantity && (remark==null || remark.trim().length()==0))
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","LESSQUAN",userId);
										break;
									}
									//Added by Mrunalini Sinkar for chc enhancment(End)
								}
								catch(NumberFormatException num)
								{
									//System.out.println("NumberFormatException occours for ");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
								}
							}
						}
						// added by rupali on 10/09/17 for applying validation on rate field [start]
						else if ( "rate".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("quantity inside is null");
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								errString = itmDBAccessLocal.getErrorString("rate","NULRATE",userId);
								break;
							}
							else
							{
								try
								{
									//String quantity = checkNull(genericUtility.getColumnValue("quantity", dom, ""+currentFormNo));
									String quantity = checkNullNum(genericUtility.getColumnValueFromNode("rate", currDetail));
									//System.out.println("quantity inside:- "+quantity);
									int quan = Integer.parseInt(quantity);
									//System.out.println("quanquan :::::"+quan);
									if( quan < 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("rate","INVLIDRATE",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
									//	sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									//	errString = itmDBAccessLocal.getErrorString("rate","INVLDRATE",userId);
								}
							}
						}
						// added by rupali on 10/09/17 for applying validation on rate field [end]
						// added by rupali on 30/10/17 for applying validation on stock and lot_no in order form [start]
						else if ( "stock_qty".equalsIgnoreCase( childNodeName ) && "Y".equalsIgnoreCase(isStockInfo) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("dhdjkhsd stok quan");
								String quantity = genericUtility.getColumnValueFromNode("quantity", currDetail);
								//System.out.println("quantity stok quan["+quantity+"]");

								if(quantity!=null && quantity.trim().length()>0) 
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("stock_qty","NULLSTOCK",userId);
									break;
								}
								
							}
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									String quantity = checkNullNum(genericUtility.getColumnValueFromNode("stock_qty", currDetail));
									int quan = Integer.parseInt(quantity);
									if( quan < 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("stock_qty","INVLDSTOCK",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("stock_qty","INVLDSTOCK",userId);
								}
							}
						}
						else if ( "lot_no".equalsIgnoreCase( childNodeName ) && "Y".equalsIgnoreCase(isStockInfo))
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								/*errString = itmDBAccessLocal.getErrorString("lot_no","NULLOTNUM",userId);
								break;*/
							}
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								String lotNumber = genericUtility.getColumnValueFromNode("lot_no", currDetail);
								String itemCode = genericUtility.getColumnValueFromNode("item_code", currDetail);
								int count = 0;
								String codeSql = "";
								//System.out.println("itemCode =["+itemCode+"], lotNumber = ["+lotNumber+"]");
								codeSql = "SELECT COUNT(*) AS COUNT FROM ITEM_LOT_INFO WHERE LOT_NO = ? AND ITEM_CODE = ?";
								pstmt = connectionObject.prepareStatement(codeSql);
								pstmt.setString(1,lotNumber);
								pstmt.setString(2,itemCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									//System.out.println("INVALID lot_no::");
									errString = itmDBAccessLocal.getErrorString("lot_no","INVLOTNUM",userId);
									break;
								}
							}
						}
						// added by rupali on 30/10/17 for applying validation on stock and lot_no in order form [end]
						// added by rupali on 27/12/17 for applying validation on stock_info field in order form [start]
						else if ( "stock_info".equalsIgnoreCase( childNodeName ) && "Y".equalsIgnoreCase(isStockInfo))
						{
							String stockInfo = "";
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								stockInfo = genericUtility.getColumnValueFromNode("stock_info", currDetail);
								String itemCode = genericUtility.getColumnValueFromNode("item_code", currDetail);
								//System.out.println("itemCode =["+itemCode+"], stockInfo = ["+stockInfo+"]");
								//	if("{\"name\":\"stock_info|stock|expiry_date\", \"disp_name\":\"Batch No.|Stock|Expiry\", \"type\":\"text|number|text\", \"protect\":\"0|0|1\", \"1\":\"||\"}".equals(stockInfo))
								if("{\"name\": \"stock|stock_info|expiry_date\", \"disp_name\": \"Pend Stk.|Batch No.|Expiry\", \"type\": \"number|text|text\", \"protect\": \"0|0|1\", \"1\": \"||\" }".equals(stockInfo))
								{
									errString = itmDBAccessLocal.getErrorString("stock_info","BLNKSTKINF",userId);
									break;
								}
								else
								{
									JSONObject jsonData = new JSONObject(stockInfo);
									Iterator<String> jsonKeys = jsonData.keys();
									String jsonKey = "";
									int totalStock = 0;
									// added by rupali on 24/01/17 for validating wrong batch code [start]
									ArrayList nameList = new ArrayList();
									while (jsonKeys.hasNext())
									{
										jsonKey = jsonKeys.next();
										if("name".equals(jsonKey))
										{
											String jsonValue = jsonData.getString(jsonKey);
											String [] temp = jsonValue.split("\\|");
											for(int i = 0 ;i < temp.length;i++)
											{
												nameList.add(temp[i]);
											}
										}
									}
									//System.out.println("nameList:::::"+nameList);
									int position = nameList.indexOf("stock_info");
									Iterator<String> jsonKeysNew = jsonData.keys();
									// added by rupali on 24/01/17 for validating wrong batch code [end]
									while (jsonKeysNew.hasNext())
									{
										jsonKey = jsonKeysNew.next();

										if(!("name".equals(jsonKey) ||"disp_name".equals(jsonKey) || "type".equals(jsonKey) || "protect".equals(jsonKey)))
										{
											// commented and added by rupali on 24/01/17 for validating wrong batch code [start]
											/*int count = 0;
											String jsonValue = jsonData.getString(jsonKey);
											String batchCode = jsonValue.substring(0,jsonValue.indexOf("|"));*/

											int count = 0;
											String batchCode = "";
											ArrayList valueList = new ArrayList();
											String jsonValue = jsonData.getString(jsonKey);
											String [] temp = jsonValue.split("\\|");
											for(int i = 0 ;i < temp.length;i++)
											{
												valueList.add(temp[i]);
											}
											//System.out.println("valueList:::::"+valueList);
											if(valueList.size() - 1 >= position)
											{
												batchCode = (String)valueList.get(position);
											}
											//System.out.println("batchCode is:::::"+batchCode);
											// commented and added by rupali on 24/01/17 for validating wrong batch code [end]
											if(batchCode.trim().length() == 0)
											{
												//System.out.println("Blank lot_no::");
												errString = itmDBAccessLocal.getErrorString("lot_no","BLNKLOTNUM",userId);
												break;
											}
											else
											{
												String codeSql = "SELECT COUNT(*) AS COUNT FROM ITEM_LOT_INFO WHERE LOT_NO = ? AND ITEM_CODE = ?";
												pstmt = connectionObject.prepareStatement(codeSql);
												pstmt.setString(1,batchCode);
												pstmt.setString(2,itemCode);
												rs = pstmt.executeQuery();
												if(rs.next())
												{
													count = rs.getInt("COUNT");
												}
												if (rs != null)
												{
													rs.close();
													rs = null;
												}
												if (pstmt != null)
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													//System.out.println("INVALID lot_no::");
													errString = itmDBAccessLocal.getErrorString("lot_no","INVLOTNUM",userId);
													break;
												}
											}
										}
									}
								}
							}
						}
						// added by rupali on 27/12/17 for applying validation on stock_info field in order form [end]
						// added by Niraj on 10/12/17 for applying validation on promo_code field [start]
						else if(childNodeName.equalsIgnoreCase("promo_code"))
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								String promoCode = checkNull(genericUtility.getColumnValueFromNode("promo_code", currDetail));
								String itemCode = checkNull(genericUtility.getColumnValueFromNode("item_code", currDetail));
								String scCode = checkNull(genericUtility.getColumnValueFromNode("strg_code", currDetail));
								String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2));
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								//System.out.println("eventDate:::"+eventDate);
								String promocodeSql = "";
								int cnt = 0;

								// commentted and added by rupali on 08/02/19 for getting proper data for validation [start]
								/*promocodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER SC, STATE S ,ITEM ITEM LEFT OUTER JOIN PRICELIST " +
										"PM ON ITEM.ITEM_CODE = PM.ITEM_CODE LEFT OUTER JOIN SCHEME_APPLICABILITY SA ON (ITEM.ITEM_CODE = SA.ITEM_CODE OR SA.PROD_SCH='Y'), " +
										"BOM B, SCHEME_APPLICABILITY_DET SAD WHERE SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST " +
										"AND SA.SCHEME_CODE = B.BOM_CODE AND SA.SCHEME_CODE = SAD.SCHEME_CODE AND SA.APP_FROM<= ? AND SA.VALID_UPTO>= ? " +
										"AND SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST AND (SAD.SITE_CODE= ? OR SAD.STATE_CODE= S.STATE_CODE " +
										"OR SAD.COUNT_CODE = S.COUNT_CODE) AND SC.SC_CODE= ? AND ITEM.ITEM_CODE = ? AND SA.SCHEME_CODE = ? ";*/
								
								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom2, "1" );
								promocodeSql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS SP, STATE S ,ITEM ITEM "+
										"LEFT OUTER JOIN SCHEME_APPLICABILITY SA ON (ITEM.ITEM_CODE = SA.ITEM_CODE OR SA.PROD_SCH = 'Y'), "+
										"BOM B, SCHEME_APPLICABILITY_DET SAD WHERE SP.STATE_CODE = S.STATE_CODE "+
										"AND SA.SCHEME_CODE = B.BOM_CODE AND SA.SCHEME_CODE = SAD.SCHEME_CODE "+
										"AND SA.APP_FROM <= ? AND SA.VALID_UPTO >= ? "+
										"AND (SAD.SITE_CODE= ? OR SAD.STATE_CODE= S.STATE_CODE "+
										"OR SAD.COUNT_CODE = S.COUNT_CODE) AND SP.SALES_PERS = ? "+
										"AND SP.ITEM_SER = ITEM.ITEM_SER AND ITEM.ITEM_CODE = ? AND SA.SCHEME_CODE  = ? ";
								//commentted and added by rupali on 08/02/19 for getting proper data for validation [end]
								
								pstmt = connectionObject.prepareStatement(promocodeSql);
								pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								pstmt.setString(3, siteCode);
								//pstmt.setString(4, scCode);
								pstmt.setString(4, salesPers);
								pstmt.setString(5, itemCode);
								pstmt.setString(6, promoCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("COUNT");
								}
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(cnt == 0)
								{
									//System.out.println( "scheme not available for this item" );
									errString = itmDBAccessLocal.getErrorString( "promo_code" , "SCHMNOTAVL" , userId );
									break;
								}
							}
						}
						// added by Niraj on 10/12/17 for applying validation on promo_code field [end]
						// added by mrunalini sinkar for dicount and promo_perc validation(start)
						else if ( "disc_perc".equalsIgnoreCase( childNodeName ) )
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									String quantity = checkNullNum(genericUtility.getColumnValueFromNode("disc_perc", currDetail));
									double quan = Double.parseDouble(quantity);
									System.out.println("disc_perc :::::"+quan);
									if( quan > 100 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("disc_perc","INVALDDISC",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
									//	sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									//	errString = itmDBAccessLocal.getErrorString("rate","INVLDRATE",userId);
								}
							}
						}
						else if ( "promo_perc".equalsIgnoreCase( childNodeName ) )
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									String quantity = checkNullNum(genericUtility.getColumnValueFromNode("promo_perc", currDetail));
									double quan = Double.parseDouble(quantity);
									System.out.println("promo_perc :::::"+quan);
									if( quan > 100 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("promo_perc","INVALSCHEM",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
									//	sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									//	errString = itmDBAccessLocal.getErrorString("rate","INVLDRATE",userId);
								}
							}
						}
						// added by mrunalini sinkar for dicount and promo_perc validation(end)
						//added by Bhagyashri T on [21/08/21][start] for focus_devi_reas validation
						
						else if ( "focus_devi_reas".equalsIgnoreCase( childNodeName ) )
						{
							//System.out.println("Focus Dev reason Field Before");
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								System.out.println("Focus Dev reason inside is null");
							}
							else
							{
								//System.out.println("Focus Dev reason Field after");
								String focusDeviRes = genericUtility.getColumnValueFromNode("focus_devi_reas", currDetail);
								String remarksRes = genericUtility.getColumnValueFromNode("remarks_ord", currDetail);
								//System.out.println("focusDeviRes inside:- "+focusDeviRes);
								//System.out.println("remarksRes inside:- "+remarksRes);
								if(("6".equalsIgnoreCase(focusDeviRes)) && (remarksRes==null || remarksRes.trim().length()==0))
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("focus_devi_reas","FOCRESMAN",userId);
									break;
								}
							}
						}
						//added by Bhagyashri T on [21/08/21][end] for focus_devi_reas validation
						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{
							updateFlagCnt++;
						}
					}

					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				if(errString != null && errString.trim().length() > 0)
				{
					//System.out.println("sampleDescr =["+sampleDescr+"]");
					errString = getModifiedErrorString(errString, sampleDescr);
				}
			}
			//added by mrunalini sinkar for quantity validation in order and sample item subform on 16-june-2017(end)
			// added by rupali on 12/09/18 for adding survey subform in DAR [start]
			else if("survey".equalsIgnoreCase(formName) || "retailersurvey".equalsIgnoreCase(formName) || "stockistsurvey".equalsIgnoreCase(formName) || "ncwsurvey".equalsIgnoreCase(formName))
			{
				// added by rupali on 16/07/19 to validate survey question [start]
				String surveyDescr = "", surveyCode = "";
				ArrayList surveyList = new ArrayList();
				ArrayList custTypeList = new ArrayList();
				
				String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom2));
				String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2));
				strgType = checkNull(genericUtility.getColumnValue("strg_type", dom2));
				String surveyTemplate=checkNull(genericUtility.getColumnValue("survey_templ", dom2));
				//Added by Pooja S on  [18-FEB-2020] to set the activity template in case of MI 
				String activityTempl=checkNull(genericUtility.getColumnValue("activity_templ", dom2));
				// added by rupali on 16/07/19 to validate survey question [end]
				
				//System.out.println("survey : validation ::");
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectBox = "";
					String updateFlag = "";
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds["+noOfChilds+"]");
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						if(childNodeName.equalsIgnoreCase("strg_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
									( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								errString = itmDBAccessLocal.getErrorString( "strg_code" , "NULSTRGCD" , userId );
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("survey_code"))
						{
							//System.out.println("inside survey_code:::::"+childNodeName);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("inside survey_code if loop:::::"+childNodeName);
								errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVCD",userId);
								break;
							}
							// added by rupali on 16/07/19 to validate survey question [start]
							else
							{
								surveyCode = checkNull(genericUtility.getColumnValueFromNode("survey_code", parentNode));
								surveyDescr = checkNull(genericUtility.getColumnValueFromNode("strgType", parentNode));
								surveyList.add(surveyCode);
							}
							// added by rupali on 16/07/19 to validate survey question [end]
						}
						else if(childNodeName.equalsIgnoreCase("result1") || childNodeName.equalsIgnoreCase("result2") || childNodeName.equalsIgnoreCase("result3"))
						{
							//System.out.println("inside survey_code:::::"+childNodeName);
							String resultType = genericUtility.getColumnValueFromNode("result_type", parentNode);
							//System.out.println("inside survey_code resultType is:::::"+resultType);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if((childNodeName.equalsIgnoreCase("result1") && (resultType.equalsIgnoreCase("N"))) || (childNodeName.equalsIgnoreCase("result3") && (resultType.equalsIgnoreCase("T")))
										|| (childNodeName.equalsIgnoreCase("result2") && (resultType.equalsIgnoreCase("D") || resultType.equalsIgnoreCase("L"))))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULSURVRES",userId);
									break;
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("doc_id_2"))
						{
							System.out.println("inside DOC_ID__2:::::"+childNodeName);
							String attachOPT = checkNull(genericUtility.getColumnValueFromNode("attach_opt", parentNode));
							System.out.println("inside DOC_ID__2 attachOPT:::::"+attachOPT);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								System.out.println("inside DOC_ID__2 if loop:::::");
								if("1".equalsIgnoreCase(attachOPT))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","NULLATTACH",userId);
									break;
									
								}
							}
						}
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				// added by rupali on 16/07/19 to validate survey question [start]
				if(errString == null ||  errString.trim().length() == 0)
				{
					System.out.println("strgType:::"+strgType+" surveyList:::"+surveyList+"surveyTemplate IS["+surveyTemplate+"] eventType ["+ eventType +"]");
					custTypeList=getTemplateSurvey(connectionObject, userId);
					System.out.println("custTypeList is:["+custTypeList+"]");
					if(custTypeList.contains(strgType)  && parentNodeListLength > 0)
					{
							String surveySql = "SELECT B.SURVEY_CODE SURVEY_CODE, C.DESCR SURVEY_DESCR,C.MANDATORY FROM SURVEY_TEMPLATE A, SURVEY_TEMPL_DET B, SURVEY_MASTER C, SURVEY_GROUP G " + 
							           "WHERE A.SURVEY_TEMPL = B.SURVEY_TEMPL AND C.SURVEY_GROUP = G.SURVEY_GROUP AND A.SURVEY_TEMPL IN(SELECT SURVEY_TEMPL FROM SURVEY_TEMPLATE " + 
							           "WHERE SURVEY_TEMPL = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO AND CONFIRMED ='Y') AND B.SURVEY_CODE = C.SURVEY_CODE " + 
							           "AND C.ACTIVE='Y' AND C.MANDATORY = 'Y'";
							PreparedStatement pstmtSurvey =  connectionObject.prepareStatement(surveySql);
							//Added by Pooja S on  [18-FEB-2020] to set the activity template in case of MI Start
							if( eventType.equalsIgnoreCase("MI")  || eventType.equalsIgnoreCase("OT"))
							{
								pstmtSurvey.setString(1,activityTempl);
							}
							else
							{
							pstmtSurvey.setString(1,surveyTemplate);
							}
							//Added by Pooja S on  [18-FEB-2020] to set the activity template in case of MI Start End
							pstmtSurvey.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
							ResultSet rsSurvey = pstmtSurvey.executeQuery();
							while (rsSurvey.next())
							{
								surveyCode = checkNull(rsSurvey.getString("SURVEY_CODE"));
								surveyDescr = checkNull(rsSurvey.getString("SURVEY_DESCR"));
								if(!surveyList.contains(surveyCode))
								{
									errString = itmDBAccessLocal.getErrorString("survey_code","SURVENTSEL",userId);
									break;
								}
							}
							//Added by Hariom for Dirty Connection close -- 09-Mar-2021 [Start]
							if (rsSurvey != null)
							{
								rsSurvey.close();
								rsSurvey = null;
							}
							if (pstmtSurvey != null)
							{
								pstmtSurvey.close();
								pstmtSurvey = null;
							}
							//Added by Hariom for Dirty Connection close -- 09-Mar-2021 [End]
							if(errString != null && errString.trim().length() > 0)
							{
								System.out.println("surveyDescr =["+surveyDescr+"]");
								errString = getModifiedErrorString(errString, surveyDescr);
							}
						}
						// added by rupali on 16/07/19 to validate survey question [end]
				}
			}
			// added by rupali on 12/09/18 for adding survey subform in DAR [end]
			//added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(start)
			else if("display".equalsIgnoreCase(formName) || "retailerdisplay".equalsIgnoreCase(formName) || "stockistdisplay".equalsIgnoreCase(formName) || "ncwdisplay".equalsIgnoreCase(formName))
			{
				parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeLength = parentList.getLength();
				for (int prntCtr = 0; prntCtr < parentNodeLength; prntCtr++ )
				{
					String selectBox = "";
					String updateFlag = "";
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctrs = 0; ctrs < noOfChilds; ctrs++)
					{
						childNode = childList.item(ctrs);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						//Changed by Niraj s on 14-Dec-2018 for validation to change Item_code to brand_code in display form(start)
						if(childNodeName.equalsIgnoreCase("brand_code"))
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								int count = 0;
								String brandCode[]=columnValue.split(",");
								System.out.println("columnValue::::::["+columnValue+"]");
								for(int i = 0 ;i < brandCode.length;i++)
								{
									String brands = checkNull(brandCode[i]);
									System.out.println("brandCode::::::["+brands+"]");
									String itmSql="SELECT COUNT(*) AS COUNT FROM BRAND WHERE BRAND_CODE=?";
									PreparedStatement itmPstmt= connectionObject.prepareStatement(itmSql);
									itmPstmt.setString(1, brands);
									ResultSet itmRs = itmPstmt.executeQuery();
									if(itmRs.next())
									{
										count = itmRs.getInt("COUNT");
									}
									if (itmRs != null)
									{
										itmRs.close();
										itmRs = null;
									}
									if (itmPstmt != null)
									{
										itmPstmt.close();
										itmPstmt = null;
									}
									if(count == 0)
									{
										errString = itmDBAccessLocal.getErrorString("brand_code","INVBRNCD",userId);
										break;
									}
								}
								

							}


						}
						//Changed by Niraj s on 14-Dec-2018 for validation to change Item_code to brand_code in display form(end)
					}
				}
			}
			//added by mrunalini sinkar on 30-nov-2018 for disp_type changes adding the disp_type,item_code,quantity in query(end)
			//Added by Bhgyashri t For checking valdation for Lifescan on team form start[09/03/2022][start][W21KJOH015]
			else if("team".equalsIgnoreCase(formName) || "retailerteam".equalsIgnoreCase(formName) || "ncwteam".equalsIgnoreCase(formName) || "stockistteam".equalsIgnoreCase(formName))
			{
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;
				//System.out.println("Inside team validation ::");
				ArrayList<String> memberCodeList=new ArrayList<String>();
				
				//Changes made by Rahul P. on 26-Sep-2023 [Start] set ENTITY_TYPE='R'
				/*String memCodesql ="SELECT ENTITY_TYPE AS MEMBER_TYPE,ENTITY_CODE AS STRG_CODE,CONTACT_PERS AS MEM_CODE,CONTACT_PERS_NAME AS MEMEBR_NAME,MOBILE_NO AS MOBILE_NO FROM ENTITY_CONTACT WHERE ENTITY_TYPE ='C' " + 
						"UNION " + 
						"SELECT ENTITY_TYPE AS MEMBER_TYPE,ENTITY_CODE AS STRG_CODE,CONTACT_PERS AS MEM_CODE,CONTACT_PERS_NAME AS MEMEBR_NAME,MOBILE_NO AS MOBILE_NO  FROM ENTITY_CONTACT WHERE ENTITY_TYPE='E' " + 
						"AND ENTITY_CODE = ?";*/
				String memCodesql ="SELECT ENTITY_TYPE AS MEMBER_TYPE,ENTITY_CODE AS STRG_CODE,CONTACT_PERS AS MEM_CODE,CONTACT_PERS_NAME AS MEMEBR_NAME,MOBILE_NO AS MOBILE_NO FROM ENTITY_CONTACT WHERE ENTITY_TYPE ='R' " + 
						"UNION " + 
						"SELECT ENTITY_TYPE AS MEMBER_TYPE,ENTITY_CODE AS STRG_CODE,CONTACT_PERS AS MEM_CODE,CONTACT_PERS_NAME AS MEMEBR_NAME,MOBILE_NO AS MOBILE_NO  FROM ENTITY_CONTACT WHERE ENTITY_TYPE='E' " + 
						"AND ENTITY_CODE = ?";
				//Changes made by Rahul P. on 26-Sep-2023 [End]
				pstmt = connectionObject.prepareStatement(memCodesql);
				pstmt.setString(1, userId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String memtype = checkNull(rs.getString("MEMBER_TYPE")).trim();
					String strgCd = checkNull(rs.getString("STRG_CODE")).trim();
					String memCode = checkNull(rs.getString("MEM_CODE")).trim();
					String memName = checkNull(rs.getString("MEMEBR_NAME")).trim();
					String mobileNo = checkNull(rs.getString("MOBILE_NO")).trim();
					String memcodeTyp = memtype+"@"+strgCd+"@"+memCode;
					//String memcodeTyp = memtype.trim() +"@"+strgCode.trim() +"@"+memCode.trim() +"@"+memName.trim() +"@"+mobileNo.trim();
					memberCodeList.add(memcodeTyp);

				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("Member code details list is:["+memberCodeList+"]");
				ArrayList membercodeArray = new ArrayList();
				//System.out.println("Inside team membercodeArray::"+membercodeArray);
				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				//System.out.println("parentNodeListLength in team ["+parentNodeListLength+"]");
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{

					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					//System.out.println("noOfChilds team["+noOfChilds+"]");
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeName in team =["+childNodeName+"]");
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
								{
									break;
								}
							}
						}
						else if ( "mem_code".equalsIgnoreCase( childNodeName ) )
						{
							//System.out.println("Inside mem code validation");
							String memberType = genericUtility.getColumnValueFromNode("member_type", currDetail).trim();
							//System.out.println("Inside mem code validation memberType:"+memberType);
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("Memeber_Code inside is null");
								if(memberType.equalsIgnoreCase("C") ||memberType.equalsIgnoreCase("E"))
								{
									errString = itmDBAccessLocal.getErrorString("mem_code","NULMEMCD",userId);
									break;
								}
								
							}
							else
							{
								if(memberType.equalsIgnoreCase("C") ||memberType.equalsIgnoreCase("E"))
								{
									//System.out.println("Inside MEMBERTYPE C OR E");
									String memberCode = checkNull(genericUtility.getColumnValueFromNode("mem_code", currDetail)).trim();
									String scCode = checkNull(genericUtility.getColumnValueFromNode("strg_code", currDetail)).trim();
									//System.out.println("Inside mem code validation in memberCode:["+memberCode+"]");
									//System.out.println("Inside mem code validation in scCode:["+scCode+"]");
									//System.out.println("Inside mem code validation in userId:["+userId+"]");
									String newMember ="";
									if(memberType.equalsIgnoreCase("C"))
									{
										//System.out.println("Inside mem code validation in else C TYPE:"+memberType);
										newMember = memberType+"@"+scCode+"@"+memberCode;
									}
									else if(memberType.equalsIgnoreCase("E"))
									{
										//System.out.println("Inside mem code validation in else E TYPE:"+memberType);
										newMember = memberType+"@"+userId.trim()+"@"+memberCode;
									}
									//System.out.println("Inside mem code validation in else data for valdation:"+newMember);
									if(!memberCodeList.contains(newMember) )
									{
										//System.out.println("Invalid member Code");
										errString = itmDBAccessLocal.getErrorString("mem_code","INVMEMCD",userId);
										break;
									}
									if(membercodeArray == null || !membercodeArray.contains(memberCode))
									{
										membercodeArray.add(memberCode);
									}
									else
									{
										//System.out.println("Duplicate member Code");
										errString = itmDBAccessLocal.getErrorString("mem_code","DUPLMEMCD",userId);
										break;
									}
									//System.out.println("membercodeArray member Code after add::"+membercodeArray);
									
								}//end C and E
									
							}//end else
						}//end team
						else if ( "member_name".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("Memeber_name inside is null");
								String memType = checkNull(genericUtility.getColumnValueFromNode("member_type", currDetail)).trim();
								if(memType.equalsIgnoreCase("R") ||memType.equalsIgnoreCase("O"))
								{
									errString = itmDBAccessLocal.getErrorString("member_name","NULMNAME",userId);
									break;
								}
								
							}
						}
						else if( "team_mobile_no".equalsIgnoreCase( childNodeName ) )
						{
							if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								String mobileNo = checkNull(genericUtility.getColumnValueFromNode("team_mobile_no", currDetail)).trim();
								//System.out.println("mobileNo PHONE no.....::["+mobileNo+"]");
								if(mobileNo.length() < 10 || mobileNo.length() > 15)
								{
									errString = itmDBAccessLocal.getErrorString("team_mobile_no","INVMOBLNO",userId);
									break;
								}
							}
						}
						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{
							updateFlagCnt++;
						}
					}
					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				
				}
			}
			//Added by Bhgyashri t For checking valdation for Lifecsna on team form start[09/03/2022][end][W21KJOH015]
			//Added  by Bhagyashri for Invoice subform[START]
			else if("invoice".equalsIgnoreCase(formName))
			{
				int selectedFlagCnt = 0;
				int updateFlagCnt = 0;

				String sampleDescr = "";

				parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				parentNodeListLength = parentList.getLength();
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";
					sampleDescr = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
								{
									System.out.println("INSIDE THE FLAG");
									break;
								}
							}
						}
						else if ( "quantity".equalsIgnoreCase( childNodeName ) )
						{
							String isBroken = checkNull(genericUtility.getColumnValueFromNode("is_broken", currDetail));
							System.out.println("isBroken =["+isBroken+"]");
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								if(!"Y".equalsIgnoreCase(isBroken))
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
									break;
								}
							}
							else
							{
								try
								{
									String quantity = checkNullNum(genericUtility.getColumnValueFromNode("quantity", currDetail));
									
									int quan = Integer.parseInt(quantity);
									if( quan <= 0 && !"Y".equalsIgnoreCase(isBroken))
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									//System.out.println("NumberFormatException occours for ");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("quantity","INVLDQUAN",userId);
								}
							}
						}
						// added by rupali on 10/09/17 for applying validation on rate field [start]
						else if ( "rate".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("quantity inside is null");
								sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
								errString = itmDBAccessLocal.getErrorString("rate","NULRATE",userId);
								break;
							}
							else
							{
								try
								{
									//String quantity = checkNull(genericUtility.getColumnValue("quantity", dom, ""+currentFormNo));
									String rate = checkNullNum(genericUtility.getColumnValueFromNode("rate", currDetail));
									//System.out.println("quantity inside:- "+quantity);
									int rateS = Integer.parseInt(rate);
									//System.out.println("quanquan :::::"+quan);
									if( rateS <= 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("rate","INVLIDRATE",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for ");
								}
							}
						}
						else if ( "curr_stock".equalsIgnoreCase( childNodeName ) )
						{
							if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
							{
								//System.out.println("dhdjkhsd stok quan");
								String currStock = genericUtility.getColumnValueFromNode("curr_stock", currDetail);
								//System.out.println("quantity stok quan["+quantity+"]");

								if(currStock == null && currStock.trim().length()<=0) 
								{
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("curr_stock","NULLSTOCK",userId);
									break;
								}
								
							}
							else if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()) && childNode.getFirstChild().getNodeValue().trim().length() > 0)
							{
								try
								{
									System.out.println("Inside Stock of Invoice val");
									String currStock = checkNullNum(genericUtility.getColumnValueFromNode("curr_stock", currDetail));
									String orgStock = checkNullNum(genericUtility.getColumnValueFromNode("org_stock", currDetail));
									String quantity = checkNullNum(genericUtility.getColumnValueFromNode("quantity", currDetail));
									String itemCode = checkNull(genericUtility.getColumnValueFromNode("item_code", currDetail));
									int stock = Integer.parseInt(orgStock);
									int quan = Integer.parseInt(quantity);
									System.out.println("validation 13dec23 itemCode=["+itemCode+"], currStock=["+currStock+"],orgStock=["+orgStock+"], quantity=["+quantity+"]");
									//System.out.println("Inside Stock quan::"+quan);
									if( stock < 0 )
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("curr_stock","INVLDSTOCK",userId);
										break;
									}
									else if(quan > stock)
									{
										sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
										errString = itmDBAccessLocal.getErrorString("curr_stock","LARGEQUAN ",userId);
										break;
									}
								}
								catch(NumberFormatException num)
								{
									System.out.println("NumberFormatException occours for stock");
									sampleDescr = genericUtility.getColumnValueFromNode("item_descr", currDetail);
									errString = itmDBAccessLocal.getErrorString("curr_stock","INVLDSTOCK",userId);
								}
							}
						}
						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{
							updateFlagCnt++;
						}
					}

					if(errString != null && errString.trim().length() > 0)
					{
						break;
					}
				}
				if(errString != null && errString.trim().length() > 0)
				{
					errString = getModifiedErrorString(errString, sampleDescr);
				}
			}
			//Added by Bhagyashri for Invoicesubform[END]
			//added by prachi [W22FBAS009]
			else if("collection".equalsIgnoreCase(formName))
			{
				System.out.println("Collection form Validation");
                
                errString = darCommonBean.collectionValidate(dom, currentFormNo, xtraParams, connectionObject);
            }//end[W22FBAS009] 
			
		}//try end
		catch (Exception e)
		{
			System.out.println ( "Exception: real time reoprt: wfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
				if (rsActivity!= null)
				{
					rsActivity.close();
					rsActivity = null;
				}
				if(pstmtActivity!=null)
				{
					pstmtActivity.close();
					pstmtActivity = null;
				}
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :real Time report : wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);

	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :RealTimeReportEJB :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		//System.out.println ( "returning from RealTimeReportEJB itemChanged" );
		return errString;
	}
	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		//System.out.println ( "In side itemChanged:::::::::" );
		ResultSet rs = null;
		PreparedStatement pstmt = null,pStmt1=null, pstmt2 = null;
		ResultSet itemRs = null,rs1=null,rs2=null;
		String sql = "";
		String columnValue = "";
		String userId = "";
		Statement stmt = null;
		int currentFormNo = 0;
		String itemSer ="",custType="",sql1 ="";
		String errString = "",itemCode="",salesPers="";
		String eventDate="",strgType="",strgCode="", strgName="";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		String windowName = "w_"+getObjName(dom,objContext);
		//System.out.println("Window Name Got :::["+windowName+"]");
		String clientName="",phoneNo="",address="",emailId="",visitTimeFr="",visitTimeTo="",localitySql="",localityDescr="",dcrDate="";
		//System.out.println("editFlag::::["+editFlag+"]");
		String pitchDetail ="";
		String pitchDescr ="";
		String empcode ="";
		//GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//			ConnDriver connDriver = new ConnDriver();
			//			connectionObject = connDriver.getConnectDB( "DriverValidator" );
			connectionObject = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			userId = getEmpCode(userId, connectionObject);
			empcode = userId;
			/*
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("userId>>::"+userId+"empcode>>::"+empcode);
			if( empcode == null || (empcode != null  && empcode.length() == 0))
			{
				empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			}
			 */
			columnValue = genericUtility.getColumnValue( currentColumn, dom );
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			//valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n</Header>\r\n" );
			//System.out.println("currentFormNo=========================["+currentFormNo+"]");
			String tranId ="";
			String prdCode ="";
			String winName = "w_real_time_report";
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");

			switch ( currentFormNo )
			{
			case 1:
			{
				valueXmlString.append( "<Detail1 domID='1' >\r\n" );
				//System.out.println( "columnValue [" + currentColumn + "]" );
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{
					//System.out.println("xmlString :::: ["+dom+"]");
					//TODO
					//tranId = generateTranID(connectionObject, xmlString, xtraParams, winName);
					valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append(currDate).append( "]]></event_date>\r\n" );
					valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<client_name protect = '1'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
					valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
					valueXmlString.append( "<email_addr protect = '1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
					valueXmlString.append( "<mobile_no protect = '1'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
					valueXmlString.append( "<unlist_locality protect = '1'><![CDATA[" ).append("").append( "]]></unlist_locality>\r\n" );
					valueXmlString.append( "<locality_descr ><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
					//System.out.println("itemdefault called....");
				}
				/*else if(currentColumn.trim().equalsIgnoreCase("event_date"))
					{
						System.out.println("inside else if...event_date.");
						eventDate = checkNull(genericUtility.getColumnValue("event_date", dom));
						System.out.println("event_date....case1::: "+eventDate);
						valueXmlString.append( "<event_date><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );
					}*/
				else if( currentColumn.equalsIgnoreCase( "itm_defaultedit" ))
				{
					//strgCode = genericUtility.getColumnValue( "strg_code", dom );
					//System.out.println("itm_defaultedit called...."+strgCode);
					dcrDate = genericUtility.getColumnValue( "event_date", dom );
					eventDate=dcrDate;
					if("E".equalsIgnoreCase(editFlag) )
					{
						//strgCode = genericUtility.getColumnValue( "strg_code", dom );
						// strgName = genericUtility.getColumnValue( "strg_name", dom );
						tranId = genericUtility.getColumnValue( "tran_id", dom );

						sql1 = "SELECT STRG_CODE ,STRG_NAME ,STRG_TYPE FROM STRG_MEET WHERE TRAN_ID = ? ";
						pstmt2 = connectionObject.prepareStatement(sql1);
						pstmt2.setString(1,tranId);
						rs2 = pstmt2.executeQuery();
						//System.out.println( " sql sss sql1[" + sql1	 + "]" );
						if(rs2.next())
						{
							strgCode =rs2.getString("STRG_CODE");
							strgName =rs2.getString("STRG_NAME");
							strgType =rs2.getString("STRG_TYPE");
						}
						//System.out.println("itm_defaultedit called...."+strgCode);
						//System.out.println("strgName called...."+strgName);
						rs2 = ( rs2!=null )? null : rs2;
						pstmt2 = ( pstmt2!=null )? null : pstmt2;

						if((strgCode == null || strgCode.trim().length() == 0 || strgCode =="null") && (strgName == null || strgName.trim().length() == 0 || strgName =="null") )
						{
							//System.out.println("inside else if.codef...editFlag"+editFlag);
							salesPers = genericUtility.getColumnValue( "sales_pers", dom );
							strgType = genericUtility.getColumnValue( "strg_type", dom );
							String scCode = genericUtility.getColumnValue( "sc_code", dom );
							//System.out.println( " dcrDate dcrDate [" + dcrDate + "]" );
							//System.out.println( " eventDate dcrDate [" + eventDate + "]" );
							String locality = checkNull(genericUtility.getColumnValue("unlist_locality", dom));

							sql = " select * from dr_unlist_visit WHERE sales_pers = ? AND work_date = ? and sc_code = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1,salesPers);
							pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
							pstmt.setString(3,scCode);
							rs = pstmt.executeQuery();
							//System.out.println( " sql sss [" + sql + "]" );
							if(rs.next())
							{
								custType=checkNull(rs.getString("cust_type").trim());
								salesPers=checkNull(rs.getString("sales_pers").trim());
								//eventDate=checkNull(rs.getString("work_date").trim());
								clientName=checkNull(rs.getString("client_name").trim());
								phoneNo=checkNull(rs.getString("mobile_no").trim());
								address=checkNull(rs.getString("address").trim());
								emailId=checkNull(rs.getString("email_addr").trim());
								visitTimeFr=checkNull(rs.getString("visit_time_fr").trim());
								visitTimeTo=checkNull(rs.getString("visit_time_to").trim());
								locality=checkNull(rs.getString("locality_code").trim());

								localitySql ="SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
								//System.out.println( " sql sss locality[" + localitySql + "]" );
								pStmt1 = connectionObject.prepareStatement(localitySql);
								pStmt1.setString(1, locality);
								rs1 = pStmt1.executeQuery();
								if(rs1.next())
								{
									localityDescr=checkNull(rs1.getString("DESCR").trim());
								}
								rs1 = ( rs1!=null )? null : rs1;
								pStmt1 = ( pStmt1!=null )? null : pStmt1;


								if("L".equalsIgnoreCase(custType))
								{
									valueXmlString.append( "<cust_type  protect = '1'><![CDATA[" ).append("U").append( "]]></cust_type>\r\n" );
								}
								else
								{
									valueXmlString.append( "<cust_type protect = '1' ><![CDATA[" ).append("V").append( "]]></cust_type>\r\n" );
								}

								valueXmlString.append( "<strg_code protect = '1' ><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
								valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
								valueXmlString.append( "<event_date protect = '1'><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );

								valueXmlString.append( "<client_name protect = '0'><![CDATA[" ).append(clientName).append( "]]></client_name>\r\n" );
								valueXmlString.append( "<unlist_locality protect = '0'><![CDATA[" ).append(locality).append( "]]></unlist_locality>\r\n" );
								valueXmlString.append( "<locality_descr ><![CDATA[" ).append(localityDescr).append( "]]></locality_descr>\r\n" );
								valueXmlString.append( "<mobile_no protect = '0'><![CDATA[" ).append(phoneNo).append( "]]></mobile_no>\r\n" );
								valueXmlString.append( "<email_addr protect = '0'><![CDATA[" ).append(emailId).append( "]]></email_addr>\r\n" );
								valueXmlString.append( "<address protect = '0'><![CDATA[" ).append(address).append( "]]></address>\r\n" );
							}
							else
							{
								valueXmlString.append( "<cust_type protect = '1' ><![CDATA[" ).append(strgType).append( "]]></cust_type>\r\n" );
								valueXmlString.append( "<client_name protect = '1'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
								valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
								valueXmlString.append( "<email_addr protect = '1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
								valueXmlString.append( "<mobile_no protect = '1'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
								valueXmlString.append( "<unlist_locality protect = '1'><![CDATA[" ).append("").append( "]]></unlist_locality>\r\n" );
								valueXmlString.append( "<locality_descr ><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
								valueXmlString.append( "<event_date protect = '1'><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );
							}
							rs = ( rs!=null )? null : rs;
							pstmt = ( pstmt!=null )? null : pstmt;
						}
						else
						{
							valueXmlString.append( "<cust_type protect = '1' ><![CDATA[" ).append(strgType).append( "]]></cust_type>\r\n" );
							valueXmlString.append( "<client_name protect = '1'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
							valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
							valueXmlString.append( "<email_addr protect = '1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
							valueXmlString.append( "<mobile_no protect = '1'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
							valueXmlString.append( "<unlist_locality protect = '1'><![CDATA[" ).append("").append( "]]></unlist_locality>\r\n" );
							valueXmlString.append( "<locality_descr ><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<event_date protect = '1'><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );

						}

					}
				}
				else if(currentColumn.trim().equalsIgnoreCase( "cust_type" ))
				{
					//System.out.println("inside else if...strg_type.");
					strgType = checkNull(genericUtility.getColumnValue("cust_type", dom));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom));
					//System.out.println("cust_type....case1::: "+strgType);
					if("L".equalsIgnoreCase(strgType))
					{
						//System.out.println("inside else if.LLL..strg_type.");
						valueXmlString.append( "<strg_code protect = '0' ><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<client_name protect = '1'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
						valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '1'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("L").append( "]]></strg_type>\r\n" );
						//valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("L").append( "]]></cust_type>\r\n" );
						valueXmlString.append( "<unlist_locality protect = '1'><![CDATA[" ).append("").append( "]]></unlist_locality>\r\n" );
						valueXmlString.append( "<locality_descr ><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append( "<strg_name ><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
					}
					if("F".equalsIgnoreCase(strgType))
					{
						//System.out.println("inside else if.fgLLL..strg_type.");
						valueXmlString.append( "<strg_code protect = '0' ><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );

						valueXmlString.append( "<client_name protect = '1'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
						valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '1'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("F").append( "]]></strg_type>\r\n" );
						//valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("F").append( "]]></cust_type>\r\n" );
						valueXmlString.append( "<unlist_locality protect = '1'><![CDATA[" ).append("").append( "]]></unlist_locality>\r\n" );
						valueXmlString.append( "<locality_descr ><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append( "<strg_name ><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
					}
					else if("U".equalsIgnoreCase(strgType))
					{
						//System.out.println("inside else if.ffgfffff..strg_type.");
						valueXmlString.append( "<strg_code protect = '1' ><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("L").append( "]]></strg_type>\r\n" );
						//valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("L").append( "]]></cust_type>\r\n" );
						valueXmlString.append( "<client_name protect = '0'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
						valueXmlString.append( "<address protect = '0'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<unlist_locality protect = '0'><![CDATA[" ).append("").append( "]]></unlist_locality>\r\n" );
						valueXmlString.append( "<locality_descr ><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );

					}
					else if("V".equalsIgnoreCase(strgType))
					{
						//System.out.println("inside else if.fdsfdsfffff..strg_type.");
						valueXmlString.append( "<strg_code protect = '1' ><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("F").append( "]]></strg_type>\r\n" );
						//valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("F").append( "]]></cust_type>\r\n" );
						valueXmlString.append( "<client_name protect = '0'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
						valueXmlString.append( "<address protect = '0'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<unlist_locality protect = '0'><![CDATA[" ).append("").append( "]]></unlist_locality>\r\n" );
						valueXmlString.append( "<locality_descr ><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );

					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("strg_code" ))
				{
					//System.out.println("inside else if.codef..strg_code.");
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom));
					sql = " SELECT FIRST_NAME || ' ' ||  LAST_NAME as STRG_NAME FROM STRG_CUSTOMER  WHERE SC_CODE= ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,strgCode);
					rs = pstmt.executeQuery();
					//System.out.println( " sql sss [" + sql + "]" );
					if(rs.next())
					{
						valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("STRG_NAME"))).append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_code protect = '0'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
				}
				else if(currentColumn.trim().equalsIgnoreCase("unlist_locality" ))
				{
					//System.out.println("inside else if.codef..locality.");
					String locality = checkNull(genericUtility.getColumnValue("unlist_locality", dom));
					sql = " SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,locality);
					rs = pstmt.executeQuery();
					//System.out.println( " sql sss [" + sql + "]" );
					if(rs.next())
					{
						valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></locality_descr>\r\n" );
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
				}
				valueXmlString.append( "</Detail1>\r\n" );
				//System.out.println("valueXmlString....."+valueXmlString);
				break;
			}//case 1 end

			case 2:
			{
				/*String lineNo = genericUtility.getColumnValue("line_no", dom);
					System.out.println("lineNo>>::"+lineNo);
					if(lineNo==null || lineNo.trim().length()==0)
					{
						lineNo="1";
					}
					int domId=Integer.parseInt(lineNo);*/
				NodeList detailNodeList = dom.getElementsByTagName("Detail2");
				Node detailNode = detailNodeList.item(0);
				NodeList detailChildList = detailNode.getChildNodes(); //to get childs of detail

				String attributeMy = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
				//System.out.println("my value is FORM 2 ["+attributeMy+"]");
				valueXmlString.append( "<Detail2 domID='"+attributeMy+"' >\r\n" );
				if (currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					//System.out.println("In itm_default case 2 ::::::: ");
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));

					//System.out.println("tranId....."+tranId);
					valueXmlString.append( "<tran_id ><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<strg_code ><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
				}
				else if(currentColumn.trim().equalsIgnoreCase("sales_pers" ))
				{
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
					String spName="";
					sql = " SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,salesPers);
					rs = pstmt.executeQuery();
					//System.out.println( " sql sss team[" + sql + "]" );
					if(rs.next())
					{
						spName=checkNull(rs.getString("SP_NAME"));
					}

					valueXmlString.append( "<sales_pers_sp_name  ><![CDATA[" ).append(spName.trim()).append( "]]></sales_pers_sp_name>\r\n" );
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;

				}
				//domId++;
				valueXmlString.append( "</Detail2>\r\n" );
				break;
			}//case 2 end
			case 3:
			{
				/*String lineNo = genericUtility.getColumnValue("line_no", dom);
					System.out.println("lineNo>>::"+lineNo);
					if(lineNo==null || lineNo.trim().length()==0)
					{
						lineNo="1";
					}
					int domId=Integer.parseInt(lineNo);*/
				NodeList detailNodeList = dom.getElementsByTagName("Detail3");
				Node detailNode = detailNodeList.item(0);
				NodeList detailChildList = detailNode.getChildNodes(); //to get childs of detail

				String attributeMy = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
				//System.out.println("my value is FORM 3 ["+attributeMy+"]");

				//   NodeList attribNodeList = document.getElementsByTagName("attribute");
				//   Node attribNode = attribNodeList.item(0);
				//
				/*if (detailNode.hasAttributes() )
					    {
					        // get attributes names and values
					        NamedNodeMap nodeMap = detailNode.getAttributes();
					        for (int i = 0; i < nodeMap.getLength(); i++)
					        {
					             Node tempNode = nodeMap.item(i);
					             System.out.println("new -----Attr name : " + tempNode.getNodeName()+ "; Value = " + tempNode.getNodeValue());
//					              if( "dbID".equalsIgnoreCase( tempNode.getNodeName( ) ) )
//					              {
//					             // updatedTransPKValue =  tempNode.getNodeValue();
//					             // E12CommonUtils.printOnConsole("5057---$$$-updatedTransPKValue ["+updatedTransPKValue+"]");
//					              }
					         }
					     }*/
				valueXmlString.append( "<Detail3 domID='"+attributeMy+"' >\r\n" );
				if (currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					//System.out.println("In itm_default case 2 ::::::: ");
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));

					//System.out.println("tranId....."+tranId);
					valueXmlString.append( "<tran_id ><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<strg_code ><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
				}
				else if(currentColumn.trim().equalsIgnoreCase("item_code" ))
				{
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
					String itemDescr="";
					sql = " SELECT DESCR FROM ITEM WHERE ITEM_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,itemCode);
					rs = pstmt.executeQuery();
					//System.out.println( " sql sss item[" + sql + "]" );
					if(rs.next())
					{
						itemDescr=checkNull(rs.getString("DESCR"));
					}

					valueXmlString.append( "<item_descr ><![CDATA[" ).append(itemDescr.trim()).append( "]]></item_descr>\r\n" );
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
				}
				//domId++;
				valueXmlString.append( "</Detail3>\r\n" );
				break;
			}//case 3 end
			case 4 :
			{
				/*System.out.println("@@@@@@@@@@@@@@@ In Detail 4 @@@@@@@@@@@@@@@:::::PITCH ");
					String lineNo = genericUtility.getColumnValue("line_no", dom);
					System.out.println("lineNo>>::"+lineNo);
					if(lineNo==null || lineNo.trim().length()==0)
					{
						lineNo="1";
					}
					int domId=Integer.parseInt(lineNo);*/
				NodeList detailNodeList = dom.getElementsByTagName("Detail4");
				Node detailNode = detailNodeList.item(0);
				NodeList detailChildList = detailNode.getChildNodes(); //to get childs of detail

				String attributeMy = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
				//System.out.println("my value is FORM 4 ["+attributeMy+"]");
				valueXmlString.append( "<Detail4 domID='"+attributeMy+"' >\r\n" );
				if( currentColumn.equalsIgnoreCase("itm_default") )
				{
					String PitchList = "";
					String wrkDateInDbFmt = "";
					int domID = 1;
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					eventDate = checkNull(genericUtility.getColumnValue("event_date", dom1));
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom1));
					strgType = checkNull(genericUtility.getColumnValue("cust_type", dom1).trim());
					strgType = checkNull(genericUtility.getColumnValue("cust_type", dom1).trim());
					String callOutCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1).trim());

					//System.out.println("In Detail4: salesPers : [" + salesPers + "]\n strgCode :[" + strgCode + "]\n tranId :[" + tranId + "]\n wrkDateInDbFmt ::["+wrkDateInDbFmt+"]");
					if( "".equalsIgnoreCase( checkNull( salesPers ) ) )
					{
						salesPers = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
					}
					valueXmlString.append("<work_date><![CDATA[" ).append(eventDate).append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salesPers)).append("]]></sales_pers>\n");
					valueXmlString.append( "<tran_id ><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<pitch_detail  ><![CDATA[" ).append("").append( "]]></pitch_detail>\r\n" );
					valueXmlString.append( "<call_outcome protect = '1' ><![CDATA[" ).append(callOutCome).append( "]]></call_outcome>\r\n" );
					if("F".equalsIgnoreCase(strgType) || "L".equalsIgnoreCase(strgType) )
					{
						valueXmlString.append("<sc_code><![CDATA[").append( checkNull( strgCode ) ).append("]]></sc_code>\r\n");
					}
					else
					{
						if("U".equalsIgnoreCase(strgType))
						{
							custType="L";
						}
						else if("V".equalsIgnoreCase(strgType))
						{
							custType="F";
						}
						String scCode=getUnlistSccode(connectionObject, custType);
						valueXmlString.append("<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
					}
				}
				else if( currentColumn.equalsIgnoreCase( "itm_defaultedit" ))
				{
					pitchDetail = genericUtility.getColumnValue( "pitch_detail", dom );
					String callOutCome = checkNull(genericUtility.getColumnValue("call_outcome", dom1).trim());
					//System.out.println("itm_defaultedit called..pitchDetail.."+pitchDetail);
					sql = " SELECT FLD_VALUE, DESCR FROM GENCODES WHERE FLD_VALUE = ?  ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,pitchDetail);
					rs = pstmt.executeQuery();
					//System.out.println( " sql sss BRAND[" + sql + "]" );
					while(rs.next())
					{
						pitchDescr=checkNull(rs.getString("DESCR"));
						pitchDetail=checkNull(rs.getString("FLD_VALUE"));
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
					valueXmlString.append( "<call_outcome protect = '1' ><![CDATA[" ).append(callOutCome).append( "]]></call_outcome>\r\n" );
					valueXmlString.append("<pitch_detail><![CDATA[").append(pitchDetail).append("]]></pitch_detail>\n");
					valueXmlString.append("<descr><![CDATA[").append(pitchDescr).append("]]></descr>\n");
				}
				else if(currentColumn.trim().equalsIgnoreCase("pitch_detail" ))
				{
					pitchDetail = checkNull(genericUtility.getColumnValue("pitch_detail", dom));
					sql = " SELECT FLD_VALUE, DESCR FROM GENCODES WHERE FLD_VALUE = ?  ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,pitchDetail);
					rs = pstmt.executeQuery();
					//System.out.println( " sql sss BRAND[" + sql + "]" );
					if(rs.next())
					{
						pitchDescr=checkNull(rs.getString("DESCR"));
						pitchDetail=checkNull(rs.getString("FLD_VALUE"));
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
					valueXmlString.append("<pitch_detail><![CDATA[").append(pitchDetail).append("]]></pitch_detail>\n");
					valueXmlString.append("<descr><![CDATA[").append(pitchDescr).append("]]></descr>\n");
				}
				else if(currentColumn.trim().equalsIgnoreCase("brand_code" ))
				{
					String branCode = checkNull(genericUtility.getColumnValue("brand_code", dom));
					String itemDescr="";
					String brandDescr ="";
					sql = " SELECT BRAND_CODE, DESCRIPTION  FROM BRAND WHERE BRAND_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,branCode);
					rs = pstmt.executeQuery();
					//System.out.println( " sql sss BRAND[" + sql + "]" );
					if(rs.next())
					{
						brandDescr=checkNull(rs.getString("DESCRIPTION"));
						branCode=checkNull(rs.getString("BRAND_CODE"));
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
					valueXmlString.append("<item_code><![CDATA[").append(branCode).append("]]></item_code>\n");
					valueXmlString.append("<brand_code><![CDATA[").append(branCode).append("]]></brand_code>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brandDescr).append("]]></brand_descr>\n");
				}
				//domId++;
				valueXmlString.append( "</Detail4>\r\n" );
				break;//case 4 end
			}
			}//switch statement ends here

		}//try block ends here
		catch(Exception e)
		{
			System.out.println( "Exception :RealTimeReport :itemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealTimeReport:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//Added by Gaurav Singh on 27-OCT-2016 [ For real time mobile reporting ]
	public String defaultDataWiz() throws RemoteException, ITMException
	{
		return "";
	}

	public String defaultDataWiz(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("defaultDataWiz xmlString:::: ["+xmlString+"]");
		System.out.println("defaultDataWiz xmlString1::: ["+xmlString1+"]");
		System.out.println("defaultDataWiz xmlString2::: ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = defaultDataWiz( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams, formName );
			//System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :RealTimeReportEJB :defaultDataWiz(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		//System.out.println ( "returning from RealTimeReportEJB defaultDataWiz" );
		return errString;
	}
	public String defaultDataWiz( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName ) throws RemoteException,ITMException
	{
		//System.out.println ( "In side defaultDataWiz :::::::::" );
		ResultSet rs = null;
		PreparedStatement pstmt = null,pStmt1=null;
		PreparedStatement pstmt1 = null;
		ResultSet rs2 = null;
		ResultSet itemRs = null,rs1=null;
		String sql = "";
		String columnValue = "";
		String userId = "";
		Statement stmt = null;
		int currentFormNo = 0;
		String errString = "",itemCode="",salesPers="";
		String eventDate="",strgType="",strgCode="", strgNameDom ="";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		String [] temp = new String [10];
		String spName = "";
		String empcode = "";
		//String windowName = "w_"+getObjName(dom,objContext);
		//System.out.println("Window Name Got :::["+windowName+"]");
		String clientName="",phoneNo="",address="",emailId="",visitTimeFr="",visitTimeTo="",localitySql="",localityDescr="",dcrDate="";
		String sprsCodeWW = ""; // added by rupali on 03/05/18 for single screen mgr reporting

		try
		{
			String currentGeoPos = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"currentGeoPos");
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			userId = getEmpCode(userId, connectionObject);
			empcode = userId;
			//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
			String empDesign = getDesignName(userId, connectionObject); 
			String grade = getGrade(userId, connectionObject);
			System.out.println("empDesign IN defaultdatawiz:: ["+empDesign +"] grade ["+ grade +"]");
			//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
			/*
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("userId>>::"+userId+"empcode>>::"+empcode);
			if( empcode == null || (empcode != null  && empcode.length() == 0))
			{
				empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			}
			userId = empcode;
			 */
			columnValue = genericUtility.getColumnValue( currentColumn, dom );
			//System.out.println("currentColumn"+currentColumn);
			//System.out.println("COLUMNVALUE"+columnValue);
			String mgrCode = getMGREmployee(userId, connectionObject);// added by rupali on 03/05/18 for single screen mgr reporting

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			//System.out.println("currentFormNo=========["+currentFormNo+"], empcode :: ["+empcode+"] , editFlag["+editFlag+"] ,form name is ["+formName+"]");

			String tranId ="";
			String prdCode ="";
			String itemSer ="",custType="";
			String winName = "w_real_time_report";
			String spNameSql = "";
			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			String currentDate = dtFormat.format( date );
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");

			if("doctor".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				String doctorFormNo= checkNull(getFormNo(objName, "doctor", connectionObject));
				String sampleOrder=checkNull(getFormNo(objName, "sampleorder", connectionObject));
				String invoice=checkNull(getFormNo(objName, "invoice", connectionObject));
				String doctorTeam=checkNull(getFormNo(objName, "team", connectionObject));
				String collectFormNo=checkNull(getFormNo(objName, "collection", connectionObject));//added by prachi on 09-AUG-22 [W22EBAS005]
				//String eventTime = geteventTime(); // added by rupali on 20/09/17 for inserting event_time in strg_meet table
				// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [screen]
				String startTime =  geteventTime();
				//String endTime = getVisitTime (connectionObject);
				//commented by mrunalini sinkar for set current time in end time field
				// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
				//System.out.println( "doctorFormNo [" + doctorFormNo + "]" );
				String isMemberPresnt  = checkNull(getSfaParmValue(userId,"HIDE_UNLIST_DET",connectionObject));  //added by mrunalini sinkar for member present
				String displayTimeField  = checkNull(getSfaParmValue(userId,"HIDE_EVENT_TIME_END",connectionObject));//Added by shraddha M[20/07/2020]
				String isFortuneActivity = checkNull(getSfaParmValue(userId, "IS_FORTUNE_ACTIVITY", connectionObject));// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
				
				if( currentColumn.equalsIgnoreCase( "itm_default" ))
				{
					//String startTime = geteventTime();
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, doctorFormNo);
					String actCode = genericUtility.getColumnValue("event_type", dom2, doctorFormNo);
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation]
					String custTypeDescr = genericUtility.getColumnValue("sh_descr", dom2, doctorFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, doctorFormNo);
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2,doctorFormNo));
					String activityCode = checkNull(genericUtility.getColumnValue("strg_code", dom2,doctorFormNo));// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]

					java.sql.Date workDate = null;
					java.sql.Date lastWorkDate = null;
					//tranId = generateTranID(connectionObject, xmlString, xtraParams, winName);
					//TODO
					sql = " SELECT MAX(EVENT_DATE) LAST_WORK_DATE, MAX(EVENT_DATE)+1 WORK_DATE FROM STRG_MEET WHERE SALES_PERS = ? "+
							"AND EVENT_TYPE NOT IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE = 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu
					pstmt =  connectionObject.prepareStatement(sql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if ( rs.next())
					{
						workDate = rs.getDate("WORK_DATE");
						lastWorkDate = rs.getDate("LAST_WORK_DATE");
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//System.out.println("Work date ["+workDate+"] LAST_WORK_DATE ["+lastWorkDate+"]");
					if ( workDate == null )
					{
						java.sql.Date empJoinDate = null;

						sql = "SELECT DATE_JOIN,DATE_JOIN-1 AS LAST_WORK_DATE FROM EMPLOYEE WHERE EMP_CODE = ? ";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, userId);
						rs = pstmt.executeQuery();
						if ( rs.next())
						{
							empJoinDate = rs.getDate("DATE_JOIN") ;
							lastWorkDate = rs.getDate("LAST_WORK_DATE");

						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						String applStartDARDateProp="";
						java.sql.Date appStartDate = null;

						String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='APPL_START_DAR'";// application start date format will be dd/mm/yy
						PreparedStatement pstmtProp = connectionObject.prepareStatement(propSql);

						ResultSet rsProp = pstmtProp.executeQuery();

						if(rsProp.next())
						{
							applStartDARDateProp = rsProp.getString("PROP_VALUE");
						}
						//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
						if (rsProp != null)
						{
							rsProp.close();
							rsProp = null;
						}
						if (pstmtProp != null)
						{
							pstmtProp.close();
							pstmtProp = null;
						}
						//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
						//System.out.println("applStartDARDateProp=["+applStartDARDateProp+"]");

						appStartDate = java.sql.Date.valueOf(dbFormat.format(dtFormat.parse(applStartDARDateProp)));
						//System.out.println("appStartDate=["+appStartDate+"], empJoinDate=["+empJoinDate+"]");
						if(appStartDate.before(empJoinDate))
						{
							//System.out.println("IF empJoinDate");
							workDate= empJoinDate;
						}
						else
						{
							//System.out.println("ELSE appStartDate");
							workDate= appStartDate;
						}
					}
					java.sql.Date sysDate = null;

					sysDate = java.sql.Date.valueOf(dbFormat.format(date));

					//System.out.println("workDate...["+ workDate+"] sysDate...["+ sysDate+"]");
					//System.out.println("workDate.after(sysDate)...["+ workDate.after(sysDate)+"]");
					if ( workDate.after(sysDate) )
					{
						workDate = sysDate;
					}
					//System.out.println("Work date ["+workDate+"] LAST_WORK_DATE["+lastWorkDate+"]");
					String eventDateStr = dtFormat.format( workDate );
					//String tranID = getTranId(connectionObject);

					//System.out.println("Gaurav :: eventDateStr :: ["+eventDateStr+"] ");
					spNameSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt =  connectionObject.prepareStatement(spNameSql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if ( rs.next())
					{
						spName = checkNull(rs.getString("SP_NAME"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					//added by prachi on 02-aug-22 [W22EBAS002]
					String pricelist ="";
					String pricelistSQL = "SELECT ST.PRICE_LIST FROM STATE ST LEFT OUTER JOIN SALES_PERS SP ON ST.STATE_CODE=SP.STATE_CODE WHERE SP.SALES_PERS=? ";				
					pstmt = connectionObject.prepareStatement(pricelistSQL);
		            pstmt.setString(1, userId);
		            rs = pstmt.executeQuery();
		            if(rs.next())
		            {
		            	pricelist=checkNull(rs.getString("PRICE_LIST"));
		            }
		            if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//Added by Bhagyashri T for CGST AND SGST[START][W22EBAS004]
					String totCgst ="";
					String totCgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTCGST FROM DUAL";
					pstmt = connectionObject.prepareStatement( totCgstSql );
					pstmt.setString(1, "CGST");
					ResultSet rset = pstmt.executeQuery();
					if ( rset.next() )
					{
						totCgst = checkNull( rset.getString( "TOTCGST" ) );
					}
					if (rset !=null )
					{
						rset.close();
						rset = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					String totSgst="";
					String totSgstSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TOTSGST FROM DUAL";
					pstmt = connectionObject.prepareStatement( totSgstSql );
					pstmt.setString(1, "SGST");
					rset = pstmt.executeQuery();
					if ( rset.next() )
					{
						totSgst = checkNull( rset.getString( "TOTSGST" ) );
					}
					if (rset !=null )
					{
						rset.close();
						rset = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//Added by Bhagyashri T for CGST AND SGST[END][W22EBAS004]
					//Added by mrunalini sinkar to showing headquarter in summary page (start) 
					String stanCodeHQ="",headQaurter="";
					String hqSql="SELECT EMP.STAN_CODE__HQ AS STAN_CODE__HQ,ST.DESCR AS HEADQAURTER FROM EMPLOYEE EMP,STATION ST WHERE EMP.EMP_CODE=? AND EMP.STAN_CODE__HQ=ST.STAN_CODE";
					pstmt =  connectionObject.prepareStatement(hqSql);
					pstmt.setString(1, userId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stanCodeHQ = checkNull(rs.getString("STAN_CODE__HQ"));
						headQaurter = checkNull(rs.getString("HEADQAURTER"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					//Added by mrunalini sinkar to showing headquarter in summary page (end)
					
					//Added by mrunalini sinkar for Load Number changes28 Feb 2023(Start)
					String eventdate = genericUtility.getValidDateTimeString( currDate , getApplDateFormat() , getDBDateFormat());

					String maxDaySummDate="";

					String daySummMaxSQL="SELECT MAX(EVENT_DATE) AS MAX_DAY_SUMM_DATE FROM SPRS_DAY_SUMM WHERE SALES_PERS=? AND EVENT_DATE<=? ";
					pstmt =  connectionObject.prepareStatement(daySummMaxSQL);
					pstmt.setString(1, salesPers);
					pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(eventdate));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						maxDaySummDate=checkNull(rs.getString("MAX_DAY_SUMM_DATE"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					//Added by mrunalini sinkar for Load Number changes28 Feb 2023(End)
					
					
					//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (start)
					String loadNo="",vehicleNo="";

					if(maxDaySummDate != null && maxDaySummDate.trim().length() > 0) 
					{
						String daySummSql="SELECT SDA.LOAD_NO AS LOAD_NO,SDA.VEH_NO AS VEHICLE_NO FROM SPRS_DAY_SUMM SDA WHERE TRIM(SDA.SALES_PERS)=TRIM(?) AND SDA.EVENT_DATE=?";
						pstmt =  connectionObject.prepareStatement(daySummSql);
						pstmt.setString(1, userId);
						pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(eventdate));
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							loadNo = checkNull(rs.getString("LOAD_NO"));
							vehicleNo = checkNull(rs.getString("VEHICLE_NO"));
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					//Added by Bhagyashri T for showing Load_no and Vehicle no on summary page (end)
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
					
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
					
					String parmValue = getSfaParmValue(userId,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)
					//System.out.println("parmValue is:["+parmValue+"] cuurent date is:"+currDate);
					/*if(parmValue.equalsIgnoreCase("Y"))
					{
						//added by vishal pathare on 23.8.17 for[date of reporting will not change till user confirms the DAR]Start.
						int dcrCount = 0;
						String lastDCRDate ="";
						String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ?";
						pstmt = connectionObject.prepareStatement( selectSql );
						pstmt.setString(1,userId);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							dcrCount = rs.getInt( "COUNT" );
						}
						System.out.println("dcrCount["+dcrCount+"]");
						if( rs != null )
						{
							rs.close();
							rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}

						if( dcrCount > 0 )
						{
							sql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? "+
									"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE != 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu;
							pstmt =  connectionObject.prepareStatement(sql);
							pstmt.setString(1, userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								lastDCRDate = rs.getString("LAST_DCR_DATE");
								System.out.println("lastDCRDate =["+lastDCRDate+"]");
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							String lastConfirmed="";
							sql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE CONFIRMED='Y' and SALES_PERS = ?";
							pstmt =  connectionObject.prepareStatement(sql);
							pstmt.setString(1, userId);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								lastConfirmed = rs.getString("LAST_DCR_DATE");
								System.out.println("lastConfirmedDate =["+lastConfirmed+"]");
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							Date lastDcrDate=dbFormat.parse( lastDCRDate );
							// commented by rupali on 12/10/17 for solving issue if confirmed dcr is not available
							Date lastConfirmedDate=dbFormat.parse( lastConfirmed );
							date=dbFormat.parse( dbFormat.format(date) );

							// added by rupali on 12/10/17 for solving issue if confirmed dcr is not available [start]
							Date lastConfirmedDate = null;
							if(lastConfirmed == null || lastConfirmed.trim().length() == 0)
							{
								System.out.println("lastConfirmed is null =["+lastConfirmed+"]");
							}
							else
							{
								lastConfirmedDate=dbFormat.parse( lastConfirmed );
								date=dbFormat.parse( dbFormat.format(date) );
							}
							// added by rupali on 12/10/17 for solving issue in realtime if confirmed dcr is not available [end]

							if ( date.compareTo( lastDcrDate ) > 0 )
							{
								System.out.println("lastDcrDate =["+lastDcrDate+"]");
								//if( lastDcrDate.compareTo(lastConfirmedDate)==0 ) // commented by rupali on 12/10/17 for solving issue in realtime if confirmed dcr is not available
								if( lastDcrDate.equals(lastConfirmedDate) ) // added by rupali on 12/10/17 for solving issue in realtime if confirmed dcr is not available
								{
									long millis = lastDcrDate.getTime();
									millis += 24 * 60 * 60 * 1000;
									Date newDate = new Date( millis );
									currDate=dtFormat.format( newDate );
								}
								else
								{
									currDate=dtFormat.format( lastDcrDate );;
								}
							}
						}
						else
						{
							currDate=eventDateStr;
						}
						System.out.println("currDate["+currDate+"]");
						//added by vishal pathare on 23.8.17 for[date of reporting will not change till user confirms the DAR]End.
					}*/

					//Added by sagar m.on 17.1.19[for work with other set current value].start
					String othParticipant="";
					String othPartisql= " SELECT OTH_PARTICIPANT,EVENT_TIME_START FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE =  ? "+
							        "AND TO_CHAR(TO_DATE (EVENT_TIME_START, 'HH:MI AM'),'HH24:MI:SS') = (SELECT MAX(TO_CHAR(TO_DATE (EVENT_TIME_START, 'HH:MI AM'),'HH24:MI:SS')) "+
									"FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?) ";
					PreparedStatement othprPstmt = connectionObject.prepareStatement(othPartisql);
					othprPstmt.setString(1,userId);
					othprPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					othprPstmt.setString(3,userId);
					othprPstmt.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					ResultSet othprRs = othprPstmt.executeQuery();
					if(othprRs.next())
					{
						othParticipant = checkNull(othprRs.getString("OTH_PARTICIPANT"));
					}
					if(othprRs != null)
					{
						othprRs.close();
						othprRs = null;
					}
					if(othprPstmt != null)
					{
						othprPstmt.close();
						othprPstmt = null;
					}
					//Added by sagar m.on 17.1.19[for work with other set current value].end
					
					//added by mrunalini sinkar on 19-jan-2018 prescription report changes (start)
					int count=0;
					String isPrExist = "N";

					String countPrSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.SALES_PERS = ? AND A.EVENT_DATE = ? AND B.ACTIVITY_TYPE='PR'";
					PreparedStatement prPstmt = connectionObject.prepareStatement(countPrSql);
					prPstmt.setString(1,userId);
					prPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					ResultSet prRs = prPstmt.executeQuery();
					if(prRs.next())
					{
						count = prRs.getInt("COUNT");
					}
					if(prRs != null)
					{
						prRs.close();
						prRs = null;
					}
					if(prPstmt != null)
					{
						prPstmt.close();
						prPstmt = null;
					}
					if(count > 0)
					{
						isPrExist = "Y";
					}
					//added by mrunalini sinkar on 19-jan-2018 prescription report changes (end)

					// added by rupali on 23/02/18 for edit mode of realtime report [start]
					String tranID = genericUtility.getColumnValue("tran_id", dom2, doctorFormNo);
					//System.out.println("tranID::::::::"+tranID);
					int cnt = 0;
					if(tranID != null && tranID != "" && tranID.trim().length() != 0)
					{
						SimpleDateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());//Added by mrunalini sinkar for next plan date
						SimpleDateFormat dbDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());//Added by mrunalini sinkar for next plan date

						// add the station descr to show on summary page by mrunalini sinkar on 20-05-2019
						//commented & added by mrunalini sinka for route_id changes on 30-04-2019(start)
						/*String editSql = "SELECT SM.*,S.DESCR AS SPECIALITY_DESCR,L.DESCR AS LOCALITY_DESCR FROM LOCALITY L, STRG_MEET SM "+
								"LEFT OUTER JOIN SPECIALITY S ON SM.SPL_CODE = S.SPL_CODE WHERE TRAN_ID = ? AND SM.LOCALITY_CODE = L.LOCALITY_CODE";*/
						String editSql = "SELECT SM.*,S.DESCR AS SPECIALITY_DESCR,(CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END ) AS LOCALITY_DESCR,ST.DESCR AS STATION_DESCR  FROM SPRS_ROUTE SR,STATION ST,STRG_MEET SM "+
								"LEFT OUTER JOIN SPECIALITY S ON SM.SPL_CODE = S.SPL_CODE WHERE TRAN_ID = ? AND  SM.LOCALITY_CODE = SR.LOCALITY_CODE AND SR.ROUTE_ID=SM.ROUTE_ID AND SR.SPRS_CODE=SM.SALES_PERS AND ST.STAN_CODE=SR.STAN_CODE";
						
						//commented & added by mrunalini sinka for route_id changes on 30-04-2019(start)
						pstmt =  connectionObject.prepareStatement(editSql);
						pstmt.setString(1, tranID);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							Date planDate=null;
							String showDate="";
							String actType = "";
							String actDescr = "";
							String stockistCode = "";
							String stockistName = "";
							String placeRequired="";
							String visitedwithTeam = ""; // added by rupali on 03/05/18 for single screen mgr reporting
							currDate = rs.getString("EVENT_DATE");
							Date evntDate = dbFormat.parse(currDate);
							currDate = dtFormat.format(evntDate);
							String eventType = checkNull(rs.getString("EVENT_TYPE"));
							String classCode = checkNull(rs.getString("STRG_CLASS_CODE"));
							String cusType = checkNull(rs.getString("STRG_TYPE"));
							strgCode = checkNull(rs.getString("STRG_CODE"));
							String copyPlan = checkNull(rs.getString("COPY_PLAN"));
							String callOutcome = checkNull(rs.getString("CALL_OUTCOME")); // aded by mrunalini sinkar to visible off in case of refused
							sprsCodeWW = checkNull(rs.getString("SPRS_CODE__WW"));// added by rupali on 03/05/18 for single screen mgr reporting
							//Added by mrunalini sinkar for next plan date(start)
							String nextPlanDate=checkNull(rs.getString("NEXT_PLAN_DATE"));
							String totalamount =  checkNull(rs.getString("AMOUNT")) ;
							String taxAmount =  checkNull(rs.getString("TAX_AMOUNT")) ;
							String netAmount = checkNull(rs.getString("NET_AMT")) ;
							double amt =0d;
							double invoiceAmount =0d;
							String invoicAmount ="";
							double sgstamt =0d;
							double sgstAmt =0d;
							String sgstAmount ="";
							String cgstAmount ="";
							
							String allowChgTime="";
							String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
							pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
							pstmt.setString(1, eventType);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(totalamount!=null && totalamount.trim().length()>0)
							{
							  amt=Double.parseDouble(totalamount);
							  invoiceAmount=Math.round(amt);
							  invoicAmount=Double.toString(invoiceAmount);
							}
							if(taxAmount!=null && taxAmount.trim().length()>0)
							{
								sgstamt=Double.parseDouble(taxAmount);
								sgstAmt=(sgstamt/2);
								sgstAmount=Double.toString(sgstAmt);
								cgstAmount =sgstAmount;
							}
							 //added by bhagyashri T for Summary of lbcp[start]
			                String  strgState="";
			                String strgGstNo="";
		                    String strgCdsql = "SELECT ST.DESCR AS STRG_STATE,SC.GST_NO AS STRG_GST_NO FROM STRG_CUSTOMER SC,STATE ST WHERE TRIM(SC.SC_CODE)=TRIM(?) AND SC.STATE_CODE=ST.STATE_CODE";
		        			pstmt = connectionObject.prepareStatement(strgCdsql);
		        			pstmt.setString(1, strgCode);
		        			ResultSet rSet = pstmt.executeQuery();
		        			if(rSet.next())
		        			{
		        				strgState = checkNull(rSet.getString("STRG_STATE"));
		        				strgGstNo = checkNull(rSet.getString("STRG_GST_NO"));
		        			}
		        			if(rSet!=null)
		        			{
		        				rSet.close();
		        				rSet=null;
		        			}
		        			if(pstmt!=null)
		        			{
		        				pstmt.close();
		        				pstmt = null;

		        			}
		        			//added by bhagyashri T for Summary of lbcp[end]
							if(nextPlanDate!=null && nextPlanDate.trim().length()>0)
							{
								planDate=dbFormat.parse(nextPlanDate);
								showDate=applFormat.format(planDate);
							}
							//Added by mrunalini sinkar for next plan date(end)
							
							String classCodeDescr = getClassCodeDesc(classCode,cusType,sprsCodeWW,connectionObject);
							String templateId=checkNull(getTemplateIdForUnlisted(userId, cusType, connectionObject));
							//changed by mrunalini sinkar for place required changes(start)
							//String actSql  = "SELECT DESCR, ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
							String actSql  = "SELECT DESCR, ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
							pStmt1 = connectionObject.prepareStatement(actSql);
							pStmt1.setString(1, eventType);
							rs1 = pStmt1.executeQuery();
							if(rs1.next())
							{
								actDescr = checkNull(rs1.getString("DESCR"));
								actType = checkNull(rs1.getString("ACTIVITY_TYPE"));
								placeRequired = checkNull(rs1.getString("PLACE_REQUIRED"));
							}
							if( rs1 !=null )
							{
								rs1.close();
								rs1 = null;
							}
							if( pStmt1 !=null )
							{
								pStmt1.close();
								pStmt1 = null;
							}
							String stockSql = "SELECT SMO.STOCKIST_CODE AS STOCKIST_CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS STOCKIST_NAME, DCR_ID "+
									"FROM STRG_MEET_ORDER SMO, STRG_CUSTOMER SC WHERE SMO.TRAN_ID = ? AND SC.SC_CODE = SMO.STOCKIST_CODE";
							pStmt1 =  connectionObject.prepareStatement(stockSql);
							pStmt1.setString(1, tranID);
							rs1 = pStmt1.executeQuery();
							if(rs1.next())
							{
								stockistCode = checkNull(rs1.getString("STOCKIST_CODE"));
								stockistName = checkNull(rs1.getString("STOCKIST_NAME"));
							}
							if (rs1!= null)
							{
								rs1.close();
								rs1 = null;
							}
							if(pStmt1!=null)
							{
								pStmt1.close();
								pStmt1 = null;
							}
							String workWith = "";
							String teamDetail = getExistingTeam(userId,currDate,tranID,connectionObject);
							if(teamDetail.length() > 0)
							{
								//System.out.println("Inside teamDeatils");
								workWith = getWorkWithList(teamDetail,"1");
							}
							//System.out.println("workWith :: ["+workWith+"]");

							String custSql  = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE = ?";
							pStmt1 = connectionObject.prepareStatement(custSql);
							pStmt1.setString(1, strgCode);
							rs1 = pStmt1.executeQuery();
							if(rs1.next())
							{
								cnt = rs1.getInt("COUNT");
							}
							if( rs1 !=null )
							{
								rs1.close();
								rs1 = null;
							}
							if( pStmt1 !=null )
							{
								pStmt1.close();
								pStmt1 = null;
							}
							// added by rupali on 03/05/18 for single screen mgr reporting [start]
							custSql = "SELECT EMP_CODE AS TEAM, (CASE WHEN DDF_GET_EMPLOYEE_NAME(EMP_CODE) ||' (' || LTRIM(RTRIM(EMP_CODE)) || ') ' LIKE '%("+empcode+")%' THEN 'SELF' "+
									"ELSE DDF_GET_EMPLOYEE_NAME(EMP_CODE) ||' (' || LTRIM(RTRIM(EMP_CODE)) || ') ' END) AS VISITED_WITH FROM EMPLOYEE WHERE EMP_CODE = ?";
							pStmt1 = connectionObject.prepareStatement(custSql);
							pStmt1.setString(1, sprsCodeWW);
							rs1 = pStmt1.executeQuery();
							if(rs1.next())
							{
								visitedwithTeam = rs1.getString("VISITED_WITH");
							}
							if( rs1 !=null )
							{
								rs1.close();
								rs1 = null;
							}
							if( pStmt1 !=null )
							{
								pStmt1.close();
								pStmt1 = null;
							}
							// added by rupali on 03/05/18 for single screen mgr reporting [end]
							//adeed by mrunalini sinkar on 6-july-2018(start)
							String active="",parmVal="",formNo="";
							String subFormsql="SELECT ACTIVE,PARM_VALUE FROM SFAPARM WHERE PARM_NAME='IS_SUBFORM_PROTECT'";
							PreparedStatement subFormPstmt =connectionObject.prepareStatement(subFormsql);
							ResultSet subFormRs = subFormPstmt.executeQuery();
							if(subFormRs.next())
							{
								active=checkNull(subFormRs.getString("ACTIVE"));
								parmVal=checkNull(subFormRs.getString("PARM_VALUE"));
							}
							if(subFormRs != null)
							{
								subFormRs.close();
								subFormRs = null;
							}
							if(subFormPstmt != null)
							{
								subFormPstmt.close();
								subFormPstmt = null;
							}
							if(active.equalsIgnoreCase("Y"))
							{

								String subFormName = "";
								String [] subForm = parmVal.split(",");
								for(int i = 0 ;i < subForm.length;i++)
								{
									if(subFormName == null || subFormName.trim().length() == 0)
									{
										subFormName = subForm[i];
									}
									else
									{
										subFormName = subFormName + "','" + subForm[i];
									}
								}
								subFormName = "'" + subFormName + "'";

								String objectName = getObjNameFromDom( dom, "objName" , 1);
								String objWinName = "w_"+objectName;
								String objFormSql= "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME= ? AND FORM_NAME IN("+subFormName+") ";
								PreparedStatement objFormpstmt = connectionObject.prepareStatement(objFormSql);
								objFormpstmt.setString(1, objWinName);
								ResultSet objFormrs = objFormpstmt.executeQuery();
								while(objFormrs.next())
								{
									String objFormNo = checkNull(objFormrs.getString("FORM_NO"));
									if(formNo == null || formNo.trim().length() == 0)
									{
										formNo = objFormNo;
									}
									else
									{
										formNo = formNo + "," + objFormNo;
									}
								}
								if(objFormrs != null)
								{
									objFormrs.close();
									objFormrs = null;
								}
								if(objFormpstmt != null)
								{
									objFormpstmt.close();
									objFormpstmt = null;
								}
							}
							//System.out.println("formNo is["+formNo+"]");
							//adeed by mrunalini sinkar on 6-july-2018(end)
							valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"' selected = 'Y'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append( "<tran_id><![CDATA[" ).append(tranID).append( "]]></tran_id>\r\n" );
							valueXmlString.append( "<event_date protect = '1'><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
							valueXmlString.append("<survey_templ>").append(templateId).append("</survey_templ>\r\n");
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
							valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
							valueXmlString.append( "<grade_code><![CDATA[" ).append( grade ).append( "]]></grade_code>\r\n" );
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
							valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("EVENT_TYPE")) ).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append( actDescr ).append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append( actType ).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append( placeRequired ).append( "]]></place_required>\r\n" );	// added by mrunalini sinkar on 09-sep-2018 for place required changes(start)
							valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );
							valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_TYPE")) ).append( "]]></strg_type>\r\n" );
							valueXmlString.append( "<locality_code protect = '1'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_DESCR")) ).append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<wf_status><![CDATA[" ).append( checkNull(rs.getString("WF_STATUS")) ).append( "]]></wf_status>\r\n" );
							valueXmlString.append( "<confirmed><![CDATA[" ).append( checkNull(rs.getString("CONFIRMED")) ).append( "]]></confirmed>\r\n" );
							valueXmlString.append( "<route_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("ROUTE_ID")) ).append( "]]></route_id>\r\n" ); // added by mrunalini sinka for route_id changes on 30-04-2019
							valueXmlString.append( "<station_type><![CDATA[" ).append( checkNull(rs.getString("STATION_TYPE")) ).append( "]]></station_type>\r\n" );//added by mrunalini sinka for route_id changes on 30-04-2019
							valueXmlString.append( "<station_descr><![CDATA[" ).append( checkNull(rs.getString("STATION_DESCR")) ).append( "]]></station_descr>\r\n" ); // added by mrunalini sinka for showing STATION_DESCR changes on 20-05-2019
							valueXmlString.append("<is_member_present><![CDATA[" ).append(checkNull(isMemberPresnt)).append( "]]></is_member_present>\r\n" );
							valueXmlString.append( "<price_list><![CDATA[" ).append(pricelist).append( "]]></price_list>\r\n" );
							valueXmlString.append( "<amount><![CDATA[" ).append(totalamount).append( "]]></amount>\r\n" ); 
							valueXmlString.append( "<net_amt><![CDATA[" ).append( netAmount ).append( "]]></net_amt>\r\n" ); 
							valueXmlString.append( "<tax_amount><![CDATA[" ).append( taxAmount ).append( "]]></tax_amount>\r\n" );
							valueXmlString.append("<basic_value><![CDATA[" ).append( "Basic:" + netAmount ).append( "]]></basic_value>\r\n" );
							valueXmlString.append("<total_gst><![CDATA[" ).append( "GST:" + taxAmount).append( "]]></total_gst>\r\n" );
							valueXmlString.append("<total_value><![CDATA[" ).append( "Total Amount:" + totalamount ).append( "]]></total_value>\r\n" );
							//Added by Bhagyashri T for details showing on summary
							valueXmlString.append( "<load_no><![CDATA[" ).append(loadNo).append( "]]></load_no>\r\n" );
							valueXmlString.append( "<vehicle_no><![CDATA[" ).append(vehicleNo).append( "]]></vehicle_no>\r\n" ); 
							valueXmlString.append( "<invoice_amount><![CDATA[" ).append(invoicAmount).append( "]]></invoice_amount>\r\n" ); 
							valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append( sgstAmount).append( "]]></total_sgst_amt>\r\n" ); 
							valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append( cgstAmount).append( "]]></total_cgst_amt>\r\n" ); 
							valueXmlString.append( "<total_cgst><![CDATA[" ).append(totCgst).append( "]]></total_cgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
							valueXmlString.append( "<total_sgst><![CDATA[" ).append(totSgst).append( "]]></total_sgst>\r\n" ); //Added by Bhagyashri T for CGST AND SGST
							valueXmlString.append( "<strg_gst_no><![CDATA[" ).append( strgState).append( "]]></strg_gst_no>\r\n" ); 
							valueXmlString.append( "<strg_state><![CDATA[" ).append( strgGstNo).append( "]]></strg_state>\r\n" );
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
							{
								if(allowChgTime.trim().equalsIgnoreCase("Y"))
								{
									valueXmlString.append( "<event_time_start protect='0' visible = '1'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect='0' visible = '1'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								}
								else if(allowChgTime.trim().equalsIgnoreCase("N"))
								{
									valueXmlString.append( "<event_time_start protect = '1'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect = '1'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								
								}
								else if(allowChgTime.trim().equalsIgnoreCase("B"))
								{
									valueXmlString.append( "<event_time_start protect='0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect='0'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								
								}
								else
								{
									valueXmlString.append( "<event_time_start protect = '1'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
									valueXmlString.append( "<event_time_end protect = '1'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );								
								
								}
								valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								
							}
							else
							{
								
								valueXmlString.append( "<event_time_start visible = '0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append("]]></event_time_start>\r\n");
								valueXmlString.append( "<event_time_end visible = '0'><![CDATA[").append( checkNull(rs.getString("EVENT_TIME_END")) ).append( "]]></event_time_end>\r\n" );
							}
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							valueXmlString.append( "<visit_time_from visible = '0'><![CDATA[").append(checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></visit_time_from>\r\n" );//added by shraddha M[20/07/2020]
							valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
							valueXmlString.append( "<strg_no_visit protect='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NO_VISIT")) ).append( "]]></strg_no_visit>\r\n" );
							valueXmlString.append("<member_present><![CDATA[" ).append(checkNull(rs.getString("MEMBER_PRESENT")) ).append( "]]></member_present>\r\n" ); 
							valueXmlString.append("<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT")) ).append( "]]></strg_no_visit>\r\n" ); 


							//added by mrunalini sinkar on 12-june-2018 For set ---NA--- in case refused (start)
							if(callOutcome.equalsIgnoreCase("0") || callOutcome.equalsIgnoreCase("9"))
							{
								valueXmlString.append( "<meet_summ protect='1' visible='0'><![CDATA[" ).append("---NA---").append( "]]></meet_summ>\r\n" );
							}
							else
							{
								valueXmlString.append( "<meet_summ protect='0' visible='1'><![CDATA[" ).append( checkNull(rs.getString("MEET_SUMM")) ).append( "]]></meet_summ>\r\n" );
							}
							valueXmlString.append( "<subform_protect><![CDATA[" ).append(formNo).append( "]]></subform_protect>\r\n" );
							//added by mrunalini sinkar on 12-june-2018 For set ---NA--- in case refused (end)
							valueXmlString.append( "<short_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID")) ).append( "]]></short_id>\r\n" );
							valueXmlString.append( "<dcr_id protect='1'><![CDATA[" ).append( checkNull(rs.getString("DCR_ID")) ).append( "]]></dcr_id>\r\n" );
							valueXmlString.append( "<pob_val protect='1'><![CDATA[" ).append( checkNull(rs.getString("POB_VAL")) ).append( "]]></pob_val>\r\n" );
							valueXmlString.append( "<sku_value protect='1'><![CDATA[" ).append( checkNull(rs.getString("SKU_VALUE")) ).append( "]]></sku_value>\r\n" );
							valueXmlString.append( "<add_geopos protect='1'><![CDATA[" ).append( checkNull(rs.getString("ADD_GEOPOS")) ).append( "]]></add_geopos>\r\n" );
							valueXmlString.append( "<chg_geopos protect='1'><![CDATA[" ).append( checkNull(rs.getString("CHG_GEOPOS")) ).append( "]]></chg_geopos>\r\n" );
							valueXmlString.append( "<geopos_accuracy protect='1'><![CDATA[" ).append( checkNull(rs.getString("GEOPOS_ACCURACY")) ).append( "]]></geopos_accuracy>\r\n" ); //changes made by rupali on 20/07/18 for adding geopos_accuracy tag
							valueXmlString.append( "<geo_pos_name><![CDATA[" ).append( checkNull(rs.getString("GEO_POS_NAME")) ).append( "]]></geo_pos_name>\r\n" );
							valueXmlString.append( "<order_of_visit protect='1'><![CDATA[" ).append( checkNull(rs.getString("ORDER_OF_VISIT")) ).append( "]]></order_of_visit>\r\n" );
							//valueXmlString.append( "<visited_with protect = '0'><![CDATA[" ).append( teamDetail ).append( "]]></visited_with>\r\n" );
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append( "" ).append( "]]></calloutcome_descr>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append(checkNull(getShDescr(cusType,connectionObject))).append( "]]></sh_descr>\r\n" );
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append( checkNull(rs.getString("COPY_PLAN")) ).append( "]]></copy_plan>\r\n" );
							valueXmlString.append( "<visited_with_team><![CDATA[" ).append( checkNull(rs.getString("SPRS_CODE__WW")) ).append( "]]></visited_with_team>\r\n" );
							// added by rupali on 03/05/18 for single screen mgr reporting [start]
							if(mgrCode.trim().length()!= 0)
							{
								valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append( checkNull(rs.getString("SPRS_CODE__WW")) ).append( "]]></sprs_code__ww>\r\n" );
								valueXmlString.append( "<visited_with protect = '1'><![CDATA[" ).append( visitedwithTeam ).append( "]]></visited_with>\r\n" );
							}
							else
							{
								valueXmlString.append( "<visited_with protect = '1'><![CDATA[" ).append( teamDetail ).append( "]]></visited_with>\r\n" );
							}
							// added by rupali on 03/05/18 for single screen mgr reporting [end]

							if(cnt > 0)
							{
								//Added by mrunalini sinkar for member present changes(start)
								valueXmlString.append( "<strg_code protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
								valueXmlString.append( "<call_outcome protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
								valueXmlString.append( "<oth_participant visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
								valueXmlString.append( "<remarks visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
								valueXmlString.append( "<stockist_name protect = '1' visible='1'><![CDATA[" ).append( stockistName ).append( "]]></stockist_name>\r\n" );
								valueXmlString.append( "<stockist_code visible='1'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );
								//Added by mrunalini sinkar for member present changes(end)
								valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append( "LISTED" ).append( "]]></cust_type>\r\n" );
								valueXmlString.append( "<type_cust><![CDATA[" ).append("L").append( "]]></type_cust>\r\n" );
								valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
								valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
								valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
								valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
								valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
								valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
								valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );
								valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
								valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
								valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
								valueXmlString.append( "<age protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
								valueXmlString.append( "<qualification protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
								valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
								valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append( classCodeDescr ).append( "]]></class_code_descr>\r\n" );
								valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );
							}
							else
							{
								if(!isMemberPresnt.equalsIgnoreCase("Y"))//Added by mrunalini sinkar for member present changes
								{
									//Added by mrunalini sinkar for member present changes(start)
									valueXmlString.append( "<strg_code protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
									valueXmlString.append( "<call_outcome protect = '1' visible='1'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
									valueXmlString.append( "<oth_participant visible='1'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
									valueXmlString.append( "<remarks visible='1'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
									valueXmlString.append( "<stockist_name protect = '1' visible='1'><![CDATA[" ).append( stockistName ).append( "]]></stockist_name>\r\n" );
									valueXmlString.append( "<stockist_code visible='1'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );
									//Added by mrunalini sinkar for member present changes(end)
									valueXmlString.append( "<strg_name protect = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
									valueXmlString.append( "<email_addr protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
									valueXmlString.append( "<mobile_no protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
									valueXmlString.append( "<address_as protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
									valueXmlString.append( "<gender protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
									valueXmlString.append( "<addr1 protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
									valueXmlString.append( "<addr2 protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
									valueXmlString.append( "<addr3 protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
									valueXmlString.append( "<age protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
									valueXmlString.append( "<qualification protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
									valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
									valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append( classCodeDescr ).append( "]]></class_code_descr>\r\n" );
									//added & commented by mrunalini sinkar on 30-01-2019(start) 
									valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append(checkNull(getCustTypeDesc(cusType, connectionObject))).append( "]]></cust_type>\r\n" );
									if("D".equalsIgnoreCase(cusType))
									{
										valueXmlString.append( "<spl_code protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									else
									{
										valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									valueXmlString.append("<next_plan_date visible='1'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );

								}
								else//Added by mrunalini sinkar for member present changes
								{
									
									String strgName=checkNull(rs.getString("STRG_NAME"));
									valueXmlString.append("<strg_code protect = '1' visible='0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")) ).append( "]]></strg_code>\r\n" );
									valueXmlString.append("<call_outcome protect = '1' visible='0'><![CDATA[" ).append( checkNull(rs.getString("CALL_OUTCOME")) ).append( "]]></call_outcome>\r\n" );
									valueXmlString.append("<oth_participant visible='0'><![CDATA[" ).append( checkNull(rs.getString("OTH_PARTICIPANT")) ).append( "]]></oth_participant>\r\n" );
									valueXmlString.append("<remarks visible='0'><![CDATA[" ).append( checkNull(rs.getString("REMARKS")) ).append( "]]></remarks>\r\n" );
									valueXmlString.append( "<stockist_name protect = '1' visible='0'><![CDATA[" ).append( stockistName ).append( "]]></stockist_name>\r\n" );
									valueXmlString.append( "<stockist_code visible='0'><![CDATA[" ).append( stockistCode ).append( "]]></stockist_code>\r\n" );

									if(strgName!=null && strgName.trim().length() >0)
									{
										valueXmlString.append( "<strg_name protect = '0' visible='0'><![CDATA[" ).append( checkNull(rs.getString("STRG_NAME")) ).append( "]]></strg_name>\r\n" );
									}
									else
									{
										valueXmlString.append( "<strg_name protect = '0' visible='0'><![CDATA[" ).append(checkNull(getShDescr(cusType,connectionObject))).append( "]]></strg_name>\r\n" );

									}
									valueXmlString.append( "<email_addr protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
									valueXmlString.append( "<mobile_no protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
									valueXmlString.append( "<address_as protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
									valueXmlString.append( "<gender protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("GENDER")) ).append( "]]></gender>\r\n" );
									valueXmlString.append( "<addr1 protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
									valueXmlString.append( "<addr2 protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
									valueXmlString.append( "<addr3 protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
									valueXmlString.append( "<age protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
									valueXmlString.append( "<qualification protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
									valueXmlString.append( "<strg_class_code protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("STRG_CLASS_CODE")) ).append( "]]></strg_class_code>\r\n" );
									valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append( classCodeDescr ).append( "]]></class_code_descr>\r\n" );
									//added & commented by mrunalini sinkar on 30-01-2019(start) 
									valueXmlString.append( "<cust_type protect = '1' visible='0'><![CDATA[" ).append(checkNull(getCustTypeDesc(cusType, connectionObject))).append( "]]></cust_type>\r\n" );
									if("D".equalsIgnoreCase(cusType))
									{
										valueXmlString.append( "<spl_code protect = '0' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									else
									{
										valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
										valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );

									}
									valueXmlString.append("<next_plan_date visible='0'><![CDATA[" ).append(checkNull(showDate)).append( "]]></next_plan_date>\r\n" );

								}

								/*if("D".equalsIgnoreCase(cusType))
								{
									valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("UNLISTED-DOCTOR").append( "]]></cust_type>\r\n" );
									valueXmlString.append( "<spl_code protect = '0' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></spl_code>\r\n" );
									valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></speciality_descr>\r\n" );
								}
								else if("C".equalsIgnoreCase(cusType))
								{
									valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("UNLISTED-RETAILER").append( "]]></cust_type>\r\n" );
									valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></speciality_descr>\r\n" );
									valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></spl_code>\r\n" );
								}
								else if("S".equalsIgnoreCase(cusType))
								{
									valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("UNLISTED-STOCKIST").append( "]]></cust_type>\r\n" );
									valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></speciality_descr>\r\n" );
									valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></spl_code>\r\n" );
								}
								else if("O".equalsIgnoreCase(cusType))
								{
									valueXmlString.append( "<cust_type protect = '1'><![CDATA[" ).append("UNLISTED-OTHER").append( "]]></cust_type>\r\n" );
									valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPL_CODE")) ).append( "]]></speciality_descr>\r\n" );
									valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append( checkNull(rs.getString("SPECIALITY_DESCR")) ).append( "]]></spl_code>\r\n" );
								}*/
								//added & commented by mrunalini sinkar on 30-01-2019(end )
							}
							//System.out.println("itemdefaultEdit called....");
							valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
							valueXmlString.append( "<invoice_form_no><![CDATA[" ).append( invoice ).append( "]]></invoice_form_no>\r\n" );
							valueXmlString.append( "<collection_form_no><![CDATA[" ).append( collectFormNo ).append( "]]></collection_form_no>\r\n" );//added by prachi on 09-AUG-22 [W22EBAS005]
							valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
							valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displayTimeField ).append( "]]></display_time_fld>\r\n" );//addednby shraddha M[20/07/2020]

							valueXmlString.append( "</Detail1>\r\n" );

							HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
							strgCode = "'"+strgCode+"'";
							if(subFormsMap.containsKey("sampleitem"))
							{
								String sampleitemFormNo = subFormsMap.get("sampleitem");
								if ( preDomExists( dom2, sampleitemFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, sampleitemFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									////System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingItem = getSampleExistingItemsDetail( userId, currDate , strgCode,sampleitemFormNo,"sampleitem",connectionObject ) ;
									////System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
									if( existingItem !=null && existingItem.length() > 0 )
									{
										valueXmlString.append( existingItem);
									}
								}
							}
							if(subFormsMap.containsKey("sampleorder"))
							{
								String sampleorderFormNo = subFormsMap.get("sampleorder");
								if ( preDomExists( dom2, sampleorderFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, sampleorderFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingItem = getExistingItemsDetail( userId, currDate , strgCode,sampleorderFormNo,"sampleorder",connectionObject ) ;
									//System.out.println( "DefaultDataDAR :: existingItem5 [ " + existingItem + "]" );
									if( existingItem !=null && existingItem.length() > 0 )
									{
										valueXmlString.append( existingItem);
									}
								}
							}
							if(subFormsMap.containsKey("brand"))
							{
								String brandFormNo = subFormsMap.get("brand");
								if ( preDomExists( dom2, brandFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, brandFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingBrand = getExistingPitchForDoctor( userId, currDate, strgCode, "", "", brandFormNo,"brand",connectionObject );
									//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingBrand + "]" );
									if( existingBrand !=null && existingBrand.length() > 0 )
									{
										valueXmlString.append( existingBrand);
									}
								}
							}
							if(subFormsMap.containsKey("display"))
							{
								String displayFormNo = subFormsMap.get("display");
								if ( preDomExists( dom2, displayFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, displayFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingDnd = getExistingDndDetailDisplay( userId, currDate, strgCode, connectionObject,displayFormNo,"display") ;
									//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingDnd + "]" );
									if( existingDnd !=null && existingDnd.length() > 0 )
									{
										valueXmlString.append( existingDnd);
									}
								}
							}
							if(subFormsMap.containsKey("team"))
							{
								String teamFormNo = subFormsMap.get("team");
								if ( preDomExists( dom2, teamFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, teamFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingTeam = getSalesExistingTeamDetail( userId, currDate , strgCode,teamFormNo,"team",connectionObject ) ;
									//System.out.println( "DefaultDataDAR :: existiteam [ " + existingTeam + "]" );
									if( existingTeam !=null && existingTeam.length() > 0 )
									{
										valueXmlString.append( existingTeam);
									}
								}
							}
							if(subFormsMap.containsKey("brandsurvey"))
							{
								String brandSurveyFormNo = subFormsMap.get("brandsurvey");
								if ( preDomExists( dom2, brandSurveyFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, brandSurveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingBrandSurvey = getExistingBrandSurveyDetail( userId, currDate, strgCode, brandSurveyFormNo,"brandsurvey", connectionObject );
									//System.out.println( "DefaultDataDAR :: existingBrand [ " + existingBrand + "]" );
									if( existingBrandSurvey !=null && existingBrandSurvey.length() > 0 )
									{
										valueXmlString.append( existingBrandSurvey);
									}
								}
							}
							// added by rupali on 28/09/18 for survey subform [start]
							if(subFormsMap.containsKey("survey"))
							{
								String surveyFormNo = subFormsMap.get("survey");
								if ( preDomExists( dom2, surveyFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, surveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingSurvey = getExistingSurveyDetail( userId, currDate, strgCode, surveyFormNo,"survey", connectionObject );
									//System.out.println( "DefaultDataDAR :: existingSurvey [ " + existingSurvey + "]" );
									if( existingSurvey !=null && existingSurvey.length() > 0 )
									{
										valueXmlString.append( existingSurvey);
									}
								}
							}
							// added by rupali on 28/09/18 for survey subform [end]
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
							if(subFormsMap.containsKey("coaching"))
							{
								String surveyFormNo = subFormsMap.get("coaching");
								if ( preDomExists( dom2, surveyFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, surveyFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									//System.out.println( "DefaultDataDAR :: prevFormValues [ " + prevFormValues + "]" );
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingSurvey = getExistingCoachingDetail( userId, currDate, strgCode, surveyFormNo,"coaching", connectionObject,sprsCodeWW,visitedwithTeam );
									//System.out.println( "DefaultDataDAR :: existingSurvey [ " + existingSurvey + "]" );
									if( existingSurvey !=null && existingSurvey.length() > 0 )
									{
										valueXmlString.append( existingSurvey);
									}
								}
							}
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
							//Added by Bhagyashri T for Invoice form[W22EBAS004][start]
							if(subFormsMap.containsKey("invoice"))
							{
								String invoiceFormNo = subFormsMap.get("invoice");
								if ( preDomExists( dom2, invoiceFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, invoiceFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingItem = getExistingInvoiceDetail( userId, currDate , strgCode,invoiceFormNo,"invoice",connectionObject ) ;
									if( existingItem !=null && existingItem.length() > 0 )
									{
										valueXmlString.append( existingItem);
									}
								}
							}
							//Added by Bhagyashri T for Invoice form[W22EBAS004][end]
							
							//added by prachi on 09-AUG-22 [W22EBAS005]
							if(subFormsMap.containsKey("collection"))
							{
								String collectionFormNo = subFormsMap.get("collection");
								if ( preDomExists( dom2, collectionFormNo ) )
								{
									String prevFormValues =  getPrevFormVal( dom2, collectionFormNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
									valueXmlString.append( prevFormValues );
								}
								else if( !"".equalsIgnoreCase( strgCode ) )
								{
									String existingDnd = getExistingCollectionDetail( userId, currDate, strgCode,collectionFormNo,"collection",connectionObject) ;
									if( existingDnd !=null && existingDnd.length() > 0 )
									{
										valueXmlString.append( existingDnd);
									}
								}
							}
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else
					{
						
						// added by rupali on 04/12/18 to set nearest manager in visited with field [start]
						String mgrUserId = "";
						String visitedWith = "";
						//System.out.println("currentGeoPos is:["+currentGeoPos+"] currDate::::["+currDate+"]");
						TreeMap<Double , String> mgrLocationMap = getMgrLocation(currentGeoPos,userId,currDate,connectionObject);
						if(!mgrLocationMap.isEmpty())
						{
							Entry<Double,String> entry = mgrLocationMap.entrySet().iterator().next();
							Double key = entry.getKey();
							mgrUserId = entry.getValue();
							//System.out.println("mgrLocationMap key"+ key+"mgrLocationMap value"+mgrUserId);
						}
						
						sql = "SELECT EMP_CODE AS REPORT_TO,DDF_GET_EMPLOYEE_NAME(EMP_CODE) ||' (' || "+
						     "LTRIM(RTRIM(EMP_CODE)) || ') ' AS VISITED_WITH FROM EMPLOYEE WHERE EMP_CODE = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mgrUserId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							visitedWith = checkNull(rs.getString("VISITED_WITH"));
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						// added by rupali on 04/12/18 to set nearest manager in visited with field [end]
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]
						String defACt = checkNull(getSfaParmValue(userId, "DEF_ACT_REALCODE", connectionObject));
						String actDescr="",actType="",placReq="";
						//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
						String actPlace="";
						//String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED,ACTIVITY_PLACE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
						pstmt = connectionObject.prepareStatement(defACtsql);
						pstmt.setString(1, defACt);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							actDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
							actType = checkNull(rs.getString("ACTIVITY_TYPE"));
							placReq = checkNull(rs.getString("PLACE_REQUIRED"));
							actPlace = checkNull(rs.getString("ACTIVITY_PLACE"));//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]
						//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[start]
						int allwdPrd=0;
						String allDelaySql = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
						pstmt =  connectionObject.prepareStatement(allDelaySql);
						pstmt.setString(1, checkNull(userId));
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							allwdPrd = rs.getInt("ALLWD_DELAY_PRD");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						String allowChgTime="";
						String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
						pstmt.setString(1, defACt);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[end]
						// added by rupali on 26/07/18 to open realtime report from series master [start]
						if(strgCode == null || strgCode.trim().length() == 0)
						{
							//added by prachhi for planned beat changes on 15-NOV-2022
							String planDayRoute  = checkNull(getSfaParmValue(userId,"PLAN_DAYS_REQ",connectionObject));
							String localityCode1 = "", localityDescr1 = "", stockistCode = "", stockistName = "",stockistAdd="",stockistGstno="",stockistState="", itemSer1= "",stationType = "", stationDescr = "",
							routeType = "", routeId = "",routeDescr="",invoiceNo="";
							int planCount=0;
							if("Y".equalsIgnoreCase(planDayRoute))
							{
								DateFormat dtAppFormat = new SimpleDateFormat(getApplDateFormat());
								Date parsedDate = dtAppFormat.parse(currDate);
								Calendar calendar = Calendar.getInstance();
								calendar.setTime(parsedDate);
								String days[] = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
								String prefixes[] = new String[]{"1st", "2nd", "3rd", "4th", "5th"};
								String dayName = days[parsedDate.getDay()];
					            String weekDayString = "";
								if(parsedDate.getDate() % 7 == 0)
								{
									weekDayString = prefixes[(int)Math.floor((parsedDate.getDate() / 7) - 1)] + ' ' + days[parsedDate.getDay()];
								}
								else
								{
									weekDayString = prefixes[(int)Math.floor(parsedDate.getDate() / 7)] + ' ' + days[parsedDate.getDay()];
								}
					           
					            String planlocalityCnt = "SELECT COUNT(pe.ROUTE_ID) AS COUNT  FROM TABLE(localityCodePophelp.getlocalityPophelpData(?)) pe where pe.PLAN_DAYS LIKE '%"+weekDayString+"%' ";
								pstmt = connectionObject.prepareStatement(planlocalityCnt);
								pstmt.setString(1, userId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									planCount=rs.getInt("COUNT");
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
					            }
								
								if(planCount > 0)
								{

						            int itr=0;
									String localityData = "SELECT TRIM(pe.ROUTE_ID) AS ROUTE_ID,pe.INVOICE_SR_NO AS INVOICE_NO,pe.LOCALITY_CODE AS LOCALITY_CODE, pe.DESCR  AS DESCR,pe.STOCKIST_CODE AS STOCKIST_CODE, "
											+ "pe.STOCKIST_NAME AS STOCKIST_NAME ,pe.STOCKIST_ADDRESS,pe.STOCKIST_GST_NO,pe.STOCKIST_STATE,TRIM(pe.VISITED_WITH_TEAM) AS VISITED_WITH_TEAM,pe.ITEM_SER AS ITEM_SER  ,PE.STATION_TYPE AS STATION_TYPE , "
											+ "PE.STATION_DESCR AS STATION_DESCR,PE.ROUTE_TYPE AS ROUTE_TYPE, PE.PLAN_DAYS  FROM TABLE(localityCodePophelp.getlocalityPophelpData(?)) pe where pe.PLAN_DAYS LIKE '%"+weekDayString+"%' order by DESCR";
									pstmt = connectionObject.prepareStatement(localityData);
									pstmt.setString(1, userId);
									rs = pstmt.executeQuery();
					                while(rs.next())
									{
					                	itr++;
					                	if(routeDescr==null || routeDescr.trim().length()==0)
					                	{
					                		routeDescr=checkNull(rs.getString("DESCR"));
					                	}
					                	else 
					                	{
					                		routeDescr=routeDescr+","+checkNull(rs.getString("DESCR"));
					                	}
					                	//System.out.println("routeId:"+routeId+" routeDescr:"+routeDescr);
					                	if(routeId==null || routeId.trim().length()==0)
					                	{
					                		routeId = checkNull(rs.getString("ROUTE_ID"));
					                		invoiceNo = checkNull(rs.getString("INVOICE_NO"));
					                		int custCount=0,meetCount=0;
					                        String customerSql = "SELECT count(pe.strg_code) AS COUNT FROM TABLE(strgCodePophelp.getstrgCodePophelpData(?)) pe where pe.route_id = ? ";
											
					                        pstmt1 = connectionObject.prepareStatement(customerSql);
					                        pstmt1.setString(1, userId);
					                        pstmt1.setString(2, routeId);
											
											rs2 = pstmt1.executeQuery();
											if(rs2.next())
											{
												custCount=rs2.getInt("COUNT");
											}
											if(rs2 != null)
											{
												rs2.close();
												rs2 = null;
											}
											if(pstmt1 != null)
											{
												pstmt1.close();
												pstmt1 = null;
								            }
											String visitedCust = "select COUNT(STRG_CODE) AS COUNT from strg_meet where  sales_pers = ? and event_date = ? AND route_id = ? ";
											
					                        pstmt1 = connectionObject.prepareStatement(visitedCust);
					                        pstmt1.setString(1, userId);
					                        pstmt1.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					        				pstmt1.setString(3, routeId);
											
											rs2 = pstmt1.executeQuery();
											if(rs2.next())
											{
												meetCount=rs2.getInt("COUNT");
											}
											if(rs2 != null)
											{
												rs2.close();
												rs2 = null;
											}
											if(pstmt1 != null)
											{
												pstmt1.close();
												pstmt1 = null;
								            }
											//System.out.println("meetCount::"+meetCount+"custCount:"+custCount);
											if(meetCount<custCount)
											{
												localityDescr1=checkNull(rs.getString("DESCR"));
												localityCode1=checkNull(rs.getString("LOCALITY_CODE"));
												stockistCode=checkNull(rs.getString("STOCKIST_CODE"));
												stockistAdd=checkNull(rs.getString("STOCKIST_ADDRESS"));
												stockistGstno=checkNull(rs.getString("STOCKIST_GST_NO"));
												stockistName=checkNull(rs.getString("STOCKIST_NAME"));
												stockistState=checkNull(rs.getString("STOCKIST_STATE"));
												itemSer1=checkNull(rs.getString("ITEM_SER"));
												stationType=checkNull(rs.getString("STATION_TYPE"));
												stationDescr=checkNull(rs.getString("STATION_DESCR"));
												routeType=checkNull(rs.getString("ROUTE_TYPE"));
												
											}
											else if(meetCount==custCount)
											{
												//System.out.println("meet equal  itr:"+itr+" planCount:"+planCount);
												if(itr==planCount)
												{
													localityDescr1=checkNull(rs.getString("DESCR"));
													localityCode1=checkNull(rs.getString("LOCALITY_CODE"));
													stockistCode=checkNull(rs.getString("STOCKIST_CODE"));
													stockistAdd=checkNull(rs.getString("STOCKIST_ADDRESS"));
													stockistGstno=checkNull(rs.getString("STOCKIST_GST_NO"));
													stockistName=checkNull(rs.getString("STOCKIST_NAME"));
													stockistState=checkNull(rs.getString("STOCKIST_STATE"));
													itemSer1=checkNull(rs.getString("ITEM_SER"));
													stationType=checkNull(rs.getString("STATION_TYPE"));
													stationDescr=checkNull(rs.getString("STATION_DESCR"));
													routeType=checkNull(rs.getString("ROUTE_TYPE"));
												}
												else
												{
													routeId="";
												} 
											}
					                	}	
									}
					                if(rs != null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
						            }
								  
								} 	
							}
							//end planned beat
							
							
							//System.out.println("inside if["+strgCode+"]");
							valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
							valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[start]
							if(allwdPrd > 0)
							{
								valueXmlString.append( "<event_date protect = '0' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}
							else
							{
								valueXmlString.append( "<event_date protect = '1' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}
							//valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[end]
							//added & commented by mrunalini sinkar for default activity (start)
							/*valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append("Y").append( "]]></place_required>\r\n" ); // added by mrunalini sinkar for place required changes()*/
							valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" );
							valueXmlString.append( "<activity_place><![CDATA[" ).append(actPlace).append( "]]></activity_place>\r\n" );//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
							//added & commented by mrunalini sinkar for default activity (end)
							//	valueXmlString.append( "<cust_type><![CDATA[" ).append("").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for showing default value in cust_type
							valueXmlString.append( "<cust_type><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for showing default value in cust_type
							valueXmlString.append( "<type_cust><![CDATA[" ).append("L").append( "]]></type_cust>\r\n" );
							valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );
							valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<oth_participant><![CDATA[" ).append( othParticipant).append( "]]></oth_participant>\r\n" );//Added by sagar m.on 17.1.19[for work with other set current value].
							valueXmlString.append( "<sku_value><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
							//Added by Bhagyashri T For Item_default set all values of invoice lbcp[Start][17-10-22]
							valueXmlString.append( "<net_amt><![CDATA[" ).append("0").append( "]]></net_amt>\r\n" );
							valueXmlString.append( "<tax_amount><![CDATA[" ).append("0").append( "]]></tax_amount>\r\n" );
							valueXmlString.append( "<amount><![CDATA[" ).append("0").append( "]]></amount>\r\n" );
							valueXmlString.append("<basic_value><![CDATA[" ).append( "Basic:0" ).append( "]]></basic_value>\r\n" );
							valueXmlString.append("<total_gst><![CDATA[" ).append( "GST:0" ).append( "]]></total_gst>\r\n" );
							valueXmlString.append("<total_value><![CDATA[" ).append( "Total Amount:0" ).append( "]]></total_value>\r\n" );
							//Added by Bhagyashri T for details showing on summary
							valueXmlString.append( "<load_no><![CDATA[" ).append(loadNo).append( "]]></load_no>\r\n" );
							valueXmlString.append( "<vehicle_no><![CDATA[" ).append(vehicleNo).append( "]]></vehicle_no>\r\n" ); 
							valueXmlString.append( "<invoice_amount><![CDATA[" ).append("0").append( "]]></invoice_amount>\r\n" ); 
							valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append("0").append( "]]></total_sgst_amt>\r\n" ); 
							valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append("0").append( "]]></total_cgst_amt>\r\n" ); 
							//Added by Bhagyashri T For Item_default set all values of invoice lbcp[End][17-10-22]
							valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
							valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
							valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
							valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
							// commented by rupali on 23/05/18 for getting locality code of customer [start]
							/*valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );*/
							// commented by rupali on 23/05/18 for getting locality code of customer [end]
							//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
							//valueXmlString.append( "<call_outcome protect = '0'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
							valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
							valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
							valueXmlString.append( "<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
							valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
							// added by rupali on 01/12/17 for hiding unnecessary fields [start]
							valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
							valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
							valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
							valueXmlString.append( "<age protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
							valueXmlString.append( "<qualification protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
							valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
							// added by rupali on 01/12/17 for hiding unnecessary fields [end]
							// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
							/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end><![CDATA[").append(startTime).append( "]]></event_time_end>\r\n" );*/
							// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
							valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
							valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
							valueXmlString.append("<is_member_present><![CDATA[" ).append(checkNull(isMemberPresnt)).append( "]]></is_member_present>\r\n" ); 

							//added by prachi k on 15-nov-22 for planned beat online changes
							if("Y".equalsIgnoreCase(planDayRoute) && planCount>0)
							{
								valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
								valueXmlString.append( "<stockist_code><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
								valueXmlString.append( "<stockist_address><![CDATA[" ).append(stockistAdd).append( "]]></stockist_address>\r\n" );
								valueXmlString.append( "<stockist_gst_no><![CDATA[" ).append(stockistGstno).append( "]]></stockist_gst_no>\r\n" );
								valueXmlString.append( "<stockist_state><![CDATA[" ).append(stockistState).append( "]]></stockist_state>\r\n" );
								valueXmlString.append( "<item_ser><![CDATA[" ).append(itemSer1).append( "]]></item_ser>\r\n" );
								valueXmlString.append( "<station_type><![CDATA[" ).append(stationType).append( "]]></station_type>\r\n" );
								valueXmlString.append( "<station_descr><![CDATA[" ).append(stationDescr).append( "]]></station_descr>\r\n" );
								valueXmlString.append( "<route_type><![CDATA[" ).append(routeType).append( "]]></route_type>\r\n" );
								valueXmlString.append( "<route_id><![CDATA[" ).append(routeId).append( "]]></route_id>\r\n" );
								valueXmlString.append( "<invoice_no><![CDATA[" ).append(invoiceNo).append( "]]></invoice_no>\r\n" );
								valueXmlString.append( "<beat_plan><![CDATA[" ).append(routeDescr).append( "]]></beat_plan>\r\n" );
								valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append(localityCode1).append( "]]></locality_code>\r\n" );
								valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append(localityDescr1).append( "]]></locality_descr>\r\n" );
							}
							else
							{
								// added by rupali on 23/05/18 for getting locality code of customer [start]
								String locCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);
								String locDescr = "";
								if(locCode == null || locCode.trim().length() == 0)
								{
									strgCode = genericUtility.getColumnValue("strg_code", dom2, doctorFormNo);
									sql = "SELECT LC.LOCALITY_CODE AS LOCALITY_CODE,LC.DESCR AS DESCR FROM LOCALITY LC, STRG_CUSTOMER SC WHERE LC.LOCALITY_CODE = SC.LOCALITY_CODE AND SC.SC_CODE = ?";
									pstmt =  connectionObject.prepareStatement(sql);
									pstmt.setString(1, strgCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										locCode = rs.getString("LOCALITY_CODE");
										locDescr = rs.getString("DESCR");
										//System.out.println("localoty code =["+locCode+"] locality descr =["+locDescr+"]");
									}
									if (rs!= null)
									{
										rs.close();
										rs = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}

									valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append( locCode ).append( "]]></locality_code>\r\n" );
									valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( locDescr ).append( "]]></locality_descr>\r\n" );
								}
								// added by rupali on 23/05/18 for getting locality code of customer [end]
								
								// added by rupali on 27/10/17 for displaying preffered stockist field [start]
								valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
								valueXmlString.append( "<stockist_code><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							}
							// added by rupali on 23/05/18 for getting locality code of customer [end]
							valueXmlString.append( "<visited_with><![CDATA[" ).append(visitedWith).append( "]]></visited_with>\r\n" ); // added by rupali on 04/12/18 to set nearest manager in visited with field
							
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							if(isFortuneActivity.trim().equalsIgnoreCase("Y")) 
							{
								if(allowChgTime.trim().equalsIgnoreCase("Y"))
								{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								}
								else if(allowChgTime.trim().equalsIgnoreCase("N"))
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
									
								}								
								else
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
									
								}
								valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							}
							else
							{
							valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							}
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( allwdPrd ).append( "]]></allwd_delay_prd>\r\n" );
							valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
							valueXmlString.append( "<invoice_form_no><![CDATA[" ).append( invoice ).append( "]]></invoice_form_no>\r\n" );
							valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
							valueXmlString.append( "<collection_form_no><![CDATA[" ).append( collectFormNo ).append( "]]></collection_form_no>\r\n" );
							//added by prachi on 09-AUG-22 [W22EBAS005]
							valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
							valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
							valueXmlString.append( "<grade_code><![CDATA[" ).append( grade ).append( "]]></grade_code>\r\n" );
							valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displayTimeField ).append( "]]></display_time_fld>\r\n" );//addednby shraddha M[20/07/2020]
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
							valueXmlString.append( "</Detail1>\r\n" );
							//System.out.println("itemdefault called....");
						}
						else
						{
							//System.out.println("inside else in realtime["+strgCode+"]");
							String salesPersCode = userId;
							String travelDate = currDate;
							String eventType = defACt;
							strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2));
							String localityCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);

							valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
							valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[start]
							if(allwdPrd > 0)
							{
								valueXmlString.append( "<event_date protect = '0' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}
							else
							{
								valueXmlString.append( "<event_date protect = '1' ><![CDATA[" ).append( currentDate ).append( "]]></event_date>\r\n" );
							}

							//valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
							//added by mrunalini sinkar for protect event date & set current date for CHC client on 07-01-2018[end]
							//added & commented by mrunalini sinkar for default activity (start)
							/*valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append("Y").append( "]]></place_required>\r\n" ); // added by mrunalini sinkar for place required changes()*/
							valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" );
							valueXmlString.append( "<activity_place><![CDATA[" ).append(actPlace).append( "]]></activity_place>\r\n" );//Added by Bhagyashri T for Activity place[W21DSUN098][26/JUL/21]
							//added & commented by mrunalini sinkar for default activity (end)
							valueXmlString.append( "<sku_value><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
							//Added by Bhagyashri T For Item_default set all values of invoice lbcp[Start][17-10-22]
							valueXmlString.append( "<amount><![CDATA[" ).append("0").append( "]]></amount>\r\n" ); 
							valueXmlString.append( "<net_amt><![CDATA[" ).append("0").append( "]]></net_amt>\r\n" ); 
							valueXmlString.append( "<tax_amount><![CDATA[" ).append("0").append( "]]></tax_amount>\r\n" ); 
							valueXmlString.append( "<invoice_amount><![CDATA[" ).append("0").append( "]]></invoice_amount>\r\n" ); 
							valueXmlString.append( "<total_sgst_amt><![CDATA[" ).append("0").append( "]]></total_sgst_amt>\r\n" ); 
							valueXmlString.append( "<total_cgst_amt><![CDATA[" ).append("0").append( "]]></total_cgst_amt>\r\n" );
							valueXmlString.append("<basic_value><![CDATA[" ).append( "Basic:0" ).append( "]]></basic_value>\r\n" );
							valueXmlString.append("<total_gst><![CDATA[" ).append( "GST:0" ).append( "]]></total_gst>\r\n" );
							valueXmlString.append("<total_value><![CDATA[" ).append( "Total Amount:0" ).append( "]]></total_value>\r\n" );
							//Added by Bhagyashri T for details showing on summary
							valueXmlString.append( "<load_no><![CDATA[" ).append(loadNo).append( "]]></load_no>\r\n" );
							valueXmlString.append( "<vehicle_no><![CDATA[" ).append(vehicleNo).append( "]]></vehicle_no>\r\n" ); 
							//Added by Bhagyashri T For Item_default set all values of invoice lbcp[End][17-10-22]
							valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<stan_code__hq><![CDATA[" ).append(stanCodeHQ).append( "]]></stan_code__hq>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<headquarter><![CDATA[" ).append(headQaurter).append( "]]></headquarter>\r\n" );//Added by mrunalini sinkar to showing headquarter in summary page
							valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );
							
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
							if(isFortuneActivity.trim().equalsIgnoreCase("Y")) 
							{
								if(allowChgTime.trim().equalsIgnoreCase("Y"))
								{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								
								}
								else if(allowChgTime.trim().equalsIgnoreCase("N"))
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );									
								}								
								else
								{
									valueXmlString.append("<event_time_start protect = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
									valueXmlString.append("<event_time_end protect = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
									
								}
								valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							}
							else
							{
							valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							}
							// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
							
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></visit_time_from>\r\n" );//added by shraddha M[20/07/2020]
							valueXmlString.append("<is_member_present><![CDATA[" ).append(checkNull(isMemberPresnt)).append( "]]></is_member_present>\r\n" ); 
							int planCount=0;
							String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
							if(travelDate != null && travelDate.trim().length() > 0)
							{
								if("Y".equalsIgnoreCase(isPlanCumpulsory))
								{
									String planSql="select count(*) AS COUNT from SPRS_PLAN_HDR sph,SPRS_PLAN_cust planCust where sph.plan_date=? and sph.SPRS_CODE__PLAN=? and planCust.sc_code=? and planCust.locality_code=? and sph.plan_id=planCust.plan_id and sph.confirm='Y'";
									PreparedStatement planPstmt =  connectionObject.prepareStatement(planSql);
									planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( travelDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
									planPstmt.setString(2, checkNull(salesPersCode));
									planPstmt.setString(3, checkNull(strgCode));
									planPstmt.setString(4, checkNull(localityCode));

									ResultSet planRs = planPstmt.executeQuery();
									if(planRs.next())
									{
										planCount = planRs.getInt("COUNT");
									}
									if(planRs != null)
									{
										planRs.close();
										planRs = null;
									}
									if(planPstmt != null)
									{
										planPstmt.close();
										planPstmt = null;
									}
								}
							}
							//sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME, SC.CUST_TYPE, SC.LOCALITY_CODE, SC.ADDRESS_AS, SC.SEX, SC.ADDR1, SC.ADDR2, SC.ADDR3, SS.CLASS_CODE, SS.SPL_CODE, S.DESCR AS SPPECIALITY, SC.EMAIL_ADDR,SC.MOBILE_NO, LC.DESCR FROM STRG_CUSTOMER SC LEFT OUTER JOIN  STRG_SERIES SS ON SC.SC_CODE = SS.SC_CODE LEFT OUTER JOIN SPECIALITY S ON SS.SPL_CODE = S.SPL_CODE, LOCALITY LC WHERE SC.LOCALITY_CODE = LC.LOCALITY_CODE AND SC.SC_CODE= ? ";
							String routIdP="";//Added by Bhagyashri T to set Visited with issue[03-FEB-23]
							String sfaParmVal  = checkNull(getSfaParmValue(salesPers,"CHC_SURVEY",connectionObject));

							sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME, SC.CUST_TYPE, SC.LOCALITY_CODE, SC.ADDRESS_AS,(CASE WHEN SCT.SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SCT.SURVEY_TEMPL END) AS SURVEY_TEMPL, "
									+ "SC.SEX, SC.ADDR1, SC.ADDR2, SC.ADDR3, SS.CLASS_CODE, SS.SPL_CODE, S.DESCR AS SPPECIALITY, SC.EMAIL_ADDR,SC.MOBILE_NO, "
									+ "SS.ROUTE_ID, (CASE WHEN SR.ROUTE_DESCR IS NOT NULL THEN SR.ROUTE_DESCR ELSE SR.DESCR END) AS DESCR,SS.NO_VISIT "
									+ "FROM STRG_CUSTOMER SC LEFT OUTER JOIN  STRG_SERIES SS ON SC.SC_CODE = SS.SC_CODE "
									+ "LEFT OUTER JOIN SPRS_ROUTE SR ON SS.ROUTE_ID = SR.ROUTE_ID AND SR.SPRS_CODE = SS.SALES_PERS "
									+ "LEFT OUTER JOIN SPECIALITY S ON SS.SPL_CODE = S.SPL_CODE LEFT OUTER JOIN STRG_CUST_TYPE SCT ON SC.CUST_TYPE=SCT.TYPE, LOCALITY LC WHERE SR.LOCALITY_CODE = LC.LOCALITY_CODE AND SC.SC_CODE= ? AND SPRS_CODE = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1,strgCode);
							pstmt.setString(2,userId);  
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								String customerType = checkNull(rs.getString("CUST_TYPE"));
								routIdP = checkNull(rs.getString("ROUTE_ID"));////Added by Bhagyashri T to set Visited with issue[03-FEB-23]
								int visit=0;
								visit = orderOfVisit(travelDate,salesPersCode,localityCode ,connectionObject);
								valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("STRG_NAME"))).append( "]]></strg_name>\r\n" );
								valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
								valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" );
								valueXmlString.append( "<type_cust><![CDATA[" ).append("L").append( "]]></type_cust>\r\n" );
								valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("CUST_TYPE"))).append( "]]></strg_type>\r\n" );
								valueXmlString.append("<locality_code protect='0'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );
								valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR")) ).append( "]]></locality_descr>\r\n" );
								valueXmlString.append("<address_as protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
								valueXmlString.append("<gender protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("SEX")) ).append( "]]></gender>\r\n" );
								valueXmlString.append("<addr1 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
								valueXmlString.append("<addr2 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
								valueXmlString.append("<addr3 protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
								valueXmlString.append("<age protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
								valueXmlString.append( "<qualification protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
								valueXmlString.append("<email_addr protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
								valueXmlString.append("<mobile_no protect = '1' visible = '0'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
								valueXmlString.append("<order_of_visit><![CDATA[" ).append(visit).append( "]]></order_of_visit>\r\n" );
								valueXmlString.append("<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></strg_no_visit>\r\n" );
								valueXmlString.append("<survey_templ><![CDATA[").append(checkNull(rs.getString("SURVEY_TEMPL"))).append("]]></survey_templ>\r\n");

								valueXmlString.append("<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("CLASS_CODE")).append( "]]></strg_class_code>\r\n" );
								/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
								if("D".equalsIgnoreCase(customerType) )
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("DOCTOR").append( "]]></sh_descr>\r\n" );
								}
								else if("C".equalsIgnoreCase(customerType) || "R".equalsIgnoreCase(customerType) )
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("CHEMIST").append( "]]></sh_descr>\r\n" );
								}
								else if("S".equalsIgnoreCase(customerType) )
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("STOCKIST").append( "]]></sh_descr>\r\n" );
								}
								else
								{
									valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("LISTED").append( "]]></sh_descr>\r\n" );
								}
								/*if(customerType.equals("D"))
								{
									valueXmlString.append("<spl_code protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPL_CODE")).append( "]]></spl_code>\r\n" );
									valueXmlString.append("<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPPECIALITY")).append( "]]></speciality_descr>\r\n" );
								}
								else
								{
									valueXmlString.append("<spl_code protect = '1' visible = '0'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
									valueXmlString.append("<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );

								}*/
								valueXmlString.append("<spl_code protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPL_CODE")).append( "]]></spl_code>\r\n" );
								valueXmlString.append("<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append(rs.getString("SPPECIALITY")).append( "]]></speciality_descr>\r\n" );
								valueXmlString.append("<route_id><![CDATA[" ).append(rs.getString("ROUTE_ID")).append( "]]></route_id>\r\n" );
								
								}
							else
							{
								valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
								valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
								valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append("").append( "]]></strg_type>\r\n" );
								valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("").append( "]]></cust_type>\r\n" );
								valueXmlString.append("<locality_code><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
								valueXmlString.append("<locality_descr><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
								valueXmlString.append("<address_as protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
								valueXmlString.append("<gender protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
								valueXmlString.append("<addr1 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
								valueXmlString.append("<addr2 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
								valueXmlString.append("<addr3 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
								valueXmlString.append("<age protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
								valueXmlString.append( "<qualification protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
								valueXmlString.append("<email_addr protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
								valueXmlString.append("<mobile_no protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
								valueXmlString.append("<strg_class_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
								valueXmlString.append("<spl_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
								valueXmlString.append("<speciality_descr protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
								/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							/*if( eventType != null && eventType.trim().length() != 0 )
							{
								valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(checkNull(eventType)).append( "]]></event_type>\r\n" );
							}
							else
							{
								valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
								valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
								valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
							}*/
							if("Y".equalsIgnoreCase(isPlanCumpulsory) && planCount>0)
							{
								valueXmlString.append( "<copy_plan protect='0'><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
							}
							else
							{
								valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
							}
							valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></visited_with_team>\r\n" );
							valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );
							//Added by Bhagyashri T to set Visited with issue[03-FEB-23][start]
							if(mgrCode.trim().length()!= 0)
							{
								if(visitedWith == null || visitedWith.trim().length()<=0)
								{
									int cntNo=0;
									sql = "SELECT COUNT(*) AS CNT FROM STRG_SERIES WHERE SALES_PERS=? AND ROUTE_ID=? AND SC_CODE=?";
										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, userId); 
										pstmt.setString(2, routIdP);
										pstmt.setString(3, strgCode);
										rs = pstmt.executeQuery();
										if(rs.next())
										{
											cntNo = rs.getInt("CNT");
										}
										if (rs!= null)
										{
											rs.close();
											rs = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
										//System.out.println("Check count is as:: "+cntNo);
										if( cntNo > 0)
										{
											//System.out.println("Inside count is gereter Than 0");
											String vstWithDesCode="";
											sql = "SELECT EMP.design_code AS VISITED_WITH_DESIGN_CODE FROM EMPLOYEE emp WHERE EMP.EMP_CODE=?";
											pstmt = connectionObject.prepareStatement(sql);
											pstmt.setString(1, userId);
											rs = pstmt.executeQuery();
											if(rs.next())
											{
												vstWithDesCode=checkNull(rs.getString("VISITED_WITH_DESIGN_CODE"));
											}
											if (rs!= null)
											{
												rs.close();
												rs = null;
											}
											if(pstmt!=null)
											{
												pstmt.close();
												pstmt = null;
											}
											valueXmlString.append( "<grade_type><![CDATA[" ).append("M").append( "]]></grade_type>\r\n" );
											valueXmlString.append( "<VISITED_WITH_DESIGN_CODE><![CDATA[" ).append(vstWithDesCode).append( "]]></VISITED_WITH_DESIGN_CODE>\r\n" );
											valueXmlString.append( "<SPRS_CODE__WW><![CDATA[" ).append(userId).append( "]]></SPRS_CODE__WW>\r\n" );
											valueXmlString.append( "<VISITED_WITH_CODE><![CDATA[" ).append(userId).append( "]]></VISITED_WITH_CODE>\r\n" );
											valueXmlString.append( "<visited_with><![CDATA[" ).append("SELF").append( "]]></visited_with>\r\n" );
											
										}
										else
										{
											valueXmlString.append( "<visited_with><![CDATA[" ).append("").append( "]]></visited_with>\r\n" );
										}
										
								}
								else
								{
									valueXmlString.append( "<visited_with><![CDATA[" ).append(visitedWith).append( "]]></visited_with>\r\n" ); // added by rupali on 04/12/18 to set nearest manager in visited with field
								
								}
							}
							else
							{
								valueXmlString.append( "<visited_with><![CDATA[" ).append(visitedWith).append( "]]></visited_with>\r\n" ); // added by rupali on 04/12/18 to set nearest manager in visited with field
							
							}
							//Added by Bhagyashri T to set Visited with issue[03-FEB-23][end]
							valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( allwdPrd ).append( "]]></allwd_delay_prd>\r\n" );
							valueXmlString.append( "<order_form_no><![CDATA[" ).append( sampleOrder ).append( "]]></order_form_no>\r\n" );
							valueXmlString.append( "<invoice_form_no><![CDATA[" ).append( invoice ).append( "]]></invoice_form_no>\r\n" );
							valueXmlString.append( "<team_form_no><![CDATA[" ).append( doctorTeam ).append( "]]></team_form_no>\r\n" );
							valueXmlString.append( "<collection_form_no><![CDATA[" ).append( collectFormNo ).append( "]]></collection_form_no>\r\n" );
							//added by prachi on 09-AUG-22 [W22EBAS005]
							valueXmlString.append(" <host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
							valueXmlString.append( "<emp_design><![CDATA[" ).append( empDesign ).append( "]]></emp_design>\r\n" );
							valueXmlString.append( "<grade_code><![CDATA[" ).append( grade ).append( "]]></grade_code>\r\n" );
							valueXmlString.append( "<display_time_fld><![CDATA[" ).append( displayTimeField ).append( "]]></display_time_fld>\r\n" );//addednby shraddha M[20/07/2020]

							//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
							valueXmlString.append( "</Detail"+objContext+">\r\n" );

						}
						// added by rupali on 26/07/18 to open realtime report from series master [end]
						//commented by rupali on 26/07/18 to open realtime report from series master [start]
						/*valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
						valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
						//	valueXmlString.append( "<cust_type><![CDATA[" ).append("").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for showing default value in cust_type
						valueXmlString.append( "<cust_type><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for showing default value in cust_type
						valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );

						valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						// commented by rupali on 23/05/18 for getting locality code of customer [start]
						valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						// commented by rupali on 23/05/18 for getting locality code of customer [end]
						//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
						//valueXmlString.append( "<call_outcome protect = '0'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
						//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
						valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append( "<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
						// added by rupali on 01/12/17 for hiding unnecessary fields [start]
						valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						// added by rupali on 01/12/17 for hiding unnecessary fields [end]
						// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
						valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(startTime).append( "]]></event_time_end>\r\n" );
						// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
						valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
						valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
						// added by rupali on 23/05/18 for getting locality code of customer [start]
						String locCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);
						String locDescr = "";
						if(locCode == null || locCode.trim().length() == 0)
						{
							strgCode = genericUtility.getColumnValue("strg_code", dom2, doctorFormNo);
							sql = "SELECT LC.LOCALITY_CODE AS LOCALITY_CODE,LC.DESCR AS DESCR FROM LOCALITY LC, STRG_CUSTOMER SC WHERE LC.LOCALITY_CODE = SC.LOCALITY_CODE AND SC.SC_CODE = ?";
							pstmt =  connectionObject.prepareStatement(sql);
							pstmt.setString(1, strgCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								locCode = rs.getString("LOCALITY_CODE");
								locDescr = rs.getString("DESCR");
								System.out.println("localoty code =["+locCode+"] locality descr =["+locDescr+"]");
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append( locCode ).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( locDescr ).append( "]]></locality_descr>\r\n" );
						}
						// added by rupali on 23/05/18 for getting locality code of customer [end]
						valueXmlString.append( "</Detail1>\r\n" );
						System.out.println("itemdefault called....");*/
						//commented by rupali on 26/07/18 to open realtime report from series master [end]
					}
					// added by rupali on 23/02/18 for edit mode of realtime report [end]

					// commented by rupali on 23/02/18 for edit mode of realtime report [start]
					/*valueXmlString.append( "<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
					valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<event_date><![CDATA[" ).append( currDate ).append( "]]></event_date>\r\n" );
					valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append("FW").append( "]]></event_type>\r\n" );
					valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append("WHOLE DAY FIELD WORK").append( "]]></activity_descr>\r\n" );
					valueXmlString.append( "<activity_type><![CDATA[" ).append("FW").append( "]]></activity_type>\r\n" );
					//	valueXmlString.append( "<cust_type><![CDATA[" ).append("").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for showing default value in cust_type
					valueXmlString.append( "<cust_type><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for showing default value in cust_type
					valueXmlString.append( "<chg_date protect = '1'><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user protect = '1'><![CDATA[" ).append(empcode).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term protect = '1'><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
					valueXmlString.append( "<sales_pers protect = '1'><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
					valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(spName).append( "]]></sales_pers_sp_name>\r\n" );

					valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
					valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
					valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
					valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
					valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
					valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
					//commented by vishal pathare on 25.10.17 for[initial value should apply (Default Call outcome should be believer)].
					//valueXmlString.append( "<call_outcome protect = '0'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
					//valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
					valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
					valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
					valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
					valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
					valueXmlString.append( "<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
					valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
					// added by rupali on 27/10/17 for displaying preffered stockist field [start]
					valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
					valueXmlString.append( "<stockist_code><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
					// added by rupali on 27/10/17 for displaying preffered stockist field [end]
					// added by rupali on 01/12/17 for hiding unnecessary fields [start]
					valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
					valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
					valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
					valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
					valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
					// added by rupali on 01/12/17 for hiding unnecessary fields [end]
					// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
					valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
					valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
					// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
					valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
					valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );

					valueXmlString.append( "</Detail"+objContext+">\r\n" );
					System.out.println("itemdefault called....");*/
					// commented by rupali on 23/02/18 for edit mode of realtime report [start]

				}
				else if( currentColumn.equalsIgnoreCase( "event_date" ))
				{
					String eventType="";
					//System.out.println("Itemchanged on event_date .....");
					dcrDate = checkNull(genericUtility.getColumnValue("event_date", dom2 ));
					salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom2 ));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2 ));
					String localityCode=checkNull(genericUtility.getColumnValue("locality_code", dom2 ));
					String custDateType=checkNull(genericUtility.getColumnValue("cust_type", dom2 ));
					eventType = checkNull(genericUtility.getColumnValue("event_type", dom2)); // Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]

					//strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2 ));
					//strgNameDom = checkNull(genericUtility.getColumnValue("strg_name", dom2 ));


					/*					if( (dcrDate != null && dcrDate.trim().length() > 0)  && (strgType != null && strgType.trim().length() > 0)
							&& (strgNameDom != null && strgNameDom.trim().length() > 0) && (strgCode != null && strgCode.trim().length() > 0))
					{
					 */						/*System.out.println("Called Itemchanged on event_date ::::: editFlag"+editFlag);


						System.out.println( " dcrDate dcrDate [" + dcrDate + "]" );
						eventDate=dcrDate;
						System.out.println( " eventDate dcrDate [" + eventDate + "]" );*/

					/*if("U".equalsIgnoreCase(strgType))
						{
							strgType = "L";
						}
						else if ("V".equalsIgnoreCase(strgType))
						{
							strgType = "F";
						}*/
					//added by mrunalini sinkar on 19-jan-2018 prescription report changes (start)
					if(dcrDate != null && dcrDate.trim().length() > 0)
					{
						int count=0;
						String isPrExist = "N";

						//Added by sagar m.on 17.1.19[for work with other set current value].start
						String othParticipant="";
						String othPartisql= " SELECT OTH_PARTICIPANT,EVENT_TIME_START FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE =  ? "+
								        "AND TO_CHAR(TO_DATE (EVENT_TIME_START, 'HH:MI AM'),'HH24:MI:SS') = (SELECT MAX(TO_CHAR(TO_DATE (EVENT_TIME_START, 'HH:MI AM'),'HH24:MI:SS')) "+
										"FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?) ";
						PreparedStatement othprPstmt = connectionObject.prepareStatement(othPartisql);
						othprPstmt.setString(1,userId);
						othprPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						othprPstmt.setString(3,userId);
						othprPstmt.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						ResultSet othprRs = othprPstmt.executeQuery();
						if(othprRs.next())
						{
							othParticipant = checkNull(othprRs.getString("OTH_PARTICIPANT"));
						}
						if(othprRs != null)
						{
							othprRs.close();
							othprRs = null;
						}
						if(othprPstmt != null)
						{
							othprPstmt.close();
							othprPstmt = null;
						}
						//Added by sagar m.on 17.1.19[for work with other set current value].end
						
						String countPrSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.SALES_PERS = ? AND A.EVENT_DATE = ? AND B.ACTIVITY_TYPE='PR'";
						PreparedStatement prPstmt = connectionObject.prepareStatement(countPrSql);
						prPstmt.setString(1,userId);
						prPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
						ResultSet prRs = prPstmt.executeQuery();
						if(prRs.next())
						{
							count = prRs.getInt("COUNT");
						}
						if(prRs != null)
						{
							prRs.close();
							prRs = null;
						}
						if(prPstmt != null)
						{
							prPstmt.close();
							prPstmt = null;
						}
						if(count > 0)
						{
							isPrExist = "Y";
						}
						//added by mrunalini sinkar on 19-jan-2018 prescription report changes (end)

						//added by mrunalini sinkar on 19-jan-2018 for adding copy plan changes report changes (start)

						int planCount=0;
						String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);

						if("Y".equalsIgnoreCase(isPlanCumpulsory))
						{
							String planSql="select count(*) AS COUNT from SPRS_PLAN_HDR sph,SPRS_PLAN_cust planCust where sph.plan_date=? and sph.SPRS_CODE__PLAN=? and planCust.sc_code=? and planCust.locality_code=? and sph.plan_id=planCust.plan_id and sph.confirm='Y'";
							PreparedStatement planPstmt =  connectionObject.prepareStatement(planSql);
							planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							planPstmt.setString(2, checkNull(salesPers));
							planPstmt.setString(3, checkNull(strgCode));
							planPstmt.setString(4, checkNull(localityCode));
							ResultSet planRs = planPstmt.executeQuery();
							if(planRs.next())
							{
								planCount = planRs.getInt("COUNT");
							}
							if(planRs != null)
							{
								planRs.close();
								planRs = null;
							}
							if(planPstmt != null)
							{
								planPstmt.close();
								planPstmt = null;
							}
						}
						//added by mrunalini sinkar on 19-jan-2018 for adding copy plan changes report changes (end)

						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
						String allowChgTime="";
						String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
						pstmt.setString(1, eventType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
						
						valueXmlString.append("<Detail"+objContext+ " domID='1' formName='"+formName+"'>\r\n" );
						/*System.out.println("strgType :::>>>>>>>["+strgType+"]");
						String locality = checkNull(genericUtility.getColumnValue("locality", dom2));
						sql = " SELECT * FROM DR_UNLIST_VISIT WHERE SALES_PERS = ? AND WORK_DATE = ? AND  CUST_TYPE = ?  ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1,salesPers);
						pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
						pstmt.setString(3,strgType);

						rs = pstmt.executeQuery();
						//System.out.println( " sql sss [" + sql + "]" );
						if(rs.next())
						{
							custType=checkNull(rs.getString("cust_type"));
							salesPers=checkNull(rs.getString("sales_pers"));
							//eventDate=checkNull(rs.getString("work_date").trim());
							clientName=checkNull(rs.getString("client_name"));
							phoneNo=checkNull(rs.getString("mobile_no"));
							address=checkNull(rs.getString("address").trim());
							emailId=checkNull(rs.getString("email_addr").trim());
							visitTimeFr=checkNull(rs.getString("visit_time_fr"));
							visitTimeTo=checkNull(rs.getString("visit_time_to"));
							locality=checkNull(rs.getString("locality_code"));


							localitySql ="SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
							System.out.println( " sql sss locality[" + localitySql + "]" );
							//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
							pStmt1 = connectionObject.prepareStatement(localitySql);
							pStmt1.setString(1, locality);
							rs1 = pStmt1.executeQuery();
							if(rs1.next())
							{
								localityDescr=checkNull(rs1.getString("DESCR"));
							}
							if (rs1 != null)
							{
								rs1.close();
								rs1 = null;
							}
							if (pStmt1 != null)
							{
								pStmt1.close();
								pStmt1 = null;
							}

							if("L".equalsIgnoreCase(custType))
							{
								valueXmlString.append( "<cust_type  protect = '1'><![CDATA[" ).append("U").append( "]]></cust_type>\r\n" );
							}
							else
							{
								valueXmlString.append( "<cust_type protect = '1' ><![CDATA[" ).append("V").append( "]]></cust_type>\r\n" );
							}

							valueXmlString.append( "<strg_code protect = '1' ><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
							valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
							valueXmlString.append( "<event_date protect = '1'><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );

							valueXmlString.append( "<client_name protect = '0'><![CDATA[" ).append(clientName).append( "]]></client_name>\r\n" );
							valueXmlString.append( "<locality protect = '0'><![CDATA[" ).append(locality).append( "]]></locality>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append(localityDescr).append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<mobile_no protect = '0'><![CDATA[" ).append(phoneNo).append( "]]></mobile_no>\r\n" );
							valueXmlString.append( "<email_addr protect = '0'><![CDATA[" ).append(emailId).append( "]]></email_addr>\r\n" );
							valueXmlString.append( "<address protect = '0'><![CDATA[" ).append(address).append( "]]></address>\r\n" );

						}
						else
						{
							//valueXmlString.append("<Detail1 domID='1'>\r\n" );
							//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );

							valueXmlString.append( "<cust_type protect = '1' ><![CDATA[" ).append(strgType).append( "]]></cust_type>\r\n" );
							valueXmlString.append( "<client_name protect = '1'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
							valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
							valueXmlString.append( "<email_addr protect = '1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
							valueXmlString.append( "<mobile_no protect = '1'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
							valueXmlString.append( "<locality protect = '1'><![CDATA[" ).append("").append( "]]></locality>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<event_date protect = '1'><![CDATA[" ).append(eventDate).append( "]]></event_date>\r\n" );

						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}*/
						valueXmlString.append( "<is_pr_exist><![CDATA[" ).append( isPrExist ).append("]]></is_pr_exist>\r\n" );//added by mrunalini sinkar
						if("Y".equalsIgnoreCase(isPlanCumpulsory) && planCount>0)//added by mrunalini sinkar for copy plan
						{
							valueXmlString.append( "<copy_plan protect='0'><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
						}
						else
						{
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						}
						//System.out.println("dcrDate:::::"+dcrDate +"currentDate:::::::"+currentDate);
						String setVisitTime = getSfaParmValue(salesPers,"SET_VISIT_TIME",connectionObject);
						String eventEndTime = getSfaParmValue(salesPers,"HIDE_EVENT_TIME_END",connectionObject);

						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
						/*if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							
						}
						else
						{
							if(!dcrDate.equals(currentDate) && (setVisitTime.trim().length() == 0 || setVisitTime.equalsIgnoreCase("N")))
							{
								if("LISTED".equalsIgnoreCase(custDateType))
								{
									if("Y".equalsIgnoreCase(eventEndTime))
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '0'><![CDATA[]]></event_time_end>\r\n" );
									}
									else
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
									}
								}
								else
								{
									valueXmlString.append("<event_time_start visible = '0'><![CDATA[]]></event_time_start>\r\n");
									valueXmlString.append("<visit_time_from visible = '1'><![CDATA[]]></visit_time_from>\r\n");
									valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
								}

							}
						}*/
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
						
						if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							
						}
						else
						{
							System.out.println("At line no 6003:: dcrDate:"+dcrDate+" currentDate:"+currentDate+" setVisitTime:"+setVisitTime+" custDateType:"+custDateType+" eventEndTime:"+eventEndTime);
							//W22CJOH017 ADDED BY PRACHI
							if(!dcrDate.equals(currentDate) && (setVisitTime.trim().length() == 0 || setVisitTime.equalsIgnoreCase("N")))
							{
								if("LISTED".equalsIgnoreCase(custDateType))
								{
									if("Y".equalsIgnoreCase(eventEndTime))
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '0'><![CDATA[]]></event_time_end>\r\n" );
									}
									else
									{
										valueXmlString.append("<event_time_start visible = '1'><![CDATA[]]></event_time_start>\r\n");
										valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
										valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
									}

								}
								else
								{
									valueXmlString.append("<event_time_start visible = '0'><![CDATA[]]></event_time_start>\r\n");
									valueXmlString.append("<visit_time_from visible = '1'><![CDATA[]]></visit_time_from>\r\n");
									valueXmlString.append("<event_time_end visible = '1'><![CDATA[]]></event_time_end>\r\n" );
								}

							}
							else
							{
								System.out.println("6035:: "+startTime);
								valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");

							}
						}
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
						
						valueXmlString.append( "<oth_participant><![CDATA[" ).append( othParticipant ).append( "]]></oth_participant>\r\n" );//Added by sagar m.on 17.1.19[for work with other set current value].
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					//}
				}
				else if(currentColumn.trim().equalsIgnoreCase( "event_type" ))
				{
					//System.out.println("In side Itemchanged called Activity.......... ");
					String actDescr = "", actType="",placeRequired="";
					String allowChgTime = "";
					String strgTypeD = checkNull(genericUtility.getColumnValue("strg_type", dom2, "1"));
					String custTypeD = checkNull(genericUtility.getColumnValue("cust_type", dom2, "1"));
					//System.out.println("strgTypeD :: ["+strgTypeD+"]custTypeD::["+custTypeD+"]");

					String activityCode = checkNull(genericUtility.getColumnValue("event_type", dom2));
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation]
					String shDescr = checkNull(genericUtility.getColumnValue("sh_descr", dom2));
					//Query Modified by mrunalini sinkar to add the place required on 09-sep-2018
					//sql = " SELECT DESCR, ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					sql = " SELECT DESCR, ACTIVITY_TYPE,PLACE_REQUIRED, ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,activityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						actDescr = checkNull(rs.getString("DESCR"));
						actType = checkNull(rs.getString("ACTIVITY_TYPE"));
						placeRequired = checkNull(rs.getString("PLACE_REQUIRED")); //added by mrunalini sinkar to add the place required on 09-sep-2018
						allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME")); // Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
					}
					//System.out.println("actType =["+actType+"]placeRequired=["+placeRequired+"]");
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					// added by mrunalini sinkar if the activity type is leave and nfw on 30-may-2017 then protect the all fields(start)
					//Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
					//if("LEAVE".equalsIgnoreCase(actType) || "NFW".equalsIgnoreCase(actType))
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation]
					//if(!"FW".equalsIgnoreCase(actType))
					if(!"FW".equalsIgnoreCase(actType) || "CA".equalsIgnoreCase(activityCode) ) //Added & commented by mrunalini sinkar for NFW activity type not found(13-02-2019)
					{
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(checkNull(activityCode)).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(checkNull(actDescr)).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(checkNull(actType)).append( "]]></activity_type>\r\n" );
						//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
						if( "CA".equalsIgnoreCase(activityCode) )
						{
							valueXmlString.append( "<strg_code protect = '1' visible = '0'><![CDATA[" ).append("NA").append( "]]></strg_code>\r\n" );
						}
						else
						{
							valueXmlString.append( "<strg_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						}
						//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
						valueXmlString.append( "<strg_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						valueXmlString.append( "<cust_type protect = '1' visible = '0'><![CDATA[" ).append(checkNull(custTypeD)).append( "]]></cust_type>\r\n" );
						//Chnages by mrunalini sinkar to add the place required on 09-sep-2018
						//added by mrunalini sinkar on 26-june-2018(start)
						//if( "NFW".equalsIgnoreCase(actType))
						if( "Y".equalsIgnoreCase(placeRequired))
						{
							valueXmlString.append( "<locality_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
							if(mgrCode.trim().length()!= 0)
							{
								valueXmlString.append( "<visited_with protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
							}
							else
							{
								valueXmlString.append( "<visited_with protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
							}
						}
						//added by mrunalini sinkar on 26-june-2018(end)
						else
						{
							valueXmlString.append( "<locality_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<visited_with protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
						}
						//added by mrunalini sinkar on 26-june-2018(end)
						valueXmlString.append( "<call_outcome protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						//commented by mrunalini sinkar to set na in case of LEAVE & NFW11 -june-2018(start)
						//valueXmlString.append( "<meet_summ protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<meet_summ protect = '1' visible = '0'><![CDATA[" ).append("---NA---").append( "]]></meet_summ>\r\n" );
						//commented by mrunalini sinkar to set na in case of LEAVE & NFW11 -june-2018(start)
						valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append( "<age protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append( "<qualification protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
						valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append( "<remarks protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<copy_plan protect='1' visible = '0'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						valueXmlString.append( "<oth_participant protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" ); //added by rupali on 18/09/17 for worked with field
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						valueXmlString.append( "<stockist_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
						/*valueXmlString.append("<event_time_start visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end visible = '0'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						valueXmlString.append( "<visited_with_team protect = '1' visible = '0'><![CDATA[" ).append(empcode).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
						valueXmlString.append( "<place_required protect = '1' visible = '0'><![CDATA[" ).append(placeRequired).append( "]]></place_required>\r\n" ); //added by mrunalini sinkar to add the place required on 09-sep-2018
						if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

							
						}
						
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					else
					{
						
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(checkNull(actDescr)).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<event_type protect = '0'><![CDATA[" ).append(checkNull(activityCode)).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(checkNull(actType)).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<strg_name protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append( "<address_as protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append( "<gender protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						valueXmlString.append( "<cust_type protect = '0' visible = '1'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" );
						valueXmlString.append( "<locality_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<call_outcome protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						valueXmlString.append( "<meet_summ protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<addr1 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append( "<age protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append( "<qualification protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
						
						//valueXmlString.append( "<mobile_no protect = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						//valueXmlString.append( "<email_addr protect = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<spl_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append( "<remarks protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<strg_class_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						valueXmlString.append( "<visited_with protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></visited_with>\r\n" ); //added by rupali on 18/09/17 for worked with field
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						valueXmlString.append( "<stockist_name protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
						// added by rupali on 01/12/17 for hiding unnecessary fields [start]
						valueXmlString.append( "<locality_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<email_addr protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						// added by rupali on 01/12/17 for hiding unnecessary fields [end]
						/*valueXmlString.append("<event_time_start visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						valueXmlString.append( "<copy_plan protect='1' visible = '1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						valueXmlString.append( "<oth_participant protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" ); //added by rupali on 18/09/17 for worked with field
						valueXmlString.append( "<visited_with_team protect = '0' visible = '1'><![CDATA[" ).append(empcode).append( "]]></visited_with_team>\r\n" ); // added by rupali on 03/05/18 for single screen mgr reporting
						valueXmlString.append( "<place_required protect = '0' visible = '0'><![CDATA[" ).append(placeRequired).append( "]]></place_required>\r\n" ); //added by mrunalini sinkar to add the place required on 09-sep-2018
						
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
						if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
						{
							if(allowChgTime.trim().equalsIgnoreCase("Y"))
							{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						
							}		
							else if(allowChgTime.trim().equalsIgnoreCase("N"))
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}
							else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
							{
								valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[]]></event_time_start>\r\n");
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
								valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[]]></event_time_end>\r\n" );
							}
							else
							{
								valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
								valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
								valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
							}						
							valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );											
						}			
						// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
					}
					// added by mrunalini sinkar if the activity type is leave and nfw on 30-may-2017 then protect the all fields(end)
				}
				else if(currentColumn.trim().equalsIgnoreCase( "cust_type" ))
				{
					//System.out.println("In side Itemchanged called cust_type......... ");
					strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2));

					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2));
					//System.out.println("cust_type....case1:::["+strgType+"]");
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );

					
					if("LISTED".equalsIgnoreCase(strgType) || "LISTED-CLIENT".equalsIgnoreCase(strgType) || "LISTED-FRANCHISE".equalsIgnoreCase(strgType))
					{
						valueXmlString.append( "<strg_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );

						valueXmlString.append( "<client_name protect = '1'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
						valueXmlString.append( "<address protect = '1'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						//valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append(strgType).append( "]]></strg_type>\r\n" );
						//valueXmlString.append( "<cust_type><![CDATA[" ).append("L").append( "]]></cust_type>\r\n" );
						//valueXmlString.append( "<locality_code protect = '1'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );		//Changed by Sagar B. for shifting locality code above customer code on[16/10/17]
						valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code protect = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
						// added by rupali on 01/12/17 for hiding unnecessary fields [start]
						valueXmlString.append( "<address_as protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append( "<gender protect = '1' visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
						valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append( "<wf_status><![CDATA[" ).append("P").append( "]]></wf_status>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("N").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<addr1 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append( "<age protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append( "<qualification protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
						
					    valueXmlString.append( "<strg_class_code protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						// added by rupali on 01/12/17 for hiding unnecessary fields [end]
					}
					// added condition by rupali on 30/10/17 for itemchange of new customer types
					else if(!"LISTED".equalsIgnoreCase(strgType) && !isMemberPresnt.equalsIgnoreCase("Y"))
					{
						String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2));
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]
						String defACt = checkNull(getSfaParmValue(userId, "DEF_ACT_REALCODE", connectionObject));
						String actDescr="",actType="",placReq="";
						String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
						pstmt = connectionObject.prepareStatement(defACtsql);
						pstmt.setString(1, defACt);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							actDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
							actType = checkNull(rs.getString("ACTIVITY_TYPE"));
							placReq = checkNull(rs.getString("PLACE_REQUIRED"));
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]
						int count=0;
						strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2));
						strgNameDom = checkNull(genericUtility.getColumnValue("strg_name", dom2,"1")); //added by mrunalini sinkar on 05-07-17 for unlisted customer name
						//System.out.println("strg_name is : "+strgNameDom);
						// added by rupali on 29/01/18 for setting default class code from sfaparm [start]
						String parmValue = "";
						//String parmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='DEFAULT_UNLISTED_CLASS' AND ACTIVE='Y' ";
						String parmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='DEFAULT_UNLIST_CLASS' AND ACTIVE='Y' ";
						pstmt = connectionObject.prepareStatement(parmSql);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							parmValue = rs.getString("PARM_VALUE");
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						// added by rupali on 29/01/18 for setting default class code from sfaparm [end]
						// commented by rupali on 20/09/17 for displaying proper data on itemchange of cust_type [start]
						/*String ScCodeSql="";

						ScCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE STRG_CODE=?";
						pstmt = connectionObject.prepareStatement(ScCodeSql);
						pstmt.setString(1, strgCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							count = rs.getInt("COUNT");
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(count == 0)
						{
							String custCodeSql="";
							int cnt = 0;

							custCodeSql = "SELECT COUNT(*) AS COUNT FROM STRG_CUSTOMER WHERE SC_CODE=?";
							pstmt = connectionObject.prepareStatement(custCodeSql);
							pstmt.setString(1, strgCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt("COUNT");
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(cnt == 0)
							{
								strgCode = generateCustomerCode(connectionObject);
							}
						}*/
						// commented by rupali on 20/09/17 for displaying proper data on itemchange of cust_type [end]
						strgCode = generateCustomerCode(connectionObject);

						valueXmlString.append( "<strg_code protect = '1' visible = '0'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<strg_name protect = '0'><![CDATA[" ).append(strgNameDom).append( "]]></strg_name>\r\n" );  //added by mrunalini sinkar on 05-07-17 for unlisted customer name

						valueXmlString.append( "<client_name protect = '0'><![CDATA[" ).append("").append( "]]></client_name>\r\n" );
						valueXmlString.append( "<address protect = '0'><![CDATA[" ).append("").append( "]]></address>\r\n" );
						valueXmlString.append( "<email_addr protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append( "<mobile_no protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append( "<address_as protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						//valueXmlString.append( "<gender protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						// commented and added by rupali on 29/01/18 for setting default class code from sfaparm [start]
						/*valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );*/
						/*if(parmValue.trim().length() == 0 || "null".equalsIgnoreCase(parmValue))
						{
							valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append( "" ).append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
						}
						else
						{
							valueXmlString.append( "<strg_class_code visible = '0'><![CDATA[" ).append( parmValue ).append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr visible = '0'><![CDATA[" ).append("CLASS "+parmValue).append( "]]></class_code_descr>\r\n" );
						}*/
						// commented and added by rupali on 29/01/18 for setting default class code from sfaparm [end]
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [start]
						/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [end]
						// added by rupali on 20/09/17 for displaying proper data on itemchange of cust_type [start]
						valueXmlString.append( "<addr1 protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append( "<addr2 protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append( "<addr3 protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append( "<age protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append( "<gender protect = '0' visible = '1'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
						valueXmlString.append( "<qualification protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
						// added by rupali on 20/09/17 for displaying proper data on itemchange of cust_type [end]
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						/*valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code protect = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );*/
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						// commented by mrunalini sinkar on 28-feb-2019(start)
						/*if("UNLISTED-DOCTOR".equalsIgnoreCase(strgType))
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("DOCTOR").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
							//valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("D").append( "]]></strg_type>\r\n" );
							//valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
							//valueXmlString.append( "<spl_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append( "" ).append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
							valueXmlString.append( "<gender protect = '0' visible = '1'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						}
						else if("UNLISTED-RETAILER".equalsIgnoreCase(strgType))
						{
							//valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("C").append( "]]></strg_type>\r\n" );
							//valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
							//valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("CHEMIST").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
							if(parmValue.trim().length() == 0 || "null".equalsIgnoreCase(parmValue))
							{
								valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append( "" ).append( "]]></strg_class_code>\r\n" );
								valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
							}
							else
							{
								valueXmlString.append( "<strg_class_code visible = '0'><![CDATA[" ).append( parmValue ).append( "]]></strg_class_code>\r\n" );
								valueXmlString.append( "<class_code_descr visible = '0'><![CDATA[" ).append("CLASS "+parmValue).append( "]]></class_code_descr>\r\n" );
							}
							valueXmlString.append( "<gender visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						}
						else if("UNLISTED-STOCKIST".equalsIgnoreCase(strgType))
						{
							//valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("S").append( "]]></strg_type>\r\n" );
							//valueXmlString.append( "<speciality_descr protect = '1' visible = '0'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
							//valueXmlString.append( "<spl_code protect = '1' visible = '0'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("STOCKIST").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
							if(parmValue.trim().length() == 0 || "null".equalsIgnoreCase(parmValue))
							{
								valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append( "" ).append( "]]></strg_class_code>\r\n" );
								valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
							}
							else
							{
								valueXmlString.append( "<strg_class_code visible = '0'><![CDATA[" ).append( parmValue ).append( "]]></strg_class_code>\r\n" );
								valueXmlString.append( "<class_code_descr visible = '0'><![CDATA[" ).append("CLASS "+parmValue).append( "]]></class_code_descr>\r\n" );
							}
							valueXmlString.append( "<gender visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						}
						else if("UNLISTED-OTHER".equalsIgnoreCase(strgType))
						{
							valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("O").append( "]]></strg_type>\r\n" );
							//valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
							//valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("OTHER").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
							valueXmlString.append( "<strg_class_code protect = '0' visible = '1'><![CDATA[" ).append( "" ).append( "]]></strg_class_code>\r\n" );
							valueXmlString.append( "<class_code_descr protect = '1' visible = '1'><![CDATA[" ).append("").append( "]]></class_code_descr>\r\n" );
							valueXmlString.append( "<gender visible = '0'><![CDATA[" ).append("M").append( "]]></gender>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						}
						// added by rupali on 30/10/17 for itemchange of new customer types [start]
						else if("UNLISTED TRADE".equalsIgnoreCase(strgType))
						{
							valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("C").append( "]]></strg_type>\r\n" );
							valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
							valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("TRADE").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
						}
						else if("UNLISTED GEN TRADE".equalsIgnoreCase(strgType))
						{
							valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("D").append( "]]></strg_type>\r\n" );
							valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
							valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("GENERAL TRADE").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
						}
						else if("UNLISTED INST SALE".equalsIgnoreCase(strgType))
						{
							valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("S").append( "]]></strg_type>\r\n" );
							valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
							valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("INSTITUTION SALE").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
						}
						else if("OTHER".equalsIgnoreCase(strgType))
						{
							valueXmlString.append( "<strg_type protect = '1'><![CDATA[" ).append("O").append( "]]></strg_type>\r\n" );
							valueXmlString.append( "<speciality_descr protect = '1' visible = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
							valueXmlString.append( "<spl_code protect = '1' visible = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("OTHER").append( "]]></sh_descr>\r\n" ); // added by rupali on 09/10/17 for displaying customer type on summary screen
						}*/
						// added by rupali on 30/10/17 for itemchange of new customer types [end]
						// commented by mrunalini sinkar on 28-feb-2019(end)
						if( eventType != null && eventType.trim().length() != 0 )
						{
							valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(checkNull(eventType)).append( "]]></event_type>\r\n" );
						}
						else
						{
							valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<place_required protect = '0' visible = '0'><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" ); //added by mrunalini sinkar to add the place required on 09-sep-2018
						}
					}
					valueXmlString.append( "</Detail"+objContext+">\r\n" );
				}
				else if(currentColumn.trim().equalsIgnoreCase("strg_code" ))
				{
					String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2,doctorFormNo));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2,doctorFormNo));
					//System.out.println("strgCode in doctor form is:["+strgCode+"]");
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, doctorFormNo);
					String trvDate = genericUtility.getColumnValue("event_date", dom2, doctorFormNo);
					strgType = checkNull(genericUtility.getColumnValue("cust_type", dom2));
					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom2, doctorFormNo));
					String locDescription = checkNull(genericUtility.getColumnValue("locality_descr", dom2, doctorFormNo));
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom2, doctorFormNo));
					String stockistName = checkNull(genericUtility.getColumnValue("stockist_name", dom2, doctorFormNo));
					String shdescr = checkNull(genericUtility.getColumnValue("sh_descr", dom2, doctorFormNo));
					
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(start)
					int allwdPrd=0;
					String allDelaySql = "SELECT ALLWD_DELAY_PRD FROM SALES_PERS WHERE SALES_PERS=?";
					pstmt =  connectionObject.prepareStatement(allDelaySql);
					pstmt.setString(1, checkNull(sprsCode));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						allwdPrd = rs.getInt("ALLWD_DELAY_PRD");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(end)
					// added by rupali on 11/09/18 for applying validation for distance limit variance [start]
					//String varDistance = getSfaParmValue(userId,"VARIANCE_DISTANCE_LMT",connectionObject);
					String varDistance = getSfaParmValue(userId,"VARIANCE_DISTANC_LMT",connectionObject);
					String taggedLoc = "";
					String taggedLocSql = "SELECT GET_TAGGED_LOCATION(?,?) AS TAGGED_LOCATION FROM DUAL";
					pstmt =  connectionObject.prepareStatement(taggedLocSql);
					pstmt.setString(1, checkNull(strgCode));
					pstmt.setString(2, checkNull(userId));

					rs = pstmt.executeQuery();
					if(rs.next())
					{
						taggedLoc = checkNull(rs.getString("TAGGED_LOCATION"));
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					// added by rupali on 11/09/18 for applying validation for distance limit variance [end]

					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
					String allowChgTime="";
					String ACTIVITYSql="SELECT ALLOW_CHG_VISITTIME FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					pstmt =  connectionObject.prepareStatement(ACTIVITYSql);
					pstmt.setString(1, eventType);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						allowChgTime = checkNull(rs.getString("ALLOW_CHG_VISITTIME"));
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
					
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
					eventType = genericUtility.getColumnValue( "event_type", dom );
					//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
					int visit=0;
					visit = orderOfVisit(trvDate,sprsCode,localityCode ,connectionObject); //added by mrunalini sinkar to count total number of visit
					//added by mrunalini sinkar on 19-jan-2018 for adding copy plan changes report changes (end)
					int planCount=0;
					String planID = "";
					int planCnt = 0;
					int planCustCnt = 0;
					Boolean isCustPlan = false;
					String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
					if(trvDate != null && trvDate.trim().length() > 0)
					{
						if("Y".equalsIgnoreCase(isPlanCumpulsory))
						{
							String planSql="select count(*) AS COUNT from SPRS_PLAN_HDR sph,SPRS_PLAN_cust planCust where sph.plan_date=? and sph.SPRS_CODE__PLAN=? and planCust.sc_code=? and planCust.locality_code=? and sph.plan_id=planCust.plan_id and sph.confirm='Y'";
							PreparedStatement planPstmt =  connectionObject.prepareStatement(planSql);
							planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							planPstmt.setString(2, checkNull(sprsCode));
							planPstmt.setString(3, checkNull(strgCode));
							planPstmt.setString(4, checkNull(localityCode));

							ResultSet planRs = planPstmt.executeQuery();
							if(planRs.next())
							{
								planCount = planRs.getInt("COUNT");
							}
							if(planRs != null)
							{
								planRs.close();
								planRs = null;
							}
							if(planPstmt != null)
							{
								planPstmt.close();
								planPstmt = null;
							}
							// added by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available [start]
							planSql = "select PLAN_ID, count(*) AS COUNT from SPRS_PLAN_HDR where sprs_code__plan = ? and plan_date = ? and confirm='Y' group by plan_id";
							planPstmt =  connectionObject.prepareStatement(planSql);
							planPstmt.setString(1, checkNull(sprsCode));
							planPstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							planRs = planPstmt.executeQuery();
							if(planRs.next())
							{
								planID = planRs.getString("PLAN_ID");
								planCnt = planRs.getInt("COUNT");
								String planCustSql="select count(*) AS COUNT from SPRS_PLAN_CUST where PLAN_ID = ?";
								PreparedStatement planCustPstmt =  connectionObject.prepareStatement(planCustSql);
								planCustPstmt.setString(1, checkNull(planID));
								ResultSet planCustRs = planCustPstmt.executeQuery();
								if(planCustRs.next())
								{
									planCustCnt = planCustRs.getInt("COUNT");
								}
								//addedby mrunalini 310821
								if(planCustRs != null)
								{
									planCustRs.close();
									planCustRs = null;
								}
								if(planCustPstmt != null)
								{
									planCustPstmt.close();
									planCustPstmt = null;
								}
							}
							if(planRs != null)
							{
								planRs.close();
								planRs = null;
							}
							if(planPstmt != null)
							{
								planPstmt.close();
								planPstmt = null;
							}
							if( planCnt > 0 && planCustCnt > 0 )
							{
								isCustPlan = true;
							}
							// added by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available [end]
						}
					}
					//added by mrunalini sinkar on 19-jan-2018 for adding copy plan changes report changes (end)
					sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME, SC.CUST_TYPE, SC.LOCALITY_CODE, SC.ADDRESS_AS, SC.SEX, SC.ADDR1, SC.ADDR2, SC.ADDR3,SC.QUALIFICATION,SC.AGE,SS.CLASS_CODE, SS.SPL_CODE, S.DESCR AS SPPECIALITY, SC.EMAIL_ADDR,SC.MOBILE_NO, LC.DESCR FROM STRG_CUSTOMER SC LEFT OUTER JOIN  STRG_SERIES SS ON SC.SC_CODE = SS.SC_CODE LEFT OUTER JOIN SPECIALITY S ON SS.SPL_CODE = S.SPL_CODE, LOCALITY LC WHERE SC.LOCALITY_CODE = LC.LOCALITY_CODE AND SC.SC_CODE= ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,strgCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						String customerType = checkNull(rs.getString("CUST_TYPE"));
						//System.out.println("CUST_TYPE IS :"+customerType);
						valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("STRG_NAME"))).append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						//	valueXmlString.append("<cust_type protect = '1'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // commented by rupali on 19/09/17 for editing cust_type
						valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("LISTED").append( "]]></cust_type>\r\n" ); // added by rupali on 19/09/17 for editing cust_type
						valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append( checkNull(rs.getString("CUST_TYPE"))).append( "]]></strg_type>\r\n" );
						//valueXmlString.append("<locality_code protect='1'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)

						if(localityCode!=null && localityCode.trim().length()>0)
						{
							valueXmlString.append("<locality_code protect='0'><![CDATA[" ).append(localityCode).append( "]]></locality_code>\r\n" );	//Changed by Sagar B. on 13/10/17 for location code editable
							valueXmlString.append("<locality_descr><![CDATA[" ).append(locDescription).append( "]]></locality_descr>\r\n" );
						}
						else
						{
							valueXmlString.append("<locality_code protect='0'><![CDATA[" ).append( checkNull(rs.getString("LOCALITY_CODE")) ).append( "]]></locality_code>\r\n" );	//Changed by Sagar B. on 13/10/17 for location code editable
							valueXmlString.append("<locality_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR")) ).append( "]]></locality_descr>\r\n" );
						}
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

						valueXmlString.append("<address_as protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDRESS_AS")) ).append( "]]></address_as>\r\n" );
						valueXmlString.append("<gender protect = '1'><![CDATA[" ).append( checkNull(rs.getString("SEX")) ).append( "]]></gender>\r\n" );
						valueXmlString.append("<addr1 protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR1")) ).append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR2")) ).append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 protect = '1'><![CDATA[" ).append( checkNull(rs.getString("ADDR3")) ).append( "]]></addr3>\r\n" );
						
						//added by prachi
						valueXmlString.append("<age protect = '1'><![CDATA[" ).append( checkNull(rs.getString("AGE")) ).append( "]]></age>\r\n" );
						valueXmlString.append("<qualification protect = '1'><![CDATA[" ).append( checkNull(rs.getString("QUALIFICATION")) ).append( "]]></qualification>\r\n" );
						
						valueXmlString.append("<email_addr protect = '1'><![CDATA[" ).append( checkNull(rs.getString("EMAIL_ADDR")) ).append( "]]></email_addr>\r\n" );
						valueXmlString.append("<mobile_no protect = '1'><![CDATA[" ).append( checkNull(rs.getString("MOBILE_NO")) ).append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<order_of_visit><![CDATA[" ).append(visit).append( "]]></order_of_visit>\r\n" );
						valueXmlString.append("<strg_class_code protect = '1'><![CDATA[" ).append(rs.getString("CLASS_CODE")).append( "]]></strg_class_code>\r\n" );
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [start]
						/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [end]
						// added by rupali on 09/10/17 for displaying customer type on summary screen [start]
						if("D".equalsIgnoreCase(customerType) )
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("DOCTOR").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						}
						else if("C".equalsIgnoreCase(customerType) || "R".equalsIgnoreCase(customerType) )
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("CHEMIST").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						}
						else if("S".equalsIgnoreCase(customerType) )
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("STOCKIST").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '0'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						}
						else
						{
							valueXmlString.append( "<sh_descr protect = '1'><![CDATA[" ).append("LISTED").append( "]]></sh_descr>\r\n" );
							valueXmlString.append("<stockist_code protect = '0' visible = '1'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
							valueXmlString.append("<stockist_name protect = '1' visible = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
						}
						// added by rupali on 09/10/17 for displaying customer type on summary screen [end]
						//added by mrunalini sinkar on 20-july-2017 to add speciality code (start)
						/*if(customerType.equals("D"))
						{
							valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append(rs.getString("SPL_CODE")).append( "]]></spl_code>\r\n" );
							valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append(rs.getString("SPPECIALITY")).append( "]]></speciality_descr>\r\n" );
						}
						else
						{
							valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );
							valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
						}*/
						valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append(rs.getString("SPL_CODE")).append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append(rs.getString("SPPECIALITY")).append( "]]></speciality_descr>\r\n" );
						//added by mrunalini sinkar on 20-july-2017 to add speciality code (end)
					}
					else
					{
						valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append("").append( "]]></strg_type>\r\n" );
						valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("").append( "]]></cust_type>\r\n" );
						valueXmlString.append("<locality_code><![CDATA[" ).append("").append( "]]></locality_code>\r\n" );
						valueXmlString.append("<locality_descr><![CDATA[" ).append("").append( "]]></locality_descr>\r\n" );
						valueXmlString.append("<address_as protect = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append("<gender protect = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						valueXmlString.append("<addr1 protect = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 protect = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 protect = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						
						//added by prachi
						valueXmlString.append("<age protect = '0'><![CDATA[" ).append("").append( "]]></age>\r\n" );
						valueXmlString.append("<qualification protect = '0'><![CDATA[" ).append("").append( "]]></qualification>\r\n" );
						
						valueXmlString.append("<email_addr protect = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append("<mobile_no protect = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<strg_class_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<spl_code protect = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr protect = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [start]
						valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
						// added by rupali on 20/09/17 for inserting event_time in strg_meet table [end]
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					// commented by rupali on 28/12/17 for not setting blank values in stockist code and name
					// added by rupali on 27/10/17 for displaying preffered stockist field [start]
					/*valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
					valueXmlString.append( "<stockist_code protect = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );*/
					// added by rupali on 27/10/17 for displaying preffered stockist field [end]
					// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[start]
					String defACt = checkNull(getSfaParmValue(userId, "DEF_ACT_REALCODE", connectionObject));
					String actDescr="",actType="",placReq="";
					String defACtsql = "SELECT DESCR AS ACTIVITY_DESCR,ACTIVITY_TYPE,PLACE_REQUIRED FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
					pstmt = connectionObject.prepareStatement(defACtsql);
					pstmt.setString(1, defACt);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						actDescr = checkNull(rs.getString("ACTIVITY_DESCR"));
						actType = checkNull(rs.getString("ACTIVITY_TYPE"));
						placReq = checkNull(rs.getString("PLACE_REQUIRED"));
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					// added by mrunalini sinkar for default activity for CHC client on 07-02-2019[end]
					if( eventType != null && eventType.trim().length() != 0 )
					{
						valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(checkNull(eventType)).append( "]]></event_type>\r\n" );
					}
					else
					{
						valueXmlString.append( "<event_type protect = '1'><![CDATA[" ).append(defACt).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_descr protect = '1'><![CDATA[" ).append(actDescr).append( "]]></activity_descr>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<place_required><![CDATA[" ).append(placReq).append( "]]></place_required>\r\n" );//Added by mrunalini sinkar for place required changes(start)
					}
					// added condition by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available
					if("Y".equalsIgnoreCase(isPlanCumpulsory) && isCustPlan )
					{
						//if("Y".equalsIgnoreCase(isPlanCumpulsory) && planCount>0)
						if(planCount>0)
						{
							valueXmlString.append( "<copy_plan protect='0'><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
						}
						else
						{
							valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
						}
					}
					// added by rupali on 29/05/18 for getting locality code of customer [start]
					String locCode = genericUtility.getColumnValue("locality_code", dom2, doctorFormNo);
					String locDescr = "";
					if(locCode == null || locCode.trim().length() == 0)
					{
						strgCode = genericUtility.getColumnValue("strg_code", dom2, doctorFormNo);
						sql = "SELECT LC.LOCALITY_CODE AS LOCALITY_CODE,LC.DESCR AS DESCR FROM LOCALITY LC, STRG_CUSTOMER SC WHERE LC.LOCALITY_CODE = SC.LOCALITY_CODE AND SC.SC_CODE = ?";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, strgCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							locCode = rs.getString("LOCALITY_CODE");
							locDescr = rs.getString("DESCR");
							//System.out.println("localoty code =["+locCode+"] locality descr =["+locDescr+"]");
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}

						valueXmlString.append( "<locality_code protect = '0'><![CDATA[" ).append( locCode ).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<locality_descr protect = '1'><![CDATA[" ).append( locDescr ).append( "]]></locality_descr>\r\n" );
					}
					// added by rupali on 29/05/18 for getting locality code of customer [end]
					// added by rupali on 11/09/18 for applying validation for distance limit variance [start]
					valueXmlString.append( "<variance_distance><![CDATA[" ).append( varDistance ).append( "]]></variance_distance>\r\n" );
					valueXmlString.append( "<tagged_location><![CDATA[" ).append( taggedLoc ).append( "]]></tagged_location>\r\n" );
					// added by rupali on 11/09/18 for applying validation for distance limit variance [end]
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(start)
					valueXmlString.append( "<allwd_delay_prd><![CDATA[" ).append( allwdPrd ).append( "]]></allwd_delay_prd>\r\n" );
					//Added by Mrunalini Sinkar On 03-10-2018 for allw_delay_prd(start)
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [Start]
					if(isFortuneActivity.trim().equalsIgnoreCase("Y"))
					{

						if(allowChgTime.trim().equalsIgnoreCase("Y"))
						{
							valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");

						}		
						else if(allowChgTime.trim().equalsIgnoreCase("N"))
						{
							valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						}
						else if(allowChgTime.trim().equalsIgnoreCase("B") && !dcrDate.equals(currentDate))
						{
							valueXmlString.append("<event_time_start protect='0' visible = '1'><![CDATA[]]></event_time_start>\r\n");
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[]]></visit_time_from>\r\n");
							valueXmlString.append("<event_time_end protect='0' visible = '1'><![CDATA[]]></event_time_end>\r\n" );
						}
						else
						{
							valueXmlString.append("<event_time_start protect='1'><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<event_time_end protect='1'><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );
							valueXmlString.append("<visit_time_from visible = '0'><![CDATA[").append(checkNull(startTime)).append("]]></visit_time_from>\r\n");
						}						
						valueXmlString.append( "<allow_chg_visittime><![CDATA[").append( allowChgTime ).append( "]]></allow_chg_visittime>\r\n" );								

					}
					// Added by Harion S for Activity form changes in fortune server --18-May-2021 [End]
				
					valueXmlString.append( "</Detail"+objContext+">\r\n" );
				}
				else if(currentColumn.trim().equalsIgnoreCase("locality_code" ))
				{
					//System.out.println("In side Itemchanged called locality_code......... ");
					String localityDes = "";
					// added by rupali on 28/12/17 to set stockist code and name on itemchange of locality_code [start]
					String stockistCode = "";
					String stockistName = "";
					// added by rupali on 28/12/17 to set stockist code and name on itemchange of locality_code [end]
					String strgTypeD = checkNull(genericUtility.getColumnValue("strg_type", dom2, "1"));
					String custTypeD = checkNull(genericUtility.getColumnValue("cust_type", dom2, "1"));
					String eventdate = checkNull(genericUtility.getColumnValue("event_date", dom2, "1"));
					String eventType = checkNull(genericUtility.getColumnValue("event_type", dom2, "1"));
					int planCustCnt = 0;
					//System.out.println("strgTypeD :: ["+strgTypeD+"]custTypeD::["+custTypeD+"]");
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, doctorFormNo);
					//System.out.println("sales pers:"+sprsCode);

					String localityCode = checkNull(genericUtility.getColumnValue("locality_code", dom2));
					int visit = orderOfVisit(eventdate,sprsCode,localityCode ,connectionObject);//added by mrunalini sinkar to count total number of visit
					//System.out.println("order of visit is:"+visit);
					String scCode = checkNull(genericUtility.getColumnValue("strg_code", dom2));

					// commented and added by rupali on 28/12/17 to set stockist code and name on itemchange of locality_code [start]
					//	sql = " SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ? ";
					//commmented by mrunalini snikar to take itemchange from pophelp not from code(start)
					/*sql = " SELECT DESCR, DEF_DISTRIBUTOR, SC.FIRST_NAME || ' ' || SC.LAST_NAME AS STRG_NAME FROM LOCALITY L LEFT OUTER JOIN STRG_CUSTOMER SC ON SC.SC_CODE = L.DEF_DISTRIBUTOR WHERE L.LOCALITY_CODE = ? ";
					// commented and added by rupali on 28/12/17 to set stockist code and name on itemchange of locality_code [end]
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,localityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						localityDes = checkNull(rs.getString("DESCR"));
						stockistCode = checkNull(rs.getString("DEF_DISTRIBUTOR"));
						stockistName = checkNull(rs.getString("STRG_NAME"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}*/
					// commented and added by rupali on 28/12/17 to set stockist code and name on itemchange of locality_code [end]

					//added by mrunalini sinkar on 23-jan-2018 for copy plan changes of real time reporting(start)
					int planCount=0;
					String isPlanCumpulsory  = getSfaParmValue(userId,"IS_PLAN_COMPULSORY",connectionObject);
					if(eventdate != null && eventdate.trim().length() > 0)
					{
						if("Y".equalsIgnoreCase(isPlanCumpulsory))
						{
							// commented and added by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available [start]
							/*String planSql="select count(*) AS COUNT from SPRS_PLAN_HDR sph,SPRS_PLAN_cust planCust where sph.plan_date=? and sph.SPRS_CODE__PLAN=? and planCust.sc_code=? and planCust.locality_code=? and sph.plan_id=planCust.plan_id and sph.confirm='Y'";
							PreparedStatement planPstmt =  connectionObject.prepareStatement(planSql);
							planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							planPstmt.setString(2, checkNull(sprsCode));
							planPstmt.setString(3, checkNull(scCode));
							planPstmt.setString(4, checkNull(localityCode));*/
							
							String planExstSql = "SELECT COUNT(*) AS COUNT FROM SPRS_PLAN_CUST WHERE PLAN_ID = (SELECT PLAN_ID FROM SPRS_PLAN_HDR WHERE SPRS_CODE__PLAN = ? AND PLAN_DATE = ? AND CONFIRM='Y')";
							pstmt =  connectionObject.prepareStatement(planExstSql);
							pstmt.setString(1, checkNull(sprsCode));
							pstmt.setTimestamp(2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								planCustCnt = rs.getInt("COUNT");
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							
							if(planCustCnt == 0)
							{
								String planSql="select count(*) AS COUNT from SPRS_PLAN_HDR sph,SPRS_PLAN_PLACE planPlace where sph.plan_date=? and sph.SPRS_CODE__PLAN= ? and planPlace.locality_code=? and sph.plan_id=planPlace.plan_id and sph.confirm='Y' and sph.plan_activity = ?";
								PreparedStatement planPstmt =  connectionObject.prepareStatement(planSql);
								planPstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
								planPstmt.setString(2, checkNull(sprsCode));
								planPstmt.setString(3, checkNull(localityCode));
								planPstmt.setString(4, checkNull(eventType));
								// commented and added by rupali on 10/10/18 to set report from plan value if plan for selected loaclity is available [start]
								ResultSet planRs = planPstmt.executeQuery();
								if(planRs.next())
								{
									planCount = planRs.getInt("COUNT");
								}
								if(planRs != null)
								{
									planRs.close();
									planRs = null;
								}
								if(planPstmt != null)
								{
									planPstmt.close();
									planPstmt = null;
								}
							}
						}
					}
					//added by mrunalini sinkar on 23-jan-2018 for copy plan changes of real time reporting(start)
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );

					//valueXmlString.append("<locality_descr protect = '1'><![CDATA[" ).append(checkNull(localityDes)).append( "]]></locality_descr>\r\n" );
					valueXmlString.append("<locality_code protect = '0'><![CDATA[" ).append(checkNull(localityCode)).append( "]]></locality_code>\r\n" );
					valueXmlString.append( "<order_of_visit><![CDATA[" ).append(visit).append( "]]></order_of_visit>\r\n" );
					// added by rupali on 28/12/17 to set stockist code and name on itemchange of locality_code [start]
					//valueXmlString.append("<stockist_code protect = '0'><![CDATA[" ).append(stockistCode).append( "]]></stockist_code>\r\n" );
					//valueXmlString.append("<stockist_name protect = '1'><![CDATA[" ).append(stockistName).append( "]]></stockist_name>\r\n" );
					// added by rupali on 28/12/17 to set stockist code and name on itemchange of locality_code [end]
					//Added by Sagar B. on [13/10/17] START
					if( "LISTED".equalsIgnoreCase(custTypeD) || "LISTED-CLIENT".equalsIgnoreCase(custTypeD) || "LISTED-FRANCHISE".equalsIgnoreCase(custTypeD))
					{
						valueXmlString.append("<strg_name protect = '1'><![CDATA[" ).append("").append( "]]></strg_name>\r\n" );
						valueXmlString.append("<strg_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_code>\r\n" );
						valueXmlString.append("<strg_type protect = '1'><![CDATA[" ).append("").append( "]]></strg_type>\r\n" );
						//valueXmlString.append("<cust_type protect = '0'><![CDATA[" ).append("").append( "]]></cust_type>\r\n" );
						valueXmlString.append("<address_as protect = '0'><![CDATA[" ).append("").append( "]]></address_as>\r\n" );
						valueXmlString.append("<gender protect = '0'><![CDATA[" ).append("").append( "]]></gender>\r\n" );
						valueXmlString.append("<addr1 protect = '0'><![CDATA[" ).append("").append( "]]></addr1>\r\n" );
						valueXmlString.append("<addr2 protect = '0'><![CDATA[" ).append("").append( "]]></addr2>\r\n" );
						valueXmlString.append("<addr3 protect = '0'><![CDATA[" ).append("").append( "]]></addr3>\r\n" );
						valueXmlString.append("<email_addr protect = '0'><![CDATA[" ).append("").append( "]]></email_addr>\r\n" );
						valueXmlString.append("<mobile_no protect = '0'><![CDATA[" ).append("").append( "]]></mobile_no>\r\n" );
						valueXmlString.append("<strg_class_code protect = '0'><![CDATA[" ).append("").append( "]]></strg_class_code>\r\n" );
						valueXmlString.append("<spl_code protect = '0'><![CDATA[" ).append("").append( "]]></spl_code>\r\n" );
						valueXmlString.append("<speciality_descr protect = '0'><![CDATA[" ).append("").append( "]]></speciality_descr>\r\n" );
						/*valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(startTime)).append("]]></event_time_start>\r\n");
						valueXmlString.append("<event_time_end><![CDATA[").append(checkNull(startTime)).append( "]]></event_time_end>\r\n" );*/
						// commented by rupali on 28/12/17 for not setting blank values in stockist code and name
						// added by rupali on 27/10/17 for displaying preffered stockist field [start]
						/*valueXmlString.append( "<stockist_name protect = '1'><![CDATA[" ).append("").append( "]]></stockist_name>\r\n" );
						valueXmlString.append( "<stockist_code protect = '0'><![CDATA[" ).append("").append( "]]></stockist_code>\r\n" );*/
						// added by rupali on 27/10/17 for displaying preffered stockist field [end]
					}
					if("Y".equalsIgnoreCase(isPlanCumpulsory) && planCount>0)
					{
						valueXmlString.append( "<copy_plan protect='0'><![CDATA[" ).append("Y").append( "]]></copy_plan>\r\n" );
					}
					else
					{
						valueXmlString.append( "<copy_plan protect='1'><![CDATA[" ).append("N").append( "]]></copy_plan>\r\n" );
					}
					//Added by Sagar B. on [13/10/17] END

					// added by rupali on 25/06/18 for geeting travel_mode for expense process related changes [start]
					String travelMode = getDefaultTravelMode(sprsCode, eventdate, localityCode, connectionObject);
					if(travelMode.trim().length() != 0)
					{
						valueXmlString.append( "<travel_mode><![CDATA[" ).append(travelMode).append( "]]></travel_mode>\r\n" );
					}
					else
					{
						String newEventdate = eventdate;
						int cnt = 1;
						int count = 1;
						int dateCountBefore = 1;
						int dateCountAfter = 1;
						int sunCount = 0;
						while(dateCountBefore <= 3 || dateCountAfter <= 3)
						{
							date = dtFormat.parse(newEventdate);
							Calendar calendar = Calendar.getInstance();
							calendar.setTime(date);
							calendar.add(Calendar.DATE, - cnt);
							String eventDateBefore = dtFormat.format(calendar.getTime());
							String checkSunday = "select count(1) as count from holiday where hol_date = ? and hol_tblno = (select hol_tblno from employee where emp_code = ?) and descr = 'SUNDAY'";
							pstmt = connectionObject.prepareStatement(checkSunday);
							pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDateBefore, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
							pstmt.setString(2,sprsCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								sunCount = rs.getInt("count");
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(sunCount == 0)
							{
								dateCountBefore++;
								//System.out.println("dateCountBefore:::"+dateCountBefore);
								travelMode = getDefaultTravelMode(sprsCode, eventDateBefore, localityCode, connectionObject);
								if(travelMode.trim().length() != 0 && dateCountBefore <= 3)
								{
									valueXmlString.append( "<travel_mode><![CDATA[" ).append(travelMode).append( "]]></travel_mode>\r\n" );
									break;
								}
								else
								{
									date = dtFormat.parse(newEventdate);
									Calendar calendar1 = Calendar.getInstance();
									calendar1.setTime(date);
									calendar1.add(Calendar.DATE, + count);
									String eventDateAfter = dtFormat.format(calendar1.getTime());
									String checkSundayAfter = "select count(1) as count from holiday where hol_date = ? and hol_tblno = (select hol_tblno from employee where emp_code = ?) and descr = 'SUNDAY'";
									pstmt = connectionObject.prepareStatement(checkSundayAfter);
									pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDateAfter, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
									pstmt.setString(2,sprsCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										sunCount = rs.getInt("count");
										if(sunCount == 0)
										{
											dateCountAfter++;
											//System.out.println("dateCountAfter:::"+dateCountAfter);
											travelMode = getDefaultTravelMode(sprsCode, eventDateAfter, localityCode, connectionObject);
											if(travelMode.trim().length() != 0)
											{
												valueXmlString.append( "<travel_mode><![CDATA[" ).append(travelMode).append( "]]></travel_mode>\r\n" );
												break;
											}
										}
									}
									if (rs != null)
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									count++;
								}
							}
							cnt++;
						}
					}
					if(travelMode.trim().length() == 0)
					{
						valueXmlString.append( "<travel_mode><![CDATA[" ).append("1").append( "]]></travel_mode>\r\n" );
					}
					// added by rupali on 25/06/18 for geeting travel_mode for expense process related changes [end]
					valueXmlString.append( "</Detail"+objContext+">\r\n" );

				}
				//added by mrunalini sinkar on 20-july-2017 to add speciality code (start)
				else if(currentColumn.trim().equalsIgnoreCase("spl_code"))
				{
					//System.out.println("INSIDE SPL CODE................");
					String specialityCode = checkNull(genericUtility.getColumnValue("spl_code", dom2));
					//System.out.println("speciality code is  :"+specialityCode);
					String unlistedStrgType = checkNull(genericUtility.getColumnValue("cust_type", dom2));
					//System.out.println("unlistedStrgType code is  :"+unlistedStrgType);
					String specialityDescr="";
					sql = "SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, specialityCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						specialityDescr = checkNull(rs.getString("DESCR"));
						//System.out.println("specialityDescr"+specialityDescr);

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					if("UNLISTED-DOCTOR".equalsIgnoreCase(unlistedStrgType))
					{
						valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append(checkNull(specialityDescr)).append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<spl_code protect = '0'><![CDATA[" ).append(checkNull(specialityCode)).append( "]]></spl_code>\r\n" );
					}
					/*else
					{
						valueXmlString.append("<speciality_descr protect = '1'><![CDATA[" ).append("OTHER").append( "]]></speciality_descr>\r\n" );
						valueXmlString.append("<spl_code protect = '1'><![CDATA[" ).append("OTH").append( "]]></spl_code>\r\n" );

					}*/
					valueXmlString.append( "</Detail"+objContext+">\r\n" );

				}
				//added by mrunalini sinkar on 20-july-2017 to add speciality code (end)
				else if( currentColumn.equalsIgnoreCase("call_outcome"))
				{
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					String outCome = checkNull(genericUtility.getColumnValue("call_outcome", dom2, ""+currentFormNo));
					//System.out.println("CALL OUTCOME IS"+outCome);
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2, ""+currentFormNo));
					//System.out.println("STRG_CODE IS"+strgCode);
					//String call = checkNull(genericUtility.getColumnValue("strg_code", dom2, ""+currentFormNo));
					String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom2, ""+currentFormNo));
					String meetSumm = checkNull(genericUtility.getColumnValue("meet_summ", dom2, ""+currentFormNo));


					//System.out.println("outCome call_outcome: ["+outCome+"]domIDcall_outcome["+domID+"]call_outcomestrgCode["+strgCode);
					//System.out.println("outCome : ["+outCome+"]domID["+domID);
					valueXmlString.append( "<Detail"+objContext+" dbID='' domID='1' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );

					if(outCome.equalsIgnoreCase("0") || outCome.equalsIgnoreCase("9"))
					{

						valueXmlString.append( "<oth_participant protect='1'><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						//commented by mrunalini sinkar to visible off the field in case of refused 11-june-2018(start)
						//valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<meet_summ protect='1' visible = '0'><![CDATA[" ).append("---NA---").append( "]]></meet_summ>\r\n" );
						//commented by mrunalini sinkar to visible off the field in case of refused 11-june-2018(end)
						if(outCome.equalsIgnoreCase("0") || outCome.equalsIgnoreCase("9"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					else
					{
						//System.out.println("INSIDE ELSE");
						//added by mrunalini sinkar to visible off the field in case of refused 11-june-2018(start)
						//valueXmlString.append( "<meet_summ protect='0' visible = '1'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						if(meetSumm.equalsIgnoreCase("---NA---"))
						{
							valueXmlString.append( "<meet_summ protect='0' visible = '1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						}
						else
						{
							valueXmlString.append( "<meet_summ protect='0' visible = '1'><![CDATA[" ).append(meetSumm).append( "]]></meet_summ>\r\n" );
						}
						//added by mrunalini sinkar to visible off the field in case of refused 11-june-2018(end)
						valueXmlString.append( "<oth_participant protect='0'><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						if(outCome.equalsIgnoreCase("4"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("3"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("2"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("1"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("5"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Supporter").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("6"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Believer").append( "]]></calloutcome_descr>\r\n" );
						}
						else if(outCome.equalsIgnoreCase("7"))
						{
							valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Non Believer").append( "]]></calloutcome_descr>\r\n" );
						}
					}
					valueXmlString.append("</Detail"+objContext+">\r\n");

				}
				// added by rupali on 27/10/17 for displaying preffered stockist field [start]
				else if( currentColumn.equalsIgnoreCase("stockist_code"))
				{
					//System.out.println("INSIDE stockist_code itemchange................");
					String stockistCode = checkNull(genericUtility.getColumnValue("stockist_code", dom2,"1"));
					//System.out.println("stockist code is  :"+stockistCode);
					String stockistName="";
					sql = "SELECT SC.FIRST_NAME || ' ' ||  SC.LAST_NAME AS STRG_NAME FROM STRG_CUSTOMER SC WHERE SC_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, stockistCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						stockistName = checkNull(rs.getString("STRG_NAME"));
						//System.out.println("stockistName"+stockistName);

					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<stockist_name protect = '1'><![CDATA[" ).append(checkNull(stockistName)).append( "]]></stockist_name>\r\n" );
					valueXmlString.append("<stockist_code protect = '0'><![CDATA[" ).append(checkNull(stockistCode)).append( "]]></stockist_code>\r\n" );
					valueXmlString.append( "</Detail"+objContext+">\r\n" );
				}
				// added by rupali on 27/10/17 for displaying preffered stockist field [end]
				//added by vishal pathare on 13.12.17 [for adding class_code_descr]Start.
				//commented by mrunalini sinkar to make itemchange through pophelp query(start)
				/*else if( currentColumn.equalsIgnoreCase("strg_class_code"))
				{
					System.out.println("INSIDE strg_class_code itemchange................");
					String classCode = checkNull(genericUtility.getColumnValue("strg_class_code", dom2));
					System.out.println("classCodeis  [:"+classCode);
					String strgTyp = checkNull(genericUtility.getColumnValue("strg_type", dom2));
					System.out.println("strgTyp is  [:"+strgTyp);
					String classCodeDescr = getClassCodeDesc( classCode, strgTyp, connectionObject );

					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<class_code_descr protect = '1'><![CDATA[" ).append(checkNull(classCodeDescr)).append( "]]></class_code_descr>\r\n" );
					valueXmlString.append( "</Detail"+objContext+">\r\n" );
				}*/
				//commented by mrunalini sinkar to make itemchange through pophelp query(end)
				//added by vishal pathare on 13.12.17 [for adding class_code_descr]End.
				// added by rupali on 03/05/18 for single screen mgr reporting [start]
				/*else if( currentColumn.equalsIgnoreCase("visited_with") && mgrCode.trim().length() != 0)
				{
					valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
					String selTeam = "";
					String visitedWith = checkNull(genericUtility.getColumnValue( "visited_with" , dom2 ));
					System.out.println("before if::::::::"+visitedWith);
					if(visitedWith.trim().length() > 0)
					{
						System.out.println("inside if::::::::"+visitedWith);
						if(visitedWith.indexOf("(") != -1 && visitedWith.indexOf(")") != -1)
						{
							selTeam = checkNull(visitedWith.substring(visitedWith.indexOf("(")+1, visitedWith.indexOf(")")));
							valueXmlString.append("<sprs_code__ww protect = '0'><![CDATA[" ).append(checkNull(selTeam)).append( "]]></sprs_code__ww>\r\n" );
							valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(selTeam)).append( "]]></visited_with_team>\r\n" );
						}
						else
						{
							System.out.println("selTeam:::::::"+selTeam);
							valueXmlString.append("<sprs_code__ww protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></sprs_code__ww>\r\n" );
							valueXmlString.append("<visited_with_team protect = '0'><![CDATA[" ).append(checkNull(empcode)).append( "]]></visited_with_team>\r\n" );
						}
					}
					valueXmlString.append( "</Detail"+objContext+">\r\n" );
				}*/
				// added by rupali on 03/05/18 for single screen mgr reporting [end]
				//System.out.println("valueXmlString....."+valueXmlString);
				/*else if( currentColumn.equalsIgnoreCase("strg_name"))
				{
					String key = "", value = "", val = "", val1 = "", name1 = "";
					String keyaddr1 = "", valueaddr1 = "", shortName="",city="",state="",country="",pinCode="";
					JSONParser parser = new JSONParser();
					String strgName = checkNull(genericUtility.getColumnValue("strg_name", dom2));
					System.out.println("strgName is:::"+strgName);
					try
					{
						valueXmlString.append("<Detail"+objContext+" domID='1' formName='"+formName+"'>\r\n" );
						org.json.simple.JSONObject json = (org.json.simple.JSONObject) parser.parse(strgName);
						System.out.println("JsonObj1   " + json);
						Iterator<String> JsonObjKey = json.keySet().iterator();
						while (JsonObjKey.hasNext())
						{
							key = JsonObjKey.next();
							System.out.println("Key [" +key +"]");
							value = json.get(key).toString();
							System.out.println("Value [" + value +"]");

							if (key.equalsIgnoreCase("address_components"))
							{
								org.json.simple.JSONArray adddrcomp = (org.json.simple.JSONArray) parser.parse(value);
								HashMap<String, String> fields= getAddressDetailMap( adddrcomp, connectionObject );
								String pinAdr =  fields.get("pin");
								valueXmlString.append("<pin><![CDATA[" + pinAdr + "]]></pin>");
							}
							else if (key.equalsIgnoreCase("adr_address"))
							{
								System.out.println("value in adr_address"+value);
								HashMap<String, String> Address = getAddressMap( value );
								String Adr1=Address.get("addr1");
								valueXmlString.append("<addr1><![CDATA[" + Adr1 + "]]></addr1>");
								String Adr2=Address.get("addr2");
								valueXmlString.append("<addr2><![CDATA["+ Adr2 +"]]></addr2>");
								String Adr3=Address.get("addr3");
								valueXmlString.append("<addr3><![CDATA["+ Adr3  +"]]></addr3>");
							}
							else if (key.equalsIgnoreCase("formatted_phone_number"))
							{
								System.out.println("Value formatted_phone_number" + (value));
								if(value.indexOf(" ") != -1)
								{
									value = value.replace(" ", "");
								}
								if(value.indexOf("0") == 0)
								{
									value = value.substring(1);
								}
								valueXmlString.append("<mobile_no><![CDATA[" + value + "]]></mobile_no>");
							}
							else if (key.equalsIgnoreCase("name"))
							{
								System.out.println("Value name" + (value));
								strgName = value;
								valueXmlString.append("<strg_name><![CDATA[" + value + "]]></strg_name>");
							}
						}
						
						valueXmlString.append( "</Detail"+objContext+">\r\n" );
						
					}
					catch (Exception e)
					{
						System.out.println("exeception in the cust_name "+e.getMessage());
					}
				}*/
			}
			else if("sampleitem".equalsIgnoreCase(formName) || "retailersampleitem".equalsIgnoreCase(formName) )
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					String parentFormNo = "1";

					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);

					String editScCode = getSelectedYesRowValue(dom2, parentFormNo, "strg_code", 0);
					if(editScCode==null || editScCode.trim().length()==0)
					{
						editScCode="X";
					}
					//System.out.println("salePersCode =["+salePersCode+"], wrkDate =["+wrkDate+"], scCode=["+scCode+"]");

					valueXmlString.append( getSampleItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,editScCode,formName ));
				}
			}
			else if("sampleorder".equalsIgnoreCase(formName) || "retailersampleorder".equalsIgnoreCase(formName))
			{
				DARCommonBean darCommonBean= new DARCommonBean();

				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					////System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					String parentFormNo = "1";
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String prcListTemp=getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
					valueXmlString.append( getItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,prcListTemp ));

				}
				else if( currentColumn.equalsIgnoreCase( "quantity" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					//System.out.println("Inside order quantity itemchange...........");
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					String parentFormDomId="";
					//System.out.println("dom1 >>domID::["+domID+"] ");
					String qtyDom = checkNull(genericUtility.getColumnValue("quantity", dom2, ""+currentFormNo));
					String rateDom = checkNull(genericUtility.getColumnValue("landing_rate", dom2, ""+currentFormNo));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom2, ""+currentFormNo));
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom2, ""+currentFormNo));
					double value = 0d;
					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--started
					double totPOBVal=0.0;
					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--ended
					//System.out.println("qtyDom::["+qtyDom+"] dom1 >>domID::["+domID+"] strg_code_dummy::["+strgCode+"]");
					//System.out.println("rateDom ::["+rateDom+"] itemCode:["+itemCode+"]");
					//	String objName = "strg_meet_pr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("parentFormNo::["+parentFormNo+"] ");


					parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					//System.out.println("parentFormDomId::["+parentFormDomId+"]");
					//System.out.println("dom2>>parentFormDomId::["+parentFormDomId+"]");
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--started
					String pobValueParent=checkNull(genericUtility.getColumnValue("sku_value", dom2,""+parentFormNo, parentFormDomId));

					totPOBVal =  getTotalPOBValue( dom2, ""+currentFormNo, "value", strgCode);
					//System.out.println("pobValueParent ::["+pobValueParent+"] ");
					if(pobValueParent == null || pobValueParent.trim().length() == 0)
					{
						pobValueParent = "0";
					}

					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--ended

					try
					{
						//valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"'>\r\n" );
						DecimalFormat df = new DecimalFormat("###.##");
						if(qtyDom != null && qtyDom.trim().length() != 0)
						{
							//System.out.println("Inside qty loop");
							double qty = 0d;
							double rate = 0d;
							qty = Double.parseDouble(qtyDom);
							rate = Double.parseDouble(rateDom);
							//System.out.println("qty : ["+qty+"]  rate:["+rate+"]");
							value = qty * rate;
							//System.out.println("value : ["+value+"]");
							valueXmlString.append("<value><![CDATA[" ).append(df.format(value)).append( "]]></value>\r\n" );
						}
						else
						{
							value = 0;
							valueXmlString.append("<value><![CDATA[" ).append("").append( "]]></value>\r\n" );
						}

						/*totPOBVal = totPOBVal + value;
						 *
						System.out.println("totPOBVal ::::["+totPOBVal+"] ");*/
						//totPOBVal = Double.parseDouble(pobValueParent) + value  ;
						valueXmlString.append("<Detail"+parentFormNo+"."+parentFormDomId+".sku_value><![CDATA[" ).append(df.format(totPOBVal)).append( "]]></Detail"+parentFormNo+"."+parentFormDomId+".sku_value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}
					catch(NumberFormatException e)
					{
						//System.out.println("NumberFormatException......");
						valueXmlString.append("<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}

				}
				// added by rupali on 02/11/17 for applying itemchange of lot_no in order form [start]
				else if( currentColumn.equalsIgnoreCase( "lot_no" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					//System.out.println("Inside lot_no itemchange...........");
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					String parentFormDomId="";
					//System.out.println("dom1 >>domID::["+domID+"] ");
					/*String lotNo = checkNull(genericUtility.getColumnValue("lot_no", dom1, ""+currentFormNo));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom1, ""+currentFormNo));
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom1, ""+currentFormNo));*/

					String lotNo = checkNull(genericUtility.getColumnValue("lot_no", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom1));
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom1));
					//System.out.println("lotNo::["+lotNo+"] itemCode::["+itemCode+"] strg_code_dummy::["+strgCode+"]");
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("parentFormNo::["+parentFormNo+"] ");

					parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					String totMonths = darCommonBean.getTotalMonths(itemCode,lotNo,connectionObject);
					/*String expDate = "";
					sql = "select exp_date from item_lot_info where item_code = ? and  lot_no = ?";
					pstmt =  connectionObject.prepareStatement(sql);
					pstmt.setString(1, itemCode);
					pstmt.setString(2, lotNo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						expDate = (rs.getString("exp_date") == null) ?"":rs.getString("exp_date").trim();
						System.out.println("expDate is::::::"+expDate);
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					Date date1 = Calendar.getInstance().getTime();
			        DateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			        String today = sdf.format(date1);
			        System.out.println("Today : " + today);
			        String totMonths = "";
			        if(expDate.trim().length() != 0)
			        {
				        SimpleDateFormat inputFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
						Date eventDate1=null;
						eventDate1 = inputFormat.parse(expDate);
						expDate=sdf.format(eventDate1);
						System.out.println("expDate is:::::"+expDate);

				        Date date3 = sdf.parse(today);
				        Date date2 = sdf.parse(expDate);

				        if (date3.compareTo(date2) < 0)
				        {
				        	totMonths = Integer.toString(monthsBetween(sdf.parse(today), sdf.parse(expDate)));
				        }
					    System.out.println("totMonths:::::"+totMonths);
			        }*/
					//System.out.println("parentFormDomId::["+parentFormDomId+"]");
					//System.out.println("dom2>>parentFormDomId::["+parentFormDomId+"]");
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<expiry_date><![CDATA[" ).append( totMonths ).append( "]]></expiry_date>\r\n" );
					/*if(totMonths.trim().length() != 0)
					{
						valueXmlString.append( "<expiry_date><![CDATA[" ).append( totMonths+" M" ).append( "]]></expiry_date>\r\n" );
					}
					else
					{
						valueXmlString.append( "<expiry_date><![CDATA[" ).append("0 M").append( "]]></expiry_date>\r\n" );
					}*/
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				}
				// added by rupali on 02/11/17 for applying itemchange of lot_no in order form [end]
				// added by rupali on 22/12/17 for applying itemchange on stock_info field [start]
				else if( currentColumn.equalsIgnoreCase("stock_info"))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					//System.out.println("dom1 >>domID::["+domID+"] ");

					String stockInfo = checkNull(genericUtility.getColumnValue(currentColumn, dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code_dummy", dom1));
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom1));
					//System.out.println("stockInfo::["+stockInfo+"] itemCode::["+itemCode+"] strg_code_dummy::["+strgCode+"]");
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("parentFormNo::["+parentFormNo+"] ");

					String parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					String totMonths = darCommonBean.getTotalMonths(itemCode,stockInfo,connectionObject);

					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<expiry_date><![CDATA[" ).append( totMonths ).append( "]]></expiry_date>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				}
				// added by rupali on 22/12/17 for applying itemchange on stock_info field [end]
				// added by Niraj on 10/12/17 for applying itemchange on promo_code field [start]
				else if(currentColumn.trim().equalsIgnoreCase("promo_code"))
				{
					//System.out.println("INSIDE PROMO CODE................");
					String PromoCode = checkNull(genericUtility.getColumnValue("promo_code", dom1));
					//System.out.println("Promo code is  :"+PromoCode);
					String descr="";
					sql = "SELECT DESCR FROM BOM WHERE BOM_CODE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,PromoCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = checkNull(rs.getString("DESCR"));
						//System.out.println("Descr"+descr);
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					else
					{
						domID = domID;
					}
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<description><![CDATA[" ).append(descr).append( "]]></description>\r\n" );
					valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				}
				// added by Niraj on 10/12/17 for applying itemchange on promo_code field [end]
			}
			else if("brand".equalsIgnoreCase(formName) || "retailerbrand".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "",localityCode="";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					//added by mrunalini sinkar for edetailing changes--10-02-18(start)
					localityCode = getSelectedRowValue(dom2, parentFormNo, "locality_code", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String copyPlan=getSelectedRowValue(dom2, parentFormNo, "copy_plan", 0); // added by mrunalini sinkar to get the attachment from MAP 27-07-2018(start)
					valueXmlString.append( getPitchDetails( salePersCode, wrkDate, copyPlan,scCode,localityCode, xtraParams, "", "", ""+currentFormNo, formName,connectionObject));
				}
			}
			else if("display".equalsIgnoreCase(formName) || "retailerdisplay".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					//System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					//System.out.println("salePersCode : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getDNDDetails( dom2 , salePersCode, wrkDate, scCode, "", xtraParams, objContext,formName,connectionObject ));// Changed by kailash on 20/dec/17
				}
				else if(currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					System.out.println("in detail display...........itm_default_add");
					String itmOption="",disType="";
					String salePersCode = "";
					String wrkDate = "";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					String dcrID = getDCRId(connectionObject,salePersCode, wrkDate);
					
					String dispSql="SELECT ITEM_OPTION,DISP_TYPE FROM DISPLAY_TYPE ORDER BY DISP_TYPE" ;
					System.out.println(" dispSql is:["+dispSql+"]");
					PreparedStatement dispPstmt = connectionObject.prepareStatement(dispSql) ;
					ResultSet dispRs = dispPstmt.executeQuery();
					if(dispRs.next())
					{
						itmOption = checkNull(dispRs.getString("ITEM_OPTION"));
						disType = checkNull(dispRs.getString("DISP_TYPE"));

					}
					if (dispRs != null)
					{
						dispRs.close();
						dispRs = null;
					}
					if (dispPstmt != null)
					{
						dispPstmt.close();
						dispPstmt = null;
					}
					System.out.println("itmoption:["+itmOption+"]disType["+disType+"]");
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					valueXmlString.append( "<Root>\r\n" );
					valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
					valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
					valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
					valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<disp_type><![CDATA[" ).append("").append("]]></disp_type>\r\n");
					if(itmOption.equalsIgnoreCase("1"))
					{
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else if(itmOption.equalsIgnoreCase("2"))
					{
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else if(itmOption.equalsIgnoreCase("3"))
					{
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					else
					{
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
					}
					valueXmlString.append("</Detail"+objContext+">\r\n" );
					valueXmlString.append( "</Root>\r\n" );
				}
				//added by mrunalini sinkar on 30-nov-2018 for disp_type changes(start)
				else if(currentColumn.equalsIgnoreCase("disp_type"))
				{
					String dispType = checkNull(genericUtility.getColumnValue(currentColumn, dom1));
					String itmOption ="";
					String dispSql="SELECT ITEM_OPTION FROM DISPLAY_TYPE WHERE DISP_TYPE=?";
					PreparedStatement dispPstmt = connectionObject.prepareStatement(dispSql) ;
					dispPstmt.setString(1, dispType);
					ResultSet dispRs = dispPstmt.executeQuery();
					if(dispRs.next())
					{
						itmOption = checkNull(dispRs.getString("ITEM_OPTION"));
					}
					if (dispRs != null)
					{
						dispRs.close();
						dispRs = null;
					}
					if (dispPstmt != null)
					{
						dispPstmt.close();
						dispPstmt = null;
					}
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					else
					{
						domID =domID;
					}
					if(itmOption.equalsIgnoreCase("1"))
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                                 //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
						valueXmlString.append( "<quantity visible = '0'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");

					}
					else if(itmOption.equalsIgnoreCase("2"))
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<brand_code visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                                 //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '1'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '1'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");

					}
					else if(itmOption.equalsIgnoreCase("3"))
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<brand_code visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_code>\r\n" );                                  //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
						valueXmlString.append( "<quantity visible = '1'><![CDATA[" ).append( "" ).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<brand_descr visible = '0'><![CDATA[" ).append( "" ).append( "]]></brand_descr>\r\n" );
						valueXmlString.append( "<target_qty visible = '0'><![CDATA[" ).append( "" ).append( "]]></target_qty>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");

					}
				}
				else if(currentColumn.equalsIgnoreCase("brand_code"))
				{
					String brandCode = checkNull(genericUtility.getColumnValue(currentColumn, dom1));
					String custCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					String dispEventDate = checkNull(genericUtility.getColumnValue("event_date", dom2, "1"));
					String brandDescr ="";
					String targetQty ="";
					String remarks ="";
					
					/*String brandSql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE = ?";
					pstmt = connectionObject.prepareStatement(brandSql) ;
					pstmt.setString(1, brandCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						brandDescr = checkNull(rs.getString("DESCRIPTION"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}*/
					
					String dispBrandSql= "SELECT BRAND.BRAND_CODE, BRAND.DESCRIPTION ,DET.TARGET_QTY, DET.REMARKS AS REMARKS FROM BRAND BRAND, SALES_PERS SP, DND_DEAL DEAL, DND_DEAL_DET DET "+
									"WHERE SP.ITEM_SER = BRAND.ITEM_SER AND SP.SALES_PERS = DEAL.SALES_PERS AND BRAND.BRAND_CODE = DET.BRAND_CODE "+
									"AND DEAL.TRAN_ID = DET.TRAN_ID AND DEAL.APRV_STAT = 'A' AND DEAL.STRG_CODE = ? AND SP.SALES_PERS = ? AND DEAL.EFF_FROM <= ? "+
									"AND DEAL.VALID_UPTO >= ? AND DET.BRAND_CODE = ? AND DEAL.STATUS_DATE = (SELECT MAX(STATUS_DATE) FROM DND_DEAL DND,DND_DEAL_DET DND_DET "+
									"WHERE DND.APRV_STAT = DEAL.APRV_STAT AND DND.STRG_CODE = DEAL.STRG_CODE AND DND.SALES_PERS = SP.SALES_PERS "+
									"AND DND.EFF_FROM <= ? AND DND.VALID_UPTO >= ? AND DND_DET.BRAND_CODE = DET.BRAND_CODE)";

					pstmt = connectionObject.prepareStatement(dispBrandSql) ;
					pstmt.setString(1, custCode);
					pstmt.setString(2, empcode);
					pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setTimestamp(4, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setString(5, brandCode);
					pstmt.setTimestamp(6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					pstmt.setTimestamp(7, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( dispEventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						brandDescr = checkNull(rs.getString("DESCRIPTION"));
						targetQty = checkNull(rs.getString("TARGET_QTY"));
						remarks = checkNull(rs.getString("REMARKS"));
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<brand_descr><![CDATA[" ).append( brandDescr ).append( "]]></brand_descr>\r\n" );                                 //Changed by Niraj s on 14-Dec-2018 for change Item_code to brand_code in display form.
					valueXmlString.append( "<target_qty><![CDATA[" ).append( targetQty ).append( "]]></target_qty>\r\n" );
					valueXmlString.append( "<display_area><![CDATA[").append( remarks ).append("]]></display_area>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n");
				}
			}
            //added by prachi on 03-AUG-22 for collection subform [W22EBAS005]
			else if("collection".equalsIgnoreCase(formName))
			{
				System.out.println("Inside collection subform changes, currentColumn is:"+currentColumn);
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String billamount = getSelectedRowValue(dom2, parentFormNo, "amount", 0);
					int num=1;
					valueXmlString.append( "<Root>\r\n" );
					valueXmlString.append("<Detail"+currentFormNo+" domID='" + num + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(num).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(scCode).append("]]></strg_code>\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<bill_amt><![CDATA[").append(billamount).append("]]></bill_amt>\r\n");
					valueXmlString.append("<bill_date><![CDATA[").append(wrkDate).append("]]></bill_date>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( "" ).append("]]></pay_mode>\r\n");
					valueXmlString.append("<ref_no><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
					valueXmlString.append("<ref_date><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
					valueXmlString.append("<amount><![CDATA[").append( "" ).append("]]></amount>\r\n");
					valueXmlString.append("<ref_bank><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
					valueXmlString.append("<remarks_collect><![CDATA[").append( "" ).append("]]></remarks_collect>\r\n");
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
					valueXmlString.append( "</Root>\r\n" );
				}
				else if(currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					System.out.println("in detail collection...........itm_default_add");
					String salePersCode = "";
					String wrkDate = "";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					String billamount = getSelectedRowValue(dom2, parentFormNo, "amount", 0);
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					
					valueXmlString.append( "<Root>\r\n" );
					valueXmlString.append("<Detail"+currentFormNo+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<bill_amt><![CDATA[").append(billamount).append("]]></bill_amt>\r\n");
					valueXmlString.append("<bill_date><![CDATA[").append(wrkDate).append("]]></bill_date>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( "" ).append("]]></pay_mode>\r\n");
					valueXmlString.append("<ref_no><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
					valueXmlString.append("<ref_date><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
					valueXmlString.append("<amount><![CDATA[").append( "" ).append("]]></amount>\r\n");
					valueXmlString.append("<ref_bank><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
					valueXmlString.append("<remarks_collect><![CDATA[").append( "" ).append("]]></remarks_collect>\r\n");
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
					valueXmlString.append( "</Root>\r\n" );
										
				}
				else if(currentColumn.equalsIgnoreCase("pay_mode"))
				{
					String payMode = checkNull(genericUtility.getColumnValue(currentColumn, dom1));
					
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					else
					{
						domID =domID;
					}
					System.out.println("DomId Value is::"+domID);
					valueXmlString.append( "<Root>\r\n" );
					if(payMode.equalsIgnoreCase("C"))
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<ref_no visible='0'><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
						valueXmlString.append("<ref_date visible='0'><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
						valueXmlString.append("<ref_bank visible='0'><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");

					}
					else
					{
						valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<ref_no visible='1'><![CDATA[").append( "" ).append("]]></ref_no>\r\n");
						valueXmlString.append("<ref_date visible='1'><![CDATA[").append( "" ).append("]]></ref_date>\r\n");
						valueXmlString.append("<ref_bank visible='1'><![CDATA[").append( "" ).append("]]></ref_bank>\r\n");
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}
					valueXmlString.append( "<Root>\r\n" );
					
				}
				
			}
			//prachi end
			else if("team".equalsIgnoreCase(formName) || "retailerteam".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				//System.out.println("in case 4.... team");
				String nMemCode ="";
				if( currentColumn.equalsIgnoreCase("itm_default") )
				{

					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//	String objName = "strg_meet_dcr_wiz";
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					//System.out.println("**********************In WsfaZuviusDsrWizEJB defaultDataDAR : salePersCode : ["+salePersCode+"] wrkDate:["+wrkDate+"] scCode:["+scCode+"]" );
					valueXmlString.append( getSalesTeamDetails( dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,formName, connectionObject, objContext ));//commented by vinayakk
				}
				//added by Bhagyashri T for team subform [03/MAR/2022][START][W21KJOH015]
				else if(currentColumn.equalsIgnoreCase("itm_default_add"))
				{
					//System.out.println("in detail team...........itm_default_add");
					nMemCode = "N" + randomNumberBetween(0, 99999);
					//System.out.println("New membercode is::"+nMemCode);
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					//System.out.println("Dom id in add new::itm_default_add::"+domID);
					valueXmlString.append( "<Root>\r\n" );
					valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					valueXmlString.append("<dcr_id><![CDATA[" ).append("").append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
					valueXmlString.append("<tran_id><![CDATA[").append( "" ).append("]]></tran_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\r\n");
					valueXmlString.append("<member_type visible ='0'><![CDATA[").append("").append("]]></member_type>\r\n");
					valueXmlString.append("<member_name visible ='1'><![CDATA[").append("").append("]]></member_name>\r\n");
					valueXmlString.append("<mem_code visible ='0'><![CDATA[").append( "" ).append("]]></mem_code>\r\n");
					valueXmlString.append("<team_mobile_no visible ='1'><![CDATA[" ).append("").append("]]></team_mobile_no>\r\n");					
					valueXmlString.append("<sales_pers visible ='0'><![CDATA[").append( nMemCode ).append("]]></sales_pers>\r\n");
					//valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("Customer Contact").append("]]></disp_descr>\r\n");
					valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("Customer Representative").append("]]></disp_descr>\r\n");
					valueXmlString.append("</Detail"+objContext+">\r\n" );
					valueXmlString.append( "</Root>\r\n" );
				}
				else if(currentColumn.equalsIgnoreCase("member_type"))
				{
					//System.out.println("in detail team...........itm_default_add member type");
					String memType = checkNull(genericUtility.getColumnValue(currentColumn, dom1));
					
					ArrayList<Integer> domIdList  = getMaxDomIdListFromDom( dom2, "domID" , currentFormNo);
					int domID = Collections.max(domIdList);
					if(memType.equalsIgnoreCase("C") ||memType.equalsIgnoreCase("E"))
					{
						valueXmlString.append( "<Root>\r\n" );
						valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<member_name protect='1' visible ='1'><![CDATA[").append("").append("]]></member_name>\r\n");
						valueXmlString.append("<mem_code visible ='1'><![CDATA[").append( "" ).append("]]></mem_code>\r\n");
						valueXmlString.append("<team_mobile_no protect='1' visible ='1'><![CDATA[" ).append("").append("]]></team_mobile_no>\r\n");					
						if("C".equalsIgnoreCase(memType))
						{
							valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("Customer Contact").append("]]></disp_descr>\r\n");					
						}
						else if("E".equalsIgnoreCase(memType))
						{
							valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("Employee").append("]]></disp_descr>\r\n");					
						}
						else
						{
							valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("").append("]]></disp_descr>\r\n");					
						}
						valueXmlString.append("</Detail"+objContext+">\r\n" );
						valueXmlString.append( "</Root>\r\n" );
					}
					else
					{
						valueXmlString.append( "<Root>\r\n" );
						valueXmlString.append("<Detail"+objContext+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<member_name protect='0' visible ='1'><![CDATA[").append("").append("]]></member_name>\r\n");
						valueXmlString.append("<mem_code visible ='0'><![CDATA[").append( "").append("]]></mem_code>\r\n");
						//valueXmlString.append("<sales_pers visible ='0'><![CDATA[").append( nMemCode ).append("]]></sales_pers>\r\n");
						valueXmlString.append("<team_mobile_no protect='0' visible ='1'><![CDATA[" ).append("").append("]]></team_mobile_no>\r\n");					
						if("R".equalsIgnoreCase(memType))
						{
							valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("Customer Representative").append("]]></disp_descr>\r\n");					
						}
						else if("O".equalsIgnoreCase(memType))
						{
							valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("Others").append("]]></disp_descr>\r\n");					
						}
						else
						{
							valueXmlString.append("<disp_descr visible ='0'><![CDATA[" ).append("").append("]]></disp_descr>\r\n");					
						}
						valueXmlString.append("</Detail"+objContext+">\r\n" );
						valueXmlString.append( "</Root>\r\n" );
					}
				}
				//added by Bhagyashri T [03/MAR/2022][END][W21KJOH015]
			}
			// added by rupali on 11/09/17 fro adding new form on doctor screen [start]
			else if("brandsurvey".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);

					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);

					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getBrandSurveyDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName ));
				}
			}
			// added by rupali on 11/09/17 fro adding new form on doctor screen [end]
			// added by rupali on 12/09/18 for adding survey subform in DAR [start]
			else if("survey".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);

					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String surveyTemplate=getSelectedRowValue(dom2, parentFormNo, "survey_templ", 0);

					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getSurveyDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,surveyTemplate ));
				}
			}
			//Added by Pooja on 18/12/19 [Coaching related detail form implementation] START
			else if("coaching".equalsIgnoreCase(formName))
			{
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("in detail ...........");
					String salePersCode = "";
					String wrkDate = "";
					String vistedWith = "";
					String scCode = "",sprsCodeWrkWith ="";
					//		String objName = "strg_meet_dcr_wiz";
					//System.out.println("Object nAme  value in subform:-  -  "+objName);
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					//System.out.println("ParentForm no is:- "+parentFormNo);
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					vistedWith = getSelectedRowValue(dom2, parentFormNo, "visited_with", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					sprsCodeWrkWith = getSelectedRowValue(dom2, parentFormNo, "sprs_code__ww", 0);
					String shDescr = getSelectedRowValue(dom2, parentFormNo, "sh_descr", 0);
					String eventType = getSelectedRowValue(dom2, parentFormNo, "event_type", 0);
					System.out.println("shDescr  : " + shDescr + " eventType: " + eventType  );
					String coachingTemplate = getSelectedRowValue(dom2, parentFormNo, "coaching_templ", 0);
					System.out.println("coachingTemplate  : " + coachingTemplate );
					//System.out.println("hgjjg : " + salePersCode + " wrkDate: " + wrkDate + " scCode: " + scCode );
					valueXmlString.append( getCoachingDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,coachingTemplate,eventType,shDescr,empDesign,grade,sprsCodeWrkWith,vistedWith ));
				}
			}
			//Added by Pooja on 18/12/19 [Coaching related detail form implementation] END
			//Added by Bhagyashri t For Invoice subform[start][W22EBAS004]
			else if("invoice".equalsIgnoreCase(formName))
			{
				DARCommonBean darCommonBean= new DARCommonBean();
				//System.out.println("Inside Invoice form::"+currentColumn);

				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					System.out.println("in detail of itm_default invoice...........");
					String salePersCode = "";
					String wrkDate = "";
					String scCode = "";
					String parentFormNo = "1";
					salePersCode = getSelectedRowValue(dom2, parentFormNo, "sales_pers", 0);
					wrkDate = getSelectedRowValue(dom2, parentFormNo, "event_date", 0);
					scCode = getSelectedRowValue(dom2, parentFormNo, "strg_code", 0);
					String prcListTemplate=getSelectedRowValue(dom2, parentFormNo, "price_list", 0);
					//System.out.println("Inside the subform invoice prcListTemplate::"+prcListTemplate);
					valueXmlString.append( getInvoiceItemDetails(dom, dom2 , salePersCode, wrkDate, scCode, xtraParams,connectionObject,objContext,formName,prcListTemplate));

				}
				else if( currentColumn.equalsIgnoreCase( "quantity" ))
				{
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					//System.out.println("Inside order quantity itemchange.........currentFormNo.."+currentFormNo);
					String domID=checkNull(getDomID(dom1, ""+currentFormNo));
					if(domID.contains(":") && domID.trim().length() > 0 )
					{
						domID = domID.substring(0, domID.indexOf(":"));
					}
					String parentFormDomId="";
					//System.out.println("dom >>domID::["+domID+"] ");
					String qtyDom = checkNull(genericUtility.getColumnValue("quantity", dom2, ""+currentFormNo, domID));
					String rateDom = checkNull(genericUtility.getColumnValue("rate", dom2, ""+currentFormNo, domID));
					String taxAmt = checkNull(genericUtility.getColumnValue("tax_amt", dom2, ""+currentFormNo, domID));
					System.out.println("qtyDom is as:["+qtyDom+"] ");
					System.out.println("rateDomis as::["+rateDom+"] ");
					double value = 0d;
					double totBasicVal=0.0;
					double totGSTVal=0.0;
					double totAmountVal=0.0;
					String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					parentFormDomId = checkNull(getParentDomID(dom2, parentFormNo , strgCode));
					if(parentFormDomId.contains(":") && parentFormDomId.trim().length() > 0 )
					{
						parentFormDomId = parentFormDomId.substring(0, parentFormDomId.indexOf(":"));
					}
					valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+domID+"' objContext='"+currentFormNo+"' formName='"+formName+"'>\r\n" );
					String totAmtValParent=checkNull(genericUtility.getColumnValue("amount", dom2,""+parentFormNo, parentFormDomId));

					totBasicVal =  getBasicValue( dom2, ""+currentFormNo, "value", strgCode);
					totGSTVal =  getGSTValue( dom2, ""+currentFormNo, "value", strgCode);
					totAmountVal =  getAmountValue( dom2, ""+currentFormNo, "value", strgCode);
					//System.out.println("Total Basic value parent in invoice ::["+totBasicVal+"] ");
					//System.out.println("totGSTVal parent in invoice ::["+totGSTVal+"] ");
					//System.out.println("totAmountVal parent in invoice ::["+totAmountVal+"] ");
					//System.out.println("totAmtValParent parent in invoice ::["+totAmtValParent+"] ");
					if(totAmtValParent == null || totAmtValParent.trim().length() == 0)
					{
						totAmtValParent = "0";
					}
					try
					{
						DecimalFormat df = new DecimalFormat("###.##");
						if(qtyDom != null && qtyDom.trim().length() != 0)
						{
							double qty = 0d;
							double rate = 0d;
							double taxAmount = 0.d;
							qty = Double.parseDouble(qtyDom);
							rate = Double.parseDouble(rateDom);
							//System.out.println("qty in invoice itechange : ["+qty+"]  rate in invoice itemchnage:["+rate+"]");
							taxAmount = Double.parseDouble(taxAmt);
							taxAmount=(taxAmount/100);
							value = ((qty * rate)+taxAmount);
							System.out.println("value in quantity itemchange : ["+value+"]");
							valueXmlString.append("<value><![CDATA[" ).append(df.format(value)).append( "]]></value>\r\n" );
							
						}
						else
						{
							value = 0;
							valueXmlString.append("<value><![CDATA[" ).append("").append( "]]></value>\r\n" );
						}
						valueXmlString.append("<basic_value><![CDATA[" ).append(df.format(totBasicVal)).append( "]]></basic_value>\r\n" );
						valueXmlString.append("<total_gst><![CDATA[" ).append(df.format(totGSTVal)).append( "]]></total_gst>\r\n" );
						valueXmlString.append("<total_value><![CDATA[" ).append(df.format(totAmountVal)).append( "]]></total_value>\r\n" );
						valueXmlString.append("<Detail"+parentFormNo+"."+parentFormDomId+".net_amt><![CDATA[" ).append(df.format(totBasicVal)).append( "]]></Detail"+parentFormNo+"."+parentFormDomId+".net_amt>\r\n" );
						valueXmlString.append("<Detail"+parentFormNo+"."+parentFormDomId+".tax_amount><![CDATA[" ).append(df.format(totGSTVal)).append( "]]></Detail"+parentFormNo+"."+parentFormDomId+".tax_amount>\r\n" );
						valueXmlString.append("<Detail"+parentFormNo+"."+parentFormDomId+".amount><![CDATA[" ).append(df.format(totAmountVal)).append( "]]></Detail"+parentFormNo+"."+parentFormDomId+".amount>\r\n" );
						
						
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}
					catch(NumberFormatException e)
					{
						valueXmlString.append("<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}

				}
			}
			//added by bhagyashri T for Invoice subform[end]
			// added by rupali on 12/09/18 for adding survey subform in DAR [end]
			/*
			else if("sampleorder".equalsIgnoreCase(formName))
			{
				if(currentColumn.equalsIgnoreCase("itm_default"))
				{
					int domID = 1;
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					//String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
					String doctorFormNo= checkNull(getFormNo(objName, "doctor", connectionObject));
					String orderFormNo = checkNull(getFormNo(objName, "sampleorder", connectionObject));
					String sprsCode = checkNull(genericUtility.getColumnValue("sales_pers", dom2, doctorFormNo));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					dcrDate = checkNull(genericUtility.getColumnValue("event_date", dom2 ));
					String ItemDescrList ="";
					try
					{
						String smiQuery = "";
						System.out.println("custList =["+strgCode+"]");
						String dcrID = getDCRId(connectionObject,sprsCode, dcrDate);
						//System.out.println("dcrID>>>"+dcrID);
						smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.SCHEME_CODE,SMO.QUANTITY, SMO.VALUE, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID, "
								+" SMO.STOCKIST_CODE "
								+" FROM STRG_MEET_ORDER SMO, ITEM ITEM"
								+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
								+" AND SMO.DCR_ID =  '"+dcrID+"' "+
								"  AND SMO.STRG_CODE IN ('"+strgCode+"')";
						pstmt = connectionObject.prepareStatement(smiQuery);
						//pstmt.setString(1, strgCode);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							if(ItemDescrList == null && ItemDescrList.length() == 0)
							{
								ItemDescrList = checkNull(rs.getString("ITEMDESCR"));

							}
							else
							{
								ItemDescrList = ItemDescrList +  "," + checkNull(rs.getString("ITEMDESCR"));
							}

							valueXmlString.append( "<Detail"+currentFormNo+" domID='" + domID + "' selected = 'N'>\r\n" );
							valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");//Gaurav Singh on 03/06/15
							valueXmlString.append("<item_descr protect = '1'>").append(checkNull(rs.getString("ITEMDESCR"))).append("</item_descr>\n");
							valueXmlString.append("<quantity>").append("").append("</quantity>\n");//Gulzar
							valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
							valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							valueXmlString.append("<line_no><![CDATA[").append("").append("]]></line_no>\r\n");
							valueXmlString.append("<scheme_code><![CDATA[").append("").append("]]></scheme_code>\n");
							valueXmlString.append("<value>").append("").append("</value>\n");
							valueXmlString.append("<stockist_code><![CDATA[").append("").append("]]></stockist_code>\n");
							//valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
							valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
							domID++;
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						System.out.println("ItemDescrList ["+ItemDescrList+"]");
						if(ItemDescrList == null && ItemDescrList.length() == 0)
						{
							ItemDescrList = "X";

						}
						String Selectsql ="";

						Selectsql = "SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.SCHEME_CODE,SMO.QUANTITY, SMO.VALUE, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID, "
									+" SMO.STOCKIST_CODE "
									+" FROM STRG_MEET_ORDER SMO, ITEM ITEM"
									+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
									+" AND SMO.STRG_CODE IN ('"+strgCode+"')";
						pstmt = connectionObject.prepareStatement(Selectsql);
						//pstmt.setString(1, strgCode);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							valueXmlString.append( "<Detail"+currentFormNo+" domID='" + domID + "' selected = 'N'>\r\n" );
							valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");//Gaurav Singh on 03/06/15
							valueXmlString.append("<item_descr protect = '1'>").append(checkNull(rs.getString("ITEMDESCR"))).append("</item_descr>\n");
							valueXmlString.append("<quantity>").append("").append("</quantity>\n");//Gulzar
							valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
							valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							valueXmlString.append("<line_no><![CDATA[").append("").append("]]></line_no>\r\n");
							valueXmlString.append("<scheme_code><![CDATA[").append("").append("]]></scheme_code>\n");
							valueXmlString.append("<value>").append("").append("</value>\n");
							valueXmlString.append("<stockist_code><![CDATA[").append("").append("]]></stockist_code>\n");
							//valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
							valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
							domID++;
						}

					}
					catch(Exception e)
					{
						System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
						valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
					}
					finally
					{
						try
						{
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

						}
						catch(Exception e)
						{
							System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
							throw new ITMException(e);
						}
					}
				}

			}
			else if("sampleitem".equalsIgnoreCase(formName))
			{
				if (currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					int domID = 1;
					String ItemCodeList = "";
					System.out.println("In itm_default case 3 ::::::: ");
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom1));

					System.out.println("In Detail3: salesPers : [" + salesPers + "]\n strgCode :[" + strgCode + "]\n tranId :[" + tranId + "]");
					if( "".equalsIgnoreCase( checkNull( salesPers ) ) )
					{
						salesPers = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
					}

					String selectSql = " SELECT SM.ITEM_CODE AS ITEM_CODE, SM.QUANTITY AS QUANTITY, ITEM.DESCR AS DESCR" +
									   " FROM STRG_MEET_ITEMS SM, ITEM ITEM WHERE SM.TRAN_ID = ? " +
									   " AND SM.ITEM_CODE = ITEM.ITEM_CODE ";

					pstmt = connectionObject.prepareStatement(selectSql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						if (ItemCodeList == null || ItemCodeList.trim().length() == 0)
						{
							ItemCodeList = checkNull(rs.getString("ITEM_CODE").trim()) ;
						}
						else
						{
							ItemCodeList = ItemCodeList +  "," + checkNull(rs.getString("ITEM_CODE")) ;
						}

						valueXmlString.append( "<Detail3 domID='"+domID+"' >\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<item_code><![CDATA[" ).append(checkNull(rs.getString("ITEM_CODE"))).append( "]]></item_code>\r\n" );
						valueXmlString.append( "<item_descr protect = '1'><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "</Detail3>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("ItemCodeList>>>>>>>========>["+ItemCodeList+"]");
					if( ItemCodeList == null || ItemCodeList.trim().length() == 0 )
					{
						ItemCodeList = "X";
					}

					//SH_DESCR,ITEM_SER,ITEM_TYPE,ACTIVE

					sql = " SELECT  SI.ITEM_CODE, SI.SALES_PERS, ITEM.ITEM_USAGE, ITEM.ITEM_CODE, ITEM.DESCR, ITEM.ITEM_PARNT, ITEM.ITEM_SER, ITEM.GRP_CODE, ITEM.SGRP_CODE, ITEM.UNIT, ITEM.ITEM_TYPE, ITEM.LOC_CODE, ITEM.SITE_CODE FROM ITEM ITEM, SPRS_ITEM SI "
						  + " WHERE SI.ITEM_CODE = ITEM.ITEM_CODE AND SI.SALES_PERS = ? AND SI.STATUS = 'Y' AND  "
						  + " (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0 "
						  + " AND ITEM.ITEM_USAGE  IN ('G','GFT','S','SPK') AND ITEM.ITEM_CODE NOT IN ("+getFormattedStringBuff(ItemCodeList)+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";


					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,salesPers);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						valueXmlString.append( "<Detail3 domID='"+domID+"' >\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<item_code><![CDATA[" ).append(checkNull(rs.getString("ITEM_CODE"))).append( "]]></item_code>\r\n" );
						valueXmlString.append( "<item_descr protect = '1'><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "</Detail3>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("tranId....."+tranId);

				}
				else if(currentColumn.trim().equalsIgnoreCase("item_code" ))
				{
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
					sql = " SELECT DESCR FROM ITEM WHERE ITEM_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,itemCode);
					rs = pstmt.executeQuery();
					System.out.println( " sql sss item[" + sql + "]" );
					if(rs.next())
					{
						valueXmlString.append( "<item_descr protect = '1' ><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></item_descr>\r\n" );
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
					valueXmlString.append( "</Detail3>\r\n" );
				}
			}
			else if("display".equalsIgnoreCase(formName))
			{
				if (currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					int domID = 1;
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					String displayFormNo = checkNull(getFormNo(objName, "display", connectionObject));
					String sprsCode = genericUtility.getColumnValue("sales_pers", dom2, displayFormNo);
					try
					{
						dcrDate = checkNull(genericUtility.getColumnValue("event_date", dom2 ));
						String dcrID = getDCRIdList(connectionObject, sprsCode, dcrDate);

						String sampleQuery="";
						sampleQuery = " SELECT DCR_ID, LINE_NO, STRG_CODE, DOC_ID, DOC_ID_1, DISPLAY_AREA FROM STRG_ITEM_DISPLAY " +
									  " WHERE DCR_ID IN ("+dcrID+")";

						pstmt = connectionObject.prepareStatement(sampleQuery);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							valueXmlString.append("<Detail"+currentFormNo+" domID='" + domID + "' selected = 'Y'>\r\n" );
							valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append("<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
							valueXmlString.append("<line_no><![CDATA[").append("").append("]]></line_no>\r\n");
							valueXmlString.append("<strg_code><![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]></strg_code>\n");
							valueXmlString.append("<doc_id><![CDATA[").append(checkNull(rs.getString("DOC_ID"))).append("]]></doc_id>\n");
							valueXmlString.append("<doc_id_1><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\n");
							valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
							//valueXmlString.append("<display_area_no><![CDATA[" ).append( checkNull(rs.getString("DISPLAY_AREA_NO")) ).append( "]]></display_area_no>\r\n" );
							valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
							domID++;
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					catch(Exception e)
					{
						System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getExistingDndDetailDisplay :" + e.getMessage() + ":" );
						valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
					}
					finally
					{
						try
						{
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						catch(Exception e)
						{
							System.out.println( "Exception :StrgMeetOTCGwtWizardComp :defaultDataWiz :==>\n"+e.getMessage());
							throw new ITMException(e);
						}
					}

				}
			}
			else if("team".equalsIgnoreCase(formName))
			{
				if (currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					System.out.println("In itm_default case 2 ::::::: ");
					String workWith = "";
					int domID = 1;
					String TeamList = "";
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					System.out.println(" Detail 2 :: strgCode ::["+strgCode+"], tranId :: ["+tranId+"]");

					String selectSql = " SELECT ST.SALES_PERS, ST.STRG_CODE, LTRIM(RTRIM(A.EMP_FNAME))||' '||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) || ' (' || LTRIM(RTRIM(A.EMP_CODE)) ||')' AS WORK_WITH " +
									   " FROM EMPLOYEE A, STRG_MEET_TEAM ST WHERE ST.SALES_PERS = A.EMP_CODE AND ST.TRAN_ID =  ? ";
					pstmt = connectionObject.prepareStatement(selectSql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						if (TeamList == null || TeamList.trim().length() == 0)
						{
							TeamList = checkNull(rs.getString("SALES_PERS").trim()) ;
						}
						else
						{
							TeamList = TeamList +  "," + checkNull(rs.getString("SALES_PERS").trim()) ;
						}

						valueXmlString.append( "<Detail2 domID='"+domID+"'>\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("WORK_WITH"))).append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(tranId).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "</Detail2>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					System.out.println("TeamList>>>>>>>========>["+TeamList+"]");
					if( TeamList == null || TeamList.trim().length() == 0 )
					{
						TeamList = "X";
					}

					//SH_DESCR,ITEM_SER,ITEM_TYPE,ACTIVE
					sql = " SELECT LTRIM(RTRIM(A.EMP_FNAME))||' '||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) || ' (' || LTRIM(RTRIM(A.EMP_CODE)) ||')' AS SP_NAME, A.EMP_CODE AS SALES_PERS " +
						  " FROM EMPLOYEE A, GRADE B WHERE A.EMP_CODE IN  ( SELECT REPORT_TO  FROM EMPLOYEE WHERE RELIEVE_DATE IS NULL  START WITH EMP_CODE = ? " +
						  " CONNECT BY PRIOR  REPORT_TO = EMP_CODE) AND A.GRADE = B.GRADE_CODE AND A.EMP_CODE NOT IN ("+getFormattedStringBuff(TeamList)+") ORDER BY DESIGNATION ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,empcode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						valueXmlString.append( "<Detail2 domID='"+domID+"'>\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(tranId).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "</Detail2>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					System.out.println("tranId....."+tranId);

				}
				else if(currentColumn.trim().equalsIgnoreCase("sales_pers" ))
				{
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
					sql = " SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,salesPers);
					rs = pstmt.executeQuery();
					System.out.println( " sql sss team[" + sql + "]" );
					valueXmlString.append( "<Detail3 domID='1'>\r\n" );
					if(rs.next())
					{
						valueXmlString.append( "<sales_pers_sp_name protect = '1' ><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
					valueXmlString.append( "</Detail2>\r\n" );
				}
			}
			 */
			/*case 2:
			{

				if (currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					System.out.println("In itm_default case 2 ::::::: ");
					String workWith = "";
					int domID = 1;
					String TeamList = "";
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					System.out.println(" Detail 2 :: strgCode ::["+strgCode+"], tranId :: ["+tranId+"]");

					String selectSql = " SELECT ST.SALES_PERS, ST.STRG_CODE, LTRIM(RTRIM(A.EMP_FNAME))||' '||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) || ' (' || LTRIM(RTRIM(A.EMP_CODE)) ||')' AS WORK_WITH " +
									   " FROM EMPLOYEE A, STRG_MEET_TEAM ST WHERE ST.SALES_PERS = A.EMP_CODE AND ST.TRAN_ID =  ? ";
					pstmt = connectionObject.prepareStatement(selectSql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						if (TeamList == null || TeamList.trim().length() == 0)
						{
							TeamList = checkNull(rs.getString("SALES_PERS").trim()) ;
						}
						else
						{
							TeamList = TeamList +  "," + checkNull(rs.getString("SALES_PERS").trim()) ;
						}

						valueXmlString.append( "<Detail2 domID='"+domID+"'>\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CODE"))).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("WORK_WITH"))).append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(tranId).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "</Detail2>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					System.out.println("TeamList>>>>>>>========>["+TeamList+"]");
					if( TeamList == null || TeamList.trim().length() == 0 )
					{
						TeamList = "X";
					}

					//SH_DESCR,ITEM_SER,ITEM_TYPE,ACTIVE
					sql = " SELECT LTRIM(RTRIM(A.EMP_FNAME))||' '||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) || ' (' || LTRIM(RTRIM(A.EMP_CODE)) ||')' AS SP_NAME, A.EMP_CODE AS SALES_PERS " +
						  " FROM EMPLOYEE A, GRADE B WHERE A.EMP_CODE IN  ( SELECT REPORT_TO  FROM EMPLOYEE WHERE RELIEVE_DATE IS NULL  START WITH EMP_CODE = ? " +
						  " CONNECT BY PRIOR  REPORT_TO = EMP_CODE) AND A.GRADE = B.GRADE_CODE AND A.EMP_CODE NOT IN ("+getFormattedStringBuff(TeamList)+") ORDER BY DESIGNATION ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,empcode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						valueXmlString.append( "<Detail2 domID='"+domID+"'>\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name protect = '1'><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(tranId).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "</Detail2>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					System.out.println("tranId....."+tranId);

				}
				else if(currentColumn.trim().equalsIgnoreCase("sales_pers" ))
				{
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
					sql = " SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,salesPers);
					rs = pstmt.executeQuery();
					System.out.println( " sql sss team[" + sql + "]" );
					valueXmlString.append( "<Detail3 domID='1'>\r\n" );
					if(rs.next())
					{
						valueXmlString.append( "<sales_pers_sp_name protect = '1' ><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
					valueXmlString.append( "</Detail2>\r\n" );
				}
				break;
			}//case 2 end
			case 3:
			{

				if (currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					int domID = 1;
					String ItemCodeList = "";
					System.out.println("In itm_default case 3 ::::::: ");
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom1));
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom1));

					System.out.println("In Detail3: salesPers : [" + salesPers + "]\n strgCode :[" + strgCode + "]\n tranId :[" + tranId + "]");
					if( "".equalsIgnoreCase( checkNull( salesPers ) ) )
					{
						salesPers = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
					}

					String selectSql = " SELECT SM.ITEM_CODE AS ITEM_CODE, SM.QUANTITY AS QUANTITY, ITEM.DESCR AS DESCR" +
									   " FROM STRG_MEET_ITEMS SM, ITEM ITEM WHERE SM.TRAN_ID = ? " +
									   " AND SM.ITEM_CODE = ITEM.ITEM_CODE ";

					pstmt = connectionObject.prepareStatement(selectSql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						if (ItemCodeList == null || ItemCodeList.trim().length() == 0)
						{
							ItemCodeList = checkNull(rs.getString("ITEM_CODE").trim()) ;
						}
						else
						{
							ItemCodeList = ItemCodeList +  "," + checkNull(rs.getString("ITEM_CODE")) ;
						}

						valueXmlString.append( "<Detail3 domID='"+domID+"' >\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<item_code><![CDATA[" ).append(checkNull(rs.getString("ITEM_CODE"))).append( "]]></item_code>\r\n" );
						valueXmlString.append( "<item_descr protect = '1'><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "</Detail3>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("ItemCodeList>>>>>>>========>["+ItemCodeList+"]");
					if( ItemCodeList == null || ItemCodeList.trim().length() == 0 )
					{
						ItemCodeList = "X";
					}

					//SH_DESCR,ITEM_SER,ITEM_TYPE,ACTIVE

					sql = " SELECT  SI.ITEM_CODE, SI.SALES_PERS, ITEM.ITEM_USAGE, ITEM.ITEM_CODE, ITEM.DESCR, ITEM.ITEM_PARNT, ITEM.ITEM_SER, ITEM.GRP_CODE, ITEM.SGRP_CODE, ITEM.UNIT, ITEM.ITEM_TYPE, ITEM.LOC_CODE, ITEM.SITE_CODE FROM ITEM ITEM, SPRS_ITEM SI "
						  + " WHERE SI.ITEM_CODE = ITEM.ITEM_CODE AND SI.SALES_PERS = ? AND SI.STATUS = 'Y' AND  "
						  + " (CASE WHEN SI.QUANTITY IS NULL THEN 0 ELSE SI.QUANTITY END - CASE WHEN SI.ISSUE_QTY IS NULL THEN 0 ELSE SI.ISSUE_QTY END ) > 0 "
						  + " AND ITEM.ITEM_USAGE  IN ('G','GFT','S','SPK') AND ITEM.ITEM_CODE NOT IN ("+getFormattedStringBuff(ItemCodeList)+") ORDER BY ITEM.ITEM_USAGE,ITEM.DESCR ";


					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,salesPers);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						valueXmlString.append( "<Detail3 domID='"+domID+"' >\r\n" );
						valueXmlString.append( "<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append("").append( "]]></line_no>\r\n" );
						valueXmlString.append( "<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append( "<strg_code><![CDATA[" ).append(strgCode).append( "]]></strg_code>\r\n" );
						valueXmlString.append( "<item_code><![CDATA[" ).append(checkNull(rs.getString("ITEM_CODE"))).append( "]]></item_code>\r\n" );
						valueXmlString.append( "<item_descr protect = '1'><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "</Detail3>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("tranId....."+tranId);

				}
				else if(currentColumn.trim().equalsIgnoreCase("item_code" ))
				{
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
					sql = " SELECT DESCR FROM ITEM WHERE ITEM_CODE = ? ";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,itemCode);
					rs = pstmt.executeQuery();
					System.out.println( " sql sss item[" + sql + "]" );
					if(rs.next())
					{
						valueXmlString.append( "<item_descr protect = '1' ><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></item_descr>\r\n" );
					}
					rs = ( rs!=null )? null : rs;
					pstmt = ( pstmt!=null )? null : pstmt;
					valueXmlString.append( "</Detail3>\r\n" );
				}

				break;
			}//case 3 end
			case 4 :
			{
				System.out.println("@@@@@@@@@@@@@@@ In Detail 4 @@@@@@@@@@@@@@@:::::PITCH ");
				if( currentColumn.equalsIgnoreCase("itm_default") )
				{
					String PitchList = "";
					String wrkDateInDbFmt = "";
					String callOutcome = "";
					int domID = 1;
					tranId = checkNull(genericUtility.getColumnValue("tran_id", dom1));
					strgCode = checkNull(genericUtility.getColumnValue("strg_code", dom2));
					eventDate = checkNull(genericUtility.getColumnValue("event_date", dom1));
					salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom1));
					callOutcome = checkNull(genericUtility.getColumnValue("call_outcome", dom2));
					System.out.println( "callOutcome:::["+ callOutcome +"]  strgCode::["+strgCode+"]");


					if ( eventDate != null )
					{
						wrkDateInDbFmt = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy");
					}

					System.out.println("In Detail4: salesPers : [" + salesPers + "]\n strgCode :[" + strgCode + "]\n tranId :[" + tranId + "]\n wrkDateInDbFmt ::["+wrkDateInDbFmt+"]");
					if( "".equalsIgnoreCase( checkNull( salesPers ) ) )
					{
						salesPers = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
					}

					String sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SALES_PERS = '"+salesPers+"' AND WORK_DATE = '"+wrkDateInDbFmt+"' AND SC_CODE='"+strgCode+"' ";
					System.out.println("In RealTimeReport getPitchDetails :: salesPers : " + salesPers + "\n xtraParams :" + xtraParams );

					pstmt = connectionObject.prepareStatement(sdQuery);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						//String item = checkNull(rs.getString("DESCR"));
						String brand = checkNull(rs.getString("BRAND_DESCR"));

						if (PitchList == null || PitchList.trim().length() == 0)
						{
							PitchList = checkNull(rs.getString("BRAND_CODE")) ;
						}
						else
						{
							PitchList = PitchList +  "," + checkNull(rs.getString("BRAND_CODE").trim()) ;
						}

						valueXmlString.append("<Detail4 domID='"+domID+"'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
						valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
						valueXmlString.append("<work_date><![CDATA[" ).append(eventDate).append( "]]></work_date>\r\n" );
						valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salesPers)).append("]]></sales_pers>\n");
						valueXmlString.append("<sc_code><![CDATA[").append( checkNull( strgCode ) ).append("]]></sc_code>\r\n");
						valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
						valueXmlString.append("<pitch_detail><![CDATA[").append( checkNull(rs.getString("PITCH_DETAIL")) ).append("]]></pitch_detail>\r\n" );
						valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
						valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
						valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
						valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );
						valueXmlString.append("<tran_id><![CDATA[" ).append(tranId).append( "]]></tran_id>\r\n" );
						valueXmlString.append("<pitch_sequence><![CDATA[]]></pitch_sequence>\r\n" );
						valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
						valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
						valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
						valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
						valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
						valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
						valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
						valueXmlString.append("<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
						valueXmlString.append("</Detail4>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					System.out.println("PitchList>>>>>>>========>["+PitchList+"]");
					if( PitchList == null || PitchList.trim().length() == 0 )
					{
						PitchList = "X";
					}

					sdQuery = " SELECT BRAND.BRAND_CODE, BRAND.DESCRIPTION " +
							  " FROM BRAND BRAND, SALES_PERS SALES_PERS "+
							  " WHERE  SALES_PERS.ITEM_SER = BRAND.ITEM_SER AND BRAND.BRAND_CODE NOT IN ("+getFormattedStringBuff(PitchList)+") "+
							  " AND SALES_PERS.SALES_PERS = ? ORDER BY BRAND.BRAND_CODE ";

					pstmt = connectionObject.prepareStatement(sdQuery);
					pstmt.setString(1,salesPers);
					rs = pstmt.executeQuery();
					while(rs.next())
					{

						//String item = checkNull(rs.getString("DESCR"));
						String brand = checkNull(rs.getString("DESCRIPTION"));
						//itemCode = checkNull( rs.getString("ITEM_CODE") );

						valueXmlString.append("<Detail4 domID='"+domID+"'>\r\n" );
						valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
						valueXmlString.append("<work_date><![CDATA[" ).append(eventDate).append( "]]></work_date>\r\n" );
						valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salesPers)).append("]]></sales_pers>\n");
						valueXmlString.append("<sc_code><![CDATA[").append( checkNull( strgCode ) ).append("]]></sc_code>\r\n");
						valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
						valueXmlString.append("<pitch_detail><![CDATA[]]></pitch_detail>\r\n" );
						valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
						valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
						valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
						valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );
						valueXmlString.append("<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append("<pitch_sequence><![CDATA[]]></pitch_sequence>\r\n" );
						valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
						valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
						valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
						valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
						valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
						valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
						valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
						valueXmlString.append("<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
						valueXmlString.append("</Detail4>\r\n" );
						domID++;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			break;*/

			//switch statement ends here
			valueXmlString.append( "</Root>\r\n" );
		}//try block ends here
		catch(Exception e)
		{
			System.out.println( "Exception :RealTimeReport :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				if(rs2 != null)
				{
					rs2.close();
					rs2 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
	            }
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealTimeReportEJB:defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}

		System.out.println( "\n****ValueXmlString :::::::::::" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	/*private String checkNull(String input)
	{
		if (input == null)
		{
			input="";
		}
		return input.trim();
	}*/
	private String getObjName(Document dom2,String objContext)
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}
	private String getStringFromDocument(Document doc)
	{
		try
		{
			DOMSource domSource = new DOMSource(doc);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			transformer.transform(domSource, result);
			return writer.toString();
		}
		catch(TransformerException ex)
		{
			ex.printStackTrace();
			return null;
		}
	}
	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}
	public String getTranId( Connection conn )throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String tranID = "";
		String sqlTranId = "";
		try
		{
			sqlTranId = "SELECT TRAN_ID_SEQ.NEXTVAL AS TRAN_ID FROM DUAL";
			pstmt = conn.prepareStatement(sqlTranId);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				tranID = rs.getString("TRAN_ID");
			}

			String tmp1  = "000000000000000000000000"+tranID;
			int tm_len = tmp1.length()-10  ;
			tranID = tmp1.substring(tm_len ) ;

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			//System.out.println("tranID :: ["+tranID+"]");
		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +sqlTranId+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
		return tranID;
	}//generateTranTd()
	public String wfValPitchDetail(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String errString1 = "";
		String childNodeName = "";
		String columnValue = "";
		ITMDBAccessEJB itmDBAccessLocal = null;//modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;

		String lineNo = "";

		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentNodeListLength(wfValPitchDetail)["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String salesCode = getSelectedRowValue(dom, currentFormNo, "sales_pers",prntCtr);
				String custCode = getSelectedRowValue(dom, currentFormNo, "sc_code",prntCtr);
				String sprsProdGrp = getSelectedRowValue(dom, currentFormNo, "sc_type", prntCtr);
				String itemCode = getSelectedRowValue(dom, currentFormNo, "item_code",prntCtr);
				String itemDescr = getSelectedRowValue(dom, currentFormNo, "item_descr",prntCtr);
				String brandCode = getSelectedRowValue(dom, currentFormNo, "brand_code",prntCtr);
				String brandDescr = getSelectedRowValue(dom, currentFormNo, "brand_descr",prntCtr);
				String strgName = getSelectedRowValue(dom, currentFormNo, "strg_name",prntCtr);


				lineNo = getSelectedRowValue(dom, currentFormNo, "line_no",prntCtr).trim();

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();

				if( !"".equalsIgnoreCase( lineNo ) )
					for (ctr = 0; ctr < noOfChilds; ctr++)
					{

						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("sales_pers"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Inside  sales_pers null");
								errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSALESP",userId);
								break;
							}

						}
						else if(childNodeName.equalsIgnoreCase("sc_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Inside sc_code null ");
								errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSCCODE",userId);
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("brand_code"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Inside brand_code null ");
								errString = itmDBAccessLocal.getErrorString("sales_pers","NULLBRCODE",userId);
								break;
							}
						}
						else if(childNodeName.equalsIgnoreCase("pitch_detail"))
						{
							if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
							{
								//System.out.println("Inside pitch_detail null ");
								errString = itmDBAccessLocal.getErrorString("pitch_detail","NULLPITCDT",userId);
								break;
							}
						}
						/*else if(childNodeName.equalsIgnoreCase("item_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							System.out.println("Inside item_code null ");
							errString = itmDBAccessLocal.getErrorString("sales_pers","NULITMCODE",userId);
							break;
						}
					}*/

					}
				if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						//errString = getItemErrorString( errString,  strgName, brandDescr, brandCode, sprsProdGrp, userId);
						//break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}
				}
			}

		}
		catch(Exception e)
		{
			System.out.println ( "Exception :RealTimeReportEJB :wfValPitchDetail():" + e.getMessage() + ":" );
			errString = generateErrorString(genericUtility.createErrorString(e));
		}
		return errString;
	}
	public String generateErrorString(String errorString)
	{
		return ("<Error><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Error>");

	}
	/*
	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			//Modified by Abhishek on [23/04/2012][To resolve the issue at live server of getting nullpointer exception][Start]
			if (detailList == null || detailList.getLength() == 0)
			{
				return "";
			}
			//Modified by Abhishek on [23/04/2012][To resolve the issue at live server of getting nullpointer exception][End]
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}
	 */
	private String getItemErrorString( String errString, String custName ,String itemDescr, String itemCode, String sprsProdGrp, String userId) throws ITMException
	{
		String sql = "";
		String custCode = "";
		String msgDescr = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();

			sql = "SELECT UPPER(FIRST_NAME)||\' \'||UPPER(LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(custCode));
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				custName = rSet.getString("SC_NAME");
			}

			if (rSet != null)
			{
				rSet.close();
				rSet = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(itemCode.length() != 0 && !itemCode.equalsIgnoreCase(""))
			{
				itemDescr = " Status for "+ itemDescr;
			}
			else if( sprsProdGrp.length() != 0 && !sprsProdGrp.equalsIgnoreCase(""))
			{
				itemDescr = " Status for " + itemDescr;
			}
			if(custName == null || custName.trim().length() == 0 )
			{
				sql = "SELECT CLIENT_NAME FROM DR_UNLIST WHERE SALES_PERS = ? AND SC_CODE = ? ";
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, checkNull(userId));
				pstmt.setString(2, checkNull(custCode));
				rSet = pstmt.executeQuery();
				if(rSet.next())
				{
					custName = rSet.getString("CLIENT_NAME");
				}
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}



			msgDescr = getMsgDescrFromErrTag(errString)+ "" +itemDescr+ " selected for " + custName;


			msgDescr = "<![CDATA["+msgDescr+"]]>";
			//System.out.println("msgDescr=5::"+msgDescr);



			errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
		}

		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rSet !=null )
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt= null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}
	private String getMsgDescrFromErrTag(String msgDescr)
	{
		//System.out.println("In getMsgDescrFromErrTag msgDescr"+msgDescr);
		String errString = "";
		if(msgDescr == null )
		{
			return " ";
		}
		if(msgDescr != null && msgDescr.trim().length() > 0)
		{

			if(msgDescr.contains("<![CDATA["))
			{
				int msgDescrStart =  msgDescr.indexOf("<description>");
				int msgLengthStart = msgDescr.indexOf("<![CDATA[",msgDescrStart);
				int msgLengthEnd = msgDescr.indexOf("]",msgLengthStart);
				//System.out.println("length"+msgDescrStart+msgLengthStart+msgLengthEnd);
				errString =  msgDescr.substring(msgLengthStart+9,msgLengthEnd);
				//System.out.println("In getMsgDescrFromErrTag value " +errString);
			}
		}
		return errString;

	}
	private String getUnlistSccode(Connection conn, String scType)throws ITMException
	{
		String unlistScCode ="";
		PreparedStatement pstmtNextSeq = null;
		ResultSet rsNextSeq = null;
		try
		{
			String nextSeq = "";
			String tempScCode = "0000000000";
			String getNextSeqSql = "SELECT dr_unlist_client_seq.NEXTVAL AS NEXT_SEQ FROM DUAL";
			pstmtNextSeq = conn.prepareStatement(getNextSeqSql);
			rsNextSeq = pstmtNextSeq.executeQuery();
			if(rsNextSeq.next())
			{
				nextSeq = rsNextSeq.getString("NEXT_SEQ");
			}
			tempScCode = tempScCode + nextSeq;
			unlistScCode = scType + tempScCode.substring(tempScCode.length()-9);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsNextSeq != null)
				{
					rsNextSeq.close();
					rsNextSeq = null;
				}
				if (pstmtNextSeq != null)
				{
					pstmtNextSeq.close();
					pstmtNextSeq = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		return unlistScCode;
	}
	public String getItemDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject, String formNo,String formName,String prcListTemp  ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}

			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				if(newScCode == null || newScCode.trim().length() == 0)
				{
					newScCode = "''";
				}
				//System.out.println("getItemDetails >> newScCode=["+newScCode+"]");
				selectedItem = getExistingItemsDetail( salePersCode, wrkDate , newScCode, formNo,formName,connectionObject) ;
			}
			selectedItem = "<Root>" + selectedItem + "</Root>";
			//System.out.println("selectedItem>>>"+selectedItem);
			//String itemDetails = getSalesPersItemList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName,dom2);
			String itemDetails = getSalesPersItemList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName,dom2,prcListTemp );

			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
	private String getDomID(Document dom2,String objContext)
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null)
				{
					objName = etlAttributes.getNamedItem("domID").getNodeValue();
				}
			}
		}
		return objName;
	}
	private String getParentDomID(Document dom2,String parentFormNo, String strgCode)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String prntdomId = "";
		String domId = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;

		double totalValue = 0d;
		try
		{
			//System.out.println("getParentDomID strgCode["+strgCode+"]");
			parentList = dom2.getElementsByTagName("Detail"+ parentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("getParentDomID parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}

				if(currDetail.getAttributes().getNamedItem("domID") != null)
				{
					domId = currDetail.getAttributes().getNamedItem("domID").getNodeValue();
					//System.out.println("domId :::["+domId+"]");
				}
				if(domId != null && domId.trim().length() > 0 && domId.contains(strgCode))
				{
					prntdomId = domId;
					//System.out.println("prntdomId ::::::["+prntdomId+"]");
					break;
				}

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				//System.out.println("noOfChilds["+noOfChilds+"]");
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					//System.out.println("childNodeName =["+childNodeName+"] columnValue =["+columnValue+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							//System.out.println("getParentDomID updateFlag["+updateFlag+"]");
							if(updateFlag != null && updateFlag.trim().length() > 0 && "D".equalsIgnoreCase(updateFlag) )
							{
								break;
							}
						}
					}

				}

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getParentDomID :::["+prntdomId+"]");
		return prntdomId;
	}
	private double getTotalPOBValue(Document dom2,String currentFormNo, String value, String strgCode)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
		int parentNodeListLength = parentList.getLength();
		//System.out.println("getTotalPOBValue parentNodeListLength--["+parentNodeListLength+"] strgCode [ "+strgCode+"], currentFormNo=["+currentFormNo+"]");
		double totalValue = 0d;
		try
		{
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				//System.out.println("noOfChilds =["+noOfChilds+"]");
				String landingRate = "0";
				String quantity = "0";
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = checkNull(childNode.getNodeName());
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					//changes done by Prathamesh Jangam on 30th March2017 for sum of selected item to be display on doctor POB value--started
					//System.out.println("childNodeName =["+childNodeName+"] columnValue =["+columnValue+"]");
					/*if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							System.out.println("getTotalPOBValue updateFlag["+updateFlag+"]");
							if(updateFlag != null && updateFlag.trim().length() > 0 && "D".equalsIgnoreCase(updateFlag) )
							{
								continue;
						}
					}
					}*/

					/*if(childNodeName.equalsIgnoreCase("strg_code_dummy"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							String strgCodeDum = childNode.getFirstChild().getNodeValue();
							System.out.println("strgCodeDum :["+strgCodeDum+"]");
							if(strgCodeDum != null && strgCodeDum.trim().length() > 0)
							{
								if(strgCodeDum.equals(strgCode) )
								{
									System.out.println("strgCode is equals....");
									//continue;
								}
								else
								{
									System.out.println("strgCode is not equals....");
									//break;
								}
							}
							else
							{
								System.out.println("strgCode is not equals");
							}
						}
					}*/
					if(childNodeName.equalsIgnoreCase("quantity"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							quantity = checkNull(childNode.getFirstChild().getNodeValue());
							if(quantity.length() == 0)
							{
								quantity = "0";
							}
						}
						else
						{
							quantity = "0";
						}
					}
					else if(childNodeName.equalsIgnoreCase("landing_rate"))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							landingRate = checkNull(childNode.getFirstChild().getNodeValue());
							if(landingRate.length() == 0)
							{
								landingRate = "0";
							}
						}
						else
						{
							landingRate = "0";
						}
					}
					/*if(childNodeName.equalsIgnoreCase(checkNull(value)))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{

							double eachVal = Double.parseDouble(columnValue);
							System.out.println("value::::["+eachVal+"]");
							totalValue = totalValue + eachVal;
						}
					}*/
				}
				//System.out.println("quantity =["+quantity+"], landingRate=["+landingRate+"]");
				if(quantity != null && quantity.length()> 0 && landingRate != null && landingRate.length() > 0)
				{
					totalValue = totalValue + (Double.parseDouble(quantity)* Double.parseDouble(landingRate));
				}
				//changes done by Prathamesh Jangam on 30th March2017 for sum of selected order to be display on doctor POB value--ended
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("getTotalPOBValue for strgCode "+strgCode+":::["+totalValue+"]");
		return totalValue;
	}
	public String getSalesTeamDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams,String formName, Connection connectionObject,String formNo ) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedTeam = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			//System.out.println("Printing DOM + "+genericUtility.serializeDom(dom)+"+++++++++++++++");
			//System.out.println("Printing DOM222 + "+genericUtility.serializeDom(dom2)+"+++++++++++++++");
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}


			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedTeam = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
				//System.out.println("previous form values for team : - "+selectedTeam);
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				selectedTeam = getSalesExistingTeamDetail( salePersCode, wrkDate , newScCode, formNo ,formName,connectionObject) ;
			}
			selectedTeam = "<Root>" + selectedTeam + "</Root>";
			//System.out.println("selectedTeam>>>"+selectedTeam);
			String itemDetails = getSalesPersTeamList(dom,dom2, salePersCode, scCode, selectedTeam, wrkDate,formNo,formName);
			//TODO


			//System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}	*/
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
	public String getExistingItemsDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==null )
			{

				connectionObject = getConnection();
				isLocalConn =true;
			}
			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);
			//System.out.println("dcrID>>>"+dcrID);
			//added lot_no and stock_qty fields in sql by rupali on 30/10/17 for getting field value edit mode
			smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.SCHEME_CODE,SMO.QUANTITY, SMO.VALUE, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID,SMO.PROMO_PERC, "// added by mrunalini sinkar PROMO_PERC on 10/04/2019 
					+" SMO.STOCKIST_CODE, SMO.RATE, SMO.DISC_PERC, SMO.LOT_NO, SMO.STOCK_QTY, SMO.STOCK_INFO,SMO.PROMO_CODE " // added stock_info column by rupali on 22/12/17 for getting data in edit mode
					+" FROM STRG_MEET_ORDER SMO, ITEM ITEM"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.DCR_ID =  '"+dcrID+"' "+
					"   AND SMO.STRG_CODE IN (" + custList + ")";
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String item = checkNull(rs.getString("ITEMDESCR"));
				//System.out.println("item["+item+"]");

				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
				if( !item.equals("") )
				{
					//valueXmlString.append("<item_descr>").append( item ).append("</item_descr>\n");
					valueXmlString.append("<item_descr><![CDATA[").append(item).append("]]></item_descr>\n");


				}

				valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
				valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
				valueXmlString.append("<scheme_code><![CDATA[").append(checkNull(rs.getString("SCHEME_CODE"))).append("]]></scheme_code>\n");
				valueXmlString.append("<value>").append(checkNull(rs.getString("VALUE"))).append("</value>\n");
				valueXmlString.append("<stockist_code><![CDATA[").append(checkNull(rs.getString("STOCKIST_CODE"))).append("]]></stockist_code>\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				//added by rupali on 10/09/17 for dispaly rate and discount date on edit mode [start]
				valueXmlString.append( "<rate><![CDATA[" ).append(checkNull(rs.getString("RATE"))).append( "]]></rate>\r\n" );
				valueXmlString.append( "<disc_perc><![CDATA[" ).append(checkNull(rs.getString("DISC_PERC"))).append( "]]></disc_perc>\r\n" );
				//added by rupali on 10/09/17 for dispaly rate and discount date on edit mode [end]
				//added by rupali on 30/10/17 for dispaly lot_no and stock_qty on edit mode [start]
				valueXmlString.append( "<lot_no><![CDATA[" ).append(checkNull(rs.getString("LOT_NO"))).append( "]]></lot_no>\r\n" );
				valueXmlString.append( "<stock_qty><![CDATA[" ).append(checkNull(rs.getString("STOCK_QTY"))).append( "]]></stock_qty>\r\n" );
				//added by rupali on 30/10/17 for dispaly lot_no and stock_qty on edit mode [end]
				valueXmlString.append( "<stock_info><![CDATA[" ).append(checkNull(rs.getString("STOCK_INFO"))).append( "]]></stock_info>\r\n" ); // added stock_info column by rupali on 22/12/17 for getting data in edit mode
				valueXmlString.append( "<promo_code><![CDATA[" ).append(checkNull(rs.getString("PROMO_CODE"))).append( "]]></promo_code>\r\n" ); // added promo_code column by rupali on 11/12/18 for getting data in edit mode
				valueXmlString.append( "<promo_perc><![CDATA[" ).append(checkNull(rs.getString("PROMO_PERC"))).append( "]]></promo_perc>\r\n" ); // added by mrunalini sinkar PROMO_PERC on 10/04/2019

				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	private String getSalesExistingTeamDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{

		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);
			//System.out.println("dcrID>>>"+dcrID);

			smiQuery= "SELECT DISTINCT ST.TRAN_ID AS TRAN_ID,ST.DCR_ID AS DCR_ID, ST.SALES_PERS AS SALES_PERS ,ST.STRG_CODE AS STRG_CODE , UPPER(EMP.EMP_FNAME) ||' ' ||UPPER(EMP.EMP_MNAME) ||' '|| UPPER(EMP.EMP_LNAME) AS EMP_NAME, " +
					"EMP.DESIGNATION DESIGNATION FROM STRG_MEET_TEAM ST LEFT OUTER JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE " +
					"WHERE ST.DCR_ID = '"+dcrID+"' AND STRG_CODE IN("+custList+")";




			//System.out.println(" StrgMeetSQL[ ---- >] "+smiQuery);
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String salesPers = checkNull(rs.getString("SALES_PERS"));
				String dispName = checkNull(getEmpNameDesign(salesPers,connectionObject));//added by mrunalini sinkar 
				String empDesign = getDesignName(salesPers, connectionObject); 
				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<name>").append(rs.getString("emp_name")).append("</name>\n");//Gulzar
				valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(rs.getString("SALES_PERS"))).append("]]></sales_pers>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
				valueXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n"); // added by rupali on 23/02/18 for edit mode of realtime report
				valueXmlString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n"); //added by bhagyashri T for Team subform[W21KJOH015]
				valueXmlString.append("<visited_with_display><![CDATA[" ).append(checkNull(dispName)).append( "]]></visited_with_display>\r\n" );
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	public String getSalesPersTeamList(Document dom,Document dom2, String sprsCode, String strgCode, String selectedTeam, String eventDate, String formNo, String formName ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer selectedXmlString = new StringBuffer();
		StringBuffer unselectedString = new StringBuffer();
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String name = "";
		int maxLineNo = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		String custTranID = null;
		int modeCounter = 0;
		String workWith = "";
		boolean isLocal = false ;

		//String objName = checkNull(getObjNameFromDom(dom2, "objName",formNo));
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocal = true;
			}
			String objName = "strg_meet_dcr_realtime_wiz"; //added by rupali on 15/09/17 for worked with field
			String parentFormNo = checkNull(getParentformNo(formNo, objName, connectionObject ));
			//	workWith = checkNull(genericUtility.getColumnValue("select_team", dom2, parentFormNo)); //commented by rupali on 18/09/17 for worked with field
			workWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, parentFormNo)); //added by rupali on 15/09/17 for worked with field
			//	System.out.println("Visited with value is +="+workWith);
			List workWithListForm = null;
			String workWithCodeList = "";
			if(workWith != null && workWith.trim().length() > 0)
			{
				String workWithCode[] = workWith.split(",");

				int totalFieldNo = workWithCode.length;

				//System.out.println("totalFieldNo ::"+totalFieldNo);

				for ( int i = 0; i < totalFieldNo; i++ )
				{
					String code = workWithCode[i];
					if(code.indexOf("(") != -1)
					{
						code = code.substring(code.indexOf("(")+1,code.indexOf(")")).trim();
					}

					workWithCodeList = workWithCodeList + code + ",";
				}
				workWithCodeList = workWithCodeList.substring(0, workWithCodeList.lastIndexOf(","));

				//System.out.println( "workWithCodeList ::::: "+ workWithCodeList);
				String wrkWith = workWithCodeList;
				workWithListForm = Arrays.asList(wrkWith.split(","));
				//System.out.println("value in workWithListForm is:- "+workWithListForm);
			}
			//System.out.println("Printing getDrSalesPersTeamList DOM + "+genericUtility.serializeDom(dom)+"+++++++++++++++");
			//System.out.println("Printing getDrSalesPersTeamList DOM222 + "+genericUtility.serializeDom(dom2)+"+++++++++++++++");
			valueXmlString.append( "<Root>\r\n" );
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			//connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			/*
			sql1 =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ," +
					"PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";
			 */
			// added by rupali on 13/04/18 for org_structure related changes [start]
			ArrayList salesPersList = new ArrayList();
			String salesPersTemp="";
			String isOrgStrcture = getSfaParmValue(sprsCode,"HIERARCY_FRM_ORG_STR",connectionObject);
			OrgStructure orgStructure = new OrgStructure();
			String itemSer=checkNull(getItemSer(sprsCode, connectionObject));
			String isFortuneAct = getSfaParmValue(sprsCode,"IS_FORTUNE_ACTIVITY",connectionObject);
			//System.out.println("isFortuneAct is in realtime::::"+isFortuneAct);
			DARCommonBean darCommonBean= new DARCommonBean();
			HashMap<String, String> employeeDesignationMap=darCommonBean.getEmployeeDesignationMap(itemSer,connectionObject);
			//System.out.println("employeeDesignationMap is["+employeeDesignationMap+"]");

			if("Y".equalsIgnoreCase(isOrgStrcture))
			{
				salesPersList = orgStructure.reportToUp(sprsCode,eventDate,connectionObject);
				salesPersTemp = orgStructure.getFormattedList(salesPersList);
			}
			
			//Changed & Added By Vikas Lagad on 23-12-2019 [Changed logic for JNJ_coaching manager in team detail form ]Start
			String teamGradeLevel = "";
			sql = "select parm_value from sfaparm WHERE parm_name = ? and active = ? ";
			PreparedStatement pstmt1= connectionObject.prepareStatement(sql);
			pstmt1.setString(1, "TEAM_GRADE_LEV");
			pstmt1.setString(2, "Y");
			ResultSet rs1= pstmt1.executeQuery();
			
			if(rs1.next())
			{
				teamGradeLevel = checkNull(rs1.getString(1));
			}
			else
			{
				teamGradeLevel = "4";
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			

			String scCodeteam =strgCode.trim();
			if(salesPersList != null && !salesPersList.isEmpty())
			{
				//sql1 ="SELECT EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO <='"+teamGradeLevel+"' ORDER BY GRADE.LEVEL_NO DESC";
				/*sql = "SELECT DISTINCT '2' AS SR_NO,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO " + 
						"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
						"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
						"UNION "+
						"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO "+
						 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY SR_NO,LEVEL_NO DESC";*/
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("Y".equalsIgnoreCase(isFortuneAct))
				{
					sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' ORDER BY LEVEL_NO DESC";
				}
				else
				{
					//Changes made by Rahul P. on 26-Sep-2023 [Start] set ENTITY_TYPE='R'
					/*sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+ 
							 "UNION "+
							 "SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							 "FROM ENTITY_CONTACT WHERE ENTITY_TYPE='C' AND ENTITY_CODE ='"+scCodeteam+"' " +
							 "ORDER BY SR_NO,LEVEL_NO DESC";*/
					sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersTemp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+ 
							 "UNION "+
							 "SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							 "FROM ENTITY_CONTACT WHERE ENTITY_TYPE='R' AND ENTITY_CODE ='"+scCodeteam+"' " +
							 "ORDER BY SR_NO,LEVEL_NO DESC";
					//Changes made by Rahul P. on 26-Sep-2023 [End]
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]

			}
			else
			{
				ArrayList teamList = new ArrayList();

				String teamSql="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR  REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
				PreparedStatement teamPstmt= connectionObject.prepareStatement(teamSql);
				teamPstmt.setString(1, sprsCode);
				ResultSet teamRs= teamPstmt.executeQuery();
				while(teamRs.next())
				{
					String reportTo=checkNull(teamRs.getString("REPORT_TO"));
					teamList.add(reportTo);
				}
				if(teamPstmt != null)
				{
					teamPstmt.close();
					teamPstmt = null;
				}
				if(teamRs != null)
				{
					teamRs.close();
					teamRs = null;
				}
				
				System.out.println("teamList is:"+teamList);
				
				String salesPersEmp=orgStructure.getFormattedList(teamList);
				//sql1 ="SELECT EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+teamGradeLevel+"' ORDER BY GRADE.LEVEL_NO DESC";
				/*sql1 = "SELECT DISTINCT '2' AS SR_NO,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO " + 
						"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
						"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
						"UNION "+
						"SELECT DISTINCT '1' AS SR_NO,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO "+
						 "FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY SR_NO,LEVEL_NO DESC";*/
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("Y".equalsIgnoreCase(isFortuneAct))
				{
					sql1 = "SELECT DISTINCT '2' AS SR_NO,'' AS STRG_CODE,EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"'  ORDER BY LEVEL_NO DESC";
				}
				else
				{	
					//Changes made by Rahul P. on 26-Sep-2023 [Start] set ENTITY_TYPE='R'
					/*sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+
							"UNION "+
							"SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							"FROM ENTITY_CONTACT WHERE ENTITY_TYPE='C'" +
							"ORDER BY SR_NO,LEVEL_NO DESC";*/
					sql = "SELECT DISTINCT '2' AS SR_NO,''AS STRG_CODE, EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP_CODE) DESIGNATION ,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,G.LEVEL_NO LEVEL_NO,EMP.MOBILE_NO " + 
							"FROM EMPLOYEE EMP, GRADE G WHERE TRIM(EMP_CODE) IN (SELECT REGEXP_SUBSTR(TRIM(ENTITY_CODE),'[^,]+', 1, LEVEL) FROM ORG_ROLE_ASSIGN " + 
							"WHERE ORG_UNIT='"+itemSer+"' CONNECT BY REGEXP_SUBSTR(ENTITY_CODE, '[^,]+', 1, LEVEL) IS NOT NULL)AND EMP.GRADE=G.GRADE_CODE "+
							"UNION "+
							"SELECT DISTINCT '1' AS SR_NO,'' AS STRG_CODE,EMP.EMP_CODE AS REPORT_TO,GET_EMP_DESIGNATION(EMP.EMP_CODE) DESIGNATION,DDF_GET_EMPLOYEE_NAME(EMP.EMP_CODE) AS NAME,GRADE.LEVEL_NO AS LEVEL_NO,EMP.MOBILE_NO "+
							"FROM EMPLOYEE EMP,GRADE GRADE WHERE EMP.EMP_CODE IN ("+salesPersEmp+") AND EMP.GRADE=GRADE.GRADE_CODE AND GRADE.LEVEL_NO<='"+ teamGradeLevel +"' "+
							"UNION "+
							"SELECT DISTINCT '3' AS SR_NO,entity_code as strg_code,contact_pers as REPORT_TO,'' as DESIGNATION ,CONTACT_PERS_NAME as NAME , 0 AS LEVEL_NO, MOBILE_NO " + 
							"FROM ENTITY_CONTACT WHERE ENTITY_TYPE='R'" +
							"ORDER BY SR_NO,LEVEL_NO DESC";
					//Changes made by Rahul P. on 26-Sep-2023 [End]
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
			}
			//Changed & Added By Vikas Lagad on 18-12-2019 [Changed logic for JNJ_coaching manager in team detail form]END
			// added by rupali on 13/04/18 for org_structure related changes [end]
			//System.out.println(" selectedTeam in dom vala parametr["+selectedTeam+"]");
			HashMap teamMap = new HashMap();

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			//System.out.println("Value of dcr id is:- -"+dcrID);

			if ( selectedTeam != null && selectedTeam.trim().length() > 0 )
			{
				//System.out.println(" selectedTeam in dom vala parametrtest lenghth["+selectedTeam.length()+"]");
				NodeList teamNodeList = ( genericUtility.parseString( selectedTeam ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = teamNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					int x =1;
					NodeList innerNodeList = teamNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String selTeam = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						//System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "sales_pers".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								selTeam = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						if ( "name".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								name = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
					}
					//System.out.println("selectTeam details["+selTeam+"] [");
					teamMap.put( selTeam, selTeam);

					//System.out.println(" teamMap ["+teamMap+"]");
					x++;
				}
			}

			if(dcrID != null)
			{
				String checkModeSql = " SELECT MAX(LINE_NO) AS MAXLINENO,MAX(TRAN_ID) AS TRAN_ID  FROM STRG_MEET_TEAM WHERE DCR_ID= ?  AND STRG_CODE = ?";
				pstmt = connectionObject.prepareStatement(checkModeSql);
				pstmt.setString(1,dcrID);
				pstmt.setString(2,strgCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxLineNo = rs.getInt("MAXLINENO");
					custTranID = checkNull(rs.getString("TRAN_ID"));
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(custTranID != null)
				{
					if(custTranID.length()>0)
						modeCounter++;
				}
			}

			int num = 1;
			int lineNo=1;
			pstmt =  connectionObject.prepareStatement( sql1 );
			// added by rupali on 13/04/18 for org_structure related changes
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String teamCode = checkNull(rs.getString("REPORT_TO"));
				//String empName = getEmpName(teamCode, connectionObject);
				String empDesign = getDesignName(teamCode, connectionObject);
				//System.out.println("test check report: - "+teamCode);
				//String designation = checkNull(rs.getString("DESIGNATION"));
				String empNameDesign = getEmpNameDesign(teamCode, connectionObject);
				System.out.println("empNameDesign::"+empNameDesign);
				String srNo = checkNull(rs.getString("SR_NO"));
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				String mobileNo = checkNull(rs.getString("MOBILE_NO"));
				String strCode = checkNull(rs.getString("STRG_CODE"));
				//System.out.println("Mobile no is::"+mobileNo);
				String empName="";
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
				String designation="";
				if("2".equalsIgnoreCase(srNo) && !employeeDesignationMap.isEmpty())
				{
					if(employeeDesignationMap.containsKey(teamCode))
					{
						designation=employeeDesignationMap.get(teamCode);

					}
					else
					{
						designation=empDesign;

					}
				}
				else
				{
					designation=empDesign;
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("3".equalsIgnoreCase(srNo))
				{
					empName = checkNull(rs.getString("NAME")).trim();
				}
				else
				{
					empName = getEmpName(teamCode, connectionObject);
				}
				System.out.println("empName is in realtime for team data:"+empName);
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
				if(empNameDesign!=null && empNameDesign.trim().length()>0)
				{
					empNameDesign=empNameDesign.substring(0, empNameDesign.lastIndexOf("("));
					System.out.println("empNameDesign before add designation : - "+empNameDesign);
					empNameDesign=empNameDesign +"("+designation+")";

				}
				System.out.println("empNameDesign after add designation : - "+empNameDesign);
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][START]
				if("3".equalsIgnoreCase(srNo))
				{
					empNameDesign = checkNull(rs.getString("NAME")).trim();
				}
				else
				{
					empNameDesign = empNameDesign;
				}
				//Added by Bhagyashri t for Team Subform Lifescan[W21KJOH015][END]
				if ( teamMap.get( teamCode.trim() ) != null )
				{
					String data = ( String ) teamMap.get( teamCode.trim() );
					//System.out.println("value of data is inside if:- "+data);
					selectedXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					selectedXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					selectedXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					selectedXmlString.append("<sales_pers><![CDATA[").append( data ).append("]]></sales_pers>\r\n");
					selectedXmlString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
					selectedXmlString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
					selectedXmlString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
					selectedXmlString.append("<line_no><![CDATA["+num+"]]></line_no>\r\n");
					selectedXmlString.append("<tran_id><![CDATA["+custTranID+"]]></tran_id>\r\n");
					selectedXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					selectedXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					selectedXmlString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
					selectedXmlString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
					selectedXmlString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
					selectedXmlString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
					selectedXmlString.append("<mem_code visible='0'><![CDATA[").append( data ).append("]]></mem_code>\r\n");
					selectedXmlString.append("<team_mobile_no visible='0'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
					selectedXmlString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
					
					selectedXmlString.append( "</Detail"+formNo+">\r\n" );
					num++;
				}
				else
				{

					maxLineNo = maxLineNo +1;
					//System.out.println("Value of mode counter is = "+modeCounter);
					if(modeCounter == 0)
					{
						//System.out.println("Value in ifff workWithListForm{"+workWithListForm+"}teamcode value is :- {"+teamCode);

						if((workWithListForm != null) && (workWithListForm.contains(teamCode)))
						{
							unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							unselectedString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							unselectedString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
							unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
							unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
							unselectedString.append("<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
							unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
							unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
							unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
							unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
							unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
							unselectedString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
							unselectedString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
							unselectedString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");					
							unselectedString.append("<team_mobile_no visible='0'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
							unselectedString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
							unselectedString.append("</Detail"+formNo+">\r\n" );
						}
						else
						{
							unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
							unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
							unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
							unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
							//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<strg_code><![CDATA[").append( strCode ).append("]]></strg_code>\r\n");
							unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
							unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
							unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
							unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
							unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
							unselectedString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
							unselectedString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
							unselectedString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");					
							unselectedString.append("<team_mobile_no visible='0'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
							unselectedString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
							unselectedString.append( "</Detail"+formNo+">\r\n" );
						}
					}

					else
					{
						//System.out.println("value of data is inside else:- ");
						unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
						unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						unselectedString.append("<sales_pers><![CDATA[").append( teamCode ).append("]]></sales_pers>\r\n");
						unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
						unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
						//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
						unselectedString.append("<strg_code><![CDATA[").append(strCode).append("]]></strg_code>\r\n");
						unselectedString.append("<name><![CDATA[").append( empName ).append("]]></name>\r\n");
						unselectedString.append("<sales_pers_sp_name ><![CDATA[").append( empName ).append("]]></sales_pers_sp_name>\r\n");
						unselectedString.append("<design_code><![CDATA[").append( empDesign ).append("]]></design_code>\r\n");
						unselectedString.append("<employee_designation><![CDATA[").append( designation ).append("]]></employee_designation>\r\n");
						unselectedString.append("<visited_with_display><![CDATA[").append( empNameDesign ).append("]]></visited_with_display>\r\n");
						unselectedString.append("<member_name visible ='0'><![CDATA[").append( empName ).append("]]></member_name>\r\n");
						unselectedString.append("<member_type visible='0'><![CDATA[").append("").append("]]></member_type>\r\n");
						unselectedString.append("<mem_code visible='0'><![CDATA[").append( teamCode ).append("]]></mem_code>\r\n");					
						unselectedString.append("<team_mobile_no visible='0'><![CDATA[" ).append( mobileNo ).append("]]></team_mobile_no>\r\n");
						unselectedString.append("<disp_descr><![CDATA[").append( empDesign ).append("]]></disp_descr>\r\n");
						unselectedString.append( "</Detail"+formNo+">\r\n" );
					}
				}

			}//end of while

			valueXmlString.append(selectedXmlString);
			valueXmlString.append(unselectedString);
			//System.out.println("outside detail:- "+valueXmlString);
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(connectionObject != null && isLocal)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		//System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//added by mrunalini sinkar to show order of visit  on summary page 2-june-2017(start)

	public int orderOfVisit(String eventDate,String salesPers,String localityCode ,Connection conn ) throws ITMException
	{
		//System.out.println("CALLING THE orderOfVisit::::");
		int orderOfVisit=0;
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			int count=0;
			String countSql ="SELECT COUNT(*) AS COUNT FROM SPRS_TRAVEL WHERE TRAVEL_DATE = ? AND SALES_PERS = ? AND LOCALITY_CODE = ?";
			pstmt = conn.prepareStatement(countSql);
			pstmt.setTimestamp(1,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2,salesPers);
			pstmt.setString(3,localityCode);
			rs = pstmt.executeQuery();
			//System.out.println("countSqlcountSql:::>>>["+countSql+"]");
			if(rs.next())
			{
				count=rs.getInt("COUNT");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			//System.out.println("count:::>>["+count+"]");
			if(count>0)
			{
				//System.out.println("iside if:");
				String orderVisit="SELECT ORDER_OF_VISIT FROM SPRS_TRAVEL WHERE TRAVEL_DATE=? AND SALES_PERS=? AND LOCALITY_CODE=?";
				pstmt = conn.prepareStatement(orderVisit);
				pstmt.setTimestamp(1,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,salesPers);
				pstmt.setString(3,localityCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					orderOfVisit=rs.getInt("ORDER_OF_VISIT");
					//System.out.println("order of visit is:"+orderOfVisit);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			else
			{
				//System.out.println("iside else:");
				int maxVisit = 0;
				String orderVisit="SELECT MAX(ORDER_OF_VISIT) AS ORDER_OF_VISIT FROM SPRS_TRAVEL WHERE TRAVEL_DATE=? AND SALES_PERS=?";
				pstmt = conn.prepareStatement(orderVisit);
				pstmt.setTimestamp(1,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,salesPers);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					maxVisit = rs.getInt("ORDER_OF_VISIT");
					//System.out.println("max visit is:"+maxVisit);
					orderOfVisit = maxVisit+1;
					//System.out.println("order of visit is:"+orderOfVisit);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}

			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}

		return orderOfVisit;
	}
	//added by mrunalini sinkar to show order of visit  on summary page 2-june-2017(end)

	private String getEmpName(String empCode,Connection conn) throws ITMException
	{
		String name=null;
		String employeCode = null;
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT UPPER(EMP_FNAME) ||' ' ||UPPER(EMP_MNAME) ||' '|| UPPER(EMP_LNAME) AS EMP_NAME,EMP_CODE from employee 	WHERE EMP_CODE= ? ";
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				name = checkNull(rs.getString("EMP_NAME"));
				employeCode = checkNull(rs.getString("EMP_CODE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return name +"("+employeCode+")";
	}

	private String getDesignName(String empCode,Connection conn) throws ITMException
	{
		String designation="";
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			String nameSql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE= ? ";
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				designation = checkNull(rs.getString("DESIGN_CODE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return designation;
	}
	public String getCallNoteTypes( String xmlString, String xtraParams) throws ITMException
	{
		//System.out.println("in getCallNoteTypes");
		String listType = "";
		PreparedStatement pstmtNoteType = null;
		ResultSet rsNoteType = null;
		Connection conn = null;
		String noteType = "";
		String descr = "";
		String shDescr = "";
		String colorCode = "";
		JSONObject jsonObj = new JSONObject();
		String jSonKey="";
		try
		{
			JSONObject jsonNoteTypeObj = new JSONObject();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			Document dom=genericUtility.parseString(xmlString);
			//System.out.println("Dom >>>:: "+dom);
			//System.out.println("xmlString>>>::"+xmlString);
			jSonKey=genericUtility.getColumnValue("scope_object",dom);
			//System.out.println("jSonKey>>>::"+jSonKey);
			if(jSonKey==null || jSonKey.trim().length()==0)  // changed by rupali on 06/03/17
			{
				jSonKey="JSON";
			}
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );*/
			conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ORDER BY SEQ_NO";
			pstmtNoteType = conn.prepareStatement(noteTypeSql);
			rsNoteType = pstmtNoteType.executeQuery();
			while(rsNoteType.next())
			{
				noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
				descr = checkNull(rsNoteType.getString("DESCR"));
				shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
				colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));
				jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);
			}
			//System.out.println("jSonKey>>>::"+jSonKey);
			jsonObj.put(jSonKey, jsonNoteTypeObj);
			//System.out.println("jsonConvertedData ::"+jsonObj.toString());
		}
		catch(Exception e)
		{
			System.out.println("Exception in getcallnotetype ::"+e.getMessage());
			throw new ITMException(e);//addde by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if(rsNoteType != null)
				{
					rsNoteType.close();
					rsNoteType = null;
				}
				if(pstmtNoteType != null)
				{
					pstmtNoteType.close();
					pstmtNoteType = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return jsonObj.toString();
	}
	private double getLandingRate(String strgCode, String itemCode, String workDate, String sprsCode, Connection connectionObject) throws Exception
	{
		//System.out.println("Inside getLandingRate()::::::" );
		double rate = 0d;
		String sql = "";
		String stateCode = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;

		try
		{
			//System.out.println("strgCode:::>>>>[" + strgCode +"]" );
			//sql = "SELECT STATE_CODE FROM STRG_CUSTOMER WHERE SC_CODE= ? ";
			sql = "SELECT STATE_CODE FROM SALES_PERS WHERE SALES_PERS = ? ";

			pStmt = connectionObject.prepareStatement(sql);
			//pStmt.setString(1, strgCode);
			pStmt.setString(1, sprsCode);
			rs = pStmt.executeQuery();

			if(rs.next())
			{
				stateCode= (checkNull(rs.getString("STATE_CODE"))).trim();
			}

			//System.out.println("stateCode:::>>>>[" + stateCode +"]");
			DistCommon distComn = new DistCommon();
			rate = distComn.pickRate(stateCode, workDate, itemCode, connectionObject);

			//System.out.println("getLandingRate_RATE::>>>>["+itemCode+"] [" + rate +"]");


		}
		catch (Exception e)
		{
			e.printStackTrace();
			//System.out.println( "Exception :getLandingRate(String):" + e.getMessage() + ":" );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}

				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}

		return rate;
	}
	private String generateCustomerCode( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			//System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");

			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_wsfa_strg_customer' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<sc_code></sc_code>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		//System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey;
	}
	//added by mrunalini sinkar if dcr is alerdy confirm then same date scond dcr not allow(start)

	public String wfValSalesPersAct(Document dom, Document dom2, String currentFormNo, String userId,Connection connectionObject) throws ITMException //chnged by sachin satre on [9-nov-16] to get connection
	{
		//System.out.println("inside wfValSalesPersAct ");
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String updateFlag="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errStringNew = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;//modified by kailash.
		boolean isLocalConn=false;
		int noOfChilds = 0;
		try
		{

			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn=true;
			}

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal=new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else
						{
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							java.util.Date eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							String evtdat=childNode.getFirstChild().getNodeValue();
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}

							// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(start) 
							String futureDate="";
							String eventType = checkNull(genericUtility.getColumnValue( "event_type" , dom2 ,currentFormNo));
							String itemSer = getItemSer(userId,connectionObject);
							//String actSql = " SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? AND ITEM_SER = ? ";
							String actSql = "SELECT FUTURE_DATE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? "+
									 "AND (ITEM_SER IS NULL OR ITEM_SER = 'ALL' OR ITEM_SER = ?) "+
									 "AND (SITE_CODE IS NULL OR SITE_CODE = 'ALL' OR (SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE = ?) IN "+
									 "(SELECT REGEXP_SUBSTR(SITE_CODE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(SITE_CODE, '[^,]+', 1, LEVEL) IS NOT NULL) ) "+
									 "ORDER BY DESCR ";
							pstmt = connectionObject.prepareStatement(actSql);
							pstmt.setString(1, eventType);
							pstmt.setString(2, itemSer);  
							pstmt.setString(3, userId);  
							rSet = pstmt.executeQuery();
							if (rSet.next())
							{
								futureDate =  checkNull(rSet.getString("FUTURE_DATE"));
							}
							if (rSet != null)
							{
								rSet.close();
								rSet = null;
							}
							if (pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							
							// added by mrunalini sinkar for allowing future_date to particular activity code on 01-04-2019(end)
							//if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							if (( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 && (futureDate.equalsIgnoreCase("0") || futureDate.trim().length() == 0)))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}


							String salesPers =checkNull( genericUtility.getColumnValue( "sales_pers" , dom2 ,currentFormNo));
							//System.out.println("salesperson is:"+salesPers);
							String dcrDate = checkNull(genericUtility.getColumnValue( "event_date" , dom2 ,currentFormNo));
							//System.out.println("eventdate is:"+dcrDate);
							
							// String confirmed = "";
							dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							String loadNo="";
							String loadSql="SELECT load_no FROM sprs_day_summ where event_date <= ? and " + 
									"sales_pers = ? and load_status='N'";
							PreparedStatement pstmtSel5 = connectionObject.prepareStatement(loadSql);
							pstmtSel5.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
							pstmtSel5.setString(2, salesPers);
							ResultSet rsSelect5 = pstmtSel5.executeQuery();
							if(rsSelect5.next())
							{
								loadNo = rsSelect5.getString("load_no");
							}
							if(rsSelect5 != null)
							{
								rsSelect5.close();
								rsSelect5 = null;
							}
							if(pstmtSel5 != null)
							{
								pstmtSel5.close();
								pstmtSel5 = null;
							}
							String allowMultiDCRDay = getSfaParmValue(salesPers,"ALLOW_MULTI_DCR_DAY",connectionObject);
							System.out.println("allowMultiDCRDay is:"+allowMultiDCRDay);
							if(! allowMultiDCRDay.equalsIgnoreCase("Y"))
							{
								int count = 0;
								// commented and added by rupali on 03/01/17 for getting count from table
								// String selectSql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ?";
								String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND CONFIRMED = 'Y' "+
										"AND ACTIVITY_CODE NOT IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE = 'PR')";
								PreparedStatement pstmtSel = connectionObject.prepareStatement(selectSql);
								pstmtSel.setString(1, salesPers);
								pstmtSel.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
								ResultSet rsSelect = pstmtSel.executeQuery();
								if(rsSelect.next())
								{
									//	confirmed = (rsSelect.getString("CONFIRMED") == null) ?"":rsSelect.getString("CONFIRMED").trim();
									count = rsSelect.getInt("COUNT");
								}
								rsSelect.close(); rsSelect = null;
								pstmtSel.close(); pstmtSel = null;
								//	if("Y".equalsIgnoreCase(confirmed))
								if(count >= 1)
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRCONFD" , userId );
									break;
								}
							}
							else
							{
								int count = 0;
								if(loadNo != null && loadNo.length() > 0 )
								{
									String selectSql = "SELECT COUNT(*) AS COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? "+
											"AND ACTIVITY_CODE NOT IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE = 'PR') AND LOAD_NO = ?";
									PreparedStatement pstmtSel = connectionObject.prepareStatement(selectSql);
									pstmtSel.setString(1, salesPers);
									pstmtSel.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
									pstmtSel.setString(3, loadNo);
									ResultSet rsSelect = pstmtSel.executeQuery();
									if(rsSelect.next())
									{
										count = rsSelect.getInt("COUNT");
									}
									if(rsSelect != null)
									{
										rsSelect.close();
										rsSelect = null;
									}
									if(pstmtSel != null)
									{
										pstmtSel.close();
										pstmtSel = null;
									}
								}

									int meetCount = 0;
									String selectSql1 = "SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE " +
											" SALES_PERS = ? AND EVENT_DATE = ? AND WF_STATUS='S'"; 									
									PreparedStatement pstmtSelect1 = connectionObject.prepareStatement(selectSql1);
									pstmtSelect1.setString(1, salesPers);
									pstmtSelect1.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
									ResultSet selectSql2 = pstmtSelect1.executeQuery();
									if(selectSql2.next())
									{
										meetCount = selectSql2.getInt("COUNT");
									}
									if(selectSql2 != null)
									{
										selectSql2.close();
										selectSql2 = null;
									}
									if(pstmtSelect1 != null)
									{
										pstmtSelect1.close();
										pstmtSelect1 = null;
									}
									//	if("Y".equalsIgnoreCase(confirmed))
									if(count >= 1 && meetCount >= 1)
									{
										errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRCONFD" , userId );
										break;
									}
								
							/*	else
								{
									int meetCount = 0;
									String selectSql1 = "SELECT COUNT(*) AS COUNT FROM STRG_MEET WHERE " +
											" SALES_PERS = ? AND EVENT_DATE = ? AND WF_STATUS='S' and AND CONFIRMED in ('Y','N')"; 
								
									PreparedStatement pstmtSelect1 = connectionObject.prepareStatement(selectSql1);
									pstmtSelect1.setString(1, salesPers);
									pstmtSelect1.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
									ResultSet selectSql2 = pstmtSelect1.executeQuery();
									if(selectSql2.next())
									{
										meetCount = selectSql2.getInt("COUNT");
									}
									if(selectSql2 != null)
									{
										selectSql2.close();
										selectSql2 = null;
									}
									if(pstmtSelect1 != null)
									{
										pstmtSelect1.close();
										pstmtSelect1 = null;
									}
									if(meetCount >= 1)
									{
										errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRCONFD" , userId );
										break;
									}	
								}*/
							}
							
							
							
							
							
							int confCnt=0;
							String confSql="SELECT COUNT(*) AS COUNT FROM STRG_MEET SAT WHERE SAT.SALES_PERS = ? AND SAT.EVENT_DATE = ?  " + 
									"AND ( CASE WHEN SAT.CONFIRMED IS NULL THEN 'N' ELSE SAT.CONFIRMED END ) ='N'  AND WF_STATUS='S' " + 
									"AND SAT.EVENT_TYPE NOT IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE = 'PR')";
							PreparedStatement pstmtconf = connectionObject.prepareStatement(confSql);
							pstmtconf.setString(1, salesPers);
							pstmtconf.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
							ResultSet rsSelectConf = pstmtconf.executeQuery();
							if(rsSelectConf.next())
							{
								confCnt = rsSelectConf.getInt("COUNT");
							}
							rsSelectConf.close(); rsSelectConf = null;
							pstmtconf.close(); pstmtconf = null;
							if(confCnt >= 1)
							{
								errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRSUBMD" , userId );
								break;
							}
							
							int allowDays = 0;
							String propName = "MAX_ALLOW_PRD_MEET";
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? ";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1, propName);
							rSet = pstmt.executeQuery();
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");

								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}


							String eventdate = childNode.getFirstChild().getNodeValue();


							String activityCode = checkNull(genericUtility.getColumnValue( "event_type" , dom2 ));
							String activityType = checkNull(genericUtility.getColumnValue( "activity_type" , dom2 ));
							//System.out.println("before activityCode"+ activityCode);
							//System.out.println("before activity"+ activityType);
							if(activityCode==null || activityCode.length()==0)
							{
								errString = itmDBAccessLocal.getErrorString("event_type","NULLACTCOD",userId);
								break;
							}

							if(activityType==null || activityType.length()==0)
							{
								String sql= "select activity_type from fieldactivity where activity_code= ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}

							}
							if( salesPers != null && evtdat != null )
							{
								// commented and added by Rupali on 04/12/17 for defining sfaparam value for sequential reporting[start]
								/*errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
								if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
								{
									errString = errStringNew;
									break;
								}*/
								//commented by mrunalini sinkar for adding irg unit condition in case of sequential dar(start)
								/*String parmValue = "";
								SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
								String currDate = dtFormat.format(new java.util.Date());
								String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SEQUENTIAL_DAR' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
								PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
								pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
								ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
								if (rsSfaParm.next())
								{
									parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
								}
								if(rsSfaParm != null)
								{
									rsSfaParm.close();
									rsSfaParm = null;
								}
								if(pstmtSfaParm != null)
								{
									pstmtSfaParm.close();
									pstmtSfaParm = null;
								}*/
								//commented by mrunalini sinkar for on 21-Feb-2018 adding irg unit condition in case of sequential dar(start)
								boolean seqDAR=true;
								String parmValue = getSfaParmValue(userId,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)
								String designation = checkNull(genericUtility.getColumnValue( "emp_design" , dom2,"1"));
								String seqDesignCode = checkNull(getSfaParmValue(salesPers,"SEQ_DAR_NO_MANDATE",connectionObject)); 
								String event = checkNull(genericUtility.getColumnValue( "event_type" , dom2,"1" ));
								System.out.println("designation code is:["+designation+"]event["+event+"]");
								if(seqDesignCode!=null && seqDesignCode.trim().length()!=0)
								{
									String [] temp = seqDesignCode.split(",");
									for(int i = 0 ;i < temp.length;i++)
									{
										String designCodeName=checkNull(temp[i]);
										if(designation.equalsIgnoreCase(designCodeName) && "CA".equalsIgnoreCase(event))
										{
											seqDAR=false;
											break;
										}
									}
								}
										
								
								System.out.println("seqDAR is:["+seqDAR+"]");
								if(seqDAR)
								{
									if(parmValue.equalsIgnoreCase("Y"))
									{
										errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
										if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
										{
											errString = errStringNew;
											break;
										}
									}
								}
								//System.out.println("In 1 If parmValue is"+ parmValue);

								// commented and added by Rupali on 04/12/17 for defining sfaparam value for sequential reporting[end]
								//Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(END)

								int maxUnconfAllow=0;
								String parmVal = getSfaParmValue(userId, "UNCONF_DAR", connectionObject);
								System.out.println("UNCONF_DAR IS["+parmVal+"]");
								if (parmVal.trim().length() > 0)										
								{
									try
									{
										maxUnconfAllow = Integer.parseInt(parmVal.trim());
									}
									catch (NumberFormatException ne)
									{
										maxUnconfAllow = 0;
									}	
								}
								System.out.println("maxUnconfAllow IS["+maxUnconfAllow+"]");
								if(maxUnconfAllow>0)
								{
									String unConfDcrDates="";
									int DARCount=0;
									String selectConfirmSql = "SELECT DISTINCT EVENT_DATE FROM SPRS_ACT_TRAN  WHERE SALES_PERS = ? " +
											" AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END ) <> 'Y'" +
											" AND  EVENT_DATE < ? ORDER BY EVENT_DATE ";
									PreparedStatement pstmtSelect = connectionObject.prepareStatement(selectConfirmSql);
									pstmtSelect.setString(1, salesPers);
									pstmtSelect.setTimestamp( 2, java.sql.Timestamp.valueOf(dcrDate));
									ResultSet resultSelect = pstmtSelect.executeQuery();
									while(resultSelect.next())
									{
										DARCount++;
										String unConfDcrDate = (resultSelect.getString("EVENT_DATE")) == null ?"":resultSelect.getString("EVENT_DATE").trim();
										unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
										unConfDcrDates += unConfDcrDate+",";

									}
									resultSelect.close(); resultSelect = null;
									pstmtSelect.close(); pstmtSelect = null;
									System.out.println( "Event Dates >>> ["+unConfDcrDates+"] DARCount["+DARCount+"]");
									//if(count >=3)
									if(DARCount >= maxUnconfAllow)
									{
                                        errString = itmDBAccessLocal.getErrorString("sales_pers","DCRUNCONFD",userId);
										errString = getModifiedErrorString(errString, unConfDcrDates);
                                        /*String message=getMsgDescr("DCRUNCONFD",connectionObject);
										errString = "";
										String messageValue ="\r\n"+message+"\n"+unConfDcrDates;
										StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
										valueXmlErrorString.append("<error id=\"DCRUNCONFD\" type=\"E\" >");
										valueXmlErrorString.append("<message><![CDATA[").append("").append("]]></message>\r\n");
										valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
										valueXmlErrorString.append("<type>E</type>\r\n");
										valueXmlErrorString.append("<option></option>\r\n");
										valueXmlErrorString.append("<time></time>\r\n");
										valueXmlErrorString.append("<alarm></alarm>\r\n");
										valueXmlErrorString.append("<source></source>\r\n");
										valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
										valueXmlErrorString.append("<redirect>1</redirect>\r\n");
										valueXmlErrorString.append("</error>\r\n");
										valueXmlErrorString.append("</Errors>\r\n");
										valueXmlErrorString.append("</Header>\r\n");
										valueXmlErrorString.append( "</Root>\r\n" );
										//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
										errString =valueXmlErrorString.toString();*/
										return errString;
									}
								}
								//Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(END)
								
								int actCount = 0;
								String sql= "select activity_type,count(*) as count from fieldactivity where activity_code= ? group by activity_type";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									actCount = rSet.getInt("count");
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(start)

								if(!updateFlag.equalsIgnoreCase("E"))
								{
								errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject,"");
								if(errString != null && errString.length()>0 && (errString.indexOf("ERRORS")!=-1 || errString.indexOf("Errors")!=-1))
								{
									//System.out.println("CAME HERE");
									//System.out.println("activity"+ activityType);
									if(actCount == 0)
									{
										errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNOTFND", userId );
										break;
									}
									if(activityType !=null && activityType.length() > 0 && "LEAVE".equalsIgnoreCase(activityType))
									{
										//System.out.println("Checking leave not allowed");
										errString = itmDBAccessLocal.getErrorString("event_type","LVENOTALOW",userId);
										break;
									}

									else
									{
										//System.out.println("Checking leave not allowed--- in else");
										errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
									}

									//System.out.println("Holiday!");
									break;

								}

							}
								// added by Atish Rane for not display Holiday error in edit mode  changes on 26-Aug-2019(end)


						}

					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrWizardEJB :wfValData():" + e.getMessage() + ":" );

			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}
	//added by mrunalini sinkar if dcr is alerdy confirm then same date scond dcr not allow(end)

	public String getSelectedRowVal(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			//System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			//System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			//System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}
	private String getModifiedErrorString(String errString, String modifiedString)
	{
		String xmlStr1 = "";
		String xmlStr2 = "";
		//String xmlStr3 = "";
		try
		{
			if(errString.indexOf("<trace>") != -1)
			{
				xmlStr1 = errString.substring(0,errString.indexOf("<trace>"));
				//xmlStr3 = errString.substring(errString.indexOf("<description>")+"<description>".length(),errString.indexOf("</description>"));
				xmlStr2 = errString.substring(errString.indexOf("</trace>")+"</trace>".length());

				modifiedString = "<trace>" + modifiedString + "</trace>";

				errString = xmlStr1 + modifiedString + xmlStr2;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("getModifiedErrorString >> errString ::"+errString);
		return errString;
	}
	// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [start]
	private String getVisitTime (Connection connectionObject) throws SQLException
	{
		String hours="";
		String startTime = geteventTime();
		String endTime = "";
		String hour = "";
		String minute = "";
		int position=startTime.indexOf(':');
		hour = startTime.substring(0,position).trim();
		minute = startTime.substring( position+1 ,position+3 ).trim();
		int hr=Integer.parseInt(hour);
		int min=Integer.parseInt(minute);
		String format = startTime.substring( position+3 , startTime.length() ).trim();

		String interval = "";
		String sql = "SELECT TRIM(PROP_VALUE) AS MEET_INTERVAL FROM PROPERTIES WHERE PROP_NAME ='MEET_INTERVAL'";
		//System.out.println( " [StrgMeetWizEJB]sql [" + sql + "]" );
		PreparedStatement pstmt =  connectionObject.prepareStatement(sql);
		ResultSet rs = pstmt.executeQuery();
		if( rs.next() )
		{
			interval = checkNull(rs.getString( "MEET_INTERVAL" ));
		}
		if (rs!= null)
		{
			rs.close();
			rs = null;
		}
		if(pstmt!=null)
		{
			pstmt.close();
			pstmt = null;
		}

		int minIntrvl=Integer.parseInt(interval);
		minIntrvl = min + minIntrvl;
		if(hr == 11 && minIntrvl >= 60)
		{
			if("AM".equals(format))
			{
				format = "PM";
			}
			else if("PM".equals(format))
			{
				format = "AM";
			}
		}
		//System.out.println("hour =["+hour+"], minute=["+minute+"], interval=["+interval+"]");
		int intr =0;
		if( interval.length()>0 )
		{
			intr = Integer.parseInt( interval );
			min = min+intr;
			if( min>59 )
			{
				while( min > 59 )
				{
					hr=hr+1;
					min=min-60;
					if(hr == 11 && min >= 60)
					{
						if("AM".equals(format))
						{
							format = "PM";
						}
						else if("PM".equals(format))
						{
							format = "AM";
						}
					}
				}
				//System.out.println("minits are::::["+min+"]");
				if( min==0 )
				{
					if( hr < 10 )
					{
						hours = "0"+hr;
					}
					else
					{
						hours = String.valueOf( hr );
					}
					endTime = hours+":00"+" "+format;
					//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":00")).append( "]]></event_time_end>\r\n" );
				}
				else
				{
					if( hr < 10 )
					{
						hours="0"+hr;
					}
					else
					{
						hours=String.valueOf( hr );
					}
					if(min<10)
					{
						endTime = hours+":0"+min+" "+format;
						//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":0"+min)).append( "]]></event_time_end>\r\n" );
					}
					else
					{
						endTime = hours+":"+min+" "+format;
						//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
					}
				}
			}
			else
			{
				if( hr < 10 )
				{
					hours="0"+hr;
				}
				else
				{
					hours=String.valueOf( hr );
				}
				endTime = hours+":"+min+" "+format;
				//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
			}
		}
		return endTime;
	}
	// added by rupali on 14/12/17 for showing event_time_from and event_time_to fields on customer screen [end]
	//added by mrunalini sinkar on 06/02/2018 for offline of realtime(start)
	public String populateSubformData(String xmlString) throws ITMException
	{
		//System.out.println("RealTimeReportEJB :: populateSubformData :: xmlString ["+xmlString+"]");
		String SubFormData="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		Document dom = null;
		Connection connectionObject = null;
		try
		{
			connectionObject=getConnection();
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString( xmlString );
			}
			SubFormData=getSubFormData(dom,connectionObject);
			//System.out.println("SubFormData is:"+SubFormData);

		}
		catch(Exception e)
		{
			System.out.println( "Exception :RealTimeReport :populateFormData(String):" + e.getMessage() + ":" );
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealTimeReportEJB:populateFormData:==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return SubFormData;
	}
	//added by mrunalini sinkar on 06/02/2018 for offline of realtime(start)
	// added by rupali on 23/02/18 for edit mode of realtime report [start]
	private String getWorkWithList(String teamDetail,String formNo)
	{
		String workWith = "";
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			Document preFormDom =  genericUtility.parseString("<Root>"+teamDetail+"</Root>");
			NodeList preDomList = preFormDom.getElementsByTagName("Detail"+formNo);
			for (int prntCtr = 0; prntCtr < preDomList.getLength(); prntCtr++ )
			{
				//System.out.println("Team1["+prntCtr+"]");
				Node det3Nod = preDomList.item(prntCtr);
				NodeList teamList = det3Nod.getChildNodes();
				int teamLen = teamList.getLength();

				for(int tCtr = 0;tCtr < teamLen;tCtr++)
				{
					//System.out.println("Team2["+prntCtr+"]");
					Node teamNode = teamList.item(tCtr);
					if(teamNode != null && teamNode.getNodeType() == Node.ELEMENT_NODE)
					{

						if(teamNode.getNodeName().equalsIgnoreCase("sales_pers"))
						{
							workWith = workWith + "("+teamNode.getFirstChild().getNodeValue() + ")";
						}
						else if(teamNode.getNodeName().equalsIgnoreCase("name"))
						{
							workWith = workWith + teamNode.getFirstChild().getNodeValue() + ",";
						}
					}

				}

			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		return workWith;
	}
	public String getExistingTeam( String salePersCode, String eventDate, String tranId, Connection conn ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID= 1;

		String teamData = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String smtQuery = "SELECT DISTINCT ST.SALES_PERS,UPPER(EMP.EMP_FNAME) ||' ' ||UPPER(EMP.EMP_MNAME) ||' '|| "+
					"UPPER(EMP.EMP_LNAME) AS EMP_NAME, EMP.DESIGNATION DESIGNATION FROM STRG_MEET_TEAM ST LEFT OUTER "+
					"JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE WHERE ST.TRAN_ID = ?";

			pstmt = conn.prepareStatement(smtQuery);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				teamData = teamData + checkNull(rs.getString("EMP_NAME")) +" ("+checkNull(rs.getString("SALES_PERS"))+")," ;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			if(teamData.lastIndexOf(",")!= -1)
			{
				teamData = teamData.substring(0, teamData.length()-1);
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		//System.out.println("teamData ::"+teamData);
		return teamData;
	}
	public String getShDescr(String type,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String shDescr = "";
		try
		{

			String sql  = "SELECT SH_DESCR FROM STRG_CUST_TYPE WHERE TYPE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, type);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				shDescr = checkNull(rs.getString("SH_DESCR"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("shDescr val:- "+shDescr);
		return shDescr;
	}
	// added by rupali on 23/02/18 for edit mode of realtime report [end]
	// added by rupali on 03/05/18 for single screen mgr reporting [start]
	/*public String getMGREmployee(String empCode,Connection con) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " + "WHERE A.EMP_CODE = ? " + "AND A.GRADE = B.GRADE_CODE " + "AND B.GRADE_TYPE = 'M' ";

			pstmt = con.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		} catch (Exception e)
		{
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


			}
			catch (Exception e1){}

		}
		return empCodeMGR;
	}*/
	// added by rupali on 03/05/18 for single screen mgr reporting [end]
	// added by rupali on 25/06/18 for geeting travel_mode for expense process related changes [start]
	public String getStanCodeFrom( Connection con, String userId, String currDate,String check ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn=false;
		try
		{
			if(con == null)
			{
				con =getConnection();
				isLocalConn=true;
			}
			//Added by kailash on 04-03-19 [start]
			String travelDate = "";
			String maxTravelDt = "SELECT MAX(TRAVEL_DATE) AS TRAVEL_DATE FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE <= ?";
			pstmt =  con.prepareStatement(maxTravelDt);
			pstmt.setString(1, userId );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				travelDate = checkNull(rs.getString("TRAVEL_DATE"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(travelDate != null && travelDate.trim().length() > 0) // added this condtion if travel date is blanck then exception is occured
			{
				//Added by kailash on 04-03-19 [end]

				//Change done by kailash on 04-03-19[start]
				/*String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=? AND TRAVEL_DATE <= ?) ) "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=? AND TRAVEL_DATE <= ?)";*/
				String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE = ? ) "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  = ? ";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf(travelDate) );
				pstmt.setString(3, userId );
				pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf(travelDate) );
				//Change done by kailash on 04-03-19[end]
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCodeFrom = rs.getString(1);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			//added by  mrunalini sinakr to get locality if salesperson first time report(start)
			else
			{
				String stanCodeHq="";
				String sqlHq = "select stan_code__hq from employee where emp_code= ? ";
				pstmt = con.prepareStatement( sqlHq );
				pstmt.setString(1, userId);
				 rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					stanCodeHq =   checkNull(rs.getString("stan_code__hq"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				String getLocalitySql = "SELECT SR.LOCALITY_CODE FROM SPRS_ROUTE SR,LOCALITY LOC "
						+ "WHERE SR.STAN_CODE = ? AND SR.SPRS_CODE = ? AND SR.STATUS='Y' AND SR.LOCALITY_CODE = LOC.LOCALITY_CODE ";

				pstmt = con.prepareStatement(getLocalitySql);
				pstmt.setString(1, stanCodeHq);
				pstmt.setString(2, userId);

				 rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCodeFrom =   checkNull(rs.getString("LOCALITY_CODE"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			//added by  mrunalini sinakr to get locality if salesperson first time report(end)
			

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( isLocalConn && con != null && ! con.isClosed() )
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealTimeReportEJB :getStanCodeFrom :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return localityCodeFrom;
	}
	public String getDefaultTravelMode(String sprsCode, String eventdate, String localityCode, Connection connectionObject ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn=false;
		String travelMode = "";
		int holCnt = 0;
		int dayNo = 0;
		try
		{
			if(connectionObject == null)
			{
				connectionObject =getConnection();
				isLocalConn=true;
			}
			String locCodeFrom = getStanCodeFrom( connectionObject, sprsCode, eventdate, "");

			Date dateNo = new SimpleDateFormat(genericUtility.getApplDateFormat()).parse(eventdate);
			System.out.println(eventdate+"\t"+dateNo);
			SimpleDateFormat format = new SimpleDateFormat("dd");
			int monthDay=Integer.parseInt(format.format(dateNo));
			System.out.println(monthDay);

			String holDayCnt = "SELECT COUNT(*) AS COUNT FROM HOLIDAY, PERIOD WHERE HOL_DATE BETWEEN FR_DATE AND ? AND CODE = (SELECT CODE FROM PERIOD WHERE ? "+
					"BETWEEN FR_DATE AND TO_DATE) AND HOLIDAY.DESCR = 'SUNDAY' AND HOL_TBLNO = (SELECT HOL_TBLNO FROM EMPLOYEE WHERE EMP_CODE = ?)";
			pstmt = connectionObject.prepareStatement(holDayCnt);
			pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(3,sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				holCnt = rs.getInt("COUNT");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			dayNo = monthDay - holCnt;

			String trvModeSql = "SELECT TRV_MODE FROM SPRS_TOUR_PLANDET WHERE TRAN_ID = (SELECT MAX(TRAN_ID) FROM SPRS_TOUR_PLAN WHERE SALES_PERS= ? "+
					"AND PRD_CODE__FROM = (SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE)) AND FROM_LOCALITY = ? AND TO_LOCALITY = ? AND DAY_NO = ?";
			pstmt = connectionObject.prepareStatement(trvModeSql);
			pstmt.setString(1,sprsCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventdate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(3,locCodeFrom);
			pstmt.setString(4,localityCode);
			pstmt.setInt(5,dayNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				travelMode = checkNull(rs.getString("TRV_MODE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :RealTimeReportEJB :getTravelMode :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return travelMode;
	}
	// added by rupali on 25/06/18 for geeting travel_mode for expense process related changes [end]
	// added by rupali on 04/12/18 to set nearest manager in visited with field [start]
	public TreeMap<Double, String> getMgrLocation(String currentGeopos,String salesPers,String eventDate,Connection conn)
	{
		PreparedStatement pstmt=null;
		ResultSet rs= null;
		TreeMap<Double, String> mgrPositionMap = new TreeMap<Double, String>();
		String reportToSql = "";
		ArrayList teamList = new ArrayList();
		try
		{
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			String dbName =CommonConstants.DB_NAME;
			
			if(dbName.equalsIgnoreCase("DB2"))
			{
				reportToSql ="select DISTINCT REPORT_TO from employee where fn_emp_hierarcy_up(REPORT_TO, CAST( ? As VARCHAR(10) )) > 0 AND LENGTH(EMPLOYEE.REPORT_TO) != 0";
			}
			else if(dbName.equalsIgnoreCase("ORACLE"))
			{
				reportToSql ="SELECT REPORT_TO FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR REPORT_TO = EMP_CODE AND REPORT_TO IS NOT NULL";
			}
			String salesPersTemp="";
			String isOrgStrcture = getSfaParmValue(salesPers,"HIERARCY_FRM_ORG_STR",conn);
			if("Y".equalsIgnoreCase(isOrgStrcture))
			{
				OrgStructure orgStructure = new OrgStructure();
				teamList = orgStructure.reportToUp(salesPers,eventDate,conn);
				salesPersTemp = orgStructure.getFormattedList(teamList);

			}

			System.out.println("teamList is::::"+teamList);
			if(teamList == null || teamList.isEmpty() || dbName.equalsIgnoreCase("DB2"))
			{
				pstmt = conn.prepareStatement(reportToSql);
				pstmt.setString(1, salesPers);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String teamMember = checkNull(rs.getString("REPORT_TO"));
					teamList.add(teamMember);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			String sql="SELECT USERID,CURRENT_GEO_POS FROM LOGINTRACE WHERE "+
					   "TRUNC(LOGINTIME) = ? AND CURRENT_GEO_POS IS NOT NULL AND USERID IN ("+salesPersTemp+")";
			pstmt= conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString(currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			rs= pstmt.executeQuery();
			while(rs.next())
			{
				String mgrCode = checkNull(rs.getString("USERID"));
				String mgrCurrGeoPos = checkNull(rs.getString("CURRENT_GEO_POS"));
				System.out.println("mgrCode is:["+mgrCode+"] mgrCurrGeoPos["+mgrCurrGeoPos+"]");

				if( mgrCurrGeoPos.trim().length()> 0 && currentGeopos.trim().length() > 0 )
				{
					double mgrLat = Double.parseDouble( mgrCurrGeoPos.split(",")[0] );
					double mgrLang = Double.parseDouble( mgrCurrGeoPos.split(",")[1] );
					double currentLat = Double.parseDouble( currentGeopos.split(",")[0] );
					double currentLang = Double.parseDouble( currentGeopos.split(",")[1] );
					System.out.println("mgrLat is:["+mgrLat+"] mgrLang["+mgrLang+"]currentLat["+currentLat+"]currentLang["+currentLang+"]");

					double distanceInMtrs = (double) getLatLngInMtr( mgrLat, mgrLang, currentLat, currentLang );
					mgrPositionMap.put(distanceInMtrs, mgrCode);
				}
			}
			
			System.out.println("mgrPositionMap is:["+mgrPositionMap+"]");
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return mgrPositionMap;
	}
	private double getLatLngInMtr( double lat1, double lon1, double lat2, double lon2 )
	{
		double R = 6371; // Radius of the earth in km
		double dLat = deg2rad(lat2-lat1);  // deg2rad below
		double dLon = deg2rad(lon2-lon1); 
		double a = 
				Math.sin(dLat/2) * Math.sin(dLat/2) +
				Math.cos(deg2rad(lat1)) * Math.cos(deg2rad(lat2)) * 
				Math.sin(dLon/2) * Math.sin(dLon/2)
				; 
		double c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a)); 
		double d = R * c; // Distance in km
		System.out.println("In getAddress()...distanceinMtrs:::"+d*1000);
		return d*1000;
	}
	private double deg2rad( double deg ) 
	{
		return deg * (Math.PI/180);
	}
	// added by rupali on 04/12/18 to set nearest manager in visited with field [end]
	private ArrayList getMaxDomIdListFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String domID = "";
		ArrayList allSelectedDomIdList = new ArrayList();
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;
			String indexDom = "";

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				domID = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();


				System.out.println("domID>>>>["+domID+"]");
				if ( domID.indexOf(":") > 0 )
				{
					String temp [] = domID.split(":");
					if ( temp != null && temp.length > 0 )
					{
						System.out.println("temp.length["+temp.length+"]");
						for ( int i=0; i<temp.length; i++)
						{
							indexDom = temp[i];
							System.out.println("teamMember =["+indexDom+"]");
						}
						indexDom= temp[0];
						System.out.println("teamMemberoooo =["+indexDom+"]");
					}
				}
				else
				{
					indexDom = domID;
					System.out.println("inside else"+indexDom+"]");
				}

				System.out.println("domID["+indexDom+"]");
				int intDomID = Integer.parseInt(indexDom);
				System.out.println("DomiD value is := intDomID"+intDomID);
				allSelectedDomIdList.add(intDomID);

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("allSelected Donm id on previous:- "+allSelectedDomIdList);
		return allSelectedDomIdList;
	}
	private HashMap< String, String > getAddressDetailMap( org.json.simple.JSONArray adddrcomp, Connection conn )
	{
		HashMap<String, String> map=new HashMap();
		String keyaddr = "", valueaddr = "", longName = "";
		String sql="";
		ResultSet rs=null;
		PreparedStatement pstm=null;
		try
		{
			System.out.println("valueaddr " + (adddrcomp.size()));

			org.json.simple.JSONObject addrJson = null;
			for (int j = 0; j < adddrcomp.size(); j++)
			{
				System.out.println("valueaddr ["+ j +"]" + (adddrcomp.get(j)));
				addrJson = (org.json.simple.JSONObject) adddrcomp.get(j);
				System.out.println("json object [ "+ addrJson +"]" );
				JSONParser parser = new JSONParser();
				Iterator<String> addrobjtyp = addrJson.keySet().iterator();
				org.json.simple.JSONArray typeArr = null;
				while (addrobjtyp.hasNext())
				{
					keyaddr = addrobjtyp.next();
					valueaddr = addrJson.get(keyaddr).toString();
					System.out.println( "key : [" + keyaddr + "], value : [" + valueaddr +"]" );

					if( keyaddr.equalsIgnoreCase("long_name") )
					{
						longName = valueaddr;
						System.out.println("value of long term "+longName);
					}
					else if (keyaddr.equalsIgnoreCase("types"))
					{
						typeArr=(org.json.simple.JSONArray) parser.parse(valueaddr);
					}
				}
				if ( longName == null || longName.trim().length() == 0)
				{
					continue;
				}
				String type = typeArr.get(0).toString();
				System.out.println( "longName : ["+ longName +"], type : ["+ type +"]" );
				if (type.equalsIgnoreCase("locality"))
				{
					map.put("city", longName);
				}
				else if ( type.equalsIgnoreCase("administrative_area_level_1") )
				{
					String region="";
					sql = "select state_code from state where DESCR = ?";
					pstm = conn.prepareStatement(sql);
					pstm.setString(1, longName);
					rs = pstm.executeQuery();
					if (rs.next())
					{
						region=rs.getString("state_code");
					}
					rs.close();
					rs = null;
					pstm.close();
					pstm = null;
					if ( region.length() > 0 )
					{
						map.put( "state_code" , region );
					}
				}
				else if (type.equalsIgnoreCase("country"))
				{
					System.out.println("in country " + longName);

					String countryC="";
					sql = "select count_code from Country where DESCR =?";
					pstm = conn.prepareStatement(sql);
					pstm.setString(1, longName);
					rs = pstm.executeQuery();
					if (rs.next()) 
					{
						countryC=rs.getString("count_code");
					}
					rs.close();
					rs = null;
					pstm.close();
					pstm = null;

					if(countryC.length() > 0)
					{
						map.put("count_code", countryC);
					}
				}
				else if (type.equalsIgnoreCase("postal_code"))
				{
					map.put("pin", longName );
					System.out.println("in postal_code " + longName);
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception of the SetFields Method"+e.getMessage());
		}
		return map;
	}
	private HashMap<String, String> getAddressMap(String value )
	{
		HashMap<String, String> map=new HashMap();
		try 
		{
			String firstString = "",finalString="", secondString = "", secString = "", thirdString = "", thiString = "",addr="";
			String Address1="",Address2="",Address3="";
			String FinalS= value.substring(0,value.indexOf("<span class=\"locality\">"));
			String [] arr2=FinalS.split("\\<span.*?\\>");
			for(int k=0;k<arr2.length;k++)
			{
				String[] concatString=arr2[k].split("</span>");
				finalString=finalString.concat(concatString[0]);
			}

			if (finalString.length() > 40)
			{
				addr = finalString.substring(0, 40);
				firstString = addr.substring(0, addr.lastIndexOf(","));
				Address1=firstString;

				String address = finalString.substring(finalString.indexOf(firstString) + firstString.length());

				if (finalString.length() > firstString.length() && address.length() > 40)
				{
					secondString = finalString.substring( firstString.length() +1 ,( firstString.length() +1 )+ 40);
					if(secondString.contains(","))
					{
						secString = secondString.substring(0, secondString.lastIndexOf(","));
						Address2=secString;
					}
					else
					{
						secString = secondString.substring(0, secondString.lastIndexOf(" "));
						Address2=secString;
					}
					String address1 = finalString.substring(finalString.indexOf(secString) + secString.length());

					if (finalString.length() > ((firstString.length()) + (secString.length()))&& address1.length() > 40)
					{
						thirdString = finalString.substring(((finalString.indexOf(secString)) + secString.length()) + 1,
								(((finalString.indexOf(secString)) + secString.length()) + 1) + 40);
						if(thirdString.contains(","))
						{
						thiString = thirdString.substring(0, thirdString.lastIndexOf(","));
						Address3=thiString;
						}
						else
						{
							thiString = thirdString.substring(0, thirdString.lastIndexOf(" "));
							Address3=thiString;
						}
					}
					else
					{
						Address3=address1;

					}
				}
				else
				{
					Address2=address;
					Address3="";
				}
			}
			else
			{
				Address1=finalString;
				Address2="";
				Address3="";
			}
			map.put("addr1", Address1);
			map.put("addr2", Address2);
			map.put("addr3", Address3);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return map;
	}
	
	public String getLastCoachingData( String xmlString ) throws ITMException
	{
		StringBuffer coachingDetailXML = new StringBuffer();
		Document dom = null;
		Connection conn = null;

		//PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmt2 = null;

		//ResultSet resultset = null;
		ResultSet resultset1 = null;
		ResultSet resultset2 = null;
		
		try
		{
			System.out.println( "getLastCoachingData xmlString ["+ xmlString +"]" );
			
			String salesPers = "";
			if( xmlString != null && xmlString.trim().length() != 0 )
			{
				dom = genericUtility.parseString( xmlString );
				salesPers = checkNull( genericUtility.getColumnValue( "sales_pers", dom ) );
			}
			System.out.println( "getLastCoachingData :: salesPers ["+ salesPers +"]" );
			
			conn = getConnection();
			/*String selfCoachingDetSql = "select sm.event_date, sm.event_type, sc.strg_code, sc.sprs_code__ww, sc.survey_code, smst.descr, smst.correct_ans, sc.result, sp.sp_name " + 
					"from sprs_coaching sc, strg_meet sm, survey_master smst, sales_pers sp " + 
					"where sc.tran_id = sm.tran_id " + 
					"and sc.survey_code = smst.survey_code " + 
					"and sp.sales_pers = sm.sales_pers " + 
					"and smst.result_type <> 'A' " + 
					"and sm.event_date = ? " + 
					"and sm.event_type = ? " + 
					"and sm.strg_code = ? " + 
					"and sm.sprs_code__ww = ? " + 
					"and sm.confirmed = 'Y' " +
					"order by sm.event_date, sc.result desc";
			pstmt1 = conn.prepareStatement( selfCoachingDetSql );
			
			String selfCoachingSql ="select max(sm.event_date) event_date, sm.event_type, sm.strg_code, sm.sprs_code__ww " + 
					"from strg_meet sm, sprs_coaching sprsc " + 
					"where sprsc.dcr_id = sm.dcr_id " + 
					"and sprsc.strg_code = sm.strg_code " + 
					"and sprsc.sprs_code__ww = sm.sprs_code__ww " + 
					"and sm.sprs_code__ww = ? " + 
					"group by sm.event_type, sm.strg_code, sm.sprs_code__ww " + 
					"order by event_date desc";
			
			pstmt = conn.prepareStatement( selfCoachingSql );
			pstmt.setString( 1, salesPers );
			resultset = pstmt.executeQuery();

			while( resultset.next() )
			{
				String eventDate = resultset.getString("event_date");
				String eventType = resultset.getString("event_type");
				String strgCode = resultset.getString("strg_code");
				String sprsCodeWw = resultset.getString("sprs_code__ww");
				
				//String coachingstrDate = genericUtility.getValidDateString(eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
				
				System.out.println("strgCode ["+strgCode+"]");
				System.out.println("eventType ["+eventType+"]");
				System.out.println("strgCode ["+strgCode+"]");
				System.out.println("sprsCodeww ["+sprsCodeWw+"]");
				//System.out.println("strDate ["+coachingstrDate+"]");

				pstmt1.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDate) );
				pstmt1.setString( 2, eventType );
				pstmt1.setString( 3, strgCode );
				pstmt1.setString( 4, sprsCodeWw );

				resultset1 = pstmt1.executeQuery();
				while( resultset1.next() )
				{
					coachingDetailXML.append("<Detail1>");
					coachingDetailXML.append("<event_date><![CDATA["+ genericUtility.getValidDateString( resultset1.getString("event_date"), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() ) +"]]></event_date>");
					coachingDetailXML.append("<event_type><![CDATA["+ resultset1.getString( "event_type" ) +"]]></event_type>");
					coachingDetailXML.append("<strg_code><![CDATA["+ genericUtility.checkNull( resultset1.getString( "strg_code" ) ) +"]]></strg_code>"); 
					coachingDetailXML.append("<sprs_code__ww><![CDATA["+ genericUtility.checkNull( resultset1.getString("sprs_code__ww") ) +"]]></sprs_code__ww>");
					coachingDetailXML.append("<survey_code><![CDATA["+ resultset1.getString( "survey_code" ) +"]]></survey_code>");
					coachingDetailXML.append("<descr><![CDATA["+ resultset1.getString( "descr" ) +"]]></descr>"); 
					coachingDetailXML.append("<correct_ans><![CDATA["+ resultset1.getString( "correct_ans" ) +"]]></correct_ans>");
					coachingDetailXML.append("<result><![CDATA["+ resultset1.getString( "result" ) +"]]></result>");
					coachingDetailXML.append("<name><![CDATA["+ resultset1.getString( "sp_name" ) +"]]></name>");
					coachingDetailXML.append("<host_url><![CDATA["+ CommonConstants.TOMCAT_HOME +"]]></host_url>");
					coachingDetailXML.append("</Detail1>");
				}
				pstmt1.clearParameters();
				
				resultset1.close();
				resultset1 = null;
			}
			
			resultset.close();
			resultset = null;
			
			pstmt.close();
			pstmt = null;
			
			if ( pstmt1 != null )
			{
				pstmt1.close();
				pstmt1 = null;
			}*/
			/*String reportingCoachingDetSql = "select sm.event_date, sm.event_type, sc.strg_code, sc.sprs_code__ww, sc.survey_code, smst.descr, smst.correct_ans, sc.result, sp.sp_name " + 
					"from sprs_coaching sc, strg_meet sm, survey_master smst, sales_pers sp " + 
					"where sc.tran_id = sm.tran_id " + 
					"and sc.survey_code = smst.survey_code " + 
					"and sp.sales_pers = sc.sprs_code__ww " + 
					"and smst.result_type <> 'A' " + 
					"and sm.event_date = ? " + 
					"and sm.event_type = ? " + 
					"and sm.strg_code = ? " + 
					"and sm.sprs_code__ww = ? " + 
					"and sm.confirmed = 'Y' " +
					"order by sm.event_date, sc.result desc";
			pstmt1 = conn.prepareStatement( selfCoachingDetSql );
			
			System.out.println( "getLastCoachingData for reporting" );
	
			String reportingCoachingSql = "select max(sm.event_date) event_date, sm.event_type, sm.strg_code, sm.sprs_code__ww, sm.sales_pers " + 
					"from strg_meet sm, sprs_coaching sprsc " + 
					"where sprsc.dcr_id = sm.dcr_id " + 
					"and sprsc.strg_code = sm.strg_code " + 
					"and sprsc.sprs_code__ww = sm.sprs_code__ww " + 
					"and sm.sales_pers = ? " + 
					"group by sm.event_type, sm.strg_code, sm.sprs_code__ww, sm.sales_pers " + 
					"order by event_date desc";
			
			pstmt2 = conn.prepareStatement( reportingCoachingSql );
			pstmt2.setString(1, salesPers);
			resultset2 = pstmt2.executeQuery();

			while( resultset2.next() )
			{
				String eventDate = resultset2.getString("event_date");
				String eventType = resultset2.getString("event_type");
				String strgCode = resultset2.getString("strg_code");
				String sprsCodeWw = resultset2.getString("sprs_code__ww");
				//String coachingstrDate = genericUtility.getValidDateString( eventDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
				
				System.out.println("strgCode ["+strgCode+"]");
				System.out.println("eventType ["+eventType+"]");
				System.out.println("sprsCodeww ["+sprsCodeWw+"]");
				//System.out.println("strDate ["+coachingstrDate+"]");

				//pstmt1.setString( 1, coachingstrDate );
				pstmt1.setTimestamp( 1, java.sql.Timestamp.valueOf(eventDate) );
				pstmt1.setString( 2, eventType );
				pstmt1.setString( 3, strgCode );
				pstmt1.setString( 4, sprsCodeWw );

				resultset1 = pstmt1.executeQuery();
				while( resultset1.next() )
				{
					coachingDetailXML.append("<Detail2>");
					coachingDetailXML.append("<event_date><![CDATA["+ genericUtility.getValidDateString( resultset1.getString("event_date"), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() ) +"]]></event_date>");
					coachingDetailXML.append("<event_type><![CDATA["+ resultset1.getString( "event_type" ) +"]]></event_type>");
					coachingDetailXML.append("<strg_code><![CDATA["+ genericUtility.checkNull( resultset1.getString( "strg_code" ) ) +"]]></strg_code>"); 
					coachingDetailXML.append("<sprs_code__ww><![CDATA["+ genericUtility.checkNull( resultset1.getString("sprs_code__ww") ) +"]]></sprs_code__ww>");
					coachingDetailXML.append("<survey_code><![CDATA["+ resultset1.getString( "survey_code" ) +"]]></survey_code>");
					coachingDetailXML.append("<descr><![CDATA["+ resultset1.getString( "descr" ) +"]]></descr>"); 
					coachingDetailXML.append("<correct_ans><![CDATA["+ resultset1.getString( "correct_ans" ) +"]]></correct_ans>");
					coachingDetailXML.append("<result><![CDATA["+ resultset1.getString( "result" ) +"]]></result>");
					coachingDetailXML.append("<name><![CDATA["+ resultset1.getString( "sp_name" ) +"]]></name>");
					coachingDetailXML.append("<host_url><![CDATA["+ CommonConstants.TOMCAT_HOME +"]]></host_url>");
					coachingDetailXML.append("</Detail2>");
				}
				pstmt1.clearParameters();
				
				resultset1.close();
				resultset1 = null;
			}
			
			resultset2.close();
			resultset2 = null;
			
			pstmt2.close();
			pstmt2 = null;*/
			coachingDetailXML.append("<Root>");

			String selfCoahingWithSql="WITH cte_quantity AS (SELECT MAX(sm.event_date) event_date,sm.event_type,sm.strg_code,sm.sprs_code__ww " + 
					"FROM strg_meet sm,sprs_coaching sprsc,strg_series ss WHERE sprsc.dcr_id = sm.dcr_id AND sprsc.strg_code = sm.strg_code AND sprsc.sprs_code__ww = sm.sprs_code__ww " + 
					"AND sm.sprs_code__ww = ? and ss.sc_code=sm.strg_code and ss.sc_code=sprsc.strg_code and ss.sales_pers=sm.sprs_code__ww and ss.sales_pers=sprsc.sprs_code__ww AND SS.STATUS='Y' GROUP BY sm.event_type,sm.strg_code,sm.sprs_code__ww ) " + 
					"SELECT sm.event_date,sm.event_type,sc.strg_code,sc.sprs_code__ww,sc.survey_code,smst.descr,smst.correct_ans,sc.result,sp.sp_name  " + 
					"FROM sprs_coaching sc,strg_meet sm,survey_master smst,sales_pers sp,cte_quantity  cte " + 
					"WHERE sc.tran_id = sm.tran_id AND sc.survey_code = smst.survey_code AND sp.sales_pers = sm.sales_pers AND smst.result_type <> 'A'  " + 
					"AND sm.event_date = cte.event_date AND sm.event_type = cte.event_type AND sm.strg_code = cte.strg_code AND sm.sprs_code__ww = cte.sprs_code__ww AND sm.confirmed = 'Y' " + 
					"ORDER BY sm.event_date DESC ";
			pstmt1 = conn.prepareStatement( selfCoahingWithSql );
			pstmt1.setString( 1, salesPers );
			resultset1 = pstmt1.executeQuery();
			while( resultset1.next() )
			{
				coachingDetailXML.append("<Detail1>");
				coachingDetailXML.append("<event_date><![CDATA["+ genericUtility.getValidDateString( resultset1.getString("event_date"), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() ) +"]]></event_date>");
				coachingDetailXML.append("<event_type><![CDATA["+ resultset1.getString( "event_type" ) +"]]></event_type>");
				coachingDetailXML.append("<strg_code><![CDATA["+ genericUtility.checkNull( resultset1.getString( "strg_code" ) ) +"]]></strg_code>"); 
				coachingDetailXML.append("<sprs_code__ww><![CDATA["+ genericUtility.checkNull( resultset1.getString("sprs_code__ww") ) +"]]></sprs_code__ww>");
				coachingDetailXML.append("<survey_code><![CDATA["+ resultset1.getString( "survey_code" ) +"]]></survey_code>");
				coachingDetailXML.append("<descr><![CDATA["+ resultset1.getString( "descr" ) +"]]></descr>"); 
				coachingDetailXML.append("<correct_ans><![CDATA["+ resultset1.getString( "correct_ans" ) +"]]></correct_ans>");
				coachingDetailXML.append("<result><![CDATA["+ resultset1.getString( "result" ) +"]]></result>");
				coachingDetailXML.append("<name><![CDATA["+ resultset1.getString( "sp_name" ) +"]]></name>");
				coachingDetailXML.append("<host_url><![CDATA["+ CommonConstants.TOMCAT_HOME +"]]></host_url>");
				coachingDetailXML.append("</Detail1>");
			}
			if(resultset1 != null)
			{
				resultset1.close();
				resultset1 = null;
			}
			if(pstmt1 !=null)
			{
				pstmt1.close();
				pstmt1 =  null;
			}
			
			String reportingCoachingWithSql="WITH cte_quantity AS (SELECT MAX(sm.event_date) event_date,sm.event_type,sm.strg_code,sm.sprs_code__ww,sm.sales_pers " + 
					"FROM strg_meet sm,sprs_coaching sprsc,strg_series ss WHERE sprsc.dcr_id = sm.dcr_id AND sprsc.strg_code = sm.strg_code AND sprsc.sprs_code__ww = sm.sprs_code__ww " + 
					"AND sm.sales_pers = ? and ss.sc_code=sm.strg_code and ss.sc_code=sprsc.strg_code and ss.sales_pers=sm.sprs_code__ww and ss.sales_pers=sprsc.sprs_code__ww AND SS.STATUS='Y'  GROUP BY sm.event_type,sm.strg_code,sm.sprs_code__ww,sm.sales_pers) " + 
					"SELECT sm.event_date,sm.event_type,sc.strg_code,sc.sprs_code__ww,sc.survey_code,smst.descr,smst.correct_ans,sc.result,sp.sp_name  " + 
					"FROM sprs_coaching sc,strg_meet sm,survey_master smst,sales_pers sp,cte_quantity  cte " + 
					"WHERE sc.tran_id = sm.tran_id AND sc.survey_code = smst.survey_code AND sp.sales_pers = sm.sales_pers AND smst.result_type <> 'A'  " + 
					"AND sm.event_date = cte.event_date AND sm.event_type = cte.event_type AND sm.strg_code = cte.strg_code AND sm.sprs_code__ww = cte.sprs_code__ww AND sm.confirmed = 'Y' " + 
					"ORDER BY sm.event_date DESC";
			pstmt2 = conn.prepareStatement( reportingCoachingWithSql );
			pstmt2.setString(1, salesPers);
			resultset2 = pstmt2.executeQuery();
			while( resultset2.next() )
			{
				coachingDetailXML.append("<Detail2>");
				coachingDetailXML.append("<event_date><![CDATA["+ genericUtility.getValidDateString( resultset2.getString("event_date"), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() ) +"]]></event_date>");
				coachingDetailXML.append("<event_type><![CDATA["+ resultset2.getString( "event_type" ) +"]]></event_type>");
				coachingDetailXML.append("<strg_code><![CDATA["+ genericUtility.checkNull( resultset2.getString( "strg_code" ) ) +"]]></strg_code>"); 
				coachingDetailXML.append("<sprs_code__ww><![CDATA["+ genericUtility.checkNull( resultset2.getString("sprs_code__ww") ) +"]]></sprs_code__ww>");
				coachingDetailXML.append("<survey_code><![CDATA["+ resultset2.getString( "survey_code" ) +"]]></survey_code>");
				coachingDetailXML.append("<descr><![CDATA["+ resultset2.getString( "descr" ) +"]]></descr>"); 
				coachingDetailXML.append("<correct_ans><![CDATA["+ resultset2.getString( "correct_ans" ) +"]]></correct_ans>");
				coachingDetailXML.append("<result><![CDATA["+ resultset2.getString( "result" ) +"]]></result>");
				coachingDetailXML.append("<name><![CDATA["+ resultset2.getString( "sp_name" ) +"]]></name>");
				coachingDetailXML.append("<host_url><![CDATA["+ CommonConstants.TOMCAT_HOME +"]]></host_url>");
				coachingDetailXML.append("</Detail2>");
			}
			
			if(resultset2 != null)
			{
				resultset2.close();
				resultset2 = null;
			}
			if(pstmt2 !=null)
			{
				pstmt2.close();
				pstmt2 =  null;
			}
		} 
		catch(Exception e)
		{
			System.out.println( "getLastCoachingData EXCEPTION = "+ e.getMessage());
		}
		finally 
		{
			try
			{
/*				if(resultset!= null)
				{
					resultset.close();
					resultset = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}*/
				if(pstmt1 !=null)
				{
					pstmt1.close();
					pstmt1 =  null;
				} 
				if(pstmt2 !=null)
				{
					pstmt2.close();
					pstmt2 =  null;
				}
				if(resultset1!= null)
				{
					resultset1.close();
					resultset1 = null;
				}
				if(resultset1 != null)
				{
					resultset1.close();
					resultset1 = null;
				}
				if(resultset2 != null)
				{
					resultset2.close();
					resultset2 = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "getLastCoachingData EXCEPTION finally = "+ e);
			}
		}
		coachingDetailXML.append("</Root>");
		System.out.println( "coachingDetailXML ["+ coachingDetailXML +"]" );
		
		return coachingDetailXML.toString();
	}
	//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]
	public String getGradeForSTP(String salesPers,Connection conn) throws ITMException
	{
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		String grdCode="";
		try
		{
			if(conn == null)
			{
				conn = getConnection();
				isLocalConn =true;
			}
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = conn.prepareStatement(getSalesPerData);
			pstmt.setString(1, salesPers);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(new java.util.Date());
			sysDate  = genericUtility.getValidDateString(sysDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat());
			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME='STP_APPL_GRADE' "+
					" AND ?  BETWEEN EFF_FROM AND VALID_UPTO ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,empSite+"_"+itemSer);
			pstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				grdCode  = checkNull(rs.getString(1));
			}	
			else
			{
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, "X"+"_"+itemSer);
				pstmt1.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					grdCode  = checkNull(rs1.getString(1));
				}
				else
				{
					allPstmt = conn.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setTimestamp(2,java.sql.Timestamp.valueOf(sysDate));
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						grdCode  = checkNull(allRs.getString(1));
					}
					
				}
				
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
	
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}

		return grdCode;
	}
	//Added By Bhagyashri T For not update the sales pers for perticular Div[21/04/21]
	//Added by bhagyashri t for team subform sales_pers[W21KJOH15]
		private int randomNumberBetween(int start, int end)
		{
			int randomNumber = 0;
			randomNumber = (int) ( ( end - start  + 1 ) * Math.random() + start ) ;
			System.out.println("New membercode is randomNumberBetween::"+randomNumber);
			return randomNumber;
		}
		//Added by bhagyashri t for team subform sales_pers[W21KJOH15]
		
		//method added by prachi on 09-AUG-22 [W22EBAS005]
		public String getExistingCollectionDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
		{
			ResultSet rs = null;
			PreparedStatement pstmt = null;
			int domID=1;
			StringBuffer valueXmlString = new StringBuffer();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			
			
			try
			{
				DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
				DateFormat dbFormat = new SimpleDateFormat(getDBDateFormat());
				
				String smiQuery = "";

				String dcrID = getDCRId(connectionObject,salePersCode, eventDate);
				System.out.println("dcrID for collection subform>>>"+dcrID);
				smiQuery="SELECT * FROM STRG_MEET_COLLECT WHERE DCR_ID = '"+dcrID+"' AND STRG_CODE IN (" + custList + ")";
				pstmt = connectionObject.prepareStatement(smiQuery);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String billdate = rs.getString("BILL_DATE");
					Date evntDate = dbFormat.parse(billdate);
					billdate = dtFormat.format(evntDate);
					
					valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
					valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
					valueXmlString.append("<tran_id><![CDATA[").append( checkNull(rs.getString("TRAN_ID")) ).append("]]></tran_id>\r\n");
					valueXmlString.append("<bill_amt><![CDATA[").append( checkNull(rs.getString("BILL_AMT")) ).append("]]></bill_amt>\r\n");
					valueXmlString.append("<bill_date><![CDATA[").append(billdate).append("]]></bill_date>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append( checkNull(rs.getString("PAY_MODE")) ).append("]]></pay_mode>\r\n");
					valueXmlString.append("<pay_ref_no><![CDATA[").append( checkNull(rs.getString("PAY_REF_NO")) ).append("]]></pay_ref_no>\r\n");
					valueXmlString.append("<amount><![CDATA[").append( checkNull(rs.getString("AMOUNT")) ).append("]]></amount>\r\n");
					valueXmlString.append("<bank_name><![CDATA[").append( checkNull(rs.getString("BANK_NAME")) ).append("]]></bank_name>\r\n");
					valueXmlString.append("<remarks_collect><![CDATA[").append( checkNull(rs.getString("REMARKS_COLLECT")) ).append("]]></remarks_collect>\r\n");
					valueXmlString.append( "</Detail"+formNo+">\r\n" );
					domID++;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :Collection edit mode detials :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
				throw new ITMException(e);

			}
			finally
			{
				try
				{
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch(Exception e)
				{
					System.out.println( "Exception :Invoice edit mode detials in catch :defaultDataWiz :==>\n"+e.getMessage());
					throw new ITMException(e);
				}
			}
			return valueXmlString.toString();
		}//end
		
		//Added by bhagyashri t for team subform invice[start]
		public String getExistingInvoiceDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
		{
			ResultSet rs = null;
			PreparedStatement pstmt = null;
			int domID=1;
			StringBuffer valueXmlString = new StringBuffer();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			boolean isLocalConn =false;
			try
			{
				if(connectionObject ==null )
				{

					connectionObject = getConnection();
					isLocalConn =true;
				}
				String smiQuery = "";

				String dcrID = getDCRId(connectionObject,salePersCode, eventDate);
				//System.out.println("dcrID for Invoice subform>>>"+dcrID);
				smiQuery="SELECT SMI.LINE_NO,SMI.STRG_CODE,SMI.ITEM_CODE,SMI.QUANTITY, ITEM.DESCR AS ITEMDESCR,SMI.DCR_ID, " 
						+" SMI.RATE, SMI.DISC_PERC, SMI.LOT_NO, SMI.TAX_AMT_INV,SMI.NET_AMT,SMI.CURR_STOCK,SMI.REMARKS_INV " 
						+" FROM STRG_MEET_INVOICE SMI, ITEM ITEM"
						+" WHERE SMI.ITEM_CODE = ITEM.ITEM_CODE "
						+" AND SMI.DCR_ID =  '"+dcrID+"' "+
						"   AND SMI.STRG_CODE IN (" + custList + ")";
				pstmt = connectionObject.prepareStatement(smiQuery);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String item = checkNull(rs.getString("ITEMDESCR"));
					String quantity = checkNull(rs.getString("QUANTITY"));
					String rate = checkNull(rs.getString("RATE"));
					String taxAmt = checkNull(rs.getString("TAX_AMT_INV"));
					valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					if( !item.equals("") )
					{
						valueXmlString.append("<item_descr><![CDATA[").append(item).append("]]></item_descr>\n");


					}
					
					valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
					valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
					valueXmlString.append( "<rate><![CDATA[" ).append(checkNull(rs.getString("RATE"))).append( "]]></rate>\r\n" );
					valueXmlString.append( "<curr_stock><![CDATA[" ).append(checkNull(rs.getString("CURR_STOCK"))).append( "]]></curr_stock>\r\n" );
					valueXmlString.append( "<net_amt><![CDATA[" ).append(checkNull(rs.getString("NET_AMT"))).append( "]]></net_amt>\r\n" );
					valueXmlString.append( "<tax_amt_inv><![CDATA[" ).append(checkNull(rs.getString("TAX_AMT_INV"))).append( "]]></tax_amt_inv>\r\n" );
					valueXmlString.append( "<reamrks_inv><![CDATA[" ).append(checkNull(rs.getString("REMARKS_INV"))).append( "]]></remarks_inv>\r\n" );

					valueXmlString.append( "</Detail"+formNo+">\r\n" );
					domID++;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :Invoice edit mode detials :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
				throw new ITMException(e);

			}
			finally
			{
				try
				{
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
					{
						connectionObject.close();
						connectionObject = null;
						pstmt = null;
					}
				}
				catch(Exception e)
				{
					System.out.println( "Exception :Invoice edit mode detials in catch :defaultDataWiz :==>\n"+e.getMessage());
					throw new ITMException(e);
				}
			}
			return valueXmlString.toString();
		}
		//added by Bhagyashri t for invoice subform[W22EBAS004][start]
		public String getInvoiceItemDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject, String formNo,String formName,String prcListTemplate) throws ITMException
		{
			ResultSet rs = null;
			PreparedStatement pstmt = null;
			int domID = 1;
			int num = 0;
			StringBuffer valueXmlString = new StringBuffer();
			String wrkDateInDbFmt = "";
			String selectedItem = "";
			String dcrId="";
			String sql="";
			String userId="";
			String dcrID="";
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			boolean isLocalConn =false;
			try
			{
				if(connectionObject ==  null )
				{
					connectionObject = getConnection();
					isLocalConn =true;
				}
				DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
				java.util.Date date = Calendar.getInstance().getTime();
				String currDate = dtFormat.format( date );
				userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
				if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
				{
					salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
				}

				String [] temp = scCode.split(",");
				if ( preDomExists( dom2, formNo ))
				{
					selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
				}
				else
				{
					String newScCode = "";
					if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
					{
						newScCode = "'"+scCode+"'";
					}
					else
					{
						newScCode = scCode;
					}
					if(newScCode == null || newScCode.trim().length() == 0)
					{
						newScCode = "''";
					}
					//System.out.println("getItemDetails >> newScCode=["+newScCode+"]");
					selectedItem = getExistingInvoiceDetail( salePersCode, wrkDate , newScCode, formNo,formName,connectionObject) ;
				}
				selectedItem = "<Root>" + selectedItem + "</Root>";
				//System.out.println("selectedItem>>>"+selectedItem);
				String itemDetails = getSalesPersInvItemList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName,dom2,prcListTemplate);

				//System.out.println("itemDetails>>>"+itemDetails);
				valueXmlString.append(itemDetails);
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				e.printStackTrace();
				//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
				throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

			}
			finally
			{
				try
				{
					if (rs !=null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if (isLocalConn && connectionObject != null)
					{
						connectionObject.close();
						connectionObject = null;
					}
				}
				catch(Exception e)
				{
					System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
					System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			//System.out.println("Return valueXmlString===>"+valueXmlString);
			return valueXmlString.toString();
		}
		
		private double getBasicValue(Document dom2,String currentFormNo, String value, String strgCode)
		{
			System.out.println("Inside getBasicValue currentFormNo::"+currentFormNo);
			String CheckUpdateFlag = "";
			int selectedFlagCnt = 0;
			int updateFlagCnt = 0;
			int noOfChilds = 0;
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			String errString = "";
			NodeList parentList = null;
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = "";
			String columnValue = "";
			String checkSQL = "";
			Connection connectionObject = null;
			PreparedStatement pstmt = null;
			PreparedStatement actPstmt = null;
			ResultSet actRs = null;
			ResultSet rSet = null;
			parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("Inside getBasicValue parentNodeListLength::"+parentNodeListLength);
			double totalValue = 0d;
			try
			{
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					if(currDetail.getAttributes().getNamedItem("updateFlag") != null)
					{
						updateFlag = currDetail.getAttributes().getNamedItem("updateFlag").getNodeValue();
					}
					//System.out.println("updateFlag is in basic value:::::::"+updateFlag);
					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					String Rate = "0";
					String quantity = "0";
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = checkNull(childNode.getNodeName());
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						if(childNodeName.equalsIgnoreCase("quantity"))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{
								quantity = checkNull(childNode.getFirstChild().getNodeValue());
								if(quantity.length() == 0)
								{
									quantity = "0";
								}
							}
							else
							{
								quantity = "0";
							}
						}
						else if(childNodeName.equalsIgnoreCase("rate"))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{
								Rate = checkNull(childNode.getFirstChild().getNodeValue());
								if(Rate.length() == 0)
								{
									Rate = "0";
								}
							}
							else
							{
								Rate = "0";
							}
						}
					}
					//System.out.println("quantity =["+quantity+"], landingRate=["+Rate+"],Totalamount["+totalValue+"]");
					if(updateFlag != null && updateFlag.trim().length() > 0 && !("D".equalsIgnoreCase(updateFlag)))
					{
						if(quantity != null && quantity.length()> 0 && Rate != null && Rate.length() > 0)
						{
							totalValue = totalValue + (Double.parseDouble(quantity)* Double.parseDouble(Rate));
						}
					}
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			//System.out.println("getBasicValue for strgCode "+strgCode+":::["+totalValue+"]");
			return totalValue;
		}
		private double getGSTValue(Document dom2,String currentFormNo, String value, String strgCode)
		{
			//System.out.println("Inside getGSTValue");
			String CheckUpdateFlag = "";
			int selectedFlagCnt = 0;
			int updateFlagCnt = 0;
			int noOfChilds = 0;
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			String errString = "";
			NodeList parentList = null;
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = "";
			String columnValue = "";
			String checkSQL = "";
			Connection connectionObject = null;
			PreparedStatement pstmt = null;
			PreparedStatement actPstmt = null;
			ResultSet actRs = null;
			ResultSet rSet = null;
			parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			double totalValue = 0d;
			try
			{
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					if(currDetail.getAttributes().getNamedItem("updateFlag") != null)
					{
						updateFlag = currDetail.getAttributes().getNamedItem("updateFlag").getNodeValue();
					}
					//System.out.println("updateFlag is in gst:::::::"+updateFlag);


					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					String Rate = "0";
					String taxAmount="0";
					String quantity = "0";
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = checkNull(childNode.getNodeName());
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						if(childNodeName.equalsIgnoreCase("quantity"))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{
								quantity = checkNull(childNode.getFirstChild().getNodeValue());
								if(quantity.length() == 0)
								{
									quantity = "0";
								}
							}
							else
							{
								quantity = "0";
							}
						}
						else if(childNodeName.equalsIgnoreCase("rate"))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{
								Rate = checkNull(childNode.getFirstChild().getNodeValue());
								if(Rate.length() == 0)
								{
									Rate = "0";
								}
							}
							else
							{
								Rate = "0";
							}
						}
						if(childNodeName.equalsIgnoreCase(checkNull("tax_amt_inv")))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{

								taxAmount = checkNull(childNode.getFirstChild().getNodeValue());
								System.out.println("value::::["+taxAmount+"]");
							}
						}
					}
					//System.out.println("quantity =["+quantity+"], landingRate=["+Rate+"],Totalamount["+totalValue+"],TaxAmount in GST["+taxAmount+"]");
					if(updateFlag != null && updateFlag.trim().length() > 0 && !("D".equalsIgnoreCase(updateFlag)))
					{
						if(quantity != null && quantity.length()> 0 && Rate != null && Rate.length() > 0)
						{
							totalValue = totalValue + (Double.parseDouble(taxAmount)/100);
						}
					}
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			//System.out.println("getGSTValue for strgCode "+strgCode+":::["+totalValue+"]");
			return totalValue;
		}
		private double getAmountValue(Document dom2,String currentFormNo, String value, String strgCode)
		{
			//System.out.println("Inside getAmountValue");
			String CheckUpdateFlag = "";
			int selectedFlagCnt = 0;
			int updateFlagCnt = 0;
			int noOfChilds = 0;
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			String errString = "";
			NodeList parentList = null;
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;
			String childNodeName = "";
			String columnValue = "";
			String checkSQL = "";
			Connection connectionObject = null;
			PreparedStatement pstmt = null;
			PreparedStatement actPstmt = null;
			ResultSet actRs = null;
			ResultSet rSet = null;
			parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			double totalValue = 0d;
			try
			{
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					String selectedFlag = "";
					String updateFlag = "";

					Node currDetail = parentList.item(prntCtr);
					if(currDetail.getAttributes().getNamedItem("selected") != null)
					{
						selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
					}
					if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
					{
						selectedFlagCnt++;
					}
					if(currDetail.getAttributes().getNamedItem("updateFlag") != null)
					{
						updateFlag = currDetail.getAttributes().getNamedItem("updateFlag").getNodeValue();
					}
					//System.out.println("updateFlag isin amunt:::::::"+updateFlag);

					parentNode = parentList.item(prntCtr);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					String Rate = "0";
					String quantity = "0";
					String taxAmount ="0";
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = checkNull(childNode.getNodeName());
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						if(childNodeName.equalsIgnoreCase("quantity"))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{
								quantity = checkNull(childNode.getFirstChild().getNodeValue());
								if(quantity.length() == 0)
								{
									quantity = "0";
								}
							}
							else
							{
								quantity = "0";
							}
						}
						else if(childNodeName.equalsIgnoreCase("rate"))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{
								Rate = checkNull(childNode.getFirstChild().getNodeValue());
								if(Rate.length() == 0)
								{
									Rate = "0";
								}
							}
							else
							{
								Rate = "0";
							}
						}
						if(childNodeName.equalsIgnoreCase(checkNull("tax_amt_inv")))
						{
							if(( childNode.getFirstChild().getNodeValue() != null))
							{

								taxAmount = checkNull(childNode.getFirstChild().getNodeValue());
								//System.out.println("tax is ::::["+taxAmount+"]");
								
							}
						}
					}
					//System.out.println("quantity["+quantity+"], landingRate["+Rate+"],Totalamount["+totalValue+"],TaxAmount total["+taxAmount+"]");
					if(updateFlag != null && updateFlag.trim().length() > 0 && !("D".equalsIgnoreCase(updateFlag)))
					{
						if(quantity != null && quantity.length()> 0 && Rate != null && Rate.length() > 0)
						{
							totalValue = totalValue + ((Double.parseDouble(quantity)* Double.parseDouble(Rate)) +(Double.parseDouble(taxAmount)/100));
						}
					}
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			//System.out.println("getAmountValue for strgCode "+strgCode+":::["+totalValue+"]");
			return totalValue;
		}
		public String getSalesPersInvItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo, String formName,Document dom2,String prcListTemplate ) throws ITMException
		{

			String sql = "";
			String sql1 = "";
			StringBuffer valueXmlString = new StringBuffer();
			Connection connectionObject = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			PreparedStatement pstmt1 = null;
			ResultSet rs1 = null;
			PreparedStatement custPrcList =null;
			ResultSet rsCustPrc = null;
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			boolean isMasterPitchFound = false;

			String bindValue = sprsCode;

			try
			{
				DARCommonBean darCommonBean= new DARCommonBean();

				valueXmlString.append( "<Root>\r\n" );
				connectionObject = getConnection();
				String paramValue="";
				String custCode="";

				String itemUSage="";
				String parmItemUsage = getSfaParmValue(sprsCode,"SAMPLE_ITEM_USAGE",connectionObject);
				String cashInvoiceAmnt  = checkNull(getSfaParmValue(sprsCode,"CASH_INVOICE_AMOUNT",connectionObject));
				if(parmItemUsage!=null && parmItemUsage.trim().length()>0)
				{
					itemUSage=checkNull(getFormattedStringBuff( parmItemUsage ));
				}
				else
				{
					itemUSage="'G','S'";
				}
				//Addde by mrunalini Sinkar Start
				String invoiceNumber="";
				String maxInvoiceIDSql="SELECT MAX(SMI.INVOICE_ID) AS MAX_INVOICE_ID FROM STRG_MEET_INVOICE SMI,STRG_MEET SM WHERE SMI.TRAN_ID=SM.TRAN_ID AND SM.SALES_PERS=? AND SMI.INVOICE_ID IS NOT NULL  AND SMI.DCR_ID=SM.DCR_ID AND SMI.STRG_CODE=SM.STRG_CODE ";
				pstmt = connectionObject.prepareStatement(maxInvoiceIDSql);
				pstmt.setString(1, sprsCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					String invocieID = checkNull(rs.getString("MAX_INVOICE_ID"));
					if(invocieID.indexOf("/")!=-1)
					{
						invoiceNumber=invocieID.split("/")[1];

					}

				}
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				//Addde by mrunalini Sinkar End
				
				
				sql = " SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, ITEM.UNIT AS ITEM_UNIT, "+
						" ITEM.HSN_NO,(S.QUANTITY-S.ALLOC_QTY) AS QUANTITY,PM.PRICE_LIST AS PRICE_LIST, ITEM.PKG_SIZE AS PKG_SIZE,S.QUANTITY AS STOCK_QTY " +
						" FROM ITEM ITEM LEFT OUTER JOIN PRICELIST  PM ON ITEM.ITEM_CODE = PM.ITEM_CODE,STOCK S,SALES_PERS SP  "+
						" WHERE PM.PRICE_LIST= ? AND SP.ITEM_SER=ITEM.ITEM_SER  "+
						" AND ITEM.ACTIVE = 'Y' "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN("+itemUSage+") "+
						" AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END ))='F' "+
						" AND S.ITEM_CODE=ITEM.ITEM_CODE AND S.SITE_CODE =(SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE= ? ) " + 
						" AND S.LOC_CODE=? AND S.ITEM_SER=ITEM.ITEM_SER AND S.INV_STAT='SALE' AND S.QUANTITY >0 ORDER BY PM.PRICE_LIST " ;
				

				HashMap itemMap = new HashMap();
				HashMap rateMap = new HashMap(); 
				HashMap remarkMap = new HashMap();
				HashMap tranIDMap = new HashMap();

				String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
				
				if ( selectedItem != null && selectedItem.trim().length() > 0 )
				{
					//System.out.println("Inside selected item in add");
					NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
					int nodeListLen = itemNodeList.getLength();
					for ( int i=0; i < nodeListLen ; i++ )
					{
						NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
						int innerNodeListLen = innerNodeList.getLength();
						String itemCode = "";
						String qty = "";
						String columnValue = "";
						String chgRate = "";
						String remarksInv ="";
						String tranID ="";
						for ( int j = 0; j < innerNodeListLen; j++ )
						{
							Node currNode = innerNodeList.item( j );
							if ( "item_code".equals( currNode.getNodeName() ) )
							{
								if(currNode.getFirstChild().getNodeValue() != null )
								{
									itemCode = currNode.getFirstChild().getNodeValue().trim();
								}
							}
							else if ( "quantity".equals( currNode.getNodeName() ) )
							{
								if(currNode.getFirstChild().getNodeValue() != null )
								{
									qty = currNode.getFirstChild().getNodeValue().trim();
								}
							}
							else if ( "rate".equals( currNode.getNodeName() ) )
							{
								if(currNode.getFirstChild() != null)
								{
									chgRate = checkNull(currNode.getFirstChild().getNodeValue());
								}
							}
							else if ( "remarks_inv".equals( currNode.getNodeName() ) )
							{
								if(currNode.getFirstChild() != null)
								{
									remarksInv = checkNull(currNode.getFirstChild().getNodeValue());
								}
							}
							else if ( "tran_id".equals( currNode.getNodeName() ) )
							{
								if(currNode.getFirstChild() != null)
								{
									tranID = checkNull(currNode.getFirstChild().getNodeValue());
								}
							}
						}
						itemMap.put( itemCode,qty);
						rateMap.put(itemCode,chgRate); 
						remarkMap.put(itemCode, remarksInv);
						tranIDMap.put(itemCode, tranID);

					}
				}

				String qty = "";
				int num = 1;
				int lineNo=1;

				double value = 0d;
				double stockValue = 0d;
				double rate = 0d;
				String stock = "";
				 String taxAmount="";
				 String taxAmtSql = "SELECT DDF_TOTAL_TAX_AMOUNT( ? )AS TAXAMT FROM DUAL";
				PreparedStatement pstmtCnt = connectionObject.prepareStatement( taxAmtSql );
				pstmtCnt.setString(1, "IGST");
				ResultSet rset = pstmtCnt.executeQuery();
				if ( rset.next() )
				{
					taxAmount = checkNull( rset.getString( "TAXAMT" ) );
				}
				if (rset !=null )
				{
					rset.close();
					rset = null;
				}
				if(pstmtCnt != null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				
				int currFormNo = Integer.parseInt(formNo);
				String objName = checkNull(getObjNameFromDom(dom2, "objName",currFormNo));
				String parentFormNo = checkNull(getParentformNo(formNo, objName, connectionObject ));
				String collectFormNo=checkNull(getFormNo(objName, "collection", connectionObject));

				String basicValue = getSelectedRowValue(dom2, "1", "net_amt", 0);
				String gstValue = getSelectedRowValue(dom2, "1", "tax_amount", 0);
				String totalValue = getSelectedRowValue(dom2, "1", "amount", 0);
				
				pstmt =  connectionObject.prepareStatement( sql );
				String itemSer=checkNull(getItemSer(sprsCode, connectionObject));
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, prcListTemplate);
				pstmt.setString(2, sprsCode);
				pstmt.setString(3, sprsCode);

				String priceTemplate="'"+prcListTemplate+"'";
				HashMap<String, String> childItemMap = childItemMapFunction(priceTemplate,itemSer,eventDate, sprsCode,connectionObject);
				String evdate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());

				HashMap<String, String> loadQtyMap = loadQtyMap(sprsCode,evdate,connectionObject);

				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String remark="";
					String tranID = "";
					String itemCode = checkNull(rs.getString("ITEM_CODE"));
					String itemDescr = checkNull(rs.getString("DESCR"));
					String itemShDescr = checkNull(rs.getString("SH_DESCR"));
					String priceList = checkNull(rs.getString("PRICE_LIST"));
					String hsnNo= checkNull(rs.getString("HSN_NO"));
					String pkgSize= checkNull(rs.getString("PKG_SIZE"));
					String loadQuantity=checkNull(rs.getString("STOCK_QTY"));
					DecimalFormat df = new DecimalFormat("###.##");
					
					String key=itemCode+"@"+priceList;
					String childItemDescr="",childhsnNoValue="",childPriceList="",childItemCode="",childPackageSize="";
					String subItemDescr="",subhsnNoValue="",subPriceList="",subItemCode="",subPacakgeSize="";
					if(childItemMap.containsKey(key))
					{
						String childItemValue=childItemMap.get(key);
						
						String allValue[]=childItemValue.split("@");
						childItemDescr=allValue[0];
						childhsnNoValue=allValue[1];
						childPriceList=allValue[2];
						childItemCode=allValue[3];
						childPackageSize=allValue[4];
						String childKey=childItemCode+"@"+childPriceList;

						if(childItemMap.containsKey(childKey))
						{
							String subchildItemValue=childItemMap.get(childKey);

							String SuballValue[]=subchildItemValue.split("@");
							subItemDescr=SuballValue[0];
							subhsnNoValue=SuballValue[1];
							subPriceList=SuballValue[2];
							subItemCode=SuballValue[3];
							subPacakgeSize=SuballValue[4];
						}
					}
					
					if(loadQtyMap.containsKey(itemCode))
					{
						loadQuantity=loadQtyMap.get(itemCode);
						System.out.println("loadQuantity from invoice["+loadQuantity+"]");

					}
					else
					{
						String loadSql="SELECT FN_GET_LOAD_QAUNTITY ('0',?,?,?,?) AS LOAD_QTY FROM DUAL";
						PreparedStatement pstmtLoad = connectionObject.prepareStatement(loadSql);
						pstmtLoad.setString(1, loadQuantity);
						pstmtLoad.setString(2, itemCode);
						pstmtLoad.setString(3, sprsCode);
						pstmtLoad.setTimestamp(4, java.sql.Timestamp.valueOf(eventDate));
						ResultSet rsLoad = pstmtLoad.executeQuery();
						if(rsLoad.next())
						{
							loadQuantity=checkNull(rsLoad.getString("LOAD_QTY"));;

						}
						if( rsLoad !=null )
						{
							rsLoad.close();
							rsLoad = null;
						}
						if( pstmtLoad !=null )
						{
							pstmtLoad.close();
							pstmtLoad = null;
						}

					}
					
					
					
					rate = darCommonBean.getLandingRate( strgCode, itemCode, eventDate, sprsCode,priceList, connectionObject);

					double childItemrate  = darCommonBean.getLandingRate( "", childItemCode, eventDate, sprsCode,childPriceList, connectionObject);
					double subItemrate  = darCommonBean.getLandingRate( "", subItemCode, eventDate, sprsCode,subPriceList, connectionObject);

					if ( itemMap.get( itemCode.trim() ) != null || rateMap.get( itemCode.trim() ) != null )
					{
						qty = ( String ) itemMap.get( itemCode.trim() );
						rate = Double.parseDouble(( String ) rateMap.get( itemCode.trim() ));
						//System.out.println("Rate is as in invoice at selected:"+rate);
						if(remarkMap != null && !remarkMap.isEmpty())
						{
							remark = ( String ) remarkMap.get( itemCode.trim() );
						}	
						if(tranIDMap.containsKey(itemCode))
						{
							tranID = (String)tranIDMap.get(itemCode);
						}
						valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
						valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
						valueXmlString.append("<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
						valueXmlString.append("<rate><![CDATA[" ).append(df.format(rate)).append( "]]></rate>\r\n" );
						valueXmlString.append("<remarks_inv><![CDATA[" ).append(remark).append( "]]></remarks_inv>\r\n" );
					}
					else
					{
						valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
						valueXmlString.append("<quantity><![CDATA[" ).append("").append( "]]></quantity>\r\n" );
						valueXmlString.append("<rate><![CDATA[" ).append(df.format(rate)).append( "]]></rate>\r\n" );
						valueXmlString.append("<remarks_inv><![CDATA[" ).append("").append( "]]></remarks_inv>\r\n" );
					}
					if( rate> 0 && qty.trim().length()>0 && taxAmount.trim().length()>0 && qty != null )
			    	{
						double tempQuantity = 0d;
						double tempTaxAmt= 0d;
						double tempTotalGst= 0d;
						double selSgstAmt=0d;
						double selCgstAmt=0d;
						double selValueTotal=0d;
						try
						{
							tempQuantity =Double.parseDouble(qty);
							tempTaxAmt =Double.parseDouble(taxAmount);
							tempTotalGst=(rate * tempQuantity);
							selSgstAmt=(rate * tempQuantity * (tempTaxAmt/200));
							selCgstAmt = selSgstAmt;
							selValueTotal = (tempTotalGst + selCgstAmt + selSgstAmt );
							valueXmlString.append("<value>").append(df.format(tempTotalGst)).append("</value>\n");
							valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(df.format(selSgstAmt)).append( "]]></total_sgst_amount>\r\n" );
							valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(df.format(selCgstAmt)).append( "]]></total_cgst_amount>\r\n" );
							valueXmlString.append("<total_amount><![CDATA[" ).append(df.format(selValueTotal)).append( "]]></total_amount>\r\n" );
							
						}
						catch(NumberFormatException e)
						{
							tempTotalGst=0;
							valueXmlString.append("<value><![CDATA[" ).append(tempTotalGst).append( "]]></value>\r\n" );
							valueXmlString.append("<total_sgst_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_sgst_amount>\r\n" );
							valueXmlString.append("<total_cgst_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_cgst_amount>\r\n" );
							valueXmlString.append("<total_amount><![CDATA[" ).append(tempTotalGst).append( "]]></total_amount>\r\n" );
						}
					}
					else
					{
						valueXmlString.append("<value>").append("").append("</value>\n");
						valueXmlString.append("<total_sgst_amount>").append("").append("</total_sgst_amount>\n");
						valueXmlString.append("<total_cgst_amount>").append("").append("</total_cgst_amount>\n");
						valueXmlString.append("<total_amount>").append("").append("</total_amount>\n");
					}
					valueXmlString.append("<basic_value><![CDATA[" ).append( basicValue ).append( "]]></basic_value>\r\n" );
					valueXmlString.append("<total_gst><![CDATA[" ).append( gstValue ).append( "]]></total_gst>\r\n" );
					valueXmlString.append("<total_value><![CDATA[" ).append( totalValue ).append( "]]></total_value>\r\n" );
					valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
					valueXmlString.append("<item_descr><![CDATA[").append( rs.getString("DESCR") ).append("]]></item_descr>\r\n");
					valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
					valueXmlString.append("<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					valueXmlString.append("<curr_stock><![CDATA[").append( rs.getString("QUANTITY") ).append("]]></curr_stock>\r\n" );
					valueXmlString.append("<org_stock><![CDATA[").append( rs.getString("QUANTITY") ).append("]]></org_stock>\r\n" );
					valueXmlString.append("<load_qty><![CDATA[").append(loadQuantity).append("]]></load_qty>\r\n" );

					valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
					valueXmlString.append("<tax_amt_inv><![CDATA[").append(taxAmount).append("]]></tax_amt_inv>\r\n");
					valueXmlString.append("<hsn_number><![CDATA[" ).append(hsnNo).append( "]]></hsn_number>\r\n" );
					valueXmlString.append("<pkg_size><![CDATA[" ).append(pkgSize).append( "]]></pkg_size>\r\n" );
					valueXmlString.append("<itm_child><![CDATA[" ).append(childItemCode).append( "]]></itm_child>\r\n" );
					valueXmlString.append("<itm_child_descr><![CDATA[" ).append(childItemDescr).append( "]]></itm_child_descr>\r\n" );
					valueXmlString.append("<child_price_list><![CDATA[" ).append(childPriceList).append( "]]></child_price_list>\r\n" );
					valueXmlString.append("<itm_child_rate><![CDATA[" ).append(childItemrate).append( "]]></itm_child_rate>\r\n" );
					valueXmlString.append("<child_hsn_number><![CDATA[" ).append(childhsnNoValue).append( "]]></child_hsn_number>\r\n" );
					valueXmlString.append("<child_pack_size><![CDATA[" ).append(childPackageSize).append( "]]></child_pack_size>\r\n" );
					valueXmlString.append("<sub_itm_child><![CDATA[" ).append(subItemCode).append( "]]></sub_itm_child>\r\n" );
					valueXmlString.append("<sub_child_descr><![CDATA[" ).append(subItemDescr).append( "]]></sub_child_descr>\r\n" );
					valueXmlString.append("<sub_price_list><![CDATA[" ).append(subPriceList).append( "]]></sub_price_list>\r\n" );
					valueXmlString.append("<sub_child_rate><![CDATA[" ).append(subItemrate).append( "]]></sub_child_rate>\r\n" );
					valueXmlString.append("<sub_hsn_number><![CDATA[" ).append(subhsnNoValue).append( "]]></sub_hsn_number>\r\n" );
					valueXmlString.append("<sub_pack_size><![CDATA[" ).append(subPacakgeSize).append( "]]></sub_pack_size>\r\n" );
					valueXmlString.append("<is_broken><![CDATA[" ).append("N").append( "]]></is_broken>\r\n" );
					valueXmlString.append("<max_invoice_id><![CDATA[").append(invoiceNumber).append("]]></max_invoice_id>\r\n" );
					valueXmlString.append("<cash_invoice_amount><![CDATA[").append(cashInvoiceAmnt).append("]]></cash_invoice_amount>\r\n" );
					valueXmlString.append("<collection_form_no><![CDATA[" ).append( collectFormNo ).append( "]]></collection_form_no>\r\n" );//added by prachi on 09-AUG-22 [W22EBAS005]
					valueXmlString.append("</Detail"+formNo+">\r\n" );

					 qty = "";
					 num++;
					 lineNo++;
				}//end of while
				if(rs != null)
				{
					rs.close(); rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close(); pstmt = null;
				}
				num = 1;
			}
			catch (Exception e)
			{
				e.printStackTrace();
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersInvItemList(String):" + e.getMessage() + ":" );
				throw new ITMException(e);

			}
			finally
			{
				try
				{
					if( connectionObject != null && ! connectionObject.isClosed() )
					{
						connectionObject.close();
						connectionObject = null;
					}
				}
				catch(Exception e)
				{
					System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
					throw new ITMException(e);
				}
			}
			valueXmlString.append( "</Root>\r\n" );
			System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
			return valueXmlString.toString();
		}
		//Added by Bhagyashri t For invoice subform[W22EBAS004][end]
}