/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.AssetDataUtility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebServlet(value={"/AssetDataServlet"})
public class AssetDataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        HttpSession sess = null;
        try {
            UserInfoBean userInfo = null;
            String assetCode = this.checkNull(request.getParameter("assetCode"));
            BaseLogger.log("3", null, null, "AssetDataServlet Called:: assetCode[" + assetCode + "]");
            sess = request.getSession();
            BaseLogger.log("3", null, null, "\nsess.getId()............... :" + sess.getId());
            userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
            BaseLogger.log("3", null, null, "AssetDataServlet Called:: assetCode[" + assetCode + "]" + "[userInfo: " + userInfo + "]");
            String transDB = userInfo.getTransDB();
            BaseLogger.log("3", null, null, "AssetDataServlet Called:: assetCode[" + assetCode + "]" + "[userInfo: " + userInfo + "]");
            AssetDataUtility assetDataUtility = new AssetDataUtility();
            String assetHtmlData = assetDataUtility.getAssetData(assetCode, transDB, userInfo);
            response.setStatus(200);
            response.getWriter().write(assetHtmlData);
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception in AssetDataServlet: " + e.getMessage());
            response.setStatus(500);
            response.getWriter().write("<div class='error'>Internal Server Error</div>");
        }
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

