/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DocumentHandlerEJB;
import ibase.webitm.ejb.UploadFileLocal;
import ibase.webitm.ejb.UploadFileRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.sql.CLOB;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class UploadFileEJB
implements UploadFileLocal,
UploadFileRemote {
    @Override
    public boolean getIsDefault(String tempName, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadFileEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String respString = "";
        boolean isDefault = false;
        String transDB = null;
        try {
            try {
                transDB = userInfo.getTransDB();
                String getIsDefault = "SELECT IS_DEFAULT FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME =?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getIsDefault);
                pstmt.setString(1, tempName);
                rs = pstmt.executeQuery();
                if (rs.next() && "Y".equalsIgnoreCase(rs.getString(1))) {
                    isDefault = true;
                }
            }
            catch (Exception e) {
                respString = "exception" + e.getMessage();
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return isDefault;
    }

    @Override
    public HashMap getErrorData(String batchId, String profileId, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadFileEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap errorMap = new HashMap();
        String transDB = null;
        try {
            try {
                BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                transDB = userInfo.getTransDB();
                String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, ERROR_MSG FROM BATCHLOAD WHERE  BATCH_ID = ?  AND LOAD_STAT = ?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getErrorData);
                pstmt.setString(1, batchId);
                pstmt.setString(2, "N");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    do {
                        HashMap<String, Object> innerMap = new HashMap<String, Object>();
                        innerMap.put("winName", rs.getString(1));
                        innerMap.put("tranSl", rs.getInt(2));
                        innerMap.put("loadDate", rs.getTimestamp(3));
                        innerMap.put("errorMessage", rs.getString(4));
                        errorMap.put(String.valueOf(batchId) + "_" + rs.getInt(2), innerMap);
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return errorMap;
    }

    @Override
    public ArrayList getDefaultTemp(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadFileEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> defaultTemp = new ArrayList<String>();
        String transDB = null;
        try {
            try {
                transDB = userInfo.getTransDB();
                String getDefaultTemp = "SELECT TEMPLATE_NAME ,TEMPLATE_XML FROM OBJ_FILE_TEMPLATE WHERE OBJ_NAME = ? AND IS_DEFAULT = ?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getDefaultTemp);
                pstmt.setString(1, objName);
                pstmt.setString(2, "Y");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    defaultTemp.add(rs.getString(1));
                    defaultTemp.add(rs.getString(2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return defaultTemp;
    }

    @Override
    public TreeMap getSortedErrorData(String batchId, String profileId, UserInfoBean userInfo) throws RemoteException, ITMException {
        return this.getSortedErrorData(batchId, profileId, null, userInfo, null);
    }

    public TreeMap getSortedErrorData(String batchId, String profileId, String tranSl, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadFileEjb called");
        ConnDriver connDriver = null;
        boolean isLocalConn = false;
        Statement pstmt = null;
        ResultSet rs = null;
        TreeMap errorMap = new TreeMap();
        try {
            try {
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE,  CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG,  LOAD_STAT, TRAN_ID__REF, DATA_FILE_NAME, XFRM_TEMPLATE, THREAD_KEY, LOAD_ORDER, DEPENDENCY, EDI_ADDR, ADD_DATE, ADD_USER, CHG_DATE, CHG_USER  FROM BATCHLOAD  WHERE BATCH_ID = ? ";
                getErrorData = tranSl != null ? String.valueOf(getErrorData) + " AND TRAN_SL = '" + tranSl + "' " : String.valueOf(getErrorData) + " AND LOAD_STAT in ('N','E','Y')  ORDER BY TO_NUMBER(TRAN_SL)";
                connDriver = new ConnDriver();
                if (conn == null) {
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    isLocalConn = true;
                }
                pstmt = conn.prepareStatement(getErrorData);
                pstmt.setString(1, batchId);
                SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.APPL_DATETIME_FORMAT);
                rs = pstmt.executeQuery();
                String loadDate = "";
                String addDate = "";
                String chgDate = "";
                if (rs.next()) {
                    do {
                        HashMap<String, Object> innerMap = new HashMap<String, Object>();
                        innerMap.put("winName", rs.getString("WIN_NAME"));
                        innerMap.put("tranSl", rs.getInt("TRAN_SL"));
                        loadDate = rs.getTimestamp("LOAD_DATE") != null ? sdf.format(rs.getTimestamp("LOAD_DATE")) : "";
                        innerMap.put("loadDate", loadDate);
                        innerMap.put("errorMessage", rs.getString("ERROR_MSG"));
                        innerMap.put("batchId", batchId);
                        innerMap.put("loadStat", rs.getString("LOAD_STAT"));
                        innerMap.put("tranIdRef", rs.getString("TRAN_ID__REF"));
                        innerMap.put("dataFileName", rs.getString("DATA_FILE_NAME"));
                        innerMap.put("xfrmTemplate", rs.getString("XFRM_TEMPLATE"));
                        innerMap.put("threadKey", rs.getString("THREAD_KEY"));
                        innerMap.put("loadOrder", rs.getString("LOAD_ORDER"));
                        innerMap.put("dependency", rs.getString("DEPENDENCY"));
                        innerMap.put("ediAddr", rs.getString("EDI_ADDR"));
                        addDate = rs.getTimestamp("ADD_DATE") != null ? sdf.format(rs.getTimestamp("ADD_DATE")) : "";
                        innerMap.put("addDate", addDate);
                        innerMap.put("addUser", rs.getString("ADD_USER"));
                        chgDate = rs.getTimestamp("CHG_DATE") != null ? sdf.format(rs.getTimestamp("CHG_DATE")) : "";
                        innerMap.put("chgDate", chgDate);
                        innerMap.put("chgUser", rs.getString("CHG_USER"));
                        errorMap.put(rs.getInt("TRAN_SL"), innerMap);
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && isLocalConn) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return errorMap;
    }

    @Override
    public String getSqlValue(String sqlString, String sqlInput, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadFileEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String respString = "";
        try {
            try {
                connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                BaseLogger.log("3", userInfo, null, "sqlString = [" + sqlString + "] , sqlInput[= " + sqlInput + "]");
                pstmt = conn.prepareStatement(sqlString);
                if (sqlInput.contains(",")) {
                    String[] sqlInputArray = sqlInput.split(",");
                    int i = 0;
                    while (i < sqlInputArray.length) {
                        BaseLogger.log("3", userInfo, null, "input value = " + sqlInputArray[i]);
                        pstmt.setString(i + 1, sqlInputArray[i]);
                        ++i;
                    }
                } else {
                    pstmt.setString(1, sqlInput);
                }
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    respString = rs.getString(1);
                    BaseLogger.log("3", userInfo, null, " respString in getSqlValue = " + respString);
                }
            }
            catch (Exception e) {
                respString = "exception" + e.getMessage();
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return respString;
    }

    @Override
    public HashMap<String, String> getObjList(String profileId, UserInfoBean userInfo, String caller) throws RemoteException, ITMException {
        HashMap<String, String> objListMap;
        block24: {
            ConnDriver connDriver = null;
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            objListMap = new HashMap<String, String>();
            try {
                try {
                    connDriver = new ConnDriver();
                    String transDB = userInfo.getTransDB();
                    conn = connDriver.getConnectDB(transDB);
                    String userLev = userInfo.getUserLevel();
                    String objMapQuery = "";
                    if ("Process_Temp".equalsIgnoreCase(caller)) {
                        String userId = userInfo.getLoginCode();
                        BaseLogger.log("3", userInfo, null, "profile=========>[" + profileId + "]");
                        String profileQureyCond = this.appendProfileIdQueryCond(profileId);
                        BaseLogger.log("3", userInfo, null, "profileQureyCond=========>[" + profileQureyCond + "]");
                        objMapQuery = "SELECT DISTINCT MENU.WIN_NAME, MENU.DESCR  FROM OBJ_FILE_TEMPLATE TEMP, ITM2MENU MENU  WHERE MENU.WIN_NAME = 'w_' || TEMP.OBJ_NAME  AND ( TEMP.CHG_USER = ?  OR TEMP.SHARE_SCOPE = '2'  OR ( TEMP.SHARE_SCOPE = '3' " + profileQureyCond + " )" + " OR ( TEMP.SHARE_SCOPE = '4' AND TEMP.SCOPE_VALUE LIKE '%" + userId + "%' ) )";
                        pstmt = conn.prepareStatement(objMapQuery);
                        pstmt.setString(1, userId);
                    } else if ("0".equalsIgnoreCase(userLev)) {
                        objMapQuery = "SELECT WIN_NAME, DESCR FROM ITM2MENU  WHERE ( WIN_NAME != NULL OR WIN_NAME != '-' )  AND OBJ_TYPE = 'T'  ORDER BY APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5 ";
                        pstmt = conn.prepareStatement(objMapQuery);
                    } else {
                        objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + "AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " + "AND ( A.RIGHTS LIKE '%U%' or (A.RIGHTS LIKE '%*%' AND  (A.EXCLUDE_RIGHTS_CHAR NOT LIKE '%U%' OR A.EXCLUDE_RIGHTS_CHAR IS NULL ))) AND ( WIN_NAME != NULL or WIN_NAME != '-') AND B.OBJ_TYPE = 'T '" + "ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
                        pstmt = conn.prepareStatement(objMapQuery);
                    }
                    String objName = "";
                    String desc = "";
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        do {
                            if ((objName = rs.getString("WIN_NAME")) != null && objName.indexOf("w") == 0 && objName.indexOf("_") == 1) {
                                objName = objName.substring(2);
                            }
                            desc = rs.getString("DESCR");
                            objListMap.put(objName, desc);
                        } while (rs.next());
                        break block24;
                    }
                    BaseLogger.log("3", userInfo, null, "rs is null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return objListMap;
    }

    @Override
    public String getTemplateXml(String tempName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String xmlString = "";
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_XML_NEW.getClobval()  FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.TEMPLATE_NAME =?";
                connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getExistingTemplate);
                pstmt.setString(1, tempName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    xmlString = rs.getString(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return xmlString;
    }

    @Override
    public boolean getUserAccess(String profileId, String pageName, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, " pageName = " + pageName);
        boolean isAccessible = false;
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String transDB = null;
        String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND WIN_NAME IN (?, ?, ?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + "AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " + "AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')";
        try {
            try {
                transDB = userInfo.getTransDB();
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getUserAccess);
                if (pageName.equals("Apply_Default_Temp")) {
                    pstmt.setString(1, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/jsp/E12ApplyDefaultTemp.jsp");
                    pstmt.setString(2, "/ibase/jsp/E12ApplyDefaultTemp.jsp");
                    pstmt.setString(3, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/webitm/jsp/E12ApplyDefaultTemp.jsp");
                    pstmt.setString(4, "/ibase/webitm/jsp/E12ApplyDefaultTemp.jsp");
                } else if (pageName.equals("Upload_Temp")) {
                    pstmt.setString(1, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/jsp/E12UploadTemplate.jsp");
                    pstmt.setString(2, "/ibase/jsp/E12UploadTemplate.jsp");
                    pstmt.setString(3, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/webitm/jsp/E12UploadTemplate.jsp?reset=true");
                    pstmt.setString(4, "/ibase/webitm/jsp/E12UploadTemplate.jsp?reset=true");
                } else if (pageName.equals("Process_Temp")) {
                    pstmt.setString(1, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/jsp/E12ProcessTemplate.jsp");
                    pstmt.setString(2, "/ibase/jsp/E12ProcessTemplate.jsp");
                    pstmt.setString(3, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/webitm/jsp/E12ProcessTemplate.jsp?reset=true");
                    pstmt.setString(4, "/ibase/webitm/jsp/E12ProcessTemplate.jsp?reset=true");
                }
                rs = pstmt.executeQuery();
                if (rs.next() && rs.getInt(1) > 0) {
                    isAccessible = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return isAccessible;
    }

    @Override
    public HashMap getExistingTemplate(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, String> existingTemplateList = new HashMap<String, String>();
        try {
            try {
                String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_NAME, TEMPLATE.TEMPLATE_XML , TEMPLATE.TEMPLATE_XML_NEW.getClobval() FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.OBJ_NAME =?";
                connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getExistingTemplate);
                pstmt.setString(1, objName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    do {
                        String templateName = E12GenericUtility.checkNull(rs.getString("TEMPLATE_NAME"));
                        existingTemplateList.put(templateName, rs.getString(3));
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return existingTemplateList;
    }

    @Override
    public String saveTemplate(String objName, String tempName, String xmlString, String isDefault, UserInfoBean userInfo) throws RemoteException, ITMException {
        String respString = null;
        ConnDriver connDriver = null;
        connDriver = new ConnDriver();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                String getTemplateCount = "SELECT COUNT(1) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ?";
                pstmt = conn.prepareStatement(getTemplateCount);
                pstmt.setString(1, tempName);
                pstmt.setString(2, objName);
                rs = pstmt.executeQuery();
                pstmt.close();
                pstmt = null;
                if (rs.next()) {
                    if (rs.getInt(1) == 0) {
                        String tranId = this.generateTranId("w_obj_file_template", conn);
                        String insertTemplate = "INSERT INTO OBJ_FILE_TEMPLATE(OBJ_NAME, TEMPLATE_NAME, TEMPLATE_XML, IS_DEFAULT,TEMPLATE_XML_NEW,TEMPLATE_ID) VALUES (?,?,?,?,XMLType(?),?)";
                        BaseLogger.log("3", userInfo, null, "insertTemplate = " + insertTemplate);
                        pstmt = conn.prepareStatement(insertTemplate);
                        pstmt.setString(1, objName);
                        pstmt.setString(2, tempName);
                        pstmt.setString(3, "");
                        pstmt.setString(4, isDefault);
                        CLOB xmlData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        xmlData.putString(1L, xmlString);
                        pstmt.setClob(5, (Clob)xmlData);
                        pstmt.setString(6, tranId);
                    } else {
                        String updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = XMLType(?) WHERE  TEMPLATE_NAME = ? AND OBJ_NAME = ? ";
                        BaseLogger.log("3", userInfo, null, "updateTemplate = " + updateTemplate);
                        pstmt = conn.prepareStatement(updateTemplate);
                        pstmt.setString(1, "");
                        pstmt.setString(2, isDefault);
                        CLOB xmlData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        xmlData.putString(1L, xmlString);
                        pstmt.setClob(3, (Clob)xmlData);
                        pstmt.setString(4, tempName);
                        pstmt.setString(5, objName);
                    }
                    int result = pstmt.executeUpdate();
                    respString = result > 0 ? "Template saved in database" : "Error while saving template";
                }
                if (conn != null) {
                    conn.commit();
                }
            }
            catch (SQLException e) {
                BaseLogger.log("0", userInfo, null, "In SQLException - " + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "In Exception - " + e.getMessage());
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return respString;
    }

    @Override
    public HashMap<String, HashMap<String, String>> getTemplateDetail(String objName, String accessFrom, UserInfoBean userInfo) throws RemoteException, ITMException {
        return this.getTemplateDetail(objName, accessFrom, null, userInfo);
    }

    public HashMap<String, HashMap<String, String>> getTemplateDetail(String objName, String accessFrom, String templateName, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String rights = "";
        HashMap<String, HashMap<String, String>> templateDetailMap = null;
        try {
            try {
                connDriver = new ConnDriver();
                String loginCode = "";
                String loginUserProfile = "";
                ArrayList<String> userProfileList = null;
                if (userInfo != null) {
                    String transDB = userInfo.getTransDB();
                    conn = connDriver.getConnectDB(transDB);
                    loginCode = userInfo.getLoginCode();
                    loginUserProfile = this.checkNull(userInfo.getProfileId());
                    if (loginUserProfile.length() > 0) {
                        userProfileList = new ArrayList<String>(Arrays.asList(loginUserProfile.split("\\s*,\\s*")));
                    }
                    BaseLogger.log("3", userInfo, null, "loginCode - [" + loginCode + "], loginUserProfile - [" + loginUserProfile + "]");
                }
                connDriver = null;
                String templateDetailSQL = " SELECT TEMPLATE.TEMPLATE_NAME, TEMPLATE.TEMPLATE_XML, TEMPLATE.IS_DEFAULT,  TEMPLATE.TEMPLATE_XML_NEW, TEMPLATE.FILE_MAPPING FILE_MAPPING, TEMPLATE_ID, SHARE_SCOPE, SCOPE_VALUE, ADD_USER, CHG_USER, DOC_ID, RIGHTS_CHAR, AUTO_CONFIRM  FROM OBJ_FILE_TEMPLATE TEMPLATE  WHERE TEMPLATE.OBJ_NAME = ? ";
                if (this.checkNull(templateName).length() > 0) {
                    templateDetailSQL = String.valueOf(templateDetailSQL) + " AND TEMPLATE.TEMPLATE_NAME = ? ";
                }
                templateDetailSQL = String.valueOf(templateDetailSQL) + " AND (TEMPLATE.ACTIVE is null or TEMPLATE.ACTIVE = 'Y') ";
                BaseLogger.log("3", userInfo, null, "templateDetailSQL :: - [" + templateDetailSQL + "]");
                pstmt = conn.prepareStatement(templateDetailSQL);
                pstmt.setString(1, objName);
                if (this.checkNull(templateName).length() > 0) {
                    pstmt.setString(2, templateName);
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    templateDetailMap = new HashMap<String, HashMap<String, String>>();
                    do {
                        String templateId = E12GenericUtility.checkNull(rs.getString("TEMPLATE_ID"));
                        templateName = E12GenericUtility.checkNull(rs.getString("TEMPLATE_NAME"));
                        String templateXml = E12GenericUtility.checkNull(rs.getString("TEMPLATE_XML"));
                        String templateXmlNew = E12GenericUtility.checkNull(rs.getString("TEMPLATE_XML_NEW"));
                        String isDefault = E12GenericUtility.checkNull(rs.getString("IS_DEFAULT"));
                        String fileMappingXml = E12GenericUtility.checkNull(rs.getString("FILE_MAPPING"));
                        String shareScope = E12GenericUtility.checkNull(rs.getString("SHARE_SCOPE"));
                        String scopeValue = E12GenericUtility.checkNull(rs.getString("SCOPE_VALUE"));
                        String addUser = E12GenericUtility.checkNull(rs.getString("ADD_USER"));
                        String chgUser = E12GenericUtility.checkNull(rs.getString("CHG_USER"));
                        String docId = E12GenericUtility.checkNull(rs.getString("DOC_ID"));
                        String rightsChar = E12GenericUtility.checkNull(rs.getString("RIGHTS_CHAR"));
                        String isAutoConfirm = E12GenericUtility.checkNull(rs.getString("AUTO_CONFIRM"));
                        BaseLogger.log("3", userInfo, null, "shareScope - [" + shareScope + "]");
                        BaseLogger.log("3", userInfo, null, "docId - [" + docId + "]");
                        BaseLogger.log("3", userInfo, null, "templateName - [" + templateName + "]");
                        if (scopeValue.length() > 1 && rightsChar.length() == 1) {
                            StringBuffer rightsBuff = new StringBuffer();
                            String[] scopeValueArr = scopeValue.split(", ");
                            int scopeValCtr = 0;
                            while (scopeValCtr < scopeValueArr.length) {
                                rightsBuff = rightsBuff.append(String.valueOf(rightsChar) + ", ");
                                ++scopeValCtr;
                            }
                            rightsChar = rightsBuff.toString();
                            if (rightsChar.length() > 2) {
                                rightsChar = rightsChar.substring(0, rightsChar.length() - 2);
                            }
                        }
                        if (!addUser.equals(loginCode)) {
                            ArrayList<String> dataList = new ArrayList<String>(Arrays.asList(scopeValue.split("\\s*,\\s*")));
                            ArrayList<String> rightList = new ArrayList<String>(Arrays.asList(rightsChar.split("\\s*,\\s*")));
                            if ("1".equalsIgnoreCase(shareScope)) {
                                BaseLogger.log("3", userInfo, null, "addUser - [" + addUser + "]");
                                if (!addUser.equals(loginCode)) {
                                    continue;
                                }
                            } else if ("3".equalsIgnoreCase(shareScope)) {
                                boolean profileIdExist = false;
                                int profileCtr = 0;
                                while (profileCtr < userProfileList.size()) {
                                    String profileId = (String)userProfileList.get(profileCtr);
                                    int dataCtr = 0;
                                    while (dataCtr < dataList.size()) {
                                        String dataProfile = (String)dataList.get(dataCtr);
                                        if (dataProfile.equals(profileId) && rightList.size() > 0) {
                                            profileIdExist = true;
                                            rights = (String)rightList.get(dataCtr);
                                            break;
                                        }
                                        ++dataCtr;
                                    }
                                    ++profileCtr;
                                }
                                if (!profileIdExist) {
                                    continue;
                                }
                            } else if ("4".equalsIgnoreCase(shareScope)) {
                                int userEntity = 0;
                                while (userEntity < dataList.size()) {
                                    String entity = (String)dataList.get(userEntity);
                                    if (entity.equals(loginCode)) {
                                        rights = (String)rightList.get(userEntity);
                                    }
                                    ++userEntity;
                                }
                                BaseLogger.log("3", userInfo, null, "dataList - [" + dataList + "]");
                                if (dataList != null && !dataList.contains(loginCode)) continue;
                            }
                            if ("Process_Temp".equalsIgnoreCase(accessFrom) && "E".equalsIgnoreCase(rights)) continue;
                        }
                        HashMap<String, String> detailMap = new HashMap<String, String>();
                        detailMap.put("TEMPLATE_NAME", templateName);
                        detailMap.put("TEMPLATE_XML", templateXml);
                        detailMap.put("TEMPLATE_XML_NEW", templateXmlNew);
                        detailMap.put("IS_DEFAULT", isDefault);
                        detailMap.put("FILE_MAPPING", fileMappingXml);
                        detailMap.put("TEMPLATE_ID", templateId);
                        detailMap.put("SHARE_SCOPE", shareScope);
                        detailMap.put("SCOPE_VALUE", scopeValue);
                        detailMap.put("TEMP_DOC_ID", docId);
                        detailMap.put("TEMP_RIGHTS_CHAR", rightsChar);
                        detailMap.put("ADD_USER", addUser);
                        detailMap.put("CHG_USER", chgUser);
                        detailMap.put("RIGHTS", rights);
                        detailMap.put("AUTO_CONFIRM", isAutoConfirm);
                        templateDetailMap.put(templateName, detailMap);
                    } while (rs.next());
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return templateDetailMap;
    }

    @Override
    public TreeMap<Integer, String> getFormWiseTitleMap(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pStmt = null;
        ResultSet rs = null;
        TreeMap<Integer, String> formDetailInfo = new TreeMap<Integer, String>();
        try {
            try {
                connDriver = new ConnDriver();
                if (userInfo != null) {
                    String transDB = userInfo.getTransDB();
                    conn = connDriver.getConnectDB(transDB);
                }
                connDriver = null;
                String winName = objName.contains("w_") ? objName : "w_" + objName;
                String sql = " SELECT FORM_NO, TITLE FROM OBJ_FORMS WHERE WIN_NAME = ? ORDER BY TO_NUMBER(FORM_NO) ";
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, winName);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    formDetailInfo.put(rs.getInt("FORM_NO"), rs.getString("TITLE"));
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            if (conn != null) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
        }
        return formDetailInfo;
    }

    @Override
    public String saveTemplate(String tempId, String objName, String tempName, String xmlString, String isDefault, String fileMapping, String shareScope, String scopeValue, String templateRightsChar, String fileName, byte[] byteArray, String filePath, String isDataUploadAutoConfirm, UserInfoBean userInfo) throws RemoteException, ITMException {
        String respString = "<Root><Detail>Error</Detail></Root>";
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String tranId = "";
        boolean isError = false;
        String dbName = "";
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                String transDB = this.checkNull(userInfo.getTransDB());
                if (transDB.trim().length() > 0) {
                    conn = connDriver.getConnectDB(transDB);
                }
                dbName = connDriver.getDBName(conn);
                connDriver = null;
                conn.setAutoCommit(false);
                tranId = tempId != null && tempId.length() > 0 ? tempId : this.generateTranId("w_obj_file_template", conn);
                BaseLogger.log("3", userInfo, null, "scopeValue.length() - [" + scopeValue.length() + "]");
                String chgTerm = userInfo.getRemoteHost();
                String loginCode = userInfo.getLoginCode();
                if (scopeValue.length() <= 0) {
                    scopeValue = loginCode;
                }
                String docId = "";
                if (byteArray != null) {
                    String documentStr = this.addDocument(tranId, objName, tempName, fileName, byteArray, filePath, userInfo);
                    docId = this.getDocumentId(documentStr);
                }
                String getTemplateCount = "SELECT COUNT(1) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ?";
                pstmt = conn.prepareStatement(getTemplateCount);
                pstmt.setString(1, tempName);
                pstmt.setString(2, objName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    if (rs.getInt(1) == 0) {
                        pstmt.close();
                        pstmt = null;
                        rs.close();
                        rs = null;
                        String insertTemplate = "INSERT INTO OBJ_FILE_TEMPLATE(TEMPLATE_ID, OBJ_NAME, TEMPLATE_NAME, TEMPLATE_XML, IS_DEFAULT, TEMPLATE_XML_NEW, FILE_MAPPING, ADD_USER, ADD_DATE, ADD_TERM, CHG_USER, CHG_DATE, CHG_TERM, SHARE_SCOPE, SCOPE_VALUE, DOC_ID, RIGHTS_CHAR, ACTIVE, AUTO_CONFIRM)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                        BaseLogger.log("3", userInfo, null, "insertTemplate = " + insertTemplate);
                        pstmt = conn.prepareStatement(insertTemplate);
                        pstmt.setString(1, tranId);
                        pstmt.setString(2, objName);
                        pstmt.setString(3, tempName);
                        pstmt.setString(4, "");
                        pstmt.setString(5, isDefault);
                        if ("pgsql".equalsIgnoreCase(dbName)) {
                            pstmt.setString(6, xmlString);
                            pstmt.setString(7, fileMapping);
                        } else {
                            CLOB xmlData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                            xmlData.putString(1L, xmlString);
                            pstmt.setClob(6, (Clob)xmlData);
                            CLOB fileMappingData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                            fileMappingData.putString(1L, fileMapping);
                            pstmt.setClob(7, (Clob)fileMappingData);
                        }
                        pstmt.setString(8, loginCode);
                        pstmt.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                        pstmt.setString(10, chgTerm);
                        pstmt.setString(11, loginCode);
                        pstmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                        pstmt.setString(13, chgTerm);
                        pstmt.setString(14, shareScope);
                        pstmt.setString(15, scopeValue);
                        pstmt.setString(16, docId);
                        pstmt.setString(17, templateRightsChar);
                        pstmt.setString(18, "Y");
                        pstmt.setString(19, isDataUploadAutoConfirm);
                    } else {
                        String updateTemplate;
                        pstmt.close();
                        pstmt = null;
                        rs.close();
                        rs = null;
                        if (byteArray != null) {
                            updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = ?,  FILE_MAPPING = ?, CHG_USER = ?, CHG_DATE = ?, CHG_TERM = ?, SHARE_SCOPE = ?, SCOPE_VALUE = ?, DOC_ID = ?, RIGHTS_CHAR = ?, AUTO_CONFIRM = ? WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ? AND TEMPLATE_ID = ? ";
                            BaseLogger.log("3", userInfo, null, "updateTemplate = " + updateTemplate);
                            pstmt = conn.prepareStatement(updateTemplate);
                            pstmt.setString(1, "");
                            pstmt.setString(2, isDefault);
                            if ("pgsql".equalsIgnoreCase(dbName)) {
                                pstmt.setString(3, xmlString);
                                pstmt.setString(4, fileMapping);
                            } else {
                                CLOB xmlData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                                xmlData.putString(1L, xmlString);
                                pstmt.setClob(3, (Clob)xmlData);
                                CLOB fileMappingData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                                fileMappingData.putString(1L, fileMapping);
                                pstmt.setClob(4, (Clob)fileMappingData);
                            }
                            pstmt.setString(5, loginCode);
                            pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                            pstmt.setString(7, chgTerm);
                            pstmt.setString(8, shareScope);
                            pstmt.setString(9, scopeValue);
                            pstmt.setString(10, docId);
                            pstmt.setString(11, templateRightsChar);
                            pstmt.setString(12, isDataUploadAutoConfirm);
                            pstmt.setString(13, tempName);
                            pstmt.setString(14, objName);
                            pstmt.setString(15, tempId);
                        } else {
                            updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = ?,  FILE_MAPPING = ?, CHG_USER = ?, CHG_DATE = ?, CHG_TERM = ?, SHARE_SCOPE = ?, SCOPE_VALUE = ?, RIGHTS_CHAR = ?, AUTO_CONFIRM = ?  WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ? AND TEMPLATE_ID = ? ";
                            BaseLogger.log("3", userInfo, null, "updateTemplate = " + updateTemplate);
                            pstmt = conn.prepareStatement(updateTemplate);
                            pstmt.setString(1, "");
                            pstmt.setString(2, isDefault);
                            if ("pgsql".equalsIgnoreCase(dbName)) {
                                pstmt.setString(3, xmlString);
                                pstmt.setString(4, fileMapping);
                            } else {
                                CLOB xmlData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                                xmlData.putString(1L, xmlString);
                                pstmt.setClob(3, (Clob)xmlData);
                                CLOB fileMappingData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                                fileMappingData.putString(1L, fileMapping);
                                pstmt.setClob(4, (Clob)fileMappingData);
                            }
                            pstmt.setString(5, loginCode);
                            pstmt.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                            pstmt.setString(7, chgTerm);
                            pstmt.setString(8, shareScope);
                            pstmt.setString(9, scopeValue);
                            pstmt.setString(10, templateRightsChar);
                            pstmt.setString(11, isDataUploadAutoConfirm);
                            pstmt.setString(12, tempName);
                            pstmt.setString(13, objName);
                            pstmt.setString(14, tempId);
                        }
                    }
                    int result = pstmt.executeUpdate();
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (result > 0) {
                        respString = "<Root><Detail>Success</Detail></Root>";
                    }
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in userInfo saveTemplate - [" + e.getMessage() + "]");
                isError = true;
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    if (!isError) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    conn.close();
                    conn = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return respString;
    }

    private String generateTranId(String windowName, Connection conn) throws ITMException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String selSql = "";
        String tranId = "";
        String tranSer = "";
        String keyString = "";
        String keyCol = "";
        String xmlValues = "";
        try {
            try {
                selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, windowName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyString = rs.getString("KEY_STRING");
                    keyCol = rs.getString("TRAN_ID_COL");
                    tranSer = rs.getString("REF_SER");
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", null, null, "keyString :" + keyString);
                BaseLogger.log("3", null, null, "keyCol :" + keyCol);
                BaseLogger.log("3", null, null, "tranSer :" + tranSer);
                xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
                xmlValues = String.valueOf(xmlValues) + "<Header></Header>";
                xmlValues = String.valueOf(xmlValues) + "<Detail1>";
                xmlValues = String.valueOf(xmlValues) + "<tran_id></tran_id>";
                xmlValues = String.valueOf(xmlValues) + "</Detail1></Root>";
                BaseLogger.log("3", null, null, "xmlValues  :[" + xmlValues + "]");
                TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
                tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
                BaseLogger.log("3", null, null, "tranId :" + tranId);
            }
            catch (SQLException ex) {
                BaseLogger.log("0", null, null, "Exception ::" + selSql + ex.getMessage() + ":");
                ex.printStackTrace();
                throw new ITMException(ex);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception ::" + e.getMessage() + ":");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
        return tranId;
    }

    @Override
    public String getUploadStatusData(String batchId, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Statement pstmt = null;
        ResultSet rs = null;
        StringBuffer result = new StringBuffer();
        String retResult = "";
        boolean localConn = false;
        try {
            try {
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, TRAN_ID__REF, LOAD_STAT, BATCH_ID, DATA_FILE_NAME, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG  FROM BATCHLOAD  WHERE BATCH_ID = ?  AND LOAD_STAT in ('N','E','Y')  ORDER BY TO_NUMBER(TRAN_SL)";
                if (conn == null) {
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    localConn = true;
                }
                pstmt = conn.prepareStatement(getErrorData);
                pstmt.setString(1, batchId);
                SimpleDateFormat sdfdate = new SimpleDateFormat("MM/dd/yyy hh:mm a");
                HashMap<String, HashMap> dataMap = new HashMap<String, HashMap>();
                int totalRec = 0;
                int transl = 0;
                int processed = 0;
                int successRec = 0;
                int errorRec = 0;
                int unProcessed = 0;
                String objName = "";
                String loadStatus = "";
                String tranIdRef = "";
                String errorMsg = "";
                String winName = "";
                String dataFileName = "";
                String loadDate = "";
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    result.append("<ROOT>");
                    do {
                        ++totalRec;
                        winName = this.checkNull(rs.getString(1));
                        if (winName.length() > 2) {
                            objName = winName.substring(2);
                        }
                        transl = rs.getInt(2);
                        loadDate = rs.getTimestamp(3) != null ? sdfdate.format(rs.getTimestamp(3)) : "";
                        tranIdRef = rs.getString(4) != null ? rs.getString(4) : "";
                        loadStatus = rs.getString(5);
                        batchId = rs.getString(6);
                        dataFileName = rs.getString(7);
                        errorMsg = rs.getString(8);
                        result.append("<DETAIL>");
                        result.append("<BATCH_ID><![CDATA[").append(this.checkNull(batchId)).append("]]></BATCH_ID>");
                        result.append("<WIN_NAME><![CDATA[").append(this.checkNull(rs.getString(1))).append("]]></WIN_NAME>");
                        result.append("<TRAN_SL><![CDATA[").append(transl).append("]]></TRAN_SL>");
                        result.append("<TRAN_ID_REF><![CDATA[").append(this.checkNull(tranIdRef)).append("]]></TRAN_ID_REF>");
                        result.append("<LOAD_DATE><![CDATA[").append(this.checkNull(loadDate)).append("]]></LOAD_DATE>");
                        result.append("<LOAD_STAT><![CDATA[").append(loadStatus).append("]]></LOAD_STAT>");
                        result.append("<DATA_FILE_NAME><![CDATA[").append(dataFileName).append("]]></DATA_FILE_NAME>");
                        result.append("<ERROR_MSG><![CDATA[").append(this.checkNull(errorMsg)).append("]]></ERROR_MSG>");
                        result.append("</DETAIL>");
                        if ("Y".equalsIgnoreCase(loadStatus)) {
                            ++successRec;
                        } else if ("E".equalsIgnoreCase(loadStatus)) {
                            ++errorRec;
                        } else if ("N".equalsIgnoreCase(loadStatus)) {
                            ++unProcessed;
                        }
                        processed = successRec + errorRec;
                    } while (rs.next());
                    result.append("</ROOT>");
                }
                HashMap metadataMap = new HashMap();
                int percentage = processed * 100 / totalRec;
                metadataMap.put("batchId", batchId);
                metadataMap.put("objName", objName);
                metadataMap.put("totalRec", "" + totalRec);
                metadataMap.put("successRec", "" + successRec);
                metadataMap.put("errorRec", "" + errorRec);
                metadataMap.put("unProcessed", "" + unProcessed);
                metadataMap.put("processed", "" + processed);
                metadataMap.put("progress", String.valueOf(processed) + " / " + totalRec);
                metadataMap.put("percentage", "" + percentage);
                metadataMap.put("dataFileName", dataFileName);
                metadataMap.put("response", "" + result);
                BaseLogger.log("3", userInfo, null, "successRec - [" + successRec + "], errorRec - [" + errorRec + "], unProcessed - [" + unProcessed + "]");
                BaseLogger.log("3", userInfo, null, "processed - [" + processed + "]");
                BaseLogger.log("3", userInfo, null, "loadDate - [" + loadDate + "], tranIdRef -[" + tranIdRef + "]");
                dataMap.put(batchId, metadataMap);
                JSONObject resultJson = new JSONObject();
                for (Map.Entry entry : dataMap.entrySet()) {
                    String mapBatchId = (String)entry.getKey();
                    metadataMap = (HashMap)entry.getValue();
                    if (metadataMap == null) continue;
                    JSONObject metadataJson = new JSONObject();
                    for (Map.Entry entry1 : metadataMap.entrySet()) {
                        metadataJson.put((String)entry1.getKey(), entry1.getValue());
                    }
                    resultJson.put(mapBatchId, (Object)metadataJson);
                }
                retResult = resultJson.toString();
                BaseLogger.log("3", userInfo, null, "retResult ---[" + retResult + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception on getUploadStatusData----[" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (localConn && conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (localConn && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return retResult;
    }

    public String getUploadStatusDataArray(String batchId, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException {
        BaseLogger.log("3", userInfo, null, "In upload status data array:");
        ConnDriver connDriver = null;
        Statement pstmt = null;
        ResultSet rs = null;
        StringBuffer result = new StringBuffer();
        String retResult = "";
        boolean localConn = false;
        try {
            try {
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "batchId [" + batchId + "]");
                String getErrorData = "";
                getErrorData = batchId.indexOf("-") == -1 ? "SELECT CREATED_DATE as DateTime,JOB_ID as Transaction_Id, (CASE WHEN JOB_STAT IN('I','C') THEN 'Successfully Sent.' ELSE REMARKS END) as Message FROM BACKGROUND_JOB  WHERE JOB_ID = ?  AND JOB_STAT in ('X','E','I','P','C')  ORDER BY TO_NUMBER(QUEUE_ID)" : "SELECT LOAD_DATE as DateTime, TRAN_ID__REF as Transaction_Id,(CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END) as Message  FROM BATCHLOAD  WHERE BATCH_ID = ?  AND LOAD_STAT in ('N','E','Y')  ORDER BY TO_NUMBER(TRAN_SL)";
                if (conn == null) {
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    connDriver = null;
                    localConn = true;
                }
                pstmt = conn.prepareStatement(getErrorData);
                pstmt.setString(1, batchId);
                SimpleDateFormat sdfdate = new SimpleDateFormat("MM/dd/yyy hh:mm a");
                boolean totalRec = false;
                boolean transl = false;
                boolean processed = false;
                boolean successRec = false;
                boolean errorRec = false;
                boolean unProcessed = false;
                String objName = "";
                String loadStatus = "";
                String tranIdRef = "";
                String errorMsg = "";
                String winName = "";
                String dataFileName = "";
                String loadDate = "";
                int srNo = 0;
                rs = pstmt.executeQuery();
                JSONObject JsonData = new JSONObject();
                JSONArray tempJson1 = new JSONArray();
                ResultSetMetaData metaData = rs.getMetaData();
                int count = metaData.getColumnCount();
                tempJson1.put((Object)"Sr.No");
                JSONArray cssJson = new JSONArray();
                cssJson.put((Object)"numberClass");
                int i = 1;
                while (i <= count) {
                    String columnName = metaData.getColumnLabel(i);
                    BaseLogger.log("3", userInfo, null, "column names are[" + columnName + "]");
                    columnName = columnName.replace("_", " ");
                    String camelColumnName = this.camelCase(columnName.toLowerCase());
                    BaseLogger.log("3", userInfo, null, "Camel case[" + camelColumnName + "]");
                    tempJson1.put((Object)camelColumnName);
                    if (camelColumnName.equalsIgnoreCase("Transaction Id")) {
                        cssJson.put((Object)"numberClass");
                    } else if (camelColumnName.equalsIgnoreCase("DateTime")) {
                        cssJson.put((Object)"dateClass");
                    } else {
                        cssJson.put((Object)"textClass");
                    }
                    ++i;
                }
                JsonData.put("cols", (Object)tempJson1);
                JsonData.put("colStyle", (Object)cssJson);
                if (rs.next()) {
                    JSONArray tempJson = new JSONArray();
                    do {
                        loadDate = rs.getTimestamp("DateTime") != null ? sdfdate.format(rs.getTimestamp("DateTime")) : "";
                        BaseLogger.log("3", userInfo, null, "2161 DateTime - [" + loadDate + "]");
                        tranIdRef = rs.getString("Transaction_Id") != null ? rs.getString("Transaction_Id") : "";
                        errorMsg = rs.getString("Message");
                        BaseLogger.log("3", userInfo, null, "Sr.no : [" + ++srNo + "], tranIdRef - [" + tranIdRef + "],errorMsg - [" + errorMsg + "]");
                        JSONArray tempJson2 = new JSONArray();
                        tempJson2.put((Object)("" + srNo));
                        tempJson2.put((Object)loadDate);
                        tempJson2.put((Object)tranIdRef);
                        tempJson2.put((Object)errorMsg);
                        tempJson.put((Object)tempJson2);
                    } while (rs.next());
                    JsonData.put("rows", (Object)tempJson);
                }
                retResult = JsonData.toString();
                BaseLogger.log("3", userInfo, null, "retResult ---[" + retResult + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception on getUploadStatusDataArray----[" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (localConn && conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (localConn && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return retResult;
    }

    String camelCase(String str) {
        StringBuilder builder = new StringBuilder(str);
        boolean isLastSpace = true;
        int i = 0;
        while (i < builder.length()) {
            char ch = builder.charAt(i);
            if (isLastSpace && ch >= 'a' && ch <= 'z') {
                builder.setCharAt(i, (char)(ch + -32));
                isLastSpace = false;
            } else {
                isLastSpace = ch == ' ';
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public String getAllUploadStatusData(UserInfoBean userInfo, String loadDate) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String retResult = "";
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String transDB = userInfo.getTransDB();
                String getErrorData = " SELECT WIN_NAME, BATCH_ID,  COUNT(BATCH_ID) AS TOTAL_CNT,  SUM(CASE WHEN LOAD_STAT = 'Y' THEN 1 ELSE 0 END) AS SUCC_CNT,  SUM(CASE WHEN LOAD_STAT = 'E' THEN 1 ELSE 0 END) AS ERR_CNT,  SUM(CASE WHEN LOAD_STAT = 'N' THEN 1 ELSE 0 END) AS PEND_CNT  FROM BATCHLOAD  WHERE LOAD_STAT IN ('N','E','Y')  AND LOAD_DATE > ? AND LOAD_DATE < ?  AND CHG_USER = ?  GROUP BY WIN_NAME, BATCH_ID  ORDER BY WIN_NAME, BATCH_ID DESC";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                connDriver = null;
                pstmt = conn.prepareStatement(getErrorData);
                SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
                Date date = sdf.parse(loadDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, 1);
                Date nextDay = calendar.getTime();
                String currDate = sdf.format(date);
                currDate = genericUtility.getValidDateString(currDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
                String nextDate = sdf.format(nextDay);
                nextDate = genericUtility.getValidDateString(nextDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
                BaseLogger.log("3", userInfo, null, "currDate : [" + currDate + "], nextDate : [" + nextDate + "]");
                pstmt.setString(1, currDate);
                pstmt.setString(2, nextDate);
                pstmt.setString(3, userInfo.getLoginCode());
                int totalRec = 0;
                int processed = 0;
                int successRec = 0;
                int errorRec = 0;
                int unProcessed = 0;
                String objName = "";
                String loadStatus = "";
                String batchId = "";
                rs = pstmt.executeQuery();
                JSONArray resultJson = new JSONArray();
                if (rs.next()) {
                    do {
                        batchId = rs.getString("BATCH_ID");
                        objName = rs.getString("WIN_NAME");
                        objName = objName.substring(2);
                        totalRec = rs.getInt("TOTAL_CNT");
                        successRec = rs.getInt("SUCC_CNT");
                        errorRec = rs.getInt("ERR_CNT");
                        unProcessed = rs.getInt("PEND_CNT");
                        processed = successRec + errorRec;
                        float percentage = processed * 100 / totalRec;
                        BaseLogger.log("3", userInfo, null, "batchId : [" + batchId + "], successRec - [" + successRec + "], errorRec - [" + errorRec + "], unProcessed - [" + unProcessed + "], processed - [" + processed + "]");
                        JSONObject tempJson = new JSONObject();
                        tempJson.put("batchId", (Object)batchId);
                        tempJson.put("objName", (Object)objName);
                        tempJson.put("totalRec", (Object)("" + totalRec));
                        tempJson.put("successRec", (Object)("" + successRec));
                        tempJson.put("errorRec", (Object)("" + errorRec));
                        tempJson.put("unProcessed", (Object)("" + unProcessed));
                        tempJson.put("processed", (Object)("" + processed));
                        tempJson.put("progress", (Object)(String.valueOf(processed) + " / " + totalRec));
                        tempJson.put("percentage", (Object)("" + percentage));
                        tempJson.put("loadStatus", (Object)loadStatus);
                        resultJson.put((Object)tempJson);
                    } while (rs.next());
                }
                retResult = resultJson.toString();
                BaseLogger.log("3", userInfo, null, "retResult ---[" + retResult + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception on getallUploadStatusData----[" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return retResult;
    }

    public String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    @Override
    public String getDataFileName(String batchId, UserInfoBean userInfo) {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String downloadFile = "";
        try {
            try {
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                String fileName = " select data_file_name from BATCHLOAD where batch_id = ?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(fileName);
                pstmt.setString(1, batchId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    downloadFile = this.checkNull(rs.getString(1));
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception on getUploadStatusData----[" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return downloadFile;
    }

    private String addDocument(String refId, String objName, String tempName, String fileName, byte[] byteArray, String filePath, UserInfoBean userInfo) throws Exception {
        String retString = null;
        try {
            String refSer = "";
            if (this.checkNull(objName).length() > 0) {
                DBAccessEJB dbAccess = new DBAccessEJB();
                refSer = dbAccess.getRefSer(null, "obj_file_template", userInfo);
                dbAccess = null;
            }
            String user = userInfo.getLoginCode();
            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            StringBuffer retXMLStrBuff = new StringBuffer();
            retXMLStrBuff.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
            retXMLStrBuff.append("<DocumentRoot>");
            retXMLStrBuff.append("<description>Datawindow Root</description>");
            retXMLStrBuff.append("<group0>");
            retXMLStrBuff.append("<description>Group0 description</description>");
            retXMLStrBuff.append("<Header0>");
            retXMLStrBuff.append("<description>Header0 members</description>");
            retXMLStrBuff.append("<header>");
            retXMLStrBuff.append("<ref_id><![CDATA[" + refId + "]]></ref_id>");
            retXMLStrBuff.append("<ref_col><![CDATA[]]></ref_col>");
            retXMLStrBuff.append("<obj_name><![CDATA[" + objName + "]]></obj_name>");
            retXMLStrBuff.append("<ref_ser><![CDATA[" + refSer + "]]></ref_ser>");
            retXMLStrBuff.append("<doc_name><![CDATA[" + fileName + "]]></doc_name>");
            retXMLStrBuff.append("<doc_type><![CDATA[" + fileType + "]]></doc_type>");
            retXMLStrBuff.append("<document_type><![CDATA[]]></document_type>");
            retXMLStrBuff.append("<file_type><![CDATA[]]></file_type>");
            retXMLStrBuff.append("<created_by><![CDATA[" + user + "]]></created_by>");
            retXMLStrBuff.append("</header>");
            retXMLStrBuff.append("</Header0>");
            retXMLStrBuff.append("</group0>");
            retXMLStrBuff.append("</DocumentRoot>");
            DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
            retString = docHandler.addDocument(retXMLStrBuff.toString(), byteArray, null, userInfo);
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            throw e;
        }
        return retString;
    }

    private InitialContext getInitialContext() {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ctx;
    }

    private String getDocumentId(String documentStr) throws ITMException {
        Document dom;
        NodeList nodeList;
        Node node;
        NodeList childList;
        String docId = "";
        if (this.checkNull(documentStr).length() > 0 && (childList = (node = (nodeList = (dom = new E12GenericUtility().parseString(documentStr)).getElementsByTagName("Document")).item(0)).getChildNodes()) != null) {
            int i = 0;
            while (i < childList.getLength()) {
                String childNodeName;
                Node childNode = childList.item(i);
                if (childNode != null && this.checkNull(childNodeName = childNode.getNodeName()).length() > 0 && childNodeName.equalsIgnoreCase("ID")) {
                    docId = childNode.getAttributes().getNamedItem("Document_Id").getNodeValue();
                }
                ++i;
            }
        }
        BaseLogger.log("2", null, null, "docId - [" + docId + "]");
        return docId;
    }

    private String appendProfileIdQueryCond(String profileId) {
        String query = "";
        if (profileId != null) {
            String[] profile;
            query = "AND (";
            String[] stringArray = profile = profileId.split(",");
            int n = profile.length;
            int n2 = 0;
            while (n2 < n) {
                String pro = stringArray[n2];
                query = String.valueOf(query) + " TEMP.SCOPE_VALUE LIKE '%" + pro.trim() + "%' " + "OR ";
                ++n2;
            }
            query = query.substring(0, query.lastIndexOf("OR"));
            query = String.valueOf(query) + ")";
            BaseLogger.log("3", null, null, "In the Query Method===>" + query);
        }
        return query;
    }

    @Override
    public boolean checkExistingTempName(String objName, String tempName, UserInfoBean userInfo) {
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            ConnDriver connDriver = null;
            connDriver = new ConnDriver();
            String transDB = this.checkNull(userInfo.getTransDB());
            if (transDB.trim().length() > 0) {
                conn = connDriver.getConnectDB(transDB);
            }
            connDriver = null;
            String getTempCont = "SELECT COUNT(*) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME = ? AND OBJ_NAME = ?";
            BaseLogger.log("3", userInfo, null, " getTempCont===> oooooo --->[" + getTempCont + "]");
            pstmt = conn.prepareStatement(getTempCont);
            pstmt.setString(1, tempName);
            pstmt.setString(2, objName);
            rs = pstmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (count > 0) {
                return true;
            }
            try {
                rs.close();
                pstmt.close();
                conn.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "In the Exception Catch Block==> [" + e.getMessage() + "]");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public String getDocId(String batchId, String refSer, UserInfoBean userInfo) {
        String responseStr = "";
        String docId = "";
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                String transDB = this.checkNull(userInfo.getTransDB());
                if (transDB.trim().length() > 0) {
                    conn = connDriver.getConnectDB(transDB);
                }
                connDriver = null;
                String sql = "SELECT DOC_ID FROM DOC_TRANSACTION_LINK WHERE REF_ID = ? AND REF_SER = ?";
                BaseLogger.log("3", userInfo, null, " getTempCont : [" + sql + "]");
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, batchId);
                pstmt.setString(2, refSer);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    responseStr = docId = rs.getString("DOC_ID");
                    BaseLogger.log("3", userInfo, null, "getDocId response : [" + responseStr + "]");
                }
                rs.close();
                pstmt.close();
                conn.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, " getDocId Exception : [" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return responseStr;
    }

    @Override
    public String getDocIdNrefId(String objName, String tempName, UserInfoBean userInfo) {
        String responseStr = "";
        String docId = "";
        String refId = "";
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                String transDB = this.checkNull(userInfo.getTransDB());
                if (transDB.trim().length() > 0) {
                    conn = connDriver.getConnectDB(transDB);
                }
                connDriver = null;
                String sql = "SELECT DOC_ID,TEMPLATE_ID FROM OBJ_FILE_TEMPLATE WHERE OBJ_NAME = ? AND TMP_NAME = ?";
                BaseLogger.log("3", userInfo, null, " getDocIdNrefId sql : [" + sql + "]");
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, objName);
                pstmt.setString(2, tempName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    docId = rs.getString("DOC_ID");
                    refId = rs.getString("TEMPLATE_ID");
                    responseStr = String.valueOf(refId) + "&" + docId;
                    BaseLogger.log("3", userInfo, null, "getDocIdNrefId response : [" + responseStr + "]");
                }
                rs.close();
                pstmt.close();
                conn.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, " getDocIdNrefId Exception : [" + e.getMessage() + "]");
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return responseStr;
    }

    public String deleteTemplate(String tempName, String objName, UserInfoBean userInfo) {
        String updatedTempName = String.valueOf(tempName) + "_delete";
        BaseLogger.log("3", null, null, "updatedTempName :: [" + updatedTempName + "]");
        String tempStatus = "N";
        String resStr = "";
        int updateCnt = 0;
        Connection conn = null;
        Statement pstmt = null;
        boolean isError = false;
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                String transDB = this.checkNull(userInfo.getTransDB());
                if (transDB.length() > 0) {
                    conn = connDriver.getConnectDB(transDB);
                }
                connDriver = null;
                String updateSql = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_NAME = ?, ACTIVE = ?, CHG_DATE = ? where TEMPLATE_NAME = ? and OBJ_NAME = ?";
                BaseLogger.log("3", null, null, " deactivteTemplate updateSql : [" + updateSql + "]");
                pstmt = conn.prepareStatement(updateSql);
                pstmt.setString(1, updatedTempName);
                pstmt.setString(2, tempStatus);
                pstmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(4, tempName);
                pstmt.setString(5, objName);
                updateCnt = pstmt.executeUpdate();
                pstmt.close();
                pstmt = null;
                BaseLogger.log("3", null, null, "OBJ_FILE_TEMPLATE : updateCnt : [" + updateCnt + "]");
                if (updateCnt == 1) {
                    resStr = "Success";
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, " deactivteTemplate Exception : [" + e.getMessage() + "]");
                isError = true;
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        if (!isError) {
                            conn.commit();
                        } else {
                            conn.rollback();
                        }
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    if (!isError) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return resStr;
    }

    public String getUserRightInfo(String objName, String loginCode, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver mConnDriver = null;
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        String mQuery = null;
        String profileId = null;
        String strRights = "";
        String transDB = null;
        try {
            try {
                transDB = userInfo.getTransDB();
                mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                profileId = E12GenericUtility.checkNull(userInfo.getProfileId());
                mQuery = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND OBJ_NAME ='" + objName + "'";
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                while (mRs.next()) {
                    strRights = String.valueOf(strRights) + E12GenericUtility.checkNull(mRs.getString("RIGHTS"));
                }
                BaseLogger.log("3", null, null, "getUserRightInfo strRights :[" + strRights + "]");
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
                if (mRs != null) {
                    mRs.close();
                    mRs = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "getUserRightInfo Exception :[" + e.getMessage() + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mRs != null) {
                    mRs.close();
                    mRs = null;
                }
                if (mStmt != null) {
                    mStmt.close();
                    mStmt = null;
                }
                if (mConnection != null) {
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return strRights;
    }

    public String updateBatchloadStatus(String batchId, int tranSl, String status, UserInfoBean userInfo, Connection conn) throws ITMException {
        String retString = "";
        Statement psUpdateBl = null;
        boolean isLocalConn = false;
        try {
            try {
                if (conn == null) {
                    ConnDriver mConnDriver = new ConnDriver();
                    conn = mConnDriver.getConnectDB(userInfo.getTransDB());
                    mConnDriver = null;
                    isLocalConn = true;
                }
                String update = "UPDATE BATCHLOAD SET LOAD_STAT = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? WHERE BATCH_ID = ? AND TRAN_SL = ?";
                psUpdateBl = conn.prepareStatement(update);
                psUpdateBl.setString(1, status);
                psUpdateBl.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                psUpdateBl.setString(3, userInfo.getLoginCode());
                psUpdateBl.setString(4, userInfo.getRemoteHost());
                psUpdateBl.setString(5, batchId);
                psUpdateBl.setInt(6, tranSl);
                int updateCnt = psUpdateBl.executeUpdate();
                String message = "No record updated";
                if (updateCnt > 0) {
                    message = String.valueOf(updateCnt) + " record updated";
                }
                retString = "<Root><Detail><message><![CDATA[" + message + "]]</message></Detail></Root>";
                psUpdateBl.close();
                psUpdateBl = null;
                BaseLogger.log("3", null, null, "BATCHLOAD : updateCnt :: [" + updateCnt + "]");
            }
            catch (SQLException ex) {
                BaseLogger.log("0", null, null, "SQLException : updateBatchloadStatus :: [" + ex.getMessage() + "]");
                ex.printStackTrace();
                throw new ITMException(ex);
            }
            catch (Exception ex) {
                BaseLogger.log("0", null, null, "Exception : updateBatchloadStatus :: [" + ex.getMessage() + "]");
                ex.printStackTrace();
                throw new ITMException(ex);
            }
        }
        finally {
            try {
                if (psUpdateBl != null) {
                    psUpdateBl.close();
                    psUpdateBl = null;
                }
                if (conn != null && isLocalConn) {
                    conn.commit();
                    conn = null;
                }
            }
            catch (SQLException sqlex) {
                sqlex.printStackTrace();
            }
        }
        return retString;
    }

    public boolean checkDailyUploadLimitExcced(UserInfoBean userInfo) throws ITMException {
        boolean dailyUploadLimitExceed = false;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                int dailyUploadLimit = 0;
                String uploadLimitSQL = "SELECT DAILY_UPLOAD_LIMIT FROM ENTERPRISE WHERE ENTERPRISE = ?";
                preparedStatement = conn.prepareStatement(uploadLimitSQL);
                preparedStatement.setString(1, userInfo.getEnterprise());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    dailyUploadLimit = resultSet.getInt("DAILY_UPLOAD_LIMIT");
                }
                BaseLogger.log("3", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() DAILY_UPLOAD_LIMIT against enterprise 3264:::[" + userInfo.getEnterprise() + "] " + ": [" + dailyUploadLimit + "]");
                preparedStatement.close();
                preparedStatement = null;
                resultSet.close();
                resultSet = null;
                int batchLoadCount = 0;
                String bathlodCountSQL = "SELECT count(*) as count FROM BATCHLOAD B, USERS U WHERE B.CHG_USER = U.CODE AND U.ENTERPRISE = ? AND LOAD_STAT = 'Y'";
                String sqlWhere1 = "";
                String dbName = "";
                E12GenericUtility genericUtility = new E12GenericUtility();
                dbName = genericUtility.getDbName(conn);
                sqlWhere1 = "db2".equalsIgnoreCase(dbName) ? " AND DATE(B.CHG_DATE) = CURRENT_DATE" : ("mysql".equalsIgnoreCase(dbName) ? " AND DATE(B.CHG_DATE) = CURRENT_DATE" : ("pgsql".equalsIgnoreCase(dbName) ? " AND DATE(B.CHG_DATE) = CURRENT_DATE" : ("mssql".equalsIgnoreCase(dbName) ? " AND CONVERT(DATE,B.CHG_DATE) = CONVERT(DATE, GETDATE())" : " AND TRUNC(B.CHG_DATE) = TRUNC(SYSDATE)")));
                bathlodCountSQL = String.valueOf(bathlodCountSQL) + sqlWhere1;
                preparedStatement = conn.prepareStatement(bathlodCountSQL);
                preparedStatement.setString(1, userInfo.getEnterprise());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    batchLoadCount = resultSet.getInt("count");
                }
                BaseLogger.log("3", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() batchLoadCount 3506::::: [" + batchLoadCount + "]");
                preparedStatement.close();
                preparedStatement = null;
                resultSet.close();
                resultSet = null;
                if (dailyUploadLimit != 0 && batchLoadCount >= dailyUploadLimit) {
                    dailyUploadLimitExceed = true;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                        preparedStatement = null;
                    }
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() Exception in finally : [" + E12GenericUtility.getStackTrace(e2) + "]");
            }
        }
        BaseLogger.log("2", userInfo, null, "UploadFileEJB.checkDailyUploadLimitExcced() DAILY_UPLOAD_LIMIT exceed 3550: [" + dailyUploadLimitExceed + "]");
        return dailyUploadLimitExceed;
    }

    public boolean checkMonthlyUploadLimitExcced(UserInfoBean userInfo) throws ITMException {
        boolean monthlyUploadLimitExceed = false;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                int monthlyUploadLimit = 0;
                String uploadLimitSQL = "SELECT MONTHLY_UPLOAD_LIMIT FROM ENTERPRISE WHERE ENTERPRISE = ?";
                preparedStatement = conn.prepareStatement(uploadLimitSQL);
                preparedStatement.setString(1, userInfo.getEnterprise());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    monthlyUploadLimit = resultSet.getInt("MONTHLY_UPLOAD_LIMIT");
                }
                BaseLogger.log("3", userInfo, null, "UploadFileEJB.checkMonthlyUploadLimitExcced() MONTHLY_UPLOAD_LIMIT against enterprise [" + userInfo.getEnterprise() + "] " + ": [" + monthlyUploadLimit + "]");
                preparedStatement.close();
                preparedStatement = null;
                resultSet.close();
                resultSet = null;
                int batchLoadCount = 0;
                String bathlodCountSQL = "SELECT count(*) as count FROM BATCHLOAD B, USERS U WHERE B.CHG_USER = U.CODE AND U.ENTERPRISE = ? AND LOAD_STAT = 'Y'";
                String sqlWhere1 = "";
                String dbName = "";
                E12GenericUtility genericUtility = new E12GenericUtility();
                dbName = genericUtility.getDbName(conn);
                sqlWhere1 = "db2".equalsIgnoreCase(dbName) ? " AND B.CHG_DATE BETWEEN DATE(TRUNC(CURRENT_DATE, 'MONTH')) AND LAST_DAY(CURRENT_DATE)" : ("mysql".equalsIgnoreCase(dbName) ? " AND B.CHG_DATE BETWEEN DATE_FORMAT(NOW(), '%Y-%m-01') AND LAST_DAY(NOW())" : ("pgsql".equalsIgnoreCase(dbName) ? " AND B.CHG_DATE BETWEEN date_trunc('month', CURRENT_DATE) AND (date_trunc('month', CURRENT_DATE) + INTERVAL '1 month - 1 day')" : ("mssql".equalsIgnoreCase(dbName) ? " AND B.CHG_DATE BETWEEN CAST(DATEFROMPARTS(YEAR(GETDATE()), MONTH(GETDATE()), 1) AS DATE) AND EOMONTH(GETDATE())" : " AND B.CHG_DATE BETWEEN TRUNC(SYSDATE, 'MM') AND LAST_DAY(SYSDATE)")));
                bathlodCountSQL = String.valueOf(bathlodCountSQL) + sqlWhere1;
                preparedStatement = conn.prepareStatement(bathlodCountSQL);
                preparedStatement.setString(1, userInfo.getEnterprise());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    batchLoadCount = resultSet.getInt("count");
                }
                BaseLogger.log("3", userInfo, null, "UploadFileEJB.checkMonthlyUploadLimitExcced() batchLoadCount : [" + batchLoadCount + "]");
                preparedStatement.close();
                preparedStatement = null;
                resultSet.close();
                resultSet = null;
                if (monthlyUploadLimit != 0 && batchLoadCount >= monthlyUploadLimit) {
                    monthlyUploadLimitExceed = true;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "UploadFileEJB.checkMonthlyUploadLimitExcced() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                        preparedStatement = null;
                    }
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
            }
            catch (Exception e2) {
                BaseLogger.log("0", userInfo, null, "UploadFileEJB.checkMonthlyUploadLimitExcced() Exception in finally : [" + E12GenericUtility.getStackTrace(e2) + "]");
            }
        }
        BaseLogger.log("2", userInfo, null, "UploadFileEJB.checkMonthlyUploadLimitExcced() MONTHLY_UPLOAD_LIMIT exceed : [" + monthlyUploadLimitExceed + "]");
        return monthlyUploadLimitExceed;
    }
}

