/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import ibase.bi.ejb.session.TableInfoBean;
import ibase.bi.utility.BIException;
import ibase.utility.CommonConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLExplorer
extends DefaultHandler {
    HashMap nameMappings = null;
    HashMap physicalMapping = null;
    HashMap javaTypeMappings = null;
    HashMap expressionTypeMappings = null;
    HashMap displayMappings = null;
    HashMap disPatternMappings = null;
    HashMap dbPatternMappings = null;
    HashMap dbTableMappings = null;
    TreeMap joinOrder = null;
    String dbName = "";
    String joinOrderStr = "";
    String pKeyStr = "";
    String keyColumnStr = "";
    String displayNameStr = "";
    String logicalName;
    String dbTableName;
    String dataType;
    boolean readForJoinOrder = false;
    int index = 0;
    HashMap joinInfo = null;
    String tableName = null;
    String viaTableName = null;
    String refTable = null;
    String isMainTable = null;
    String pKeyId = null;
    String fKeyId = null;
    String joinType = null;
    ArrayList _pKeys = null;
    ArrayList _fKeys = null;
    boolean readForDBName = false;
    boolean readForDriver = false;
    boolean readForKeyColumn = false;
    boolean readForPrimaryKey = false;
    boolean readForDisplayName = false;
    String driverInfo = null;

    public XMLExplorer() throws Exception {
        try {
            this.nameMappings = new HashMap();
            this.physicalMapping = new HashMap();
            this.javaTypeMappings = new HashMap();
            this.expressionTypeMappings = new HashMap();
            this.displayMappings = new HashMap();
            this.disPatternMappings = new HashMap();
            this.dbPatternMappings = new HashMap();
            this.dbTableMappings = new HashMap();
            this.joinOrder = new TreeMap();
            this.joinInfo = new HashMap();
            this._pKeys = new ArrayList();
            this._fKeys = new ArrayList();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void parseXML(String baName, String userID) throws Exception {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            String path = String.valueOf(CommonConstants.BI_RESOURCE_PATH) + File.separator + "common" + File.separator + "xml" + File.separator + baName + ".xml";
            saxParser.parse(path, (DefaultHandler)this);
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (qName.equalsIgnoreCase("DATABASE_NAME")) {
                this.readForDBName = true;
            } else if (qName.equalsIgnoreCase("DRIVER")) {
                this.readForDriver = true;
            } else if (qName.equalsIgnoreCase("COLUMN")) {
                this.logicalName = atts.getValue("NAME");
                this.dbTableName = atts.getValue("DBTABLE");
                this.dataType = atts.getValue("JAVATYPE");
                if (this.dbTableName != null && this.dbTableName.equals("")) {
                    this.nameMappings.put(this.logicalName, String.valueOf(this.dbTableName) + atts.getValue("DBNAME"));
                    this.physicalMapping.put(String.valueOf(this.dbTableName) + atts.getValue("DBNAME"), this.logicalName);
                    this.dbTableMappings.put(this.logicalName, this.dbTableName);
                } else {
                    this.nameMappings.put(this.logicalName, String.valueOf(this.dbTableName) + "." + atts.getValue("DBNAME"));
                    this.physicalMapping.put(String.valueOf(this.dbTableName) + "." + atts.getValue("DBNAME"), this.logicalName);
                    this.dbTableMappings.put(this.logicalName, this.dbTableName);
                }
                this.javaTypeMappings.put(this.logicalName, atts.getValue("JAVATYPE"));
                this.disPatternMappings.put(this.logicalName, atts.getValue("PATTERN"));
                if (atts.getValue("DISPLAYPATTERN") != null) {
                    this.disPatternMappings.put(this.logicalName, atts.getValue("DISPLAYPATTERN"));
                } else {
                    String displayPattern = null;
                    this.dataType = this.dataType.toUpperCase();
                    displayPattern = this.dataType.indexOf("DATE") != -1 ? CommonConstants.DISPLAY_DATE_PATTERN : (this.dataType.indexOf("TIMESTAMP") != -1 ? CommonConstants.DISPLAY_TIMESTAMP_PATTERN : (this.dataType.indexOf("NUMBER") != -1 || this.dataType.indexOf("INTEGER") != -1 || this.dataType.indexOf("FLOAT") != -1 || this.dataType.indexOf("DOUBLE") != -1 || this.dataType.indexOf("DECIMAL") != -1 ? CommonConstants.DISPLAY_NUMBER_PATTERN : CommonConstants.DISPLAY_ALPHANUM_PATTERN));
                    if (displayPattern != null) {
                        this.disPatternMappings.put(this.logicalName, displayPattern);
                    }
                }
                if (atts.getValue("DBPATTERN") != null) {
                    this.dbPatternMappings.put(this.logicalName, atts.getValue("DBPATTERN"));
                } else {
                    String dbPattern = null;
                    this.dataType = this.dataType.toUpperCase();
                    dbPattern = this.dataType.indexOf("DATE") != -1 ? CommonConstants.DB_DATE_PATTERN : (this.dataType.indexOf("TIMESTAMP") != -1 ? CommonConstants.DB_TIMESTAMP_PATTERN : (this.dataType.indexOf("NUMBER") != -1 || this.dataType.indexOf("INTEGER") != -1 || this.dataType.indexOf("FLOAT") != -1 || this.dataType.indexOf("DOUBLE") != -1 || this.dataType.indexOf("DECIMAL") != -1 ? CommonConstants.DB_NUMBER_PATTERN : CommonConstants.DB_ALPHANUM_PATTERN));
                    if (dbPattern != null) {
                        this.dbPatternMappings.put(this.logicalName, dbPattern);
                    }
                }
                String expressionType = atts.getValue("EXPRESSIONTYPE");
                if (expressionType.equalsIgnoreCase("C")) {
                    this.expressionTypeMappings.put(String.valueOf(this.dbTableName) + "." + atts.getValue("DBNAME"), "C");
                } else {
                    this.expressionTypeMappings.put(String.valueOf(this.dbTableName) + "." + atts.getValue("DBNAME"), atts.getValue("DEFAULTFUNCTION"));
                }
                this.readForDisplayName = true;
            } else if (qName.equalsIgnoreCase("TABLE")) {
                this.index = Integer.parseInt(atts.getValue("ID"));
                this.readForJoinOrder = true;
            } else if (qName.equalsIgnoreCase("JOIN")) {
                this.tableName = atts.getValue("ID");
                this.viaTableName = atts.getValue("JOIN_VIA");
                this.isMainTable = atts.getValue("MAIN_TABLE");
            } else if (qName.equalsIgnoreCase("PRIMARY_KEY")) {
                this.pKeyId = atts.getValue("ID");
                this.readForPrimaryKey = true;
            } else if (qName.equalsIgnoreCase("FOREIGN_KEY")) {
                this.refTable = atts.getValue("TABLE");
                this.joinType = atts.getValue("KEY_TYPE");
            } else if (qName.equalsIgnoreCase("KEY_COLUMN")) {
                this.fKeyId = atts.getValue("ID");
                this.readForKeyColumn = true;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String tagContent = new String(ch, start, length);
            if (this.readForDBName) {
                this.dbName = String.valueOf(this.dbName) + tagContent;
            }
            if (this.readForDriver) {
                this.driverInfo = String.valueOf(this.driverInfo) + tagContent;
            }
            if (this.readForJoinOrder) {
                this.joinOrderStr = String.valueOf(this.joinOrderStr) + tagContent;
            }
            if (this.readForPrimaryKey) {
                this.pKeyStr = String.valueOf(this.pKeyStr) + tagContent;
            }
            if (this.readForKeyColumn) {
                this.keyColumnStr = String.valueOf(this.keyColumnStr) + tagContent;
            }
            if (this.readForDisplayName) {
                this.displayNameStr = String.valueOf(this.displayNameStr) + tagContent;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (qName.equalsIgnoreCase("DATABASE_NAME")) {
                this.readForDBName = false;
            } else if (qName.equalsIgnoreCase("DRIVER")) {
                this.readForDriver = false;
            } else if (qName.equalsIgnoreCase("COLUMN")) {
                this.displayMappings.put(this.logicalName, this.displayNameStr);
                this.displayNameStr = "";
                this.readForDisplayName = false;
            } else if (qName.equalsIgnoreCase("TABLE")) {
                this.fillJoinOrder(this.index, this.joinOrderStr.trim());
                this.joinOrderStr = "";
                this.readForJoinOrder = false;
            } else if (qName.equalsIgnoreCase("JOIN")) {
                this.fillJoinInfo(this.tableName, this._pKeys, this._fKeys, this.viaTableName);
                this._pKeys.clear();
                this._fKeys.clear();
            } else if (qName.equalsIgnoreCase("PRIMARY_KEY")) {
                this._pKeys.add(String.valueOf(this.pKeyId) + "#" + this.pKeyStr.trim());
                this.pKeyStr = "";
                this.readForPrimaryKey = false;
            } else if (qName.equalsIgnoreCase("KEY_COLUMN")) {
                this._fKeys.add(String.valueOf(this.fKeyId) + "#" + this.refTable + "#" + this.keyColumnStr.trim() + "#" + this.joinType);
                this.keyColumnStr = "";
                this.readForKeyColumn = false;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    private void fillJoinOrder(int index, String tableName) throws Exception {
        this.joinOrder.put(new Integer(index), tableName);
    }

    private void fillJoinInfo(String tableName, ArrayList pKeys, ArrayList fKeys, String viaTableName) throws Exception {
        TableInfoBean tib = new TableInfoBean();
        tib.setTableName(tableName);
        tib.setPrimaryKeys(pKeys);
        tib.setForeignKeys(fKeys);
        tib.setViaTableName(viaTableName);
        this.joinInfo.put(tableName, tib);
        tib = null;
    }

    @Override
    public void endDocument() {
    }

    protected void finalize() {
        this.nameMappings = null;
        this.physicalMapping = null;
        this.javaTypeMappings = null;
        this.expressionTypeMappings = null;
        this.displayMappings = null;
        this.joinOrder = null;
        this.joinInfo = null;
    }
}

