/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.bean;

import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.renderer.AreaRenderer;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.BarRenderer3D;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.StackedBarRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultValueDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.Range;
import org.jfree.data.ValueDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.util.TableOrder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class GraphBuilder
implements Serializable {
    public String draw(String data, String XMLParam, String qCount) throws Exception {
        try {
            XYSeriesCollection xyDataSet;
            PiePlot plot;
            PieDataset pieData;
            BarRenderer renderer;
            CategoryAxis axis;
            CategoryPlot plot2;
            boolean xLabel;
            String catLabel;
            double width = 750.0;
            double height = 480.0;
            String imageFile = null;
            String imageMap = "";
            String imgName = String.valueOf(System.currentTimeMillis()) + ".jpeg";
            JFreeChart chart = null;
            String type = null;
            String title = "CHART";
            String[] xDim = null;
            Object xDimDisplay = null;
            String[] yDim = null;
            Object sizeact = null;
            String bgtype = null;
            Object bgcolorck = null;
            Object bgcolorstr = null;
            String label = "on";
            String span1 = "";
            String span2 = "";
            String defaultcolor = "#FFFFFF";
            Color color1 = null;
            Color color2 = null;
            boolean bgcolor = false;
            int size = 0;
            String legendstr = "on";
            boolean legend = true;
            DefaultCategoryDataset dataSet = null;
            String xAxisLogicalName = "";
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(new ByteArrayInputStream(XMLParam.getBytes()));
            type = doc.getElementsByTagName("TYPE").item(0).getFirstChild().getNodeValue();
            size = Integer.parseInt(doc.getElementsByTagName("SIZE").item(0).getFirstChild().getNodeValue().trim());
            legendstr = doc.getElementsByTagName("LEGEND").item(0).getFirstChild().getNodeValue().trim();
            legend = legendstr.equals("on");
            span1 = doc.getElementsByTagName("SPAN1").item(0).getFirstChild().getNodeValue().trim();
            span2 = doc.getElementsByTagName("SPAN2").item(0).getFirstChild().getNodeValue().trim();
            color1 = Color.decode(span1);
            color2 = Color.decode(span2);
            bgtype = doc.getElementsByTagName("BGTYPE").item(0).getFirstChild().getNodeValue().trim();
            label = doc.getElementsByTagName("LABEL").item(0).getFirstChild().getNodeValue().trim();
            title = doc.getElementsByTagName("TITLE").item(0).getFirstChild().getNodeValue();
            if (title.equals(" ")) {
                title = "";
            }
            NodeList xList = doc.getElementsByTagName("X-AXIS");
            xDim = new String[xList.getLength()];
            int i = 0;
            while (i < xList.getLength()) {
                if (i == 0) {
                    xAxisLogicalName = xList.item(i).getFirstChild().getNodeValue();
                }
                xDim[i] = new String(xList.item(i).getAttributes().getNamedItem("displayname").getNodeValue());
                ++i;
            }
            NodeList yList = doc.getElementsByTagName("Y-AXIS");
            yDim = new String[yList.getLength()];
            int i2 = 0;
            while (i2 < yList.getLength()) {
                yDim[i2] = new String();
                yDim[i2] = yList.item(i2).getFirstChild().getNodeValue();
                ++i2;
            }
            if (label.equals("on")) {
                catLabel = xDim[0];
                xLabel = true;
            } else {
                catLabel = null;
                xLabel = false;
            }
            if (type.equalsIgnoreCase("verticalbar")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createBarChart((String)title, (String)catLabel, null, (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = chart.getCategoryPlot();
                axis = plot2.getDomainAxis();
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                axis.setTickLabelsVisible(xLabel);
                renderer = new BarRenderer();
                renderer.setItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator("GraphDrillDown.jsp", "qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot2.setRenderer((CategoryItemRenderer)renderer);
            } else if (type.equalsIgnoreCase("horizontalbar")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createBarChart((String)title, (String)catLabel, null, (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = chart.getCategoryPlot();
                axis = plot2.getDomainAxis();
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                axis.setTickLabelsVisible(xLabel);
                renderer = new BarRenderer();
                renderer.setItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator("GraphDrillDown.jsp", "qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot2.setRenderer((CategoryItemRenderer)renderer);
            } else if (type.equals("verticalbar3d")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createBarChart3D((String)title, (String)catLabel, (String)"", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = chart.getCategoryPlot();
                axis = plot2.getDomainAxis();
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                axis.setTickLabelsVisible(xLabel);
                renderer = new BarRenderer3D();
                renderer.setItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator("GraphDrillDown.jsp", "qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot2.setRenderer((CategoryItemRenderer)renderer);
            } else if (type.equals("verticalbarstacked")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createStackedBarChart((String)title, (String)catLabel, (String)"", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = chart.getCategoryPlot();
                axis = plot2.getDomainAxis();
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                axis.setTickLabelsVisible(xLabel);
                renderer = new StackedBarRenderer();
                renderer.setItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator("GraphDrillDown.jsp", "qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot2.setRenderer((CategoryItemRenderer)renderer);
            } else if (type.equals("horizontalbarstacked")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createStackedBarChart((String)title, (String)catLabel, (String)"", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = chart.getCategoryPlot();
                axis = plot2.getDomainAxis();
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                axis.setTickLabelsVisible(xLabel);
                renderer = new StackedBarRenderer();
                renderer.setItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator("GraphDrillDown.jsp", "qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot2.setRenderer((CategoryItemRenderer)renderer);
            } else if (type.equals("areachart")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createAreaChart((String)title, (String)catLabel, (String)"", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = chart.getCategoryPlot();
                axis = plot2.getDomainAxis();
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                axis.setTickLabelsVisible(xLabel);
                plot2.setForegroundAlpha(0.75f);
                renderer = new AreaRenderer();
                renderer.setItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator("GraphDrillDown.jsp", "qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot2.setRenderer((CategoryItemRenderer)renderer);
            } else if (type.equals("pienormal")) {
                dataSet = this.buildDataSet(data, XMLParam);
                pieData = DatasetUtilities.createPieDatasetForRow((CategoryDataset)dataSet, (int)0);
                chart = ChartFactory.createPieChart((String)title, (PieDataset)pieData, (boolean)legend, (boolean)true, (boolean)true);
                plot = (PiePlot)chart.getPlot();
                plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator("GraphDrillDown.jsp?qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieItemLabelGenerator());
            } else if (type.equals("pie3d")) {
                dataSet = this.buildDataSet(data, XMLParam);
                pieData = DatasetUtilities.createPieDatasetForRow((CategoryDataset)dataSet, (int)0);
                chart = ChartFactory.createPieChart3D((String)title, (PieDataset)pieData, (boolean)legend, (boolean)true, (boolean)true);
                plot = (PiePlot)chart.getPlot();
                plot.setForegroundAlpha(0.75f);
                plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator("GraphDrillDown.jsp?qCount=" + qCount + "&NotUsed", "DrillFrom=" + xAxisLogicalName + "&" + xAxisLogicalName));
                plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieItemLabelGenerator());
            } else if (type.equals("multiple")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createMultiplePieChart((String)title, (CategoryDataset)dataSet, (TableOrder)TableOrder.BY_ROW, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = (MultiplePiePlot)chart.getPlot();
                plot2.setForegroundAlpha(0.75f);
            } else if (type.equals("linechart")) {
                dataSet = this.buildDataSet(data, XMLParam);
                chart = ChartFactory.createLineChart((String)title, (String)catLabel, (String)"y-axis", (CategoryDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot2 = chart.getCategoryPlot();
                plot2.setForegroundAlpha(0.75f);
                axis = plot2.getDomainAxis();
                axis.setTickLabelsVisible(xLabel);
            } else if (type.equals("xyplot")) {
                xyDataSet = this.buildXYDataSet(data, XMLParam);
                chart = ChartFactory.createXYLineChart((String)title, (String)catLabel, (String)"", (XYDataset)xyDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot = chart.getXYPlot();
                plot.setForegroundAlpha(0.75f);
                ValueAxis axis2 = plot.getDomainAxis();
                axis2.setTickLabelsVisible(xLabel);
                axis2 = plot.getRangeAxis();
                axis2.setTickLabelsVisible(xLabel);
            } else if (type.equals("xyarea")) {
                xyDataSet = this.buildXYDataSet(data, XMLParam);
                chart = ChartFactory.createXYAreaChart((String)title, (String)catLabel, (String)"", (XYDataset)xyDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot = chart.getPlot();
                plot.setForegroundAlpha(0.75f);
            } else if (type.equals("timeseries")) {
                xyDataSet = this.buildXYDataSet(data, XMLParam);
                chart = ChartFactory.createTimeSeriesChart((String)title, (String)catLabel, (String)"", (XYDataset)xyDataSet, (boolean)legend, (boolean)true, (boolean)true);
                plot = chart.getPlot();
                plot.setForegroundAlpha(0.75f);
            } else if (type.equals("meterdail")) {
                MeterPlot meterPlot = (MeterPlot)this.buildValueDataSet(data, XMLParam);
                chart = new JFreeChart(title, new Font("Arial", 1, 15), (Plot)meterPlot, legend);
            } else if (type.equals("thermometer")) {
                ThermometerPlot thermoPlot = (ThermometerPlot)this.buildValueDataSet(data, XMLParam);
                chart = new JFreeChart(title, new Font("Arial", 1, 15), (Plot)thermoPlot, legend);
            } else if (type.equals("scatter")) {
                xyDataSet = this.buildXYDataSet(data, XMLParam);
                chart = ChartFactory.createScatterPlot((String)title, (String)catLabel, (String)"", (XYDataset)xyDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)true, (boolean)true);
                plot = chart.getPlot();
                plot.setForegroundAlpha(0.75f);
            }
            if (bgtype.equals("gradient")) {
                chart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, color1, 1000.0f, 0.0f, color2));
            } else {
                chart.setBackgroundPaint((Paint)color1);
            }
            String graphDirPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "bi" + File.separator + "resource" + File.separator + "common" + File.separator + "graph" + File.separator;
            File dir = new File(graphDirPath);
            BaseLogger.log("3", null, null, "graph folder exists  :" + dir.exists());
            if (!dir.exists()) {
                dir.mkdirs();
                BaseLogger.log("3", null, null, "graph folder created..." + dir.getAbsolutePath());
            }
            imageFile = String.valueOf(graphDirPath) + imgName;
            BaseLogger.log("3", null, null, "ImageFile" + imageFile);
            File img = new File(imageFile);
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            ChartUtilities.saveChartAsJPEG((File)img, (JFreeChart)chart, (int)((int)width * size / 100), (int)((int)height * size / 100), (ChartRenderingInfo)info);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));
            ChartUtilities.writeImageMap((PrintWriter)pw, (String)"insightmap", (ChartRenderingInfo)info);
            pw.flush();
            imageMap = baos.toString();
            return String.valueOf(imgName) + ':' + imageMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private DefaultCategoryDataset buildDataSet(String XML, String XMLParam) throws Exception {
        try {
            String value;
            NamedNodeMap atts;
            int i;
            String type = "";
            String[] xDim = null;
            String[] yDim = null;
            String[] yDisplay = null;
            String[] yyDisplay = null;
            DefaultCategoryDataset dataSet = null;
            BaseLogger.log("3", null, null, "XML FILE name buildDataSet = " + XML);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(new ByteArrayInputStream(XMLParam.getBytes()));
            type = doc.getElementsByTagName("TYPE").item(0).getFirstChild().getNodeValue();
            BaseLogger.log("3", null, null, type);
            NodeList xList = doc.getElementsByTagName("X-AXIS");
            xDim = new String[xList.getLength()];
            String title = "";
            int i2 = 0;
            while (i2 < xList.getLength()) {
                xDim[i2] = new String();
                xDim[i2] = xList.item(i2).getFirstChild().getNodeValue();
                title = String.valueOf(title) + xDim[i2];
                ++i2;
            }
            title = String.valueOf(title) + "V/S";
            NodeList yyList = doc.getElementsByTagName("YY-AXIS");
            NodeList yList = doc.getElementsByTagName("Y-AXIS");
            if (yyList != null && yyList.getLength() > 0) {
                yDisplay = new String[yyList.getLength()];
                String yString = yList.item(0).getFirstChild().getNodeValue();
                String yDStr = new String(yList.item(0).getAttributes().getNamedItem("displayname").getNodeValue());
                yDim = new String[yyList.getLength()];
                int i3 = 0;
                while (i3 < yyList.getLength()) {
                    yDim[i3] = new String();
                    yDim[i3] = String.valueOf(yyList.item(i3).getFirstChild().getNodeValue()) + "__" + yString;
                    BaseLogger.log("3", null, null, "yDim :" + yDim[i3]);
                    yDisplay[i3] = new String(String.valueOf(yDStr) + "  of   " + yyList.item(i3).getAttributes().getNamedItem("displayname").getNodeValue());
                    BaseLogger.log("3", null, null, "yDisplay :" + yDisplay[i3]);
                    ++i3;
                }
            } else {
                yDim = new String[yList.getLength()];
                yDisplay = new String[yList.getLength()];
                yyDisplay = new String[yyList.getLength()];
                int i4 = 0;
                while (i4 < yList.getLength()) {
                    yDim[i4] = new String();
                    yDim[i4] = yList.item(i4).getFirstChild().getNodeValue();
                    yDisplay[i4] = new String(yList.item(i4).getAttributes().getNamedItem("displayname").getNodeValue());
                    ++i4;
                }
            }
            DocumentBuilder dataParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dataDoc = dataParser.parse(XML);
            NodeList xlist = dataDoc.getElementsByTagName(xDim[0]);
            int size = xlist.getLength();
            Object[] xdata = null;
            ArrayList<String> arr = new ArrayList<String>();
            if (yyList != null && yyList.getLength() > 0) {
                BaseLogger.log("3", null, null, "YY list is not null size is " + size);
                if (size > 0) {
                    i = 0;
                    while (i < size) {
                        atts = xlist.item(i).getAttributes();
                        value = atts.getNamedItem("value").getNodeValue().trim();
                        String occurence = atts.getNamedItem("occurence").getNodeValue();
                        double occ = Double.parseDouble(occurence);
                        if (value.length() > 10) {
                            value = value.substring(0, 9);
                        } else if (value == "" || value == null) {
                            value = "Not Available";
                        }
                        arr.add(value);
                        int k = 1;
                        while ((double)k < occ) {
                            arr.add(value);
                            ++k;
                        }
                        ++i;
                    }
                }
                xdata = new Object[arr.size()];
                xdata = arr.toArray();
            } else {
                xdata = new Object[size];
                if (size > 0) {
                    i = 0;
                    while (i < size) {
                        atts = xlist.item(i).getAttributes();
                        value = atts.getNamedItem("value").getNodeValue().trim();
                        if (value == null || "".equals(value) || "0".equals(value)) {
                            value = "Not Available";
                        }
                        xdata[i] = new String(value);
                        ++i;
                    }
                }
            }
            Number[][] ydata = new Number[yDim.length][];
            String[][] sdata = new String[yDim.length][];
            int j = 0;
            while (j < yDim.length) {
                NodeList list = dataDoc.getElementsByTagName(yDim[j]);
                size = list.getLength();
                BaseLogger.log("3", null, null, "size:" + size);
                ydata[j] = new Double[size];
                sdata[j] = new String[size];
                if (size > 0) {
                    boolean in = false;
                    int i5 = 0;
                    while (i5 < size) {
                        String value2 = list.item(i5).getFirstChild().getNodeValue();
                        String series = null;
                        if (yyList != null && yyList.getLength() > 0) {
                            series = list.item(i5).getAttributes().getNamedItem("value").getNodeValue();
                        }
                        BaseLogger.log("3", null, null, "value :" + value2 + ", series: " + series);
                        try {
                            double d = Double.parseDouble(value2);
                            ydata[j][i5] = new Double(d);
                            sdata[j][i5] = series;
                        }
                        catch (NumberFormatException ne) {
                            ydata[j][i5] = new Double(0.0);
                            sdata[j][i5] = null;
                            BaseLogger.log("0", null, null, ne);
                        }
                        ++i5;
                    }
                }
                ++j;
            }
            BaseLogger.log("3", null, null, "X data " + xdata);
            BaseLogger.log("3", null, null, "Y data " + ydata);
            BaseLogger.log("3", null, null, "Y display " + yDisplay);
            dataSet = new DefaultCategoryDataset();
            BaseLogger.log("3", null, null, "yDisplay length :" + yDisplay.length);
            int i6 = 0;
            while (i6 < yDisplay.length) {
                int j2 = 0;
                while (j2 < ydata[i6].length) {
                    if (yyList != null && yyList.getLength() > 0) {
                        dataSet.addValue(ydata[i6][j2].doubleValue(), (Comparable)((Object)sdata[i6][j2]), (Comparable)((Object)new String(xdata[j2].toString())));
                    } else {
                        dataSet.addValue(ydata[i6][j2].doubleValue(), (Comparable)((Object)new String(yDisplay[i6])), (Comparable)((Object)new String(xdata[j2].toString())));
                    }
                    ++j2;
                }
                ++i6;
            }
            return dataSet;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GraphBuilder :buildDataSet :==>");
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private XYSeriesCollection buildXYDataSet(String XML, String XMLParam) throws Exception {
        try {
            type = "";
            xDim = null;
            yDim = null;
            yDisplay = null;
            xDisplay = null;
            parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(new ByteArrayInputStream(XMLParam.getBytes()));
            type = doc.getElementsByTagName("TYPE").item(0).getFirstChild().getNodeValue();
            xList = doc.getElementsByTagName("X-AXIS");
            xDim = new String[xList.getLength()];
            xDisplay = new String[xList.getLength()];
            title = "";
            i = 0;
            while (i < xList.getLength()) {
                xDim[i] = new String();
                xDim[i] = xList.item(i).getFirstChild().getNodeValue();
                title = String.valueOf(title) + xDim[i];
                xDisplay[i] = new String(xList.item(i).getAttributes().getNamedItem("displayname").getNodeValue());
                ++i;
            }
            yList = doc.getElementsByTagName("Y-AXIS");
            yDim = new String[yList.getLength()];
            yDisplay = new String[yList.getLength()];
            i = 0;
            while (i < yList.getLength()) {
                yDim[i] = new String();
                yDim[i] = yList.item(i).getFirstChild().getNodeValue();
                title = String.valueOf(title) + yDim[i] + " ,";
                yDisplay[i] = new String(yList.item(i).getAttributes().getNamedItem("displayname").getNodeValue());
                ++i;
            }
            dataParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            dataDoc = dataParser.parse(XML);
            xlist = dataDoc.getElementsByTagName(xDim[0]);
            size = xlist.getLength();
            ysize = 0;
            BaseLogger.log("3", null, null, "xsize :" + size);
            xAxisValue = new Double[size];
            yAxisValue = new Double[2][size];
            data = new Object[yDim.length][size][2];
            i = 0;
            while (i < size) {
                block17: {
                    atts = xlist.item(i).getAttributes();
                    seriesdata = atts.getNamedItem("value").getNodeValue();
                    BaseLogger.log("3", null, null, "xyvalue :" + seriesdata);
                    xAxisValue[i] = new Double(seriesdata);
                    try {
                        if (seriesdata == null || seriesdata == "" || seriesdata.length() < 0) {
                            seriesdata = "0";
                        }
                        p = 0;
                        while (p < yDim.length) {
                            data[p][i][0] = new Double(seriesdata);
                            ++p;
                        }
                        break block17;
                    }
                    catch (NumberFormatException ne) {
                        p = 0;
                        ** while (p < yDim.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        temp = new Date(seriesdata);
                        data[p][i][0] = temp;
                        ++p;
                        continue;
                    }
                }
                ++i;
            }
            j = 0;
            while (j < yDim.length) {
                list = dataDoc.getElementsByTagName(yDim[j]);
                ysize = list.getLength();
                BaseLogger.log("3", null, null, "ysize=" + ysize);
                if (size > 0) {
                    k = 0;
                    while (k < ysize) {
                        value = list.item(k).getFirstChild().getNodeValue();
                        BaseLogger.log("3", null, null, "yvalue=" + value);
                        yAxisValue[j][k] = new Double(value);
                        d = 0.0;
                        try {
                            d = Double.parseDouble(value);
                        }
                        catch (NumberFormatException ne) {
                            d = 0.0;
                            BaseLogger.log("0", null, null, ne);
                        }
                        data[j][k][1] = new Double(d);
                        ++k;
                    }
                }
                BaseLogger.log("3", null, null, "YDATA :" + ysize);
                ++j;
            }
            defaultXYDataset = null;
            BaseLogger.log("3", null, null, "\n\n\n yDisplay :" + yDisplay.length);
            BaseLogger.log("3", null, null, "xList : " + xList.getLength());
            defaultXYDataset = new XYSeriesCollection();
            j = 0;
            while (j < yDisplay.length) {
                series = new XYSeries(yDisplay[j]);
                i = 0;
                while (i < ysize) {
                    series.add(xAxisValue[i].doubleValue(), yAxisValue[j][i].doubleValue());
                    ++i;
                }
                defaultXYDataset.addSeries(series);
                ++j;
            }
            return defaultXYDataset;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GraphBuilder :buildXYDataSet :==>");
            e.printStackTrace();
            throw e;
        }
    }

    private Plot buildValueDataSet(String XML, String XMLParam) throws Exception {
        try {
            String type = "";
            String[] xDim = null;
            String[] yDim = null;
            String[] yDisplay = null;
            String[] xDisplay = null;
            String seriesdata = null;
            String seriesoccurence = null;
            Double minnormal = null;
            Double maxnormal = null;
            Double mincritical = null;
            Double maxcritical = null;
            Double minwarning = null;
            Double maxwarning = null;
            Double minrange = null;
            Double maxrange = null;
            Double result = null;
            Double minnormalm = null;
            Double maxnormalm = null;
            Double mincriticalm = null;
            Double maxcriticalm = null;
            Double minwarningm = null;
            Double maxwarningm = null;
            Double minrangem = null;
            Double maxrangem = null;
            MeterPlot meterPlot = null;
            ThermometerPlot thermoPlot = null;
            ThermometerPlot plot = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(new ByteArrayInputStream(XMLParam.getBytes()));
            type = doc.getElementsByTagName("TYPE").item(0).getFirstChild().getNodeValue();
            if (doc.getElementsByTagName("MINNORMAL").item(0) != null) {
                minnormal = new Double(doc.getElementsByTagName("MINNORMAL").item(0).getFirstChild().getNodeValue().trim());
                maxnormal = new Double(doc.getElementsByTagName("MAXNORMAL").item(0).getFirstChild().getNodeValue().trim());
                mincritical = new Double(doc.getElementsByTagName("MINCRITICAL").item(0).getFirstChild().getNodeValue().trim());
                maxcritical = new Double(doc.getElementsByTagName("MAXCRITICAL").item(0).getFirstChild().getNodeValue().trim());
                minwarning = new Double(doc.getElementsByTagName("MINWARNING").item(0).getFirstChild().getNodeValue().trim());
                maxwarning = new Double(doc.getElementsByTagName("MAXWARNING").item(0).getFirstChild().getNodeValue().trim());
                minrange = new Double(doc.getElementsByTagName("MINRANGE").item(0).getFirstChild().getNodeValue().trim());
                maxrange = new Double(doc.getElementsByTagName("MAXRANGE").item(0).getFirstChild().getNodeValue().trim());
            } else if (doc.getElementsByTagName("MINNORMALM").item(0) != null) {
                minnormalm = new Double(doc.getElementsByTagName("MINNORMALM").item(0).getFirstChild().getNodeValue().trim());
                maxnormalm = new Double(doc.getElementsByTagName("MAXNORMALM").item(0).getFirstChild().getNodeValue().trim());
                mincriticalm = new Double(doc.getElementsByTagName("MINCRITICALM").item(0).getFirstChild().getNodeValue().trim());
                maxcriticalm = new Double(doc.getElementsByTagName("MAXCRITICALM").item(0).getFirstChild().getNodeValue().trim());
                minwarningm = new Double(doc.getElementsByTagName("MINWARNINGM").item(0).getFirstChild().getNodeValue().trim());
                maxwarningm = new Double(doc.getElementsByTagName("MAXWARNINGM").item(0).getFirstChild().getNodeValue().trim());
                minrangem = new Double(doc.getElementsByTagName("MINRANGEM").item(0).getFirstChild().getNodeValue().trim());
                maxrangem = new Double(doc.getElementsByTagName("MAXRANGEM").item(0).getFirstChild().getNodeValue().trim());
            }
            NodeList xList = doc.getElementsByTagName("X-AXIS");
            xDim = new String[xList.getLength()];
            xDisplay = new String[xList.getLength()];
            String title = "";
            int i = 0;
            while (i < xList.getLength()) {
                xDim[i] = new String();
                xDim[i] = xList.item(i).getFirstChild().getNodeValue();
                ++i;
            }
            NodeList yList = doc.getElementsByTagName("Y-AXIS");
            DocumentBuilder dataParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document dataDoc = dataParser.parse(XML);
            NodeList xlist = dataDoc.getElementsByTagName(xDim[0]);
            int size = xlist.getLength();
            BaseLogger.log("3", null, null, "xsize :" + size);
            double sumofseriesdata = 0.0;
            int i2 = 0;
            while (i2 < size) {
                NamedNodeMap atts = xlist.item(i2).getAttributes();
                seriesdata = atts.getNamedItem("value").getNodeValue();
                seriesoccurence = atts.getNamedItem("occurence").getNodeValue();
                BaseLogger.log("3", null, null, "xyvalue :" + seriesdata);
                BaseLogger.log("3", null, null, "xyvalue occurence :" + seriesoccurence);
                if (seriesdata == null || seriesdata == "" || seriesdata.length() < 0) {
                    seriesdata = "0";
                }
                if (seriesoccurence == null || seriesoccurence == "" || seriesoccurence.length() < 0) {
                    seriesoccurence = "0";
                }
                BaseLogger.log("3", null, null, "ADD" + (sumofseriesdata += Double.parseDouble(seriesdata) * Double.parseDouble(seriesoccurence)));
                ++i2;
            }
            double target = 0.0;
            if (yList != null && yList.getLength() > 0) {
                yDim = new String[yList.getLength()];
                yDisplay = new String[yList.getLength()];
                int i3 = 0;
                while (i3 < yList.getLength()) {
                    yDim[i3] = new String();
                    yDim[i3] = yList.item(i3).getFirstChild().getNodeValue();
                    ++i3;
                }
                int j = 0;
                while (j < yDim.length) {
                    NodeList list = dataDoc.getElementsByTagName(yDim[j]);
                    int ysize = list.getLength();
                    BaseLogger.log("3", null, null, "ysize=" + ysize);
                    if (size > 0) {
                        int k = 0;
                        while (k < ysize) {
                            String value = list.item(k).getFirstChild().getNodeValue();
                            BaseLogger.log("3", null, null, "yvalue :" + value);
                            if (value == null || value == "" || value.length() < 0) {
                                value = "0";
                            }
                            BaseLogger.log("3", null, null, "yvalue Target :" + (target += Double.parseDouble(value)));
                            ++k;
                        }
                    }
                    ++j;
                }
                result = new Double(target / sumofseriesdata * 100.0);
                BaseLogger.log("3", null, null, "RESULT ==>yList not null :" + result + "%");
            } else {
                result = new Double(sumofseriesdata);
                BaseLogger.log("3", null, null, "RESULT ==>yList null :" + result);
            }
            if (type.equals("thermometer")) {
                DefaultValueDataset valueDataSet = new DefaultValueDataset(result.doubleValue());
                thermoPlot = new ThermometerPlot((ValueDataset)valueDataSet);
                thermoPlot.setRange(mincritical.doubleValue(), maxcritical.doubleValue());
                thermoPlot.setSubrange(0, minnormal.doubleValue(), maxnormal.doubleValue());
                thermoPlot.setSubrange(2, mincritical.doubleValue(), maxcritical.doubleValue());
                thermoPlot.setSubrange(1, minwarning.doubleValue(), maxwarning.doubleValue());
                thermoPlot.setMercuryPaint((Paint)this.getColor(7));
                thermoPlot.setThermometerPaint((Paint)this.getColor(6));
                plot = thermoPlot;
            } else {
                DefaultValueDataset valueDataSet = new DefaultValueDataset(result.doubleValue());
                meterPlot = new MeterPlot((ValueDataset)valueDataSet);
                meterPlot.setCriticalRange(new Range(mincriticalm.doubleValue(), maxcriticalm.doubleValue()));
                meterPlot.setWarningRange(new Range(minwarningm.doubleValue(), maxwarningm.doubleValue()));
                meterPlot.setNormalRange(new Range(minnormalm.doubleValue(), maxnormalm.doubleValue()));
                meterPlot.setRange(new Range(minrangem.doubleValue(), maxrangem.doubleValue()));
                meterPlot.setUnits(new String(""));
                meterPlot.setDrawBorder(false);
                plot = meterPlot;
            }
            return plot;
        }
        catch (NumberFormatException e) {
            BaseLogger.log("0", null, null, "Exception :GraphBuilder :buildValueDataSet :==>");
            e.printStackTrace();
            throw e;
        }
    }

    private Object[] toArray(String XML, String dimension) throws Exception {
        try {
            Object[] data = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(XML);
            NodeList list = doc.getElementsByTagName(dimension);
            int size = list.getLength();
            data = new Object[size];
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    NamedNodeMap atts = list.item(i).getAttributes();
                    String value = atts.getNamedItem("value").getNodeValue();
                    if (value.length() > 10) {
                        value = value.substring(0, 9);
                    }
                    data[i] = new String(value);
                    ++i;
                }
            }
            return data;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GraphBuilder :toArray :==>");
            e.printStackTrace();
            throw e;
        }
    }

    protected Color getColor(int color) throws Exception {
        try {
            switch (color % 11) {
                case 0: {
                    return Color.white;
                }
                case 1: {
                    return Color.black;
                }
                case 2: {
                    return Color.blue;
                }
                case 3: {
                    return Color.green;
                }
                case 4: {
                    return Color.red;
                }
                case 5: {
                    return Color.yellow;
                }
                case 6: {
                    return Color.gray;
                }
                case 7: {
                    return Color.orange;
                }
                case 8: {
                    return Color.cyan;
                }
                case 9: {
                    return Color.magenta;
                }
                case 10: {
                    return Color.pink;
                }
            }
            return Color.white;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }
}

