<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<script type="text/javascript" src="/ibase/webitm/js/ITMWizard.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
function sortTable(f,n)
{
	var rowlen = 0;
	  var rows = $('#mytable tbody  tr').get();
	  rows.sort(function(a, b) {

	  var A = $(a).children('td').eq(n).text().toUpperCase();
	  var B = $(b).children('td').eq(n).text().toUpperCase();

	  if(A < B) {
	    return -1*f;
	  }
	  if(A > B) {
	    return 1*f;
	  }
	  return 0;
	  });
	
	var count = 0;

	  $.each(rows, function(index, row) {
	    $('#mytable').children('tbody').append(row);
	  });
	}
	var f_sl = 1;
	var f_nm = 1;
function callTypeShort()
{
	$(".tHeader").click(function(){
	    f_nm *= -1;
	    var n = $(this).prevAll().length;
	    sortTable(f_nm,n);
	});
}
 ]]>
			</script>

			<body onload="callTypeShort();">
				<style type="text/css">
					table tr.separator { height: 5px; }
					root
					{
					display: block;
					}

					.sortable
					{
					/*color: #666;*/
					cursor: pointer;
					/*text-decoration: underline;*/
					}

					th.sortable:hover
					{
					color: black;
					}

					th.sorted-asc, th.sorted-desc
					{
					color: black;
					background-color: cadetblue;
					}

					th:hover
					{
					cursor:pointer;
					color: blue;
					/*background:#AAA;*/

					}

					div.address
					{

					<!-- height: 20px; -->
					font-size:11px;
					float: left;
					color: grey;
					padding-left:36px;
					text-transform:uppercase;
					}

					div.galaxyTable
					{
					width: 100%;
					margin-top:
					25px;
					overflow-x: auto;
					overflow-y: auto;
					white-space: nowrap;
					border-left: 1px solid lightgray;
					border-right: 1px solid lightgray;
					border-color: #6cf #ccc #ccc;
					border-width: 2px 1px 1px;
					border-style: solid;
					border-bottom: 1px solid lightgray;
					}
					tr.border_bottom td {
					border-bottom:1px solid #f2f2f2;
					}
					.parentAbsolutePnl
					{
					background:#f2f2f3;
					}
				</style>
				<!-- <link type="text/css" rel="stylesheet" href="/ibase/webitm/xsl/Standard/WIZARD/css/htmlWizard.css"/> -->
				<div class="parentAbsolutePnl parentAbsPnl-wiz">
					<form name="Wizard_visit">


						<div id="signatureAttachment" style="font-weight: bold;padding-top: 1em;"></div>
						<div
							style="font-size:16px; font-weight:bold; text-transform:uppercase;text-align: center;padding-top: 1em;">
							<xsl:for-each select="//scheme_details">
								<xsl:if test="position() = 1">
									<xsl:variable name="item_descr"></xsl:variable>
									<xsl:value-of select="item_descr" />
								</xsl:if>
							</xsl:for-each>
						</div>

						<div
							style="max-height: 80%;overflow:-moz-scrollbars-vertical;width : 94%;BACKGROUND-COLOR:#FFF;margin: 1em auto;"
							class="galaxyTable">

							<xsl:for-each select="//scheme_details">
								<xsl:variable name="scheme_descr">
									<xsl:value-of select="scheme_descr" />
								</xsl:variable>
								<span
									style="font-size: 14px; color:gray;width: 12%;WHITE-SPACE: NOWRAP;padding-left:5px">
									<xsl:value-of select="$scheme_descr" />
								</span><br></br>
								<table
									style="border-bottom: 1px solid #f2f2f2; width: 98%;margin:5px">
									<tr width="100%">
									</tr>
								</table>
							</xsl:for-each>
						</div>
					</form>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>