<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
                <LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/Standard/summarydefault.css" />

                <title>Details</title>
                <!--<style>
                    body {font-family: Arial, Helvetica, sans-serif;}
                    a {color: #C00;}
                    details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
                    box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
                    /*margin: 0 0 .4em;*/ padding: 1%; }
                    details[open] {background:
                    #fff;}
                    summary {background: #fff; cursor: pointer; font-size: 12px;
                    font-weight:
                    normal; margin: -1%; padding: 8px; position: relative;
                    border:0
                    none; outline:none; }
                    summary:hover, details[open] summary
                    {background: #fff;}
                    summary::-webkit-details-marker {display: none}
                    summary:before{/*border-radius: 5px; */content: "+"; color: white;
                    display: block; float: right; font-size: 16px; font-weight: normal;
                    /*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
                    width: 20px;}
                    details[open] summary:before {content: "-";
                    /*margin-top: -4px;*/
                    margin-left:-5px;color:white;}
                    p {font-size:
                    12px; margin-left:-5px;}

                    .attachmentUpload {
                    position: absolute;
                    width: 92%;
                    background:white;-->
                    <!-- overflow-x:scroll; -->
                    <!--height: 90%;
                    z-index: 999;
                    left: 4%;
                    top: 5%;
                    right: 3%;-->


                    <!-- min-width: 400px; min-height: 200px; -->
                    <!--}
                    .headerText
                    {
                    color:gray;
                    padding-left:5%;
                    }
                    .close {
                    font-family:
                    Arial, Helvetica, sans-serif;
                    font-size: large;
                    background: #606061;
                    color: #fff;
                    line-height: 25px;
                    position: absolute;
                    left: -12px;
                    text-align: center;
                    top: -10px;
                    width: 24px;
                    text-decoration: none;
                    font-weight: bold;
                    -webkit-border-radius: 12px;
                    -moz-border-radius:
                    12px;
                    border-radius: 12px;
                    -moz-box-shadow: 1px 1px 3px #000;
                    -webkit-box-shadow: 1px 1px 3px #000;
                    box-shadow: 1px 1px 3px #000;
                    cursor: pointer;
                    }

                    .close:hover {
                    background: #00d9ff;
                    }
                    .normalFont
                    {
                    font-size:14px;
                    color:black;
                    }
                    .headerTablediv
                    {
                    background: #fff;
                    box-shadow: 0px -1px 0px 0
                    rgba(0,0,0,.1);
                    }
                    .headerTable1
                    {
                    text-align:center;
                    padding-left:
                    0;
                    }
                </style>-->
                <style>
                 /* Added by Jatin M for New Summary Changes for Show Status/DAR on 15/03/2021  - Start */
                *{
                    margin:0;
                    padding:0;
                    box-sizing: border-box;
                }
                .textcolor{
                    color:#969696 !Important;
                    font-weight: 500;
                }
                .text-rowgroup-1{
                    color: #969696!Important;
                    font-weight: 600;
                }
                .horizontal-border {
                    margin: 0 16px 0 40px;
                    border-bottom: 1px solid #eeeeee;
                }
                .horizontal-unlisted-border {
                    margin: 0 16px 0 16px;
                    border-bottom: 1px solid #eeeeee;
                }

                .text-rowgroup-2{
                    font-size: 16px;
                    font-weight: 600;
                    color: #000;
                    text-align: center;
                }
                   .mobviewDiv{
                        margin: 16px 16px 0;
                        border: 1px solid #e2e2e2;
                        border-radius: 12px;   
                    }
                .text-rowgroup-3{
                    font-size: 18px;
                    font-weight: 600;
                    padding: 8px 0 0 0;
                    color: #000;
                }
                .sample-order-div{
					padding: 0 16px 4px 40px;
				}
                .gift-sample-div-unlisted {
                    padding: 0 16px 4px 16px;
                    display: flex;
                    align-items: center;
                }
				.sample-order-div-unlisted {
					padding: 0 16px 4px 16px;
				}
                  .adjPadding{
                    padding: 0 0 0 6px;
                }

                .adjMargin{
					margin: 0 0 8px;
				}

				.mgnTop{
					margin: 0 0 8px;
				}

				.alignLeft{
					padding: 0 0 0 46px !important;
					text-align: left;
				}
                .activity-descr-text{
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .mainiconradius{
                    width: 24px;
                    height: 24px;
                    margin: 0 10px;
                }
                .addspace{
                    text-align: left;
                    margin: 0 0 0 10px;
                }
                .stickysubforms{
                    position: relative;
                    display: contents;
                    -webkit-overflow-scrolling: touch;
                }
                .timeline::before {
                    content: '';
                    position: absolute;
                    height: 22px;
                    width: 1px;
                    background-color: #000;
                    left: 32px;
                    transform: translateY(-118%);
                    /*transform: translate(100%,-100%);*/
                }
                .timeline:first-child::before{
                    width: 0;
                }
   				.divToTheRight{
                     text-align:right;
                     width: 50%;
                     padding: 0 0 0 8px;
                     min-width: 120px;
                     overflow: hidden;
                 }
                .customerDiv{
                    display: flex;
                    padding: 0 16px;
                    align-items: center;
                    margin-bottom: 16px;
                }
  			.divToTheLeft{
                     width: 50%;
                     padding: 0 8px 0 0;
                     min-width: 120px;
                     overflow: hidden;
                     text-align: left;
                 }
				    
                .customerDiv:last-child{
                    margin-bottom: 0;
                }
                .cust-location{
                    height: 16px;
                    width: 16px;
                }
                .large-font{
                    font-size: 14px;
                }
                .small-font{
                    font-size: 12px;
                }
                .align-customer{
                    display: inline-block;
                }
                .row-div{
                    padding: 0 16px 0 40px;
                    display: flex;
                    margin-bottom: 16px;
                }
                .gift-sample-div{
                    padding: 0 16px 4px 40px;
                    display: flex;
                    align-items: center;
                }
                .gift-sample-div-unlisted {
                    padding: 0 16px 4px 16px;
                    display: flex;
                    align-items: center;
                }
                .outerIcon{
                    height: 24px;
                    width: 24px;
                    margin: 0 4px 0 0;
                }
                .travelIcon{
                    height: 20px;
                    width: 20px;
                    border-radius: 100%
                }
                .donebutton{
                    border-radius: 100%;
                    height: 20px;
                    width: 20px;
                    margin: 0 32px;
                }
                .places_visited{
                    height: 20px;
                    width: 20px;
                }
                
                .hideoverflow{
                    /*overflow: hidden;*/
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 2;
                    display: block;
                    -webkit-box-orient: vertical;
                    height: auto;
                }

                .hideoverflowfeed{
                    /*overflow: hidden;*/
                    display: inline-table;
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 1;
                    -webkit-box-orient: vertical;
                    height: 20px;
                    min-width: 50px;
                    line-height: 24px;
                }

                .povminwidth{
                    min-width: 150px;
                }

                .mainbody{
                    background: #f5f5f5;
                    margin: auto;
                    max-width: 1024px;
                    width: calc(100% - 32px);
                    font-family: sans-serif !important;
                    font-weight: 500 !important;
                    margin-bottom: 0;
                }

                .showstatusDiv{
                    background: #f5f5f5;
                    margin: auto;
                    margin-bottom: 70px;
                    width: calc(100% - 32px);
                    font-family: sans-serif !important;
                    font-weight: 500 !important;
                    /*overflow: auto;*/
                    max-width: calc(1024px - 1px);
                    position: relative;
                    /*height: auto;*/
                    height:calc(100% - 60px);
                    z-index: 1;   
                    overflow-y: scroll;
                    -webkit-overflow-scrolling: touch;
                }
                .mainDivShowStatus{
                    position: fixed; 
                    width: 100%; 
                    height: 100%; 
                    top: 0;
                    left: 0;
                }

                .fixedcontainerDiv{
                    position: absolute; 
                    bottom:0; 
                    left:0; 
                    width:100%; 
                    height: 40px; 
                    background:#cccccc; 
                    z-index:11;
                }

                .datafontsize{
                    font-size:14px !Important;
                    color: #000;
                }
                .headerfontsize{
                    font-size:12px !Important;
                    color:#969696 !Important;
                }
                .bradius{
                    border-radius: 100px;
                    height: 30px;
                    width: 30px;
                }

                .collapsibleIconRadius{
                    border-radius: 100px;
                    height: 24px;
                    width: 24px;
                }

                .imgradius{
                    border-radius: 100px;
                    height: 80px;
                    width: 80px;
                }
                .headerdata{
                    display: flex;
                    align-items: center;
                    white-space: nowrap;
                    /* height: 36px; */
                    margin: 0;
                    font-size: 12px;
                    padding: 0 12px;
                    color: #000;
                    cursor: pointer;
                }  

                .rightcol-spacing{
                    margin-inline-start: auto;
                    text-align: right;
                    font-size: 12px;
                    align-self: baseline;
                    white-space: nowrap;
                }

                .containerfeed{
                    padding: 12px 0;
                    margin: 8px 0 8px 0;
                    /*height: auto;*/
                    border-radius: 12px;
                    background-color: #fff;
                    overflow: hidden;
                }
                    
                .main-icon{
                    display: block; 
                    text-align:center;
                }
				.itmdescrFeed
				{
                    display: flex;
                    align-items: center;
                }
                .submitdate{
                    font-size:12px;
                    font-weight: 600;
                    padding: 8px 0 0 0;
                    font-weight: 600px;
                    color: #000;
                }


                .align-imgtext{
                    float:left;
                    text-align:right;
                }

                .single-colDiv{
                    display: inline-flex;
                    align-items: center;
                    text-align: left;
                    justify-content: center;
                    margin: 0 auto;
                    padding: 0 16px;
                    width: 100%;
                    height: 100px;
                    min-height: 100px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                }

                .columnsDiv {
                    display: flex;
                    align-items: center;
                    width: 100%;
                    height: 52px;
                    min-height: 52px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                    /* border: 1px solid #e2e2e2; */
                    /* border-radius: 12px;*/
                }

                .columnsDiv-1 {
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    width: 100%;
                    /* padding: 16px; */
                    height: 52px;
                    min-height: 52px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                    /* border: 1px solid #e2e2e2; */
                    /* border-radius: 12px;*/
                }

                .btnborder{
                    height: 24px;
                    width: 24px;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    background-color: #f5f5f5;
                    border-radius: 28px;
                }


                .visitdetails{
                    color: #969696;
                    display: flex;
                    padding: 0px;
                    height: 25px;
                }
                .tab{
                    margin-inline-start: auto;
                    cursor: pointer;
                }
                .tablinks{
                    border:none;
                    outline:none;
                    background: none;
                }

                .svgcolor{
                    background-color: #faaa1f;
                    width: 14px;
                    height: 14px;
                    border-radius: 100%;
                }

                .tab button:active {
                    border: none;
                    outline: none;
                    box-shadow: none;
                }
                .confstatus{
                    display: flex;
                    align-items: center;
                    border-radius: 50%;
                    font-size:12px;
                    color: #969696;
                }

                .placeofvisit{
                    width:25%;
                    padding: 0 8px 0 0;
                    min-width: 120px;
                    overflow: hidden;
                    text-align: left;
                }
                .journeyfrom{
                    text-align: left;
                    width:25%;
                    padding: 0 8px 0;
                    min-width: 120px;
                    overflow: hidden;
                }
                .travelmode{
                    text-align: left;
                    width:25%;
                    padding: 0 8px 0;
                    min-width: 120px;
                    overflow: hidden;
                }
                .orderofvisit{
                    text-align:right;
                    width:25%;
                    padding: 0 0 0 8px;
                    min-width: 120px;
                    overflow: hidden;
                }


                .emp-name{
                    width: 20%;
                    padding: 0 8px 0 0;
                    min-width: 150px;
                    overflow: hidden;
                    text-align: left;
                }
                .placeofvisitmgr{
                    width: 20%;
                    padding: 0 8px;
                    min-width: 120px;
                    overflow: hidden;
                    text-align: left;
                }
                .journeyfrommgr{
                    text-align: left;
                    width: 20%;
                    padding: 0 8px 0;
                    min-width: 120px;
                    overflow: hidden;
                }
                .travelmodemgr{
                    text-align: left;
                    width: 20%;
                    padding: 0 8px 0;
                    min-width: 120px;
                    overflow: hidden;
                }
                .orderofvisitmgr{
                    text-align:right;
                    width:20%;
                    padding: 0 0 0 8px;
                    min-width: 120px;
                    overflow: hidden;
                }

                .left-spacing{
                    width: 60%;
                    padding: 0 8px 0 0;
                    min-width: 150px;
                    overflow: hidden;
                    text-align: left;
                    display: flex;
                    align-items: center;
                }

                .center-spacing{
                    width: 20%;
                    text-align: left;
                    padding: 0 8px 0;
                    min-width: 110px;
                    overflow: hidden;
                }
                .right-spacing{
                    text-align: right;
                    width: 20%;
                    padding: 0 0 0 8px;
                    min-width: 110px;
                    overflow: hidden;
                }

                sup{
                    font-size: 8px;
                }

                .bgcolorform{
                    background-color: #f5f5f5;
                }
                .headingwidth{
                    border-bottom: 1px solid #0000001a;
                    white-space: nowrap;
                    display: flex;
                    align-items: flex-start;
                    height: 25px;
                    text-overflow: ellipsis;
                    overflow: hidden;
                    color: #969696 !important;
                    padding: 0 8px;
                }


                .detailswidth{
                    padding: 0 8px;
                    white-space: normal;
                    height: auto;
                    display:block;
                    /*align-items: center;*/
                    color: #000;
                }
                
                .seperatorDiv{
                    border-bottom: 1px solid #0000001a;
                }
                .firstcolumn{
                    text-align: left;
                    padding: 0 8px 0 0;
                    left: 0;
                }

                .lastcolumn{
                    justify-content: flex-end;
                    padding: 0 0 0 8px;
					text-align: right;
                }

                .docname{
                    width: 20%;
                    min-width: 200px;
                }
                .speciality{
                    min-width: 150px;
                    width: 10%;
                    text-align: left;
                }

                .class{
                    min-width: 150px;
                    width: 10%;
                    text-align: left;
                }

                .placeofwork{
                    width: 10%;
                    min-width: 200px;
                    text-align: left;
                }
                .activity{
                    width: 10%;
                    min-width: 110px;
                    text-align: left;
                }
                .visitplan{
                    min-width: 90px;
                    width: 10%;
                    text-align: right;
                    justify-content: flex-end;
                }

                .visitwith{
                    width: 10%;
                    min-width: 200px;
                    text-align: left;
                }

                .visittime{
                    width: 10%;
                    min-width: 100px;
                    text-align: right;
                    justify-content: flex-end;
                }

                .pobvalue{
                    width: 10%;
                    min-width: 90px;
                    text-align: right;
                    justify-content: flex-end;
                }
                
                .reg-no{
                    min-width: 125px;
                    width: 10%;
                    text-align: right;
                    justify-content: flex-end;
                }

                .euin-no{
                    min-width: 125px;
                    width: 10%;
                    text-align: right;
                    justify-content: flex-end;
                }

                .meet-stat{
                    min-width: 120px;
                    width: 10%;
                    text-align: right;
                    justify-content: flex-end;
                }
                .customer-types{
                    min-width: 120px;
                    width: 10%;
                    text-align: right;
                    justify-content: flex-end;
                }
                

                .remarks{
                    width: 10%;
                    min-width: 200px;
                }
                .timeofcall{
                    width: 20%;
                    min-width: 150px;
                    text-align: right;
                    justify-content: flex-end;
                }

                .unlistedcust{
                    width: 10%;
                    min-width: 200px;
                }
				.ord-product{
				    width: 20%;
				    padding: 0 8px 0 0;
				    min-width: 150px;
				    overflow: hidden;
				    text-align: left;
				    display: flex;
				    align-items: center;
				}
				
				.ord-quantity{
				    width: 20%;
				    text-align: right;
				    padding: 0 8px 0;
				    min-width: 100px;
				    overflow: hidden;
				}
				
				.ord-value{
				    width: 20%;
				    text-align: right;
				    padding: 0 8px 0;
				    min-width: 100px;
				    overflow: hidden;
				}
				
				.ord-descr{
				    text-align: left;
				    width: 20%;
				    padding: 0 8px 0;
				    min-width: 150px;
				    overflow: hidden;
				}
				
				.ord-remarks{
					text-align: right;
				    width: 20%;
				    padding: 0 0 0 8px;
				    min-width: 150px;
				    overflow: hidden;
				}

                .ord-devi-rsn{
                    text-align: left;
                    padding: 0 8px 0;
                    min-width: 200px;
                    overflow: hidden;
                }
                .visited-with{
                    width: 20%;
                    min-width: 140px;
                    text-align: left;
                }
                .pob-value{
                    width: 20%;
                    min-width: 80px;
                    text-align: right;
                    justify-content: flex-end;
                }

                .unlistedremark{
                    width: 20%;
                    min-width: 150px;
                }

                .workplace{
                    width: 20%;
                    min-width: 120px;
                    text-align: left;
                }


                .visitsdetails{
                    display: flex;
                    align-items: center;
                    padding: 8px 0px;
                }

                .containertable{
                    padding: 0 16px;
                    margin: 12px 0;
                    border-radius: 12px;
                    background:#fff;
                    overflow-x: hidden;
                }

                .doctorcontainer{
                    padding: 8px 0;
                    margin: 8px 0 8px 0;
                    /*height: auto;*/
                    border-radius: 12px;
                    background-color: #fff; 
                    overflow-x: auto;
                    overflow-y: hidden;
                    /*width: calc(100% - 0px);*/
                    /*position: relative;*/
                }
                    


                .doctordetails{
                    display: flex;
                    padding: 0px;
                    white-space: initial;
                    /*width: 100%;*/
                    height: 25px;
                }
                .docdatadetails{
                    display: flex;
                    align-items: center;
                    padding: 0px;
                    height: auto;
                    margin: 8px 0;
                }

                .sampleheading{
                    display:flex;
                    align-items:center;
                    padding: 8px 0;
                }

                .samplename{
                    display: flex;
                    align-items: center;
                    color: #969696;
                    padding: 0;
                    height: 25px;
                    border-bottom: 1px solid #0000001a;
                }
                
                .overflo-samplename{
				    display: flex;
				    align-items: center;
				    color: #666666;
				    padding: 0;
				    height: 25px;
				}

                .sampledata{
                    white-space: initial;
                    display: flex;
                    padding: 0;
                    margin: 8px 0;
                    height: auto;
                    align-items: center;
                }
                
                .subformoverflow{
				    overflow-x:auto;
				}

                .sampledetails{
                    background-color: #ededed;
                    padding: 8px 16px;
                    /*width: 100%;*/
                    left: 0;
                    position: sticky;
                    position: -webkit-sticky;
                }
                    
                .routeicon{
                    margin-inline-start: auto;
                    background-color: #eeeeee;
                }

                .itemlabel {
                    margin-top: 16px;
                    padding: 0 40px;
                    height: 16px;
                    text-align: left;
                }
                .itemlabel-unlisted {
                    margin-top: 16px;
                    padding: 0 16px;
                    height: 16px;
                    text-align: left;
                }
                .itemOuterDiv{
                    margin-top: 16px;
                }

                .coldatafeed{
                    display:flex;
                    padding: 8px 16px;
                }

                .imgicon{
                    width: 80px;
                    height: 80px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .btniconborder{
                    height: 34px;
                    width: 34px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .table_default_bg{
                    background-color: #e6f4ff;
                }

                .feed_default_bg{
                    background-color: #0273d0;
                }

                .iconborder{
                    min-height: 30px;
                    min-width: 30px;
                    max-width: 30px;
                    max-height: 30px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .location-icon {
                    background-color: #98ccf4;
                }

                .lstdcrdate-icon {
                    background-color: #d5b3ff;
                }
                .remarks-icon {
                    background-color : #86e7d6;
                }

                .speciality-icon{
                    background-color: #91ecff;
                } 

                .class-icon{
                background-color: #ffa7a7;
                }

                .visitplan-icon {
                    background-color: #f4a8ff;
                }

                .timeofcall-icon {
                    background-color: #ffb98e;
                }

                .visitedwith-icon {
                    background-color: #ccbdbd;
                }

                .pobvalue-icon {
                    background-color: #fbd607;
                }

                .regno-icon {
                    background-color: #ef5350;
                }

                .euin-icon {
                    background-color: #03a9f4;
                }

                .product-icon  {
                    background-color: #cacaca;
                } 

                .unlistedcust-doc-icon{
                    background-color: #0baa85;
                }

                .unlistedcust-chem-icon{
                    background-color: #b2bbff;
                }

                .unlistedcust-sto-icon{
                    background-color: #4995ea;
                }

                .unlistedcust-ncw-icon{
                    background-color: #ff3e00;
                }

                .bluebg-icon{
                    background-color: #e6f4ff;
                }

                .redbg-icon{
                    background-color: #ffe8e9;
                }



                .connroute:before {
                    box-shadow: 1px 0 0 0 rgb(0 0 0 / 10%);
                }
                .connroute:first-child {
                    display: none;
                }


                .namespacing{
                    padding: 0 0 0 16px;
                    text-align: left;
                    line-height: 1.5;
                }



                .activityspacing{
                    padding: 8px 0 0 0;
                    color: #000;
                }

                .nestedcontainer{
                    /*height:auto;*/
                    background-color:#d9d9d9;
                    padding:16px;
                    margin : 8px 16px;
                    border-radius:15px;
                }

                .column-center{
                    text-align:center;
                }
                .alignimg{
                    vertical-align:middle;
                }
                .clearfix{
                    clear:both;
                }

                .powfeedview{
                    overflow: hidden;
                    min-width: 50px;
                    white-space: normal;
                    max-width: 200px;
                }

                #section-n2 {
                    display:none;
                }



                .fixedcontainer{
                    display:flex;
                    background-color: #fff;
                    width:100%;
                    /*height:auto;*/
                    position: fixed;
                    bottom:0;
                    padding: 8px 32px 0;
                }


                .delbutton{
                    margin-inline-start: auto;
                    height: 36px;
                    width:36px;
                }
                button.rmvborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #f5f5f5;
                }

                button.rmborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #fff;
                }

                cust-col{
                    display: flex;
                    align-items: center;
                    text-align: left;
                    width: 100%;
                    height: 34px;
                    min-height: 34px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                }

                .btnpadding{
                    padding: 0 0 0 4px;
                }

                .tabs {
                    position: relative;
                    text-align: center;
                    background: #f5f5f5;
                    /*width: 100%;*/
                    border-radius: 5px;
                    min-width: 240px;
                    min-height: 500px;
                    overflow-x: auto;
                    overflow-y: hidden;
                    -webkit-overflow-scrolling: touch;
                }
                .tabs .uldiv {
                    list-style-type: none;
                    padding: 0 16px;
                    display: -webkit-box;
                    display: flex;
                    -webkit-box-orient: horizontal;
                    -webkit-box-direction: normal;
                            flex-direction: row;
                    margin-bottom: 4px;
                    -webkit-box-pack: justify;
                            justify-content: space-between;
                    -webkit-box-align: end;
                            align-items: center;
                    flex-wrap: wrap;
                    margin-top: 0;
                    width: 100%;
                }

                .rmv-Mrg{
                    margin: 0;
                }

                .unlistedcustmgn{
                    margin-top:0 !important;
                }

                .tabs .uldiv li {
                    box-sizing: border-box;
                    -webkit-box-flex: 1;
                    text-align: center;
                    margin-right: 0;
                }
                .lidiv{
                    padding: 0 0 0 16px;
                }


                .tabs .uldiv li label {
                    -webkit-transition: all 0.3s ease-in-out;
                    transition: all 0.3s ease-in-out;
                    padding: 5px auto;
                    overflow: hidden;
                    text-overflow: ellipsis;
                    display: block;
                    cursor: pointer;
                    -webkit-transition: all 0.2s ease-in-out;
                    transition: all 0.2s ease-in-out;
                    white-space: nowrap;
                    -webkit-touch-callout: none;
                    user-select: none;
                }

                .tabs .uldiv li label{
                    font-size: 18px;
                    color: #0273d0;
                }


                .tabs .uldiv li label:hover, .tabs .uldiv li label:focus, tabs .uldiv li label:active{
                    outline: 0;
                    color: #0273d0;
                }

                .tabs .slidertab {
                    position: relative;
                    width: calc(100% - 56px);
                    -webkit-transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                    transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                }
                .tabs .slidertab .indicator {
                    position: relative;
                    width: 16px;
                    max-width: 100%;
                    margin-inline-start: auto;
                    height: 4px;
                    background: #0273d0;
                    border-radius: 1px;
                }

                .tabs .data-content section {
                    -webkit-animation-name: data-content;
                            animation-name: data-content;
                    -webkit-animation-direction: normal;
                            animation-direction: normal;
                    -webkit-animation-duration: 0.3s;
                            animation-duration: 0.3s;
                    -webkit-animation-timing-function: ease-in-out;
                            animation-timing-function: ease-in-out;
                    -webkit-animation-iteration-count: 1;
                            animation-iteration-count: 1;
                    line-height: 1.4;
                }

                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .uldiv > li:nth-child(1) > label {
                    cursor: default;
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }

                .tabs input[name="tab-control"] {
                    display: none;
                }

                @-webkit-keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @media (max-width: 1000px) {
                    .tabs .uldiv li label {
                        white-space: initial;
                    }
                }


                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .slidertab {
                    -webkit-transform: translateX(-18px);
                            transform: translateX(-18px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(1):checked ~ .data-content > section:nth-child(1) {
                    display: block;
                }*/
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .uldiv > li:nth-child(2) > label {
                    cursor: default;
                }
                
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(32px);
                            transform: translateX(32px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(2):checked ~ .data-content > section:nth-child(2) {
                    display: block;
                }*/

                .duo-colDiv{
                    padding: 0 16px;
                    text-align:left;
                }

                .visits-colDiv{
                    margin: 0 16px;
                    grid-column-gap: 16px;
                }

                .multi-colDiv{
                    margin: 24px 0;
                    text-align: left;
                    padding: 0 16px;
                    
                }
                @media screen and  (min-width:580px) {
                    .multi-colDiv{
                        display: grid;
                        grid-template-columns: 1fr 1fr 1fr;
                    }
                    .columnsDiv{
                        justify-content: center;
                    }
                }

                </style>
			</head>

			<script type="text/javascript"
				src="/ibase/webitm/js/ViewReport.js"></script>
			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>
            <!--<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: initial;
					font-size: 14px;
					color:
					#666;
					padding-top: 7px;

					}
					.tdLeft
					{
					text-align: left;

					}
					.tdRight
					{
					text-align: right;

					}

					.heading
					{
					font-weight: 500;
					font-size:
					14px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {-->
					<!--padding-left:8%; -->
					<!--margin-right: 12%;
					}
					.firstData
					{
					color:black;
					}
					@media only screen and
					(min-width: 100px) and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>-->

				<!--<style>
					.travelTableCss {
					padding: 10px;
					color: #666;
					font-size: 14px;
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					width: auto;
					grid-column-gap: 0.30em;
					grid-row-gap: 0.25em;
					}

					.travelTitle {
					width:
					auto;
					float: right;
					font-size: 14px;
					text-align: right;
					}

					.travelValue{
					width: auto;
					text-align: left;
					line-height: 1.2;
					}

					.valueFieldCss{
					font-size: 14px;
					color: #666;
					}

					.plcDetailCss {
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					grid-column-gap: 0.25em;
					grid-row-gap: 0.25em;
					width: 100%;
					}

					.custDetailCss{
					color: #666;
					width: 100%;
					font-size: 12px;
					display: grid !important;
					grid-template-columns: 35% 30% 30%;
					grid-column-gap: 0.75em;
					grid-row-gap: 0.75em;
					}

					.dataDivCss{
					height:100%;
					width:100%;
					overflow-x:hidden;
					overflow-y:auto;
					}

					.summaryborderPanel{
					display:
					block;
					border-top: #fff 1px solid;
					width: 98%;
					margin-top: 24px;
					}
				</style>-->
            <LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
			<body onload="">
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" class="bgcolorform">
                <!--Changes by Jatin M on 15-MAR-2021 for Summary Look and Feel-->
                    <div class="mainbody">
                        <!--<div ID="dsrDiv" class="outerDiv"
                            style="MARGIN-BOTTOM: 10PX;width: 98%;">

                            <div id='dataDiv' class="dataDiv"
                                style="height:100%;width:100%;overflow-y:auto">

                                <table id="travelTable" class="tTitleD" border="0" cellspacing="1"
                                    cellpadding="1" width="100%"> 

                                <div class="headerTable1 headerTablediv">
                                    <table id="travelTable" class="tTitleD " border="0"
                                        cellspacing="1" cellpadding="1" width="100%">-->

                                        

                                            <!--<tr>
                                                <td class="cellttl1" width="auto"
                                                    style='padding : 10px 10px 0px 10px;'>

                                                    <div class="normalFont"
                                                        style='text-transform:capitalize;float: left;'>
                                                        <xsl:variable name="sales_pers_name">
                                                            <xsl:value-of select="sales_pers_sp_name" />
                                                        </xsl:variable>
                                                        <xsl:variable name="sales_pers">
                                                            <xsl:value-of select="sales_pers" />
                                                        </xsl:variable>
                                                        <xsl:variable name="host_url">
                                                            <xsl:value-of select="host_url" />
                                                        </xsl:variable>

                                                        <IMG
                                                            SRC="{normalize-space($host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($sales_pers)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($sales_pers_name)}"
                                                            onerror='this.src="../webitm/images/Summary/errUser.png"'
                                                            class="iw-header-userImage"
                                                            style="height: 28px; width: 28px;border-radius:50%;;background:lightgray">
                                                        </IMG>
                                                        <div class="normalFont"
                                                            style='text-transform:capitalize;float:right;padding:4px 5px;text-align: left;'>
                                                            <xsl:value-of select="sales_pers_sp_name" />
                                                            <xsl:value-of
                                                                select="concat('(',sales_pers,')')" />
                                                            <br></br>
                                                            <xsl:value-of select="headquarter" />
                                                        </div>
                                                    </div>
                                                    <div class="normalFont"
                                                        style='text-transform:capitalize;float:right;padding:4px 5px;'>
                                                        <xsl:value-of select="event_date" />
                                                    </div>

                                                </td>
                                            </tr>-->
                                    
                        <xsl:for-each select="//Detail1">
                            <xsl:variable name="host_url">
                                <xsl:for-each select="//Detail1">
                                    <xsl:if test="attribute/@updateFlag!='D'">
                                        <xsl:value-of select="host_url" />
                                    </xsl:if>
                                </xsl:for-each>
                            </xsl:variable>


                            <!--<tr style="width: 100%;">
                                <td class="cellttl1" width="auto"
                                    style="text-align:center;">
                                    <div class=""
                                        style='text-transform:capitalize;height: 30px;margin: auto;width: 30px;border-radius: 50%;background: lightgray;'>

                                        <xsl:variable name="event_type">
                                            <xsl:value-of select="activity_code" />
                                        </xsl:variable>
                                        <xsl:variable name="event_descr">
                                            <xsl:value-of select="activity_descr" />
                                        </xsl:variable>
                                        <xsl:variable name="hostUrl">
                                            <xsl:value-of select="host_url" />
                                        </xsl:variable>
                                        <IMG
                                            SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($event_type)}&amp;object=wsfa_fieldactivity&amp;objName=wsfa_fieldactivity&amp;ALT_FLD_VALUE={normalize-space($event_descr)}"
                                            onerror='this.src="../webitm/images/Summary/errUser.png"'
                                            class="iw-header-userImage"
                                            style="height: 15px; width: 15px;padding: 7.5px">
                                        </IMG>
                                    </div>
                                    <span CLASS="normalFont"
                                        style="width:auto;color:black;">Activity </span>
                                    <br />
                                    <span CLASS="normalFont" style="width:auto;">
                                        <xsl:value-of select="activity_descr" />
                                    </span>
                                    </td>
                                </tr>
                                <tr style="width: 100%;">
                                    <td class="cellttl1" width="auto"
                                        style="text-align:center;border-bottom: 1px solid #e5e4e9;">
                                        <span CLASS="normalFont"
                                                style="width:auto;color:black;">Report Status: </span>
                                        <span CLASS="normalFont" style="width:auto;">
                                            Submitted On
                                        <xsl:value-of select="submit_show_date" />
                                            But Not confirmed
                                        </span>

                                    </td>
                                </tr>-->

                            <div class="containerfeed">
                                <div class="headerdata">
                                    <div class="text-rowgroup-1">
                                        <xsl:value-of select="event_date" />
                                    </div>
                                    <div class="text-rowgroup-1 rightcol-spacing">
                                        <div class="confstatus">
                                            <IMG
                                                SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                                onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                                class="align-imgtext svgcolor" width="40" height="40">
                                            </IMG>
                                            <div class="addspace text-rowgroup-1">
                                                Pending Confirmation
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="single-colDiv">
                                    <xsl:variable name="sales_pers_name">
                                        <xsl:value-of select="sales_pers_sp_name" />
                                    </xsl:variable>
                                    <xsl:variable name="sales_pers">
                                        <xsl:value-of select="sales_pers" />
                                    </xsl:variable>
                                    <div class="imgicon bluebg-icon">
                                        <IMG
                                            SRC="{normalize-space($host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($sales_pers)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($sales_pers_name)}"
                                            onerror='this.src="../webitm/images/Summary/user.png"'
                                            class="imgradius align-imgtext">
                                        </IMG>
                                    </div>
                                </div>
                                <div class="text-rowgroup-2">
                                    <xsl:value-of select="sales_pers_sp_name" />
                                    <xsl:value-of
                                        select="concat('(',sales_pers,'), ',headquarter)" />
                                </div>

                                <div class="main-icon">
                                    <xsl:variable name="event_type">
                                        <xsl:value-of select="activity_code" />
                                    </xsl:variable>
                                    <xsl:variable name="event_descr">
                                        <xsl:value-of select="activity_descr" />
                                    </xsl:variable>	
                                    <div class="text-rowgroup-3 activity-descr-text">				
                                        <IMG
                                            SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/fw.svg"
                                            onerror='this.src="../webitm/images/Summary/fw.svg"'
                                            class="mainiconradius"
                                            width ="40" height="40">
                                        </IMG>
                                        <xsl:value-of select="activity_descr" />
                                    </div>
                                </div>
                                <div class="submitdate">
                                    <span class="textcolor"> Submitted On  </span> <xsl:value-of select="submit_show_date" />
                                </div>
                                <div class="mobviewDiv">
                                    <div class="multi-colDiv">
                                        <div class="columnsDiv">
                                            <xsl:variable name="lastdcrdate">
                                                <xsl:value-of select="last_dcr_date" />
                                            </xsl:variable>
                                            <div class="iconborder lstdcrdate-icon">
                                                <IMG
                                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_date.svg"
                                                    onerror='this.src="../webitm/images/Summary/summary_date.svg"' 
                                                    class="bradius align-imgtext">
                                                </IMG>
                                            </div>
                                            <div  class="namespacing align-imgtext">
                                                <div class="textcolor headerfontsize " >
                                                    Last DCR Date
                                                </div>
                                                <div class="datafontsize " >
                                                    <xsl:value-of select="last_dcr_date" />
                                                </div>
                                            </div>
                                        </div>

                                        <div class="columnsDiv">
                                            <xsl:variable name="placeofwork">
                                                <xsl:value-of select="sprs_route_descr" />
                                            </xsl:variable>
                                            <div class="iconborder location-icon">
                                                <IMG
                                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_place.svg"
                                                    onerror='this.src="../webitm/images/Summary/summary_place.svg"' 
                                                    class="bradius align-imgtext">
                                                </IMG>
                                            </div>
                                            <div class="namespacing align-imgtext">
                                                <div class="textcolor headerfontsize" >
                                                    Last Place of work
                                                </div>
                                                <div class="datafontsize">
                                                    <xsl:value-of select="sprs_route_descr" />
                                                </div>
                                            </div>
                                        </div>

                                        <div class="columnsDiv">
                                            <xsl:variable name="remarks_sp">
                                                <xsl:value-of select="remark" />
                                            </xsl:variable>
                                            <div class="iconborder remarks-icon">
                                                <IMG
                                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                                    onerror='this.src="../webitm/images/Summary/summary_remarks.svg"' 
                                                    class="bradius align-imgtext">
                                                </IMG>
                                            </div>
                                            <div class="namespacing align-imgtext">
                                                <div class="textcolor headerfontsize " >
                                                    Remarks
                                                </div>
                                                <div class="datafontsize " >
                                                    <xsl:value-of select="remark" />                                                   
                                                </div>
                                            </div>
                                        </div>                                    
                                    </div>
                                </div>
                            </div>

                        </xsl:for-each>

                                <!--<div class="headerdata datafontsize"><div id="showTableText" class="textcontent">
                                    Table view
                                </div>
                                <div id="showFeedText" class="textcontent">
                                    Feed View
                                </div>
                                <div class="tab datafontsize" align="right">
                                    <button class="tablinks rmborder"   onclick="view(event, 'Tableview'), textview(event, 'showTableText')" >
                                        <IMG SRC="/ibase/webitm/images/Summary/table view.svg" width ="30" height="30">
                                        </IMG>
                                    </button>
                                    <button class="tablinks rmborder"   onclick="view(event, 'Feedview'), textview(event, 'showFeedText')">
                                        <IMG SRC="/ibase/webitm/images/Summary/feed view.svg" width ="30" height="30">
                                        </IMG>
                                    </button>
                                    </div>
                                </div>-->

                        <xsl:variable name="hostUrl">
                            <xsl:for-each select="//Detail1">
                                <xsl:value-of select="host_url" />
                            </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="feed">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed.svg')" />
                        </xsl:variable>
                        <xsl:variable name="feed_alt">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed_alt.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table_alt">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table_alt.svg')" />
                        </xsl:variable>


                        <div class="tabs">
                            <input type="radio" id="tab1" name="tab-control" checked="true"  />
                            <input type="radio" id="tab2" name="tab-control" />
                            <ul class="uldiv">
                                <li class="rightcol-spacing" title="Feed View">
                                    <label for="tab1" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder feed_default_bg" id="feedbg">
                                                <IMG 
                                                    id="feedicon" width ="30" height="30"
                                                    onclick="focusView('focusOnFeed','{normalize-space($feed_alt)}','{normalize-space($table)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$feed_alt" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                                <li class="lidiv rmv-Mrg" title="Table View">
                                    
                                    <label for="tab2" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder table_default_bg" id="tablebg">
                                                <IMG 
                                                    id="tableicon" width ="30" height="30"
                                                    onclick="focusView('focusOnTable','{normalize-space($table_alt)}','{normalize-space($feed)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$table" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                            </ul>
                            <div class="slidertab">
                                <div class="indicator"></div>
                            </div>
								<!--</table>
							</div>-->

							<!--<xsl:variable name="activity_type">
								<xsl:for-each select="//Detail1">
									<xsl:value-of select="activity_type" />
								</xsl:for-each>
							</xsl:variable>-->
                            <div class="data-content">
                                <!--Feed View Template Start-->
                                <section id="section-n1">

                                <!-- Detail2(start) -->
                                    <xsl:variable name="detail2_listed_count">
                                        <xsl:for-each select="//Detail2">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail2)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail2_listed_count) > '0'">
                                        <xsl:variable name="detail2_form">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','2',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail2_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail2_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail2_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail2(end) -->
                                    <!-- Detail3(start) -->
                                    <xsl:variable name="detail3_listed_count">
                                        <xsl:for-each select="//Detail3">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail3)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail3_listed_count) > '0'">
                                        <xsl:variable name="detail3_form">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','3',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail3_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail3_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail3_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail3(end) -->
                                    <!-- Detail4(start) -->
                                    <xsl:variable name="detail4_listed_count">
                                        <xsl:for-each select="//Detail4">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail4)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail4_listed_count) > '0'">
                                        <xsl:variable name="detail4_form">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','4',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail4_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail4_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail4_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail4(end) -->
                                    <!-- Detail5(start) -->
                                    <xsl:variable name="detail5_listed_count">
                                        <xsl:for-each select="//Detail5">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail5)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail5_listed_count) > '0'">
                                        <xsl:variable name="detail5_form">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','5',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail5_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail5_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail5_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail5(end) -->
                                    <!-- Detail6(start) -->
                                    <xsl:variable name="detail6_listed_count">
                                        <xsl:for-each select="//Detail6">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail6)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail6_listed_count) > '0'">
                                        <xsl:variable name="detail6_form">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','6',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail6_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail6_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail6_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail6(end) -->
                                    <!-- Detail7(start) -->
                                    <xsl:variable name="detail7_listed_count">
                                        <xsl:for-each select="//Detail7">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail7)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail7_listed_count) > '0'">
                                        <xsl:variable name="detail7_form">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','7',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail7_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail7_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail7_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail7(end) -->
                                    <!-- Detail8(start) -->
                                    <xsl:variable name="detail8_listed_count">
                                        <xsl:for-each select="//Detail8">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail8)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail8_listed_count) > '0'">
                                        <xsl:variable name="detail8_form">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','8',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail8_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail8_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail8_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail8(end) -->
                                    <!-- Detail9(start) -->
                                    <xsl:variable name="detail9_listed_count">
                                        <xsl:for-each select="//Detail9">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail9)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail9_listed_count) > '0'">
                                        <xsl:variable name="detail9_form">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','9',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail9_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail9_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail9_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail9(end) -->
                                    <!-- Detail10(start) -->
                                    <xsl:variable name="detail10_listed_count">
                                        <xsl:for-each select="//Detail10">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail10)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail10_listed_count) > '0'">
                                        <xsl:variable name="detail10_form">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','10',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail10_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail10_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail10_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                     <!-- Detail11(start) -->
                                    <xsl:variable name="detail11_listed_count">
                                        <xsl:for-each select="//Detail11">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail11)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail11_listed_count) > '0'">
                                        <xsl:variable name="detail11_form">
                                            <xsl:for-each select="//Detail11">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','11',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail11_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail11_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail11_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                     <!-- Detail12(start) -->
                                    <xsl:variable name="detail12_listed_count">
                                        <xsl:for-each select="//Detail12">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail12)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail12_listed_count) > '0'">
                                        <xsl:variable name="detail12_form">
                                            <xsl:for-each select="//Detail12">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','12',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail12_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail12_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail12_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                     <!-- Detail10(start) -->
                                    <xsl:variable name="detail13_listed_count">
                                        <xsl:for-each select="//Detail13">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail13)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail13_listed_count) > '0'">
                                        <xsl:variable name="detail13_form">
                                            <xsl:for-each select="//Detail13">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','13',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail13_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail13_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail13_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                     <!-- Detail14(start) -->
                                    <xsl:variable name="detail14_listed_count">
                                        <xsl:for-each select="//Detail14">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail14)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail14_listed_count) > '0'">
                                        <xsl:variable name="detail14_form">
                                            <xsl:for-each select="//Detail14">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','14',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail14_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail14_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail14_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                     <!-- Detail15(start) -->
                                        <xsl:variable name="detail15_listed_count">
                                            <xsl:for-each select="//Detail15">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail15)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail15_listed_count) > '0'">
                                            <xsl:variable name="detail15_form">
                                                <xsl:for-each select="//Detail15">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','15',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail15_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail15_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail15_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail15(end) -->
                                        <!-- Detail16(start) -->
                                        <xsl:variable name="detail16_listed_count">
                                            <xsl:for-each select="//Detail16">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail16)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail16_listed_count) > '0'">
                                            <xsl:variable name="detail16_form">
                                                <xsl:for-each select="//Detail16">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','16',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail16_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail16_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail16_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail16(end) -->
                                        <!-- Detail17(start) -->
                                        <xsl:variable name="detail17_listed_count">
                                            <xsl:for-each select="//Detail17">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail17)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail17_listed_count) > '0'">
                                            <xsl:variable name="detail17_form">
                                                <xsl:for-each select="//Detail17">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','17',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail17_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail17_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail17_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail17(end) -->
                                        <!-- Detail18(start) -->
                                        <xsl:variable name="detail18_listed_count">
                                            <xsl:for-each select="//Detail18">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail18)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail18_listed_count) > '0'">
                                            <xsl:variable name="detail18_form">
                                                <xsl:for-each select="//Detail18">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','18',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail18_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail18_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail18_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail18(end) -->
                                        <!-- Detail19(start) -->
                                        <xsl:variable name="detail19_listed_count">
                                            <xsl:for-each select="//Detail19">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail19)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail19_listed_count) > '0'">
                                            <xsl:variable name="detail19_form">
                                                <xsl:for-each select="//Detail19">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','19',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail19_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail19_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail19_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail19(end) -->
                                        <!-- Detail20(start) -->
                                        <xsl:variable name="detail20_listed_count">
                                            <xsl:for-each select="//Detail20">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail20)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail20_listed_count) > '0'">
                                            <xsl:variable name="detail20_form">
                                                <xsl:for-each select="//Detail20">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','20',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail20_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail20_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail20_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail20(end) -->
                                        <!-- Detail21(start) -->
                                        <xsl:variable name="detail21_listed_count">
                                            <xsl:for-each select="//Detail21">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail21)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail21_listed_count) > '0'">
                                            <xsl:variable name="detail21_form">
                                                <xsl:for-each select="//Detail21">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','21',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail21_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail21_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail21_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail21(end) -->
                                        <!-- Detail22(start) -->
                                        <xsl:variable name="detail22_listed_count">
                                            <xsl:for-each select="//Detail22">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail22)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail22_listed_count) > '0'">
                                            <xsl:variable name="detail22_form">
                                                <xsl:for-each select="//Detail22">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','22',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail22_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail22_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail22_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail22(end) -->
                                        <!-- Detail23(start) -->
                                        <xsl:variable name="detail23_listed_count">
                                            <xsl:for-each select="//Detail23">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail23)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail23_listed_count) > '0'">
                                            <xsl:variable name="detail23_form">
                                                <xsl:for-each select="//Detail23">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','23',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail23_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail23_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail23_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail23(end) -->
                                        <!-- Detail24(start) -->
                                        <xsl:variable name="detail24_listed_count">
                                            <xsl:for-each select="//Detail24">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail24)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail24_listed_count) > '0'">
                                            <xsl:variable name="detail24_form">
                                                <xsl:for-each select="//Detail24">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','24',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail24_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail24_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail24_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail24(end) -->
                                        <!-- Detail25(start) -->
                                        <xsl:variable name="detail25_listed_count">
                                            <xsl:for-each select="//Detail25">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail25)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail25_listed_count) > '0'">
                                            <xsl:variable name="detail25_form">
                                                <xsl:for-each select="//Detail25">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','25',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail25_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail25_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail25_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail25(end) -->
                                        <!-- Detail26(start) -->
                                        <xsl:variable name="detail26_listed_count">
                                            <xsl:for-each select="//Detail26">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail26)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail26_listed_count) > '0'">
                                            <xsl:variable name="detail26_form">
                                                <xsl:for-each select="//Detail26">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','26',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                             
                                            <xsl:variable name="detail26_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail26_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail26_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail26(end) -->
                                        <!-- Detail27(start) -->
                                        <xsl:variable name="detail27_listed_count">
                                            <xsl:for-each select="//Detail27">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail27)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail27_listed_count) > '0'">
                                            <xsl:variable name="detail27_form">
                                                <xsl:for-each select="//Detail27">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','27',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail27_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail27_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail27_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail27(end) -->
                                        <!-- Detail28(start) -->
                                        <xsl:variable name="detail28_listed_count">
                                            <xsl:for-each select="//Detail28">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail28)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail28_listed_count) > '0'">
                                            <xsl:variable name="detail28_form">
                                                <xsl:for-each select="//Detail28">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','28',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail28_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail28_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail28_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail28(end) -->
                                        <!-- Detail29(start) -->
                                        <xsl:variable name="detail29_listed_count">
                                            <xsl:for-each select="//Detail29">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail29)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail29_listed_count) > '0'">
                                            <xsl:variable name="detail29_form">
                                                <xsl:for-each select="//Detail29">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','29',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail29_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail29_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail29_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail29(end) -->
                                        <!-- Detail30(start) -->
                                        <xsl:variable name="detail30_listed_count">
                                            <xsl:for-each select="//Detail30">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail30)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail30_listed_count) > '0'">
                                            <xsl:variable name="detail30_form">
                                                <xsl:for-each select="//Detail30">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','30',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail30_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail30_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail30_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail30(end) -->
                                    
                                    <!-- Added by Prasad on 11/08/2021 [to display non-visited customers] START -->
									<div id="section-n1-not-visited"></div>
									<!-- Added by Prasad on 11/08/2021 [to display non-visited customers] END -->
                                    
                                </section>

                                <!--Feed View - End-->
                                <!--Table View Template Start-->

                                <section id="section-n2">
                                    <!-- Detail2(start) -->
                                    <xsl:variable name="detail2_listed_count">
                                        <xsl:for-each select="//Detail2">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail2)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail2_listed_count) > '0'">
                                        <xsl:variable name="detail2_form">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','2',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail2_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail2_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail2_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail2(end) -->
                                    <!-- Detail3(start) -->
                                    <xsl:variable name="detail3_listed_count">
                                        <xsl:for-each select="//Detail3">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail3)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail3_listed_count) > '0'">
                                        <xsl:variable name="detail3_form">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','3',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail3_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail3_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail3_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail3(end) -->
                                    <!-- Detail4(start) -->
                                    <xsl:variable name="detail4_listed_count">
                                        <xsl:for-each select="//Detail4">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail4)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail4_listed_count) > '0'">
                                        <xsl:variable name="detail4_form">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','4',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail4_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail4_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail4_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail4(end) -->
                                    <!-- Detail5(start) -->
                                    <xsl:variable name="detail5_listed_count">
                                        <xsl:for-each select="//Detail5">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail5)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail5_listed_count) > '0'">
                                        <xsl:variable name="detail5_form">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','5',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail5_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail5_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail5_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail5(end) -->
                                    <!-- Detail6(start) -->
                                    <xsl:variable name="detail6_listed_count">
                                        <xsl:for-each select="//Detail6">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail6)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail6_listed_count) > '0'">
                                        <xsl:variable name="detail6_form">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','6',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail6_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail6_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail6_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail6(end) -->
                                    <!-- Detail7(start) -->
                                    <xsl:variable name="detail7_listed_count">
                                        <xsl:for-each select="//Detail7">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail7)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail7_listed_count) > '0'">
                                        <xsl:variable name="detail7_form">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','7',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail7_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail7_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail7_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail7(end) -->
                                    <!-- Detail8(start) -->
                                    <xsl:variable name="detail8_listed_count">
                                        <xsl:for-each select="//Detail8">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail8)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail8_listed_count) > '0'">
                                        <xsl:variable name="detail8_form">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','8',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail8_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail8_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail8_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail8(end) -->
                                    <!-- Detail9(start) -->
                                    <xsl:variable name="detail9_listed_count">
                                        <xsl:for-each select="//Detail9">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail9)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail9_listed_count) > '0'">
                                        <xsl:variable name="detail9_form">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','9',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail9_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail9_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail9_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail9(end) -->
                                    <!-- Detail10(start) -->
                                    <xsl:variable name="detail10_listed_count">
                                        <xsl:for-each select="//Detail10">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail10)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail10_listed_count) > '0'">
                                        <xsl:variable name="detail10_form">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','10',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail10_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail10_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail10_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                    
                                    
                                     <!-- Detail11(start) -->
                                    <xsl:variable name="detail11_listed_count">
                                        <xsl:for-each select="//Detail11">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail11)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail11_listed_count) > '0'">
                                        <xsl:variable name="detail11_form">
                                            <xsl:for-each select="//Detail11">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','11',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail11_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail11_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail11_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                     <!-- Detail12(start) -->
                                    <xsl:variable name="detail12_listed_count">
                                        <xsl:for-each select="//Detail12">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail12)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail12_listed_count) > '0'">
                                        <xsl:variable name="detail12_form">
                                            <xsl:for-each select="//Detail12">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','12',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail12_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail12_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail12_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    
                                     <!-- Detail13(start) -->
                                    <xsl:variable name="detail13_listed_count">
                                        <xsl:for-each select="//Detail13">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail13)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail13_listed_count) > '0'">
                                        <xsl:variable name="detail13_form">
                                            <xsl:for-each select="//Detail13">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','13',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail13_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail13_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail13_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                                                        
                                    
                                    <!-- Detail14(start) -->
                                        <xsl:variable name="detail14_listed_count">
                                            <xsl:for-each select="//Detail14">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail14)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail14_listed_count) > '0'">
                                            <xsl:variable name="detail14_form">
                                                <xsl:for-each select="//Detail14">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','14',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail14_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail14_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail14_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail14(end) -->
                                        <!-- Detail15(start) -->
                                        <xsl:variable name="detail15_listed_count">
                                            <xsl:for-each select="//Detail15">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail15)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail15_listed_count) > '0'">
                                            <xsl:variable name="detail15_form">
                                                <xsl:for-each select="//Detail15">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','15',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail15_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail15_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail15_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail15(end) -->
                                        <!-- Detail16(start) -->
                                        <xsl:variable name="detail16_listed_count">
                                            <xsl:for-each select="//Detail16">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail16)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail16_listed_count) > '0'">
                                            <xsl:variable name="detail16_form">
                                                <xsl:for-each select="//Detail16">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','16',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail16_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail16_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail16_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail16(end) -->
                                        <!-- Detail17(start) -->
                                        <xsl:variable name="detail17_listed_count">
                                            <xsl:for-each select="//Detail17">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail17)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail17_listed_count) > '0'">
                                            <xsl:variable name="detail17_form">
                                                <xsl:for-each select="//Detail17">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','17',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail17_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail17_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail17_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail17(end) -->
                                        <!-- Detail18(start) -->
                                        <xsl:variable name="detail18_listed_count">
                                            <xsl:for-each select="//Detail18">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail18)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail18_listed_count) > '0'">
                                            <xsl:variable name="detail18_form">
                                                <xsl:for-each select="//Detail18">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','18',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail18_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail18_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail18_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail18(end) -->
                                        <!-- Detail19(start) -->
                                        <xsl:variable name="detail19_listed_count">
                                            <xsl:for-each select="//Detail19">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail19)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail19_listed_count) > '0'">
                                            <xsl:variable name="detail19_form">
                                                <xsl:for-each select="//Detail19">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','19',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail19_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail19_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail19_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail19(end) -->
                                        <!-- Detail20(start) -->
                                        <xsl:variable name="detail20_listed_count">
                                            <xsl:for-each select="//Detail20">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail20)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail20_listed_count) > '0'">
                                            <xsl:variable name="detail20_form">
                                                <xsl:for-each select="//Detail20">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','20',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail20_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail20_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail20_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail20(end) -->
                                        <!-- Detail21(start) -->
                                        <xsl:variable name="detail21_listed_count">
                                            <xsl:for-each select="//Detail21">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail21)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail21_listed_count) > '0'">
                                            <xsl:variable name="detail21_form">
                                                <xsl:for-each select="//Detail21">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','21',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail21_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail21_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail21_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail21(end) -->
                                        <!-- Detail22(start) -->
                                        <xsl:variable name="detail22_listed_count">
                                            <xsl:for-each select="//Detail22">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail22)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail22_listed_count) > '0'">
                                            <xsl:variable name="detail22_form">
                                                <xsl:for-each select="//Detail22">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','22',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail22_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail22_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail22_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail22(end) -->
                                        <!-- Detail23(start) -->
                                        <xsl:variable name="detail23_listed_count">
                                            <xsl:for-each select="//Detail23">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail23)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail23_listed_count) > '0'">
                                            <xsl:variable name="detail23_form">
                                                <xsl:for-each select="//Detail23">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','23',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail23_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail23_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail23_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail23(end) -->
                                        <!-- Detail24(start) -->
                                        <xsl:variable name="detail24_listed_count">
                                            <xsl:for-each select="//Detail24">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail24)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail24_listed_count) > '0'">
                                            <xsl:variable name="detail24_form">
                                                <xsl:for-each select="//Detail24">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','24',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail24_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail24_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail24_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail24(end) -->
                                        <!-- Detail25(start) -->
                                        <xsl:variable name="detail25_listed_count">
                                            <xsl:for-each select="//Detail25">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail25)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail25_listed_count) > '0'">
                                            <xsl:variable name="detail25_form">
                                                <xsl:for-each select="//Detail25">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','25',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail25_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail25_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail25_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail25(end) -->
                                        <!-- Detail26(start) -->
                                        <xsl:variable name="detail26_listed_count">
                                            <xsl:for-each select="//Detail26">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail26)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail26_listed_count) > '0'">
                                            <xsl:variable name="detail26_form">
                                                <xsl:for-each select="//Detail26">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','26',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail26_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail26_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail26_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail26(end) -->
                                        <!-- Detail27(start) -->
                                        <xsl:variable name="detail27_listed_count">
                                            <xsl:for-each select="//Detail27">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail27)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail27_listed_count) > '0'">
                                            <xsl:variable name="detail27_form">
                                                <xsl:for-each select="//Detail27">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','27',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail27_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail27_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail27_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail27(end) -->
                                        <!-- Detail28(start) -->
                                        <xsl:variable name="detail28_listed_count">
                                            <xsl:for-each select="//Detail28">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail28)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail28_listed_count) > '0'">
                                            <xsl:variable name="detail28_form">
                                                <xsl:for-each select="//Detail28">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','28',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail28_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail28_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail28_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail28(end) -->
                                        <!-- Detail29(start) -->
                                        <xsl:variable name="detail29_listed_count">
                                            <xsl:for-each select="//Detail29">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail29)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail29_listed_count) > '0'">
                                            <xsl:variable name="detail29_form">
                                                <xsl:for-each select="//Detail29">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','29',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail29_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail29_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail29_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail29(end) -->
                                        <!-- Detail30(start) -->
                                        <xsl:variable name="detail30_listed_count">
                                            <xsl:for-each select="//Detail30">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail30)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if
                                            test="normalize-space($detail30_listed_count) > '0'">
                                            <xsl:variable name="detail30_form">
                                                <xsl:for-each select="//Detail30">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','30',',')" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:variable name="detail30_form_name">
                                                <xsl:value-of
                                                    select="substring-before($detail30_form,',')" />
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit"
                                                    select="$detail30_form_name" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail30(end) -->
                                    
                                    
                                    <!-- Added by Prasad on 11/08/2021 [to display non-visited customers] START -->
									<div id="section-n2-not-visited"></div>
									<!-- Added by Prasad on 11/08/2021 [to display non-visited customers] END -->
                                    
                                </section>
                                <!--Table View - End-->
                            </div>
                        </div>

							<!--<div class="headerTablediv headerTable1">

								<xsl:for-each select="//Detail1">
									<div>
										<div
											style="display: inline-block;width: 100%;padding: .5em;">
											<div
												style="height: auto;float: left;width: 36px;display: block;">
												<div class="vision-ui-action_realtime_report"
													style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
											</div>
											<div style="width: calc(100% - 36px);float: right;">
												<div style="float: left; color: black; width:100%;"
													class="normalFont tdLeft">Last DCR Date :</div>
												<div style="float: left; white-space: normal;color:#666"
													class="normalFont tdLeft">
													<xsl:value-of select="last_dcr_date" />
												</div>
											</div>
										</div>

									</div>
									<div>
										<div
											style="display: inline-block;width: 100%;padding: .5em;">
											<div
												style="height: auto; float: left; width: 40px; background: :gray;">
												<div class="vision-ui-location"
													style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
											</div>
											<div style="width: calc(100% - 40px); float: right;">
												<div style="float: left; color: black; width:100%;"
													class="normalFont tdLeft">Last Place of Work :</div>
												<div style="float: left; white-space: normal;color:#666"
													class="normalFont tdLeft">
													<xsl:value-of select="sprs_route_descr" />
												</div>
											</div>
										</div>

									</div>
									<div>
										<div
											style="display: inline-block;width: 100%;padding: .5em;">
											<div
												style="height: auto;float: left;width: 36px;display: block;">
												<div class="vision-ui-message"
													style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
											</div>
											<div style="width: calc(100% - 36px);float: right;">
												<div style="float: left; color: black; width:100%;"
													class="normalFont tdLeft">General Remarks :</div>
												<div style="float: left; white-space: normal;color:#666"
													class="normalFont tdLeft">
													<xsl:value-of select="remark" />
												</div>
											</div>
										</div>

									</div>
								</xsl:for-each>
							</div>-->

							<!-- Detail10(end) -->

                        <div width="40%" id="attachmentUpload"
                            class="attachmentUpload" style="display: none;">
                            <table width="100%" height="100%">
                                <tr height="10%" width="100%">
                                    <td>
                                        <div class="close" onclick="closeMe('attachmentUpload');">x</div>
                                        <div width="100%">
                                            <div
                                                style="width:100%;float:right;border-bottom: #e5e4e9 1px solid;PADDING-BOTTOM: 5PX;">
                                                <input type="button" class="buttonZoomIN"
                                                    style="float:right;" value="+" id="zoomInBtn"
                                                    onclick="zoomImage('+')" />
                                                <input type="button" class="buttonZoomOUT"
                                                    style="float:right;" value="(-)" id="zoomOutBtn"
                                                    onclick="zoomImage('-')" />
                                            </div>
                                        </div>
                                    </td>
                                </tr>

                                <tr height="89%" width="100%">
                                    <td>
                                        <div id="uploadContent"
                                            style="height: 100%; width: 100%; overflow:auto;background:white; margin:0 auto;">
                                            <img id="targetImg"
                                                style="max-height: 100%; max-width:100%;" src=""
                                                setMinSize="false" setSize="false" oHeight="" oWidth=""></img>
                                        </div>
                                    </td>
                                </tr>
                                <tr height="1%" width="100%">
                                    <td>

                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div id="overlay"></div>

					</div>

				</form>
                <!--Changes by Jatin M on 15-MAR-2021 for Summary Look and Feel -  End-->
                
                <!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] START -->
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" onload = "getNonVisitedRoute();" />
				<!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] END -->
			</body>

		</html>
	</xsl:template>
        
    <xsl:template name="tmpSplitString">
        <xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>

		<xsl:variable name="last_locality_descr">
			<xsl:value-of select="//Detail1/sprs_route_descr" />
		</xsl:variable>



<xsl:if test="normalize-space($form_name) = 'activity'">
			<!--<details open="true">-->
            <xsl:variable name="activity_code">
				<xsl:value-of select="count(//node()[starts-with(name(), $detail)])" />
			</xsl:variable>

            <div class="headerdata datafontsize"><xsl:value-of
                select="normalize-space($activity_code)" /> Activity Details
            </div>
            <div class="containertable">
                <div class="doctorcontainer datafontsize">

                    <div class="doctordetails textcolor ">
                    	 <div class="left-spacing seperatorDiv headerfontsize"> Activity </div>	
                    	<div class="center-spacing seperatorDiv headerfontsize"> Time From </div>
                    	<div class="right-spacing seperatorDiv headerfontsize"> Time To </div>
                    </div>

                    <xsl:for-each
                        select="//node()[starts-with(name(), $detail)]">
                        
			             <xsl:if test="attribute/@updateFlag!='D'">
                      	  <xsl:variable name="activity_descr">
                            <xsl:value-of select="activity_descr" />
                       	 </xsl:variable>
                      	  <xsl:variable name="visit_time_fr">
                            <xsl:value-of select="visit_time_fr" />
                     	   </xsl:variable>
                       	 <xsl:variable name="visit_time_to">
                      	      <xsl:value-of select="visit_time_to" />
                       	 </xsl:variable>
                       
                  
                            <div class="sampledata datafontsize">
                                <div class="left-spacing detailswidth firstcolumn hideoverflow">
                                    <xsl:value-of select="$activity_descr" />
                                </div>
                                <div class="detailswidth center-spacing">
                                    <xsl:value-of select="$visit_time_fr" />
                                </div>
                                <div class="detailswidth lastcolumn right-spacing">
                                    <xsl:value-of select="$visit_time_to" />
                                </div>
                            </div>                                 
                   		 </xsl:if>  
                        
                    </xsl:for-each>
                </div>
            </div>
			<!--</details>-->
		</xsl:if>
		

        <!--Changes by Jatin M on 15/MAR/2021 for Summary Look and Feel - Table View - Start-->
		<xsl:if test="normalize-space($form_name) = 'place'">
			<!--<details open="true">
				<summary class="summary" style="text-align: left;">Place Details</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<TR>
							<TH CLASS="cellttl1 cellttlblck heading firstData tdLeft">Emp Place Of Work</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData">Place Of Work</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData">Journey From</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData">Travel Mode</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData tdRight">Order Of Visit</TH>
						</TR>
					</thead>-->
            <xsl:variable name="visit_no">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)])" />
            </xsl:variable>
                
            <div class="headerdata datafontsize">
                <xsl:value-of
                select="normalize-space($visit_no)" /> Places Visited
            </div>
            <div class="containertable">
                <div class="doctorcontainer datafontsize">

                    <div class="doctordetails headerfontsize">
                        <div  class="emp-name seperatorDiv headerfontsize">EMPLOYEE NAME</div>
                        <div class="journeyfrommgr seperatorDiv headerfontsize">JOURNEY FROM</div>
                        <div  class="placeofvisitmgr seperatorDiv headerfontsize">PLACE OF VISIT</div>
                        <div class="travelmodemgr seperatorDiv headerfontsize">TRAVEL MODE</div>
                        <div class="orderofvisitmgr seperatorDiv headerfontsize">ORDER OF VISIT</div>
                    </div>

                    <xsl:for-each
                        select="//node()[starts-with(name(), $detail)]">
                        <xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="sl_no">
                                <xsl:value-of select="sl_no" />
                            </xsl:variable>
                            <xsl:variable name="sprs_route_descr">
                                <xsl:value-of select="sprs_route_descr" />
                            </xsl:variable>
                            <xsl:variable name="travel_mode">
                                <xsl:value-of select="travel_mode_descr" />
                            </xsl:variable>
                            <xsl:variable name="order_of_visit">
                                <xsl:value-of select="order_of_visit" />
                            </xsl:variable>
                            <xsl:variable name="station_descr">
                                <xsl:value-of select="station_descr" />
                            </xsl:variable>
                            <xsl:variable name="prv_order_of_visit">
                                <xsl:value-of select="$order_of_visit - 1" />
                            </xsl:variable>


                            <!--<TR>-->
                            <div class="visitsdetails datafontsize">

                                <div class="emp-name">
                                    <xsl:value-of select="concat('','',sprs_ww__name)" />                         
                                </div>

                                <div class="journeyfrommgr">
                                    <xsl:if test="normalize-space($order_of_visit) = '1'">
                                        <xsl:value-of select="$last_locality_descr" />
                                    </xsl:if>
                                    <xsl:if test="normalize-space($order_of_visit) != '1'">
                                        <xsl:for-each
                                            select="//node()[starts-with(name(), $detail)]">
                                            <xsl:variable name="current_order_visit">
                                                <xsl:value-of select="order_of_visit" />
                                            </xsl:variable>
                                            <xsl:variable name="prv_route_descr">
                                                <xsl:value-of select="sprs_route_descr" />
                                            </xsl:variable>

                                            <xsl:if
                                                test="normalize-space($current_order_visit) = normalize-space($prv_order_of_visit)">
                                                <xsl:value-of select="$prv_route_descr" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:if>
                                </div>

                                <div class="placeofvisitmgr">
                                    <xsl:value-of select="$sprs_route_descr" />
                                </div>

                                <div class="travelmodemgr">
                                    by <xsl:value-of select="$travel_mode" />
                                </div>

                                <!--<TD CLASS="cellttl1 tdLeft title ">-->
                                <div  class="orderofvisitmgr">
                                    <xsl:value-of select="$order_of_visit" />
                                </div>                              

                                <!--</TD>-->
                                

                                <!--<TD CLASS="cellttl1 tdCenter title  ">
                                    <xsl:value-of select="$sprs_route_descr" />

                                </TD>
                                <TD CLASS="cellttl1 tdCenter title  ">
                                    <xsl:if test="normalize-space($order_of_visit) = '1'">
                                        <xsl:value-of select="$last_locality_descr" />
                                    </xsl:if>
                                    <xsl:if test="normalize-space($order_of_visit) != '1'">
                                        <xsl:for-each
                                            select="//node()[starts-with(name(), $detail)]">
                                            <xsl:variable name="current_order_visit">
                                                <xsl:value-of select="order_of_visit" />
                                            </xsl:variable>
                                            <xsl:variable name="prv_route_descr">
                                                <xsl:value-of select="sprs_route_descr" />
                                            </xsl:variable>

                                            <xsl:if
                                                test="normalize-space($current_order_visit) = normalize-space($prv_order_of_visit)">
                                                <xsl:value-of select="$prv_route_descr" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:if>

                                </TD>
                                <TD CLASS="cellttl1 tdCenter title">
                                    <xsl:value-of select="$travel_mode" />
                                </TD>
                                <TD CLASS="cellttl1 tdRight title ">
                                    <xsl:value-of select="$order_of_visit" />
                                </TD>
                            </TR>-->
                            </div>
                        </xsl:if>

                    </xsl:for-each>
                </div>
            </div>
				<!--</TABLE>
			</details>-->
		</xsl:if>

        <xsl:variable name="host_url">
            <xsl:for-each select="//Detail1">
                <xsl:if test="attribute/@updateFlag!='D'">
                    <xsl:value-of select="host_url" />
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>

		<xsl:if test="normalize-space($form_name) = 'doctor'">

			<xsl:variable name="doc_listed_cnt">
			    <xsl:value-of
				    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type,'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="unlisted_cnt">
			<xsl:value-of
				select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
		    </xsl:variable>

			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">

                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">-->
                <div class="headerdata datafontsize">
                    <xsl:value-of
                        select="normalize-space($doc_listed_cnt)" />
                    Doctor's (Call List)
                </div>
				<!--</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
                <div class="containertable">
                    <div class="doctorcontainer"><!-- container starts -->
                            <div class="headerfontsize doctordetails textcolor">
                                <div class="headingwidth firstcolumn docname">DOCTOR NAME</div>
                                <div class="headingwidth class">CLASS</div>
                                <div class="headingwidth speciality">SPECIALITY</div>                           
                                <div class="headingwidth placeofwork">PLACE OF WORK</div>
                                <div class="headingwidth visitplan">VISIT PLAN</div>
                                <div class="headingwidth visitwith">VISITED WITH</div>
                                <div class="headingwidth timeofcall">VISITED TIME</div>
                                <div class="headingwidth pobvalue">POB VALUE</div>
                                <div class="remarks headingwidth lastcolumn">REMARKS</div>
                            </div>

                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:sort select="substring-after(event_time_start, ' ')" />
                            <xsl:sort
                                select="substring-before(event_time_start,':') mod 12"
                                data-type="number" />
                            <xsl:sort
                                select="substring-before(substring-after(event_time_start,':'), ' ')"
                                data-type="number" />

                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable>
                                <!-- <xsl:if test="normalize-space($customer_type) = 'Doctors'"> -->

                                    <xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->

                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
                                        <xsl:value-of select="contact_pers_name" />
                                    </xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrder">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
				<!--</TABLE>
			</details>-->
			</xsl:if>


			<xsl:if test="normalize-space($unlisted_cnt) > '0'">
				<!--<details open="true">
					<summary class="summary" style="text-align: left;">Doctor's Details (Not From Call List)</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <xsl:value-of
                        select="normalize-space($unlisted_cnt)" />
                    Doctor's (Unlisted)
                </div>
				<xsl:variable name="is_member_presents">
                    <xsl:for-each
                        select="//node()[starts-with(name(), $detail)]">
                            <xsl:variable name="customer_types">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <xsl:if test="(contains($customer_types, 'UNLISTED'))">
					            <xsl:value-of select="is_member_present" />
                            </xsl:if>
                    </xsl:for-each>
				</xsl:variable>
                <div class="containertable">
                    <div class="doctorcontainer"><!-- container starts -->
                        <div class="doctordetails headerfontsize">
                            <div  class="firstcolumn headingwidth unlistedcust">
                            	<xsl:choose>
		                            <xsl:when test="$is_member_presents = 'Y'">
		                                NO OF DOCTOR
		                            </xsl:when>
		                            <xsl:otherwise>
		                                CUSTOMER NAME
		                            </xsl:otherwise>
		                        </xsl:choose>
                            </div>
                            <div class="headingwidth visitwith">VISITED WITH</div>
                            <div class=" headingwidth timeofcall">TIME OF FIRST CALL</div>
                            <div  class="headingwidth timeofcall">TIME OF LAST CALL</div>
                            <div  class="headingwidth pobvalue">POB VALUE</div>
                            <div  class="lastcolumn headingwidth remarks">REMARKS</div>
                        </div>

                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">

                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable>
                                <!-- <xsl:if
                                    test="normalize-space($customer_type) = 'UNLISTED-DOCTOR'"> -->

                                <xsl:if test="(contains($customer_type, 'UNLISTED'))">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                        
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>

                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
                                        <xsl:value-of select="contact_pers_name" />
                                    </xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrder">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
		</xsl:if>

        <xsl:if test="normalize-space($form_name) = 'retailer'">

        <xsl:variable name="chem_listed_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type, 'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="chem_unlisted_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
            </xsl:variable>

            <xsl:if test="normalize-space($chem_listed_cnt) > '0'">
                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">Chemist's Call Details - (
                        <xsl:value-of
                            select="normalize-space($chem_listed_cnt)" />
                        )</summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize"> 
                    <xsl:value-of
                        select="normalize-space($chem_listed_cnt)" />
                    Chemist's (Call List)
                </div>
                <div class="containertable">
                    <div class ="doctorcontainer">
                        <div class="doctordetails headerfontsize">
                            <div  class="firstcolumn headingwidth docname">CHEMIST NAME</div>
                            <div class=" headingwidth placeofwork">PLACE OF WORK</div>
                            <div class="headingwidth visitwith">VISITED WITH</div>
                            <div  class="headingwidth timeofcall">VISITED TIME</div>
                            <div  class="headingwidth pobvalue">POB VALUE</div>
                            <div  class="lastcolumn headingwidth remarks"> REMARKS</div>
                        </div>

                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable>
                                <!-- 	<xsl:if
                                        test="normalize-space($customer_type) = 'Chemist'"> -->
                                        <xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                <xsl:variable name="strg_name">
                                    <xsl:value-of select="strg_name" />
                                </xsl:variable>
                                <xsl:variable name="strg_code">
                                    <xsl:value-of select="strg_code" />
                                </xsl:variable>
                                <xsl:variable name="order_form_no">
                                    <xsl:value-of select="order_form_no" />
                                </xsl:variable>
                                <xsl:variable name="locality_descr">
                                    <xsl:value-of select="locality_descr" />
                                </xsl:variable>
                                <xsl:variable name="call_outcome">
                                    <xsl:value-of select="meeting_status" />
                                </xsl:variable>
                                <xsl:variable name="domID">
                                    <xsl:value-of select="@domID" />
                                </xsl:variable>
                                <!-- <xsl:variable name="host_url">
                                    <xsl:value-of select="host_url" />
                                </xsl:variable> -->
                                <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                    select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                    /> </xsl:call-template> -->
                                <xsl:variable name="visited_with_team">
                                    <xsl:value-of select="visited_with_display" />
                                </xsl:variable>
                                <xsl:variable name="team_form_no">
                                    <xsl:value-of select="team_form_no" />
                                </xsl:variable>
                                <xsl:variable name="class_code_descr">
                                    <xsl:value-of select="class_code_descr" />
                                </xsl:variable>

                                <xsl:variable name="speciality_descr">
                                    <xsl:value-of select="speciality_descr" />
                                </xsl:variable>
                                <xsl:variable name="no_visit">
                                    <xsl:value-of select="strg_no_visit" />
                                </xsl:variable>
                                <xsl:variable name="event_time_start">
                                    <xsl:value-of select="event_time_start" />
                                </xsl:variable>
                                <xsl:variable name="event_time_end">
                                    <xsl:value-of select="event_time_end" />
                                </xsl:variable>
                                <xsl:variable name="pob_val">
                                    <xsl:value-of select="sku_value" />
                                </xsl:variable>
                                <xsl:variable name="is_member_present">
                                    <xsl:value-of select="is_member_present" />
                                </xsl:variable>
                                <!--<xsl:variable name="meet_summ">
                                    <xsl:value-of select="concat(meet_summ,',')" />
                                </xsl:variable>-->
                                <xsl:variable name="meet_summ">
                                    <xsl:value-of select="remarks" />
                                </xsl:variable>
                                <!-- <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable> -->
                                <xsl:variable name="member_present">
                                    <xsl:value-of select="member_present" />
                                </xsl:variable>
                                <xsl:variable name="strg_type">
                                    <xsl:value-of select="strg_type" />
                                </xsl:variable>

                                <xsl:variable name="contact_pers">
                                    <xsl:value-of select="contact_pers" />
                                </xsl:variable>
                                <xsl:variable name="contact_pers_name">
                                    <xsl:value-of select="contact_pers_name" />
                                </xsl:variable>
                                <xsl:variable name="reg_no">
                                        <xsl:value-of select="reg_no" />
                                </xsl:variable>
                                <xsl:variable name="is_fortune_activity">
                                        <xsl:value-of select="is_fortune_activity" />
                                </xsl:variable>
                                <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                <xsl:call-template name="tmpOrder">
                                    <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
                    <!--</TABLE>
                </details>-->
            </xsl:if>

            <xsl:if test="normalize-space($chem_unlisted_cnt) > '0'">
                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">Chemist's Call Details (Not From Call List)</summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <xsl:value-of
                    select="normalize-space($chem_unlisted_cnt)" />
                    Chemist's (Unlisted)
                </div>
				<xsl:variable name="is_member_presents">
                    <xsl:for-each
                        select="//node()[starts-with(name(), $detail)]">
                            <xsl:variable name="customer_types">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <xsl:if test="(contains($customer_types, 'UNLISTED'))">
					            <xsl:value-of select="is_member_present" />
                            </xsl:if>
                    </xsl:for-each>
				</xsl:variable>
                <div class="containertable">
                    <div class="doctorcontainer"><!-- container starts -->
                        <div class="doctordetails headerfontsize">
                            <div  class="firstcolumn headingwidth unlistedcust">
                            	<xsl:choose>
		                            <xsl:when test="$is_member_presents = 'Y'">
		                                NO OF CHEMIST
		                            </xsl:when>
		                            <xsl:otherwise>
		                                CUSTOMER NAME
		                            </xsl:otherwise>
		                        </xsl:choose>
                            </div>
                            <div class="headingwidth visitwith">VISITED WITH</div>
                            <div class=" headingwidth timeofcall">TIME OF FIRST CALL</div>
                            <div  class="headingwidth timeofcall">TIME OF LAST CALL</div>
                            <div  class="headingwidth pobvalue">POB VALUE</div>
                            <div  class="lastcolumn headingwidth remarks">REMARKS</div>
                        </div>

                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable>
                                    <!-- <xsl:if
                                        test="normalize-space($customer_type) = 'UNLISTED-CHEMIST'"> -->
                                <xsl:if test="(contains($customer_type, 'UNLISTED'))">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>

                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
              							<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrder">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
                    <!--</TABLE>
                </details>-->
            </xsl:if>


        </xsl:if>

		<!-- <xsl:variable name="sto_listed_cnt">
			<xsl:for-each
				select="//node()[starts-with(name(), $detail)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:variable name="customer_type">
						<xsl:value-of select="cust_type" />
					</xsl:variable>
					<xsl:if test="normalize-space($customer_type) = 'Stockist'">
						<xsl:value-of
							select="count(//node()[starts-with(name(), $detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable> -->
        <xsl:if test="normalize-space($form_name) = 'stockist'">

            <xsl:variable name="sto_listed_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type, 'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="sto_unlisted_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
            </xsl:variable>

            <xsl:if test="normalize-space($sto_listed_cnt) > '0'">

			<!--<details open="true">
				<summary class="summary" style="text-align: left;">
					Stockist Call Details - (
					<xsl:value-of
						select="normalize-space($sto_listed_cnt)" />
					)
				</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <xsl:value-of
						select="normalize-space($sto_listed_cnt)" />
                    Stockist's (Call List)
				</div>
                <div class="containertable">
                    <div class ="doctorcontainer">
                        <div class="doctordetails headerfontsize">
                            <div  class="firstcolumn headingwidth docname">STOCKIST NAME</div>
                            <div class=" headingwidth placeofwork">PLACE OF WORK</div>
                            <div class="headingwidth visitwith">VISITED WITH</div>
                            <div  class="headingwidth timeofcall">VISITED TIME</div>
                            <div  class="headingwidth pobvalue">POB VALUE</div>
                            <div  class="lastcolumn headingwidth remarks">REMARKS</div>
                        </div>


                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:sort select="substring-after(event_time_start, ' ')" />
                            <xsl:sort
                                select="substring-before(event_time_start,':') mod 12"
                                data-type="number" />
                            <xsl:sort
                                select="substring-before(substring-after(event_time_start,':'), ' ')"
                                data-type="number" />
                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable>
                                <!-- <xsl:if
                                    test="normalize-space($customer_type) = 'Stockist'"> -->
                                <xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
              							<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrder">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
				<!--</TABLE>
			</details>-->
            </xsl:if>

            <xsl:if test="normalize-space($sto_unlisted_cnt) > '0'">

			<!--<details open="true">
				<summary class="summary" style="text-align: left;">
					Stockist Call Details (Not From Call List)
				</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
				<xsl:variable name="is_member_presents">
                    <xsl:for-each
                        select="//node()[starts-with(name(), $detail)]">
                            <xsl:variable name="customer_types">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <xsl:if test="(contains($customer_types, 'UNLISTED'))">
					            <xsl:value-of select="is_member_present" />
                            </xsl:if>
                    </xsl:for-each>
				</xsl:variable>
                <div class="headerdata datafontsize">
                    <xsl:value-of
						select="normalize-space($sto_unlisted_cnt)" />
					Stockist's (Unlisted)
				</div>
                <div class="containertable">
                    <div class="doctorcontainer"><!-- container starts -->
                        <div class="doctordetails headerfontsize">
                            <div  class="firstcolumn headingwidth unlistedcust">
                            	<xsl:choose>
		                            <xsl:when test="$is_member_presents = 'Y'">
		                                NO OF STOCKIST
		                            </xsl:when>
		                            <xsl:otherwise>
		                                CUSTOMER NAME
		                            </xsl:otherwise>
		                        </xsl:choose>
                            </div>
                            <div class="headingwidth visitwith">VISITED WITH</div>
                            <div class=" headingwidth timeofcall">TIME OF FIRST CALL</div>
                            <div  class="headingwidth timeofcall">TIME OF LAST CALL</div>
                            <div  class="headingwidth pobvalue">POB VALUE</div>
                            <div  class="lastcolumn headingwidth remarks">REMARKS</div>
                        </div>

                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:sort select="substring-after(event_time_start, ' ')" />
                            <xsl:sort
                                select="substring-before(event_time_start,':') mod 12"
                                data-type="number" />
                            <xsl:sort
                                select="substring-before(substring-after(event_time_start,':'), ' ')"
                                data-type="number" />
                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable>
                                <!-- <xsl:if
                                    test="normalize-space($customer_type) = 'UNLISTED-STOCKIST'"> -->
                                <xsl:if test="(contains($customer_type, 'UNLISTED'))">

                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrder">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
				<!--</TABLE>
			</details>-->
            </xsl:if>
        </xsl:if>
        <!--Changes by Jatin M on 15/MAR/2021 for Summary Look and Feel - Table View - Ends-->
		 <xsl:if test="normalize-space($form_name) = 'ncw'">

            <xsl:variable name="ncw_listed_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type, 'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="ncw_unlisted_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
            </xsl:variable>

            <xsl:if test="normalize-space($ncw_listed_cnt) > '0'">

			<!--<details open="true">
				<summary class="summary" style="text-align: left;">
					Stockist Call Details - (
					<xsl:value-of
						select="normalize-space($sto_listed_cnt)" />
					)
				</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <xsl:value-of
						select="normalize-space($ncw_listed_cnt)" />
                    Other's (Call List)
				</div>
                <div class="containertable">
                    <div class ="doctorcontainer">
                    <!--<div class="doctordetails headerfontsize">
                        <div  class="firstcolumn headingwidth docname">OTHER NAME</div>
                        <div class=" headingwidth placeofwork">PLACE OF WORK</div>
                        <div class="headingwidth visitwith">VISITED WITH</div>
                        <div  class="headingwidth timeofcall">VISITED TIME</div>
                        <div  class="headingwidth pobvalue">POB VALUE</div>
                        <div  class="lastcolumn headingwidth remarks">REMARKS</div>
                    </div>-->

                    <div class="headerfontsize doctordetails textcolor">
                        <div class="headingwidth firstcolumn docname">OTHER NAME</div>                                              
                        <div class="headingwidth placeofwork">PLACE OF WORK</div>   
                        <div class="headingwidth activity">ACTIVITY</div>                       
                        <div class="headingwidth visitwith">VISITED WITH</div>
                        <div class="headingwidth timeofcall">VISITED TIME</div>
                          <div class="headingwidth pobvalue">POB VALUE</div> 
                        <div class="headingwidth meet-stat">MEETING STATUS</div>
                        <div class="headingwidth customer-types">CUSTOMER TYPE</div>
                        <div class="headingwidth euin-no">EUIN NO</div>                    
                        <div class="headingwidth reg-no">ARN NO</div>                                                                                       
                        <div class="headingwidth lastcolumn remarks">REMARKS</div>
                    </div>


                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:sort select="substring-after(event_time_start, ' ')" />
                            <xsl:sort
                                select="substring-before(event_time_start,':') mod 12"
                                data-type="number" />
                            <xsl:sort
                                select="substring-before(substring-after(event_time_start,':'), ' ')"
                                data-type="number" />
                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable>
                                <!-- <xsl:if
                                    test="normalize-space($customer_type) = 'Stockist'"> -->
                                <xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
              							<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>
                                    <xsl:variable name="event_type_descr">
                                         <xsl:value-of select="event_type_descr" />
                                    </xsl:variable> 
                                    <xsl:call-template name="tmpOrder">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%$',$dcr_group,'%%%%$',$customer_type,'$%%$',$event_type_descr)" />
                                    </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
				<!--</TABLE>
			</details>-->
            </xsl:if>

            <xsl:if test="normalize-space($ncw_unlisted_cnt) > '0'">

			<!--<details open="true">
				<summary class="summary" style="text-align: left;">
					Stockist Call Details (Not From Call List)
				</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <xsl:value-of
						select="normalize-space($ncw_unlisted_cnt)" />
					Other's (Unlisted)
				</div>
				<xsl:variable name="is_member_presents">
	                <xsl:for-each
	                    select="//node()[starts-with(name(), $detail)]">
	                        <xsl:variable name="customer_types">
	                            <xsl:value-of select="cust_type" />
	                        </xsl:variable>
	                        <xsl:if test="(contains($customer_types, 'UNLISTED'))">
	                            <xsl:value-of select="is_member_present" />
	                        </xsl:if>
	                </xsl:for-each>
	            </xsl:variable>
                <div class="containertable">
                    <div class="doctorcontainer"><!-- container starts -->
                        <div class="doctordetails headerfontsize">
                            <div  class="firstcolumn headingwidth unlistedcust">
	                        	<xsl:choose>
		                            <xsl:when test="$is_member_presents = 'Y'">
		                                NO OF CUSTOMER
		                            </xsl:when>
		                            <xsl:otherwise>
		                                CUSTOMER NAME
		                            </xsl:otherwise>
		                        </xsl:choose>
	                        </div>
                            <div class="headingwidth activity">ACTIVITY</div>                       
                            <div class="headingwidth visitwith">VISITED WITH</div>
                            <div class=" headingwidth timeofcall">TIME OF FIRST CALL</div>
                            <div  class="headingwidth timeofcall">TIME OF LAST CALL</div>
                            <div  class="headingwidth pobvalue">POB VALUE</div>
                            <div  class="headingwidth meet-stat">MEETING STATUS</div>
                            <div class="headingwidth customer-types">CUSTOMER TYPE</div>
                            <div  class="headingwidth euin-no">EUIN NO</div>
                            <div  class="headingwidth reg-no">ARN NO</div>
                            <div  class="lastcolumn headingwidth remarks">REMARKS</div>
                        </div>

                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:sort select="substring-after(event_time_start, ' ')" />
                            <xsl:sort
                                select="substring-before(event_time_start,':') mod 12"
                                data-type="number" />
                            <xsl:sort
                                select="substring-before(substring-after(event_time_start,':'), ' ')"
                                data-type="number" />
                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="customer_type">
                                    <xsl:value-of select="cust_type" />
                                </xsl:variable>
                                <!-- <xsl:if
                                    test="normalize-space($customer_type) = 'UNLISTED-STOCKIST'"> -->
                                <xsl:if test="(contains($customer_type, 'UNLISTED'))">

                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
    									<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>
 									<xsl:variable name="event_type_descr">
                                         <xsl:value-of select="event_type_descr" />
                                    </xsl:variable> 
                                    <xsl:call-template name="tmpOrder">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%$',$dcr_group,'%%%%$',$customer_type,'$%%$',$event_type_descr)" />
                                    </xsl:call-template>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
				<!--</TABLE>
			</details>-->
            </xsl:if>
        </xsl:if>
	</xsl:template>

	<xsl:template name="tmpOrder">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="ord_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_call_outcome">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="visited_team">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="tm_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="class_descr">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>

		<xsl:variable name="spl_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="no_visit">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="meet_summ">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="pob_val">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>

		<xsl:variable name="member_presents">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'][')" />
		</xsl:variable>

		<xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,']['),'####')" />
		</xsl:variable>

        <xsl:variable name="strg_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'####'),'$#')" />
		</xsl:variable>

        <xsl:variable name="is_member_presents">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'$#'),'||')" />
		</xsl:variable>

        <xsl:variable name="contact_pers">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'||'),'$%')" />
		</xsl:variable>
		
		<xsl:variable name="contact_pers_name">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),'$$%')" />
		</xsl:variable>
		<xsl:variable name="reg_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$$%'),'%%')" />
		</xsl:variable>
		<xsl:variable name="is_fortune_activity">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%'),'%%%$')" />
		</xsl:variable>

		<xsl:variable name="dcr_group">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%%$'),'%%%%$')" />
		</xsl:variable>
		<xsl:variable name="type_of_customer">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%%%$'),'$%%$')" />
		</xsl:variable> 
		<xsl:variable name="event_type_descr">
			<xsl:value-of
				select="substring-after($ord_value,'$%%$')" />
		</xsl:variable> 
		
		
		<xsl:variable name="upImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Up.svg')" />
		</xsl:variable>
		<xsl:variable name="downImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Down.svg')" />
		</xsl:variable>
        
		<xsl:variable name="ord_detail">
			<xsl:value-of select="concat('Detail',$ord_form_no)" />
		</xsl:variable>
		<xsl:variable name="team_detail">
			<xsl:value-of select="concat('Detail',$tm_form_no)" />
		</xsl:variable>
		<xsl:variable name="call_outcome_descr">
			<xsl:if test="normalize-space($doc_call_outcome) = '5' ">
				Supporter
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '6' ">
				Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '7' ">
				Non Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '0' ">
				Refused
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="ord_listed_count">
					<xsl:if test="normalize-space($ord_form_no)!=''">		
			<xsl:for-each
				select="//node()[starts-with(name(), $ord_detail)]">
				<xsl:if test="attribute/@updateFlag!='D'">

					<xsl:variable name="order_strg_code">
						<xsl:value-of select="strg_code" />
					</xsl:variable>
					<xsl:if
						test="normalize-space($order_strg_code) = normalize-space($doc_strg_code)">
						<xsl:value-of
							select="count(//node()[starts-with(name(), $ord_detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<!-- Item Details Start -->

		<xsl:variable name="item_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="item_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="item_detail">
			<xsl:value-of select="concat('Detail',$item_form_no)" />
		</xsl:variable>

		<xsl:variable name="item_listed_count">
			<xsl:if test="normalize-space($item_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $item_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="item_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($item_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $item_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<!-- Item Details End -->
<!-- Display Details Start -->

		<xsl:variable name="display_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="display_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="display_detail">
			<xsl:value-of select="concat('Detail',$display_form_no)" />
		</xsl:variable>

		<xsl:variable name="display_listed_count">
			<xsl:if test="normalize-space($display_form_no)!=''">

				<xsl:for-each
					select="//node()[starts-with(name(), $display_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="display_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($display_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $display_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<!-- Display Details end -->

		<xsl:variable name="team_listed_count">
			<xsl:if test="normalize-space($tm_form_no)!=''">

				<xsl:for-each
					select="//node()[starts-with(name(), $team_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="tm_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($tm_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $team_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="brand_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="brand_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="brand_detail">
			<xsl:value-of select="concat('Detail',$brand_form_no)" />
		</xsl:variable>

		<xsl:variable name="brand_listed_count">
			<xsl:if test="normalize-space($brand_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $brand_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="brand_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($brand_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $brand_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="coaching_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="coaching_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="coaching_detail">
			<xsl:value-of select="concat('Detail',$coaching_form_no)" />
		</xsl:variable>

		<xsl:variable name="coaching_listed_count">
			<xsl:if test="normalize-space($coaching_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $coaching_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="coaching_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($coaching_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $coaching_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
<!-- Survey Details Start -->

		<xsl:variable name="survey_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="survey_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="survey_detail">
			<xsl:value-of select="concat('Detail',$survey_form_no)" />
		</xsl:variable>

		<xsl:variable name="survey_listed_count">
			<xsl:if test="normalize-space($survey_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $survey_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="survey_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($survey_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $survey_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<!-- Survey Details end -->
        <!--Changes by Jatin M on 15/MAR/2021 for Summary Look and Feel - Table View - Start-->
		<xsl:choose>
			<xsl:when test="$item_listed_count > '0' or $brand_listed_count >'0' or $ord_listed_count >'0' or $survey_listed_count > '0' or $display_form_no > '0'">
                <div class="stickysubforms">
                    <div class=" datafontsize docdatadetails">
                            
                        <xsl:choose>
                            <xsl:when
                                test="contains($customer_types, 'UNLISTED')">
                                <xsl:if test="normalize-space($strg_type)='D' or normalize-space($strg_type)='S' or normalize-space($strg_type)='O' or normalize-space($dcr_group)='O' or normalize-space($strg_type)='C' 
                                        or normalize-space($doc_strg_code) = 'UR00000000' or normalize-space($doc_strg_code) = '0000000000'">
                                    <div  class="firstcolumn detailswidth unlistedcust">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </xsl:if>
                            </xsl:when>
							<xsl:otherwise>
                                <div class="detailswidth firstcolumn docname hideoverflow">
                                    <xsl:value-of
						    			select="concat($doc_strg_name,' ',' ')" />
					    			<!--<xsl:value-of
				    					select="concat($doc_strg_name,' ',$call_outcome_descr)" />-->
                                </div>
                            </xsl:otherwise>
                        </xsl:choose>
                        
                        <xsl:if
                            test="not(contains($customer_types, 'UNLISTED')) and normalize-space($strg_type) = 'D'">

                            <div class="detailswidth class hideoverflow">
                                <xsl:value-of select="$class_descr" />
                            </div>

                            <div class="detailswidth speciality hideoverflow">
                                <xsl:value-of select="$spl_description" />
                            </div>
                        </xsl:if>

                        <xsl:if test="normalize-space($doc_locality) != '' and not(contains($customer_types, 'UNLISTED'))">
                                    <div class="detailswidth placeofwork hideoverflow">
                                        <xsl:value-of select="$doc_locality" />
                                    </div>
                        </xsl:if>
                        
                        <xsl:if
                            test="not(contains($customer_types, 'UNLISTED')) and normalize-space($strg_type) = 'D'">

                            <div class="detailswidth visitplan">
                                <xsl:value-of select="$no_visit" />
                            </div>

                        </xsl:if>


                                <div class="detailswidth visitwith hideoverflow">
                                    <xsl:choose>
                                        <xsl:when test="$team_listed_count > '0'">
                                            <xsl:call-template name="tempTeamData">
                                                <xsl:with-param name="teamData"
                                                    select="concat($team_detail,'@',$doc_strg_code)" />
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>

                        <xsl:choose>
                            <xsl:when
                                    test="contains($customer_types, 'UNLISTED')">

                                <div class="detailswidth timeofcall">
                                    <xsl:value-of select="$event_time_start" />
                                </div>

                                <div class="detailswidth timeofcall">
                                    <xsl:value-of select="$event_time_end" />
                                </div>
                            </xsl:when>
                            <xsl:otherwise>
                                <div class="detailswidth timeofcall">
                                    <xsl:value-of select="$event_time_start" />
                                </div>
                            </xsl:otherwise>
                        </xsl:choose>

                        <div class="detailswidth pobvalue">
                            <xsl:value-of select="$pob_val" />
                        </div>

                        <xsl:if test="normalize-space($dcr_group)='O'">
							<div class="detailswidth meet-stat hideoverflow">
								<xsl:value-of select="$doc_call_outcome" />
							</div>
							<div class="detailswidth customer-types hideoverflow">
								<xsl:value-of select="$type_of_customer" />
							</div>
							 <xsl:if test="normalize-space($contact_pers) != '' ">
                               	<div class="detailswidth euin-no">
                                    <xsl:value-of select="concat($contact_pers_name,' (',$contact_pers,')')" />
                                </div>
                             </xsl:if>

							<div class="detailswidth reg-no hideoverflow">
								<xsl:value-of select="$reg_no" />
							</div>
						</xsl:if>

                        <div class="detailswidth lastcolumn remarks hideoverflow">
                            <xsl:value-of select="$meet_summ" />
                        </div>


                    </div>			
                                            <!--<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Remarks:
												<xsl:call-template name="meetTemp">
													<xsl:with-param name="stringtosplitRemark"
														select="$meet_summ" />
												</xsl:call-template>
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>-->
					<!-- //Changed by Pooja S on 29-JULY-2020 [Survey and Coaching related detail form implementation] Start -->
                    <xsl:call-template name="tempOrderData">
                        <xsl:with-param name="orderData"
                            select="concat($item_detail,'@',$doc_strg_code,'#',$item_listed_count,'{',$brand_listed_count,'}',$brand_detail,'***',$coaching_listed_count,'###',$coaching_detail,'[',$ord_detail,']',$ord_listed_count,'~',$survey_detail,'^',$survey_listed_count,'@@@@',$display_detail,'#####',$display_listed_count)" />                                                        
                    </xsl:call-template>

                </div>
					<!--</thead>
				</TABLE>-->
			</xsl:when>
			<xsl:otherwise>
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">

								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="../webitm/images/Summary/errUser.png"'
											class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">
										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500;">
												<xsl:choose>
													<xsl:when
														test="contains($customer_types, 'UNLISTED-CHEMIST') and normalize-space($doc_strg_code) = 'UR00000000'">
														<xsl:value-of
															select="concat($doc_strg_name,' - ',$member_presents)" />
													</xsl:when>
													<xsl:when
														test="contains($customer_types, 'UNLISTED-DOCTOR') and  normalize-space($doc_strg_code) = '0000000000'">
														<xsl:value-of
															select="concat('No Of Unlisted Doctors',' - ',$member_presents)" />
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of
															select="concat($doc_strg_name,'  ',$call_outcome_descr)" />
													</xsl:otherwise>
												</xsl:choose>
											</div>






											<xsl:if test="normalize-space($doc_locality) != ''">
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Place Of Work:
													<xsl:value-of select="$doc_locality" />
												</div>
											</xsl:if>

											<xsl:if
												test="not(contains($customer_types, 'UNLISTED')) and normalize-space($strg_type) = 'D'">
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Class:
													<xsl:value-of select="$class_descr" />
												</div>
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Speciality:
													<xsl:value-of select="$spl_description" />
												</div>
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Visit Plan:
													<xsl:value-of select="$no_visit" />
												</div>

											</xsl:if>
											<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Visited With :
												<xsl:choose>
													<xsl:when test="$team_listed_count > '0'">
														<xsl:call-template name="tempTeamData">
															<xsl:with-param name="teamData"
																select="concat($team_detail,'@',$doc_strg_code)" />
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
													</xsl:otherwise>
												</xsl:choose>
											</div>

											<xsl:choose>
												<xsl:when
													test="contains($customer_types, 'UNLISTED')">
													<div
														style="color:#666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Time Of First Call:
														<xsl:value-of select="$event_time_start" />
													</div>
													<div
														style="color:#666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Time Of Last Call:
														<xsl:value-of select="$event_time_end" />
													</div>
												</xsl:when>
												<xsl:otherwise>
													<div
														style="color:#666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Visited Time:
														<xsl:value-of select="$event_time_start" />
													</div>

												</xsl:otherwise>
											</xsl:choose>

											<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												POB Value:
												<xsl:value-of select="$pob_val" />
											</div>

											<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Remarks:
												<xsl:call-template name="meetTemp">
													<xsl:with-param name="stringtosplitRemark"
														select="$meet_summ" />
												</xsl:call-template>
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>
					</thead>
				</TABLE>-->
                <div class="stickysubforms">
                    <div class=" datafontsize docdatadetails">
                            
                        <xsl:choose>
                            <xsl:when
                                test="contains($customer_types, 'UNLISTED')">
                                <xsl:if test="normalize-space($strg_type)='D' or normalize-space($strg_type)='S' or normalize-space($strg_type)='O' or normalize-space($dcr_group)='O' or normalize-space($strg_type)='C' 
                                        or normalize-space($doc_strg_code) = 'UR00000000' or normalize-space($doc_strg_code) = '0000000000'">
                                    <div  class="firstcolumn detailswidth unlistedcust">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </xsl:if>
                            </xsl:when>
							<xsl:otherwise>
                                <div class="detailswidth firstcolumn docname hideoverflow">
                                    <xsl:value-of
						    			select="concat($doc_strg_name,' ',' ')" />
					    			<!--<xsl:value-of
				    					select="concat($doc_strg_name,' ',$call_outcome_descr)" />-->
                                </div>
                            </xsl:otherwise>
                        </xsl:choose>
                        
                        <xsl:if
                            test="not(contains($customer_types, 'UNLISTED')) and normalize-space($strg_type) = 'D'">

                            <div class="detailswidth class hideoverflow">
                                <xsl:value-of select="$class_descr" />
                            </div>

                            <div class="detailswidth speciality hideoverflow">
                                <xsl:value-of select="$spl_description" />
                            </div>
                        </xsl:if>

                        <xsl:if test="normalize-space($doc_locality) != '' and not(contains($customer_types, 'UNLISTED'))">
                                    <div class="detailswidth placeofwork hideoverflow">
                                        <xsl:value-of select="$doc_locality" />
                                    </div>
                        </xsl:if>
                        
                        <xsl:if
                            test="not(contains($customer_types, 'UNLISTED')) and normalize-space($strg_type) = 'D'">

                            <div class="detailswidth visitplan">
                                <xsl:value-of select="$no_visit" />
                            </div>

                        </xsl:if>


                                <div class="detailswidth visitwith hideoverflow">
                                    <xsl:choose>
                                        <xsl:when test="$team_listed_count > '0'">
                                            <xsl:call-template name="tempTeamData">
                                                <xsl:with-param name="teamData"
                                                    select="concat($team_detail,'@',$doc_strg_code)" />
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>

                        <xsl:choose>
                            <xsl:when
                                    test="contains($customer_types, 'UNLISTED')">

                                <div class="detailswidth timeofcall">
                                    <xsl:value-of select="$event_time_start" />
                                </div>

                                <div class="detailswidth timeofcall">
                                    <xsl:value-of select="$event_time_end" />
                                </div>
                            </xsl:when>
                            <xsl:otherwise>
                                <div class="detailswidth timeofcall">
                                    <xsl:value-of select="$event_time_start" />
                                </div>
                            </xsl:otherwise>
                        </xsl:choose>

                        <div class="detailswidth pobvalue">
                            <xsl:value-of select="$pob_val" />
                        </div>

                        <xsl:if test="normalize-space($dcr_group)='O'">
							<div class="detailswidth meet-stat hideoverflow">
								<xsl:value-of select="$doc_call_outcome" />
							</div>
							<div class="detailswidth customer-types hideoverflow">
								<xsl:value-of select="$type_of_customer" />
							</div>
							 <xsl:if test="normalize-space($contact_pers) != '' ">
                                   	<div class="detailswidth euin-no">
                                       	<xsl:value-of select="concat($contact_pers_name,' (',$contact_pers,')')" />
                                    </div>
                             </xsl:if>

							<div class="detailswidth reg-no hideoverflow">
								<xsl:value-of select="$reg_no" />
							</div>
						</xsl:if>

                        <div class="detailswidth lastcolumn remarks hideoverflow">
                            <xsl:value-of select="$meet_summ" />
                        </div>


                    </div>
                </div>
			</xsl:otherwise>
		</xsl:choose>
        <!--Changes by Jatin M on 15/MAR/2021 for Summary Look and Feel - Table View - Ends-->
	</xsl:template>
	<xsl:template name="tempOrderData">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="item_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="item_form_cnt">
			<xsl:value-of
			select="substring-before(substring-after($order_data_value,'#'),'{')" />
		</xsl:variable>
		
		<!-- //Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] Start -->
		<xsl:variable name="brand_form_cnt">
			<xsl:value-of select="substring-before(substring-after($order_data_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="brand_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'}'),'***')" />
		</xsl:variable>
		<!-- surey Details End -->
		<xsl:variable name="coaching_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'***'),'###')" />
		</xsl:variable>
		<xsl:variable name="coaching_details">
			<xsl:value-of
				select="substring-after($order_data_value,'###')" />
		</xsl:variable>
		
		<xsl:variable name="order_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'['),']')" />
		</xsl:variable>
		     <xsl:variable name="order_form_cnt">
        			<xsl:value-of select="substring-before(substring-after($order_data_value,']'),'~')" />
		</xsl:variable>

				<xsl:variable name="survey_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'~'),'^')" />
		</xsl:variable>

		<xsl:variable name="survey_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'^'),'@@@@')" />		
				</xsl:variable>
		<xsl:variable name="display_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@@@@'),'#####')" />
		</xsl:variable>

		<xsl:variable name="display_form_cnt">
						<xsl:value-of select="substring-after($order_data_value,'#####')" />
		</xsl:variable>
		
		
        <xsl:variable name="domID">
			<xsl:value-of select="@domID" />
		</xsl:variable>
		<!-- //Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] end -->
		
        <!-- Added by Jatin M on 15-MAR-2021 for Summary Look and Feel - Table View - Starts-->
		<!-- Item Details Start -->
		<xsl:if test="normalize-space($item_form_cnt) > 0">
			<!--<TABLE id="itemTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<tr id="item.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Gift/Sample</th>
						<th></th>
						<th></th>
					</tr>
					<TR id="item.{normalize-space($dcotor_cust_code)}.heading">

						<TH CLASS="cellttl1 cellttlblck heading tdLeft firstData">Input Type</TH>
						<TH CLASS="cellttl1 cellttlblck heading firstData">Product</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdRight firstData">Quantity</TH>
					</TR>
				</thead>-->
            <xsl:variable name="itemCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $item_details)]">
                    <xsl:variable name="itm_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($itm_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($itm_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <div class="sampledetails ">
                <div class="sampleheading textcolor headerfontsize">
                    <xsl:value-of select="string-length(normalize-space($itemCnt))" /> Gift/Samples
                </div>
                <div class="subformoverflow">
	                <div class="overflo-samplename">
	                    <div class="left-spacing seperatorDiv headerfontsize"> PRODUCT </div>	
	                    <div class="center-spacing seperatorDiv headerfontsize"> TYPE </div>
	                    <div class="right-spacing seperatorDiv headerfontsize"> QUANTITY </div>
	                </div>
	
				<!--<tbody id="item.{normalize-space($dcotor_cust_code)}.details">-->
	                <xsl:for-each
	                    select="//node()[starts-with(name(), $item_details)]">
	
	                    <xsl:if test="attribute/@updateFlag!='D'">
	                        <xsl:variable name="sample_item_descr">
	                            <xsl:value-of select="item_descr" />
	                        </xsl:variable>
	                        <xsl:variable name="item_quantity">
	                            <xsl:value-of select="quantity" />
	                        </xsl:variable>
	                        <xsl:variable name="item_usage">
	                            <xsl:value-of select="item_usage" />
	                        </xsl:variable>
	                        <xsl:variable name="item_strg_code">
	                            <xsl:value-of select="strg_code" />
	                        </xsl:variable>
	                        <xsl:if
	                            test="normalize-space($item_strg_code) = normalize-space($dcotor_cust_code)">
	
	    								<!--<TR style="background-color: #f0eded;">
		    								<TD CLASS="cellttl1 tdLeft title">
			    								<xsl:value-of select="$item_usage" />
				    						</TD>
					    					<TD CLASS="cellttl1 tdCenter title">
						    					<xsl:value-of select="$sample_item_descr" />
							    			</TD>
								    		<TD CLASS="cellttl1 tdRight title">
											<xsl:value-of select="$item_quantity" />
	    									</TD>
		    							</TR>-->
	
	                            <div class="sampledata datafontsize">
	                                <div class="left-spacing detailswidth firstcolumn hideoverflow">
	                                    <xsl:value-of select="$sample_item_descr" />
	    					    	</div>
		    			    		<div class="detailswidth center-spacing"> 
			    		    			<xsl:value-of select="$item_usage" />
			        				</div>
			    	    			<div class="detailswidth lastcolumn right-spacing">
					    				<xsl:value-of select="$item_quantity" />
		    			    		</div>
	                            </div>
						    </xsl:if>
						</xsl:if>
					</xsl:for-each>
				</div>
            </div>
				<!--</tbody>
			</TABLE>-->
		</xsl:if>
        <!-- Added by Jatin M on 15-MAR-2021 for Summary Look and Feel - Table View - Ends-->
		<!-- Item Details end -->
		<!-- Survey Details Start -->
		<!-- Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] Start -->
			<xsl:if test="normalize-space($brand_form_cnt) > 0">
			
			 <div class="sampledetails">
                <!--<div class="sampleheading textcolor headerfontsize">
                Product
                </div>-->
                <div class="samplename">
                    <div class="left-spacing headerfontsize"> PRODUCT </div>	
                    <div class="right-spacing rightcol-spacing headerfontsize"> STATUS </div>
                </div>

                
                <xsl:for-each select="//node()[starts-with(name(), $brand_details)]">
						<xsl:variable name="brand_descr">
							<xsl:value-of select="brand_descr" />
						</xsl:variable>
						<xsl:variable name="pitch_detail_descr">
							<xsl:value-of select="pitch_detail_descr" />
						</xsl:variable>

						<xsl:variable name="brand_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>


						<xsl:if
							test="normalize-space($brand_strg_code) = normalize-space($dcotor_cust_code)">
						<div class="sampledata datafontsize">
                            <div class="left-spacing firstcolumn detailswidth hideoverflow">
                                <xsl:value-of select="$brand_descr" />
                            </div>

                            <div class="lastcolumn detailswidth rightcol-spacing right-spacing">
                                <xsl:value-of select="$pitch_detail_descr" />
                            </div>
                        </div>
						</xsl:if>
					</xsl:for-each>
            </div>
			
</xsl:if>	
<xsl:if test="normalize-space($survey_form_cnt) > 0">

			
			<xsl:variable name="surveyCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $survey_details)]">
                    <xsl:variable name="survey_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($survey_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($survey_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
			<div class="sampledetails">
                <div class="sampleheading textcolor headerfontsize">
                    <xsl:value-of select="string-length(normalize-space($surveyCnt))" /> Surveys
                </div>
                <div class="subformoverflow">
                    <div class="overflo-samplename">
                        <div class="divToTheLeft seperatorDiv headerfontsize"> SURVEY DESCRIPTION </div>	
                        <div class="divToTheRight seperatorDiv headerfontsize"> SURVEY RESULT </div>
                    </div>
					<xsl:for-each select="//node()[starts-with(name(), $survey_details)]">
								<xsl:sort select="survey_group_descr" />
								<xsl:sort select="survey_descr" />
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="survey_group_descr">
										<xsl:value-of select="survey_group_descr" />
									</xsl:variable>
									<xsl:variable name="survey_descr">
										<xsl:value-of select="survey_descr" />
									</xsl:variable>
									<xsl:variable name="survey_strg_code">
				                        <xsl:value-of select="strg_code" />
				                    </xsl:variable>
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<xsl:variable name="result_format">
										<xsl:value-of select="result_format" />
									</xsl:variable>
									<xsl:variable name="surv_doc_id">
										<xsl:value-of select="doc_id_2" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'N'">
												<xsl:value-of select="result1" />
											</xsl:when>
											<xsl:when test="$result_type = 'T'">
												<xsl:value-of select="result3" />
											</xsl:when>
											<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
												<xsl:value-of select="result4" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="result2" />
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:if 
										test="normalize-space($survey_strg_code) = normalize-space($dcotor_cust_code)">
										<xsl:choose>
											<xsl:when test="position() = '1' or $survey_group_descr != preceding-sibling::*[1][attribute/@selected!='N']/survey_group_descr">											
												<div class="sampledata datafontsize">
					                                <div class="divToTheLeft firstcolumn detailswidth hideoverflow">
					                                    <xsl:value-of select="$survey_descr" />
					                                </div>
					                                <div class="lastcolumn detailswidth divToTheRight">
					                                    <xsl:choose>
															<xsl:when test="$result = 'Y'">
																Yes
															</xsl:when>
															<xsl:when test="$result = 'N'">
																No
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="$result" />
															</xsl:otherwise>
														</xsl:choose>
					                                </div>
					                            </div>
											</xsl:when>
											<xsl:otherwise>												
												<div class="sampledata datafontsize">
					                                <div class="divToTheLeft firstcolumn detailswidth hideoverflow">
					                                    <xsl:value-of select="$survey_descr" />
					                                </div>
					                                <div class="lastcolumn detailswidth divToTheRight">
					                                    <xsl:choose>
															<xsl:when test="$result = 'Y'">
																Yes
															</xsl:when>
															<xsl:when test="$result = 'N'">
																No
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="$result" />
															</xsl:otherwise>
														</xsl:choose>
					                                </div>
					                            </div>
											</xsl:otherwise>
										</xsl:choose>
										<div class="displayplugin detailswidth">
											<div align='left' id="__attachmentDiv.{normalize-space($surv_doc_id)}" style="text-align:center;white-space:nowrap;"></div>
											<img style="height:0px;width:0px;" src="_"
												onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($surv_doc_id)}', 'strg_meet_dcr_wiz', 'M-DCR', '{normalize-space($surv_doc_id)}'); this.remove();" />
										</div>
									</xsl:if>
								</xsl:if>
							</xsl:for-each>
					</div>
				</div>
		</xsl:if>
		<xsl:if test="normalize-space($display_form_cnt) > 0">
		
			<xsl:variable name="dispCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $display_details)]">
                    <xsl:variable name="display_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($display_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($display_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
			<div class="sampledetails">
                <div class="sampleheading textcolor headerfontsize">
                        <xsl:value-of select="string-length(normalize-space($dispCnt))" /> Display
                </div>
				<xsl:for-each
					select="//node()[starts-with(name(), $display_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="doc_id">
							<xsl:value-of select="doc_id" />
						</xsl:variable>
						<xsl:variable name="display_area">
							<xsl:value-of select="display_area" />
						</xsl:variable>
						<xsl:variable name="display_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($display_strg_code) = normalize-space($dcotor_cust_code)">
							
							<div class="overflo-sampledata datafontsize">
								<div class="displayarea">
                                     DISPLAY AREA - <xsl:value-of select="$display_area" />
                                 </div>
                            </div>
                            <div class="displayplugin detailswidth">
                               	<div align='center' id="__attachmentDiv.{normalize-space(concat($doc_id,'_table'))}"
										style="text-align:center;white-space:nowrap;"></div>
								<img src="_"
									onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space(concat($doc_id,'_table'))}', 'strg_meet_dcr_wiz', 'M-DCR', '{normalize-space($doc_id)}'); this.remove();" />
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</div>	

		</xsl:if>
		<xsl:if test="normalize-space($coaching_form_cnt) > 0">
			<TABLE id="coachingTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<tr id="coaching.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Coaching Details</th>
						<th></th>
					</tr>
				</thead>
				<tbody
					id="coaching.{normalize-space($dcotor_cust_code)}.details">
					<xsl:for-each
						select="//node()[starts-with(name(), $coaching_details)]">
						<xsl:if test="attribute/@updateFlag!='D'">
							<xsl:variable name="survey_descr">
									<xsl:value-of select="survey_descr" />
								</xsl:variable>
								<xsl:variable name="result_type">
									<xsl:value-of select="result_type" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] Start -->
								<xsl:variable name="result_format">
									<xsl:value-of select="result_format" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] End -->
								<xsl:variable name="coaching_doc_id">
									<xsl:value-of select="doc_id_1" />
								</xsl:variable>
								<xsl:variable name="result">
									<xsl:choose>
										<xsl:when test="$result_type = 'N'">
											<xsl:value-of select="result1" />
										</xsl:when>
										<xsl:when test="$result_type = 'T'">
											<xsl:value-of select="result3" />
										</xsl:when>
										<xsl:when test="$result_type = 'A'">
											<xsl:value-of select="result5" />
										</xsl:when>
										<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
											<xsl:value-of select="result4" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="result2" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="coaching_strg_code">
								<xsl:value-of select="strg_code" />
							</xsl:variable>
							<xsl:if
								test="normalize-space($coaching_strg_code) = normalize-space($dcotor_cust_code)">
								<tr style="background-color: #f0eded;">
									<TD CLASS="cellttl1 title tdLeft">
										<xsl:value-of select="$survey_descr" />
									</TD>
									<TD CLASS="cellttl1 title tdRight">
										<!-- <xsl:value-of select="$result" /> -->
										<xsl:choose>
											<xsl:when test="$result = 'Y'">
												Yes
											</xsl:when>
											<xsl:when test="$result = 'N'">
												No
											</xsl:when>
											<xsl:otherwise>
												<!-- <xsl:value-of select="$result" /> -->
												<xsl:variable name="testVar" select="substring-after($result,'task_descr&quot;:&quot;')" />
												<xsl:value-of select="substring-before($testVar,'&quot;')" />
											</xsl:otherwise>
										</xsl:choose>
									</TD>
								</tr>
								<tr>
									<td>
										<div align='center'
											id="__attachmentDiv.{normalize-space($coaching_doc_id)}"
											style="text-align:center;white-space:nowrap;">
										</div>
									</td>
								</tr>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
				</tbody>
			</TABLE>
		</xsl:if>
		
		<xsl:if test="normalize-space($order_form_cnt) > 0">
			
			<xsl:variable name="ordCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $order_details)]">
                    <xsl:variable name="ord_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($ord_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($ord_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
			<div class="sampledetails ">
                <div class="sampleheading textcolor headerfontsize">
                    <xsl:value-of select="string-length(normalize-space($ordCnt))" /> Orders
                </div>
                <div class="subformoverflow">
	                <div class="overflo-samplename">
	                      <div class="ord-product seperatorDiv headerfontsize"> PRODUCT </div>	
	                      <div class="ord-quantity seperatorDiv headerfontsize"> QUANTITY </div>
	                      <div class="ord-value seperatorDiv headerfontsize"> VALUE </div>
	                      <div class="ord-descr seperatorDiv headerfontsize"> SCHEME DESCRIPTION </div>
                          <div class="ord-devi-rsn seperatorDiv headerfontsize"> FOCUS DEVIATION REASON </div>
						  <div class="ord-remarks seperatorDiv headerfontsize lastcolumn"> REMARKS </div>
	                </div>
                  
					<xsl:for-each
						select="//node()[starts-with(name(), $order_details)]">
						<xsl:if test="attribute/@updateFlag!='D'">
							<xsl:variable name="ord_strg_code">
								<xsl:value-of select="strg_code" />
							</xsl:variable>
							<xsl:variable name="item_descr">
								<xsl:value-of select="item_descr" />
							</xsl:variable>
							<xsl:variable name="quantity">
								<xsl:value-of select="quantity" />
							</xsl:variable>
							<xsl:variable name="ordervalue">
								<xsl:value-of select="value" />
							</xsl:variable>
							<xsl:variable name="Scheme_description">
								<xsl:value-of select="description" />
							</xsl:variable>
							<xsl:variable name="remark_descr">
								<xsl:value-of select="remark_descr" />
							</xsl:variable>
                            <xsl:variable name="order_remarks">
                                <xsl:value-of select="remarks_ord" />
                            </xsl:variable>
							<xsl:if
								test="normalize-space($ord_strg_code) = normalize-space($dcotor_cust_code)">
								<!-- <TR style="background-color: #f0eded;">
									<TD CLASS="cellttl1 tdCenter title tdLeft">
										<xsl:value-of select="$item_descr" />
									</TD>
									<TD CLASS="cellttl1 tdCenter title">
										<xsl:value-of select="$quantity" />
									</TD>
									<TD CLASS="cellttl1 tdCenter title">
										<xsl:value-of select="$ordervalue" />
									</TD>
									<TD CLASS="cellttl1 tdCenter title tdRight">
										<xsl:value-of select="$Scheme_description" />
									</TD>
								</TR>-->
								<div class="sampledata datafontsize">
	                                <div class="ord-product firstcolumn detailswidth hideoverflow">
	                                    <xsl:value-of select="$item_descr" />
	                                </div>
	                                <div class="detailswidth ord-quantity"> 
	                                    <xsl:value-of select="$quantity" />
	                                </div>
	                                <div class="detailswidth ord-value"> 
	                                    <xsl:value-of select="$ordervalue" />
	                                </div>
	                                <div class="detailswidth ord-descr">
	                                    <xsl:value-of select="$Scheme_description" />
	                                </div>
									<div class="detailswidth ord-devi-rsn">
	                                    <xsl:value-of select="$remark_descr" />
	                                </div>
                                    <div class="lastcolumn detailswidth ord-remarks">
	                                    <xsl:value-of select="$order_remarks" />
	                                </div>
	                            </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
				</div>
			</div>
				<!--</tbody>
			</TABLE>-->
		</xsl:if>
		
		
		
		<!-- //Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] end -->

	</xsl:template>
    <!-- Table View Related Template - End -->
    <xsl:variable name="host">
        <xsl:for-each select="//Detail1">
            <xsl:if test="attribute/@updateFlag!='D'">
                <xsl:value-of select="host_url" />
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>
    <!-- Feed View Related Template - Start -->
	<xsl:template name="tmpSplitStringFeed">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>
        <xsl:variable name="collapse">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/collapse.svg')" />
		</xsl:variable>
		<xsl:variable name="expand">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/expand.svg')" />
		</xsl:variable>

		<xsl:variable name="last_locality_descr">
			<xsl:value-of select="//Detail1/sprs_route_descr" />
		</xsl:variable>



	    <xsl:if test="normalize-space($form_name) = 'activity'">
            <xsl:variable name="activity_code">
                <xsl:value-of select="count(//node()[starts-with(name(), $detail)])" />
            </xsl:variable>

            <div class="headerdata datafontsize">
                <IMG
                    SRC="{normalize-space($host)}/ibase/webitm/images/Summary/fw_activity_header.svg"
                    onerror='this.src="../webitm/images/Summary/fw_activity_header.svg"'
                    class="outerIcon align-imgtext" >
                </IMG>
                <xsl:value-of select="normalize-space($activity_code)" /> Activity Details
            </div>

            <div id="activity_visited">
                <div class="containerfeed datafontsize">
                    <div class="visits-colDiv">
                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:sort select="order_of_visit" order="descending" />
                            <xsl:if test="attribute/@updateFlag!='D'">

                                <xsl:variable name="activity_descr">
                                    <xsl:value-of select="activity_descr" />
                                </xsl:variable>

                                <xsl:variable name="visit_time_fr">
                                    <xsl:value-of select="visit_time_fr" />
                                </xsl:variable>

                                <xsl:variable name="visit_time_to">
                                    <xsl:value-of select="visit_time_to" />
                                </xsl:variable>


                                <div class="columnsDiv-1">
                                    <div class="iconborder location-icon align-imgtext">
                                        <IMG
                                            SRC="{normalize-space($host)}/ibase/webitm/images/Summary/fw_activity.svg"
                                            onerror='this.src="../webitm/images/Summary/fw_activity.svg"'
                                            class="travelIcon align-imgtext" width="40" height="40">
                                        </IMG>

                                    </div>
                                    <div class="namespacing align-imgtext powfeedview">
                                        <div class="hideoverflowfeed">
                                            <xsl:value-of select="$activity_descr" />
                                        </div>

                                    </div>

                                    <div class="rightcol-spacing">
                                        <div>
                                            <span class="textcolor">Visit From  </span>
                                            <span>
                                                <xsl:value-of select="$visit_time_fr" />
                                            </span>
                                        </div>
                                        <div>
                                            <span class="textcolor">Time To  </span>
                                            <span>
                                                <xsl:value-of select="$visit_time_to" />
                                            </span>
                                        </div>
                                    </div>

                                </div>

                            </xsl:if>
                        </xsl:for-each>
                    </div>
                </div>
            </div>

        </xsl:if>

        <!-- Added by Jatin M on 15-MAR-2021 for Look and Feel - - Feed View - Start -->
		<xsl:if test="normalize-space($form_name) = 'place'">
			<!--<details open="true">
				<summary class="summary" style="text-align: left;">Place Details</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<TR>
							<TH CLASS="cellttl1 cellttlblck heading firstData tdLeft">Emp Place Of Work</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData">Place Of Work</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData">Journey From</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData">Travel Mode</TH>
							<TH CLASS="cellttl1 cellttlblck heading firstData tdRight">Order Of Visit</TH>
						</TR>
					</thead>-->
            <xsl:variable name="visit_no">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)])" />
            </xsl:variable>
            
            <div class="headerdata datafontsize">
                <IMG
                    SRC="{normalize-space($host)}/ibase/webitm/images/Summary/places_visited.svg"
                    onerror='this.src="../webitm/images/Summary/places_visited.svg"'
                    class="outerIcon align-imgtext" >
                </IMG>
                <xsl:value-of
                    select="normalize-space($visit_no)" /> Places Visited
                <div class="tab">
                    <button type="button" class="rmvborder">
                        <div class="btnborder align-imgtext">
                            <IMG
                                id="place_visited_btn" class="collapsibleIconRadius align-imgtext" 
                                onclick="expandDetails('place_visited', 'place_visited_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                            </IMG>
                        </div>
                    </button>
                </div>
            </div>
            
            <div id="place_visited">
                <div class="containerfeed datafontsize">
                    <div class="visits-colDiv">

                        <xsl:for-each
                            select="//node()[starts-with(name(), $detail)]">
                            <xsl:sort select="order_of_visit" order="descending" />
                            <xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="sl_no">
                                    <xsl:value-of select="sl_no" />
                                </xsl:variable>
                                <xsl:variable name="sprs_route_descr">
                                    <xsl:value-of select="sprs_route_descr" />
                                </xsl:variable>
                                <xsl:variable name="travel_mode">
                                    <xsl:value-of select="travel_mode_descr" />
                                </xsl:variable>
                                <xsl:variable name="order_of_visit">
                                    <xsl:value-of select="order_of_visit" />
                                </xsl:variable>
                                <xsl:variable name="station_descr">
                                    <xsl:value-of select="station_descr" />
                                </xsl:variable>
                                <xsl:variable name="prv_order_of_visit">
                                    <xsl:value-of select="$order_of_visit - 1" />
                                </xsl:variable>


                                <div class="columnsDiv-1 timeline">
                                    <div class="iconborder location-icon align-imgtext">
                                        <xsl:choose>
                                            <xsl:when test="$travel_mode = 'ROAD'">
                                                <IMG
                                                    SRC="{normalize-space($host)}/ibase/webitm/images/Summary/road.svg"
                                                    onerror='this.src="../webitm/images/Summary/road.svg"'
                                                    class="travelIcon align-imgtext" width="40" height="40">
                                                </IMG>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <IMG
                                                    SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_place.svg"
                                                    onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                                    class="bradius align-imgtext" width="40" height="40">
                                                </IMG>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        
                                    </div>
                                    <div class="namespacing align-imgtext powfeedview">
                                        <div class="hideoverflowfeed">
                                            <xsl:value-of select="$sprs_route_descr" />
                                        </div>
                                        <div class="headerfontsize textcolor">
                                            by <xsl:value-of select="$travel_mode" />
                                        </div>
                                    </div>
                                    <div class="routeicon iconborder">
                                        <xsl:value-of select="$order_of_visit" />
                                    </div>
                                </div>

								<!--<TD CLASS="cellttl1 tdCenter title  ">
									<xsl:value-of select="$sprs_route_descr" />

								</TD>
								<TD CLASS="cellttl1 tdCenter title  ">
									<xsl:if test="normalize-space($order_of_visit) = '1'">
										<xsl:value-of select="$last_locality_descr" />
									</xsl:if>
									<xsl:if test="normalize-space($order_of_visit) != '1'">
										<xsl:for-each
											select="//node()[starts-with(name(), $detail)]">
											<xsl:variable name="current_order_visit">
												<xsl:value-of select="order_of_visit" />
											</xsl:variable>
											<xsl:variable name="prv_route_descr">
												<xsl:value-of select="sprs_route_descr" />
											</xsl:variable>

											<xsl:if
												test="normalize-space($current_order_visit) = normalize-space($prv_order_of_visit)">
												<xsl:value-of select="$prv_route_descr" />
											</xsl:if>
										</xsl:for-each>
									</xsl:if>

								</TD>
								<TD CLASS="cellttl1 tdCenter title">
									<xsl:value-of select="$travel_mode" />
								</TD>
								<TD CLASS="cellttl1 tdRight title ">
									<xsl:value-of select="$order_of_visit" />
								</TD>
							</TR>-->
                            </xsl:if>

                        </xsl:for-each>
                    </div>
                </div>
            </div>
				<!--</TABLE>
			</details>-->
		</xsl:if>

		<xsl:if test="normalize-space($form_name) = 'doctor'">

            <xsl:variable name="doc_listed_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type,'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="unlisted_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
            </xsl:variable>

			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">

                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_doc.svg"
                        onerror='this.src="../webitm/images/Summary/summary_doc.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG> 
                    <xsl:value-of
                        select="normalize-space($doc_listed_cnt)" />
                        Doctor's (Call List)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="doc_listed_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('doc_listed', 'doc_listed_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>
                <!--</summary>
                <TABLE class="tTitleD" border="0" width="100%"
                    style="width:100%; z-index:9999999999;  ">-->
                <div id="doc_listed">
					<xsl:for-each
						select="//node()[starts-with(name(), $detail)]">
						<xsl:sort select="substring-after(event_time_start, ' ')" />
						<xsl:sort
							select="substring-before(event_time_start,':') mod 12"
							data-type="number" />
						<xsl:sort
							select="substring-before(substring-after(event_time_start,':'), ' ')"
							data-type="number" />

						<xsl:if test="attribute/@updateFlag!='D'">
							<xsl:variable name="customer_type">
								<xsl:value-of select="cust_type" />
							</xsl:variable>
							<!-- <xsl:if test="normalize-space($customer_type) = 'Doctors'"> -->

                            <xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize"><!-- container starts -->
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
	                                
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->

                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>

                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
                </div>
				<!--</TABLE>
			</details>-->
			</xsl:if>


			<xsl:if test="normalize-space($unlisted_cnt) > '0'">
				<!--<details open="true">
					<summary class="summary" style="text-align: left;">Doctor's Details (Not From Call List)</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_doc.svg"
                        onerror='this.src="../webitm/images/Summary/summary_doc.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG> 
                    <xsl:value-of
                        select="normalize-space($unlisted_cnt)" />
                        Doctor's (Unlisted)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="doc_unlisted_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('doc_unlisted', 'doc_unlisted_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>
                
                <div id="doc_unlisted">
                    
                    <xsl:for-each
                        select="//node()[starts-with(name(), $detail)]">

                        <xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <!-- <xsl:if
                                test="normalize-space($customer_type) = 'UNLISTED-DOCTOR'"> -->

                                <xsl:if test="(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize">
                                <xsl:variable name="strg_name">
                                    <xsl:value-of select="strg_name" />
                                </xsl:variable>
                                <xsl:variable name="strg_code">
                                    <xsl:value-of select="strg_code" />
                                </xsl:variable>
                                <xsl:variable name="order_form_no">
                                    <xsl:value-of select="order_form_no" />
                                </xsl:variable>
                                <xsl:variable name="locality_descr">
                                    <xsl:value-of select="locality_descr" />
                                </xsl:variable>
                                <xsl:variable name="call_outcome">
                                    <xsl:value-of select="meeting_status" />
                                </xsl:variable>
                                <xsl:variable name="domID">
                                    <xsl:value-of select="@domID" />
                                </xsl:variable>
                                <!-- <xsl:variable name="host_url">
                                    <xsl:value-of select="host_url" />
                                </xsl:variable> -->
                                <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                    select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                    /> </xsl:call-template> -->
                                <xsl:variable name="visited_with_team">
                                    <xsl:value-of select="visited_with_display" />
                                </xsl:variable>
                                <xsl:variable name="team_form_no">
                                    <xsl:value-of select="team_form_no" />
                                </xsl:variable>
                                <xsl:variable name="class_code_descr">
                                    <xsl:value-of select="class_code_descr" />
                                </xsl:variable>


                                <xsl:variable name="speciality_descr">
                                    <xsl:value-of select="speciality_descr" />
                                </xsl:variable>
                                <xsl:variable name="no_visit">
                                    <xsl:value-of select="strg_no_visit" />
                                </xsl:variable>
                                <xsl:variable name="event_time_start">
                                    <xsl:value-of select="event_time_start" />
                                </xsl:variable>
                                <xsl:variable name="event_time_end">
                                    <xsl:value-of select="event_time_end" />
                                </xsl:variable>
                                <xsl:variable name="pob_val">
                                    <xsl:value-of select="sku_value" />
                                </xsl:variable>
                                <xsl:variable name="is_member_present">
                                    <xsl:value-of select="is_member_present" />
                                </xsl:variable>
                                <!--<xsl:variable name="meet_summ">
                                    <xsl:value-of select="concat(meet_summ,',')" />
                                </xsl:variable>-->
                                <xsl:variable name="meet_summ">
                                    <xsl:value-of select="remarks" />
                                </xsl:variable>

                                <xsl:variable name="member_present">
                                    <xsl:value-of select="member_present" />
                                </xsl:variable>
                                <xsl:variable name="strg_type">
                                    <xsl:value-of select="strg_type" />
                                </xsl:variable>

                                <xsl:variable name="contact_pers">
                                    <xsl:value-of select="contact_pers" />
                                </xsl:variable>
                                <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
								</xsl:variable>
                                <xsl:variable name="reg_no">
                                        <xsl:value-of select="reg_no" />
                                </xsl:variable>
                                <xsl:variable name="is_fortune_activity">
                                        <xsl:value-of select="is_fortune_activity" />
                                </xsl:variable>
                                <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                <xsl:call-template name="tmpOrderFeed">
                                    <xsl:with-param name="orderFormName"
                                        select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                </xsl:call-template>
                                </div>
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
		</xsl:if>

        <xsl:if test="normalize-space($form_name) = 'retailer'">

            <xsl:variable name="chem_listed_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type, 'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="chem_unlisted_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
            </xsl:variable>

		    <xsl:if test="normalize-space($chem_listed_cnt) > '0'">
                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">Chemist's Call Details - (
                        <xsl:value-of
                            select="normalize-space($chem_listed_cnt)" />
                        )</summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize"> 
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_chem.svg"
                        onerror='this.src="../webitm/images/Summary/summary_chem.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG> 
                    <xsl:value-of
                        select="normalize-space($chem_listed_cnt)" />
                    Chemist's (Call List)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="chem_listed_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('chem_listed', 'chem_listed_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="chem_listed">

					<xsl:for-each
						select="//node()[starts-with(name(), $detail)]">
						<xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
							<!--<xsl:if
									test="normalize-space($customer_type) = 'Chemist'"> -->
							<xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>

                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
                </div>
				<!--</TABLE>
			</details>-->
		    </xsl:if>

		    <xsl:if test="normalize-space($chem_unlisted_cnt) > '0'">
                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">Chemist's Call Details (Not From Call List)</summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_chem.svg"
                        onerror='this.src="../webitm/images/Summary/summary_chem.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG> 
                    <xsl:value-of
                    select="normalize-space($chem_unlisted_cnt)" />
                    Chemist's (Unlisted)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="chem_unlisted_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('chem_unlisted', 'chem_unlisted_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="chem_unlisted">
					<xsl:for-each
						select="//node()[starts-with(name(), $detail)]">
						<xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
								<!-- <xsl:if
									test="normalize-space($customer_type) = 'UNLISTED-CHEMIST'"> -->
							<xsl:if test="(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize"><!-- container starts -->
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>

                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
                </div>
				<!--</TABLE>
			</details>-->
		    </xsl:if>
        </xsl:if>

		<!-- <xsl:variable name="sto_listed_cnt">
			<xsl:for-each
				select="//node()[starts-with(name(), $detail)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:variable name="customer_type">
						<xsl:value-of select="cust_type" />
					</xsl:variable>
					<xsl:if test="normalize-space($customer_type) = 'Stockist'">
						<xsl:value-of
							select="count(//node()[starts-with(name(), $detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable> -->
        <xsl:if test="normalize-space($form_name) = 'stockist'">

            <xsl:variable name="sto_listed_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type, 'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="sto_unlisted_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
            </xsl:variable>

		    <xsl:if test="normalize-space($sto_listed_cnt) > '0'">

                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">
                        Stockist Call Details - (
                        <xsl:value-of
                            select="normalize-space($sto_listed_cnt)" />
                        )
                    </summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_stockist.svg"
                        onerror='this.src="../webitm/images/Summary/summary_stockist.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG>
                    <xsl:value-of
                        select="normalize-space($sto_listed_cnt)" />
                    Stockist's (Call List)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="sto_listed_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('sto_listed', 'sto_listed_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="sto_listed">
					<xsl:for-each
						select="//node()[starts-with(name(), $detail)]">
						<xsl:sort select="substring-after(event_time_start, ' ')" />
						<xsl:sort
							select="substring-before(event_time_start,':') mod 12"
							data-type="number" />
						<xsl:sort
							select="substring-before(substring-after(event_time_start,':'), ' ')"
							data-type="number" />
						<xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <!-- <xsl:if
                                test="normalize-space($customer_type) = 'Stockist'"> -->
                            <xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
                </div>
				<!--</TABLE>
			</details>-->
		    </xsl:if>

		    <xsl:if test="normalize-space($sto_unlisted_cnt) > '0'">

                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">
                        Stockist Call Details (Not From Call List)
                    </summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_stockist.svg"
                        onerror='this.src="../webitm/images/Summary/summary_stockist.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG>
                    <xsl:value-of
						select="normalize-space($sto_unlisted_cnt)" />
					Stockist's (Unlisted)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="sto_unlisted_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('sto_unlisted', 'sto_unlisted_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
				</div>

                <div id="sto_unlisted">
					<xsl:for-each
						select="//node()[starts-with(name(), $detail)]">
						<xsl:sort select="substring-after(event_time_start, ' ')" />
						<xsl:sort
							select="substring-before(event_time_start,':') mod 12"
							data-type="number" />
						<xsl:sort
							select="substring-before(substring-after(event_time_start,':'), ' ')"
							data-type="number" />
						<xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <!-- <xsl:if
                                test="normalize-space($customer_type) = 'UNLISTED-STOCKIST'"> -->
                            <xsl:if test="(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize"><!-- container starts -->

                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%',$dcr_group)" />
                                    </xsl:call-template>
                                </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
                </div>
				<!--</TABLE>
			</details>-->
            </xsl:if>
        </xsl:if>
        
        
        <!-- Added by Jatin M on 15-MAR-2021 for Look and Feel - Feed View - End -->

		
		<xsl:if test="normalize-space($form_name) = 'ncw'">

            <xsl:variable name="ncw_listed_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][not(contains(cust_type, 'UNLISTED'))])" />
            </xsl:variable>
            <xsl:variable name="ncw_unlisted_cnt">
                <xsl:value-of
                    select="count(//node()[starts-with(name(), $detail)][contains(cust_type, 'UNLISTED')])" />
            </xsl:variable>

		    <xsl:if test="normalize-space($ncw_listed_cnt) > '0'">

                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">
                        Stockist Call Details - (
                        <xsl:value-of
                            select="normalize-space($sto_listed_cnt)" />
                        )
                    </summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_others.svg"
                        onerror='this.src="../webitm/images/Summary/summary_others.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG>
                    <xsl:value-of
                        select="normalize-space($ncw_listed_cnt)" />
                    Other's (Call List)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="ncw_listed_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('ncw_listed', 'ncw_listed_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="ncw_listed">
					<xsl:for-each
						select="//node()[starts-with(name(), $detail)]">
						<xsl:sort select="substring-after(event_time_start, ' ')" />
						<xsl:sort
							select="substring-before(event_time_start,':') mod 12"
							data-type="number" />
						<xsl:sort
							select="substring-before(substring-after(event_time_start,':'), ' ')"
							data-type="number" />
						<xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <!-- <xsl:if
                                test="normalize-space($customer_type) = 'Stockist'"> -->
                            <xsl:if test="not(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize">
                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>
									 <xsl:variable name="event_type_descr">
                                         <xsl:value-of select="event_type_descr" />
                                    </xsl:variable>
                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%$',$dcr_group,'%%%%$',$customer_type,'$%%$',$event_type_descr)" />
                                    </xsl:call-template>
                                </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
                </div>
				<!--</TABLE>
			</details>-->
		    </xsl:if>

		    <xsl:if test="normalize-space($ncw_unlisted_cnt) > '0'">

                <!--<details open="true">
                    <summary class="summary" style="text-align: left;">
                        Stockist Call Details (Not From Call List)
                    </summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_others.svg"
                        onerror='this.src="../webitm/images/Summary/summary_others.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG>
                    <xsl:value-of
						select="normalize-space($ncw_unlisted_cnt)" />
					Other's (Unlisted)
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="ncw_unlisted_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('ncw_unlisted', 'ncw_unlisted_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
				</div>

                <div id="ncw_unlisted">
					<xsl:for-each
						select="//node()[starts-with(name(), $detail)]">
						<xsl:sort select="substring-after(event_time_start, ' ')" />
						<xsl:sort
							select="substring-before(event_time_start,':') mod 12"
							data-type="number" />
						<xsl:sort
							select="substring-before(substring-after(event_time_start,':'), ' ')"
							data-type="number" />
						<xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="customer_type">
                                <xsl:value-of select="cust_type" />
                            </xsl:variable>
                            <!-- <xsl:if
                                test="normalize-space($customer_type) = 'UNLISTED-STOCKIST'"> -->
                            <xsl:if test="(contains($customer_type, 'UNLISTED'))">
                                <div class="containerfeed datafontsize"><!-- container starts -->

                                    <xsl:variable name="strg_name">
                                        <xsl:value-of select="strg_name" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_code">
                                        <xsl:value-of select="strg_code" />
                                    </xsl:variable>
                                    <xsl:variable name="order_form_no">
                                        <xsl:value-of select="order_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="locality_descr">
                                        <xsl:value-of select="locality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="call_outcome">
                                        <xsl:value-of select="meeting_status" />
                                    </xsl:variable>
                                    <xsl:variable name="domID">
                                        <xsl:value-of select="@domID" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="host_url">
                                        <xsl:value-of select="host_url" />
                                    </xsl:variable> -->
                                    <!-- <xsl:call-template name="tmpOrder"> <xsl:with-param name="orderFormName"
                                        select="concat($host_url,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr)"
                                        /> </xsl:call-template> -->
                                    <xsl:variable name="visited_with_team">
                                        <xsl:value-of select="visited_with_display" />
                                    </xsl:variable>
                                    <xsl:variable name="team_form_no">
                                        <xsl:value-of select="team_form_no" />
                                    </xsl:variable>
                                    <xsl:variable name="class_code_descr">
                                        <xsl:value-of select="class_code_descr" />
                                    </xsl:variable>


                                    <xsl:variable name="speciality_descr">
                                        <xsl:value-of select="speciality_descr" />
                                    </xsl:variable>
                                    <xsl:variable name="no_visit">
                                        <xsl:value-of select="strg_no_visit" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_start">
                                        <xsl:value-of select="event_time_start" />
                                    </xsl:variable>
                                    <xsl:variable name="event_time_end">
                                        <xsl:value-of select="event_time_end" />
                                    </xsl:variable>
                                    <xsl:variable name="pob_val">
                                        <xsl:value-of select="sku_value" />
                                    </xsl:variable>
                                    <xsl:variable name="is_member_present">
                                        <xsl:value-of select="is_member_present" />
                                    </xsl:variable>
                                    <!--<xsl:variable name="meet_summ">
                                        <xsl:value-of select="concat(meet_summ,',')" />
                                    </xsl:variable>-->
                                    <xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
                                    </xsl:variable>
                                    <!-- <xsl:variable name="customer_type">
                                        <xsl:value-of select="cust_type" />
                                    </xsl:variable> -->
                                    <xsl:variable name="member_present">
                                        <xsl:value-of select="member_present" />
                                    </xsl:variable>
                                    <xsl:variable name="strg_type">
                                        <xsl:value-of select="strg_type" />
                                    </xsl:variable>

                                    <xsl:variable name="contact_pers">
                                        <xsl:value-of select="contact_pers" />
                                    </xsl:variable>
                                    <xsl:variable name="contact_pers_name">
   										<xsl:value-of select="contact_pers_name" />
									</xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="dcr_group">
                                         <xsl:value-of select="dcr_group" />
                                    </xsl:variable>
                                  <xsl:variable name="event_type_descr">
                                         <xsl:value-of select="event_type_descr" />
                                    </xsl:variable>

                                    <xsl:call-template name="tmpOrderFeed">
                                        <xsl:with-param name="orderFormName"
                                            select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'][',$detail,'####',$strg_type,'$#',$is_member_present,'||',$contact_pers,'$%',$contact_pers_name,'$$%',$reg_no,'%%',$is_fortune_activity,'%%%$',$dcr_group,'%%%%$',$customer_type,'$%%$',$event_type_descr)" />
                                    </xsl:call-template>
                                </div>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
                </div>
				<!--</TABLE>
			</details>-->
            </xsl:if>
        </xsl:if>
		
	</xsl:template>

	<xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="ord_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_call_outcome">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="visited_team">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="tm_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="class_descr">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>


		<xsl:variable name="spl_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="no_visit">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="meet_summ">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="pob_val">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>

		<xsl:variable name="member_presents">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'][')" />
		</xsl:variable>

		<xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,']['),'####')" />
		</xsl:variable>

        <xsl:variable name="strg_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'####'),'$#')" />
		</xsl:variable>

        <xsl:variable name="is_member_presents">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'$#'),'||')" />
		</xsl:variable>

        <xsl:variable name="contact_pers">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'||'),'$%')" />
		</xsl:variable>
		
		<xsl:variable name="contact_pers_name">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),'$$%')" />
		</xsl:variable>
		<xsl:variable name="reg_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$$%'),'%%')" />
		</xsl:variable>
		<xsl:variable name="is_fortune_activity">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%'),'%%%$')" />
		</xsl:variable>
		<xsl:variable name="dcr_group">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%%$'),'%%%%$')" />
		</xsl:variable> 
		<xsl:variable name="type_of_customer">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%%%$'),'$%%$')" />
		</xsl:variable> 
		<xsl:variable name="event_type_descr">
			<xsl:value-of
				select="substring-after($ord_value,'$%%$')" />
		</xsl:variable> 

		<xsl:variable name="upImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Up.svg')" />
		</xsl:variable>
		<xsl:variable name="downImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Down.svg')" />
		</xsl:variable>
		<xsl:variable name="ord_detail">
			<xsl:value-of select="concat('Detail',$ord_form_no)" />
		</xsl:variable>
		<xsl:variable name="team_detail">
			<xsl:value-of select="concat('Detail',$tm_form_no)" />
		</xsl:variable>

        <xsl:variable name="team_data">
			<xsl:value-of select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>

		<xsl:variable name="call_outcome_descr">
			<xsl:if test="normalize-space($doc_call_outcome) = '5' ">
				Supporter
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '6' ">
				Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '7' ">
				Non Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '0' ">
				Refused
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="ord_listed_count">
		<xsl:if test="normalize-space($ord_form_no)!=''">					
			<xsl:for-each
				select="//node()[starts-with(name(), $ord_detail)]">
				<xsl:if test="attribute/@updateFlag!='D'">

					<xsl:variable name="order_strg_code">
						<xsl:value-of select="strg_code" />
					</xsl:variable>
					<xsl:if
						test="normalize-space($order_strg_code) = normalize-space($doc_strg_code)">
						<xsl:value-of
							select="count(//node()[starts-with(name(), $ord_detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<!-- Item Details Start -->

		<xsl:variable name="item_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="item_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>


		<xsl:variable name="item_detail">
			<xsl:value-of select="concat('Detail',$item_form_no)" />
		</xsl:variable>

		<xsl:variable name="item_listed_count">
			<xsl:if test="normalize-space($item_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $item_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="item_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($item_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $item_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<!-- Item Details End -->


		<xsl:variable name="team_listed_count">
			<xsl:if test="normalize-space($tm_form_no)!=''">

				<xsl:for-each
					select="//node()[starts-with(name(), $team_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="tm_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($tm_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $team_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="brand_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="brand_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="brand_detail">
			<xsl:value-of select="concat('Detail',$brand_form_no)" />
		</xsl:variable>

		<xsl:variable name="brand_listed_count">
			<xsl:if test="normalize-space($brand_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $brand_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="brand_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($brand_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $brand_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		

		<xsl:variable name="survey_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="survey_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="survey_detail">
			<xsl:value-of select="concat('Detail',$survey_form_no)" />
		</xsl:variable>

		<xsl:variable name="survey_listed_count">
			<xsl:if test="normalize-space($survey_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $survey_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="survey_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($survey_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $survey_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="coaching_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="coaching_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="coaching_detail">
			<xsl:value-of select="concat('Detail',$coaching_form_no)" />
		</xsl:variable>

		<xsl:variable name="coaching_listed_count">
			<xsl:if test="normalize-space($coaching_form_no)!=''">
				<xsl:for-each
					select="//node()[starts-with(name(), $coaching_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="coaching_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($coaching_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $coaching_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		
		<!-- Display Details Start -->

		<xsl:variable name="display_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="display_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="display_detail">
			<xsl:value-of select="concat('Detail',$display_form_no)" />
		</xsl:variable>

		<xsl:variable name="display_listed_count">
			<xsl:if test="normalize-space($display_form_no)!=''">

				<xsl:for-each
					select="//node()[starts-with(name(), $display_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="display_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($display_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $display_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<!-- Display Details end -->

        <xsl:variable name="host_url">
            <xsl:for-each select="//Detail1">
                <xsl:if test="attribute/@updateFlag!='D'">
                    <xsl:value-of select="host_url" />
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>


        <xsl:variable name="visited_with_code">
			<xsl:choose>
                <xsl:when test="$team_listed_count > '0'">
                    <xsl:for-each
                        select="//node()[starts-with(name(), $team_detail)]">
                        <xsl:if test="attribute/@updateFlag!='D'">

                            <xsl:variable name="tm_strg_code">
                                <xsl:value-of select="strg_code" />
                            </xsl:variable>
                            <xsl:variable name="sales_pers">
                                <xsl:value-of select="sales_pers" />
                            </xsl:variable>
                            <xsl:if
                                test="normalize-space($tm_strg_code) = normalize-space($doc_strg_code)">
                                <xsl:value-of
                                    select="$sales_pers" />
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                </xsl:otherwise>
            </xsl:choose>
		</xsl:variable>

        <xsl:variable name="visited_with_name">
			<xsl:choose>
                <xsl:when test="$team_listed_count > '0'">
                    <xsl:for-each
                        select="//node()[starts-with(name(), $team_detail)]">
                        <xsl:if test="attribute/@updateFlag!='D'">

                            <xsl:variable name="tm_strg_code">
                                <xsl:value-of select="strg_code" />
                            </xsl:variable>
                            <xsl:variable name="name">
                                <xsl:value-of select="name" />
                            </xsl:variable>
                            <xsl:if
                                test="normalize-space($tm_strg_code) = normalize-space($doc_strg_code)">
                                <xsl:value-of
                                    select="$name" />
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                </xsl:otherwise>
            </xsl:choose>
		</xsl:variable>


        <!-- Added by Jatin M on 15-MAR-2021 for Summary Look and Feel - Feed View - Start -->
		<xsl:choose>
			<xsl:when test="$item_listed_count > '0' or $brand_listed_count > '0' or $ord_listed_count > '0' or $survey_listed_count > '0' or $display_listed_count > '0'">
				
                <div>
                    <xsl:if
                        test="not(contains($customer_types, 'UNLISTED'))">
                        <div class="customerDiv">
                            <div class="iconborder bluebg-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
                                    onerror='this.src="../images/map/user.png"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>  
                            <div class="addspace large-font">
                                <div>
                                    <xsl:value-of
                                        select="concat($doc_strg_name,',',' ')" />
                                <!--<xsl:value-of
                                    select="concat($doc_strg_name,' ',$call_outcome_descr)" />-->
                                    <xsl:if test="normalize-space($doc_locality) != ''">
                                        <div class="align-customer">
                                            <IMG
                                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place_alt.svg"
                                                onerror='this.src="../webitm/images/Summary/summary_place_alt.svg"'
                                                class="cust-location align-imgtext">
                                            </IMG>
                                            <xsl:value-of select="$doc_locality" />
                                        </div>
                                    </xsl:if>
                                </div>
                                <div class="small-font">
                                    <xsl:if
                                        test="normalize-space($strg_type) = 'D'">
                                        <span class="textcolor">Speciality  </span>
                                            <xsl:value-of select="concat($spl_description,',',' ')" />
                                        <span class="textcolor">Class  </span> 
                                            <xsl:value-of select="$class_descr" />
                                    </xsl:if>
                                     <xsl:if
                                        test="normalize-space($dcr_group) = 'O'">
                                        <span class="textcolor"> Meeting Status </span> 
                                           <xsl:value-of select="concat($doc_call_outcome,',',' ')" />
                                         <span class="textcolor">Customer Type </span> 
                                                <xsl:value-of select="concat($type_of_customer,',',' ')" /> 
                                          <span class="textcolor">Activity </span> 
                                                <xsl:value-of select="concat($event_type_descr,' ')" />   
                                    </xsl:if>
                                </div> 
                            </div>
                            <div class="rightcol-spacing">
                                <div> 
                                    <span class="textcolor">Visit Time  </span> 
                                    <span> <xsl:value-of select="$event_time_start" /> </span>
                                </div>
                                <xsl:if
                                    test="normalize-space($strg_type) = 'D'">
                                    <div> 
                                        <span class="textcolor">Visit Plan  </span>  
                                        <span> <xsl:value-of select="$no_visit" /> </span>  
                                    </div>
                                </xsl:if>  
                            </div>
                        </div> 
                        <div class="row-div">
                        
                            <div class="iconborder visitedwith-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($visited_with_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($visited_with_name)}"
                                    onerror='this.src="../webitm/images/Summary/summary_visited.svg"' class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Visited With
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:choose>
                                        <xsl:when test="$team_listed_count > '0'">
                                            <xsl:call-template name="tempTeamData">
                                                <xsl:with-param name="teamData"
                                                    select="concat($team_detail,'@',$doc_strg_code)" />
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                            </div>
                        </div>
                        <div class="row-div">
                            <div class="iconborder pobvalue-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_values.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_values.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    POB Value
                                </div>
                                <div>
                                    <xsl:value-of select="$pob_val" />
                                </div>
                            </div>
                        </div>

                        <xsl:if test="normalize-space($dcr_group)='O'">                    
                            <div class="row-div">
                                <div class="iconborder euin-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        EUIN No
                                    </div>
                                    <xsl:if test="normalize-space($contact_pers) != '' ">
                                    	<div>
                                         	<xsl:value-of select="concat($contact_pers_name,' (',$contact_pers,')')" />
                                        </div>
                                    </xsl:if>
                                </div>
                            </div>
                            <div class="row-div">
                                <div class="iconborder regno-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        ARN No
                                    </div>
                                    <div>
                                        <xsl:value-of select="$reg_no" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>

                        <div class="row-div">
                            <div class="iconborder remarks-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_remarks.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Remarks
                                </div>
                                <div class="hideoverflowfeed">
                                    <!--<xsl:call-template name="meetTemp">
                                        <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                                    <xsl:value-of select="$meet_summ" />
                                </div>
                            </div>
                        </div>
                    </xsl:if>

                                    
                    <xsl:if
                        test="contains($customer_types, 'UNLISTED')">
                        <xsl:if
                            test="normalize-space($strg_type)='C' or normalize-space($doc_strg_code) ='UR00000000'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-chem-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_chem.svg"
                                    onerror='this.src="../webitm/images/Summary/unlisted_chem.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Chemists
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </div>    
                            </div>
                                <!--<xsl:value-of
                                    select="concat($doc_strg_name,' - ',$member_presents)" />-->
                        </xsl:if>
                        <xsl:if
                            test="normalize-space($strg_type)='D' or normalize-space($doc_strg_code) ='0000000000'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-doc-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_doc.svg"
                                        onerror='this.src="../webitm/images/Summary/unlisted_doc.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div> 
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Doctors
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </div>
                            </div>
                                <!--<xsl:value-of
                                    select="concat('No Of Unlisted Doctors',' - ',$member_presents)" />-->
                        </xsl:if> 
                        <xsl:if
                            test="normalize-space($strg_type)='S'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-sto-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_stockist.svg"
                                        onerror='this.src="../webitm/images/Summary/unlisted_stockist.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div> 
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Stockists
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
                        <xsl:if
                            test="normalize-space($dcr_group)='O'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-ncw-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_others.svg"
                                        onerror='this.src="../webitm/images/Summary/unlisted_others.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div> 
                                <div class="addspace large-font">
                                	<div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Customers
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                   <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div class="small-font">
                                    <xsl:if
                                        test="normalize-space($dcr_group) = 'O'">
                                        <span class="textcolor"> Meeting Status </span> 
                                           <xsl:value-of select="concat($doc_call_outcome,',',' ')" />
                                         <span class="textcolor">Customer Type </span> 
                                                <xsl:value-of select="concat($type_of_customer,',',' ')" />
                                          <span class="textcolor">Activity </span> 
                                                <xsl:value-of select="concat($event_type_descr,' ')" />    
                                    </xsl:if>
                                </div>
                                </div>
                                
                            </div>
                        </xsl:if>
                
                        <div class="customerDiv">
                            
                            <div class="iconborder visitedwith-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($visited_with_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($visited_with_name)}"
                                    onerror='this.src="../webitm/images/Summary/summary_visited.svg"' class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Visited With
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:choose>
                                        <xsl:when test="$team_listed_count > '0'">
                                            <xsl:call-template name="tempTeamData">
                                                <xsl:with-param name="teamData"
                                                    select="concat($team_detail,'@',$doc_strg_code)" />
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                            </div>
                        </div>
                        <div class="customerDiv">
                            <div class="iconborder timeofcall-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Time of First call
                                </div>
                                <div>
                                    <xsl:value-of select="$event_time_start" />
                                </div>
                            </div>
                        </div>
                        <div class="customerDiv">
                            <div class="iconborder timeofcall-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Time of Last call
                                </div>
                                <div>
                                    <xsl:value-of select="$event_time_end" />
                                </div>
                            </div>
                        </div>
                        <div class="customerDiv">
                            <div class="iconborder pobvalue-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_values.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_values.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    POB Value
                                </div>
                                <div>
                                    <xsl:value-of select="$pob_val" />
                                </div>
                            </div>
                        </div>

                        <xsl:if test="normalize-space($dcr_group)='O'">                    
                            <div class="customerDiv">
                                <div class="iconborder euin-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        EUIN No
                                    </div>
                                    <xsl:if test="normalize-space($contact_pers) != '' ">
                                    	<div>
                                         	<xsl:value-of select="concat($contact_pers_name,' (',$contact_pers,')')" />
                                        </div>
                                    </xsl:if>
                                </div>
                            </div>
                            <div class="customerDiv">
                                <div class="iconborder regno-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        ARN No
                                    </div>
                                    <div>
                                        <xsl:value-of select="$reg_no" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>

                        <div class="customerDiv">
                            <div class="iconborder remarks-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_remarks.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Remarks
                                </div>
                                <div class="hideoverflowfeed">
                                    <!--<xsl:call-template name="meetTemp">
                                        <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                                    <xsl:value-of select="$meet_summ" />
                                </div>
                            </div>
                        </div>
                    </xsl:if>

											<!--<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Remarks:
												<xsl:call-template name="meetTemp">
													<xsl:with-param name="stringtosplitRemark"
														select="$meet_summ" />
												</xsl:call-template>
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>-->
						<!-- //Changed by Pooja S on 29-JULY-2020 [Survey and Coaching related detail form implementation] Start -->
                    <xsl:call-template name="tempOrderDataFeed">
                        <xsl:with-param name="orderData"
                            select="concat($item_detail,'@',$doc_strg_code,'#',$item_listed_count,'{',$brand_listed_count,'}',$brand_detail,'***',$coaching_listed_count,'###',$coaching_detail,'@@@',$customer_types,'####', $host_url,'[',$ord_detail,']',$ord_listed_count,'~',$survey_detail,'^',$survey_listed_count,'@@@@',$display_detail,'#####',$display_listed_count)" />
                    
                    </xsl:call-template>

                </div>
					<!--</thead>
				</TABLE>-->
			</xsl:when>
			<xsl:otherwise>
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">

								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="../webitm/images/Summary/errUser.png"'
											class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">
										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500;">
												<xsl:choose>
													<xsl:when
														test="contains($customer_types, 'UNLISTED-CHEMIST') and normalize-space($doc_strg_code) = 'UR00000000'">
														<xsl:value-of
															select="concat($doc_strg_name,' - ',$member_presents)" />
													</xsl:when>
													<xsl:when
														test="contains($customer_types, 'UNLISTED-DOCTOR') and  normalize-space($doc_strg_code) = '0000000000'">
														<xsl:value-of
															select="concat('No Of Unlisted Doctors',' - ',$member_presents)" />
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of
															select="concat($doc_strg_name,'  ',$call_outcome_descr)" />
													</xsl:otherwise>
												</xsl:choose>
											</div>






											<xsl:if test="normalize-space($doc_locality) != ''">
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Place Of Work:
													<xsl:value-of select="$doc_locality" />
												</div>
											</xsl:if>

											<xsl:if
												test="not(contains($customer_types, 'UNLISTED')) and normalize-space($strg_type) = 'D'">
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Class:
													<xsl:value-of select="$class_descr" />
												</div>
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Speciality:
													<xsl:value-of select="$spl_description" />
												</div>
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Visit Plan:
													<xsl:value-of select="$no_visit" />
												</div>

											</xsl:if>
											<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Visited With :
												<xsl:choose>
													<xsl:when test="$team_listed_count > '0'">
														<xsl:call-template name="tempTeamData">
															<xsl:with-param name="teamData"
																select="concat($team_detail,'@',$doc_strg_code)" />
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
													</xsl:otherwise>
												</xsl:choose>
											</div>

											<xsl:choose>
												<xsl:when
													test="contains($customer_types, 'UNLISTED')">
													<div
														style="color:#666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Time Of First Call:
														<xsl:value-of select="$event_time_start" />
													</div>
													<div
														style="color:#666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Time Of Last Call:
														<xsl:value-of select="$event_time_end" />
													</div>
												</xsl:when>
												<xsl:otherwise>
													<div
														style="color:#666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Visited Time:
														<xsl:value-of select="$event_time_start" />
													</div>

												</xsl:otherwise>
											</xsl:choose>

											<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												POB Value:
												<xsl:value-of select="$pob_val" />
											</div>

											<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Remarks:
												<xsl:call-template name="meetTemp">
													<xsl:with-param name="stringtosplitRemark"
														select="$meet_summ" />
												</xsl:call-template>
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>
					</thead>
				</TABLE>-->
                <div>
                    <xsl:if
                        test="not(contains($customer_types, 'UNLISTED'))">
                        <div class="customerDiv">
                            <div class="iconborder bluebg-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
                                    onerror='this.src="../images/map/user.png"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>  
                            <div class="addspace large-font">
                                <div>
                                    <xsl:value-of
                                        select="concat($doc_strg_name,',',' ')" />
                                <!--<xsl:value-of
                                    select="concat($doc_strg_name,' ',$call_outcome_descr)" />-->
                                    <xsl:if test="normalize-space($doc_locality) != ''">
                                        <div class="align-customer">
                                            <IMG
                                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place_alt.svg"
                                                onerror='this.src="../webitm/images/Summary/summary_place_alt.svg"'
                                                class="cust-location align-imgtext">
                                            </IMG>
                                            <xsl:value-of select="$doc_locality" />
                                        </div>
                                    </xsl:if>
                                </div>
                                <div class="small-font">
                                    <xsl:if
                                        test="normalize-space($strg_type) = 'D'">
                                        <span class="textcolor">Speciality  </span>
                                            <xsl:value-of select="concat($spl_description,',',' ')" />
                                        <span class="textcolor">Class  </span> 
                                            <xsl:value-of select="$class_descr" />
                                    </xsl:if>
                                    <xsl:if
                                        test="normalize-space($dcr_group) = 'O'">
                                        <span class="textcolor"> Meeting Status </span> 
                                           <xsl:value-of select="concat($doc_call_outcome,',',' ')" />
                                         <span class="textcolor">Customer Type </span> 
                                                <xsl:value-of select="concat($type_of_customer,',',' ')" />
                                          <span class="textcolor">Activity </span> 
                                                <xsl:value-of select="concat($event_type_descr,' ')" /> 
                                    </xsl:if>
                                </div> 
                            </div>
                            
                            <div class="rightcol-spacing">
                                <div> 
                                    <span class="textcolor">Visit Time  </span> 
                                    <span> <xsl:value-of select="$event_time_start" /> </span>
                                </div>
                                <xsl:if
                                    test="normalize-space($strg_type) = 'D'">
                                    <div> 
                                        <span class="textcolor">Visit Plan  </span>  
                                        <span> <xsl:value-of select="$no_visit" /> </span>  
                                    </div>
                                </xsl:if>  
                            </div> 
                            
                        </div> 
                        <div class="row-div">
                            
                            <div class="iconborder visitedwith-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($visited_with_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($visited_with_name)}"
                                    onerror='this.src="../webitm/images/Summary/summary_visited.svg"' class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Visited With
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:choose>
                                        <xsl:when test="$team_listed_count > '0'">
                                            <xsl:call-template name="tempTeamData">
                                                <xsl:with-param name="teamData"
                                                    select="concat($team_detail,'@',$doc_strg_code)" />
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                            </div>
                        </div>
                        <div class="row-div">
                            <div class="iconborder pobvalue-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_values.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_values.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    POB Value
                                </div>
                                <div>
                                    <xsl:value-of select="$pob_val" />
                                </div>
                            </div>
                        </div>

                        <xsl:if test="normalize-space($dcr_group)='O'">                    
                            <div class="row-div">
                                <div class="iconborder euin-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        EUIN No
                                    </div>
                                    <xsl:if test="normalize-space($contact_pers) != '' ">
                                    	<div>
                                         	<xsl:value-of select="concat($contact_pers_name,' (',$contact_pers,')')" />
                                        </div>
                                    </xsl:if>
                                </div>
                            </div>
                            <div class="row-div">
                                <div class="iconborder regno-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        ARN No
                                    </div>
                                    <div>
                                        <xsl:value-of select="$reg_no" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>

                        <div class="row-div">
                            <div class="iconborder remarks-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_remarks.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Remarks
                                </div>
                                <div class="hideoverflowfeed">
                                    <!--<xsl:call-template name="meetTemp">
                                        <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                                    <xsl:value-of select="$meet_summ" />
                                </div>
                            </div>
                        </div>
                    </xsl:if>

                                    
                    <xsl:if
                        test="contains($customer_types, 'UNLISTED')">
                        <xsl:if
                            test="normalize-space($strg_type)='C' or normalize-space($doc_strg_code) ='UR00000000'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-chem-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_chem.svg"
                                    onerror='this.src="../webitm/images/Summary/unlisted_chem.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Chemists
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </div>    
                            </div>
                                <!--<xsl:value-of
                                    select="concat($doc_strg_name,' - ',$member_presents)" />-->
                        </xsl:if>
                        <xsl:if
                            test="normalize-space($strg_type)='D' or normalize-space($doc_strg_code) ='0000000000'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-doc-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_doc.svg"
                                        onerror='this.src="../webitm/images/Summary/unlisted_doc.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div> 
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Doctors
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </div>
                            </div>
                                <!--<xsl:value-of
                                    select="concat('No Of Unlisted Doctors',' - ',$member_presents)" />-->
                        </xsl:if> 
                        <xsl:if
                            test="normalize-space($strg_type)='S'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-sto-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_stockist.svg"
                                        onerror='this.src="../webitm/images/Summary/unlisted_stockist.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div> 
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Stockists
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
                        <xsl:if
                            test="normalize-space($dcr_group)='O'">
                            <div class="customerDiv">
                                <div class="iconborder unlistedcust-ncw-icon">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/unlisted_others.svg"
                                        onerror='this.src="../webitm/images/Summary/unlisted_others.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div> 
                                <div class="addspace large-font">
                                	<div class="detailtext headerfontsize">
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                No. of Customers
                                            </xsl:when>
                                            <xsl:otherwise>
                                                Customer Name
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                   <div>
                                        <xsl:choose>
                                            <xsl:when test="$is_member_presents = 'Y'">
                                                <xsl:value-of
                                                    select="concat($member_presents,' ',' ')" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:value-of
                                                    select="concat(' ',' ',$doc_strg_name)" />
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </div>
                                    <div class="small-font">
                                    <xsl:if
                                        test="normalize-space($dcr_group) = 'O'">
                                        <span class="textcolor"> Meeting Status </span> 
                                           <xsl:value-of select="concat($doc_call_outcome,',',' ')" />
                                         <span class="textcolor">Customer Type </span> 
                                                <xsl:value-of select="concat($type_of_customer,',',' ')" />
                                          <span class="textcolor">Activity </span> 
                                                <xsl:value-of select="concat($event_type_descr,' ')" />    
                                    </xsl:if>
                                </div>
                                </div>
                                
                            </div>
                        </xsl:if>
                
                        <div class="customerDiv">
                            
                            <div class="iconborder visitedwith-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($visited_with_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($visited_with_name)}"
                                    onerror='this.src="../webitm/images/Summary/summary_visited.svg"' class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Visited With
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:choose>
                                        <xsl:when test="$team_listed_count > '0'">
                                            <xsl:call-template name="tempTeamData">
                                                <xsl:with-param name="teamData"
                                                    select="concat($team_detail,'@',$doc_strg_code)" />
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:otherwise>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                            </div>
                        </div>
                        <div class="customerDiv">
                            <div class="iconborder timeofcall-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Time of First call
                                </div>
                                <div>
                                    <xsl:value-of select="$event_time_start" />
                                </div>
                            </div>
                        </div>
                        <div class="customerDiv">
                            <div class="iconborder timeofcall-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Time of Last call
                                </div>
                                <div>
                                    <xsl:value-of select="$event_time_end" />
                                </div>
                            </div>
                        </div>
                        <div class="customerDiv">
                            <div class="iconborder pobvalue-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_values.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_values.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    POB Value
                                </div>
                                <div>
                                    <xsl:value-of select="$pob_val" />
                                </div>
                            </div>
                        </div>

                        <xsl:if test="normalize-space($strg_type)='O' or normalize-space($dcr_group)='O'">                    
                            <div class="customerDiv">
                                <div class="iconborder euin-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        EUIN No
                                    </div>
                                    <xsl:if test="normalize-space($contact_pers) != '' ">
                                    	<div>
                                         	<xsl:value-of select="concat($contact_pers_name,' (',$contact_pers,')')" />
                                        </div>
                                    </xsl:if>
                                </div>
                            </div>
                            <div class="customerDiv">
                                <div class="iconborder regno-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        ARN No
                                    </div>
                                    <div>
                                        <xsl:value-of select="$reg_no" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>

                        <div class="customerDiv">
                            <div class="iconborder remarks-icon">
                                <IMG
                                    SRC="{normalize-space($host_url)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_remarks.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Remarks
                                </div>
                                <div class="hideoverflowfeed">
                                    <!--<xsl:call-template name="meetTemp">
                                        <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                                    <xsl:value-of select="$meet_summ" />
                                </div>
                            </div>
                        </div>
                    </xsl:if>
                    <xsl:if test="normalize-space($strg_type) = 'D'">
                        <xsl:choose>
                            <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                                <div class="itemlabel datafontsize">
                                    No Gift/Samples
                                </div>
                            </xsl:when>
                            <xsl:when test="contains($customer_types, 'UNLISTED')">
                                <div class="itemlabel-unlisted datafontsize">
                                    No Gift/Samples
                                </div>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
                </div>
			</xsl:otherwise>
		</xsl:choose>
        <!-- Added by Jatin M on 15-MAR-2021 for Look and Feel - Feed View - Ends -->
	</xsl:template>
	<xsl:template name="meetTemp">
		<xsl:param name="stringtosplitRemark" />
		<xsl:variable name="first"
			select="substring-before($stringtosplitRemark, ',')" />
		<xsl:variable name="remaining"
			select="substring-after($stringtosplitRemark, ',')" />
		<xsl:variable name="value">
			<xsl:value-of select="$first" />
		</xsl:variable>
		<xsl:variable name="type">
			<xsl:value-of select="substring($value,6,1)" />
		</xsl:variable>
		<xsl:variable name="text">
			<xsl:value-of select="substring($value,8)" />
		</xsl:variable>
		<xsl:variable name="remark">
			<xsl:choose>
				<xsl:when test="($type='C') ">
					<xsl:value-of select="$text" />
					[Complaint]
					<br />
				</xsl:when>
				<xsl:when test="($type='R') ">
					<xsl:value-of select="$text" />
					[Request]
					<br />
				</xsl:when>
				<xsl:when test="($type='Q') ">
					<xsl:value-of select="$text" />
					[Query]
					<br />
				</xsl:when>
				<xsl:when test="($type='P') ">
					<xsl:value-of select="$text" />
					[Compliment]
					<br />
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="concat($remark,' ')" />
		<xsl:if test="$remaining">
			<xsl:call-template name="meetTemp">
				<xsl:with-param name="stringtosplitRemark"
					select="$remaining" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="tempTeamData">
		<xsl:param name="teamData" />
		<xsl:variable name="team_data_value">
			<xsl:value-of select="$teamData" />
		</xsl:variable>
		<xsl:variable name="team_details">
			<xsl:value-of
				select="substring-before($team_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="team_cust_code">
			<xsl:value-of
				select="substring-after($team_data_value,'@')" />
		</xsl:variable>
		<xsl:for-each
			select="//node()[starts-with(name(), $team_details)]">
			<xsl:if test="attribute/@updateFlag!='D'">
				<xsl:variable name="team_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:variable name="name">
					<xsl:value-of select="name" />
				</xsl:variable>
				<xsl:variable name="sales_pers">
					<xsl:value-of select="sales_pers" />
				</xsl:variable>
				<xsl:variable name="visited_with_display">
					<xsl:value-of select="visited_with_display" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($team_strg_code) = normalize-space($team_cust_code)">
					<xsl:value-of select="$visited_with_display" />
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>


	<xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="item_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="item_form_cnt">
			<xsl:value-of
			select="substring-before(substring-after($order_data_value,'#'),'{')" />
		</xsl:variable>
		
		<!-- //Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] Start -->
		<xsl:variable name="brand_form_cnt">
			<xsl:value-of select="substring-before(substring-after($order_data_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="brand_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'}'),'***')" />
		</xsl:variable>
		<!-- surey Details End -->
		<xsl:variable name="coaching_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'***'),'###')" />
		</xsl:variable>
		
        <xsl:variable name="coaching_details">
			<xsl:value-of select="substring-before(substring-after($order_data_value,'###'),'@@@')" />
		</xsl:variable>

        <xsl:variable name="customer_types">
			<xsl:value-of select="substring-before(substring-after($order_data_value,'@@@'),'####')" />
		</xsl:variable>

        <xsl:variable name="ord_data_host_url">
        			<xsl:value-of select="substring-before(substring-after($order_data_value,'####'),'[')" />
        </xsl:variable>
		
			<xsl:variable name="order_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'['),']')" />
		</xsl:variable>
		
        <xsl:variable name="order_form_cnt">
        			<xsl:value-of select="substring-before(substring-after($order_data_value,']'),'~')" />
		</xsl:variable>

		<xsl:variable name="survey_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'~'),'^')" />
		</xsl:variable>

		<xsl:variable name="survey_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'^'),'@@@@')" />		
				</xsl:variable>
		<xsl:variable name="display_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@@@@'),'####')" />
		</xsl:variable>

		<xsl:variable name="display_form_cnt">
						<xsl:value-of select="substring-after($order_data_value,'#####')" />
		</xsl:variable>

        <xsl:variable name="domID">
			<xsl:value-of select="@domID" />
		</xsl:variable>
		<!-- //Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] end -->

		<!-- Added by Jatin M for New Summary Look and Feel - Feed View Subform on 15-MAR-2021 [Start]-->
		
		<xsl:if test="normalize-space($order_form_cnt) > 0">				
			<xsl:variable name="ordCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $order_details)]">
                    <xsl:variable name="ord_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>                    		                    
                    
                    <xsl:if
                        test="normalize-space($ord_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($ord_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                    <div class="itemlabel datafontsize">
                        <xsl:value-of select="string-length(normalize-space($ordCnt))" /> Orders
                    </div>
                </xsl:when>
                <xsl:when test="contains($customer_types, 'UNLISTED')">
                   
                    <div class="itemlabel-unlisted datafontsize">
                        <xsl:value-of select="string-length(normalize-space($ordCnt))" /> Orders
                    </div>
                </xsl:when>
            </xsl:choose>
            <div class="mobviewDiv">
				<xsl:for-each
					select="//node()[starts-with(name(), $order_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="ord_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="ordervalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="Scheme_description">
							<xsl:value-of select="description" />
						</xsl:variable>
						<xsl:variable name="item_code">
                            <xsl:value-of select="item_code" />
                        </xsl:variable>
						<xsl:variable name="remark_descr">
                            <xsl:value-of select="remark_descr" />
                        </xsl:variable>
                        <xsl:variable name="order_remarks">
                            <xsl:value-of select="remarks_ord" />
                        </xsl:variable>
						<xsl:if
							test="normalize-space($ord_strg_code) = normalize-space($dcotor_cust_code)">
							<div class="itemOuterDiv">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                    <div class="sample-order-div">
                                        <div>
                                            <div class="iconborder product-icon align-imgtext">
                                                <IMG
                                                    SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($item_code)}&amp;object=wsfa_item&amp;objName=wsfa_item&amp;ALT_FLD_VALUE={normalize-space($item_descr)}"
                                                    onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
                                                </IMG>
                                            </div>
                                        </div>
										<div>
											<div class="itmdescrFeed">
												<div class="namespacing align-imgtext adjMargin">
													<div class="hideoverflowfeed datafontsize">
														<xsl:value-of select="$item_descr" />
													</div>
                                                    <xsl:if test="normalize-space($Scheme_description) != '' ">
                                                        <div class="headerfontsize alignLeft">
                                                            <xsl:value-of select="$Scheme_description" />
                                                        </div>
                                                    </xsl:if>
												</div>
												<div class="align-imgtext rightcol-spacing adjPadding">
													<div class="datafontsize">
														<span class="headerfontsize"> Qty </span>
														<xsl:value-of
															select="$quantity" />
													</div>
													<div class="datafontsize"> 
														<span class="headerfontsize"> &#x20b9; </span>
														<xsl:value-of
															select="$ordervalue" /> 
													</div>
												</div>
											</div>
											
                                            <xsl:if test="normalize-space($remark_descr) != '' ">
												<div class="datafontsize alignLeft">
													<span class="headerfontsize"> Focus Deviation Reason : </span> <xsl:value-of select="$remark_descr" />
												</div>
											</xsl:if>
                                            <xsl:if test="normalize-space($order_remarks) != '' ">
                                                <div class="datafontsize alignLeft"> <span class="headerfontsize"> Remarks : </span> <xsl:value-of select="$order_remarks" /> </div>
                                            </xsl:if>
                                        </div>
                                    </div>
                                    <div class="horizontal-border"></div>
                                </xsl:if>
                                <xsl:if test="contains($customer_types, 'UNLISTED')">
                                    <div class="sample-order-div-unlisted">
                                        <div>
                                            <div class="iconborder product-icon align-imgtext">
                                                <IMG
                                                    SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($item_code)}&amp;object=wsfa_item&amp;objName=wsfa_item&amp;ALT_FLD_VALUE={normalize-space($item_descr)}"
                                                    onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
                                                </IMG>
                                            </div>
                                        </div>
										<div>
											<div class="itmdescrFeed">
												<div class="hideoverflowfeed namespacing datafontsize align-imgtext adjMargin">
													<div>
														<xsl:value-of select="$item_descr" />
													</div>
                                                    <xsl:if test="normalize-space($Scheme_description) != '' ">
                                                        <div class="headerfontsize alignLeft">
                                                            <xsl:value-of select="$Scheme_description" />
                                                        </div>
                                                    </xsl:if>
												</div>
												<div class="align-imgtext rightcol-spacing adjPadding">
													<div class="datafontsize">
														<span class="headerfontsize"> Qty </span>
														<xsl:value-of
															select="$quantity" />
													</div>
													<div class="datafontsize"> 
														<span class="headerfontsize"> &#x20b9; </span>
														<xsl:value-of
															select="$ordervalue" /> 
													</div>
												</div>
											</div>
                                            <xsl:if test="normalize-space($remark_descr) != '' ">
												<div class="datafontsize alignLeft">
													<span class="headerfontsize"> Focus Deviation Reason : </span> <xsl:value-of select="$remark_descr" />
												</div>
											</xsl:if>
                                            <xsl:if test="normalize-space($order_remarks) != '' ">
                                                <div class="datafontsize alignLeft"> <span class="headerfontsize"> Remarks : </span> <xsl:value-of select="$order_remarks" /> </div>
                                            </xsl:if>
										</div>
                                    </div>
                                    <div class="horizontal-unlisted-border"></div>
                                </xsl:if>
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</div>
				<!--</tbody>
			</TABLE>-->
		</xsl:if>
		
		<!-- Survey Details Start -->
		<xsl:if test="normalize-space($survey_form_cnt) > 0">
			<xsl:variable name="surveyCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $survey_details)]">
                    <xsl:variable name="survey_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($survey_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($survey_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                    <div class="itemlabel datafontsize">
                        <xsl:value-of select="string-length(normalize-space($surveyCnt))" /> Surveys
                    </div>
                </xsl:when>
                <xsl:when test="contains($customer_types, 'UNLISTED')">
                    <div class="itemlabel-unlisted datafontsize">
                        <xsl:value-of select="string-length(normalize-space($surveyCnt))" /> Surveys
                    </div>
                </xsl:when>
            </xsl:choose>
					<div class="mobDivView">
						<xsl:for-each select="//node()[starts-with(name(), $survey_details)]">
								<xsl:sort select="survey_group_descr" />
								<xsl:sort select="survey_descr" />
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="survey_group_descr">
										<xsl:value-of select="survey_group_descr" />
									</xsl:variable>
									<xsl:variable name="survey_descr">
										<xsl:value-of select="survey_descr" />
									</xsl:variable>
									<xsl:variable name="survey_strg_code">
				                        <xsl:value-of select="strg_code" />
				                    </xsl:variable>
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<xsl:variable name="result_format">
										<xsl:value-of select="result_format" />
									</xsl:variable>
									<xsl:variable name="surv_doc_id">
										<xsl:value-of select="doc_id_2" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'N'">
												<xsl:value-of select="result1" />
											</xsl:when>
											<xsl:when test="$result_type = 'T'">
												<xsl:value-of select="result3" />
											</xsl:when>
											<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
												<xsl:value-of select="result4" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="result2" />
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:if
										test="normalize-space($survey_strg_code) = normalize-space($dcotor_cust_code)">
											<xsl:choose>
												<xsl:when test="position() = '1' or $survey_group_descr != preceding-sibling::*[1][attribute/@selected!='N']/survey_group_descr">												
												<div class="itemOuterDiv">
					                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
					                                    <div class="gift-sample-div">
					                                        <div class="iconborder product-icon align-imgtext">
					                                            <IMG
					                                                SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($survey_descr)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($survey_descr)}"
					                                                onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
					                                            </IMG>
					                                        </div>
					                                        <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
					                                            <xsl:value-of select="$survey_descr" />
					                                        </div>
					                                        <div class=" align-imgtext rightcol-spacing">
					                                        	<div class="headerfontsize"> Survey Result </div>
					                                            <div>
					                                                <xsl:choose>
																		<xsl:when test="$result = 'Y'">
																			Yes
																		</xsl:when>
																		<xsl:when test="$result = 'N'">
																			No
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="$result" />
																		</xsl:otherwise>
																	</xsl:choose>
					                                            </div>
					                                        </div>
					                                    </div>
					                                    <div class="horizontal-border"></div>
					                                </xsl:if>
					                                <xsl:if test="contains($customer_types, 'UNLISTED')">
					                                    <div class="gift-sample-div-unlisted">
					                                        <div class="iconborder product-icon align-imgtext">
					                                            <IMG
					                                                SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($survey_descr)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($survey_descr)}"
					                                                onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
					                                            </IMG>
					                                        </div>
					                                        <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
					                                            <xsl:value-of select="$survey_descr" />
					                                        </div>
					                                        <div class=" align-imgtext rightcol-spacing">
					                                        	<div class="headerfontsize"> Survey Result </div>
					                                            <div>
					                                                <xsl:choose>
																		<xsl:when test="$result = 'Y'">
																			Yes
																		</xsl:when>
																		<xsl:when test="$result = 'N'">
																			No
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:value-of select="$result" />
																		</xsl:otherwise>
																	</xsl:choose>
					                                            </div>
					                                        </div>
					                                    </div>
					                                    <div class="horizontal-unlisted-border"></div>
					                                </xsl:if>
					                            </div>
												</xsl:when>
												<xsl:otherwise>									
													<div class="itemOuterDiv">
						                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
						                                    <div class="gift-sample-div">
						                                        <div class="iconborder product-icon align-imgtext">
						                                            <IMG
						                                                SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($survey_descr)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($survey_descr)}"
						                                                onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
						                                            </IMG>
						                                        </div>
						                                        <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
						                                            <xsl:value-of select="$survey_descr" />
						                                        </div>
						                                        <div class=" align-imgtext rightcol-spacing">
						                                        	<div class="headerfontsize"> Survey Result </div>
						                                            <div>
						                                                <xsl:choose>
																			<xsl:when test="$result = 'Y'">
																				Yes
																			</xsl:when>
																			<xsl:when test="$result = 'N'">
																				No
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="$result" />
																			</xsl:otherwise>
																		</xsl:choose>
						                                            </div>
						                                        </div>
						                                    </div>
						                                    <div class="horizontal-border"></div>
						                                </xsl:if>
						                                <xsl:if test="contains($customer_types, 'UNLISTED')">
						                                    <div class="gift-sample-div-unlisted">
						                                        <div class="iconborder product-icon align-imgtext">
						                                            <IMG
						                                                SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($survey_descr)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($survey_descr)}"
						                                                onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
						                                            </IMG>
						                                        </div>
						                                        <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
						                                            <xsl:value-of select="$survey_descr" />
						                                        </div>
						                                        <div class=" align-imgtext rightcol-spacing">
						                                        	<div class="headerfontsize"> Survey Result </div>
						                                            <div>
						                                                <xsl:choose>
																			<xsl:when test="$result = 'Y'">
																				Yes
																			</xsl:when>
																			<xsl:when test="$result = 'N'">
																				No
																			</xsl:when>
																			<xsl:otherwise>
																				<xsl:value-of select="$result" />
																			</xsl:otherwise>
																		</xsl:choose>
						                                            </div>
						                                        </div>
						                                    </div>
						                                    <div class="horizontal-unlisted-border"></div>
						                                </xsl:if>
						                            </div>
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="not(contains($customer_types, 'UNLISTED'))">
													<div class="displayplugin gift-sample-div">
															<div align='left' id="__attachmentDiv.{normalize-space(concat($surv_doc_id,'feed_list'))}" style="text-align:center;white-space:nowrap;"></div>
															<img style="height:0px;width:0px;" src="_"
																onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space(concat($surv_doc_id,'feed_list'))}', 'strg_meet_dcr_wiz', 'M-DCR', '{normalize-space($surv_doc_id)}'); this.remove();" />
													</div>
												</xsl:when>
												<xsl:when test="contains($customer_types, 'UNLISTED')">
													<div class="displayplugin gift-sample-div-unlisted">
															<div align='left' id="__attachmentDiv.{normalize-space(concat($surv_doc_id,'feed_unlist'))}" style="text-align:center;white-space:nowrap;"></div>
															<img style="height:0px;width:0px;" src="_"
																onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space(concat($surv_doc_id,'feed_unlist'))}', 'strg_meet_dcr_wiz', 'M-DCR', '{normalize-space($surv_doc_id)}'); this.remove();" />
													</div>
												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:if>
								</xsl:if>
							</xsl:for-each>
						</div>
		</xsl:if>
		<!-- Survey Details end -->
		
		<xsl:if test="normalize-space($display_form_cnt) > 0">
			
			<xsl:variable name="dispCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $display_details)]">
                    <xsl:variable name="display_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($display_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($display_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                    <div class="itemlabel datafontsize">
                        <xsl:value-of select="string-length(normalize-space($dispCnt))" /> Displays
                    </div>
                </xsl:when>
                <xsl:when test="contains($customer_types, 'UNLISTED')">
                    <div class="itemlabel-unlisted datafontsize">
                        <xsl:value-of select="string-length(normalize-space($dispCnt))" /> Displays
                    </div>
                </xsl:when>
            </xsl:choose>
            
            <div class="mobviewDiv">
				<xsl:for-each
					select="//node()[starts-with(name(), $display_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="doc_id">
							<xsl:value-of select="doc_id" />
						</xsl:variable>
						<xsl:variable name="display_area">
							<xsl:value-of select="display_area" />
						</xsl:variable>
						<xsl:variable name="display_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($display_strg_code) = normalize-space($dcotor_cust_code)">
							
							<div class="itemOuterDiv">
		                        <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
		                            <div class="gift-sample-div">
		                                <div class="iconborder product-icon align-imgtext">
		                                    <IMG
		                                        SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($display_area)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($display_area)}"
		                                        onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
		                                    </IMG>
		                                </div>
		                                <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
		                                     <div class="datafontsize">
										   		<xsl:value-of select="$display_area" />
		                                     </div>
		                                </div>
		                            </div>
		                            <div class="horizontal-border"></div>
		                            <div class="displayplugin gift-sample-div">
	                                    <div align='center' id="__attachmentDiv.{normalize-space(concat($doc_id,'_feed_list',''))}"
											style="text-align:center;white-space:nowrap;"></div>
										<img src="_"
											onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space(concat($doc_id,'_feed_list',''))}', 'strg_meet_dcr_wiz', 'M-DCR', '{normalize-space($doc_id)}'); this.remove();" />
	                                </div>
		                        </xsl:if>
		                        <xsl:if test="contains($customer_types, 'UNLISTED')">
		                            <div class="gift-sample-div-unlisted">
		                                <div class="iconborder product-icon align-imgtext">
		                                    <IMG
		                                        SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($display_area)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($display_area)}"
		                                        onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
		                                    </IMG>
		                                </div>
		                                <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
		                                     <div class="datafontsize">
										   		<xsl:value-of select="$display_area" />
		                                     </div>
		                                </div>
		                            </div>
		                            <div class="horizontal-unlisted-border"></div>
		                            <div class="displayplugin gift-sample-div-unlisted">
	                                    <div align='center' id="__attachmentDiv.{normalize-space(concat($doc_id,'_feed_unlist',''))}"
											style="text-align:center;white-space:nowrap;"></div>
										<img src="_"
											onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space(concat($doc_id,'_feed_unlist',''))}', 'strg_meet_dcr_wiz', 'M-DCR', '{normalize-space($doc_id)}'); this.remove();" />
	                                </div>
		                        </xsl:if>      
		                    </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</div>
		</xsl:if>
		
		<!-- Item Details Start -->
		
		
		
		
		
		
		
		<xsl:if test="normalize-space($item_form_cnt) > 0">
			<!--<TABLE id="itemTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<tr id="item.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Gift/Sample</th>
						<th></th>
						<th></th>
					</tr>
					<TR id="item.{normalize-space($dcotor_cust_code)}.heading">

						<TH CLASS="cellttl1 cellttlblck heading tdLeft firstData">Input Type</TH>
						<TH CLASS="cellttl1 cellttlblck heading firstData">Product</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdRight firstData">Quantity</TH>
					</TR>
				</thead>-->
            <xsl:variable name="itemCnt">
                <xsl:for-each
                    select="//node()[starts-with(name(), $item_details)]">
                    <xsl:variable name="itm_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    <xsl:if
                        test="normalize-space($itm_strg_code) = normalize-space($dcotor_cust_code)">
                        <xsl:value-of select="count($itm_strg_code)" />
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                    <div class="itemlabel datafontsize">
                        <xsl:value-of select="string-length(normalize-space($itemCnt))" /> Gift/Samples
                    </div>
                </xsl:when>
                <xsl:when test="contains($customer_types, 'UNLISTED')">
                    <div class="itemlabel-unlisted datafontsize">
                        <xsl:value-of select="string-length(normalize-space($itemCnt))" /> Gift/Samples
                    </div>
                </xsl:when>
            </xsl:choose>

            <div class="mobviewDiv">
			    <!--<tbody id="item.{normalize-space($dcotor_cust_code)}.details">-->
                <xsl:for-each
                    select="//node()[starts-with(name(), $item_details)]">

                    <xsl:if test="attribute/@updateFlag!='D'">
                        <xsl:variable name="sample_item_descr">
                            <xsl:value-of select="item_descr" />
                        </xsl:variable>
                        <xsl:variable name="item_quantity">
                            <xsl:value-of select="quantity" />
                        </xsl:variable>
                        <xsl:variable name="item_usage">
                            <xsl:value-of select="item_usage" />
                        </xsl:variable>
                        <xsl:variable name="item_strg_code">
                            <xsl:value-of select="strg_code" />
                        </xsl:variable>
                        <xsl:variable name="item_code">
                            <xsl:value-of select="item_code" />
                        </xsl:variable>
                        <xsl:if
                            test="normalize-space($item_strg_code) = normalize-space($dcotor_cust_code)">
                            <!--<TR style="background-color: #f0eded;">
                                <TD CLASS="cellttl1 tdLeft title">
                                    <xsl:value-of select="$item_usage" />
                                </TD>
                                <TD CLASS="cellttl1 tdCenter title">
                                    <xsl:value-of select="$sample_item_descr" />
                                </TD>
                                <TD CLASS="cellttl1 tdRight title">
                                <xsl:value-of select="$item_quantity" />
                                </TD>

                            </TR>-->

                            <div class="itemOuterDiv">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                    <div class="gift-sample-div">
                                        <div class="iconborder product-icon align-imgtext">
                                            <IMG
                                                SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($item_code)}&amp;object=wsfa_item&amp;objName=wsfa_item&amp;ALT_FLD_VALUE={normalize-space($sample_item_descr)}"
                                                onerror='this.src="../webitm/images/Summary/product.svg"' class="bradius align-imgtext">
                                            </IMG>
                                        </div>
                                        <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
                                            <xsl:value-of select="$sample_item_descr" />
                                        </div>
                                        <div class=" align-imgtext rightcol-spacing">
                                            <div>
                                                <xsl:value-of
                                                    select="$item_quantity" />
                                            </div>
                                            <div class="headerfontsize"> Pieces </div>
                                        </div>
                                    </div>
                                    <div class="horizontal-border"></div>
                                </xsl:if>
                                <xsl:if test="contains($customer_types, 'UNLISTED')">
                                    <div class="gift-sample-div-unlisted">
                                        <div class="iconborder product-icon align-imgtext">
                                            <IMG
                                                SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($item_code)}&amp;object=wsfa_item&amp;objName=wsfa_item&amp;ALT_FLD_VALUE={normalize-space($sample_item_descr)}"
                                                onerror='this.src="../webitm/images/Summary/product.svg"' class="bradius align-imgtext">
                                            </IMG>
                                        </div>
                                        <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
                                            <xsl:value-of select="$sample_item_descr" />
                                        </div>
                                        <div class=" align-imgtext rightcol-spacing">
                                            <div>
                                                <xsl:value-of
                                                    select="$item_quantity" />
                                            </div>
                                            <div class="headerfontsize"> Pieces </div>
                                        </div>
                                    </div>
                                    <div class="horizontal-unlisted-border"></div>
                                </xsl:if>
                            </div>
                        </xsl:if>
                    </xsl:if>
                </xsl:for-each>
                
            </div>
				<!--</tbody>
			</TABLE>-->
		</xsl:if>
        <!-- Added by Jatin M for New Summary Look and Feel - Feed View Subform on 15-MAR-2021 [Start]-->
		<!-- Item Details end -->
		<!-- Survey Details Start -->
		<!-- Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] Start -->
		<xsl:if test="normalize-space($brand_form_cnt) > 0">
		
            <xsl:choose>
                <xsl:when test="not(contains($customer_types, 'UNLISTED'))">
                    <div class="itemlabel datafontsize">
                        Product
                    </div>
                </xsl:when>
                <xsl:when test="contains($customer_types, 'UNLISTED')">
                    <div class="itemlabel-unlisted datafontsize">
                        Product
                    </div>
                </xsl:when>
            </xsl:choose>
          
            <div id="brand.{normalize-space($dcotor_cust_code)}.details">
                <xsl:for-each select="//node()[starts-with(name(), $brand_details)]">
                    <xsl:variable name="brand_descr">
                        <xsl:value-of select="brand_descr" />
                    </xsl:variable>
                    <xsl:variable name="pitch_detail_descr">
                        <xsl:value-of select="pitch_detail_descr" />
                    </xsl:variable>

                    <xsl:variable name="brand_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>


                    <xsl:if
                        test="normalize-space($brand_strg_code) = normalize-space($dcotor_cust_code)">
                        <div class="itemOuterDiv">
                            <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                <div class="gift-sample-div">
                                    <div class="iconborder product-icon align-imgtext">
                                        <IMG
                                            SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($brand_strg_code)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($brand_descr)}"
                                            onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
                                        <xsl:value-of select="$brand_descr" />
                                    </div>
                                    <div class=" align-imgtext rightcol-spacing">
                                        <div>
                                            <xsl:value-of
                                                select="$pitch_detail_descr" />
                                        </div>
                                        <div class="headerfontsize"> status </div>
                                    </div>
                                </div>
                                <div class="horizontal-border"></div>
                            </xsl:if>
                            <xsl:if test="contains($customer_types, 'UNLISTED')">
                                <div class="gift-sample-div-unlisted">
                                    <div class="iconborder product-icon align-imgtext">
                                        <IMG
                                            SRC="{normalize-space($ord_data_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($brand_strg_code)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($brand_descr)}"
                                            onerror='this.src="../images/Summary/product.svg"' class="bradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
                                        <xsl:value-of select="$brand_descr" />
                                    </div>
                                    <div class=" align-imgtext rightcol-spacing">
                                        <div>
                                            <xsl:value-of
                                                select="$pitch_detail_descr" />
                                        </div>
                                        <div class="headerfontsize"> status </div>
                                    </div>
                                </div>
                                <div class="horizontal-unlisted-border"></div>
                            </xsl:if>
                        </div>
                    </xsl:if>
                </xsl:for-each>
            </div>
		</xsl:if>
		<!-- Survey Details end -->

		<xsl:if test="normalize-space($coaching_form_cnt) > 0">
			<TABLE id="coachingTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<tr id="coaching.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Coaching Details</th>
						<th></th>
					</tr>
				</thead>
				<tbody
					id="coaching.{normalize-space($dcotor_cust_code)}.details">
					<xsl:for-each
						select="//node()[starts-with(name(), $coaching_details)]">
						<xsl:if test="attribute/@updateFlag!='D'">
							<xsl:variable name="survey_descr">
									<xsl:value-of select="survey_descr" />
								</xsl:variable>
								<xsl:variable name="result_type">
									<xsl:value-of select="result_type" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] Start -->
								<xsl:variable name="result_format">
									<xsl:value-of select="result_format" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] End -->
								<xsl:variable name="coaching_doc_id">
									<xsl:value-of select="doc_id_1" />
								</xsl:variable>
								<xsl:variable name="result">
									<xsl:choose>
										<xsl:when test="$result_type = 'N'">
											<xsl:value-of select="result1" />
										</xsl:when>
										<xsl:when test="$result_type = 'T'">
											<xsl:value-of select="result3" />
										</xsl:when>
										<xsl:when test="$result_type = 'A'">
											<xsl:value-of select="result5" />
										</xsl:when>
										<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
											<xsl:value-of select="result4" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="result2" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<xsl:variable name="coaching_strg_code">
								<xsl:value-of select="strg_code" />
							</xsl:variable>
							<xsl:if
								test="normalize-space($coaching_strg_code) = normalize-space($dcotor_cust_code)">
								<tr style="background-color: #f0eded;">
									<TD CLASS="cellttl1 title tdLeft">
										<xsl:value-of select="$survey_descr" />
									</TD>
									<TD CLASS="cellttl1 title tdRight">
										<!-- <xsl:value-of select="$result" /> -->
										<xsl:choose>
											<xsl:when test="$result = 'Y'">
												Yes
											</xsl:when>
											<xsl:when test="$result = 'N'">
												No
											</xsl:when>
											<xsl:otherwise>
												<!-- <xsl:value-of select="$result" /> -->
												<xsl:variable name="testVar" select="substring-after($result,'task_descr&quot;:&quot;')" />
												<xsl:value-of select="substring-before($testVar,'&quot;')" />
											</xsl:otherwise>
										</xsl:choose>
									</TD>
								</tr>
								<tr>
									<td>
										<div align='center'
											id="__attachmentDiv.{normalize-space($coaching_doc_id)}"
											style="text-align:center;white-space:nowrap;">
										</div>
									</td>
								</tr>
							</xsl:if>
						</xsl:if>
					</xsl:for-each>
				</tbody>
			</TABLE>
		</xsl:if>
		<!-- //Added by Pooja on 29-JULY-2020 [Survey and Coaching related detail form implementation] end -->

	</xsl:template>
</xsl:stylesheet>
