<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/vision_ui.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					<!-- a {color: #C00;} -->
					details
					{
					box-shadow: 0px -1px 0px 0 rgba(0,0,0,.1);
					color: #363636;
					padding: 0;
					background: #fff;
					}

					details[open]
					{
					}
					summary
					{
					cursor:
					pointer;
					margin: 0;
					position: relative;
					border: 0 none;
					outline: none;
					padding: .5em;

					}
					summary:hover,
					details[open] summary
					{
					}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:white;}
					p {font-size:
					12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}

				</style>

			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ITMWizard.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/e12PluginWrapper.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    
    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>
			<!-- Added by Sagar B. for calling gwt wizard to change travel details 
				[26-Jun-18]START -->
			<script language="JavaScript" type="text/javascript">
				function
				callTravelForm(isMgr)
				{
				console.log('It is coming inside
				callTravelForm() 1689 '+isMgr);
				var dcrDate =
				document.getElementById('EVENT_DATE').value;
				var salesPers =
				document.getElementById('SALES_PERS').value;

				var id="";
				var
				objName="";

				if(isMgr != "")
				{
				console.log('MANGER inside
				callTravelForm() 1689 ');
				objName="strg_meet_mgr_dcr_trv_change";
				}
				else
				{
				console.log('DCR inside callTravelForm() 1689 ');
				objName="strg_meet_dcr_trv_change";
				}


				var objType = "W";
				var
				callReport="Y";
				var title = "Daily Call Reporting";
				var
				qryStr="event_date="+dcrDate+"&amp;OBJ_NAME="+objName+"&amp;sales_pers="+salesPers+"&amp;call_report="+callReport;
				console.log('objName-- '+objName);
				console.log('objType-- '+objType);
				console.log('title-- '+title);
				console.log('id-- '+id);
				console.log('qryStr-- '+qryStr);
				openTransFrmXsl(id, objName,
				objType, title, qryStr );
				}

				function openTransFrmXsl(id, objName,
				objType, title, qryStr )
				{
				console.log('It is coming inside
				openTransFrmXsl 1726 ');
				var Window = window;
				if( window.parent !==
				Window )
				{
				Window = window.parent;
				}
				try
				{
				Window.setWizardParamMapGWT(
				qryStr );
				Window.openTransactionGWT(id, objName, objType, title );
				}
				catch(err)
				{
				console.log('Exception-- '+err.message);
				if(
				err.message.indexOf('origin') != -1 )
				{
				var sendData =
				qryStr+'~~'+id+'~~'+objName+'~~'+objType+'~~'+title;
				Window.postMessage( sendData, '*' );
				}
				}
				document.getElementById('Cancel').click();
				}
			</script>
			<!-- Added by Sagar B. for calling gwt wizard to change travel details 
				[26-Jun-18]END -->
			<body bgcolor='#EEEEEE' onload=""
				style="overflow-x: hidden;margin: 0;overflow-y: auto;padding: 0;">


				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height: 100% !important
					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width: 100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px
					solid grey;}

					div.outerDiv
					{
					border-bottom
					: 1px solid #ebebeb;

					}
					.tdCenter
					{
					text-align: center;

					}
					.tdLeft
					{
					text-align: left;

					}
					.tdRight
					{
					text-align: right;

					}

					.headerTable
					{
					background: #fff;
					box-shadow: 0px -1px 0px 0 rgba(0,0,0,.1);
					}
					.subFormTable
					{
					color:
					gray;
					padding:
					.5em;
					}
					@media
					only
					screen and
					(min-width: 100px) and
					(max-width: 500px)
					{
					.headerTable1
					{
					text-align:center;
					padding-left:
					0;
					}
					}
					.summary
					{
					font-weight: bold;
					color:black;
					text-align:left;
					}
					.title
					{
					font-weight:
					initial;
					font-size:
					14px;
					color:
					#666;
					padding-top: 7px;

					}
					.heading
					{
					font-weight: 500;
					font-size: 12px;
					padding-top: 0;
					padding-bottom:0;
					width:15%

					}

					.mainHeading
					{
					font-weight: 100;
					font-size: 13px;
					padding-top: 0;
					color:#000000;
					padding-bottom:0;
					width:15%

					}
					.headerFont
					{
					font-size:14px;
					}
					.normalFont
					{
					font-size:14px;
					}
					.actionbuttons
					{
					text-align:center;

					}
					.actionbuttonsright
					{
					text-align:right;
					float:
					right;
					}
					.actionbuttonsleft
					{
					text-align:left;
					float: left;
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style='width :98%'>
					<div>

						<div class="headerTable1 headerTable">
							<table id="travelTable" class="tTitleD " border="0"
								cellspacing="1" cellpadding="1" width="100%">
								<xsl:for-each select="//DARDetails//Detail1">
									<xsl:variable name="hostUrl">
										<xsl:value-of select="host_url" />
									</xsl:variable>

									<xsl:variable name="confirmed">
										<xsl:value-of select="confirmed" />
									</xsl:variable>

									<tr>
										<td class="cellttl1" width="auto" style='padding : 10px 10px 0px 10px;'>

											<div class="headerFont" style='text-transform:capitalize;float: left;'>
												<xsl:variable name="sales_pers_name">
													<xsl:value-of select="sales_pers_sp_name" />
												</xsl:variable>
												<xsl:variable name="sales_pers">
													<xsl:value-of select="sales_pers" />
												</xsl:variable>

												<IMG
													SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($sales_pers)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($sales_pers_name)}"
													onerror='this.src="../images/map/user.png"' class="iw-header-userImage"
													style="height: 28px; width: 28px;border-radius:50%;;background:lightgray">
												</IMG>
												<div class="headerFont"
													style='text-transform:capitalize;float:right;padding:4px 5px;'>
													<xsl:value-of select="sales_pers_sp_name" />
													<xsl:value-of select="concat(' (',sales_pers,')')" />
													<br></br>
													<xsl:value-of select="headquarter" />
												</div>
											</div>
											<div class="headerFont"
												style='text-transform:capitalize;float:right;padding:4px 5px;'>
												<xsl:value-of select="event_date" />
											</div>

										</td>
									</tr>






									<tr style="width: 100%;">
										<td class="cellttl1" width="auto" style="text-align:center;">
											<div class=""
												style='text-transform:capitalize;height: 30px;margin: auto;width: 30px;border-radius: 50%;background: lightgray;'>

												<xsl:variable name="event_type">
													<xsl:value-of select="activity_code" />
												</xsl:variable>
												<xsl:variable name="event_descr">
													<xsl:value-of select="activity_descr" />
												</xsl:variable>
												<IMG
													SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($event_type)}&amp;object=wsfa_fieldactivity&amp;objName=wsfa_fieldactivity&amp;ALT_FLD_VALUE={normalize-space($event_descr)}"
													onerror='this.src="images/map/user.png"' class="iw-header-userImage"
													style="height: 15px; width: 15px;padding: 7.5px">
												</IMG>
											</div>
											<span CLASS="normalFont" style="width:auto;color:black;">Activity </span>
											<br />
											<span CLASS="headerFont" style="width:auto;">
												<xsl:value-of select="activity_descr" />
											</span>

										</td>
									</tr>
									<tr style="width: 100%;">
										<td class="cellttl1" width="auto" style="text-align:center;">
											<xsl:variable name="submit_show_date">
												<xsl:value-of select="submit_show_date" />
											</xsl:variable>

											<xsl:variable name="confirmed">
												<xsl:value-of select="confirmed" />
											</xsl:variable>
											<xsl:if test="normalize-space($submit_show_date) != ''">
												<span CLASS="normalFont" style="width:auto;color:black;">Report Status: </span>
												<span CLASS="headerFont" style="width:auto;">
													<xsl:choose>
														<xsl:when test="$confirmed = 'Y'">
															Confirmed On
															<xsl:value-of select="conf_date" />
														</xsl:when>
														<xsl:otherwise>
															Submitted On
															<xsl:value-of select="submit_show_date" />
															But Not confirmed
														</xsl:otherwise>
													</xsl:choose>




												</span>
											</xsl:if>
										</td>
									</tr>

								</xsl:for-each>


							</table>
						</div>



						<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 100%;">

							<div id='dataDiv' class="dataDiv headerTable" style="width:100%;">

								<xsl:variable name="listed_count">
									<xsl:value-of select="count(//DARDetails//Detail2)" />
								</xsl:variable>

								<xsl:if test="normalize-space($listed_count) > '0'">
									<details open="true">
										<summary class="summary headerFont">
											Place Details
											<xsl:variable name="activity_type">
												<xsl:value-of select="//Detail1/activity_type" />
											</xsl:variable>
											<!-- Added By Mrunalini Sinakr On 26-sep-2018 Start -->
											<xsl:variable name="is_mgr">
												<xsl:value-of select="//Detail1/is_mgr" />
											</xsl:variable>
											<!-- Added By Mrunalini Sinakr On 26-sep-2018 End -->
											<xsl:variable name="action">
												<xsl:value-of select="//HeaderData/confirm_or_delete" />
											</xsl:variable>


											<xsl:if test="normalize-space($action) = 'view'">
												<xsl:choose>
													<xsl:when test="$activity_type != 'LEAVE'">
														<a style="color: blue; text-decoration: underline;" id="linkToWizard"
															isMgr='{normalize-space($is_mgr)}'
															onclick="javascript:callTravelForm(this.getAttribute('isMgr'))">Change travel path</a>
													</xsl:when>
												</xsl:choose>
											</xsl:if>
											<!-- Added by Sagar B. for calling gwt wizard to change travel 
												details [26-Jun-18]END -->
										</summary>
										<TABLE style="width:100%; " width="100%" border="0"
											class="tTitleD subFormTable" cellpadding="0" cellspacing="0">
											<xsl:variable name="host_place">
												<xsl:for-each select="//DARDetails//Detail1">
													<xsl:value-of select="host_url" />
												</xsl:for-each>
											</xsl:variable>
											<xsl:variable name="is_mgrs">
												<xsl:value-of select="//Detail1/is_mgr" />
											</xsl:variable>
											<thead class="" style="height : 30px;color:#000000">
												<TR>
													<!-- <TH CLASS= "cellttl1 cellttlblck" STYLE="PADDING: 12PX;border-bottom: 
														#e5e4e9 1px solid;">SN</TH> -->
													<xsl:if test="normalize-space($is_mgrs) !=''">
														<TH CLASS="cellttl1 cellttlblck heading tdLeft normalFont">Emp Place Of Work</TH>
														<TH CLASS="cellttl1 cellttlblck heading tdCenter normalFont">Place of Work</TH>
													</xsl:if>
													<xsl:if test="normalize-space($is_mgrs) =''">
														<TH CLASS="cellttl1 cellttlblck heading tdLeft normalFont">Place of Work</TH>
													</xsl:if>
													<TH CLASS="cellttl1 cellttlblck heading tdCenter normalFont">Journey From</TH>
													<TH CLASS="cellttl1 cellttlblck heading tdCenter normalFont">Travel Mode</TH>
													<TH CLASS="cellttl1 cellttlblck heading normalFont tdRight">Order Of Visit</TH>
												</TR>
											</thead>

											<xsl:for-each select="//DARDetails//Detail2">
												<xsl:variable name="sl_no">
													<xsl:value-of select="sl_no" />
												</xsl:variable>
												<xsl:variable name="sprs_route_frm_descr">
													<xsl:value-of select="sprs_route_frm_descr" />
												</xsl:variable>
												<xsl:variable name="sprs_route_descr">
													<xsl:value-of select="sprs_route_descr" />
												</xsl:variable>
												<xsl:variable name="travel_mode">
													<xsl:value-of select="travel_mode" />
												</xsl:variable>
												<xsl:variable name="order_of_visit">
													<xsl:value-of select="order_of_visit" />
												</xsl:variable>
												<xsl:variable name="station_frm_descr">
													<xsl:value-of select="station_frm_descr" />
												</xsl:variable>
												<xsl:variable name="station_to_descr">
													<xsl:value-of select="station_to_descr" />
												</xsl:variable>
												<xsl:variable name="sprs_ww__name">
													<xsl:value-of select="sprs_ww__name" />
												</xsl:variable>
												<TR>

													<xsl:if test="normalize-space($is_mgrs) !=''">
														<TD CLASS="cellttl1 tdCenter title tdLeft normalFont">
															<xsl:value-of select="$sprs_ww__name" />
														</TD>
														<TD CLASS="cellttl1 tdCenter title  normalFont">
															<xsl:value-of select="$sprs_route_descr" />
														</TD>
													</xsl:if>
													<xsl:if test="normalize-space($is_mgrs) =''">
														<TD CLASS="cellttl1 tdLeft title  normalFont">
															<xsl:value-of select="$sprs_route_descr" />
														</TD>
													</xsl:if>

													<TD CLASS="cellttl1 tdCenter title normalFont">
														<xsl:value-of select="$sprs_route_frm_descr" />
													</TD>

													<TD CLASS="cellttl1 tdCenter title normalFont">
														<xsl:value-of select="$travel_mode" />
													</TD>

													<TD CLASS="cellttl1 tdRight title  normalFont">
														<xsl:value-of select="$order_of_visit" />
													</TD>

												</TR>
											</xsl:for-each>
										</TABLE>
									</details>
								</xsl:if>



								<xsl:variable name="listed_count">
									<xsl:value-of select="count(//DARDetails//doctor)" />
								</xsl:variable>

								<xsl:variable name="doc_listed_cnt">
									<xsl:value-of
										select="count(//DARDetails//doctor[customer_type='LISTED'])" />
								</xsl:variable>

								<xsl:variable name="unlisted_cnt">
									<xsl:value-of
										select="count(//DARDetails//doctor[customer_type='UNLISTED'])" />
								</xsl:variable>

								<xsl:if test="normalize-space($listed_count) > '0'">
									<xsl:if test="normalize-space($doc_listed_cnt) > '0'">

										<details open="true">
											<summary class="summary headerFont">
												Doctor's Details (Call List) - (
												<xsl:value-of select="normalize-space($doc_listed_cnt)" />
												)
											</summary>
											<TABLE cellspacing="0" cellpadding="0" class="tTitleD"
												border="0" width="100%" style="width:100%; ">

												<xsl:for-each select="//DARDetails//doctor">
													<xsl:sort select="substring-after(event_time_start, ' ')" />
													<xsl:sort select="substring-before(event_time_start,':') mod 12"
														data-type="number" />
													<xsl:sort
														select="substring-before(substring-after(event_time_start,':'), ' ')"
														data-type="number" />

													<xsl:variable name="customer_type">
														<xsl:value-of select="customer_type" />
													</xsl:variable>
													<xsl:if test="normalize-space($customer_type) = 'LISTED'">

														<xsl:variable name="strg_code3">
															<xsl:value-of select="strg_code" />
														</xsl:variable>
														<xsl:variable name="cust_name">
															<xsl:value-of select="cust_name" />
														</xsl:variable>
														<xsl:variable name="locality_descr">
															<xsl:value-of select="locality_descr" />
														</xsl:variable>
														<xsl:variable name="calloutcome_descr">
															<xsl:value-of select="calloutcome_descr" />
														</xsl:variable>
														<xsl:variable name="domID">
															<xsl:value-of select="@domID" />
														</xsl:variable>
														<xsl:variable name="host_url">
															<xsl:value-of select="host_url" />
														</xsl:variable>
														<xsl:variable name="team_details">
															<xsl:value-of select="team_details" />
														</xsl:variable>
														<xsl:variable name="class_code_descr">
															<xsl:value-of select="class_code_descr" />
														</xsl:variable>
														<xsl:variable name="spl_descr">
															<xsl:value-of select="spl_descr" />
														</xsl:variable>
														<xsl:variable name="no_visit">
															<xsl:value-of select="no_visit" />
														</xsl:variable>
														<xsl:variable name="event_time_start">
															<xsl:value-of select="event_time_start" />
														</xsl:variable>
														<xsl:variable name="event_time_end">
															<xsl:value-of select="event_time_end" />
														</xsl:variable>
														<xsl:variable name="pob_val">
															<xsl:value-of select="pob_val" />
														</xsl:variable>
														<xsl:variable name="meet_summ">
															<xsl:value-of select="remarks" />
														</xsl:variable>
														<!-- Changed by Pooja on 06/01/20 [to display coaching details 
															on confirm xsl] START -->
														<xsl:variable name="member_present_1">
															<xsl:value-of select="member_present_1" />
														</xsl:variable>
														<xsl:variable name="member_present">
															<xsl:choose>
																<xsl:when test="$member_present_1 = ''">
																	<xsl:value-of select="0" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:value-of select="member_present_1" />
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>

														<xsl:variable name="coaching_details">
															<xsl:value-of select="coaching_details" />
														</xsl:variable>
														<xsl:variable name="oth_participant">
															<xsl:value-of select="oth_participant" />
														</xsl:variable>

														<xsl:call-template name="tmpOrder">
															<xsl:with-param name="orderFormName"
																select="concat($host_url,'@','sampleorder','#',$cust_name,'(',$calloutcome_descr,'*',$strg_code3,'!',$locality_descr,'^',$team_details,'+',$class_code_descr,'**',$spl_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'@@@',$coaching_details,'$$@','doctor','[',$oth_participant)" />
														</xsl:call-template>
														<!-- Changed by Pooja on 06/01/20 [to display coaching details 
															on confirm xsl] END -->
													</xsl:if>
												</xsl:for-each>
											</TABLE>
										</details>
									</xsl:if>


									<xsl:if test="normalize-space($unlisted_cnt) > '0'">
										<details open="true">
											<summary class="summary headerFont">Doctor's Details (Not From Call List)</summary>
											<TABLE cellspacing="0" cellpadding="0" class="tTitleD"
												border="0" width="100%" style="width:100%; ">
												<xsl:for-each select="//DARDetails//doctor">
													<xsl:variable name="customer_type">
														<xsl:value-of select="customer_type" />
													</xsl:variable>
													<xsl:if
														test="contains(normalize-space($customer_type), 'UNLISTED')">

														<xsl:variable name="strg_code3">
															<xsl:value-of select="strg_code" />
														</xsl:variable>
														<xsl:variable name="cust_name">
															<xsl:value-of select="cust_name" />
														</xsl:variable>
														<xsl:variable name="locality_descr">
															<xsl:value-of select="locality_descr" />
														</xsl:variable>
														<xsl:variable name="calloutcome_descr">
															<xsl:value-of select="calloutcome_descr" />
														</xsl:variable>
														<xsl:variable name="domID">
															<xsl:value-of select="@domID" />
														</xsl:variable>
														<xsl:variable name="host_url">
															<xsl:value-of select="host_url" />
														</xsl:variable>
														<xsl:variable name="team_details">
															<xsl:value-of select="team_details" />
														</xsl:variable>
														<xsl:variable name="class_code_descr">
															<xsl:value-of select="class_code_descr" />
														</xsl:variable>
														<xsl:variable name="spl_descr">
															<xsl:value-of select="spl_descr" />
														</xsl:variable>
														<xsl:variable name="no_visit">
															<xsl:value-of select="no_visit" />
														</xsl:variable>
														<xsl:variable name="event_time_start">
															<xsl:value-of select="event_time_start" />
														</xsl:variable>
														<xsl:variable name="event_time_end">
															<xsl:value-of select="event_time_end" />
														</xsl:variable>
														<xsl:variable name="pob_val">
															<xsl:value-of select="pob_val" />
														</xsl:variable>
														<xsl:variable name="meet_summ">
															<xsl:value-of select="remarks" />
														</xsl:variable>
														<!-- Changed by Pooja on 06/01/20 [to display coaching details 
															on confirm xsl] START -->
														<xsl:variable name="member_present">
															<xsl:value-of select="member_present" />
														</xsl:variable>
														<xsl:variable name="unlisted_member_present">
															<xsl:choose>
																<xsl:when test="$member_present = ''">
																	<xsl:value-of select="0" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:value-of select="member_present" />
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
														<xsl:variable name="coaching_details">
															<xsl:value-of select="coaching_details" />
														</xsl:variable>
														<xsl:variable name="oth_participant">
															<xsl:value-of select="oth_participant" />
														</xsl:variable>
														<xsl:call-template name="tmpOrder">
															<xsl:with-param name="orderFormName"
																select="concat($host_url,'@','sampleorder','#',$cust_name,'(',$calloutcome_descr,'*',$strg_code3,'!',$locality_descr,'^',$team_details,'+',$class_code_descr,'**',$spl_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$unlisted_member_present,'@@@',$coaching_details,'$$@','doctor','[',$oth_participant)" />
														</xsl:call-template>
														<!-- Changed by Pooja on 06/01/20 [to display coaching details 
															on confirm xsl] END -->
													</xsl:if>
												</xsl:for-each>

											</TABLE>
										</details>
									</xsl:if>
								</xsl:if>

								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//sampleorder)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Order</summary> <TABLE class="tTitleD" 
									border="0" width="100%" style="width:100%; z-index:9999999999; "> <thead 
									class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 cellttlblck heading">Product</TH> 
									<TH CLASS="cellttl1 cellttlblck heading">Quantity</TH> <TH CLASS="cellttl1 
									cellttlblck heading">Value</TH> </TR> </thead> <xsl:for-each select="//DARDetails//sampleorder"> 
									<xsl:variable name="item_descr"> <xsl:value-of select="item_descr" /> </xsl:variable> 
									<xsl:variable name="quantity"> <xsl:value-of select="quantity" /> </xsl:variable> 
									<xsl:variable name="value"> <xsl:value-of select="value" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$item_descr" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$quantity" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$value" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->





								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//team)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Team</summary> <div id = "teamDr" 
									style="display: none;"> <TABLE class="tTitleD" border="0" width="100%" style="width:100%; 
									z-index:9999999999; "> <thead class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 
									cellttlblck heading"> Team </TH> <TH CLASS="cellttl1 cellttlblck heading"> 
									Designation </TH> </TR> </thead> <xsl:for-each select="//DARDetails//team"> 
									<xsl:variable name="sp_name"> <xsl:value-of select="sp_name" /> </xsl:variable> 
									<xsl:variable name="designation"> <xsl:value-of select="designation" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$sp_name" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$designation" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->





								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//retailersampleorder)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Order</summary> <TABLE class="tTitleD" 
									border="0" width="100%" style="width:100%; z-index:9999999999; "> <thead 
									class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 cellttlblck heading">Product</TH> 
									<TH CLASS="cellttl1 cellttlblck heading">Quantity</TH> <TH CLASS="cellttl1 
									cellttlblck heading">Value</TH> </TR> </thead> <xsl:for-each select="//DARDetails//retailersampleorder"> 
									<xsl:variable name="item_descr"> <xsl:value-of select="item_descr" /> </xsl:variable> 
									<xsl:variable name="quantity"> <xsl:value-of select="quantity" /> </xsl:variable> 
									<xsl:variable name="value"> <xsl:value-of select="value" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$item_descr" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$quantity" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$value" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->







								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//retailerteam)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Team</summary> <div id = "teamDr" 
									style="display: none;"> <TABLE class="tTitleD" border="0" width="100%" style="width:100%; 
									z-index:9999999999; "> <thead class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 
									cellttlblck heading"> Team </TH> <TH CLASS="cellttl1 cellttlblck heading"> 
									Designation </TH> </TR> </thead> <xsl:for-each select="//DARDetails//retailerteam"> 
									<xsl:variable name="sp_name"> <xsl:value-of select="sp_name" /> </xsl:variable> 
									<xsl:variable name="designation"> <xsl:value-of select="designation" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$sp_name" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$designation" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->

								 <xsl:variable name="listed_count_sto">
									<xsl:value-of select="count(//DARDetails//StockData)" />
								</xsl:variable>
								<xsl:variable name="sto_listed_cnt">
									<xsl:value-of
										select="count(//DARDetails//StockData[customer_type='LISTED'])" />
								</xsl:variable>
								<xsl:variable name="sto_unlisted_cnt">
									<xsl:value-of
										select="count(//DARDetails//StockData[customer_type='UNLISTED'])" />
								</xsl:variable>
								
			<xsl:if test="normalize-space($listed_count_sto) > '0'">						
								<xsl:if test="normalize-space($sto_listed_cnt) > '0'">
									<details open="true">
										<summary class="summary headerFont">
											Stockist's Call Details - (
											<xsl:value-of select="normalize-space($sto_listed_cnt)" />
											)
										</summary>
										<TABLE cellspacing="0" cellpadding="0" class="tTitleD"
											border="0" width="100%" style="width:100%; ">

											<xsl:for-each select="//DARDetails//StockData">
												<xsl:sort select="substring-after(event_time_start, ' ')" />
												<xsl:sort select="substring-before(event_time_start,':') mod 12"
													data-type="number" />
												<xsl:sort
													select="substring-before(substring-after(event_time_start,':'), ' ')"
													data-type="number" />
                                                     <xsl:variable name="customer_type">
														<xsl:value-of select="customer_type" />
													</xsl:variable>
													<xsl:if test="normalize-space($customer_type) = 'LISTED'">
												<xsl:variable name="strg_code3">
													<xsl:value-of select="strg_code" />
												</xsl:variable>
												<xsl:variable name="cust_name">
													<xsl:value-of select="cust_name" />
												</xsl:variable>
												<xsl:variable name="locality_descr">
													<xsl:value-of select="locality_descr" />
												</xsl:variable>
												<xsl:variable name="calloutcome_descr">
													<xsl:value-of select="calloutcome_descr" />
												</xsl:variable>
												<xsl:variable name="domID">
													<xsl:value-of select="@domID" />
												</xsl:variable>
												<xsl:variable name="host_url">
													<xsl:value-of select="host_url" />
												</xsl:variable>
												<xsl:variable name="team_details">
													<xsl:value-of select="team_details" />
												</xsl:variable>
												<xsl:variable name="meet_summ">
													<xsl:value-of select="remarks" />
												</xsl:variable>
												<xsl:variable name="event_time_start">
													<xsl:value-of select="event_time_start" />
												</xsl:variable>
												<xsl:variable name="event_time_end">
													<xsl:value-of select="event_time_end" />
												</xsl:variable>
												<xsl:variable name="pob_val">
													<xsl:value-of select="pob_val" />
												</xsl:variable>
												<!-- <xsl:variable name="customer_type">
													<xsl:value-of select="customer_type" />
												</xsl:variable> -->
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] START -->
												<xsl:variable name="member_present">
															<xsl:value-of select="member_present" />
														</xsl:variable>
														<xsl:variable name="stockist_member_present">
															<xsl:choose>
																<xsl:when test="$member_present = ''">
																	<xsl:value-of select="0" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:value-of select="member_present" />
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
												<xsl:variable name="coaching_details">
													<xsl:value-of select="coaching_details" />
												</xsl:variable>
												<xsl:variable name="oth_participant">
													<xsl:value-of select="oth_participant" />
												</xsl:variable>
												<xsl:call-template name="tmpOrder">
													<xsl:with-param name="orderFormName"
														select="concat($host_url,'@','StockOrder','#',$cust_name,'(',$calloutcome_descr,'*',$strg_code3,'!',$locality_descr,'^',$team_details,'+','','**','','~','','##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$stockist_member_present,'@@@',$coaching_details,'$$@','stockist','[',$oth_participant)" />
												</xsl:call-template>
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] END -->
													</xsl:if>
											</xsl:for-each>
										</TABLE>
									</details>
								</xsl:if>
								
								<xsl:if test="normalize-space($sto_unlisted_cnt) > '0'">
									<details open="true">
										<summary class="summary headerFont">
											Stockist's Call Details (Not From Call List)
										</summary>
										<TABLE cellspacing="0" cellpadding="0" class="tTitleD"
											border="0" width="100%" style="width:100%; ">

											<xsl:for-each select="//DARDetails//StockData">
												<xsl:sort select="substring-after(event_time_start, ' ')" />
												<xsl:sort select="substring-before(event_time_start,':') mod 12"
													data-type="number" />
												<xsl:sort
													select="substring-before(substring-after(event_time_start,':'), ' ')"
													data-type="number" />

                                                    <xsl:variable name="customer_type">
														<xsl:value-of select="customer_type" />
													</xsl:variable>
													<xsl:if
														test="contains(normalize-space($customer_type), 'UNLISTED')">
												<xsl:variable name="strg_code3">
													<xsl:value-of select="strg_code" />
												</xsl:variable>
												<xsl:variable name="cust_name">
													<xsl:value-of select="cust_name" />
												</xsl:variable>
												<xsl:variable name="locality_descr">
													<xsl:value-of select="locality_descr" />
												</xsl:variable>
												<xsl:variable name="calloutcome_descr">
													<xsl:value-of select="calloutcome_descr" />
												</xsl:variable>
												<xsl:variable name="domID">
													<xsl:value-of select="@domID" />
												</xsl:variable>
												<xsl:variable name="host_url">
													<xsl:value-of select="host_url" />
												</xsl:variable>
												<xsl:variable name="team_details">
													<xsl:value-of select="team_details" />
												</xsl:variable>
												<xsl:variable name="meet_summ">
													<xsl:value-of select="remarks" />
												</xsl:variable>
												<xsl:variable name="event_time_start">
													<xsl:value-of select="event_time_start" />
												</xsl:variable>
												<xsl:variable name="event_time_end">
													<xsl:value-of select="event_time_end" />
												</xsl:variable>
												<xsl:variable name="pob_val">
													<xsl:value-of select="pob_val" />
												</xsl:variable>
												<!-- <xsl:variable name="customer_type">
													<xsl:value-of select="customer_type" />
												</xsl:variable> -->
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] START -->
												<xsl:variable name="member_present">
															<xsl:value-of select="member_present" />
														</xsl:variable>
														<xsl:variable name="stockist_member_present">
															<xsl:choose>
																<xsl:when test="$member_present = ''">
																	<xsl:value-of select="0" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:value-of select="member_present" />
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
												<xsl:variable name="coaching_details">
													<xsl:value-of select="coaching_details" />
												</xsl:variable>
												<xsl:variable name="oth_participant">
													<xsl:value-of select="oth_participant" />
												</xsl:variable>
												
												<xsl:call-template name="tmpOrder">
													<xsl:with-param name="orderFormName"
														select="concat($host_url,'@','StockOrder','#',$cust_name,'(',$calloutcome_descr,'*',$strg_code3,'!',$locality_descr,'^',$team_details,'+','','**','','~','','##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$stockist_member_present,'@@@',$coaching_details,'$$@','stockist','[',$oth_participant)" />
												</xsl:call-template>
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] END -->
													</xsl:if>
											</xsl:for-each>
										</TABLE>
									</details>
								</xsl:if>
								
</xsl:if>

                                  <xsl:variable name="listed_count_chem">
									<xsl:value-of select="count(//DARDetails//retailer)" />
								</xsl:variable>
								<xsl:variable name="chem_listed_cnt">
									<xsl:value-of
										select="count(//DARDetails//retailer[customer_type='LISTED'])" />
								</xsl:variable>
								<xsl:variable name="chem_unlisted_cnt">
									<xsl:value-of
										select="count(//DARDetails//retailer[customer_type='UNLISTED'])" />
								</xsl:variable>

								
				<xsl:if test="normalize-space($listed_count_chem) > '0'">						
								<xsl:if test="normalize-space($chem_listed_cnt) > '0'">
									<details open="true">
										<summary class="summary headerFont">Chemist's Call Details - (
											<xsl:value-of select="normalize-space($chem_listed_cnt)" />
											)
											</summary>
										<TABLE cellspacing="0" cellpadding="0" class="tTitleD"
											border="0" width="100%" style="width:100%; ">
											<xsl:for-each select="//DARDetails//retailer">
											
											    <xsl:variable name="customer_type">
														<xsl:value-of select="customer_type" />
												</xsl:variable>
												<xsl:if test="normalize-space($customer_type) = 'LISTED'">
												<xsl:variable name="strg_code3">
													<xsl:value-of select="strg_code" />
												</xsl:variable>
												<xsl:variable name="cust_name">
													<xsl:value-of select="cust_name" />
												</xsl:variable>
												<xsl:variable name="locality_descr">
													<xsl:value-of select="locality_descr" />
												</xsl:variable>
												<xsl:variable name="calloutcome_descr">
													<xsl:value-of select="calloutcome_descr" />
												</xsl:variable>
												<xsl:variable name="domID">
													<xsl:value-of select="@domID" />
												</xsl:variable>
												<xsl:variable name="host_url">
													<xsl:value-of select="host_url" />
												</xsl:variable>
												<xsl:variable name="team_details">
													<xsl:value-of select="team_details" />
												</xsl:variable>
												<xsl:variable name="event_time_start">
													<xsl:value-of select="event_time_start" />
												</xsl:variable>
												<xsl:variable name="event_time_end">
													<xsl:value-of select="event_time_end" />
												</xsl:variable>
												<xsl:variable name="pob_val">
													<xsl:value-of select="pob_val" />
												</xsl:variable>
												<xsl:variable name="meet_summ">
													<xsl:value-of select="remarks" />
												</xsl:variable>
												<!-- <xsl:variable name="customer_type">
													<xsl:value-of select="customer_type" />
												</xsl:variable> -->
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] START -->
												<xsl:variable name="member_present">
															<xsl:value-of select="member_present" />
														</xsl:variable>
														<xsl:variable name="chemist_member_present">
															<xsl:choose>
																<xsl:when test="$member_present = ''">
																	<xsl:value-of select="0" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:value-of select="member_present" />
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
												<xsl:variable name="coaching_details">
													<xsl:value-of select="coaching_details" />
												</xsl:variable>
												<xsl:variable name="oth_participant">
													<xsl:value-of select="oth_participant" />
												</xsl:variable>
												<xsl:call-template name="tmpOrder">
													<xsl:with-param name="orderFormName"
														select="concat($host_url,'@','retailersampleorder','#',$cust_name,'(',$calloutcome_descr,'*',$strg_code3,'!',$locality_descr,'^',$team_details,'+','','**','','~','','##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$chemist_member_present,'@@@',$coaching_details,'$$@','retailer','[',$oth_participant)" />
												</xsl:call-template>
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] END -->
													</xsl:if>
											</xsl:for-each>
										</TABLE>
									</details>
								</xsl:if>
								
								<xsl:if test="normalize-space($chem_unlisted_cnt) > '0'">
									<details open="true">
										<summary class="summary headerFont">Chemist's Call Details (Not From Call List)</summary>
										<TABLE cellspacing="0" cellpadding="0" class="tTitleD"
											border="0" width="100%" style="width:100%; ">
											<xsl:for-each select="//DARDetails//retailer">
											
											 <xsl:variable name="customer_type">
														<xsl:value-of select="customer_type" />
												</xsl:variable>
												<xsl:if test="normalize-space($customer_type) = 'UNLISTED'">
												<xsl:variable name="strg_code3">
													<xsl:value-of select="strg_code" />
												</xsl:variable>
												<xsl:variable name="cust_name">
													<xsl:value-of select="cust_name" />
												</xsl:variable>
												<xsl:variable name="locality_descr">
													<xsl:value-of select="locality_descr" />
												</xsl:variable>
												<xsl:variable name="calloutcome_descr">
													<xsl:value-of select="calloutcome_descr" />
												</xsl:variable>
												<xsl:variable name="domID">
													<xsl:value-of select="@domID" />
												</xsl:variable>
												<xsl:variable name="host_url">
													<xsl:value-of select="host_url" />
												</xsl:variable>
												<xsl:variable name="team_details">
													<xsl:value-of select="team_details" />
												</xsl:variable>
												<xsl:variable name="event_time_start">
													<xsl:value-of select="event_time_start" />
												</xsl:variable>
												<xsl:variable name="event_time_end">
													<xsl:value-of select="event_time_end" />
												</xsl:variable>
												<xsl:variable name="pob_val">
													<xsl:value-of select="pob_val" />
												</xsl:variable>
												<xsl:variable name="meet_summ">
													<xsl:value-of select="remarks" />
												</xsl:variable>
												<!-- <xsl:variable name="customer_type">
													<xsl:value-of select="customer_type" />
												</xsl:variable> -->
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] START -->
												<xsl:variable name="member_present">
															<xsl:value-of select="member_present" />
														</xsl:variable>
														<xsl:variable name="chemist_member_present">
															<xsl:choose>
																<xsl:when test="$member_present = ''">
																	<xsl:value-of select="0" />
																</xsl:when>
																<xsl:otherwise>
																	<xsl:value-of select="member_present" />
																</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
												<xsl:variable name="coaching_details">
													<xsl:value-of select="coaching_details" />
												</xsl:variable>
												<xsl:variable name="oth_participant">
													<xsl:value-of select="oth_participant" />
												</xsl:variable>
												<xsl:call-template name="tmpOrder">
													<xsl:with-param name="orderFormName"
														select="concat($host_url,'@','retailersampleorder','#',$cust_name,'(',$calloutcome_descr,'*',$strg_code3,'!',$locality_descr,'^',$team_details,'+','','**','','~','','##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$chemist_member_present,'@@@',$coaching_details,'$$@','retailer','[',$oth_participant)" />
												</xsl:call-template>
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] END -->
													</xsl:if>
											</xsl:for-each>
										</TABLE>
									</details>
								</xsl:if>
								
		</xsl:if>

								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//StockOrder)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Order</summary> <TABLE class="tTitleD" 
									border="0" width="100%" style="width:100%; z-index:9999999999; "> <thead 
									class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 cellttlblck heading">Product</TH> 
									<TH CLASS="cellttl1 cellttlblck heading">Quantity</TH> <TH CLASS="cellttl1 
									cellttlblck heading">Value</TH> </TR> </thead> <xsl:for-each select="//DARDetails//StockOrder"> 
									<xsl:variable name="item_descr"> <xsl:value-of select="item_descr" /> </xsl:variable> 
									<xsl:variable name="quantity"> <xsl:value-of select="quantity" /> </xsl:variable> 
									<xsl:variable name="value"> <xsl:value-of select="value" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$item_descr" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$quantity" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$value" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->





								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//StockistTeam)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Team</summary> <div id = "teamDr" 
									style="display: none;"> <TABLE class="tTitleD" border="0" width="100%" style="width:100%; 
									z-index:9999999999; "> <thead class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 
									cellttlblck heading"> Team </TH> <TH CLASS="cellttl1 cellttlblck heading"> 
									Designation </TH> </TR> </thead> <xsl:for-each select="//DARDetails//StockistTeam"> 
									<xsl:variable name="sp_name"> <xsl:value-of select="sp_name" /> </xsl:variable> 
									<xsl:variable name="designation"> <xsl:value-of select="designation" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$sp_name" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$designation" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->

								<xsl:variable name="listed_count">
									<xsl:value-of select="count(//DARDetails//NCWData)" />
								</xsl:variable>
								<xsl:if test="normalize-space($listed_count) > '0'">
									<details open="true">
										<summary class="summary headerFont">Other's Call Details</summary>
										<TABLE cellspacing="0" cellpadding="0" class="tTitleD"
											border="0" width="100%" style="width:100%; ">

											<xsl:for-each select="//DARDetails//NCWData">
												<xsl:sort select="substring-after(event_time_start, ' ')" />
												<xsl:sort select="substring-before(event_time_start,':') mod 12"
													data-type="number" />
												<xsl:sort
													select="substring-before(substring-after(event_time_start,':'), ' ')"
													data-type="number" />

												<xsl:variable name="strg_code3">
													<xsl:value-of select="strg_code" />
												</xsl:variable>
												<xsl:variable name="cust_name">
													<xsl:value-of select="cust_name" />
												</xsl:variable>
												<xsl:variable name="locality_descr">
													<xsl:value-of select="locality_descr" />
												</xsl:variable>
												<xsl:variable name="calloutcome_descr">
													<xsl:value-of select="calloutcome_descr" />
												</xsl:variable>
												<xsl:variable name="domID">
													<xsl:value-of select="@domID" />
												</xsl:variable>
												<xsl:variable name="host_url">
													<xsl:value-of select="host_url" />
												</xsl:variable>
												<xsl:variable name="team_details">
													<xsl:value-of select="team_details" />
												</xsl:variable>
												<xsl:variable name="event_time_start">
													<xsl:value-of select="event_time_start" />
												</xsl:variable>
												<xsl:variable name="event_time_end">
													<xsl:value-of select="event_time_end" />
												</xsl:variable>
												<xsl:variable name="pob_val">
													<xsl:value-of select="pob_val" />
												</xsl:variable>
												<xsl:variable name="customer_type">
													<xsl:value-of select="customer_type" />
												</xsl:variable>
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] START -->
												<xsl:variable name="member_present_1">
													<xsl:value-of select="member_present_1" />
												</xsl:variable>
												<xsl:variable name="member_present">
													<xsl:choose>
														<xsl:when test="$member_present_1 = ''">
															<xsl:value-of select="0" />
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="member_present" />
														</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>

												<xsl:variable name="meet_summ">
													<xsl:value-of select="remarks" />
												</xsl:variable>
												<xsl:variable name="coaching_details">
													<xsl:value-of select="coaching_details" />
												</xsl:variable>
												<xsl:variable name="oth_participant">
													<xsl:value-of select="oth_participant" />
												</xsl:variable>
												<xsl:call-template name="tmpOrder">
													<xsl:with-param name="orderFormName"
														select="concat($host_url,'@','NcwOrder','#',$cust_name,'(',$calloutcome_descr,'*',$strg_code3,'!',$locality_descr,'^',$team_details,'+','','**','','~','','##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'@@@',$coaching_details,'$$@','ncw','[',$oth_participant)" />
												</xsl:call-template>
												<!-- Changed by Pooja on 06/01/20 [to display coaching details 
													on confirm xsl] END -->
											</xsl:for-each>
										</TABLE>
									</details>
								</xsl:if>

								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//NcwOrder)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Order</summary> <TABLE class="tTitleD" 
									border="0" width="100%" style="width:100%; z-index:9999999999; "> <thead 
									class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 cellttlblck heading">Product</TH> 
									<TH CLASS="cellttl1 cellttlblck heading">Quantity</TH> <TH CLASS="cellttl1 
									cellttlblck heading">Value</TH> </TR> </thead> <xsl:for-each select="//DARDetails//NcwOrder"> 
									<xsl:variable name="item_descr"> <xsl:value-of select="item_descr" /> </xsl:variable> 
									<xsl:variable name="quantity"> <xsl:value-of select="quantity" /> </xsl:variable> 
									<xsl:variable name="value"> <xsl:value-of select="value" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$item_descr" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$quantity" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$value" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->






								<!-- <xsl:variable name="listed_count"> <xsl:value-of select="count(//DARDetails//NcwTeam)" 
									/> </xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details 
									open="true"> <summary class="summary"> Team</summary> <div id = "teamDr" 
									style="display: none;"> <TABLE class="tTitleD" border="0" width="100%" style="width:100%; 
									z-index:9999999999; "> <thead class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 
									cellttlblck heading"> Team </TH> <TH CLASS="cellttl1 cellttlblck heading"> 
									Designation </TH> </TR> </thead> <xsl:for-each select="//DARDetails//NcwTeam"> 
									<xsl:variable name="sp_name"> <xsl:value-of select="sp_name" /> </xsl:variable> 
									<xsl:variable name="designation"> <xsl:value-of select="designation" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$sp_name" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$designation" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->



								<xsl:variable name="listed_count">
									<xsl:value-of select="count(//PrDetails//Detail13)" />
								</xsl:variable>

								<!-- <xsl:if test="normalize-space($listed_count) > '0'"> <details> 
									<summary class="summary">Prescription Doctor's Call Details</summary> <TABLE 
									class="tTitleD" border="0" width="100%" style="width:100%; z-index:9999999999; 
									"> <thead class="" style="height : 30px;"> <TR> <TH CLASS= "cellttl1 cellttlblck" 
									STYLE="PADDING: 12PX; border-bottom: #e5e4e9 1px solid;">SN</TH> <TH CLASS="cellttl1 
									cellttlblck heading">Doctor </TH> <TH CLASS="cellttl1 cellttlblck heading">Locality</TH> 
									<TH CLASS="cellttl1 cellttlblck heading">POB Value</TH> </TR> </thead> <xsl:for-each 
									select="//PrDetails//Detail13"> <xsl:variable name="strg_code3"> <xsl:value-of 
									select="strg_code" /> </xsl:variable> <xsl:variable name="cust_name"> <xsl:value-of 
									select="cust_name" /> </xsl:variable> <xsl:variable name="locality_descr"> 
									<xsl:value-of select="locality_descr" /> </xsl:variable> <xsl:variable name="sku_value"> 
									<xsl:value-of select="sku_value" /> </xsl:variable> <xsl:variable name="domID"> 
									<xsl:value-of select="@domID" /> </xsl:variable> <TR> <TD CLASS="cellttl1 
									tdCenter title"> <xsl:value-of select="$cust_name" /> </TD> <TD CLASS="cellttl1 
									tdCenter title"> <xsl:value-of select="$locality_descr" /> </TD> <TD CLASS="cellttl1 
									tdCenter title"> <xsl:value-of select="$sku_value" /> </TD> </TR> </xsl:for-each> 
									</TABLE> </details> </xsl:if> <xsl:variable name="listed_count"> <xsl:value-of 
									select="count(//PrDetails//Detail14)" /> </xsl:variable> <xsl:if test="normalize-space($listed_count) 
									> '0'"> <details> <summary class="summary"> Order</summary> <TABLE class="tTitleD" 
									border="0" width="100%" style="width:100%; z-index:9999999999; "> <thead 
									class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 cellttlblck heading">Product 
									</TH> <TH CLASS="cellttl1 cellttlblck heading">Quantity</TH> <TH CLASS="cellttl1 
									cellttlblck heading">Value</TH> </TR> </thead> <xsl:for-each select="//PrDetails//Detail14"> 
									<xsl:variable name="item_descr"> <xsl:value-of select="item_descr" /> </xsl:variable> 
									<xsl:variable name="quantity"> <xsl:value-of select="quantity" /> </xsl:variable> 
									<xsl:variable name="value"> <xsl:value-of select="value" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$item_descr" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$quantity" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="$value" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> <xsl:variable 
									name="listed_count"> <xsl:value-of select="count(//PrDetails//DISPLAY)" /> 
									</xsl:variable> <xsl:if test="normalize-space($listed_count) > '0'"> <details> 
									<summary class="summary"> Display</summary> <div id = "displayDr" style="display: 
									none;"> <TABLE class="tTitleD" border="0" width="100%" style="width:100%; 
									z-index:9999999999; "> <thead class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1 
									cellttlblck heading">Display Area </TH> <TH CLASS="cellttl1 cellttlblck heading">Display 
									Image </TH> </TR> </thead> <xsl:for-each select="//PrDetails//DISPLAY"> <xsl:variable 
									name="doc_id"> <xsl:value-of select="doc_id" /> </xsl:variable> <xsl:variable 
									name="display_area"> <xsl:value-of select="display_area" /> </xsl:variable> 
									<TR> <TD CLASS="cellttl1 tdCenter title"> <xsl:value-of select="display_area" 
									/> </TD> <TD CLASS="cellttl1 tdCenter title"> <div align='center' id="__attachmentDiv.{normalize-space($doc_id)}"></div> 
									<img src="_" onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($doc_id)}', 
									'strg_meet_pr_wiz', 'J-PR', '{normalize-space($doc_id)}'); this.remove();" 
									/> </TD> </TR> </xsl:for-each> </TABLE> </details> </xsl:if> -->

								<div class="headerTable headerTable1" style="padding-bottom: 40px;">
									<xsl:for-each select="//DARDetails//Detail1">

										<xsl:variable name="host">
											<xsl:value-of select="host_url" />
										</xsl:variable>
										<div>
											<div style="display: inline-block;width: 100%;padding: .5em;">
												<div style="height: auto;float: left;width: 36px;display: block;">
													<div class="vision-ui-action_realtime_report"
														style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
												</div>
												<div style="width: calc(100% - 36px);float: right;">
													<div style="float: left; color: black; width:100%;"
														class="normalFont tdLeft">Last DCR Date :</div>
													<div style="float: left; white-space: normal;color:#666"
														class="headerFont tdLeft">
														<xsl:value-of select="last_dcr_date" />
													</div>
												</div>
											</div>

										</div>
										<div>
											<div style="display: inline-block;width: 100%;padding: .5em;">
												<div
													style="height: auto; float: left; width: 40px; background: :gray;">
													<div class="vision-ui-location"
														style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
												</div>
												<div style="width: calc(100% - 40px); float: right;">
													<div style="float: left; color: black; width:100%;"
														class="normalFont tdLeft">Last Place of Work :</div>
													<div style="float: left; white-space: normal;color:#666"
														class="headerFont tdLeft">
														<xsl:value-of select="sprs_route_descr" />
													</div>
												</div>
											</div>

										</div>
										<div>
											<div style="display: inline-block;width: 100%;padding: .5em;">
												<div style="height: auto;float: left;width: 36px;display: block;">
													<div class="vision-ui-message"
														style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
												</div>
												<div style="width: calc(100% - 36px);float: right;">
													<div style="float: left; color: black; width:100%;"
														class="normalFont tdLeft">General Remarks :</div>
													<div style="float: left; white-space: normal;color:#666"
														class="headerFont tdLeft">
														<xsl:value-of select="remark" />
													</div>
												</div>
											</div>

										</div>
									</xsl:for-each>
								</div>
								<div id="actionDiv" class=""
									style="padding:.2em;position: sticky;bottom: 0;background:#fff;">
									<xsl:variable name="callReport">
										<xsl:value-of select="//HeaderData/callReport" />
									</xsl:variable>
									<!--getValidationAlert added by mrunalini sinkar for franco client 
										alert on confirm delete on 01-jan-2018(START) -->
									<xsl:variable name="isConfirmReq">
										<xsl:value-of select="//HeaderData/isConfirmReq" />
									</xsl:variable>
									<xsl:variable name="isDeleteReq">
										<xsl:value-of select="//HeaderData/isDeleteReq" />
									</xsl:variable>
									<xsl:variable name="isConfirmEnable">
										<xsl:value-of select="//cofirmEnable" />
									</xsl:variable><!--Added By Nilesh for confirm button enable according 
										userright Start :: 22-04-19 -->
									<xsl:variable name="missed_data">
										<xsl:value-of select="//HeaderData/missed_data" />
									</xsl:variable>
									<xsl:variable name="report_id">
										<xsl:value-of select="//HeaderData/report_id" />
									</xsl:variable>
									<xsl:variable name="device_type">
										<xsl:value-of select="//HeaderData/device_type" />
									</xsl:variable>
									<xsl:variable name="old_data">
										<xsl:value-of select="//HeaderData/old_data" />
									</xsl:variable>


									<xsl:if test="normalize-space($old_data)= 'true'">
												
												<xsl:choose>
													<xsl:when test="$report_id ='ANALYSIS_REPORT' or $device_type= 'Mobile'">
												<div
													style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
													class="" id="actionDiv">
													<div style="width: 33.33%;">
														<div class="actionbuttonsleft"
															style="width: 50px;text-align:  center;height: 50px;margin: auto;">
															<div class="vision-ui-cross"
																style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																name="Cancel" onclick="goBackToPriviousPage();"></div>
															<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																style="color: #7b7b7b; font-size: 14px;">Cancel</div>
														</div>
													</div>
												</div>
													</xsl:when>
													<xsl:otherwise>

													<div
													style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
													class="" id="actionDiv">
													<div style="width: 33.33%;">
														<div class="actionbuttonsleft"
															style="width: 50px;text-align:  center;height: 50px;margin: auto;">
															<div class="vision-ui-cross"
																style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																name="Cancel" onclick="window.close();"></div>
															<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																style="color: #7b7b7b; font-size: 14px;">Cancel</div>
														</div>
													</div>
												</div>
													</xsl:otherwise>
												</xsl:choose>
												
											</xsl:if>
									
									
									<xsl:if test="normalize-space($old_data)= 'false'">
									<xsl:choose>
										<xsl:when test="$callReport='Y'">
											<div
												style="padding: 8px;position: sticky;height: 50px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
												class="" id="actionDiv">
												<div style="width: 33.33%;">
													<div class="actionbuttonsleft"
														style="width: 50px;text-align:  center;height: 50px;margin: auto;">
														<div class="vision-ui-cross"
															style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
															name="Cancel" onclick="goBackToPage('CallReportStatus.jsp','confirm');"></div>
														<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
															style="color: #7b7b7b; font-size: 14px;">Cancel</div>
													</div>
												</div>
												<div style="width: 33.33%;">
													<div class="actionbuttons"
														style="width: 50px;text-align: center;height: 50px;margin:auto;">
														<div class="vision-ui-delete"
															style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
															value="Delete" id="Delete" name="Delete"
															isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
															onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'Y',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
														<div class="gwt-Label summaryLabel"
															style="color: #666;font-size: 14px;padding: 4px 0 0 0;">Delete</div>
													</div>
												</div>
												<xsl:if test="$isConfirmEnable='Yes'"> 	<!--Added By Nilesh for confirm button enable according userright Start :: 
														22-04-19 -->
													<div style="width: 33.33%;">
														<div class="actionbuttonsright"
															style="width: 50px;text-align: center;height: 50px;margin:  auto;">
															<div class="vision-ui-check"
																style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																value="Confirm" id="Confirm" name="Confirm"
																isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
																onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'Y',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
															<div class="gwt-Label summaryLabel"
																style="color: #666;font-size: 14px;padding: 4px 0 0 0;">Confirm</div>
														</div>
													</div>
												</xsl:if>
											</div>
										</xsl:when>
										<xsl:otherwise>

											
											<xsl:variable name="conf_or_delete">
												<xsl:value-of select="//HeaderData/confirm_or_delete" />
											</xsl:variable>
											<xsl:variable name="isConfirmEnable">
												<xsl:value-of select="//cofirmEnable" />
											</xsl:variable><!--Added By Nilesh for confirm button enable according 
												userright Start :: 22-04-19 -->
												
											

											<xsl:if
												test="normalize-space($conf_or_delete)= 'view' or normalize-space($conf_or_delete)= 'C' or normalize-space($conf_or_delete)= 'D'">
												<xsl:choose>
													<xsl:when test="$conf_or_delete ='C'">

														<div
															style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
															class="" id="actionDiv">
															<!-- <input type="button" style="cursor:hand" class="button 
																green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="javascript:goBackToPage('ConfirmReportOTC.jsp','confirm');"/> -->
															<div style="width: 50%">
																<div class="actionbuttonsleft"
																	style="width: 50px;text-align:  center;height: 50px;margin: auto;">
																	<div class="vision-ui-cross"
																		style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																		name="Cancel" value="Cancel"
																		onclick="goBackToPage('ConfirmReport.jsp','confirm');"></div>
																	<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																		style="color: #7b7b7b; font-size: 14px;">Cancel</div>
																</div>
															</div>

															<!-- <input type="button" style="cursor:hand; float:right" 
																class="button green-Btn" value="Confirm" id="Confirm" name="Confirm" title='' 
																onclick="javascript:confirmOTCDCR('confirm','DSR')"/> -->

															<div style="width: 50%">
																<div class="actionbuttonsright"
																	style="width: 50px;text-align: center;height: 50px;margin:  auto;">
																	<div class="vision-ui-check"
																		style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																		value="Confirm" id="Confirm" name="Confirm"
																		isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
																		onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'N',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
																	<div class="gwt-Label summaryLabel"
																		style="color: #666;font-size: 14px;padding: 1px 0 0 0;">Confirm</div>
																</div>
															</div>
														</div>

														<!--name="Confirm" onclick="javascript:confirmOTCDCR('confirm','DSR','N')" 
															/> -->
													</xsl:when>
													<xsl:otherwise>

														<!-- <input type="button" style="cursor:hand" class="button 
															green-Btn" id="Cancel" name="Cancel" value="Cancel" title='' onclick="javascript:goBackToPage('DeleteReportOTC.jsp','delete');"/> -->
														<div
															style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
															class="" id="actionDiv">
															<div style="width: 50%;">
																<div class="actionbuttonsleft"
																	style="width: 50px;text-align:  center;height: 50px;margin: auto;">
																	<div class="vision-ui-cross"
																		style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																		name="Cancel" onclick="goBackToPage('DeleteReport.jsp','delete');"></div>
																	<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																		style="color: #7b7b7b; font-size: 14px;">Cancel</div>
																</div>
															</div>



															<!-- <input type="button" style="cursor:hand; float:right" 
																class="button green-Btn" value="Delete" id="Delete" name="Delete" title='' 
																onclick="javascript:confirmOTCDCR('delete','DSR')"/> -->

															<div style="width: 50%">
																<div class="actionbuttonsright"
																	style="width: 50px;text-align: center;height: 50px;margin:auto;">
																	<div class="vision-ui-delete"
																		style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																		value="Delete" id="Delete" name="Delete"
																		isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
																		onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'N',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
																	<div class="gwt-Label summaryLabel"
																		style="color: #666;font-size: 14px;padding: 1px 0 0 0;">Delete</div>
																</div>
															</div>
														</div>
														<!--name="Delete" onclick="javascript:confirmOTCDCR('delete','DSR','N')" 
															/> -->
														<!-- <span style ="float:right">Delete</span> -->

													</xsl:otherwise>
												</xsl:choose>
											</xsl:if>

											<xsl:if test="normalize-space($conf_or_delete)= 'SHOW_STATUS'">
												<xsl:choose>
													<xsl:when test="$report_id ='ANALYSIS_REPORT' or $device_type= 'Mobile'">
													<div
													style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
													class="" id="actionDiv">
													<div style="width: 33.33%;">
														<div class="actionbuttonsleft"
															style="width: 50px;text-align:  center;height: 50px;margin: auto;">
															<div class="vision-ui-cross"
																style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																name="Cancel" onclick="goBackToPriviousPage();"></div>
															<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																style="color: #7b7b7b; font-size: 14px;">Cancel</div>
														</div>
													</div>
													<div style="width: 33.33%;">
														<div class="actionbuttons"
															style="width: 50px;text-align: center;height: 50px;margin:auto;">
															<div class="vision-ui-delete"
																style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																value="Delete" id="Delete" name="Delete"
																isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
																onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
															<div class="gwt-Label summaryLabel"
																style="color: #666;font-size: 14px;padding: 1px 0 0 0;">Delete</div>
														</div>
													</div>

													<div style="width: 33.33%;">
														<div class="actionbuttonsright"
															style="width: 50px;text-align: center;height: 50px;margin:  auto;">
															<div class="vision-ui-check"
																style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																value="Confirm" id="Confirm" name="Confirm"
																isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
																onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
															<div class="gwt-Label summaryLabel"
																style="color: #666;font-size: 14px;padding: 1px 0 0 0;">Confirm</div>
														</div>
													</div>
												</div>
													</xsl:when>
													<xsl:otherwise>
													<div
													style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
													class="" id="actionDiv">
													<div style="width: 33.33%;">
														<div class="actionbuttonsleft"
															style="width: 50px;text-align:  center;height: 50px;margin: auto;">
															<div class="vision-ui-cross"
																style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																name="Cancel" onclick="window.close();"></div>
															<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																style="color: #7b7b7b; font-size: 14px;">Cancel</div>
														</div>
													</div>
													<div style="width: 33.33%;">
														<div class="actionbuttons"
															style="width: 50px;text-align: center;height: 50px;margin:auto;">
															<div class="vision-ui-delete"
																style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																value="Delete" id="Delete" name="Delete"
																isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
																onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
															<div class="gwt-Label summaryLabel"
																style="color: #666;font-size: 14px;padding: 1px 0 0 0;">Delete</div>
														</div>
													</div>

													<div style="width: 33.33%;">
														<div class="actionbuttonsright"
															style="width: 50px;text-align: center;height: 50px;margin:  auto;">
															<div class="vision-ui-check"
																style="cursor: hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																value="Confirm" id="Confirm" name="Confirm"
																isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
																onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))"></div> <!--getValidationAlert added by mrunalini sinkar -->
															<div class="gwt-Label summaryLabel"
																style="color: #666;font-size: 14px;padding: 1px 0 0 0;">Confirm</div>
														</div>
													</div>
												</div>
													</xsl:otherwise>
													</xsl:choose>
												
											</xsl:if>


											<xsl:if test="normalize-space($conf_or_delete)= 'VIEW_REPORT'">
												
												<xsl:choose>
													<xsl:when test="$report_id ='ANALYSIS_REPORT' or $device_type= 'Mobile'">
												<div
													style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
													class="" id="actionDiv">
													<div style="width: 33.33%;">
														<div class="actionbuttonsleft"
															style="width: 50px;text-align:  center;height: 50px;margin: auto;">
															<div class="vision-ui-cross"
																style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																name="Cancel" onclick="goBackToPriviousPage();"></div>
															<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																style="color: #7b7b7b; font-size: 14px;">Cancel</div>
														</div>
													</div>
												</div>
													</xsl:when>
													<xsl:otherwise>
													<div
													style="padding: 8px;position: fixed;height: 40px;bottom: 0;background:#fff;display:  inline-flex;width: calc(100% - 16px);box-shadow: 0px -3px 6px -3px rgba(0,0,0,.05);"
													class="" id="actionDiv">
													<div style="width: 33.33%;">
														<div class="actionbuttonsleft"
															style="width: 50px;text-align:  center;height: 50px;margin: auto;">
															<div class="vision-ui-cross"
																style="cursor:hand;background-color: #666;height: 30px;width: 30px;font-size: 18px;line-height: 30px;color: #fff;border-radius: 20px;margin: auto;"
																name="Cancel" onclick="window.close();"></div>
															<div class="color: #666;font-size: 14px;padding: 4px 0 0 0;"
																style="color: #7b7b7b; font-size: 14px;">Cancel</div>
														</div>
													</div>
												</div>
													</xsl:otherwise>
												</xsl:choose>
												
											</xsl:if>

										</xsl:otherwise>
									</xsl:choose>
									</xsl:if>
								</div>


							</div>



						</div>
					</div>
				</form>
			</body>

		</html>
	</xsl:template>
	<xsl:template name="tmpOrder">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="ord_detail">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="call_outcome_descr">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '!'), '^')" />
		</xsl:variable>
		<xsl:variable name="team_data">
			<xsl:value-of select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="class_descr">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>
		<xsl:variable name="spl_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="no_visit">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="meet_summ">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="pob_val">
			<xsl:value-of select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>
		<xsl:variable name="member_presents">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'@@@')" />
		</xsl:variable>
		<!-- Changed by Pooja on 06/01/20 [to display coaching details on confirm 
			xsl] START -->
		<xsl:variable name="coaching_data">
			<xsl:value-of select="substring-before(substring-after($ord_value,'@@@'),'$$@')" />
		</xsl:variable>
		<xsl:variable name="current_form_no">
					<xsl:value-of select="substring-before(substring-after($ord_value,'$$@'),'[')" />		
		</xsl:variable>
		<xsl:variable name="oth_participant">
			<xsl:value-of select="substring-after($ord_value,'[')" />
		</xsl:variable>
		<!-- Changed by Pooja on 06/01/20 [to display coaching details on confirm 
			xsl] END -->

		<xsl:variable name="upImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Up.svg')" />
		</xsl:variable>
		<xsl:variable name="downImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Down.svg')" />
		</xsl:variable>

		<xsl:variable name="ord_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $ord_detail)]">
				<xsl:variable name="order_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($order_strg_code) = normalize-space($doc_strg_code)">
					<xsl:value-of select="count(//node()[starts-with(name(), $ord_detail)])" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="strg_type">
			<xsl:if test="normalize-space($current_form_no)='doctor'">
				<xsl:for-each select="//DARDetails//doctor[1]">
					<xsl:value-of select="cust_type" />
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="normalize-space($current_form_no)='retailer'">
				<xsl:for-each select="//DARDetails//retailer[1]">
					<xsl:value-of select="cust_type" />
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="normalize-space($current_form_no)='stockist'">
				<xsl:for-each select="//DARDetails//StockData[1]">
					<xsl:value-of select="cust_type" />
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<!-- Item Details Start -->


		<xsl:variable name="item_detail">
			<xsl:if test="normalize-space($current_form_no)='doctor'">
				<xsl:for-each select="//DARDetails//doctor[1]">
					<xsl:value-of select="item_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='retailer'">
				<xsl:for-each select="//DARDetails//retailer[1]">
					<xsl:value-of select="item_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='stockist'">
				<xsl:for-each select="//DARDetails//StockData[1]">
					<xsl:value-of select="item_form_no" />
				</xsl:for-each>
			</xsl:if>

		</xsl:variable>

		<xsl:variable name="item_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $item_detail)]">
				<xsl:variable name="item_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($item_strg_code) = normalize-space($doc_strg_code)">
					<xsl:value-of select="count(//node()[starts-with(name(), $item_detail)])" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>



		<!-- Item Details End -->

		<xsl:variable name="display_detail">
			<xsl:if test="normalize-space($current_form_no)='doctor'">
				<xsl:for-each select="//DARDetails//doctor[1]">
					<xsl:value-of select="display_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='retailer'">
				<xsl:for-each select="//DARDetails//retailer[1]">
					<xsl:value-of select="display_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='stockist'">
				<xsl:for-each select="//DARDetails//StockData[1]">
					<xsl:value-of select="display_form_no" />
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>


		<xsl:variable name="display_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $display_detail)]">
				<xsl:variable name="display_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($display_strg_code) = normalize-space($doc_strg_code)">
					<xsl:value-of
						select="count(//node()[starts-with(name(), $display_detail)])" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<!-- Display Details end -->

		<!-- Brand Details Start -->

		<xsl:variable name="brand_detail">
			<xsl:if test="normalize-space($current_form_no)='doctor'">
				<xsl:for-each select="//DARDetails//doctor[1]">
					<xsl:value-of select="brand_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='retailer'">
				<xsl:for-each select="//DARDetails//retailer[1]">
					<xsl:value-of select="brand_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='stockist'">
				<xsl:for-each select="//DARDetails//StockData[1]">
					<xsl:value-of select="brand_form_no" />
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>



		<xsl:variable name="brand_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $brand_detail)]">
				<xsl:variable name="brand_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($brand_strg_code) = normalize-space($doc_strg_code)">
					<xsl:value-of select="count(//node()[starts-with(name(), $brand_detail)])" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<!-- Brand Details End -->


		<!-- Survey Details Start -->

		<xsl:variable name="survey_detail">

			<xsl:if test="normalize-space($current_form_no)='doctor'">
				<xsl:for-each select="//DARDetails//doctor[1]">
					<xsl:value-of select="prescription_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='retailer'">
				<xsl:for-each select="//DARDetails//retailer[1]">
					<xsl:value-of select="prescription_form_no" />
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="normalize-space($current_form_no)='stockist'">
				<xsl:for-each select="//DARDetails//StockData[1]">
					<xsl:value-of select="prescription_form_no" />
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>



		<xsl:variable name="survey_listed_count">
			<xsl:if test="normalize-space($survey_detail) !=''">
				<xsl:for-each select="//node()[starts-with(name(), $survey_detail)]">
					<xsl:variable name="survey_strg_code">
						<xsl:value-of select="strg_code" />
					</xsl:variable>
					<xsl:if
						test="normalize-space($survey_strg_code) = normalize-space($doc_strg_code)">
						<xsl:value-of
							select="count(//node()[starts-with(name(), $survey_detail)])" />
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<!-- Survey Details end -->





		<xsl:choose>
			<xsl:when
				test="$ord_listed_count > '0' or $item_listed_count > '0' or $display_listed_count > '0' or $brand_listed_count > '0' or $survey_listed_count > '0'">
				<TABLE cellspacing="0" cellpadding="0" class="tTitleD" border="0"
					width="100%">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">
								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="images/map/user.png"' class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">
										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500;"
												class="headerFont">
												<xsl:choose>
													<xsl:when
														test="contains($customer_types, 'UNLISTED') and normalize-space($strg_type)='C' and normalize-space($doc_strg_code) ='UR00000000'">
														<xsl:value-of
															select="concat($doc_strg_name,' - ',$member_presents)" />
													</xsl:when>
													<xsl:when
														test="contains($customer_types, 'UNLISTED') and normalize-space($strg_type)='D' and normalize-space($doc_strg_code) ='0000000000'">
														<xsl:value-of
															select="concat('No Of Unlisted Doctors',' - ',$member_presents)" />
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of
															select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
													</xsl:otherwise>
												</xsl:choose>

											</div>
											<div style="float: right; height: 18px; width: 18px;">
												<img id="{normalize-space($doc_strg_code)}" style="height: 10px; width: 10px; padding: 4px;"
													onClick="showDetailsOrder(this.id,'{normalize-space($upImage)}','{normalize-space($downImage)}')">
													<xsl:attribute name="src"><xsl:value-of
														select="$upImage" />
													</xsl:attribute>
												</img>
											</div>


											<xsl:if test="normalize-space($doc_locality) != ''">
												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Place Of Work:
													<xsl:value-of select="$doc_locality" />
												</div>
											</xsl:if>


											<xsl:choose>
												<xsl:when
													test="not(contains($customer_types, 'UNLISTED')) and $strg_type = 'D'">
													<div
														style="color: #666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Class:
														<xsl:value-of select="$class_descr" />
													</div>


													<div
														style="color: #666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Speciality:
														<xsl:value-of select="$spl_description" />
													</div>


													<div
														style="color: #666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Visit Plan:
														<xsl:value-of select="$no_visit" />
													</div>
												</xsl:when>
											</xsl:choose>



											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Visited With :
												<xsl:if test="string-length($team_data) != 0">
													<xsl:value-of select="$team_data" />
												</xsl:if>

											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Work With Other :
													<xsl:value-of select="$oth_participant" />

											</div>
											<!-- Changed by Pooja on 06/01/20 [to display coaching details 
												on confirm xsl] START -->
											<xsl:if test="string-length($coaching_data) != 0">
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Coaching Details :
												
													<xsl:value-of select="$coaching_data" />
											</div>
											</xsl:if>
											<!-- Changed by Pooja on 06/01/20 [to display coaching details 
												on confirm xsl] END -->
											<xsl:choose>
												<xsl:when test="contains($customer_types, 'UNLISTED')">
													<xsl:if test="normalize-space($event_time_start) != ''">
														<div
															style="color: #666; float: left; white-space: normal;width: 100%;"
															class="normalFont">
															Time Of First Call:
															<xsl:value-of select="$event_time_start" />
														</div>
													</xsl:if>
													<xsl:if test="normalize-space($event_time_end) != ''">
														<div
															style="color: #666; float: left; white-space: normal;width: 100%;"
															class="normalFont">
															Time Of Last Call:
															<xsl:value-of select="$event_time_end" />
														</div>
													</xsl:if>
												</xsl:when>
												<xsl:otherwise>
													<xsl:if test="normalize-space($event_time_start) != ''">
														<div
															style="color: #666; float: left; white-space: normal;width: 100%;"
															class="normalFont">
															Visited Time:
															<xsl:value-of select="$event_time_start" />
														</div>
													</xsl:if>
												</xsl:otherwise>
											</xsl:choose>

											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												POB Value:
												<xsl:value-of select="$pob_val" />
											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Remarks:
												<xsl:value-of select="$meet_summ" />


											</div>

										</div>


									</div>
								</div>
							</td>
						</tr>
						<xsl:call-template name="tempOrderData">
							<xsl:with-param name="orderData"
								select="concat($ord_detail,'@',$doc_strg_code,'#',$ord_listed_count,'*',$item_listed_count,'~',$item_detail,'^',$display_listed_count,'**',$display_detail,'##',$brand_listed_count,'@@',$brand_detail,'{',$survey_listed_count,'}',$survey_detail)" />
						</xsl:call-template>
					</thead>
				</TABLE>
			</xsl:when>
			<xsl:otherwise>
				<TABLE cellspacing="0" cellpadding="0" class="tTitleD" border="0"
					width="100%">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">
								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="images/map/user.png"' class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">
										<div
											style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500"
											class="headerFont">

											<xsl:choose>
												<xsl:when
													test="contains($customer_types, 'UNLISTED') and normalize-space($strg_type)='C' and normalize-space($doc_strg_code) ='UR00000000'">
													<xsl:value-of
														select="concat($doc_strg_name,' - ',$member_presents)" />
												</xsl:when>
												<xsl:when
													test="contains($customer_types, 'UNLISTED') and normalize-space($strg_type)='D' and normalize-space($doc_strg_code) ='0000000000'">
													<xsl:value-of
														select="concat('No Of Unlisted Doctors',' - ',$member_presents)" />
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of
														select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
												</xsl:otherwise>
											</xsl:choose>


										</div>
										<xsl:if test="normalize-space($doc_locality) != ''">
											<div
												style="color:#666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Place Of Work:
												<xsl:value-of select="$doc_locality" />
											</div>
										</xsl:if>


										<xsl:choose>
											<xsl:when
												test="not(contains($customer_types, 'UNLISTED')) and $strg_type = 'D'">
												<div
													style="color: #666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Class:
													<xsl:value-of select="$class_descr" />
												</div>


												<div
													style="color: #666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Speciality:
													<xsl:value-of select="$spl_description" />
												</div>


												<div
													style="color: #666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Visit Plan:
													<xsl:value-of select="$no_visit" />
												</div>
											</xsl:when>
										</xsl:choose>

										<div
											style="color: #666; float: left; white-space: normal;width: 100%;"
											class="normalFont">
											Visited With :
											<xsl:if test="string-length($team_data) != 0">
												<xsl:value-of select="$team_data" />
											</xsl:if>

										</div>
										<div style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Work With Other :
													<xsl:value-of select="$oth_participant" />

										</div>
										<!-- Changed by Pooja on 06/01/20 [to display coaching details 
											on confirm xsl] START -->
									<xsl:if test="string-length($coaching_data) != 0">
										<div
											style="color: #666; float: left; white-space: normal;width: 100%;"
											class="normalFont">
											Coaching Details :
												<xsl:value-of select="$coaching_data" />
										</div>
										</xsl:if>
										<!-- Changed by Pooja on 06/01/20 [to display coaching details 
											on confirm xsl] END -->
										<xsl:choose>
											<xsl:when test="contains($customer_types, 'UNLISTED')">
												<xsl:if test="normalize-space($event_time_start) != ''">
													<div
														style="color: #666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Time Of First Call:
														<xsl:value-of select="$event_time_start" />
													</div>
												</xsl:if>
												<xsl:if test="normalize-space($event_time_end) != ''">
													<div
														style="color: #666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Time Of Last Call:
														<xsl:value-of select="$event_time_end" />
													</div>
												</xsl:if>
											</xsl:when>
											<xsl:otherwise>
												<xsl:if test="normalize-space($event_time_start) != ''">
													<div
														style="color: #666; float: left; white-space: normal;width: 100%;"
														class="normalFont">
														Visited Time:
														<xsl:value-of select="$event_time_start" />
													</div>
												</xsl:if>
											</xsl:otherwise>
										</xsl:choose>
										<div
											style="color: #666; float: left; white-space: normal;width: 100%;"
											class="normalFont">
											POB Value:
											<xsl:value-of select="$pob_val" />
										</div>
										<div
											style="color: #666; float: left; white-space: normal;width: 100%;"
											class="normalFont">
											Remarks:
											<xsl:value-of select="$meet_summ" />

										</div>


									</div>
								</div>
							</td>
							<td CLASS="cellttl1 tdCenter title"></td>
						</tr>
					</thead>
				</TABLE>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="tempOrderData">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="order_details">
			<xsl:value-of select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="order_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'#'),'*')" />
		</xsl:variable>

		<!-- Item Details start -->
		<xsl:variable name="item_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'*'),'~')" />
		</xsl:variable>

		<xsl:variable name="item_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'~'),'^')" />
		</xsl:variable>
		<!-- Item Details end -->

		<!-- display Details Start -->
		<xsl:variable name="display_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'^'),'**')" />
		</xsl:variable>

		<xsl:variable name="display_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'**'),'##')" />
		</xsl:variable>
		<!-- display Details end -->
		<!-- brand Details Start -->
		<xsl:variable name="brand_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'##'),'@@')" />
		</xsl:variable>

		<xsl:variable name="brand_details">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@@'),'{')" />
		</xsl:variable>
		<xsl:value-of select="brand_details" />
		<!-- brand Details End -->
		<!-- surey Details Start -->
		<xsl:variable name="survey_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'{'),'}')" />
		</xsl:variable>

		<xsl:variable name="survey_details">
			<xsl:value-of select="substring-after($order_data_value,'}')" />
		</xsl:variable>

		<!-- surey Details End -->
		<xsl:variable name="prescription_listed_count">
			<xsl:value-of select="count(//DARDetails//surveybrand)" />
		</xsl:variable>

		<xsl:if test="normalize-space($order_form_cnt) > 0">

			<TABLE id="orderTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD subFormTable" border="0" width="100%"
				style="background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<TR id="order.{normalize-space($dcotor_cust_code)}.heading1">
						<TH style="float: left;">Order</TH>
						<TH></TH>
						<TH></TH>
						<TH></TH>
					</TR>
					<TR id="order.{normalize-space($dcotor_cust_code)}.heading">
						<TH CLASS="cellttl1 cellttlblck heading tdLeft normalFont">Product</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdCenter normalFont">Quantity</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdCenter normalFont">Value</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdRight normalFont">Scheme Description</TH>
					</TR>
				</thead>
				<tbody id="order.{normalize-space($dcotor_cust_code)}.details">
					<xsl:for-each select="//node()[starts-with(name(), $order_details)]">
						<xsl:variable name="ord_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="ordervalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="Scheme_description">
							<xsl:value-of select="description" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($ord_strg_code) = normalize-space($dcotor_cust_code)">
							<TR>
								<TD CLASS="cellttl1 tdCenter title tdLeft normalFont">
									<xsl:value-of select="$item_descr" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdCenter normalFont">
									<xsl:value-of select="$quantity" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdCenter normalFont">
									<xsl:value-of select="$ordervalue" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdRight normalFont">
									<xsl:value-of select="$Scheme_description" />
								</TD>
							</TR>
						</xsl:if>
					</xsl:for-each>
				</tbody>
			</TABLE>
		</xsl:if>
		<xsl:if test="normalize-space($item_form_cnt) > 0">
			<TABLE id="itemTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD subFormTable" border="0" width="100%"
				style="background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<TR id="item.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">BR/Sample</th>
						<th></th>
						<th></th>
					</TR>
					<TR id="item.{normalize-space($dcotor_cust_code)}.heading">
						<TH CLASS="cellttl1 cellttlblck heading tdLeft normalFont">Input Type</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdCenter normalFont">Product</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdRight normalFont">Quantity</TH>
					</TR>
				</thead>
				<tbody id="item.{normalize-space($dcotor_cust_code)}.details">
					<xsl:for-each select="//node()[starts-with(name(), $item_details)]">
						<xsl:variable name="item_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="item_usage">
							<xsl:value-of select="item_usage" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($item_strg_code) = normalize-space($dcotor_cust_code)">
							<TR>
								<TD CLASS="cellttl1 tdCenter title tdLeft normalFont">
									<xsl:value-of select="$item_usage" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdCenter normalFont">
									<xsl:value-of select="$item_descr" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdRight normalFont">
									<xsl:value-of select="$quantity" />
								</TD>
							</TR>
						</xsl:if>
					</xsl:for-each>
				</tbody>
			</TABLE>
		</xsl:if>
		<!-- Item Details end -->
		<xsl:if test="normalize-space($brand_form_cnt) > 0">
			<TABLE id="brandTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD subFormTable" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<tr id="brand.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Brand</th>
						<th></th>
					</tr>
					<TR id="brand.{normalize-space($dcotor_cust_code)}.heading">
						<TH CLASS="cellttl1 cellttlblck heading tdLeft firstData">Brand</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdCenter firstData">Pitch Order</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdRight firstData">Actual Order</TH>

					</TR>
				</thead>

				<tbody id="brand.{normalize-space($dcotor_cust_code)}.details">
					<xsl:for-each select="//node()[starts-with(name(), $brand_details)]">
						<xsl:variable name="brand_descr">
							<xsl:value-of select="brand_descr" />
						</xsl:variable>
						<xsl:variable name="pitch_priority">
							<xsl:value-of select="pitch_priority" />
						</xsl:variable>
						<xsl:variable name="pitch_sequence">
							<xsl:value-of select="pitch_sequence" />
						</xsl:variable>
						<xsl:variable name="brand_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>


						<xsl:if
							test="normalize-space($brand_strg_code) = normalize-space($dcotor_cust_code)">
							<TR style="background-color: #f0eded;">
								<TD CLASS="cellttl1 tdLeft title">
									<xsl:value-of select="$brand_descr" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title">
									<xsl:value-of select="$pitch_priority" />
								</TD>
								<TD CLASS="cellttl1 tdRight title">
									<xsl:value-of select="$pitch_sequence" />
								</TD>

							</TR>
						</xsl:if>
					</xsl:for-each>
				</tbody>
			</TABLE>
		</xsl:if>

		<xsl:if test="normalize-space($survey_form_cnt) > '0'">
			<TABLE id="prescriptionTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD subFormTable" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">

				<thead class="" style="height : 30px;">
					<tr id="prescription.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Prescription</th>
					</tr>
					<TR id="prescription.{normalize-space($dcotor_cust_code)}.heading">
						<TH CLASS="cellttl1 cellttlblck heading tdCenter firstData">Item</TH>
					</TR>
				</thead>
				<tbody id="prescription.{normalize-space($dcotor_cust_code)}.details">
					<xsl:for-each select="//node()[starts-with(name(), $survey_details)]">
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="prescription_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($prescription_strg_code) = normalize-space($dcotor_cust_code)">
							<TR style="background-color: #f0eded;">
								<TD CLASS="cellttl1 tdCenter title">
									<xsl:value-of select="$item_descr" />
								</TD>
							</TR>
						</xsl:if>
					</xsl:for-each>


				</tbody>

			</TABLE>


		</xsl:if>
	</xsl:template>
	<xsl:template name="meetTemp">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="first"
			select="substring-before($stringtosplit, ',')" />
		<xsl:variable name="remaining" select="substring-after($stringtosplit, ',')" />
		<xsl:variable name="value">
			<xsl:value-of select="$first" />
		</xsl:variable>
		<xsl:variable name="type">
			<xsl:value-of select="substring($value,6,1)" />
		</xsl:variable>
		<xsl:variable name="text">
			<xsl:value-of select="substring($value,8)" />
		</xsl:variable>
		<xsl:variable name="remark">
			<xsl:choose>
				<xsl:when test="($type='C') ">
					<xsl:value-of select="$text" />
					[Complaint]
					<br />
				</xsl:when>
				<xsl:when test="($type='R') ">
					<xsl:value-of select="$text" />
					[Request]
					<br />
				</xsl:when>
				<xsl:when test="($type='Q') ">
					<xsl:value-of select="$text" />
					[Query]
					<br />
				</xsl:when>
				<xsl:when test="($type='P') ">
					<xsl:value-of select="$text" />
					[Compliment]
					<br />
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="concat($remark,' ')" />
		<xsl:if test="$remaining">
			<xsl:call-template name="meetTemp">
				<xsl:with-param name="stringtosplit" select="$remaining" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>