<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<style type="text/css">
.pg-normal {
	color: #333;
	font-size: 15px;
	cursor: pointer;
	background: #e7e7e7; 
	padding: 2px 4px 2px 4px;
	border-radius : 2px;
	
}
.pg-number {
	color: #333;
	font-size: 15px;
	cursor: pointer;
	background: #e7e7e7; 
	padding: 2px 4px 2px 4px;
	margin-left: 2px;
	border-radius : 2px;
}

.pg-selected {
	color: #fff;
	font-size: 15px;
	background: #679fdd;
	padding: 2px 4px 2px 4px;
	border-radius : 2px;
}

table.mt {
	font-family: arial;
	border-collapse: collapse;
	border: solid 3px #7f7f7f;
	font-size: small;
}

table.mt td {
	padding: 5px;
	border-right: solid 1px #7f7f7f;
}

table.mt .even {
	background-color: #EEE8AC;
}

table.mt .odd {
	background-color: #F9FAD0;
}

<!--table.mt th {
	border: 1px solid #7f7f7f;
	padding: 5px;
	height: auto;
	background: #D0B389;
}-->

table.mt th a {
	text-decoration: none;
	text-align: center;
	padding-right: 20px;
	font-weight: bold;
	white-space: nowrap;
}

table.mt tfoot td {
	border-top: 1px solid #7f7f7f;
	background-color: #E1ECF9;
}

table.mt thead td {
	vertical-align: middle;
	background-color: #E1ECF9;
	border: none;
}

table.mt thead .tableHeader {
	font-size: larger;
	font-weight: bold;
}

table.mt thead .filter {
	text-align: right;
}

table.mt tfoot {
	background-color: #E1ECF9;
	text-align: center;
}

table.mt .tablesorterPager {
	padding: 10px 0 10px 0;
}

table.mt .tablesorterPager span {
	padding: 0 5px 0 5px;
}

table.mt .tablesorterPager input.prev {
	width: auto;
	margin-right: 10px;
}

table.mt .tablesorterPager input.next {
	width: auto;
	margin-left: 10px;
}

table.mt .pagedisplay {
	font-size: 10pt;
	width: 30px;
	border: 0px;
	background-color: #E1ECF9;
	text-align: center;
	vertical-align: top;
}
</style>
<script type="text/javascript">
<![CDATA[

]]>
</script>
</head>

<script type="text/javascript" src="/ibase/webitm/js/BrandReportingWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<!--<script type="text/javascript" src="/ibase/webitm/js/sortable_table.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/BranddescrFixedTableHeader.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/Branddescr_plan_request.js"></script>-->

<body onLoad="loadHeader();setcolor();setTotalOnLoad();">
<style type="text/css">

th {
    background-color: grey;
    color: white;
    text-align: center;
    vertical-align: bottom;
    height: 62px;
    padding-bottom: 3px;
    padding-left: 5px;
    padding-right: 5px;
    border-bottom: 1px solid #ccc;
}

.verticalText {
    width: 23px;
    padding-left: 10px;
    padding-right: 3px;
    padding-top: 15px;
    -webkit-transform: rotate(-90deg);
    -moz-transform: rotate(-90deg);
    height: 46px;
    line-height: 15px;
}

.thClass
{
border:inset 0;
background:white;
font-family:verdana;
font-size: 13px;
color: black;
border-left: 2px solid #ddd;
border-top: 2px solid #ddd;
border-right: 2px solid #ddd;
}

.tHeader
{
	line-height: 15px;
	padding: 0 10px;
	color: #555;
	text-shadow: none;
	border-width: 1px 1px 1px 0;
	border-style: solid;
	background-color: white;
	-webkit-box-shadow: inset 0 1px rgba(255,255,255,0.2), inset 0 0 0 1px rgba(255,255,255,0.06), 0 1px rgba(0,0,0,0.04);
	box-shadow: inset 0 1px rgba(255,255,255,0.2), inset 0 0 0 1px rgba(255,255,255,0.06), 0 1px rgba(0,0,0,0.04);
	text-rendering: optimizeLegibility;
	border-left: 1px solid #ddd;
	border-top: 1px solid #ddd;
	border-bottom: 2px solid #ddd;
	border-right: 1px solid #ddd;
	border-top-left-radius: 0 !important;
	font-size: 14px;
	font-weight: bold;
}

.table-head>tr>th {
	padding: 0 10px;
	border-left: 2px solid #ddd;
	border-top: 2px solid #ddd;
	border-right: 2px solid #ddd;
	font-family: Arial, Helvetica, Helvetica Neue, Verdana, sans-serif;
	text-rendering: optimizeLegibility;
	font-size: 14px;
	font-weight: bold;
}

.trClassOdd td
{
	line-height: 35px;
	padding: 0 10px;
	border: 1px solid #ddd;
	font-size: 12px;
	text-shadow: none;
	background: #f5f5f5;
	text-rendering: optimizeLegibility;
}
.trClassOdd:hover {
	background-color: #f5f5f5;
}
.error
{
	border: solid 1px red;
	color : #333;
	background : white;
	text-align : left;
	font-size : 14px;
	line-height: 20px;
}

        table.mt {border-width: 1px;border-spacing:0px ;border-style: solid;border-color: #cfcfcf;border-collapse: collapse;line-height: 25px;background-color: #FFF;}
        table.mt th {border-width: 1px;padding: 1px;border-style: solid;border-color: #cfcfcf;white-space: normal;text-rendering: optimizeLegibility;}
        table.mt td {border-width: 1px;padding: 1px;border-style: solid;border-color: #cfcfcf;vertical-align:middle;}
	
	.tdClass>td{
	padding: 0 10px;
	border-right: 1px solid #eee;
	border-right-color: rgba(0, 0, 0, 0.07);
	font-family: Arial, Helvetica, Helvetica Neue, Verdana, sans-serif;
	font-size: 12px;
	text-shadow: 0 1px white;
	text-shadow: 0 1px 1px rgba(0, 0, 0, .2);
	text-rendering: optimizeLegib

	}
	
	.headerTd
	{
		font-size: 16px;
		text-align: left;
		<!-- padding-left: 20px; -->
		background-color: #f7f8fa;
		overflow: hidden;
		color: white;
	}
.verticalText {
  
   height: 23px;
   line-height: 1;
   -webkit-transform: rotate(-90deg);
   font-size: 11px;
    
}
.tooltip {
  position: relative;
  display: inline-block;
    height:29px;
}

.tooltip .tooltiptext {
visibility: hidden;
   webkit-transform: rotate(90deg);
   transform: rotate(90deg);
   width: 250px;
   line-height: 1;
   height: auto;
   background-color: #666666;
   color: #fff;
   opacity: 1;
   text-align: center;
   border-radius: 6px;
   padding: 5px;
   position: absolute;
   z-index: 30;
   top: 7px;
   display: block;
   left: -110px;
   right: -67px;
   margin: -3px -13px 7px -1px;
   botton:100%
}

.tooltip:hover .tooltiptext {
  visibility: visible;
}

.tooltip .tooltiptext::after {
 content: "";
 position: absolute;
 bottom: 100%;
 left: 55%;
 margin-left: -5px;
 border-width: 5px;
 border-style: solid;
 border-color: transparent transparent #666666 transparent;
   
}	
.search{
	
	padding: 3px;
    border: none;
    width: 100%;
    box-shadow: inset 0 -1px 0 0 rgba(0,0,0,.1);
	}
	.tooltip {
  position: relative;
  display: inline-block;
}
</style>
<link href="/ibase/webitm/xsl/Standard/WIZARD/css/htmlWizard.css" rel="stylesheet" type="text/css"/>
<link href="/ibase/webitm/xsl/Standard/WIZARD/css/dataAdjust.css" rel="stylesheet" type="text/css"/>
<!--<link href="/ibase/webitm/css/BranddescrFixedTableHeader.css" rel="stylesheet"/>-->
<!--<link rel="stylesheet" href="/ibase/webitm/css/Standard/default.css" type="text/css" />-->
<link id="userThemeLink" type="text/css" rel="stylesheet" href=""/>
<form name = "Wizard_Travel" id = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" style="background-color: #f7f8fa; " onSubmit="javascript:return validatebrand(2);">

<table id="errorTravelTable"  width="100%"  style="margin: 15px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0">
	<xsl:for-each select="//error">
			<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
			<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
			<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
			<xsl:if test="position() = 1">

					<tr  style="background: rgba(255, 204, 0, 0.66);">	
						<td class="tdss_leftAlign"     style="background: rgba(255, 204, 0, 0.66); padding-right:5px; padding-left:5xp"  nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
							Description :
						</td>
						<td class="tdss_rightAlign"    style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
							<a href="#" style="text-decoration:none;" onclick="doHideMsg('errorTravelTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
						</td>

					</tr>
			</xsl:if>
			<tr  style="background: rgba(255, 204, 0, 0.66);">
				<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
					<xsl:value-of select="message"/>
				</td>
				<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
					<xsl:value-of select="description"/>
				</td>
				<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
				</td>

				
			</tr>
	</xsl:for-each>
	<xsl:for-each select="//error">
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:if test="position() = 1">
				<xsl:if test="$type = 'W'">
				<tr  style="background: rgba(255, 204, 0, 0.66);">
					<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
						Override Warnings :
					</td>
					<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
						<input  type="checkbox"  name="forceSave"  value="false" onClick="javascript:setChecked(this)"/>
					</td>
					<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
					</td>

				</tr>
				</xsl:if>
			</xsl:if>	
	</xsl:for-each>
	</table>


		<!-- <TABLE border="0" width="99%" class="header_td" cellpadding="0" cellspacing="0" style="background-color: #f7f8fa;height:55px;"> -->
		<!-- <TABLE border="0" width="99%" class="headerTd" cellpadding="0" cellspacing="0" style="background-color: #f7f8fa;">
			<TR>	  
					<td class="header_main" nowrap="true" align="left" valign="middle"  >
                                                <table class="headerTd" ><tr>
						<xsl:for-each select="//HEADERDATA">
							<xsl:if test="position() = 1">
							<xsl:variable name="sales_pers_name"><xsl:value-of select="sales_pers_name"/></xsl:variable>
							<xsl:variable name="standescr"><xsl:value-of select="standescr"/></xsl:variable>	
							<xsl:variable name="itmdescr"><xsl:value-of select="itmdescr"/></xsl:variable>	
							<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>		
							<td width = "220px" class="header_main" style="float:left;font-size: 14px;"><b>Division:</b> <xsl:value-of select="itmdescr"/></td><td style="width:5%"></td>
							<td width = "150px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b> Station:</b>  <xsl:value-of select="standescr"/> </td><td style="width:5%"></td>
							<td width = "250px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"><b>Name :</b>  <xsl:value-of select="sales_pers_name"/></td><td style="width:5%"></td>
							<td width = "140px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Period :</b>  <xsl:value-of select="prd_code"/></td><td style="width:15%"></td>
							<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Enter average per month</b> </td>

							</xsl:if>
						</xsl:for-each>
						</tr></table>
					</td>
			</TR>
		</TABLE> -->
		<!-- <div>
			<xsl:for-each select="//HEADERDATA">
				<xsl:if test="position() = 1">
					<xsl:variable name="sales_pers_name"><xsl:value-of select="sales_pers_name"/></xsl:variable>
					<xsl:variable name="standescr"><xsl:value-of select="standescr"/></xsl:variable>	
					<xsl:variable name="itmdescr"><xsl:value-of select="itmdescr"/></xsl:variable>	
									<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>
				
					<div class="ul">
						<div class="li">
							<div class="box">
								<div class="lbl">Division:</div>
								<div class="txt"><xsl:value-of select="itmdescr"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Station:</div>
								<div class="txt"><xsl:value-of select="standescr"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Name:</div>
								<div class="txt"><xsl:value-of select="sales_pers_name"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Period:</div>
								<div class="txt"><xsl:value-of select="prd_code"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Enter average per month</div>
							</div>
						</div>
				
					</div>
					<td class="header_main" style="float:left;font-size: 14px;"><b>Division:</b> <xsl:value-of select="itmdescr"/></td><td style="width:5%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b> Station:</b>  <xsl:value-of select="standescr"/> </td><td style="width:5%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"><b>Name :</b>  <xsl:value-of select="sales_pers_name"/></td><td style="width:5%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Period :</b>  <xsl:value-of select="prd_code"/></td><td style="width:15%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Enter average per month</b> </td>
				</xsl:if>
			</xsl:for-each>
		</div> -->
		 <div border="0" cellspacing="1" cellpadding="1" style="width : 99%;margin-left:5px height:62px;" >
		<!--  <TABLE border="0" width="99%" class="" cellpadding="0" cellspacing="0" style="background-color: #f7f8fa;">
			<TR>	  
					<td class="header_main" nowrap="true" align="left" valign="middle"  >
                                                <table class=""  width="100%" cellpadding="0" cellspacing="0">
                  
						<xsl:for-each select="//HEADERDATA">
							<xsl:if test="position() = 1">
							<xsl:variable name="sales_pers_name"><xsl:value-of select="sales_pers_name"/></xsl:variable>
							<xsl:variable name="standescr"><xsl:value-of select="standescr"/></xsl:variable>	
							<xsl:variable name="itmdescr"><xsl:value-of select="itmdescr"/></xsl:variable>	
							<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>	
							<xsl:variable name="emp_code"><xsl:value-of select="emp_code"/></xsl:variable>	
							
							<tr> <td class="header_main" style="float:left;font-size: 12px;width:70%;padding: 0 0 3px 0;"><b>Name :</b> <xsl:value-of select="sales_pers_name"/></td>
							<td class="header_main" style="float:left;font-size: 12px;width: 30%;"> <b>Period :</b><xsl:value-of select="prd_code"/></td> 
							<td class="header_main" style="float:left;font-size: 12px;width: 70%;margin-left: -8px;"><b>Division:</b><xsl:value-of select="itmdescr"/></td>
							<td class="header_main" style="float:left;font-size: 12px;width: 30%;margin-left: -20px;"> <b>Station:</b>  <xsl:value-of select="standescr"/> </td></tr>
							
							

							</xsl:if>
						</xsl:for-each>
						</table>
					</td>
			</TR>
		</TABLE> -->
		
		<TABLE border="0" width="99%" class="headerTd" cellpadding="0" cellspacing="0" style="background-color: #f7f8fa;">
			<TR>	  
					<td class="header_main" nowrap="true" align="left" valign="middle"  >
					<div >
                                                <table class="headerTd" ><tr>
						<xsl:for-each select="//HEADERDATA">
							<xsl:if test="position() = 1">
							<xsl:variable name="sales_pers_name"><xsl:value-of select="sales_pers_name"/></xsl:variable>
							<xsl:variable name="standescr"><xsl:value-of select="standescr"/></xsl:variable>	
							<xsl:variable name="itmdescr"><xsl:value-of select="itmdescr"/></xsl:variable>	
							<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>		
							<td width = "220px" class="header_main" style="float:left;font-size: 14px;"><b>Division : </b> <xsl:value-of select="itmdescr"/></td><!-- <td style="width:5%"></td> -->
							<td width = "150px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b> Station : </b>  <xsl:value-of select="standescr"/> </td><!-- <td style="width:5%"></td> -->
							<td width = "250px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"><b>Name : </b>  <xsl:value-of select="sales_pers_name"/></td><!-- <td style="width:5%"></td> -->
							<td width = "140px" class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Period : </b>  <xsl:value-of select="prd_code"/></td><!-- <td style="width:15%"></td> -->
							<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Enter average per month</b> </td>

							</xsl:if>
						</xsl:for-each>
						</tr></table>
						</div>
					</td>
			</TR>
		</TABLE>
		<!-- 	<div>
			<xsl:for-each select="//HEADERDATA">
				<xsl:if test="position() = 1">
					<xsl:variable name="sales_pers_name"><xsl:value-of select="sales_pers_name"/></xsl:variable>
					<xsl:variable name="standescr"><xsl:value-of select="standescr"/></xsl:variable>	
					<xsl:variable name="itmdescr"><xsl:value-of select="itmdescr"/></xsl:variable>	
									<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>
				
					<div class="ul">
						<div class="li">
							<div class="box">
								<div class="lbl">Division:</div>
								<div class="txt"><xsl:value-of select="itmdescr"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Station:</div>
								<div class="txt"><xsl:value-of select="standescr"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Name:</div>
								<div class="txt"><xsl:value-of select="sales_pers_name"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Period:</div>
								<div class="txt"><xsl:value-of select="prd_code"/></div>
							</div>
						</div>
						<div class="li">
							<div class="box">
								<div class="lbl">Enter average per month</div>
							</div>
						</div>
				
					</div>
					<td class="header_main" style="float:left;font-size: 14px;"><b>Division:</b> <xsl:value-of select="itmdescr"/></td><td style="width:5%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b> Station:</b>  <xsl:value-of select="standescr"/> </td><td style="width:5%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"><b>Name :</b>  <xsl:value-of select="sales_pers_name"/></td><td style="width:5%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Period :</b>  <xsl:value-of select="prd_code"/></td><td style="width:15%"></td>
					<td class="header_main" style="margin-left:5px;float:left;font-size: 14px;"> <b>Enter average per month</b> </td>
				</xsl:if>
			</xsl:for-each>
		</div> -->
		</div> 
				 <div  border="0" cellspacing="1" cellpadding="1" style="width : 99%; margin-left:5px;" >
				 		        
		<!-- 
		          <input type="text" id="myInput" style="width: 137px; margin-left:5px;" onkeyup="myFunction()" placeholder="Search" title="Type in a SC Code"  />
			      <input type="text" id="myInput1" style="width: 302px; margin-left:-5px;"  onkeyup="myFunction1()" placeholder="Search" title="Type in a Doctor Name" />		    			      
			      <input type="text" id="myInput2" style="width: 134px; margin-left:-5px;" onkeyup="myFunction2()" placeholder="Search" title="Type in a Locality"  />			      
			      <input type="text" id="myInput3" style="width: 130px; margin-left:-5px;" onkeyup="myFunction3()" placeholder="Search" title="Type in a Speciality"  />
			       -->
			     
			      <input type="text" id="myInput" onkeyup="myFunction()" placeholder="Search" title="Type in a Doctor Name"  />	      
			      <input type="text" id="myInput1" onkeyup="myFunction1()" placeholder="Search" title="Type in a SC Code" />
			      <input type="text" id="myInput2" onkeyup="myFunction2()" placeholder="Search" title="Type in a Locality"  />   
			      <input type="text" id="myInput3" onkeyup="myFunction3()" placeholder="Search" title="Type in a Speciality"  />
			      
        </div>
    
        
	<!--<div class = ""  style="height: 100%;width: 100%;position: fixed;"> -->
	<!--<div id="innerDiv" style="overflow-y:auto;overflow-x:auto;max-height:80%; width: 100%;">-->
	<!-- <div id="Scroller:fxbrandTable:OuterDiv" style="overflow: hidden;padding: 0px;margin: 0px;height: 86px;"></div> -->
		<table id="brandTable" name="brandTable" class="mt" border="0" cellspacing="1" cellpadding="1" style="width : 99%;margin-left:5px;">
			<thead class="table-head">
			<tr class="thClass" >
			      <!--<td class="tHeader"></td>-->
			      <th class="thClass" ><div class="verticalText">SC Code</div></th>
			      <th class="thClass"><div class="verticalText">Doctor Name</div></th>
			      <th class="thClass"><div class="verticalText">Locality</div></th>
			      <th class="thClass"><div class="verticalText">Speciality</div></th>
			      <th class="thClass"><div class="verticalText">Category</div></th>
			      <th class="thClass"><div class="verticalText">Period</div></th>
			      <th class="thClass"><div class="verticalText">Total</div></th> 
			     <!--<th style="border-bottom: 0px;" class="tHeader">
			    <div class="verticalText">
			    SC Code
			    </div>
			    </th>-->
			        <xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<!--<xsl:value-of select="$dbID"/>::-->
				<xsl:variable name="i" select="position()" />
					<xsl:for-each select="//BRAND_DESC2">
						<xsl:variable name="editFlag"><xsl:value-of select="@editFlag"/></xsl:variable>
						<xsl:variable name="parentDbID"><xsl:value-of select="@parentDomID"/></xsl:variable>
						<xsl:variable name="brand_code"><xsl:value-of select="brand_code"/></xsl:variable>
						<xsl:variable name="brand_descr"><xsl:value-of select="brand_descr"/></xsl:variable>
						<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>

						    <xsl:if test=" $parentDbID = 1 and $dbID = 1 ">
						   <!-- <xsl:value-of select="brand_code"/>:::	-->	      
							<th class="thClass">
								 <!--<xsl:value-of select="$parentDbID"/>:<xsl:value-of select="$dbID"/>--><!-- <div class="verticalText"><xsl:value-of select="brand_descr"/></div> --><div class="verticalText tooltip"> <xsl:value-of select="brand_descr"/>  <span class="tooltiptext"><xsl:value-of select="brand_descr"/></span> </div>
								<input  type="hidden"  name="BRAND_DESC3.{normalize-space($line_no)}.brand_code" id="BRAND_DESC3.{normalize-space($line_no)}.brand_code" style="width : 100%" value="{$brand_code}"  ISCHANGED="false"/>
							</th>
						    </xsl:if>

					</xsl:for-each>
							<!--<xsl:choose>
							  <xsl:when test="$editFlag ='E'">
									<xsl:if test=" $parentDbID = '1' ">
									    	
									      <td width="20%" class="tHeader" nowrap="true" valign="bottom">
										      <strong><xsl:value-of select="parentDbID"/><xsl:value-of select="brand_code"/></strong>
									      </td>
									</xsl:if>
				  
							  </xsl:when>
							  <xsl:otherwise>
									      <td width="20%" class="tHeader" nowrap="true" valign="bottom">
										      <strong><xsl:value-of select="brand_code"/></strong>
									      </td>
								  
							  </xsl:otherwise>
						</xsl:choose>-->
				</xsl:for-each>
				<!-- <th class="thClass"><div class="verticalText"> Total</div></th> -->
				
			</tr>
			</thead>
			<tbody class='table-body fadeInDown'>
			<xsl:for-each select="//Detail2">
			    <xsl:variable name="brand_nos"><xsl:value-of select="brand_nos"/></xsl:variable>
		
			    <xsl:variable name="sales_pers"><xsl:value-of select="sales_pers"/></xsl:variable>
			    <xsl:variable name="stan_code__from"><xsl:value-of select="stan_code__from"/></xsl:variable>
			    <xsl:variable name="chg_term"><xsl:value-of select="chg_term"/></xsl:variable>
			    <xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
			    <xsl:variable name="branddata"><xsl:value-of select="branddata"/></xsl:variable>
			    <xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			    <xsl:variable name="editFlag"><xsl:value-of select="@editFlag"/></xsl:variable>
			    <xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
			    <xsl:variable name="sc_code"><xsl:value-of select="sc_code"/></xsl:variable>
			    <xsl:variable name="doctor_name"><xsl:value-of select="doctor_name"/></xsl:variable>
			    <xsl:variable name="locality"><xsl:value-of select="locality"/></xsl:variable>
			    <xsl:variable name="speciality"><xsl:value-of select="speciality"/></xsl:variable>
			    <xsl:variable name="category"><xsl:value-of select="category"/></xsl:variable>
			    
			    <xsl:variable name="curr_horz_total"><xsl:value-of select="curr_horz_total"/></xsl:variable>
				<xsl:variable name="base_value_horz_tot"><xsl:value-of select="base_value_horz_tot"/></xsl:variable>
				<xsl:variable name="brand_base_loc_val"><xsl:value-of select="brand_base_loc_val"/></xsl:variable>
			

			    <xsl:choose>
			    <xsl:when test="$editFlag ='E'">
			    <tr class="tdClass" style="text-align:center">
				<!--<td>
				<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;"  />
				</td>-->
				<td align="left"  style="width : 10%;line-height : 15px;padding : 3px;border-left: 1px solid #ddd;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;"  />
<!-- 					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;"  /> -->
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.sc_code" id="Detail2.{normalize-space($dbID)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					<xsl:value-of select="sc_code"/>
				</td>
	
				<td align="left"  style="width : 15%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.doctor_name" id="Detail2.{normalize-space($dbID)}.doctor_name" style="width : 100%" value="{$doctor_name}"  ISCHANGED="false"/>
					<xsl:value-of select="doctor_name"/>
				</td>

				<td align="left"  style="width : 9.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.locality" id="Detail2.{normalize-space($dbID)}.locality" style="width : 100%" value="{$locality}"  ISCHANGED="false"/>
					<xsl:value-of select="locality"/>
				</td>

				<td align="left" style="width : 9.8%;border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.speciality" id="Detail2.{normalize-space($dbID)}.speciality" style="width : 100%" value="{$speciality}"  ISCHANGED="false"/>
					<xsl:value-of select="speciality"/>
				</td>

				<td align="left" style="width : 4%;border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" style="width : 100%" value="{$category}"  ISCHANGED="false"/>
					<xsl:value-of select="category"/>
				</td>
				<!-- <td align="left" style="border-top: 0px;line-height : 15px;border-bottom: 1px solid #ddd;" class="td_leftAlign"> -->
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" class="input_editable" style="text-align: right;width:100%" size="5px"   ISCHANGED="false"/> -->
					 <xsl:if test=" $brand_base_loc_val= 'N' ">
						<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" class="input_editable" readonly="readonly" maxlength="6" value="" style="text-align: right;width:100%;background-color:#f5f5f5" /> -->
						<!-- <input  type="hidden"  name="" id="" class="input_editable" value ="{$base_value_horz_tot}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5"/> -->
						<p style="line-height:1;color:#000;font-weight:500;">Base</p>
					</xsl:if> 
				<!-- 	<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable" maxlength="6" value="{$curr_horz_total}"   style="text-align: right;width:100%" /> -->
					<!-- <input  type="hidden"  name="" id="" class="input_editable"  value="{$curr_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;" /> -->
					<p style="line-height:1;color:#000;font-weight:500;">Current</p>
				</td>
				
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" class="input_editable" style="text-align: right;width:100%" size="5px"   ISCHANGED="false"/> -->
					 <xsl:if test=" $brand_base_loc_val= 'N' ">
						<!-- <input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" class="input_editable" readonly="readonly" maxlength="6" value="" style="text-align: right;width:100%;background-color:#f5f5f5" /> -->
						<input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" class="input_editable" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5"/>
					</xsl:if> 
				<!-- 	<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable" maxlength="6" value="{$curr_horz_total}"   style="text-align: right;width:100%" /> -->
					<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable"  value="{$curr_horz_total}" ISCHANGED="false" readonly="readonly" maxlength="6" style="text-align: right;width:100%;" /> 
				</td>
				
				  <xsl:for-each select="//BRAND_DESC2">
				  
				      <xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
				      <xsl:variable name="brand_code"><xsl:value-of select="brand_code"/></xsl:variable>
				      <xsl:variable name="brand_descr"><xsl:value-of select="brand_descr"/></xsl:variable>
				      <xsl:variable name="target_nos"><xsl:value-of select="target_nos"/></xsl:variable>
				      <xsl:variable name="dbID1"><xsl:value-of select="@domID1"/></xsl:variable>
				      <xsl:variable name="sc_code1"><xsl:value-of select="sc_code"/></xsl:variable>
				      <xsl:variable name="pitch_priority"><xsl:value-of select="pitch_priority"/></xsl:variable>
				      
				      <xsl:variable name="base_values"><xsl:value-of select="base_values"/></xsl:variable>
				      
				      <xsl:if test=" $sc_code = $sc_code1 ">
				      <td class="td_leftAlign" style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;">
				      
		    <!-- 		    <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.brand_code" id="Detail2.{normalize-space($dbID)}.brand_code" style="width : 100%" value="{$brand_code}"  ISCHANGED="false"/> -->
					    <input  type="hidden"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.brand_code" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.brand_code" style="width : 100%" value="{$brand_code}"  ISCHANGED="false"/>
					     <input  type="hidden"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" style="width : 100%" value="{$pitch_priority}"  ISCHANGED="false"/>
<!-- 					    <input  type="hidden"  name="branddata" id="branddata" style="width : 100%" value=""  ISCHANGED="false"/> -->
					   <!--  <input  type="number"    name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable" onkeyup="this.value=this.value.replace(/[^\d]/,'')"  ISCHANGED="false" maxlength="6" style="text-align: right;width:100%;"/> -->
					   <xsl:if test=" $brand_base_loc_val= 'N' ">
					    	<input  type="text"    name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_values" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_values" value="{$base_values}"   readonly="readonly" class="input_editable" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5"/>
					    </xsl:if>
					    <input  type="text"    name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos"  value="{$target_nos}" class="input_editable"  onblur="calculateTotal(this);" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:100%;"/>
				     
				      </td>
 				     </xsl:if> 
				  </xsl:for-each>
				
				   <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.branddata" id="Detail2.{normalize-space($dbID)}.branddata" style="width : 100%;" value=""  ISCHANGED="false"/>

			    </tr>
			    </xsl:when>	
			    <xsl:otherwise>
			    
			     <tr class="tdClass">
				<!--<td>
				<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;" />
				</td>-->
				<td   align="left"  style="width : 10%;line-height : 15px;padding : 3px;border-left: 1px solid #ddd;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" style="display:none;" />
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.sc_code" id="Detail2.{normalize-space($dbID)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					<xsl:value-of select="sc_code"/>
				</td>
	
				<td align="left"  style="width : 15%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.doctor_name" id="Detail2.{normalize-space($dbID)}.doctor_name" style="width : 100%" value="{$doctor_name}"  ISCHANGED="false"/>
					<xsl:value-of select="doctor_name"/>
				</td>

				<td align="left"  style="width : 9.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.locality" id="Detail2.{normalize-space($dbID)}.locality" style="width : 100%" value="{$locality}"  ISCHANGED="false"/>
					<xsl:value-of select="locality"/>
				</td>

				<td align="left"  style="width : 9.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.speciality" id="Detail2.{normalize-space($dbID)}.speciality" style="width : 100%" value="{$speciality}"  ISCHANGED="false"/>
					<xsl:value-of select="speciality"/>
				</td>

				<td align="left"  style="width : 4%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.category" id="Detail2.{normalize-space($dbID)}.category" style="width : 100%" value="{$category}"  ISCHANGED="false"/>
					<xsl:value-of select="category"/>
				</td>
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					 <xsl:if test=" $brand_base_loc_val= 'N' ">
						<!-- <input  type="hidden"  name="" id="" readonly="readonly" class="input_editable" maxlength="6" value="Base" style="text-align: right;width:100%;background-color:#f5f5f5" ISCHANGED="false" size="5px"  /> -->
					<p style="line-height:1;color:#000;font-weight:500;">Base</p>	
					</xsl:if> 
					<!-- <input  type="hidden"  name="" id="" class="input_editable" maxlength="6" value="Current" readonly="readonly" style="text-align: right;width:100%" ISCHANGED="false" size="5px"  /> -->
					<p style="line-height:1;color:#000;font-weight:500;">Current</p>  
				</td> 
				
				<td align="left" style="width : 4.8%;line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;" class="td_leftAlign">
					 <xsl:if test=" $brand_base_loc_val= 'N' ">
						<input  type="number"  name="Detail2.{normalize-space($dbID)}.base_value_horz_tot" id="Detail2.{normalize-space($dbID)}.base_value_horz_tot" readonly="readonly" class="input_editable" maxlength="6" value="{$base_value_horz_tot}" style="text-align: right;width:100%;background-color:#f5f5f5" ISCHANGED="false" size="5px"  />
					</xsl:if> 
					<input  type="number"  name="Detail2.{normalize-space($dbID)}.curr_horz_total" id="Detail2.{normalize-space($dbID)}.curr_horz_total" class="input_editable" maxlength="6" value="{$curr_horz_total}" readonly="readonly" style="text-align: right;width:100%" ISCHANGED="false" size="5px"  /> 
				</td> 
				  <xsl:for-each select="//BRAND_DESC2">
				  
				      <xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
				      <xsl:variable name="brand_code"><xsl:value-of select="brand_code"/></xsl:variable>
				      <xsl:variable name="brand_descr"><xsl:value-of select="brand_descr"/></xsl:variable>
				      <xsl:variable name="target_nos"><xsl:value-of select="target_nos"/></xsl:variable>
				      <xsl:variable name="dbID1"><xsl:value-of select="@domID1"/></xsl:variable>
				      <xsl:variable name="sc_code1"><xsl:value-of select="sc_code"/></xsl:variable>
				      <xsl:variable name="pitch_priority"><xsl:value-of select="pitch_priority"/></xsl:variable>
				    
				    <xsl:variable name="base_values"><xsl:value-of select="base_values"/></xsl:variable>
				    <xsl:if test=" $sc_code = $sc_code1 ">
				      <td class="td_leftAlign" style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;">
				      
		    <!-- 		    <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.brand_code" id="Detail2.{normalize-space($dbID)}.brand_code" style="width : 100%" value="{$brand_code}"  ISCHANGED="false"/> -->
					    <input  type="hidden"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.sc_code" style="width : 100%" value="{$sc_code}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.brand_code" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.brand_code" style="width : 100%" value="{$brand_code}"  ISCHANGED="false"/>
					    <input  type="hidden"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.pitch_priority" style="width : 100%" value="{$pitch_priority}"  ISCHANGED="false"/>
<!-- 					    <input  type="hidden"  name="branddata" id="branddata" style="width : 100%" value=""  ISCHANGED="false"/> -->
					   <!--  <input  type="number"    name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" class="input_editable" value="{$target_nos}" onkeyup="this.value=this.value.replace(/[^\d]/,'')" maxlength="6"  style="text-align: right;width:100%" size="5px"  ISCHANGED="false"/>
				      </td> -->
				      <xsl:if test=" $brand_base_loc_val= 'N' ">
							<input  type="text"    name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_values" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_values"  value="{$base_values}" readonly="readonly" class="input_editable" onkeyup="javascript:return numbersonly(this, event,value)"  ISCHANGED="false" maxlength="6" style="text-align: right;width:100%;background-color:#f5f5f5"/>
						</xsl:if>
					    <input  type="text"    name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.target_nos" class="input_editable" value="{$target_nos}"  onblur="calculateTotal(this);" onkeyup="javascript:return numbersonly(this, event,value)" maxlength="6"  style="text-align: right;width:100%" size="5px"  ISCHANGED="false"/>
				      </td>
 				      </xsl:if>
 				     
				  </xsl:for-each>
				
				   <input  type="hidden"  name="Detail2.{normalize-space($dbID)}.branddata" id="Detail2.{normalize-space($dbID)}.branddata" style="width : 100%;" value=""  ISCHANGED="false"/>

			    </tr>
			    </xsl:otherwise>
			    </xsl:choose>
						
			</xsl:for-each>
			</tbody>
			      <input  type="hidden"  name="Detail2.1.is_confirm" id="Detail2.1.is_confirm" style="width : 100%" value=""  ISCHANGED="false"/>
		</table>
		<div id="footer" style="left:0px;position: relative;" onscroll="scrollDataDiv( this )">
		 <table id ="verTotalTable" class="mt" style="margin-left: 5px;border-left:1px solid #ccc;border-right:1px solid #ccc;border-bottom:1px solid #ccc; " border="0" >
			<tfoot>
				<tr >
					<!-- <td style="width:20.3%;background:#fff;text-align: center;border-right:1px solid #ccc;color:black;">Total</td> -->
					<td  align="left"  style="line-height : 15px;padding : 3px;border-left: 1px solid #ddd;border-top: 0px;border-bottom: 1px solid #ddd; background:#fff; font-weight: bold; text-color:black" class="td_leftAlign"> 
						<div id="totfoot" align="center" style="color:#000;" >Total 
						</div> 
					</td>  
					<xsl:for-each select="//Detail2">
						<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
						<xsl:variable name="brand_base_loc_val"><xsl:value-of select="brand_base_loc_val"/></xsl:variable>
						 <xsl:if test="position() = 1">
								<td align="left" style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;background:#fff;" class="td_leftAlign">
									 <xsl:if test=" $brand_base_loc_val= 'N' ">
							 			<input  type="number"  name="base_value_tot_ver" id="base_value_tot_ver" class="input_editable"  readonly="readonly" maxlength="6"  style="text-align: right;width:100%;background-color:#f5f5f5" size="5px"  />
									</xsl:if> 	
									<input  type="number"  name="curr_vert_total" id="curr_vert_total" class="input_editable" maxlength="6" readonly="readonly" style="text-align: right;width:100%;background-color:#f5f5f5" size="5px"  />
								</td>
						  </xsl:if>
						<xsl:variable name="i" select="position()" />
							<xsl:for-each select="//BRAND_DESC2">
								<xsl:variable name="editFlag"><xsl:value-of select="@editFlag"/></xsl:variable>
								<xsl:variable name="parentDbID"><xsl:value-of select="@parentDomID"/></xsl:variable>
								<xsl:variable name="brand_code"><xsl:value-of select="brand_code"/></xsl:variable>
								<xsl:variable name="brand_descr"><xsl:value-of select="brand_descr"/></xsl:variable>
								<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
								<xsl:variable name="curr_vert_total"><xsl:value-of select="curr_vert_total"/></xsl:variable>
								
								    <xsl:if test=" $parentDbID = 1 and $dbID = 1 ">
									<!-- <td class="td_leftAlign" style="background:#fff;border-right:1px solid #ccc;padding: 3px 2px 3px 2px;"> -->
									<td  style="line-height : 15px;padding : 3px;border-top: 0px;border-bottom: 1px solid #ddd;background:#fff;" class="td_leftAlign">
										 <xsl:if test=" $brand_base_loc_val= 'N' ">
											<input  type="number"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_value_tot_ver" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.base_value_tot_ver" class="input_editable" maxlength="6"  readonly="readonly" style="text-align: right;width:100%;background-color:#f5f5f5" size="5px"  />
										</xsl:if> 
											<input  type="number"  name="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.curr_vert_total"  readonly="readonly" id="BRAND_DESC2.{normalize-space($dbID)}.{normalize-space($line_no)}.curr_vert_total" class="input_editable" maxlength="6"  style="text-align: right;width:100%;" size="5px"  />
									</td>
								    </xsl:if>
						   </xsl:for-each>
					</xsl:for-each>
			</tr>
		</tfoot>
	</table> 
</div>
		 <!-- <div id="pageNavPosition" style="padding-top: 5px" align="right"></div> -->
		 <div id="pageNavPosition" style="width: 50%;float:right;margin-top: 10px;margin-bottom: 0px;height: 36px;" align="right"></div>

	<!--</div>-->
<!--	<div id="repeatPlacesDiv" style="margin-left:0px" class="tableLocDivClass"></div>-->

	<!-- <div style="width=50%;margin-left=-12px;margin-top:10px;margin-bottom:0px;" > -->
	<div style="width=50%;margin-left=-12px;margin-top:8px;margin-bottom:0px;" >
	<table>
		<tr>
		    <td>
			<input  type="hidden"  value="2" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="strg_brand_act" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />

			
			<input type="submit" style="cursor:hand" value="Cancel" name="Cancel" id="Cancel" class="button" title='' onclick="javascript:setActionVal('previous')"/>
				
			<input type="submit" style="cursor:hand" value="Save" name ="Finish" id="Finish" class="button" title='' onclick="javascript:setActionVal('finish'),dissableFld();"/> 
			<input type="button" style="cursor:hand" value="Confirm" id="Confirm" class="button" title='' onclick="javascript:checkConfirm('finish');disableButtonConfirm();"/>   
<!-- 			<input type="button" style="cursor:hand" value="Finish" id="Finish" class="button" title=''  onclick="javascript:validatebrand();"/>   -->
			
		    </td>
         </tr>
	</table>
	</div>


					
</form>
</body>
<script type="text/javascript">
	var pager = new Pager('brandTable', 10);
	pager.init();
	pager.showPageNav('pager', 'pageNavPosition');
	pager.showPage(1);
</script>
</html>
</xsl:template>
</xsl:stylesheet>