<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body >

<script type="text/javascript" src="/ibase/webitm/js/ITMWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/ITMWizardCalendar.js"></script>


<script>
var calendertop = 100;
var calenderleft = 200;
var selectedObj = null;
var global_date_format ="dd/MM/yy";
var global_date_type= "date";

function assignDate( date )
{	
	document.getElementById( selectedObj ).value = date;
	document.getElementById( selectedObj ).focus();
}
</script>

<style type="text/css">
<!-- 
.tableClass
{margin-left:10px;margin-top:20px}

.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:11pt;text-align:center}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt} -->
.editDisplayColumnClass 
{
readOnly:true; margin-left:2px; BACKGROUND:#fff; TEXT-ALIGN:LEFT; margin-bottom:10px; border-bottom:solid 1px #ebebeb; border-right:solid 1px #ebebeb; border-left:solid 1px #ebebeb;
}

.td_rightAlign
{
	background-color: #FFF;
    <!-- font-family: verdana; -->
    font-family: "MuseoLight-300",sans-serif;
    font-size: 14px;
    text-shadow: none;    
    text-align:right;
}


</style>

<form name = "doctor_deact_arg" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<!-- <table id="activityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1"> -->
	<table id="activityTable" class="editDisplayColumnClass" border="0" cellSpacing="2" cellPadding="1" align="left" style="width: 100%;height:170px;">
		<tr>
			<td class="td_rightAlign" colspan="2" style = "text-align:left;border-bottom :#6cf 3px solid;color: #827F7F;padding-left:3px;">
				<strong>Doctor Deactivation </strong>
			</td>
		</tr>
		<xsl:for-each select="//Detail1">
			<xsl:variable name="deact_date"><xsl:value-of select="deact_date"/></xsl:variable>
			<xsl:variable name="sales_pers"><xsl:value-of select="sales_pers"/></xsl:variable>
			<xsl:variable name="sp_name"><xsl:value-of select="sp_name"/></xsl:variable>
			<xsl:variable name="login_code"><xsl:value-of select="login_code"/></xsl:variable>
			<xsl:variable name="chg_date"><xsl:value-of select="chg_date"/></xsl:variable>
			<xsl:variable name="chg_user"><xsl:value-of select="chg_user"/></xsl:variable>
			<xsl:variable name="chg_term"><xsl:value-of select="chg_term"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>

			<input type="hidden" name="Detail1.{normalize-space($dbID)}.login_code" id = "Detail1.{normalize-space($dbID)}.login_code" value="{$login_code}" ISCHANGED="false"/>
			
			<tr>
				<!-- <td class="td_leftAlign" nowrap="true"> -->
				<td class="td_rightAlign" nowrap="true" style="color: #827F7F;">
					<strong>Deactivation Date :</strong>
				</td>
				<td class="td_leftAlign">
					<input type="text" class="input_editable" size="15" value="{$deact_date}" name="Detail1.{normalize-space($dbID)}.deact_date" id="Detail1.{normalize-space($dbID)}.deact_date" maxlength="8" ISCHANGED="false"/><xsl:text> </xsl:text>
					<!-- <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" onClick="selectedObj = 'Detail1.{normalize-space($dbID)}.deact_date'; javascript:show_calendar('Detail1.{normalize-space($dbID)}.deact_date','','','DD/MM/YY');"/> -->
					<img src="/ibase/webitm/images/calender.png" onClick="selectedObj = 'Detail1.{normalize-space($dbID)}.deact_date'; javascript:show_calendar('Detail1.{normalize-space($dbID)}.deact_date','','','DD/MM/YY');" name="Date1" alt="Calendar"   title="Click to see calender" style="cursor:hand;vertical-align: middle;"/>
				</td>
			</tr>

			<tr>
				<!-- <td class="td_leftAlign" nowrap="true"> -->
				<td class="td_rightAlign" nowrap="true" style="color: #827F7F;">
					<strong>Sales Person :</strong>
				</td>
				<td class="td_leftAlign">
					
					<input type="text" name="Detail1.{normalize-space($dbID)}.sales_pers" id = "Detail1.{normalize-space($dbID)}.sales_pers" value="{sales_pers}" size="15" class="input_editable" maxlength="0" ISCHANGED="false" readOnly = "1"/><xsl:text> </xsl:text>
					
					<a href="javascript:callSalesPersListJSP( '{normalize-space($dbID)}','{normalize-space($login_code)}' );"> <img src="/ibase/webitm/images/pophelp.png" border="0"/> </a><xsl:text> </xsl:text>
					<input type="text" name="Detail1.{normalize-space($dbID)}.sp_name" id = "Detail1.{normalize-space($dbID)}.sp_name" value="{sp_name}" size="35" class="input_editable" maxlength="0" ISCHANGED="false" readOnly = "1"/>

					<!-- <a href="javascript:callSalesPersListJSP( '{normalize-space($dbID)}','{normalize-space($login_code)}' );"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" border="0"/> </a> -->

					<input type="hidden" name="Detail1.{normalize-space($dbID)}.chg_date" id = "Detail1.{normalize-space($dbID)}.chg_date" value="{$chg_date}" ISCHANGED="false"/>
					<input type="hidden" name="Detail1.{normalize-space($dbID)}.chg_user" id = "Detail1.{normalize-space($dbID)}.chg_user" value="{$chg_user}" ISCHANGED="false"/>
					<input type="hidden" name="Detail1.{normalize-space($dbID)}.chg_term" id = "Detail1.{normalize-space($dbID)}.chg_term" value="{$chg_term}" ISCHANGED="false"/>
				</td>
			</tr>

		</xsl:for-each>
		<tr>
		<td colspan="2">
			<input  type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="doctor_deact" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />

			<input type="submit" style="cursor:hand"  value="Next" title='' onclick="javascript:setActionVal('next')"/>
		</td>
               </tr>
	</table>
	<table id="errorActivityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1">
			
			<xsl:for-each select="//error">
				<xsl:if test="position() = 1">
					<tr>	
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Description :
						</td>
					</tr>
				</xsl:if>
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<tr>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="message"/>
					</td>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
				</tr>
			</xsl:for-each>
			<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
					<tr>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Override Warnings :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							<input  type="checkbox"  name="forceSave"  value="false" onClick="setChecked(this)"/>
						</td>
					</tr>
					</xsl:if>
				</xsl:if>	
			</xsl:for-each>
			
	</table>
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>