<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: black;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:black;}
					p {font-size: 12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>

			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:black;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {
					<!-- padding-left:8%; -->
					padding:10px;
					}
					.firstData
					{
						color:black;
						width:50%;
					}
					@media only screen and (min-width: 100px) and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0">
					<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">

							<!-- <table id="travelTable" class="tTitleD" border="0" cellspacing="1"
								cellpadding="1" width="100%"> -->

							<div class="headerTableDCR headerTableDCR1">
								<table id="travelTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%">
									<xsl:for-each select="//Detail1">
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Transaction Date : </span>
											</td>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: left;">
													<xsl:value-of select="tran_date" />
												</span>
											</td>
										</tr>

										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Sales Person: </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="sp_name" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Strategic Customer: </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="strg_name" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Effective From: </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="eff_from" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Valid Upto: </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="valid_upto" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Workflow Status: </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:variable name="wf_status">
														<xsl:value-of select="wf_status" />
													</xsl:variable>
													<xsl:if test="normalize-space($wf_status) = 'D' ">
															Draft
													</xsl:if>
													<xsl:if test="normalize-space($wf_status) = 'S' ">
															Submit
													</xsl:if>
													<!-- <xsl:value-of select="wf_status" /> -->
												</span>

											</td>
										</tr>
										<tr>
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">Approval Status: </span>
											</td>
											<td class="firstData">

												<span class="" style='text-transform:capitalize;float: left;'>
												
												<xsl:variable name="ho_approval">
													<xsl:value-of select="ho_approval" />
												</xsl:variable>
												
												<xsl:variable name="aprv_stat">
													<xsl:value-of select="aprv_stat" />
												</xsl:variable>
												
												<xsl:choose>
														<xsl:when test="$ho_approval = 'Y'">
														Approved
														</xsl:when>
														
														<xsl:otherwise>
														
															<xsl:if test="normalize-space($aprv_stat) = 'A' ">
																	Approved
															</xsl:if>
															<xsl:if test="normalize-space($aprv_stat) = 'R' ">
																	Rejected
															</xsl:if>
															<xsl:if test="normalize-space($aprv_stat) = 'P' ">
																	Pending
															</xsl:if>	
															
														</xsl:otherwise>
												</xsl:choose>
												
																
													<!-- <xsl:value-of select="aprv_stat" />-->
												</span>

											</td>
										</tr>
									</xsl:for-each>

								</table>
							</div>
<xsl:variable name="activity_type"><xsl:for-each select="//Detail1"><xsl:value-of select="activity_type" /></xsl:for-each></xsl:variable>
<xsl:if test="normalize-space($activity_type) = 'FW'">
<input type="button" id="button" value="-" onClick="expandAllDetails(this.id)" style="background-color: white;text-align:right;width:inherit;border:none;"/>
</xsl:if>


<!-- Detail2(start) -->
<xsl:variable name="detail2_listed_count">
<xsl:for-each select="//Detail2"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail2)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail2_listed_count) > '0'">
<xsl:variable name="detail2_form" ><xsl:for-each  select="//Detail2" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each></xsl:variable>
<xsl:variable name = "detail2_form_name"><xsl:value-of select="substring-before($detail2_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail2_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail2(end) -->
							<div width="40%" id="attachmentUpload" class="attachmentUpload"
								style="display: none;">
								<table width="100%" height="100%">
									<tr height="10%" width="100%">
										<td>
											<div class="close" onclick="closeMe('attachmentUpload');">x</div>
											<div width="100%">
												<div
													style="width:100%;float:right;border-bottom: #e5e4e9 1px solid;PADDING-BOTTOM: 5PX;">
													<input type="button" class="buttonZoomIN" style="float:right;"
														value="+" id="zoomInBtn" onclick="zoomImage('+')" />
													<input type="button" class="buttonZoomOUT" style="float:right;"
														value="(-)" id="zoomOutBtn" onclick="zoomImage('-')" />
												</div>
											</div>
										</td>
									</tr>

									<tr height="89%" width="100%">
										<td>
											<div id="uploadContent"
												style="height: 100%; width: 100%; overflow:auto;background:white; margin:0 auto;">
												<img id="targetImg" style="max-height: 100%; max-width:100%;"
													src="" setMinSize="false" setSize="false" oHeight=""
													oWidth=""></img>
											</div>
										</td>
									</tr>
									<tr height="1%" width="100%">
										<td>

										</td>
									</tr>
								</table>
							</div>

							<div id="overlay"></div>

						</div>
					</div>

				</form>
			</body>

		</html>
	</xsl:template>

	<xsl:template name="tmpSplitString">
				<xsl:param name="stringtosplit" />
 				<xsl:variable name = "value"><xsl:value-of select="$stringtosplit" /></xsl:variable>
	    		<xsl:variable name = "form_no"><xsl:value-of select="substring-after($value,'(')"/></xsl:variable>
				<xsl:variable name = "form_name"><xsl:value-of select="substring-before($value,'(')"/></xsl:variable>
				<xsl:variable name = "detail"><xsl:value-of select="concat('Detail',$form_no)"/></xsl:variable>

 					 				<xsl:if test="normalize-space($form_no) = '2'">
 					 				<details open="true">
									<summary class="summary">Brand</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<TH CLASS="cellttlblck heading">Brand </TH>
												<TH CLASS="cellttlblck heading">Target Quantity</TH>
												<TH CLASS="cellttlblck heading">Remarks</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="brand_description">
													<xsl:value-of select="brand_description" />
												</xsl:variable>
												<xsl:variable name="target_qty">
													<xsl:value-of select="target_qty" />
												</xsl:variable>
												<xsl:variable name="remarks">
													<xsl:value-of select="remarks" />
												</xsl:variable>
												<TR>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$brand_description" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$target_qty" />
													</TD>
													<TD CLASS="tdCenter title">
														<xsl:value-of select="$remarks" />
													</TD>
												</TR>
											</xsl:if>

										</xsl:for-each>
									</TABLE>
								</details>
 					 				</xsl:if>
 					 		</xsl:template>
</xsl:stylesheet>
