<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background: #fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px; font-weight:
					normal; margin: -1%; padding: 8px; position: relative; border:0
					none; outline:none; }
					summary:hover, details[open] summary {background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-"; /*margin-top: -4px;*/
					margin-left:-5px;color:white;}
					p {font-size: 12px; margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family: Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius: 12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>

			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    
    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width: 100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width: 100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height: 28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 100;
					font-size: 13px;
					color:
					#787878;
					padding-top: 7px;

					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.firstData
					{
						color:black;
					}
					.headerTableDCR {
					padding-left:8%;
					}
					@media only screen and (min-width: 100px) and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0">
					<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX;width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">

							<!-- <table id="travelTable" class="tTitleD" border="0" cellspacing="1" 
								cellpadding="1" width="100%"> -->

							<div class="headerTableDCR headerTableDCR1">

								<table id="travelTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%">
									<xsl:for-each select="//Detail1">
										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">DCR Date :</span>
											</td>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: left;">
													<xsl:value-of select="event_date" />
												</span>
											</td>
										</tr>

										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Activity :</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class="" style='text-transform:capitalize; float: left;'>
													<xsl:value-of select="activity_descr" />
												</span>

											</td>
										</tr>

										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Sales Persons:</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="sales_pers_sp_name" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Last DCR Date:</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="last_dcr_date" />
												</span>

											</td>
										</tr>
										<tr>
											<td class="cellttl1 firstData" width="auto">
												<span CLASS="" style="width:auto;float: right;">Last Place of Work:</span>
											</td>
											<td class="cellttl1 firstData" width="auto">

												<span class="" style='text-transform:capitalize;float: left;'>
													<xsl:value-of select="sprs_route_descr" />
												</span>

											</td>
										</tr>
									</xsl:for-each>

								</table>
							</div>
<xsl:variable name="activity_type"><xsl:for-each select="//Detail1"><xsl:value-of select="activity_type" /></xsl:for-each></xsl:variable>
<xsl:if test="normalize-space($activity_type) = 'FW'">
<input type="button" id="button" value="-" onClick="expandAllDetails(this.id)" style="background-color: white;text-align:right;width:inherit;border:none;"/>
</xsl:if>

<!-- Detail2(start) -->	
<xsl:variable name="detail2_listed_count">
<xsl:for-each select="//Detail2"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail2)" /></xsl:if></xsl:for-each>
</xsl:variable> 
<xsl:if test="normalize-space($detail2_listed_count) > '0'">					
<xsl:variable name="detail2_form" ><xsl:for-each  select="//Detail2" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each></xsl:variable>
<xsl:variable name = "detail2_form_name"><xsl:value-of select="substring-before($detail2_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail2_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail2(end) -->	
<!-- Detail3(start) -->	
<xsl:variable name="detail3_listed_count">
<xsl:for-each select="//Detail3"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail3)" /></xsl:if></xsl:for-each>
</xsl:variable> 	
<xsl:if test="normalize-space($detail3_listed_count) > '0'">					
<xsl:variable name="detail3_form" >
<xsl:for-each  select="//Detail3" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail3_form_name"><xsl:value-of select="substring-before($detail3_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail3_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail3(end) -->	
<!-- Detail4(start) -->	
<xsl:variable name="detail4_listed_count">
<xsl:for-each select="//Detail4"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail4)" /></xsl:if></xsl:for-each>
</xsl:variable> 
<xsl:if test="normalize-space($detail4_listed_count) > '0'">					
<xsl:variable name="detail4_form" >
<xsl:for-each  select="//Detail4" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail4_form_name"><xsl:value-of select="substring-before($detail4_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail4_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail4(end) -->	
<!-- Detail5(start) -->	
<xsl:variable name="detail5_listed_count">
<xsl:for-each select="//Detail5"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail5)" /></xsl:if></xsl:for-each>
</xsl:variable> 
<xsl:if test="normalize-space($detail5_listed_count) > '0'">					
<xsl:variable name="detail5_form" >
<xsl:for-each  select="//Detail5" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail5_form_name"><xsl:value-of select="substring-before($detail5_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail5_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail5(end) -->	
<!-- Detail6(start) -->	
<xsl:variable name="detail6_listed_count">
<xsl:for-each select="//Detail6"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail6)" /></xsl:if></xsl:for-each>
</xsl:variable> 
<xsl:if test="normalize-space($detail6_listed_count) > '0'">					
<xsl:variable name="detail6_form" >
<xsl:for-each  select="//Detail6" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail6_form_name"><xsl:value-of select="substring-before($detail6_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail6_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail6(end) -->	
<!-- Detail7(start) -->	
<xsl:variable name="detail7_listed_count">
<xsl:for-each select="//Detail7"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail7)" /></xsl:if></xsl:for-each>
</xsl:variable>
<xsl:if test="normalize-space($detail7_listed_count) > '0'">					
<xsl:variable name="detail7_form" >
<xsl:for-each  select="//Detail7" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail7_form_name"><xsl:value-of select="substring-before($detail7_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail7_form_name" /></xsl:call-template>
</xsl:if>

<!-- Detail7(end) -->	
<!-- Detail8(start) -->	
<xsl:variable name="detail8_listed_count">
<xsl:for-each select="//Detail8"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail8)" /></xsl:if></xsl:for-each>
</xsl:variable> 
<xsl:if test="normalize-space($detail8_listed_count) > '0'">					
<xsl:variable name="detail8_form" >
<xsl:for-each  select="//Detail8" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail8_form_name"><xsl:value-of select="substring-before($detail8_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail8_form_name" /></xsl:call-template>
</xsl:if>

<!-- Detail8(end) -->	
<!-- Detail9(start) -->	
<xsl:variable name="detail9_listed_count">
<xsl:for-each select="//Detail9"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail9)" /></xsl:if></xsl:for-each>
</xsl:variable> 	
<xsl:if test="normalize-space($detail9_listed_count) > '0'">					
<xsl:variable name="detail9_form" >
<xsl:for-each  select="//Detail9" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail9_form_name"><xsl:value-of select="substring-before($detail9_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail9_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail9(end) -->	
<!-- Detail10(start) -->	
<xsl:variable name="detail10_listed_count">
<xsl:for-each select="//Detail10"><xsl:if test="attribute/@updateFlag!='D'"><xsl:value-of select="count(//Detail10)" /></xsl:if></xsl:for-each>
</xsl:variable> 	
<xsl:if test="normalize-space($detail10_listed_count) > '0'">					
<xsl:variable name="detail10_form" >
<xsl:for-each  select="//Detail10" ><xsl:value-of select="concat(@formName,'(',@objContext,',')"/></xsl:for-each>
</xsl:variable>
<xsl:variable name = "detail10_form_name"><xsl:value-of select="substring-before($detail10_form,',')"/></xsl:variable>
<xsl:call-template name="tmpSplitString"><xsl:with-param name="stringtosplit" select ="$detail10_form_name" /></xsl:call-template>
</xsl:if>
<!-- Detail10(end) -->





							<div width="40%" id="attachmentUpload" class="attachmentUpload"
								style="display: none;">
								<table width="100%" height="100%">
									<tr height="10%" width="100%">
										<td>
											<div class="close" onclick="closeMe('attachmentUpload');">x</div>
											<div width="100%">
												<div
													style="width:100%;float:right;border-bottom: #e5e4e9 1px solid;PADDING-BOTTOM: 5PX;">
													<input type="button" class="buttonZoomIN" style="float:right;"
														value="+" id="zoomInBtn" onclick="zoomImage('+')" />
													<input type="button" class="buttonZoomOUT" style="float:right;"
														value="(-)" id="zoomOutBtn" onclick="zoomImage('-')" />
												</div>
											</div>
										</td>
									</tr>

									<tr height="89%" width="100%">
										<td>
											<div id="uploadContent"
												style="height: 100%; width: 100%; overflow:auto;background:white; margin:0 auto;">
												<img id="targetImg" style="max-height: 100%; max-width:100%;"
													src="" setMinSize="false" setSize="false" oHeight=""
													oWidth=""></img>
											</div>
										</td>
									</tr>
									<tr height="1%" width="100%">
										<td>

										</td>
									</tr>
								</table>
							</div>

							<div id="overlay"></div>

						</div>
					</div>

				</form>
			</body>

		</html>
	</xsl:template>
	<xsl:template name="tmpSplitString">
				<xsl:param name="stringtosplit" />
 				<xsl:variable name = "value"><xsl:value-of select="$stringtosplit" /></xsl:variable>	
	    		<xsl:variable name = "form_no"><xsl:value-of select="substring-after($value,'(')"/></xsl:variable>
				<xsl:variable name = "form_name"><xsl:value-of select="substring-before($value,'(')"/></xsl:variable>
				<xsl:variable name = "detail"><xsl:value-of select="concat('Detail',$form_no)"/></xsl:variable>
				<xsl:if test="normalize-space($form_name) = 'salesperson'">
				<details>
									<summary class="summary">Sales Persons Details</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>

												<TH CLASS="cellttl1 cellttlblck heading">Sales Persons</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Joint Work</TH>

											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:variable name="sl_no">
												<xsl:value-of select="sl_no" />
											</xsl:variable>
											<xsl:variable name="sp_name">
												<xsl:value-of select="sp_name" />
											</xsl:variable>
											<xsl:variable name="joint_work">
												<xsl:value-of select="joint_work" />
											</xsl:variable>
											<xsl:variable name="sprs_code__ww">
												<xsl:value-of select="sprs_code__ww" />
											</xsl:variable>

											<TR>

												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:value-of select="$sp_name" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:if test="$joint_work = 'Y'">
														Yes
													</xsl:if>
													<xsl:if test="$joint_work = 'N'">
														No
													</xsl:if>
												</TD>
											</TR>
										</xsl:for-each>
									</TABLE>
								</details>
				</xsl:if>
				<xsl:if test="normalize-space($form_name) = 'place'">
				<details>
									<summary class="summary">Place Details</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>

												<TH CLASS="cellttl1 cellttlblck heading">Place of Work</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Order Of Visit</TH>

											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:variable name="sl_no">
												<xsl:value-of select="sl_no" />
											</xsl:variable>
											<xsl:variable name="sprs_route_descr">
												<xsl:value-of select="sprs_route_descr" />
											</xsl:variable>
											<xsl:variable name="travel_mode">
												<xsl:value-of select="travel_mode" />
											</xsl:variable>
											<xsl:variable name="order_of_visit">
												<xsl:value-of select="order_of_visit" />
											</xsl:variable>

											<TR>

												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:value-of select="$sprs_route_descr" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:value-of select="$order_of_visit" />
												</TD>
											</TR>


										</xsl:for-each>
									</TABLE>
								</details>
				</xsl:if>
				<xsl:if test="normalize-space($form_name) = 'doctor'">
				<details>
									<summary class="summary">Doctor's Call Details</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<!-- <TH CLASS= "cellttl1 cellttlblck" STYLE="PADDING: 12PX; 
													border-bottom: #e5e4e9 1px solid;">SN</TH> -->
												<TH CLASS="cellttl1 cellttlblck heading">Doctor </TH>
												<TH CLASS="cellttl1 cellttlblck heading">Locality</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Call Outcome</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:variable name="strg_code5">
												<xsl:value-of select="strg_code" />
											</xsl:variable>
											<xsl:variable name="cust_name">
												<xsl:value-of select="cust_name" />
											</xsl:variable>
											<xsl:variable name="locality_descr">
												<xsl:value-of select="locality_descr" />
											</xsl:variable>
											<xsl:variable name="call_outcome">
												<xsl:value-of select="call_outcome" />
											</xsl:variable>
											<xsl:variable name="calloutcome_descr">
												<xsl:value-of select="calloutcome_descr" />
											</xsl:variable>
											<xsl:variable name="domID">
												<xsl:value-of select="@domID" />
											</xsl:variable>

											<TR>
												<TD CLASS="cellttl1 tdCenter title">
													<xsl:value-of select="$cust_name" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title">
													<xsl:value-of select="$locality_descr" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title">
													<!-- <xsl:value-of select="$calloutcome_descr" /> -->
													<xsl:if test="normalize-space($call_outcome) = '5' ">
															Supporter
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '6' ">
															Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '7' ">
															Non Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '0' "> 
															Refused
													</xsl:if>
												</TD>
											</TR>

										</xsl:for-each>
									</TABLE>
								</details>
				</xsl:if>
				<xsl:if test="normalize-space($form_name) = 'retailer'">
					<details>
									<summary class="summary">Retailer's Call Details</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<!-- <TH CLASS= "cellttl1 cellttlblck" STYLE="PADDING: 12PX; 
													border-bottom: #e5e4e9 1px solid;">SN</TH> -->
												<TH CLASS="cellttl1 cellttlblck heading">Retailer</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Locality</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Call Outcome</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:variable name="strg_code5">
												<xsl:value-of select="strg_code" />
											</xsl:variable>
											<xsl:variable name="cust_name">
												<xsl:value-of select="cust_name" />
											</xsl:variable>
											<xsl:variable name="locality_descr">
												<xsl:value-of select="locality_descr" />
											</xsl:variable>
											<xsl:variable name="call_outcome">
												<xsl:value-of select="call_outcome" />
											</xsl:variable>
											<xsl:variable name="calloutcome_descr">
												<xsl:value-of select="calloutcome_descr" />
											</xsl:variable>
											<xsl:variable name="domID">
												<xsl:value-of select="@domID" />
											</xsl:variable>

											<TR>
												<TD CLASS="cellttl1 tdCenter title">
													<xsl:value-of select="$cust_name" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title">
													<xsl:value-of select="$locality_descr" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title">
													<!-- <xsl:value-of select="$calloutcome_descr" /> -->
													<xsl:if test="normalize-space($call_outcome) = '5' ">
															Supporter
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '6' ">
															Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '7' ">
															Non Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '0' "> 
															Refused
													</xsl:if>
												</TD>
											</TR>
										</xsl:for-each>
									</TABLE>
								</details>
				</xsl:if>
				<xsl:if test="normalize-space($form_name) = 'stockist'">
				<details>
									<summary class="summary">Stockist Call Details</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<!-- <TH CLASS= "cellttl1 cellttlblck" STYLE="PADDING: 12PX; 
													border-bottom: #e5e4e9 1px solid;">SN</TH> -->
												<TH CLASS="cellttl1 cellttlblck heading">Stockist</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Locality</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Call Outcome</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:variable name="strg_code5">
												<xsl:value-of select="strg_code" />
											</xsl:variable>
											<xsl:variable name="cust_name">
												<xsl:value-of select="cust_name" />
											</xsl:variable>
											<xsl:variable name="locality_descr">
												<xsl:value-of select="locality_descr" />
											</xsl:variable>
											<xsl:variable name="call_outcome">
												<xsl:value-of select="call_outcome" />
											</xsl:variable>
											<xsl:variable name="calloutcome_descr">
												<xsl:value-of select="calloutcome_descr" />
											</xsl:variable>
											<xsl:variable name="domID">
												<xsl:value-of select="@domID" />
											</xsl:variable>

											<TR>
												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:value-of select="$cust_name" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:value-of select="$locality_descr" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title ">
													<!-- <xsl:value-of select="$calloutcome_descr" /> -->
													<xsl:if test="normalize-space($call_outcome) = '5' ">
															Supporter
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '6' ">
															Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '7' ">
															Non Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '0' "> 
															Refused
													</xsl:if>
												</TD>
											</TR>

										</xsl:for-each>
									</TABLE>
								</details>
				</xsl:if>
				<xsl:if test="normalize-space($form_name) = 'ncw'">
				<details>
									<summary class="summary">Ncw Call Details</summary>
									<TABLE class="tTitleD" border="0" width="100%"
										style="width:100%; z-index:9999999999;  ">
										<thead class="" style="height : 30px;">
											<TR>
												<!-- <TH CLASS= "cellttl1 cellttlblck" STYLE="PADDING: 12PX; 
													border-bottom: #e5e4e9 1px solid;">SN</TH> -->
												<TH CLASS="cellttl1 cellttlblck heading">Ncw</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Locality</TH>
												<TH CLASS="cellttl1 cellttlblck heading">Call Outcome</TH>
											</TR>
										</thead>

										<xsl:for-each select="//node()[starts-with(name(), $detail)]">
											<xsl:variable name="strg_code5">
												<xsl:value-of select="strg_code" />
											</xsl:variable>
											<xsl:variable name="cust_name">
												<xsl:value-of select="cust_name" />
											</xsl:variable>
											<xsl:variable name="locality_descr">
												<xsl:value-of select="locality_descr" />
											</xsl:variable>
											<xsl:variable name="call_outcome">
												<xsl:value-of select="call_outcome" />
											</xsl:variable>
											<xsl:variable name="calloutcome_descr">
												<xsl:value-of select="calloutcome_descr" />
											</xsl:variable>
											<xsl:variable name="domID">
												<xsl:value-of select="@domID" />
											</xsl:variable>

											<TR>
												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:value-of select="$cust_name" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title ">
													<xsl:value-of select="$locality_descr" />
												</TD>
												<TD CLASS="cellttl1 tdCenter title ">
													<!-- <xsl:value-of select="$calloutcome_descr" /> -->
													<xsl:if test="normalize-space($call_outcome) = '5' ">
															Supporter
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '6' ">
															Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '7' ">
															Non Believer
													</xsl:if>
													<xsl:if test="normalize-space($call_outcome) = '0' "> 
															Refused
													</xsl:if>
												</TD>
											</TR>

										</xsl:for-each>
									</TABLE>
								</details>
				</xsl:if>
				
	</xsl:template>
</xsl:stylesheet>
