<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color: white;}
					p {font-size:
					12px; margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
				</style>

			</head>

			<script type="text/javascript"
				src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    
    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: initial;
					font-size: 14px;
					color:
					#666;
					padding-top: 7px;

					}
					.firstData
					{
					color:black;
					}
					.heading
					{
					font-weight: 500;
					font-size:
					12px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {
					padding-left:20%;
					}
					@media only screen and (min-width: 100px) and
					(max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}

					.travelTableCss {
					padding: 10px;
					color: #666;
					font-size: 14px;
					display: grid !important;
					grid-template-columns: 50% 50%;
					width: auto;
					grid-column-gap: 0.30em;
					grid-row-gap: 0.25em;
					}

					.travelTitle {
					width: auto;
					float: right;
					font-size: 14px;
					text-align: right;
					}

					.travelValue{
					width: auto;
					text-align: left;
					}

					.valueFieldCss{
					font-size: 14px;
					color: #666;
					}

					.plcDetailCss {
					display: grid !important;
					grid-template-columns: 50% 50%;
					grid-column-gap: 0.25em;
					grid-row-gap: 0.25em;
					width: 100%;
					}

					.custDetailCss{
					color: #666;
					width: 100%;
					font-size: 12px;
					display: grid !important;
					grid-template-columns: 35% 30% 30%;
					grid-column-gap: 0.75em;
					grid-row-gap: 0.75em;
					}

					.dataDivCss{
					height:100%;
					width:100%;
					overflow-x:hidden;
					overflow-y:auto;
					}

					.summaryborderPanel{
					display: block;
					border-top: #fff 1px solid;
					width: 98%;
					margin-top: 24px;
					}

				</style>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0">
					<div ID="dsrDiv" class="outerDiv"
						style="MARGIN-BOTTOM: 10PX;width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-x:hidden;overflow-y:auto;">

							<div style="padding: 10px;">

								<div id="travelTable" class="travelTableCss"
									style="display : flex">
									<xsl:for-each select="//Detail1">

										<div class="travelTitle">Plan Date :</div>

										<div class="travelValue">
											<xsl:value-of select="plan_date" />
										</div>

										<div class="travelTitle">Activity :</div>

										<div class="travelValue">
											<xsl:value-of select="fieldactivity_descr" />
										</div>


										<div class="travelTitle">Sales Person:</div>

										<div class="travelValue">
											<xsl:value-of select="sales_pers_sp_name" />
										</div>

									</xsl:for-each>

								</div>

							</div>
							<input type="button" id="button" value="-"
								onClick="expandAllDetails(this.id)"
								style="background-color: white;text-align:right;width:inherit;border:none;" />
							<xsl:variable name="place_listed_count">
								<xsl:value-of select="count(//Detail2)" />
							</xsl:variable>

							<xsl:if test="normalize-space($place_listed_count) > '0'">
								<details open="true" style="border-bottom: #ffff;">
									<summary class="summary">Place Details</summary>

									<div id="placeDetailId" class="plcDetailCss" border="0"
										width="100%">
										<div style="font-size: 12px;">Place of Work</div>
										<div style="font-size: 12px;">Order Of Visit</div>

										<xsl:for-each select="//Detail2">
											<xsl:sort order="ascending" select="order_of_visit" data-type="number"/>

											<xsl:if test="attribute/@updateFlag!='D'">
												<xsl:variable name="locality_descr">
													<xsl:value-of select="locality_descr" />
												</xsl:variable>
												<xsl:variable name="order_of_visit">
													<xsl:value-of select="order_of_visit" />
												</xsl:variable>

												<div CLASS="valueFieldCss">
													<xsl:value-of select="$locality_descr" />
												</div>
												<div CLASS="valueFieldCss">
													<xsl:value-of select="$order_of_visit" />
												</div>
											</xsl:if>
										</xsl:for-each>
									</div>
								</details>
							</xsl:if>

							<xsl:variable name="doctor_listed_count">
								<xsl:value-of select="count(//Detail3)" />
							</xsl:variable>

							<xsl:if test="normalize-space($doctor_listed_count) > '0'">

								<details open="true" style="border-bottom: #ffff;">
									<summary class="summary">Customer's Details</summary>
									<div class="custDetailCss">
										<div style="color: #000000;">Customer</div>
										<div style="color: #000000;">Place of Work</div>
										<div style="color: #000000;">Customer Type</div>
										<xsl:for-each select="//Detail2">
											<xsl:if test="attribute/@updateFlag!='D'">
											<xsl:variable name="place_locality_code">
												<xsl:value-of select="locality_code" />
											</xsl:variable>
											
										<xsl:for-each select="//Detail3">
										<xsl:if test="attribute/@updateFlag!='D'">
										<xsl:variable name="cust_locality_code">
												<xsl:value-of select="locality_code" />
											</xsl:variable>
								<xsl:if test="normalize-space($cust_locality_code) = normalize-space($place_locality_code)">
											<xsl:variable name="type_descr">
												<xsl:value-of select="type_descr" />
											</xsl:variable>
											<xsl:variable name="sc_name">
												<xsl:value-of select="sc_name" />
											</xsl:variable>
											<xsl:variable name="locality_descr">
												<xsl:value-of select="locality_descr" />
											</xsl:variable>
											<xsl:variable name="domID">
												<xsl:value-of select="@domID" />
											</xsl:variable>

											<div class="valueFieldCss">
												<xsl:value-of select="$sc_name" />
											</div>
											<div class="valueFieldCss">
												<xsl:value-of select="$locality_descr" />
											</div>
											<div class="valueFieldCss">
												<xsl:value-of select="$type_descr" />
											</div>
											</xsl:if>
										</xsl:if>
										</xsl:for-each>
											</xsl:if>
										</xsl:for-each>
									</div>
								</details>
							</xsl:if>

							<!-- <tr><td colspan="4" style="background-color: #EEEEEE;padding: 
								0px;">&#160;</td></tr> -->


							<div width="40%" id="attachmentUpload"
								class="attachmentUpload" style="display: none;">
								<div width="100%" height="100%">

									<div class="close" onclick="closeMe('attachmentUpload');">x</div>

									<div width="100%">
										<div
											style="width:100%;float:right;border-bottom: #e5e4e9 1px solid;PADDING-BOTTOM: 5PX;">
											<input type="button" class="buttonZoomIN"
												style="float:right;" value="+" id="zoomInBtn"
												onclick="zoomImage('+')" />
											<input type="button" class="buttonZoomOUT"
												style="float:right;" value="(-)" id="zoomOutBtn"
												onclick="zoomImage('-')" />
										</div>
									</div>

									<div id="uploadContent"
										style="height: 100%; width: 100%; overflow:auto;background:white; margin:0 auto;">
										<img id="targetImg"
											style="max-height: 100%; max-width:100%;" src=""
											setMinSize="false" setSize="false" oHeight="" oWidth=""></img>
									</div>

								</div>
							</div>

							<div id="overlay"></div>

						</div>
					</div>

				</form>
			</body>

		</html>
	</xsl:template>
</xsl:stylesheet>

