<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}
					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color: white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:white;}
					p {font-size:
					12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}
					.tdLeft
					{
					text-align: left;
					padding-left: 20px;
					}
					.tdRight
					{
					text-align: right;
					padding-right: 20px;
					}
					.normalFont
					{
					font-size:14px;
					color:black;
					}


				</style>

			</head>

			<script type="text/javascript"
				src="/ibase/webitm/js/ViewReport.js"></script>

			<script language="JavaScript" type="text/javascript">

<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>

			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: initial;
					font-size: 14px;
					color:
					#666;
					padding-top: 7px;

					}
					div.displayArea
					{
					width:100%;
					}

					.heading
					{
					font-weight: 500;
					font-size:
					14px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%
					}
					.headerTableDCR {
					padding-left:8%;
					}
					.firstData
					{
					color:black;
					}
					@media only screen and
					(min-width: 100px)
					and (max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}

					}
				</style>

				<style>
					.travelTableCss {
					padding: 10px;
					color: #666;
					font-size: 14px;
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					width: auto;
					grid-column-gap: 0.30em;
					grid-row-gap: 0.25em;
					}

					.travelTitle {
					width:
					auto;
					float: right;
					font-size: 14px;
					text-align: right;
					}

					.travelValue{
					width: auto;
					text-align: left;
					line-height: 1.2;
					}

					.valueFieldCss{
					font-size: 14px;
					color: #666;
					}

					.plcDetailCss {
					display: grid
					!important;
					grid-template-columns: 50% 50%;
					grid-column-gap: 0.25em;
					grid-row-gap: 0.25em;
					width: 100%;
					}

					.custDetailCss{
					color: #666;
					width: 100%;
					font-size: 12px;
					display: grid !important;
					grid-template-columns: 35% 30% 30%;
					grid-column-gap: 0.75em;
					grid-row-gap: 0.75em;
					}

					.dataDivCss{
					height:100%;
					width:100%;
					overflow-x:hidden;
					overflow-y:auto;
					}

					.summaryborderPanel{
					display:
					block;
					border-top: #fff 1px solid;
					width: 98%;
					margin-top: 24px;
					}
					.headerTablediv
					{
					background: #fff;
					box-shadow: 0px -1px 0px 0
					rgba(0,0,0,.1);
					}
					.headerTable1
					{
					text-align:center;
					padding-left:
					0;
					}

                    .mainbody{
                        background: #f5f5f5;
                        margin: auto;
                        max-width: 1024px;
                        width: calc(100% - 32px);
                        font-family: sans-serif !important;
                        font-weight: 500 !important;
                        margin-bottom: 0;
                    }

                    .containerfeed{
                        padding: 12px 0;
                        margin: 4px 0;
                        /*height: auto;*/
                        border-radius: 12px;
                        background-color: #fff;
                        overflow: hidden;
                    }


                    .headerdata{
                        display: flex;
                        align-items: center;
                        white-space: nowrap;
                        /* height: 36px; */
                        margin: 0;
                        font-size: 12px;
                        padding: 0 12px;
                        color: #000;
                        cursor: pointer;
                    } 

                    .doctorDiv{
                        width: 20%;
                        min-width: 200px;
                        text-align: left;
                    }
                    .localityDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .stateDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .qualificationDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .specialityDiv{
                        width: 15%;
                        min-width: 120px;
                        padding: 0 8px;
                        text-align: left;
                    }
                    .brandsDiv{
                        width: 20%;
                        min-width: 200px;
                        text-align: right;
                    }

                    .single-colDiv{
                        display: inline-flex;
                        align-items: center;
                        text-align: left;
                        justify-content: center;
                        margin: 0 auto;
                        padding: 0 16px;
                        width: 100%;
                        height: 100px;
                        min-height: 100px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                    }

                    .imgicon{
                        width: 80px;
                        height: 80px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    *{
                        margin:0;
                        padding:0;
                        box-sizing: border-box;
                    }
                .textcolor{
                    color:#969696 !Important;
                    font-weight: 500;
                }
                .prescription_btm_border {
                    margin: 4px 16px 0 40px;
                    border-bottom: 1px solid #eeeeee;
                }

                .text-rowgroup-2{
                    font-size: 14px;
                    font-weight: 600;
                    color: #000;
                    margin: 4px 0;
                    text-align: center;
                }
                .text-rowgroup-3{
                    font-size: 18px;
                    font-weight: 600;
                    text-align: center;
                    color: #000;
                }
                .activity-descr-text{
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .mainiconradius{
                    width: 30px;
                    height: 30px;
                    margin: 0 10px;
                }

                .stickysubforms{
                    position: relative;
                    display: contents;
                    -webkit-overflow-scrolling: touch;
                }
                .timeline::before {
                    content: '';
                    position: absolute;
                    height: 22px;
                    width: 1px;
                    background-color: #000;
                    left: 32px;
                    transform: translateY(-118%);
                    /*transform: translate(100%,-100%);*/
                }
                .timeline:first-child::before{
                    width: 0;
                }

                .customerDiv{
                    display: flex;
                    padding: 0 16px;
                    align-items: center;
                    margin-bottom: 16px;
                }

                .customerDiv:last-child{
                    margin-bottom: 0;
                }

                .outerIcon{
                    height: 24px;
                    width: 24px;
                    margin: 0 4px 0 0;
                }

                .large-font{
                    font-size: 14px;
                }
                .small-font{
                    font-size: 12px;
                }
                .row-div{
                    padding: 0 16px 0 40px;
                    display: flex;
                    align-items: center;
                    margin-bottom: 16px;
                }
                .prescription_det {
                    padding: 0 16px 0 40px;
                    display: flex;
                    align-items: center;
                }
                
                .hideoverflow{
                    overflow: hidden;
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 2;
                    display: -webkit-box;
                    -webkit-box-orient: vertical;
                    height: 35px;
                }

                .hideoverflowfeed{
                    overflow: hidden;
                    text-overflow: ellipsis;
                    -webkit-line-clamp: 1;
                    -webkit-box-orient: vertical;
                    height: 20px;
                    min-width: 50px;
                    line-height: 24px;
                }

                .datafontsize{
                    font-size:14px !Important;
                    color: #000;
                }
                .headerfontsize{
                    font-size:12px !Important;
                    color:#969696 !Important;
                }
                .bradius{
                    border-radius: 100px;
		    height: 30px;
                    width: 30px;
                }
		.brandImg{
                    border-radius: 100px;
                    width: 30px;
                }

                .collapsibleIconRadius{
                    border-radius: 100px;
                    height: 30px;
                    width: 30px;
                }

                .rightcol-spacing{
                    margin-inline-start: auto;
                    text-align: right;
                    font-size: 12px;
                    align-self: baseline;
                    white-space: nowrap;
                }

                .imgradius{
                    border-radius: 100px;
                    height: 80px;
                    width: 80px;
                }

                .main-icon{
                    display: block; 
                    text-align:center;
                    margin: 4px 0;
                }

                .align-imgtext{
                    float:left;
                    text-align:right;
                }
				
				.prescription_data{
                    float:left;
                    text-align:right;
					height: 36px;
                }

                .columnsDiv {
                    display: flex;
                    align-items: center;
                    width: 100%;
                    height: 52px;
                    min-height: 52px;
                    -webkit-column-break-inside: avoid;
                    -webkit-column-break-after: avoid;
                    /* border: 1px solid #e2e2e2; */
                    /* border-radius: 12px;*/
                }

                .btnborder{
                    height: 24px;
                    width: 24px;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    background-color: #f5f5f5;
                    border-radius: 28px;
                }

                .tab{
                    margin-inline-start: auto;
                    cursor: pointer;
                }
                .tablinks{
                    border:none;
                    outline:none;
                    background: none;
                }

                .tab button:active {
                    border: none;
                    outline: none;
                    box-shadow: none;
                }
               
                .left-spacing{
                    width: 60%;
                    padding: 0 8px 0 0;
                    min-width: 80px;
                    overflow: hidden;
                    text-align: left;
                    display: flex;
                    align-items: center;
                }

                .center-spacing{
                    width: 20%;
                    text-align: left;
                    padding: 0 8px 0;
                    min-width: 70px;
                    overflow: hidden;
                }
                .right-spacing{
                    text-align: right;
                    width: 20%;
                    padding: 0 0 0 8px;
                    min-width: 60px;
                    overflow: hidden;
                }

                .bgcolorform{
                    background-color: #f5f5f5;
                }
                .headingwidth{
                    border-bottom: 1px solid #0000001a;
                    white-space: nowrap;
                    display: flex;
                    align-items: flex-start;
                    height: 25px;
                    text-overflow: ellipsis;
                    overflow: hidden;
                    color: #666666 !important;
                    padding: 0 8px;
                }


                .detailswidth{
                    padding: 0 8px;
                    white-space: normal;
                    height: 38px;
                    display:grid;
                    align-items: center;
                    color: #000;
                }
                
                .seperatorDiv{
                    border-bottom: 1px solid #0000001a;
                }
                .firstcolumn{
                    text-align: left;
                    padding: 0 8px 0 0;
                    left: 0;
                }

                .lastcolumn{
                    justify-content: flex-end;
                    padding: 0 0 0 8px;
                }

                .containertable{
                    padding: 0 16px;
                    margin: 12px 0;
                    border-radius: 12px;
                    background:#fff;
                    overflow-x: hidden;
                }

                .doctorcontainer{
                    padding: 8px 0;
                    margin: 8px 0 8px 0;
                    border-radius: 12px;
                    background-color: #fff; 
                    overflow-x: auto;
                    overflow-y: hidden;
                }

                .doctordetails{
                    display: flex;
                    padding: 0px;
                    white-space: initial;
                    height: 25px;
                }
                .docdatadetails{
                    display: flex;
                    align-items: center;
                    padding: 0px;
                    height: 35px;
                    margin: 8px 0;
                }

                .sampleheading{
                    display:flex;
                    align-items:center;
                    padding: 8px 0;
                }

                .samplename{
                    display: flex;
                    align-items: center;
                    color: #666666;
                    padding: 0;
                    height: 25px;
                    border-bottom: 1px solid #0000001a;
                }

                .sampledata{
                    white-space: initial;
                    display: flex;
                    padding: 0;
                    margin: 8px 0;
                    height: 38px;
                    align-items: center;
                }

                .sampledetails{
                    background-color: #ededed;
                    padding: 16px;
                    /*width: 100%;*/
                    left: 0;
                    position: sticky;
                    position: -webkit-sticky;
                }

                .itemlabelDiv {
                    margin : 4px 16px 0 40px;
                    height: 16px;
                    text-align: left;
                }
                .itemOuterDiv{
                    margin-top: 16px;
                }

                .btniconborder{
                    height: 34px;
                    width: 34px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .feed_default_bg{
                    background-color: #0273d0;
                }

                .table_default_bg{
                    background-color: #e6f4ff;
                }

                .iconborder{
                    min-height: 30px;
                    min-width: 30px;
                    max-width: 30px;
                    max-height: 30px;
                    display: inline-flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 100%;
                }

                .location-icon {
                    background-color: #98ccf4;
                }

                .date-icon {
                    background-color: #d5b3ff;
                }
                .remarks-icon {
                    background-color : #86e7d6;
                }

                .speciality-icon{
                    background-color: #91ecff;
                } 

                .class-icon{
                background-color: #ffa7a7;
                }

                .visitplan-icon {
                    background-color: #f4a8ff;
                }

                .state-icon {
                    background-color: #ffb98e;
                }

                .visitedwith-icon {
                    background-color: #b2bbff;
                }

                .pobvalue-icon {
                    background-color: #fbd607;
                }
                .product-icon  {
                    background-color: #cacaca;
                } 

                .unlistedcust-icon{
                    background-color: #b2bbff;
                }

                .bluebg-icon{
                    background-color: #e6f4ff;
                }

                .redbg-icon{
                    background-color: #ffe8e9;
                }


                .namespacing{
                    padding: 0 0 0 16px;
                    text-align: left;
                    line-height: 1.5;
                }

                #section-n2 {
                    display:none;
                }

                button.rmvborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #f5f5f5;
                }

                button.rmborder{
                    cursor: pointer;
                    border: none;
                    outline: none;
                    background-color: #fff;
                }

                .tabs {
                    position: relative;
                    text-align: center;
                    background: #f5f5f5;
                    /*width: 100%;*/
                    border-radius: 5px;
                    min-width: 240px;
                    min-height: 500px;
                    overflow-x: auto;
                    overflow-y: hidden;
                    -webkit-overflow-scrolling: touch;
                }

                .tabs .uldiv {
                    list-style-type: none;
                    padding: 0 16px;
                    display: -webkit-box;
                    display: flex;
                    -webkit-box-orient: horizontal;
                    -webkit-box-direction: normal;
                            flex-direction: row;
                    margin-bottom: 4px;
                    -webkit-box-pack: justify;
                            justify-content: space-between;
                    -webkit-box-align: end;
                            align-items: center;
                    flex-wrap: wrap;
                    margin-top: 0;
                    width: 100%;
                }

                .rmv-Mrg{
                    margin: 0;
                }

                .tabs .uldiv li {
                    box-sizing: border-box;
                    -webkit-box-flex: 1;
                    text-align: center;
                    margin-right: 0;
                }
                .lidiv{
                    padding: 0 0 0 16px;
                }


                .tabs .uldiv li label {
                    -webkit-transition: all 0.3s ease-in-out;
                    transition: all 0.3s ease-in-out;
                    padding: 5px auto;
                    overflow: hidden;
                    text-overflow: ellipsis;
                    display: block;
                    cursor: pointer;
                    -webkit-transition: all 0.2s ease-in-out;
                    transition: all 0.2s ease-in-out;
                    white-space: nowrap;
                    -webkit-touch-callout: none;
                    user-select: none;
                }

                .tabs .uldiv li label{
                    font-size: 18px;
                    color: #0273d0;
                }


                .tabs .uldiv li label:hover, .tabs .uldiv li label:focus, tabs .uldiv li label:active{
                    outline: 0;
                    color: #0273d0;
                }

                .tabs .slidertab {
                    position: relative;
                    width: calc(100% - 56px);
                    -webkit-transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                    transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                }
                .tabs .slidertab .indicator {
                    position: relative;
                    width: 16px;
                    max-width: 100%;
                    margin-inline-start: auto;
                    height: 4px;
                    background: #0273d0;
                    border-radius: 1px;
                }

                .tabs .data-content section {
                    -webkit-animation-name: data-content;
                            animation-name: data-content;
                    -webkit-animation-direction: normal;
                            animation-direction: normal;
                    -webkit-animation-duration: 0.3s;
                            animation-duration: 0.3s;
                    -webkit-animation-timing-function: ease-in-out;
                            animation-timing-function: ease-in-out;
                    -webkit-animation-iteration-count: 1;
                            animation-iteration-count: 1;
                    line-height: 1.4;
                }

                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .uldiv > li:nth-child(1) > label {
                    cursor: default;
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(0%);
                            transform: translateX(0%);
                }

                .tabs input[name="tab-control"] {
                    display: none;
                }

                @-webkit-keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @keyframes data-content {
                    from {
                        opacity: 0;
                        -webkit-transform: translateY(5%);
                                transform: translateY(5%);
                    }
                    to {
                        opacity: 1;
                        -webkit-transform: translateY(0%);
                                transform: translateY(0%);
                    }
                }
                @media (max-width: 1000px) {
                    .tabs .uldiv li label {
                        white-space: initial;
                    }
                }


                .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .slidertab {
                    -webkit-transform: translateX(-18px);
                            transform: translateX(-18px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(1):checked ~ .data-content > section:nth-child(1) {
                    display: block;
                }*/
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .uldiv > li:nth-child(2) > label {
                    cursor: default;
                }
                
                .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                    -webkit-transform: translateX(32px);
                            transform: translateX(32px);
                }
                /*.tabs input[name="tab-control"]:nth-of-type(2):checked ~ .data-content > section:nth-child(2) {
                    display: block;
                }*/

                .multi-colDiv{
                    margin: 24px 0;
                    text-align: left;
                    padding: 0 16px;
                    
                }
                @media screen and  (min-width:580px) {
                    .multi-colDiv{
                        display: grid;
                        grid-template-columns: 1fr 1fr 1fr;
                    }
                    .columnsDiv{
                        justify-content: center;
                    }
                }
				</style>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/MobDARSummary.css" />
				<!--<form name="Wizard_TravelDSR" style="margin-bottom:0">-->
                <form name="Wizard_TravelDSR" class="bgcolorform">
					<!--<div ID="dsrDiv" class="outerDiv"
						style="MARGIN-BOTTOM: 10PX; width: 98%;">-->
                    <div class="mainbody">


						<!--<div class="headerTable1 headerTablediv">
							<table id="travelTable" class="tTitleD " border="0"
								cellspacing="1" cellpadding="1" width="100%">-->

								

									<!--<tr>
										<td class="cellttl1" width="auto"
											style='padding : 10px 10px 0px 10px;'>

											<div class="normalFont"
												style='text-transform:capitalize;float: left;'>
												<xsl:variable name="sp_name">
													<xsl:value-of select="sp_name" />
												</xsl:variable>
												<xsl:variable name="sales_pers">
													<xsl:value-of select="sales_pers" />
												</xsl:variable>

												<IMG
													SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($sales_pers)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($sp_name)}"
													onerror='this.src="../webitm/images/Summary/errUser.png"'
													class="iw-header-userImage"
													style="height: 28px; width: 28px;border-radius:50%;;background:lightgray">
												</IMG>
												<div class="normalFont"
													style='text-transform:capitalize;float:right;padding:4px 5px;text-align: left;'>
													<xsl:value-of select="sp_name" />
													<xsl:value-of
														select="concat('(',sales_pers,')')" />
													
												</div>
											</div>
											<div class="normalFont"
												style='text-transform:capitalize;float:right;padding:4px 5px;'>
												<xsl:value-of select="tran_date" />
											</div>

										</td>
									</tr>

									<tr style="width: 100%;">
										<td class="cellttl1" width="auto"
											style="text-align:center;">
											<div class=""
												style='text-transform:capitalize;height: 30px;margin: auto;width: 30px;border-radius: 50%;background: lightgray;'>

												<xsl:variable name="campgn_id">
													<xsl:value-of select="campgn_id" />
												</xsl:variable>
												<xsl:variable name="descr">
													<xsl:value-of select="descr" />
												</xsl:variable>
												
												<IMG
														SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($campgn_id)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($descr)}"
														onerror='this.src="../webitm/images/Summary/errUser.png"'
														class="iw-header-userImage"
														style="height: 15px; width: 15px;padding: 7.5px">
												</IMG>
												
											</div>
											<span CLASS="normalFont" style="width:auto;color:black;">Brand Prescription </span>
											<br />
											<span CLASS="normalFont" style="width:auto;">
												<xsl:value-of select="descr" />
													<xsl:value-of
														select="concat('(',campgn_id,')')" />
												
											</span>

										</td>
									</tr>-->

                                <xsl:for-each select="//Detail1">
                                    <xsl:variable name="hostUrl">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="host_url" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>

                                    

                                    <div class="containerfeed">
                                        <div class="headerdata">
                                            <div class="text-rowgroup-1">
                                                <xsl:value-of select="tran_date" />
                                            </div>
                                        </div>

                                        <div class="single-colDiv">
                                            <xsl:variable name="sp_name">
                                                <xsl:value-of select="sp_name" />
                                            </xsl:variable>
                                            <xsl:variable name="sales_pers">
                                                <xsl:value-of select="sales_pers" />
                                            </xsl:variable>

                                            <div class="imgicon bluebg-icon">
                                                <IMG
                                                    SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($sales_pers)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($sp_name)}"
                                                    onerror='this.src="../webitm/images/Summary/errUser.png"'
                                                    class="imgradius align-imgtext">
                                                    <!--class="iw-header-userImage"
                                                    style="height: 15px; width: 15px;padding: 7.5px">-->
                                                </IMG>
                                            </div>
                                        </div>

                                        <div class="text-rowgroup-2">
                                            <xsl:value-of select="sp_name" />
                                            <xsl:value-of
                                                select="concat('(',sales_pers,')')" />
                                        </div>

                                        <div class="text-rowgroup-3"> BRAND PRESCRIPTION </div>

                                        <div class="main-icon">
                                            <div class="activity-descr-text">
                                                <xsl:variable name="campgn_id">
                                                    <xsl:value-of select="campgn_id" />
                                                </xsl:variable>
                                                <xsl:variable name="descr">
                                                    <xsl:value-of select="descr" />
                                                </xsl:variable>
                                                
                                                <IMG
                                                    SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($campgn_id)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($descr)}"
                                                    onerror='this.src="../webitm/images/Summary/errUser.png"'
                                                    class="mainiconradius">
                                                    <!--class="iw-header-userImage"
                                                    style="height: 15px; width: 15px;padding: 7.5px">-->
												</IMG>
                                                <span class="text-rowgroup-2 hideoverflowfeed"> 
                                                    <xsl:value-of select="descr" />
                                                    <xsl:value-of
                                                        select="concat('(',campgn_id,')')" />
                                                </span>
                                            </div>
                                        </div>

                                        <div class="multi-colDiv">
                                            <div class="columnsDiv">
                                                <div class="iconborder date-icon">
                                                    <IMG
                                                        SRC="{normalize-space($hostUrl)}/ibase/webitm/images/Summary/summary_date.svg"
                                                        onerror='this.src="../webitm/images/Summary/summary_date.svg"' 
                                                        class="bradius align-imgtext">
                                                    </IMG>
                                                </div>
                                                <div  class="namespacing align-imgtext">
                                                    <div class="textcolor headerfontsize " >
                                                        Effective From
                                                    </div>
                                                    <div class="datafontsize " >
                                                        <xsl:value-of select="eff_from" />
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="columnsDiv">
                                                <div class="iconborder date-icon">
                                                    <IMG
                                                        SRC="{normalize-space($hostUrl)}/ibase/webitm/images/Summary/summary_date.svg"
                                                        onerror='this.src="../webitm/images/Summary/summary_date.svg"' 
                                                        class="bradius align-imgtext">
                                                    </IMG>
                                                </div>
                                                <div class="namespacing align-imgtext">
                                                    <div class="textcolor headerfontsize" >
                                                        Valid Upto
                                                    </div>
                                                    <div class="datafontsize">
                                                        <xsl:value-of select="valid_upto" />
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="columnsDiv">
                                                <div class="iconborder remarks-icon">
                                                    <IMG
                                                        SRC="{normalize-space($hostUrl)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                                        onerror='this.src="../webitm/images/Summary/summary_remarks.svg"' 
                                                        class="bradius align-imgtext">
                                                    </IMG>
                                                </div>
                                                <div class="namespacing align-imgtext">
                                                    <div class="textcolor headerfontsize " >
                                                        Remarks
                                                    </div>
                                                    <div class="datafontsize hideoverflowfeed" >
                                                        <xsl:value-of select="remarks" />                                                   
                                                    </div>
                                                </div>
                                            </div>                                    
                                        </div>

                                    </div>

									
								</xsl:for-each>

                                <xsl:variable name="hostUrl">
                                    <xsl:for-each select="//Detail1">
                                        <xsl:if test="attribute/@updateFlag!='D'">
                                            <xsl:value-of select="host_url" />
                                        </xsl:if>
                                    </xsl:for-each>
                                </xsl:variable>

							<!--</table>
						</div>-->

                        <xsl:variable name="feed">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed.svg')" />
                        </xsl:variable>
                        <xsl:variable name="feed_alt">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_feed_alt.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table_alt">
                            <xsl:value-of
                                select="concat(normalize-space($hostUrl),'/ibase/webitm/images/Summary/summary_table_alt.svg')" />
                        </xsl:variable>


                        <div class="tabs">
                            <input type="radio" id="tab1" name="tab-control" checked="true"  />
                            <input type="radio" id="tab2" name="tab-control" />
                            <ul class="uldiv">
                                <li class="rightcol-spacing" title="Feed View">
                                    <label for="tab1" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder feed_default_bg" id="feedbg">
                                                <IMG 
                                                    id="feedicon" width ="30" height="30"
                                                    onclick="focusView('focusOnFeed','{normalize-space($feed_alt)}','{normalize-space($table)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$feed_alt" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                                <li class="lidiv rmv-Mrg" title="Table View">
                                    
                                    <label for="tab2" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder table_default_bg" id="tablebg">
                                                <IMG 
                                                    id="tableicon" width ="30" height="30"
                                                    onclick="focusView('focusOnTable','{normalize-space($table_alt)}','{normalize-space($feed)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$table" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                            </ul>
                            <div class="slidertab">
                                <div class="indicator"></div>
                            </div>

                            <xsl:variable name="host_url">
                                <xsl:for-each select="//Detail1">
                                    <xsl:value-of select="host_url" />
                                </xsl:for-each>
                            </xsl:variable>
                            <div class="data-content">

                                <section id="section-n1">

                                    <!-- Detail2(start) -->
                                    <xsl:variable name="detail2_listed_count">
                                        <xsl:for-each select="//Detail2">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail2)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                        <xsl:variable name="detail2_form">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','2',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail2_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail2_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail2_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail2(end) -->
                                    <!-- Detail3(start) -->
                                    <xsl:variable name="detail3_listed_count">
                                        <xsl:for-each select="//Detail3">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail3)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail3_listed_count) > '0'">
                                        <xsl:variable name="detail3_form">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','3',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail3_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail3_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail3_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail3(end) -->
                                    <!-- Detail4(start) -->
                                    <xsl:variable name="detail4_listed_count">
                                        <xsl:for-each select="//Detail4">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail4)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail4_listed_count) > '0'">
                                        <xsl:variable name="detail4_form">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','4',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail4_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail4_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail4_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail4(end) -->
                                    <!-- Detail5(start) -->
                                    <xsl:variable name="detail5_listed_count">
                                        <xsl:for-each select="//Detail5">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail5)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail5_listed_count) > '0'">
                                        <xsl:variable name="detail5_form">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','5',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail5_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail5_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail5_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail5(end) -->
                                    <!-- Detail6(start) -->
                                    <xsl:variable name="detail6_listed_count">
                                        <xsl:for-each select="//Detail6">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail6)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail6_listed_count) > '0'">
                                        <xsl:variable name="detail6_form">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','6',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail6_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail6_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail6_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail6(end) -->
                                    <!-- Detail7(start) -->
                                    <xsl:variable name="detail7_listed_count">
                                        <xsl:for-each select="//Detail7">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail7)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail7_listed_count) > '0'">
                                        <xsl:variable name="detail7_form">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','7',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail7_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail7_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail7_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail7(end) -->
                                    <!-- Detail8(start) -->
                                    <xsl:variable name="detail8_listed_count">
                                        <xsl:for-each select="//Detail8">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail8)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail8_listed_count) > '0'">
                                        <xsl:variable name="detail8_form">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','8',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail8_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail8_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail8_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail8(end) -->
                                    <!-- Detail9(start) -->
                                    <xsl:variable name="detail9_listed_count">
                                        <xsl:for-each select="//Detail9">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail9)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail9_listed_count) > '0'">
                                        <xsl:variable name="detail9_form">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','9',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail9_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail9_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail9_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail9(end) -->
                                    <!-- Detail10(start) -->
                                    <xsl:variable name="detail10_listed_count">
                                        <xsl:for-each select="//Detail10">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail10)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail10_listed_count) > '0'">
                                        <xsl:variable name="detail10_form">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','10',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail10_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail10_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail10_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail10(end) -->
                                    <!-- Detail11(start) -->
                                    <xsl:variable name="detail11_listed_count">
                                        <xsl:for-each select="//Detail11">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail11)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail11_listed_count) > '0'">
                                        <xsl:variable name="detail11_form">
                                            <xsl:for-each select="//Detail11">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','11',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail11_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail11_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail11_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail11(end) -->
                                    <!-- Detail12(start) -->
                                    <xsl:variable name="detail12_listed_count">
                                        <xsl:for-each select="//Detail12">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail12)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail12_listed_count) > '0'">
                                        <xsl:variable name="detail12_form">
                                            <xsl:for-each select="//Detail12">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','12',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail12_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail12_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail12_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail12(end) -->

                                    <!-- Detail13(start) -->
                                    <xsl:variable name="detail13_listed_count">
                                        <xsl:for-each select="//Detail13">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail13)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail13_listed_count) > '0'">
                                        <xsl:variable name="detail13_form">
                                            <xsl:for-each select="//Detail13">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','13',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail13_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail13_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail13_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail13(end) -->
                                    <!-- Detail14(start) -->
                                    <xsl:variable name="detail14_listed_count">
                                        <xsl:for-each select="//Detail14">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail14)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail14_listed_count) > '0'">
                                        <xsl:variable name="detail14_form">
                                            <xsl:for-each select="//Detail14">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','14',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail14_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail14_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail14_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail14(end) -->
                                    <!-- Detail15(start) -->
                                    <xsl:variable name="detail15_listed_count">
                                        <xsl:for-each select="//Detail15">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail15)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail15_listed_count) > '0'">
                                        <xsl:variable name="detail15_form">
                                            <xsl:for-each select="//Detail15">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','15',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail15_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail15_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail15_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail15(end) -->
                                    <!-- Detail16(start) -->
                                    <xsl:variable name="detail16_listed_count">
                                        <xsl:for-each select="//Detail16">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail16)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail16_listed_count) > '0'">
                                        <xsl:variable name="detail16_form">
                                            <xsl:for-each select="//Detail16">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','16',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail16_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail16_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail16_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail16(end) -->
                                    <!-- Detail17(start) -->
                                    <xsl:variable name="detail17_listed_count">
                                        <xsl:for-each select="//Detail17">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail17)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail17_listed_count) > '0'">
                                        <xsl:variable name="detail17_form">
                                            <xsl:for-each select="//Detail17">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','17',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail17_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail17_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail17_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail17(end) -->
                                    <!-- Detail18(start) -->
                                    <xsl:variable name="detail18_listed_count">
                                        <xsl:for-each select="//Detail18">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail18)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail18_listed_count) > '0'">
                                        <xsl:variable name="detail18_form">
                                            <xsl:for-each select="//Detail18">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','18',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail18_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail18_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail18_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail18(end) -->
                                    <!-- Detail19(start) -->
                                    <xsl:variable name="detail19_listed_count">
                                        <xsl:for-each select="//Detail19">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail19)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail19_listed_count) > '0'">
                                        <xsl:variable name="detail19_form">
                                            <xsl:for-each select="//Detail19">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','19',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail19_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail19_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail19_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail19(end) -->
                                    <!-- Detail20(start) -->
                                    <xsl:variable name="detail20_listed_count">
                                        <xsl:for-each select="//Detail20">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail20)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail20_listed_count) > '0'">
                                        <xsl:variable name="detail20_form">
                                            <xsl:for-each select="//Detail20">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','20',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail20_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail20_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail20_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail20(end) -->
                                    <!-- Detail21(start) -->
                                    <xsl:variable name="detail21_listed_count">
                                        <xsl:for-each select="//Detail21">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail21)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail21_listed_count) > '0'">
                                        <xsl:variable name="detail21_form">
                                            <xsl:for-each select="//Detail21">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','21',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail21_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail21_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail21_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail21(end) -->
                                    <!-- Detail22(start) -->
                                    <xsl:variable name="detail22_listed_count">
                                        <xsl:for-each select="//Detail22">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail22)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail22_listed_count) > '0'">
                                        <xsl:variable name="detail22_form">
                                            <xsl:for-each select="//Detail22">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','22',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail22_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail22_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail22_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail22(end) -->
                                    <!-- Detail23(start) -->
                                    <xsl:variable name="detail23_listed_count">
                                        <xsl:for-each select="//Detail23">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail23)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail23_listed_count) > '0'">
                                        <xsl:variable name="detail23_form">
                                            <xsl:for-each select="//Detail23">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','23',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail23_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail23_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail23_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail23(end) -->
                                    <!-- Detail24(start) -->
                                    <xsl:variable name="detail24_listed_count">
                                        <xsl:for-each select="//Detail24">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail24)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail24_listed_count) > '0'">
                                        <xsl:variable name="detail24_form">
                                            <xsl:for-each select="//Detail24">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','24',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail24_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail24_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail24_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail24(end) -->
                                    <!-- Detail25(start) -->
                                    <xsl:variable name="detail25_listed_count">
                                        <xsl:for-each select="//Detail25">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail25)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail25_listed_count) > '0'">
                                        <xsl:variable name="detail25_form">
                                            <xsl:for-each select="//Detail25">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','25',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail25_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail25_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail25_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail25(end) -->
                                    <!-- Detail26(start) -->
                                    <xsl:variable name="detail26_listed_count">
                                        <xsl:for-each select="//Detail26">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail26)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail26_listed_count) > '0'">
                                        <xsl:variable name="detail26_form">
                                            <xsl:for-each select="//Detail26">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','26',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail26_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail26_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail26_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail26(end) -->
                                    <!-- Detail27(start) -->
                                    <xsl:variable name="detail27_listed_count">
                                        <xsl:for-each select="//Detail27">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail27)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail27_listed_count) > '0'">
                                        <xsl:variable name="detail27_form">
                                            <xsl:for-each select="//Detail27">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','27',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail27_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail27_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail27_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail27(end) -->
                                    <!-- Detail28(start) -->
                                    <xsl:variable name="detail28_listed_count">
                                        <xsl:for-each select="//Detail28">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail28)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail28_listed_count) > '0'">
                                        <xsl:variable name="detail28_form">
                                            <xsl:for-each select="//Detail28">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','28',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail28_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail28_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail28_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail28(end) -->
                                    <!-- Detail29(start) -->
                                    <xsl:variable name="detail29_listed_count">
                                        <xsl:for-each select="//Detail29">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail29)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail29_listed_count) > '0'">
                                        <xsl:variable name="detail29_form">
                                            <xsl:for-each select="//Detail29">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','29',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail29_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail29_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail29_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail29(end) -->
                                    <!-- Detail30(start) -->
                                    <xsl:variable name="detail30_listed_count">
                                        <xsl:for-each select="//Detail30">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail30)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail30_listed_count) > '0'">
                                        <xsl:variable name="detail30_form">
                                            <xsl:for-each select="//Detail30">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','30',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail30_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail30_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitStringFeed">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail30_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail30(end) -->
                                
                                </section>

                                <section id="section-n2">

                                    <!-- Detail2(start) -->
                                    <xsl:variable name="detail2_listed_count">
                                        <xsl:for-each select="//Detail2">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail2)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                        <xsl:variable name="detail2_form">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','2',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail2_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail2_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail2_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail2(end) -->
                                    <!-- Detail3(start) -->
                                    <xsl:variable name="detail3_listed_count">
                                        <xsl:for-each select="//Detail3">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail3)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail3_listed_count) > '0'">
                                        <xsl:variable name="detail3_form">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','3',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail3_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail3_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail3_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail3(end) -->
                                    <!-- Detail4(start) -->
                                    <xsl:variable name="detail4_listed_count">
                                        <xsl:for-each select="//Detail4">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail4)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail4_listed_count) > '0'">
                                        <xsl:variable name="detail4_form">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','4',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail4_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail4_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail4_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail4(end) -->
                                    <!-- Detail5(start) -->
                                    <xsl:variable name="detail5_listed_count">
                                        <xsl:for-each select="//Detail5">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail5)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail5_listed_count) > '0'">
                                        <xsl:variable name="detail5_form">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','5',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail5_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail5_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail5_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail5(end) -->
                                    <!-- Detail6(start) -->
                                    <xsl:variable name="detail6_listed_count">
                                        <xsl:for-each select="//Detail6">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail6)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail6_listed_count) > '0'">
                                        <xsl:variable name="detail6_form">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','6',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail6_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail6_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail6_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail6(end) -->
                                    <!-- Detail7(start) -->
                                    <xsl:variable name="detail7_listed_count">
                                        <xsl:for-each select="//Detail7">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail7)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail7_listed_count) > '0'">
                                        <xsl:variable name="detail7_form">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','7',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail7_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail7_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail7_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail7(end) -->
                                    <!-- Detail8(start) -->
                                    <xsl:variable name="detail8_listed_count">
                                        <xsl:for-each select="//Detail8">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail8)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail8_listed_count) > '0'">
                                        <xsl:variable name="detail8_form">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','8',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail8_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail8_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail8_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail8(end) -->
                                    <!-- Detail9(start) -->
                                    <xsl:variable name="detail9_listed_count">
                                        <xsl:for-each select="//Detail9">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail9)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if test="normalize-space($detail9_listed_count) > '0'">
                                        <xsl:variable name="detail9_form">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','9',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail9_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail9_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail9_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail9(end) -->
                                    <!-- Detail10(start) -->
                                    <xsl:variable name="detail10_listed_count">
                                        <xsl:for-each select="//Detail10">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail10)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail10_listed_count) > '0'">
                                        <xsl:variable name="detail10_form">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','10',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail10_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail10_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail10_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail10(end) -->
                                    <!-- Detail11(start) -->
                                    <xsl:variable name="detail11_listed_count">
                                        <xsl:for-each select="//Detail11">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail11)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail11_listed_count) > '0'">
                                        <xsl:variable name="detail11_form">
                                            <xsl:for-each select="//Detail11">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','11',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail11_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail11_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail11_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail11(end) -->
                                    <!-- Detail12(start) -->
                                    <xsl:variable name="detail12_listed_count">
                                        <xsl:for-each select="//Detail12">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail12)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail12_listed_count) > '0'">
                                        <xsl:variable name="detail12_form">
                                            <xsl:for-each select="//Detail12">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','12',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail12_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail12_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail12_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail12(end) -->

                                    <!-- Detail13(start) -->
                                    <xsl:variable name="detail13_listed_count">
                                        <xsl:for-each select="//Detail13">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail13)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail13_listed_count) > '0'">
                                        <xsl:variable name="detail13_form">
                                            <xsl:for-each select="//Detail13">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','13',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail13_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail13_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail13_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail13(end) -->
                                    <!-- Detail14(start) -->
                                    <xsl:variable name="detail14_listed_count">
                                        <xsl:for-each select="//Detail14">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail14)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail14_listed_count) > '0'">
                                        <xsl:variable name="detail14_form">
                                            <xsl:for-each select="//Detail14">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','14',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail14_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail14_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail14_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail14(end) -->
                                    <!-- Detail15(start) -->
                                    <xsl:variable name="detail15_listed_count">
                                        <xsl:for-each select="//Detail15">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail15)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail15_listed_count) > '0'">
                                        <xsl:variable name="detail15_form">
                                            <xsl:for-each select="//Detail15">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','15',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail15_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail15_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail15_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail15(end) -->
                                    <!-- Detail16(start) -->
                                    <xsl:variable name="detail16_listed_count">
                                        <xsl:for-each select="//Detail16">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail16)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail16_listed_count) > '0'">
                                        <xsl:variable name="detail16_form">
                                            <xsl:for-each select="//Detail16">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','16',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail16_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail16_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail16_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail16(end) -->
                                    <!-- Detail17(start) -->
                                    <xsl:variable name="detail17_listed_count">
                                        <xsl:for-each select="//Detail17">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail17)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail17_listed_count) > '0'">
                                        <xsl:variable name="detail17_form">
                                            <xsl:for-each select="//Detail17">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','17',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail17_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail17_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail17_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail17(end) -->
                                    <!-- Detail18(start) -->
                                    <xsl:variable name="detail18_listed_count">
                                        <xsl:for-each select="//Detail18">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail18)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail18_listed_count) > '0'">
                                        <xsl:variable name="detail18_form">
                                            <xsl:for-each select="//Detail18">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','18',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail18_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail18_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail18_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail18(end) -->
                                    <!-- Detail19(start) -->
                                    <xsl:variable name="detail19_listed_count">
                                        <xsl:for-each select="//Detail19">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail19)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail19_listed_count) > '0'">
                                        <xsl:variable name="detail19_form">
                                            <xsl:for-each select="//Detail19">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','19',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail19_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail19_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail19_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail19(end) -->
                                    <!-- Detail20(start) -->
                                    <xsl:variable name="detail20_listed_count">
                                        <xsl:for-each select="//Detail20">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail20)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail20_listed_count) > '0'">
                                        <xsl:variable name="detail20_form">
                                            <xsl:for-each select="//Detail20">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','20',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail20_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail20_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail20_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail20(end) -->
                                    <!-- Detail21(start) -->
                                    <xsl:variable name="detail21_listed_count">
                                        <xsl:for-each select="//Detail21">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail21)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail21_listed_count) > '0'">
                                        <xsl:variable name="detail21_form">
                                            <xsl:for-each select="//Detail21">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','21',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail21_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail21_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail21_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail21(end) -->
                                    <!-- Detail22(start) -->
                                    <xsl:variable name="detail22_listed_count">
                                        <xsl:for-each select="//Detail22">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail22)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail22_listed_count) > '0'">
                                        <xsl:variable name="detail22_form">
                                            <xsl:for-each select="//Detail22">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','22',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail22_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail22_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail22_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail22(end) -->
                                    <!-- Detail23(start) -->
                                    <xsl:variable name="detail23_listed_count">
                                        <xsl:for-each select="//Detail23">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail23)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail23_listed_count) > '0'">
                                        <xsl:variable name="detail23_form">
                                            <xsl:for-each select="//Detail23">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','23',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail23_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail23_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail23_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail23(end) -->
                                    <!-- Detail24(start) -->
                                    <xsl:variable name="detail24_listed_count">
                                        <xsl:for-each select="//Detail24">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail24)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail24_listed_count) > '0'">
                                        <xsl:variable name="detail24_form">
                                            <xsl:for-each select="//Detail24">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','24',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail24_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail24_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail24_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail24(end) -->
                                    <!-- Detail25(start) -->
                                    <xsl:variable name="detail25_listed_count">
                                        <xsl:for-each select="//Detail25">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail25)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail25_listed_count) > '0'">
                                        <xsl:variable name="detail25_form">
                                            <xsl:for-each select="//Detail25">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','25',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail25_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail25_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail25_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail25(end) -->
                                    <!-- Detail26(start) -->
                                    <xsl:variable name="detail26_listed_count">
                                        <xsl:for-each select="//Detail26">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail26)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail26_listed_count) > '0'">
                                        <xsl:variable name="detail26_form">
                                            <xsl:for-each select="//Detail26">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','26',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail26_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail26_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail26_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail26(end) -->
                                    <!-- Detail27(start) -->
                                    <xsl:variable name="detail27_listed_count">
                                        <xsl:for-each select="//Detail27">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail27)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail27_listed_count) > '0'">
                                        <xsl:variable name="detail27_form">
                                            <xsl:for-each select="//Detail27">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','27',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail27_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail27_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail27_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail27(end) -->
                                    <!-- Detail28(start) -->
                                    <xsl:variable name="detail28_listed_count">
                                        <xsl:for-each select="//Detail28">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail28)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail28_listed_count) > '0'">
                                        <xsl:variable name="detail28_form">
                                            <xsl:for-each select="//Detail28">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','28',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail28_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail28_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail28_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail28(end) -->
                                    <!-- Detail29(start) -->
                                    <xsl:variable name="detail29_listed_count">
                                        <xsl:for-each select="//Detail29">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail29)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail29_listed_count) > '0'">
                                        <xsl:variable name="detail29_form">
                                            <xsl:for-each select="//Detail29">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','29',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail29_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail29_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail29_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>

                                    <!-- Detail29(end) -->
                                    <!-- Detail30(start) -->
                                    <xsl:variable name="detail30_listed_count">
                                        <xsl:for-each select="//Detail30">
                                            <xsl:if test="attribute/@updateFlag!='D'">
                                                <xsl:value-of select="count(//Detail30)" />
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:if
                                        test="normalize-space($detail30_listed_count) > '0'">
                                        <xsl:variable name="detail30_form">
                                            <xsl:for-each select="//Detail30">
                                                <xsl:value-of
                                                    select="concat(@formName,'(','30',',')" />
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:variable name="detail30_form_name">
                                            <xsl:value-of
                                                select="substring-before($detail30_form,',')" />
                                        </xsl:variable>
                                        <xsl:call-template name="tmpSplitString">
                                            <xsl:with-param name="stringtosplit"
                                                select="$detail30_form_name" />
                                        </xsl:call-template>
                                    </xsl:if>
                                    <!-- Detail30(end) -->

                                </section>

                            </div>
                        </div>

						<!--<div class="headerTablediv headerTable1">
						
							<xsl:for-each select="//Detail1">
								
									<div>
										<div
											style="display: inline-block;width: 100%;padding: .5em;">
											<div
												style="height: auto;float: left;width: 36px;display: block;">
												<div class="vision-ui-action_realtime_report"
													style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
											</div>
											<div style="width: calc(100% - 36px);float: right;padding-top: 5px">
												<div style="float: left; color: black; width:100%;"
													class="normalFont tdLeft">Effective From : <xsl:value-of select="eff_from" /> </div>
												</div>
										</div>

									</div>
							
									<div>
										<div
											style="display: inline-block;width: 100%;padding: .5em;">
											<div
												style="height: auto;float: left;width: 36px;display: block;">
												<div class="vision-ui-action_realtime_report"
													style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
											</div>
											<div style="width: calc(100% - 36px);float: right;padding-top: 5px">
												<div style="float: left; color: black; width:100%;"
													class="normalFont tdLeft">Valid Upto : <xsl:value-of select="valid_upto" /> </div>
												</div>
										</div>

									</div>
								
									
									<div>
										<div
											style="display: inline-block;width: 100%;padding: .5em;">
											<div
												style="height: auto;float: left;width: 36px;display: block;">
												<div class="vision-ui-message"
													style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;color:gray;"></div>
											</div>
											<div style="width: calc(100% - 36px);float: right;">
												<div style="float: left; color: black; width:100%;"
													class="normalFont tdLeft">Remarks :</div>
												<div style="float: left; white-space: normal;color:#666"
													class="normalFont tdLeft">
													<xsl:value-of select="remarks" />
												</div>
											</div>
										</div>
								</div>
								
							</xsl:for-each>	
						</div>-->
						
						<div id="overlay"></div>
					</div>

				</form>
			</body>

		</html>
	</xsl:template>

    <xsl:variable name="host">
        <xsl:for-each select="//Detail1">
            <xsl:if test="attribute/@updateFlag!='D'">
                <xsl:value-of select="host_url" />
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>

	<xsl:template name="tmpSplitStringFeed">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>

        <xsl:variable name="collapse">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/collapse.svg')" />
		</xsl:variable>
		<xsl:variable name="expand">
			<xsl:value-of
				select="concat(normalize-space($host),'/ibase/webitm/images/Summary/expand.svg')" />
		</xsl:variable>

		<xsl:if test="normalize-space($form_name) = 'doctor'">
			<xsl:variable name="doc_listed_cnt">
				<xsl:value-of
					select="count(//node()[starts-with(name(), $detail)])" />
			</xsl:variable>
			
			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">

				<!--<details open="true">
					<summary class="summary" style="text-align: left;">
						Doctor's Details - (
						<xsl:value-of
							select="normalize-space($doc_listed_cnt)" />
						)
					</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">-->
                <div class="headerdata datafontsize">
                    <IMG
                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_doc.svg"
                        onerror='this.src="../webitm/images/Summary/summary_doc.svg"'
                        class="outerIcon align-imgtext" >
                    </IMG> 
                    <xsl:value-of
                        select="normalize-space($doc_listed_cnt)" />
                    Doctor's Details
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="doc_listed_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('doc_listed', 'doc_listed_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>
                
                <div id="doc_listed">

						<xsl:for-each
							select="//node()[starts-with(name(), $detail)]">
							


							<xsl:if test="attribute/@updateFlag!='D'">
								
								<xsl:variable name="customer_type">
									<xsl:value-of select="cust_type" />
								</xsl:variable>
								
                                <div class="containerfeed datafontsize">

									<xsl:variable name="strg_name">
										<xsl:value-of select="cust_name" />
									</xsl:variable>
									
									<xsl:variable name="strg_code">
										<xsl:value-of select="strg_code" />
									</xsl:variable>
									
									<xsl:variable name="order_form_no">
										<xsl:value-of select="order_form_no" />
									</xsl:variable>
									<xsl:variable name="locality_descr">
										<xsl:value-of select="locality_descr" />
									</xsl:variable>
									
									<xsl:variable name="domID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									
									<xsl:variable name="speciality_descr">
										<xsl:value-of select="speciality" />
									</xsl:variable>
									
									<xsl:variable name="class_code_descr">
										<xsl:value-of select="class_code" />
									</xsl:variable>
									
									<xsl:variable name="state_descr">
										<xsl:value-of select="state_descr" />
									</xsl:variable>
									
									<xsl:variable name="qualification">
										<xsl:value-of select="qualification" />
									</xsl:variable>
									
									<xsl:variable name="brand_code">
										<xsl:value-of select="brand_code" />
									</xsl:variable>
									
									<xsl:variable name="description">
										<xsl:value-of select="description" />
									</xsl:variable>
									
									<xsl:call-template name="tmpOrderFeed">
										<xsl:with-param name="orderFormName"
											select="concat($host,'@',$order_form_no,'#',$strg_name,'*',$strg_code,'!',$locality_descr,'^',$qualification,'**',$speciality_descr,'@@',$class_code_descr,'$#',$detail,'####',$state_descr,'#####',$description,'***',$brand_code)" />
									</xsl:call-template>

                                </div>
									
							</xsl:if>
						</xsl:for-each>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>

			
		</xsl:if>

	
	</xsl:template>

	<xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="ord_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '*')" />
		</xsl:variable>
		
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '^')" />
		</xsl:variable>
		
		<xsl:variable name="spl_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'@@')" />
		</xsl:variable>
		
		<xsl:variable name="qualification">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'^'),'**')" />
		</xsl:variable>
		
		<xsl:variable name="description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'#####'),'***')" />
		</xsl:variable>
	
	   <xsl:variable name="brand_code">
			<xsl:value-of
				select="substring-after($ord_value,'***')" />
		</xsl:variable>

		
	 
	 	<xsl:variable name="class_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'$#')" />
		</xsl:variable>
		
		 <xsl:variable name="state_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'####'),'#####')" />
		</xsl:variable>
		
		<xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$#'),'####')" />

		</xsl:variable>

		
		<!-- Item Details Start -->

		<xsl:variable name="item_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="item_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>


		<xsl:variable name="item_detail">
			<xsl:value-of select="concat('Detail',$item_form_no)" />
		</xsl:variable>
		
		
		<xsl:variable name="item_listed_count">
			<xsl:if test="normalize-space($item_form_no)!=''">
			
				<xsl:for-each
					select="//node()[starts-with(name(), $item_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="item_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						   <xsl:if
							test="normalize-space($item_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $item_detail)])" />
						</xsl:if> 
					</xsl:if>
				</xsl:for-each>
				
			</xsl:if>
		</xsl:variable>
		<!-- Item Details End -->


		<xsl:choose>
			<xsl:when test="$item_listed_count > '0'">
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">

								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="../webitm/images/Summary/errUser.png"'
											class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">

										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500;">
												
													<xsl:value-of
															select="$doc_strg_name" />
													
											</div>

											<xsl:if test="normalize-space($doc_locality) != ''">

												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Locality:
													<xsl:value-of select="$doc_locality" />
													  
												</div>

											</xsl:if>

											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												State:
												<xsl:value-of select="$state_description" />
												   
											</div>
											

											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												qualification:
												<xsl:value-of select="$qualification" />
											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Speciality:
												<xsl:value-of select="$spl_description" />
											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Brands:
												<xsl:value-of select="$description" />
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>-->
                <div>
                    <div class="customerDiv">

                        <div class="iconborder bluebg-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
                                onerror='this.src="../webitm/images/Summary/errUser.png"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                <xsl:value-of
									select="$doc_strg_name" />
                            </div>
                        </div>
                    
                    </div>

                    <xsl:if test="normalize-space($doc_locality) != ''">
                        
                        <div class="row-div">
                            <div class="iconborder location-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Locality
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:value-of select="$doc_locality" />
                                </div>
                            </div>
                        </div>
                        
                    </xsl:if>

                    <div class="row-div">
                        <div class="iconborder state-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_state.svg"
                                onerror='this.src="../webitm/images/Summary/summary_state.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                State
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$state_description" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder date-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Qualification
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$qualification" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder speciality-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Speciality
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$spl_description" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder product-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($brand_code)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($description)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Brands
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$description" />
                            </div>
                        </div>
                    </div>

                    
                    <xsl:call-template name="tempOrderDataFeed">
                        <xsl:with-param name="orderData"
                            select="concat($item_detail,'@',$doc_strg_code,'#',$item_listed_count,'*',$ord_host_url)" />
                    </xsl:call-template>
                
                </div>
					
					<!--</thead>
				</TABLE>-->
			</xsl:when>
			<xsl:otherwise>
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">

								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="../webitm/images/Summary/errUser.png"'
											class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">

										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500;">
												
													<xsl:value-of
															select="$doc_strg_name" />
													
											</div>

											<xsl:if test="normalize-space($doc_locality) != ''">

												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Locality:
													<xsl:value-of select="$doc_locality" />
													    
												</div>

											</xsl:if>

											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												State:
												<xsl:value-of select="$state_description" />
											</div>
											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Qualification:
												<xsl:value-of select="$qualification" />
											</div>
											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Speciality:
												<xsl:value-of select="$spl_description" />
											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Brands:
												<xsl:value-of select="$description" />
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>-->
						<!--<xsl:call-template name="tempOrderData">
							<xsl:with-param name="orderData"
								select="concat($item_detail,'@',$doc_strg_code,'#',$item_listed_count)" />
						</xsl:call-template>-->

					<!--</thead>
				</TABLE>-->

                <div>
                    <div class="customerDiv">

                        <div class="iconborder bluebg-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
                                onerror='this.src="../webitm/images/Summary/errUser.png"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                <xsl:value-of
									select="$doc_strg_name" />
                            </div>
                        </div>
                    
                    </div>

                    <xsl:if test="normalize-space($doc_locality) != ''">
                        
                        <div class="row-div">
                            <div class="iconborder location-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Locality
                                </div>
                                <div class="hideoverflowfeed">
                                    <xsl:value-of select="$doc_locality" />
                                </div>
                            </div>
                        </div>
                        
                    </xsl:if>

                    <div class="row-div">
                        <div class="iconborder state-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_state.svg"
                                onerror='this.src="../webitm/images/Summary/summary_state.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                State
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$state_description" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder date-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Qualification
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$qualification" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder speciality-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Speciality
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$spl_description" />
                            </div>
                        </div>
                    </div>

                    <div class="row-div">
                        <div class="iconborder product-icon align-imgtext">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($brand_code)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($description)}"
                                onerror='this.src="../webitm/images/Summary/product.svg"'
                                class="brandImg align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Brands
                            </div>
                            <div class="hideoverflowfeed">
                                <xsl:value-of select="$description" />
                            </div>
                        </div>
                    </div>
                </div>

			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>


	<xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="item_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="item_form_cnt">
            <xsl:value-of
				select="substring-before(substring-after($order_data_value,'#'),'*')" />
		</xsl:variable>
        <xsl:variable name="ord_data_url">
            <xsl:value-of
				select="substring-after($order_data_value,'*')" />
        </xsl:variable>

		<!-- Item Details Start -->
	
			<!--<TABLE id="itemTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<tr id="item.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Prescription</th>
						<th></th>
						<th></th>
					</tr>
					<TR id="item.{normalize-space($dcotor_cust_code)}.heading">
						<TH CLASS="cellttl1 cellttlblck heading tdLeft firstData">Item</TH>
						<TH CLASS="cellttl1 cellttlblck heading firstData">Description</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdRight firstData">Rx</TH>
					</TR>
				</thead>
				<tbody id="item.{normalize-space($dcotor_cust_code)}.details">-->
            
            <div class="itemlabelDiv datafontsize">
                Prescription
            </div>
            <div class="mobviewDiv">
					<xsl:for-each
						select="//node()[starts-with(name(), $item_details)]">
						
						<xsl:if test="attribute/@updateFlag!='D'">
						
							<xsl:variable name="camp_item_descr">
								<xsl:value-of select="item_descr" />
							</xsl:variable>
							
							<xsl:variable name="camp_item_code">
								<xsl:value-of select="item_code" />
							</xsl:variable>
						
							<xsl:variable name="item_rx">
								<xsl:value-of select="outcome_num" />
							</xsl:variable>
							
							<xsl:variable name="item_strg_code">
								<xsl:value-of select="strg_code" />
							</xsl:variable>
							
							<xsl:if
								test="normalize-space($item_strg_code) = normalize-space($dcotor_cust_code)">
								<!--<TR style="background-color: #f0eded;">
									<TD CLASS="cellttl1 tdLeft title">
										<xsl:value-of select="$camp_item_code" />
									</TD>
									<TD CLASS="cellttl1 tdCenter title">
										<xsl:value-of select="$camp_item_descr" />
									</TD>
									<TD CLASS="cellttl1 tdRight title">
										<xsl:value-of select="$item_rx" />
									</TD>
								</TR>-->

                                <div class="itemOuterDiv">
                                    <div class="prescription_det">
                                        <div class="iconborder product-icon align-imgtext">
                                            <IMG
                                                SRC="{normalize-space($ord_data_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($camp_item_code)}&amp;object=wsfa_item&amp;objName=wsfa_item&amp;ALT_FLD_VALUE={normalize-space($camp_item_descr)}"
                                                onerror='this.src="../webitm/images/Summary/product.svg"' class="bradius align-imgtext">
                                            </IMG>
                                        </div>
                                        <div class="hideoverflowfeed namespacing datafontsize prescription_data">
                                            <div>
                                                <xsl:value-of select="$camp_item_code" />
                                            </div>
                                            <div class="headerfontsize">
                                                <xsl:value-of select="$camp_item_descr" />
                                            </div>
                                        </div>
                                        <div class=" align-imgtext rightcol-spacing">
                                            <div class="datafontsize">
                                                <xsl:value-of select="$item_rx" />
                                            </div>
                                            <div class="headerfontsize"> Rx </div>
                                        </div>
                                        
                                    </div>
                                </div>
                                <div class="prescription_btm_border"></div>
							</xsl:if>
							
						</xsl:if>
						
					</xsl:for-each>	
            </div>	
				<!--</tbody>
			</TABLE>-->

		<!-- Item Details end -->

	</xsl:template>

    <xsl:template name="tmpSplitString">
		<xsl:param name="stringtosplit" />
		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>
		<xsl:variable name="form_no">
			<xsl:value-of select="substring-after($value,'(')" />
		</xsl:variable>
		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>
		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>
		
				 <xsl:variable name="host_url">
						<xsl:for-each select="//Detail1">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:value-of select="host_url" />
								</xsl:if>
							</xsl:for-each>
				</xsl:variable>


		<xsl:if test="normalize-space($form_name) = 'doctor'">
			<xsl:variable name="doc_listed_cnt">
				<xsl:value-of
					select="count(//node()[starts-with(name(), $detail)])" />
			</xsl:variable>
			
			<xsl:if test="normalize-space($doc_listed_cnt) > '0'">

				<!--<details open="true">
					<summary class="summary" style="text-align: left;">
						Doctor's Details - (
						<xsl:value-of
							select="normalize-space($doc_listed_cnt)" />
						)
					</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">-->
                
                <div class="headerdata datafontsize">
                    <xsl:value-of
						select="normalize-space($doc_listed_cnt)" />
                    Doctor's Details
                </div>

                <div class="containertable">
                    <div class="doctorcontainer"><!-- container starts -->
                        <div class="headerfontsize doctordetails textcolor">
                            <div class="headingwidth firstcolumn doctorDiv">DOCTOR NAME</div>
                            <div class="headingwidth localityDiv">LOCALITY</div>
                            <div class="headingwidth stateDiv">STATE</div>                           
                            <div class="headingwidth qualificationDiv">QUALIFICATION</div>
                            <div class="headingwidth specialityDiv">SPECIALITY</div>
                            <div class="headingwidth brandsDiv lastcolumn">BRANDS</div>
                        </div>
						<xsl:for-each
							select="//node()[starts-with(name(), $detail)]">

							<xsl:if test="attribute/@updateFlag!='D'">
								
								<xsl:variable name="customer_type">
									<xsl:value-of select="cust_type" />
								</xsl:variable>
								
                                  
									<xsl:variable name="strg_name">
										<xsl:value-of select="cust_name" />
									</xsl:variable>
									
									<xsl:variable name="strg_code">
										<xsl:value-of select="strg_code" />
									</xsl:variable>
									
									<xsl:variable name="order_form_no">
										<xsl:value-of select="order_form_no" />
									</xsl:variable>
									<xsl:variable name="locality_descr">
										<xsl:value-of select="locality_descr" />
									</xsl:variable>
									
									<xsl:variable name="domID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									
									<xsl:variable name="speciality_descr">
										<xsl:value-of select="speciality" />
									</xsl:variable>
									
									<xsl:variable name="class_code_descr">
										<xsl:value-of select="class_code" />
									</xsl:variable>
									
									<xsl:variable name="state_descr">
										<xsl:value-of select="state_descr" />
									</xsl:variable>
									
									<xsl:variable name="qualification">
										<xsl:value-of select="qualification" />
									</xsl:variable>
									
									<xsl:variable name="brand_code">
										<xsl:value-of select="brand_code" />
									</xsl:variable>
									
									<xsl:variable name="description">
										<xsl:value-of select="description" />
									</xsl:variable>
									
									<xsl:call-template name="tmpOrder">
										<xsl:with-param name="orderFormName"
											select="concat($host_url,'@',$order_form_no,'#',$strg_name,'*',$strg_code,'!',$locality_descr,'^',$qualification,'**',$speciality_descr,'@@',$class_code_descr,'$#',$detail,'####',$state_descr,'#####',$description)" />
									</xsl:call-template>
									
							</xsl:if>
						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>

			
		</xsl:if>

	
	</xsl:template>

	<xsl:template name="tmpOrder">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="ord_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '*')" />
		</xsl:variable>
		
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '^')" />
		</xsl:variable>
		
		<xsl:variable name="spl_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'@@')" />
		</xsl:variable>
		
		<xsl:variable name="qualification">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'^'),'**')" />
		</xsl:variable>
	
	   <xsl:variable name="description">
			<xsl:value-of
				select="substring-after($ord_value,'#####')" />
		</xsl:variable>

		
	 
	 	<xsl:variable name="class_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'$#')" />
		</xsl:variable>
		
		 <xsl:variable name="state_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'####'),'#####')" />
		</xsl:variable>
		
		<xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$#'),'####')" />

		</xsl:variable>

		
		<!-- Item Details Start -->

		<xsl:variable name="item_form_no">
			<xsl:for-each
				select="//node()[starts-with(name(), $current_form_no)][1]">
				<xsl:if test="attribute/@updateFlag!='D'">
					<xsl:value-of select="item_form_no" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>


		<xsl:variable name="item_detail">
			<xsl:value-of select="concat('Detail',$item_form_no)" />
		</xsl:variable>
		
		
		<xsl:variable name="item_listed_count">
			<xsl:if test="normalize-space($item_form_no)!=''">
			
				<xsl:for-each
					select="//node()[starts-with(name(), $item_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="item_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						   <xsl:if
							test="normalize-space($item_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of
								select="count(//node()[starts-with(name(), $item_detail)])" />
						</xsl:if> 
					</xsl:if>
				</xsl:for-each>
				
			</xsl:if>
		</xsl:variable>
		<!-- Item Details End -->


		<xsl:choose>
			<xsl:when test="$item_listed_count > '0'">
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">

								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="../webitm/images/Summary/errUser.png"'
											class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">

										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500;">
												
													<xsl:value-of
															select="$doc_strg_name" />
													
											</div>

											<xsl:if test="normalize-space($doc_locality) != ''">

												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Locality:
													<xsl:value-of select="$doc_locality" />
													  
												</div>

											</xsl:if>

											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												State:
												<xsl:value-of select="$state_description" />
												   
											</div>
											

											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												qualification:
												<xsl:value-of select="$qualification" />
											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Speciality:
												<xsl:value-of select="$spl_description" />
											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Brands:
												<xsl:value-of select="$description" />
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>-->
                <div class="stickysubforms"><!-- container starts -->
                    <div class=" datafontsize docdatadetails">

                        <div  class="firstcolumn detailswidth doctorDiv">
                            <xsl:value-of
								select="$doc_strg_name" />
                        </div>

                        <div class="detailswidth localityDiv hideoverflow">
                            <xsl:value-of select="$doc_locality" />
                        </div>

                        <div class="detailswidth stateDiv hideoverflow">
                            <xsl:value-of select="$state_description" />
                        </div>

                        <div class="detailswidth qualificationDiv hideoverflow">
                            <xsl:value-of select="$qualification" />
                        </div>

                        <div class="detailswidth specialityDiv hideoverflow">
                            <xsl:value-of select="$spl_description" />
                        </div>

                        <div class="detailswidth brandsDiv hideoverflow lastcolumn">
                            <xsl:value-of select="$description" />
                        </div>
                    </div>

						<xsl:call-template name="tempOrderData">
							<xsl:with-param name="orderData"
								select="concat($item_detail,'@',$doc_strg_code,'#',$item_listed_count)" />
						</xsl:call-template>
                </div>
					
					<!--</thead>
				</TABLE>-->
			</xsl:when>
			<xsl:otherwise>
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black; text-align:left;white-space:nowrap;">

								<div
									style="display: inline-block;width: calc(100% - 1em);padding: .5em;">
									<div style="height: auto;float: left;width: 36px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="../webitm/images/Summary/errUser.png"'
											class="iw-header-userImage"
											style="padding: 0px;height: 30px;width: 30px;border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 36px);float: right;">

										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;font-weight:500;">
												
													<xsl:value-of
															select="$doc_strg_name" />
													
											</div>

											<xsl:if test="normalize-space($doc_locality) != ''">

												<div
													style="color:#666; float: left; white-space: normal;width: 100%;"
													class="normalFont">
													Locality:
													<xsl:value-of select="$doc_locality" />
													    
												</div>

											</xsl:if>

											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												State:
												<xsl:value-of select="$state_description" />
											</div>
											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Qualification:
												<xsl:value-of select="$qualification" />
											</div>
											
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Speciality:
												<xsl:value-of select="$spl_description" />
											</div>
											<div
												style="color: #666; float: left; white-space: normal;width: 100%;"
												class="normalFont">
												Brands:
												<xsl:value-of select="$description" />
											</div>
										</div>
									</div>
								</div>
							</td>
						</tr>
						<xsl:call-template name="tempOrderData">
							<xsl:with-param name="orderData"
								select="concat($item_detail,'@',$doc_strg_code,'#',$item_listed_count)" />
						</xsl:call-template>
					</thead>
				</TABLE>-->
                <div class="stickysubforms"><!-- container starts -->
                    <div class=" datafontsize docdatadetails">
                        <div  class="firstcolumn detailswidth doctorDiv">
                            <xsl:value-of
								select="$doc_strg_name" />
                        </div>

                        <div class="detailswidth localityDiv hideoverflow">
                            <xsl:value-of select="$doc_locality" />
                        </div>

                        <div class="detailswidth stateDiv hideoverflow">
                            <xsl:value-of select="$state_description" />
                        </div>

                        <div class="detailswidth qualificationDiv hideoverflow">
                            <xsl:value-of select="$qualification" />
                        </div>

                        <div class="detailswidth specialityDiv hideoverflow">
                            <xsl:value-of select="$spl_description" />
                        </div>

                        <div class="detailswidth brandsDiv hideoverflow lastcolumn">
                            <xsl:value-of select="$description" />
                        </div>
                    </div>
                </div>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>


	<xsl:template name="tempOrderData">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="item_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="item_form_cnt">
			<xsl:value-of
				select="substring-after($order_data_value,'#')" />
		</xsl:variable>

		<!-- Item Details Start -->
	
			<!--<TABLE id="itemTable.{normalize-space($dcotor_cust_code)}"
				class="tTitleD" width="100%"
				style="z-index:9999999999;background-color: #f0eded;border-bottom: 5px solid white;">
				<thead class="" style="height : 30px;">
					<tr id="item.{normalize-space($dcotor_cust_code)}.heading1">
						<th style="float: left;">Prescription</th>
						<th></th>
						<th></th>
					</tr>
					<TR id="item.{normalize-space($dcotor_cust_code)}.heading">
						<TH CLASS="cellttl1 cellttlblck heading tdLeft firstData">Item</TH>
						<TH CLASS="cellttl1 cellttlblck heading firstData">Description</TH>
						<TH CLASS="cellttl1 cellttlblck heading tdRight firstData">Rx</TH>
					</TR>
				</thead>
				<tbody id="item.{normalize-space($dcotor_cust_code)}.details">-->
        <div class="sampledetails">
            <div class="sampleheading textcolor headerfontsize">
                Prescription
            </div>
            <div class="samplename">
                <div class="left-spacing headerfontsize"> ITEM </div>	
                <div class="center-spacing headerfontsize"> DESCRIPTION </div>
                <div class="right-spacing headerfontsize"> RX </div>
            </div>

            <xsl:for-each
                select="//node()[starts-with(name(), $item_details)]">
                
                <xsl:if test="attribute/@updateFlag!='D'">
                
                    <xsl:variable name="camp_item_descr">
                        <xsl:value-of select="item_descr" />
                    </xsl:variable>
                    
                    <xsl:variable name="camp_item_code">
                        <xsl:value-of select="item_code" />
                    </xsl:variable>
                
                    <xsl:variable name="item_rx">
                        <xsl:value-of select="outcome_num" />
                    </xsl:variable>
                    
                    <xsl:variable name="item_strg_code">
                        <xsl:value-of select="strg_code" />
                    </xsl:variable>
                    
                    <xsl:if
                        test="normalize-space($item_strg_code) = normalize-space($dcotor_cust_code)">
                        <!--<TR style="background-color: #f0eded;">
                            <TD CLASS="cellttl1 tdLeft title">
                                <xsl:value-of select="$camp_item_code" />
                            </TD>
                            <TD CLASS="cellttl1 tdCenter title">
                                <xsl:value-of select="$camp_item_descr" />
                            </TD>
                            <TD CLASS="cellttl1 tdRight title">
                                <xsl:value-of select="$item_rx" />
                            </TD>
                        </TR>-->
                        <div class="sampledata datafontsize">

                            <div class="left-spacing detailswidth firstcolumn hideoverflow">
                                <xsl:value-of select="$camp_item_code" />
                            </div>
                            <div class="detailswidth center-spacing">
                                <xsl:value-of select="$camp_item_descr" />
                            </div>
                            <div class="detailswidth lastcolumn right-spacing">
                                <xsl:value-of select="$item_rx" />
                            </div>

                        </div>
                    </xsl:if>
                    
                </xsl:if>
                
            </xsl:for-each>		
        </div>
				<!--</tbody>
			</TABLE>-->

		<!-- Item Details end -->

	</xsl:template>

</xsl:stylesheet>