<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--<xsl:output method="html" indent="no" version="4.0" /> -->

	<xsl:output omit-xml-declaration="yes" method="html"
		encoding="utf-8" indent="yes" />


	<xsl:template match="/">
		<html style = "overflow: auto;">
			<head>
				<title>Invoice Claim</title>
				<script type="text/javascript"
					src="/ibase/webitm/e12ria_ext/e12ria.nocache.js"></script>
				<script type="text/javascript"
					src="/ibase/webitm/js/retail_sch_adm_aprv.js"></script>
				<script type="text/javascript"
					src="/ibase/webitm/js/e12PluginWrapper.js"></script>
				<script>
						var calendertop = 100;
						var calenderleft = 700;
						var selectedObj = null;
						var global_date_format ="MM/dd/yy";
						var global_date_type= "date";
						var objCur = "";
						var local_dom_id="";
						
					</script>
		</head>
		
		
	<xsl:for-each select="//DocumentRoot"><xsl:variable name="DEFAULTCOL"><xsl:value-of select="/DOCUMENTROOT/editFlag" /></xsl:variable></xsl:for-each>
	<xsl:for-each select="//Detail1">
		<xsl:variable name="tran_mode"><xsl:value-of select="tran_mode" /></xsl:variable>
		<xsl:variable name="editFlag1"><xsl:value-of select="@editFlag" /></xsl:variable>
		<xsl:variable name="updateFlagHeader"><xsl:value-of select="attribute/@updateFlag" /></xsl:variable>
						<xsl:variable name="confirm"><xsl:value-of select="confirm" /></xsl:variable>
		
     <body onload="windowOnLoad();clickLink();loadHeader();" style = "width: 100%;margin: 0;padding: 0; font-family: MuseoLight-300, sans-serif !important;">
     <style>
		

<!--
	@font-face 
	{
    	font-family: "myFirstFont";
    	src: url(../font/GothamRoundedBook.ttf) format("truetype");
	}
 -->
 <!-- SONAM K -->
@font-face {
	font-family: "elegant-icons";
	src: url(/ibase/webitm/css/fonts/elegant-icons.ttf),
    	 url(/ibase/webitm/css/fonts/elegant-icons.woff);
}

* {
    box-sizing: border-box;
}

#attPluginMainPanel table td {
    border: none;
}

h1, h2, h3, h4, h5, h6 
{
  font-family: myFirstFont, Helvetica, Arial, sans-serif;
}
html 
{
  margin: 0;
  padding: 0;
  height: 100%;
  font-size:100%;
}
body 
{
  font-family: myFirstFont, sans-serif, Arial;
  line-height: 1.8;
  background-color: #fff;
  -webkit-font-smoothing: antialiased;
   font-size: 100%;
  color: #384047;
  font-weight: 400;
  position: relative;
  padding: 0;
  width: 99%;
  min-height: 100vh;
  overflow-x: hidden;
  -webkit-overflow-scrolling: touch;
  -moz-overflow-scrolling: touch;
  -ms-overflow-scrolling: touch;
  -o-overflow-scrolling: touch;
  overflow-scrolling: touch;
  -webkit-font-kerning: auto;
  -moz-font-kerning: auto;
  font-kerning: auto;
  -o-font-kerning: auto;

  --primary:#5fdeb2; <!-- SONAM K-->
}
body.preloader-active 
{
  overflow-y: hidden;
  -ms-touch-action: none;
}
.no-js body.preloader-active 
{
  overflow-y: auto;
  -ms-touch-action: auto;
}
* 
{
  font-family: inherit;
}
.organization-form
{
	box-shadow: 0px 0px 10px -3px rgba(0,0,0,0.19);
}
.container
{
	width:70%;
	margin:auto;
	box-shadow: 0px 0px 10px -3px rgba(0,0,0,0.19);
	background:#f7f8fa;
	height:auto;
}
.row
{
	padding:1em;
	margin-top:1em;
}

.row_title
{
	padding:0.5em;
}
.arrow_img{
	width:20px;
	float:right;
}
.row_section
{
	background:#fff;
	height:auto;
    padding: 0.5em;
    border-bottom: 1px solid #f3f3f3;
}
.center
{
	font-size: 1em;
	text-align: left;
	margin-top:0; 
	color:#687285;
}
.cotainer
 {
    -webkit-column-count: 3;
    -moz-column-count: 3;
    column-count: 3;
    position: relative;
   -webkit-column-rule: 1px dashed #e6e6e6;
    -moz-column-rule: 1px dashed #e6e6e6;
    column-rule: 1px dashed #e6e6e6;
}

.heading
{
	/*font-size: 0.9em;
	text-align: left;
	padding-top: 0.5em;
	padding-left: 0.8em;
	background-color:#fff;
	color: #687285;*/
	
	font-size: 14px;
    text-align: left;
    padding: 8px;
    padding-left: 8px;
    background-color: #fff;
    color: #4e4e4e;
}

.circle 
{
  width: 30px;
  height: 30px;
  border-radius: 50%;
  font-size: 12px;
  color: #fff;
  line-height: 30px;
  text-align: center;
  background: #cfbebe;
}

.field_row 
{
    margin-left: auto;
    margin-right: auto;
}
.field_row1 
{
    
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
    margin: 0em 0 1em;
}
.field_row2 
{
   
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
    margin: 0em 0 1em;
	padding-bottom:1em;
}
.field_row3 
{
    
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
        margin: 0em 0 1em;
}
.field_row4 
{
    
    -webkit-column-break-inside: avoid;
    break-inside: avoid;
        margin: 0em 0 1em;
}
.textfield
{
	padding:0;
}
.img_field
{
	width: 7%;
	float:left;
	margin: 0.5em;
    margin-top: 1.2em;
}
.inputfield
{
	/*width: 98%;*/
	margin:auto;
	/*border-bottom:none;*/
	font-family: MuseoLight-300, sans-serif !important;
}
input::placeholder 
{
  color: #ccc;
  font-size:0.8rem !important;
  
}
::-webkit-input-placeholder 
{ /* Chrome/Opera/Safari */  color: #ccc;font-size:0.8rem !important; 
} ::-moz-placeholder { /* Firefox 19+ */  color: #ccc;font-size:0.8rem !important; }
 
.styled-input
 {
  position: relative;
}

.styled-input label
 {
    color: #666666;
	/*color:#9e9e9e;*/
    position: absolute;
    top: 0.6rem;
    left: 1px;
    height: 100%;
    font-size: 1rem;
    cursor: text;
    -webkit-transform-origin: 0% 100%;
    transform-origin: 0% 100%;
    text-align: initial;
    -webkit-transform: translateY(13px);
    transform: translateY(13px);
    pointer-events: none;
	width: 93%;
    float: left;
}

.styled-input.wide 
{ 
	width: 100%;
}

input,
textarea 
{
   background-color: transparent;
    border: none;
    /*border-bottom: 1px solid #dadada;*/
    border-radius: 0;
    outline: none;
    height: 1.5rem;
    width: 100%;
    /*font-size: 1rem;*/
    margin: 0 0 0px 0;
    padding: 22px 1px 0px;
    -webkit-box-shadow: none;
    box-shadow: none;
    -webkit-box-sizing: content-box;
    box-sizing: content-box;
    -webkit-transition: all 0.3s;
    transition: all 0.3s;
    color: ##666;
}

input ~ span,
textarea ~ span
 {
    display: block;
    width: 0;
    height: 3px;
    position: absolute;
    bottom: 0;
    left: 0;
    -webkit-transition: all 0.125s ease;
    transition: all 0.125s ease;
    font-size: 0.75em;
    color: #fd3e19;
    font-weight: 400;
	padding: 8px 0 0;
    
}

input:focus,
textarea:focus { outline: 0;}

input:focus ~ span,
textarea:focus ~ span {
  width: 99%;
  -webkit-transition: all 0.075s ease;
  transition: all 0.075s ease;
   
}

input[type=text]:focus:not([readonly])
 {
            border-bottom: 1px solid #fda786;
}
label.active 
{
    transform-origin: 0 0;
    transform: translateY(-0.4rem) scale(0.75);
    -webkit-transform: translateY(-0.4rem) scale(0.75);
    -webkit-transform-origin: 0 0;
}

textarea {
  width: 99%;
  min-height: 3em;
}
.right_arrow 
{
position: absolute;
padding: 10px 3px 5px 14px;
width: 35px;
height: 32px;
vertical-align: bottom;
right: 0;
bottom: 0;
cursor: pointer;
}


.galaxyButton {
    border: 1px solid #e7e7e7;
	border-radius: 2px;
	-moz-border-radius: 2px;
	-webkit-border-radius: 2px;
	-moz-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
	-webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
	box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
	color: #333;
	height: 22px;
	font-size: 12px;
	background-color: #e7e7e7;
	background: #e7e7e7;
	cursor: pointer;
	margin-right: 10px;
	width: auto;
	/*padding: 2px;*/
	padding: 0 7px;
	float:unset;
}


/*switch button*/
*,*:before,*:after{
box-sizing:border-box;
margin:0;
padding:0;
/*transition*/
/*-webkit-transition:.25s ease-in-out;
   -moz-transition:.25s ease-in-out;
     -o-transition:.25s ease-in-out;
        transition:.25s ease-in-out;*/
outline:none;

}
body{
background:#f1f1f1;
}
h1{
margin:75px auto 0 auto;
text-align:center;
font-weight:200;
color:#4b4b4b;
}
#toggles{
    width: 60px;
    margin: 0.8em;
    text-align: center;
    float: right;
}
.ios-toggle,.ios-toggle:active{
position:absolute;
top:-5000px;
height:0;
width:0;
opacity:0;
border:none;
outline:none;
}
.checkbox-label {
    display: block;
    position: relative;
    padding: 7px;
    margin-bottom: 15px;
    font-size: 12px;
    line-height: 10px;
    width: 100%;
    height: 31px;
    -webkit-border-radius: 18px;
    -moz-border-radius: 18px;
    border-radius: 18px;
    background: #f8f8f8;
    cursor: pointer;
}
.checkbox-label:before{
content:'';
display:block;
position:absolute;
z-index:1;
line-height:34px;
text-indent:40px;
height:25px;
width:25px;
/*border-radius*/
-webkit-border-radius:100%;
   -moz-border-radius:100%;
        border-radius:100%;
top:3px;
left:4px;
right:auto;
background:white;
/*box-shadow*/
-webkit-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
   -moz-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
        box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
}
.checkbox-label:after{
content:attr(data-off);
display:block;
position:absolute;
z-index:1;
top:0;
left:-268px;
padding:10px;
height:100%;
width:300px;
text-align:right;
color:#bfbfbf;
white-space:nowrap;
}
.ios-toggle:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
.ios-toggle:checked + .checkbox-label:before{
left:calc(100% - 28px);
/*box-shadow*/
-webkit-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
   -moz-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
        box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
}
.ios-toggle:checked + .checkbox-label:after{
content:attr(data-on);
left:26px;
width:36px;
z-index:9;
}
/* GREEN CHECKBOX */

#checkbox1 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
}
#checkbox1:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
#checkbox1:checked + .checkbox-label:after{
color:rgba(19,191,17,1);
}
/* RED CHECKBOX */

#checkbox2 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #f35f42,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #f35f42,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #f35f42,0 0 0 2px #dddddd;
}
#checkbox2:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #f35f42,0 0 0 2px #f35f42;
   -moz-box-shadow:inset 0 0 0 20px #f35f42,0 0 0 2px #f35f42;
        box-shadow:inset 0 0 0 20px #f35f42,0 0 0 2px #f35f42;
}
#checkbox2:checked + .checkbox-label:after{
color:#000;
}
/* BLUE CHECKBOX */

#checkbox3 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
}
#checkbox3:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
   -moz-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
        box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
}
#checkbox3:checked + .checkbox-label:after{
color:#1fc1c8;
}


/*On off button*/
*,*:before,*:after{
box-sizing:border-box;
margin:0;
padding:0;
/*transition*/
/*-webkit-transition:.25s ease-in-out;
   -moz-transition:.25s ease-in-out;
     -o-transition:.25s ease-in-out;
        transition:.25s ease-in-out;
*/
outline:none;

}
body{
background:#f1f1f1;
}
h1{
margin:75px auto 0 auto;
text-align:center;
font-weight:200;
color:#4b4b4b;
}
#toggles_on_off{
    width: 60px;
    margin: 0.8em;
    text-align: center;
    float: right;
}
.ios-toggle_on_off,.ios-toggle_on_off:active{
position:absolute;
top:-5000px;
height:0;
width:0;
opacity:0;
border:none;
outline:none;
}
.checkbox-label_on {
    display: block;
    position: relative;
    padding: 7px;
    margin-bottom: 15px;
    font-size: 12px;
    line-height: 10px;
    width: 100%;
    height: 31px;
   
    background: #f8f8f8;
    cursor: pointer;
}
.checkbox-label_on:before{
content:'';
display:block;
position:absolute;
z-index:1;
line-height:34px;
text-indent:40px;
height:25px;
width:25px;
top:3px;
left:4px;
right:auto;
background:white;
/*box-shadow*/
-webkit-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
   -moz-box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
        box-shadow:0 3px 3px rgba(0,0,0,.2),0 0 0 2px #dddddd;
}
.checkbox-label_on:after{
content:attr(data-off);
display:block;
position:absolute;
z-index:1;
top:0;
left:-268px;
padding:10px;
height:100%;
width:304px;
text-align:right;
color:#bfbfbf;
white-space:nowrap;
}
.ios-toggle_on_off:checked + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 20px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
.ios-toggle_on_off:checked + .checkbox-label_on:before{
left:calc(100% - 28px);
/*box-shadow*/
-webkit-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
   -moz-box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
        box-shadow:0 0 0 2px transparent,0 3px 3px rgba(0,0,0,.3);
}
.ios-toggle_on_off:checked + .checkbox-label_on:after{
content:attr(data-on);
left:26px;
width:36px;
z-index:9;
}
/* GREEN CHECKBOX */

#checkbox_on+ .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px rgba(19,191,17,1),0 0 0 2px #dddddd;
}
#checkbox_on:checked + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
   -moz-box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
        box-shadow:inset 0 0 0 18px rgba(19,191,17,1),0 0 0 2px rgba(19,191,17,1);
}
#checkbox_on:checked + .checkbox-label_on:after{
color:rgba(19,191,17,1);
}
/* RED CHECKBOX */

#checkbox_on + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #13bf11,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #13bf11,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #13bf11,0 0 0 2px #dddddd;
}
#checkbox_on:checked + .checkbox-label_on{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #13bf11,0 0 0 2px #13bf11;
   -moz-box-shadow:inset 0 0 0 20px #13bf11,0 0 0 2px #13bf11;
        box-shadow:inset 0 0 0 20px #13bf11,0 0 0 2px #13bf11;
}
#checkbox_on:checked + .checkbox-label_on:after{
color:#000;
}
/* BLUE CHECKBOX */

#checkbox3 + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
   -moz-box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
        box-shadow:inset 0 0 0 0px #1fc1c8,0 0 0 2px #dddddd;
}
#checkbox3:checked + .checkbox-label{
/*box-shadow*/
-webkit-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
   -moz-box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
        box-shadow:inset 0 0 0 20px #1fc1c8,0 0 0 2px #1fc1c8;
}
#checkbox3:checked + .checkbox-label:after{
color:#1fc1c8;
}



/*select field*/
.selectoption {
    display: block;
    background: white;
    outline: none;
    -moz-outline: none;
    outline-color: transparent;
    font-weight: lighter;
    font-size: small;
    box-sizing: border-box;
    position: relative;
    background-color: transparent;
    border: 1px solid;
    border-top-color: #fff;
    border-left-color: #fff;
    border-right-color: #fff;
    border-bottom-color: #ccc;
    border-radius: 0;
    -webkit-appearance: menulist !important;
    padding-top:2em;
	width:100%;
}

/*map*/
.map{
    border: 1px solid #ccc;
    height: 150px;
	width:97%;
	}
	
/*Tooltip*/
.error:after{content: "?"; color: red;position: relative;
    display: inline-block;}
	
.error:after .tooltiptext {
    visibility: hidden;
    width: 120px;
    background-color: black;
    color: #fff;
    text-align: center;
    border-radius: 6px;
    padding: 5px 0;

    /* Position the tooltip */
    position: absolute;
    z-index: 1;
}

.error:after :hover .tooltiptext {
    visibility: visible;
}

.tooltip {
    position: relative;
    display: inline-block;
    border-bottom: 1px dotted black;
}

.tooltip .tooltiptext {
    visibility: hidden;
    width: 120px;
    background-color: black;
    color: #fff;
    text-align: center;
    border-radius: 6px;
    padding: 5px 0;

    /* Position the tooltip */
    position: absolute;
    z-index: 1;
}

.tooltip:hover .tooltiptext {
    visibility: visible;
}


/*checkbox*/
input[type=checkbox]{
	    width: 4%;
		vertical-align: middle;
		font-size:0.75em;
}


/*3 column */

#pagewrap {
	padding: 5px;
	width: 100%;
}

#content {
	width: 33%;
	float: left;
	padding: 5px;
}

#middle {
	width: 33%; /* Account for margins + border values */
	float: left;
	padding: 5px;
	margin: 0px 5px 5px 5px;
}

#sidebar {
	width: 32%;
	padding: 5px;
	float: left;
}


/************************************************************************************
MEDIA QUERIES
*************************************************************************************/
/* for 980px or less */
@media screen and (max-width: 980px) {
	
	#pagewrap {
		width: 94%;
	}
	#content {
		width: 41%;
		padding: 1% 4%;
	}
	#middle {
		width: 41%;
		padding: 1% 4%;
		margin: 0px 0px 5px 5px;
		float: right;
	}
	
	#sidebar {
		clear: both;
		padding: 1% 4%;
		width: auto;
		float: none;
	}

	
}

/* for 700px or less */
@media screen and (max-width: 600px) {

	#content {
		width: auto;
		float: none;
	}
	
	#middle {
		width: auto;
		float: none;
		margin-left: 0px;
	}
	
	#sidebar {
		width: auto;
		float: none;
	}

}

/* for 480px or less */
@media screen and (max-width: 480px) {

	
	#sidebar {
		display: none;
	}

}


#content, #middle, #sidebar {
	margin-bottom: 5px;
}

<!-- Add for toogle button -->
.toggle {
  -webkit-appearance: none;
  appearance: none;
  width: 62px;
  height: 32px;
  display: inline-block;
  position: relative;
  border-radius: 50px;
  overflow: hidden;
  outline: none;
  border: none;
  cursor: pointer;
  background-color: #a2a2a2;
  transition: background-color ease 0.3s;
}

.toggle:before {
  content: "yes no";
  display: block;
  position: absolute;
  z-index: 2;
  width: 28px;
  height: 28px;
  background: #fff;
  left: 2px;
  top: 2px;
  border-radius: 50%;
  font: 10px/28px Helvetica;
  text-transform: uppercase;
  font-weight: bold;
  text-indent: -22px;
  word-spacing: 37px;
  color: #fff;
  text-shadow: -1px -1px rgba(0,0,0,0.15);
  white-space: nowrap;
  box-shadow: 0 1px 2px rgba(0,0,0,0.2);
  transition: all cubic-bezier(0.3, 1.5, 0.7, 1) 0.3s;
}

.toggle:checked {
}

.toggle:checked:before {
  left: 32px;
}
select {
    border: none;
    outline: none;
    scroll-behavior: smooth;
    border-style: none;
    background: transparent;
    width: 100%;
    padding: 4px 0px;
    box-shadow: 0px .5px 0px 0px rgba(0,0,0,.4);
}
.thClass
	{
	border-bottom-width:2px;
	}
						
.tdClass>td{
	padding: 0 10px;
	font-size: 12px;
	text-shadow: 0 1px 1px rgba(0, 0, 0, .2);
	/*border-right: 1px solid #eee;
	border-right-color: rgba(0, 0, 0, 0.07);
	font-family: Arial, Helvetica, Helvetica Neue, Verdana, sans-serif;
	font-size: 12px;
	text-shadow: 0 1px white;
	text-shadow: 0 1px 1px rgba(0, 0, 0, .2);
	text-rendering: optimizeLegib*/
	}
table.mt {
	/*border-width: 1px;border-spacing:0px ;border-style:
	solid;border-color: #cfcfcf;border-collapse: collapse;line-height:
	25px;background-color: #FFF;*/
	border-spacing: 0px;
	line-height: 25px;
	
	
	
	}
table.mt th {
	/*border-width: 1px;
    padding: 1px;
    border-style: solid;
    border-color: #cfcfcf;
    white-space: normal;
    text-rendering: optimizeLegibility;*/
    
    padding: 1px;
    border-style: none;
    white-space: normal;
    text-rendering: optimizeLegibility;
    background-color: #fff;
	}
table.mt td {
	/*border-width: 1px;padding: 1px;border-color:
	#cfcfcf;vertical-align:middle;*/
	border: 1px solid #e0e0e0;
    border-collapse: collapse;
    background-color: #fff !IMPORTANT;
	}	
	
.viewimage
{
	margin-right: 4px !important;
	width: 25px !important;
	height: 25px !important;
}	
.editfield
{
width: 90%;
    padding: 4px;
    color: #000;
    border-radius: 3px;
    text-align: right;
    background-color: #f3f3f3;
    border: 1px solid #d3d3d3;
}

	</style>   
	
<script src="/ibase/E12BROWSER/js/jquery-1.11.1.min.js"></script>
<script src="/ibase/E12BROWSER/js/expandy.min.js"></script>
<script><![CDATA[
    var __FULL_SCREEN = true;
    
    $('[id^="container"').makeExpander({
		toggleElement : 'h2',
		jqAnim : true,
		showFirst : false,
		accordion : true,
		speed : 400
		/*indicator: 'triangle'*/
    });
]]></script>
	<form name="form1" method="POST" action="" style="width:98%;margin:1em auto;-webkit-box-shadow: 0 0 2px #ccc;-moz-box-shadow: 0 0 2px #ccc;">
		<!-- <div class="heading"> -->
			<xsl:variable name="item_count">
				<xsl:for-each select="//Detail3">
						<xsl:value-of select="count(//Detail3)" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="invoice_count">
				<xsl:for-each select="//Detail2">
						<xsl:value-of select="count(//Detail2)" />
				</xsl:for-each>
			</xsl:variable>
			<xsl:choose>
			<xsl:when  test="$updateFlagHeader ='A'"> 
  			<!-- <table width="100%" border="0" cellspacing="0" cellpadding="0" >
  				<tr>
					<td style="text-align:right;padding-right:0.5em;">
						<div class="heading" style="text-align: right;">
						<div style="text-align:right;display: inline-block;" class="buttondata">
						<button type="button" value="Save" class="galaxyButton" id="Save" onclick="return saveData(this)">Save</button>
						<button type="button" value="Close" class="galaxyButton" onclick="closeWindow();">Close</button></div>
						</div>
					</td>
				</tr>
  			</table> -->
  			<div style="text-align: right;border-bottom: 1px solid #efefef;text-align: left;position: relative;display: flex;align-items: center;" class="heading">
  			<div style="font-size: 18px;font-weight: bold;">Wholesaler Invoice Details</div>
  			<div class="buttondata" style="text-align:right;display: inline-block;right: 0;position: absolute;">
  			<!-- <button onclick="saveData(this)" id="Save" class="galaxyButton" value="Save" type="button">Save</button> -->
  			<!-- <button onclick="closeWindow();" class="galaxyButton" value="Close" type="button">Close</button> -->
  			<input onclick="closeWindowView();" class="galaxyButton" value="Close" type="button" />
  			</div></div>
			</xsl:when>
			<xsl:otherwise>
			<!-- <table  width="100%" border="0" cellspacing="0" cellpadding="0" >
  				<tr>
					<td style="text-align:right;padding-right:0.5em;">
						<div class="heading" style="text-align: right;">
						<div style="text-align:right;display: inline-block;" class="buttondata">
						
						<xsl:choose>
						<xsl:when  test="$confirm !='Y'"> 
						<button type="button" value="Save" class="galaxyButton" id="Save" onclick="saveData(this)">Save</button>
						</xsl:when>
						</xsl:choose>
						<button type="button" value="Close" class="galaxyButton" onclick="closeWindow();">Close</button>
						</div>
						</div>
					</td>
				</tr>
			</table> -->
			<div style="text-align: right;border-bottom: 1px solid #efefef;text-align: left;position: relative;display: flex;align-items: center;" class="heading">
  			<div style="font-size: 18px;font-weight: bold;">Wholesaler Invoice Details</div>
  			<div class="buttondata" style="text-align:right;display: inline-block;right: 0;position: absolute;">
  			<!-- <button onclick="saveData(this)" id="Save" class="galaxyButton" value="Save" type="button">Save</button> -->
  			<!-- <button onclick="closeWindow();" class="galaxyButton" value="Close" type="button">Close</button> -->
  			<input onclick="closeWindowView();" class="galaxyButton" value="Close" type="button" />
  			</div></div>
			</xsl:otherwise>
			</xsl:choose>

		<!-- </div> -->
					
		<div id="mainDiv">
			<div id="tranDiv">
				<table height="208" border="0" align="center" class="" id="headerTable"  >
				<xsl:variable name="domIDHeader"><xsl:value-of select="@domID" /></xsl:variable>
				<xsl:variable name="statusHeader"><xsl:value-of select="attribute/@status" /></xsl:variable>
				<xsl:variable name="dbIDHeader"><xsl:value-of select="@dbID" /></xsl:variable>
				<xsl:variable name="pkNamesHeader"><xsl:value-of select="attribute/@pkNames" /></xsl:variable>
				<xsl:variable name="objNameHeader"><xsl:value-of select="@objName" /></xsl:variable>
				<xsl:variable name="editFlag"><xsl:value-of select="editFlag" /></xsl:variable>
				
									<xsl:variable name="tran_id">
										<xsl:value-of select="tran_id" />
									</xsl:variable>

									<xsl:variable name="tran_date">
										<xsl:value-of select="tran_date" />
									</xsl:variable>

									<xsl:variable name="sales_pers">
										<xsl:value-of select="sales_pers" />
									</xsl:variable>

									<xsl:variable name="emp_name">
										<xsl:value-of select="emp_name" />
									</xsl:variable>

									<xsl:variable name="strg_code">
										<xsl:value-of select="strg_code" />
									</xsl:variable>

									<xsl:variable name="wholesaler_name">
										<xsl:value-of select="wholesaler_name" />
									</xsl:variable>

									<xsl:variable name="mobile_no">
										<xsl:value-of select="mobile_no" />
									</xsl:variable>

									<xsl:variable name="confirmed">
										<xsl:value-of select="confirmed" />
									</xsl:variable>
									
									<xsl:variable name="distributor_name">
										<xsl:value-of select="distributor_name" />
									</xsl:variable>
									
									<xsl:variable name="wf_remarks">
										<xsl:value-of select="wf_remarks" />
									</xsl:variable>
									
									<xsl:variable name="emp_code__aprv">
										<xsl:value-of select="emp_code__aprv" />
									</xsl:variable>
									
									<xsl:variable name="descr">
										<xsl:value-of select="descr" />
									</xsl:variable>
									
									<xsl:variable name="eff_from">
										<xsl:value-of select="eff_from" />
									</xsl:variable>
									
									<xsl:variable name="valid_upto">
										<xsl:value-of select="valid_upto" />
									</xsl:variable>
									
									<xsl:variable name="last_claim_date">
										<xsl:value-of select="last_claim_date" />
									</xsl:variable>
									
									<xsl:variable name="payout_date">
										<xsl:value-of select="payout_date" />
									</xsl:variable>
									
									<xsl:variable name="beat">
										<xsl:value-of select="beat" />
									</xsl:variable>
									
									<xsl:variable name="sh_descr">
										<xsl:value-of select="sh_descr" />
									</xsl:variable>
									
									<xsl:variable name="class_code_descr">
										<xsl:value-of select="class_code_descr" />
									</xsl:variable>
									
									<xsl:variable name="period">
										<xsl:value-of select="$eff_from" /> to <xsl:value-of select="$valid_upto" />
									</xsl:variable>
									
									<xsl:variable name="remarks">
										<xsl:value-of select="remarks" />
									</xsl:variable>
									
				<input type="hidden" value="{$dbIDHeader}" name="Detail1.{normalize-space($domIDHeader)}.dbID" id="Detail1.{normalize-space($domIDHeader)}.dbID" />
				<input type="hidden" value="{$objNameHeader}" name="Detail1.{normalize-space($domIDHeader)}.objName" id="Detail1.{normalize-space($domIDHeader)}.objName" />
				<input type="hidden" value="{$pkNamesHeader}" name="Detail1.{normalize-space($domIDHeader)}.pkNames" id="Detail1.{normalize-space($domIDHeader)}.pkNames" />
				<input type="hidden" value="{$updateFlagHeader}" name="Detail1.{normalize-space($domIDHeader)}.updateFlag" id="Detail1.{normalize-space($domIDHeader)}.updateFlag" />
				<input type="hidden" value="{$updateFlagHeader}" name="updateFlag" id="Detail1.{normalize-space($domIDHeader)}.updateFlag" />
				<input type="hidden" value="{$objNameHeader}" name="OBJ_NAME" id="OBJ_NAME" />
				<input type="hidden" value="{$dbIDHeader}" name="pkValues" id="pkValues" />
				<input type="hidden" value="{$editFlag}" name="Detail1.{normalize-space($domIDHeader)}.editFlag" id="Detail1.{normalize-space($domIDHeader)}.editFlag" />
				<input type="hidden" value="{$editFlag1}" name="Detail1.{normalize-space($domIDHeader)}.editFlag" id="Detail1.{normalize-space($domIDHeader)}.editFlag" />
				<div style="overflow:auto;" id="mainDiv">
				
				<table id="headerTable" style="height:100%; font-size :12px;color:black; overflow:auto; background:#FFF; padding: 5px 0; padding:0px;" cellspacing="0" cellpadding="0" border="0" align="center" class="question1">
				
 				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.tran_id" name="Detail1.{normalize-space($domIDHeader)}.tran_id" value="{$tran_id}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.tran_date" name="Detail1.{normalize-space($domIDHeader)}.tran_date" value="{$tran_date}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
				<input type="hidden" id="Detail1.{normalize-space($domIDHeader)}.emp_code__aprv" name="Detail1.{normalize-space($domIDHeader)}.emp_code__aprv" value="{$emp_code__aprv}" ispopup="true" class="headerInputField"  isServerCallOnChange="true"  size="12"    tabindex="65" required="true" />
																							
					<div class="section_column">
					
					<!-- <h6 class="heading"> Wholesaler details</h6> -->
					<div class="row_section cotainer" id="row_section1" >
 						<div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.sales_pers" name="Detail1.{normalize-space($domIDHeader)}.sales_pers"  value="{$sales_pers}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.sales_pers')" tabindex="0" required="true"    />
                                 <label class="active">Employee Code</label>
                                 </div>
                              </div>
                           </div>
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.emp_name" name="Detail1.{normalize-space($domIDHeader)}.emp_name"  value="{$emp_name}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.emp_name')" tabindex="0" required="true"    />
                                 <label class="active">Employee Name</label>
                                 </div>
                              </div>
                           </div>	
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.strg_code" name="Detail1.{normalize-space($domIDHeader)}.strg_code"  value="{$strg_code}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.strg_code')" tabindex="0" required="true"    />
                                 <label class="active">Wholesaler Id</label>
                                 </div>
                              </div>
                           </div>	
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.wholesaler_name" name="Detail1.{normalize-space($domIDHeader)}.wholesaler_name"  value="{$wholesaler_name}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.wholesaler_name')" tabindex="0" required="true"    />
                                 <label class="active">Wholesaler Name</label>
                                 </div>
                              </div>
                           </div>
                           <xsl:if test="($mobile_no != '') ">	
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.mobile_no" name="Detail1.{normalize-space($domIDHeader)}.mobile_no"  value="{$mobile_no}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.mobile_no')" tabindex="0" required="true"    />
                                 <label class="active">Phone No</label>
                                 </div>
                              </div>
                           </div>
                           </xsl:if>
                           <xsl:if test="($sh_descr != '') ">
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.sh_descr" name="Detail1.{normalize-space($domIDHeader)}.sh_descr"  value="{$sh_descr}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.sh_descr')" tabindex="0" required="true"    />
                                 <label class="active">Customet Type</label>
                                 </div>
                              </div>
                           </div>
                           </xsl:if>
                           <xsl:if test="($class_code_descr != '') ">
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.class_code_descr" name="Detail1.{normalize-space($domIDHeader)}.class_code_descr"  value="{$class_code_descr}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.class_code_descr')" tabindex="0" required="true"    />
                                 <label class="active">Class</label>
                                 </div>
                              </div>
                           </div>
                           </xsl:if>
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.beat" name="Detail1.{normalize-space($domIDHeader)}.beat"  value="{$beat}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.beat')" tabindex="0" required="true"    />
                                 <label class="active">Beat</label>
                                 </div>
                              </div>
                           </div>
 							<div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.distributor_name" name="Detail1.{normalize-space($domIDHeader)}.distributor_name"  value="{$distributor_name}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.distributor_name')" tabindex="0" required="true"    />
                                 <label class="active">Distributor</label>
                                 </div>
                              </div>
                           </div>
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.descr" name="Detail1.{normalize-space($domIDHeader)}.descr"  value="{$descr}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.descr')" tabindex="0" required="true"    />
                                 <label class="active">Scheme</label>
                                 </div>
                              </div>
                           </div>
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.period" name="Detail1.{normalize-space($domIDHeader)}.period"  value="{$period}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.period')" tabindex="0" required="true"    />
                                 <label class="active">Period</label>
                                 </div>
                              </div>
                           </div>	
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.last_claim_date" name="Detail1.{normalize-space($domIDHeader)}.last_claim_date"  value="{$last_claim_date}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.last_claim_date')" tabindex="0" required="true"    />
                                 <label class="active">Last Claim Date</label>
                                 </div>
                              </div>
                           </div>	
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <input disabled="true" type="text" id="Detail1.{normalize-space($domIDHeader)}.payout_date" name="Detail1.{normalize-space($domIDHeader)}.payout_date"  value="{$payout_date}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.payout_date')" tabindex="0" required="true"    />
                                 <label class="active">Payout Date</label>
                                 </div>
                              </div>
                           </div>
                           <div class="field_row1">
                              <div class="inputfield">
                                 <div class="styled-input">
                                 <!-- <input style = "border-bottom: 1px solid #dadada;" type="text" id="Detail1.{normalize-space($domIDHeader)}.remarks" name="Detail1.{normalize-space($domIDHeader)}.remarks"  value="{$remarks}" ispopup="true" maxlength="100"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.remarks')" tabindex="0" required="true"    /> -->
                                 <textarea  disabled="true" style = "border-bottom: 1px solid #dadada;" type="text" id="Detail1.{normalize-space($domIDHeader)}.remarks" name="Detail1.{normalize-space($domIDHeader)}.remarks"  value="{$remarks}" ispopup="true" maxlength="120"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12" tabindex="0" required="true"  ><xsl:value-of select="$remarks"/></textarea>
                                 <label class="active">General Remarks</label>
                                 </div>
                              </div>
                           </div>
                           <div class="field_row1">
                              <div class="inputfield">
                                 <!--<input type="text" id="Detail1.{normalize-space($domIDHeader)}.confirmed" name="Detail1.{normalize-space($domIDHeader)}.confirmed"  value="{$confirmed}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.confirmed')" tabindex="0" required="true"    /> -->
								<label class="active" style="color: #666666;font-size: 12px;">Status </label><br></br>
								<select id="Detail1.{normalize-space($domIDHeader)}.confirmed" name="Detail1.{normalize-space($domIDHeader)}.confirmed"  value="{$confirmed}" disabled="true" >
								   <!--  <option value="Y">Approve</option>
								    <option value="R">Reject</option> -->
								    <option> <xsl:choose>
								    <xsl:when  test="$confirmed = 'Y'">Approved</xsl:when>
								    <xsl:when  test="$confirmed = 'R'">Rejected</xsl:when>
								    <xsl:otherwise>Pending</xsl:otherwise>
								    </xsl:choose>
								    </option>
								  </select>
                              </div>
                           </div>
                           <xsl:if  test="$confirmed = 'R'">
							 <div class="field_row1">
                              <div class="inputfield">
                                 <label class="active" style="color: #666666;font-size: 12px;">Reason</label><br></br>
                                 <!--<input type="text" id="Detail1.{normalize-space($domIDHeader)}.wf_remarks" name="Detail1.{normalize-space($domIDHeader)}.wf_remarks"  value="{$wf_remarks}" ispopup="true" maxlength="25"  onkeydown="return onKeyDownFun(this,event)" isServerCallOnChange="true" onblur="return onBlurFunction(this)" size="12"  onkeyup="upperCase('Detail1.{normalize-space($domIDHeader)}.wf_remarks')" tabindex="0" required="true"    /> -->
								 <select id="Detail1.{normalize-space($domIDHeader)}.wf_remarks" name="Detail1.{normalize-space($domIDHeader)}.wf_remarks"  value="{$wf_remarks}" disabled="true" >
									<option><xsl:value-of select="$wf_remarks" /></option>
								    <!-- <option>Amount is more than actual</option>
								    <option>Bill not loaded/attached</option>
									<option>Continuation bill not uploaded</option>
								    <option>Image not clear</option>
									<option>Same invoice uploaded twice</option>
								    <option>Wholesaler name is not correct</option>
								    <option>Invoice number is not correct</option>
								    <option>Distributor name is not correct</option>-->
								    </select>
                              </div>
                           </div>
                           </xsl:if>	
                        </div>
                        
					</div>
					<xsl:if test="normalize-space($invoice_count) > '0'">
							<h6 class="heading"> Invoice details</h6>
					<div style="height:0%;float:left;width : 99%">
												<div
													style="height:100%; overflow-x: auto;overflow-y : auto;margin-left: 10px;margin-top: 5px;">
													<table id="detailInvoiceTable" cellpadding="0"
														cellspacing="0" border="0" class="mt" style="width : 100%">
														<thead class="table-head">
															<tr class="thClass"
																style="border-bottom:#ccc solid 1px; border-bottom-width:2px;">


																<!-- <th style="font-size :14px;" class="thClass">Line No</th> -->
																<th style="font-size :14px;padding-left: 8px;" class="thClass"
																	align="left">Invoice Number</th>
																<th style="font-size :14px;padding-left: 8px;" class="thClass"
																	align="left">Invoice Date</th>
																<th style="font-size :14px;padding-left: 8px;" class="thClass"
																	align="left">Invoice Value</th>
																<th style="font-size :14px;padding-left: 8px;" class="thClass"
																	align="left">Invoice Approve</th>
																<th style="font-size :14px;padding-left: 8px;" class="thClass"
																	align="left">View Invoice</th>

															</tr>
														</thead>
														<tbody class='table-body fadeInDown'>

															<xsl:for-each select="//Detail2">

																<xsl:variable name="line_no">
																	<xsl:value-of select="line_no" />
																</xsl:variable>

																<xsl:variable name="domIDDetail">
																	<xsl:value-of select="@domID" />
																</xsl:variable>
																<xsl:variable name="updateFlagDetail">
																	<xsl:value-of
																		select="attribute/@updateFlag" />
																</xsl:variable>
																<xsl:variable name="statusDetail">
																	<xsl:value-of select="attribute/@status" />
																</xsl:variable>
																<xsl:variable name="dbIDDetail">
																	<xsl:value-of select="@dbID" />
																</xsl:variable>
																<xsl:variable name="pkNamesDetail">
																	<xsl:value-of select="attribute/@pkNames" />
																</xsl:variable>
																<xsl:variable name="objNameDetail">
																	<xsl:value-of select="@objName" />
																</xsl:variable>

																<xsl:variable name="invoice_id">
																	<xsl:value-of select="invoice_id" />
																</xsl:variable>
																<xsl:variable name="inv_date">
																	<xsl:value-of select="inv_date" />
																</xsl:variable>
																<xsl:variable name="inv_amt">
																	<xsl:value-of select="inv_amt" />
																</xsl:variable>
																<xsl:variable name="aprv_amt">
																	<xsl:value-of select="aprv_amt" />
																</xsl:variable>
																<xsl:variable name="image_id">
																	<xsl:value-of select="image_id" />
																</xsl:variable>
																<xsl:variable name="tran_id">
																	<xsl:value-of select="tran_id" />
																</xsl:variable>

																<tr class="tdClass" style="text-align:center">

																	<input type="hidden" value="{$dbIDDetail}"
																		name="Detail2.{normalize-space($domIDDetail)}.dbID"
																		id="Detail2.{normalize-space($domIDDetail)}.dbID" />
																	<input type="hidden" value="{$objNameDetail}"
																		name="Detail2.{normalize-space($domIDDetail)}.objName"
																		id="Detail2.{normalize-space($domIDDetail)}.objName" />
																	<input type="hidden" value="{$pkNamesDetail}"
																		name="Detail2.{normalize-space($domIDDetail)}.pkNames"
																		id="Detail2.{normalize-space($domIDDetail)}.pkNames" />
																	<input type="hidden" value="{$statusDetail}"
																		name="Detail2.{normalize-space($domIDDetail)}.status"
																		id="Detail2.{normalize-space($domIDDetail)}.status" />
																	<input type="hidden" value="{$updateFlagDetail}"
																		name="Detail2.{normalize-space($domIDDetail)}.updateFlag"
																		id="Detail2.{normalize-space($domIDDetail)}.updateFlag" />
																	<input type="hidden" value="{$objNameDetail}"
																		name="OBJ_NAME" id="OBJ_NAME" />
																	<input type="hidden" value="{$dbIDDetail}"
																		name="pkValues" id="pkValues" />

																	<input type="hidden"
																		name="Detail2.{normalize-space($domIDDetail)}.tran_id"
																		id="Detail2.{normalize-space($domIDDetail)}.tran_id"
																		value="{$tran_id}" />

																	<!-- <td style="width:10%"><xsl:value-of select="line_no" 
																		/><input type="hidden" id="Detail2.{normalize-space($domIDDetail)}.line_no" 
																		name="Detail2.{normalize-space($domIDDetail)}.line_no" value="{$line_no}" 
																		class="InputField" size="6%" style="width:90%; text-align:right " readonly="readonly" 
																		tabindex="-1"/></td> -->

																	<td style="width:20%">

																		<input type="text"
																			id="Detail2.{normalize-space($domIDDetail)}.invoice_id"
																			name="Detail2.{normalize-space($domIDDetail)}.invoice_id"
																			value="{$invoice_id}" class="InputField" size="6%"
																			style="width:90%; padding: 0; color: #666;" readonly="readonly" tabindex="-1" />
																	</td>
																	<td style="width:20%">

																		<input type="text"
																			id="Detail2.{normalize-space($domIDDetail)}.inv_date"
																			name="Detail2.{normalize-space($domIDDetail)}.inv_date"
																			value="{$inv_date}" class="InputField" size="6%"
																			style="width:90%; padding: 0; color: #666;" readonly="readonly" tabindex="-1" />
																	</td>
																	<td style="width:20%">

																		<input type="text"
																			id="Detail2.{normalize-space($domIDDetail)}.inv_amt"
																			name="Detail2.{normalize-space($domIDDetail)}.inv_amt"
																			value="{$inv_amt}" class="InputField" size="6%"
																			style="width:90%; padding: 0;text-align: right; color: #666;" readonly="readonly" tabindex="-1" />
																	</td>
																	<td style="width:20%">

																		<input type="text"
																			id="Detail2.{normalize-space($domIDDetail)}.aprv_amt"
																			name="Detail2.{normalize-space($domIDDetail)}.aprv_amt"
																			value="{$aprv_amt}" class="InputField" size="6%"
																			style="width:90%; padding: 0;text-align: right; color: #666;" readonly="readonly" tabindex="-1" />
																	</td>
																	<td class="cellttl1" width="100%" >

																		<div
																			id="__attachmentDiv.{normalize-space($image_id)}"></div>
																		<img src="_"
																			onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($image_id)}', 'retail_sch_claim', 'R-SCHC', '{normalize-space($image_id)}', true, '30px','30px'); this.remove();" />

																	</td>

																</tr>
															</xsl:for-each>

														</tbody>
													</table>
												</div>

											</div>
											</xsl:if>
					<xsl:if test="normalize-space($item_count) > '0'">
					<h6 class="heading"> Item details</h6>
							<!-- <div style="height:0%;float:left;width : 99%">
												<div
													style="height:100%; overflow-x: auto;overflow-y : auto;margin-left: 10px;margin-top: 5px;"> -->
													<table id="detailTable" cellpadding="0"
														cellspacing="0" border="0" class="mt" style="width : 100%">
														<thead class="table-head">
															<tr class="thClass"
																style="border-bottom:#ccc solid 1px; border-bottom-width:2px;">

																<th style="font-size :14px;padding-left: 8px;text-align: left;" class="thClass"
																	align="left">Item</th>
																<th style="font-size :14px;padding-left: 8px;text-align: right;" class="thClass"
																	align="left">Quantity</th>
															</tr>
														</thead>
														<tbody class='table-body fadeInDown'>

															<xsl:for-each select="//Detail3">

																<xsl:variable name="line_no">
																	<xsl:value-of select="line_no" />
																</xsl:variable>

																<xsl:variable name="domIDDetail">
																	<xsl:value-of select="@domID" />
																</xsl:variable>
																<xsl:variable name="updateFlagDetail">
																	<xsl:value-of
																		select="attribute/@updateFlag" />
																</xsl:variable>
																<xsl:variable name="statusDetail">
																	<xsl:value-of select="attribute/@status" />
																</xsl:variable>
																<xsl:variable name="dbIDDetail">
																	<xsl:value-of select="@dbID" />
																</xsl:variable>
																<xsl:variable name="pkNamesDetail">
																	<xsl:value-of select="attribute/@pkNames" />
																</xsl:variable>
																<xsl:variable name="objNameDetail">
																	<xsl:value-of select="@objName" />
																</xsl:variable>

																<xsl:variable name="item_code">
																	<xsl:value-of select="item_code" />
																</xsl:variable>
																<xsl:variable name="quantity">
																	<xsl:value-of select="quantity" />
																</xsl:variable>
																<xsl:variable name="remarks">
																	<xsl:value-of select="remarks" />
																</xsl:variable>
																<xsl:variable name="descr">
																	<xsl:value-of select="descr" />
																</xsl:variable>
																<xsl:variable name="tran_id">
																	<xsl:value-of select="tran_id" />
																</xsl:variable>

																<tr class="tdClass" style="text-align:center">

																	<input type="hidden" value="{$dbIDDetail}"
																		name="Detail3.{normalize-space($domIDDetail)}.dbID"
																		id="Detail3.{normalize-space($domIDDetail)}.dbID" />
																	<input type="hidden" value="{$objNameDetail}"
																		name="Detail3.{normalize-space($domIDDetail)}.objName"
																		id="Detail3.{normalize-space($domIDDetail)}.objName" />
																	<input type="hidden" value="{$pkNamesDetail}"
																		name="Detail3.{normalize-space($domIDDetail)}.pkNames"
																		id="Detail3.{normalize-space($domIDDetail)}.pkNames" />
																	<input type="hidden" value="{$statusDetail}"
																		name="Detail3.{normalize-space($domIDDetail)}.status"
																		id="Detail3.{normalize-space($domIDDetail)}.status" />
																	<input type="hidden" value="{$updateFlagDetail}"
																		name="Detail3.{normalize-space($domIDDetail)}.updateFlag"
																		id="Detail3.{normalize-space($domIDDetail)}.updateFlag" />
																	<input type="hidden" value="{$objNameDetail}"
																		name="OBJ_NAME" id="OBJ_NAME" />
																	<input type="hidden" value="{$dbIDDetail}"
																		name="pkValues" id="pkValues" />

																	<input type="hidden"
																		name="Detail3.{normalize-space($domIDDetail)}.tran_id"
																		id="Detail3.{normalize-space($domIDDetail)}.tran_id"
																		value="{$tran_id}" />

																	<td style="width:20%">

																		<input type="text"
																			id="Detail3.{normalize-space($domIDDetail)}.descr"
																			name="Detail3.{normalize-space($domIDDetail)}.descr"
																			value="{$descr}" class="InputField" size="6%"
																			style="width:100%; padding: 4px; color: #666;text-align: left;" readonly="readonly" tabindex="-1" />
																	</td>
																	<td style="width:20%">

																		<input type="text"
																			id="Detail3.{normalize-space($domIDDetail)}.quantity"
																			name="Detail3.{normalize-space($domIDDetail)}.quantity"
																			value="{$quantity}" class="InputField" size="6%"
																			style="width:100%; padding: 4px;text-align: right; color: #666;" readonly="readonly" tabindex="-1" />
																	</td>
																	
																</tr>
															</xsl:for-each>

														</tbody>
													</table>
												<!-- </div>

											</div> -->
					 </xsl:if>
		</table>
 </div>
                                    
		<table id="detailTableDelete" class="deleteRowTable"></table>
</table>
</div>
		<div class="fieldSuggestionDiv" style="display:none" id="fieldSuggestionDiv"></div>
</div>
</form>
					
		<table class="detail3Table" id="detail3Table"></table> 
		<table class="detail3Table" id="detail3Table"></table> 
					
</body>
</xsl:for-each>

		</html>
	</xsl:template>
</xsl:stylesheet>
