<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}

					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color:white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:white;}
					p {font-size:
					12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}



                    /* Added by Jatin M for New Summary Changes for Show Status/DAR on 15/03/2021  - Start */
                    *{
                        margin:0;
                        padding:0;
                        box-sizing: border-box;
                    }
                    .textcolor{
                        color:#969696 !Important;
                        font-weight: 500;
                    }
                    .text-rowgroup-1{
                        color: #969696!Important;
                        font-weight: 600;
                    }
                    .horizontal-border {
                        margin: 0 16px;
                        border-bottom: 1px solid #eeeeee;
                    }

                    .text-rowgroup-2{
                        font-size: 16px;
                        font-weight: 600;
                        color: #000;
                        text-align: center;
                    }
                    .text-rowgroup-3{
                        font-size: 18px;
                        font-weight: 600;
                        padding: 8px 0 0 0;
                        color: #000;
                    }
                    .activity-descr-text{
                        display: flex;
                        justify-content: center;
                        align-items: center;
                    }
                    .mainiconradius{
                        width: 24px;
                        height: 24px;
                        margin: 0 10px;
                    }
                    .addspace{
                        text-align: left;
                        margin: 0 0 0 10px;
                    }
                    .stickysubforms{
                        position: sticky;
                        display: table;
                        -webkit-overflow-scrolling: touch;
                    }
                    .timeline::before {
                        content: '';
                        position: absolute;
                        height: 22px;
                        width: 1px;
                        background-color: #000;
                        left: 32px;
                        transform: translateY(-118%);
                        /*transform: translate(100%,-100%);*/
                    }
                    .timeline:first-child::before{
                        width: 0;
                    }

                    .customerDiv{
                        display: flex;
                        padding: 0 16px;
                        align-items: center;
                        margin-bottom: 16px;
                    }
                    .customerDiv:last-child{
                        margin: 0;
                    }
                    .large-font{
                        font-size: 14px;
                    }
                    .small-font{
                        font-size: 12px;
                        color: #666;
                    }

                    .promotionDiv {
                        padding: 0 16px 4px 16px;
                        display: flex;
                        align-items: center;
                    }

                    .travelIcon{
                        height: 20px;
                        width: 20px;
                        border-radius: 100%
                    }
                    .donebutton{
                        border-radius: 100%;
                        height: 20px;
                        width: 20px;
                        margin: 0 32px;
                    }
                    .places_visited{
                        height: 20px;
                        width: 20px;
                    }
                    .divToLeft {
                        text-align: left;
                    }

                    .hideoverflow{
                        overflow: hidden;
                        text-overflow: ellipsis;
                        -webkit-line-clamp: 2;
                        display: -webkit-box;
                        -webkit-box-orient: vertical;
                        height: 35px;
                    }

                    .hideoverflowfeed{
                        overflow: hidden;
                        text-overflow: ellipsis;
                        -webkit-line-clamp: 1;
                        -webkit-box-orient: vertical;
                        height: 20px;
                        min-width: 50px;
                        line-height: 24px;
                    }

                    .povminwidth{
                        min-width: 150px;
                    }

                    .mainbody{
                        background: #f5f5f5;
                        margin: auto;
                        width: calc(100% - 32px);
                        font-family: sans-serif !important;
                        font-weight: 500 !important;
                        margin-bottom: 0;
                    }

                    .datafontsize{
                        font-size:14px !Important;
                        color: #000;
                    }
                    .headerfontsize{
                        font-size:12px !Important;
                        color:#969696 !Important;
                    }
                    .bradius{
                        border-radius: 100px;
                        height: 30px;
                        width: 30px;
                    }

                    .subformradius{
                        height: 30px;
                        width: 30px;
                    }

                    .collapsibleIconRadius{
                        border-radius: 100px;
                        height: 30px;
                        width: 30px;
                    }
                    .imgradius{
                        border-radius: 100px;
                        height: 80px;
                        width: 80px;
                    }

                           
                    .headerdata{
                        display: flex;
                        align-items: center;
                        white-space: nowrap;
                         height: 40px;
                        margin: 0;
                        font-size: 12px;
                        padding: 0 12px;
                        color: #000;
                        cursor: pointer;
                    }  

                    .rightcol-spacing{
                        margin-inline-start: auto;
                        text-align: right;
                        font-size: 12px;
                        align-self: baseline;
                        /*white-space: nowrap;*/
                        overflow-wrap: break-word;
                        justify-content: flex-end;
                    }

                    .containerfeed{
                        padding: 12px 0;
                        margin: 4px 0;
                        /*height: auto;*/
                        border-radius: 12px;
                        background-color: #fff;
                        overflow: hidden;
                    }
                        
                    .main-icon{
                        display: block; 
                        text-align:center;
                    }

                    .submitdate{
                        font-size:12px;
                        font-weight: 600;
                        padding: 8px 0 0 0;
                        font-weight: 600px;
                        color: #000;
                    }

                    .align-imgtext{
                        float:left;
                        text-align:right;
                    }

                    .single-colDiv{
                        display: inline-flex;
                        align-items: center;
                        text-align: left;
                        justify-content: center;
                        margin: 0 auto;
                        padding: 0 16px;
                        width: 100%;
                        height: 100px;
                        min-height: 100px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                    }

                    .columnsDiv {
                        display: flex;
                        align-items: center;
                        width: 100%;
                        height: 52px;
                        min-height: 52px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                        /* border: 1px solid #e2e2e2; */
                        /* border-radius: 12px;*/
                    }

                    .btnborder{
                        height: 24px;
                        width: 24px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        background-color: #f5f5f5;
                        border-radius: 28px;
                    }

                    .visitdetails{
                        color: #969696;
                        display: flex;
                        padding: 0px;
                        height: 25px;
                    }
                    .tab{
                        margin-inline-start: auto;
                        cursor: pointer;
                    }
                    .tablinks{
                        border:none;
                        outline:none;
                        background: none;
                    }

                    .svgcolor{
                        background-color: #faaa1f;
                        width: 14px;
                        height: 14px;
                        border-radius: 100%;
                    }

                    .tab button:active {
                        border: none;
                        outline: none;
                        box-shadow: none;
                    }
                    .confstatus{
                        display: flex;
                        align-items: center;
                        border-radius: 50%;
                        font-size:12px;
                    }
                    
                    .customername_doc{
                        width: 10%;
                        min-width: 150px;
                        text-align: left;
                    }
                    .customernameDiv{
                        width: 15%;
                        min-width: 150px;
                        text-align: left;
                    }

                    .customertypesDiv {
                        width: 15%;
                        min-width: 150px;
                        text-align: left;
                        padding: 0 8px;
                    }
                    .eventtimestartDiv {
                        width: 10%;
                        min-width: 120px;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                    }
                    .visittimeDiv{
                        width: 20%;
                        min-width: 120px;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                    }
                    .pobvalueDiv{
                        width: 10%;
                        min-width: 100px;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                    }

                    .reg-no{
                        min-width: 125px;
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .euin-no{
                        min-width: 125px;
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .remarksDiv{
                        width: 15%;
                        min-width: 120px;
                        text-align: left;
                        padding: 0 8px;
                    }
                    .doclocalityDiv{
                        width: 10%;
                        MA
                        min-width: 120px;
                        text-align: right;
                        justify-content: flex-end;
                    }
                    .teamDiv{
                        width: 15%;
                        min-width: 120px;
                        text-align: left;
                        padding: 0 8px;
                    }
                    
                    .firstcolumn{
                        text-align: left !important;
                        padding: 0 8px 0 0;
                        left: 0;
                    }
                    .headingwidth{
                        border-bottom: 1px solid #0000001a;
                        white-space: nowrap;
                        display: flex;
                        align-items: flex-start;
                        height: 25px;
                        text-overflow: ellipsis;
                        overflow: hidden;
                        color: #969696 !important;
                        padding: 0 8px;
                        font-size: 12px;
                    }

                    .detailswidth{
                        padding: 0 8px;
                        white-space: normal;
                        height: 38px;
                        display:grid;
                        align-items: center;
                        color: #000;
                    }
                    
                    .seperatorDiv{
                        border-bottom: 1px solid #0000001a;
                    }

                    .lastcolumn{
                        justify-content: flex-end;
                        text-align: right !important;
                        padding: 0 0 0 8px;
                    }
                    .place_of_visit{
                        width:33.33%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .visited-with{
                        text-align: left;
                        width: 33.33%;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .order_of_visit{
                        text-align:right;
                        width:33.33%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .branddescr{
                        width: 50%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .pitchsequence{
                        text-align:right;
                        width: 50%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .itemusage{
                        width:33.33%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .itemdescr{
                        text-align: left;
                        width: 33.33%;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .quantitysample{
                        text-align:right;
                        width:33.33%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .displayarea{
                        width: 50%;
                        margin-bottom: 16px;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .displayplugin{
                        text-align: left;
                        height: auto;
                        overflow-x: scroll;
                        overflow-y: hidden;
                    }
                    .surveydescr{
                        width: 50%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .surveyresult{
                        text-align:right;
                        width: 50%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .travelmode{
                        text-align: left;
                        width:25%;
                        padding: 0 8px 0;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    #section-n2 {
                        display:none;
                    }

                    .emp-name{
                        width: 20%;
                        padding: 0 8px 0 0;
                        min-width: 150px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .placeofvisitmgr{
                        width: 20%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    
                    .travelmodemgr{
                        text-align: left;
                        width: 20%;
                        padding: 0 8px 0;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .orderofvisitmgr{
                        text-align:right;
                        width:20%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .left-spacing{
                        width: 25%;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                        display: flex;
                        align-items: center;
                    }

                    .center-left{
                        width: 25%;
                        text-align: left;
                        padding: 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .center-right{
                        width: 25%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                        min-width:120px;
                        overflow: hidden;
                    }

                    .right-spacing{
                        justify-content: flex-end;
                        text-align: right;
                        width: 25%;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .ordervalue{
                        width: 20%;
                        text-align: right;
                        padding: 0 8px 0;
                        min-width: 90px;
                        overflow: hidden;
                    }
                    
                    .schemedescription{
                        width: 20%;
                        text-align: left;
                        padding: 0 8px 0;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .bgcolorform{
                        background-color: #f5f5f5;
                    }

                    .customertypes_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    
                    .classdescr_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 100px;
                        overflow: hidden;
                    }

                    .spldescription_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 100px;
                        overflow: hidden;
                    }

                    .novisit_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 80px;
                        overflow: hidden;
                    }

                    .visittime_doc{
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 150px;
                        overflow: hidden;
                    }
                    .eventtimestart_doc{
                        width: 5%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .pobvalue_doc{
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 80px;
                        overflow: hidden;
                    }
                    .remarks_doc{
                        width: 15%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 100px;
                        overflow: hidden;
                    }
                    .team_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .doclocality_doc{
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .speciality{
                        min-width: 160px;
                        width: 10%;
                        text-align: left;
                    }

                    .class{
                        min-width: 90px;
                        width: 10%;
                        text-align: left;
                    }

                    .placeofwork{
                        width: 10%;
                        min-width: 120px;
                        text-align: left;
                    }
                    .visitplan{
                        min-width: 80px;
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .visitwith{
                        width: 10%;
                        min-width: 200px;
                        text-align: left;
                    }

                    .visittime{
                        width: 10%;
                        min-width: 100px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .pobvalue{
                        width: 10%;
                        min-width: 80px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .remarks{
                        width: 10%;
                        min-width: 150px;
                    }
                    .timeofcall{
                        width: 20%;
                        min-width: 140px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    
                    .pob-value{
                        width: 20%;
                        min-width: 80px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .unlistedremark{
                        width: 20%;
                        min-width: 150px;
                    }

                    .workplace{
                        width: 20%;
                        min-width: 120px;
                        text-align: left;
                    }


                    .visitsdetails{
                        display: flex;
                        align-items: center;
                        padding: 8px 0px;
                    }

                    .containertable{
                        padding: 0 16px;
                        margin: 12px 0;
                        border-radius: 12px;
                        background:#fff;
                        overflow-x: hidden;
                    }

                    .doctorcontainer{
                        padding: 8px 0;
                        margin: 8px 0 8px 0;
                        /*height: auto;*/
                        border-radius: 12px;
                        background-color: #fff; 
                        overflow-x: auto;
                        overflow-y: hidden;
                        /*width: calc(100% - 0px);*/
                        /*position: relative;*/
                    }
                    
                    .doctordetails{
                        display: flex;
                        padding: 0px;
                        white-space: initial;
                        /*width: 100%;*/
                        height: 25px;
                    }
                    .docdatadetails{
                        display: flex;
                        align-items: center;
                        padding: 0px;
                        height: 35px;
                        margin: 8px 0;
                    }

                    .sampleheading{
                        display:flex;
                        align-items:center;
                        padding: 8px 0;
                    }

                    .samplename{
                        display: flex;
                        align-items: center;
                        color: #969696;
                        padding: 0;
                        height: 25px;
                        border-bottom: 1px solid #0000001a;
                    }

                    .sampledata{
                        white-space: initial;
                        display: flex;
                        padding: 0;
                        margin: 8px 0;
                        height: 38px;
                        align-items: center;
                    }

                    .sampledetails{
                        background-color: #ededed;
                        padding: 16px;
                        /*width: 100%;*/
                        left: 0;
                        position: sticky;
                        position: -webkit-sticky;
                    }
                        
                    .routeicon{
                        margin-inline-start: auto;
                        background-color: #eeeeee;
                    }

                    .itemlabel {
                        margin-top: 16px;
                        padding: 0 40px;
                        height: 16px;
                        text-align: left;
                    }
                    .orderFormHeader {
                        display: flex;
                        margin-top: 16px;
                        padding: 0 16px;
                        align-items: center;
                        text-align: left;
                    }
                    .itemOuterDiv{
                        margin-top: 16px;
                    }
                  @media screen and (min-width:768px) {
                 .columnDiv
                    {
                    	column-count: 3;
                    	padding: 0 8px 8px 8px;
                    }
                   }
                   @media screen and (max-width:768px) {
                    .columnDiv
                    {
                    	column-count: 1;
                    	padding: 0 8px 8px 8px;
                    }
                    }

                    .imgicon{
                        width: 80px;
                        height: 80px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    .btniconborder{
                        height: 34px;
                        width: 34px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    .table_default_bg{
                        background-color: #e6f4ff;
                    }

                    .feed_default_bg{
                        background-color: #0273d0;
                    }

                    .iconborder{
                        min-height: 30px;
                        min-width: 30px;
                        max-width: 30px;
                        max-height: 30px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    .location-icon {
                        background-color: #98ccf4;
                    }

                    .lstdcrdate-icon {
                        background-color: #d5b3ff;
                    }
                    .remarks-icon {
                        background-color : #86e7d6;
                    }

                    .speciality-icon{
                        background-color: #91ecff;
                    } 

                    .class-icon{
                    background-color: #ffa7a7;
                    }

                    .visitplan-icon {
                        background-color: #f4a8ff;
                    }

                    .timeofcall-icon {
                        background-color: #ffb98e;
                    }

                    .visitedwith-icon {
                        background-color: #ccbdbd;
                    }

                    .pobvalue-icon {
                        background-color: #fbd607;
                    }

                    .regno-icon {
                        background-color: #ef5350;
                    }

                    .euin-icon {
                        background-color: #03a9f4;
                    }

                    .product-icon  {
                        background-color: #cacaca;
                    } 

                    .unlistedcust-icon{
                        background-color: #b2bbff;
                    }

                    .bluebg-icon{
                        background-color: #e6f4ff;
                    }

                    .redbg-icon{
                        background-color: #ffe8e9;
                    }

                    .connroute:before {
                        box-shadow: 1px 0 0 0 rgb(0 0 0 / 10%);
                    }
                    .connroute:first-child {
                        display: none;
                    }

                    .namespacing{
                        padding: 0 0 0 16px;
                        text-align: left;
                        line-height: 1.5;
                    }

                    .powfeedview{
                        overflow: hidden;
                        min-width: 50px;
                        white-space: normal;
                    }

                    button.rmvborder{
                        cursor: pointer;
                        border: none;
                        outline: none;
                        background-color: #f5f5f5;
                    }

                    button.rmborder{
                        cursor: pointer;
                        border: none;
                        outline: none;
                        background-color: #fff;
                    }

                    cust-col{
                        display: flex;
                        align-items: center;
                        text-align: left;
                        width: 100%;
                        height: 34px;
                        min-height: 34px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                    }

                    .btnpadding{
                        padding: 0 0 0 4px;
                    }

                    .tabs {
                        position: relative;
                        text-align: center;
                        background: #f5f5f5;
                        /*width: 100%;*/
                        border-radius: 5px;
                        min-width: 240px;
                        min-height: 500px;
                        overflow-x: auto;
                        overflow-y: hidden;
                        -webkit-overflow-scrolling: touch;
                    }
                    .tabs .uldiv {
                        list-style-type: none;
                        padding: 0 16px;
                        display: -webkit-box;
                        display: flex;
                        -webkit-box-orient: horizontal;
                        -webkit-box-direction: normal;
                                flex-direction: row;
                        margin-bottom: 4px;
                        -webkit-box-pack: justify;
                                justify-content: space-between;
                        -webkit-box-align: end;
                                align-items: center;
                        flex-wrap: wrap;
                        margin-top: 0;
                        width: 100%;
                    }

                    .rmv-Mrg{
                        margin: 0;
                    }

                    .unlistedcustmgn{
                        margin-top:0 !important;
                    }

                    .tabs .uldiv li {
                        box-sizing: border-box;
                        -webkit-box-flex: 1;
                        text-align: center;
                        margin-right: 0;
                    }
                    .lidiv{
                        padding: 0 0 0 16px;
                    }


                    .tabs .uldiv li label {
                        -webkit-transition: all 0.3s ease-in-out;
                        transition: all 0.3s ease-in-out;
                        padding: 5px auto;
                        overflow: hidden;
                        text-overflow: ellipsis;
                        display: block;
                        cursor: pointer;
                        -webkit-transition: all 0.2s ease-in-out;
                        transition: all 0.2s ease-in-out;
                        white-space: nowrap;
                        -webkit-touch-callout: none;
                        user-select: none;
                    }

                    .tabs .uldiv li label{
                        font-size: 18px;
                        color: #0273d0;
                    }


                    .tabs .uldiv li label:hover, .tabs .uldiv li label:focus, tabs .uldiv li label:active{
                        outline: 0;
                        color: #0273d0;
                    }

                    .tabs .slidertab {
                        position: relative;
                        width: calc(100% - 56px);
                        -webkit-transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                        transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                    }
                    .tabs .slidertab .indicator {
                        position: relative;
                        width: 16px;
                        max-width: 100%;
                        margin-inline-start: auto;
                        height: 4px;
                        background: #0273d0;
                        border-radius: 1px;
                    }

                    .tabs .data-content section {
                        -webkit-animation-name: data-content;
                                animation-name: data-content;
                        -webkit-animation-direction: normal;
                                animation-direction: normal;
                        -webkit-animation-duration: 0.3s;
                                animation-duration: 0.3s;
                        -webkit-animation-timing-function: ease-in-out;
                                animation-timing-function: ease-in-out;
                        -webkit-animation-iteration-count: 1;
                                animation-iteration-count: 1;
                        line-height: 1.4;
                    }

                    .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .uldiv > li:nth-child(1) > label {
                        cursor: default;
                        -webkit-transform: translateX(0%);
                                transform: translateX(0%);
                    }
                    .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                        -webkit-transform: translateX(0%);
                                transform: translateX(0%);
                    }

                    .tabs input[name="tab-control"] {
                        display: none;
                    }

                    @-webkit-keyframes data-content {
                        from {
                            opacity: 0;
                            -webkit-transform: translateY(5%);
                                    transform: translateY(5%);
                        }
                        to {
                            opacity: 1;
                            -webkit-transform: translateY(0%);
                                    transform: translateY(0%);
                        }
                    }
                    @keyframes data-content {
                        from {
                            opacity: 0;
                            -webkit-transform: translateY(5%);
                                    transform: translateY(5%);
                        }
                        to {
                            opacity: 1;
                            -webkit-transform: translateY(0%);
                                    transform: translateY(0%);
                        }
                    }
                    @media (max-width: 1000px) {
                        .tabs .uldiv li label {
                            white-space: initial;
                        }
                    }

                    .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .slidertab {
                        -webkit-transform: translateX(-18px);
                                transform: translateX(-18px);
                    }
                    /*.tabs input[name="tab-control"]:nth-of-type(1):checked ~ .data-content > section:nth-child(1) {
                        display: block;
                    }*/
                    .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .uldiv > li:nth-child(2) > label {
                        cursor: default;
                    }
                    
                    .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                        -webkit-transform: translateX(32px);
                                transform: translateX(32px);
                    }
                    /*.tabs input[name="tab-control"]:nth-of-type(2):checked ~ .data-content > section:nth-child(2) {
                        display: block;
                    }*/

                    .multi-colDiv{
                        text-align: left;
                        padding: 0 16px;
                        
                    }
                    @media screen and  (min-width:580px) {
                        .multi-colDiv{
                        }
                        .columnsDiv{
                        }
                    }

                    /* Added by Jatin M for New Summary Changes for Show Status/DAR on 15/03/2021  - End */

				</style>

				<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

				<script type="text/javascript" language="javascript">
<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }



]]>



				</script>

			</head>



			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.tdLeft
					{
					text-align: left;

					}
					.tdRight
					{
					text-align:
					right;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 400;
					font-size: 13px;
					color:
					black;
					padding-top: 7px;


					}
					.firstData
					{
					color:black;
					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%


					}
					.imageCenter
					{
					display: block;
					margin-left: auto;
					margin-right: auto;
					width: 50%;
					}
					.headerTableDCR {
					padding-left:8%;
					}
					@media only screen
					and
					(min-width: 100px) and
					(max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0" class="bgcolorform">
					<!--<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">-->
                    <div class="mainbody">

							<!-- <table id="travelTable" class="tTitleD" border="0" cellspacing="1"
								cellpadding="1" width="100%"> -->

							<!--<div class="headerTableDCR1">-->
                            

								<!--<table id="travelTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%">-->
                       
                        <!--</table>-->
                                                    <div class="containerfeed">
                        
                                                        <div class="text-rowgroup-2">
                                                        <xsl:for-each select="//Detail1">
									<xsl:variable name="status_mode">
										<xsl:value-of select="status_mode" />
									</xsl:variable>
									
									<xsl:variable name="status">
										<xsl:choose>
											<xsl:when test="$status_mode = 'S'">
												Submit
											</xsl:when>
											<xsl:when test="$status_mode = 'D'">
													Draft
											</xsl:when>
										</xsl:choose>
									</xsl:variable>
										
										
										
										<tr>
											
											<td class="firstData">
												<span CLASS="" style="width:auto;float: left;">
													<xsl:value-of select="sp_name" />
												</span>
											</td>
										</tr>
										<tr>
											
											
											
											
											<td class="firstData">
												<span CLASS="" style="width:auto;float: right;">
													<xsl:value-of select="$status" />
												</span>
											</td>
										</tr>
										
										
									</xsl:for-each>
									</div>
									</div>
								
								
								 <div class="headerdata datafontsize">
                            Customer  Details
                            <div class="tab">
                                <!-- <button type="button" class="rmvborder">
                                    <div class="btnborder align-imgtext">
                                        <IMG
                                            id="customer_details_btn" class="collapsibleIconRadius align-imgtext" 
                                            onclick="expandDetails('customer_details', 'customer_details_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                            <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                        </IMG>
                                    </div>
                                </button> -->
                            </div>
                        </div>
				
				
                        <div id="customer_details">
                            <div class="containerfeed">
								<xsl:for-each select="//Detail2">
							<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="sc_name">
										<xsl:value-of select="sc_name" />
									</xsl:variable>

									<xsl:variable name="descr">
										<xsl:value-of select="descr" />
									</xsl:variable>
									<xsl:variable name="retailer_name__o">
										<xsl:value-of select="retailer_name__o" />
									</xsl:variable>
									<xsl:variable name="retailer_name">
										<xsl:value-of select="retailer_name" />
									</xsl:variable>
									<xsl:variable name="retailer_mobno">
										<xsl:value-of select="retailer_mobno" />
									</xsl:variable>
									<xsl:variable name="retailer_mobno__o">
										<xsl:value-of select="retailer_mobno__o" />
									</xsl:variable>
									<xsl:variable name="retailer_adr1__o">
										<xsl:value-of select="retailer_adr1__o" />
									</xsl:variable>
									<xsl:variable name="retailer_adr2__o">
										<xsl:value-of select="retailer_adr2__o" />
									</xsl:variable>
									<xsl:variable name="retailer_adr3__o">
										<xsl:value-of select="retailer_adr3__o" />
									</xsl:variable>
									<xsl:variable name="retailer_adr1">
										<xsl:value-of select="retailer_adr1" />
									</xsl:variable>
									<xsl:variable name="retailer_adr2">
										<xsl:value-of select="retailer_adr2" />
									</xsl:variable>
									<xsl:variable name="retailer_adr3">
										<xsl:value-of select="retailer_adr3" />
									</xsl:variable>
									
									<xsl:variable name="host_url">
										<xsl:value-of select="host_url" />
									</xsl:variable>
									<xsl:variable name="sc_code">
										<xsl:value-of select="sc_code" />
									</xsl:variable>
									<xsl:variable name="new_address">
									<xsl:value-of select="concat($retailer_adr1__o,' ',$retailer_adr2__o,' ',$retailer_adr3__o)" />
									
									</xsl:variable>
									<xsl:variable name="old_address">
									<xsl:value-of select="concat($retailer_adr1,' ',$retailer_adr2,' ',$retailer_adr3)" />
									
									</xsl:variable>
									
									<xsl:call-template name="tmpOrder">
										<xsl:with-param name="orderFormName"
											select="concat($sc_name,'@',$descr,'#',$retailer_name__o,'(',$retailer_mobno__o,'*',$new_address,'!',$old_address,'|',$retailer_mobno,'@@',$host_url,'##',$sc_code,'**',$retailer_name)" />
									</xsl:call-template>
									</xsl:if>
								</xsl:for-each>
							 </div> 
							 </div>
								
									
									
                        
                        


                        
					</div>

				</form>
			</body>

		</html>
	</xsl:template>

    



			<!-- Changed by Pooja on 23/12/19 [coaching related implementation] START -->

                        
			<!-- Changed by Pooja on 23/12/19 [coaching related implementation] END -->

			
			<!-- Added by Pooja on 23/12/19 [coaching related implementation] END -->
			<!-- Added by sadique shaikh 23-01-2020 [to display people trained in summary page] Start -->
			
			<!-- Added by sadique shaikh 23-01-2020 [to display people trained in summary page] End -->
			<!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 START -->
			
            <!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 End -->
            <!-- Added by Sadique S. [ To display Other Details in summary page ] on 19-02-2020 Start -->
			
			 <!-- Added by Sadique S. [ To display Other Details in summary page ] on 19-02-2020 Start -->
			<!-- <xsl:if test="$remaining"> <xsl:call-template name="tmpSplitString">
				<xsl:with-param name="stringtosplit" select="$remaining" /> </xsl:call-template>
				</xsl:if> -->
	<xsl:template name="tmpOrder">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>

		
		<xsl:variable name="custoer_name">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="beat_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="retailer_name__o">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="retailer_mob_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="new_address">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'*'), '!')" />
		</xsl:variable>
		<xsl:variable name="old_address">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="old_mob_no">
			<xsl:value-of select="substring-before(substring-after($ord_value,'|'), '@@')" />

		</xsl:variable>
		<xsl:variable name="host_url">
			<xsl:value-of select="substring-before(substring-after($ord_value,'@@'), '##')" />
		</xsl:variable>
		<xsl:variable name="sc_code">
			<xsl:value-of select="substring-before(substring-after($ord_value,'##'), '**')" />

		</xsl:variable>
		<xsl:variable name="retailer_name">
			<xsl:value-of select="substring-after($ord_value,'**')" />

		</xsl:variable>
<div style="padding: 8px 0;box-shadow: 0px 1px 0px 0px rgba(0,0,0,.1);">
                    <div class="customerDiv">
                        <div class="iconborder bluebg-icon">
                            <IMG
                                SRC="{normalize-space($host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($sc_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($custoer_name)}"
                                onerror='this.src="images/map/user.png"'
                                class="bradius align-imgtext">
                            </IMG>
                                <!--style=" padding: 5px; height: 30px; width: 30px; border-radius: 50%;"-->
                            
                        </div>
                    
									<!--<div style="width: calc(100% - 40px); float: right;">
										<div>-->
											<!--<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;">-->
                        <div class="addspace large-font">
                            <div class="datafontsize">
                                <xsl:value-of
                                    select="$custoer_name" />
							</div>
                            <div class="small-font" style="display: flex;align-items: center;line-height: 16px;">
                          <svg xmlns="http://www.w3.org/2000/svg" width="256" height="256" viewBox="0 0 256 256" style="height: 10px;width: 10px;margin: 0 3px 0 0;">
  <defs>
    <style>
      .cls-1 {
        fill: #ff8871;
        fill-rule: evenodd;
      }
    </style>
  </defs>
  <path id="Location_2" data-name="Location 2" class="cls-1" d="M128.3,8.01c-50.612,0-91.785,40.442-91.785,90.146,0,66.5,84.684,145.548,88.29,148.884a5.176,5.176,0,0,0,6.992,0c3.6-3.336,88.288-82.38,88.288-148.884C220.082,48.452,178.911,8.01,128.3,8.01Zm0,140.227c-28.114,0-50.992-22.468-50.992-50.081S100.183,48.075,128.3,48.075s50.992,22.468,50.992,50.081S156.413,148.237,128.3,148.237Z"></path>
</svg>
                                <xsl:value-of select="$beat_name" />
                            </div>
                        </div>
                    </div>
<div style="padding: 0 16px;font-size: 12px;color: #666;text-align: left;">Proprietor Details</div>
<div class="columnDiv">
<div style="color: gray;text-align: left;padding: 8px;"><div style="font-size: 12px;color: #666;">Name:</div>
<div style="font-size: 14px;">
<xsl:if test="normalize-space($retailer_name__o) != normalize-space($retailer_name)">
<span style="text-decoration:line-through;"><xsl:value-of select="$retailer_name" /></span>
<br></br>
</xsl:if>
<span><xsl:value-of select="$retailer_name__o" /></span>
</div></div>
<div style="color: gray;text-align: left;padding: 8px;"><div style="font-size: 12px;color: #666;">Mobile No.</div>
<div style="font-size: 14px;">
<xsl:if test="normalize-space($old_mob_no) != normalize-space($retailer_mob_no)">
<span style="text-decoration:line-through;"><xsl:value-of select="$old_mob_no" /></span>
<br></br>
</xsl:if> 
 <span>
<xsl:value-of select="$retailer_mob_no" />

 </span> 
</div></div>
<div style="color: gray;text-align: left;padding: 8px;">
<div style="font-size: 12px;color: #666;">Address</div>
<div style="font-size: 14px;">
<xsl:if test="normalize-space($new_address) != normalize-space($old_address)">

<span style="text-decoration:line-through;"><xsl:value-of select="$old_address" /></span>
<br></br>
</xsl:if>
<span><xsl:value-of select="$new_address" /></span>


</div></div>

</div>
</div>

				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
			
	</xsl:template>

	


	
	<!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 END -->
</xsl:stylesheet>