<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/Standard/summarydefault.css" />

				<title>Details</title>
				<style>
					body {font-family: Arial, Helvetica, sans-serif;}
					a {color: #C00;}
					details { border-bottom: #e5e4e9 1px solid; /*border-radius: 5px;
					box-shadow: 0 1px 4px rgba(0, 0, 0, .4);*/ color: #363636;
					/*margin: 0 0 .4em;*/ padding: 1%; }
					details[open] {background:
					#fff;}

					summary {background: #fff; cursor: pointer; font-size: 12px;
					font-weight:
					normal; margin: -1%; padding: 8px; position: relative;
					border:0
					none; outline:none; }
					summary:hover, details[open] summary
					{background: #fff;}
					summary::-webkit-details-marker {display: none}
					summary:before{/*border-radius: 5px; */content: "+"; color:white;
					display: block; float: right; font-size: 16px; font-weight: normal;
					/*margin: -2px 10px 0 10px;*/ padding: 0; text-align: center;
					width: 20px;}
					details[open] summary:before {content: "-";
					/*margin-top: -4px;*/
					margin-left:-5px;color:white;}
					p {font-size:
					12px;
					margin-left:-5px;}

					.attachmentUpload {
					position: absolute;
					width: 92%;
					background:white;
					<!-- overflow-x:scroll; -->
					height: 90%;
					z-index: 999;
					left: 4%;
					top: 5%;
					right: 3%;


					<!-- min-width: 400px; min-height: 200px; -->
					}
					.headerText
					{
					color:gray;
					padding-left:5%;
					}
					.close {
					font-family:
					Arial, Helvetica, sans-serif;
					font-size: large;
					background: #606061;
					color: #fff;
					line-height: 25px;
					position: absolute;
					left: -12px;
					text-align: center;
					top: -10px;
					width: 24px;
					text-decoration: none;
					font-weight: bold;
					-webkit-border-radius: 12px;
					-moz-border-radius:
					12px;
					border-radius: 12px;
					-moz-box-shadow: 1px 1px 3px #000;
					-webkit-box-shadow: 1px 1px 3px #000;
					box-shadow: 1px 1px 3px #000;
					cursor: pointer;
					}

					.close:hover {
					background: #00d9ff;
					}



                    /* Added by Jatin M for New Summary Changes for Show Status/DAR on 15/03/2021  - Start */
                    *{
                        margin:0;
                        padding:0;
                        box-sizing: border-box;
                    }
                    .textcolor{
                        color:#969696 !Important;
                        font-weight: 500;
                    }
                    .text-rowgroup-1{
                        color: #969696!Important;
                        font-weight: 600;
                    }
                    .horizontal-border {
                        margin: 0 16px;
                        border-bottom: 1px solid #eeeeee;
                    }

                    .text-rowgroup-2{
                        font-size: 16px;
                        font-weight: 600;
                        color: #000;
                        text-align: center;
                    }
                    .text-rowgroup-3{
                        font-size: 18px;
                        font-weight: 600;
                        padding: 8px 0 0 0;
                        color: #000;
                    }
                    .activity-descr-text{
                        display: flex;
                        justify-content: center;
                        align-items: center;
                    }
                    .mainiconradius{
                        width: 24px;
                        height: 24px;
                        margin: 0 10px;
                    }
                    .addspace{
                        text-align: left;
                        margin: 0 0 0 10px;
                    }
                    .stickysubforms{
                        position: sticky;
                        display: table;
                        -webkit-overflow-scrolling: touch;
                    }
                    .timeline::before {
                        content: '';
                        position: absolute;
                        height: 22px;
                        width: 1px;
                        background-color: #000;
                        left: 32px;
                        transform: translateY(-118%);
                        /*transform: translate(100%,-100%);*/
                    }
                    .timeline:first-child::before{
                        width: 0;
                    }

                    .customerDiv{
                        display: flex;
                        padding: 0 16px;
                        align-items: center;
                        margin-bottom: 16px;
                    }
                    .customerDiv:last-child{
                        margin: 0;
                    }
                    .large-font{
                        font-size: 14px;
                    }
                    .small-font{
                        font-size: 12px;
                        color: #969696;
                    }

                    .promotionDiv {
                        padding: 0 16px 4px 16px;
                        display: flex;
                        align-items: center;
                    }

                    .sampleOrderDiv{
                        padding: 0 16px 4px 16px;
                    }

                    .travelIcon{
                        height: 20px;
                        width: 20px;
                        border-radius: 100%
                    }
                    .donebutton{
                        border-radius: 100%;
                        height: 20px;
                        width: 20px;
                        margin: 0 32px;
                    }
                    .places_visited{
                        height: 20px;
                        width: 20px;
                    }
                    .divToLeft {
                        text-align: left;
                    }

                    .hideoverflow{
                        /*overflow: hidden;*/
                        text-overflow: ellipsis;
                        -webkit-line-clamp: 2;
                        display: block;
                        -webkit-box-orient: vertical;
                        height: auto;
                    }

                    .hideoverflowfeed{
                        /*overflow: hidden;*/
                        display: inline-table;
                        text-overflow: ellipsis;
                        -webkit-line-clamp: 1;
                        -webkit-box-orient: vertical;
                        height: 20px;
                        min-width: 50px;
                        line-height: 24px;
                    }

                    .povminwidth{
                        min-width: 150px;
                    }

                    .mainbody{
                        background: #f5f5f5;
                        margin: auto;
                        width: calc(100% - 32px);
                        max-width: 1024px;
                        font-family: sans-serif !important;
                        font-weight: 500 !important;
                        margin-bottom: 0;
                    }

                    .datafontsize{
                        font-size:14px !Important;
                        color: #000;
                    }
                    .headerfontsize{
                        font-size:12px !Important;
                        color:#969696 !Important;
                    }
                    .bradius{
                        border-radius: 100px;
                        height: 30px;
                        width: 30px;
                    }

                    .subformradius{
                        height: 30px;
                        width: 30px;
                    }

                    .collapsibleIconRadius{
                        border-radius: 100px;
                        height: 30px;
                        width: 30px;
                    }
                    .imgradius{
                        border-radius: 100px;
                        height: 80px;
                        width: 80px;
                    }

                    .headerdata{
                        display: flex;
                        align-items: center;
                        white-space: nowrap;
                        /* height: 36px; */
                        margin: 0;
                        font-size: 12px;
                        padding: 0 12px;
                        color: #000;
                        cursor: pointer;
                    }  

                    .rightcol-spacing{
                        margin-inline-start: auto;
                        text-align: right;
                        font-size: 12px;
                        align-self: baseline;
                        white-space: nowrap;
                        overflow-wrap: break-word;
                        justify-content: flex-end;
                    }

                    .containerfeed{
                        padding: 12px 0;
                        margin: 4px 0;
                        /*height: auto;*/
                        border-radius: 12px;
                        background-color: #fff;
                        overflow: hidden;
                    }
                        
                    .main-icon{
                        display: block; 
                        text-align:center;
                    }

                    .submitdate{
                        font-size:12px;
                        font-weight: 600;
                        padding: 8px 0 0 0;
                        font-weight: 600px;
                        color: #000;
                    }

                    .align-imgtext{
                        float:left;
                        text-align:right;
                    }

                    .single-colDiv{
                        display: inline-flex;
                        align-items: center;
                        text-align: left;
                        justify-content: center;
                        margin: 0 auto;
                        padding: 0 16px;
                        width: 100%;
                        height: 100px;
                        min-height: 100px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                    }

                    .columnsDiv {
                        display: flex;
                        align-items: center;
                        width: 100%;
                        height: 52px;
                        min-height: 52px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                        /* border: 1px solid #e2e2e2; */
                        /* border-radius: 12px;*/
                    }

                    .btnborder{
                        height: 24px;
                        width: 24px;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        background-color: #f5f5f5;
                        border-radius: 28px;
                    }

                    .visitdetails{
                        color: #969696;
                        display: flex;
                        padding: 0px;
                        height: 25px;
                    }
                    .tab{
                        margin-inline-start: auto;
                        cursor: pointer;
                    }
                    .tablinks{
                        border:none;
                        outline:none;
                        background: none;
                    }

                    .svgcolor{
                        background-color: #faaa1f;
                        width: 14px;
                        height: 14px;
                        border-radius: 100%;
                    }

                    .tab button:active {
                        border: none;
                        outline: none;
                        box-shadow: none;
                    }
                    .confstatus{
                        display: flex;
                        align-items: center;
                        border-radius: 50%;
                        font-size:12px;
                    }
                    
                    .customername_doc{
                        width: 10%;
                        min-width: 150px;
                        text-align: left;
                    }
                    .customernameDiv{
                        width: 15%;
                        min-width: 150px;
                        text-align: left;
                    }

                    .customertypesDiv {
                        width: 15%;
                        min-width: 150px;
                        text-align: left;
                        padding: 0 8px;
                    }
                    .eventtimestartDiv {
                        width: 10%;
                        min-width: 120px;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                    }
                    .visittimeDiv{
                        width: 20%;
                        min-width: 120px;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                    }
                    .pobvalueDiv{
                        width: 10%;
                        min-width: 100px;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                    }
                    .planChgRsn{
                        min-width: 200px;
                        text-align: left;
                        padding: 0 8px;
                    }

                    .reg-no{
                        min-width: 125px;
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .euin-no{
                        min-width: 125px;
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .remarksDiv{
                        width: 15%;
                        min-width: 120px;
                        text-align: left;
                        padding: 0 8px;
                    }
                    .doclocalityDiv{
                        width: 10%;
                        min-width: 120px;
                        text-align: right;
                        justify-content: flex-end;
                    }
                    .teamDiv{
                        width: 15%;
                        min-width: 120px;
                        text-align: left;
                        padding: 0 8px;
                    }
                    
                    .firstcolumn{
                        text-align: left !important;
                        padding: 0 8px 0 0;
                        left: 0;
                    }
                    .headingwidth{
                        border-bottom: 1px solid #0000001a;
                        white-space: nowrap;
                        display: flex;
                        align-items: flex-start;
                        height: 25px;
                        text-overflow: ellipsis;
                        overflow: hidden;
                        color: #969696 !important;
                        padding: 0 8px;
                        font-size: 12px;
                    }

                    .detailswidth{
                        padding: 0 8px;
                        white-space: normal;
                        height: auto;
                        display:block;
                        /*align-items: center;*/
                        color: #000;
                    }
                    
                    .seperatorDiv{
                        border-bottom: 1px solid #0000001a;
                    }

                    .lastcolumn{
                        justify-content: flex-end;
                        text-align: right !important;
                        padding: 0 0 0 8px;
                    }
                    .place_of_visit{
                        width:33.33%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .visited-with{
                        text-align: left;
                        width: 33.33%;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .order_of_visit{
                        text-align:right;
                        width:33.33%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .branddescr{
                        width: 50%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .pitchsequence{
                        text-align:right;
                        width: 50%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .itemusage{
                        width:33.33%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .itemdescr{
                        text-align: left;
                        width: 33.33%;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .quantitysample{
                        text-align:right;
                        width:33.33%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .displayarea{
                        width: 50%;
                        margin-bottom: 16px;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .displayplugin{
                        text-align: left;
                        height: auto;
                        overflow-x: scroll;
                        overflow-y: hidden;
                    }
                    .surveydescr{
                        width: 50%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .surveyresult{
                        text-align:right;
                        width: 50%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .travelmode{
                        text-align: left;
                        width:25%;
                        padding: 0 8px 0;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    #section-n2 {
                        display:none;
                    }

                    .emp-name{
                        width: 20%;
                        padding: 0 8px 0 0;
                        min-width: 150px;
                        overflow: hidden;
                        text-align: left;
                    }
                    .placeofvisitmgr{
                        width: 20%;
                        padding: 0 8px 0 0;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                    }
                    
                    .travelmodemgr{
                        text-align: left;
                        width: 20%;
                        padding: 0 8px 0;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .orderofvisitmgr{
                        text-align:right;
                        width:20%;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .left-spacing{
                        width: 25%;
                        min-width: 120px;
                        overflow: hidden;
                        text-align: left;
                        display: flex;
                        align-items: center;
                    }

                    .center-left{
                        width: 25%;
                        text-align: left;
                        padding: 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .center-right{
                        width: 25%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 8px;
                        min-width:120px;
                        overflow: hidden;
                    }
					
					.ord-product{
						width: 20%;
						min-width: 150px;
						overflow: hidden;
						text-align: left;
						display: flex;
						align-items: center;
					}
					
					.ord-quantity{
						width: 20%;
						text-align: right;
						padding: 0 8px 0;
						min-width: 100px;
                        justify-content: flex-end;
						overflow: hidden;
					}
					
					.ord-value{
						width: 20%;
						text-align: right;
						padding: 0 8px 0;
						min-width: 100px;
                        justify-content: flex-end;
						overflow: hidden;
					}
					
					.ord-descr{
						text-align: left;
						width: 20%;
						padding: 0 8px 0;
						min-width: 150px;
						overflow: hidden;
					}

                    .ord-devi-rsn{
						text-align: left;
						padding: 0 8px 0;
						min-width: 200px;
						overflow: hidden;
					}
					
					.ord-remarks{
						text-align: right;
						width: 20%;
						padding: 0 0 0 8px;
						min-width: 150px;
						overflow: hidden;
                        justify-content: flex-end;
					}

                    .right-spacing{
                        justify-content: flex-end;
                        text-align: right;
                        width: 25%;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .ordervalue{
                        width: 20%;
                        text-align: right;
                        padding: 0 8px 0;
                        min-width: 90px;
                        overflow: hidden;
                    }
                    
                    .schemedescription{
                        width: 20%;
                        text-align: left;
                        padding: 0 8px 0;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .bgcolorform{
                        background-color: #f5f5f5;
                    }

                    .customertypes_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    
                    .classdescr_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 100px;
                        overflow: hidden;
                    }

                    .spldescription_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 100px;
                        overflow: hidden;
                    }

                    .novisit_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 80px;
                        overflow: hidden;
                    }

                    .visittime_doc{
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 150px;
                        overflow: hidden;
                    }
                    .eventtimestart_doc{
                        width: 5%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .pobvalue_doc{
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 80px;
                        overflow: hidden;
                    }
                    .remarks_doc{
                        width: 15%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 100px;
                        overflow: hidden;
                    }
                    .team_doc{
                        width: 10%;
                        text-align: left;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }
                    .doclocality_doc{
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                        padding: 0 0 0 8px;
                        min-width: 120px;
                        overflow: hidden;
                    }

                    .speciality{
                        min-width: 160px;
                        width: 10%;
                        text-align: left;
                    }

                    .class{
                        min-width: 90px;
                        width: 10%;
                        text-align: left;
                    }

                    .placeofwork{
                        width: 10%;
                        min-width: 120px;
                        text-align: left;
                    }
                    .visitplan{
                        min-width: 80px;
                        width: 10%;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .visitwith{
                        width: 10%;
                        min-width: 200px;
                        text-align: left;
                    }

                    .visittime{
                        width: 10%;
                        min-width: 100px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .pobvalue{
                        width: 10%;
                        min-width: 80px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .remarks{
                        width: 10%;
                        min-width: 150px;
                    }
                    .timeofcall{
                        width: 20%;
                        min-width: 140px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    
                    .pob-value{
                        width: 20%;
                        min-width: 80px;
                        text-align: right;
                        justify-content: flex-end;
                    }

                    .unlistedremark{
                        width: 20%;
                        min-width: 150px;
                    }

                    .workplace{
                        width: 20%;
                        min-width: 120px;
                        text-align: left;
                    }


                    .visitsdetails{
                        display: flex;
                        align-items: center;
                        padding: 8px 0px;
                    }

                    .containertable{
                        padding: 0 16px;
                        margin: 12px 0;
                        border-radius: 12px;
                        background:#fff;
                        overflow-x: hidden;
                    }

                    .doctorcontainer{
                        padding: 8px 0;
                        margin: 8px 0 8px 0;
                        /*height: auto;*/
                        border-radius: 12px;
                        background-color: #fff; 
                        overflow-x: auto;
                        overflow-y: hidden;
                        /*width: calc(100% - 0px);*/
                        /*position: relative;*/
                    }
                    
                    .doctordetails{
                        display: flex;
                        padding: 0px;
                        white-space: initial;
                        /*width: 100%;*/
                        height: 25px;
                    }
                    .docdatadetails{
                        display: flex;
                        align-items: center;
                        padding: 0px;
                        height: auto;
                        margin: 8px 0;
                    }

                    .sampleheading{
                        display:flex;
                        align-items:center;
                        padding: 8px 0;
                    }

                    .samplename{
                        display: flex;
                        align-items: center;
                        color: #969696;
                        padding: 0;
                        height: 25px;
                        border-bottom: 1px solid #0000001a;
                    }

                    .sampledata{
                        white-space: initial;
                        display: flex;
                        padding: 0;
                        margin: 8px 0;
                        height: auto;
                        align-items: center;
                    }

                    .sampledetails{
                        background-color: #ededed;
                        padding: 16px;
                        /*width: 100%;*/
                        left: 0;
                        position: sticky;
                        position: -webkit-sticky;
                    }
                        
                    .routeicon{
                        margin-inline-start: auto;
                        background-color: #eeeeee;
                    }

                    .itemlabel {
                        margin-top: 16px;
                        padding: 0 40px;
                        height: 16px;
                        text-align: left;
                    }
                    .orderFormHeader {
                        display: flex;
                        margin-top: 16px;
                        padding: 0 16px;
                        align-items: center;
                        text-align: left;
                    }
                    .itemOuterDiv{
                        margin-top: 16px;
                    }

                    .imgicon{
                        width: 80px;
                        height: 80px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    .btniconborder{
                        height: 34px;
                        width: 34px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    .table_default_bg{
                        background-color: #e6f4ff;
                    }

                    .feed_default_bg{
                        background-color: #0273d0;
                    }

                    .iconborder{
                        min-height: 30px;
                        min-width: 30px;
                        max-width: 30px;
                        max-height: 30px;
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 100%;
                    }

                    .location-icon {
                        background-color: #98ccf4;
                    }

                    .lstdcrdate-icon {
                        background-color: #d5b3ff;
                    }
                    .remarks-icon {
                        background-color : #86e7d6;
                    }

                    .beatchange-icon{
                        background-color : #f4a460;
                    }

                    .speciality-icon{
                        background-color: #91ecff;
                    } 

                    .class-icon{
                    background-color: #ffa7a7;
                    }

                    .visitplan-icon {
                        background-color: #f4a8ff;
                    }

                    .timeofcall-icon {
                        background-color: #ffb98e;
                    }

                    .visitedwith-icon {
                        background-color: #ccbdbd;
                    }

                    .pobvalue-icon {
                        background-color: #fbd607;
                    }

                    .regno-icon {
                        background-color: #ef5350;
                    }

                    .euin-icon {
                        background-color: #03a9f4;
                    }

                    .product-icon  {
                        background-color: #cacaca;
                    } 

                    .unlistedcust-icon{
                        background-color: #b2bbff;
                    }

                    .bluebg-icon{
                        background-color: #e6f4ff;
                    }

                    .redbg-icon{
                        background-color: #ffe8e9;
                    }

                    .connroute:before {
                        box-shadow: 1px 0 0 0 rgb(0 0 0 / 10%);
                    }
                    .connroute:first-child {
                        display: none;
                    }

                    .namespacing{
                        padding: 0 0 0 16px;
                        text-align: left;
                        line-height: 1.5;
                    }

                    .expWidth{
                        width: 100%;
                    }

                    .itmdescrFeed{
                        display: flex;
                        align-items: center;
                    }

                    .adjPadding{
                        padding: 0 0 0 6px;
                    }

                    .adjMargin{
						margin: 0 0 8px;
					}

					.mgnTop{
						margin: 0 0 8px;
					}

					.alignLeft{
						padding: 0 0 0 46px !important;
						text-align: left;
					}

                    .powfeedview{
                        overflow: hidden;
                        min-width: 50px;
                        white-space: normal;
                    }

                    button.rmvborder{
                        cursor: pointer;
                        border: none;
                        outline: none;
                        background-color: #f5f5f5;
                    }

                    button.rmborder{
                        cursor: pointer;
                        border: none;
                        outline: none;
                        background-color: #fff;
                    }

                    cust-col{
                        display: flex;
                        align-items: center;
                        text-align: left;
                        width: 100%;
                        height: 34px;
                        min-height: 34px;
                        -webkit-column-break-inside: avoid;
                        -webkit-column-break-after: avoid;
                    }

                    .btnpadding{
                        padding: 0 0 0 4px;
                    }

                    .tabs {
                        position: relative;
                        text-align: center;
                        background: #f5f5f5;
                        /*width: 100%;*/
                        border-radius: 5px;
                        min-width: 240px;
                        min-height: 500px;
                        overflow-x: auto;
                        overflow-y: hidden;
                        -webkit-overflow-scrolling: touch;
                    }
                    .tabs .uldiv {
                        list-style-type: none;
                        padding: 0 16px;
                        display: -webkit-box;
                        display: flex;
                        -webkit-box-orient: horizontal;
                        -webkit-box-direction: normal;
                                flex-direction: row;
                        margin-bottom: 4px;
                        -webkit-box-pack: justify;
                                justify-content: space-between;
                        -webkit-box-align: end;
                                align-items: center;
                        flex-wrap: wrap;
                        margin-top: 0;
                        width: 100%;
                    }

                    .rmv-Mrg{
                        margin: 0;
                    }

                    .unlistedcustmgn{
                        margin-top:0 !important;
                    }

                    .tabs .uldiv li {
                        box-sizing: border-box;
                        -webkit-box-flex: 1;
                        text-align: center;
                        margin-right: 0;
                    }
                    .lidiv{
                        padding: 0 0 0 16px;
                    }


                    .tabs .uldiv li label {
                        -webkit-transition: all 0.3s ease-in-out;
                        transition: all 0.3s ease-in-out;
                        padding: 5px auto;
                        overflow: hidden;
                        text-overflow: ellipsis;
                        display: block;
                        cursor: pointer;
                        -webkit-transition: all 0.2s ease-in-out;
                        transition: all 0.2s ease-in-out;
                        white-space: nowrap;
                        -webkit-touch-callout: none;
                        user-select: none;
                    }

                    .tabs .uldiv li label{
                        font-size: 18px;
                        color: #0273d0;
                    }


                    .tabs .uldiv li label:hover, .tabs .uldiv li label:focus, tabs .uldiv li label:active{
                        outline: 0;
                        color: #0273d0;
                    }

                    .tabs .slidertab {
                        position: relative;
                        width: calc(100% - 56px);
                        -webkit-transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                        transition: all 0.33s cubic-bezier(0.38, 0.8, 0.32, 1.07);
                    }
                    .tabs .slidertab .indicator {
                        position: relative;
                        width: 16px;
                        max-width: 100%;
                        margin-inline-start: auto;
                        height: 4px;
                        background: #0273d0;
                        border-radius: 1px;
                    }

                    .tabs .data-content section {
                        -webkit-animation-name: data-content;
                                animation-name: data-content;
                        -webkit-animation-direction: normal;
                                animation-direction: normal;
                        -webkit-animation-duration: 0.3s;
                                animation-duration: 0.3s;
                        -webkit-animation-timing-function: ease-in-out;
                                animation-timing-function: ease-in-out;
                        -webkit-animation-iteration-count: 1;
                                animation-iteration-count: 1;
                        line-height: 1.4;
                    }

                    .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .uldiv > li:nth-child(1) > label {
                        cursor: default;
                        -webkit-transform: translateX(0%);
                                transform: translateX(0%);
                    }
                    .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                        -webkit-transform: translateX(0%);
                                transform: translateX(0%);
                    }

                    .tabs input[name="tab-control"] {
                        display: none;
                    }

                    @-webkit-keyframes data-content {
                        from {
                            opacity: 0;
                            -webkit-transform: translateY(5%);
                                    transform: translateY(5%);
                        }
                        to {
                            opacity: 1;
                            -webkit-transform: translateY(0%);
                                    transform: translateY(0%);
                        }
                    }
                    @keyframes data-content {
                        from {
                            opacity: 0;
                            -webkit-transform: translateY(5%);
                                    transform: translateY(5%);
                        }
                        to {
                            opacity: 1;
                            -webkit-transform: translateY(0%);
                                    transform: translateY(0%);
                        }
                    }
                    @media (max-width: 1000px) {
                        .tabs .uldiv li label {
                            white-space: initial;
                        }
                    }

                    .tabs input[name="tab-control"]:nth-of-type(1):checked ~ .slidertab {
                        -webkit-transform: translateX(-18px);
                                transform: translateX(-18px);
                    }
                    /*.tabs input[name="tab-control"]:nth-of-type(1):checked ~ .data-content > section:nth-child(1) {
                        display: block;
                    }*/
                    .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .uldiv > li:nth-child(2) > label {
                        cursor: default;
                    }
                    
                    .tabs input[name="tab-control"]:nth-of-type(2):checked ~ .slidertab {
                        -webkit-transform: translateX(32px);
                                transform: translateX(32px);
                    }
                    /*.tabs input[name="tab-control"]:nth-of-type(2):checked ~ .data-content > section:nth-child(2) {
                        display: block;
                    }*/

                    .multi-colDiv{
                        text-align: left;
                        padding: 0 16px;
                        
                    }
                    @media screen and  (min-width:580px) {
                        .multi-colDiv{
                        }
                        .columnsDiv{
                        }
                    }

                    /* Added by Jatin M for New Summary Changes for Show Status/DAR on 15/03/2021  - End */

				</style>

				<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>

				<script type="text/javascript" language="javascript">
<![CDATA[
    var maxId = 0;

    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }



]]>



				</script>

			</head>



			<body bgcolor='#EEEEEE' onload="">

				<style type="text/css">

					.tableClass_1
					{margin-top:0px;}

					.header_td
					{border:inset
					0;background-color:#7aa5d6;font-family:verdana;font-size:11pt;height:28px
					;color:white}

					.custtype_td
					{border:inset
					0;background-color:lightblue;font-family:verdana;font-size:11pt;height:23px;}

					.input_editable_text
					{text-align:left;width:600px;}

					.input_num_editable
					{border:inset
					2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;
					}

					.td_leftAlign
					{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

					.td_rightAlign
					{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

					.input_num_field
					{text-align:right;width:100px;}

					div.mainDiv
					{
					width:
					100%;
					}
					table.mainTable
					{
					max-width: 100%;
					}

					div.content
					{
					float: left;
					width:auto;

					}
					div.content1
					{
					float: left;
					width:100%;

					}
					div.innerDiv
					{
					width: 100%;
					}
					div.dataDiv
					{
					width: 100%;
					height:70%;
					overflow-y: scroll;

					}
					div.dataDiv1
					{
					width: 100%;
					height:100%;

					}
					table.innerTable
					{
					width:
					100%;
					}
					td.dataCol
					{
					width: 100px;
					border-bottom: 1px solid grey;
					border-left: 1px solid grey;
					border-right: 1px solid grey;
					height:
					28px;

					}
					.outerTable
					{border:1px solid grey;}

					div.outerDiv
					{



					}
					.tdCenter
					{
					text-align: center;

					}
					.tdLeft
					{
					text-align: left;

					}
					.tdRight
					{
					text-align:
					right;

					}
					.headerTable
					{
					background:#fff;
					}
					.summary
					{
					font-size: 14px;
					font-weight: 700;
					padding-top: 4px;
					padding-bottom:4px;
					}
					.title
					{
					font-weight: 400;
					font-size: 13px;
					color:
					black;
					padding-top: 7px;


					}
					.firstData
					{
					color:black;
					}
					.heading
					{
					font-weight: 100;
					font-size:
					13px;
					color:
					#000000;
					padding-top: 0;
					padding-bottom:0;
					width:15%


					}
					.imageCenter
					{
					display: block;
					margin-left: auto;
					margin-right: auto;
					width: 50%;
					}
					.headerTableDCR {
					padding-left:8%;
					}
					@media only screen
					and
					(min-width: 100px) and
					(max-width: 500px) {
					.headerTableDCR1 {
					text-align:center;
					padding-left: 0;
					}
					}
				</style>
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/MobDARSummary.css" />
				<form name="Wizard_TravelDSR" style="margin-bottom:0" class="bgcolorform">
					<!--<div ID="dsrDiv" class="outerDiv" style="MARGIN-BOTTOM: 10PX; width: 98%;">

						<div id='dataDiv' class="dataDiv"
							style="height:100%;width:100%;overflow-y:auto">-->
                    <div class="mainbody">

							<!-- <table id="travelTable" class="tTitleD" border="0" cellspacing="1"
								cellpadding="1" width="100%"> -->

							<!--<div class="headerTableDCR1">-->
                            

								<!--<table id="travelTable" class="tTitleD" border="0"
									cellspacing="1" cellpadding="1" width="100%">-->
                        <xsl:for-each select="//Detail1">
                            <xsl:variable name="hostUrl">
                                <xsl:value-of select="host_url" />
                            </xsl:variable>
                            <div class="containerfeed">
                                <div class="headerdata">
                                    <div class="text-rowgroup-1">
                                        <xsl:variable name="event_date">
	                                        <xsl:value-of select="event_date" />
	                                    </xsl:variable>
                                        <xsl:value-of select="event_date" />
                                        <!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] START -->
                                        <input type="hidden" id="dcr_event_date" value="{normalize-space($event_date)}"/>
                                        <!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] END -->
                                    </div>
                                </div>
                                <!--<tr>

                                    <td class="cellttl1 firstData" width="auto"
                                        style='padding : 10px 10px 0px 10px;'>

                                        <span class="" style='text-transform:capitalize;float: left;'>-->
                                <div class="single-colDiv">
                                    <xsl:variable name="sales_pers_name">
                                        <xsl:value-of select="sales_pers_sp_name" />
                                    </xsl:variable>
                                    <xsl:variable name="sales_pers">
                                        <xsl:value-of select="sales_pers" />
                                    </xsl:variable>
                                    
                                    <div class="imgicon bluebg-icon">
                                        <IMG
                                            SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($sales_pers)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($sales_pers_name)}"
                                            onerror="{normalize-space($hostUrl)}/ibase/webitm/images/map/user.png"
                                            class="imgradius align-imgtext">
                                        </IMG>
                                        <!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] START -->
                                        <input type="hidden" id="sales_pers" value="{normalize-space($sales_pers)}"/>
                                        <!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] END -->
                                    </div>
                                </div>
                                        <!--</span>-->

                                        <!--<span class=""
                                            style='text-transform:capitalize;float:left;margin-left:4px;padding:4px 0;'>-->
                                <div class="text-rowgroup-2">
                                    <xsl:value-of select="sales_pers_sp_name" />
                                    ,
                                    <xsl:value-of select="headquarter" />
                                </div>
                                        <!--</span>-->


                                        <!--<span class=""
                                            style='text-transform:capitalize;float:right;padding:4px 5px;'>
                                            <xsl:value-of select="event_date" />
                                        </span>-->

                                    <!--</td>

                                </tr>-->


                                <!--<tr style="width: 100%;">
                                    <td class="cellttl1 firstData" width="auto">
                                        <div class=""
                                            style='text-transform:capitalize;height: 30px;margin: auto;width: 30px;     border-radius: 50%;     background: lightgray;'>-->
                                <div class="main-icon">
                                    <xsl:variable name="event_type">
                                        <xsl:value-of select="event_type" />
                                    </xsl:variable>
                                    <xsl:variable name="event_descr">
                                        <xsl:value-of select="activity_descr" />
                                    </xsl:variable>
                                    <div class="text-rowgroup-3 activity-descr-text">
                                            <!--<IMG
                                                SRC="{normalize-space($hostUrl)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($event_type)}&amp;object=wsfa_fieldactivity&amp;objName=wsfa_fieldactivity&amp;ALT_FLD_VALUE={normalize-space($event_descr)}"
                                                onerror='this.src="images/map/user.png"' class="iw-header-userImage"
                                                style="height: 15px; width: 15px;padding: 7.5px">
                                            </IMG>-->
                                        <IMG
                                            SRC="{normalize-space($hostUrl)}/ibase/webitm/images/Summary/fw.svg"
                                            onerror="{normalize-space($hostUrl)}/ibase/webitm/images/Summary/fw.svg"
                                            class="mainiconradius"
                                            width ="40" height="40">
                                        </IMG>
                                        <xsl:value-of select="activity_descr" />
                                    </div>
                                </div>
                                        <!--</div>
                                        <span CLASS="" style="width:auto;color:gray;">Activity </span>
                                        <br />
                                        <span CLASS="" style="width:auto;">-->
                                            
                                        <!--</span>

                                    </td>
                                </tr>-->
                            </div>
                        </xsl:for-each>
                        <!--</table>-->
                        <xsl:variable name="btn_host_Url">
                            <xsl:for-each select="//Detail1">
                                <xsl:if test="attribute/@updateFlag!='D'">
                                    <xsl:value-of select="host_url" />
                                </xsl:if>
                            </xsl:for-each>
                        </xsl:variable>
						
						
                        <xsl:variable name="feed">
                            <xsl:value-of
                                select="concat(normalize-space($btn_host_Url),'/ibase/webitm/images/Summary/summary_feed.svg')" />
                        </xsl:variable>
                        <xsl:variable name="feed_alt">
                            <xsl:value-of
                                select="concat(normalize-space($btn_host_Url),'/ibase/webitm/images/Summary/summary_feed_alt.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table">
                            <xsl:value-of
                                select="concat(normalize-space($btn_host_Url),'/ibase/webitm/images/Summary/summary_table.svg')" />
                        </xsl:variable>
                        <xsl:variable name="table_alt">
                            <xsl:value-of
                                select="concat(normalize-space($btn_host_Url),'/ibase/webitm/images/Summary/summary_table_alt.svg')" />
                        </xsl:variable>
						


                        <div class="tabs">
                            <input type="radio" id="tab1" name="tab-control" checked="true"  />
                            <input type="radio" id="tab2" name="tab-control" />
                            <ul class="uldiv">
                                <li class="rightcol-spacing" title="Feed View">
                                    <label for="tab1" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder feed_default_bg" id="feedbg">
                                                <IMG 
                                                    id="feedicon" width ="30" height="30"
                                                    onclick="focusView('focusOnFeed','{normalize-space($feed_alt)}','{normalize-space($table)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$feed_alt" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                                <li class="lidiv rmv-Mrg" title="Table View">
                                    
                                    <label for="tab2" role="button" class="tablinks" >
                                        <span>
                                            <div class="btniconborder table_default_bg" id="tablebg">
                                                <IMG 
                                                    id="tableicon" width ="30" height="30"
                                                    onclick="focusView('focusOnTable','{normalize-space($table_alt)}','{normalize-space($feed)}')">
                                                    <xsl:attribute name="src">
                                                        <xsl:value-of select="$table" />
                                                    </xsl:attribute>
                                                </IMG>
                                            </div>
                                        </span>
                                    </label>
                                </li>
                            </ul>
                            <div class="slidertab">
                                <div class="indicator"></div>
                            </div>

							<div class="data-content">

                                <section id="section-n1">      
                                    <!-- Detail1(start) -->
                                    <xsl:variable name="activity_type">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="activity_type" />
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="place_required">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="place_required" />
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="host_url">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="host_url" />
                                        </xsl:for-each>
                                    </xsl:variable>

                                    <xsl:if test="normalize-space($place_required) = 'Y'">
                                        <!--<input type="button" id="button" value="-"
                                            onClick="expandAllDetails(this.id)"
                                            style="background-color: transparent;text-align:right;width:inherit;border:none;border-style: none;" />-->

                                        <xsl:variable name="detail1_listed_count">
                                            <xsl:for-each select="//Detail1">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail1)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>

                                        <xsl:if test="normalize-space($detail1_listed_count) > '0'">

                                            <xsl:variable name="detail1_form">
                                                <xsl:for-each select="//Detail1">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','1','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>

                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail1_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail1(end) -->
                                        <!-- Detail2(start) -->
                                        <xsl:variable name="detail2_listed_count">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail2)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                            <xsl:variable name="detail2_form">
                                                <xsl:for-each select="//Detail2">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','2','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail2_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail2(end) -->
                                        <!-- Detail3(start) -->
                                        <xsl:variable name="detail3_listed_count">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail3)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail3_listed_count) > '0'">
                                            <xsl:variable name="detail3_form">
                                                <xsl:for-each select="//Detail3">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','3','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail3_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail3(end) -->
                                        <!-- Detail4(start) -->
                                        <xsl:variable name="detail4_listed_count">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail4)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail4_listed_count) > '0'">
                                            <xsl:variable name="detail4_form">
                                                <xsl:for-each select="//Detail4">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','4','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail4_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail4(end) -->
                                        <!-- Detail5(start) -->
                                        <xsl:variable name="detail5_listed_count">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail5)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail5_listed_count) > '0'">
                                            <xsl:variable name="detail5_form">
                                                <xsl:for-each select="//Detail5">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','5','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail5_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail5(end) -->
                                        <!-- Detail6(start) -->
                                        <xsl:variable name="detail6_listed_count">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail6)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail6_listed_count) > '0'">
                                            <xsl:variable name="detail6_form">
                                                <xsl:for-each select="//Detail6">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','6','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail6_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail6(end) -->
                                        <!-- Detail7(start) -->
                                        <xsl:variable name="detail7_listed_count">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail7)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail7_listed_count) > '0'">
                                            <xsl:variable name="detail7_form">
                                                <xsl:for-each select="//Detail7">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','7','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail7_form" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail7(end) -->
                                        <!-- Detail8(start) -->
                                        <xsl:variable name="detail8_listed_count">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail8)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail8_listed_count) > '0'">
                                            <xsl:variable name="detail8_form">
                                                <xsl:for-each select="//Detail8">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','8','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail8_form" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail8(end) -->
                                        <!-- Detail9(start) -->
                                        <xsl:variable name="detail9_listed_count">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail9)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail9_listed_count) > '0'">
                                            <xsl:variable name="detail9_form">
                                                <xsl:for-each select="//Detail9">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','9','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail9_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail9(end) -->
                                        <!-- Detail10(start) -->
                                        <xsl:variable name="detail10_listed_count">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail10)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail10_listed_count) > '0'">
                                            <xsl:variable name="detail10_form">
                                                <xsl:for-each select="//Detail10">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','10','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitStringFeed">
                                                <xsl:with-param name="stringtosplit" select="$detail10_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                    </xsl:if>
							        <!-- Detail10(end) -->
							        
							        <!-- Added by Prasad on 11/08/2021 [to display non-visited customers] START -->
									<div id="section-n1-not-visited"></div>
									<!-- Added by Prasad on 11/08/2021 [to display non-visited customers] END -->
                                </section>

                                <section id="section-n2">
                                    <!-- Detail1(start) -->
                                    <xsl:variable name="activity_type">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="activity_type" />
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="place_required">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="place_required" />
                                        </xsl:for-each>
                                    </xsl:variable>
                                    <xsl:variable name="host_url">
                                        <xsl:for-each select="//Detail1">
                                            <xsl:value-of select="host_url" />
                                        </xsl:for-each>
                                    </xsl:variable>

                                    <xsl:if test="normalize-space($place_required) = 'Y'">
                                        <!--<input type="button" id="button" value="-"
                                            onClick="expandAllDetails(this.id)"
                                            style="background-color: transparent;text-align:right;width:inherit;border:none;border-style: none;" />-->

                                        <xsl:variable name="detail1_listed_count">
                                            <xsl:for-each select="//Detail1">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail1)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>

                                        <xsl:if test="normalize-space($detail1_listed_count) > '0'">

                                            <xsl:variable name="detail1_form">
                                                <xsl:for-each select="//Detail1">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','1','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>

                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail1_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail1(end) -->
                                        <!-- Detail2(start) -->
                                        <xsl:variable name="detail2_listed_count">
                                            <xsl:for-each select="//Detail2">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail2)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail2_listed_count) > '0'">
                                            <xsl:variable name="detail2_form">
                                                <xsl:for-each select="//Detail2">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','2','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail2_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail2(end) -->
                                        <!-- Detail3(start) -->
                                        <xsl:variable name="detail3_listed_count">
                                            <xsl:for-each select="//Detail3">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail3)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail3_listed_count) > '0'">
                                            <xsl:variable name="detail3_form">
                                                <xsl:for-each select="//Detail3">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','3','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail3_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail3(end) -->
                                        <!-- Detail4(start) -->
                                        <xsl:variable name="detail4_listed_count">
                                            <xsl:for-each select="//Detail4">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail4)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail4_listed_count) > '0'">
                                            <xsl:variable name="detail4_form">
                                                <xsl:for-each select="//Detail4">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','4','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail4_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail4(end) -->
                                        <!-- Detail5(start) -->
                                        <xsl:variable name="detail5_listed_count">
                                            <xsl:for-each select="//Detail5">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail5)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail5_listed_count) > '0'">
                                            <xsl:variable name="detail5_form">
                                                <xsl:for-each select="//Detail5">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','5','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail5_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail5(end) -->
                                        <!-- Detail6(start) -->
                                        <xsl:variable name="detail6_listed_count">
                                            <xsl:for-each select="//Detail6">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail6)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail6_listed_count) > '0'">
                                            <xsl:variable name="detail6_form">
                                                <xsl:for-each select="//Detail6">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','6','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail6_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail6(end) -->
                                        <!-- Detail7(start) -->
                                        <xsl:variable name="detail7_listed_count">
                                            <xsl:for-each select="//Detail7">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail7)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail7_listed_count) > '0'">
                                            <xsl:variable name="detail7_form">
                                                <xsl:for-each select="//Detail7">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','7','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail7_form" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail7(end) -->
                                        <!-- Detail8(start) -->
                                        <xsl:variable name="detail8_listed_count">
                                            <xsl:for-each select="//Detail8">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail8)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail8_listed_count) > '0'">
                                            <xsl:variable name="detail8_form">
                                                <xsl:for-each select="//Detail8">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','8','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail8_form" />
                                            </xsl:call-template>
                                        </xsl:if>

                                        <!-- Detail8(end) -->
                                        <!-- Detail9(start) -->
                                        <xsl:variable name="detail9_listed_count">
                                            <xsl:for-each select="//Detail9">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail9)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail9_listed_count) > '0'">
                                            <xsl:variable name="detail9_form">
                                                <xsl:for-each select="//Detail9">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','9','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail9_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                        <!-- Detail9(end) -->
                                        <!-- Detail10(start) -->
                                        <xsl:variable name="detail10_listed_count">
                                            <xsl:for-each select="//Detail10">
                                                <xsl:if test="attribute/@updateFlag!='D'">
                                                    <xsl:value-of select="count(//Detail10)" />
                                                </xsl:if>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="normalize-space($detail10_listed_count) > '0'">
                                            <xsl:variable name="detail10_form">
                                                <xsl:for-each select="//Detail10">
                                                    <xsl:value-of
                                                        select="concat(@formName,'(','10','|',$activity_type,'*',$place_required,'#',$host_url)" />
                                                </xsl:for-each>
                                            </xsl:variable>
                                            <xsl:call-template name="tmpSplitString">
                                                <xsl:with-param name="stringtosplit" select="$detail10_form" />
                                            </xsl:call-template>
                                        </xsl:if>
                                    </xsl:if>
							        <!-- Detail10(end) -->
                                
                                	<!-- Added by Prasad on 11/08/2021 [to display non-visited customers] START -->
									<div id="section-n2-not-visited"></div>
									<!-- Added by Prasad on 11/08/2021 [to display non-visited customers] END -->
                                </section>

                            </div>


							<div width="40%" id="attachmentUpload" class="attachmentUpload"
								style="display: none;">
								<table width="100%" height="100%">
									<tr height="10%" width="100%">
										<td>
											<div class="close" onclick="closeMe('attachmentUpload');">x</div>
											<div width="100%">
												<div
													style="width:100%;float:right;border-bottom: #e5e4e9 1px solid;PADDING-BOTTOM: 5PX;">
													<input type="button" class="buttonZoomIN" style="float:right;"
														value="+" id="zoomInBtn" onclick="zoomImage('+')" />
													<input type="button" class="buttonZoomOUT" style="float:right;"
														value="(-)" id="zoomOutBtn" onclick="zoomImage('-')" />
												</div>
											</div>
										</td>
									</tr>

									<tr height="89%" width="100%">
										<td>
											<div id="uploadContent"
												style="height: 100%; width: 100%; overflow:auto;background:white; margin:0 auto;">
												<img id="targetImg" style="max-height: 100%; max-width:100%;"
													src="" setMinSize="false" setSize="false" oHeight=""
													oWidth=""></img>
											</div>
										</td>
									</tr>
									<tr height="1%" width="100%">
										<td>

										</td>
									</tr>
								</table>
							</div>

							<div id="overlay"></div>

						</div>
					</div>

				</form>
			</body>
			<!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] START -->
            <LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/Standard/summarydefault.css" onload="getNonVisitedRoute();" />
            <!--Added by Prasad on 20-Aug-2021 [to display the non visisted customer] END -->
		</html>
	</xsl:template>

    <xsl:variable name="host_Url">
        <xsl:for-each select="//Detail1">
            <xsl:if test="attribute/@updateFlag!='D'">
                <xsl:value-of select="host_url" />
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>

    <xsl:template name="tmpSplitStringFeed">
		<xsl:param name="stringtosplit" />


		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>

		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>

		<xsl:variable name="form_no">
			<xsl:value-of select="substring-before(substring-after($value, '('), '|')" />
		</xsl:variable>

		<xsl:variable name="activity">
			<xsl:value-of select="substring-before(substring-after($value, '|'), '*')" />
		</xsl:variable>
		<xsl:variable name="place_mandatory">
			<xsl:value-of select="substring-before(substring-after($value, '*'), '#')" />
		</xsl:variable>
		<xsl:variable name="host">
			<xsl:value-of select="substring-after($value,'#')" />
		</xsl:variable>

		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>

        <xsl:variable name="collapse">
			<xsl:value-of
				select="concat(normalize-space($host_Url),'/ibase/webitm/images/Summary/collapse.svg')" />
		</xsl:variable>
		<xsl:variable name="expand">
			<xsl:value-of
				select="concat(normalize-space($host_Url),'/ibase/webitm/images/Summary/expand.svg')" />
		</xsl:variable>


		<xsl:if test="normalize-space($form_name) = 'doctor'">

			<!--<details open="true" id="RTR_SummaryPage_place_listed_count">
				<summary class="summary" id="RTR_SummaryPage_place_listed_count"
					style="float: left;">Place Details</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
            <div class="headerdata datafontsize">
                Beat Details
                <div class="tab">
                    <button type="button" class="rmvborder">
                        <div class="btnborder align-imgtext">
                            <IMG
                                id="place_details_btn" class="collapsibleIconRadius align-imgtext" 
                                onclick="expandDetails('place_details', 'place_details_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                            </IMG>
                        </div>
                    </button>
                </div>
            </div>
                
            <div id="place_details">    
                <div class="containerfeed datafontsize">
                    <div class="multi-colDiv">
                        <xsl:for-each select="//node()[starts-with(name(), $detail)]">
                            <xsl:variable name="locality_descr">
                                <xsl:value-of select="locality_descr" />
                            </xsl:variable>
                            <xsl:variable name="travel_mode">
                                <xsl:value-of select="travel_mode" />
                            </xsl:variable>
                            <xsl:variable name="order_of_visit">
                                <xsl:value-of select="order_of_visit" />
                            </xsl:variable>
                            <xsl:variable name="station_descr">
                                <xsl:value-of select="station_descr" />
                            </xsl:variable>

                            <!--<TR>

                                <TD CLASS="cellttl1 tdCenter title ">
                                    <div style="display: inline-block; width: 100%;">
                                        <div
                                            style="height: auto; float: left; width: 40px; background: :gray;">-->
                                    <div class="columnsDiv">
                                        <!--<div class="iconborder lstdcrdate-icon">
                                            <img
                                                src="{normalize-space($host)}/ibase/webitm/images/Summary/summary_place.svg"
                                                class="bradius align-imgtext"></img>-->
                                                <!--style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;">-->
                                        <div class="iconborder location-icon align-imgtext">
                                            <xsl:choose>
                                                <xsl:when test="$travel_mode = 'ROAD'">
                                                    <IMG
                                                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/road.svg"
                                                        onerror='this.src="../webitm/images/Summary/road.svg"'
                                                        class="travelIcon align-imgtext" width="40" height="40">
                                                    </IMG>
                                                </xsl:when>
                                                <xsl:when test="$travel_mode = 'RAIL'">
                                                    <IMG
                                                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/train.svg"
                                                        onerror='this.src="../webitm/images/Summary/train.svg"'
                                                        class="bradius align-imgtext" width="40" height="40">
                                                    </IMG>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <IMG
                                                        SRC="{normalize-space($host)}/ibase/webitm/images/Summary/summary_place.svg"
                                                        onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                                        class="bradius align-imgtext" width="40" height="40">
                                                    </IMG>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </div>
                                        <div class="namespacing align-imgtext powfeedview">
                                            <div class="hideoverflowfeed">
                                                <xsl:value-of select="$locality_descr" />
                                                <xsl:if test="station_descr != ''">
                                                    <xsl:value-of select="concat(' ','(',$station_descr,')')" />
                                                </xsl:if>
                                            </div>
                                        </div>
                                        <div class="routeicon iconborder">
                                            <xsl:value-of select="$order_of_visit" />
                                        </div>
                                    </div>
                                        <!--<div  class="namespacing align-imgtext">
                                            <div class="textcolor headerfontsize " >-->
                                            <!--<div style="width: calc(100% - 40px); float: right;">
                                                <div style="float: left; color: gray;">-->
                                                <!--  Place
                                            </div>
                                            <div class="datafontsize " >
                                                <xsl:value-of select="$locality_descr" />
                                                <xsl:if test="station_descr != ''">
                                                    <xsl:value-of select="concat(' ','(',$station_descr,')')" />
                                                </xsl:if>
                                            </div>
                                        </div>
                                    </div>-->
                                            <!--<br />
                                            <div style="float: left; white-space: normal;">-->
                                                
                                            <!--</div>
                                        </div>
                                    </div>
                                </TD>


                            </TR>-->

                        </xsl:for-each>
                    <!--</TABLE>
                </details>-->
                <!--<details open="true" id="RTR_SummaryPage_place_listed_count">
                    <summary class="summary" id="RTR_SummaryPage_place_listed_count"
                        style="float: left;">Worked with Details</summary>
                    <TABLE class="tTitleD" border="0" width="100%"
                        style="width:100%; z-index:9999999999;  ">-->
                        <xsl:for-each select="//node()[starts-with(name(), $detail)]">
                            <xsl:variable name="visited_with">
                                <xsl:value-of select="visited_with" />
                            </xsl:variable>
                            <!--<TR>
                                <TD CLASS="cellttl1 tdCenter title ">
                                    <div style="display: inline-block; width: 100%;">
                                        <div
                                            style="height: auto; float: left; width: 40px; background: :gray;">-->
                                    <div class="columnsDiv">
                                        <div class="iconborder visitedwith-icon">
                                            <IMG
                                                SRC="{normalize-space($host)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($visited_with)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($visited_with)}"
                                                onerror='this.src="../webitm/images/Summary/summary_visited.svg"' class="bradius align-imgtext">
                                            </IMG>
                                        </div>
                                    
                                        <!--<div style="width: calc(100% - 40px); float: right;">
                                            <div style="float: left; color: gray;">-->
                                        <div class="namespacing align-imgtext">
                                            <div class="textcolor headerfontsize " >
                                                Worked With
                                            </div>
                                            <div class="datafontsize " >
                                                <!--<br />
                                                <div style="float: left; white-space: normal;">-->
                                                <xsl:value-of select="$visited_with" />
                                            </div>
                                        </div>
                                    </div>
                                            <!--</div>
                                        </div>
                                    </div>
                                </TD>


                            </TR>-->

                        </xsl:for-each>
                    </div>
                </div>
            </div>
				<!--</TABLE>
			</details>-->
		</xsl:if>
		<xsl:if test="normalize-space($activity) = 'FW'">

			<!-- Changed by Pooja on 23/12/19 [coaching related implementation] START -->
			<xsl:for-each select="//Detail1">
				<xsl:variable name="event_type">
					<xsl:value-of select="event_type" />
				</xsl:variable>
				<xsl:if test="event_type != 'CA'">
					<xsl:if test="normalize-space($form_name) = 'doctor'">
                        <div class="headerdata datafontsize">
                            Customer Call Details
                            <div class="tab">
                                <button type="button" class="rmvborder">
                                    <div class="btnborder align-imgtext">
                                        <IMG
                                            id="customer_details_btn" class="collapsibleIconRadius align-imgtext" 
                                            onclick="expandDetails('customer_details', 'customer_details_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                            <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                        </IMG>
                                    </div>
                                </button>
                            </div>
                        </div>
                            
                        <div id="customer_details">
						<!--<details open="true" id="RTR_SummaryPage_customer_listed_count">
							<summary class="summary">Customer Call Details</summary>-->
							<!-- <div style="overflow : scroll;"> -->
							<!--<TABLE class="tTitleD" border="0" width="100%"
								style="width:100%; z-index:9999999999;  ">-->
                            <div class="containerfeed">
								<xsl:for-each select="//node()[starts-with(name(), $detail)]">
									<xsl:variable name="strg_name">
										<xsl:value-of select="strg_name" />
									</xsl:variable>
									<xsl:variable name="strg_code">
										<xsl:value-of select="strg_code" />
									</xsl:variable>
									<xsl:variable name="order_form_no">
										<xsl:value-of select="order_form_no" />
									</xsl:variable>
									<xsl:variable name="locality_descr">
										<xsl:value-of select="locality_descr" />
									</xsl:variable>
									<xsl:variable name="call_outcome">
										<xsl:value-of select="call_outcome" />
									</xsl:variable>
									<xsl:variable name="domID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									<xsl:variable name="visited_with_team">
										<xsl:value-of select="visited_with_display" />
									</xsl:variable>
									<xsl:variable name="team_form_no">
										<xsl:value-of select="team_form_no" />
									</xsl:variable>
									<xsl:variable name="class_code_descr">
										<xsl:value-of select="class_code_descr" />
									</xsl:variable>
									<xsl:variable name="speciality_descr">
										<xsl:value-of select="speciality_descr" />
									</xsl:variable>
									<xsl:variable name="no_visit">
										<xsl:value-of select="strg_no_visit" />
									</xsl:variable>
									<xsl:variable name="event_time_start">
										<xsl:value-of select="event_time_start" />
									</xsl:variable>
									<xsl:variable name="event_time_end">
										<xsl:value-of select="event_time_end" />
									</xsl:variable>
									<xsl:variable name="pob_val">
										<xsl:value-of select="sku_value" />
									</xsl:variable>
									<xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
										<!--<xsl:value-of select="concat(meet_summ,',')" />-->
									</xsl:variable>
									<xsl:variable name="customer_type">
										<xsl:value-of select="cust_type" />
									</xsl:variable>
									<xsl:variable name="member_present">
										<xsl:value-of select="member_present" />
									</xsl:variable>
									<xsl:variable name="strg_type">
										<xsl:value-of select="strg_type" />
									</xsl:variable>

                                    <xsl:variable name="oth_participant">
                                        <xsl:value-of select="oth_participant" />
                                    </xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
                                    <xsl:variable name="plan_chg_reason">
										<xsl:value-of select="plan_chg_reason_descr" />
									</xsl:variable>

									<xsl:call-template name="tmpOrderFeed">
										<xsl:with-param name="orderFormName"
											select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'[',$strg_type,'||',$oth_participant,'$%',$reg_no,'%%',$is_fortune_activity,']',$plan_chg_reason)" />
									</xsl:call-template>

								</xsl:for-each>
                            </div>
							<!--</TABLE>-->
							<!-- </div> -->
						<!--</details>-->
                        </div>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			<!-- Changed by Pooja on 23/12/19 [coaching related implementation] END -->
			
			<xsl:if test="normalize-space($form_name) = 'brand'">
				<!--<details open="true">
					<summary class="summary">E-Detailing</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 cellttlblck heading tdLeft">Brand </TH>
								<TH CLASS="cellttl1 cellttlblck heading tdRight">Actual Order</TH>

							</TR>
						</thead>-->
                <div class="headerdata datafontsize">
                    E-Detailing
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="e_detailing_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('e_detailing', 'e_detailing_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="e_detailing">
                    <div class="containerfeed">
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="brand_code">
									<xsl:value-of select="brand_code" />
								</xsl:variable>
								<xsl:variable name="brand_descr">
									<xsl:value-of select="brand_descr" />
								</xsl:variable>
								<xsl:variable name="pitch_sequence">
									<xsl:value-of select="pitch_sequence" />
								</xsl:variable>
								<!--<TR>
									<TD CLASS="cellttl1 tdCenter title tdLeft">-->
                                <div class="customerDiv">
                                    <div class="iconborder align-imgtext">  
                                        <IMG
                                            SRC="{normalize-space($host_Url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($brand_code)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($brand_descr)}"
                                            onerror='this.src="../webitm/images/Summary/subform_edetailing.svg"'
                                            class="bradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="divToLeft addspace">
                                        <div class="headerfontsize">
                                            Brand
                                        </div>
                                        <div class="datafontsize">
										    <xsl:value-of select="$brand_descr" />
                                        </div>
                                    </div>
									<!--</TD>
									<TD CLASS="cellttl1 tdCenter title tdRight">-->
                                    <div class="align-imgtext rightcol-spacing">
                                        <div class="headerfontsize">
                                            Actual Order
                                        </div>
                                        <div class="datafontsize">
										    <xsl:value-of select="$pitch_sequence" />
                                        </div>
                                    </div>
                                </div>
									<!--</TD>
								</TR>-->
							</xsl:if>

						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
			<!-- Brand subform for Fortune -->
			<!--<xsl:if test="normalize-space($form_name) = 'brand'">
                <div class="headerdata datafontsize">
                    Product
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="e_detailing_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('e_detailing', 'e_detailing_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="e_detailing">
                    <div class="containerfeed">
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="brand_code">
									<xsl:value-of select="brand_code" />
								</xsl:variable>
								<xsl:variable name="brand_descr">
									<xsl:value-of select="brand_descr" />
								</xsl:variable>
								<xsl:variable name="pitch_detail_descr">
									<xsl:value-of select="pitch_detail_descr" />
								</xsl:variable>
                                <div class="customerDiv">
                                    <div class="iconborder align-imgtext">  
                                        <IMG
                                            SRC="{normalize-space($host_Url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($brand_code)}&amp;object=product&amp;objName=product&amp;ALT_FLD_VALUE={normalize-space($brand_descr)}"
                                            onerror='this.src="../webitm/images/Summary/subform_edetailing.svg"'
                                            class="bradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="divToLeft addspace">
                                        <div class="headerfontsize">
                                            Product
                                        </div>
                                        <div class="datafontsize">
										    <xsl:value-of select="$brand_descr" />
                                        </div>
                                    </div>
									<TD CLASS="cellttl1 tdCenter title tdRight">
                                    <div class="align-imgtext rightcol-spacing">
                                        <div class="headerfontsize">
                                            Status
                                        </div>
                                        <div class="datafontsize">
										    <xsl:value-of select="$pitch_detail_descr" />
                                        </div>
                                    </div>
                                </div>
							</xsl:if>

						</xsl:for-each>
                    </div>
                </div>
			</xsl:if>-->
			<!-- Brand subform for Fortune -->



			<xsl:if test="normalize-space($form_name) = 'sampleitem'">
				<!--<details open="true">
					<summary class="summary">Promotion</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 cellttlblck heading tdLeft">Item Usage</TH>
								<TH CLASS="cellttl1 cellttlblck heading">Product</TH>
								<TH CLASS="cellttl1 cellttlblck heading tdRight">Quantity</TH>
							</TR>
						</thead>-->
                <div class="headerdata datafontsize">
                    Promotion
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="promotion_details_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('promotion_details', 'promotion_details_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id= "promotion_details">
                        <!--<div>
                            <div>Item Usage</div>
                            <div>Product</div>
                            <div>Quantity</div>
                        </div>-->
                    <div class="containerfeed">
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
                                <xsl:variable name="item_code">
									<xsl:value-of select="item_code" />
								</xsl:variable>
								<xsl:variable name="item_descr_sample">
									<xsl:value-of select="item_descr" />
								</xsl:variable>
								<xsl:variable name="quantity_sample">
									<xsl:value-of select="quantity" />
								</xsl:variable>
								<xsl:variable name="item_usage">
									<xsl:value-of select="item_usage" />
								</xsl:variable>


								<!--<TR>
									<TD CLASS="cellttl1 tdLeft title">-->
                                <div class="itemOuterDiv">
                                    <div class="promotionDiv">
                                        <div class="iconborder align-imgtext">
                                            <IMG
                                                SRC="{normalize-space($host_Url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($item_code)}&amp;object=itemimages&amp;objName=itemimages&amp;ALT_FLD_VALUE={normalize-space($item_descr_sample)}"
                                                onerror='this.src="../webitm/images/Summary/subform_promotion.svg"' class="subformradius align-imgtext">
                                            </IMG>
										</div>
                                        <div class="hideoverflowfeed namespacing datafontsize align-imgtext">
                                        <!--</TD>
                                        <TD CLASS="cellttl1 tdCenter title">-->
                                            <xsl:value-of select="$item_descr_sample" />
                                        </div>
                                        <!--</TD>
                                        <TD CLASS="cellttl1 tdCenter title tdRight">-->
                                        <div class=" align-imgtext rightcol-spacing">
                                            <div class="datafontsize">
                                                <xsl:value-of select="$quantity_sample" /> 
                                            </div>
                                            <div class="headerfontsize"> Pieces </div>
                                        </div>
                                    </div>
                                </div>
									<!--</TD>
								</TR>-->
							</xsl:if>
						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
			<xsl:if test="normalize-space($form_name) = 'display'">
				<!--<details open="true">
					<summary class="summary"> Display</summary>-->
					<!-- <div id = "displayDr" style="display: none;"> -->
					<!--<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 tdCenter cellttlblck heading" style="text-align:left;">Display Area </TH>

							</TR>
						</thead>-->
                <div class="headerdata datafontsize">
                    Display Area
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="display_area_id_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('display_area_id', 'display_area_id_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="display_area_id">
                    <div class="containerfeed datafontsize">
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="doc_id">
									<xsl:value-of select="doc_id" />
								</xsl:variable>
								<xsl:variable name="display_area">
									<xsl:value-of select="display_area" />
								</xsl:variable>
								<!--<TR>
									<tr>
										<td CLASS="cellttl1 tdCenter title" style="text-align: left;">-->
                                <div class="customerDiv">
                                    <div class="iconborder align-imgtext">  
                                        <IMG
                                            SRC="{normalize-space($host)}/ibase/webitm/images/Summary/subform_display.svg"
                                            onerror='this.src="../webitm/images/Summary/subform_display.svg"'
                                            class="subformradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="divToLeft addspace">
                                        <div class="headerfontsize">
                                            Display Area
                                        </div>
                                        <div class="datafontsize">
										    <xsl:value-of select="display_area" />
                                        </div>
                                    </div>
                                </div>
										<!--</td>
									</tr>
									<tr>
										<td>-->
                                <div class="displayplugin">
                                    <div align='center' id="__attachmentDiv.{normalize-space(concat($doc_id,'_feed',''))}"
                                        style="text-align:center;white-space:nowrap;"></div>
                                    <img style="height:0px;width:0px;" src="_"
                                        onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space(concat($doc_id,'_feed',''))}', 'strg_meet_dcr_realtime_wiz', 'R-DCR', '{normalize-space($doc_id)}'); this.remove();" />
                                </div>
                                
                                        <!--</td>
									</tr>
								</TR>-->
							</xsl:if>
						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>

			<xsl:if test="normalize-space($form_name) = 'brandsurvey'">
				<details open="true">
					<summary class="summary">Prescription</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 cellttlblck heading tdLeft">Prescription Detail's</TH>

							</TR>
						</thead>

						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="item_descr">
									<xsl:value-of select="item_descr" />
								</xsl:variable>

								<TR>
									<TD CLASS="cellttl1 tdCenter title tdLeft">
										<xsl:value-of select="$item_descr" />
									</TD>
								</TR>
							</xsl:if>

						</xsl:for-each>
					</TABLE>
				</details>
			</xsl:if>
			<!-- Added by sadique shaikh 23-01-2020 [to display Survey data on summary if event_type is not mini methass] -->
			<xsl:if test="(//Detail1/event_type != 'MI') and (//Detail1/event_type != 'OT')">
				<xsl:if test="normalize-space($form_name) = 'survey'">
					<!--<details open="true">
						<summary class="summary">Survey</summary>
						<TABLE class="tTitleD" border="0" width="100%"
							style="z-index:9999999999;  ">
							<thead class="" style="height : 30px;">
								<TR>
									<TH CLASS="cellttl1 tdCenter cellttlblck heading tdLeft"> Survey Description </TH>
									<TH CLASS="cellttl1 tdCenter cellttlblck heading tdRight"> Survey Result </TH>
								</TR>
							</thead>-->
                    <div class="headerdata datafontsize">
                        Survey
                        <div class="tab">
                            <button type="button" class="rmvborder">
                                <div class="btnborder align-imgtext">
                                    <IMG
                                        id="survey_id_btn" class="collapsibleIconRadius align-imgtext" 
                                        onclick="expandDetails('survey_id', 'survey_id_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                        <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                    </IMG>
                                </div>
                            </button>
                        </div>
                    </div>

                    <div id="survey_id">
                        <div class="containerfeed datafontsize">

							<xsl:for-each select="//node()[starts-with(name(), $detail)]">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="survey_descr">
										<xsl:value-of select="survey_descr" />
									</xsl:variable>
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
										value in SURVEY master and same to in SURVEY form] Start -->
									<xsl:variable name="result_format">
										<xsl:value-of select="result_format" />
									</xsl:variable>
									<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
										value in SURVEY master and same to in SURVEY form] End -->
									<xsl:variable name="surv_doc_id">
										<xsl:value-of select="doc_id_2" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'N'">
												<xsl:value-of select="result1" />
											</xsl:when>
											<xsl:when test="$result_type = 'T'">
												<xsl:value-of select="result3" />
											</xsl:when>
											<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
												value in SURVEY master and same to in SURVEY form] Start -->
											<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
												<xsl:value-of select="result4" />
											</xsl:when>
											<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
												value in SURVEY master and same to in SURVEY form] End -->
											<xsl:otherwise>
												<xsl:value-of select="result2" />
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>

									<!--<tr>
										<TD CLASS="cellttl1 tdCenter title tdLeft">-->
                                    <div class="customerDiv">
                                        <div class="iconborder align-imgtext">  
                                            <IMG
                                                SRC="{normalize-space($host_Url)}/ibase/webitm/images/Summary/subform_survey.svg"
                                                onerror='this.src="../webitm/images/Summary/subform_survey.svg"'
                                                class="subformradius align-imgtext">
                                            </IMG>
                                        </div>
                                        <div class="divToLeft addspace">
                                            <div class="headerfontsize">
                                                Survey Description
                                            </div>
                                            <div class="datafontsize">
											    <xsl:value-of select="$survey_descr" /> 
                                            </div>
                                        </div>
                                        <div class="align-imgtext rightcol-spacing">
                                            <div class="headerfontsize">
                                                Survey Result
                                            </div>
                                            <div class="datafontsize">
                                                <xsl:choose>
                                                    <xsl:when test="$result = 'Y'">
                                                        Yes
                                                    </xsl:when>
                                                    <xsl:when test="$result = 'N'">
                                                        No
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:value-of select="$result" />
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </div>
                                        </div>
                                    </div>
										<!--</TD>
										<TD CLASS="cellttl1 tdCenter title tdRight">-->
											<!-- <xsl:value-of select="$result" /> -->
									
										<!--</TD>
                                        </tr>
                                        <tr>
                                            <td>-->
                                            
                                                <div align='center' id="__attachmentDiv.{normalize-space($surv_doc_id)}" style="text-align:center;white-space:nowrap;"></div>
                                                <img style="height:0px;width:0px;" src="_"
                                                    onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($surv_doc_id)}', 'strg_meet_dcr_realtime_wiz', 'R-DCR', '{normalize-space($surv_doc_id)}'); this.remove();" />

                                            <!--</td>
                                        </tr>-->
                                    
								</xsl:if>
							</xsl:for-each>
                        </div>
                    </div>
						<!--</TABLE>
					</details>-->
				</xsl:if>
			</xsl:if>

			<!-- Added by Pooja on 23/12/19 [coaching related implementation] START -->
			<xsl:if test="normalize-space($form_name) = 'coaching'">
				<!--<details open="true">
					<summary class="summary">Coaching Details</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="z-index:9999999999;  ">-->
						<!-- <thead class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1
							tdCenter cellttlblck heading tdLeft"> Survey Description </TH> <TH CLASS="cellttl1
							tdCenter cellttlblck heading tdRight"> Survey Result </TH> </TR> </thead> -->
                <div class="headerdata datafontsize">
                    Coaching Details
                    <div class="tab">
                        <button type="button" class="rmvborder">
                            <div class="btnborder align-imgtext">
                                <IMG
                                    id="coaching_details_btn" class="collapsibleIconRadius align-imgtext" 
                                    onclick="expandDetails('coaching_details', 'coaching_details_btn','{normalize-space($collapse)}','{normalize-space($expand)}')">
                                    <xsl:attribute name="src"> <xsl:value-of select="$collapse" /> </xsl:attribute>
                                </IMG>
                            </div>
                        </button>
                    </div>
                </div>

                <div id="coaching_details">
                    <div class="containerfeed datafontsize">

						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="survey_descr">
									<xsl:value-of select="survey_descr" />
								</xsl:variable>
								<xsl:variable name="result_type">
									<xsl:value-of select="result_type" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] Start -->
								<xsl:variable name="result_format">
									<xsl:value-of select="result_format" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] End -->
								<xsl:variable name="coaching_doc_id">
									<xsl:value-of select="doc_id_1" />
								</xsl:variable>
								<xsl:variable name="result">
									<xsl:choose>
										<xsl:when test="$result_type = 'N'">
											<xsl:value-of select="result1" />
										</xsl:when>
										<xsl:when test="$result_type = 'T'">
											<xsl:value-of select="result3" />
										</xsl:when>
										<xsl:when test="$result_type = 'A'">
											<xsl:value-of select="result5" />
										</xsl:when>
										<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
											<xsl:value-of select="result4" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="result2" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<!--<tr>
									<TD CLASS="cellttl1 tdCenter title tdLeft">-->
                                <div class="customerDiv">
                                    <div class="iconborder align-imgtext">  
                                        <IMG
                                            SRC="{normalize-space($host_Url)}/ibase/webitm/images/Summary/subform_survey.svg"
                                            onerror='this.src="../webitm/images/Summary/subform_survey.svg"'
                                            class="subformradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="divToLeft addspace">
                                        <div class="headerfontsize">
										    <xsl:value-of select="$survey_descr" />
                                        </div>
                                    </div>
									<!--</TD>
									<TD CLASS="cellttl1 tdCenter title tdRight">-->
										<!-- <xsl:value-of select="$result" /> -->
                                    <div class="align-imgtext rightcol-spacing datafontsize">
										<xsl:choose>
											<xsl:when test="$result = 'Y'">
												Yes
											</xsl:when>
											<xsl:when test="$result = 'N'">
												No
											</xsl:when>
											<xsl:otherwise>
												<!-- <xsl:value-of select="$result" /> -->
												<xsl:variable name="testVar" select="substring-after($result,'task_descr&quot;:&quot;')" />
												<xsl:value-of select="substring-before($testVar,'&quot;')" />
											</xsl:otherwise>
										</xsl:choose>
                                    </div>
                                </div>
									<!--</TD>
								</tr>
								<tr>
									<td>-->
                                    <div align='center'
                                        id="__attachmentDiv.{normalize-space($coaching_doc_id)}"
                                        style="text-align:center;white-space:nowrap;">
                                    </div>
									<!--</td>
								</tr>-->
							</xsl:if>
						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
			<!-- Added by Pooja on 23/12/19 [coaching related implementation] END -->
			<!-- Added by sadique shaikh 23-01-2020 [to display people trained in summary page] Start -->
			<xsl:if test="//Detail1/event_type = 'MI'">
				<xsl:if test="normalize-space($form_name) = 'survey'">
					<details open="true">
						<summary class="summary">People Trained</summary>
						<TABLE class="tTitleD" border="0" width="100%"
							style="z-index:9999999999;  ">
							<tr>
								<th CLASS="cellttl1 tdCenter title tdLeft">
									Attendee Name
								</th>
								<th CLASS="cellttl1 tdCenter title tdLeft">
									Mobile No.
								</th>
								<th CLASS="cellttl1 tdCenter title tdLeft">
									Remarks
								</th>
							</tr>
							<xsl:for-each select="//Detail7">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'A'">
												<xsl:value-of select="result5" />
											</xsl:when>
										</xsl:choose>
									</xsl:variable>
									<xsl:call-template name="peopleTrainedTemplate">
										<xsl:with-param name="result" select="$result" />
									</xsl:call-template>

								</xsl:if>
							</xsl:for-each>

						</TABLE>
					</details>
				</xsl:if>
			</xsl:if>
			<!-- Added by sadique shaikh 23-01-2020 [to display people trained in summary page] End -->
			<!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 START -->
			<xsl:if test="//Detail1/event_type = 'OT'">
				<xsl:if test="normalize-space($form_name) = 'survey'">
					<details open="true">
						<summary class="summary">Receipt</summary>
						<TABLE class="tTitleD" border="0" width="100%"
							style="z-index:9999999999;  ">
							<tr>
								<th CLASS="cellttl1 tdCenter title tdCenter" >
									Meter
								</th>
								<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
									Purchased Meter
								</th>
								<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
									Attachments
								</th>
							</tr>
							<xsl:for-each select="//Detail7">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'A'">
												<xsl:value-of select="result5" />
											</xsl:when>
										</xsl:choose>
									</xsl:variable>
									<xsl:call-template name="ReceiptTemplate">
										<xsl:with-param name="result" select="$result" />
									</xsl:call-template>
								</xsl:if>
							</xsl:for-each>
						</TABLE>
					</details>
				</xsl:if>
			</xsl:if>
            <!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 End -->
            <!-- Added by Sadique S. [ To display Other Details in summary page ] on 19-02-2020 Start -->
			<xsl:if test="//Detail1/event_type = 'OT'">
				<xsl:if test="normalize-space($form_name) = 'survey'">
				<details open="true">
					<summary class="summary">Other Details</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="z-index:9999999999;  ">
						<tr>
							<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
								Number of People Educated about SMBG
							</th>
							<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
								Meter puchased on same day
							</th>
							<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
								Remarks
							</th>
						</tr>
						<xsl:for-each select="//Detail1">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="member_present">
									<xsl:value-of select="member_present" />
								</xsl:variable>
								<xsl:variable name="pob_item">
									<xsl:value-of select="pob_item" />
								</xsl:variable>
								<xsl:variable name="remarks">
									<xsl:value-of select="remarks" />
								</xsl:variable>
						<tr>
							<TD CLASS="cellttl1 tdCenter title tdCenter">
										<xsl:value-of select="$member_present" />
							</TD>
							<TD CLASS="cellttl1 tdCenter title tdCenter">
										<xsl:value-of select="$pob_item" />
							</TD>
							<TD CLASS="cellttl1 tdCenter title tdCenter">
										<xsl:value-of select="$remarks" />
							</TD>
                        </tr>
						</xsl:if>
						</xsl:for-each>
					</TABLE>
				</details>
				</xsl:if>
        </xsl:if>
			 <!-- Added by Sadique S. [ To display Other Details in summary page ] on 19-02-2020 Start -->
			<!-- <xsl:if test="$remaining"> <xsl:call-template name="tmpSplitString">
				<xsl:with-param name="stringtosplit" select="$remaining" /> </xsl:call-template>
				</xsl:if> -->
		</xsl:if>
	</xsl:template>
	<xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="ord_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_call_outcome">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="visited_team">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="tm_form_no">
			<xsl:value-of select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="class_descr">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>
		<xsl:variable name="spl_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="no_visit">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="meet_summ">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="pob_val">
			<xsl:value-of select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>

		<xsl:variable name="member_presents">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'[')" />
		</xsl:variable>
		<!--<xsl:variable name="strg_types">
			<xsl:value-of select="substring-after($ord_value,'[')" />
		</xsl:variable>-->

		<xsl:variable name="strg_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'['),'||')" />
		</xsl:variable>

        <xsl:variable name="oth_participant">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'||'),'$%')" />
		</xsl:variable>

		<xsl:variable name="reg_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),'%%')" />
		</xsl:variable>
        
		<xsl:variable name="is_fortune_activity">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),']')" />
		</xsl:variable>
		<xsl:variable name="plan_chg_reason">
			<xsl:value-of select="substring-after($ord_value,']')" />
		</xsl:variable>

		<xsl:variable name="upImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Up.svg')" />
		</xsl:variable>
		<xsl:variable name="downImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Down.svg')" />
		</xsl:variable>
		<xsl:variable name="ord_detail">
			<xsl:value-of select="concat('Detail',$ord_form_no)" />
		</xsl:variable>
		<xsl:variable name="team_detail">
			<xsl:value-of select="concat('Detail',$tm_form_no)" />
		</xsl:variable>
		<xsl:variable name="call_outcome_descr">
			<xsl:if test="normalize-space($doc_call_outcome) = '5' ">
				Supporter
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '6' ">
				Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '7' ">
				Non Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '0' ">
				Refused
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="ord_listed_count">
			<xsl:if test="normalize-space($ord_form_no)!=''">

				<xsl:for-each select="//node()[starts-with(name(), $ord_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="order_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($order_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of select="count(//node()[starts-with(name(), $ord_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="team_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $team_detail)]">
				<xsl:if test="attribute/@updateFlag!='D'">

					<xsl:variable name="tm_strg_code">
						<xsl:value-of select="strg_code" />
					</xsl:variable>
					<xsl:if
						test="normalize-space($tm_strg_code) = normalize-space($doc_strg_code)">
						<xsl:value-of select="count(//node()[starts-with(name(), $team_detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

        <xsl:variable name="visited_code">
            <xsl:choose>
                <xsl:when test="$team_listed_count > '0'">
                    <xsl:for-each select="//node()[starts-with(name(), $team_detail)]">
                        <xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="team_strg_code">
                                <xsl:value-of select="strg_code" />
                            </xsl:variable>
                            <xsl:variable name="sales_pers">
                                <xsl:value-of select="sales_pers" />
                            </xsl:variable>
                            <xsl:if
                                test="normalize-space($team_strg_code) = normalize-space($doc_strg_code)">
                                <xsl:value-of select="$sales_pers" />
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="visited_name">
            <xsl:choose>
                <xsl:when test="$team_listed_count > '0'">
                    <xsl:for-each select="//node()[starts-with(name(), $team_detail)]">
                        <xsl:if test="attribute/@updateFlag!='D'">
                            <xsl:variable name="team_strg_code">
                                <xsl:value-of select="strg_code" />
                            </xsl:variable>
                            <xsl:variable name="name">
                                <xsl:value-of select="name" />
                            </xsl:variable>
                            <xsl:if
                                test="normalize-space($team_strg_code) = normalize-space($doc_strg_code)">
                                <xsl:value-of select="$name" />
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

		<xsl:choose>
			<xsl:when test="$ord_listed_count > '0'">
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>

							<td style="color: black; text-align:left;white-space:nowrap;">
								<div style="display: inline-block; width: 100%;">
									<div style="height: auto; float: left; width: 40px;">-->
                <div>
                    <div class="customerDiv">
                        <div class="iconborder bluebg-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
                                onerror='this.src="images/map/user.png"'
                                class="bradius align-imgtext">
                            </IMG>
                                <!--style=" padding: 5px; height: 30px; width: 30px; border-radius: 50%;"-->
                            
                        </div>
                    
									<!--<div style="width: calc(100% - 40px); float: right;">
										<div>-->
											<!--<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;">-->
                        <div class="addspace large-font">
                            <div class="datafontsize">
                                <xsl:value-of
                                    select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
							</div>
                            <div class="small-font">
                                <!--<div style="float: right; height: 18px; width: 18px;">
                                    <img id="{normalize-space($doc_strg_code)}" style="height: 10px; width: 10px; padding: 4px;"
                                        onClick="showDetailsOrder(this.id,'{normalize-space($upImage)}','{normalize-space($downImage)}')">
                                        <xsl:attribute name="src"><xsl:value-of
                                            select="$upImage" />
                                        </xsl:attribute>
                                    </img>
                                </div>-->
                                        <!--</div>-->
										<!--<br></br>-->
                                        <!--<div style="color: gray;text-align: left;">-->
                                Customer Type
                                <xsl:value-of select="$customer_types" />
                            </div>
                        </div>
                    </div>
                    <xsl:if test="normalize-space($strg_types) = 'D' ">
                        <xsl:if test="normalize-space($class_descr) != ''">
                            <!--<div style="color: gray;text-align: left;">-->
                            <div class="customerDiv">
                                <div class="iconborder align-imgtext class-icon">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_class.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_class.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        Class
                                    </div>
                                    <div class="hideoverflowfeed datafontsize">
                                        <xsl:value-of select="$class_descr" />
                                    </div>
                                </div>
                            </div>

                        </xsl:if>
                        <xsl:if test="normalize-space($spl_description) != ''">
                            <!--<div style="color: gray;text-align: left;">-->
                            <div class="customerDiv">
                                <div class="iconborder align-imgtext speciality-icon">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        Speciality
                                    </div>
                                    <div class="hideoverflowfeed datafontsize">
                                        <xsl:value-of select="$spl_description" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
                        <xsl:if test="normalize-space($no_visit) != ''">
                            <!--<div style="color: gray;text-align: left;">-->
                            <div class="customerDiv">
                                <div class="iconborder visitplan-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_visit.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_visit.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        No Of Visits
                                    </div>
                                    <div class="hideoverflowfeed datafontsize">
                                        <xsl:value-of select="$no_visit" /> 
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
                    </xsl:if>
                    <!--changes by shraddha M for listed/unlisted case [20/07/2020]-->
                    <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                        <!--<div style="color: gray;text-align: left;">-->
                        <!-- Visit Time From: -->
                        <div class="customerDiv">
                            <div class="iconborder timeofcall-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Visit Time
                                </div>
                                <div class="hideoverflowfeed datafontsize">
                                    <xsl:value-of select="$event_time_start" />
                                </div>
                            </div>
                        </div>
                    </xsl:if>
                    
                    <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                        <!--<div style="color: gray;text-align: left;">-->
                        <!--  Visit Time From:-->
                        <div class="customerDiv">
                            <div class="iconborder timeofcall-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Time Of First Call
                                </div>
                                <div class="datafontsize">
                                    <xsl:value-of select="$event_time_start" />
                                </div>
                            </div>
                        </div>
                        <div class="customerDiv">
                            <div class="iconborder timeofcall-icon align-imgtext">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Time Of First Call
                                </div>
                                <div class="datafontsize">
                                    <xsl:value-of select="$event_time_end" />
                                </div>
                            </div>
                        </div>
                        <!--<div style="color: gray;text-align: left;">
                        Time Of Last Call:
                        <xsl:value-of select="$event_time_end" />
                        </div>-->
                    </xsl:if>
                    <!--changes by shraddha M for listed/unlisted case [20/07/2020]-->
                    <!--<div style="color: gray;text-align: left;">-->
                    <div class="customerDiv">
                        <div class="iconborder pobvalue-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_values.svg"
                                onerror='this.src="../webitm/images/Summary/summary_values.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                POB Value
                            </div>
                            <div class="datafontsize">
                                <xsl:value-of select="$pob_val" />
                            </div>
                        </div>
                    </div>

                    <xsl:if test="normalize-space($strg_types)='O'">                    
                            <div class="customerDiv">
                                <div class="iconborder euin-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        EUIN No
                                    </div>
                                    <div class="datafontsize">
                                        <xsl:value-of select="$oth_participant" />
                                    </div>
                                </div>
                            </div>
                            <div class="customerDiv">
                                <div class="iconborder regno-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        ARN No
                                    </div>
                                    <div class="datafontsize">
                                        <xsl:value-of select="$reg_no" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
					<xsl:if test="normalize-space($plan_chg_reason) != ''">
                        <div class="customerDiv">
                            <div class="iconborder beatchange-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_beatchange.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_beatchange.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
								<div class="detailtext headerfontsize">
									Reason for Beat Change
								</div>
                                <div class="datafontsize">
                                    <xsl:value-of select="$plan_chg_reason" />
                                </div>
                            </div>
                        </div>
                    </xsl:if>
                    <!--<div style="color: gray;text-align: left;">-->
                    <div class="customerDiv">
                        <div class="iconborder remarks-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                onerror='this.src="../webitm/images/Summary/summary_remarks.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Remarks
                            </div>
                            <div class="datafontsize"> 
                                <div class="datafontsize">
                                    <xsl:value-of select="$meet_summ" />
                                </div>
                                <!--<xsl:call-template name="meetTemp">
                                    <xsl:with-param name="stringtosplitRemark"
                                        select="$meet_summ" />
                                </xsl:call-template>-->
                            </div>
                        </div>
                    </div>

                    <!--<div
                        style="color: gray; float: left; white-space: normal;width: 100%;">-->
                    <div class="customerDiv">
                        <div class="iconborder visitedwith-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($visited_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($visited_name)}"
                                onerror='this.src="../webitm/images/Summary/summary_visited.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Team
                            </div>
                            <div class="datafontsize">
                                <xsl:choose>
                                    <xsl:when test="$team_listed_count > '0'">
                                        <xsl:call-template name="tempTeamData">
                                            <xsl:with-param name="teamData"
                                                select="concat($team_detail,'@',$doc_strg_code)" />
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="string-length($visited_team) != 0">
                                        <xsl:value-of select="$visited_team" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </div>
                        </div>
                    </div>
                    <!--<div
                        style="color: gray; float: left; white-space: normal;width: 100%;">-->
                    <div class="customerDiv">
                        <div class="iconborder remarks-icon">
                            <IMG
                                SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place.svg"
                                onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                class="bradius align-imgtext">
                            </IMG>
                        </div>
                        <div class="namespacing">
                            <div class="detailtext headerfontsize">
                                Beat 
                            </div>
                            <div class="datafontsize">
                                <xsl:value-of select="$doc_locality" />
                            </div>
                        </div>
                    </div>
                    
                </div>
								<!--</div>
							</td>

						</tr>-->
						<xsl:call-template name="tempOrderDataFeed">
							<xsl:with-param name="orderData"
								select="concat($ord_detail,'@',$doc_strg_code,'##',$ord_host_url)" />
						</xsl:call-template>
					<!--</thead>
				</TABLE>-->
			</xsl:when>
			<xsl:otherwise>
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black;text-align:left;white-space:nowrap;">
								<div style="display: inline-block; width: 100%;">
									<div style="height: auto; float: left; width: 40px;">-->
                    <div>
                        <div class="customerDiv">
                            <div class="iconborder bluebg-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
                                    onerror='this.src="images/map/user.png"'
                                    class="bradius align-imgtext">
                                    <!--style=" padding: 5px; height: 30px; width: 30px; border-radius: 50%;">-->
                                </IMG>
                            </div>
									<!--<div style="width: calc(100% - 40px); float: right;">
										<div
											style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;">-->
                            <div class="addspace large-font">
                                <div class="datafontsize">
                                    <xsl:value-of
                                        select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
                                </div>
                                <div class="small-font">
                                    <!--<div style="float: right; height: 18px; width: 18px;">
										<br></br>
										<div style="color: gray;text-align: left;">-->
                                        Customer Type
                                        <xsl:value-of select="$customer_types" />
                                    <!--</div>-->
                                </div>
                            </div>
                        </div>
                        <xsl:if test="normalize-space($strg_types) = 'D' ">
                            <xsl:if test="normalize-space($class_descr) != ''">
                                <!--<div style="color: gray;text-align: left;">-->
                                <div class="customerDiv">
                                    <div class="iconborder align-imgtext class-icon">
                                        <IMG
                                            SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_class.svg"
                                            onerror='this.src="../webitm/images/Summary/summary_class.svg"'
                                            class="bradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="namespacing">
                                        <div class="detailtext headerfontsize">
                                            Class
                                        </div>
                                        <div class="hideoverflowfeed datafontsize">
                                            <xsl:value-of select="$class_descr" />
                                        </div>
                                    </div>
                                </div>

                            </xsl:if>
                            <xsl:if test="normalize-space($spl_description) != ''">
                                <!--<div style="color: gray;text-align: left;">-->
                                <div class="customerDiv">
                                    <div class="iconborder align-imgtext speciality-icon">
                                        <IMG
                                            SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_speciality.svg"
                                            onerror='this.src="../webitm/images/Summary/summary_speciality.svg"'
                                            class="bradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="namespacing">
                                        <div class="detailtext headerfontsize">
                                            Speciality
                                        </div>
                                        <div class="hideoverflowfeed datafontsize">
                                            <xsl:value-of select="$spl_description" />
                                        </div>
                                    </div>
                                </div>
                            </xsl:if>
                            <xsl:if test="normalize-space($no_visit) != ''">
                                <!--<div style="color: gray;text-align: left;">-->
                                <div class="customerDiv">
                                    <div class="iconborder visitplan-icon align-imgtext">
                                        <IMG
                                            SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_visit.svg"
                                            onerror='this.src="../webitm/images/Summary/summary_visit.svg"'
                                            class="bradius align-imgtext">
                                        </IMG>
                                    </div>
                                    <div class="namespacing">
                                        <div class="detailtext headerfontsize">
                                            No Of Visits
                                        </div>
                                        <div class="hideoverflowfeed datafontsize">
                                            <xsl:value-of select="$no_visit" />
                                        </div>
                                    </div>
                                </div>
                            </xsl:if>
                        </xsl:if>
                        <!--changes by shraddha M for listed/unlisted case [20/07/2020]-->
                        <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                            <!--<div style="color: gray;text-align: left;">-->
                            <!-- Visit Time From: -->
                            <div class="customerDiv">
                                <div class="iconborder timeofcall-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        Visit Time
                                    </div>
                                    <div class="hideoverflowfeed datafontsize">
                                        <xsl:value-of select="$event_time_start" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
                        
                        <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                            <!--<div style="color: gray;text-align: left;">-->
                            <!--  Visit Time From:-->
                            <div class="customerDiv">
                                <div class="iconborder timeofcall-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        Time Of First Call
                                    </div>
                                    <div class="datafontsize">
                                        <xsl:value-of select="$event_time_start" />
                                    </div>
                                </div>
                            </div>
                            <div class="customerDiv">
                                <div class="iconborder timeofcall-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_time.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_time.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        Time Of First Call
                                    </div>
                                    <div class="datafontsize">
                                        <xsl:value-of select="$event_time_end" />
                                    </div>
                                </div>
                            </div>
                            <!--<div style="color: gray;text-align: left;">
                            Time Of Last Call:
                            <xsl:value-of select="$event_time_end" />
                            </div>-->
                        </xsl:if>
                        <!--changes by shraddha M for listed/unlisted case [20/07/2020]-->
                        <!--<div style="color: gray;text-align: left;">-->
                        <div class="customerDiv">
                            <div class="iconborder pobvalue-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_values.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_values.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    POB Value
                                </div>
                                <div class="datafontsize">
                                    <xsl:value-of select="$pob_val" />
                                </div>
                            </div>
                        </div>

                        <xsl:if test="normalize-space($strg_types)='O'">                    
                            <div class="customerDiv">
                                <div class="iconborder euin-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        EUIN No
                                    </div>
                                    <div class="datafontsize">
                                        <xsl:value-of select="$oth_participant" />
                                    </div>
                                </div>
                            </div>
                            <div class="customerDiv">
                                <div class="iconborder regno-icon align-imgtext">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_numeric.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_numeric.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        ARN No
                                    </div>
                                    <div class="datafontsize">
                                        <xsl:value-of select="$reg_no" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
						<xsl:if test="normalize-space($plan_chg_reason) != ''">
                            <div class="customerDiv">
                                <div class="iconborder beatchange-icon">
                                    <IMG
                                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_beatchange.svg"
                                        onerror='this.src="../webitm/images/Summary/summary_beatchange.svg"'
                                        class="bradius align-imgtext">
                                    </IMG>
                                </div>
                                <div class="namespacing">
                                    <div class="detailtext headerfontsize">
                                        Reason for Beat Change
                                    </div>
                                    <div class="datafontsize">
                                        <xsl:value-of select="$plan_chg_reason" />
                                    </div>
                                </div>
                            </div>
                        </xsl:if>
                        <!--<div style="color: gray;text-align: left;">-->
                        <div class="customerDiv">
                            <div class="iconborder remarks-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_remarks.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_remarks.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Remarks
                                </div>
                                <div class="datafontsize"> 
                                    <div class="datafontsize">
                                        <xsl:value-of select="$meet_summ" />
                                    </div>
                                    <!--<xsl:call-template name="meetTemp">
                                        <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                                </div>
                            </div>
                        </div>

                        <!--<div
                            style="color: gray; float: left; white-space: normal;width: 100%;">-->
                        <div class="customerDiv">
                            <div class="iconborder visitedwith-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($visited_code)}&amp;object=slpers&amp;objName=slpers&amp;ALT_FLD_VALUE={normalize-space($visited_name)}"
                                    onerror='this.src="../webitm/images/Summary/summary_visited.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Team
                                </div>
                                <div class="datafontsize">
                                    <xsl:choose>
                                        <xsl:when test="$team_listed_count > '0'">
                                            <xsl:call-template name="tempTeamData">
                                                <xsl:with-param name="teamData"
                                                    select="concat($team_detail,'@',$doc_strg_code)" />
                                            </xsl:call-template>
                                        </xsl:when>
                                        <xsl:when test="string-length($visited_team) != 0">
                                            <xsl:value-of select="$visited_team" />
                                        </xsl:when>
                                        <xsl:otherwise>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </div>
                            </div>
                        </div>
                        <!--<div
                            style="color: gray; float: left; white-space: normal;width: 100%;">-->
                        <div class="customerDiv">
                            <div class="iconborder remarks-icon">
                                <IMG
                                    SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/summary_place.svg"
                                    onerror='this.src="../webitm/images/Summary/summary_place.svg"'
                                    class="bradius align-imgtext">
                                </IMG>
                            </div>
                            <div class="namespacing">
                                <div class="detailtext headerfontsize">
                                    Beat 
                                </div>
                                <div class="datafontsize">
                                    <xsl:value-of select="$doc_locality" />
                                </div>
                            </div>
                        </div>
                        
                    </div>
							<!--</td>
							<td CLASS="cellttl1 tdCenter title"></td>
						</tr>

					</thead>
				</TABLE>-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>
        <xsl:variable name="order_details">
			<xsl:value-of select="substring-before($order_data_value,'@')" />
		</xsl:variable>
        <xsl:variable name="dcotor_cust_code">
			<xsl:value-of select="substring-before(substring-after($order_data_value, '@'), '##')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-after($order_data_value,'##')" />
		</xsl:variable>
		<!--<TABLE class="tTitleD" border="0" width="100%"
			style="z-index:9999999999;background-color: #f0eded;">
			<thead class="" style="height : 30px;">-->
	 <!-- Added by Hariom S. [ To display Order header ] on 21-08-2020 Start -->
			<!--<TR id="order.{normalize-space($dcotor_cust_code)}.heading1">	-->		
						<!-- <th style="text-align: center;">Order</th>
						<th></th>
						<th></th>
						<th></th> -->
						<!--<summary class="summary">Order</summary>
					</TR>-->
					 <!-- Added by Hariom S. [ To display Order header ] on 21-08-2020 End -->
				<!--<TR id="order.{normalize-space($dcotor_cust_code)}.heading">
					<TH CLASS="cellttl1 cellttlblck heading tdLeft">Product</TH>
					<TH CLASS="cellttl1 cellttlblck heading tdRight">Quantity</TH>
					<TH CLASS="cellttl1 cellttlblck heading tdRight">Value</TH>
					<TH CLASS="cellttl1 cellttlblck heading tdRight">Scheme Description</TH>
				</TR>
			</thead>
			<tbody id="order.{normalize-space($dcotor_cust_code)}.details">-->
            <div class="orderFormHeader datafontsize">
                <!--<div class="iconborder">
                    <IMG
                        SRC="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/subform_order.svg"
                        onerror='this.src="../webitm/images/Summary/subform_order.svg"'
                        class="bradius align-imgtext">
                    </IMG>
                </div>
                <div class="addspace">-->
                    Order
                <!--</div>-->
            </div>
				<xsl:for-each select="//node()[starts-with(name(), $order_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="ord_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
                        <xsl:variable name="item_code">
							<xsl:value-of select="item_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="ordervalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="Scheme_description">
							<xsl:value-of select="description" />
						</xsl:variable>
						<xsl:variable name="remark_descr">
                            <xsl:value-of select="remark_descr" />
                        </xsl:variable>
                        <xsl:variable name="order_remarks">
                            <xsl:value-of select="remarks_ord" />
                        </xsl:variable>
						<xsl:if
							test="normalize-space($ord_strg_code) = normalize-space($dcotor_cust_code)">
                            <div class="itemOuterDiv">
							<!--<TR style="background-color: #f0eded;">
								<TD CLASS="cellttl1 tdCenter title tdLeft">-->
                                <div class="sampleOrderDiv">
                                    <div>
                                        <div class="iconborder product-icon align-imgtext">
                                            <IMG
                                                SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($item_code)}&amp;object=wsfa_item&amp;objName=wsfa_item&amp;ALT_FLD_VALUE={normalize-space($item_descr)}"
                                                onerror='this.src="{normalize-space($ord_host_url)}/ibase/webitm/images/Summary/product.svg"' class="bradius align-imgtext">
                                            </IMG>
                                        </div>
                                    </div>
									<div class="itmdescrFeed">
                                        <div class="namespacing datafontsize align-imgtext adjMargin">
                                            <div class="hideoverflowfeed datafontsize">
                                                <xsl:value-of select="$item_descr" />
                                            </div>
                                            <!--<xsl:if test="normalize-space($Scheme_description) != '' ">-->
                                                <div class="headerfontsize alignLeft mgnTop">
                                                    <xsl:value-of select="$Scheme_description" />
                                                </div>
                                            <!--</xsl:if>-->
                                        </div>
                                        <!--</TD>
                                        <TD CLASS="cellttl1 tdCenter title tdRight">-->
                                        <div class="align-imgtext rightcol-spacing adjPadding">
                                            <div class="textcolor">
                                                Qty <span class="datafontsize"> <xsl:value-of select="$quantity" /> </span>
                                            </div>
                                            <div class="textcolor">
                                                &#x20b9; <span class="datafontsize"> <xsl:value-of select="$ordervalue" /> </span>
                                            </div>
                                        </div>
									</div>
									<xsl:if test="normalize-space($remark_descr) != '' ">
										<div class="datafontsize alignLeft">
                                            <span class="headerfontsize"> Focus Deviation Reason : </span> <xsl:value-of select="$remark_descr" />
                                        </div>
                                    </xsl:if>
                                    <xsl:if test="normalize-space($order_remarks) != '' ">
                                        <div class="datafontsize alignLeft"> <span class="headerfontsize"> Remarks : </span> <xsl:value-of select="$order_remarks" /> </div>
									</xsl:if>
									
								<!--</TD>
								<TD CLASS="cellttl1 tdCenter title tdRight">-->
									
								<!--</TD>
								<TD CLASS="cellttl1 tdCenter title tdRight">-->
								</div>
                            </div>
                            <div class="horizontal-border"></div>
								<!--</TD>
							</TR>-->
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			<!--</tbody>
		</TABLE>-->
	</xsl:template>


	<xsl:template name="tmpSplitString">
		<xsl:param name="stringtosplit" />


		<xsl:variable name="value">
			<xsl:value-of select="$stringtosplit" />
		</xsl:variable>

		<xsl:variable name="form_name">
			<xsl:value-of select="substring-before($value,'(')" />
		</xsl:variable>

		<xsl:variable name="form_no">
			<xsl:value-of select="substring-before(substring-after($value, '('), '|')" />
		</xsl:variable>

		<xsl:variable name="activity">
			<xsl:value-of select="substring-before(substring-after($value, '|'), '*')" />
		</xsl:variable>
		<xsl:variable name="place_mandatory">
			<xsl:value-of select="substring-before(substring-after($value, '*'), '#')" />
		</xsl:variable>
		<xsl:variable name="host">
			<xsl:value-of select="substring-after($value,'#')" />
		</xsl:variable>

		<xsl:variable name="detail">
			<xsl:value-of select="concat('Detail',$form_no)" />
		</xsl:variable>


		<xsl:if test="normalize-space($form_name) = 'doctor'">

			<!--<details open="true" id="RTR_SummaryPage_place_listed_count">
				<summary class="summary" id="RTR_SummaryPage_place_listed_count"
					style="float: left;">Place Details</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
            <div class="headerdata datafontsize">
                Beat Details
            </div>
            <div class="containertable">
                <div class="doctorcontainer datafontsize">

                    <div class="doctordetails textcolor ">
                        <div  class="place_of_visit seperatorDiv headerfontsize">BEAT OF VISIT</div>
                        <div  class="visited-with seperatorDiv headerfontsize">VISITED WITH</div>
                        <div class="order_of_visit seperatorDiv headerfontsize">ORDER OF VISIT</div>
                    </div>
					<xsl:for-each select="//node()[starts-with(name(), $detail)]">
						<xsl:variable name="locality_descr">
							<xsl:value-of select="locality_descr" />
						</xsl:variable>
						<xsl:variable name="travel_mode">
							<xsl:value-of select="travel_mode" />
						</xsl:variable>
						<xsl:variable name="order_of_visit">
							<xsl:value-of select="order_of_visit" />
						</xsl:variable>
						<xsl:variable name="station_descr">
							<xsl:value-of select="station_descr" />
						</xsl:variable>
                        <xsl:variable name="visited_with">
							<xsl:value-of select="visited_with" />
						</xsl:variable>

						<!--<TR>

							<TD CLASS="cellttl1 tdCenter title ">
								<div style="display: inline-block; width: 100%;">
									<div
										style="height: auto; float: left; width: 40px; background: :gray;">
										<img
											src="{normalize-space($host)}/ibase/webitm/images/Summary/summary_place.svg"
											style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;"></img>
									</div>
									<div style="width: calc(100% - 40px); float: right;">
										<div style="float: left; color: gray;">
											Place
										</div>
										<br />
										<div style="float: left; white-space: normal;">
											<xsl:value-of select="$locality_descr" />
											<xsl:if test="station_descr != ''">
											<xsl:value-of select="concat(' ','(',$station_descr,')')" />
											</xsl:if>
										</div>
									</div>
								</div>
							</TD>


						</TR>-->
                        <div class="visitsdetails datafontsize">
                                
                            <div class="place_of_visit">
                                <xsl:value-of select="$locality_descr" />
                            </div>

                            <div class="visited-with">
                                <xsl:value-of select="$visited_with" />
                            </div>

                            <div class="order_of_visit"> 
                                <xsl:value-of select="$order_of_visit" />
                            </div>	                                    

                        </div>

					</xsl:for-each>
                </div>
            </div>
				<!--</TABLE>
			</details>
			<details open="true" id="RTR_SummaryPage_place_listed_count">
				<summary class="summary" id="RTR_SummaryPage_place_listed_count"
					style="float: left;">Worked with Details</summary>
				<TABLE class="tTitleD" border="0" width="100%"
					style="width:100%; z-index:9999999999;  ">-->
                        
					<!--<xsl:for-each select="//node()[starts-with(name(), $detail)]">
						<xsl:variable name="visited_with">
							<xsl:value-of select="visited_with" />
						</xsl:variable>-->
						<!--<TR>
							<TD CLASS="cellttl1 tdCenter title ">
								<div style="display: inline-block; width: 100%;">
									<div
										style="height: auto; float: left; width: 40px; background: :gray;">
										<img
											src="{normalize-space($host)}/ibase/webitm/images/Summary/worked_with.svg"
											style="padding: 7.5px; height: 15px; width: 15px; background: lightgray; border-radius: 50%;"></img>
									</div>
									<div style="width: calc(100% - 40px); float: right;">
										<div style="float: left; color: gray;">
											Worked With
										</div>
										<br />
										<div style="float: left; white-space: normal;">
											<xsl:value-of select="$visited_with" />
										</div>
									</div>
								</div>
							</TD>


						</TR>-->

					<!--</xsl:for-each>
               
				</TABLE>
			</details>-->
		</xsl:if>
		<xsl:if test="normalize-space($activity) = 'FW'">

			<!-- Changed by Pooja on 23/12/19 [coaching related implementation] START -->
			<xsl:for-each select="//Detail1">
				<xsl:variable name="event_type">
					<xsl:value-of select="event_type" />
				</xsl:variable>
                <xsl:variable name="strg__types">
                    <xsl:value-of select="strg_type" />
                </xsl:variable>
                <xsl:variable name="customer_types">
                    <xsl:value-of select="cust_type" />
                </xsl:variable>
				<xsl:if test="event_type != 'CA'">
					<xsl:if test="normalize-space($form_name) = 'doctor'">

						<!--<details open="true" id="RTR_SummaryPage_customer_listed_count">
							<summary class="summary">Customer Call Details</summary>-->
							<!-- <div style="overflow : scroll;"> -->
							<!--<TABLE class="tTitleD" border="0" width="100%"
								style="width:100%; z-index:9999999999;  ">-->
                        <div class="headerdata datafontsize">
                            Customer Call Details
                        </div>
                        <div class="containertable">
                            <div class="doctorcontainer datafontsize">
                                <xsl:if test="normalize-space($strg__types) = 'D' ">
                                    <div class="doctordetails textcolor">
                                        <div  class="seperatorDiv headingwidth firstcolumn customername_doc">CUSTOMER NAME</div>
                                        <div  class="customertypes_doc seperatorDiv headingwidth">CUSTOMER TYPE</div>
                                        <div class="classdescr_doc seperatorDiv headingwidth">CLASS</div>
                                        <div  class="spldescription_doc seperatorDiv headingwidth">SPECIALITY</div>
                                        <div  class="novisit_doc seperatorDiv headingwidth">NO OF VISIT</div>
                                        <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                                            <div class="visittime_doc seperatorDiv headingwidth">VISIT TIME</div>
                                        </xsl:if>
                                        <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                                            <div class="eventtimestart_doc seperatorDiv headingwidth">TIME OF FIRST CALL</div>
                                            <div class="eventtimestart_doc seperatorDiv headingwidth">TIME OF LAST CALL</div>
                                        </xsl:if>
                                        <div class="pobvalue_doc seperatorDiv headingwidth">POB VALUE</div>
                                         <div  class="planChgRsn seperatorDiv headingwidth">REASON FOR BEAT CHANGE</div>
                                        <div  class="remarks_doc seperatorDiv headingwidth">REMARKS</div>
                                        <div  class="team_doc seperatorDiv headingwidth">TEAM</div>
                                        <div class="doclocality_doc seperatorDiv headingwidth lastcolumn">BEAT</div>
                                    </div>
                                </xsl:if>
                                <xsl:if test="normalize-space($strg__types) != 'D' ">
                                    <div class="doctordetails textcolor">
                                        <div class="seperatorDiv headingwidth firstcolumn customernameDiv">CUSTOMER NAME</div>
                                        <div class="customertypesDiv seperatorDiv headingwidth">CUSTOMER TYPE</div>
                                        <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                                            <div class="visittimeDiv seperatorDiv headingwidth">VISIT TIME</div>
                                        </xsl:if>
                                        <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                                            <div class="eventtimestartDiv seperatorDiv headingwidth">TIME OF FIRST CALL</div>
                                            <div class="eventtimestartDiv seperatorDiv headingwidth">TIME OF LAST CALL</div>
                                        </xsl:if>
                                        <div class="pobvalueDiv seperatorDiv headingwidth">POB VALUE</div>
                                        <xsl:if test="normalize-space($strg__types) = 'O' ">
                                            <div class="euin-no seperatorDiv headingwidth">EUIN NO</div>
                                            <div class="reg-no seperatorDiv headingwidth">ARN NO</div>
                                        </xsl:if>
                                        <div  class="planChgRsn seperatorDiv headingwidth">REASON FOR BEAT CHANGE</div>
                                        <div  class="remarksDiv seperatorDiv headingwidth">REMARKS</div>
                                        <div  class="teamDiv seperatorDiv headingwidth">TEAM</div>
                                        <div class="doclocalityDiv seperatorDiv headingwidth lastcolumn">BEAT</div>
                                    </div>
                                </xsl:if>
								<xsl:for-each select="//node()[starts-with(name(), $detail)]">
									<xsl:variable name="strg_name">
										<xsl:value-of select="strg_name" />
									</xsl:variable>
									<xsl:variable name="strg_code">
										<xsl:value-of select="strg_code" />
									</xsl:variable>
									<xsl:variable name="order_form_no">
										<xsl:value-of select="order_form_no" />
									</xsl:variable>
									<xsl:variable name="locality_descr">
										<xsl:value-of select="locality_descr" />
									</xsl:variable>
									<xsl:variable name="call_outcome">
										<xsl:value-of select="call_outcome" />
									</xsl:variable>
									<xsl:variable name="domID">
										<xsl:value-of select="@domID" />
									</xsl:variable>
									<xsl:variable name="visited_with_team">
										<xsl:value-of select="visited_with_display" />
									</xsl:variable>
									<xsl:variable name="team_form_no">
										<xsl:value-of select="team_form_no" />
									</xsl:variable>
									<xsl:variable name="class_code_descr">
										<xsl:value-of select="class_code_descr" />
									</xsl:variable>
									<xsl:variable name="speciality_descr">
										<xsl:value-of select="speciality_descr" />
									</xsl:variable>
									<xsl:variable name="no_visit">
										<xsl:value-of select="strg_no_visit" />
									</xsl:variable>
									<xsl:variable name="event_time_start">
										<xsl:value-of select="event_time_start" />
									</xsl:variable>
									<xsl:variable name="event_time_end">
										<xsl:value-of select="event_time_end" />
									</xsl:variable>
									<xsl:variable name="pob_val">
										<xsl:value-of select="sku_value" />
									</xsl:variable>
									<xsl:variable name="meet_summ">
                                        <xsl:value-of select="remarks" />
										<!--<xsl:value-of select="concat(meet_summ,',')" />-->
									</xsl:variable>
									<xsl:variable name="customer_type">
										<xsl:value-of select="cust_type" />
									</xsl:variable>
									<xsl:variable name="member_present">
										<xsl:value-of select="member_present" />
									</xsl:variable>
									<xsl:variable name="strg_type">
										<xsl:value-of select="strg_type" />
									</xsl:variable>

                                    <xsl:variable name="oth_participant">
                                        <xsl:value-of select="oth_participant" />
                                    </xsl:variable>
                                    <xsl:variable name="reg_no">
                                         <xsl:value-of select="reg_no" />
                                    </xsl:variable>
                                    <xsl:variable name="is_fortune_activity">
                                         <xsl:value-of select="is_fortune_activity" />
                                    </xsl:variable>
									<xsl:variable name="plan_chg_reason">
										<xsl:value-of select="plan_chg_reason_descr" />
									</xsl:variable>
									<xsl:call-template name="tmpOrder">
										<xsl:with-param name="orderFormName"
											select="concat($host,'@',$order_form_no,'#',$strg_name,'(',$call_outcome,'*',$strg_code,'!',$locality_descr,'|',$visited_with_team,'^',$team_form_no,'+',$class_code_descr,'**',$speciality_descr,'~',$no_visit,'##',$meet_summ,'%',$event_time_start,'?',$event_time_end,'{',$pob_val,'}',$customer_type,'@@',$member_present,'[',$strg_type,'||',$oth_participant,'$%',$reg_no,'%%',$is_fortune_activity,']',$plan_chg_reason)" />
									</xsl:call-template>

								</xsl:for-each>
                            </div>
                        </div>
							<!--</TABLE>-->
							<!-- </div> -->
						<!--</details>-->
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			<!-- Changed by Pooja on 23/12/19 [coaching related implementation] END -->
			
			<xsl:if test="normalize-space($form_name) = 'brand'">
				<!--<details open="true">
					<summary class="summary">E-Detailing</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 cellttlblck heading tdLeft">Brand </TH>
								<TH CLASS="cellttl1 cellttlblck heading tdRight">Actual Order</TH>

							</TR>
						</thead>-->
                <div class="headerdata datafontsize">
                    E-Detailing
                </div>
                <div class="containertable">
                    <div class="doctorcontainer datafontsize">
                        <div class="doctordetails textcolor ">
                            <div  class="branddescr seperatorDiv headerfontsize">BRAND</div>
                            <div  class="pitchsequence seperatorDiv headerfontsize">ACTUAL ORDER</div>
                        </div>
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="brand_descr">
									<xsl:value-of select="brand_descr" />
								</xsl:variable>
								<xsl:variable name="pitch_sequence">
									<xsl:value-of select="pitch_sequence" />
								</xsl:variable>
								<!--<TR>
									<TD CLASS="cellttl1 tdCenter title tdLeft">-->
                                <div class="visitsdetails datafontsize">
                                
                                    <div class="branddescr">
										<xsl:value-of select="$brand_descr" />
                                    </div>
									<!--</TD>
									<TD CLASS="cellttl1 tdCenter title tdRight">-->
                                    <div class="pitchsequence">
										<xsl:value-of select="$pitch_sequence" />
                                    </div>
                                </div>
									<!--</TD>
								</TR>-->
							</xsl:if>

						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
			<!-- Brand subform for Fortune -->
			<!--<xsl:if test="normalize-space($form_name) = 'brand'">
				
                <div class="headerdata datafontsize">
                    Product
                </div>
                <div class="containertable">
                    <div class="doctorcontainer datafontsize">
                        <div class="doctordetails textcolor ">
                            <div  class="branddescr seperatorDiv headerfontsize">Product</div>
                            <div  class="pitchsequence seperatorDiv headerfontsize">Status</div>
                        </div>
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="brand_descr">
									<xsl:value-of select="brand_descr" />
								</xsl:variable>
								<xsl:variable name="pitch_detail_descr">
									<xsl:value-of select="pitch_detail_descr" />
								</xsl:variable>
                                <div class="visitsdetails datafontsize">
                                
                                    <div class="branddescr">
										<xsl:value-of select="$brand_descr" />
                                    </div>
                                    <div class="pitchsequence">
										<xsl:value-of select="$pitch_detail_descr" />
                                    </div>
                                </div>
							</xsl:if>

						</xsl:for-each>
                    </div>
                </div>
					
			</xsl:if>-->
			<!-- Brand subform for Fortune -->



			<xsl:if test="normalize-space($form_name) = 'sampleitem'">
				<!--<details open="true">
					<summary class="summary">Promotion</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 cellttlblck heading tdLeft">Item Usage</TH>
								<TH CLASS="cellttl1 cellttlblck heading">Product</TH>
								<TH CLASS="cellttl1 cellttlblck heading tdRight">Quantity</TH>
							</TR>
						</thead>-->
                <div class="headerdata datafontsize">
                    Promotion
                </div>
                <div class="containertable">
                    <div class="doctorcontainer datafontsize">
                        <div class="doctordetails textcolor ">
                            <div  class="itemusage seperatorDiv headerfontsize">ITEM USAGE</div>
                            <div  class="itemdescr seperatorDiv headerfontsize">PRODUCT</div>
                            <div  class="quantitysample seperatorDiv headerfontsize">QUANTITY</div>
                        </div>
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="item_descr_sample">
									<xsl:value-of select="item_descr" />
								</xsl:variable>
								<xsl:variable name="quantity_sample">
									<xsl:value-of select="quantity" />
								</xsl:variable>
								<xsl:variable name="item_usage">
									<xsl:value-of select="item_usage" />
								</xsl:variable>


								<!--<TR>
									<TD CLASS="cellttl1 tdLeft title">-->
                                <div class="visitsdetails datafontsize">
                                
                                    <div class="itemusage">
										<xsl:value-of select="$item_usage" />
                                    </div>
									<!--</TD>
									<TD CLASS="cellttl1 tdCenter title">-->
                                    <div class="itemdescr">
										<xsl:value-of select="$item_descr_sample" />
                                    </div>
									<!--</TD>
									<TD CLASS="cellttl1 tdCenter title tdRight">-->
                                    <div class="quantitysample">
										<xsl:value-of select="$quantity_sample" />
									</div>
                                </div>
                                    <!--</TD>
								</TR>-->
							</xsl:if>
						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
			<xsl:if test="normalize-space($form_name) = 'display'">
				<!--<details open="true">
					<summary class="summary"> Display</summary>-->
					<!-- <div id = "displayDr" style="display: none;"> -->
					<!--<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 tdCenter cellttlblck heading" style="text-align:left;">Display Area </TH>

							</TR>
						</thead>-->
                <div class="headerdata datafontsize">
                    Display Area
                </div>
                <div class="containertable">
                    <div class="doctorcontainer datafontsize">
                        <!--<div class="doctordetails textcolor">
                            <div  class="displayarea seperatorDiv headerfontsize">DISPLAY AREA</div>
                        </div>-->
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="doc_id">
									<xsl:value-of select="doc_id" />
								</xsl:variable>
								<xsl:variable name="display_area">
									<xsl:value-of select="display_area" />
								</xsl:variable>
								<!--<TR>
									<tr>
										<td CLASS="cellttl1 tdCenter title" style="text-align: left;">-->
                                    <div class="displayarea">
                                        DISPLAY AREA - <xsl:value-of select="display_area" />
                                    </div>
										<!--</td>
									</tr>
									<tr>
										<td>-->
                                    <div class="displayplugin detailswidth">
                                        <div align='center' id="__attachmentDiv.{normalize-space(concat($doc_id,'_table',''))}"
                                            style="text-align:center;white-space:nowrap;"></div>
                                        <img style="height:0px;width:0px;" src="_"
                                            onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space(concat($doc_id,'_table',''))}', 'strg_meet_dcr_realtime_wiz', 'R-DCR', '{normalize-space($doc_id)}'); this.remove();" />
                                    </div>
                                    <!--<div class="align-imgtext rightcol-spacing">
                                        <div align='center' id="__attachmentDiv.{normalize-space($doc_id)}"
                                            style="text-align:center;white-space:nowrap;"></div>
                                        <img style="height:0px;width:0px;" src="_"
                                            onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($doc_id)}', 'strg_meet_dcr_realtime_wiz', 'R-DCR', '{normalize-space($doc_id)}'); this.remove();" />
                                    </div>-->
                                
                                        <!--</td>
									</tr>
								</TR>-->
							</xsl:if>
						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>

			<xsl:if test="normalize-space($form_name) = 'brandsurvey'">
				<details open="true">
					<summary class="summary">Prescription</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="width:100%; z-index:9999999999;  ">
						<thead class="" style="height : 30px;">
							<TR>
								<TH CLASS="cellttl1 cellttlblck heading tdLeft">Prescription Detail's</TH>

							</TR>
						</thead>

						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="item_descr">
									<xsl:value-of select="item_descr" />
								</xsl:variable>

								<TR>
									<TD CLASS="cellttl1 tdCenter title tdLeft">
										<xsl:value-of select="$item_descr" />
									</TD>
								</TR>
							</xsl:if>

						</xsl:for-each>
					</TABLE>
				</details>
			</xsl:if>
			<!-- Added by sadique shaikh 23-01-2020 [to display Survey data on summary if event_type is not mini methass] -->
			<xsl:if test="(//Detail1/event_type != 'MI') and (//Detail1/event_type != 'OT')">
				<xsl:if test="normalize-space($form_name) = 'survey'">
					<!--<details open="true">
						<summary class="summary">Survey</summary>
						<TABLE class="tTitleD" border="0" width="100%"
							style="z-index:9999999999;  ">
							<thead class="" style="height : 30px;">
								<TR>
									<TH CLASS="cellttl1 tdCenter cellttlblck heading tdLeft"> Survey Description </TH>
									<TH CLASS="cellttl1 tdCenter cellttlblck heading tdRight"> Survey Result </TH>
								</TR>
							</thead>-->
                    <div class="headerdata datafontsize">
                        Survey
                    </div>
                    <div class="containertable">
                        <div class="doctorcontainer datafontsize">
                            <div class="doctordetails textcolor ">
                                <div  class="surveydescr seperatorDiv headerfontsize">SURVEY DESCRIPTION</div>
                                <div  class="surveyresult seperatorDiv headerfontsize">SURVEY RESULT</div>
                            </div>

							<xsl:for-each select="//node()[starts-with(name(), $detail)]">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="survey_descr">
										<xsl:value-of select="survey_descr" />
									</xsl:variable>
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
										value in SURVEY master and same to in SURVEY form] Start -->
									<xsl:variable name="result_format">
										<xsl:value-of select="result_format" />
									</xsl:variable>
									<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
										value in SURVEY master and same to in SURVEY form] End -->
									<xsl:variable name="surv_doc_id">
										<xsl:value-of select="doc_id_2" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'N'">
												<xsl:value-of select="result1" />
											</xsl:when>
											<xsl:when test="$result_type = 'T'">
												<xsl:value-of select="result3" />
											</xsl:when>
											<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
												value in SURVEY master and same to in SURVEY form] Start -->
											<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
												<xsl:value-of select="result4" />
											</xsl:when>
											<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
												value in SURVEY master and same to in SURVEY form] End -->
											<xsl:otherwise>
												<xsl:value-of select="result2" />
											</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>

									<!--<tr>
										<TD CLASS="cellttl1 tdCenter title tdLeft">-->
                                    <div class="visitsdetails datafontsize">
                                
                                        <div class="surveydescr">
											<xsl:value-of select="$survey_descr" />
                                        </div>
										<!--</TD>
										<TD CLASS="cellttl1 tdCenter title tdRight">-->
											<!-- <xsl:value-of select="$result" /> -->
                                        <div class="surveyresult">
											<xsl:choose>
												<xsl:when test="$result = 'Y'">
													Yes
												</xsl:when>
												<xsl:when test="$result = 'N'">
													No
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="$result" />
												</xsl:otherwise>
											</xsl:choose>
                                        </div>
                                    </div>
										<!--</TD>
									</tr>
									<tr>
										<td>-->

											<div align='center' id="__attachmentDiv.{normalize-space($surv_doc_id)}" style="text-align:center;white-space:nowrap;"></div>
											<img style="height:0px;width:0px;" src="_"
												onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($surv_doc_id)}', 'strg_meet_dcr_realtime_wiz', 'R-DCR', '{normalize-space($surv_doc_id)}'); this.remove();" />

										<!--</td>
									</tr>-->
								</xsl:if>
							</xsl:for-each>
                        </div>
                    </div>
						<!--</TABLE>
					</details>-->
				</xsl:if>
			</xsl:if>

			<!-- Added by Pooja on 23/12/19 [coaching related implementation] START -->
			<xsl:if test="normalize-space($form_name) = 'coaching'">
				<!--<details open="true">
					<summary class="summary">Coaching Details</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="z-index:9999999999;  ">-->
						<!-- <thead class="" style="height : 30px;"> <TR> <TH CLASS="cellttl1
							tdCenter cellttlblck heading tdLeft"> Survey Description </TH> <TH CLASS="cellttl1
							tdCenter cellttlblck heading tdRight"> Survey Result </TH> </TR> </thead> -->
                <div class="headerdata datafontsize">
                        Coaching Details
                </div>
                <div class="containertable">
                    <div class="doctorcontainer datafontsize">
                        <div class="doctordetails textcolor ">
                            <div  class="surveydescr seperatorDiv headerfontsize">SURVEY DESCRIPTION</div>
                            <div  class="surveyresult seperatorDiv headerfontsize">SURVEY RESULT</div>
                        </div>
						<xsl:for-each select="//node()[starts-with(name(), $detail)]">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="survey_descr">
									<xsl:value-of select="survey_descr" />
								</xsl:variable>
								<xsl:variable name="result_type">
									<xsl:value-of select="result_type" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] Start -->
								<xsl:variable name="result_format">
									<xsl:value-of select="result_format" />
								</xsl:variable>
								<!-- Added by Sagar m.on 26-dec-2018[To dropdown with predefined
									value in SURVEY master and same to in SURVEY form] End -->
								<xsl:variable name="coaching_doc_id">
									<xsl:value-of select="doc_id_1" />
								</xsl:variable>
								<xsl:variable name="result">
									<xsl:choose>
										<xsl:when test="$result_type = 'N'">
											<xsl:value-of select="result1" />
										</xsl:when>
										<xsl:when test="$result_type = 'T'">
											<xsl:value-of select="result3" />
										</xsl:when>
										<xsl:when test="$result_type = 'A'">
											<xsl:value-of select="result5" />
										</xsl:when>
										<xsl:when test="($result_type = 'L') and ($result_format = 'D')">
											<xsl:value-of select="result4" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="result2" />
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<!--<tr>
									<TD CLASS="cellttl1 tdCenter title tdLeft">-->
                                <div class="visitsdetails datafontsize">
                                
                                    <div class="surveydescr">
										<xsl:value-of select="$survey_descr" />
                                    </div>
									<!--</TD>
									<TD CLASS="cellttl1 tdCenter title tdRight">-->
										<!-- <xsl:value-of select="$result" /> -->
                                    <div class="surveyresult">
										<xsl:choose>
											<xsl:when test="$result = 'Y'">
												Yes
											</xsl:when>
											<xsl:when test="$result = 'N'">
												No
											</xsl:when>
											<xsl:otherwise>
												<!-- <xsl:value-of select="$result" /> -->
												<xsl:variable name="testVar" select="substring-after($result,'task_descr&quot;:&quot;')" />
												<xsl:value-of select="substring-before($testVar,'&quot;')" />
											</xsl:otherwise>
										</xsl:choose>
                                    </div>
                                </div>
									<!--</TD>
								</tr>
								<tr>
									<td>-->

										<div align='center'
											id="__attachmentDiv.{normalize-space($coaching_doc_id)}"
											style="text-align:center;white-space:nowrap;">
										</div>

									<!--</td>
								</tr>-->
							</xsl:if>
						</xsl:for-each>
                    </div>
                </div>
					<!--</TABLE>
				</details>-->
			</xsl:if>
			<!-- Added by Pooja on 23/12/19 [coaching related implementation] END -->
			<!-- Added by sadique shaikh 23-01-2020 [to display people trained in summary page] Start -->
			<xsl:if test="//Detail1/event_type = 'MI'">
				<xsl:if test="normalize-space($form_name) = 'survey'">
					<details open="true">
						<summary class="summary">People Trained</summary>
						<TABLE class="tTitleD" border="0" width="100%"
							style="z-index:9999999999;  ">
							<tr>
								<th CLASS="cellttl1 tdCenter title tdLeft">
									Attendee Name
								</th>
								<th CLASS="cellttl1 tdCenter title tdLeft">
									Mobile No.
								</th>
								<th CLASS="cellttl1 tdCenter title tdLeft">
									Remarks
								</th>
							</tr>
							<xsl:for-each select="//Detail7">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'A'">
												<xsl:value-of select="result5" />
											</xsl:when>
										</xsl:choose>
									</xsl:variable>
									<xsl:call-template name="peopleTrainedTemplate">
										<xsl:with-param name="result" select="$result" />
									</xsl:call-template>

								</xsl:if>
							</xsl:for-each>

						</TABLE>
					</details>
				</xsl:if>
			</xsl:if>
			<!-- Added by sadique shaikh 23-01-2020 [to display people trained in summary page] End -->
			<!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 START -->
			<xsl:if test="//Detail1/event_type = 'OT'">
				<xsl:if test="normalize-space($form_name) = 'survey'">
					<details open="true">
						<summary class="summary">Receipt</summary>
						<TABLE class="tTitleD" border="0" width="100%"
							style="z-index:9999999999;  ">
							<tr>
								<th CLASS="cellttl1 tdCenter title tdCenter" >
									Meter
								</th>
								<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
									Purchased Meter
								</th>
								<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
									Attachments
								</th>
							</tr>
							<xsl:for-each select="//Detail7">
								<xsl:if test="attribute/@updateFlag!='D'">
									<xsl:variable name="result_type">
										<xsl:value-of select="result_type" />
									</xsl:variable>
									<xsl:variable name="result">
										<xsl:choose>
											<xsl:when test="$result_type = 'A'">
												<xsl:value-of select="result5" />
											</xsl:when>
										</xsl:choose>
									</xsl:variable>
									<xsl:call-template name="ReceiptTemplate">
										<xsl:with-param name="result" select="$result" />
									</xsl:call-template>
								</xsl:if>
							</xsl:for-each>
						</TABLE>
					</details>
				</xsl:if>
			</xsl:if>
            <!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 End -->
            <!-- Added by Sadique S. [ To display Other Details in summary page ] on 19-02-2020 Start -->
			<xsl:if test="//Detail1/event_type = 'OT'">
				<xsl:if test="normalize-space($form_name) = 'survey'">
				<details open="true">
					<summary class="summary">Other Details</summary>
					<TABLE class="tTitleD" border="0" width="100%"
						style="z-index:9999999999;  ">
						<tr>
							<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
								Number of People Educated about SMBG
							</th>
							<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
								Meter puchased on same day
							</th>
							<th CLASS="cellttl1 tdCenter title tdCenter" style="width: 239px;">
								Remarks
							</th>
						</tr>
						<xsl:for-each select="//Detail1">
							<xsl:if test="attribute/@updateFlag!='D'">
								<xsl:variable name="member_present">
									<xsl:value-of select="member_present" />
								</xsl:variable>
								<xsl:variable name="pob_item">
									<xsl:value-of select="pob_item" />
								</xsl:variable>
								<xsl:variable name="remarks">
									<xsl:value-of select="remarks" />
								</xsl:variable>
						<tr>
							<TD CLASS="cellttl1 tdCenter title tdCenter">
										<xsl:value-of select="$member_present" />
							</TD>
							<TD CLASS="cellttl1 tdCenter title tdCenter">
										<xsl:value-of select="$pob_item" />
							</TD>
							<TD CLASS="cellttl1 tdCenter title tdCenter">
										<xsl:value-of select="$remarks" />
							</TD>
                        </tr>
						</xsl:if>
						</xsl:for-each>
					</TABLE>
				</details>
				</xsl:if>
        </xsl:if>
			 <!-- Added by Sadique S. [ To display Other Details in summary page ] on 19-02-2020 Start -->
			<!-- <xsl:if test="$remaining"> <xsl:call-template name="tmpSplitString">
				<xsl:with-param name="stringtosplit" select="$remaining" /> </xsl:call-template>
				</xsl:if> -->
		</xsl:if>
	</xsl:template>
	<xsl:template name="tmpOrder">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="ord_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_call_outcome">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_locality">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'!'), '|')" />
		</xsl:variable>
		<xsl:variable name="visited_team">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'|'), '^')" />
		</xsl:variable>
		<xsl:variable name="tm_form_no">
			<xsl:value-of select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="class_descr">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>
		<xsl:variable name="spl_description">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="no_visit">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="meet_summ">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="pob_val">
			<xsl:value-of select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>

		<xsl:variable name="member_presents">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'[')" />
		</xsl:variable>
		<!--<xsl:variable name="strg_types">
			<xsl:value-of select="substring-after($ord_value,'[')" />
		</xsl:variable>-->

        <xsl:variable name="strg_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'['),'||')" />
		</xsl:variable>
		<xsl:variable name="oth_participant">
		<xsl:value-of
				select="substring-before(substring-after($ord_value,'||'),'$%')" />
		</xsl:variable>
		<xsl:variable name="reg_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),'%%')" />
		</xsl:variable>
		<xsl:variable name="is_fortune_activity">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),']')" />
		</xsl:variable>
		<xsl:variable name="plan_chg_reason">
			<xsl:value-of select="substring-after($ord_value,']')" />
		</xsl:variable>

		<xsl:variable name="upImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Up.svg')" />
		</xsl:variable>
		<xsl:variable name="downImage">
			<xsl:value-of
				select="concat($ord_host_url,'/ibase/webitm/images/Summary/Down.svg')" />
		</xsl:variable>
		<xsl:variable name="ord_detail">
			<xsl:value-of select="concat('Detail',$ord_form_no)" />
		</xsl:variable>
		<xsl:variable name="team_detail">
			<xsl:value-of select="concat('Detail',$tm_form_no)" />
		</xsl:variable>
		<xsl:variable name="call_outcome_descr">
			<xsl:if test="normalize-space($doc_call_outcome) = '5' ">
				Supporter
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '6' ">
				Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '7' ">
				Non Believer
			</xsl:if>
			<xsl:if test="normalize-space($doc_call_outcome) = '0' ">
				Refused
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="ord_listed_count">
			<xsl:if test="normalize-space($ord_form_no)!=''">

				<xsl:for-each select="//node()[starts-with(name(), $ord_detail)]">
					<xsl:if test="attribute/@updateFlag!='D'">

						<xsl:variable name="order_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($order_strg_code) = normalize-space($doc_strg_code)">
							<xsl:value-of select="count(//node()[starts-with(name(), $ord_detail)])" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="team_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $team_detail)]">
				<xsl:if test="attribute/@updateFlag!='D'">

					<xsl:variable name="tm_strg_code">
						<xsl:value-of select="strg_code" />
					</xsl:variable>
					<xsl:if
						test="normalize-space($tm_strg_code) = normalize-space($doc_strg_code)">
						<xsl:value-of select="count(//node()[starts-with(name(), $team_detail)])" />
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$ord_listed_count > '0'">
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>

							<td style="color: black; text-align:left;white-space:nowrap;">
								<div style="display: inline-block; width: 100%;">-->
									<!--<div style="height: auto; float: left; width: 40px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="images/map/user.png"' class="iw-header-userImage"
											style=" padding: 5px; height: 30px; width: 30px; border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 40px); float: right;">
										<div>
											<div
												style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;">
												<xsl:value-of
													select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
											</div>
											<div style="float: right; height: 18px; width: 18px;">
												<img id="{normalize-space($doc_strg_code)}" style="height: 10px; width: 10px; padding: 4px;"
													onClick="showDetailsOrder(this.id,'{normalize-space($upImage)}','{normalize-space($downImage)}')">
													<xsl:attribute name="src"><xsl:value-of
														select="$upImage" />
													</xsl:attribute>
												</img>
											</div>
										</div>
										<br></br>-->
										<!--<div style="color: gray;text-align: left;">
											Customer Type
											<xsl:value-of select="$customer_types" />
										</div>
										<xsl:if test="normalize-space($strg_types) = 'D' ">
											<xsl:if test="normalize-space($class_descr) != ''">
												<div style="color: gray;text-align: left;">
													Class
													<xsl:value-of select="$class_descr" />
												</div>

											</xsl:if>
											<xsl:if test="normalize-space($spl_description) != ''">
												<div style="color: gray;text-align: left;">
													Speciality
													<xsl:value-of select="$spl_description" />
												</div>

											</xsl:if>
											<xsl:if test="normalize-space($no_visit) != ''">
												<div style="color: gray;text-align: left;">
													No Of Visits
													<xsl:value-of select="$no_visit" />
												</div>
											</xsl:if>
										</xsl:if>-->
										<!--changes by shraddha M for listed/unlisted case [20/07/2020] start-->
										<!--<xsl:if test="normalize-space($customer_types) = 'LISTED'">
											<div style="color: gray;text-align: left;">-->
											<!-- Visit Time From: -->
											<!--Visit Time:
											<xsl:value-of select="$event_time_start" />
											</div>
										</xsl:if>
										<xsl:if test="normalize-space($customer_types) != 'LISTED'">
											<div style="color: gray;text-align: left;">-->
											<!--  Visit Time From:-->
											<!--Time Of First Call:
											<xsl:value-of select="$event_time_start" />
											</div>
											
											<div style="color: gray;text-align: left;">
											Time Of Last Call:
											<xsl:value-of select="$event_time_end" />
										   </div>
										</xsl:if>-->
										<!-- <div style="color: gray;text-align: left;">
											Visit Time From:
											<xsl:value-of select="$event_time_start" />
										</div>


										<div style="color: gray;text-align: left;">
											Visit Time End:
											<xsl:value-of select="$event_time_end" />
										</div> -->
										<!--changes by shraddha M for listed/unlisted case [20/07/2020]end-->
										<!--<div style="color: gray;text-align: left;">
											POB Value:
											<xsl:value-of select="$pob_val" />
										</div>

										<div style="color: gray;text-align: left;">
											Remarks
											<xsl:call-template name="meetTemp">
												<xsl:with-param name="stringtosplitRemark"
													select="$meet_summ" />
											</xsl:call-template>
										</div>




										<div
											style="color: gray; float: left; white-space: normal;width: 100%;">
											<xsl:choose>
												<xsl:when test="$team_listed_count > '0'">
													<xsl:call-template name="tempTeamData">
														<xsl:with-param name="teamData"
															select="concat($team_detail,'@',$doc_strg_code)" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="string-length($visited_team) != 0">
													Team :
													<xsl:value-of select="$visited_team" />
												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>

										</div>
										<div
											style="color: gray; float: left; white-space: normal;width: 100%;">
											Place 
											<xsl:value-of select="$doc_locality" />
										</div>-->
									<!--</div>
								</div>
							</td>

						</tr>-->
                <div class="stickysubforms"><!-- container starts -->
                    <div class="datafontsize docdatadetails">
                        <xsl:if test="normalize-space($strg_types) = 'D' ">
                            <div  class="firstcolumn detailswidth customername_doc">
                                <xsl:value-of
                                    select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
                            </div>
                                
                            <div class="customertypes_doc detailswidth">
                                <xsl:value-of select="$customer_types" />
                            </div>
                            <div class="classdescr_doc detailswidth">
                                <xsl:value-of select="$class_descr" />
                            </div>
                            <div class="spldescription_doc detailswidth">
                                <xsl:value-of select="$spl_description" />
                            </div>
                            <div class="novisit_doc detailswidth">
                                <xsl:value-of select="$no_visit" />
                            </div>
                            <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                                <div class="visittime_doc detailswidth">
                                <!-- Visit Time From: -->
                                <xsl:value-of select="$event_time_start" />
                                </div>
                            </xsl:if>
                            
                            <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                                <div class="eventtimestart_doc detailswidth">
                                <!--  Visit Time From:-->
                                <xsl:value-of select="$event_time_start" />
                                </div>
                                
                                <div class="eventtimestart_doc detailswidth">
                                <xsl:value-of select="$event_time_end" />
                                </div>
                            </xsl:if>
                            <div class="pobvalue_doc detailswidth">
                                <xsl:value-of select="$pob_val" />
                            </div>
                            <div class="planChgRsn detailswidth hideoverflow">
                                <xsl:value-of select="$plan_chg_reason" />
                            </div>
                            <div class="remarks_doc detailswidth hideoverflow">
                                <xsl:value-of select="$meet_summ" />
                                <!--<xsl:call-template name="meetTemp">
                                    <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                            </div>
                            <div class="team_doc detailswidth">
                                <xsl:choose>
                                    <xsl:when test="$team_listed_count > '0'">
                                        <xsl:call-template name="tempTeamData">
                                            <xsl:with-param name="teamData"
                                                select="concat($team_detail,'@',$doc_strg_code)" />
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="string-length($visited_team) != 0">
                                    <!-->-	Team :-->
                                        <xsl:value-of select="$visited_team" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </div>
                            <div class="doclocality_doc detailswidth hideoverflow">
                                <xsl:value-of select="$doc_locality" />
                            </div>
                        </xsl:if>


                        <xsl:if test="normalize-space($strg_types) != 'D' ">
                            <div  class="firstcolumn detailswidth hideoverflow customernameDiv">
                                <xsl:value-of
                                    select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
                            </div>
                                
                            <div class="customertypesDiv detailswidth hideoverflow">
                                <xsl:value-of select="$customer_types" />
                            </div>

                            <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                                <div class="visittimeDiv detailswidth hideoverflow">
                                <!-- Visit Time From: -->
                                <xsl:value-of select="$event_time_start" />
                                </div>
                            </xsl:if>
                            
                            <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                                <div class="eventtimestartDiv detailswidth hideoverflow">
                                <!--  Visit Time From:-->
                                <xsl:value-of select="$event_time_start" />
                                </div>
                                
                                <div class="eventtimestartDiv detailswidth hideoverflow">
                                <xsl:value-of select="$event_time_end" />
                                </div>
                            </xsl:if>
                            <div class="pobvalueDiv detailswidth hideoverflow">
                                <xsl:value-of select="$pob_val" />
                            </div>
                            <xsl:if test="normalize-space($strg_types) = 'O' ">
                                <div class="euin-no detailswidth hideoverflow">
                                    <xsl:value-of select="$oth_participant" />
                                </div>
                                <div class="reg-no detailswidth hideoverflow">
                                    <xsl:value-of select="$reg_no" />
                                </div>
                            </xsl:if>
                            <div class="planChgRsn detailswidth hideoverflow">
                                <xsl:value-of select="$plan_chg_reason" />
                            </div>
                            <div class="remarksDiv detailswidth hideoverflow">
                                <xsl:value-of select="$meet_summ" />
                                <!--<xsl:call-template name="meetTemp">
                                    <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                            </div>
                            <div class="teamDiv detailswidth hideoverflow">
                                <xsl:choose>
                                    <xsl:when test="$team_listed_count > '0'">
                                        <xsl:call-template name="tempTeamData">
                                            <xsl:with-param name="teamData"
                                                select="concat($team_detail,'@',$doc_strg_code)" />
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="string-length($visited_team) != 0">
                                    <!-->-	Team :-->
                                        <xsl:value-of select="$visited_team" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </div>
                            <div class="doclocalityDiv detailswidth hideoverflow lastcolumn">
                                <xsl:value-of select="$doc_locality" />
                            </div>
                        </xsl:if>
                    </div>
						<xsl:call-template name="tempOrderData">
							<xsl:with-param name="orderData"
								select="concat($ord_detail,'@',$doc_strg_code)" />
						</xsl:call-template>
                </div>
					<!--</thead>
				</TABLE>-->
			</xsl:when>
			<xsl:otherwise>
				<!--<TABLE class="tTitleD" border="0" width="100%"
					style="z-index:9999999999;  ">
					<thead class="" style="height : 30px;">
						<tr>
							<td style="color: black;text-align:left;white-space:nowrap;">
								<div style="display: inline-block; width: 100%;">
									<div style="height: auto; float: left; width: 40px;">
										<IMG
											SRC="{normalize-space($ord_host_url)}/ibase/CustomMenuImageServlet?fldValue={normalize-space($doc_strg_code)}&amp;object=wsfa_strg_customer&amp;objName=wsfa_strg_customer&amp;ALT_FLD_VALUE={normalize-space($doc_strg_name)}"
											onerror='this.src="images/map/user.png"' class="iw-header-userImage"
											style=" padding: 5px; height: 30px; width: 30px; border-radius: 50%;">
										</IMG>
									</div>
									<div style="width: calc(100% - 40px); float: right;">
										<div
											style="float: left; max-width: 180px; overflow: hidden; text-overflow: ellipsis;">
											<xsl:value-of
												select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
										</div>
										<br></br>
										<div style="color: gray;text-align: left;">
											Customer Type
											<xsl:value-of select="$customer_types" />
										</div>
										<xsl:if test="normalize-space($strg_types) = 'D' ">
											<xsl:if test="normalize-space($class_descr) != ''">
												<div style="color: gray;text-align: left;">
													Class
													<xsl:value-of select="$class_descr" />
												</div>

											</xsl:if>
											<xsl:if test="normalize-space($spl_description) != ''">
												<div style="color: gray;text-align: left;">
													Speciality
													<xsl:value-of select="$spl_description" />
												</div>

											</xsl:if>
											<xsl:if test="normalize-space($no_visit) != ''">
												<div style="color: gray;text-align: left;">
													No Of Visits
													<xsl:value-of select="$no_visit" />
												</div>
											</xsl:if>
										</xsl:if>-->
										<!--changes by shraddha M for listed/unlisted case [20/07/2020]-->
										<!--<xsl:if test="normalize-space($customer_types) = 'LISTED'">
											<div style="color: gray;text-align: left;">-->
											<!-- Visit Time From: -->
											<!--Visit Time
											<xsl:value-of select="$event_time_start" />
											</div>
										</xsl:if>
										
										<xsl:if test="normalize-space($customer_types) != 'LISTED'">
											<div style="color: gray;text-align: left;">-->
											<!--  Visit Time From:-->
											<!--Time Of First Call
											<xsl:value-of select="$event_time_start" />
											</div>
											
											<div style="color: gray;text-align: left;">
											Time Of Last Call:
											<xsl:value-of select="$event_time_end" />
										   </div>
										</xsl:if>-->
										<!--changes by shraddha M for listed/unlisted case [20/07/2020]-->
										<!--<div style="color: gray;text-align: left;">
											POB Value:
											<xsl:value-of select="$pob_val" />
										</div>

										<div style="color: gray;text-align: left;">
											Remarks
											<xsl:call-template name="meetTemp">
												<xsl:with-param name="stringtosplitRemark"
													select="$meet_summ" />
											</xsl:call-template>
										</div>

										<div
											style="color: gray; float: left; white-space: normal;width: 100%;">
											<xsl:choose>
												<xsl:when test="$team_listed_count > '0'">
													<xsl:call-template name="tempTeamData">
														<xsl:with-param name="teamData"
															select="concat($team_detail,'@',$doc_strg_code)" />
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="string-length($visited_team) != 0">-->
												<!--	Team :-->
													<!--<xsl:value-of select="$visited_team" />
												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>
										</div>
										<div
											style="color: gray; float: left; white-space: normal;width: 100%;">
											Place 
											<xsl:value-of select="$doc_locality" />
										</div>
									</div>
								</div>
							</td>
							<td CLASS="cellttl1 tdCenter title"></td>
						</tr>

					</thead>
				</TABLE>-->
                <div class="stickysubforms"><!-- container starts -->
                    <div class="datafontsize docdatadetails">
                        <xsl:if test="normalize-space($strg_types) = 'D' ">
                            <div  class="firstcolumn detailswidth hideoverflow customername_doc">
                                <xsl:value-of
                                    select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
                            </div>
                                
                            <div class="customertypes_doc detailswidth hideoverflow">
                                <xsl:value-of select="$customer_types" />
                            </div>
                            <div class="classdescr_doc detailswidth hideoverflow">
                                <xsl:value-of select="$class_descr" />
                            </div>
                            <div class="spldescription_doc detailswidth hideoverflow">
                                <xsl:value-of select="$spl_description" />
                            </div>
                            <div class="novisit_doc detailswidth hideoverflow">
                                <xsl:value-of select="$no_visit" />
                            </div>
                            <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                                <div class="visittime_doc detailswidth hideoverflow">
                                <!-- Visit Time From: -->
                                    <xsl:value-of select="$event_time_start" />
                                </div>
                            </xsl:if>
                            
                            <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                                <div class="eventtimestart_doc detailswidth hideoverflow">
                                <!--  Visit Time From:-->
                                <xsl:value-of select="$event_time_start" />
                                </div>
                                
                                <div class="eventtimestart_doc detailswidth hideoverflow">
                                <xsl:value-of select="$event_time_end" />
                                </div>
                            </xsl:if>
                            <div class="pobvalue_doc detailswidth hideoverflow">
                                <xsl:value-of select="$pob_val" />
                            </div>
                            <div class="planChgRsn detailswidth hideoverflow">
                                <xsl:value-of select="$plan_chg_reason" />
                            </div>
                            <div class="remarks_doc detailswidth hideoverflow">
                                <xsl:value-of select="$meet_summ" />
                                <!--<xsl:call-template name="meetTemp">
                                    <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                            </div>
                            <div class="team_doc detailswidth hideoverflow">
                                <xsl:choose>
                                    <xsl:when test="$team_listed_count > '0'">
                                        <xsl:call-template name="tempTeamData">
                                            <xsl:with-param name="teamData"
                                                select="concat($team_detail,'@',$doc_strg_code)" />
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="string-length($visited_team) != 0">
                                    <!-->-	Team :-->
                                        <xsl:value-of select="$visited_team" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </div>
                            <div class="doclocality_doc detailswidth hideoverflow">
                                <xsl:value-of select="$doc_locality" />
                            </div>
                        </xsl:if>


                        <xsl:if test="normalize-space($strg_types) != 'D' ">
                            <div  class="firstcolumn detailswidth hideoverflow customernameDiv">
                                <xsl:value-of
                                    select="concat($doc_strg_name,' - ',$call_outcome_descr)" />
                            </div>
                                
                            <div class="customertypesDiv detailswidth hideoverflow">
                                <xsl:value-of select="$customer_types" />
                            </div>

                            <xsl:if test="normalize-space($customer_types) = 'LISTED'">
                                <div class="visittimeDiv detailswidth hideoverflow">
                                <!-- Visit Time From: -->
                                <xsl:value-of select="$event_time_start" />
                                </div>
                            </xsl:if>
                            
                            <xsl:if test="normalize-space($customer_types) != 'LISTED'">
                                <div class="eventtimestartDiv detailswidth hideoverflow">
                                <!--  Visit Time From:-->
                                <xsl:value-of select="$event_time_start" />
                                </div>
                                
                                <div class="eventtimestartDiv detailswidth hideoverflow">
                                <xsl:value-of select="$event_time_end" />
                                </div>
                            </xsl:if>
                            <div class="pobvalueDiv detailswidth hideoverflow">
                                <xsl:value-of select="$pob_val" />
                            </div>
                            <xsl:if test="normalize-space($strg_types) = 'O' ">
                                <div class="euin-no detailswidth hideoverflow">
                                    <xsl:value-of select="$oth_participant" />
                                </div>
                                <div class="reg-no detailswidth hideoverflow">
                                    <xsl:value-of select="$reg_no" />
                                </div>
                            </xsl:if>
                            <div class="planChgRsn detailswidth hideoverflow">
                                <xsl:value-of select="$plan_chg_reason" />
                            </div>
                            <div class="remarksDiv detailswidth hideoverflow">
                                <xsl:value-of select="$meet_summ" />
                                <!--<xsl:call-template name="meetTemp">
                                    <xsl:with-param name="stringtosplitRemark"
                                            select="$meet_summ" />
                                    </xsl:call-template>-->
                            </div>
                            <div class="teamDiv detailswidth hideoverflow">
                                <xsl:choose>
                                    <xsl:when test="$team_listed_count > '0'">
                                        <xsl:call-template name="tempTeamData">
                                            <xsl:with-param name="teamData"
                                                select="concat($team_detail,'@',$doc_strg_code)" />
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="string-length($visited_team) != 0">
                                    <!-->-	Team :-->
                                        <xsl:value-of select="$visited_team" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </div>
                            <div class="doclocalityDiv detailswidth hideoverflow lastcolumn">
                                <xsl:value-of select="$doc_locality" />
                            </div>
                        </xsl:if>
                    </div>
                </div>

			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="tempOrderData">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>
		<xsl:variable name="order_details">
			<xsl:value-of select="substring-before($order_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of select="substring-after($order_data_value,'@')" />
		</xsl:variable>
		<!--<TABLE class="tTitleD" border="0" width="100%"
			style="z-index:9999999999;background-color: #f0eded;">
			<thead class="" style="height : 30px;">-->
	 <!-- Added by Hariom S. [ To display Order header ] on 21-08-2020 Start -->
			<!--<TR id="order.{normalize-space($dcotor_cust_code)}.heading1">-->			
						<!-- <th style="text-align: center;">Order</th>
						<th></th>
						<th></th>
						<th></th>-->
						<!--<summary class="summary">Order</summary>
					</TR>-->
					 <!-- Added by Hariom S. [ To display Order header ] on 21-08-2020 End 
				<TR id="order.{normalize-space($dcotor_cust_code)}.heading">
					<TH CLASS="cellttl1 cellttlblck heading tdLeft">Product</TH>
					<TH CLASS="cellttl1 cellttlblck heading tdRight">Quantity</TH>
					<TH CLASS="cellttl1 cellttlblck heading tdRight">Value</TH>
					<TH CLASS="cellttl1 cellttlblck heading tdRight">Scheme Description</TH>
				</TR>
			</thead>
			<tbody id="order.{normalize-space($dcotor_cust_code)}.details">-->
            <div class="sampledetails ">
                <div class="sampleheading textcolor headerfontsize">
                    Order
                </div>
                <div class="samplename">
                    <div class="ord-product headerfontsize headingwidth"> PRODUCT </div>	
                    <div class="ord-quantity headerfontsize headingwidth"> QUANTITY </div>
                    <div class="ord-value headerfontsize headingwidth"> VALUE </div>
                    <div class="ord-descr headerfontsize headingwidth"> SCHEME DESCRIPTION </div>
                    <div class="ord-devi-rsn headerfontsize headingwidth"> FOCUS DEVIATION REASON </div>
					<div class="ord-remarks headerfontsize headingwidth lastcolumn"> REMARKS </div>
                </div>
				<xsl:for-each select="//node()[starts-with(name(), $order_details)]">
					<xsl:if test="attribute/@updateFlag!='D'">
						<xsl:variable name="ord_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="ordervalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="Scheme_description">
							<xsl:value-of select="description" />
						</xsl:variable>
						<xsl:variable name="remark_descr">
                            <xsl:value-of select="remark_descr" />
                        </xsl:variable>
                        <xsl:variable name="order_remarks">
                            <xsl:value-of select="remarks_ord" />
                        </xsl:variable>
						<xsl:if
							test="normalize-space($ord_strg_code) = normalize-space($dcotor_cust_code)">
							<!--<TR style="background-color: #f0eded;">
								<TD CLASS="cellttl1 tdCenter title tdLeft">
									<xsl:value-of select="$item_descr" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdRight">
									<xsl:value-of select="$quantity" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdRight">
									<xsl:value-of select="$ordervalue" />
								</TD>
								<TD CLASS="cellttl1 tdCenter title tdRight">
									<xsl:value-of select="$Scheme_description" />
								</TD>
							</TR>-->
                            <div class="sampledata datafontsize">
                                <div class="ord-product detailswidth firstcolumn hideoverflow">
                                    <xsl:value-of select="$item_descr" />
                                </div>
                                <div class="ord-quantity detailswidth">
                                    <xsl:value-of select="$quantity" />
                                </div>
                                <div class="ord-value detailswidth">
                                    <xsl:value-of select="$ordervalue" />
                                </div>
                                <div class="ord-descr detailswidth">
                                    <xsl:value-of select="$Scheme_description" />
                                </div>
								<div class="ord-devi-rsn detailswidth">
                                    <xsl:value-of select="$remark_descr" />
                                </div>
                                <div class="ord-remarks detailswidth lastcolumn">
                                    <xsl:value-of select="$order_remarks" />
                                </div>
                            </div>
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
            </div>
			<!--</tbody>
		</TABLE>-->
	</xsl:template>
	<xsl:template name="tempTeamData">
		<xsl:param name="teamData" />
		<xsl:variable name="team_data_value">
			<xsl:value-of select="$teamData" />
		</xsl:variable>
		<xsl:variable name="team_details">
			<xsl:value-of select="substring-before($team_data_value,'@')" />
		</xsl:variable>
		<xsl:variable name="team_cust_code">
			<xsl:value-of select="substring-after($team_data_value,'@')" />
		</xsl:variable>
	<!--	Team :-->
		<xsl:for-each select="//node()[starts-with(name(), $team_details)]">
			<xsl:if test="attribute/@updateFlag!='D'">
				<xsl:variable name="team_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:variable name="name">
					<xsl:value-of select="name" />
				</xsl:variable>
				<xsl:variable name="sales_pers">
					<xsl:value-of select="sales_pers" />
				</xsl:variable>
				<xsl:variable name="visited_with_display">
					<xsl:value-of select="visited_with_display" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($team_strg_code) = normalize-space($team_cust_code)">
					<xsl:value-of select="$visited_with_display" />
					,
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="meetTemp">
		<xsl:param name="stringtosplitRemark" />
		<xsl:variable name="first"
			select="substring-before($stringtosplitRemark, ',')" />
		<xsl:variable name="remaining"
			select="substring-after($stringtosplitRemark, ',')" />
		<xsl:variable name="value">
			<xsl:value-of select="$first" />
		</xsl:variable>
		<xsl:variable name="type">
			<xsl:value-of select="substring($value,6,1)" />
		</xsl:variable>
		<xsl:variable name="text">
			<xsl:value-of select="substring($value,8)" />
		</xsl:variable>
		<xsl:variable name="remark">
			<xsl:choose>
				<xsl:when test="($type='C') ">
					<xsl:value-of select="$text" />
					[Complaint]
					<br />
				</xsl:when>
				<xsl:when test="($type='R') ">
					<xsl:value-of select="$text" />
					[Request]
					<br />
				</xsl:when>
				<xsl:when test="($type='Q') ">
					<xsl:value-of select="$text" />
					[Query]
					<br />
				</xsl:when>
				<xsl:when test="($type='P') ">
					<xsl:value-of select="$text" />
					[Compliment]
					<br />
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="concat($remark,' ')" />
		<xsl:if test="$remaining">
			<xsl:call-template name="meetTemp">
				<xsl:with-param name="stringtosplitRemark" select="$remaining" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- Added by sadique shaikh 23-01-2020 [to display json for people trained] Start -->
	<xsl:template name="peopleTrainedTemplate" match="/peopleTrainedTemplate">
		<xsl:param name="result" />
		<xsl:if test="contains($result, 'attendee_name')">
			<tr>
				<td CLASS="cellttl1 tdCenter title tdLeft">
					<xsl:variable name="attendeeName"
						select="substring-after($result,'attendee_name&quot;:&quot;')" />
					<xsl:value-of select="substring-before($attendeeName,'&quot;')" />
				</td>
				<td CLASS="cellttl1 tdCenter title tdLeft">
					<xsl:variable name="mobileNo"
						select="substring-after($result,'attendee_mobile_no&quot;:&quot;')" />
					<xsl:value-of select="substring-before($mobileNo,'&quot;')" />
				</td>
				<td CLASS="cellttl1 tdCenter title tdLeft">
					<xsl:variable name="remarks"
						select="substring-after($result,'remarks&quot;:&quot;')" />
					<xsl:value-of select="substring-before($remarks,'&quot;')" />
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<!-- Added by sadique shaikh 23-01-2020 [to display json for people trained] End -->
	<!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 START -->
	<xsl:template name="ReceiptTemplate" match="ReceiptTemplate">
		<xsl:param name="result" />
		<xsl:if test="contains($result, 'meter_name')">
			<tr>
				<td CLASS="cellttl1 tdCenter title tdCenter">
					<xsl:variable name="meterName" select="substring-after($result,'meter_name&quot;:&quot;')" />
					<xsl:value-of select="substring-before($meterName,'&quot;')" />
				</td>
				<td CLASS="cellttl1 tdCenter title tdCenter">
					<xsl:variable name="meterPurchased" select="substring-after($result,'meter_purchased&quot;:&quot;')" />
					<xsl:value-of select="substring-before($meterPurchased,'&quot;')" />
				</td>
				<td CLASS="cellttl1 tdCenter title tdCenter">
					<!-- <xsl:variable name="attachments"
						select="substring-after($result,'meter_purchased&quot;:&quot;')" />
					<xsl:value-of select="substring-before($attachments,'&quot;')" /> -->
					<xsl:variable name="surv_doc_id">
						<xsl:value-of select="doc_id_2" />
					</xsl:variable>
					<div align='center' id="__attachmentDiv.{normalize-space($surv_doc_id)}" style="white-space:nowrap;"></div>
					<img style="height:0px;width:0px;" src="_" onerror="showAttachmentsPlugin('__attachmentDiv.{normalize-space($surv_doc_id)}', 'strg_meet_dcr_realtime_wiz', 'R-DCR', '{normalize-space($surv_doc_id)}'); this.remove();" />
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<!-- Added by Amey W. [ To display Receipt in summary page ] on 17-02-2020 END -->
</xsl:stylesheet>
