<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<LINK type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/Standard/darSummary.css" />
                
				<LINK type="text/css" rel="stylesheet" href="/ibase/webitm/css/vision_ui.css" />

				<title>Details</title>
				<style>
					.company-name{
	                font-size: 1.4em;
	                font-weight:bolder;
	                color: #000;
	                text-align: center;
	                line-height: 1.2;
	                padding: 0 0 10px 0;
	                }
	                .tax-challan-name{
	                font-size: 1.8em;
	                font-weight:bolder;
	                color: #000;
	                text-align: center;
	                line-height: 1.2;
	                padding: 0 0 10px 0;
	                }
	                .label-text{
	                font-size: 1em;
	                font-weight:bolder;
	                color: #000;
	                text-align: left;
	                width:40%;
	                line-height: 1.2;
	                }
	                .label-text-large{
	                font-size: 1.2em;
	                font-weight:bolder;
	                color: #000;
	                text-align: left;
	                width:40%;
	                line-height: 1.2;
	                }
	                .data-value{
	                font-size: 1em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 10px 0;
	                width:60%;
	                }
	                .data-value-large{
	                font-size: 1.2em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 10px 0;
	                width:60%;
	                }
	                .tax-payable{
	                font-size: 1em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 10px 0;
	                width:80%;
	                }
	                .tax-payable-data{
	                ffont-size: 1em;
	                line-height: 1.2;
	                color: #000;
	                font-weight:bolder;
	                padding: 0 0 10px 0;
	                width:20%;
	                }
	                .value-shown{
	                display:flex;
	                width:100%;
	                align-items: center;
	                justify-content :space-between;
	                text-align: right;
    				/*padding-right: 10%;*/
	                }
	                .value-shown-tax{
	                display:flex;
	                width:100%;
	                align-items: center;
	                justify-content :space-between;
	                }
	                .horizontal_dotted_line {
	                 width:100%;
	                 border-bottom:1px dashed #000;
	                 
	                 }
					.bgcolorform{
	                        background-color: #fff;
	                  }
	                .namespacing{
	                        padding: 3px 0 3px 0px;
	                        text-align: left;
	                        line-height: 1.5;
	                        display: flex;
	                        width:100%;
	                 }
	                 .colon{
	                color: #000;
	                margin-right: 5px;
    				line-height: 1.18;
	                }
	                .colon-num{
	                color: #000;
	                line-height: 1.18;
	               /* margin-left: 7%;*/
	                }
	                .showstatusDivW{
    margin: auto;
    margin-bottom: 70px;
    width: calc(100% - 32px);
    font-family: sans-serif !important;
    font-weight: 500 !important;
    max-width: calc(1024px - 1px);
    position: relative;
    height:calc(100% - 60px);
    z-index: 1;   
    overflow-y: scroll;
}
.containerfeedW{
    padding: 12px 10px;
    margin: 8px 0 8px 0;
    border-radius: 12px;
    background-color: #fff;
    overflow: hidden;
	box-shadow: inset 0px 0px 0px 1px rgb(215 215 215 / 50%);
}

.headerdataW{
    display: flex;
    white-space: nowrap;
    height: 36px;
    margin: 0;
    font-size: 12px;
    padding: 3px 12px;
    color: #000;
    cursor: pointer;
	/*align-items: center;*/
    justify-content: space-between;
} 
.tabsW {
	 position: relative;
     text-align: center;
	 border-radius: 5px;
	 min-width: 240px;
     min-height: 500px;
     overflow-x: auto;
     overflow-y: hidden;
}
				</style>
				
			</head>

			<script type="text/javascript" src="/ibase/webitm/js/ITMWizard.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/ViewReport.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/e12PluginWrapper.js"></script>
            <script type="text/javascript"
                src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

			<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    
    function setDivClass()
    {
	var unConfCnt = "";
	if( document.getElementById("unconf_cnt") != null )
	{
		unConfCnt = document.getElementById("unconf_cnt").value;
	}
	alert("unConfCnt =["+unConfCnt+"]");
	if( document.getElementById("dataDiv") != null )
	{
		if(unConfCnt != null && unConfCnt.length > 0 && unConfCnt != '1')
		{
		    document.getElementById("dataDiv").class='dataDiv1';
		    document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
		else
		{
		     document.getElementById("dataDiv").class='dataDiv1';
		     document.getElementById("dataDiv").setAttribute("class","dataDiv1");
		}
	}
    }

]]>

			</script>
			<script language="JavaScript" type="text/javascript">



				function
				callTravelForm(isMgr)
				{
				console.log('It is coming inside
				callTravelForm() 1689 '+isMgr);
				var dcrDate =
				document.getElementById('EVENT_DATE').value;
				var salesPers =
				document.getElementById('SALES_PERS').value;

				var id="";
				var
				objName="";

				if(isMgr != "")
				{
				console.log('MANGER inside
				callTravelForm() 1689 ');
				objName="strg_meet_mgr_dcr_trv_change";
				}
				else
				{
				console.log('DCR inside callTravelForm() 1689 ');
				objName="strg_meet_dcr_trv_change";
				}


				var objType = "W";
				var
				callReport="Y";
				var title = "Daily Call Reporting";
				var
				qryStr="event_date="+dcrDate+"&amp;OBJ_NAME="+objName+"&amp;sales_pers="+salesPers+"&amp;call_report="+callReport;
				console.log('objName-- '+objName);
				console.log('objType-- '+objType);
				console.log('title-- '+title);
				console.log('id-- '+id);
				console.log('qryStr-- '+qryStr);
				openTransFrmXsl(id, objName,
				objType, title, qryStr );
				}

				function openTransFrmXsl(id, objName,
				objType, title, qryStr )
				{
				console.log('It is coming inside
				openTransFrmXsl 1726 ');
				var Window = window;
				if( window.parent !==
				Window )
				{
				Window = window.parent;
				}
				try
				{
				Window.setWizardParamMapGWT(
				qryStr );
				Window.openTransactionGWT(id, objName, objType, title );
				}
				catch(err)
				{
				console.log('Exception-- '+err.message);
				if(
				err.message.indexOf('origin') != -1 )
				{
				var sendData =
				qryStr+'~~'+id+'~~'+objName+'~~'+objType+'~~'+title;
				Window.postMessage( sendData, '*' );
				}
				}
				document.getElementById('Cancel').click();
				}
			</script>
			<body onload="javascript:focusView('focusOnFeed'), iosSupport()" class="bgcolorform"> 
				<form name="Wizard_TravelDSR">
                    <div class="mainDivShowStatus" >
                        <div class="showstatusDivW" onclick="void(0);">
                            <xsl:for-each select="//DARDetails//Detail1">
                                <xsl:variable name="hostUrl">
                                    <xsl:value-of select="host_url" />
                                </xsl:variable>

                                <xsl:variable name="confirmed">
                                    <xsl:value-of select="confirmed" />
                                </xsl:variable>

                                <div class="containerfeedW">
                                    <div class="headerdataW">
                                        <div class="text-rowgroup-1">
                                            <xsl:value-of select="event_date" />
                                        </div>
                                        <div class="text-rowgroup-1 rightcol-spacing">
                                            
                                            <xsl:variable name="submit_show_date">
                                                <xsl:value-of select="submit_show_date" />
                                            </xsl:variable>

                                            <xsl:variable name="confirmed">
                                                <xsl:value-of select="confirmed" />
                                            </xsl:variable>
                                            <xsl:if test="normalize-space($submit_show_date) != ''">
                                                <div class="confstatus">
                                                    <xsl:choose>
                                                        <xsl:when test="$confirmed = 'Y'">
                                                        <div>
                                                            <div>
                                                                Confirmed On
                                                            </div>
                                                            <div>
                                                                <xsl:value-of select="conf_date" />
                                                            </div>
                                                        </div>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <IMG
                                                                SRC="/ibase/webitm/images/Summary/summary_time.svg"
                                                                class="align-imgtext svgcolor" width="40" height="40">
                                                            </IMG>
                                                            <div class="addspace">
                                                                Pending Confirmation
                                                            </div>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </div>
                                            </xsl:if>
                                        </div>
                                    </div>
									   <!--<div class="company-name" >
											TAX Invoice
	                                  </div>-->		
		                          	  <div class="horizontal_dotted_line">
		                                      <div class="company-name" >
		                                          M/s Langar Bidi Company Poona
		                                      </div>
		                              </div>
		                              <div class="namespacing">
	                                      <div class="label-text" >
	                                          Supplier Name
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value">
	                                          M/s Langar Bidi Company Poona,Gwalior Depo
	                                      </div>
									</div>
									<div class="namespacing">
	                                      <div class="label-text" >
	                                          Address
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value">
	                                          A-18/399 Transport Nagar,Near Water Tank,Gwalior
	                                      </div>
	                                </div>
	                                <div class="namespacing">
	                                      <div class="label-text" >
	                                          GSTIN No
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value" >
	                                          23AAAFL5383K1Z8                                                 
	                                      </div>
	                                 </div>
	                                 <div class="namespacing">
	                                      <div class="label-text" >
	                                          State
	                                      </div>
	                                      <span class="colon">:</span>
	                                      <div class="data-value" >
	                                          23 / Madhya Pradesh                                                
	                                      </div>  
	                                 </div>
                                </div>

                            </xsl:for-each>
                            <xsl:variable name="load_no">
				<xsl:for-each select="//DARDetails//Detail1">
					<xsl:value-of select="load_no" />
				</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="vehicle_no">
				<xsl:for-each select="//DARDetails//Detail1">
					<xsl:value-of select="vehicle_no" />
				</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sales_pers_sp_name">
				<xsl:for-each select="//DARDetails//Detail1">
					<xsl:value-of select="sales_pers_sp_name" />
				</xsl:for-each>
		</xsl:variable>
                            <div class="tabsW">
                             
                                <div class="data-content">
                                    <!--Feed View Start-->
									<section id="section-n1">
                                        <xsl:variable name="listed_count">
                                            <xsl:value-of select="count(//DARDetails//doctor)" />
                                        </xsl:variable>

                                        <xsl:variable name="doc_listed_cnt">
                                            <xsl:value-of
                                                select="count(//DARDetails//doctor[customer_type='LISTED'])" />
                                        </xsl:variable>

                                        <xsl:if test="normalize-space($listed_count) > '0'">
                                            <xsl:if test="normalize-space($doc_listed_cnt) > '0'">
                                                <div id="doc_listed">
                                                    <xsl:for-each select="//DARDetails//doctor">
                                                    
                                                        <xsl:sort select="substring-after(event_time_start, ' ')" />
                                                        <xsl:sort select="substring-before(event_time_start,':') mod 12"
                                                            data-type="number" />
                                                        <xsl:sort
                                                            select="substring-before(substring-after(event_time_start,':'), ' ')"
                                                            data-type="number" />

                                                        <xsl:variable name="customer_type">
                                                            <xsl:value-of select="customer_type" />
                                                        </xsl:variable>
                                                        <xsl:if test="normalize-space($customer_type) = 'LISTED'">
                                                            <div class="containerfeedW datafontsize">

                                                                <xsl:variable name="strg_code3">
                                                                    <xsl:value-of select="strg_code" />
                                                                </xsl:variable>
                                                                <xsl:variable name="cust_name">
                                                                    <xsl:value-of select="cust_name" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr1">
                                                                    <xsl:value-of select="addr1" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr2">
                                                                    <xsl:value-of select="addr2" />
                                                                </xsl:variable>
                                                                <xsl:variable name="domID">
                                                                    <xsl:value-of select="@domID" />
                                                                </xsl:variable>
                                                                <xsl:variable name="host_url">
                                                                    <xsl:value-of select="host_url" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr3">
                                                                    <xsl:value-of select="addr3" />
                                                                </xsl:variable>
                                                                <xsl:variable name="net_amt">
                                                                    <xsl:value-of select="net_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="tax_amount">
                                                                    <xsl:value-of select="tax_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="amount">
                                                                    <xsl:value-of select="amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_start">
                                                                    <xsl:value-of select="event_time_start" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_end">
                                                                    <xsl:value-of select="event_time_end" />
                                                                </xsl:variable>
                                                                <xsl:variable name="invoice_amount">
                                                                    <xsl:value-of select="invoice_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_sgst_amt">
                                                                    <xsl:value-of select="total_sgst_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_cgst_amt">
                                                                    <xsl:value-of select="total_cgst_amt" />
                                                                </xsl:variable>
                                                                 <xsl:variable name="strg_gst_no">
                                   									<xsl:value-of select="strg_gst_no" />
                                     							 </xsl:variable>
                                     							 <xsl:variable name="strg_state">
                                        							<xsl:value-of select="strg_state" />
                                    							 </xsl:variable>
                                    							<xsl:variable name="round_off">
                                      							   <xsl:value-of select="round_off" />
                                    							</xsl:variable>
                                    							<xsl:variable name="amount_in_word">
                                      							   <xsl:value-of select="amount_in_word" />
                                    							</xsl:variable>
                                   								 <xsl:variable name="address_as">
                                      							   <xsl:value-of select="address_as" />
                                   								 </xsl:variable>
                                                                <xsl:variable name="sales_type">
                                                                    <xsl:value-of select="sales_type" />
                                                                </xsl:variable>

                                                                <xsl:variable name="coaching_details">
                                                                    <xsl:value-of select="coaching_details" />
                                                                </xsl:variable>
																<xsl:variable name="dcr_group">
                                                                <xsl:value-of select="dcr_group" />
                                                            </xsl:variable>	
                                                            	<xsl:variable name="doc_tran_id">
                                                            		<xsl:value-of select="tran_id" />
                                                            	</xsl:variable>
                                                                <xsl:call-template name="tmpOrderFeed">
                                                                    <xsl:with-param name="orderFormName"
                                                                        
                                                                        select="concat($host_url,'@','invoice','#',$cust_name,'(',$addr2,'*',$strg_code3,'!',$addr1,'^',$addr3,'+',$net_amt,'**',$tax_amount,'~',$amount,'##',$total_sgst_amt,'%',$event_time_start,'?',$event_time_end,'{',$invoice_amount,'}',$customer_type,'@@',$sales_type,'@@@',$coaching_details,'$$@','doctor','$#',$total_cgst_amt,'||',$strg_gst_no,'$%',$strg_state,'$$%',$round_off,'%%~$$',$amount_in_word,'%%',$address_as,'%%$','collection','%%%$',$load_no,'[%*',$vehicle_no,'%|]',$dcr_group,'$%%%%$','',']','%%#%%',$doc_tran_id,'%##%')" />
                                                                </xsl:call-template>
                                                            </div>
                                                        </xsl:if>
                                                    </xsl:for-each>
                                                </div>
                                            </xsl:if>
                                        </xsl:if><!-- End Doctor -->
										<xsl:variable name="listed_count_chem">
                                        	<xsl:value-of select="count(//DARDetails//retailer)" />
										</xsl:variable>
										<xsl:variable name="chem_listed_cnt">
											<xsl:value-of
												select="count(//DARDetails//retailer[customer_type='LISTED'])" />
										</xsl:variable>

                                        <xsl:if test="normalize-space($listed_count_chem) > '0'">						
                                        	<xsl:if test="normalize-space($chem_listed_cnt) > '0'">
                                                <div id="doc_listed">
                                                    <xsl:for-each select="//DARDetails//retailer">
                                                    
                                                        <xsl:sort select="substring-after(event_time_start, ' ')" />
                                                        <xsl:sort select="substring-before(event_time_start,':') mod 12"
                                                            data-type="number" />
                                                        <xsl:sort
                                                            select="substring-before(substring-after(event_time_start,':'), ' ')"
                                                            data-type="number" />

                                                        <xsl:variable name="customer_type">
                                                            <xsl:value-of select="customer_type" />
                                                        </xsl:variable>
                                                        <xsl:if test="normalize-space($customer_type) = 'LISTED'">
                                                            <div class="containerfeedW datafontsize">

                                                                <xsl:variable name="strg_code3">
                                                                    <xsl:value-of select="strg_code" />
                                                                </xsl:variable>
                                                                <xsl:variable name="cust_name">
                                                                    <xsl:value-of select="cust_name" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr1">
                                                                    <xsl:value-of select="addr1" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr2">
                                                                    <xsl:value-of select="addr2" />
                                                                </xsl:variable>
                                                                <xsl:variable name="domID">
                                                                    <xsl:value-of select="@domID" />
                                                                </xsl:variable>
                                                                <xsl:variable name="host_url">
                                                                    <xsl:value-of select="host_url" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr3">
                                                                    <xsl:value-of select="addr3" />
                                                                </xsl:variable>
                                                                <xsl:variable name="net_amt">
                                                                    <xsl:value-of select="net_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="tax_amount">
                                                                    <xsl:value-of select="tax_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="amount">
                                                                    <xsl:value-of select="amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_start">
                                                                    <xsl:value-of select="event_time_start" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_end">
                                                                    <xsl:value-of select="event_time_end" />
                                                                </xsl:variable>
                                                                <xsl:variable name="invoice_amount">
                                                                    <xsl:value-of select="invoice_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_sgst_amt">
                                                                    <xsl:value-of select="total_sgst_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_cgst_amt">
                                                                    <xsl:value-of select="total_cgst_amt" />
                                                                </xsl:variable>
                                                                 <xsl:variable name="strg_gst_no">
                                   									<xsl:value-of select="strg_gst_no" />
                                     							 </xsl:variable>
                                     							 <xsl:variable name="strg_state">
                                        							<xsl:value-of select="strg_state" />
                                    							 </xsl:variable>
                                    							<xsl:variable name="round_off">
                                      							   <xsl:value-of select="round_off" />
                                    							</xsl:variable>
                                    							<xsl:variable name="amount_in_word">
                                      							   <xsl:value-of select="amount_in_word" />
                                    							</xsl:variable>
                                   								 <xsl:variable name="address_as">
                                      							   <xsl:value-of select="address_as" />
                                   								 </xsl:variable>
                                                                <xsl:variable name="sales_type">
                                                                    <xsl:value-of select="sales_type" />
                                                                </xsl:variable>

                                                                <xsl:variable name="coaching_details">
                                                                    <xsl:value-of select="coaching_details" />
                                                                </xsl:variable>
																<xsl:variable name="dcr_group">
                                                                <xsl:value-of select="dcr_group" />
                                                            </xsl:variable>	
                                                            	<xsl:variable name="doc_tran_id">
                                                            		<xsl:value-of select="tran_id" />
                                                            	</xsl:variable>
                                                                <xsl:call-template name="tmpOrderFeed">
                                                                    <xsl:with-param name="orderFormName"
                                                                     select="concat($host_url,'@','retailerinvoice','#',$cust_name,'(',$addr2,'*',$strg_code3,'!',$addr1,'^',$addr3,'+',$net_amt,'**',$tax_amount,'~',$amount,'##',$total_sgst_amt,'%',$event_time_start,'?',$event_time_end,'{',$invoice_amount,'}',$customer_type,'@@',$sales_type,'@@@',$coaching_details,'$$@','retailer','$#',$total_cgst_amt,'||',$strg_gst_no,'$%',$strg_state,'$$%',$round_off,'%%~$$',$amount_in_word,'%%',$address_as,'%%$','retailercollection','%%%$',$load_no,'[%*',$vehicle_no,'%|]',$dcr_group,'$%%%%$','',']','%%#%%',$doc_tran_id,'%##%')" />
                                                                       
                                                                </xsl:call-template>
                                                            </div>
                                                        </xsl:if>
                                                    </xsl:for-each>
                                                </div>
                                            </xsl:if>
                                        </xsl:if><!-- End of Retailer Form -->
										<xsl:variable name="listed_count_sto">
											<xsl:value-of select="count(//DARDetails//StockData)" />
										</xsl:variable>
										<xsl:variable name="sto_listed_cnt">
											<xsl:value-of
												select="count(//DARDetails//StockData[customer_type='LISTED'])" />
										</xsl:variable>

                                        <xsl:if test="normalize-space($listed_count_sto) > '0'">						
                                        	<xsl:if test="normalize-space($sto_listed_cnt) > '0'">
                                                <div id="doc_listed">
                                                    <xsl:for-each select="//DARDetails//StockData">
                                                    
                                                        <xsl:sort select="substring-after(event_time_start, ' ')" />
                                                        <xsl:sort select="substring-before(event_time_start,':') mod 12"
                                                            data-type="number" />
                                                        <xsl:sort
                                                            select="substring-before(substring-after(event_time_start,':'), ' ')"
                                                            data-type="number" />

                                                        <xsl:variable name="customer_type">
                                                            <xsl:value-of select="customer_type" />
                                                        </xsl:variable>
                                                        <xsl:if test="normalize-space($customer_type) = 'LISTED'">
                                                            <div class="containerfeedW datafontsize">

                                                                <xsl:variable name="strg_code3">
                                                                    <xsl:value-of select="strg_code" />
                                                                </xsl:variable>
                                                                <xsl:variable name="cust_name">
                                                                    <xsl:value-of select="cust_name" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr1">
                                                                    <xsl:value-of select="addr1" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr2">
                                                                    <xsl:value-of select="addr2" />
                                                                </xsl:variable>
                                                                <xsl:variable name="domID">
                                                                    <xsl:value-of select="@domID" />
                                                                </xsl:variable>
                                                                <xsl:variable name="host_url">
                                                                    <xsl:value-of select="host_url" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr3">
                                                                    <xsl:value-of select="addr3" />
                                                                </xsl:variable>
                                                                <xsl:variable name="net_amt">
                                                                    <xsl:value-of select="net_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="tax_amount">
                                                                    <xsl:value-of select="tax_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="amount">
                                                                    <xsl:value-of select="amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_start">
                                                                    <xsl:value-of select="event_time_start" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_end">
                                                                    <xsl:value-of select="event_time_end" />
                                                                </xsl:variable>
                                                                <xsl:variable name="invoice_amount">
                                                                    <xsl:value-of select="invoice_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_sgst_amt">
                                                                    <xsl:value-of select="total_sgst_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_cgst_amt">
                                                                    <xsl:value-of select="total_cgst_amt" />
                                                                </xsl:variable>
                                                                 <xsl:variable name="strg_gst_no">
                                   									<xsl:value-of select="strg_gst_no" />
                                     							 </xsl:variable>
                                     							 <xsl:variable name="strg_state">
                                        							<xsl:value-of select="strg_state" />
                                    							 </xsl:variable>
                                    							<xsl:variable name="round_off">
                                      							   <xsl:value-of select="round_off" />
                                    							</xsl:variable>
                                    							<xsl:variable name="amount_in_word">
                                      							   <xsl:value-of select="amount_in_word" />
                                    							</xsl:variable>
                                   								 <xsl:variable name="address_as">
                                      							   <xsl:value-of select="address_as" />
                                   								 </xsl:variable>
                                                                <xsl:variable name="sales_type">
                                                                    <xsl:value-of select="sales_type" />
                                                                </xsl:variable>

                                                                <xsl:variable name="coaching_details">
                                                                    <xsl:value-of select="coaching_details" />
                                                                </xsl:variable>
																<xsl:variable name="dcr_group">
                                                                <xsl:value-of select="dcr_group" />
                                                            </xsl:variable>	
                                                            	<xsl:variable name="doc_tran_id">
                                                            		<xsl:value-of select="tran_id" />
                                                            	</xsl:variable>
                                                                <xsl:call-template name="tmpOrderFeed">
                                                                    <xsl:with-param name="orderFormName"
                                                                     select="concat($host_url,'@','Stockinvoice','#',$cust_name,'(',$addr2,'*',$strg_code3,'!',$addr1,'^',$addr3,'+',$net_amt,'**',$tax_amount,'~',$amount,'##',$total_sgst_amt,'%',$event_time_start,'?',$event_time_end,'{',$invoice_amount,'}',$customer_type,'@@',$sales_type,'@@@',$coaching_details,'$$@','stockist','$#',$total_cgst_amt,'||',$strg_gst_no,'$%',$strg_state,'$$%',$round_off,'%%~$$',$amount_in_word,'%%',$address_as,'%%$','Stockcollection','%%%$',$load_no,'[%*',$vehicle_no,'%|]',$dcr_group,'$%%%%$','',']','%%#%%',$doc_tran_id,'%##%')" />
                                                                       
                                                                </xsl:call-template>
                                                            </div>
                                                        </xsl:if>
                                                    </xsl:for-each>
                                                </div>
                                            </xsl:if>
                                        </xsl:if><!-- End of Stockist Form -->
                                         <xsl:variable name="ncw_listed_count">
                                            <xsl:value-of select="count(//DARDetails//NCWData)" />
                                        </xsl:variable>

                                        <xsl:variable name="doc_ncw_listed_cnt">
                                            <xsl:value-of
                                                select="count(//DARDetails//NCWData[customer_type='LISTED'])" />
                                        </xsl:variable>

                                        <xsl:if test="normalize-space($ncw_listed_count) > '0'">
                                            <xsl:if test="normalize-space($doc_ncw_listed_cnt) > '0'">
                                                <div id="doc_listed">
                                                    <xsl:for-each select="//DARDetails//NCWData">
                                                    
                                                        <xsl:sort select="substring-after(event_time_start, ' ')" />
                                                        <xsl:sort select="substring-before(event_time_start,':') mod 12"
                                                            data-type="number" />
                                                        <xsl:sort
                                                            select="substring-before(substring-after(event_time_start,':'), ' ')"
                                                            data-type="number" />

                                                        <xsl:variable name="customer_type">
                                                            <xsl:value-of select="customer_type" />
                                                        </xsl:variable>
                                                        <xsl:if test="normalize-space($customer_type) = 'LISTED'">
                                                            <div class="containerfeedW datafontsize">

                                                                <xsl:variable name="strg_code3">
                                                                    <xsl:value-of select="strg_code" />
                                                                </xsl:variable>
                                                                <xsl:variable name="cust_name">
                                                                    <xsl:value-of select="cust_name" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr1">
                                                                    <xsl:value-of select="addr1" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr2">
                                                                    <xsl:value-of select="addr2" />
                                                                </xsl:variable>
                                                                <xsl:variable name="domID">
                                                                    <xsl:value-of select="@domID" />
                                                                </xsl:variable>
                                                                <xsl:variable name="host_url">
                                                                    <xsl:value-of select="host_url" />
                                                                </xsl:variable>
                                                                <xsl:variable name="addr3">
                                                                    <xsl:value-of select="addr3" />
                                                                </xsl:variable>
                                                                <xsl:variable name="net_amt">
                                                                    <xsl:value-of select="net_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="tax_amount">
                                                                    <xsl:value-of select="tax_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="amount">
                                                                    <xsl:value-of select="amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_start">
                                                                    <xsl:value-of select="event_time_start" />
                                                                </xsl:variable>
                                                                <xsl:variable name="event_time_end">
                                                                    <xsl:value-of select="event_time_end" />
                                                                </xsl:variable>
                                                                <xsl:variable name="invoice_amount">
                                                                    <xsl:value-of select="invoice_amount" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_sgst_amt">
                                                                    <xsl:value-of select="total_sgst_amt" />
                                                                </xsl:variable>
                                                                <xsl:variable name="total_cgst_amt">
                                                                    <xsl:value-of select="total_cgst_amt" />
                                                                </xsl:variable>
                                                                 <xsl:variable name="strg_gst_no">
                                   									<xsl:value-of select="strg_gst_no" />
                                     							 </xsl:variable>
                                     							 <xsl:variable name="strg_state">
                                        							<xsl:value-of select="strg_state" />
                                    							 </xsl:variable>
                                    							<xsl:variable name="round_off">
                                      							   <xsl:value-of select="round_off" />
                                    							</xsl:variable>
                                    							<xsl:variable name="amount_in_word">
                                      							   <xsl:value-of select="amount_in_word" />
                                    							</xsl:variable>
                                   								 <xsl:variable name="address_as">
                                      							   <xsl:value-of select="address_as" />
                                   								 </xsl:variable>
                                                                <xsl:variable name="sales_type">
                                                                    <xsl:value-of select="sales_type" />
                                                                </xsl:variable>

                                                                <xsl:variable name="coaching_details">
                                                                    <xsl:value-of select="coaching_details" />
                                                                </xsl:variable>
																<xsl:variable name="dcr_group">
                                                                <xsl:value-of select="dcr_group" />
                                                            </xsl:variable>	
                                                            	<xsl:variable name="doc_tran_id">
                                                            		<xsl:value-of select="tran_id" />
                                                            	</xsl:variable>
                                                                <xsl:call-template name="tmpOrderFeed">
                                                                    <xsl:with-param name="orderFormName"
                                                                     select="concat($host_url,'@','Ncwinvoice','#',$cust_name,'(',$addr2,'*',$strg_code3,'!',$addr1,'^',$addr3,'+',$net_amt,'**',$tax_amount,'~',$amount,'##',$total_sgst_amt,'%',$event_time_start,'?',$event_time_end,'{',$invoice_amount,'}',$customer_type,'@@',$sales_type,'@@@',$coaching_details,'$$@','NCWData','$#',$total_cgst_amt,'||',$strg_gst_no,'$%',$strg_state,'$$%',$round_off,'%%~$$',$amount_in_word,'%%',$address_as,'%%$','Ncwcollection','%%%$',$load_no,'[%*',$vehicle_no,'%|]',$dcr_group,'$%%%%$','',']','%%#%%',$doc_tran_id,'%##%')" />
                                                                       
                                                                </xsl:call-template>
                                                            </div>
                                                        </xsl:if>
                                                    </xsl:for-each>
                                                </div>
                                            </xsl:if>
                                        </xsl:if><!-- End of NCW Form -->


                                    </section>
                                    <!--Feed View Ends-->
                                </div>
                                <div class="containerfeedW">
                                <div class="namespacing">
					                               <div class="label-text">
					                                   Transport Mode
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   Vehicle
					                               </div>
					                        </div>
					                        <div class="namespacing">
					                               <div class="label-text">
					                                   Load No
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$load_no" />
					                               
					                               </div>
					                        </div>
					                         <div class="namespacing">
					                               <div class="label-text">
					                                   Vehicle No
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$vehicle_no" />
					                              
					                               </div>
					                           </div>
					                           <div class="namespacing">
					                               <div class="label-text">
					                                   Prepared By
					                               </div>
					                               <span class="colon">:</span>
					                               <div class="data-value">
					                                   <xsl:value-of select="$sales_pers_sp_name" />
					                              
					                               </div>
					                           </div>
				                           </div>
                            </div>


                        </div>

                        <div id="actionDiv" class="fixedcontainerDiv">
                            <xsl:variable name="callReport">
                                <xsl:value-of select="//HeaderData/callReport" />
                            </xsl:variable>
                            <xsl:variable name="isConfirmReq">
                                <xsl:value-of select="//HeaderData/isConfirmReq" />
                            </xsl:variable>
                            <xsl:variable name="isDeleteReq">
                                <xsl:value-of select="//HeaderData/isDeleteReq" />
                            </xsl:variable>
                            <xsl:variable name="isConfirmEnable">
                                <xsl:value-of select="//cofirmEnable" />
                            </xsl:variable>
                            <xsl:variable name="missed_data">
                                <xsl:value-of select="//HeaderData/missed_data" />
                            </xsl:variable>
                            <xsl:variable name="report_id">
                                <xsl:value-of select="//HeaderData/report_id" />
                            </xsl:variable>
                            <xsl:variable name="device_type">
                                <xsl:value-of select="//HeaderData/device_type" />
                            </xsl:variable>
                            <xsl:variable name="old_data">
                                <xsl:value-of select="//HeaderData/old_data" />
                            </xsl:variable>
                            <xsl:variable name="is_fortune_act_data">
                                <xsl:value-of select="//HeaderData/is_fortune_act" />
                            </xsl:variable>

                            <xsl:if test="normalize-space($old_data)= 'true'">
                                    
                                <xsl:choose>
                                    <xsl:when test="$report_id ='ANALYSIS_REPORT' or $device_type= 'Mobile'">
                                      <xsl:choose>
                                           <xsl:when test="$is_fortune_act_data = 'Y'">
                                         <div class="fixedcontainer" id="actionDiv">
                                            <div class="cancelbutton">
                                                <button type="button" height="50" width="50" class="rmborder" onclick="goBackToPriviousPageMultiple();">
                                                    <div class="btnpadding">
                                                        <div class="btniconborder bluebg-icon">
                                                            <IMG
                                                                src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                width ="30" height="30" class="bradius">
                                                            </IMG>
                                                        </div> 
                                                    </div> Cancel
                                                </button>
                                            </div>
                                        </div>  
                                          </xsl:when>
                                          <xsl:otherwise>
                                           <div class="fixedcontainer" id="actionDiv">
                                            <div class="cancelbutton">
                                                <button type="button" height="50" width="50" class="rmborder" onclick="goBackToPriviousPage();">
                                                    <div class="btnpadding">
                                                        <div class="btniconborder bluebg-icon">
                                                            <IMG
                                                                src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                width ="30" height="30" class="bradius">
                                                            </IMG>
                                                        </div> 
                                                    </div> Cancel
                                                </button>
                                            </div>
                                        </div>
                                          </xsl:otherwise>
                                          </xsl:choose>

                                    </xsl:when>
                                    <xsl:otherwise>

                                        <div class="fixedcontainer" id="actionDiv">
                                            <div class="cancelbutton">
                                                <button type="button" height="50" width="50" class="rmborder" onclick="window.close();">
                                                    <div class="btnpadding">
                                                        <div class="btniconborder bluebg-icon">
                                                            <IMG
                                                                    src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                    width ="30" height="30" class="bradius">
                                                            </IMG>
                                                        </div> 
                                                    </div> Cancel
                                                </button>
                                            </div>
                                        </div>
                                    </xsl:otherwise>
                                </xsl:choose>
                                
                            </xsl:if>
                        
                        
                            <xsl:if test="normalize-space($old_data)= 'false'">
                                <xsl:choose>
                                    <xsl:when test="$callReport='Y'">
                                        <div class="fixedcontainer" id="actionDiv">
                                            <div class="cancelbutton">
                                                <button type="button" height="50" width="50" class="rmborder" 
                                                    name="Cancel" onclick="goBackToPage('CallReportStatus.jsp','confirm');">
                                                    <div class="btnpadding">
                                                        <div class="btniconborder bluebg-icon">
                                                            <IMG
                                                                    src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                    width ="30" height="30" class="bradius">
                                                            </IMG>
                                                        </div> 
                                                    </div> Cancel
                                                </button>
                                            </div>


                                            <div class="delbutton">
                                                <button style="display:none;" type="button" height="50" width="50" class="rmborder"
                                                    value="Delete" id="Delete" name="Delete"
                                                    isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                    onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'Y',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                    <div class="btniconborder redbg-icon">
                                                        <IMG
                                                            src="/ibase/webitm/images/Summary/delete.svg" 
                                                            width ="30" height="30" class="bradius">
                                                        </IMG>
                                                    </div>Delete
                                                </button>
                                            </div>

                                            <xsl:if test="$isConfirmEnable='Yes'">

                                                <!--<div class="donebutton">
                                                    <button type="button" height="50" width="50" class="rmborder"
                                                        value="Confirm" id="Confirm" name="Confirm"
                                                        isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                        onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'Y',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                        <div class="btnpadding">
                                                            <div class="btniconborder bluebg-icon">
                                                                <IMG
                                                                    src="/ibase/webitm/images/Summary/done.svg" 
                                                                    width ="30" height="30" class="bradius">
                                                                </IMG>
                                                            </div>
                                                        </div> Confirm
                                                    </button>
                                                </div>-->
												<div class="donebutton">
                                                    <button type="button" height="50" width="50" class="rmborder"
                                                        value="Submit" id="Submit" name="Submit"
                                                        isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                        onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'Y',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                        <div class="btnpadding">
                                                            <div class="btniconborder bluebg-icon">
                                                                <IMG
                                                                    src="/ibase/webitm/images/Summary/done.svg" 
                                                                    width ="30" height="30" class="bradius">
                                                                </IMG>
                                                            </div>
                                                        </div> Submit
                                                    </button>
                                                </div>

                                            </xsl:if>

                                        </div>
                                    </xsl:when>
                                    <xsl:otherwise>
                                
                                        <xsl:variable name="conf_or_delete">
                                            <xsl:value-of select="//HeaderData/confirm_or_delete" />
                                        </xsl:variable>
                                        <xsl:variable name="isConfirmEnable">
                                            <xsl:value-of select="//cofirmEnable" />
                                        </xsl:variable>                              

                                        <xsl:if
                                            test="normalize-space($conf_or_delete)= 'view' or normalize-space($conf_or_delete)= 'C' or normalize-space($conf_or_delete)= 'D'">
                                            <xsl:choose>
                                                <xsl:when test="$conf_or_delete ='C'">

                                                    <div class="fixedcontainer" id="actionDiv">
                                                      

                                                        <div class="cancelbutton">
                                                            <button type="button" height="50" width="50" class="rmborder" 
                                                                onclick="goBackToPage('ConfirmReport.jsp','confirm');">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                                src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                                width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div> 
                                                                </div> Cancel
                                                            </button>
                                                        </div>

                                                        <!--<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Confirm" id="Confirm" name="Confirm"
                                                                isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                                        onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'N',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Confirm
                                                            </button>
                                                        </div>

                                                    </div>-->
													<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Submit" id="Submit" name="Submit"
                                                                isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                                        onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'N',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Submit
                                                            </button>
                                                        </div>

                                                    </div>

                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <div class="fixedcontainer" id="actionDiv">
                                                       
                                                        <div class="cancelbutton">
                                                            <button type="button" height="50" width="50" class="rmborder" 
                                                                name="Cancel" onclick="goBackToPage('DeleteReport.jsp','delete');">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                                src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                                width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div> 
                                                                </div> Cancel
                                                            </button>
                                                        </div>


                                                        <div class="delbutton">
                                                            <button style="display:none;" type="button" height="50" width="50" class="rmborder"
                                                                value="Delete" id="Delete" name="Delete"
                                                                isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
                                                                onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'N',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btniconborder redbg-icon">
                                                                    <IMG
                                                                        src="/ibase/webitm/images/Summary/delete.svg" 
                                                                        width ="30" height="30" class="bradius">
                                                                    </IMG>
                                                                </div>Delete
                                                            </button>
                                                        </div>
                                                    

                                                    </div>

                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:if>

                                        <xsl:if test="normalize-space($conf_or_delete)= 'SHOW_STATUS'">
                                            <xsl:choose>
                                                <xsl:when test="$report_id ='ANALYSIS_REPORT' or $device_type= 'Mobile'">
                                                    <div class="fixedcontainer" style='margin-top:-60px;' id="actionDiv">
                                                       

      <xsl:choose>
		<xsl:when test="$is_fortune_act_data = 'Y'">
			<div class="cancelbutton">
				<button type="button" height="50" width="50" class="rmborder"
					name="Cancel" onclick="goBackToPriviousPageMultiple();">
					<div class="btnpadding">
						<div class="btniconborder bluebg-icon">
							<IMG src="/ibase/webitm/images/Summary/cancel.svg" width="30"
								height="30" class="bradius">
							</IMG>
						</div>
					</div>
					Cancel
				</button>
			</div>

  <div class="delbutton">
                                                            <button style="display:none;" type="button" height="50" width="50" class="rmborder"
                                                                value="Delete" id="Delete" name="Delete"
                                                                    isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
                                                                    onclick="getValidationAlertMGR(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btniconborder redbg-icon">
                                                                    <IMG
                                                                        src="/ibase/webitm/images/Summary/delete.svg" 
                                                                        width ="30" height="30" class="bradius">
                                                                    </IMG>
                                                                </div>Delete
                                                            </button>
                                                        </div>

                                                        <!--<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Confirm" id="Confirm" name="Confirm"
                                                                isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
                                                                onclick="getValidationAlertMGR(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Confirm
                                                            </button>
                                                        </div>-->
														<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Submit" id="Submit" name="Submit"
                                                                isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
                                                                onclick="getValidationAlertMGR(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Submit
                                                            </button>
                                                        </div>
		</xsl:when>
		<xsl:otherwise>
			<div class="cancelbutton">
				<button type="button" height="50" width="50" class="rmborder"
					name="Cancel" onclick="goBackToPriviousPage();">
					<div class="btnpadding">
						<div class="btniconborder bluebg-icon">
							<IMG src="/ibase/webitm/images/Summary/cancel.svg" width="30"
								height="30" class="bradius">
							</IMG>
						</div>
					</div>
					Cancel
				</button>
			</div>

  <div class="delbutton">
                                                            <button style="display:none;" type="button" height="50" width="50" class="rmborder"
                                                                value="Delete" id="Delete" name="Delete"
                                                                    isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
                                                                    onclick="getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btniconborder redbg-icon">
                                                                    <IMG
                                                                        src="/ibase/webitm/images/Summary/delete.svg" 
                                                                        width ="30" height="30" class="bradius">
                                                                    </IMG>
                                                                </div>Delete
                                                            </button>
                                                        </div>

                                                        <!--<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Confirm" id="Confirm" name="Confirm"
                                                                isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
                                                                onclick="getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Confirm
                                                            </button>
                                                        </div>-->
														<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Submit" id="Submit" name="Submit"
                                                                isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}'
                                                                onclick="getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Submit
                                                            </button>
                                                        </div>
		</xsl:otherwise>
	</xsl:choose>

                                                    </div>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <div class="fixedcontainer" id="actionDiv">
                                                       
                                                
                                                        <div class="cancelbutton">
                                                            <button type="button" height="50" width="50" class="rmborder" 
                                                                name="Cancel" onclick="window.close();">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div> 
                                                                </div> Cancel
                                                            </button>
                                                        </div>

                                                        <div class="delbutton">
                                                            <button style="display:none;" type="button" height="50" width="50" class="rmborder"
                                                                value="Delete" id="Delete" name="Delete"
                                                                    isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                                    onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btniconborder redbg-icon">
                                                                    <IMG
                                                                        src="/ibase/webitm/images/Summary/delete.svg" 
                                                                        width ="30" height="30" class="bradius">
                                                                    </IMG>
                                                                </div>Delete
                                                            </button>
                                                        </div>

                                                        <!--<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Confirm" id="Confirm" name="Confirm"
                                                                    isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                                    onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Confirm
                                                            </button>
                                                        </div>-->
														<div class="donebutton">
                                                            <button type="button" height="50" width="50" class="rmborder"
                                                                value="Submit" id="Submit" name="Submit"
                                                                    isConfirm='{normalize-space($isConfirmReq)}' isDelete='{normalize-space($isDeleteReq)}' missedData='{normalize-space($missed_data)}' reportId='{normalize-space($report_id)}' deviceType='{normalize-space($device_type)}' 
                                                                    onclick="javascript:getValidationAlert(this.id,this.getAttribute('isConfirm'),this.getAttribute('isDelete'),'show_status',this.getAttribute('missedData'),this.getAttribute('reportId'),this.getAttribute('deviceType'))">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/done.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div>
                                                                </div> Submit
                                                            </button>
                                                        </div>

                                                    </div>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            
                                        </xsl:if>

                                        <xsl:if test="normalize-space($conf_or_delete)= 'VIEW_REPORT'">
                                            
                                            <xsl:choose>
                                                <xsl:when test="$report_id ='ANALYSIS_REPORT' or $device_type= 'Mobile'">
                                                   
                                                    <div class="fixedcontainer" id="actionDiv">
                                                        <div class="cancelbutton">
                                                            <button type="button" height="50" width="50" class="rmborder" 
                                                                name="Cancel" onclick="goBackToPriviousPage();">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div> 
                                                                </div> Cancel
                                                            </button>
                                                        </div>
                                                    </div>

                                                </xsl:when>
                                                <xsl:otherwise>
                                                    
                                                    <div class="fixedcontainer" id="actionDiv">
                                                        <div class="cancelbutton">
                                                            <button type="button" height="50" width="50" class="rmborder" onclick="window.close();">
                                                                <div class="btnpadding">
                                                                    <div class="btniconborder bluebg-icon">
                                                                        <IMG
                                                                            src="/ibase/webitm/images/Summary/cancel.svg" 
                                                                            width ="30" height="30" class="bradius">
                                                                        </IMG>
                                                                    </div> 
                                                                </div> Cancel
                                                            </button>
                                                        </div>
                                                    </div>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                            
                                        </xsl:if>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:if>
                        </div>
					</div>
                   
				</form>
			</body>
		</html>
	</xsl:template>

    <!--Changes by Jatin M on 15/03/2021 for New Summary - Feed View - Starts -->

    <xsl:template name="tmpOrderFeed">
		<xsl:param name="orderFormName" />

		<xsl:variable name="ord_value">
			<xsl:value-of select="$orderFormName" />
		</xsl:variable>
		<xsl:variable name="invoice_detail">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '@'), '#')" />
		</xsl:variable>
		<xsl:variable name="ord_host_url">
			<xsl:value-of select="substring-before($ord_value,'@')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_name">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '#'), '(')" />
		</xsl:variable>
		<xsl:variable name="doc_addr2">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '('), '*')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_code">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '*'), '!')" />
		</xsl:variable>
		<xsl:variable name="doc_addr1">
			<xsl:value-of
				select="substring-before(substring-after($ord_value, '!'), '^')" />
		</xsl:variable>
		<xsl:variable name="doc_addr3">
			<xsl:value-of select="substring-before(substring-after($ord_value,'^'),'+')" />
		</xsl:variable>
		<xsl:variable name="doc_net_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'+'),'**')" />
		</xsl:variable>
		<xsl:variable name="doc_tax_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'**'),'~')" />
		</xsl:variable>

		<xsl:variable name="doc_amount">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'~'),'##')" />
		</xsl:variable>
		<xsl:variable name="doc_total_sgst_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'##'),'%')" />
		</xsl:variable>
		<xsl:variable name="event_time_start">
			<xsl:value-of select="substring-before(substring-after($ord_value,'%'),'?')" />
		</xsl:variable>
		<xsl:variable name="event_time_end">
			<xsl:value-of select="substring-before(substring-after($ord_value,'?'),'{')" />
		</xsl:variable>
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of select="substring-before(substring-after($ord_value,'{'),'}')" />
		</xsl:variable>
		<xsl:variable name="customer_types">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'}'),'@@')" />
		</xsl:variable>
		<xsl:variable name="doc_sales_type">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@'),'@@@')" />
		</xsl:variable>
		<xsl:variable name="coaching_data">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'@@@'),'$$@')" />
		</xsl:variable>
        <xsl:variable name="current_form_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$$@'),'$#')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_cgst_amt">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$#'),'||')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_gst_no">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'||'),'$%')" />
		</xsl:variable>
		<xsl:variable name="doc_strg_state">
		    <xsl:value-of
				select="substring-before(substring-after($ord_value,'$%'),'$$%')" />
		</xsl:variable>
		<xsl:variable name="doc_round_off">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$$%'),'%%~$$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amt_in_word">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%~$$'),'%%')" />
		</xsl:variable>
		
			<xsl:variable name="doc_address_as">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%'),'%%$')" />
		</xsl:variable>
		<xsl:variable name="collect_detail">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%$'),'%%%$')" />
		</xsl:variable>
		<xsl:variable name="doc_load_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%%%$'),'[%*')" />
		</xsl:variable>
		<xsl:variable name="doc_vehicle_no">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'[%*'),'%|]')" />
		</xsl:variable>
		<xsl:variable name="dcr_group">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'%|]'),'$%%%%$')" />
		</xsl:variable> 
		<xsl:variable name="type_of_customer">
			<xsl:value-of
				select="substring-before(substring-after($ord_value,'$%%%%$'),'$%%$')" />
		</xsl:variable> 
		<xsl:variable name="event_type_descr">
			<xsl:value-of
				select="substring-after($ord_value,'$%%$')" />
		</xsl:variable> 
		<xsl:variable name="doc_tran_id">
			<xsl:value-of 
			select="substring-before(substring-after($ord_value,'%%#%%'),'%##%')"
		</xsl:variable>

		<xsl:variable name="invoice_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $invoice_detail)]">
				<xsl:variable name="invoice_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($invoice_strg_code) = normalize-space($doc_strg_code)">
					<xsl:value-of select="count(//node()[starts-with(name(), $invoice_detail)])" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="collection_listed_count">
			<xsl:for-each select="//node()[starts-with(name(), $collect_detail)]">
				<xsl:variable name="collection_strg_code">
					<xsl:value-of select="strg_code" />
				</xsl:variable>
				<xsl:if
					test="normalize-space($collection_strg_code) = normalize-space($doc_strg_code)">
					<xsl:value-of select="count(//node()[starts-with(name(), $collect_detail)])" />
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		
		<xsl:choose>
			<xsl:when
				test="$invoice_listed_count > '0' ">
                    <div>                        
                        <xsl:if
                            test="not(contains($customer_types, 'UNLISTED'))">
                            <div class="horizontal_dotted_line"> 
                                <div class="namespacing">
                                 	<div class="label-text-large">
                                    Recipient Name
                                	</div>
                                	<span class="colon">:</span>
                                <xsl:choose>
                           	 		<xsl:when test="($doc_sales_type='I') ">
	                                <div class="data-value-large">
	                                    <xsl:value-of select="$doc_strg_name" />
	                                </div>
                               		 </xsl:when>
                                	 <xsl:otherwise>
	                                	<div class="data-value-large">
	                                    Cash Sale
	                                	</div>
                                	</xsl:otherwise>
                                </xsl:choose>
                                </div>
                                <div class="namespacing">
	                                <div class="label-text">
	                                    Address
	                                </div>
	                                <span class="colon">:</span>
	                                <div class="data-value">
	                                    <xsl:value-of select="concat($doc_addr1,$doc_addr2,$doc_addr3)" />
	                                </div>
                            	</div>

	                            <div class="namespacing">
	                                <div class="label-text">
	                                    GST No
	                                </div>
	                                <span class="colon">:</span>
	                                <div class="data-value">
	                                    <xsl:value-of select="$doc_strg_gst_no" />
	                                </div>
	                            </div>
	
	                            <div class="namespacing">
	                                <div class="label-text">
	                                    State
	                                </div>
	                                <span class="colon">:</span>
	                                <div class="data-value">
	                                    <xsl:value-of select="$doc_strg_state" />
	                                </div>
	                            </div> 
                            </div>
                            <!--<div class="horizontal_dotted_line">
	                            <div class="namespacing">
		                            <div class="value-shown-tax">
			                              <div class="tax-payable" >
			                                  Tax is payabel on Reverse Charge 
			                              </div>
			                              <span class="colon-num">:</span>
			                              <div class="tax-payable-data">
			                                  No
			                              </div>
		                              </div>
		                           </div>
		                           <div class="namespacing">
		                              <div class="value-shown-tax">
			                              <div class="tax-payable" >
			                                  Partial/Full Reverse Charge
			                              </div>
			                              <span class="colon-num">:</span>
			                              <div class="tax-payable-data">
			                                  No
			                              </div>
		                              </div>
	                         	 </div>
	                          </div>-->
                        </xsl:if>
						<xsl:call-template name="tempOrderDataFeed">
                        <xsl:with-param name="orderData"
                        select="concat($invoice_detail,'@',$doc_strg_code,'#',$invoice_listed_count,'*',$customer_types,'####',$collection_listed_count,'**',$collect_detail,'##',$ord_host_url,'%%',$doc_total_sgst_amt,'%%%',$doc_total_cgst_amt,'%%**',$doc_invoice_amount,'%*%*$',$doc_amount,'#%#%$',$doc_net_amt,'*%**%',$doc_round_off,'~^',$doc_amt_in_word,'%~^',$doc_load_no,'[%*',$doc_vehicle_no,'%|]','%%##%%',$doc_tran_id,'%###%')" /> 
                            
                    </xsl:call-template>
                </div>
			</xsl:when>
			<xsl:otherwise>
                <div>
                    <xsl:if
                        test="not(contains($customer_types, 'UNLISTED'))">
                        <div class="horizontal_dotted_line"> 
                                <div class="namespacing">
                                 	<div class="label-text-large">
                                    Recipient Name
                                	</div>
                                	<span class="colon">:</span>
                                <xsl:choose>
                           	 		<xsl:when test="($doc_sales_type='I') ">
	                                <div class="data-value-large">
	                                    <xsl:value-of select="$doc_strg_name" />
	                                </div>
                               		 </xsl:when>
                                	 <xsl:otherwise>
	                                	<div class="data-value-large">
	                                    Cash Sale
	                                	</div>
                                	</xsl:otherwise>
                                </xsl:choose>
                                </div>
                                <div class="namespacing">
	                                <div class="label-text">
	                                    Address
	                                </div>
	                                <span class="colon">:</span>
	                                <div class="data-value">
	                                    <xsl:value-of select="concat($doc_addr1,$doc_addr2,$doc_addr3)" />
	                                </div>
                            	</div>

	                            <div class="namespacing">
	                                <div class="label-text">
	                                    GST No
	                                </div>
	                                <span class="colon">:</span>
	                                <div class="data-value">
	                                    <xsl:value-of select="$doc_strg_gst_no" />
	                                </div>
	                            </div>
	
	                            <div class="namespacing">
	                                <div class="label-text">
	                                    States
	                                </div>
	                                <span class="colon">:</span>
	                                <div class="data-value">
	                                    <xsl:value-of select="$doc_strg_state" />
	                                </div>
	                            </div> 
                            </div>
                            <!--<div class="horizontal_dotted_line">
	                            <div class="namespacing">
		                            <div class="value-shown-tax">
			                              <div class="tax-payable" >
			                                  Tax is payabel on Reverse Charge 
			                              </div>
			                              <span class="colon-num">:</span>
			                              <div class="tax-payable-data">
			                                  No
			                              </div>
		                              </div>
		                           </div>
		                           <div class="namespacing">
		                              <div class="value-shown-tax">
			                              <div class="tax-payable" >
			                                  Partial/Full Reverse Charge
			                              </div>
			                              <span class="colon-num">:</span>
			                              <div class="tax-payable-data">
			                                  No
			                              </div>
		                              </div>
	                         	 </div>
	                          </div>--> 
                    </xsl:if>
                </div>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	<xsl:template name="tempOrderDataFeed">
		<xsl:param name="orderData" />
		<xsl:variable name="order_data_value">
			<xsl:value-of select="$orderData" />
		</xsl:variable>

		<xsl:variable name="invoice_details">
			<xsl:value-of
				select="substring-before($order_data_value,'@')" />
		</xsl:variable>
        
		<xsl:variable name="dcotor_cust_code">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'@'),'#')" />
		</xsl:variable>
		<xsl:variable name="invoice_form_cnt">
			<xsl:value-of
				select="substring-before(substring-after($order_data_value,'#'),'*')" />
		</xsl:variable>

        <xsl:variable name="customer_types">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*'),'####')" />
		</xsl:variable>
		
		<xsl:variable name="collection_form_cnt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'####'),'**')" />
		</xsl:variable>
		
		<xsl:variable name="collection_details">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'**'),'##')" />
		</xsl:variable>
		
        <xsl:variable name="ord_data_host_url">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'##'),'%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_sgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%'),'%%%')" />
		</xsl:variable>
		
		<xsl:variable name="doc_total_cgst_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%%'),'%%**')" />
		</xsl:variable>
		
		<xsl:variable name="doc_invoice_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%%**'),'%*%*$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_amount">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%*%*$'),'#%#%$')" />
		</xsl:variable>
		
		<xsl:variable name="doc_net_amt">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'#%#%$'),'*%**%')" />
		</xsl:variable> 
		
		<xsl:variable name="doc_round_off">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'*%**%'),'~^')" />
		</xsl:variable> 
		
		<xsl:variable name="doc_amt_in_word">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'~^'),'%~^')" />
		</xsl:variable> 
		
		<xsl:variable name="doc_load_no">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'%~^'),'[%*')" />
		</xsl:variable> 
		
		<xsl:variable name="doc_vehicle_no">
			<xsl:value-of 
			    select="substring-before(substring-after($order_data_value,'[%*'),'%|]')" />
		</xsl:variable>
		<xsl:variable name="doc_tran_id">
			<xsl:value-of 
			select="substring-before(substring-after($order_data_value,'%%##%%'),'%###%')" />
		</xsl:variable> 

        <xsl:variable name="domID">
            <xsl:value-of select="@domID" />
        </xsl:variable>
		<xsl:if test="normalize-space($invoice_form_cnt) > 0 ">
			
				<xsl:for-each
					select="//node()[starts-with(name(), $invoice_details)]">
					
						<xsl:variable name="invoice_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="item_descr">
							<xsl:value-of select="item_descr" />
						</xsl:variable>
						<xsl:variable name="item_code">
                            <xsl:value-of select="item_code" />
                        </xsl:variable>
						<xsl:variable name="quantity">
							<xsl:value-of select="quantity" />
						</xsl:variable>
						<xsl:variable name="invoice_rate">
                            <xsl:value-of select="rate" />
                        </xsl:variable>
                        <xsl:variable name="invoice_remarks">
                            <xsl:value-of select="remarks_inv" />
                        </xsl:variable>
                        <xsl:variable name="invoicevalue">
							<xsl:value-of select="value" />
						</xsl:variable>
						<xsl:variable name="total_sgst_amount">
							<xsl:value-of select="total_sgst_amount" />
						</xsl:variable>
						<xsl:variable name="total_cgst_amount">
                            <xsl:value-of select="total_cgst_amount" />
                        </xsl:variable>
						<xsl:variable name="total_amount">
                            <xsl:value-of select="total_amount" />
                        </xsl:variable>
                        <xsl:variable name="hsn_number">
                            <xsl:value-of select="hsn_number" />
                        </xsl:variable>
                        <xsl:variable name="tax_amt_inv">
                            <xsl:value-of select="tax_amt_inv" />
                        </xsl:variable>
                        <xsl:variable name="invoice_tran_id">
                        	<xsl:value-of select="tran_id" />
                        </xsl:variable>
						<xsl:if
							test="normalize-space($invoice_strg_code) = normalize-space($dcotor_cust_code)">
						<xsl:if 
							test="normalize-space($invoice_tran_id) = normalize-space($doc_tran_id)">
							<div class="itemOuterDiv">
							<xsl:if test="normalize-space($quantity) > 0">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                        <div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                               <div class="label-text">
				                                   Item name
				                               </div>
				                               <span class="colon">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$item_descr" />
				                               </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Qty
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$quantity" />
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   HSN No
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$hsn_number" />
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Rate
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$invoice_rate" />
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Basic Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$invoicevalue" />
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   SGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$total_sgst_amount" />(14.00%)
				                               </div>
				                           </div>
				                       </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   CGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$total_cgst_amount" />(14.00%)
				                               </div>
				                           </div>
				                           </div>
                                    </div>
                                </xsl:if>
                                </xsl:if>
                            </div>
                           </xsl:if>
						</xsl:if>
					
				</xsl:for-each>
		</xsl:if>
		<xsl:if test="normalize-space($collection_form_cnt) > 0">

				<xsl:for-each
					select="//node()[starts-with(name(), $collection_details)]">
						<xsl:variable name="collection_strg_code">
							<xsl:value-of select="strg_code" />
						</xsl:variable>
						<xsl:variable name="doc_pay_mode">
							<xsl:value-of select="pay_mode" />
						</xsl:variable>
						<xsl:variable name="collection_tran_id">
							<xsl:value-of select="tran_id" />
						</xsl:variable>
						<xsl:if
							test="normalize-space($collection_strg_code) = normalize-space($dcotor_cust_code)">
						<xsl:if
							test="normalize-space($collection_tran_id) = normalize-space($doc_tran_id)">
							<div class="itemOuterDiv">
                                <xsl:if test="not(contains($customer_types, 'UNLISTED'))">
                                        <div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                               <div class="label-text">
				                                   Payment Mode
				                               </div>
				                               <span class="colon">:</span>
				                               <div class="data-value">
				                                   <xsl:choose>
														<xsl:when test="($doc_pay_mode='C') ">
															CASH
														</xsl:when>
														<xsl:when test="($doc_pay_mode='Q') ">
															CHEQUE
														</xsl:when>
														<xsl:when test="($doc_pay_mode='R') ">
															RTGS
														</xsl:when>
														<xsl:when test="($doc_pay_mode='N') ">
															NEFT
														</xsl:when>
														<xsl:when test="($doc_pay_mode='U') ">
															UPI
														</xsl:when>
														<xsl:when test="($doc_pay_mode='O') ">
															ONLINE
														</xsl:when>
													</xsl:choose>
				                               </div>
				                           </div>
				                           </div>
				                          <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Taxable Amt
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_net_amt" />
				                               </div>
				                           </div>
											</div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total SGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_total_sgst_amt" />
				                               </div>
				                           </div>
				                           </div>
				
				                       <div class="horizontal_dotted_line">
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text">
				                                   Total CGST
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value">
				                                   <xsl:value-of select="$doc_total_cgst_amt" />
				                               </div>
				                           </div>
				                           </div>
				                       </div>
				                       
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Total Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_amount" />
				                               </div>
				                           </div>
				                           </div>
				                       		
				                       	   <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Round-off
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_round_off" />
				                               </div>
				                           </div>
				                           </div>
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Invoice Amount
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_invoice_amount" />
				                               </div>
				                           </div>
				                           </div>
				                           <!--<div class="horizontal_dotted_line">-->
				                           <div class="namespacing">
				                           <div class="value-shown">
				                               <div class="label-text-large">
				                                   Amount in Words
				                               </div>
				                               <span class="colon-num">:</span>
				                               <div class="data-value-large">
				                                   <xsl:value-of select="$doc_amt_in_word" />
				                               </div>
				                           </div>
				                           </div>
				                           <!--</div>-->
				                       </xsl:if>
                               
                            </div>
                          </xsl:if>
						</xsl:if>
				</xsl:for-each>
		</xsl:if>

	</xsl:template>
    
</xsl:stylesheet>
