// on load
//Added by abhishek 02 nov 2017 for plugin 
function getAttchPluginView(data, mainElement)
{
	var pWindow = window.top;

	var MetadataKey        = pWindow.e12plugin.enums.MetadataKey,
		MetadataValue      = pWindow.e12plugin.metadata.MetadataValue,
		PluginMetadata     = pWindow.e12plugin.metadata.PluginMetadata,
		AttachmentsPlugin  = pWindow.e12plugin.plugins.AttachmentsPlugin,
		Layout             = pWindow.e12plugin.enums.Layout,
		Widget             = pWindow.e12plugin.gwtwidgets.Widget,
		HandlerType        = pWindow.e12plugin.enums.HandlerType,
		E12PluginUI 	   = pWindow.e12plugin.enums.E12PluginUI;
	    metadata           = new PluginMetadata();

	data.DOC_TYPE = data.DOC_TYPE || 'ICON';
	
	metadata.put(MetadataKey.OBJ_NAME, new MetadataValue(data.OBJ_NAME));
	metadata.put(MetadataKey.REF_SERIES, new MetadataValue(data.REF_SER));
	metadata.put(MetadataKey.REF_ID, new MetadataValue(data.REF_ID));
	metadata.put(MetadataKey.DOC_TYPE, new MetadataValue(data.DOC_TYPE));
	metadata.put(MetadataKey.HOST_URL, new MetadataValue(''));
	metadata.put(MetadataKey.IS_HOSTED_MODE, new MetadataValue(true));
	metadata.put(MetadataKey.ENABLE_SINGLE_IMAGE, new MetadataValue(true));

	var attPlugin = new AttachmentsPlugin();
	attPlugin.init(metadata);
	
	var outerDiv = document.createElement("div");
	outerDiv.id= "outerDiv";
	outerDiv.setAttribute("class","circleBase type"); 
	
	var smallDiv = document.createElement("div");
	smallDiv.id= "innerDiv";
	smallDiv.setAttribute("class","circleBase type1");
	smallDiv.onclick = function() {
		setImage(data, mainElement, attPlugin);
	};
	
	mainElement.appendChild(smallDiv);
	mainElement.appendChild(outerDiv);
	
	attPlugin.requestImagesInfoArray (
		function(imagesInfoArray) {
			var imagesInfo = imagesInfoArray[0];
			
			if (!imagesInfo)
				imageNotFound(mainElement);
			else 
				imageFound(attPlugin,imagesInfo, mainElement);
		},
		
		function(reason) {
			window.alert("Inside on failure [" + reason + "]");
		},
		
		E12PluginUI.EDIT
	);
	
}

function imageFound(attPlugin, imageInfo, mainElement) {

	var image = getImageElement(attPlugin, imageInfo.DOC_ID, imageInfo.FILE_TYPE, imageInfo.FILE_NAME, mainElement);
	image.setAttribute('class', 'circleBase type');
	image.id = 'outerImage';
	image.setAttribute("isImageSet", "true");
	
	var outerDiv = mainElement.querySelector('#outerDiv');
	outerDiv.innerHTML= "";
	outerDiv.appendChild(image);

	
	var smallDiv = mainElement.querySelector('#innerDiv');
	outerDiv.appendChild(smallDiv);
}

function imageNotFound(mainElement) {
	var smallDiv = mainElement.querySelector('#innerDiv');
	var outerDiv = mainElement.querySelector('#outerDiv');
	
	outerDiv.innerHTML= "";
	
	var img = document.createElement("img");
 	img.setAttribute("class","imageStyle");
 	img.id = "outerImage";
 	img.src = "/ibase/webitm/images/default.png";
	img.setAttribute("isImageSet","false");
	
	outerDiv.appendChild(img);
	outerDiv.appendChild(smallDiv);
}

function setImage(data, mainElement, attPlugin)
{
	var smallDiv = mainElement.querySelector('#outerImage');
	var isImgSet = smallDiv.getAttribute('isImageSet');
	
	if(isImgSet === 'true')
	{
		var ce = document.createEvent('Event');
		ce.initEvent('click');
		
		var image = mainElement.querySelector('#outerImage');
		image && image.dispatchEvent(ce);
	}
	else
	{
		contentPlugin(mainElement, data, attPlugin);
	}
}

function contentPlugin(mainElement ,data, attPlugin)
{
	var pWindow = window.top;

	var MetadataKey        = pWindow.e12plugin.enums.MetadataKey,
		MetadataValue      = pWindow.e12plugin.metadata.MetadataValue,
		PluginMetadata     = pWindow.e12plugin.metadata.PluginMetadata,
		ContentPlugin  	   = pWindow.e12plugin.plugins.ContentPlugin,
		Layout             = pWindow.e12plugin.enums.Layout,
		Widget             = pWindow.e12plugin.gwtwidgets.Widget,
		PopupPanel         = pWindow.e12plugin.gwtwidgets.PopupPanel,
		HandlerType        = pWindow.e12plugin.enums.HandlerType,
		E12PluginUI        = pWindow.e12plugin.enums.E12PluginUI,
	    metadata           = new PluginMetadata();

	metadata.put(MetadataKey.OBJ_NAME, new MetadataValue(data.OBJ_NAME));
	metadata.put(MetadataKey.REF_SERIES, new MetadataValue(data.REF_SER));
	metadata.put(MetadataKey.REF_ID, new MetadataValue(data.REF_ID));
	metadata.put(MetadataKey.DOC_TYPE, new MetadataValue('ICON'));
	metadata.put(MetadataKey.HOST_URL, new MetadataValue(''));
	metadata.put(MetadataKey.IS_HOSTED_MODE, new MetadataValue(true));
	
	var contentPlugin = new ContentPlugin();
	contentPlugin.init(metadata);
	
	contentPlugin.addHandler(function(data) {
		
		var imageUrl = data['FILE_URL'];
		var img = mainElement.querySelector('#outerImage');
		img && img.remove();
		
		var outerDiv = mainElement.querySelector('#outerDiv');

		img = getImageElement(attPlugin,data.DOC_ID, data.FILE_TYPE, data.FILE_NAME, mainElement);

		img.id = "outerImage";
		img.setAttribute("class","imageStyle");
		img.setAttribute('isImageSet', 'true');
		
		outerDiv.appendChild(img);
		
	}, HandlerType.DONE_HANDLER);
	
	var contentUI = contentPlugin.getAddUI();
	
	var popupPanel = new PopupPanel(contentUI);
	popupPanel.center();
}

function getImageElement(attPlugin,docId, fileType, fileName, mainElement) {
	var img = attPlugin.createImageElement (
		docId, fileType, fileName, window.top.e12plugin.enums.E12PluginUI.EDIT,
		function(data) {
			onSuccess(attPlugin,data, mainElement);
		},
		
		onFailure
	);
	
	return img;
}

function onSuccess(attPlugin ,data, mainElement) {
	var action = data['ACTION'];
	var img = mainElement.querySelector('#outerImage');
	img && img.remove();

	if (action === 'DELETE') {
		// set default image
		var img = document.createElement("img");
		img.setAttribute("class","imageStyle");
	 	img.id = "outerImage";
	 	img.src = "/ibase/webitm/images/default.png";
	 	
		img.setAttribute("isImageSet","false");
		
		
		var outerDiv = mainElement.querySelector('#outerDiv');
		outerDiv.appendChild(img);
		
		
	} else if (action === 'REPLACE') {
		img = getImageElement(attPlugin , data['DOC_ID'], data['FILE_TYPE'], data['FILE_NAME'], mainElement);
		img.setAttribute('class', 'circleBase type');
		img.id = 'outerImage';
		img.setAttribute("isImageSet", "true");
		
		var outerDiv = mainElement.querySelector('#outerDiv');
		outerDiv.appendChild(img);
		// add image in view
		
	}
	
}

function onFailure(reason) {
	window.alert(reason);
}
